/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.webbitserver.HttpControl;
import org.webbitserver.HttpRequest;
import org.webbitserver.HttpResponse;
import org.webbitserver.handler.AbstractResourceHandler;
import org.webbitserver.handler.FileEntry;
import org.webbitserver.handler.StaticFile;
import org.webbitserver.handler.TemplateEngine;
import org.webbitserver.helpers.ClassloaderResourceHelper;

public class StaticFileHandler
extends AbstractResourceHandler {
    private final File dir;

    public StaticFileHandler(File dir2, Executor ioThread, TemplateEngine templateEngine) {
        super(ioThread, templateEngine);
        this.dir = dir2;
    }

    public StaticFileHandler(File dir2, Executor ioThread) {
        this(dir2, ioThread, (TemplateEngine)new StaticFile());
    }

    public StaticFileHandler(String dir2, Executor ioThread, TemplateEngine templateEngine) {
        this(new File(dir2), ioThread, templateEngine);
    }

    public StaticFileHandler(String dir2, Executor ioThread) {
        this(dir2, ioThread, (TemplateEngine)new StaticFile());
    }

    public StaticFileHandler(File dir2, TemplateEngine templateEngine) {
        this(dir2, (Executor)Executors.newFixedThreadPool(4), templateEngine);
    }

    public StaticFileHandler(File dir2) {
        this(dir2, (TemplateEngine)new StaticFile());
    }

    public StaticFileHandler(String dir2, TemplateEngine templateEngine) {
        this(new File(dir2), templateEngine);
    }

    public StaticFileHandler(String dir2) {
        this(new File(dir2));
    }

    @Override
    protected FileWorker createIOWorker(HttpRequest request, HttpResponse response, HttpControl control) {
        return new FileWorker(request, response, control);
    }

    protected class FileWorker
    extends AbstractResourceHandler.IOWorker {
        private File file;

        protected FileWorker(HttpRequest request, HttpResponse response, HttpControl control) {
            super(request.uri(), request, response, control);
        }

        @Override
        protected boolean exists() throws IOException {
            this.file = this.resolveFile(this.path);
            return this.file != null && this.file.exists();
        }

        @Override
        protected boolean isDirectory() throws IOException {
            return this.file.isDirectory();
        }

        @Override
        protected byte[] fileBytes() throws IOException {
            return this.file.isFile() ? this.read(this.file) : null;
        }

        @Override
        protected byte[] welcomeBytes() throws IOException {
            File welcome = new File(this.file, StaticFileHandler.this.welcomeFileName);
            return welcome.isFile() ? this.read(welcome) : null;
        }

        @Override
        protected byte[] directoryListingBytes() throws IOException {
            if (!this.isDirectory()) {
                return null;
            }
            Iterable<FileEntry> files = ClassloaderResourceHelper.fileEntriesFor(this.file.listFiles());
            return StaticFileHandler.this.directoryListingFormatter.formatFileListAsHtml(files);
        }

        private byte[] read(File file) throws IOException {
            return this.read((int)file.length(), new FileInputStream(file));
        }

        protected File resolveFile(String path) throws IOException {
            File result = new File(StaticFileHandler.this.dir, path).getCanonicalFile();
            String fullPath = result.getPath();
            if (!fullPath.startsWith(StaticFileHandler.this.dir.getCanonicalPath() + File.separator) && !fullPath.equals(StaticFileHandler.this.dir.getCanonicalPath())) {
                return null;
            }
            return result;
        }
    }
}

