/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.htmlrunner;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class HTMLSuiteResult {
    private final String updatedSuite;
    private final List<String> hrefs;

    public HTMLSuiteResult(String originalSuite) {
        StringReader s = new StringReader(originalSuite);
        HTMLEditorKit k = new HTMLEditorKit();
        HTMLDocument doc = (HTMLDocument)k.createDefaultDocument();
        HTMLEditorKit.Parser parser = doc.getParser();
        HrefConverter p = new HrefConverter(originalSuite);
        doc.setAsynchronousLoadPriority(-1);
        try {
            parser.parse(s, p, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.hrefs = p.hrefList;
        StringBuilder sb = new StringBuilder();
        int previousPosition = originalSuite.length();
        int i = p.tagPositions.size() - 1;
        while (i >= 0) {
            int pos = p.tagPositions.get(i);
            String href = p.hrefList.get(i);
            System.out.println(href);
            String snippet = originalSuite.substring(pos, previousPosition).replace('\\', '/');
            System.out.println(snippet);
            String replaceSnippet = snippet.replaceFirst("\\Q" + href + "\\E", "#testresult" + i);
            sb.insert(0, replaceSnippet);
            previousPosition = pos;
            --i;
        }
        String snippet = originalSuite.substring(0, previousPosition);
        sb.insert(0, snippet);
        this.updatedSuite = sb.toString();
    }

    public List<String> getHrefs() {
        return this.hrefs;
    }

    public String getHref(int i) {
        if (i >= this.hrefs.size()) {
            return "";
        }
        return this.hrefs.get(i);
    }

    public String getUpdatedSuite() {
        return this.updatedSuite;
    }

    private class HrefConverter
    extends HTMLEditorKit.ParserCallback {
        String foo;
        public List<String> hrefList = new ArrayList<String>();
        public List<Integer> tagPositions = new ArrayList<Integer>();

        public HrefConverter(String foo) {
            this.foo = foo;
        }

        @Override
        public void handleStartTag(HTML.Tag tag, MutableAttributeSet attributes, int pos) {
            if (HTML.Tag.A.equals(tag)) {
                String href = (String)attributes.getAttribute(HTML.Attribute.HREF);
                this.hrefList.add(href.replace('\\', '/'));
                this.tagPositions.add(pos);
            }
        }
    }
}

