/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.awt.Robot;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Get;
import org.apache.tools.ant.util.FileUtils;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpFields;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.handler.ResourceHandler;
import org.mortbay.log.LogFactory;
import org.openqa.selenium.server.BrowserConfigurationOptions;
import org.openqa.selenium.server.BrowserResponseSequencer;
import org.openqa.selenium.server.BrowserSessionFactory;
import org.openqa.selenium.server.CommandQueue;
import org.openqa.selenium.server.FrameAddress;
import org.openqa.selenium.server.FrameGroupCommandQueueSet;
import org.openqa.selenium.server.InjectionHelper;
import org.openqa.selenium.server.RemoteCommand;
import org.openqa.selenium.server.RemoteCommandException;
import org.openqa.selenium.server.RobotRetriever;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.StaticContentHandler;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncherFactory;
import org.openqa.selenium.server.commands.CaptureEntirePageScreenshotToStringCommand;
import org.openqa.selenium.server.commands.CaptureScreenshotCommand;
import org.openqa.selenium.server.commands.CaptureScreenshotToStringCommand;
import org.openqa.selenium.server.commands.RetrieveLastRemoteControlLogsCommand;
import org.openqa.selenium.server.commands.SeleniumCoreCommand;
import org.openqa.selenium.server.htmlrunner.HTMLLauncher;
import org.openqa.selenium.server.log.AntJettyLoggerBuildListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeleniumDriverResourceHandler
extends ResourceHandler {
    static final Log LOGGER = LogFactory.getLog(SeleniumDriverResourceHandler.class);
    static Log browserSideLog = LogFactory.getLog(SeleniumDriverResourceHandler.class.getName() + ".browserSideLog");
    private SeleniumServer remoteControl;
    private static String lastSessionId = null;
    private Map<String, String> domainsBySessionId = new HashMap<String, String>();
    private StringBuffer logMessagesBuffer = new StringBuffer();
    private BrowserLauncherFactory browserLauncherFactory = new BrowserLauncherFactory();
    private final BrowserSessionFactory browserSessionFactory = new BrowserSessionFactory(this.browserLauncherFactory);

    public SeleniumDriverResourceHandler(SeleniumServer remoteControl) {
        this.remoteControl = remoteControl;
    }

    private String getParam(HttpRequest req, String name) {
        List parameterValues = req.getParameterValues(name);
        if (parameterValues == null) {
            return null;
        }
        return (String)parameterValues.get(0);
    }

    @Override
    public void handle(String pathInContext, String pathParams, HttpRequest req, HttpResponse res) throws HttpException, IOException {
        try {
            LOGGER.debug("Thread name: " + Thread.currentThread().getName());
            res.setField("Content-Type", "text/plain");
            this.setNoCacheHeaders(res);
            String method = req.getMethod();
            String cmd = this.getParam(req, "cmd");
            String sessionId = this.getParam(req, "sessionId");
            String seleniumStart = this.getParam(req, "seleniumStart");
            String loggingParam = this.getParam(req, "logging");
            String jsStateParam = this.getParam(req, "state");
            String retry = this.getParam(req, "retry");
            String closingParam = this.getParam(req, "closing");
            boolean logging = "true".equals(loggingParam);
            boolean jsState = "true".equals(jsStateParam);
            boolean justLoaded = "true".equals(seleniumStart);
            boolean retrying = "true".equals(retry);
            boolean closing = "true".equals(closingParam);
            LOGGER.debug("req: " + req);
            if (cmd != null) {
                this.handleCommandRequest(req, res, cmd, sessionId);
            } else if ("POST".equalsIgnoreCase(method) || justLoaded || logging) {
                this.handleBrowserResponse(req, res, sessionId, logging, jsState, justLoaded, retrying, closing);
            } else if (-1 == req.getRequestURL().indexOf("selenium-server/core/scripts/user-extensions.js") && -1 == req.getRequestURL().indexOf("selenium-server/tests/html/tw.jpg")) {
                LOGGER.debug("Not handling: " + req.getRequestURL() + "?" + req.getQuery());
                req.setHandled(false);
            }
        }
        catch (RuntimeException e) {
            String apparentFile;
            if (this.looksLikeBrowserLaunchFailedBecauseFileNotFound(e) && (apparentFile = this.extractNameOfFileThatCouldntBeFound(e)) != null) {
                LOGGER.error("Could not start browser; it appears that " + apparentFile + " is missing or inaccessible");
            }
            throw e;
        }
    }

    private void handleBrowserResponse(HttpRequest req, HttpResponse res, String sessionId, boolean logging, boolean jsState, boolean justLoaded, boolean retrying, boolean closing) throws IOException {
        List jsWindowNameVar;
        RemoteCommand sc;
        String seleniumWindowName = this.getParam(req, "seleniumWindowName");
        String localFrameAddress = this.getParam(req, "localFrameAddress");
        FrameAddress frameAddress = FrameGroupCommandQueueSet.makeFrameAddress(seleniumWindowName, localFrameAddress);
        String uniqueId = this.getParam(req, "uniqueId");
        String sequenceNumberString = this.getParam(req, "sequenceNumber");
        int sequenceNumber = -1;
        FrameGroupCommandQueueSet queueSet = FrameGroupCommandQueueSet.getQueueSet(sessionId);
        BrowserResponseSequencer browserResponseSequencer = queueSet.getCommandQueue(uniqueId).getBrowserResponseSequencer();
        if (sequenceNumberString != null && sequenceNumberString.length() > 0) {
            sequenceNumber = Integer.parseInt(sequenceNumberString);
            browserResponseSequencer.waitUntilNumIsAtLeast(sequenceNumber);
        }
        String postedData = this.readPostedData(req, sessionId, uniqueId);
        if (logging) {
            this.handleLogMessages(postedData);
        } else if (jsState) {
            this.handleJsState(sessionId, uniqueId, postedData);
        }
        if (postedData == null || postedData.equals("") || logging || jsState) {
            if (sequenceNumber != -1) {
                browserResponseSequencer.increaseNum();
            }
            res.getOutputStream().write("\r\n\r\n".getBytes());
            req.setHandled(true);
            return;
        }
        this.logPostedData(frameAddress, justLoaded, sessionId, postedData, uniqueId);
        if (retrying) {
            postedData = null;
        }
        if ((sc = queueSet.handleCommandResult(postedData, frameAddress, uniqueId, justLoaded, jsWindowNameVar = req.getParameterValues("jsWindowNameVar"))) != null) {
            this.respond(res, sc, uniqueId);
        }
        req.setHandled(true);
    }

    private void logPostedData(FrameAddress frameAddress, boolean justLoaded, String sessionId, String postedData, String uniqueId) {
        StringBuffer sb = new StringBuffer();
        sb.append("Browser " + sessionId + "/" + frameAddress + " " + uniqueId + " posted " + postedData);
        if (!frameAddress.isDefault()) {
            sb.append(" from " + frameAddress);
        }
        if (justLoaded) {
            sb.append(" NEW");
        }
        LOGGER.debug(sb.toString());
    }

    private void respond(HttpResponse res, RemoteCommand sc, String uniqueId) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream(1000);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buf, "UTF-8");
        if (sc != null) {
            writer.write(sc.toString());
            LOGGER.debug("res to " + uniqueId + ": " + sc.toString());
        } else {
            LOGGER.debug("res empty");
        }
        int pad = 998 - buf.size();
        while (pad-- > 0) {
            writer.write(" ");
        }
        writer.write("\r\n");
        ((Writer)writer).close();
        OutputStream out = res.getOutputStream();
        buf.writeTo(out);
    }

    private String readPostedData(HttpRequest req, String sessionId, String uniqueId) throws IOException {
        int c;
        if (req.getParameter("postedData") != null) {
            return req.getParameter("postedData");
        }
        InputStream is = req.getInputStream();
        StringBuffer sb = new StringBuffer();
        InputStreamReader r = new InputStreamReader(is, "UTF-8");
        while ((c = r.read()) != -1) {
            sb.append((char)c);
        }
        String postedData = sb.toString();
        if (postedData.startsWith("postedData=")) {
            postedData = postedData.substring(11);
            postedData = URLDecoder.decode(postedData, "UTF-8");
        }
        return postedData;
    }

    private void handleLogMessages(String s) {
        String[] lines;
        for (String line : lines = s.split("\n")) {
            if (!line.startsWith("logLevel=")) continue;
            int logLevelIdx = line.indexOf(58, "logLevel=".length());
            String logLevel = line.substring("logLevel=".length(), logLevelIdx).toUpperCase();
            String logMessage = line.substring(logLevelIdx + 1);
            if ("ERROR".equals(logLevel)) {
                browserSideLog.error(logMessage);
                continue;
            }
            if ("WARN".equals(logLevel)) {
                browserSideLog.warn(logMessage);
                continue;
            }
            if ("INFO".equals(logLevel)) {
                browserSideLog.info(logMessage);
                continue;
            }
            browserSideLog.debug(logMessage);
        }
    }

    private void handleJsState(String sessionId, String uniqueId, String s) {
        String jsInitializers = this.grepStringsStartingWith("state:", s);
        if (jsInitializers == null) {
            return;
        }
        for (String jsInitializer : jsInitializers.split("\n")) {
            String jsVarName = this.extractVarName(jsInitializer);
            InjectionHelper.saveJsStateInitializer(sessionId, uniqueId, jsVarName, jsInitializer);
        }
    }

    private String extractVarName(String jsInitializer) {
        int x = jsInitializer.indexOf(61);
        if (x == -1) {
            x = jsInitializer.lastIndexOf(40);
            if (x == -1) {
                throw new RuntimeException("expected method call, saw " + jsInitializer);
            }
            if ((x = jsInitializer.lastIndexOf(46, x - 1)) == -1) {
                throw new RuntimeException("expected method call, saw " + jsInitializer);
            }
        }
        return jsInitializer.substring(0, x);
    }

    private String grepStringsStartingWith(String pattern, String s) {
        String[] lines = s.split("\n");
        StringBuffer sb = new StringBuffer();
        String retval = null;
        for (String line : lines) {
            if (!line.startsWith(pattern)) continue;
            sb.append(line.substring(pattern.length())).append('\n');
        }
        if (sb.length() != 0) {
            retval = sb.toString();
        }
        return retval;
    }

    private String extractNameOfFileThatCouldntBeFound(Exception e) {
        String s = e.getMessage();
        if (s == null) {
            return null;
        }
        return s.replaceFirst(".*CreateProcess: ", "").replaceFirst(" .*", "");
    }

    private boolean looksLikeBrowserLaunchFailedBecauseFileNotFound(Exception e) {
        String s = e.getMessage();
        return s != null && s.matches("java.io.IOException: CreateProcess: .*error=3");
    }

    private void handleCommandRequest(HttpRequest req, HttpResponse res, String cmd, String sessionId) {
        res.setContentType("text/plain");
        this.hackRemoveConnectionCloseHeader(res);
        Vector<String> values = this.parseSeleneseParameters(req);
        String results = this.doCommand(cmd, values, sessionId, res);
        if (results != null) {
            try {
                res.getOutputStream().write(results.getBytes("UTF-8"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        req.setHandled(true);
    }

    public String doCommand(String cmd, Vector<String> values, String sessionId, HttpResponse res) {
        LOGGER.info("Command request: " + cmd + values.toString() + " on session " + sessionId);
        String results = null;
        if ("getNewBrowserSession".equals(cmd)) {
            String browserString = values.get(0);
            String extensionJs = values.size() > 2 ? values.get(2) : "";
            String browserConfigurations = values.size() > 3 ? values.get(3) : "";
            try {
                sessionId = this.getNewBrowserSession(browserString, values.get(1), extensionJs, new BrowserConfigurationOptions(browserConfigurations));
                this.setDomain(sessionId, values.get(1));
                results = "OK," + sessionId;
            }
            catch (RemoteCommandException rce) {
                results = "Failed to start new browser session: " + rce.getMessage();
            }
        } else if ("testComplete".equals(cmd)) {
            this.browserSessionFactory.endBrowserSession(sessionId, this.remoteControl.getConfiguration());
            results = "OK";
        } else if ("shutDown".equals(cmd) || "shutDownSeleniumServer".equals(cmd)) {
            results = null;
            this.shutDown(res);
        } else if ("getLogMessages".equals(cmd)) {
            results = "OK," + this.logMessagesBuffer.toString();
            this.logMessagesBuffer.setLength(0);
        } else if ("retrieveLastRemoteControlLogs".equals(cmd)) {
            results = new RetrieveLastRemoteControlLogsCommand().execute();
        } else if ("captureEntirePageScreenshotToString".equals(cmd)) {
            results = new CaptureEntirePageScreenshotToStringCommand(values.get(0), sessionId).execute();
        } else if ("attachFile".equals(cmd)) {
            FrameGroupCommandQueueSet queue = FrameGroupCommandQueueSet.getQueueSet(sessionId);
            try {
                File downloadedFile = this.downloadFile(values.get(1));
                queue.addTemporaryFile(downloadedFile);
                results = queue.doCommand("type", values.get(0), downloadedFile.getAbsolutePath());
            }
            catch (Exception e) {
                results = e.toString();
            }
        } else if ("captureScreenshot".equals(cmd)) {
            results = new CaptureScreenshotCommand(values.get(0)).execute();
        } else if ("captureScreenshotToString".equals(cmd)) {
            results = new CaptureScreenshotToStringCommand().execute();
        } else if ("keyDownNative".equals(cmd)) {
            try {
                RobotRetriever.getRobot().keyPress(Integer.parseInt(values.get(0)));
                results = "OK";
            }
            catch (Exception e) {
                LOGGER.error("Problem during keyDown: ", e);
                results = "ERROR: Problem during keyDown: " + e.getMessage();
            }
        } else if ("keyUpNative".equals(cmd)) {
            try {
                RobotRetriever.getRobot().keyRelease(Integer.parseInt(values.get(0)));
                results = "OK";
            }
            catch (Exception e) {
                LOGGER.error("Problem during keyUp: ", e);
                results = "ERROR: Problem during keyUp: " + e.getMessage();
            }
        } else if ("keyPressNative".equals(cmd)) {
            try {
                Robot r = RobotRetriever.getRobot();
                int keycode = Integer.parseInt(values.get(0));
                r.keyPress(keycode);
                r.waitForIdle();
                r.keyRelease(keycode);
                results = "OK";
            }
            catch (Exception e) {
                LOGGER.error("Problem during keyDown: ", e);
                results = "ERROR: Problem during keyDown: " + e.getMessage();
            }
        } else if ("isPostSupported".equals(cmd)) {
            results = "OK,true";
        } else if ("setSpeed".equals(cmd)) {
            try {
                int speed = Integer.parseInt(values.get(0));
                SeleniumDriverResourceHandler.setSpeedForSession(sessionId, speed);
            }
            catch (NumberFormatException e) {
                return "ERROR: setSlowMode expects a string containing an integer, but saw '" + values.get(0) + "'";
            }
            results = "OK";
        } else if ("getSpeed".equals(cmd)) {
            results = SeleniumDriverResourceHandler.getSpeedForSession(sessionId);
        } else if ("addStaticContent".equals(cmd)) {
            File dir = new File(values.get(0));
            if (dir.exists()) {
                this.remoteControl.addNewStaticContent(dir);
                results = "OK";
            } else {
                results = "ERROR: dir does not exist - " + dir.getAbsolutePath();
            }
        } else if ("runHTMLSuite".equals(cmd)) {
            HTMLLauncher launcher = new HTMLLauncher(this.remoteControl);
            File output = null;
            if (values.size() < 4) {
                results = "ERROR: Not enough arguments (browser, browserURL, suiteURL, multiWindow, [outputFile])";
            } else {
                if (values.size() > 4) {
                    output = new File(values.get(4));
                }
                try {
                    results = launcher.runHTMLSuite(values.get(0), values.get(1), values.get(2), output, this.remoteControl.getConfiguration().getTimeoutInSeconds(), "true".equals(values.get(3)));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    results = e.toString();
                }
            }
        } else if ("launchOnly".equals(cmd)) {
            if (values.size() < 1) {
                results = "ERROR: You must specify a browser";
            } else {
                String browser = values.get(0);
                String newSessionId = this.generateNewSessionId();
                BrowserLauncher simpleLauncher = this.browserLauncherFactory.getBrowserLauncher(browser, newSessionId, this.remoteControl.getConfiguration());
                String baseUrl = "http://localhost:" + this.remoteControl.getPort();
                this.remoteControl.registerBrowserSession(new BrowserSessionFactory.BrowserSessionInfo(newSessionId, browser, baseUrl, simpleLauncher, null));
                simpleLauncher.launchHTMLSuite("TestPrompt.html?thisIsSeleniumServer=true", baseUrl, false, "info");
                results = "OK";
            }
        } else if ("slowResources".equals(cmd)) {
            String arg = values.get(0);
            boolean setting = true;
            if ("off".equals(arg) || "false".equals(arg)) {
                setting = false;
            }
            StaticContentHandler.setSlowResources(setting);
            results = "OK";
        } else {
            if ("open".equals(cmd)) {
                this.warnIfApparentDomainChange(sessionId, values.get(0));
            }
            results = new SeleniumCoreCommand(cmd, values, sessionId).execute();
        }
        if ("captureScreenshotToString".equals(cmd) || "captureEntirePageScreenshotToString".equals(cmd) || "captureEntirePageScreenshot".equals(cmd)) {
            LOGGER.info("Got result: [base64 encoded PNG] on session " + sessionId);
        } else if ("retrieveLastRemoteControlLogs".equals(cmd)) {
            LOGGER.info("Got result:" + results.substring(0, 30) + "... on session " + sessionId);
        } else {
            LOGGER.info("Got result: " + results + " on session " + sessionId);
        }
        return results;
    }

    private void warnIfApparentDomainChange(String sessionId, String url) {
        if (url.startsWith("http://")) {
            String urlDomain = url.replaceFirst("^(http://[^/]+, url)/.*", "$1");
            String domain = this.getDomain(sessionId);
            if (domain == null) {
                this.setDomain(sessionId, urlDomain);
            } else if (!url.startsWith(domain)) {
                LOGGER.warn("you appear to be changing domains from " + domain + " to " + urlDomain + "\n" + "this may lead to a 'Permission denied' from the browser (unless it is running as *iehta or *chrome,\n" + "or alternatively the selenium server is running in proxy injection mode)");
            }
        }
    }

    private String getDomain(String sessionId) {
        return this.domainsBySessionId.get(sessionId);
    }

    private Vector<String> parseSeleneseParameters(HttpRequest req) {
        Vector<String> values = new Vector<String>();
        int i = 1;
        while (req.getParameter(Integer.toString(i)) != null) {
            values.add(req.getParameter(Integer.toString(i)));
            ++i;
        }
        if (values.size() < 1) {
            values.add("");
        }
        if (values.size() < 2) {
            values.add("");
        }
        return values;
    }

    private File downloadFile(String urlString) {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed URL <" + urlString + ">, ", e);
        }
        String fileType = ".file";
        int fileTypeIndex = url.getFile().lastIndexOf(".");
        if (fileTypeIndex != -1) {
            fileType = url.getFile().substring(fileTypeIndex);
        }
        File outputFile = FileUtils.getFileUtils().createTempFile("se-", fileType, null);
        outputFile.deleteOnExit();
        Project p = new Project();
        p.addBuildListener(new AntJettyLoggerBuildListener(LOGGER));
        Get g = new Get();
        g.setProject(p);
        g.setSrc(url);
        g.setDest(outputFile);
        g.execute();
        return outputFile;
    }

    protected static String getSpeedForSession(String sessionId) {
        FrameGroupCommandQueueSet queueSet;
        String results = null;
        if (null != sessionId && null != (queueSet = FrameGroupCommandQueueSet.getQueueSet(sessionId))) {
            results = "OK," + queueSet.getSpeed();
        }
        if (null == results) {
            results = "OK," + CommandQueue.getSpeed();
        }
        return results;
    }

    protected static void setSpeedForSession(String sessionId, int speed) {
        if (null != sessionId) {
            FrameGroupCommandQueueSet queueSet = FrameGroupCommandQueueSet.getQueueSet(sessionId);
            if (speed < 0) {
                speed = 0;
            }
            if (null != queueSet) {
                queueSet.setSpeed(speed);
            }
        } else {
            CommandQueue.setSpeed(speed);
        }
    }

    private void shutDown(HttpResponse res) {
        LOGGER.info("Shutdown command received");
        Runnable initiateShutDown = new Runnable(){

            public void run() {
                LOGGER.info("initiating shutdown");
                AsyncExecute.sleepTight(500L);
                System.exit(0);
            }
        };
        Thread isd = new Thread(initiateShutDown);
        isd.setName("initiateShutDown");
        isd.start();
        if (res != null) {
            try {
                res.getOutputStream().write("OK".getBytes());
                res.commit();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String generateNewSessionId() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    protected String getNewBrowserSession(String browserString, String startURL, String extensionJs, BrowserConfigurationOptions browserConfigurations) throws RemoteCommandException {
        BrowserSessionFactory.BrowserSessionInfo sessionInfo = this.browserSessionFactory.getNewBrowserSession(browserString, startURL, extensionJs, browserConfigurations, this.remoteControl.getConfiguration());
        SeleniumDriverResourceHandler.setLastSessionId(sessionInfo.sessionId);
        return sessionInfo.sessionId;
    }

    private void hackRemoveConnectionCloseHeader(HttpResponse res) {
        res.removeField("Connection");
        Field[] fields = HttpConnection.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field _close;
            if (fields[i].getName().equals("_close")) {
                _close = fields[i];
                _close.setAccessible(true);
                try {
                    _close.setBoolean(res.getHttpConnection(), false);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            if (!fields[i].getName().equals("_persistent")) continue;
            _close = fields[i];
            _close.setAccessible(true);
            try {
                _close.setBoolean(res.getHttpConnection(), true);
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public void registerBrowserSession(BrowserSessionFactory.BrowserSessionInfo sessionInfo) {
        this.browserSessionFactory.registerExternalSession(sessionInfo);
    }

    public void deregisterBrowserSession(BrowserSessionFactory.BrowserSessionInfo sessionInfo) {
        this.browserSessionFactory.deregisterExternalSession(sessionInfo);
    }

    public void stopAllBrowsers() {
        this.browserSessionFactory.endAllBrowserSessions(this.remoteControl.getConfiguration());
    }

    private void setNoCacheHeaders(HttpResponse res) {
        res.setField("Cache-Control", "no-cache");
        res.setField("Pragma", "no-cache");
        res.setField("Expires", HttpFields.__01Jan1970);
    }

    private void setDomain(String sessionId, String domain) {
        this.domainsBySessionId.put(sessionId, domain);
    }

    public static String getLastSessionId() {
        return lastSessionId;
    }

    public static void setLastSessionId(String sessionId) {
        lastSessionId = sessionId;
    }

    public BrowserLauncherFactory getBrowserLauncherFactory() {
        return this.browserLauncherFactory;
    }

    public void setBrowserLauncherFactory(BrowserLauncherFactory browserLauncherFactory) {
        this.browserLauncherFactory = browserLauncherFactory;
    }
}

