use ExtUtils::MakeMaker;
require 5;
use Config;

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

%MakeParams = InitMakeParams();

WriteMakefile(%MakeParams);

GetTestHost();

sub InitMakeParams {
my %Params = (
    NAME         => 'SNMP',
    dist         => { SUFFIX => "gz", COMPRESS => "gzip -9f"},
    MAN3PODS     => ' ',  # Pods will be built by installman.
    XSPROTOARG   => '-noprototypes', 	# XXX remove later?
    VERSION_FROM => 'SNMP.pm',

	    );
my $snmp_lib = ($Config{'osname'} eq 'MSWin32' ? 'libsnmp.dll' : 'libsnmp.a');
my $snmp_llib = ($Config{'osname'} eq 'MSWin32' ? 'libsnmp' : 'snmp');
my @IncludeFiles = qw[asn1.h mib.h parse.h snmp.h snmp_api.h 
		      snmp_client.h snmp_impl.h];

my @IncludeDirs = qw[/usr/include /usr/local/include];

my $IncludeDir = find_files(\@IncludeFiles,\@IncludeDirs) ||
    prompt("Where are the $snmp_lib include files?","/usr/local/include");

my $LibDir = find_files(["$snmp_lib"],[qw[/usr/lib /usr/local/lib]]) ||
	prompt("Where is $snmp_lib installed?","/usr/local/lib");

   @IncludeFiles = map {"$IncludeDir/$_";} @IncludeFiles;
   $Params{LIBS} = "-L$LibDir -l$snmp_llib";
   $Params{INC}  = "-I$IncludeDir";
   $Params{H}    = \@IncludeFiles;
   return(%Params);
}

sub find_files {
    my($f,$d) = @_;
    my ($dir,$found,$file);
    for $dir (@$d){
	$found = 0;
	for $file (@$f) {
	    $found++ if -f "$dir/$file";
	}
	if ($found == @$f) {
	    return $dir;
	}
    }
}

sub GetTestHost {
    my $resp = prompt("Enter hostname or IP address for SNMP tests: ",
		      "localhost public");
    open(H, ">host") || die "Error: could not open file 'host' ($!)";
    print H "$resp\n";
    close H;
}

