#!/usr/bin/perl

use strict;
use lib 't/lib';

use Test::More;
use Test::Deep qw(cmp_deeply);

use FusionInventory::Agent::SNMP::Mock;
use FusionInventory::Agent::Tools::Hardware;

my %tests = (
    'force10/c300.01.walk' => [
        {
            TYPE         => 'NETWORKING',
            MANUFACTURER => 'Dell',
            DESCRIPTION  => 'Dell Force10 OS
Operating System Version: 1.0
Application Software Version: 8.4.2.7
Series: C300
Copyright (c) 1999-2012 by Dell Inc. All Rights Reserved.
Build Time: Thu Sep 27 14:19:20 PDT 2012',

            SNMPHOSTNAME => 'sw-c300-1-tmk',
            LOCATION     => 'Nowhere',
            CONTACT      => 'admin@foo.bar',
            UPTIME       => '(2412518166) 279 days, 5:26:21.66',
            MAC          => '00:01:e8:85:4f:43',
            IPS          => {
                IP => [
                    '10.20.102.3',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'NETWORKING',
                MANUFACTURER => 'Dell',
                COMMENTS     => 'Dell Force10 OS
Operating System Version: 1.0
Application Software Version: 8.4.2.7
Series: C300
Copyright (c) 1999-2012 by Dell Inc. All Rights Reserved.
Build Time: Thu Sep 27 14:19:20 PDT 2012',
                NAME         => 'sw-c300-1-tmk',
                LOCATION     => 'Nowhere',
                CONTACT      => 'admin@foo.bar',
                UPTIME       => '(2412518166) 279 days, 5:26:21.66',
                MAC          => '00:01:e8:85:4f:43',
                IPS          => {
                    IP => [
                        '10.20.102.3',
                    ],
                },
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '33866756',
                        IFNAME           => 'GigabitEthernet 0/0',
                        IFDESCR          => 'GigabitEthernet 0/0',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:95',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26702) 0:04:27.02',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34128900',
                        IFNAME           => 'GigabitEthernet 0/1',
                        IFDESCR          => 'GigabitEthernet 0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:96',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(149948290) 17 days, 8:31:22.90',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '528152',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '13170650',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34391044',
                        IFNAME           => 'GigabitEthernet 0/2',
                        IFDESCR          => 'GigabitEthernet 0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:97',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26702) 0:04:27.02',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34653188',
                        IFNAME           => 'GigabitEthernet 0/3',
                        IFDESCR          => 'GigabitEthernet 0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:98',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26702) 0:04:27.02',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34915332',
                        IFNAME           => 'GigabitEthernet 0/4',
                        IFDESCR          => 'GigabitEthernet 0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:99',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26702) 0:04:27.02',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '35177476',
                        IFNAME           => 'GigabitEthernet 0/5',
                        IFDESCR          => 'GigabitEthernet 0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:9a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26702) 0:04:27.02',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '35439620',
                        IFNAME           => 'GigabitEthernet 0/6',
                        IFDESCR          => 'GigabitEthernet 0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:9b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26702) 0:04:27.02',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '35701764',
                        IFNAME           => 'GigabitEthernet 0/7',
                        IFDESCR          => 'GigabitEthernet 0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:9c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26702) 0:04:27.02',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '35963908',
                        IFNAME           => 'GigabitEthernet 0/8',
                        IFDESCR          => 'GigabitEthernet 0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:9d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26702) 0:04:27.02',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '36226052',
                        IFNAME           => 'GigabitEthernet 0/9',
                        IFDESCR          => 'GigabitEthernet 0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:9e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26702) 0:04:27.02',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '36488196',
                        IFNAME           => 'GigabitEthernet 0/10',
                        IFDESCR          => 'GigabitEthernet 0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:9f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26702) 0:04:27.02',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '36750340',
                        IFNAME           => 'GigabitEthernet 0/11',
                        IFDESCR          => 'GigabitEthernet 0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26702) 0:04:27.02',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37012484',
                        IFNAME           => 'GigabitEthernet 0/12',
                        IFDESCR          => 'GigabitEthernet 0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:a1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26702) 0:04:27.02',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37274628',
                        IFNAME           => 'GigabitEthernet 0/13',
                        IFDESCR          => 'GigabitEthernet 0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:a2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26702) 0:04:27.02',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37536772',
                        IFNAME           => 'GigabitEthernet 0/14',
                        IFDESCR          => 'GigabitEthernet 0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:a3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26702) 0:04:27.02',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37798916',
                        IFNAME           => 'GigabitEthernet 0/15',
                        IFDESCR          => 'GigabitEthernet 0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:a4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26702) 0:04:27.02',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38061060',
                        IFNAME           => 'GigabitEthernet 0/16',
                        IFDESCR          => 'GigabitEthernet 0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:a5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26702) 0:04:27.02',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38323204',
                        IFNAME           => 'GigabitEthernet 0/17',
                        IFDESCR          => 'GigabitEthernet 0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:a6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26702) 0:04:27.02',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38585348',
                        IFNAME           => 'GigabitEthernet 0/18',
                        IFDESCR          => 'GigabitEthernet 0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:a7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26702) 0:04:27.02',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38847492',
                        IFNAME           => 'GigabitEthernet 0/19',
                        IFDESCR          => 'GigabitEthernet 0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:a8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26704) 0:04:27.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '39109636',
                        IFNAME           => 'GigabitEthernet 0/20',
                        IFDESCR          => 'GigabitEthernet 0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:a9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26704) 0:04:27.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '39371780',
                        IFNAME           => 'GigabitEthernet 0/21',
                        IFDESCR          => 'GigabitEthernet 0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:aa',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26704) 0:04:27.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '39633924',
                        IFNAME           => 'GigabitEthernet 0/22',
                        IFDESCR          => 'GigabitEthernet 0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:ab',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26704) 0:04:27.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '39896068',
                        IFNAME           => 'GigabitEthernet 0/23',
                        IFDESCR          => 'GigabitEthernet 0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:ac',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26704) 0:04:27.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '40158212',
                        IFNAME           => 'GigabitEthernet 0/24',
                        IFDESCR          => 'GigabitEthernet 0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:ad',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26704) 0:04:27.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '40420356',
                        IFNAME           => 'GigabitEthernet 0/25',
                        IFDESCR          => 'GigabitEthernet 0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:ae',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26704) 0:04:27.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '40682500',
                        IFNAME           => 'GigabitEthernet 0/26',
                        IFDESCR          => 'GigabitEthernet 0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:af',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26704) 0:04:27.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '40944644',
                        IFNAME           => 'GigabitEthernet 0/27',
                        IFDESCR          => 'GigabitEthernet 0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:b0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26704) 0:04:27.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '41206788',
                        IFNAME           => 'GigabitEthernet 0/28',
                        IFDESCR          => 'GigabitEthernet 0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:b1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26704) 0:04:27.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '41468932',
                        IFNAME           => 'GigabitEthernet 0/29',
                        IFDESCR          => 'GigabitEthernet 0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:b2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26704) 0:04:27.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '41731076',
                        IFNAME           => 'GigabitEthernet 0/30',
                        IFDESCR          => 'GigabitEthernet 0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:b3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26704) 0:04:27.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '41993220',
                        IFNAME           => 'GigabitEthernet 0/31',
                        IFDESCR          => 'GigabitEthernet 0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:b4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26704) 0:04:27.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '42255364',
                        IFNAME           => 'GigabitEthernet 0/32',
                        IFDESCR          => 'GigabitEthernet 0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:b5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26704) 0:04:27.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '42517508',
                        IFNAME           => 'GigabitEthernet 0/33',
                        IFDESCR          => 'GigabitEthernet 0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:b6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26704) 0:04:27.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '42779652',
                        IFNAME           => 'GigabitEthernet 0/34',
                        IFDESCR          => 'GigabitEthernet 0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:b7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26704) 0:04:27.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '43041796',
                        IFNAME           => 'GigabitEthernet 0/35',
                        IFDESCR          => 'GigabitEthernet 0/35',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:b8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26704) 0:04:27.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '43303940',
                        IFNAME           => 'GigabitEthernet 0/36',
                        IFDESCR          => 'GigabitEthernet 0/36',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:b9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26704) 0:04:27.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '43566084',
                        IFNAME           => 'GigabitEthernet 0/37',
                        IFDESCR          => 'GigabitEthernet 0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:ba',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26704) 0:04:27.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '43828228',
                        IFNAME           => 'GigabitEthernet 0/38',
                        IFDESCR          => 'GigabitEthernet 0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:bb',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26704) 0:04:27.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '44090372',
                        IFNAME           => 'GigabitEthernet 0/39',
                        IFDESCR          => 'GigabitEthernet 0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:bc',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26704) 0:04:27.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '44352516',
                        IFNAME           => 'GigabitEthernet 0/40',
                        IFDESCR          => 'GigabitEthernet 0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:bd',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26704) 0:04:27.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '44614660',
                        IFNAME           => 'GigabitEthernet 0/41',
                        IFDESCR          => 'GigabitEthernet 0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:be',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26704) 0:04:27.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '44876804',
                        IFNAME           => 'GigabitEthernet 0/42',
                        IFDESCR          => 'GigabitEthernet 0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:bf',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26704) 0:04:27.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '45138948',
                        IFNAME           => 'GigabitEthernet 0/43',
                        IFDESCR          => 'GigabitEthernet 0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26704) 0:04:27.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '45417476',
                        IFNAME           => 'TenGigabitEthernet 0/44',
                        IFDESCR          => 'TenGigabitEthernet 0/44',
                        IFALIAS          => 'To sw-ex8208-tmk',
                        IFTYPE           => '6',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:c1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875503960) 217 days, 1:43:59.60',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '3533249360',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3105352857',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => '568',
                                IFDESCR  => 'xe-0/0/2.0',
                                SYSNAME  => 'sw-ex8208-tmk',
                                SYSDESCR => 'Juniper Networks, Inc. ex8208 , version 12.3R3.4 Build date: 2013-06-14 01:38:46 UTC ',
                                SYSMAC   => '',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '45679620',
                        IFNAME           => 'TenGigabitEthernet 0/45',
                        IFDESCR          => 'TenGigabitEthernet 0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:99:c2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26704) 0:04:27.04',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '67421188',
                        IFNAME           => 'GigabitEthernet 1/0',
                        IFDESCR          => 'GigabitEthernet 1/0',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:75',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26670) 0:04:26.70',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '67683332',
                        IFNAME           => 'GigabitEthernet 1/1',
                        IFDESCR          => 'GigabitEthernet 1/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:76',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26670) 0:04:26.70',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '67945476',
                        IFNAME           => 'GigabitEthernet 1/2',
                        IFDESCR          => 'GigabitEthernet 1/2',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:77',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26670) 0:04:26.70',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '68207620',
                        IFNAME           => 'GigabitEthernet 1/3',
                        IFDESCR          => 'GigabitEthernet 1/3',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:78',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26670) 0:04:26.70',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '68469764',
                        IFNAME           => 'GigabitEthernet 1/4',
                        IFDESCR          => 'GigabitEthernet 1/4',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:79',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26670) 0:04:26.70',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '68731908',
                        IFNAME           => 'GigabitEthernet 1/5',
                        IFDESCR          => 'GigabitEthernet 1/5',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:7a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26670) 0:04:26.70',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '68994052',
                        IFNAME           => 'GigabitEthernet 1/6',
                        IFDESCR          => 'GigabitEthernet 1/6',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:7b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26670) 0:04:26.70',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '69256196',
                        IFNAME           => 'GigabitEthernet 1/7',
                        IFDESCR          => 'GigabitEthernet 1/7',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:7c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26670) 0:04:26.70',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '69518340',
                        IFNAME           => 'GigabitEthernet 1/8',
                        IFDESCR          => 'GigabitEthernet 1/8',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:7d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26670) 0:04:26.70',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '69780484',
                        IFNAME           => 'GigabitEthernet 1/9',
                        IFDESCR          => 'GigabitEthernet 1/9',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:7e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26672) 0:04:26.72',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '70042628',
                        IFNAME           => 'GigabitEthernet 1/10',
                        IFDESCR          => 'GigabitEthernet 1/10',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:7f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26672) 0:04:26.72',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '70304772',
                        IFNAME           => 'GigabitEthernet 1/11',
                        IFDESCR          => 'GigabitEthernet 1/11',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26672) 0:04:26.72',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '70566916',
                        IFNAME           => 'GigabitEthernet 1/12',
                        IFDESCR          => 'GigabitEthernet 1/12',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:81',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26672) 0:04:26.72',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '70829060',
                        IFNAME           => 'GigabitEthernet 1/13',
                        IFDESCR          => 'GigabitEthernet 1/13',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:82',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26672) 0:04:26.72',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '71091204',
                        IFNAME           => 'GigabitEthernet 1/14',
                        IFDESCR          => 'GigabitEthernet 1/14',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:83',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26672) 0:04:26.72',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '71353348',
                        IFNAME           => 'GigabitEthernet 1/15',
                        IFDESCR          => 'GigabitEthernet 1/15',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:84',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26672) 0:04:26.72',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '71615492',
                        IFNAME           => 'GigabitEthernet 1/16',
                        IFDESCR          => 'GigabitEthernet 1/16',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:85',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26672) 0:04:26.72',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '71877636',
                        IFNAME           => 'GigabitEthernet 1/17',
                        IFDESCR          => 'GigabitEthernet 1/17',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:86',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26672) 0:04:26.72',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '72139780',
                        IFNAME           => 'GigabitEthernet 1/18',
                        IFDESCR          => 'GigabitEthernet 1/18',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:87',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26672) 0:04:26.72',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '72401924',
                        IFNAME           => 'GigabitEthernet 1/19',
                        IFDESCR          => 'GigabitEthernet 1/19',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:88',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26672) 0:04:26.72',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '72664068',
                        IFNAME           => 'GigabitEthernet 1/20',
                        IFDESCR          => 'GigabitEthernet 1/20',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:89',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26672) 0:04:26.72',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '72926212',
                        IFNAME           => 'GigabitEthernet 1/21',
                        IFDESCR          => 'GigabitEthernet 1/21',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:8a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26672) 0:04:26.72',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '73188356',
                        IFNAME           => 'GigabitEthernet 1/22',
                        IFDESCR          => 'GigabitEthernet 1/22',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:8b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26672) 0:04:26.72',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '73450500',
                        IFNAME           => 'GigabitEthernet 1/23',
                        IFDESCR          => 'GigabitEthernet 1/23',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:8c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26672) 0:04:26.72',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '73712644',
                        IFNAME           => 'GigabitEthernet 1/24',
                        IFDESCR          => 'GigabitEthernet 1/24',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:8d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26672) 0:04:26.72',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '73974788',
                        IFNAME           => 'GigabitEthernet 1/25',
                        IFDESCR          => 'GigabitEthernet 1/25',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:8e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26672) 0:04:26.72',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '74236932',
                        IFNAME           => 'GigabitEthernet 1/26',
                        IFDESCR          => 'GigabitEthernet 1/26',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:8f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26672) 0:04:26.72',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '74499076',
                        IFNAME           => 'GigabitEthernet 1/27',
                        IFDESCR          => 'GigabitEthernet 1/27',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:90',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26674) 0:04:26.74',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '74761220',
                        IFNAME           => 'GigabitEthernet 1/28',
                        IFDESCR          => 'GigabitEthernet 1/28',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:91',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26674) 0:04:26.74',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '75023364',
                        IFNAME           => 'GigabitEthernet 1/29',
                        IFDESCR          => 'GigabitEthernet 1/29',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:92',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26674) 0:04:26.74',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '75285508',
                        IFNAME           => 'GigabitEthernet 1/30',
                        IFDESCR          => 'GigabitEthernet 1/30',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:93',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26674) 0:04:26.74',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '75547652',
                        IFNAME           => 'GigabitEthernet 1/31',
                        IFDESCR          => 'GigabitEthernet 1/31',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:94',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26674) 0:04:26.74',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '75809796',
                        IFNAME           => 'GigabitEthernet 1/32',
                        IFDESCR          => 'GigabitEthernet 1/32',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:95',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26674) 0:04:26.74',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '76071940',
                        IFNAME           => 'GigabitEthernet 1/33',
                        IFDESCR          => 'GigabitEthernet 1/33',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:96',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26674) 0:04:26.74',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '76334084',
                        IFNAME           => 'GigabitEthernet 1/34',
                        IFDESCR          => 'GigabitEthernet 1/34',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:97',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26674) 0:04:26.74',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '76596228',
                        IFNAME           => 'GigabitEthernet 1/35',
                        IFDESCR          => 'GigabitEthernet 1/35',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:98',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26674) 0:04:26.74',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '76858372',
                        IFNAME           => 'GigabitEthernet 1/36',
                        IFDESCR          => 'GigabitEthernet 1/36',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:99',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26674) 0:04:26.74',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '77120516',
                        IFNAME           => 'GigabitEthernet 1/37',
                        IFDESCR          => 'GigabitEthernet 1/37',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:9a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26674) 0:04:26.74',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '77382660',
                        IFNAME           => 'GigabitEthernet 1/38',
                        IFDESCR          => 'GigabitEthernet 1/38',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:9b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26674) 0:04:26.74',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '77644804',
                        IFNAME           => 'GigabitEthernet 1/39',
                        IFDESCR          => 'GigabitEthernet 1/39',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:9c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26674) 0:04:26.74',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '77906948',
                        IFNAME           => 'GigabitEthernet 1/40',
                        IFDESCR          => 'GigabitEthernet 1/40',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:9d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26674) 0:04:26.74',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '78169092',
                        IFNAME           => 'GigabitEthernet 1/41',
                        IFDESCR          => 'GigabitEthernet 1/41',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:9e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26674) 0:04:26.74',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '78431236',
                        IFNAME           => 'GigabitEthernet 1/42',
                        IFDESCR          => 'GigabitEthernet 1/42',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:9f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26674) 0:04:26.74',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '78693380',
                        IFNAME           => 'GigabitEthernet 1/43',
                        IFDESCR          => 'GigabitEthernet 1/43',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26674) 0:04:26.74',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '78971908',
                        IFNAME           => 'TenGigabitEthernet 1/44',
                        IFDESCR          => 'TenGigabitEthernet 1/44',
                        IFALIAS          => 'To sw-ex8208-tmk',
                        IFTYPE           => '6',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:a1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504336) 217 days, 1:44:03.36',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '3624729575',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1980027494',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => '576',
                                IFDESCR  => 'xe-1/0/2.0',
                                SYSNAME  => 'sw-ex8208-tmk',
                                SYSDESCR => 'Juniper Networks, Inc. ex8208 , version 12.3R3.4 Build date: 2013-06-14 01:38:46 UTC ',
                                SYSMAC   => '',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '79234052',
                        IFNAME           => 'TenGigabitEthernet 1/45',
                        IFDESCR          => 'TenGigabitEthernet 1/45',
                        IFTYPE           => '6',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9a:a2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26674) 0:04:26.74',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '100975616',
                        IFNAME           => 'GigabitEthernet 2/0',
                        IFDESCR          => 'GigabitEthernet 2/0',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:55',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637218) 12 days, 22:06:12.18',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '101237760',
                        IFNAME           => 'GigabitEthernet 2/1',
                        IFDESCR          => 'GigabitEthernet 2/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:56',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637218) 12 days, 22:06:12.18',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '101499904',
                        IFNAME           => 'GigabitEthernet 2/2',
                        IFDESCR          => 'GigabitEthernet 2/2',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:57',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637218) 12 days, 22:06:12.18',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '101762048',
                        IFNAME           => 'GigabitEthernet 2/3',
                        IFDESCR          => 'GigabitEthernet 2/3',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:58',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637220) 12 days, 22:06:12.20',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '102024192',
                        IFNAME           => 'GigabitEthernet 2/4',
                        IFDESCR          => 'GigabitEthernet 2/4',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:59',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637220) 12 days, 22:06:12.20',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '102286336',
                        IFNAME           => 'GigabitEthernet 2/5',
                        IFDESCR          => 'GigabitEthernet 2/5',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:5a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637220) 12 days, 22:06:12.20',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '102548480',
                        IFNAME           => 'GigabitEthernet 2/6',
                        IFDESCR          => 'GigabitEthernet 2/6',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:5b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637220) 12 days, 22:06:12.20',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '102810624',
                        IFNAME           => 'GigabitEthernet 2/7',
                        IFDESCR          => 'GigabitEthernet 2/7',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:5c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637222) 12 days, 22:06:12.22',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '103072768',
                        IFNAME           => 'GigabitEthernet 2/8',
                        IFDESCR          => 'GigabitEthernet 2/8',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:5d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637224) 12 days, 22:06:12.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '103334912',
                        IFNAME           => 'GigabitEthernet 2/9',
                        IFDESCR          => 'GigabitEthernet 2/9',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:5e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637224) 12 days, 22:06:12.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '103597056',
                        IFNAME           => 'GigabitEthernet 2/10',
                        IFDESCR          => 'GigabitEthernet 2/10',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:5f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637224) 12 days, 22:06:12.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '103859200',
                        IFNAME           => 'GigabitEthernet 2/11',
                        IFDESCR          => 'GigabitEthernet 2/11',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:60',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637224) 12 days, 22:06:12.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '104121344',
                        IFNAME           => 'GigabitEthernet 2/12',
                        IFDESCR          => 'GigabitEthernet 2/12',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637224) 12 days, 22:06:12.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '104383488',
                        IFNAME           => 'GigabitEthernet 2/13',
                        IFDESCR          => 'GigabitEthernet 2/13',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:62',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637224) 12 days, 22:06:12.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '104645632',
                        IFNAME           => 'GigabitEthernet 2/14',
                        IFDESCR          => 'GigabitEthernet 2/14',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:63',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637224) 12 days, 22:06:12.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '104907776',
                        IFNAME           => 'GigabitEthernet 2/15',
                        IFDESCR          => 'GigabitEthernet 2/15',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:64',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637224) 12 days, 22:06:12.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '105169920',
                        IFNAME           => 'GigabitEthernet 2/16',
                        IFDESCR          => 'GigabitEthernet 2/16',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:65',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637224) 12 days, 22:06:12.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '105432064',
                        IFNAME           => 'GigabitEthernet 2/17',
                        IFDESCR          => 'GigabitEthernet 2/17',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:66',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637224) 12 days, 22:06:12.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '105694208',
                        IFNAME           => 'GigabitEthernet 2/18',
                        IFDESCR          => 'GigabitEthernet 2/18',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:67',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637224) 12 days, 22:06:12.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '105956352',
                        IFNAME           => 'GigabitEthernet 2/19',
                        IFDESCR          => 'GigabitEthernet 2/19',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:68',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637224) 12 days, 22:06:12.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '106218496',
                        IFNAME           => 'GigabitEthernet 2/20',
                        IFDESCR          => 'GigabitEthernet 2/20',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:69',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637224) 12 days, 22:06:12.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '106480640',
                        IFNAME           => 'GigabitEthernet 2/21',
                        IFDESCR          => 'GigabitEthernet 2/21',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:6a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637224) 12 days, 22:06:12.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '106742784',
                        IFNAME           => 'GigabitEthernet 2/22',
                        IFDESCR          => 'GigabitEthernet 2/22',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:6b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637226) 12 days, 22:06:12.26',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '107004928',
                        IFNAME           => 'GigabitEthernet 2/23',
                        IFDESCR          => 'GigabitEthernet 2/23',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:6c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637226) 12 days, 22:06:12.26',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '107267072',
                        IFNAME           => 'GigabitEthernet 2/24',
                        IFDESCR          => 'GigabitEthernet 2/24',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:6d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637226) 12 days, 22:06:12.26',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '107529216',
                        IFNAME           => 'GigabitEthernet 2/25',
                        IFDESCR          => 'GigabitEthernet 2/25',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:6e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637226) 12 days, 22:06:12.26',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '107791360',
                        IFNAME           => 'GigabitEthernet 2/26',
                        IFDESCR          => 'GigabitEthernet 2/26',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:6f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637226) 12 days, 22:06:12.26',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '108053504',
                        IFNAME           => 'GigabitEthernet 2/27',
                        IFDESCR          => 'GigabitEthernet 2/27',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:70',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637226) 12 days, 22:06:12.26',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '108315648',
                        IFNAME           => 'GigabitEthernet 2/28',
                        IFDESCR          => 'GigabitEthernet 2/28',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:71',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637226) 12 days, 22:06:12.26',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '108577792',
                        IFNAME           => 'GigabitEthernet 2/29',
                        IFDESCR          => 'GigabitEthernet 2/29',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:72',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637226) 12 days, 22:06:12.26',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '108839936',
                        IFNAME           => 'GigabitEthernet 2/30',
                        IFDESCR          => 'GigabitEthernet 2/30',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:73',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637226) 12 days, 22:06:12.26',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '109102080',
                        IFNAME           => 'GigabitEthernet 2/31',
                        IFDESCR          => 'GigabitEthernet 2/31',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:74',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637226) 12 days, 22:06:12.26',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '109364224',
                        IFNAME           => 'GigabitEthernet 2/32',
                        IFDESCR          => 'GigabitEthernet 2/32',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:75',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637226) 12 days, 22:06:12.26',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '109626368',
                        IFNAME           => 'GigabitEthernet 2/33',
                        IFDESCR          => 'GigabitEthernet 2/33',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:76',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637226) 12 days, 22:06:12.26',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '109888512',
                        IFNAME           => 'GigabitEthernet 2/34',
                        IFDESCR          => 'GigabitEthernet 2/34',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:77',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637226) 12 days, 22:06:12.26',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '110150656',
                        IFNAME           => 'GigabitEthernet 2/35',
                        IFDESCR          => 'GigabitEthernet 2/35',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:78',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637226) 12 days, 22:06:12.26',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '110412800',
                        IFNAME           => 'GigabitEthernet 2/36',
                        IFDESCR          => 'GigabitEthernet 2/36',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:79',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637226) 12 days, 22:06:12.26',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '110674944',
                        IFNAME           => 'GigabitEthernet 2/37',
                        IFDESCR          => 'GigabitEthernet 2/37',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:7a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637226) 12 days, 22:06:12.26',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '110937088',
                        IFNAME           => 'GigabitEthernet 2/38',
                        IFDESCR          => 'GigabitEthernet 2/38',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:7b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637226) 12 days, 22:06:12.26',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '111199232',
                        IFNAME           => 'GigabitEthernet 2/39',
                        IFDESCR          => 'GigabitEthernet 2/39',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:7c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637226) 12 days, 22:06:12.26',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '111461376',
                        IFNAME           => 'GigabitEthernet 2/40',
                        IFDESCR          => 'GigabitEthernet 2/40',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:7d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637226) 12 days, 22:06:12.26',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '111723520',
                        IFNAME           => 'GigabitEthernet 2/41',
                        IFDESCR          => 'GigabitEthernet 2/41',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:7e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637226) 12 days, 22:06:12.26',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '111985664',
                        IFNAME           => 'GigabitEthernet 2/42',
                        IFDESCR          => 'GigabitEthernet 2/42',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:7f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637226) 12 days, 22:06:12.26',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '112247808',
                        IFNAME           => 'GigabitEthernet 2/43',
                        IFDESCR          => 'GigabitEthernet 2/43',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637226) 12 days, 22:06:12.26',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '112509952',
                        IFNAME           => 'GigabitEthernet 2/44',
                        IFDESCR          => 'GigabitEthernet 2/44',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:81',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637226) 12 days, 22:06:12.26',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '112772096',
                        IFNAME           => 'GigabitEthernet 2/45',
                        IFDESCR          => 'GigabitEthernet 2/45',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:82',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637226) 12 days, 22:06:12.26',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '113034240',
                        IFNAME           => 'GigabitEthernet 2/46',
                        IFDESCR          => 'GigabitEthernet 2/46',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:83',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637226) 12 days, 22:06:12.26',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '113296384',
                        IFNAME           => 'GigabitEthernet 2/47',
                        IFDESCR          => 'GigabitEthernet 2/47',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9b:84',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111637226) 12 days, 22:06:12.26',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '134530048',
                        IFNAME           => 'GigabitEthernet 3/0',
                        IFDESCR          => 'GigabitEthernet 3/0',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:35',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626416) 12 days, 22:04:24.16',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '134792192',
                        IFNAME           => 'GigabitEthernet 3/1',
                        IFDESCR          => 'GigabitEthernet 3/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626416) 12 days, 22:04:24.16',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '135054336',
                        IFNAME           => 'GigabitEthernet 3/2',
                        IFDESCR          => 'GigabitEthernet 3/2',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:37',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626416) 12 days, 22:04:24.16',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '135316480',
                        IFNAME           => 'GigabitEthernet 3/3',
                        IFDESCR          => 'GigabitEthernet 3/3',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:38',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626416) 12 days, 22:04:24.16',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '135578624',
                        IFNAME           => 'GigabitEthernet 3/4',
                        IFDESCR          => 'GigabitEthernet 3/4',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:39',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626416) 12 days, 22:04:24.16',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '135840768',
                        IFNAME           => 'GigabitEthernet 3/5',
                        IFDESCR          => 'GigabitEthernet 3/5',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:3a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626416) 12 days, 22:04:24.16',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '136102912',
                        IFNAME           => 'GigabitEthernet 3/6',
                        IFDESCR          => 'GigabitEthernet 3/6',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:3b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626416) 12 days, 22:04:24.16',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '136365056',
                        IFNAME           => 'GigabitEthernet 3/7',
                        IFDESCR          => 'GigabitEthernet 3/7',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:3c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626416) 12 days, 22:04:24.16',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '136627200',
                        IFNAME           => 'GigabitEthernet 3/8',
                        IFDESCR          => 'GigabitEthernet 3/8',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:3d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626416) 12 days, 22:04:24.16',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '136889344',
                        IFNAME           => 'GigabitEthernet 3/9',
                        IFDESCR          => 'GigabitEthernet 3/9',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:3e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626416) 12 days, 22:04:24.16',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '137151488',
                        IFNAME           => 'GigabitEthernet 3/10',
                        IFDESCR          => 'GigabitEthernet 3/10',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:3f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626416) 12 days, 22:04:24.16',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '137413632',
                        IFNAME           => 'GigabitEthernet 3/11',
                        IFDESCR          => 'GigabitEthernet 3/11',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:40',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626418) 12 days, 22:04:24.18',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '137675776',
                        IFNAME           => 'GigabitEthernet 3/12',
                        IFDESCR          => 'GigabitEthernet 3/12',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:41',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626418) 12 days, 22:04:24.18',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '137937920',
                        IFNAME           => 'GigabitEthernet 3/13',
                        IFDESCR          => 'GigabitEthernet 3/13',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:42',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626418) 12 days, 22:04:24.18',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '138200064',
                        IFNAME           => 'GigabitEthernet 3/14',
                        IFDESCR          => 'GigabitEthernet 3/14',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:43',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626418) 12 days, 22:04:24.18',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '138462208',
                        IFNAME           => 'GigabitEthernet 3/15',
                        IFDESCR          => 'GigabitEthernet 3/15',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:44',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626418) 12 days, 22:04:24.18',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '138724352',
                        IFNAME           => 'GigabitEthernet 3/16',
                        IFDESCR          => 'GigabitEthernet 3/16',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:45',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626420) 12 days, 22:04:24.20',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '138986496',
                        IFNAME           => 'GigabitEthernet 3/17',
                        IFDESCR          => 'GigabitEthernet 3/17',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:46',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626420) 12 days, 22:04:24.20',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '139248640',
                        IFNAME           => 'GigabitEthernet 3/18',
                        IFDESCR          => 'GigabitEthernet 3/18',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:47',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626420) 12 days, 22:04:24.20',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '139510784',
                        IFNAME           => 'GigabitEthernet 3/19',
                        IFDESCR          => 'GigabitEthernet 3/19',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:48',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626420) 12 days, 22:04:24.20',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '139772928',
                        IFNAME           => 'GigabitEthernet 3/20',
                        IFDESCR          => 'GigabitEthernet 3/20',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:49',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626420) 12 days, 22:04:24.20',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '140035072',
                        IFNAME           => 'GigabitEthernet 3/21',
                        IFDESCR          => 'GigabitEthernet 3/21',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:4a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626420) 12 days, 22:04:24.20',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '140297216',
                        IFNAME           => 'GigabitEthernet 3/22',
                        IFDESCR          => 'GigabitEthernet 3/22',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:4b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626420) 12 days, 22:04:24.20',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '140559360',
                        IFNAME           => 'GigabitEthernet 3/23',
                        IFDESCR          => 'GigabitEthernet 3/23',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:4c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626420) 12 days, 22:04:24.20',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '140821504',
                        IFNAME           => 'GigabitEthernet 3/24',
                        IFDESCR          => 'GigabitEthernet 3/24',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:4d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626420) 12 days, 22:04:24.20',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '141083648',
                        IFNAME           => 'GigabitEthernet 3/25',
                        IFDESCR          => 'GigabitEthernet 3/25',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:4e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626420) 12 days, 22:04:24.20',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '141345792',
                        IFNAME           => 'GigabitEthernet 3/26',
                        IFDESCR          => 'GigabitEthernet 3/26',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:4f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626420) 12 days, 22:04:24.20',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '141607936',
                        IFNAME           => 'GigabitEthernet 3/27',
                        IFDESCR          => 'GigabitEthernet 3/27',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626420) 12 days, 22:04:24.20',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '141870080',
                        IFNAME           => 'GigabitEthernet 3/28',
                        IFDESCR          => 'GigabitEthernet 3/28',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:51',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626420) 12 days, 22:04:24.20',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '142132224',
                        IFNAME           => 'GigabitEthernet 3/29',
                        IFDESCR          => 'GigabitEthernet 3/29',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:52',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626420) 12 days, 22:04:24.20',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '142394368',
                        IFNAME           => 'GigabitEthernet 3/30',
                        IFDESCR          => 'GigabitEthernet 3/30',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:53',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626420) 12 days, 22:04:24.20',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '142656512',
                        IFNAME           => 'GigabitEthernet 3/31',
                        IFDESCR          => 'GigabitEthernet 3/31',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:54',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626420) 12 days, 22:04:24.20',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '142918656',
                        IFNAME           => 'GigabitEthernet 3/32',
                        IFDESCR          => 'GigabitEthernet 3/32',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:55',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626420) 12 days, 22:04:24.20',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '143180800',
                        IFNAME           => 'GigabitEthernet 3/33',
                        IFDESCR          => 'GigabitEthernet 3/33',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:56',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626420) 12 days, 22:04:24.20',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '143442944',
                        IFNAME           => 'GigabitEthernet 3/34',
                        IFDESCR          => 'GigabitEthernet 3/34',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:57',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626420) 12 days, 22:04:24.20',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '143705088',
                        IFNAME           => 'GigabitEthernet 3/35',
                        IFDESCR          => 'GigabitEthernet 3/35',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:58',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626420) 12 days, 22:04:24.20',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '143967232',
                        IFNAME           => 'GigabitEthernet 3/36',
                        IFDESCR          => 'GigabitEthernet 3/36',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:59',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626422) 12 days, 22:04:24.22',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '144229376',
                        IFNAME           => 'GigabitEthernet 3/37',
                        IFDESCR          => 'GigabitEthernet 3/37',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:5a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626422) 12 days, 22:04:24.22',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '144491520',
                        IFNAME           => 'GigabitEthernet 3/38',
                        IFDESCR          => 'GigabitEthernet 3/38',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:5b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626422) 12 days, 22:04:24.22',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '144753664',
                        IFNAME           => 'GigabitEthernet 3/39',
                        IFDESCR          => 'GigabitEthernet 3/39',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:5c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626422) 12 days, 22:04:24.22',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '145015808',
                        IFNAME           => 'GigabitEthernet 3/40',
                        IFDESCR          => 'GigabitEthernet 3/40',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:5d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626422) 12 days, 22:04:24.22',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '145277952',
                        IFNAME           => 'GigabitEthernet 3/41',
                        IFDESCR          => 'GigabitEthernet 3/41',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:5e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626422) 12 days, 22:04:24.22',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '145540096',
                        IFNAME           => 'GigabitEthernet 3/42',
                        IFDESCR          => 'GigabitEthernet 3/42',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:5f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626422) 12 days, 22:04:24.22',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '145802240',
                        IFNAME           => 'GigabitEthernet 3/43',
                        IFDESCR          => 'GigabitEthernet 3/43',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:60',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626422) 12 days, 22:04:24.22',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '146064384',
                        IFNAME           => 'GigabitEthernet 3/44',
                        IFDESCR          => 'GigabitEthernet 3/44',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626422) 12 days, 22:04:24.22',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '146326528',
                        IFNAME           => 'GigabitEthernet 3/45',
                        IFDESCR          => 'GigabitEthernet 3/45',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:62',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626422) 12 days, 22:04:24.22',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '146588672',
                        IFNAME           => 'GigabitEthernet 3/46',
                        IFDESCR          => 'GigabitEthernet 3/46',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:63',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626422) 12 days, 22:04:24.22',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '146850816',
                        IFNAME           => 'GigabitEthernet 3/47',
                        IFDESCR          => 'GigabitEthernet 3/47',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9c:64',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(111626422) 12 days, 22:04:24.22',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '168084480',
                        IFNAME           => 'GigabitEthernet 4/0',
                        IFDESCR          => 'GigabitEthernet 4/0',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:15',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26350) 0:04:23.50',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '168346624',
                        IFNAME           => 'GigabitEthernet 4/1',
                        IFDESCR          => 'GigabitEthernet 4/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:16',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26350) 0:04:23.50',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '168608768',
                        IFNAME           => 'GigabitEthernet 4/2',
                        IFDESCR          => 'GigabitEthernet 4/2',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:17',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26350) 0:04:23.50',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '168870912',
                        IFNAME           => 'GigabitEthernet 4/3',
                        IFDESCR          => 'GigabitEthernet 4/3',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:18',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26350) 0:04:23.50',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '169133056',
                        IFNAME           => 'GigabitEthernet 4/4',
                        IFDESCR          => 'GigabitEthernet 4/4',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:19',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26350) 0:04:23.50',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '169395200',
                        IFNAME           => 'GigabitEthernet 4/5',
                        IFDESCR          => 'GigabitEthernet 4/5',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:1a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26350) 0:04:23.50',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '169657344',
                        IFNAME           => 'GigabitEthernet 4/6',
                        IFDESCR          => 'GigabitEthernet 4/6',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:1b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26350) 0:04:23.50',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '169919488',
                        IFNAME           => 'GigabitEthernet 4/7',
                        IFDESCR          => 'GigabitEthernet 4/7',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:1c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26350) 0:04:23.50',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '170181632',
                        IFNAME           => 'GigabitEthernet 4/8',
                        IFDESCR          => 'GigabitEthernet 4/8',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:1d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26350) 0:04:23.50',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '170443776',
                        IFNAME           => 'GigabitEthernet 4/9',
                        IFDESCR          => 'GigabitEthernet 4/9',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:1e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26350) 0:04:23.50',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '170705920',
                        IFNAME           => 'GigabitEthernet 4/10',
                        IFDESCR          => 'GigabitEthernet 4/10',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:1f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26350) 0:04:23.50',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '170968064',
                        IFNAME           => 'GigabitEthernet 4/11',
                        IFDESCR          => 'GigabitEthernet 4/11',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:20',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26352) 0:04:23.52',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '171230208',
                        IFNAME           => 'GigabitEthernet 4/12',
                        IFDESCR          => 'GigabitEthernet 4/12',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:21',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26352) 0:04:23.52',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '171492352',
                        IFNAME           => 'GigabitEthernet 4/13',
                        IFDESCR          => 'GigabitEthernet 4/13',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:22',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26352) 0:04:23.52',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '171754496',
                        IFNAME           => 'GigabitEthernet 4/14',
                        IFDESCR          => 'GigabitEthernet 4/14',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:23',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26352) 0:04:23.52',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '172016640',
                        IFNAME           => 'GigabitEthernet 4/15',
                        IFDESCR          => 'GigabitEthernet 4/15',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:24',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26352) 0:04:23.52',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '172278784',
                        IFNAME           => 'GigabitEthernet 4/16',
                        IFDESCR          => 'GigabitEthernet 4/16',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:25',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26352) 0:04:23.52',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '172540928',
                        IFNAME           => 'GigabitEthernet 4/17',
                        IFDESCR          => 'GigabitEthernet 4/17',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:26',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26352) 0:04:23.52',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '172803072',
                        IFNAME           => 'GigabitEthernet 4/18',
                        IFDESCR          => 'GigabitEthernet 4/18',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:27',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26352) 0:04:23.52',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '173065216',
                        IFNAME           => 'GigabitEthernet 4/19',
                        IFDESCR          => 'GigabitEthernet 4/19',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:28',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26352) 0:04:23.52',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '173327360',
                        IFNAME           => 'GigabitEthernet 4/20',
                        IFDESCR          => 'GigabitEthernet 4/20',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:29',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26352) 0:04:23.52',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '173589504',
                        IFNAME           => 'GigabitEthernet 4/21',
                        IFDESCR          => 'GigabitEthernet 4/21',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:2a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26352) 0:04:23.52',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '173851648',
                        IFNAME           => 'GigabitEthernet 4/22',
                        IFDESCR          => 'GigabitEthernet 4/22',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:2b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26352) 0:04:23.52',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '174113792',
                        IFNAME           => 'GigabitEthernet 4/23',
                        IFDESCR          => 'GigabitEthernet 4/23',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:2c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26352) 0:04:23.52',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '174375936',
                        IFNAME           => 'GigabitEthernet 4/24',
                        IFDESCR          => 'GigabitEthernet 4/24',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:2d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26352) 0:04:23.52',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '174638080',
                        IFNAME           => 'GigabitEthernet 4/25',
                        IFDESCR          => 'GigabitEthernet 4/25',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:2e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26352) 0:04:23.52',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '174900224',
                        IFNAME           => 'GigabitEthernet 4/26',
                        IFDESCR          => 'GigabitEthernet 4/26',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:2f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(26352) 0:04:23.52',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '175162368',
                        IFNAME           => 'GigabitEthernet 4/27',
                        IFDESCR          => 'GigabitEthernet 4/27',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:30',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(26352) 0:04:23.52',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '175424512',
                        IFNAME           => 'GigabitEthernet 4/28',
                        IFDESCR          => 'GigabitEthernet 4/28',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:31',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(26352) 0:04:23.52',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '175686656',
                        IFNAME           => 'GigabitEthernet 4/29',
                        IFDESCR          => 'GigabitEthernet 4/29',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:32',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(26352) 0:04:23.52',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '175948800',
                        IFNAME           => 'GigabitEthernet 4/30',
                        IFDESCR          => 'GigabitEthernet 4/30',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:33',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(26352) 0:04:23.52',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '176210944',
                        IFNAME           => 'GigabitEthernet 4/31',
                        IFDESCR          => 'GigabitEthernet 4/31',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:34',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(26352) 0:04:23.52',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '176473088',
                        IFNAME           => 'GigabitEthernet 4/32',
                        IFDESCR          => 'GigabitEthernet 4/32',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:35',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(26352) 0:04:23.52',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '176735232',
                        IFNAME           => 'GigabitEthernet 4/33',
                        IFDESCR          => 'GigabitEthernet 4/33',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:36',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(26352) 0:04:23.52',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '176997376',
                        IFNAME           => 'GigabitEthernet 4/34',
                        IFDESCR          => 'GigabitEthernet 4/34',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:37',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(26352) 0:04:23.52',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '177259520',
                        IFNAME           => 'GigabitEthernet 4/35',
                        IFDESCR          => 'GigabitEthernet 4/35',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:38',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(26352) 0:04:23.52',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '177521664',
                        IFNAME           => 'GigabitEthernet 4/36',
                        IFDESCR          => 'GigabitEthernet 4/36',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:39',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26352) 0:04:23.52',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '177783808',
                        IFNAME           => 'GigabitEthernet 4/37',
                        IFDESCR          => 'GigabitEthernet 4/37',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:3a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26352) 0:04:23.52',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '178045952',
                        IFNAME           => 'GigabitEthernet 4/38',
                        IFDESCR          => 'GigabitEthernet 4/38',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:3b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26352) 0:04:23.52',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '178308096',
                        IFNAME           => 'GigabitEthernet 4/39',
                        IFDESCR          => 'GigabitEthernet 4/39',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:3c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26352) 0:04:23.52',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '178570240',
                        IFNAME           => 'GigabitEthernet 4/40',
                        IFDESCR          => 'GigabitEthernet 4/40',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:3d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26352) 0:04:23.52',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '178832384',
                        IFNAME           => 'GigabitEthernet 4/41',
                        IFDESCR          => 'GigabitEthernet 4/41',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:3e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26354) 0:04:23.54',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '179094528',
                        IFNAME           => 'GigabitEthernet 4/42',
                        IFDESCR          => 'GigabitEthernet 4/42',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:3f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26354) 0:04:23.54',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '179356672',
                        IFNAME           => 'GigabitEthernet 4/43',
                        IFDESCR          => 'GigabitEthernet 4/43',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:40',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26354) 0:04:23.54',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '179618816',
                        IFNAME           => 'GigabitEthernet 4/44',
                        IFDESCR          => 'GigabitEthernet 4/44',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:41',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26354) 0:04:23.54',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '179880960',
                        IFNAME           => 'GigabitEthernet 4/45',
                        IFDESCR          => 'GigabitEthernet 4/45',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:42',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26354) 0:04:23.54',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '180143104',
                        IFNAME           => 'GigabitEthernet 4/46',
                        IFDESCR          => 'GigabitEthernet 4/46',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:43',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26354) 0:04:23.54',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '180405248',
                        IFNAME           => 'GigabitEthernet 4/47',
                        IFDESCR          => 'GigabitEthernet 4/47',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:44',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26354) 0:04:23.54',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '201638912',
                        IFNAME           => 'GigabitEthernet 5/0',
                        IFDESCR          => 'GigabitEthernet 5/0',
                        IFALIAS          => 'cppbig37',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:f5',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27442) 0:04:34.42',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2012797719',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2986277307',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:ea:f8:94',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '201901056',
                        IFNAME           => 'GigabitEthernet 5/1',
                        IFDESCR          => 'GigabitEthernet 5/1',
                        IFALIAS          => 'cppbig38',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27458) 0:04:34.58',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3877941346',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2438282272',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e3:6e:20',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '202163200',
                        IFNAME           => 'GigabitEthernet 5/2',
                        IFDESCR          => 'GigabitEthernet 5/2',
                        IFALIAS          => 'cppbig39',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:f7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27444) 0:04:34.44',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3462579550',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2791100415',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:ea:77:48',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '202425344',
                        IFNAME           => 'GigabitEthernet 5/3',
                        IFDESCR          => 'GigabitEthernet 5/3',
                        IFALIAS          => 'cppbig40',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:f8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27466) 0:04:34.66',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1387607622',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3423212546',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:ea:38:f4',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '202687488',
                        IFNAME           => 'GigabitEthernet 5/4',
                        IFDESCR          => 'GigabitEthernet 5/4',
                        IFALIAS          => 'cppbig41',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:f9',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27468) 0:04:34.68',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1776909064',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4010244149',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:ea:f7:30',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '202949632',
                        IFNAME           => 'GigabitEthernet 5/5',
                        IFDESCR          => 'GigabitEthernet 5/5',
                        IFALIAS          => 'cppbig42',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:fa',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27492) 0:04:34.92',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1191635525',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2766276419',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '68:b5:99:c5:3f:d0',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '203211776',
                        IFNAME           => 'GigabitEthernet 5/6',
                        IFDESCR          => 'GigabitEthernet 5/6',
                        IFALIAS          => 'cppbig43',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:fb',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27492) 0:04:34.92',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3321003036',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1487423878',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '68:b5:99:c5:5d:80',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '203473920',
                        IFNAME           => 'GigabitEthernet 5/7',
                        IFDESCR          => 'GigabitEthernet 5/7',
                        IFALIAS          => 'cppbig44',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:fc',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(984403680) 113 days, 22:27:16.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4084280553',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '468660524',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '68:b5:99:c5:7c:30',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '203736064',
                        IFNAME           => 'GigabitEthernet 5/8',
                        IFDESCR          => 'GigabitEthernet 5/8',
                        IFALIAS          => 'cppbig45',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:fd',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27518) 0:04:35.18',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4053423759',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3910037470',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:ea:68:b8',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '203998208',
                        IFNAME           => 'GigabitEthernet 5/9',
                        IFDESCR          => 'GigabitEthernet 5/9',
                        IFALIAS          => 'cppbig46',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:fe',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(825296808) 95 days, 12:29:28.08',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4169344596',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '118178861',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:ea:a8:58',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '204260352',
                        IFNAME           => 'GigabitEthernet 5/10',
                        IFDESCR          => 'GigabitEthernet 5/10',
                        IFALIAS          => 'wwwbma76manage',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9d:ff',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1908360980) 220 days, 21:00:09.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '29981014',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '411267155',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '6c:3b:e5:b2:66:c8',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '204522496',
                        IFNAME           => 'GigabitEthernet 5/11',
                        IFDESCR          => 'GigabitEthernet 5/11',
                        IFALIAS          => 'wwwbma74manage',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1908540610) 220 days, 21:30:06.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '12188261',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '410948197',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '6c:3b:e5:b2:76:7e',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '204784640',
                        IFNAME           => 'GigabitEthernet 5/12',
                        IFDESCR          => 'GigabitEthernet 5/12',
                        IFALIAS          => 'wwwbma71manage',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:01',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1908241078) 220 days, 20:40:10.78',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '52804959',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '419648178',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '6c:3b:e5:b2:66:da',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '205046784',
                        IFNAME           => 'GigabitEthernet 5/13',
                        IFDESCR          => 'GigabitEthernet 5/13',
                        IFALIAS          => 'wwwbma75manage',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:02',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1908662796) 220 days, 21:50:27.96',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '12715263',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '411695772',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '6c:3b:e5:b2:66:a8',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '205308928',
                        IFNAME           => 'GigabitEthernet 5/14',
                        IFDESCR          => 'GigabitEthernet 5/14',
                        IFALIAS          => 'wwwbma72manage',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:03',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1908720802) 220 days, 22:00:08.02',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '47973228',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '413867635',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '6c:3b:e5:b2:77:2c',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '205571072',
                        IFNAME           => 'GigabitEthernet 5/15',
                        IFDESCR          => 'GigabitEthernet 5/15',
                        IFALIAS          => 'wwwbma73manage',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:04',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1908600956) 220 days, 21:40:09.56',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '36102548',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '412279118',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '6c:3b:e5:b2:86:d8',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '205833216',
                        IFNAME           => 'GigabitEthernet 5/16',
                        IFDESCR          => 'GigabitEthernet 5/16',
                        IFALIAS          => 'wwwbma78manage',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:05',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1908661274) 220 days, 21:50:12.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '34336267',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '411615180',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '6c:3b:e5:b2:77:da',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '206095360',
                        IFNAME           => 'GigabitEthernet 5/17',
                        IFDESCR          => 'GigabitEthernet 5/17',
                        IFALIAS          => 'wwwbma77manage',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:06',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1908722966) 220 days, 22:00:29.66',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '33184773',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '411569433',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '6c:3b:e5:b2:67:ba',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '206357504',
                        IFNAME           => 'GigabitEthernet 5/18',
                        IFDESCR          => 'GigabitEthernet 5/18',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:07',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2336270350) 270 days, 9:38:23.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '22432448',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '443619516',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '90:b1:1c:57:0c:b4',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '206619648',
                        IFNAME           => 'GigabitEthernet 5/19',
                        IFDESCR          => 'GigabitEthernet 5/19',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:08',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26412) 0:04:24.12',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '206881792',
                        IFNAME           => 'GigabitEthernet 5/20',
                        IFDESCR          => 'GigabitEthernet 5/20',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:09',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26412) 0:04:24.12',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '207143936',
                        IFNAME           => 'GigabitEthernet 5/21',
                        IFDESCR          => 'GigabitEthernet 5/21',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:0a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26412) 0:04:24.12',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '207406080',
                        IFNAME           => 'GigabitEthernet 5/22',
                        IFDESCR          => 'GigabitEthernet 5/22',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:0b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26412) 0:04:24.12',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '207668224',
                        IFNAME           => 'GigabitEthernet 5/23',
                        IFDESCR          => 'GigabitEthernet 5/23',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:0c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26412) 0:04:24.12',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '207930368',
                        IFNAME           => 'GigabitEthernet 5/24',
                        IFDESCR          => 'GigabitEthernet 5/24',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:0d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26412) 0:04:24.12',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '208192512',
                        IFNAME           => 'GigabitEthernet 5/25',
                        IFDESCR          => 'GigabitEthernet 5/25',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:0e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26412) 0:04:24.12',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '208454656',
                        IFNAME           => 'GigabitEthernet 5/26',
                        IFDESCR          => 'GigabitEthernet 5/26',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:0f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26412) 0:04:24.12',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '208716800',
                        IFNAME           => 'GigabitEthernet 5/27',
                        IFDESCR          => 'GigabitEthernet 5/27',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:10',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26412) 0:04:24.12',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '208978944',
                        IFNAME           => 'GigabitEthernet 5/28',
                        IFDESCR          => 'GigabitEthernet 5/28',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:11',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26412) 0:04:24.12',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '209241088',
                        IFNAME           => 'GigabitEthernet 5/29',
                        IFDESCR          => 'GigabitEthernet 5/29',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:12',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26412) 0:04:24.12',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '209503232',
                        IFNAME           => 'GigabitEthernet 5/30',
                        IFDESCR          => 'GigabitEthernet 5/30',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:13',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26412) 0:04:24.12',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '209765376',
                        IFNAME           => 'GigabitEthernet 5/31',
                        IFDESCR          => 'GigabitEthernet 5/31',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:14',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26412) 0:04:24.12',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '210027520',
                        IFNAME           => 'GigabitEthernet 5/32',
                        IFDESCR          => 'GigabitEthernet 5/32',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:15',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26412) 0:04:24.12',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '210289664',
                        IFNAME           => 'GigabitEthernet 5/33',
                        IFDESCR          => 'GigabitEthernet 5/33',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:16',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26412) 0:04:24.12',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '210551808',
                        IFNAME           => 'GigabitEthernet 5/34',
                        IFDESCR          => 'GigabitEthernet 5/34',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:17',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26412) 0:04:24.12',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '210813952',
                        IFNAME           => 'GigabitEthernet 5/35',
                        IFDESCR          => 'GigabitEthernet 5/35',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:18',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26412) 0:04:24.12',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '211076096',
                        IFNAME           => 'GigabitEthernet 5/36',
                        IFDESCR          => 'GigabitEthernet 5/36',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:19',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26412) 0:04:24.12',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '211338240',
                        IFNAME           => 'GigabitEthernet 5/37',
                        IFDESCR          => 'GigabitEthernet 5/37',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:1a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26412) 0:04:24.12',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '211600384',
                        IFNAME           => 'GigabitEthernet 5/38',
                        IFDESCR          => 'GigabitEthernet 5/38',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:1b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2405317344) 278 days, 9:26:13.44',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '823137',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '26176722',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '74:86:7a:e5:56:c8',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '211862528',
                        IFNAME           => 'GigabitEthernet 5/39',
                        IFDESCR          => 'GigabitEthernet 5/39',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:1c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2405075298) 278 days, 8:45:52.98',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4018155',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '26928831',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '74:86:7a:e9:9a:bc',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '212124672',
                        IFNAME           => 'GigabitEthernet 5/40',
                        IFDESCR          => 'GigabitEthernet 5/40',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:1d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2405380412) 278 days, 9:36:44.12',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1432843758',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '41207703',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'c8:1f:66:d2:16:c0',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '212386816',
                        IFNAME           => 'GigabitEthernet 5/41',
                        IFDESCR          => 'GigabitEthernet 5/41',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:1e',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2405233628) 278 days, 9:12:16.28',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '459299',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '26165276',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '74:86:7a:e5:55:dc',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '212648960',
                        IFNAME           => 'GigabitEthernet 5/42',
                        IFDESCR          => 'GigabitEthernet 5/42',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:1f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2405269720) 278 days, 9:18:17.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '960695602',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3198376270',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'c8:1f:66:d1:c9:d6',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '212911104',
                        IFNAME           => 'GigabitEthernet 5/43',
                        IFDESCR          => 'GigabitEthernet 5/43',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:20',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2405161950) 278 days, 9:00:19.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3172960171',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3351730834',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'c8:1f:66:d1:c3:3b',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '213173248',
                        IFNAME           => 'GigabitEthernet 5/44',
                        IFDESCR          => 'GigabitEthernet 5/44',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:21',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2398649204) 277 days, 14:54:52.04',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1741307079',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '655001183',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'c8:1f:66:d2:1b:c3',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '213435392',
                        IFNAME           => 'GigabitEthernet 5/45',
                        IFDESCR          => 'GigabitEthernet 5/45',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:22',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2405547124) 278 days, 10:04:31.24',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1971138140',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '3571561446',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'c8:1f:66:d2:0f:41',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '213697536',
                        IFNAME           => 'GigabitEthernet 5/46',
                        IFDESCR          => 'GigabitEthernet 5/46',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:23',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2405424888) 278 days, 9:44:08.88',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2610571',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '26736860',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '74:86:7a:e9:99:c6',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '213959680',
                        IFNAME           => 'GigabitEthernet 5/47',
                        IFDESCR          => 'GigabitEthernet 5/47',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:24',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2398633436) 277 days, 14:52:14.36',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '250262',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '25917221',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '74:86:7a:e9:99:84',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '235193344',
                        IFNAME           => 'GigabitEthernet 6/0',
                        IFDESCR          => 'GigabitEthernet 6/0',
                        IFALIAS          => 'www52',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:d5',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384396424) 160 days, 5:32:44.24',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2620885073',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '116460244',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:ee:4d:78',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '235455488',
                        IFNAME           => 'GigabitEthernet 6/1',
                        IFDESCR          => 'GigabitEthernet 6/1',
                        IFALIAS          => 'www53',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:d6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384396352) 160 days, 5:32:43.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '133229370',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3949740553',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:ee:5d:0c',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '235717632',
                        IFNAME           => 'GigabitEthernet 6/2',
                        IFDESCR          => 'GigabitEthernet 6/2',
                        IFALIAS          => 'www54',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:d7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1370557828) 158 days, 15:06:18.28',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2151815064',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1893251894',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:ee:7d:a0',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '235979776',
                        IFNAME           => 'GigabitEthernet 6/3',
                        IFDESCR          => 'GigabitEthernet 6/3',
                        IFALIAS          => 'www19',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:d8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1416742622) 163 days, 23:23:46.22',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1053795968',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '612655181',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:ee:cd:3c',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '236241920',
                        IFNAME           => 'GigabitEthernet 6/4',
                        IFDESCR          => 'GigabitEthernet 6/4',
                        IFALIAS          => 'www20',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:d9',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1402005086) 162 days, 6:27:30.86',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2174111064',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '84864674',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:ee:8d:70',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '236504064',
                        IFNAME           => 'GigabitEthernet 6/5',
                        IFDESCR          => 'GigabitEthernet 6/5',
                        IFALIAS          => 'www9',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:da',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1402634714) 162 days, 8:12:27.14',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1551463341',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1013939346',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:ee:4d:e8',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '236766208',
                        IFNAME           => 'GigabitEthernet 6/6',
                        IFDESCR          => 'GigabitEthernet 6/6',
                        IFALIAS          => 'photoscache',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:db',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2379294980) 275 days, 9:09:09.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4164122969',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1937787870',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:ee:cd:6c',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '237028352',
                        IFNAME           => 'GigabitEthernet 6/7',
                        IFDESCR          => 'GigabitEthernet 6/7',
                        IFALIAS          => 'photoscache',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:dc',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2378943302) 275 days, 8:10:33.02',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3167350500',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '570178698',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:eb:93:a4',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '237290496',
                        IFNAME           => 'GigabitEthernet 6/8',
                        IFDESCR          => 'GigabitEthernet 6/8',
                        IFALIAS          => 'photoscache',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:dd',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2181000450) 252 days, 10:20:04.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2703634924',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2692632369',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:ee:5d:38',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '237552640',
                        IFNAME           => 'GigabitEthernet 6/9',
                        IFDESCR          => 'GigabitEthernet 6/9',
                        IFALIAS          => 'photoscache',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:de',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2181112176) 252 days, 10:38:41.76',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1879007806',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '469965831',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:ee:2d:a8',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '237814784',
                        IFNAME           => 'GigabitEthernet 6/10',
                        IFDESCR          => 'GigabitEthernet 6/10',
                        IFALIAS          => 'scripts38',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:df',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27606) 0:04:36.06',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3420323702',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2450489765',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:f4:33:c0',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '238076928',
                        IFNAME           => 'GigabitEthernet 6/11',
                        IFDESCR          => 'GigabitEthernet 6/11',
                        IFALIAS          => 'scripts39',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:e0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2373862042) 274 days, 18:03:40.42',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2243904695',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1050670299',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:eb:13:dc',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '238339072',
                        IFNAME           => 'GigabitEthernet 6/12',
                        IFDESCR          => 'GigabitEthernet 6/12',
                        IFALIAS          => 'scripts40',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:e1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1523241012) 176 days, 7:13:30.12',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3439324571',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1255134365',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:f4:c2:88',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '238601216',
                        IFNAME           => 'GigabitEthernet 6/13',
                        IFDESCR          => 'GigabitEthernet 6/13',
                        IFALIAS          => 'scripts41',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:e2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1542311126) 178 days, 12:11:51.26',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1026074770',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '2733913187',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:f4:23:30',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '238863360',
                        IFNAME           => 'GigabitEthernet 6/14',
                        IFDESCR          => 'GigabitEthernet 6/14',
                        IFALIAS          => 'scripts42',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:e3',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27662) 0:04:36.62',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2341115372',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3819303164',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:f4:13:54',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '239125504',
                        IFNAME           => 'GigabitEthernet 6/15',
                        IFDESCR          => 'GigabitEthernet 6/15',
                        IFALIAS          => 'scripts43',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:e4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2373860918) 274 days, 18:03:29.18',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '823515315',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '3444146939',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:f4:b1:70',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '239387648',
                        IFNAME           => 'GigabitEthernet 6/16',
                        IFDESCR          => 'GigabitEthernet 6/16',
                        IFALIAS          => 'scripts44',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:e5',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1470599036) 170 days, 4:59:50.36',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '233704781',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '278125430',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:f4:23:54',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '239649792',
                        IFNAME           => 'GigabitEthernet 6/17',
                        IFDESCR          => 'GigabitEthernet 6/17',
                        IFALIAS          => 'scripts45',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:e6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1850741604) 214 days, 4:56:56.04',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3574671869',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3716955214',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:f4:c1:a0',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '239911936',
                        IFNAME           => 'GigabitEthernet 6/18',
                        IFDESCR          => 'GigabitEthernet 6/18',
                        IFALIAS          => 'scripts46',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:e7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2364661212) 273 days, 16:30:12.12',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3967162213',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2444704044',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:f4:13:4c',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '240174080',
                        IFNAME           => 'GigabitEthernet 6/19',
                        IFDESCR          => 'GigabitEthernet 6/19',
                        IFALIAS          => 'scripts47',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:e8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1583974772) 183 days, 7:55:47.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1356523579',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2016273782',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:f3:1f:cc',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '240436224',
                        IFNAME           => 'GigabitEthernet 6/20',
                        IFDESCR          => 'GigabitEthernet 6/20',
                        IFALIAS          => 'scriptsbilling1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:e9',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27722) 0:04:37.22',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3145655273',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2951909740',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:eb:74:00',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '240698368',
                        IFNAME           => 'GigabitEthernet 6/21',
                        IFDESCR          => 'GigabitEthernet 6/21',
                        IFALIAS          => 'scriptsbilling2',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:ea',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27734) 0:04:37.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '37986318',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1848742552',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:f4:0a:dc',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '240960512',
                        IFNAME           => 'GigabitEthernet 6/22',
                        IFDESCR          => 'GigabitEthernet 6/22',
                        IFALIAS          => 'scriptsbilling3',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:eb',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27734) 0:04:37.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2797646093',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2431417814',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:f4:e2:e8',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '241222656',
                        IFNAME           => 'GigabitEthernet 6/23',
                        IFDESCR          => 'GigabitEthernet 6/23',
                        IFALIAS          => 'unreg1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:ec',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27746) 0:04:37.46',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2216341362',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1024928758',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:70:63:94',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '241484800',
                        IFNAME           => 'GigabitEthernet 6/24',
                        IFDESCR          => 'GigabitEthernet 6/24',
                        IFALIAS          => 'unreg2',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:ed',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27748) 0:04:37.48',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '286963134',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2002047506',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:71:9c:c8',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '241746944',
                        IFNAME           => 'GigabitEthernet 6/25',
                        IFDESCR          => 'GigabitEthernet 6/25',
                        IFALIAS          => 'unreg3',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:ee',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27772) 0:04:37.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2208092771',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3707340373',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:70:5f:e8',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '242009088',
                        IFNAME           => 'GigabitEthernet 6/26',
                        IFDESCR          => 'GigabitEthernet 6/26',
                        IFALIAS          => 'unreg4',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:ef',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27784) 0:04:37.84',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3067061910',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2714510840',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:73:50:5e',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '242271232',
                        IFNAME           => 'GigabitEthernet 6/27',
                        IFDESCR          => 'GigabitEthernet 6/27',
                        IFALIAS          => 'unreg5',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:f0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27794) 0:04:37.94',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3193566814',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1269847365',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:6f:d0:62',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '242533376',
                        IFNAME           => 'GigabitEthernet 6/28',
                        IFDESCR          => 'GigabitEthernet 6/28',
                        IFALIAS          => 'unreg6',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:f1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27806) 0:04:38.06',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '118682766',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1030455287',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:73:52:8e',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '242795520',
                        IFNAME           => 'GigabitEthernet 6/29',
                        IFDESCR          => 'GigabitEthernet 6/29',
                        IFALIAS          => 'unreg7',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:f2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27828) 0:04:38.28',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2291509979',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3775972538',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:71:8c:ec',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '243057664',
                        IFNAME           => 'GigabitEthernet 6/30',
                        IFDESCR          => 'GigabitEthernet 6/30',
                        IFALIAS          => 'unreg8',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:f3',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27830) 0:04:38.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '272018363',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4126960867',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:73:52:52',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '243319808',
                        IFNAME           => 'GigabitEthernet 6/31',
                        IFDESCR          => 'GigabitEthernet 6/31',
                        IFALIAS          => 'scriptsbilling4',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:f4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27854) 0:04:38.54',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3811256251',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '67527328',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:f4:d2:04',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '243581952',
                        IFNAME           => 'GigabitEthernet 6/32',
                        IFDESCR          => 'GigabitEthernet 6/32',
                        IFALIAS          => 'scriptsbilling5',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:f5',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27854) 0:04:38.54',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2116542681',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3852842347',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:f4:a1:e8',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '243844096',
                        IFNAME           => 'GigabitEthernet 6/33',
                        IFDESCR          => 'GigabitEthernet 6/33',
                        IFALIAS          => 'scriptsbilling7',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2262857366) 261 days, 21:42:53.66',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1387899615',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1862925292',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:eb:92:ac',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '244106240',
                        IFNAME           => 'GigabitEthernet 6/34',
                        IFDESCR          => 'GigabitEthernet 6/34',
                        IFALIAS          => 'scriptsbilling6',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:f7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27892) 0:04:38.92',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3773564616',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3854683788',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:eb:64:30',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '244368384',
                        IFNAME           => 'GigabitEthernet 6/35',
                        IFDESCR          => 'GigabitEthernet 6/35',
                        IFALIAS          => 'scriptsbilling8',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:f8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27894) 0:04:38.94',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3383095893',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '486803903',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:f4:13:6c',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '244630528',
                        IFNAME           => 'GigabitEthernet 6/36',
                        IFDESCR          => 'GigabitEthernet 6/36',
                        IFALIAS          => 'rrdbilling1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:f9',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27906) 0:04:39.06',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3553584074',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3716081301',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '78:e7:d1:f7:24:9c',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '244892672',
                        IFNAME           => 'GigabitEthernet 6/37',
                        IFDESCR          => 'GigabitEthernet 6/37',
                        IFALIAS          => 'scriptsbilling10',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:fa',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27918) 0:04:39.18',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '218098473',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '420577894',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:eb:13:34',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '245154816',
                        IFNAME           => 'GigabitEthernet 6/38',
                        IFDESCR          => 'GigabitEthernet 6/38',
                        IFALIAS          => 'udb2manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:fb',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1784878970) 206 days, 13:59:49.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '32373098',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1827060498',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '78:e3:b5:08:5c:24',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '245416960',
                        IFNAME           => 'GigabitEthernet 6/39',
                        IFDESCR          => 'GigabitEthernet 6/39',
                        IFALIAS          => 'udb2',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:fc',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1788351516) 206 days, 23:38:35.16',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1462844677',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '349319905',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '78:e3:b5:0d:40:74',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '245679104',
                        IFNAME           => 'GigabitEthernet 6/40',
                        IFDESCR          => 'GigabitEthernet 6/40',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:fd',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(26384) 0:04:23.84',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '245941248',
                        IFNAME           => 'GigabitEthernet 6/41',
                        IFDESCR          => 'GigabitEthernet 6/41',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:fe',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26384) 0:04:23.84',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '246203392',
                        IFNAME           => 'GigabitEthernet 6/42',
                        IFDESCR          => 'GigabitEthernet 6/42',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9e:ff',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(26384) 0:04:23.84',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '246465536',
                        IFNAME           => 'GigabitEthernet 6/43',
                        IFDESCR          => 'GigabitEthernet 6/43',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26384) 0:04:23.84',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '246727680',
                        IFNAME           => 'GigabitEthernet 6/44',
                        IFDESCR          => 'GigabitEthernet 6/44',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:01',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26384) 0:04:23.84',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '246989824',
                        IFNAME           => 'GigabitEthernet 6/45',
                        IFDESCR          => 'GigabitEthernet 6/45',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:02',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26384) 0:04:23.84',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '247251968',
                        IFNAME           => 'GigabitEthernet 6/46',
                        IFDESCR          => 'GigabitEthernet 6/46',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:03',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26384) 0:04:23.84',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '247514112',
                        IFNAME           => 'GigabitEthernet 6/47',
                        IFDESCR          => 'GigabitEthernet 6/47',
                        IFALIAS          => 'To sw-s50-5-tmk',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:04',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(26384) 0:04:23.84',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '268747776',
                        IFNAME           => 'GigabitEthernet 7/0',
                        IFDESCR          => 'GigabitEthernet 7/0',
                        IFALIAS          => 'cppbig27manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:b5',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1435461832) 166 days, 3:23:38.32',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '19499090',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1824079805',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:f8:b7:fa',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '269009920',
                        IFNAME           => 'GigabitEthernet 7/1',
                        IFDESCR          => 'GigabitEthernet 7/1',
                        IFALIAS          => 'cppbig28manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:b6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1435455622) 166 days, 3:22:36.22',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '18112330',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1822187945',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:f8:a7:7c',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '269272064',
                        IFNAME           => 'GigabitEthernet 7/2',
                        IFDESCR          => 'GigabitEthernet 7/2',
                        IFALIAS          => 'cppbig29manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:b7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1435450214) 166 days, 3:21:42.14',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '19683000',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1824119643',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:f8:97:7a',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '269534208',
                        IFNAME           => 'GigabitEthernet 7/3',
                        IFDESCR          => 'GigabitEthernet 7/3',
                        IFALIAS          => 'cppbig30manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2226263948) 257 days, 16:03:59.48',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '15539493',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1565591001',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:f8:b7:52',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '269796352',
                        IFNAME           => 'GigabitEthernet 7/4',
                        IFDESCR          => 'GigabitEthernet 7/4',
                        IFALIAS          => 'cppbig31manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:b9',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1435329564) 166 days, 3:01:35.64',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '19717937',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1824409358',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:f8:87:c6',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '270058496',
                        IFNAME           => 'GigabitEthernet 7/5',
                        IFDESCR          => 'GigabitEthernet 7/5',
                        IFALIAS          => 'cppbig32manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:ba',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1435408464) 166 days, 3:14:44.64',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '21037605',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1825107080',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e7:22:78',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '270320640',
                        IFNAME           => 'GigabitEthernet 7/6',
                        IFDESCR          => 'GigabitEthernet 7/6',
                        IFALIAS          => 'cppbig33manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:bb',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1435317170) 166 days, 2:59:31.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '22041096',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1825688536',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e7:12:d2',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '270582784',
                        IFNAME           => 'GigabitEthernet 7/7',
                        IFDESCR          => 'GigabitEthernet 7/7',
                        IFALIAS          => 'cppbig34manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:bc',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1435312352) 166 days, 2:58:43.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '18221439',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1829891209',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e7:22:42',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '270844928',
                        IFNAME           => 'GigabitEthernet 7/8',
                        IFDESCR          => 'GigabitEthernet 7/8',
                        IFALIAS          => 'cppbig35manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:bd',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2263166612) 261 days, 22:34:26.12',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '19479816',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1824072596',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e7:12:fe',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '271107072',
                        IFNAME           => 'GigabitEthernet 7/9',
                        IFDESCR          => 'GigabitEthernet 7/9',
                        IFALIAS          => 'cppbig36manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:be',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2263099224) 261 days, 22:23:12.24',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '20019238',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1803243404',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e7:12:d8',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '271369216',
                        IFNAME           => 'GigabitEthernet 7/10',
                        IFDESCR          => 'GigabitEthernet 7/10',
                        IFALIAS          => 'cppbig37manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:bf',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1435468162) 166 days, 3:24:41.62',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '18279158',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1823082144',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e6:f5:80',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '271631360',
                        IFNAME           => 'GigabitEthernet 7/11',
                        IFDESCR          => 'GigabitEthernet 7/11',
                        IFALIAS          => 'cppbig38manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1435461284) 166 days, 3:23:32.84',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '18124432',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1822950801',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e2:f6:c8',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '271893504',
                        IFNAME           => 'GigabitEthernet 7/12',
                        IFDESCR          => 'GigabitEthernet 7/12',
                        IFALIAS          => 'cppbig39manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:c1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1435455576) 166 days, 3:22:35.76',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '18130446',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1822898121',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e6:06:70',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '272155648',
                        IFNAME           => 'GigabitEthernet 7/13',
                        IFDESCR          => 'GigabitEthernet 7/13',
                        IFALIAS          => 'cppbig40manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:c2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1435341798) 166 days, 3:03:37.98',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '18205286',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1823027754',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e6:05:7c',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '272417792',
                        IFNAME           => 'GigabitEthernet 7/14',
                        IFDESCR          => 'GigabitEthernet 7/14',
                        IFALIAS          => 'cppbig41manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:c3',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1435335310) 166 days, 3:02:33.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '18205376',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1823018124',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e6:06:be',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '272679936',
                        IFNAME           => 'GigabitEthernet 7/15',
                        IFDESCR          => 'GigabitEthernet 7/15',
                        IFALIAS          => 'cppbig42manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:c4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1435329396) 166 days, 3:01:33.96',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '18210364',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1822959211',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e2:c2:4e',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '272942080',
                        IFNAME           => 'GigabitEthernet 7/16',
                        IFDESCR          => 'GigabitEthernet 7/16',
                        IFALIAS          => 'cppbig43manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:c5',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1435322598) 166 days, 3:00:25.98',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '18354898',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1823156802',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e2:60:56',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '273204224',
                        IFNAME           => 'GigabitEthernet 7/17',
                        IFDESCR          => 'GigabitEthernet 7/17',
                        IFALIAS          => 'cppbig44manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:c6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1435316420) 166 days, 2:59:24.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '21043480',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1825531288',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e1:2c:f8',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '273466368',
                        IFNAME           => 'GigabitEthernet 7/18',
                        IFDESCR          => 'GigabitEthernet 7/18',
                        IFALIAS          => 'cppbig45manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:c7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1435311172) 166 days, 2:58:31.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '18172285',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1822920610',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e6:16:40',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '273728512',
                        IFNAME           => 'GigabitEthernet 7/19',
                        IFDESCR          => 'GigabitEthernet 7/19',
                        IFALIAS          => 'cppbig46manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:c8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1435306262) 166 days, 2:57:42.62',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '25004620',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1826534729',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e6:f5:22',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '273990656',
                        IFNAME           => 'GigabitEthernet 7/20',
                        IFDESCR          => 'GigabitEthernet 7/20',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:c9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26442) 0:04:24.42',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '274252800',
                        IFNAME           => 'GigabitEthernet 7/21',
                        IFDESCR          => 'GigabitEthernet 7/21',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:ca',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(26442) 0:04:24.42',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '274514944',
                        IFNAME           => 'GigabitEthernet 7/22',
                        IFDESCR          => 'GigabitEthernet 7/22',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:cb',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(1906982676) 220 days, 17:10:26.76',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '7821',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '164220',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '274777088',
                        IFNAME           => 'GigabitEthernet 7/23',
                        IFDESCR          => 'GigabitEthernet 7/23',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:cc',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1906916290) 220 days, 16:59:22.90',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1980',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '275039232',
                        IFNAME           => 'GigabitEthernet 7/24',
                        IFDESCR          => 'GigabitEthernet 7/24',
                        IFALIAS          => 'wwwbma75',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:cd',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1918199656) 222 days, 0:19:56.56',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1233829202',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2492520397',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '6c:3b:e5:b3:81:38',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '275301376',
                        IFNAME           => 'GigabitEthernet 7/25',
                        IFDESCR          => 'GigabitEthernet 7/25',
                        IFALIAS          => 'wwwbma79manage',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:ce',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1908448716) 220 days, 21:14:47.16',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '29402984',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '411750414',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '6c:3b:e5:b2:66:a0',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '275563520',
                        IFNAME           => 'GigabitEthernet 7/26',
                        IFDESCR          => 'GigabitEthernet 7/26',
                        IFALIAS          => 'wwwbma76',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:cf',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1912232886) 221 days, 7:45:28.86',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '671263555',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2500477623',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '6c:3b:e5:b3:81:f4',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '275825664',
                        IFNAME           => 'GigabitEthernet 7/27',
                        IFDESCR          => 'GigabitEthernet 7/27',
                        IFALIAS          => 'wwwbma78',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1912232638) 221 days, 7:45:26.38',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3661073198',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '434576219',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '6c:3b:e5:b3:a1:98',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '276087808',
                        IFNAME           => 'GigabitEthernet 7/28',
                        IFDESCR          => 'GigabitEthernet 7/28',
                        IFALIAS          => 'wwwbma74',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:d1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1912232568) 221 days, 7:45:25.68',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2215391476',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4271041239',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '6c:3b:e5:b3:d1:a0',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '276349952',
                        IFNAME           => 'GigabitEthernet 7/29',
                        IFDESCR          => 'GigabitEthernet 7/29',
                        IFALIAS          => 'wwwbma77',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:d2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1912232460) 221 days, 7:45:24.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '383599542',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '370616094',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '6c:3b:e5:b3:23:ec',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '276612096',
                        IFNAME           => 'GigabitEthernet 7/30',
                        IFDESCR          => 'GigabitEthernet 7/30',
                        IFALIAS          => 'wwwbma71',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:d3',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1912112222) 221 days, 7:25:22.22',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3222474603',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1638092029',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '6c:3b:e5:b3:71:fc',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '276874240',
                        IFNAME           => 'GigabitEthernet 7/31',
                        IFDESCR          => 'GigabitEthernet 7/31',
                        IFALIAS          => 'wwwbma73',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:d4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1912232368) 221 days, 7:45:23.68',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1351433032',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4256930572',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '6c:3b:e5:b3:91:d0',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '277136384',
                        IFNAME           => 'GigabitEthernet 7/32',
                        IFDESCR          => 'GigabitEthernet 7/32',
                        IFALIAS          => 'wwwbma80manage',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:d5',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1908542000) 220 days, 21:30:20.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '18128598',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '411872529',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '6c:3b:e5:b2:77:12',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '277398528',
                        IFNAME           => 'GigabitEthernet 7/33',
                        IFDESCR          => 'GigabitEthernet 7/33',
                        IFALIAS          => 'wwwbma72',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:d6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1912232412) 221 days, 7:45:24.12',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2037287625',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3546919474',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '6c:3b:e5:b3:23:5c',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '277660672',
                        IFNAME           => 'GigabitEthernet 7/34',
                        IFDESCR          => 'GigabitEthernet 7/34',
                        IFALIAS          => 'pdu2n0633',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:d7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2398643546) 277 days, 14:53:55.46',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '48162417',
                        IFINERRORS       => '3',
                        IFOUTOCTETS      => '2064868086',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '277922816',
                        IFNAME           => 'GigabitEthernet 7/35',
                        IFDESCR          => 'GigabitEthernet 7/35',
                        IFALIAS          => 'dbh15manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:d8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1435443548) 166 days, 3:20:35.48',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '58138505',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1807387235',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e7:12:e4',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '278184960',
                        IFNAME           => 'GigabitEthernet 7/36',
                        IFDESCR          => 'GigabitEthernet 7/36',
                        IFALIAS          => 'dbh16manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:d9',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1435436966) 166 days, 3:19:29.66',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '58155613',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1807521332',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e6:ad:6c',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '278447104',
                        IFNAME           => 'GigabitEthernet 7/37',
                        IFDESCR          => 'GigabitEthernet 7/37',
                        IFALIAS          => 'rrd2manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:da',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1435316558) 166 days, 2:59:25.58',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '18544112',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1756679333',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:73:78:70',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '278709248',
                        IFNAME           => 'GigabitEthernet 7/38',
                        IFDESCR          => 'GigabitEthernet 7/38',
                        IFALIAS          => 'rrd1manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:db',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1435323584) 166 days, 3:00:35.84',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '35158542',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1761235502',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:6f:d1:b4',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '278971392',
                        IFNAME           => 'GigabitEthernet 7/39',
                        IFDESCR          => 'GigabitEthernet 7/39',
                        IFALIAS          => 'stats2manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:dc',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1654275540) 191 days, 11:12:35.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '65127321',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2501536984',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '68:b5:99:6d:a3:7a',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '279233536',
                        IFNAME           => 'GigabitEthernet 7/40',
                        IFDESCR          => 'GigabitEthernet 7/40',
                        IFALIAS          => 'stats3manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:dd',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1482116648) 171 days, 12:59:26.48',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '59969446',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '2500405460',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '68:b5:99:6d:a5:f0',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '279495680',
                        IFNAME           => 'GigabitEthernet 7/41',
                        IFDESCR          => 'GigabitEthernet 7/41',
                        IFALIAS          => 'mail11manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:de',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1435413692) 166 days, 3:15:36.92',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '58362297',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2498628720',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e7:12:c2',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '279757824',
                        IFNAME           => 'GigabitEthernet 7/42',
                        IFDESCR          => 'GigabitEthernet 7/42',
                        IFALIAS          => 'mail12manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:df',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1435419778) 166 days, 3:16:37.78',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '58403006',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2498681395',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e7:12:fc',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '280019968',
                        IFNAME           => 'GigabitEthernet 7/43',
                        IFDESCR          => 'GigabitEthernet 7/43',
                        IFALIAS          => 'mail13manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:e0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1435425862) 166 days, 3:17:38.62',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '58506078',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2498743921',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e7:22:64',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '280282112',
                        IFNAME           => 'GigabitEthernet 7/44',
                        IFDESCR          => 'GigabitEthernet 7/44',
                        IFALIAS          => 'mail14manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:e1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1435431704) 166 days, 3:18:37.04',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '58431713',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2498826956',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e7:12:bc',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '280544256',
                        IFNAME           => 'GigabitEthernet 7/45',
                        IFDESCR          => 'GigabitEthernet 7/45',
                        IFALIAS          => 'mail15manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:e2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1435436552) 166 days, 3:19:25.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '58634072',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2498979612',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e7:12:c4',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '280806400',
                        IFNAME           => 'GigabitEthernet 7/46',
                        IFDESCR          => 'GigabitEthernet 7/46',
                        IFALIAS          => 'donotreply1manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:e3',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1435347844) 166 days, 3:04:38.44',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '61629172',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2502885797',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e7:22:00',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '281068544',
                        IFNAME           => 'GigabitEthernet 7/47',
                        IFDESCR          => 'GigabitEthernet 7/47',
                        IFALIAS          => 'donotreply2manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:9f:e4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1435342222) 166 days, 3:03:42.22',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '58359976',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2498466609',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e7:12:a6',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '302268616',
                        IFNAME           => 'ManagementEthernet 0/0',
                        IFDESCR          => 'ManagementEthernet 0/0',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:85:4f:43',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(22716) 0:03:47.16',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '335823048',
                        IFNAME           => 'ManagementEthernet 1/0',
                        IFDESCR          => 'ManagementEthernet 1/0',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:85:46:e1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(20963188) 2 days, 10:13:51.88',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107705856',
                        IFNAME           => 'NULL 0',
                        IFDESCR          => 'NULL 0',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(20260) 0:03:22.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107755029',
                        IFNAME           => 'Port-channel 21',
                        IFDESCR          => 'Port-channel 21',
                        IFALIAS          => 'To sw-ex8208-tmk',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:98',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504226) 217 days, 1:44:02.26',
                        IFINOCTETS       => '2863010999',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '790412324',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:5e:00:01:14',
                                    '00:01:d7:8a:76:0c',
                                    '00:01:d7:c2:03:c0',
                                    '00:01:d7:c5:3b:00',
                                    '00:0c:29:d6:b8:64',
                                    '00:0d:5d:01:51:53',
                                    '00:10:db:ff:10:01',
                                    '00:14:1b:33:1c:c0',
                                    '00:14:4f:49:d2:62',
                                    '00:19:07:db:18:00',
                                    '00:19:55:cd:ac:11',
                                    '00:1a:6d:09:8f:32',
                                    '00:1a:e3:31:fc:11',
                                    '00:1c:0f:48:1c:41',
                                    '00:1c:0f:48:4d:32',
                                    '00:23:e9:54:7a:01',
                                    '00:23:e9:54:7b:01',
                                    '00:09:0f:09:00:03',
                                    '00:09:0f:09:00:04',
                                    '00:09:0f:09:14:04',
                                    '78:19:f7:05:fa:01',
                                    '08:5b:0e:02:f6:eb',
                                    '08:5b:0e:1f:05:11',
                                    '00:10:db:ff:10:01',
                                    '78:e4:00:9e:49:1a',
                                    'c8:0a:a9:8f:9c:41',
                                    'd8:30:62:33:7f:e0',
                                    '00:14:4f:9a:3a:bf',
                                    '78:19:f7:05:fa:01',
                                    '00:01:d7:8a:76:1a',
                                    '00:0c:29:7d:c6:9f',
                                    '00:14:4f:9a:c0:90',
                                    '78:19:f7:05:fa:01',
                                    '78:19:f7:05:fa:18',
                                    '3c:4a:92:ee:8d:c8',
                                    '00:10:db:ff:10:01',
                                    '00:14:4f:3a:51:ba',
                                    '00:14:4f:3a:51:d5',
                                    '78:19:f7:05:fa:01',
                                    '78:e7:d1:fa:52:6a',
                                    '78:19:f7:05:fa:01',
                                    '3c:4a:92:e6:ad:6a',
                                    '3c:4a:92:e6:ad:76',
                                    '3c:4a:92:e6:cd:92',
                                    '3c:4a:92:e6:cd:2c',
                                    '3c:4a:92:f8:91:82',
                                    '3c:4a:92:f8:91:e0',
                                    '3c:4a:92:f8:a1:94',
                                    '3c:4a:92:f8:a1:5c',
                                    '3c:4a:92:f8:a6:c8',
                                    '00:0c:29:f0:e6:ea',
                                    '00:10:db:ff:10:01',
                                    '00:a0:b8:2a:af:92',
                                    '00:a0:b8:2a:af:a2',
                                    '00:a0:b8:2a:e2:9c',
                                    '00:a0:b8:2a:e2:a8',
                                    '00:a0:b8:2a:23:02',
                                    '00:a0:b8:2a:23:18',
                                    '00:a0:b8:33:65:e2',
                                    '00:a0:b8:33:67:06',
                                    '00:a0:b8:33:6d:da',
                                    '00:a0:b8:48:d2:c4',
                                    '00:a0:b8:48:ee:a0',
                                    '00:a0:b8:56:03:20',
                                    '00:14:1b:33:1c:c0',
                                    '00:14:4f:01:f4:1a',
                                    '00:14:4f:3a:52:16',
                                    '00:1a:6c:f9:ab:b2',
                                    '00:1a:6d:09:8f:00',
                                    '00:1a:6d:09:5d:b2',
                                    '00:1c:0f:48:1c:32',
                                    '00:1c:0f:48:4d:00',
                                    '00:40:8c:7d:24:18',
                                    '00:40:8c:7d:24:26',
                                    '00:40:8c:84:b1:b0',
                                    '00:40:8c:9e:d9:60',
                                    '00:40:8c:ab:82:95',
                                    '78:19:f7:05:fa:01',
                                    '9c:8e:99:2b:07:d4',
                                    '00:14:4f:81:30:1c',
                                    '00:14:4f:d6:bd:29',
                                    '00:14:4f:e6:41:46',
                                    '00:14:4f:f7:ba:2d',
                                    '00:14:4f:3a:46:56',
                                    '00:14:4f:3a:4b:3b',
                                    '00:14:4f:3a:4c:70',
                                    '00:14:4f:3a:52:55',
                                    '00:19:07:db:18:00',
                                    '00:1b:24:3d:f7:06',
                                    '00:21:28:46:80:e2',
                                    '64:31:50:4b:7d:48',
                                    '64:31:50:50:e8:1e',
                                    '64:31:50:51:6d:5c',
                                    '64:31:50:51:a6:46',
                                    '64:31:50:51:c0:ae',
                                    '64:31:50:51:c9:28',
                                    '64:31:50:51:c9:50',
                                    '64:31:50:51:cb:9e',
                                    '64:31:50:51:cb:bc',
                                    '64:31:50:51:cb:ee',
                                    '64:31:50:51:ce:32',
                                    '64:31:50:51:dd:64',
                                    '64:31:50:51:f6:14',
                                    '64:31:50:51:45:7a',
                                    '64:31:50:51:48:a4',
                                    '64:31:50:51:60:3c',
                                    '64:31:50:51:61:c2',
                                    '68:b5:99:6d:a8:8e',
                                    '68:b5:99:6e:d0:b0',
                                    '68:b5:99:6e:d1:96',
                                    '68:b5:99:6f:d0:a0',
                                    '68:b5:99:70:75:3c',
                                    '68:b5:99:70:93:c8',
                                    '68:b5:99:70:c3:3e',
                                    '68:b5:99:70:60:42',
                                    '68:b5:99:71:97:aa',
                                    '68:b5:99:71:c7:ca',
                                    '74:86:7a:d0:da:1e',
                                    '78:e3:b5:18:cc:18',
                                    '78:e3:b5:1a:fc:4c',
                                    '78:e3:b5:08:6c:4c',
                                    '78:e7:d1:f5:66:76',
                                    '78:e7:d1:f5:66:14',
                                    '78:e7:d1:fa:d2:aa',
                                    '78:e7:d1:fa:42:f4',
                                    '78:19:f7:05:fa:01',
                                    '9c:8e:99:25:6c:76',
                                    '9c:8e:99:25:93:0a',
                                    '9c:8e:99:25:ac:38',
                                    '9c:8e:99:25:b9:44',
                                    '9c:8e:99:2b:07:d4',
                                    '9c:8e:99:2f:bc:aa',
                                    '9c:8e:99:2f:bc:58',
                                    'd4:85:64:6b:98:6c',
                                    'd4:85:64:6c:56:94',
                                    'd8:d3:85:fe:2b:d4',
                                    'e4:11:5b:ce:70:b6',
                                    'e8:39:35:ec:15:64',
                                    'e8:39:35:ec:1b:c8',
                                    'e8:39:35:ec:1c:c0',
                                    'e8:39:35:ec:1d:76',
                                    'e8:39:35:ec:1d:82',
                                    'e8:39:35:ec:1d:30',
                                    'e8:39:35:ec:1e:94',
                                    '18:a9:05:c5:6b:24',
                                    '1c:c1:de:e9:cc:fa',
                                    '44:1e:a1:58:6a:d8',
                                    '44:1e:a1:58:07:3c',
                                    '00:01:d7:8a:76:0b',
                                    '00:01:d7:8a:76:0c',
                                    '00:10:db:ff:10:01',
                                    '6c:3b:e5:a7:74:42',
                                    '6c:3b:e5:b2:66:4c',
                                    '6c:3b:e5:b4:68:c6',
                                    '6c:3b:e5:b4:68:d0',
                                    '6c:3b:e5:b4:78:28',
                                    '6c:3b:e5:b4:a8:cc',
                                    '74:86:7a:d0:da:d8',
                                    '74:86:7a:d0:dc:04',
                                    '74:86:7a:d0:dc:40',
                                    '74:86:7a:d0:dc:08',
                                    '74:86:7a:d0:dd:06',
                                    '74:86:7a:d7:ad:42',
                                    '78:19:f7:05:fa:01',
                                    '9c:8e:99:2b:07:d4',
                                    'd8:9d:67:5c:0e:2e',
                                    '00:14:4f:79:25:3c',
                                    '00:14:4f:79:2c:c4',
                                    '00:03:ba:cd:6c:79',
                                    '00:03:ba:cd:6c:7a',
                                    '00:03:ba:cd:6c:8d',
                                    '00:03:ba:cd:6c:a4',
                                    '00:03:ba:cd:6c:2a',
                                    '00:03:ba:cd:6d:7b',
                                    '00:03:ba:cd:6d:83',
                                    '00:03:ba:cd:6d:cc',
                                    '00:03:ba:cd:6d:e1',
                                    '00:03:ba:cd:6e:17',
                                    '00:03:ba:cd:6e:34',
                                    '00:03:ba:cd:6e:48',
                                    '00:03:ba:cd:6f:e1',
                                    '00:03:ba:cd:70:74',
                                    '00:03:ba:cd:70:da',
                                    '00:03:ba:cd:70:e5',
                                    '00:03:ba:cd:70:e6',
                                    '00:03:ba:cd:71:87',
                                    '00:03:ba:cd:71:9b',
                                    '00:03:ba:cd:71:d3',
                                    '00:03:ba:cd:71:e3',
                                    '00:03:ba:cd:71:ff',
                                    '00:03:ba:cd:71:21',
                                    '00:03:ba:cd:72:0c',
                                    '00:03:ba:cd:72:9c',
                                    '00:03:ba:cd:72:e8',
                                    '00:03:ba:cd:72:ec',
                                    '00:03:ba:cd:72:f6',
                                    '00:03:ba:cd:72:4b',
                                    '00:03:ba:cd:75:83',
                                    '00:03:ba:cd:7a:a7',
                                    '00:03:ba:cd:7a:ad',
                                    '00:03:ba:cd:7a:c2',
                                    '00:03:ba:cd:7b:6c',
                                    '00:03:ba:cd:7b:6e',
                                    '00:03:ba:cd:7b:73',
                                    '00:03:ba:cd:7b:7f',
                                    '00:03:ba:cd:7b:9e',
                                    '00:03:ba:cd:7b:a8',
                                    '00:03:ba:cd:7b:af',
                                    '00:03:ba:cd:7b:b6',
                                    '00:03:ba:cd:7b:ba',
                                    '00:03:ba:cd:7b:c2',
                                    '00:03:ba:cd:7b:c8',
                                    '00:03:ba:cd:7b:d3',
                                    '00:03:ba:cd:7b:d8',
                                    '00:03:ba:cd:7b:da',
                                    '00:03:ba:cd:7b:e9',
                                    '00:03:ba:cd:7b:f2',
                                    '00:03:ba:cd:7b:fb',
                                    '00:03:ba:cd:7b:55',
                                    '00:03:ba:cd:7b:5a',
                                    '00:03:ba:cd:7b:5d',
                                    '00:03:ba:cd:7b:5e',
                                    '00:03:ba:cd:7c:b3',
                                    '00:03:ba:cd:7c:07',
                                    '6c:3b:e5:b2:86:ee',
                                    '6c:3b:e5:b2:37:76',
                                    '6c:3b:e5:b2:56:e6',
                                    '6c:3b:e5:b4:68:c6',
                                    '6c:3b:e5:b4:68:d0',
                                    '6c:3b:e5:b4:68:ee',
                                    '6c:3b:e5:b4:78:8e',
                                    '6c:3b:e5:b4:78:b6',
                                    '6c:3b:e5:b4:78:28',
                                    '6c:3b:e5:b4:98:44',
                                    '6c:3b:e5:b4:a8:80',
                                    '6c:3b:e5:b4:a8:cc',
                                    '74:86:7a:d0:db:cc',
                                    '74:86:7a:d0:db:fc',
                                    '74:86:7a:d1:98:2c',
                                    '74:86:7a:d1:9d:ae',
                                    '74:86:7a:d4:4e:5c',
                                    '74:86:7a:d7:a6:9c',
                                    '74:86:7a:d7:a6:da',
                                    '74:86:7a:d7:a7:84',
                                    '74:86:7a:d7:a7:4c',
                                    '74:86:7a:d7:ac:dc',
                                    '74:86:7a:d7:ac:ec',
                                    '74:86:7a:d7:ad:2e',
                                    '74:86:7a:d7:ad:4a',
                                    '74:86:7a:d7:ad:50',
                                    '74:86:7a:d7:b2:fc',
                                    '74:86:7a:d7:b3:9a',
                                    '74:86:7a:d7:b5:2a',
                                    '78:e7:d1:f5:66:02',
                                    '78:e7:d1:f5:66:e0',
                                    '78:e7:d1:f5:66:42',
                                    '78:e7:d1:f5:56:e0',
                                    '78:e7:d1:61:d2:98',
                                    '78:e7:d1:62:7e:9e',
                                    '78:e7:d1:62:7e:10',
                                    '78:e7:d1:62:7e:18',
                                    '78:e7:d1:62:3e:ac',
                                    '78:e7:d1:62:3e:c6',
                                    '78:19:f7:05:fa:01',
                                    '80:c1:6e:70:d6:fe',
                                    '80:c1:6e:70:e6:ea',
                                    '80:c1:6e:74:6a:2e',
                                    '80:c1:6e:74:6c:72',
                                    '80:c1:6e:74:7c:82',
                                    '80:c1:6e:74:7c:a0',
                                    '80:c1:6e:74:8a:36',
                                    '80:c1:6e:74:17:76',
                                    '80:c1:6e:74:07:20',
                                    '80:c1:6e:74:57:82',
                                    '9c:8e:99:18:8d:22',
                                    '9c:8e:99:19:7a:6c',
                                    '9c:8e:99:19:7a:44',
                                    '9c:8e:99:19:8a:9a',
                                    '9c:8e:99:19:96:b6',
                                    '9c:8e:99:19:b6:aa',
                                    '9c:8e:99:19:3a:68',
                                    '9c:8e:99:19:3a:0c',
                                    '9c:8e:99:19:58:7c',
                                    '9c:8e:99:19:5a:18',
                                    'b4:99:ba:05:7c:aa',
                                    'b4:99:ba:08:7f:fe',
                                    'd4:85:64:45:b3:fa',
                                    'd4:85:64:45:e3:04',
                                    'd4:85:64:45:f3:72',
                                    'd4:85:64:4b:8f:14',
                                    'd8:9d:67:5c:0e:2e',
                                    '1c:c1:de:e9:cc:7a',
                                    '1c:c1:de:e9:cc:80',
                                    '1c:c1:de:e9:cc:92',
                                    '1c:c1:de:e9:dc:22',
                                    '1c:c1:de:ea:a9:bc',
                                    '1c:c1:de:f1:0c:ae',
                                    '3c:4a:92:e1:ff:6e',
                                    '3c:4a:92:e1:3c:c2',
                                    '3c:4a:92:e2:92:18',
                                    '3c:4a:92:e2:92:4c',
                                    '3c:4a:92:e2:a2:16',
                                    '3c:4a:92:e2:b2:68',
                                    '3c:4a:92:e2:b2:a2',
                                    '3c:4a:92:e2:16:6e',
                                    '3c:4a:92:e2:16:7e',
                                    '3c:4a:92:e2:16:ae',
                                    '3c:4a:92:e2:16:38',
                                    '3c:4a:92:e2:16:3c',
                                    '3c:4a:92:e2:16:44',
                                    '3c:4a:92:e2:16:52',
                                    '3c:4a:92:e2:26:a2',
                                    '3c:4a:92:e2:36:12',
                                    '3c:4a:92:e2:06:ce',
                                    '3c:4a:92:e2:06:f2',
                                    '00:14:4f:81:2d:b6',
                                    '00:14:4f:81:2f:8a',
                                    '00:14:4f:81:32:03',
                                    '00:14:4f:9a:38:a0',
                                    '00:14:4f:9a:38:df',
                                    '00:14:4f:9a:38:ec',
                                    '00:14:4f:9a:38:36',
                                    '00:14:4f:9a:3b:be',
                                    '00:14:4f:9a:3f:68',
                                    '00:14:4f:3a:46:93',
                                    '00:14:4f:3a:46:5a',
                                    '00:14:4f:3a:47:9f',
                                    '00:14:4f:3a:47:ad',
                                    '00:14:4f:3a:47:e7',
                                    '00:14:4f:3a:47:44',
                                    '00:14:4f:3a:48:c7',
                                    '00:14:4f:3a:48:fa',
                                    '00:14:4f:3a:48:25',
                                    '00:14:4f:3a:48:58',
                                    '00:14:4f:3a:51:68',
                                    '00:14:4f:3a:51:d6',
                                    '00:14:4f:3a:51:e2',
                                    '00:14:4f:3a:51:e4',
                                    '00:14:4f:3a:51:e9',
                                    '00:14:4f:3a:51:f3',
                                    '00:14:4f:3a:51:5d',
                                    '00:14:4f:3a:52:26',
                                    '00:19:07:db:18:00',
                                    '00:03:ba:cd:7e:41',
                                    '6c:3b:e5:b2:66:4c',
                                    '6c:3b:e5:b2:86:ee',
                                    '6c:3b:e5:b2:37:76',
                                    '6c:3b:e5:b2:56:e6',
                                    '74:86:7a:d0:da:d8',
                                    '78:e7:d1:f5:66:20',
                                    '78:e7:d1:f5:66:24',
                                    '78:e7:d1:f5:66:3e',
                                    '78:e7:d1:f5:56:e8',
                                    '78:e7:d1:fa:52:06',
                                    '78:19:f7:05:fa:01',
                                    '10:60:4b:a1:47:48',
                                    '3c:4a:92:e2:cf:60',
                                    '3c:4a:92:e6:ad:38',
                                    '3c:4a:92:e6:bd:18',
                                    '3c:4a:92:e6:bd:f6',
                                    '3c:4a:92:f1:ca:46',
                                    '3c:4a:92:f8:91:70',
                                    '3c:4a:92:f8:91:80',
                                    '3c:4a:92:f8:91:84',
                                    '3c:4a:92:f8:91:8a',
                                    '3c:4a:92:f8:91:ac',
                                    '3c:4a:92:f8:91:3c',
                                    '3c:4a:92:f8:a1:7c',
                                    '3c:4a:92:f8:a1:1e',
                                    '00:c0:b7:79:85:25',
                                    '00:c0:b7:79:be:4a',
                                    '00:c0:b7:79:c0:ba',
                                    '00:c0:b7:94:0d:9f',
                                    '00:c0:b7:c7:d4:a0',
                                    '00:c0:b7:c7:d4:d8',
                                    '00:c0:b7:c8:91:38',
                                    '00:c0:b7:2d:26:6e',
                                    '00:c0:b7:2d:26:99',
                                    '00:c0:b7:2e:86:81',
                                    '00:c0:b7:2f:77:ef',
                                    '00:c0:b7:2f:78:c7',
                                    '00:c0:b7:2f:a9:df',
                                    '00:c0:b7:2f:cc:00',
                                    '00:c0:b7:30:a5:36',
                                    '00:c0:b7:52:b7:ea',
                                    '00:c0:b7:55:1b:19',
                                    '00:c0:b7:55:03:96',
                                    '00:c0:b7:55:1f:9c',
                                    '00:c0:b7:55:21:04',
                                    '00:c0:b7:55:04:6d',
                                    '00:c0:b7:55:04:70',
                                    '00:c0:b7:55:04:82',
                                    '00:c0:b7:55:08:29',
                                    '00:c0:b7:5a:ae:d4',
                                    '00:c0:b7:5a:af:2d',
                                    '00:c0:b7:5a:af:47',
                                    '00:c0:b7:5a:b8:07',
                                    '78:19:f7:05:fa:01',
                                    '9c:8e:99:2b:07:d4',
                                    '00:14:4f:94:5b:01',
                                    '00:14:4f:39:ff:55',
                                    '00:14:4f:3a:47:3f',
                                    '00:14:4f:3a:47:45',
                                    '00:14:4f:3a:4b:42',
                                    '00:14:4f:3a:4e:87',
                                    '00:14:4f:3a:50:3a',
                                    '00:14:4f:3a:51:b0',
                                    '00:14:4f:3a:52:65',
                                    '00:14:4f:3a:52:4f',
                                    '00:03:ba:cd:6d:fc',
                                    '78:19:f7:05:fa:01',
                                    '9c:8e:99:2b:07:d4',
                                    '6c:3b:e5:b4:68:c6',
                                    '78:e7:d1:fa:72:fa',
                                    '78:e7:d1:fa:82:08',
                                    '78:e7:d1:fa:a2:12',
                                    '78:e7:d1:fa:12:a0',
                                    '78:e7:d1:fa:c2:32',
                                    '78:e7:d1:fa:52:8a',
                                    '78:e7:d1:fa:52:92',
                                    '78:e7:d1:fa:52:94',
                                    '78:e7:d1:fa:52:b0',
                                    '78:e7:d1:fa:52:b4',
                                    '78:e7:d1:fa:52:ce',
                                    '78:e7:d1:fa:52:d6',
                                    '78:e7:d1:fa:52:de',
                                    '78:e7:d1:fa:52:ec',
                                    '78:e7:d1:fa:52:f4',
                                    '78:e7:d1:fa:52:38',
                                    '78:e7:d1:fa:52:44',
                                    '78:e7:d1:fa:62:0a',
                                    '78:19:f7:05:fa:01',
                                    '80:c1:6e:62:a3:8c',
                                    '80:c1:6e:62:a3:d0',
                                    '98:4b:e1:65:45:1e',
                                    '98:4b:e1:72:a2:8a',
                                    '9c:8e:99:2b:07:d4',
                                    'd4:85:64:45:c3:6e',
                                    'd4:85:64:45:c3:04',
                                    'd8:9d:67:5c:0e:2e',
                                    'e4:11:5b:ce:80:f6',
                                    'e4:11:5b:e3:14:f6',
                                    'e8:39:35:ae:75:d8',
                                    'e8:39:35:ae:75:f0',
                                    'e8:39:35:ae:82:ba',
                                    'e8:39:35:ae:82:e8',
                                    'e8:39:35:ae:85:20',
                                    'e8:39:35:ae:a2:6c',
                                    'e8:39:35:ae:a8:d4',
                                    'e8:39:35:ae:11:c2',
                                    'e8:39:35:ae:11:ea',
                                    'e8:39:35:ae:f0:2a',
                                    '1c:c1:de:e9:cc:96',
                                    '1c:c1:de:e9:cc:e8',
                                    '1c:c1:de:e9:dc:18',
                                    '1c:c1:de:f1:eb:16',
                                    '3c:4a:92:e6:8d:ac',
                                    '3c:4a:92:e6:bd:66',
                                    '3c:4a:92:e7:e4:fe',
                                    '3c:4a:92:e7:e4:5a',
                                    '3c:4a:92:e7:05:30',
                                    '3c:4a:92:e7:37:90',
                                    '44:1e:a1:58:6d:5a',
                                    '44:1e:a1:58:6d:62',
                                    '44:1e:a1:58:cd:1a',
                                    '44:1e:a1:58:1a:68',
                                    '44:1e:a1:58:1d:04',
                                    '44:1e:a1:58:1d:30',
                                    '44:1e:a1:58:49:4e',
                                    '44:1e:a1:58:4c:e6',
                                    '44:1e:a1:58:4c:f6',
                                    '00:01:d7:8a:76:0b',
                                    '00:01:d7:8a:76:0c',
                                    '00:14:4f:8d:40:1d',
                                    '00:14:4f:94:66:69',
                                    '00:14:4f:94:66:6c',
                                    '00:14:4f:94:66:6f',
                                    '00:14:4f:94:66:72',
                                    '00:14:4f:94:66:75',
                                    '00:14:4f:94:66:81',
                                    '00:14:4f:94:66:91',
                                    '00:14:4f:94:67:25',
                                    '00:14:4f:d6:b8:9f',
                                    '00:14:4f:d6:ba:7d',
                                    '00:03:ba:cd:6c:a4',
                                    '00:03:ba:cd:6e:48',
                                    '00:03:ba:cd:7b:a8',
                                    '00:21:28:10:12:b9',
                                    '00:21:28:46:80:d5',
                                    '00:21:28:46:81:0f',
                                    '00:21:28:46:81:40',
                                    '00:21:28:46:81:52',
                                    '74:86:7a:d0:da:1e',
                                    '74:86:7a:d1:9d:ae',
                                    '78:19:f7:05:fa:01',
                                    '9c:8e:99:2b:07:d4',
                                    '00:14:4f:9a:3b:36',
                                    '78:19:f7:05:fa:01',
                                    '00:01:d7:8a:76:0b',
                                    '00:01:d7:8a:76:0c',
                                    '00:10:db:ff:10:01',
                                    '00:14:4f:8c:d0:4d',
                                    '00:14:4f:94:5c:89',
                                    '00:14:4f:9a:39:02',
                                    '00:19:07:db:18:00',
                                    '00:21:28:75:f2:a8',
                                    '00:21:28:76:14:b0',
                                    '00:21:28:46:80:d8',
                                    '00:21:28:46:80:e8',
                                    '6c:3b:e5:a7:b3:fa',
                                    '74:86:7a:d4:4e:5c',
                                    '74:86:7a:d7:a6:9c',
                                    '74:86:7a:d7:a7:84',
                                    '74:86:7a:d7:a7:4c',
                                    '74:86:7a:d7:ac:dc',
                                    '74:86:7a:d7:ac:ec',
                                    '74:86:7a:d7:ad:2e',
                                    '74:86:7a:d7:ad:4a',
                                    '74:86:7a:d7:ad:50',
                                    '74:86:7a:d7:b2:a4',
                                    '74:86:7a:d7:b2:fc',
                                    '74:86:7a:d7:b3:9a',
                                    '74:86:7a:d7:b5:2a',
                                    '78:19:f7:05:fa:01',
                                    '9c:8e:99:2b:07:d4',
                                    'b8:ca:3a:ed:69:e2',
                                    '78:19:f7:05:fa:01',
                                    '9c:8e:99:18:8d:5a',
                                    '9c:8e:99:19:96:d6',
                                    '9c:8e:99:19:a6:aa',
                                    '9c:8e:99:19:a6:16',
                                    '9c:8e:99:1d:c2:ac',
                                    '9c:8e:99:25:4c:22',
                                    'd4:85:64:45:c3:6e',
                                    'd4:85:64:45:c3:04',
                                    'd4:85:64:4b:9f:90',
                                    '1c:c1:de:e9:cc:96',
                                    '1c:c1:de:e9:dc:64',
                                    '1c:c1:de:e9:2c:6e',
                                    '1c:c1:de:e9:4c:32',
                                    '1c:c1:de:ea:89:04',
                                    '1c:c1:de:f1:eb:16',
                                    '00:01:d7:8a:76:0b',
                                    '00:01:d7:8a:76:0c',
                                    '00:19:07:db:18:00',
                                    '78:19:f7:05:fa:01',
                                    '9c:8e:99:2b:07:d4',
                                    '00:14:4f:79:2c:c4',
                                    '00:14:4f:3a:46:4c',
                                    '00:14:4f:3a:47:e0',
                                    '00:14:4f:3a:48:82',
                                    '00:14:4f:3a:48:ae',
                                    '00:14:4f:3a:48:d4',
                                    '00:14:4f:3a:48:fc',
                                    '00:14:4f:3a:48:24',
                                    '00:14:4f:3a:48:2c',
                                    '00:14:4f:3a:4a:15',
                                    '00:14:4f:3a:4a:fe',
                                    '00:14:4f:3a:4a:29',
                                    '00:14:4f:3a:4a:53',
                                    '00:14:4f:3a:4c:48',
                                    '00:14:4f:3a:4e:46',
                                    '00:14:4f:3a:50:37',
                                    '00:14:4f:3a:50:38',
                                    '00:14:4f:3a:50:41',
                                    '00:14:4f:3a:51:b5',
                                    '00:14:4f:3a:51:b9',
                                    '00:14:4f:3a:51:e1',
                                    '00:03:ba:cd:6d:7b',
                                    '00:03:ba:cd:6d:83',
                                    '00:03:ba:cd:72:e8',
                                    '00:03:ba:cd:7b:d1',
                                    '00:21:28:46:81:47',
                                    '00:21:28:46:81:4e',
                                    '68:b5:99:6d:5b:ae',
                                    '6c:3b:e5:a7:74:42',
                                    '6c:3b:e5:a7:b3:c8',
                                    '6c:3b:e5:a7:b3:fa',
                                    '6c:3b:e5:a7:c3:f2',
                                    '6c:3b:e5:b4:68:d0',
                                    '6c:3b:e5:b4:68:ee',
                                    '6c:3b:e5:b4:78:8e',
                                    '6c:3b:e5:b4:78:b6',
                                    '6c:3b:e5:b4:78:28',
                                    '6c:3b:e5:b4:98:44',
                                    '6c:3b:e5:b4:a8:80',
                                    '6c:3b:e5:b4:a8:cc',
                                    '6c:3b:e5:b8:ad:0e',
                                    '6c:3b:e5:b8:ad:10',
                                    '6c:3b:e5:b8:3d:16',
                                    '6c:3b:e5:b8:4d:58',
                                    '74:86:7a:d0:da:d8',
                                    '74:86:7a:d0:dc:04',
                                    '74:86:7a:d0:dc:40',
                                    '74:86:7a:d0:dc:08',
                                    '74:86:7a:d0:dd:06',
                                    '78:19:f7:05:fa:01',
                                    '80:c1:6e:62:a3:8c',
                                    '80:c1:6e:62:a3:d0',
                                    '90:b1:1c:57:09:b2',
                                    'b4:b5:2f:68:4c:2e',
                                    'e8:39:35:ae:11:c2',
                                    '1c:c1:de:e9:dc:18',
                                    '44:1e:a1:58:19:c6',
                                    '00:01:d7:8a:76:0b',
                                    '00:01:d7:8a:76:0c',
                                    '00:10:db:ff:10:01',
                                    '00:14:4f:94:67:04',
                                    '00:19:07:db:18:00',
                                    '78:19:f7:05:fa:01',
                                    '9c:8e:99:2b:07:d4',
                                    '00:01:d7:8a:76:0b',
                                    '78:19:f7:05:fa:01',
                                    '00:10:db:ff:10:01',
                                    '00:50:56:89:12:ed',
                                    '00:50:56:ac:3f:2f',
                                    '68:b5:99:6d:8b:4e',
                                    '78:e3:b5:18:86:14',
                                    '78:e3:b5:18:06:78',
                                    '78:e7:d1:f7:93:54',
                                    '78:e7:d1:f7:e4:c0',
                                    '78:e7:d1:f8:76:cc',
                                    '78:19:f7:05:fa:01',
                                    '78:19:f7:05:fa:18',
                                    '9c:8e:99:13:2f:24',
                                    '9c:8e:99:14:01:98',
                                    '9c:8e:99:14:01:18',
                                    '9c:8e:99:14:c0:28',
                                    '9c:8e:99:14:c0:2c',
                                    '9c:8e:99:14:e0:5c',
                                    '9c:8e:99:14:40:60',
                                    '9c:8e:99:1b:31:2c',
                                    '9c:8e:99:1c:88:a8',
                                    '9c:8e:99:1c:a9:2c',
                                    '9c:8e:99:2d:1d:2c',
                                    '2c:76:8a:55:00:38',
                                    '3c:4a:92:f4:c2:88',
                                    '78:e3:b5:19:25:b6',
                                    '78:e3:b5:19:34:7a',
                                    '78:e3:b5:1a:1d:50',
                                    '78:e3:b5:1a:4d:54',
                                    '78:e3:b5:06:7c:40',
                                    '78:e7:d1:fa:81:2e',
                                    '78:e7:d1:fa:a1:66',
                                    '78:e7:d1:fa:a1:6c',
                                    '78:e7:d1:fa:a1:6e',
                                    '78:e7:d1:fa:a1:74',
                                    '78:e7:d1:fa:a1:76',
                                    '78:e7:d1:fa:12:96',
                                    '78:e7:d1:fa:12:ea',
                                    '78:e7:d1:fa:12:f8',
                                    '78:e7:d1:fa:02:98',
                                    '78:e7:d1:fa:e1:96',
                                    '78:e7:d1:fa:f1:00',
                                    '78:e7:d1:fa:32:06',
                                    '78:e7:d1:fa:52:e2',
                                    '78:e7:d1:fa:62:16',
                                    '78:19:f7:05:fa:01',
                                    '80:c1:6e:6b:ff:76',
                                    '80:c1:6e:70:a6:28',
                                    '80:c1:6e:70:a6:36',
                                    '80:c1:6e:70:b6:9c',
                                    '80:c1:6e:70:c5:c8',
                                    '80:c1:6e:70:c6:80',
                                    '80:c1:6e:70:c6:9a',
                                    '80:c1:6e:70:d5:62',
                                    '80:c1:6e:70:e6:30',
                                    '80:c1:6e:70:f6:78',
                                    '9c:8e:99:18:9a:6c',
                                    '9c:8e:99:18:9a:ee',
                                    '9c:8e:99:18:b8:86',
                                    '9c:8e:99:18:bb:5a',
                                    '9c:8e:99:18:d8:3a',
                                    '9c:8e:99:18:e8:96',
                                    '9c:8e:99:18:29:be',
                                    '9c:8e:99:18:5b:f8',
                                    '9c:8e:99:19:6a:7c',
                                    '9c:8e:99:25:d9:04',
                                    '9c:8e:99:25:e9:84',
                                    '9c:8e:99:2f:bc:84',
                                    '9c:8e:99:2f:bc:44',
                                    '9c:8e:99:2f:cc:f4',
                                    '1c:c1:de:6d:37:3c',
                                    '1c:c1:de:03:39:fe',
                                    '1c:c1:de:03:49:1c',
                                    '1c:c1:de:03:49:06',
                                    '1c:c1:de:08:31:60',
                                    '3c:4a:92:f2:a6:de',
                                    '3c:4a:92:f3:f8:1e',
                                    '3c:4a:92:f8:76:2a',
                                    '3c:4a:92:f8:81:04',
                                    '3c:4a:92:f8:91:a8',
                                    '3c:4a:92:f8:96:04',
                                    '3c:4a:92:f8:97:f8',
                                    '3c:4a:92:f8:a6:be',
                                    '3c:4a:92:f8:e4:5c',
                                    '3c:4a:92:f8:21:88',
                                    '6c:3b:e5:b1:0c:ce',
                                    '6c:3b:e5:b1:0c:32',
                                    '6c:3b:e5:b1:1c:66',
                                    '6c:3b:e5:b1:1c:f0',
                                    '6c:3b:e5:b1:1c:62',
                                    '6c:3b:e5:b1:2c:b0',
                                    '6c:3b:e5:b1:3c:20',
                                    '6c:3b:e5:b2:73:ee',
                                    '6c:3b:e5:b2:b1:36',
                                    '6c:3b:e5:b2:c1:e4',
                                    '6c:3b:e5:b2:c1:2a',
                                    '78:19:f7:05:fa:01',
                                    '80:c1:6e:64:6e:ce',
                                    '80:c1:6e:70:a6:fc',
                                    '80:c1:6e:70:b6:1e',
                                    '80:c1:6e:70:b6:06',
                                    '80:c1:6e:70:c6:54',
                                    '80:c1:6e:70:c9:c6',
                                    '80:c1:6e:74:7c:4e',
                                    '80:c1:6e:74:dd:2e',
                                    '10:60:4b:b0:da:e2',
                                    '10:60:4b:b0:db:0c',
                                    '10:60:4b:b0:eb:7c',
                                    '10:60:4b:b0:eb:c4',
                                    '10:60:4b:b1:c0:58',
                                    '3c:4a:92:6f:d0:6a',
                                    '3c:4a:92:70:5f:f0',
                                    '3c:4a:92:70:63:9c',
                                    '3c:4a:92:71:8c:f4',
                                    '3c:4a:92:71:9c:d0',
                                    '3c:4a:92:73:50:66',
                                    '3c:4a:92:73:52:96',
                                    '3c:4a:92:73:52:5a',
                                    '00:14:1b:33:1c:c0',
                                    '00:14:4f:49:de:4a',
                                    '00:19:e8:85:ff:80',
                                    '00:19:55:cd:ac:11',
                                    '00:1a:6d:09:8f:32',
                                    '00:1a:e3:31:fc:11',
                                    '00:1c:0f:48:4d:32',
                                    '78:e7:d1:65:db:ac',
                                    '78:e7:d1:65:db:cc',
                                    '78:e7:d1:65:1c:a8',
                                    '78:19:f7:05:fa:01',
                                    'ac:16:2d:7c:a5:10',
                                    'ac:16:2d:84:00:e8',
                                    'ac:16:2d:84:af:e4',
                                    'ac:16:2d:84:d2:3c',
                                    'ac:16:2d:85:29:ac',
                                    'ac:16:2d:85:29:58',
                                    'ac:16:2d:87:c5:fc',
                                    'ac:16:2d:87:c6:a8',
                                    'ac:16:2d:87:d0:d0',
                                    'ac:16:2d:87:d7:9c',
                                    'ac:16:2d:87:d8:00',
                                    'ac:16:2d:87:d8:30',
                                    'ac:16:2d:87:d9:d4',
                                    'ac:16:2d:87:dd:a8',
                                    'ac:16:2d:87:f3:4c',
                                    'ac:16:2d:87:f7:c4',
                                    '2c:76:8a:54:ca:a4',
                                    '2c:76:8a:54:f9:90',
                                    '2c:76:8a:54:f9:f8',
                                    '2c:76:8a:54:fb:98',
                                    '2c:76:8a:54:fb:d8',
                                    '2c:76:8a:54:fb:40',
                                    '2c:76:8a:54:ff:dc',
                                    '2c:76:8a:55:3c:38',
                                    '3c:4a:92:eb:13:dc',
                                    '3c:4a:92:f4:b1:70',
                                    '3c:4a:92:f4:13:4c',
                                    '3c:4a:92:f4:c1:a0',
                                    '78:19:f7:05:fa:01',
                                    '00:14:4f:01:e8:c6',
                                    '68:b5:99:6d:8b:4e',
                                    '78:19:f7:05:fa:01',
                                    '78:19:f7:05:fa:18',
                                    '3c:4a:92:ea:f7:30',
                                    '78:19:f7:05:fa:01',
                                    'd4:85:64:cd:5a:f6',
                                    'd8:d3:85:af:3f:82',
                                    '00:14:4f:02:0a:d6',
                                    '00:14:4f:49:e1:d2',
                                    '00:15:17:8f:f0:0a',
                                    '00:15:17:8f:f0:dc',
                                    '00:16:36:e7:7b:1f',
                                    '00:1b:24:3d:ec:e3',
                                    '00:21:28:10:56:88',
                                    '00:21:28:10:57:00',
                                    '00:21:28:25:73:9e',
                                    '00:50:56:89:64:36',
                                    '64:31:50:4b:7d:40',
                                    '64:31:50:50:e8:16',
                                    '64:31:50:51:6d:54',
                                    '64:31:50:51:a6:3e',
                                    '64:31:50:51:c0:a6',
                                    '64:31:50:51:c9:20',
                                    '64:31:50:51:c9:48',
                                    '64:31:50:51:cb:96',
                                    '64:31:50:51:cb:b4',
                                    '64:31:50:51:cb:e6',
                                    '64:31:50:51:ce:2a',
                                    '64:31:50:51:dd:5c',
                                    '64:31:50:51:f6:0c',
                                    '64:31:50:51:45:72',
                                    '64:31:50:51:48:9c',
                                    '64:31:50:51:60:34',
                                    '64:31:50:51:61:ba',
                                    '68:b5:99:6d:8b:4e',
                                    '68:b5:99:6d:a3:72',
                                    '68:b5:99:6d:a5:e8',
                                    '68:b5:99:6d:a8:86',
                                    '68:b5:99:6e:d0:a8',
                                    '68:b5:99:6e:d1:8e',
                                    '68:b5:99:6f:d0:98',
                                    '68:b5:99:70:75:34',
                                    '68:b5:99:70:93:c0',
                                    '68:b5:99:70:c3:36',
                                    '68:b5:99:70:60:3a',
                                    '68:b5:99:71:97:a2',
                                    '68:b5:99:71:c7:c2',
                                    '6c:3b:e5:b2:66:4c',
                                    '6c:3b:e5:b3:d1:30',
                                    '78:e3:b5:0c:ef:cc',
                                    '78:e7:d1:65:bb:8c',
                                    '78:e7:d1:65:2c:50',
                                    '78:e7:d1:f7:73:0c',
                                    '78:19:f7:05:fa:01',
                                    '78:19:f7:05:fa:18',
                                    '9c:8e:99:2b:07:d4',
                                    '10:60:4b:a1:47:48',
                                    'd4:85:64:6b:98:64',
                                    'd4:85:64:6c:56:8c',
                                    'd8:d3:85:fe:2b:cc',
                                    '18:a9:05:c5:6b:1c',
                                    '2c:76:8a:4e:91:58',
                                    '2c:76:8a:4e:4e:54',
                                    '2c:76:8a:4e:57:54',
                                    '2c:76:8a:4e:5e:10',
                                    '2c:76:8a:4f:23:98',
                                    '2c:76:8a:54:d0:8c',
                                    '2c:76:8a:54:d2:dc',
                                    '3c:4a:92:e3:1d:24',
                                    '3c:4a:92:eb:93:a4',
                                    '3c:4a:92:eb:d8:48',
                                    '3c:4a:92:eb:e3:a4',
                                    '3c:4a:92:f3:1f:cc',
                                    '44:1e:a1:59:dd:2c',
                                    '44:1e:a1:5a:a5:b4',
                                    '00:01:d7:8a:76:0c',
                                    '00:01:d7:8a:76:1c',
                                    '00:0c:29:6c:6d:44',
                                    '00:10:db:ff:10:01',
                                    '00:14:1b:33:1c:c0',
                                    '00:14:4f:02:0a:f2',
                                    '68:b5:99:c5:b7:88',
                                    '68:b5:99:c5:2f:bc',
                                    '68:b5:99:c5:5d:80',
                                    '68:b5:99:cc:ad:f4',
                                    '6c:3b:e5:b3:d9:80',
                                    '74:86:7a:d7:ad:42',
                                    '78:e3:b5:0d:c0:cc',
                                    '78:e7:d1:f7:e3:50',
                                    '78:e7:d1:f7:42:14',
                                    '78:19:f7:05:fa:01',
                                    '78:19:f7:05:fa:18',
                                    '9c:8e:99:14:01:18',
                                    '9c:8e:99:14:a0:30',
                                    '9c:8e:99:14:c0:28',
                                    '9c:8e:99:14:c0:2c',
                                    '9c:8e:99:14:e0:5c',
                                    '9c:8e:99:15:cd:a0',
                                    '9c:8e:99:1c:88:a8',
                                    '9c:8e:99:1c:a9:2c',
                                    '9c:8e:99:2d:6e:7c',
                                    '9c:8e:99:2d:0f:4c',
                                    '9c:8e:99:2d:2f:38',
                                    '10:1f:74:2f:fb:30',
                                    'd8:9d:67:13:df:bc',
                                    'd8:d3:85:e2:82:50',
                                    'e4:11:5b:ed:9a:d8',
                                    'e4:11:5b:ed:db:74',
                                    '1c:c1:de:f3:0c:94',
                                    '1c:c1:de:f4:d3:70',
                                    '2c:76:8a:54:f5:94',
                                    '3c:4a:92:6f:d1:ac',
                                    '3c:4a:92:f4:c2:88',
                                    '3c:4a:92:f4:2b:08',
                                    '00:14:4f:01:e9:42',
                                    '00:14:4f:02:0a:de',
                                    '00:14:4f:02:0b:72',
                                    '00:14:4f:02:0e:a2',
                                    '00:14:4f:02:0e:f2',
                                    '00:14:4f:49:de:72',
                                    '00:14:4f:49:de:4a',
                                    '00:14:4f:4a:1e:72',
                                    '00:14:4f:4a:1e:aa',
                                    '00:14:4f:4a:1e:36',
                                    '64:31:50:51:c9:48',
                                    '68:b5:99:6d:8b:4e',
                                    '68:b5:99:70:60:3a',
                                    '68:b5:99:c5:6f:6c',
                                    '74:86:7a:d1:98:2c',
                                    '74:86:7a:d4:4e:5c',
                                    '74:86:7a:d7:a7:84',
                                    '74:86:7a:d7:a7:4c',
                                    '74:86:7a:d7:ac:dc',
                                    '74:86:7a:d7:ac:ec',
                                    '74:86:7a:d7:ad:2e',
                                    '74:86:7a:d7:ad:4a',
                                    '74:86:7a:d7:ad:50',
                                    '74:86:7a:d7:b2:fc',
                                    '74:86:7a:d7:b3:9a',
                                    '74:86:7a:d7:b5:2a',
                                    '78:e3:b5:18:78:c4',
                                    '78:e3:b5:18:96:60',
                                    '78:e3:b5:18:fa:c0',
                                    '78:e7:d1:65:1c:a8',
                                    '78:e7:d1:f6:21:58',
                                    '78:e7:d1:f7:84:7c',
                                    '78:e7:d1:f7:02:40',
                                    '78:e7:d1:f7:14:d4',
                                    '78:e7:d1:f7:04:28',
                                    '78:e7:d1:f7:63:94',
                                    '78:e7:d1:f7:63:d4',
                                    '78:19:f7:05:fa:01',
                                    '9c:8e:99:13:3f:30',
                                    '9c:8e:99:2b:07:d4',
                                    'b4:99:ba:05:7c:a2',
                                    'b4:99:ba:08:7f:f6',
                                    '1c:c1:de:e5:cb:94',
                                    '1c:c1:de:e6:83:38',
                                    '1c:c1:de:e6:83:08',
                                    '1c:c1:de:f3:5c:b4',
                                    '2c:76:8a:54:c4:38',
                                    '2c:76:8a:54:cb:74',
                                    '3c:4a:92:e3:7e:cc',
                                    '3c:4a:92:e3:0e:1c',
                                    '3c:4a:92:e4:d8:e8',
                                    '3c:4a:92:ea:8f:f8',
                                    '3c:4a:92:eb:72:68',
                                    '3c:4a:92:eb:73:00',
                                    '3c:4a:92:eb:73:b4',
                                    '3c:4a:92:eb:93:a4',
                                    '3c:4a:92:eb:b2:e8',
                                    '3c:4a:92:eb:b2:54',
                                    '3c:4a:92:eb:13:dc',
                                    '3c:4a:92:eb:02:54',
                                    '3c:4a:92:eb:f2:b0',
                                    '3c:4a:92:eb:34:dc',
                                    '3c:4a:92:eb:34:50',
                                    '3c:4a:92:eb:41:14',
                                    '3c:4a:92:eb:52:f4',
                                    '3c:4a:92:eb:54:e8',
                                    '3c:4a:92:ee:7d:a0',
                                    '3c:4a:92:ee:bd:b4',
                                    '3c:4a:92:ee:cd:6c',
                                    '3c:4a:92:ee:4d:e8',
                                    '3c:4a:92:ee:5d:0c',
                                    '3c:4a:92:f3:1f:cc',
                                    '3c:4a:92:f4:0a:dc',
                                    '3c:4a:92:f4:b1:70',
                                    '3c:4a:92:f4:13:4c',
                                    '3c:4a:92:f4:13:54',
                                    '3c:4a:92:f4:c1:a0',
                                    '3c:4a:92:f4:23:30',
                                    '00:14:4f:01:e9:42',
                                    '00:14:4f:01:ff:da',
                                    '00:14:4f:7d:86:30',
                                    '00:14:4f:7d:ae:18',
                                    '00:14:4f:7d:b4:7c',
                                    '00:14:4f:7d:bd:90',
                                    '00:14:4f:9a:84:c4',
                                    '00:14:4f:9a:8f:84',
                                    '00:14:4f:9a:90:18',
                                    '00:14:4f:9e:17:be',
                                    '00:14:4f:9e:17:4e',
                                    '00:14:4f:9e:5b:42',
                                    '00:14:4f:02:00:72',
                                    '00:14:4f:02:00:32',
                                    '00:14:4f:02:0a:de',
                                    '00:14:4f:02:0b:72',
                                    '00:14:4f:02:0e:a2',
                                    '00:14:4f:02:0e:ba',
                                    '00:14:4f:02:0e:f2',
                                    '00:14:4f:02:1f:fa',
                                    '00:14:4f:02:23:6a',
                                    '00:14:4f:02:05:12',
                                    '00:14:4f:49:de:72',
                                    '00:14:4f:49:de:4a',
                                    '00:14:4f:4a:1d:e6',
                                    '00:14:4f:4a:1e:72',
                                    '00:14:4f:4a:1e:aa',
                                    '00:14:4f:4a:1e:fa',
                                    '00:14:4f:4a:1e:36',
                                    '68:b5:99:c5:2f:bc',
                                    '68:b5:99:c5:5d:80',
                                    '68:b5:99:cc:1d:24',
                                    '6c:3b:e5:a7:b3:fa',
                                    '6c:3b:e5:b3:b1:98',
                                    '6c:3b:e5:b3:d1:a0',
                                    '6c:3b:e5:b3:d1:30',
                                    '6c:3b:e5:b3:32:90',
                                    '6c:3b:e5:b3:43:70',
                                    '6c:3b:e5:b3:52:a4',
                                    '74:86:7a:d0:da:d8',
                                    '78:e3:b5:0d:c0:cc',
                                    '78:e3:b5:18:fa:c0',
                                    '78:e7:d1:65:db:84',
                                    '78:e7:d1:65:db:ac',
                                    '78:e7:d1:65:db:cc',
                                    '78:e7:d1:65:1c:a8',
                                    '78:e7:d1:65:1c:5c',
                                    '78:e7:d1:f6:21:58',
                                    '78:e7:d1:f7:64:9c',
                                    '78:e7:d1:f7:63:d4',
                                    '78:19:f7:05:fa:01',
                                    '78:19:f7:05:fa:18',
                                    '9c:8e:99:14:01:18',
                                    '9c:8e:99:14:c0:28',
                                    '9c:8e:99:14:c0:2c',
                                    '9c:8e:99:14:e0:5c',
                                    '9c:8e:99:1b:f2:00',
                                    '9c:8e:99:1b:31:cc',
                                    '9c:8e:99:1c:88:a8',
                                    '9c:8e:99:1c:a9:2c',
                                    '9c:8e:99:2d:1d:2c',
                                    '9c:8e:99:2d:2f:38',
                                    '10:1f:74:2f:fb:30',
                                    'ac:16:2d:85:29:ac',
                                    'ac:16:2d:87:d9:d4',
                                    'd8:9d:67:13:bf:b0',
                                    'e8:39:35:a7:63:5c',
                                    '1c:c1:de:e5:4d:bc',
                                    '2c:76:8a:54:f7:74',
                                    '2c:76:8a:54:fb:98',
                                    '2c:76:8a:55:3c:38',
                                    '3c:4a:92:6f:d0:62',
                                    '3c:4a:92:6f:d1:ac',
                                    '3c:4a:92:70:5f:e8',
                                    '3c:4a:92:71:8c:ec',
                                    '3c:4a:92:71:9c:c8',
                                    '3c:4a:92:73:78:68',
                                    '3c:4a:92:73:50:5e',
                                    '3c:4a:92:73:52:8e',
                                    '3c:4a:92:73:52:52',
                                    '3c:4a:92:e3:7e:cc',
                                    '3c:4a:92:e3:0e:1c',
                                    '3c:4a:92:e4:d8:e8',
                                    '3c:4a:92:ea:f7:30',
                                    '3c:4a:92:eb:d3:fc',
                                    '3c:4a:92:eb:d8:5c',
                                    '3c:4a:92:eb:54:e8',
                                    '3c:4a:92:ee:5d:0c',
                                    '3c:4a:92:f3:fa:60',
                                    '00:50:56:ac:4a:be',
                                    '78:e3:b5:18:98:80',
                                    '78:e3:b5:18:d3:64',
                                    '78:e3:b5:18:37:c0',
                                    '78:e7:d1:65:1c:a8',
                                    '78:19:f7:05:fa:01',
                                    '78:19:f7:05:fa:18',
                                    '9c:8e:99:13:5f:98',
                                    '3c:4a:92:f4:c2:88',
                                    '00:01:d7:8a:76:03',
                                    '00:01:d7:8a:76:04',
                                    '00:14:4f:01:e9:0e',
                                    '00:14:4f:01:f3:ce',
                                    '00:14:4f:01:ff:e6',
                                    '00:14:4f:9e:17:8e',
                                    '00:14:4f:02:0a:f2',
                                    '00:14:4f:02:0e:36',
                                    '00:14:4f:02:1c:a6',
                                    '00:14:4f:49:d2:1a',
                                    '00:14:4f:49:d3:e6',
                                    '00:14:4f:49:db:aa',
                                    '00:14:4f:4a:1d:7a',
                                    '00:14:4f:4a:1d:c2',
                                    '00:14:4f:4a:1d:36',
                                    '00:14:4f:4a:1d:4e',
                                    '00:14:4f:4a:1e:7e',
                                    '00:14:4f:4a:1e:3e',
                                    '78:19:f7:05:fa:01',
                                    '78:19:f7:05:fa:18',
                                    '00:01:d7:8a:76:05',
                                    '00:50:56:ac:75:83',
                                    '78:19:f7:05:fa:01',
                                    '78:19:f7:05:fa:18',
                                    '9c:8e:99:2b:07:d4',
                                    '3c:4a:92:eb:74:00',
                                    '3c:4a:92:eb:93:a4',
                                    '3c:4a:92:eb:13:dc',
                                    '3c:4a:92:ee:8d:70',
                                    '3c:4a:92:ee:5d:0c',
                                    '3c:4a:92:f4:c1:a0',
                                    '3c:4a:92:f4:33:c0',
                                    '00:01:d7:8a:76:12',
                                    '00:14:4f:01:f3:d6',
                                    '00:1b:24:2d:b6:b5',
                                    '00:1b:24:2d:b8:0d',
                                    '00:1b:24:2d:b9:85',
                                    '00:1b:24:2d:ba:25',
                                    '00:1b:24:2d:bb:8d',
                                    '00:1b:24:2d:bc:65',
                                    '00:1b:24:2d:f5:7d',
                                    '00:1b:24:3d:c9:bf',
                                    '00:1b:24:3d:c9:c3',
                                    '00:1b:24:3d:c9:cb',
                                    '00:1b:24:3d:c9:27',
                                    '00:1b:24:3d:c9:2b',
                                    '00:1b:24:3d:c9:2f',
                                    '00:1b:24:3d:c9:33',
                                    '00:1b:24:3d:ca:4b',
                                    '6c:3b:e5:a8:66:6c',
                                    '6c:3b:e5:b3:2a:bc',
                                    '78:e7:d1:f7:64:c4',
                                    '78:e7:d1:f7:73:88',
                                    '78:e7:d1:f7:73:04',
                                    '78:e7:d1:f7:73:4c',
                                    '78:e7:d1:f7:82:ac',
                                    '78:e7:d1:f7:15:08',
                                    '78:e7:d1:f7:d3:8c',
                                    '78:e7:d1:f7:d3:fc',
                                    '78:e7:d1:f7:e3:0c',
                                    '78:e7:d1:f7:e3:14',
                                    '78:e7:d1:f7:e3:ec',
                                    '78:e7:d1:f7:e3:18',
                                    '78:e7:d1:f7:03:14',
                                    '78:e7:d1:f7:04:a4',
                                    '78:e7:d1:f7:04:3c',
                                    '78:e7:d1:f7:34:90',
                                    '78:e7:d1:f7:44:28',
                                    '78:e7:d1:f7:63:a8',
                                    '78:e7:d1:f7:63:b0',
                                    '78:19:f7:05:fa:01',
                                    '98:4b:e1:73:6c:b0',
                                    '9c:8e:99:2b:07:d4',
                                    'e4:11:5b:ed:73:60',
                                    'e4:11:5b:ed:77:a8',
                                    'e4:11:5b:ed:7a:84',
                                    'e4:11:5b:ed:89:38',
                                    'e4:11:5b:ed:db:b0',
                                    'e4:11:5b:ed:e8:38',
                                    'e4:11:5b:ed:19:00',
                                    'e4:11:5b:ed:05:dc',
                                    'e4:11:5b:ed:5b:f8',
                                    'e4:11:5b:ed:5b:30',
                                    'e8:39:35:b1:6c:58',
                                    '1c:c1:de:e5:4d:b0',
                                    '1c:c1:de:e5:4d:fc',
                                    '1c:c1:de:e5:5d:f8',
                                    '1c:c1:de:f3:6a:00',
                                    '1c:c1:de:f3:7c:54',
                                    '1c:c1:de:f3:5c:18',
                                    '2c:76:8a:54:c9:ac',
                                    '2c:76:8a:54:d9:d8',
                                    '3c:4a:92:eb:73:50',
                                    '3c:4a:92:ee:2d:44',
                                    '3c:4a:92:f5:2a:dc',
                                    '44:1e:a1:59:3e:d0',
                                    '44:1e:a1:5a:66:18',
                                    '44:1e:a1:5a:76:bc',
                                    '44:1e:a1:5a:a2:8c',
                                    '44:1e:a1:5a:b3:f4',
                                    '44:1e:a1:5a:b5:b8',
                                    '44:1e:a1:5a:c3:48',
                                    '44:1e:a1:5a:26:e0',
                                    '44:1e:a1:5a:37:c0',
                                    '44:1e:a1:5a:56:24',
                                    '00:01:d7:8a:76:0c',
                                    '00:10:db:ff:10:01',
                                    '00:14:4f:9e:bc:66',
                                    '00:14:4f:9e:cc:52',
                                    '00:14:4f:4a:1d:36',
                                    '00:21:28:50:47:ff',
                                    '68:b5:99:6d:8b:4e',
                                    '78:e3:b5:18:fb:24',
                                    '78:e3:b5:05:af:b0',
                                    '78:e7:d1:f7:63:94',
                                    '78:19:f7:05:fa:01',
                                    '90:b1:1c:55:25:d8',
                                    '9c:8e:99:2b:07:d4',
                                    'e4:11:5b:ed:0b:fc',
                                    'e4:11:5b:ed:cb:a0',
                                    '18:a9:05:c5:68:ba',
                                    '3c:4a:92:eb:d8:5c',
                                    '3c:4a:92:ee:5d:0c',
                                    '3c:4a:92:f4:0a:dc',
                                    '3c:4a:92:f4:b1:70',
                                    '3c:4a:92:f4:13:54',
                                    '3c:4a:92:f4:c2:88',
                                    '00:01:d7:8a:76:04',
                                    '00:01:d7:8a:76:05',
                                    '00:14:1b:33:1c:c0',
                                    '00:14:4f:8d:ee:9c',
                                    '00:14:4f:9a:8a:04',
                                    '00:14:4f:9a:90:3c',
                                    '00:21:28:75:f2:a5',
                                    '00:21:28:76:14:ad',
                                    '00:21:28:50:47:97',
                                    '00:21:28:50:48:17',
                                    '68:b5:99:6d:8b:4e',
                                    '68:b5:99:c5:b7:88',
                                    '68:b5:99:c5:ff:60',
                                    '68:b5:99:c5:09:64',
                                    '68:b5:99:cc:ac:a8',
                                    '68:b5:99:cc:ad:f4',
                                    '68:b5:99:cc:1d:24',
                                    '6c:3b:e5:b3:b1:f0',
                                    '78:e3:b5:0d:c0:cc',
                                    '78:e3:b5:18:d9:24',
                                    '78:e7:d1:65:db:cc',
                                    '78:e7:d1:f7:64:a8',
                                    '78:e7:d1:f7:64:c4',
                                    '78:e7:d1:f7:64:48',
                                    '78:e7:d1:f7:82:24',
                                    '78:e7:d1:f7:84:0c',
                                    '78:e7:d1:f7:92:f4',
                                    '78:e7:d1:f7:a4:78',
                                    '78:e7:d1:f7:c3:90',
                                    '78:e7:d1:f7:d3:64',
                                    '78:e7:d1:f7:e3:6c',
                                    '78:e7:d1:f7:e3:50',
                                    '78:e7:d1:f7:f3:9c',
                                    '78:e7:d1:f7:f3:c8',
                                    '78:e7:d1:f7:f3:2c',
                                    '78:e7:d1:f7:04:28',
                                    '78:e7:d1:f7:42:14',
                                    '78:e7:d1:f7:63:ac',
                                    '78:19:f7:05:fa:01',
                                    '78:19:f7:05:fa:18',
                                    '90:b1:1c:56:19:c3',
                                    '9c:8e:99:13:3f:30',
                                    '9c:8e:99:1b:80:08',
                                    '9c:8e:99:1c:39:74',
                                    '9c:8e:99:2d:0f:4c',
                                    'b4:99:ba:05:7c:a2',
                                    'b4:99:ba:08:7f:f6',
                                    'b8:ca:3a:ec:d8:c0',
                                    'b8:ca:3a:ec:d9:89',
                                    'b8:ca:3a:ec:d9:fd',
                                    'b8:ca:3a:ec:da:25',
                                    'b8:ca:3a:ec:de:cf',
                                    'b8:ca:3a:ec:ea:83',
                                    'b8:ca:3a:ec:ee:da',
                                    'b8:ca:3a:ed:64:1c',
                                    'b8:ca:3a:ed:67:d6',
                                    'b8:ca:3a:ed:69:df',
                                    'b8:ca:3a:ed:69:e7',
                                    'b8:ca:3a:ed:6b:1c',
                                    'b8:ca:3a:ed:72:f3',
                                    'b8:ca:3a:ed:02:1b',
                                    'b8:ca:3a:ed:5f:7a',
                                    'd8:9d:67:13:73:54',
                                    'd8:9d:67:13:78:bc',
                                    'd8:9d:67:13:b0:e0',
                                    'd8:9d:67:13:b6:ec',
                                    'd8:9d:67:13:bf:b0',
                                    'd8:9d:67:13:df:bc',
                                    'd8:9d:67:13:df:50',
                                    'd8:9d:67:13:e1:d4',
                                    'd8:9d:67:13:f1:44',
                                    'd8:9d:67:14:0c:d8',
                                    'd8:9d:67:14:11:dc',
                                    'd8:9d:67:14:07:e8',
                                    'd8:9d:67:14:09:84',
                                    'd8:9d:67:14:09:a0',
                                    'e4:11:5b:ed:6b:84',
                                    'e4:11:5b:ed:77:a8',
                                    'e4:11:5b:ed:9a:d8',
                                    'e4:11:5b:ed:db:74',
                                    'e4:11:5b:ed:f9:78',
                                    'e4:11:5b:ed:1c:b8',
                                    'e4:11:5b:ed:48:54',
                                    'e4:11:5b:ed:4a:8c',
                                    'e4:11:5b:ed:58:d4',
                                    'e8:39:35:a7:63:5c',
                                    '1c:c1:de:e5:bc:2c',
                                    '1c:c1:de:e5:3e:90',
                                    '1c:c1:de:e5:5d:f8',
                                    '3c:4a:92:eb:64:74',
                                    '3c:4a:92:eb:64:1c',
                                    '3c:4a:92:eb:72:68',
                                    '3c:4a:92:eb:73:b4',
                                    '3c:4a:92:eb:93:a4',
                                    '3c:4a:92:eb:c7:44',
                                    '3c:4a:92:eb:c8:c0',
                                    '3c:4a:92:eb:d3:64',
                                    '3c:4a:92:eb:d8:4c',
                                    '3c:4a:92:eb:32:50',
                                    '3c:4a:92:eb:39:4c',
                                    '3c:4a:92:eb:49:3c',
                                    '3c:4a:92:eb:54:e8',
                                    '3c:4a:92:ee:7d:a0',
                                    '3c:4a:92:ee:8d:70',
                                    '3c:4a:92:ee:cd:3c',
                                    '3c:4a:92:f3:fa:60',
                                    '3c:4a:92:f3:1f:cc',
                                    '3c:4a:92:f4:ac:a4',
                                    '3c:4a:92:f4:c1:a0',
                                    '3c:4a:92:f4:c2:54',
                                    '3c:4a:92:f4:c8:f8',
                                    '3c:4a:92:f4:e2:dc',
                                    '3c:4a:92:f4:ea:e4',
                                    '3c:4a:92:f4:ea:5c',
                                    '3c:4a:92:f4:fa:a4',
                                    '3c:4a:92:f4:23:30',
                                    '3c:4a:92:f4:2b:08',
                                    '3c:4a:92:f4:33:c0',
                                    '3c:4a:92:f4:3b:1c',
                                    '3c:4a:92:f4:4a:a4',
                                    '3c:4a:92:f4:55:04',
                                    '44:1e:a1:59:0e:40',
                                    '44:1e:a1:59:8e:c8',
                                    '68:b5:99:6d:8b:4e',
                                    '78:19:f7:05:fa:01',
                                    '00:01:d7:8a:76:07',
                                    '00:01:d7:8a:76:08',
                                    '78:19:f7:05:fa:01',
                                    '78:19:f7:05:fa:18',
                                    '3c:4a:92:eb:29:34',
                                    '3c:4a:92:eb:39:fc',
                                    '00:01:d7:8a:76:14',
                                    '78:19:f7:05:fa:01',
                                    '78:19:f7:05:fa:01',
                                    '78:19:f7:05:fa:18',
                                    '78:e7:d1:f7:02:cc',
                                    '78:19:f7:05:fa:01',
                                    '00:10:db:ff:10:01',
                                    '00:14:4f:49:db:6e',
                                    '00:14:4f:4a:1f:76',
                                    '00:21:28:50:47:5b',
                                    '68:b5:99:6d:8b:4e',
                                    '78:19:f7:05:fa:01',
                                    '00:01:d7:8a:76:1d',
                                    '00:50:56:ac:40:86',
                                    '78:19:f7:05:fa:01',
                                    '78:19:f7:05:fa:18',
                                    '9c:8e:99:14:83:c8',
                                    '9c:8e:99:1b:80:34',
                                    '9c:8e:99:1b:a1:18',
                                    '9c:8e:99:1b:27:58',
                                    '9c:8e:99:2b:47:c4',
                                    '1c:c1:de:e5:8c:bc',
                                    '1c:c1:de:e5:eb:44',
                                    '1c:c1:de:e5:3e:90',
                                    '1c:c1:de:e5:4d:b0',
                                    '1c:c1:de:e5:5d:f8',
                                    '1c:c1:de:e6:26:b4',
                                    '1c:c1:de:f3:6a:00',
                                    '1c:c1:de:f3:7c:54',
                                    '1c:c1:de:f3:5c:18',
                                    '1c:c1:de:f4:44:80',
                                    '00:01:d7:8a:76:0c',
                                    '00:01:d7:8a:76:1e',
                                    '00:14:1b:33:1c:c0',
                                    '00:21:28:50:48:17',
                                    '00:50:56:ac:2f:8f',
                                    '68:b5:99:6d:8b:4e',
                                    '68:b5:99:c5:ff:60',
                                    '78:e3:b5:18:92:24',
                                    '78:e3:b5:1c:03:6c',
                                    '78:e3:b5:05:af:b0',
                                    '78:e7:d1:f7:64:c4',
                                    '78:e7:d1:f7:42:14',
                                    '78:19:f7:05:fa:01',
                                    '78:19:f7:05:fa:18',
                                    '9c:8e:99:13:3f:fc',
                                    '9c:8e:99:13:3f:30',
                                    '9c:8e:99:14:01:18',
                                    '9c:8e:99:14:83:78',
                                    '9c:8e:99:14:a0:30',
                                    '9c:8e:99:14:c0:28',
                                    '9c:8e:99:14:c0:2c',
                                    '9c:8e:99:15:cd:a0',
                                    '9c:8e:99:1b:c2:08',
                                    '9c:8e:99:1b:4b:e4',
                                    '9c:8e:99:1c:88:a8',
                                    '9c:8e:99:1c:a9:2c',
                                    '9c:8e:99:2b:07:d4',
                                    '9c:8e:99:2d:6e:7c',
                                    '9c:8e:99:2d:0f:4c',
                                    '9c:8e:99:2d:1d:2c',
                                    '9c:8e:99:2d:2f:38',
                                    '10:1f:74:2f:fb:30',
                                    'd8:9d:67:13:df:bc',
                                    '1c:c1:de:e5:6d:44',
                                    '1c:c1:de:e5:6e:d0',
                                    '1c:c1:de:e5:73:a8',
                                    '1c:c1:de:e5:8c:40',
                                    '1c:c1:de:e5:bc:2c',
                                    '1c:c1:de:e5:dc:74',
                                    '1c:c1:de:e5:4d:ec',
                                    '1c:c1:de:e5:4d:34',
                                    '1c:c1:de:e5:4e:60',
                                    '1c:c1:de:e5:5d:d8',
                                    '1c:c1:de:e6:83:38',
                                    '1c:c1:de:e6:83:08',
                                    '1c:c1:de:e6:26:38',
                                    '1c:c1:de:e6:51:54',
                                    '1c:c1:de:e6:53:28',
                                    '1c:c1:de:e6:63:18',
                                    '1c:c1:de:f3:5c:b4',
                                    '2c:76:8a:54:f5:94',
                                    '3c:4a:92:6f:d1:ac',
                                    '3c:4a:92:eb:64:74',
                                    '3c:4a:92:eb:64:1c',
                                    '3c:4a:92:eb:72:68',
                                    '3c:4a:92:eb:72:98',
                                    '3c:4a:92:eb:73:00',
                                    '3c:4a:92:eb:74:18',
                                    '3c:4a:92:eb:82:40',
                                    '3c:4a:92:eb:b2:e8',
                                    '3c:4a:92:eb:b2:54',
                                    '3c:4a:92:eb:b2:5c',
                                    '3c:4a:92:eb:13:cc',
                                    '3c:4a:92:eb:02:54',
                                    '3c:4a:92:eb:d3:64',
                                    '3c:4a:92:eb:d3:b4',
                                    '3c:4a:92:eb:d3:e4',
                                    '3c:4a:92:eb:e3:94',
                                    '3c:4a:92:eb:f2:b0',
                                    '3c:4a:92:eb:32:50',
                                    '3c:4a:92:eb:34:50',
                                    '3c:4a:92:eb:41:14',
                                    '3c:4a:92:ee:bd:b4',
                                    '3c:4a:92:f4:c2:88',
                                    '00:01:d7:8a:76:0c',
                                    '00:01:d7:8a:76:0d',
                                    '78:e3:b5:13:ec:88',
                                    '9c:8e:99:2b:66:2c',
                                    '9c:8e:99:2b:e8:a4',
                                    '9c:8e:99:2d:5d:88',
                                    '1c:c1:de:e5:5d:c8',
                                    '3c:4a:92:eb:d8:18',
                                    '3c:4a:92:eb:29:58',
                                    '3c:4a:92:eb:39:0c',
                                    '3c:4a:92:eb:39:08',
                                    '3c:4a:92:eb:49:2c',
                                    '44:1e:a1:59:6f:fc',
                                    '00:0c:29:09:b4:01',
                                    '00:10:db:ff:10:01',
                                    '00:14:4f:e5:0f:7a',
                                    '68:b5:99:6d:8b:4e',
                                    '68:b5:99:c5:ff:60',
                                    '78:19:f7:05:fa:01',
                                    '1c:c1:de:e6:63:18',
                                    '3c:4a:92:eb:64:78',
                                    '3c:4a:92:eb:b2:9c',
                                    '3c:4a:92:eb:d1:d8',
                                    '3c:4a:92:eb:d3:8c',
                                    '3c:4a:92:eb:e3:94',
                                    '3c:4a:92:eb:23:1c',
                                    '3c:4a:92:eb:34:dc',
                                    '3c:4a:92:ee:bd:f0',
                                    '00:01:d7:8a:76:1f',
                                    '00:50:56:89:6c:aa',
                                    '00:50:56:89:40:da',
                                    '68:b5:99:c5:eb:40',
                                    '78:19:f7:05:fa:01',
                                    '78:19:f7:05:fa:18',
                                    '9c:8e:99:14:a0:30',
                                    '9c:8e:99:14:c0:2c',
                                    '9c:8e:99:14:e0:5c',
                                    '9c:8e:99:15:cd:a0',
                                    '9c:8e:99:2d:1d:2c',
                                    '3c:4a:92:ea:b7:20',
                                    '3c:4a:92:ea:b8:50',
                                    '3c:4a:92:eb:64:b8',
                                    '3c:4a:92:eb:13:c8',
                                    '3c:4a:92:eb:c2:34',
                                    '3c:4a:92:eb:d3:94',
                                    '3c:4a:92:eb:e3:a8',
                                    '3c:4a:92:eb:34:e8',
                                    '00:14:4f:01:f3:52',
                                    '00:14:4f:49:de:5e',
                                    '78:19:f7:05:fa:01',
                                    '78:19:f7:05:fa:18',
                                    '2c:76:8a:54:f5:94',
                                    '00:01:d7:8a:76:0c',
                                    '00:14:1b:33:1c:c0',
                                    '68:b5:99:6d:8b:4e',
                                    '78:e3:b5:0d:c0:cc',
                                    '78:19:f7:05:fa:01',
                                    '78:19:f7:05:fa:18',
                                    '9c:8e:99:14:01:18',
                                    '9c:8e:99:14:c0:28',
                                    '9c:8e:99:14:c0:2c',
                                    '9c:8e:99:14:e0:5c',
                                    '9c:8e:99:15:cd:a0',
                                    '9c:8e:99:1c:a9:2c',
                                    '9c:8e:99:2d:2f:38',
                                    '2c:76:8a:54:f5:94',
                                    '3c:4a:92:f4:c2:88',
                                    '78:19:f7:05:fa:01',
                                    'd4:85:64:cd:5a:f4',
                                    '00:14:4f:01:d6:4a',
                                    '78:e7:d1:f7:73:0c',
                                    '78:e7:d1:f7:14:d4',
                                    '78:19:f7:05:fa:01',
                                    '3c:4a:92:eb:93:a4',
                                    '3c:4a:92:ee:8d:70',
                                    '00:01:d7:8a:76:11',
                                    '00:14:4f:7d:ad:a4',
                                    '78:19:f7:05:fa:01',
                                    '78:19:f7:05:fa:18',
                                    '9c:8e:99:16:35:40',
                                    '00:1b:24:6d:f3:22',
                                    '00:1b:24:3d:e8:9f',
                                    '78:19:f7:05:fa:01',
                                    '00:14:4f:01:d6:16',
                                    '00:14:4f:01:d6:36',
                                    '00:14:4f:01:e2:32',
                                    '00:14:4f:01:e9:5a',
                                    '00:14:4f:01:ff:a2',
                                    '00:14:4f:01:ff:de',
                                    '00:14:4f:9e:cc:2e',
                                    '00:14:4f:02:0e:6e',
                                    '00:14:4f:02:0e:76',
                                    '00:14:4f:02:06:76',
                                    '00:14:4f:49:d7:f6',
                                    '00:14:4f:49:db:4a',
                                    '00:14:4f:49:dd:c2',
                                    '00:14:4f:49:e0:8e',
                                    '00:14:4f:49:e7:a6',
                                    '00:14:4f:4a:1d:02',
                                    '00:14:4f:4a:1d:16',
                                    '00:14:4f:4a:1d:32',
                                    '00:14:4f:4a:1d:4a',
                                    '00:14:4f:4a:1e:6e',
                                    '00:14:4f:4a:1e:7a',
                                    '00:14:4f:4a:1e:02',
                                    '00:14:4f:4a:1f:22',
                                    '00:14:4f:4a:1f:26',
                                    '00:21:28:25:73:66',
                                    '68:b5:99:6d:5b:a6',
                                    '6c:3b:e5:b3:79:f8',
                                    '6c:3b:e5:b3:99:dc',
                                    '6c:3b:e5:b3:a9:84',
                                    '6c:3b:e5:b3:b9:44',
                                    '6c:3b:e5:b3:d9:7c',
                                    '6c:3b:e5:b3:d9:e8',
                                    '6c:3b:e5:b3:2a:20',
                                    '6c:3b:e5:b3:2a:3c',
                                    '74:86:7a:d0:da:d8',
                                    '74:86:7a:d0:dc:04',
                                    '74:86:7a:d0:dc:40',
                                    '74:86:7a:d0:dc:08',
                                    '74:86:7a:d0:dd:06',
                                    '78:19:f7:05:fa:01',
                                    '90:b1:1c:55:b9:ed',
                                    '90:b1:1c:55:13:41',
                                    '90:b1:1c:56:14:b7',
                                    '90:b1:1c:57:09:b2',
                                    '90:b1:1c:57:09:b3',
                                    'd8:9d:67:13:73:54',
                                    'd8:9d:67:13:b6:ec',
                                    'd8:9d:67:13:bf:b0',
                                    'd8:9d:67:13:e1:d4',
                                    'd8:9d:67:13:f1:44',
                                    'd8:9d:67:14:11:dc',
                                    'd8:9d:67:14:09:84',
                                    'd8:9d:67:14:09:a0',
                                    'e4:11:5b:ed:77:a8',
                                    '1c:c1:de:e5:4d:fc',
                                    '2c:76:8a:54:c5:04',
                                    '2c:76:8a:54:c9:ac',
                                    '2c:76:8a:54:d9:d8',
                                    '44:1e:a1:59:8e:c8',
                                    '00:01:d7:8a:76:01',
                                    '00:01:d7:8a:76:0e',
                                    '00:14:4f:01:d6:12',
                                    '00:14:4f:01:e8:92',
                                    '00:19:55:cd:ac:11',
                                    '00:1a:6d:09:8f:32',
                                    '78:19:f7:05:fa:01',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1107787777',
                        IFNAME           => 'Vlan 1',
                        IFDESCR          => 'Vlan 1',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(20260) 0:03:22.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107787783',
                        IFNAME           => 'Vlan 7',
                        IFDESCR          => 'Vlan 7',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504226) 217 days, 1:44:02.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107787819',
                        IFNAME           => 'Vlan 43',
                        IFDESCR          => 'Vlan 43',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(27446) 0:04:34.46',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107787871',
                        IFNAME           => 'Vlan 95',
                        IFDESCR          => 'Vlan 95',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(27450) 0:04:34.50',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107787878',
                        IFNAME           => 'Vlan 102',
                        IFDESCR          => 'Vlan 102',
                        IFALIAS          => 'Net-mgmt',
                        IFTYPE           => '136',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        IP               => '10.20.102.3',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504226) 217 days, 1:44:02.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107787879',
                        IFNAME           => 'Vlan 103',
                        IFDESCR          => 'Vlan 103',
                        IFALIAS          => 'DC Internet',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(27464) 0:04:34.64',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107787980',
                        IFNAME           => 'Vlan 204',
                        IFDESCR          => 'Vlan 204',
                        IFALIAS          => 'Staging-mgmt',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(27470) 0:04:34.70',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107787981',
                        IFNAME           => 'Vlan 205',
                        IFDESCR          => 'Vlan 205',
                        IFALIAS          => 'staging',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(27472) 0:04:34.72',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788217',
                        IFNAME           => 'Vlan 441',
                        IFDESCR          => 'Vlan 441',
                        IFALIAS          => 'ScriptsbilllinG-mgmt',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504226) 217 days, 1:44:02.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788226',
                        IFNAME           => 'Vlan 450',
                        IFDESCR          => 'Vlan 450',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504226) 217 days, 1:44:02.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788229',
                        IFNAME           => 'Vlan 453',
                        IFDESCR          => 'Vlan 453',
                        IFALIAS          => 'MainManage',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27832) 0:04:38.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788230',
                        IFNAME           => 'Vlan 454',
                        IFDESCR          => 'Vlan 454',
                        IFALIAS          => 'WWW_manage',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504226) 217 days, 1:44:02.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788231',
                        IFNAME           => 'Vlan 455',
                        IFDESCR          => 'Vlan 455',
                        IFALIAS          => 'DBS_manage',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504226) 217 days, 1:44:02.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788232',
                        IFNAME           => 'Vlan 456',
                        IFDESCR          => 'Vlan 456',
                        IFALIAS          => 'Scripts_manage',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27798) 0:04:37.98',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788235',
                        IFNAME           => 'Vlan 459',
                        IFDESCR          => 'Vlan 459',
                        IFALIAS          => 'APC_power',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(245728362) 28 days, 10:34:43.62',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788237',
                        IFNAME           => 'Vlan 461',
                        IFDESCR          => 'Vlan 461',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504226) 217 days, 1:44:02.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788240',
                        IFNAME           => 'Vlan 464',
                        IFDESCR          => 'Vlan 464',
                        IFALIAS          => 'PhotoCache_manage',
                        IFTYPE           => '135',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504226) 217 days, 1:44:02.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788241',
                        IFNAME           => 'Vlan 465',
                        IFDESCR          => 'Vlan 465',
                        IFALIAS          => 'DBH_manage',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27780) 0:04:37.80',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788242',
                        IFNAME           => 'Vlan 466',
                        IFDESCR          => 'Vlan 466',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504226) 217 days, 1:44:02.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788243',
                        IFNAME           => 'Vlan 467',
                        IFDESCR          => 'Vlan 467',
                        IFALIAS          => 'CPP_Big_manage',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27590) 0:04:35.90',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788244',
                        IFNAME           => 'Vlan 468',
                        IFDESCR          => 'Vlan 468',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504226) 217 days, 1:44:02.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788245',
                        IFNAME           => 'Vlan 469',
                        IFDESCR          => 'Vlan 469',
                        IFTYPE           => '135',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504226) 217 days, 1:44:02.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788246',
                        IFNAME           => 'Vlan 470',
                        IFDESCR          => 'Vlan 470',
                        IFALIAS          => 'quarantine-mgmt',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504226) 217 days, 1:44:02.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788247',
                        IFNAME           => 'Vlan 471',
                        IFDESCR          => 'Vlan 471',
                        IFALIAS          => 'wap-manage',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504226) 217 days, 1:44:02.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788248',
                        IFNAME           => 'Vlan 472',
                        IFDESCR          => 'Vlan 472',
                        IFALIAS          => 'www-biling-mgmt',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504226) 217 days, 1:44:02.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788256',
                        IFNAME           => 'Vlan 480',
                        IFDESCR          => 'Vlan 480',
                        IFALIAS          => 'bphotos',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504226) 217 days, 1:44:02.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788261',
                        IFNAME           => 'Vlan 485',
                        IFDESCR          => 'Vlan 485',
                        IFALIAS          => 'bphotos-mgmt',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(27622) 0:04:36.22',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788263',
                        IFNAME           => 'Vlan 487',
                        IFDESCR          => 'Vlan 487',
                        IFALIAS          => 'Unreg-mgmt',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504228) 217 days, 1:44:02.28',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788264',
                        IFNAME           => 'Vlan 488',
                        IFDESCR          => 'Vlan 488',
                        IFALIAS          => 'Unreg',
                        IFTYPE           => '135',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(528643146) 61 days, 4:27:11.46',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788265',
                        IFNAME           => 'Vlan 489',
                        IFDESCR          => 'Vlan 489',
                        IFALIAS          => 'splunk-mgmt',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(27632) 0:04:36.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788266',
                        IFNAME           => 'Vlan 490',
                        IFDESCR          => 'Vlan 490',
                        IFALIAS          => 'splunk',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(27636) 0:04:36.36',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788268',
                        IFNAME           => 'Vlan 492',
                        IFDESCR          => 'Vlan 492',
                        IFALIAS          => 'Partner_manage',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504228) 217 days, 1:44:02.28',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788278',
                        IFNAME           => 'Vlan 502',
                        IFDESCR          => 'Vlan 502',
                        IFALIAS          => 'Main_Servers',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504228) 217 days, 1:44:02.28',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788279',
                        IFNAME           => 'Vlan 503',
                        IFDESCR          => 'Vlan 503',
                        IFALIAS          => 'WWW',
                        IFTYPE           => '135',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27662) 0:04:36.62',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788280',
                        IFNAME           => 'Vlan 504',
                        IFDESCR          => 'Vlan 504',
                        IFALIAS          => 'DBS',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504228) 217 days, 1:44:02.28',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788281',
                        IFNAME           => 'Vlan 505',
                        IFDESCR          => 'Vlan 505',
                        IFALIAS          => 'Scripts',
                        IFTYPE           => '135',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27672) 0:04:36.72',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788284',
                        IFNAME           => 'Vlan 508',
                        IFDESCR          => 'Vlan 508',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504228) 217 days, 1:44:02.28',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788285',
                        IFNAME           => 'Vlan 509',
                        IFDESCR          => 'Vlan 509',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504228) 217 days, 1:44:02.28',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788286',
                        IFNAME           => 'Vlan 510',
                        IFDESCR          => 'Vlan 510',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504228) 217 days, 1:44:02.28',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788289',
                        IFNAME           => 'Vlan 513',
                        IFDESCR          => 'Vlan 513',
                        IFALIAS          => 'PhotoCache',
                        IFTYPE           => '135',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504228) 217 days, 1:44:02.28',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788290',
                        IFNAME           => 'Vlan 514',
                        IFDESCR          => 'Vlan 514',
                        IFALIAS          => 'DBH',
                        IFTYPE           => '135',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504228) 217 days, 1:44:02.28',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788291',
                        IFNAME           => 'Vlan 515',
                        IFDESCR          => 'Vlan 515',
                        IFALIAS          => 'CPP_Big',
                        IFTYPE           => '135',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27716) 0:04:37.16',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788292',
                        IFNAME           => 'Vlan 516',
                        IFDESCR          => 'Vlan 516',
                        IFALIAS          => 'Video',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504232) 217 days, 1:44:02.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788293',
                        IFNAME           => 'Vlan 517',
                        IFDESCR          => 'Vlan 517',
                        IFALIAS          => 'NOREPLY',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504232) 217 days, 1:44:02.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788296',
                        IFNAME           => 'Vlan 520',
                        IFDESCR          => 'Vlan 520',
                        IFALIAS          => 'Polyserve3',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504232) 217 days, 1:44:02.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788299',
                        IFNAME           => 'Vlan 523',
                        IFDESCR          => 'Vlan 523',
                        IFALIAS          => 'Polyserve4',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504232) 217 days, 1:44:02.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788302',
                        IFNAME           => 'Vlan 526',
                        IFDESCR          => 'Vlan 526',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504232) 217 days, 1:44:02.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788303',
                        IFNAME           => 'Vlan 527',
                        IFDESCR          => 'Vlan 527',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504232) 217 days, 1:44:02.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788304',
                        IFNAME           => 'Vlan 528',
                        IFDESCR          => 'Vlan 528',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504232) 217 days, 1:44:02.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788305',
                        IFNAME           => 'Vlan 529',
                        IFDESCR          => 'Vlan 529',
                        IFTYPE           => '135',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504232) 217 days, 1:44:02.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788306',
                        IFNAME           => 'Vlan 530',
                        IFDESCR          => 'Vlan 530',
                        IFALIAS          => 'Mail',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504232) 217 days, 1:44:02.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788307',
                        IFNAME           => 'Vlan 531',
                        IFDESCR          => 'Vlan 531',
                        IFALIAS          => 'wap',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504232) 217 days, 1:44:02.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788308',
                        IFNAME           => 'Vlan 532',
                        IFDESCR          => 'Vlan 532',
                        IFALIAS          => 'www-biling',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504232) 217 days, 1:44:02.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788309',
                        IFNAME           => 'Vlan 533',
                        IFDESCR          => 'Vlan 533',
                        IFALIAS          => 'wwwStaff',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(27796) 0:04:37.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788318',
                        IFNAME           => 'Vlan 542',
                        IFDESCR          => 'Vlan 542',
                        IFTYPE           => '135',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27804) 0:04:38.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788319',
                        IFNAME           => 'Vlan 543',
                        IFDESCR          => 'Vlan 543',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504232) 217 days, 1:44:02.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788320',
                        IFNAME           => 'Vlan 544',
                        IFDESCR          => 'Vlan 544',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504232) 217 days, 1:44:02.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788322',
                        IFNAME           => 'Vlan 546',
                        IFDESCR          => 'Vlan 546',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504232) 217 days, 1:44:02.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788379',
                        IFNAME           => 'Vlan 603',
                        IFDESCR          => 'Vlan 603',
                        IFALIAS          => 'Noreplay_servers',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(27826) 0:04:38.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788476',
                        IFNAME           => 'Vlan 700',
                        IFDESCR          => 'Vlan 700',
                        IFALIAS          => 'quarantine',
                        IFTYPE           => '135',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:84:a0:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1875504232) 217 days, 1:44:02.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'force10/s50.01.walk' => [
        {
            TYPE         => 'NETWORKING',
            MANUFACTURER => 'Force10',
            DESCRIPTION  => 'Force10 Networks Real Time Operating System Software
Force10 Operating System Version: 1.0
Force10 Application Software Version: 8.4.2.1
Copyright (c) 1999-2010 by Force10 Networks, Inc.
Build Time: Sun Dec 26 20:21:44 2010',

            SNMPHOSTNAME => 'sw-s50-2-tmk',
            LOCATION     => 'Nowhere',
            CONTACT      => 'admin@foo.bar',
            UPTIME       => '(4242230134) 490 days, 23:58:21.34',
            MAC          => '00:01:e8:d6:a8:f6',
            IPS          => {
                IP => [
                    '10.20.102.9',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'NETWORKING',
                MANUFACTURER => 'Force10',
                COMMENTS     => 'Force10 Networks Real Time Operating System Software
Force10 Operating System Version: 1.0
Force10 Application Software Version: 8.4.2.1
Copyright (c) 1999-2010 by Force10 Networks, Inc.
Build Time: Sun Dec 26 20:21:44 2010',
                NAME         => 'sw-s50-2-tmk',
                LOCATION     => 'Nowhere',
                CONTACT      => 'admin@foo.bar',
                UPTIME       => '(4242230134) 490 days, 23:58:21.34',
                MAC          => '00:01:e8:d6:a8:f6',
                IPS          => {
                    IP => [
                        '10.20.102.9',
                    ],
                },
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '34128898',
                        IFNAME           => 'GigabitEthernet 0/1',
                        IFDESCR          => 'GigabitEthernet 0/1',
                        IFALIAS          => 'cppbig22manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3259324670) 377 days, 5:40:46.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '55740086',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '556602477',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:dc:84:60',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '34391042',
                        IFNAME           => 'GigabitEthernet 0/2',
                        IFDESCR          => 'GigabitEthernet 0/2',
                        IFALIAS          => 'cppbig23manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3268421886) 378 days, 6:56:58.86',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '64509211',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '573514316',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:dc:84:56',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '34653186',
                        IFNAME           => 'GigabitEthernet 0/3',
                        IFDESCR          => 'GigabitEthernet 0/3',
                        IFALIAS          => 'cppbig24manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3224869396) 373 days, 5:58:13.96',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '33579182',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '542928267',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e0:5a:8e',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '34915330',
                        IFNAME           => 'GigabitEthernet 0/4',
                        IFDESCR          => 'GigabitEthernet 0/4',
                        IFALIAS          => 'cppbig25manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3225042672) 373 days, 6:27:06.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '34550236',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '543247028',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:dc:84:a0',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '35177474',
                        IFNAME           => 'GigabitEthernet 0/5',
                        IFDESCR          => 'GigabitEthernet 0/5',
                        IFALIAS          => 'www36manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3224962102) 373 days, 6:13:41.02',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '69448239',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1595213582',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:c1:de:e9:dc:50',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '35439618',
                        IFNAME           => 'GigabitEthernet 0/6',
                        IFDESCR          => 'GigabitEthernet 0/6',
                        IFALIAS          => 'wwwbma1manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4117619792) 476 days, 13:49:57.92',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '46580585',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '403587267',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:c1:de:ea:99:e6',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '35701762',
                        IFNAME           => 'GigabitEthernet 0/7',
                        IFDESCR          => 'GigabitEthernet 0/7',
                        IFALIAS          => 'www37manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3224967836) 373 days, 6:14:38.36',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '69961207',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1595335611',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:c1:de:e9:dc:32',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '35963906',
                        IFNAME           => 'GigabitEthernet 0/8',
                        IFDESCR          => 'GigabitEthernet 0/8',
                        IFALIAS          => 'wwwbma2manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4117619728) 476 days, 13:49:57.28',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '44106306',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '402722310',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:c1:de:e9:4c:d2',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '36226050',
                        IFNAME           => 'GigabitEthernet 0/9',
                        IFDESCR          => 'GigabitEthernet 0/9',
                        IFALIAS          => 'www38manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3313607646) 383 days, 12:27:56.46',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '70578377',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1499598707',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:c1:de:ea:a9:20',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '36488194',
                        IFNAME           => 'GigabitEthernet 0/10',
                        IFDESCR          => 'GigabitEthernet 0/10',
                        IFALIAS          => 'wwwbma3manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4117619794) 476 days, 13:49:57.94',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '98058431',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '487048138',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:c1:de:ea:a9:1c',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '36750338',
                        IFNAME           => 'GigabitEthernet 0/11',
                        IFDESCR          => 'GigabitEthernet 0/11',
                        IFALIAS          => 'www39manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3313607358) 383 days, 12:27:53.58',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '68592184',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1500869141',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:c1:de:ea:79:e2',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '37012482',
                        IFNAME           => 'GigabitEthernet 0/12',
                        IFDESCR          => 'GigabitEthernet 0/12',
                        IFALIAS          => 'wwwbma4manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4117619804) 476 days, 13:49:58.04',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '43289294',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '405224844',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:c1:de:ea:60:88',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '37274626',
                        IFNAME           => 'GigabitEthernet 0/13',
                        IFDESCR          => 'GigabitEthernet 0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3224974260) 373 days, 6:15:42.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '73515717',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1619687429',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:c1:de:e9:dc:b2',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '37536770',
                        IFNAME           => 'GigabitEthernet 0/14',
                        IFDESCR          => 'GigabitEthernet 0/14',
                        IFALIAS          => 'wwwbma5manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4117619806) 476 days, 13:49:58.06',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '113699405',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '468157018',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:c1:de:e9:0c:fc',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '37798914',
                        IFNAME           => 'GigabitEthernet 0/15',
                        IFDESCR          => 'GigabitEthernet 0/15',
                        IFALIAS          => 'wwwbma41manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3224869014) 373 days, 5:58:10.14',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '72223676',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1737637909',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:c1:de:e9:ec:88',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '38061058',
                        IFNAME           => 'GigabitEthernet 0/16',
                        IFDESCR          => 'GigabitEthernet 0/16',
                        IFALIAS          => 'wwwbma6manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4117619730) 476 days, 13:49:57.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '43254828',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '405623042',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:c1:de:e9:2c:64',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '38323202',
                        IFNAME           => 'GigabitEthernet 0/17',
                        IFDESCR          => 'GigabitEthernet 0/17',
                        IFALIAS          => 'wwwbma42manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3224863280) 373 days, 5:57:12.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '70546401',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1737266923',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:c1:de:ea:a9:44',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '38585346',
                        IFNAME           => 'GigabitEthernet 0/18',
                        IFDESCR          => 'GigabitEthernet 0/18',
                        IFALIAS          => 'wwwbma7manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4117619810) 476 days, 13:49:58.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '43134707',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '404978356',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:c1:de:e9:cc:f4',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '38847490',
                        IFNAME           => 'GigabitEthernet 0/19',
                        IFDESCR          => 'GigabitEthernet 0/19',
                        IFALIAS          => 'wwwbma43manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3225042838) 373 days, 6:27:08.38',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '69527709',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1736985651',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd4:85:64:45:c3:24',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '39109634',
                        IFNAME           => 'GigabitEthernet 0/20',
                        IFDESCR          => 'GigabitEthernet 0/20',
                        IFALIAS          => 'wwwbma8manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4117619812) 476 days, 13:49:58.12',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '53276387',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '408533298',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:c1:de:e9:6c:64',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '39371778',
                        IFNAME           => 'GigabitEthernet 0/21',
                        IFDESCR          => 'GigabitEthernet 0/21',
                        IFALIAS          => 'wwwbma44manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3225035846) 373 days, 6:25:58.46',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '69899815',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1737064982',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:c1:de:e9:fc:0c',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '39633922',
                        IFNAME           => 'GigabitEthernet 0/22',
                        IFDESCR          => 'GigabitEthernet 0/22',
                        IFALIAS          => 'wwwbma9manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4117619820) 476 days, 13:49:58.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '51781318',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '407007119',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:c1:de:ea:a9:b8',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '39896066',
                        IFNAME           => 'GigabitEthernet 0/23',
                        IFDESCR          => 'GigabitEthernet 0/23',
                        IFALIAS          => 'wwwbma45manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3225023986) 373 days, 6:23:59.86',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '71605014',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1737208304',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:c1:de:ea:a9:b4',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '40158210',
                        IFNAME           => 'GigabitEthernet 0/24',
                        IFDESCR          => 'GigabitEthernet 0/24',
                        IFALIAS          => 'wwwbma10manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4117619816) 476 days, 13:49:58.16',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '42948037',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '198867979',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:c1:de:e9:1c:3c',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '40420354',
                        IFNAME           => 'GigabitEthernet 0/25',
                        IFDESCR          => 'GigabitEthernet 0/25',
                        IFALIAS          => 'dbs91manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3224980222) 373 days, 6:16:42.22',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '141941341',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1126122080',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e1:3c:c2',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '40682498',
                        IFNAME           => 'GigabitEthernet 0/26',
                        IFDESCR          => 'GigabitEthernet 0/26',
                        IFALIAS          => 'dbs94manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3224961638) 373 days, 6:13:36.38',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '151922269',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1127985771',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e2:92:18',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '40944642',
                        IFNAME           => 'GigabitEthernet 0/27',
                        IFDESCR          => 'GigabitEthernet 0/27',
                        IFALIAS          => 'dbs93manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3224968278) 373 days, 6:14:42.78',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '159449112',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1134747150',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e2:26:a2',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '41206786',
                        IFNAME           => 'GigabitEthernet 0/28',
                        IFDESCR          => 'GigabitEthernet 0/28',
                        IFALIAS          => 'dbs92manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3224973364) 373 days, 6:15:33.64',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '134836238',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1117829204',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e2:16:ae',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '41468930',
                        IFNAME           => 'GigabitEthernet 0/29',
                        IFDESCR          => 'GigabitEthernet 0/29',
                        IFALIAS          => 'dbs95manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3224955520) 373 days, 6:12:35.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '143363403',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1126864504',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e1:ff:6e',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '41731074',
                        IFNAME           => 'GigabitEthernet 0/30',
                        IFDESCR          => 'GigabitEthernet 0/30',
                        IFALIAS          => 'dbs96manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3224949828) 373 days, 6:11:38.28',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '141663096',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1126172416',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e2:16:38',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '41993218',
                        IFNAME           => 'GigabitEthernet 0/31',
                        IFDESCR          => 'GigabitEthernet 0/31',
                        IFALIAS          => 'dbs98manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3224937658) 373 days, 6:09:36.58',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '168419550',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1144215183',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e2:16:7e',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '42255362',
                        IFNAME           => 'GigabitEthernet 0/32',
                        IFDESCR          => 'GigabitEthernet 0/32',
                        IFALIAS          => 'dbs97manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3713233284) 429 days, 18:32:12.84',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '143342489',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1127953877',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e2:16:3c',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '42517506',
                        IFNAME           => 'GigabitEthernet 0/33',
                        IFDESCR          => 'GigabitEthernet 0/33',
                        IFALIAS          => 'dbs100manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3224961948) 373 days, 6:13:39.48',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '149379922',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1126694011',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e2:06:ce',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '42779650',
                        IFNAME           => 'GigabitEthernet 0/34',
                        IFDESCR          => 'GigabitEthernet 0/34',
                        IFALIAS          => 'dbs99manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3224931274) 373 days, 6:08:32.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '152484933',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1129003508',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:4a:92:e2:06:f2',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '43041794',
                        IFNAME           => 'GigabitEthernet 0/35',
                        IFDESCR          => 'GigabitEthernet 0/35',
                        IFALIAS          => 'partner2manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3224972898) 373 days, 6:15:28.98',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '63222701',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3945418118',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd8:d3:85:af:3f:82',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '43303938',
                        IFNAME           => 'GigabitEthernet 0/36',
                        IFDESCR          => 'GigabitEthernet 0/36',
                        IFALIAS          => 'partner1manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3224968176) 373 days, 6:14:41.76',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '82082414',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3950483044',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd4:85:64:cd:5a:f6',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '43566082',
                        IFNAME           => 'GigabitEthernet 0/37',
                        IFDESCR          => 'GigabitEthernet 0/37',
                        IFALIAS          => 'dbs85manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3224949560) 373 days, 6:11:35.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '156952074',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1138890152',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:c1:de:e9:cc:80',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '43828226',
                        IFNAME           => 'GigabitEthernet 0/38',
                        IFDESCR          => 'GigabitEthernet 0/38',
                        IFALIAS          => 'dbs86manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3400943454) 393 days, 15:03:54.54',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '145748385',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1129156577',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd4:85:64:4b:8f:14',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '44090370',
                        IFNAME           => 'GigabitEthernet 0/39',
                        IFDESCR          => 'GigabitEthernet 0/39',
                        IFALIAS          => 'dbs84manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3224955644) 373 days, 6:12:36.44',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '143504278',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1127577433',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:c1:de:e9:cc:7a',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '44352514',
                        IFNAME           => 'GigabitEthernet 0/40',
                        IFDESCR          => 'GigabitEthernet 0/40',
                        IFALIAS          => 'dbs87manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3224936524) 373 days, 6:09:25.24',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '157746444',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1129675044',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:c1:de:e9:dc:22',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '44614658',
                        IFNAME           => 'GigabitEthernet 0/41',
                        IFDESCR          => 'GigabitEthernet 0/41',
                        IFALIAS          => 'dbs83manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3224961926) 373 days, 6:13:39.26',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '154606369',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1135705539',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:c1:de:f1:0c:ae',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '44876802',
                        IFNAME           => 'GigabitEthernet 0/42',
                        IFDESCR          => 'GigabitEthernet 0/42',
                        IFALIAS          => 'dbs88manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3224930718) 373 days, 6:08:27.18',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '176548432',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1148595284',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:c1:de:e9:cc:92',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '45138946',
                        IFNAME           => 'GigabitEthernet 0/43',
                        IFDESCR          => 'GigabitEthernet 0/43',
                        IFALIAS          => 'dbs82manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3224968226) 373 days, 6:14:42.26',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '143939735',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1127723543',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd4:85:64:45:e3:04',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '45401090',
                        IFNAME           => 'GigabitEthernet 0/44',
                        IFDESCR          => 'GigabitEthernet 0/44',
                        IFALIAS          => 'dbs89manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3224924530) 373 days, 6:07:25.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '147979827',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '290907831',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd4:85:64:45:f3:72',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '45663234',
                        IFNAME           => 'GigabitEthernet 0/45',
                        IFDESCR          => 'GigabitEthernet 0/45',
                        IFALIAS          => 'dbs81manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3224973764) 373 days, 6:15:37.64',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '150430584',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1130420872',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd4:85:64:45:b3:fa',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '45925378',
                        IFNAME           => 'GigabitEthernet 0/46',
                        IFDESCR          => 'GigabitEthernet 0/46',
                        IFALIAS          => 'dbs90manage',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3224986366) 373 days, 6:17:43.66',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '146324239',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1130521139',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:c1:de:ea:a9:bc',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '46187522',
                        IFNAME           => 'GigabitEthernet 0/47',
                        IFDESCR          => 'GigabitEthernet 0/47',
                        IFALIAS          => 'brocade4a-1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4236) 0:00:42.36',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2509463639',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1102338353',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:05:33:08:a2:c3',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '46449666',
                        IFNAME           => 'GigabitEthernet 0/48',
                        IFDESCR          => 'GigabitEthernet 0/48',
                        IFALIAS          => 'To sw-c300-2-tmk',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1824220596) 211 days, 3:16:45.96',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2723191902',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4096883411',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:01:d7:c2:03:c0',
                                    '00:01:d7:c5:3b:00',
                                    '00:01:e8:80:ef:b7',
                                    '00:0c:29:d6:b8:64',
                                    '00:10:db:ff:10:01',
                                    '00:14:4f:49:d2:62',
                                    '78:19:f7:05:fa:01',
                                    '00:0c:29:f0:e6:ea',
                                    '00:a0:b8:2a:23:02',
                                    '00:a0:b8:2a:23:18',
                                    '00:a0:b8:33:65:e2',
                                    '00:a0:b8:33:67:06',
                                    '00:a0:b8:33:6d:da',
                                    '00:a0:b8:48:d2:c4',
                                    '00:a0:b8:48:ee:a0',
                                    '00:a0:b8:56:03:20',
                                    '00:14:4f:01:f4:1a',
                                    '00:14:4f:3a:52:16',
                                    '00:40:8c:7d:24:18',
                                    '00:40:8c:7d:24:26',
                                    '00:40:8c:84:b1:b0',
                                    '00:40:8c:9e:d9:60',
                                    '00:40:8c:ab:82:95',
                                    '78:19:f7:05:fa:01',
                                    '6c:3b:e5:b2:66:4c',
                                    '74:86:7a:d0:da:d8',
                                    '74:86:7a:d0:dc:04',
                                    '74:86:7a:d0:dc:40',
                                    '74:86:7a:d0:dc:08',
                                    '74:86:7a:d0:dd:06',
                                    '78:19:f7:05:fa:01',
                                    '00:14:4f:79:25:3c',
                                    '00:03:ba:cd:6c:79',
                                    '00:03:ba:cd:6c:8d',
                                    '00:03:ba:cd:6c:2a',
                                    '00:03:ba:cd:6d:cc',
                                    '00:03:ba:cd:6d:e1',
                                    '00:03:ba:cd:6e:17',
                                    '00:03:ba:cd:6e:34',
                                    '00:03:ba:cd:6f:e1',
                                    '00:03:ba:cd:70:74',
                                    '00:03:ba:cd:70:e5',
                                    '00:03:ba:cd:71:87',
                                    '00:03:ba:cd:71:d3',
                                    '00:03:ba:cd:72:9c',
                                    '00:03:ba:cd:72:f6',
                                    '00:03:ba:cd:75:83',
                                    '00:03:ba:cd:7a:ad',
                                    '00:03:ba:cd:7b:d3',
                                    '00:03:ba:cd:7b:e9',
                                    '00:03:ba:cd:7b:5e',
                                    '78:19:f7:05:fa:01',
                                    'b4:99:ba:05:7c:aa',
                                    '00:14:4f:8c:d0:4d',
                                    '00:14:4f:94:5c:89',
                                    '00:14:4f:9a:39:02',
                                    '00:21:28:75:f2:a8',
                                    '00:21:28:76:14:b0',
                                    '00:21:28:46:80:d8',
                                    '00:21:28:46:80:e8',
                                    '74:86:7a:d7:a6:9c',
                                    '74:86:7a:d7:a7:84',
                                    '74:86:7a:d7:a7:4c',
                                    '74:86:7a:d7:ac:dc',
                                    '74:86:7a:d7:ad:2e',
                                    '74:86:7a:d7:ad:50',
                                    '74:86:7a:d7:b2:a4',
                                    '74:86:7a:d7:b2:fc',
                                    '74:86:7a:d7:b3:9a',
                                    '74:86:7a:d7:b5:2a',
                                    '78:19:f7:05:fa:01',
                                    '3c:4a:92:f8:b7:52',
                                    '78:19:f7:05:fa:01',
                                    '00:14:4f:3a:48:82',
                                    '00:14:4f:3a:48:fc',
                                    '00:14:4f:3a:4a:29',
                                    '00:14:4f:3a:4e:46',
                                    '00:03:ba:cd:6d:83',
                                    '00:03:ba:cd:72:e8',
                                    '78:19:f7:05:fa:01',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1107705856',
                        IFNAME           => 'NULL 0',
                        IFDESCR          => 'NULL 0',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1274) 0:00:12.74',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107787777',
                        IFNAME           => 'Vlan 1',
                        IFDESCR          => 'Vlan 1',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(1274) 0:00:12.74',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107787878',
                        IFNAME           => 'Vlan 102',
                        IFDESCR          => 'Vlan 102',
                        IFALIAS          => 'Net-mgmt',
                        IFTYPE           => '136',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        IP               => '10.20.102.9',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1824220596) 211 days, 3:16:45.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788126',
                        IFNAME           => 'Vlan 350',
                        IFDESCR          => 'Vlan 350',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963067926) 111 days, 11:11:19.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788127',
                        IFNAME           => 'Vlan 351',
                        IFDESCR          => 'Vlan 351',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963068416) 111 days, 11:11:24.16',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788128',
                        IFNAME           => 'Vlan 352',
                        IFDESCR          => 'Vlan 352',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963010180) 111 days, 11:01:41.80',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788129',
                        IFNAME           => 'Vlan 353',
                        IFDESCR          => 'Vlan 353',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963012162) 111 days, 11:02:01.62',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788176',
                        IFNAME           => 'Vlan 400',
                        IFDESCR          => 'Vlan 400',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963003624) 111 days, 11:00:36.24',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788177',
                        IFNAME           => 'Vlan 401',
                        IFDESCR          => 'Vlan 401',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963004190) 111 days, 11:00:41.90',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788178',
                        IFNAME           => 'Vlan 402',
                        IFDESCR          => 'Vlan 402',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963004760) 111 days, 11:00:47.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788179',
                        IFNAME           => 'Vlan 403',
                        IFDESCR          => 'Vlan 403',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963005294) 111 days, 11:00:52.94',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788180',
                        IFNAME           => 'Vlan 404',
                        IFDESCR          => 'Vlan 404',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963005856) 111 days, 11:00:58.56',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788199',
                        IFNAME           => 'Vlan 423',
                        IFDESCR          => 'Vlan 423',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1032144068) 119 days, 11:04:00.68',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788216',
                        IFNAME           => 'Vlan 440',
                        IFDESCR          => 'Vlan 440',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963008882) 111 days, 11:01:28.82',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788217',
                        IFNAME           => 'Vlan 441',
                        IFDESCR          => 'Vlan 441',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963009400) 111 days, 11:01:34.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788218',
                        IFNAME           => 'Vlan 442',
                        IFDESCR          => 'Vlan 442',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963009778) 111 days, 11:01:37.78',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788226',
                        IFNAME           => 'Vlan 450',
                        IFDESCR          => 'Vlan 450',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1168630292) 135 days, 6:11:42.92',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788227',
                        IFNAME           => 'Vlan 451',
                        IFDESCR          => 'Vlan 451',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963010700) 111 days, 11:01:47.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788228',
                        IFNAME           => 'Vlan 452',
                        IFDESCR          => 'Vlan 452',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963011118) 111 days, 11:01:51.18',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788229',
                        IFNAME           => 'Vlan 453',
                        IFDESCR          => 'Vlan 453',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963011618) 111 days, 11:01:56.18',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788230',
                        IFNAME           => 'Vlan 454',
                        IFDESCR          => 'Vlan 454',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3984) 0:00:39.84',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788231',
                        IFNAME           => 'Vlan 455',
                        IFDESCR          => 'Vlan 455',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4106) 0:00:41.06',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788232',
                        IFNAME           => 'Vlan 456',
                        IFDESCR          => 'Vlan 456',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963012784) 111 days, 11:02:07.84',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788233',
                        IFNAME           => 'Vlan 457',
                        IFDESCR          => 'Vlan 457',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963013170) 111 days, 11:02:11.70',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788234',
                        IFNAME           => 'Vlan 458',
                        IFDESCR          => 'Vlan 458',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963037594) 111 days, 11:06:15.94',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788235',
                        IFNAME           => 'Vlan 459',
                        IFDESCR          => 'Vlan 459',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963038530) 111 days, 11:06:25.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788236',
                        IFNAME           => 'Vlan 460',
                        IFDESCR          => 'Vlan 460',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963039442) 111 days, 11:06:34.42',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788237',
                        IFNAME           => 'Vlan 461',
                        IFDESCR          => 'Vlan 461',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963040390) 111 days, 11:06:43.90',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788238',
                        IFNAME           => 'Vlan 462',
                        IFDESCR          => 'Vlan 462',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963041336) 111 days, 11:06:53.36',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788239',
                        IFNAME           => 'Vlan 463',
                        IFDESCR          => 'Vlan 463',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963042270) 111 days, 11:07:02.70',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788240',
                        IFNAME           => 'Vlan 464',
                        IFDESCR          => 'Vlan 464',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963043206) 111 days, 11:07:12.06',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788241',
                        IFNAME           => 'Vlan 465',
                        IFDESCR          => 'Vlan 465',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963044168) 111 days, 11:07:21.68',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788242',
                        IFNAME           => 'Vlan 466',
                        IFDESCR          => 'Vlan 466',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963064348) 111 days, 11:10:43.48',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788243',
                        IFNAME           => 'Vlan 467',
                        IFDESCR          => 'Vlan 467',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3516) 0:00:35.16',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788244',
                        IFNAME           => 'Vlan 468',
                        IFDESCR          => 'Vlan 468',
                        IFTYPE           => '135',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1764502860) 204 days, 5:23:48.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788245',
                        IFNAME           => 'Vlan 469',
                        IFDESCR          => 'Vlan 469',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(535235006) 61 days, 22:45:50.06',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788246',
                        IFNAME           => 'Vlan 470',
                        IFDESCR          => 'Vlan 470',
                        IFTYPE           => '135',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2574242042) 297 days, 22:40:20.42',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788247',
                        IFNAME           => 'Vlan 471',
                        IFDESCR          => 'Vlan 471',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963065810) 111 days, 11:10:58.10',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788248',
                        IFNAME           => 'Vlan 472',
                        IFDESCR          => 'Vlan 472',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963066228) 111 days, 11:11:02.28',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788256',
                        IFNAME           => 'Vlan 480',
                        IFDESCR          => 'Vlan 480',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963068812) 111 days, 11:11:28.12',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788261',
                        IFNAME           => 'Vlan 485',
                        IFDESCR          => 'Vlan 485',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963069336) 111 days, 11:11:33.36',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788263',
                        IFNAME           => 'Vlan 487',
                        IFDESCR          => 'Vlan 487',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963069746) 111 days, 11:11:37.46',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788264',
                        IFNAME           => 'Vlan 488',
                        IFDESCR          => 'Vlan 488',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963070216) 111 days, 11:11:42.16',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788265',
                        IFNAME           => 'Vlan 489',
                        IFDESCR          => 'Vlan 489',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963070702) 111 days, 11:11:47.02',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788266',
                        IFNAME           => 'Vlan 490',
                        IFDESCR          => 'Vlan 490',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963071290) 111 days, 11:11:52.90',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788267',
                        IFNAME           => 'Vlan 491',
                        IFDESCR          => 'Vlan 491',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963001664) 111 days, 11:00:16.64',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788268',
                        IFNAME           => 'Vlan 492',
                        IFDESCR          => 'Vlan 492',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(696141076) 80 days, 13:43:30.76',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788276',
                        IFNAME           => 'Vlan 500',
                        IFDESCR          => 'Vlan 500',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963071840) 111 days, 11:11:58.40',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788277',
                        IFNAME           => 'Vlan 501',
                        IFDESCR          => 'Vlan 501',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963072300) 111 days, 11:12:03.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788278',
                        IFNAME           => 'Vlan 502',
                        IFDESCR          => 'Vlan 502',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963072676) 111 days, 11:12:06.76',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788279',
                        IFNAME           => 'Vlan 503',
                        IFDESCR          => 'Vlan 503',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963073176) 111 days, 11:12:11.76',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788280',
                        IFNAME           => 'Vlan 504',
                        IFDESCR          => 'Vlan 504',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963073684) 111 days, 11:12:16.84',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788281',
                        IFNAME           => 'Vlan 505',
                        IFDESCR          => 'Vlan 505',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963008306) 111 days, 11:01:23.06',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788282',
                        IFNAME           => 'Vlan 506',
                        IFDESCR          => 'Vlan 506',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963074262) 111 days, 11:12:22.62',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788283',
                        IFNAME           => 'Vlan 507',
                        IFDESCR          => 'Vlan 507',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963074768) 111 days, 11:12:27.68',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788284',
                        IFNAME           => 'Vlan 508',
                        IFDESCR          => 'Vlan 508',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963075134) 111 days, 11:12:31.34',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788285',
                        IFNAME           => 'Vlan 509',
                        IFDESCR          => 'Vlan 509',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(963075428) 111 days, 11:12:34.28',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788286',
                        IFNAME           => 'Vlan 510',
                        IFDESCR          => 'Vlan 510',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963094942) 111 days, 11:15:49.42',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788287',
                        IFNAME           => 'Vlan 511',
                        IFDESCR          => 'Vlan 511',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963095874) 111 days, 11:15:58.74',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788288',
                        IFNAME           => 'Vlan 512',
                        IFDESCR          => 'Vlan 512',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(962970922) 111 days, 10:55:09.22',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788289',
                        IFNAME           => 'Vlan 513',
                        IFDESCR          => 'Vlan 513',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(962971310) 111 days, 10:55:13.10',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788290',
                        IFNAME           => 'Vlan 514',
                        IFDESCR          => 'Vlan 514',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(962972262) 111 days, 10:55:22.62',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788291',
                        IFNAME           => 'Vlan 515',
                        IFDESCR          => 'Vlan 515',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(962973210) 111 days, 10:55:32.10',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788292',
                        IFNAME           => 'Vlan 516',
                        IFDESCR          => 'Vlan 516',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(962974150) 111 days, 10:55:41.50',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788293',
                        IFNAME           => 'Vlan 517',
                        IFDESCR          => 'Vlan 517',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(962975098) 111 days, 10:55:50.98',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788294',
                        IFNAME           => 'Vlan 518',
                        IFDESCR          => 'Vlan 518',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(962976034) 111 days, 10:56:00.34',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788295',
                        IFNAME           => 'Vlan 519',
                        IFDESCR          => 'Vlan 519',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(962976986) 111 days, 10:56:09.86',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788296',
                        IFNAME           => 'Vlan 520',
                        IFDESCR          => 'Vlan 520',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(962977998) 111 days, 10:56:19.98',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788297',
                        IFNAME           => 'Vlan 521',
                        IFDESCR          => 'Vlan 521',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(962978944) 111 days, 10:56:29.44',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788299',
                        IFNAME           => 'Vlan 523',
                        IFDESCR          => 'Vlan 523',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(962980834) 111 days, 10:56:48.34',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788300',
                        IFNAME           => 'Vlan 524',
                        IFDESCR          => 'Vlan 524',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(962981796) 111 days, 10:56:57.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788302',
                        IFNAME           => 'Vlan 526',
                        IFDESCR          => 'Vlan 526',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963002584) 111 days, 11:00:25.84',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788303',
                        IFNAME           => 'Vlan 527',
                        IFDESCR          => 'Vlan 527',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963003162) 111 days, 11:00:31.62',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788304',
                        IFNAME           => 'Vlan 528',
                        IFDESCR          => 'Vlan 528',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963032882) 111 days, 11:05:28.82',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788305',
                        IFNAME           => 'Vlan 529',
                        IFDESCR          => 'Vlan 529',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963033818) 111 days, 11:05:38.18',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788306',
                        IFNAME           => 'Vlan 530',
                        IFDESCR          => 'Vlan 530',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963034762) 111 days, 11:05:47.62',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788307',
                        IFNAME           => 'Vlan 531',
                        IFDESCR          => 'Vlan 531',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963035696) 111 days, 11:05:56.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788308',
                        IFNAME           => 'Vlan 532',
                        IFDESCR          => 'Vlan 532',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963036634) 111 days, 11:06:06.34',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788318',
                        IFNAME           => 'Vlan 542',
                        IFDESCR          => 'Vlan 542',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963006336) 111 days, 11:01:03.36',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788319',
                        IFNAME           => 'Vlan 543',
                        IFDESCR          => 'Vlan 543',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963006748) 111 days, 11:01:07.48',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788320',
                        IFNAME           => 'Vlan 544',
                        IFDESCR          => 'Vlan 544',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963007224) 111 days, 11:01:12.24',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788321',
                        IFNAME           => 'Vlan 545',
                        IFDESCR          => 'Vlan 545',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963007700) 111 days, 11:01:17.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788322',
                        IFNAME           => 'Vlan 546',
                        IFDESCR          => 'Vlan 546',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1032143764) 119 days, 11:03:57.64',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788376',
                        IFNAME           => 'Vlan 600',
                        IFDESCR          => 'Vlan 600',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963063680) 111 days, 11:10:36.80',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788377',
                        IFNAME           => 'Vlan 601',
                        IFDESCR          => 'Vlan 601',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963066726) 111 days, 11:11:07.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1107788378',
                        IFNAME           => 'Vlan 602',
                        IFDESCR          => 'Vlan 602',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1554',
                        MAC              => '00:01:e8:d6:a8:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(963067388) 111 days, 11:11:13.88',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
);

plan skip_all => 'SNMP walks database required'
    if !$ENV{SNMPWALK_DATABASE};
plan tests => 2 * scalar keys %tests;

foreach my $test (sort keys %tests) {
    my $snmp  = FusionInventory::Agent::SNMP::Mock->new(
        file => "$ENV{SNMPWALK_DATABASE}/$test"
    );

    my %discovery = getDeviceInfo(
        snmp    => $snmp,
        datadir => './share'
    );
    cmp_deeply(
        \%discovery,
        $tests{$test}->[0],
        "$test: discovery"
    );

    my $inventory = getDeviceFullInfo(
        snmp    => $snmp,
        datadir => './share'
    );
    cmp_deeply(
        $inventory,
        $tests{$test}->[1],
        "$test: inventory"
    );
}
