#============================================================= -*-Perl-*-
#
# Template::Grammar
#
# DESCRIPTION
#   Grammar file for the Template Toolkit language containing token
#   definitions and parser state/rules tables generated by Parse::Yapp.
#
# AUTHOR
#   Andy Wardley   <abw@kfs.org>
#
# COPYRIGHT
#   Copyright (C) 1996-2000 Andy Wardley.  All Rights Reserved.
#   Copyright (C) 1998-2000 Canon Research Centre Europe Ltd.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the same terms as Perl itself.
#
#------------------------------------------------------------------------
#
# NOTE: this module is constructed from the parser/Grammar.pm.skel
# file by running the parser/yc script.  You only need to do this if 
# you have modified the grammar in the parser/Parser.yp file and need
# to-recompile it.  See the README in the 'parser' directory for more
# information (sub-directory of the Template distribution).
#
#------------------------------------------------------------------------
#
# $Id: Grammar.pm,v 2.17 2002/07/19 13:29:38 abw Exp $
#
#========================================================================

package Template::Grammar;

require 5.004;

use strict;
use vars qw( $VERSION );

$VERSION  = sprintf("%d.%02d", q$Revision: 2.17 $ =~ /(\d+)\.(\d+)/);

my (@RESERVED, %CMPOP, $LEXTABLE, $RULES, $STATES);
my ($factory, $rawstart);


#========================================================================

# Reserved words, comparison and binary operators
#========================================================================

@RESERVED = qw( 
	GET CALL SET DEFAULT INSERT INCLUDE PROCESS WRAPPER BLOCK END
	USE PLUGIN FILTER MACRO PERL RAWPERL TO STEP AND OR NOT DIV MOD
	IF UNLESS ELSE ELSIF FOR NEXT WHILE SWITCH CASE META
	TRY THROW CATCH FINAL LAST RETURN STOP CLEAR VIEW DEBUG
    );

# for historical reasons, != and == are converted to ne and eq to perform 
# stringwise comparison (mainly because it doesn't generate "non-numerical 
# comparison" warnings which != and == can) but the others (e.g. < > <= >=)
# are not converted to their stringwise equivalents.  I added 'gt' et al, 
# briefly for v2.04d and then took them out again in 2.04e.

%CMPOP = qw( 
    != ne
    == eq
    <  <
    >  >
    >= >=
    <= <=
);


#========================================================================
# Lexer Token Table
#========================================================================

# lookup table used by lexer is initialised with special-cases
$LEXTABLE = {
    'FOREACH' => 'FOR',
    'BREAK'   => 'LAST',
    '&&'      => 'AND',
    '||'      => 'OR',
    '!'       => 'NOT',
    '|'	      => 'FILTER',
    '.'       => 'DOT',
    '_'       => 'CAT',
    '..'      => 'TO',
#    ':'       => 'MACRO',
    '='       => 'ASSIGN',
    '=>'      => 'ASSIGN',
#    '->'      => 'ARROW',
    ','       => 'COMMA',
    '\\'      => 'REF',
    'and'     => 'AND',		# explicitly specified so that qw( and or
    'or'      => 'OR',		# not ) can always be used in lower case, 
    'not'     => 'NOT',		# regardless of ANYCASE flag
    'mod'     => 'MOD',
    'div'     => 'DIV',
};

# localise the temporary variables needed to complete lexer table
{ 
#    my @tokens = qw< ( ) [ ] { } ${ $ / ; : ? >;
    my @tokens = qw< ( ) [ ] { } ${ $ + / ; : ? >;
    my @cmpop  = keys %CMPOP;
#    my @binop  = qw( + - * % );              # '/' above, in @tokens
    my @binop  = qw( - * % );              # '+' and '/' above, in @tokens

    # fill lexer table, slice by slice, with reserved words and operators
    @$LEXTABLE{ @RESERVED, @cmpop, @binop, @tokens } 
	= ( @RESERVED, ('CMPOP') x @cmpop, ('BINOP') x @binop, @tokens );
}


#========================================================================
# CLASS METHODS
#========================================================================

sub new {
    my $class = shift;
    bless {
	LEXTABLE => $LEXTABLE,
	STATES   => $STATES,
	RULES    => $RULES,
    }, $class;
}

# update method to set package-scoped $factory lexical 
sub install_factory {
    my ($self, $new_factory) = @_;
    $factory = $new_factory;
}


#========================================================================
# States
#========================================================================

$STATES = [
	{#State 0
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			"\"" => 45,
			'BLOCK' => 44,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'DEBUG' => 48,
			'PROCESS' => 8,
			"\${" => 50,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 52,
			"[" => 54,
			'DEFAULT' => 53,
			"{" => 17,
			'THROW' => 58,
			'CALL' => 57,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 60,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 63,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 65,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 68,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 70,
			'IF' => 72
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 61,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'defblockname' => 62,
			'switch' => 46,
			'block' => 30,
			'anonblock' => 49,
			'perl' => 64,
			'ident' => 9,
			'filter' => 66,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 67,
			'statement' => 15,
			'chunks' => 51,
			'wrapper' => 40,
			'atomexpr' => 69,
			'loop' => 56,
			'defblock' => 55,
			'capture' => 18,
			'template' => 42,
			'expr' => 19,
			'assign' => 71,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 1
		DEFAULT => -103
	},
	{#State 2
		DEFAULT => -112
	},
	{#State 3
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 75,
			'item' => 25,
			'ident' => 74,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 4
		DEFAULT => -24
	},
	{#State 5
		ACTIONS => {
			";" => -20
		},
		DEFAULT => -27
	},
	{#State 6
		DEFAULT => -77,
		GOTOS => {
			'@5-1' => 77
		}
	},
	{#State 7
		ACTIONS => {
			'IDENT' => 78
		}
	},
	{#State 8
		ACTIONS => {
			'NUMBER' => 79,
			"\"" => 85,
			'FILENAME' => 81,
			'LITERAL' => 86,
			'IDENT' => 83,
			"\$" => 80
		},
		GOTOS => {
			'nameargs' => 88,
			'filename' => 82,
			'filepart' => 87,
			'names' => 89,
			'name' => 84
		}
	},
	{#State 9
		ACTIONS => {
			'DOT' => 90,
			'ASSIGN' => 91
		},
		DEFAULT => -108
	},
	{#State 10
		DEFAULT => -15
	},
	{#State 11
		DEFAULT => -6
	},
	{#State 12
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 52,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 93,
			'assign' => 94,
			'item' => 25,
			'ident' => 92,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 13
		DEFAULT => -21
	},
	{#State 14
		DEFAULT => -12
	},
	{#State 15
		ACTIONS => {
			";" => 95
		}
	},
	{#State 16
		ACTIONS => {
			'IDENT' => 97
		},
		GOTOS => {
			'meta' => 98,
			'metadata' => 96
		}
	},
	{#State 17
		ACTIONS => {
			"\${" => 50,
			'LITERAL' => 101,
			'IDENT' => 28,
			"\$" => 7
		},
		DEFAULT => -118,
		GOTOS => {
			'param' => 103,
			'params' => 99,
			'item' => 100,
			'hash' => 102
		}
	},
	{#State 18
		DEFAULT => -11
	},
	{#State 19
		ACTIONS => {
			'CAT' => 111,
			'AND' => 107,
			'CMPOP' => 108,
			'MOD' => 104,
			'BINOP' => 106,
			'OR' => 109,
			"+" => 112,
			";" => -16,
			'DIV' => 110,
			"/" => 113,
			"?" => 105
		},
		DEFAULT => -26
	},
	{#State 20
		DEFAULT => -102
	},
	{#State 21
		ACTIONS => {
			'NUMBER' => 79,
			"\"" => 85,
			'FILENAME' => 81,
			'LITERAL' => 86,
			'IDENT' => 83,
			"\$" => 80
		},
		GOTOS => {
			'nameargs' => 114,
			'filename' => 82,
			'filepart' => 87,
			'names' => 89,
			'name' => 84
		}
	},
	{#State 22
		ACTIONS => {
			'NUMBER' => 79,
			"\"" => 85,
			'FILENAME' => 81,
			'LITERAL' => 86,
			'IDENT' => 83,
			"\$" => 80
		},
		GOTOS => {
			'nameargs' => 115,
			'filename' => 82,
			'filepart' => 87,
			'names' => 89,
			'name' => 84
		}
	},
	{#State 23
		ACTIONS => {
			"\${" => 50,
			'LITERAL' => 118,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'assign' => 71,
			'setlist' => 117,
			'item' => 25,
			'ident' => 116,
			'node' => 59
		}
	},
	{#State 24
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 119,
			'item' => 25,
			'ident' => 74,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 25
		ACTIONS => {
			"(" => 120
		},
		DEFAULT => -127
	},
	{#State 26
		ACTIONS => {
			'COMMA' => 121,
			"\${" => 50,
			'LITERAL' => 118,
			'IDENT' => 28,
			"\$" => 7
		},
		DEFAULT => -19,
		GOTOS => {
			'assign' => 122,
			'item' => 25,
			'ident' => 116,
			'node' => 59
		}
	},
	{#State 27
		DEFAULT => -5
	},
	{#State 28
		DEFAULT => -129
	},
	{#State 29
		ACTIONS => {
			";" => 123
		}
	},
	{#State 30
		DEFAULT => -1
	},
	{#State 31
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 124,
			'item' => 25,
			'ident' => 74,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 32
		ACTIONS => {
			"\${" => 50,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'item' => 25,
			'ident' => 125,
			'node' => 59
		}
	},
	{#State 33
		ACTIONS => {
			'IDENT' => 126
		}
	},
	{#State 34
		ACTIONS => {
			'NUMBER' => 79,
			"\"" => 85,
			'FILENAME' => 81,
			'LITERAL' => 86,
			'IDENT' => 83,
			"\$" => 80
		},
		GOTOS => {
			'nameargs' => 127,
			'filename' => 82,
			'filepart' => 87,
			'names' => 89,
			'name' => 84
		}
	},
	{#State 35
		ACTIONS => {
			'NUMBER' => 79,
			"\"" => 85,
			'FILENAME' => 81,
			'LITERAL' => 86,
			'IDENT' => 83,
			"\$" => 80
		},
		GOTOS => {
			'nameargs' => 128,
			'filename' => 82,
			'filepart' => 87,
			'names' => 89,
			'name' => 84
		}
	},
	{#State 36
		DEFAULT => -8
	},
	{#State 37
		ACTIONS => {
			'NUMBER' => 79,
			"\"" => 133,
			"\${" => 50,
			'FILENAME' => 81,
			'LITERAL' => 134,
			'IDENT' => 131,
			"\$" => 129
		},
		GOTOS => {
			'lvalue' => 135,
			'lnameargs' => 132,
			'nameargs' => 136,
			'item' => 130,
			'filename' => 82,
			'filepart' => 87,
			'name' => 84,
			'names' => 89
		}
	},
	{#State 38
		DEFAULT => -36
	},
	{#State 39
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 137,
			'item' => 25,
			'ident' => 74,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 40
		DEFAULT => -42
	},
	{#State 41
		DEFAULT => -39
	},
	{#State 42
		ACTIONS => {
			'' => 138
		}
	},
	{#State 43
		ACTIONS => {
			";" => 139
		}
	},
	{#State 44
		ACTIONS => {
			'NUMBER' => 79,
			'FILENAME' => 81,
			'LITERAL' => 145,
			'IDENT' => 143
		},
		DEFAULT => -86,
		GOTOS => {
			'meta' => 98,
			'blockname' => 144,
			'filename' => 142,
			'blockargs' => 140,
			'filepart' => 87,
			'metadata' => 141
		}
	},
	{#State 45
		DEFAULT => -175,
		GOTOS => {
			'quoted' => 146
		}
	},
	{#State 46
		DEFAULT => -22
	},
	{#State 47
		ACTIONS => {
			'NUMBER' => 79,
			"\"" => 133,
			"\${" => 50,
			'FILENAME' => 81,
			'LITERAL' => 134,
			'IDENT' => 131,
			"\$" => 129
		},
		GOTOS => {
			'lvalue' => 135,
			'lnameargs' => 147,
			'nameargs' => 136,
			'item' => 130,
			'filename' => 82,
			'filepart' => 87,
			'name' => 84,
			'names' => 89
		}
	},
	{#State 48
		ACTIONS => {
			'NUMBER' => 79,
			"\"" => 85,
			'FILENAME' => 81,
			'LITERAL' => 86,
			'IDENT' => 83,
			"\$" => 80
		},
		GOTOS => {
			'nameargs' => 148,
			'filename' => 82,
			'filepart' => 87,
			'names' => 89,
			'name' => 84
		}
	},
	{#State 49
		DEFAULT => -10
	},
	{#State 50
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			"\${" => 50,
			'REF' => 32,
			'LITERAL' => 76,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'sterm' => 149,
			'item' => 25,
			'ident' => 74,
			'node' => 59
		}
	},
	{#State 51
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'DEBUG' => 48,
			'PROCESS' => 8,
			"\${" => 50,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 52,
			'DEFAULT' => 53,
			"[" => 54,
			"{" => 17,
			'CALL' => 57,
			'THROW' => 58,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 60,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 63,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 65,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 68,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 70,
			'IF' => 72
		},
		DEFAULT => -2,
		GOTOS => {
			'sterm' => 1,
			'view' => 61,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 150,
			'atomdir' => 5,
			'defblockname' => 62,
			'switch' => 46,
			'anonblock' => 49,
			'perl' => 64,
			'ident' => 9,
			'filter' => 66,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 67,
			'statement' => 15,
			'wrapper' => 40,
			'atomexpr' => 69,
			'defblock' => 55,
			'loop' => 56,
			'capture' => 18,
			'expr' => 19,
			'assign' => 71,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 52
		ACTIONS => {
			'ASSIGN' => 151
		},
		DEFAULT => -111
	},
	{#State 53
		ACTIONS => {
			"\${" => 50,
			'LITERAL' => 118,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'assign' => 71,
			'setlist' => 152,
			'item' => 25,
			'ident' => 116,
			'node' => 59
		}
	},
	{#State 54
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			"]" => 155,
			'REF' => 32,
			"\${" => 50
		},
		GOTOS => {
			'sterm' => 153,
			'list' => 154,
			'range' => 156,
			'item' => 25,
			'ident' => 74,
			'term' => 157,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 55
		DEFAULT => -9
	},
	{#State 56
		DEFAULT => -23
	},
	{#State 57
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 158,
			'item' => 25,
			'ident' => 74,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 58
		ACTIONS => {
			'NUMBER' => 79,
			"\"" => 85,
			'FILENAME' => 81,
			'LITERAL' => 86,
			'IDENT' => 83,
			"\$" => 80
		},
		GOTOS => {
			'nameargs' => 159,
			'filename' => 82,
			'filepart' => 87,
			'names' => 89,
			'name' => 84
		}
	},
	{#State 59
		DEFAULT => -126
	},
	{#State 60
		DEFAULT => -37
	},
	{#State 61
		DEFAULT => -14
	},
	{#State 62
		ACTIONS => {
			'IDENT' => 97
		},
		DEFAULT => -86,
		GOTOS => {
			'meta' => 98,
			'blockargs' => 160,
			'metadata' => 141
		}
	},
	{#State 63
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 161,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50
		},
		GOTOS => {
			'sterm' => 1,
			'item' => 25,
			'ident' => 74,
			'term' => 163,
			'lterm' => 20,
			'loopvar' => 162,
			'node' => 59
		}
	},
	{#State 64
		DEFAULT => -25
	},
	{#State 65
		DEFAULT => -38
	},
	{#State 66
		DEFAULT => -43
	},
	{#State 67
		DEFAULT => -13
	},
	{#State 68
		DEFAULT => -40
	},
	{#State 69
		ACTIONS => {
			'FOR' => 168,
			'UNLESS' => 164,
			'IF' => 169,
			'WHILE' => 166,
			'FILTER' => 167,
			'WRAPPER' => 165
		}
	},
	{#State 70
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 170,
			'item' => 25,
			'ident' => 74,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 71
		DEFAULT => -148
	},
	{#State 72
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 171,
			'item' => 25,
			'ident' => 74,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 73
		DEFAULT => -145
	},
	{#State 74
		ACTIONS => {
			'DOT' => 90
		},
		DEFAULT => -108
	},
	{#State 75
		ACTIONS => {
			'CAT' => 111,
			'CMPOP' => 108,
			'MOD' => 104,
			'BINOP' => 106,
			"+" => 112,
			'DIV' => 110,
			"/" => 113
		},
		DEFAULT => -141
	},
	{#State 76
		DEFAULT => -111
	},
	{#State 77
		ACTIONS => {
			";" => 172
		}
	},
	{#State 78
		DEFAULT => -131
	},
	{#State 79
		DEFAULT => -173
	},
	{#State 80
		ACTIONS => {
			"\${" => 50,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'item' => 25,
			'ident' => 173,
			'node' => 59
		}
	},
	{#State 81
		DEFAULT => -171
	},
	{#State 82
		ACTIONS => {
			'DOT' => 174
		},
		DEFAULT => -167
	},
	{#State 83
		DEFAULT => -172
	},
	{#State 84
		DEFAULT => -165
	},
	{#State 85
		DEFAULT => -175,
		GOTOS => {
			'quoted' => 175
		}
	},
	{#State 86
		DEFAULT => -168
	},
	{#State 87
		DEFAULT => -170
	},
	{#State 88
		DEFAULT => -34
	},
	{#State 89
		ACTIONS => {
			"(" => 177,
			"+" => 178
		},
		DEFAULT => -155,
		GOTOS => {
			'args' => 176
		}
	},
	{#State 90
		ACTIONS => {
			'NUMBER' => 179,
			"\${" => 50,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'item' => 25,
			'node' => 180
		}
	},
	{#State 91
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 184,
			"\"" => 45,
			'NOT' => 3,
			'FILTER' => 47,
			"\$" => 7,
			'DEBUG' => 48,
			'PROCESS' => 8,
			"\${" => 50,
			"(" => 12,
			'LITERAL' => 52,
			'DEFAULT' => 53,
			"[" => 54,
			"{" => 17,
			'CALL' => 57,
			'THROW' => 58,
			'INSERT' => 22,
			'SET' => 23,
			'STOP' => 60,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 63,
			'UNLESS' => 31,
			'REF' => 32,
			'CLEAR' => 65,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'NEXT' => 68,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 70,
			'IF' => 72
		},
		GOTOS => {
			'directive' => 183,
			'sterm' => 1,
			'mdir' => 181,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'atomdir' => 5,
			'wrapper' => 40,
			'switch' => 46,
			'atomexpr' => 69,
			'loop' => 56,
			'expr' => 182,
			'assign' => 71,
			'perl' => 64,
			'ident' => 92,
			'term' => 73,
			'filter' => 66,
			'lterm' => 20,
			'node' => 59,
			'condition' => 13
		}
	},
	{#State 92
		ACTIONS => {
			'DOT' => 90,
			'ASSIGN' => 185
		},
		DEFAULT => -108
	},
	{#State 93
		ACTIONS => {
			'MOD' => 104,
			")" => 186,
			'BINOP' => 106,
			"+" => 112,
			'CAT' => 111,
			'OR' => 109,
			'AND' => 107,
			'DIV' => 110,
			'CMPOP' => 108,
			"/" => 113,
			"?" => 105
		}
	},
	{#State 94
		ACTIONS => {
			")" => 187
		}
	},
	{#State 95
		DEFAULT => -7
	},
	{#State 96
		ACTIONS => {
			'COMMA' => 188,
			'IDENT' => 97
		},
		DEFAULT => -17,
		GOTOS => {
			'meta' => 189
		}
	},
	{#State 97
		ACTIONS => {
			'ASSIGN' => 190
		}
	},
	{#State 98
		DEFAULT => -98
	},
	{#State 99
		ACTIONS => {
			'COMMA' => 191,
			"\${" => 50,
			'LITERAL' => 101,
			'IDENT' => 28,
			"\$" => 7
		},
		DEFAULT => -117,
		GOTOS => {
			'param' => 192,
			'item' => 100
		}
	},
	{#State 100
		ACTIONS => {
			'ASSIGN' => 193
		}
	},
	{#State 101
		ACTIONS => {
			'ASSIGN' => 194
		}
	},
	{#State 102
		ACTIONS => {
			"}" => 195
		}
	},
	{#State 103
		DEFAULT => -121
	},
	{#State 104
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 196,
			'item' => 25,
			'ident' => 74,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 105
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 197,
			'item' => 25,
			'ident' => 74,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 106
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 198,
			'item' => 25,
			'ident' => 74,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 107
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 199,
			'item' => 25,
			'ident' => 74,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 108
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 200,
			'item' => 25,
			'ident' => 74,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 109
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 201,
			'item' => 25,
			'ident' => 74,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 110
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 202,
			'item' => 25,
			'ident' => 74,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 111
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 203,
			'item' => 25,
			'ident' => 74,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 112
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 204,
			'item' => 25,
			'ident' => 74,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 113
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 205,
			'item' => 25,
			'ident' => 74,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 114
		ACTIONS => {
			";" => 206
		}
	},
	{#State 115
		DEFAULT => -32
	},
	{#State 116
		ACTIONS => {
			'DOT' => 90,
			'ASSIGN' => 185
		}
	},
	{#State 117
		ACTIONS => {
			'LITERAL' => 118,
			'IDENT' => 28,
			"\$" => 7,
			'COMMA' => 121,
			"\${" => 50
		},
		DEFAULT => -30,
		GOTOS => {
			'assign' => 122,
			'item' => 25,
			'ident' => 116,
			'node' => 59
		}
	},
	{#State 118
		ACTIONS => {
			'ASSIGN' => 151
		}
	},
	{#State 119
		ACTIONS => {
			'MOD' => 104,
			'BINOP' => 106,
			"+" => 112,
			'CAT' => 111,
			'OR' => 109,
			";" => 207,
			'AND' => 107,
			'DIV' => 110,
			'CMPOP' => 108,
			"/" => 113,
			"?" => 105
		}
	},
	{#State 120
		DEFAULT => -155,
		GOTOS => {
			'args' => 208
		}
	},
	{#State 121
		DEFAULT => -147
	},
	{#State 122
		DEFAULT => -146
	},
	{#State 123
		DEFAULT => -75,
		GOTOS => {
			'@4-2' => 209
		}
	},
	{#State 124
		ACTIONS => {
			'MOD' => 104,
			'BINOP' => 106,
			"+" => 112,
			'CAT' => 111,
			'OR' => 109,
			";" => 210,
			'AND' => 107,
			'DIV' => 110,
			'CMPOP' => 108,
			"/" => 113,
			"?" => 105
		}
	},
	{#State 125
		ACTIONS => {
			'DOT' => 90
		},
		DEFAULT => -109
	},
	{#State 126
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 184,
			"\"" => 45,
			'NOT' => 3,
			'FILTER' => 47,
			"\$" => 7,
			'DEBUG' => 48,
			'PROCESS' => 8,
			"\${" => 50,
			"(" => 211,
			'LITERAL' => 52,
			'DEFAULT' => 53,
			"[" => 54,
			"{" => 17,
			'CALL' => 57,
			'THROW' => 58,
			'INSERT' => 22,
			'SET' => 23,
			'STOP' => 60,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 63,
			'UNLESS' => 31,
			'REF' => 32,
			'CLEAR' => 65,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'NEXT' => 68,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 70,
			'IF' => 72
		},
		GOTOS => {
			'directive' => 183,
			'sterm' => 1,
			'mdir' => 212,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'atomdir' => 5,
			'wrapper' => 40,
			'switch' => 46,
			'atomexpr' => 69,
			'loop' => 56,
			'expr' => 213,
			'assign' => 71,
			'perl' => 64,
			'ident' => 92,
			'term' => 73,
			'filter' => 66,
			'lterm' => 20,
			'node' => 59,
			'condition' => 13
		}
	},
	{#State 127
		DEFAULT => -33
	},
	{#State 128
		ACTIONS => {
			";" => 214
		}
	},
	{#State 129
		ACTIONS => {
			"\${" => 50,
			'IDENT' => 215,
			"\$" => 7
		},
		GOTOS => {
			'item' => 25,
			'ident' => 173,
			'node' => 59
		}
	},
	{#State 130
		DEFAULT => -158
	},
	{#State 131
		ACTIONS => {
			'ASSIGN' => -129
		},
		DEFAULT => -172
	},
	{#State 132
		DEFAULT => -72
	},
	{#State 133
		DEFAULT => -175,
		GOTOS => {
			'quoted' => 216
		}
	},
	{#State 134
		ACTIONS => {
			'ASSIGN' => -160
		},
		DEFAULT => -168
	},
	{#State 135
		ACTIONS => {
			'ASSIGN' => 217
		}
	},
	{#State 136
		DEFAULT => -157
	},
	{#State 137
		ACTIONS => {
			'MOD' => 104,
			'BINOP' => 106,
			"+" => 112,
			'CAT' => 111,
			'OR' => 109,
			";" => 218,
			'AND' => 107,
			'DIV' => 110,
			'CMPOP' => 108,
			"/" => 113,
			"?" => 105
		}
	},
	{#State 138
		DEFAULT => -0
	},
	{#State 139
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'DEBUG' => 48,
			'PROCESS' => 8,
			"\${" => 50,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 52,
			'DEFAULT' => 53,
			"[" => 54,
			"{" => 17,
			'CALL' => 57,
			'THROW' => 58,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 60,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 63,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 65,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 68,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 70,
			'IF' => 72
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 61,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'defblockname' => 62,
			'switch' => 46,
			'block' => 219,
			'anonblock' => 49,
			'perl' => 64,
			'ident' => 9,
			'filter' => 66,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 67,
			'statement' => 15,
			'chunks' => 51,
			'wrapper' => 40,
			'atomexpr' => 69,
			'defblock' => 55,
			'loop' => 56,
			'capture' => 18,
			'expr' => 19,
			'assign' => 71,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 140
		ACTIONS => {
			";" => 220
		}
	},
	{#State 141
		ACTIONS => {
			'COMMA' => 188,
			'IDENT' => 97
		},
		DEFAULT => -85,
		GOTOS => {
			'meta' => 189
		}
	},
	{#State 142
		ACTIONS => {
			'DOT' => 174
		},
		DEFAULT => -83
	},
	{#State 143
		ACTIONS => {
			'ASSIGN' => 190
		},
		DEFAULT => -172
	},
	{#State 144
		DEFAULT => -82
	},
	{#State 145
		DEFAULT => -84
	},
	{#State 146
		ACTIONS => {
			"\"" => 224,
			"\${" => 50,
			'TEXT' => 222,
			";" => 223,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'quotable' => 225,
			'item' => 25,
			'ident' => 221,
			'node' => 59
		}
	},
	{#State 147
		ACTIONS => {
			";" => 226
		}
	},
	{#State 148
		DEFAULT => -41
	},
	{#State 149
		ACTIONS => {
			"}" => 227
		}
	},
	{#State 150
		DEFAULT => -4
	},
	{#State 151
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 228,
			'item' => 25,
			'ident' => 74,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 152
		ACTIONS => {
			'LITERAL' => 118,
			'IDENT' => 28,
			"\$" => 7,
			'COMMA' => 121,
			"\${" => 50
		},
		DEFAULT => -31,
		GOTOS => {
			'assign' => 122,
			'item' => 25,
			'ident' => 116,
			'node' => 59
		}
	},
	{#State 153
		ACTIONS => {
			'TO' => 229
		},
		DEFAULT => -103
	},
	{#State 154
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			'COMMA' => 231,
			"{" => 17,
			"]" => 230,
			'REF' => 32,
			"\${" => 50
		},
		GOTOS => {
			'sterm' => 1,
			'item' => 25,
			'ident' => 74,
			'term' => 232,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 155
		DEFAULT => -106
	},
	{#State 156
		ACTIONS => {
			"]" => 233
		}
	},
	{#State 157
		DEFAULT => -115
	},
	{#State 158
		ACTIONS => {
			'CAT' => 111,
			'AND' => 107,
			'CMPOP' => 108,
			'MOD' => 104,
			'BINOP' => 106,
			'OR' => 109,
			"+" => 112,
			'DIV' => 110,
			"/" => 113,
			"?" => 105
		},
		DEFAULT => -29
	},
	{#State 159
		DEFAULT => -35
	},
	{#State 160
		ACTIONS => {
			";" => 234
		}
	},
	{#State 161
		ACTIONS => {
			'ASSIGN' => 235
		},
		DEFAULT => -129
	},
	{#State 162
		ACTIONS => {
			";" => 236
		}
	},
	{#State 163
		DEFAULT => -155,
		GOTOS => {
			'args' => 237
		}
	},
	{#State 164
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 238,
			'item' => 25,
			'ident' => 74,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 165
		ACTIONS => {
			'NUMBER' => 79,
			"\"" => 85,
			'FILENAME' => 81,
			'LITERAL' => 86,
			'IDENT' => 83,
			"\$" => 80
		},
		GOTOS => {
			'nameargs' => 239,
			'filename' => 82,
			'filepart' => 87,
			'names' => 89,
			'name' => 84
		}
	},
	{#State 166
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 240,
			'item' => 25,
			'ident' => 74,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 167
		ACTIONS => {
			'NUMBER' => 79,
			"\"" => 133,
			"\${" => 50,
			'FILENAME' => 81,
			'LITERAL' => 134,
			'IDENT' => 131,
			"\$" => 129
		},
		GOTOS => {
			'lvalue' => 135,
			'lnameargs' => 241,
			'nameargs' => 136,
			'item' => 130,
			'filename' => 82,
			'filepart' => 87,
			'name' => 84,
			'names' => 89
		}
	},
	{#State 168
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 161,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50
		},
		GOTOS => {
			'sterm' => 1,
			'item' => 25,
			'ident' => 74,
			'term' => 163,
			'lterm' => 20,
			'loopvar' => 242,
			'node' => 59
		}
	},
	{#State 169
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 243,
			'item' => 25,
			'ident' => 74,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 170
		ACTIONS => {
			'CAT' => 111,
			'AND' => 107,
			'CMPOP' => 108,
			'MOD' => 104,
			'BINOP' => 106,
			'OR' => 109,
			"+" => 112,
			'DIV' => 110,
			"/" => 113,
			"?" => 105
		},
		DEFAULT => -28
	},
	{#State 171
		ACTIONS => {
			'MOD' => 104,
			'BINOP' => 106,
			"+" => 112,
			'CAT' => 111,
			'OR' => 109,
			";" => 244,
			'AND' => 107,
			'DIV' => 110,
			'CMPOP' => 108,
			"/" => 113,
			"?" => 105
		}
	},
	{#State 172
		ACTIONS => {
			'TEXT' => 245
		}
	},
	{#State 173
		ACTIONS => {
			'DOT' => 90
		},
		DEFAULT => -155,
		GOTOS => {
			'args' => 246
		}
	},
	{#State 174
		ACTIONS => {
			'NUMBER' => 79,
			'FILENAME' => 81,
			'IDENT' => 83
		},
		GOTOS => {
			'filepart' => 247
		}
	},
	{#State 175
		ACTIONS => {
			"\"" => 248,
			"\${" => 50,
			'TEXT' => 222,
			";" => 223,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'quotable' => 225,
			'item' => 25,
			'ident' => 221,
			'node' => 59
		}
	},
	{#State 176
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'IDENT' => 28,
			"\$" => 7,
			'REF' => 32,
			"\${" => 50,
			'LITERAL' => 251,
			"[" => 54,
			"{" => 17,
			'COMMA' => 252
		},
		DEFAULT => -162,
		GOTOS => {
			'sterm' => 1,
			'param' => 253,
			'item' => 250,
			'ident' => 249,
			'term' => 254,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 177
		DEFAULT => -155,
		GOTOS => {
			'args' => 255
		}
	},
	{#State 178
		ACTIONS => {
			'NUMBER' => 79,
			"\"" => 85,
			'FILENAME' => 81,
			'LITERAL' => 86,
			'IDENT' => 83
		},
		GOTOS => {
			'filename' => 82,
			'filepart' => 87,
			'name' => 256
		}
	},
	{#State 179
		DEFAULT => -125
	},
	{#State 180
		DEFAULT => -124
	},
	{#State 181
		DEFAULT => -88
	},
	{#State 182
		ACTIONS => {
			'CAT' => 111,
			'IDENT' => -149,
			"\$" => -149,
			'AND' => 107,
			"\${" => -149,
			'CMPOP' => 108,
			'MOD' => 104,
			'BINOP' => 106,
			'OR' => 109,
			"+" => 112,
			";" => -149,
			'LITERAL' => -149,
			'COMMA' => -149,
			'DIV' => 110,
			"/" => 113,
			"?" => 105
		},
		DEFAULT => -26
	},
	{#State 183
		DEFAULT => -91
	},
	{#State 184
		ACTIONS => {
			";" => 257
		}
	},
	{#State 185
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 258,
			'item' => 25,
			'ident' => 74,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 186
		DEFAULT => -144
	},
	{#State 187
		DEFAULT => -143
	},
	{#State 188
		DEFAULT => -97
	},
	{#State 189
		DEFAULT => -96
	},
	{#State 190
		ACTIONS => {
			'NUMBER' => 259,
			"\"" => 260,
			'LITERAL' => 261
		}
	},
	{#State 191
		DEFAULT => -120
	},
	{#State 192
		DEFAULT => -119
	},
	{#State 193
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 262,
			'item' => 25,
			'ident' => 74,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 194
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 263,
			'item' => 25,
			'ident' => 74,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 195
		DEFAULT => -107
	},
	{#State 196
		DEFAULT => -136
	},
	{#State 197
		ACTIONS => {
			'MOD' => 104,
			'AND' => 107,
			'BINOP' => 106,
			'DIV' => 110,
			":" => 264,
			'CMPOP' => 108,
			"/" => 113,
			"+" => 112,
			'CAT' => 111,
			'OR' => 109,
			"?" => 105
		}
	},
	{#State 198
		ACTIONS => {
			'MOD' => 104,
			"+" => 112,
			'DIV' => 110,
			"/" => 113
		},
		DEFAULT => -132
	},
	{#State 199
		ACTIONS => {
			'CAT' => 111,
			'CMPOP' => 108,
			'MOD' => 104,
			'BINOP' => 106,
			"+" => 112,
			'DIV' => 110,
			"/" => 113
		},
		DEFAULT => -139
	},
	{#State 200
		ACTIONS => {
			'MOD' => 104,
			'BINOP' => 106,
			"+" => 112,
			'DIV' => 110,
			"/" => 113
		},
		DEFAULT => -137
	},
	{#State 201
		ACTIONS => {
			'CAT' => 111,
			'CMPOP' => 108,
			'MOD' => 104,
			'BINOP' => 106,
			"+" => 112,
			'DIV' => 110,
			"/" => 113
		},
		DEFAULT => -140
	},
	{#State 202
		ACTIONS => {
			'MOD' => 104
		},
		DEFAULT => -135
	},
	{#State 203
		ACTIONS => {
			'CMPOP' => 108,
			'MOD' => 104,
			'BINOP' => 106,
			"+" => 112,
			'DIV' => 110,
			"/" => 113
		},
		DEFAULT => -138
	},
	{#State 204
		ACTIONS => {
			'MOD' => 104,
			'DIV' => 110,
			"/" => 113
		},
		DEFAULT => -134
	},
	{#State 205
		ACTIONS => {
			'MOD' => 104,
			'DIV' => 110
		},
		DEFAULT => -133
	},
	{#State 206
		DEFAULT => -73,
		GOTOS => {
			'@3-3' => 265
		}
	},
	{#State 207
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'DEBUG' => 48,
			'PROCESS' => 8,
			"\${" => 50,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 52,
			'DEFAULT' => 53,
			"[" => 54,
			"{" => 17,
			'CALL' => 57,
			'THROW' => 58,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 60,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 63,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 65,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 68,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 70,
			'IF' => 72
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 61,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'defblockname' => 62,
			'switch' => 46,
			'block' => 266,
			'anonblock' => 49,
			'perl' => 64,
			'ident' => 9,
			'filter' => 66,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 67,
			'statement' => 15,
			'chunks' => 51,
			'wrapper' => 40,
			'atomexpr' => 69,
			'defblock' => 55,
			'loop' => 56,
			'capture' => 18,
			'expr' => 19,
			'assign' => 71,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 208
		ACTIONS => {
			")" => 267,
			'NUMBER' => 2,
			"\"" => 45,
			'LITERAL' => 251,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			'COMMA' => 252,
			"{" => 17,
			'REF' => 32,
			"\${" => 50
		},
		GOTOS => {
			'sterm' => 1,
			'param' => 253,
			'item' => 250,
			'ident' => 249,
			'term' => 254,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 209
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'DEBUG' => 48,
			'PROCESS' => 8,
			"\${" => 50,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 52,
			'DEFAULT' => 53,
			"[" => 54,
			"{" => 17,
			'CALL' => 57,
			'THROW' => 58,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 60,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 63,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 65,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 68,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 70,
			'IF' => 72
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 61,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'defblockname' => 62,
			'switch' => 46,
			'block' => 268,
			'anonblock' => 49,
			'perl' => 64,
			'ident' => 9,
			'filter' => 66,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 67,
			'statement' => 15,
			'chunks' => 51,
			'wrapper' => 40,
			'atomexpr' => 69,
			'defblock' => 55,
			'loop' => 56,
			'capture' => 18,
			'expr' => 19,
			'assign' => 71,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 210
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'DEBUG' => 48,
			'PROCESS' => 8,
			"\${" => 50,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 52,
			'DEFAULT' => 53,
			"[" => 54,
			"{" => 17,
			'CALL' => 57,
			'THROW' => 58,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 60,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 63,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 65,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 68,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 70,
			'IF' => 72
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 61,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'defblockname' => 62,
			'switch' => 46,
			'block' => 269,
			'anonblock' => 49,
			'perl' => 64,
			'ident' => 9,
			'filter' => 66,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 67,
			'statement' => 15,
			'chunks' => 51,
			'wrapper' => 40,
			'atomexpr' => 69,
			'defblock' => 55,
			'loop' => 56,
			'capture' => 18,
			'expr' => 19,
			'assign' => 71,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 211
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 52,
			"[" => 54,
			'IDENT' => 270,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 93,
			'assign' => 94,
			'margs' => 271,
			'item' => 25,
			'ident' => 92,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 212
		DEFAULT => -90
	},
	{#State 213
		ACTIONS => {
			'MOD' => 104,
			'BINOP' => 106,
			"+" => 112,
			'CAT' => 111,
			'OR' => 109,
			'AND' => 107,
			'DIV' => 110,
			'CMPOP' => 108,
			"/" => 113,
			"?" => 105
		},
		DEFAULT => -26
	},
	{#State 214
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'DEBUG' => 48,
			'PROCESS' => 8,
			"\${" => 50,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 52,
			'DEFAULT' => 53,
			"[" => 54,
			"{" => 17,
			'CALL' => 57,
			'THROW' => 58,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 60,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 63,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 65,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 68,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 70,
			'IF' => 72
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 61,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'defblockname' => 62,
			'switch' => 46,
			'block' => 272,
			'anonblock' => 49,
			'perl' => 64,
			'ident' => 9,
			'filter' => 66,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 67,
			'statement' => 15,
			'chunks' => 51,
			'wrapper' => 40,
			'atomexpr' => 69,
			'defblock' => 55,
			'loop' => 56,
			'capture' => 18,
			'expr' => 19,
			'assign' => 71,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 215
		ACTIONS => {
			'ASSIGN' => -131
		},
		DEFAULT => -129
	},
	{#State 216
		ACTIONS => {
			"\"" => 273,
			"\${" => 50,
			'TEXT' => 222,
			";" => 223,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'quotable' => 225,
			'item' => 25,
			'ident' => 221,
			'node' => 59
		}
	},
	{#State 217
		ACTIONS => {
			'NUMBER' => 79,
			"\"" => 85,
			'FILENAME' => 81,
			'LITERAL' => 86,
			'IDENT' => 83,
			"\$" => 80
		},
		GOTOS => {
			'nameargs' => 274,
			'filename' => 82,
			'filepart' => 87,
			'names' => 89,
			'name' => 84
		}
	},
	{#State 218
		DEFAULT => -59,
		GOTOS => {
			'@2-3' => 275
		}
	},
	{#State 219
		ACTIONS => {
			'CATCH' => 276,
			'FINAL' => 278
		},
		DEFAULT => -71,
		GOTOS => {
			'final' => 277
		}
	},
	{#State 220
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'DEBUG' => 48,
			'PROCESS' => 8,
			"\${" => 50,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 52,
			'DEFAULT' => 53,
			"[" => 54,
			"{" => 17,
			'CALL' => 57,
			'THROW' => 58,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 60,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 63,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 65,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 68,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 70,
			'IF' => 72
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 61,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'defblockname' => 62,
			'switch' => 46,
			'block' => 279,
			'anonblock' => 49,
			'perl' => 64,
			'ident' => 9,
			'filter' => 66,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 67,
			'statement' => 15,
			'chunks' => 51,
			'wrapper' => 40,
			'atomexpr' => 69,
			'defblock' => 55,
			'loop' => 56,
			'capture' => 18,
			'expr' => 19,
			'assign' => 71,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 221
		ACTIONS => {
			'DOT' => 90
		},
		DEFAULT => -176
	},
	{#State 222
		DEFAULT => -177
	},
	{#State 223
		DEFAULT => -178
	},
	{#State 224
		DEFAULT => -110
	},
	{#State 225
		DEFAULT => -174
	},
	{#State 226
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'DEBUG' => 48,
			'PROCESS' => 8,
			"\${" => 50,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 52,
			'DEFAULT' => 53,
			"[" => 54,
			"{" => 17,
			'CALL' => 57,
			'THROW' => 58,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 60,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 63,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 65,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 68,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 70,
			'IF' => 72
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 61,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'defblockname' => 62,
			'switch' => 46,
			'block' => 280,
			'anonblock' => 49,
			'perl' => 64,
			'ident' => 9,
			'filter' => 66,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 67,
			'statement' => 15,
			'chunks' => 51,
			'wrapper' => 40,
			'atomexpr' => 69,
			'defblock' => 55,
			'loop' => 56,
			'capture' => 18,
			'expr' => 19,
			'assign' => 71,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 227
		DEFAULT => -130
	},
	{#State 228
		ACTIONS => {
			'CAT' => 111,
			'AND' => 107,
			'CMPOP' => 108,
			'MOD' => 104,
			'BINOP' => 106,
			'OR' => 109,
			"+" => 112,
			'DIV' => 110,
			"/" => 113,
			"?" => 105
		},
		DEFAULT => -150
	},
	{#State 229
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			"\${" => 50,
			'REF' => 32,
			'LITERAL' => 76,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'sterm' => 281,
			'item' => 25,
			'ident' => 74,
			'node' => 59
		}
	},
	{#State 230
		DEFAULT => -104
	},
	{#State 231
		DEFAULT => -114
	},
	{#State 232
		DEFAULT => -113
	},
	{#State 233
		DEFAULT => -105
	},
	{#State 234
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'DEBUG' => 48,
			'PROCESS' => 8,
			"\${" => 50,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 52,
			'DEFAULT' => 53,
			"[" => 54,
			"{" => 17,
			'CALL' => 57,
			'THROW' => 58,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 60,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 63,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 65,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 68,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 70,
			'IF' => 72
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 61,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'defblockname' => 62,
			'switch' => 46,
			'block' => 30,
			'anonblock' => 49,
			'perl' => 64,
			'ident' => 9,
			'filter' => 66,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 67,
			'statement' => 15,
			'chunks' => 51,
			'wrapper' => 40,
			'atomexpr' => 69,
			'defblock' => 55,
			'loop' => 56,
			'capture' => 18,
			'template' => 282,
			'expr' => 19,
			'assign' => 71,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 235
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50
		},
		GOTOS => {
			'sterm' => 1,
			'item' => 25,
			'ident' => 74,
			'term' => 283,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 236
		DEFAULT => -56,
		GOTOS => {
			'@1-3' => 284
		}
	},
	{#State 237
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'LITERAL' => 251,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			'COMMA' => 252,
			"{" => 17,
			'REF' => 32,
			"\${" => 50
		},
		DEFAULT => -63,
		GOTOS => {
			'sterm' => 1,
			'param' => 253,
			'item' => 250,
			'ident' => 249,
			'term' => 254,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 238
		ACTIONS => {
			'MOD' => 104,
			'BINOP' => 106,
			"+" => 112,
			'CAT' => 111,
			'OR' => 109,
			'AND' => 107,
			'DIV' => 110,
			'CMPOP' => 108,
			"/" => 113,
			"?" => 105
		},
		DEFAULT => -47
	},
	{#State 239
		DEFAULT => -65
	},
	{#State 240
		ACTIONS => {
			'MOD' => 104,
			'BINOP' => 106,
			"+" => 112,
			'CAT' => 111,
			'OR' => 109,
			'AND' => 107,
			'DIV' => 110,
			'CMPOP' => 108,
			"/" => 113,
			"?" => 105
		},
		DEFAULT => -61
	},
	{#State 241
		DEFAULT => -80
	},
	{#State 242
		DEFAULT => -58
	},
	{#State 243
		ACTIONS => {
			'MOD' => 104,
			'BINOP' => 106,
			"+" => 112,
			'CAT' => 111,
			'OR' => 109,
			'AND' => 107,
			'DIV' => 110,
			'CMPOP' => 108,
			"/" => 113,
			"?" => 105
		},
		DEFAULT => -45
	},
	{#State 244
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'DEBUG' => 48,
			'PROCESS' => 8,
			"\${" => 50,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 52,
			'DEFAULT' => 53,
			"[" => 54,
			"{" => 17,
			'CALL' => 57,
			'THROW' => 58,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 60,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 63,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 65,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 68,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 70,
			'IF' => 72
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 61,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'defblockname' => 62,
			'switch' => 46,
			'block' => 285,
			'anonblock' => 49,
			'perl' => 64,
			'ident' => 9,
			'filter' => 66,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 67,
			'statement' => 15,
			'chunks' => 51,
			'wrapper' => 40,
			'atomexpr' => 69,
			'defblock' => 55,
			'loop' => 56,
			'capture' => 18,
			'expr' => 19,
			'assign' => 71,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 245
		ACTIONS => {
			'END' => 286
		}
	},
	{#State 246
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'IDENT' => 28,
			"\$" => 7,
			'REF' => 32,
			"\${" => 50,
			'LITERAL' => 251,
			"[" => 54,
			"{" => 17,
			'COMMA' => 252
		},
		DEFAULT => -161,
		GOTOS => {
			'sterm' => 1,
			'param' => 253,
			'item' => 250,
			'ident' => 249,
			'term' => 254,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 247
		DEFAULT => -169
	},
	{#State 248
		DEFAULT => -166
	},
	{#State 249
		ACTIONS => {
			'DOT' => 90,
			'ASSIGN' => 287
		},
		DEFAULT => -108
	},
	{#State 250
		ACTIONS => {
			"(" => 120,
			'ASSIGN' => 193
		},
		DEFAULT => -127
	},
	{#State 251
		ACTIONS => {
			'ASSIGN' => 194
		},
		DEFAULT => -111
	},
	{#State 252
		DEFAULT => -154
	},
	{#State 253
		DEFAULT => -152
	},
	{#State 254
		DEFAULT => -151
	},
	{#State 255
		ACTIONS => {
			")" => 288,
			'NUMBER' => 2,
			"\"" => 45,
			'LITERAL' => 251,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			'COMMA' => 252,
			"{" => 17,
			'REF' => 32,
			"\${" => 50
		},
		GOTOS => {
			'sterm' => 1,
			'param' => 253,
			'item' => 250,
			'ident' => 249,
			'term' => 254,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 256
		DEFAULT => -164
	},
	{#State 257
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'DEBUG' => 48,
			'PROCESS' => 8,
			"\${" => 50,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 52,
			'DEFAULT' => 53,
			"[" => 54,
			"{" => 17,
			'CALL' => 57,
			'THROW' => 58,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 60,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 63,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 65,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 68,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 70,
			'IF' => 72
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 61,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'defblockname' => 62,
			'switch' => 46,
			'block' => 289,
			'anonblock' => 49,
			'perl' => 64,
			'ident' => 9,
			'filter' => 66,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 67,
			'statement' => 15,
			'chunks' => 51,
			'wrapper' => 40,
			'atomexpr' => 69,
			'defblock' => 55,
			'loop' => 56,
			'capture' => 18,
			'expr' => 19,
			'assign' => 71,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 258
		ACTIONS => {
			'CAT' => 111,
			'AND' => 107,
			'CMPOP' => 108,
			'MOD' => 104,
			'BINOP' => 106,
			'OR' => 109,
			"+" => 112,
			'DIV' => 110,
			"/" => 113,
			"?" => 105
		},
		DEFAULT => -149
	},
	{#State 259
		DEFAULT => -101
	},
	{#State 260
		ACTIONS => {
			'TEXT' => 290
		}
	},
	{#State 261
		DEFAULT => -99
	},
	{#State 262
		ACTIONS => {
			'CAT' => 111,
			'AND' => 107,
			'CMPOP' => 108,
			'MOD' => 104,
			'BINOP' => 106,
			'OR' => 109,
			"+" => 112,
			'DIV' => 110,
			"/" => 113,
			"?" => 105
		},
		DEFAULT => -123
	},
	{#State 263
		ACTIONS => {
			'CAT' => 111,
			'AND' => 107,
			'CMPOP' => 108,
			'MOD' => 104,
			'BINOP' => 106,
			'OR' => 109,
			"+" => 112,
			'DIV' => 110,
			"/" => 113,
			"?" => 105
		},
		DEFAULT => -122
	},
	{#State 264
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 291,
			'item' => 25,
			'ident' => 74,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 265
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'DEBUG' => 48,
			'PROCESS' => 8,
			"\${" => 50,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 52,
			'DEFAULT' => 53,
			"[" => 54,
			"{" => 17,
			'CALL' => 57,
			'THROW' => 58,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 60,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 63,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 65,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 68,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 70,
			'IF' => 72
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 61,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'defblockname' => 62,
			'switch' => 46,
			'block' => 292,
			'anonblock' => 49,
			'perl' => 64,
			'ident' => 9,
			'filter' => 66,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 67,
			'statement' => 15,
			'chunks' => 51,
			'wrapper' => 40,
			'atomexpr' => 69,
			'defblock' => 55,
			'loop' => 56,
			'capture' => 18,
			'expr' => 19,
			'assign' => 71,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 266
		ACTIONS => {
			'CASE' => 294
		},
		DEFAULT => -55,
		GOTOS => {
			'case' => 293
		}
	},
	{#State 267
		DEFAULT => -128
	},
	{#State 268
		ACTIONS => {
			'END' => 295
		}
	},
	{#State 269
		ACTIONS => {
			'ELSE' => 296,
			'ELSIF' => 298
		},
		DEFAULT => -50,
		GOTOS => {
			'else' => 297
		}
	},
	{#State 270
		ACTIONS => {
			'IDENT' => -95,
			")" => -95,
			'COMMA' => -95
		},
		DEFAULT => -129
	},
	{#State 271
		ACTIONS => {
			'COMMA' => 301,
			")" => 300,
			'IDENT' => 299
		}
	},
	{#State 272
		ACTIONS => {
			'END' => 302
		}
	},
	{#State 273
		ACTIONS => {
			'ASSIGN' => -159
		},
		DEFAULT => -166
	},
	{#State 274
		DEFAULT => -156
	},
	{#State 275
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'DEBUG' => 48,
			'PROCESS' => 8,
			"\${" => 50,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 52,
			'DEFAULT' => 53,
			"[" => 54,
			"{" => 17,
			'CALL' => 57,
			'THROW' => 58,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 60,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 63,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 65,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 68,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 70,
			'IF' => 72
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 61,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'defblockname' => 62,
			'switch' => 46,
			'block' => 303,
			'anonblock' => 49,
			'perl' => 64,
			'ident' => 9,
			'filter' => 66,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 67,
			'statement' => 15,
			'chunks' => 51,
			'wrapper' => 40,
			'atomexpr' => 69,
			'defblock' => 55,
			'loop' => 56,
			'capture' => 18,
			'expr' => 19,
			'assign' => 71,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 276
		ACTIONS => {
			'NUMBER' => 79,
			'FILENAME' => 81,
			";" => 304,
			'DEFAULT' => 306,
			'IDENT' => 83
		},
		GOTOS => {
			'filename' => 305,
			'filepart' => 87
		}
	},
	{#State 277
		ACTIONS => {
			'END' => 307
		}
	},
	{#State 278
		ACTIONS => {
			";" => 308
		}
	},
	{#State 279
		ACTIONS => {
			'END' => 309
		}
	},
	{#State 280
		ACTIONS => {
			'END' => 310
		}
	},
	{#State 281
		DEFAULT => -116
	},
	{#State 282
		ACTIONS => {
			'END' => 311
		}
	},
	{#State 283
		DEFAULT => -155,
		GOTOS => {
			'args' => 312
		}
	},
	{#State 284
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'DEBUG' => 48,
			'PROCESS' => 8,
			"\${" => 50,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 52,
			'DEFAULT' => 53,
			"[" => 54,
			"{" => 17,
			'CALL' => 57,
			'THROW' => 58,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 60,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 63,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 65,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 68,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 70,
			'IF' => 72
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 61,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'defblockname' => 62,
			'switch' => 46,
			'block' => 313,
			'anonblock' => 49,
			'perl' => 64,
			'ident' => 9,
			'filter' => 66,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 67,
			'statement' => 15,
			'chunks' => 51,
			'wrapper' => 40,
			'atomexpr' => 69,
			'defblock' => 55,
			'loop' => 56,
			'capture' => 18,
			'expr' => 19,
			'assign' => 71,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 285
		ACTIONS => {
			'ELSE' => 296,
			'ELSIF' => 298
		},
		DEFAULT => -50,
		GOTOS => {
			'else' => 314
		}
	},
	{#State 286
		DEFAULT => -78
	},
	{#State 287
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 315,
			'item' => 25,
			'ident' => 74,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 288
		DEFAULT => -163
	},
	{#State 289
		ACTIONS => {
			'END' => 316
		}
	},
	{#State 290
		ACTIONS => {
			"\"" => 317
		}
	},
	{#State 291
		ACTIONS => {
			'CAT' => 111,
			'AND' => 107,
			'CMPOP' => 108,
			'MOD' => 104,
			'BINOP' => 106,
			'OR' => 109,
			"+" => 112,
			'DIV' => 110,
			"/" => 113,
			"?" => 105
		},
		DEFAULT => -142
	},
	{#State 292
		ACTIONS => {
			'END' => 318
		}
	},
	{#State 293
		ACTIONS => {
			'END' => 319
		}
	},
	{#State 294
		ACTIONS => {
			"{" => 17,
			'NUMBER' => 2,
			"\"" => 45,
			"\${" => 50,
			'REF' => 32,
			'LITERAL' => 76,
			";" => 320,
			'DEFAULT' => 321,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7
		},
		GOTOS => {
			'sterm' => 1,
			'item' => 25,
			'ident' => 74,
			'term' => 322,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 295
		DEFAULT => -76
	},
	{#State 296
		ACTIONS => {
			";" => 323
		}
	},
	{#State 297
		ACTIONS => {
			'END' => 324
		}
	},
	{#State 298
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'NOT' => 3,
			'LITERAL' => 76,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			"{" => 17,
			'REF' => 32,
			"\${" => 50,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 325,
			'item' => 25,
			'ident' => 74,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 299
		DEFAULT => -93
	},
	{#State 300
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 184,
			"\"" => 45,
			'NOT' => 3,
			'FILTER' => 47,
			"\$" => 7,
			'DEBUG' => 48,
			'PROCESS' => 8,
			"\${" => 50,
			"(" => 12,
			'LITERAL' => 52,
			'DEFAULT' => 53,
			"[" => 54,
			"{" => 17,
			'CALL' => 57,
			'THROW' => 58,
			'INSERT' => 22,
			'SET' => 23,
			'STOP' => 60,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 63,
			'UNLESS' => 31,
			'REF' => 32,
			'CLEAR' => 65,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'NEXT' => 68,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 70,
			'IF' => 72
		},
		GOTOS => {
			'directive' => 183,
			'sterm' => 1,
			'mdir' => 326,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'atomdir' => 5,
			'wrapper' => 40,
			'switch' => 46,
			'atomexpr' => 69,
			'loop' => 56,
			'expr' => 213,
			'assign' => 71,
			'perl' => 64,
			'ident' => 92,
			'term' => 73,
			'filter' => 66,
			'lterm' => 20,
			'node' => 59,
			'condition' => 13
		}
	},
	{#State 301
		DEFAULT => -94
	},
	{#State 302
		DEFAULT => -64
	},
	{#State 303
		ACTIONS => {
			'END' => 327
		}
	},
	{#State 304
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'DEBUG' => 48,
			'PROCESS' => 8,
			"\${" => 50,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 52,
			'DEFAULT' => 53,
			"[" => 54,
			"{" => 17,
			'CALL' => 57,
			'THROW' => 58,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 60,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 63,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 65,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 68,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 70,
			'IF' => 72
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 61,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'defblockname' => 62,
			'switch' => 46,
			'block' => 328,
			'anonblock' => 49,
			'perl' => 64,
			'ident' => 9,
			'filter' => 66,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 67,
			'statement' => 15,
			'chunks' => 51,
			'wrapper' => 40,
			'atomexpr' => 69,
			'defblock' => 55,
			'loop' => 56,
			'capture' => 18,
			'expr' => 19,
			'assign' => 71,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 305
		ACTIONS => {
			'DOT' => 174,
			";" => 329
		}
	},
	{#State 306
		ACTIONS => {
			";" => 330
		}
	},
	{#State 307
		DEFAULT => -66
	},
	{#State 308
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'DEBUG' => 48,
			'PROCESS' => 8,
			"\${" => 50,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 52,
			'DEFAULT' => 53,
			"[" => 54,
			"{" => 17,
			'CALL' => 57,
			'THROW' => 58,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 60,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 63,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 65,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 68,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 70,
			'IF' => 72
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 61,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'defblockname' => 62,
			'switch' => 46,
			'block' => 331,
			'anonblock' => 49,
			'perl' => 64,
			'ident' => 9,
			'filter' => 66,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 67,
			'statement' => 15,
			'chunks' => 51,
			'wrapper' => 40,
			'atomexpr' => 69,
			'defblock' => 55,
			'loop' => 56,
			'capture' => 18,
			'expr' => 19,
			'assign' => 71,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 309
		DEFAULT => -87
	},
	{#State 310
		DEFAULT => -79
	},
	{#State 311
		DEFAULT => -81
	},
	{#State 312
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 45,
			'LITERAL' => 251,
			"[" => 54,
			'IDENT' => 28,
			"\$" => 7,
			'COMMA' => 252,
			"{" => 17,
			'REF' => 32,
			"\${" => 50
		},
		DEFAULT => -62,
		GOTOS => {
			'sterm' => 1,
			'param' => 253,
			'item' => 250,
			'ident' => 249,
			'term' => 254,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 313
		ACTIONS => {
			'END' => 332
		}
	},
	{#State 314
		ACTIONS => {
			'END' => 333
		}
	},
	{#State 315
		ACTIONS => {
			'CAT' => 111,
			'AND' => 107,
			'CMPOP' => 108,
			'MOD' => 104,
			'BINOP' => 106,
			'OR' => 109,
			"+" => 112,
			'DIV' => 110,
			"/" => 113,
			"?" => 105
		},
		DEFAULT => -153
	},
	{#State 316
		DEFAULT => -92
	},
	{#State 317
		DEFAULT => -100
	},
	{#State 318
		DEFAULT => -74
	},
	{#State 319
		DEFAULT => -51
	},
	{#State 320
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'DEBUG' => 48,
			'PROCESS' => 8,
			"\${" => 50,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 52,
			'DEFAULT' => 53,
			"[" => 54,
			"{" => 17,
			'CALL' => 57,
			'THROW' => 58,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 60,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 63,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 65,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 68,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 70,
			'IF' => 72
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 61,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'defblockname' => 62,
			'switch' => 46,
			'block' => 334,
			'anonblock' => 49,
			'perl' => 64,
			'ident' => 9,
			'filter' => 66,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 67,
			'statement' => 15,
			'chunks' => 51,
			'wrapper' => 40,
			'atomexpr' => 69,
			'defblock' => 55,
			'loop' => 56,
			'capture' => 18,
			'expr' => 19,
			'assign' => 71,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 321
		ACTIONS => {
			";" => 335
		}
	},
	{#State 322
		ACTIONS => {
			";" => 336
		}
	},
	{#State 323
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'DEBUG' => 48,
			'PROCESS' => 8,
			"\${" => 50,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 52,
			'DEFAULT' => 53,
			"[" => 54,
			"{" => 17,
			'CALL' => 57,
			'THROW' => 58,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 60,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 63,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 65,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 68,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 70,
			'IF' => 72
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 61,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'defblockname' => 62,
			'switch' => 46,
			'block' => 337,
			'anonblock' => 49,
			'perl' => 64,
			'ident' => 9,
			'filter' => 66,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 67,
			'statement' => 15,
			'chunks' => 51,
			'wrapper' => 40,
			'atomexpr' => 69,
			'defblock' => 55,
			'loop' => 56,
			'capture' => 18,
			'expr' => 19,
			'assign' => 71,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 324
		DEFAULT => -46
	},
	{#State 325
		ACTIONS => {
			'MOD' => 104,
			'BINOP' => 106,
			"+" => 112,
			'CAT' => 111,
			'OR' => 109,
			";" => 338,
			'AND' => 107,
			'DIV' => 110,
			'CMPOP' => 108,
			"/" => 113,
			"?" => 105
		}
	},
	{#State 326
		DEFAULT => -89
	},
	{#State 327
		DEFAULT => -60
	},
	{#State 328
		ACTIONS => {
			'CATCH' => 276,
			'FINAL' => 278
		},
		DEFAULT => -71,
		GOTOS => {
			'final' => 339
		}
	},
	{#State 329
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'DEBUG' => 48,
			'PROCESS' => 8,
			"\${" => 50,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 52,
			'DEFAULT' => 53,
			"[" => 54,
			"{" => 17,
			'CALL' => 57,
			'THROW' => 58,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 60,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 63,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 65,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 68,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 70,
			'IF' => 72
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 61,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'defblockname' => 62,
			'switch' => 46,
			'block' => 340,
			'anonblock' => 49,
			'perl' => 64,
			'ident' => 9,
			'filter' => 66,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 67,
			'statement' => 15,
			'chunks' => 51,
			'wrapper' => 40,
			'atomexpr' => 69,
			'defblock' => 55,
			'loop' => 56,
			'capture' => 18,
			'expr' => 19,
			'assign' => 71,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 330
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'DEBUG' => 48,
			'PROCESS' => 8,
			"\${" => 50,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 52,
			'DEFAULT' => 53,
			"[" => 54,
			"{" => 17,
			'CALL' => 57,
			'THROW' => 58,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 60,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 63,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 65,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 68,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 70,
			'IF' => 72
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 61,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'defblockname' => 62,
			'switch' => 46,
			'block' => 341,
			'anonblock' => 49,
			'perl' => 64,
			'ident' => 9,
			'filter' => 66,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 67,
			'statement' => 15,
			'chunks' => 51,
			'wrapper' => 40,
			'atomexpr' => 69,
			'defblock' => 55,
			'loop' => 56,
			'capture' => 18,
			'expr' => 19,
			'assign' => 71,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 331
		DEFAULT => -70
	},
	{#State 332
		DEFAULT => -57
	},
	{#State 333
		DEFAULT => -44
	},
	{#State 334
		DEFAULT => -54
	},
	{#State 335
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'DEBUG' => 48,
			'PROCESS' => 8,
			"\${" => 50,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 52,
			'DEFAULT' => 53,
			"[" => 54,
			"{" => 17,
			'CALL' => 57,
			'THROW' => 58,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 60,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 63,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 65,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 68,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 70,
			'IF' => 72
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 61,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'defblockname' => 62,
			'switch' => 46,
			'block' => 342,
			'anonblock' => 49,
			'perl' => 64,
			'ident' => 9,
			'filter' => 66,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 67,
			'statement' => 15,
			'chunks' => 51,
			'wrapper' => 40,
			'atomexpr' => 69,
			'defblock' => 55,
			'loop' => 56,
			'capture' => 18,
			'expr' => 19,
			'assign' => 71,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 336
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'DEBUG' => 48,
			'PROCESS' => 8,
			"\${" => 50,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 52,
			'DEFAULT' => 53,
			"[" => 54,
			"{" => 17,
			'CALL' => 57,
			'THROW' => 58,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 60,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 63,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 65,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 68,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 70,
			'IF' => 72
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 61,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'defblockname' => 62,
			'switch' => 46,
			'block' => 343,
			'anonblock' => 49,
			'perl' => 64,
			'ident' => 9,
			'filter' => 66,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 67,
			'statement' => 15,
			'chunks' => 51,
			'wrapper' => 40,
			'atomexpr' => 69,
			'defblock' => 55,
			'loop' => 56,
			'capture' => 18,
			'expr' => 19,
			'assign' => 71,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 337
		DEFAULT => -49
	},
	{#State 338
		ACTIONS => {
			'TRY' => 43,
			'NUMBER' => 2,
			'BLOCK' => 44,
			"\"" => 45,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 47,
			"\$" => 7,
			'DEBUG' => 48,
			'PROCESS' => 8,
			"\${" => 50,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -18,
			'LITERAL' => 52,
			'DEFAULT' => 53,
			"[" => 54,
			"{" => 17,
			'CALL' => 57,
			'THROW' => 58,
			'INSERT' => 22,
			'VIEW' => 21,
			'SET' => 23,
			'STOP' => 60,
			'SWITCH' => 24,
			'IDENT' => 28,
			'PERL' => 29,
			'FOR' => 63,
			'UNLESS' => 31,
			'REF' => 32,
			'MACRO' => 33,
			'CLEAR' => 65,
			'INCLUDE' => 34,
			'WRAPPER' => 35,
			'USE' => 37,
			'NEXT' => 68,
			'RETURN' => 38,
			'WHILE' => 39,
			'LAST' => 41,
			'GET' => 70,
			'IF' => 72
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'view' => 61,
			'try' => 4,
			'setlist' => 26,
			'item' => 25,
			'chunk' => 27,
			'atomdir' => 5,
			'defblockname' => 62,
			'switch' => 46,
			'block' => 344,
			'anonblock' => 49,
			'perl' => 64,
			'ident' => 9,
			'filter' => 66,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 36,
			'macro' => 14,
			'use' => 67,
			'statement' => 15,
			'chunks' => 51,
			'wrapper' => 40,
			'atomexpr' => 69,
			'defblock' => 55,
			'loop' => 56,
			'capture' => 18,
			'expr' => 19,
			'assign' => 71,
			'term' => 73,
			'lterm' => 20,
			'node' => 59
		}
	},
	{#State 339
		DEFAULT => -69
	},
	{#State 340
		ACTIONS => {
			'CATCH' => 276,
			'FINAL' => 278
		},
		DEFAULT => -71,
		GOTOS => {
			'final' => 345
		}
	},
	{#State 341
		ACTIONS => {
			'CATCH' => 276,
			'FINAL' => 278
		},
		DEFAULT => -71,
		GOTOS => {
			'final' => 346
		}
	},
	{#State 342
		DEFAULT => -53
	},
	{#State 343
		ACTIONS => {
			'CASE' => 294
		},
		DEFAULT => -55,
		GOTOS => {
			'case' => 347
		}
	},
	{#State 344
		ACTIONS => {
			'ELSE' => 296,
			'ELSIF' => 298
		},
		DEFAULT => -50,
		GOTOS => {
			'else' => 348
		}
	},
	{#State 345
		DEFAULT => -67
	},
	{#State 346
		DEFAULT => -68
	},
	{#State 347
		DEFAULT => -52
	},
	{#State 348
		DEFAULT => -48
	}
]; 


#========================================================================
# Rules
#========================================================================

$RULES = [
	[#Rule 0
		 '$start', 2, undef
	],
	[#Rule 1
		 'template', 1,
sub
#line 64 "Parser.yp"
{ $factory->template($_[1])           }
	],
	[#Rule 2
		 'block', 1,
sub
#line 67 "Parser.yp"
{ $factory->block($_[1])              }
	],
	[#Rule 3
		 'block', 0,
sub
#line 68 "Parser.yp"
{ $factory->block()                   }
	],
	[#Rule 4
		 'chunks', 2,
sub
#line 71 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
					if defined $_[2]; $_[1]           }
	],
	[#Rule 5
		 'chunks', 1,
sub
#line 73 "Parser.yp"
{ defined $_[1] ? [ $_[1] ] : [ ]     }
	],
	[#Rule 6
		 'chunk', 1,
sub
#line 76 "Parser.yp"
{ $factory->textblock($_[1])          }
	],
	[#Rule 7
		 'chunk', 2, undef
	],
	[#Rule 8
		 'statement', 1, undef
	],
	[#Rule 9
		 'statement', 1, undef
	],
	[#Rule 10
		 'statement', 1, undef
	],
	[#Rule 11
		 'statement', 1, undef
	],
	[#Rule 12
		 'statement', 1, undef
	],
	[#Rule 13
		 'statement', 1, undef
	],
	[#Rule 14
		 'statement', 1, undef
	],
	[#Rule 15
		 'statement', 1, undef
	],
	[#Rule 16
		 'statement', 1,
sub
#line 89 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 17
		 'statement', 2,
sub
#line 90 "Parser.yp"
{ $_[0]->add_metadata($_[2]);         }
	],
	[#Rule 18
		 'statement', 0, undef
	],
	[#Rule 19
		 'directive', 1,
sub
#line 94 "Parser.yp"
{ $factory->set($_[1])                }
	],
	[#Rule 20
		 'directive', 1, undef
	],
	[#Rule 21
		 'directive', 1, undef
	],
	[#Rule 22
		 'directive', 1, undef
	],
	[#Rule 23
		 'directive', 1, undef
	],
	[#Rule 24
		 'directive', 1, undef
	],
	[#Rule 25
		 'directive', 1, undef
	],
	[#Rule 26
		 'atomexpr', 1,
sub
#line 108 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 27
		 'atomexpr', 1, undef
	],
	[#Rule 28
		 'atomdir', 2,
sub
#line 112 "Parser.yp"
{ $factory->get($_[2])                }
	],
	[#Rule 29
		 'atomdir', 2,
sub
#line 113 "Parser.yp"
{ $factory->call($_[2])               }
	],
	[#Rule 30
		 'atomdir', 2,
sub
#line 114 "Parser.yp"
{ $factory->set($_[2])                }
	],
	[#Rule 31
		 'atomdir', 2,
sub
#line 115 "Parser.yp"
{ $factory->default($_[2])            }
	],
	[#Rule 32
		 'atomdir', 2,
sub
#line 116 "Parser.yp"
{ $factory->insert($_[2])             }
	],
	[#Rule 33
		 'atomdir', 2,
sub
#line 117 "Parser.yp"
{ $factory->include($_[2])            }
	],
	[#Rule 34
		 'atomdir', 2,
sub
#line 118 "Parser.yp"
{ $factory->process($_[2])            }
	],
	[#Rule 35
		 'atomdir', 2,
sub
#line 119 "Parser.yp"
{ $factory->throw($_[2])              }
	],
	[#Rule 36
		 'atomdir', 1,
sub
#line 120 "Parser.yp"
{ $factory->return()                  }
	],
	[#Rule 37
		 'atomdir', 1,
sub
#line 121 "Parser.yp"
{ $factory->stop()                    }
	],
	[#Rule 38
		 'atomdir', 1,
sub
#line 122 "Parser.yp"
{ "\$output = '';";                   }
	],
	[#Rule 39
		 'atomdir', 1,
sub
#line 123 "Parser.yp"
{ $_[0]->{ INFOR } || $_[0]->{ INWHILE }
                                        ? 'last LOOP;'
                                        : 'last;'                         }
	],
	[#Rule 40
		 'atomdir', 1,
sub
#line 126 "Parser.yp"
{ $_[0]->{ INFOR }
					? $factory->next()
				        : ($_[0]->{ INWHILE }
                                           ? 'next LOOP;'
                                           : 'next;')                     }
	],
	[#Rule 41
		 'atomdir', 2,
sub
#line 131 "Parser.yp"
{ if ($_[2]->[0]->[0] =~ /^'(on|off)'$/) {
				          $_[0]->{ DEBUG } = ($1 eq 'on');
#					  print STDERR "turned DEBUG ", $_[0]->{ DEBUG } ? 'on' : 'off', "\n";
					  $factory->debug($_[2]);
				      }
				      else {
# print STDERR "debug ($_[0]->{ DEBUG }) @{$_[2]->[0]}\n";
					  $_[0]->{ DEBUG } ? $factory->debug($_[2]) : '';
				      }
				    }
	],
	[#Rule 42
		 'atomdir', 1, undef
	],
	[#Rule 43
		 'atomdir', 1, undef
	],
	[#Rule 44
		 'condition', 6,
sub
#line 146 "Parser.yp"
{ $factory->if(@_[2, 4, 5])           }
	],
	[#Rule 45
		 'condition', 3,
sub
#line 147 "Parser.yp"
{ $factory->if(@_[3, 1])              }
	],
	[#Rule 46
		 'condition', 6,
sub
#line 149 "Parser.yp"
{ $factory->if("!($_[2])", @_[4, 5])  }
	],
	[#Rule 47
		 'condition', 3,
sub
#line 150 "Parser.yp"
{ $factory->if("!($_[3])", $_[1])     }
	],
	[#Rule 48
		 'else', 5,
sub
#line 154 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]);
				      $_[5];                              }
	],
	[#Rule 49
		 'else', 3,
sub
#line 156 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 50
		 'else', 0,
sub
#line 157 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 51
		 'switch', 6,
sub
#line 161 "Parser.yp"
{ $factory->switch(@_[2, 5])          }
	],
	[#Rule 52
		 'case', 5,
sub
#line 165 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]); 
				      $_[5];                              }
	],
	[#Rule 53
		 'case', 4,
sub
#line 167 "Parser.yp"
{ [ $_[4] ]                           }
	],
	[#Rule 54
		 'case', 3,
sub
#line 168 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 55
		 'case', 0,
sub
#line 169 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 56
		 '@1-3', 0,
sub
#line 172 "Parser.yp"
{ $_[0]->{ INFOR }++                  }
	],
	[#Rule 57
		 'loop', 6,
sub
#line 173 "Parser.yp"
{ $_[0]->{ INFOR }--;
				      $factory->foreach(@{$_[2]}, $_[5])  }
	],
	[#Rule 58
		 'loop', 3,
sub
#line 177 "Parser.yp"
{ $factory->foreach(@{$_[3]}, $_[1])  }
	],
	[#Rule 59
		 '@2-3', 0,
sub
#line 178 "Parser.yp"
{ $_[0]->{ INWHILE }++                }
	],
	[#Rule 60
		 'loop', 6,
sub
#line 179 "Parser.yp"
{ $_[0]->{ INWHILE }--;
                                      $factory->while(@_[2, 5])           }
	],
	[#Rule 61
		 'loop', 3,
sub
#line 181 "Parser.yp"
{ $factory->while(@_[3, 1])           }
	],
	[#Rule 62
		 'loopvar', 4,
sub
#line 184 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 63
		 'loopvar', 2,
sub
#line 185 "Parser.yp"
{ [ 0, @_[1, 2] ]                     }
	],
	[#Rule 64
		 'wrapper', 5,
sub
#line 189 "Parser.yp"
{ $factory->wrapper(@_[2, 4])         }
	],
	[#Rule 65
		 'wrapper', 3,
sub
#line 191 "Parser.yp"
{ $factory->wrapper(@_[3, 1])         }
	],
	[#Rule 66
		 'try', 5,
sub
#line 195 "Parser.yp"
{ $factory->try(@_[3, 4])             }
	],
	[#Rule 67
		 'final', 5,
sub
#line 199 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2,4] ]);
				      $_[5];                              }
	],
	[#Rule 68
		 'final', 5,
sub
#line 202 "Parser.yp"
{ unshift(@{$_[5]}, [ undef, $_[4] ]);
				      $_[5];                              }
	],
	[#Rule 69
		 'final', 4,
sub
#line 205 "Parser.yp"
{ unshift(@{$_[4]}, [ undef, $_[3] ]);
				      $_[4];                              }
	],
	[#Rule 70
		 'final', 3,
sub
#line 207 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 71
		 'final', 0,
sub
#line 208 "Parser.yp"
{ [ 0 ] }
	],
	[#Rule 72
		 'use', 2,
sub
#line 211 "Parser.yp"
{ $factory->use($_[2])                }
	],
	[#Rule 73
		 '@3-3', 0,
sub
#line 214 "Parser.yp"
{ $_[0]->push_defblock();		  }
	],
	[#Rule 74
		 'view', 6,
sub
#line 215 "Parser.yp"
{ $factory->view(@_[2,5], 
						     $_[0]->pop_defblock) }
	],
	[#Rule 75
		 '@4-2', 0,
sub
#line 219 "Parser.yp"
{ ${$_[0]->{ INPERL }}++;             }
	],
	[#Rule 76
		 'perl', 5,
sub
#line 220 "Parser.yp"
{ ${$_[0]->{ INPERL }}--;
				      $_[0]->{ EVAL_PERL } 
				      ? $factory->perl($_[4])             
				      : $factory->no_perl();              }
	],
	[#Rule 77
		 '@5-1', 0,
sub
#line 226 "Parser.yp"
{ ${$_[0]->{ INPERL }}++; 
				      $rawstart = ${$_[0]->{'LINE'}};     }
	],
	[#Rule 78
		 'rawperl', 5,
sub
#line 228 "Parser.yp"
{ ${$_[0]->{ INPERL }}--;
				      $_[0]->{ EVAL_PERL } 
				      ? $factory->rawperl($_[4], $rawstart)
				      : $factory->no_perl();              }
	],
	[#Rule 79
		 'filter', 5,
sub
#line 235 "Parser.yp"
{ $factory->filter(@_[2,4])           }
	],
	[#Rule 80
		 'filter', 3,
sub
#line 237 "Parser.yp"
{ $factory->filter(@_[3,1])           }
	],
	[#Rule 81
		 'defblock', 5,
sub
#line 242 "Parser.yp"
{ my $name = join('/', @{ $_[0]->{ DEFBLOCKS } });
				      pop(@{ $_[0]->{ DEFBLOCKS } });
				      $_[0]->define_block($name, $_[4]); 
				      undef
				    }
	],
	[#Rule 82
		 'defblockname', 2,
sub
#line 249 "Parser.yp"
{ push(@{ $_[0]->{ DEFBLOCKS } }, $_[2]);
				      $_[2];
				    }
	],
	[#Rule 83
		 'blockname', 1, undef
	],
	[#Rule 84
		 'blockname', 1,
sub
#line 255 "Parser.yp"
{ $_[1] =~ s/^'(.*)'$/$1/; $_[1]      }
	],
	[#Rule 85
		 'blockargs', 1, undef
	],
	[#Rule 86
		 'blockargs', 0, undef
	],
	[#Rule 87
		 'anonblock', 5,
sub
#line 263 "Parser.yp"
{ local $" = ', ';
				      print STDERR "experimental block args: [@{ $_[2] }]\n"
					  if $_[2];
				      $factory->anon_block($_[4])         }
	],
	[#Rule 88
		 'capture', 3,
sub
#line 269 "Parser.yp"
{ $factory->capture(@_[1, 3])         }
	],
	[#Rule 89
		 'macro', 6,
sub
#line 273 "Parser.yp"
{ $factory->macro(@_[2, 6, 4])        }
	],
	[#Rule 90
		 'macro', 3,
sub
#line 274 "Parser.yp"
{ $factory->macro(@_[2, 3])           }
	],
	[#Rule 91
		 'mdir', 1, undef
	],
	[#Rule 92
		 'mdir', 4,
sub
#line 278 "Parser.yp"
{ $_[3]                               }
	],
	[#Rule 93
		 'margs', 2,
sub
#line 281 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 94
		 'margs', 2,
sub
#line 282 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 95
		 'margs', 1,
sub
#line 283 "Parser.yp"
{ [ $_[1] ]                           }
	],
	[#Rule 96
		 'metadata', 2,
sub
#line 286 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 97
		 'metadata', 2, undef
	],
	[#Rule 98
		 'metadata', 1, undef
	],
	[#Rule 99
		 'meta', 3,
sub
#line 291 "Parser.yp"
{ for ($_[3]) { s/^'//; s/'$//; 
						       s/\\'/'/g  }; 
					 [ @_[1,3] ] }
	],
	[#Rule 100
		 'meta', 5,
sub
#line 294 "Parser.yp"
{ [ @_[1,4] ] }
	],
	[#Rule 101
		 'meta', 3,
sub
#line 295 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 102
		 'term', 1, undef
	],
	[#Rule 103
		 'term', 1, undef
	],
	[#Rule 104
		 'lterm', 3,
sub
#line 307 "Parser.yp"
{ "[ $_[2] ]"                         }
	],
	[#Rule 105
		 'lterm', 3,
sub
#line 308 "Parser.yp"
{ "[ $_[2] ]"                         }
	],
	[#Rule 106
		 'lterm', 2,
sub
#line 309 "Parser.yp"
{ "[ ]"                               }
	],
	[#Rule 107
		 'lterm', 3,
sub
#line 310 "Parser.yp"
{ "{ $_[2]  }"                        }
	],
	[#Rule 108
		 'sterm', 1,
sub
#line 313 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 109
		 'sterm', 2,
sub
#line 314 "Parser.yp"
{ $factory->identref($_[2])           }
	],
	[#Rule 110
		 'sterm', 3,
sub
#line 315 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 111
		 'sterm', 1, undef
	],
	[#Rule 112
		 'sterm', 1, undef
	],
	[#Rule 113
		 'list', 2,
sub
#line 320 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 114
		 'list', 2, undef
	],
	[#Rule 115
		 'list', 1, undef
	],
	[#Rule 116
		 'range', 3,
sub
#line 325 "Parser.yp"
{ $_[1] . '..' . $_[3]                }
	],
	[#Rule 117
		 'hash', 1, undef
	],
	[#Rule 118
		 'hash', 0,
sub
#line 330 "Parser.yp"
{ "" }
	],
	[#Rule 119
		 'params', 2,
sub
#line 333 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 120
		 'params', 2, undef
	],
	[#Rule 121
		 'params', 1, undef
	],
	[#Rule 122
		 'param', 3,
sub
#line 338 "Parser.yp"
{ "$_[1] => $_[3]"                    }
	],
	[#Rule 123
		 'param', 3,
sub
#line 339 "Parser.yp"
{ "$_[1] => $_[3]"                    }
	],
	[#Rule 124
		 'ident', 3,
sub
#line 342 "Parser.yp"
{ push(@{$_[1]}, @{$_[3]}); $_[1]     }
	],
	[#Rule 125
		 'ident', 3,
sub
#line 343 "Parser.yp"
{ push(@{$_[1]}, 
					   map {($_, 0)} split(/\./, $_[3]));
				      $_[1];			          }
	],
	[#Rule 126
		 'ident', 1, undef
	],
	[#Rule 127
		 'node', 1,
sub
#line 349 "Parser.yp"
{ [ $_[1], 0 ]                        }
	],
	[#Rule 128
		 'node', 4,
sub
#line 350 "Parser.yp"
{ [ $_[1], $factory->args($_[3]) ]    }
	],
	[#Rule 129
		 'item', 1,
sub
#line 353 "Parser.yp"
{ "'$_[1]'"                           }
	],
	[#Rule 130
		 'item', 3,
sub
#line 354 "Parser.yp"
{ $_[2]                               }
	],
	[#Rule 131
		 'item', 2,
sub
#line 355 "Parser.yp"
{ $_[0]->{ V1DOLLAR }
				       ? "'$_[2]'" 
				       : $factory->ident(["'$_[2]'", 0])  }
	],
	[#Rule 132
		 'expr', 3,
sub
#line 360 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 133
		 'expr', 3,
sub
#line 361 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 134
		 'expr', 3,
sub
#line 362 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 135
		 'expr', 3,
sub
#line 363 "Parser.yp"
{ "int($_[1] / $_[3])"                }
	],
	[#Rule 136
		 'expr', 3,
sub
#line 364 "Parser.yp"
{ "$_[1] % $_[3]"                     }
	],
	[#Rule 137
		 'expr', 3,
sub
#line 365 "Parser.yp"
{ "$_[1] $CMPOP{ $_[2] } $_[3]"       }
	],
	[#Rule 138
		 'expr', 3,
sub
#line 366 "Parser.yp"
{ "$_[1]  . $_[3]"                    }
	],
	[#Rule 139
		 'expr', 3,
sub
#line 367 "Parser.yp"
{ "$_[1] && $_[3]"                    }
	],
	[#Rule 140
		 'expr', 3,
sub
#line 368 "Parser.yp"
{ "$_[1] || $_[3]"                    }
	],
	[#Rule 141
		 'expr', 2,
sub
#line 369 "Parser.yp"
{ "! $_[2]"                           }
	],
	[#Rule 142
		 'expr', 5,
sub
#line 370 "Parser.yp"
{ "$_[1] ? $_[3] : $_[5]"             }
	],
	[#Rule 143
		 'expr', 3,
sub
#line 371 "Parser.yp"
{ $factory->assign(@{$_[2]})          }
	],
	[#Rule 144
		 'expr', 3,
sub
#line 372 "Parser.yp"
{ "($_[2])"                           }
	],
	[#Rule 145
		 'expr', 1, undef
	],
	[#Rule 146
		 'setlist', 2,
sub
#line 376 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 147
		 'setlist', 2, undef
	],
	[#Rule 148
		 'setlist', 1, undef
	],
	[#Rule 149
		 'assign', 3,
sub
#line 382 "Parser.yp"
{ [ $_[1], $_[3] ]                    }
	],
	[#Rule 150
		 'assign', 3,
sub
#line 383 "Parser.yp"
{ [ @_[1,3] ]                         }
	],
	[#Rule 151
		 'args', 2,
sub
#line 390 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 152
		 'args', 2,
sub
#line 391 "Parser.yp"
{ push(@{$_[1]->[0]}, $_[2]); $_[1]   }
	],
	[#Rule 153
		 'args', 4,
sub
#line 392 "Parser.yp"
{ push(@{$_[1]->[0]}, "'', " . 
				      $factory->assign(@_[2,4])); $_[1]  }
	],
	[#Rule 154
		 'args', 2,
sub
#line 394 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 155
		 'args', 0,
sub
#line 395 "Parser.yp"
{ [ [ ] ]                             }
	],
	[#Rule 156
		 'lnameargs', 3,
sub
#line 405 "Parser.yp"
{ push(@{$_[3]}, $_[1]); $_[3]        }
	],
	[#Rule 157
		 'lnameargs', 1, undef
	],
	[#Rule 158
		 'lvalue', 1, undef
	],
	[#Rule 159
		 'lvalue', 3,
sub
#line 410 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 160
		 'lvalue', 1, undef
	],
	[#Rule 161
		 'nameargs', 3,
sub
#line 414 "Parser.yp"
{ [ [$factory->ident($_[2])], $_[3] ]   }
	],
	[#Rule 162
		 'nameargs', 2,
sub
#line 415 "Parser.yp"
{ [ @_[1,2] ] }
	],
	[#Rule 163
		 'nameargs', 4,
sub
#line 416 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 164
		 'names', 3,
sub
#line 419 "Parser.yp"
{ push(@{$_[1]}, $_[3]); $_[1] }
	],
	[#Rule 165
		 'names', 1,
sub
#line 420 "Parser.yp"
{ [ $_[1] ]                    }
	],
	[#Rule 166
		 'name', 3,
sub
#line 423 "Parser.yp"
{ $factory->quoted($_[2])  }
	],
	[#Rule 167
		 'name', 1,
sub
#line 424 "Parser.yp"
{ "'$_[1]'" }
	],
	[#Rule 168
		 'name', 1, undef
	],
	[#Rule 169
		 'filename', 3,
sub
#line 436 "Parser.yp"
{ "$_[1].$_[3]" }
	],
	[#Rule 170
		 'filename', 1, undef
	],
	[#Rule 171
		 'filepart', 1, undef
	],
	[#Rule 172
		 'filepart', 1, undef
	],
	[#Rule 173
		 'filepart', 1, undef
	],
	[#Rule 174
		 'quoted', 2,
sub
#line 450 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
				          if defined $_[2]; $_[1]         }
	],
	[#Rule 175
		 'quoted', 0,
sub
#line 452 "Parser.yp"
{ [ ]                                 }
	],
	[#Rule 176
		 'quotable', 1,
sub
#line 455 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 177
		 'quotable', 1,
sub
#line 456 "Parser.yp"
{ $factory->text($_[1])               }
	],
	[#Rule 178
		 'quotable', 1,
sub
#line 457 "Parser.yp"
{ undef                               }
	]
];



1;












