# NOTE: Derived from blib/lib/Class/MethodMaker.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package Class::MethodMaker;

#line 1745 "blib/lib/Class/MethodMaker.pm (autosplit into blib/lib/auto/Class/MethodMaker/_add_list_methods.al)"
sub _add_list_methods {
  my ($class,$methods, $field) = @_;

  $methods->{"${field}_pop"} =
    $methods->{"pop_$field"} =
      sub {
        my ($self) = @_;
        pop @{$self->{$field}}
      };

  $methods->{"${field}_push"} =
    $methods->{"push_$field"} =
      sub {
        my ($self, @values) = @_;
        push @{$self->{$field}}, @values;
      };

  $methods->{"${field}_shift"} =
    $methods->{"shift_$field"} =
      sub {
        my ($self) = @_;
        shift @{$self->{$field}}
      };

  $methods->{"${field}_unshift"} =
    $methods->{"unshift_$field"} =
      sub {
        my ($self, @values) = @_;
        unshift @{$self->{$field}}, @values;
      };

  $methods->{"${field}_splice"} =
    $methods->{"splice_$field"} =
      sub {
        my ($self, $offset, $len, @list) = @_;
        splice(@{$self->{$field}}, $offset, $len, @list);
      };

  $methods->{"${field}_clear"} =
    $methods->{"clear_$field"} =
      sub {
        my ($self) = @_;
        # this code may clobbed references passed by the user
        # $self->{$field} = [];
        @{$self->{$field}} = () ;
      };

  $methods->{"${field}_count"} =
    $methods->{"count_$field"} =
      sub {
        my ($self) = @_;
        return exists $self->{$field} ? scalar @{$self->{$field}} : 0;
      };

  $methods->{"${field}_index"} =
    $methods->{"index_$field"} =
      sub {
        my $self = shift;
        my (@indices) = @_;
        my @Result;
        push @Result, $self->{$field}->[$_]
          for @indices;
        return $Result[0] if @_ == 1;
        return wantarray ? @Result : \@Result;
      };

  foreach my $method_name (("${field}_set" ,"set_$field")) {
    $methods->{$method_name} =
      sub {
        my $self = shift;
        my @args = @_;
        croak "$method_name expects an even number of fields\n"
          if @args % 2;
        while ( my ($index, $value) = splice @args, 0, 2 ) {
          $self->{$field}->[$index] = $value;
        }
        return @_ / 2;          # required for object_list
      };
  }
}

# end of Class::MethodMaker::_add_list_methods
1;
