# NOTE: Derived from blib/lib/CGI/Session.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package CGI::Session;

#line 418 "blib/lib/CGI/Session.pm (autosplit into blib/lib/auto/CGI/Session/expires.al)"
# expires(): gets/sets the expiration time for the session
# Usage: CLASS->expires([seconds]);
#
# RETURN VALUE: if used w/out arguments, returns time() value
# if expire time was set.
# if used w/ argument, returns 1
sub expires {
    my ($self, $date) = @_;

    unless ( $date ) {
        return $self->{_data}->{_session_etime};
    }

    my $in_seconds = _date_shortcuts($date);

    $self->{_data}->{_session_etime} = time() + $in_seconds;

	# getting the session id
	my $sid = $self->{_data}->{_session_id};

	# call derived store() method. 
    # Thanks to Olivier Dragon <dragon@shadnet.shad.ca> for noticing
    # missing store() here
    $self->store($sid);
}

# end of CGI::Session::expires
1;
