# NOTE: Derived from blib/lib/CGI/Session.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package CGI::Session;

#line 611 "blib/lib/CGI/Session.pm (autosplit into blib/lib/auto/CGI/Session/clear.al)"
# clear(): clears data from the session
# Usage: CLASS->clear([\@array])
sub clear {
    my $self = shift;
    my $class = ref($self) || $self;

    # get the list of all the params the user wants to clear
    my @params = ();
    if ( defined $_[0] ) {

        unless ( ref($_[0]) eq 'ARRAY' ) {
            # It is not an arrayref we're expecting
            croak "Usage: $class->clear([\@arrayref])";
        }

        @params = @{ $_[0] };
    }

    # If the user doesn't provide with names, let's clear
    # everything
    unless ( @params ) {
        @params = $self->param();
    }

    for ( @params ) {
        /^_/ and next;      # skip  special  names
         delete $self->{_data}->{$_};
    }


    # getting session id
    my $sid = $self->{_data}->{_session_id};

    # let's synchronize data in disk with the in-memory session data
    $self->store( $sid );
}

# end of CGI::Session::clear
1;
