# NOTE: Derived from blib/lib/CGI/Session.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package CGI::Session;

#line 390 "blib/lib/CGI/Session.pm (autosplit into blib/lib/auto/CGI/Session/_date_shortcuts.al)"
# _date_shortcuts: provides a lookup table for date shortcuts
# used by expires().
#
# RETURN VALUE: CORE::time() value
sub _date_shortcuts {
    my $arg = shift;

    my $map = {
        s => 1 ,
        m => 60 ,
        h => 3600,
        d => 86400,
        w => 604800,
        M => 2592000,
        y => 31536000
    };

    my ($d, $l) = $arg =~ m/^(\d+)(\w)$/;

    if ( defined ($d) && defined ($l) ) {
        return $d * $map->{"$l"};
    }

    return $arg;
}

# end of CGI::Session::_date_shortcuts
1;
