package Sim::OPT::Sim;
# Copyright (C) 2008-2015 by Gian Luca Brunetti and Politecnico di Milano.
# This is the module Sim::OPT::Sim of Sim::OPT, a program for detailed metadesign managing parametric explorations through the ESP-r building performance simulation platform and performing optimization by block coordinate descent.
# This is free software.  You can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, version 2.
 
use v5.14;
# use v5.20;
use Exporter;
use vars qw( $VERSION @ISA @EXPORT @EXPORT_OK %EXPORT_TAGS );
use Math::Trig;
use Math::Round;
use List::Util qw[ min max reduce shuffle];
use List::MoreUtils qw(uniq);
use List::AllUtils qw(sum);
use Statistics::Basic qw(:all);
use Set::Intersection;
use List::Compare;
use IO::Tee;
use File::Copy qw( move copy );
use Data::Dumper;
#$Data::Dumper::Indent = 0;
#$Data::Dumper::Useqq  = 1;
#$Data::Dumper::Terse  = 1;
use Data::Dump qw(dump);
use feature 'say';
#use feature qw(postderef);
#no warnings qw(experimental::postderef);
#use Sub::Signatures;
#no warnings qw(Sub::Signatures); 
#no strict 'refs';
use Sim::OPT;
use Sim::OPT::Morph;
use Sim::OPT::Retrieve;
use Sim::OPT::Report;
use Sim::OPT::Descend;
use Sim::OPT::Takechance;
no strict; 
no warnings;
use warnings::unused;
@ISA = qw(Exporter); # our @adamkISA = qw(Exporter);
#%EXPORT_TAGS = ( DEFAULT => [qw( &opt &prepare )]); # our %EXPORT_TAGS = ( 'all' => [ qw( ) ] );
#@EXPORT   = qw(); # our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw( sim ); # our @EXPORT = qw( );

$VERSION = '0.49.0'; # our $VERSION = '';


#########################################################################################
# HERE FOLLOWS THE CONTENT OF "Sim.pm", Sim::OPT::Sim
##############################################################################

# HERE FOLLOWS THE "sim" FUNCTION, CALLED FROM THE MAIN PROGRAM FILE.
# IT LAUCHES SIMULATIONS AND ALSO RETRIEVES RESULTS. 
# THE TWO OPERATIONS ARE CONTROLLED SEPARATELY 
# FROM THE OPT CONFIGURATION FILE.

#____________________________________________________________________________
# Activate or deactivate the following function calls depending from your needs

sub sim    # This function launch the simulations in ESP-r
{
	my $swap = shift; #say $tee "swapINSIM: " . dump($swap);
	my %dat = %$swap;
	my @instances = @{ $dat{instances} }; #say "scalar(\@instances): " . scalar(@instances);
	my $countcase = $dat{countcase}; #say "dump(\$countcase): " . dump($countcase); # IT WILL BE SHADOWED. CUT ZZZ
	my $countblock = $dat{countblock}; #say "dump(\$countblock): " . dump($countblock); # IT WILL BE SHADOWED. CUT ZZZ		
	my %dirfiles = %{ $dat{dirfiles} }; #say "dump(\%dirfiles): " . dump(%dirfiles); 
		
	$configfile = $main::configfile; #say "dump(\$configfile): " . dump($configfile);
	@sweeps = @main::sweeps; #say "dump(\@sweeps): " . dump(@sweeps);
	@varinumbers = @main::varinumbers; #say "dump(\@varinumbers): " . dump(@varinumbers);
	@mediumiters = @main::mediumiters;
	@rootnames = @main::rootnames; #say "dump(\@rootnames): " . dump(@rootnames);
	%vals = %main::vals; #say "dump(\%vals): " . dump(%vals);
	
	$mypath = $main::mypath;  #say $tee "dumpINSIM(\$mypath): " . dump($mypath);
	$exeonfiles = $main::exeonfiles; #say $tee "dumpINSIM(\$exeonfiles): " . dump($exeonfiles);
	$generatechance = $main::generatechance; 
	$file = $main::file;
	$preventsim = $main::preventsim;
	$fileconfig = $main::fileconfig; #say $tee "dumpINSIM(\$fileconfig): " . dump($fileconfig); # NOW GLOBAL. TO MAKE IT PRIVATE, FIX PASSING OF PARAMETERS IN CONTRAINTS PROPAGATION SECONDARY SUBROUTINES
	$outfile = $main::outfile;
	$tofile = $main::tofile;
	$report = $main::report;
	$simnetwork = $main::simnetwork;
	
	$tee = new IO::Tee(\*STDOUT, ">>$tofile"); # GLOBAL ZZZ
	
	#open( OUTFILE, ">>$outfile" ) or die "Can't open $outfile: $!"; 
	open( TOFILE, ">>$tofile" ) or die "Can't open $tofile: $!"; 
	say $tee "\nNow in Sim::OPT::Sim.\n";
	
	%dowhat = %main::dowhat;

	%simtitles = %main::simtitles; #say "dumpINSIM(\%simtitles): " . dump(%simtitles);
	%retrievedata = %main::retrievedata;
	@keepcolumns = @main::keepcolumns;
	@weights = @main::weights;
	@weightsaim = @main::weightsaim;
	@varthemes_report = @main::varthemes_report;
	@varthemes_variations = @vmain::arthemes_variations;
	@varthemes_steps = @main::varthemes_steps;
	@rankdata = @main::rankdata; # CUT ZZZ
	@rankcolumn = @main::rankcolumn;
	%reportdata = %main::reportdata;
	@files_to_filter = @main::files_to_filter;
	@filter_reports = @main::filter_reports;
	@base_columns = @main::base_columns;
	@maketabledata = @main::maketabledata;
	@filter_columns = @main::filter_columns;
	%vals = %main::vals;
	
	my @simcases = @{ $dirfiles{simcases} }; #say "dump(\@simcases): " . dump(@simcases);
	my @simstruct = @{ $dirfiles{simstruct} }; #say "dump(\@simstruct): " . dump(@simstruct);
	my @morphcases = @{ $dirfiles{morphcases} };
	my @morphstruct = @{ $dirfiles{morphstruct} };
	my @retcases = @{ $dirfiles{retcases} };
	my @retstruct = @{ $dirfiles{retstruct} };
	my @repcases = @{ $dirfiles{repcases} };
	my @repstruct = @{ $dirfiles{repstruct} };
	my @mergecases = @{ $dirfiles{mergecases} };
	my @mergestruct = @{ $dirfiles{mergestruct} };
	my @descendcases = @{ $dirfiles{descendcases} };
	my @descendstruct = @{ $dirfiles{descendstruct} };
	
	my $morphlist = $dirfiles{morphlist}; #say "dump(\$dat{morphlist}): " . dump($dat{morphlist});
	my $morphblock = $dirfiles{morphblock};
	my $simlist = $dirfiles{simlist}; #say "dump(\$simlist): " . dump($simlist);
	my $simblock = $dirfiles{simblock};
	my $retlist = $dirfiles{retlist};
	my $retblock = $dirfiles{retblock};
	my $replist = $dirfiles{replist};
	my $repblock = $dirfiles{repblock};
	my $descendlist = $dirfiles{descendlist};
	my $descendblock = $dirfiles{descendblock};
	
	my $skipfile = $vals{skipfile}; say TOFILE "dump(\$skipfile): " . dump($skipfile);
	my $skipsim = $vals{skipsim}; say TOFILE "dump(\$skipsim): " . dump($skipsim);
	my $skipreport = $vals{skipreport}; say TOFILE "dump(\$skipreport): " . dump($skipreport);
	
	#my $getpars = shift;
	#eval( $getpars );

	#if ( fileno (MORPHLIST) 

	my @container;
	#say TOFILE "dump(\@instances): " . dump(@instances);
	my $countinstance = 0;
	foreach my $instance (@instances)
	{
		my %d = %{$instance};
		my $countcase = $d{countcase}; #say TOFILE "dump(\$countcase): " . dump($countcase);
		my $countblock = $d{countblock}; #say TOFILE "dump(\$countblock): " . dump($countblock);
		my @miditers = @{ $d{miditers} }; #say TOFILE "dump(\@miditers): " . dump(@miditers);
		my @winneritems = @{ $d{winneritems} }; #say TOFILE "dumpIN( \@winneritems) " . dump(@winneritems);
		my $countvar = $d{countvar}; #say TOFILE "dump(\$countvar): " . dump($countvar);
		my $countstep = $d{countstep}; #say TOFILE "dump(\$countstep): " . dump($countstep);						
		my $to = $d{to}; #say TOFILE "dump(\$to): " . dump($to);
		my $origin = $d{origin}; #say TOFILE "dump(\$origin): " . dump($origin);
		my @uplift = @{ $d{uplift} }; #say TOFILE "dump(\@uplift): " . dump(@uplift);
		#eval($getparshere);
		
		my $rootname = Sim::OPT::getrootname(\@rootnames, $countcase); #say TOFILE "dump(\$rootname): " . dump($rootname);
		my @blockelts = Sim::OPT::getblockelts(\@sweeps, $countcase, $countblock); #say TOFILE "dumpIN( \@blockelts) " . dump(@blockelts);
		my @blocks = Sim::OPT::getblocks(\@sweeps, $countcase);  #say TOFILE "dumpIN( \@blocks) " . dump(@blocks);
		my $toitem = Sim::OPT::getitem(\@winneritems, $countcase, $countblock); #say TOFILE "dump(\$toitem): " . dump($toitem);
		my $from = Sim::OPT::getline($toitem); #say TOFILE "dumpIN(\$from): " . dump($from);
		my %varnums = Sim::OPT::getcase(\@varinumbers, $countcase); #say TOFILE "dumpIN---(\%varnums): " . dump(%varnums); 
		my %mids = Sim::OPT::getcase(\@miditers, $countcase); #say TOFILE "dumpIN---(\%mids): " . dump(%mids); 
		#eval($getfly);
		
		my $stepsvar = Sim::OPT::getstepsvar($countvar, $countcase, \@varinumbers); #say TOFILE "dump(\$stepsvar): " . dump($stepsvar); 
		my $varnumber = $countvar; #say TOFILE "dump---(\$varnumber): " . dump($varnumber) . "\n\n";  # LEGACY VARIABLE
		
		my @ress;
		my @flfs;
		my $countdir = 0;
		
		#my $prov = $to;
		#my $prov =~ s/$mypath\/$file//;
		#my $prov =~ s/_$//;
		#my $prov =~ s/_-*$//;
		#if ( not ( $to ~~ @{ $simcases[$countcase] } ) )
		#{
		#	push ( @simcases, $to ); say TOFILE "simcases: " . dump(@simcases);
		#	print SIMLIST "$to\n";
		#}
		
		my $numberof_simtools = scalar ( keys %{ $dowhat{simtools} } ); #say TOFILE "\$numberof_simtools " . dump( $numberof_simtools );
		my $simelt = $to;
		
		my $counttool = 1;
		while ( $counttool <= $numberof_simtools )
		{	
			my $skip = $vals{$countvar}{$counttool}{skip}; #say TOFILE "dumpinsim(\$skip): " . dump($skip);
			if ( not ( eval ( $skipsim{$counttool} )))
			{
				my $tooltype = $dowhat{simtools}{$counttool}; #say TOFILE "\$tooltype " . dump( $tooltype );
				
				if ( $tooltype eq "esp-r" )
				{	
					my $launchline;
					unless ( ( "$^O" eq "MSWin32" ) or ( "$^O" eq "MSWin64" ) ) 
					{
						$launchline = "-file $simelt/cfg/$fileconfig -mode script";
					}
					else
					{
						$launchline = "-file $simelt\\cfg\\$fileconfig -mode script";
					}
					
					#say TOFILE "dump(\%simtitles): " . dump( %simtitles ); 
					#say TOFILE "dump(\$simtitles{\$counttool}): " . dump( $simtitles{$counttool} ); 
					#say TOFILE "dump(\@{ \$simtitles{\$counttool}): " . dump( @{ $simtitles{$counttool} } ); 	
					my $countsim = 0;		
					foreach my $simtitle_ref ( @{ $simtitles{$counttool} } )
					{
						my $date_to_sim = $simtitle_ref->[0]; #say TOFILE "dump(\$date_to_sim ): " . dump( $date_to_sim ); 
						my $begin = $simtitle_ref->[1]; #say TOFILE "dump(\$begin): " . dump($begin); 
						my $end = $simtitle_ref->[2]; #say TOFILE "dump(\$end): " . dump($end); 
						my $before = $simtitle_ref->[3]; #say TOFILE "dump(\$before): " . dump($before); 
						my $step = $simtitle_ref->[4]; #say TOFILE "dump(\$step): " . dump($step); 
						
						my $resfile = "$simelt-$date_to_sim-$tooltype.res"; #say TOFILE "dump(\$resfile): " . dump($resfile); 
						my $flfile = "$simelt-$date_to_sim-$tooltype.fl"; #say TOFILE "dump(\$flfile): " . dump($flfile); 

						#if ( fileno (SIMLIST) )
						#if (not (-e $simlist ) )
						#{
						#	if ( $countblock == 0 )
						#	{
								open( SIMLIST, ">>$simlist") or die( "$!" );
						#	}
						#	else 
						#	{
						#		open( SIMLIST, ">>$simlist") or die;
						#	}
						#}
						
						#if ( fileno (SIMBLOCK) )
						if (not (-e $simblock ) )
						{
							if ( $countblock == 0 )
							{
								open( SIMBLOCK, ">>$simblock"); # or die;
							}
							else 
							{
								open( SIMBLOCK, ">>$simblock"); # or die;
							}
						}
						
						#say "INSIM1\$countcase : " . dump($countcase);
						#say "INSIM1\@rootnames : " . dump(@rootnames);
						#say "INSIM1\$countblock : " . dump($countblock);
						#say "INSIM1\@sweeps : " . dump(@sweeps);
						#say "INSIM1\@varinumbers : " . dump(@varinumbers);
						#say "INSIM1\@miditers : " . dump(@miditers);
						#say "INSIM1\@winneritems : " . dump(@winneritems);
						#say "INSIM1\@morphcases : " . dump(@morphcases);
						#say "INSIM1\@morphstruct : " . dump(@morphstruct);
						
						push ( @{ $simstruct[ $countcase ][ $countblock ][ $countinstance ][$counttool] }, $resfile );
						print SIMBLOCK "$resfile\n";
						
						if ( ( not ( $resfile ~~ @simcases ) ) and ( not ( -e $resfile ) ) )
						{
							push ( @simcases, $resfile );
							print SIMLIST "$resfile\n";
								
							unless ( $preventsim eq "y" )
							{
								if ( $simnetwork eq "y" )
								{
									say "#Simulating case " . ($countcase + 1) . ", block " . ($countblock + 1) . ", parameter $countvar at iteration $countstep for tool $tooltype. Instance $countinstance: writing $resfile and $flfile." ;
									my $printthis =	
"bps $launchline<<XXX

c
$resfile
$flfile
$begin
$end
$before
$step
s
$simnetwork
Results for $simelt-$dates_to_sim
y
y
-
-
-
-
-
-
-
XXX
	";
									if ($exeonfiles eq "y") 
									{
										print `$printthis`;
									}
									print TOFILE " 	
			#Simulating case " . ($countcase + 1) . ", block " . ($countblock + 1) . ", parameter $countvar at iteration $countstep. Instance $countinstance.\
			$printthis
			\n";
									print OUTFILE "TWO, $resfile\n";
								}	
								else #  if ( $simnetwork eq "n" )
								{
									say "#Simulating case " . ($countcase + 1) . ", block " . ($countblock + 1) . ", parameter $countvar at iteration $countstep for tool $tooltype. Instance $countinstance: writing $resfile. " ;
									my $printthis =
"bps $launchline<<XXX

c
$resfile
$begin
$end
$before
$step
s
$simnetwork
Results for $simelt-$date_to_sim
y
y
-
-
-
-
-
-
-
XXX
";
									if ($exeonfiles eq "y") 
									{
										print `$printthis`;
									}
									print TOFILE "  
$printthis
";
								}					
							}		
						}							
						$countsim++;
					}
				}
				elsif ( ( $tooltype eq ( "generic" ) ) or ( $tooltype eq ( "energyplus" ) ) )
				{	# TO DO: POSSIBILITY TO SPECIFY LINE AND ELEMENT OF TEXT SUBSTITUTIONS.
					# THIS PART OF PROCEDURE HAS BEEN THOUGHT FOR ENERGYPLUS, THEN GENERALIZED.
					my $countsim = 0;			
					foreach my $simtitle_ref ( @{ $simtitles{$counttool} } )
					{
						my $date_to_sim = $simtitle_ref->[0]; #say TOFILE "dump(\$date_to_sim ): " . dump( $date_to_sim ); 
						my $begin = $simtitle_ref->[1]; #say TOFILE "dump(\$begin): " . dump($begin); 
						my $end = $simtitle_ref->[2]; #say TOFILE "dump(\$end): " . dump($end); 
						my $before = $simtitle_ref->[3]; #say TOFILE "dump(\$before): " . dump($before); 
						my $step = $simtitle_ref->[4]; #say TOFILE "dump(\$step): " . dump($step); 
						 
						my $epw = $simtitle_ref->[5]; #say TOFILE "dump(\$epw ): " . dump( $epw ); 
						my $epwfile = $mypath . "/" . $epw; #say TOFILE"\$epwfile " . dump( $epwfile );
						my $epdir = $simtitle_ref->[6]; #say TOFILE "dump(\$epdir ): " . dump( $epdir ); 
						my $epoldfile = $simtitle_ref->[7]; #say TOFILE "dump(\$epoldfile ): " . dump( $epoldfile ); 
						my $epnewfragment = $simtitle_ref->[8]; #say TOFILE "dump(\$epnewfragment ): " . dump( $epnewfragment );  
						my $outputdir = $simtitle_ref->[9]; #say TOFILE "dump(\$outputdir ): " . dump( $outputdir ); 
						my $modfiletype = $simtitle_ref->[10]; #say TOFILE "dump(\$modfiletype ): " . dump( $modfiletype ); 
						my $resfiletype = $simtitle_ref->[11]; #say TOFILE "dump(\$resfiletype ): " . dump( $resfiletype ); 
						my $epoldpath = $to . $epdir . "/" . $epoldfile; #say TOFILE "dump(\$epoldpath ): " . dump( $epoldpath ); 
						my $tempname = $to;
						$tempname =~ s/$mypath\/// ; #say TOFILE "dump(\$tempname ): " . dump( $tempname ); 
						my $epnewfile = $tempname . $epnewfragment . "$modfiletype"; #say TOFILE "dump(\$epnewfile ): " . dump( $epnewfile ); 
						my $epresroot = $tempname . $epnewfragment ; #say TOFILE "dump(\$epnewfile ): " . dump( $epnewfile ); 
						
						my $epnewpath;
						unless ( ( "$^O" eq "MSWin32" ) or ( "$^O" eq "MSWin64" ) ) 
						{ 
							$epnewpath = $to . $epdir . "/" . $epnewfile; #say TOFILE "dump(\$epnewpath ): " . dump( $epnewpath ); 
						}
						else
						{ 
							$epnewpath = $to . $epdir . "\\" . $epnewfile; #say TOFILE "dump(\$epnewpath ): " . dump( $epnewpath ); 
						}
						
						my @simdos = @{ $simtitle_ref };
						my @changes = @simdos[ 12..$#simdos ]; #say TOFILE "dump(\@changes ): " . dump( @changes ); 
						if ( $tooltype eq "energyplus" ) # RESTORES DEFAULTS FOR ENERGYPLUS
						{
							unless ( ( "$^O" eq "MSWin32" ) or ( "$^O" eq "MSWin64" ) ) 
							{
								$outputdir = "/Output";
							}
							else
							{
								$outputdir = "\\Output";
							}
							$modfiletype = ".idf";
							unless ( defined( $resfilename ) )
							{
								$resfilename = ".eso";
							}
						}
						
						open ( EPOLDPATH, "$epoldpath" ) or die( "$!" );
						my @sourcecontents = <EPOLDPATH>;
						close EPOLDPATH; #say TOFILE "dump(\@sourcecontents ): " . dump( @sourcecontents ); 
						
						unless ( -e $epnewpath )
						{
							open ( EPNEWPATH, ">$epnewpath" ) or die( "$!" );
							foreach my $row ( @sourcecontents )
							{
								foreach my $change ( @changes )
								{
									my $source = $change->[0]; #say T say TOFILE "dump(\$source ): " . dump( $source ); 
									my $target = $change->[1]; #say TOFILE "dump(\$target ): " . dump( $target ); say TOFILE "dump(\$rowBEFORE ): " . dump( $row ); 
									$row =~ s/$source/$target/ ; #say TOFILE "dump(\$rowAFTER ): " . dump( $row ); 
								}
								print EPNEWPATH $row;

							}	
							close EPNEWPATH;
						}
						
						my $file_eplus = "$to/$file_eplus";  #say TOFILE "dump(\$file_eplus ): " . dump( $file_eplus ); 
						
						my $simelt = $mypath . "$outputdir"; #say TOFILE "dump(\$simelt ): " . dump( $simelt ); 
						
						my $resfile;
						unless ( ( "$^O" eq "MSWin32" ) or ( "$^O" eq "MSWin64" ) ) 
						{
							$resfile = "$simelt/$epresroot$resfiletype"; #say TOFILE "dump(\$resfile ): " . dump( $resfile ); 
						}
						else
						{
							$resfile = "$simelt\\$epresroot$resfiletype"; #say TOFILE "dump(\$resfile ): " . dump( $resfile ); 
						}
						
						if (not (-e $simblock ) )
						{
							if ( $countblock == 0 )
							{
								open( SIMBLOCK, ">>$simblock"); # or die;
							}
							else 
							{
								open( SIMBLOCK, ">>$simblock"); # or die;
							}
						}
						
						if (not (-e $retblock ) )
						{
							if ( $countblock == 0 )
							{
								open( RETBLOCK, ">>$retblock"); # or die;
							}
							else 
							{
								open( RETBLOCK, ">>$retblock"); # or die;
							}
						}
						
						push ( @{ $simstruct[ $countcase ][ $countblock ][ $countinstance ][ $counttool ] }, $resfile );
						push ( @{ $retstruct[ $countcase ][ $countblock ][ $countinstance ][ $counttool ] }, $resfile );
						print SIMBLOCK "$resfile\n";
					
						if ( ( not ( $resfile ~~ @retcases ) ) and ( not ( -e $resfile ) ) )
						{
							push ( @simcases, $resfile );
							push ( @retcases, $resfile );
							print SIMLIST "$resfile\n";
							print RETLIST "$resfile\n";
								
							unless ( $preventsim eq "y" )
							{	
								open ( OLDFILEEPLUS, $epoldpath ) or die( "$!" );
								my @oldlines = <OLDFILEEPLUS>;
								close OLDFILEEPLUS;
								unless ( -e $epnewpath )
								{
									open ( NEWFILEEPLUS, ">$epnewpath" ) or die( "$!" );
									foreach my $line ( @oldlines )
									{
										foreach my $elt ( @changes )
										{
											my $old = $elt->[0];
											my $new = $elt->[1];
											$line =~ s/$old/$new/;
										}
										print NEWFILEEPLUS $line;
									}
									close NEWFILEEPLUS;
								}
								
								my $templaunch;
								unless ( -e $resfile )
								{
									unless ( $exeonfiles eq "n" )
										{
										
										my $tempf = $epnewpath; #say TOFILE "dump(\$tempf1 ): " . dump( $tempf );
										unless ( ( "$^O" eq "MSWin32" ) or ( "$^O" eq "MSWin64" ) ) 
										{
											$tempf =~ s/$to$epdir\///;  #say TOFILE "dump(\$tempf2 ): " . dump( $tempf ); 
											$templaunch = $mypath . "/" . $tempf; #say TOFILE "dump(\$templaunch ): " . dump( $templaunch ); 
											`cp -f $epnewpath $templaunch`;
										}
										else
										{
											$tempf =~ s/$to$epdir\\//;  #say TOFILE "dump(\$tempf2 ): " . dump( $tempf ); 
											$templaunch = $mypath . "\\" . $tempf; #say TOFILE "dump(\$templaunch ): " . dump( $templaunch ); 
											`xcopy  /e /c /r /y $epnewpath $templaunch`;
										}
										`runenergyplus $templaunch $epwfile`;
										#`rm -f $templaunch`;
									}
									unless ( ( "$^O" eq "MSWin32" ) or ( "$^O" eq "MSWin64" ) ) 
									{
										print TOFILE "cp -f $epnewpath $templaunch\n";
									}
									else
									{
										print TOFILE "xcopy  /e /c /r /y $epnewpath $templaunch\n";
									}
									print TOFILE "runenergyplus $templaunch $epwfile\n";
									#print TOFILE "rm -f $templaunch\n";
									say "#Simulating case " . ($countcase + 1) . ", block " . ($countblock + 1) . ", parameter $countvar at iteration $countstep for tool $tooltype. Instance $countinstance: using $epnewpath (actually $templaunch) to obtain $resfile. " ;										
								}
							}	
						}
						$countsim++;
					}
				}
			}
			$counttool++;
		}	
		$countinstance++;
	}
	close SIMLIST;
	close SIMBLOCK;
	#say TOFILE "dump(\@simcases ): " . dump( @simcases ); 
	#say TOFILE "dump(\@simstruct ): " . dump( @simstruct ); 
	return ( \@simcases, \@simstruct );
	close TOFILE;
	close OUTFILE;
}    # END SUB sim;			

# END OF THE CONTENT OF Sim::OPT::Sim
##############################################################################
##############################################################################
			
1;			
			
