# NAME

Test::Dependencies - Ensure that the dependency listing is complete

# VERSION

Version 0.21

# SYNOPSIS

In your t/00-dependencies.t:

    use CPAN::Meta;  # or CPAN::Meta::cpanfile
    use File::Find::Rule::Perl;
    use Test::Dependencies exclude =>
      [qw/ Your::Namespace Some::Other::Namespace /];

    my $meta = CPAN::Meta->load_file('META.yml');
    die "No META.yml" if ! $meta;

    my @files =
       File::Find::Rule::Perl->perl_files->in('./lib', './bin');

    ok_dependencies($meta, \@files);

# DESCRIPTION

Makes sure that all of the modules that are 'use'd are listed in the
Makefile.PL as dependencies.

# OPTIONS

**DEPRECATED** You can pass options to the module via the 'use' line.
These options will be moved to the ok\_dependencies() function.
The available options are:

- exclude

    Specifies the list of namespaces for which it is ok not to have
    specified dependencies.

- style

    Specifies the style of module usage checking to use.  There are two
    valid values: "light" and "heavy".  The default is heavy.  The
    light style uses regular expressions to try and guess which modules
    are required.  It is fast, but can get confused by here-docs,
    multi-line strings, data sections, etc.  The heavy style actually
    compiles the file and asks perl which modules were used.  It is
    slower than the light style, but much more accurate.  If you have a
    very large project and you don't want to wait for the heavy style
    every time you run "make test," you might want to try the light
    style or look into the overrides below.

    Whether a style is specified or not, the style used can be overriden
    by the environment variable TDSTYLE.  This is useful, for example, if
    you want the heavy style to be used normally, but don't want to take
    the time checking dependencies on your smoke test server.

    Example usage:

        use Test::Dependencies
          exclude => ['Test::Dependencies'],
          style => 'light';

# EXPORTED FUNCTIONS

## ok\_dependencies($meta, $files, $phases, $features, %options)

    $meta is a CPAN::Meta object
    $files is an arrayref with files to be scanned

### %options keys

- phases

    This is an arrayref holding one or more names of phases
    as defined by [CPAN::Meta::Spec](https://metacpan.org/pod/CPAN::Meta::Spec), or undef for all

- features

    This is an arrayref holding zero or more names of features, or undef for all

- ignores

    This is a hashref listing the names of modules (and their sub-namespaces)
    for which no errors are to be reported.

## ok\_dependencies()

**Deprecated.** Legacy invocation to be removed. In previous versions,
this function would scan the _entire_ bin/, lib/ and t/ subtrees, with the
exception of a few sub-directories known to be used by version control
systems.

This behaviour has been changed: as of 0.20, Find::File::Rule::Perl
is being used to find Perl files (\*.pl, \*.pm, \*.t and those starting with
a shebang line referring to perl).

# AUTHORS

- Jesse Vincent `<jesse at bestpractical.com>`
- Alex Vandiver `<alexmv at bestpractical.com>`
- Zev Benjamin `<zev at cpan.org>`
- Erik Huelsmann `<ehuels at gmail.com>`

# BUGS

- Test::Dependencies does not track module version requirements.

Please report any bugs or feature requests to
`bug-test-dependencies at rt.cpan.org`, or through the web interface at
[http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Test-Dependencies](http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Test-Dependencies).
I will be notified, and then you'll automatically be notified of progress on
your bug as I make changes.

# SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Test::Dependencies

You can also look for information at:

- AnnoCPAN: Annotated CPAN documentation

    [http://annocpan.org/dist/Test-Dependencies](http://annocpan.org/dist/Test-Dependencies)

- CPAN Ratings

    [http://cpanratings.perl.org/d/Test-Dependencies](http://cpanratings.perl.org/d/Test-Dependencies)

- RT: CPAN's request tracker

    [http://rt.cpan.org/NoAuth/Bugs.html?Dist=Test-Dependencies](http://rt.cpan.org/NoAuth/Bugs.html?Dist=Test-Dependencies)

- Search CPAN

    [http://search.cpan.org/dist/Test-Dependencies](http://search.cpan.org/dist/Test-Dependencies)

# LICENCE AND COPYRIGHT

    Copyright (c) 2016, Erik Huelsmann. All rights reserved.
    Copyright (c) 2007, Best Practical Solutions, LLC. All rights reserved.

    This module is free software; you can redistribute it and/or modify it
    under the same terms as Perl itself. See perlartistic.

    DISCLAIMER OF WARRANTY

    BECAUSE THIS SOFTWARE IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
    FOR THE SOFTWARE, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN
    OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
    PROVIDE THE SOFTWARE "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
    EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
    WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
    ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE SOFTWARE IS WITH
    YOU. SHOULD THE SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL
    NECESSARY SERVICING, REPAIR, OR CORRECTION.

    IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
    WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
    REDISTRIBUTE THE SOFTWARE AS PERMITTED BY THE ABOVE LICENCE, BE LIABLE
    TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL, OR
    CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE
    SOFTWARE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING
    RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A
    FAILURE OF THE SOFTWARE TO OPERATE WITH ANY OTHER SOFTWARE), EVEN IF
    SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
    DAMAGES.
