##---------------------------------------------------------------------------##
##  File:
##      @(#) ISO8859_8R.pm 1.1 01/08/19 15:53:56
##  Author:
##      Earl Hood       earl@earlhood.com
##  Description:
##      Mappings for ISO-8859-1.
##---------------------------------------------------------------------------##
##    Copyright (C) 1997,2001	Earl Hood, earl@earlhood.com
##
##    This program is free software; you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation; either version 2 of the License, or
##    (at your option) any later version.
##
##    This program is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with this program; if not, write to the Free Software
##    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
##    02111-1307, USA
##---------------------------------------------------------------------------##

package MHonArc::CharEnt::ISO8859_8R;

##---------------------------------------------------------------------------
##      ISO-8859-8
##---------------------------------------------------------------------------

+{
  #--------------------------------------------------------------------------
  #  Entity	   Hex Code	# ISO external entity and description
  #--------------------------------------------------------------------------
    'cent'	=> 0xA2,	# ISOnum : CENT SIGN
    'pound'	=> 0xA3,	# ISOnum : POUND SIGN
    'curren'	=> 0xA4,	# ISOnum : CURRENCY SIGN
    'yen'	=> 0xA5,	# ISOnum : YEN SIGN
    'brvbar'	=> 0xA6,	# ISOnum : BROKEN BAR
    'sect'	=> 0xA7,	# ISOnum : SECTION SIGN
    'die'	=> 0xA8,	# ISOdia : DIAERESIS
    'copy'	=> 0xA9,	# ISOnum : COPYRIGHT SIGN
    'times'	=> 0xAA,	# ISOnum : MULTIPLICATION SIGN
    'laquo'	=> 0xAB,	# ISOnum : LEFT-POINTING DOUBLE ANGLE
				#	   QUOTATION MARK
    'not'	=> 0xAC,	# ISOnum : NOT SIGN
    'shy'	=> 0xAD,	# ISOnum : SOFT HYPHEN
    'reg'	=> 0xAE,	# ISOnum : REGISTERED SIGN
    'macr'	=> 0xAF,	# ISOdia : OVERLINE (MACRON)
    'deg'	=> 0xB0,	# ISOnum : DEGREE SIGN
    'plusmn'	=> 0xB1,	# ISOnum : PLUS-MINUS SIGN
    'sup2'	=> 0xB2,	# ISOnum : SUPERSCRIPT TWO
    'sup3'	=> 0xB3,	# ISOnum : SUPERSCRIPT THREE
    'acute'	=> 0xB4,	# ISOdia : ACUTE ACCENT
    'micro'	=> 0xB5,	# ISOnum : MICRO SIGN
    'para'	=> 0xB6,	# ISOnum : PILCROW SIGN
    'middot'	=> 0xB7,	# ISOnum : MIDDLE DOT
    'cedil'	=> 0xB8,	# ISOdia : CEDILLA
    'sup1'	=> 0xB9,	# ISOnum : SUPERSCRIPT ONE
    'divide'	=> 0xBA,	# ISOlat1: DIVISION SIGN
    'raquo'	=> 0xBB,	# ISOnum : RIGHT-POINTING DOUBLE ANGLE
				#	   QUOTATION MARK
    'frac14'	=> 0xBC,	# ISOnum : VULGAR FRACTION ONE QUARTER
    'frac12'	=> 0xBD,	# ISOnum : VULGAR FRACTION ONE HALF
    'half'	=> 0xBD,	# ISOnum : VULGAR FRACTION ONE HALF
    'frac34'	=> 0xBE,	# ISOnum : VULGAR FRACTION THREE QUARTERS
    'dlowbar'	=> 0xDF,	# ISOnum?: DOUBLE LOW LINE
    'alef'	=> 0xE0,	# ISOhbrw: HEBREW LETTER ALEF
    'bet'	=> 0xE1,	# ISOhbrw: HEBREW LETTER BET
    'gimel'	=> 0xE2,	# ISOhbrw: HEBREW LETTER GIMEL
    'dalet'	=> 0xE3,	# ISOhbrw: HEBREW LETTER DALET
    'he'	=> 0xE4,	# ISOhbrw: HEBREW LETTER HE
    'vav'	=> 0xE5,	# ISOhbrw: HEBREW LETTER VAV
    'zayin'	=> 0xE6,	# ISOhbrw: HEBREW LETTER ZAYIN
    'het'	=> 0xE7,	# ISOhbrw: HEBREW LETTER HET
    'tet'	=> 0xE8,	# ISOhbrw: HEBREW LETTER TET
    'yod'	=> 0xE9,	# ISOhbrw: HEBREW LETTER YOD
    'fkaf'	=> 0xEA,	# ISOhbrw: HEBREW LETTER FINAL KAF
    'kaf'	=> 0xEB,	# ISOhbrw: HEBREW LETTER KAF
    'lamed'	=> 0xEC,	# ISOhbrw: HEBREW LETTER LAMED
    'fmem'	=> 0xED,	# ISOhbrw: HEBREW LETTER FINAL MEM
    'mem'	=> 0xEE,	# ISOhbrw: HEBREW LETTER MEM
    'fnun'	=> 0xEF,	# ISOhbrw: HEBREW LETTER FINAL NUN
    'nun'	=> 0xF0,	# ISOhbrw: HEBREW LETTER NUN
    'samekh'	=> 0xF1,	# ISOhbrw: HEBREW LETTER SAMEKH
    'ayin'	=> 0xF2,	# ISOhbrw: HEBREW LETTER AYIN
    'fpe'	=> 0xF3,	# ISOhbrw: HEBREW LETTER FINAL PE
    'pe'	=> 0xF4,	# ISOhbrw: HEBREW LETTER PE
    'ftsadi'	=> 0xF5,	# ISOhbrw: HEBREW LETTER FINAL TSADI
    'tsadi'	=> 0xF6,	# ISOhbrw: HEBREW LETTER TSADI
    'qof'	=> 0xF7,	# ISOhbrw: HEBREW LETTER QOF
    'resh'	=> 0xF8,	# ISOhbrw: HEBREW LETTER RESH
    'shin'	=> 0xF9,	# ISOhbrw: HEBREW LETTER SHIN
    'tav'	=> 0xFA,	# ISOhbrw: HEBREW LETTER TAV
};
