#!/usr/bin/perl -w 
#
# Test for IBPerl.
#
# Copyright 1998 Bill Karwin.

use IBPerl;
use strict;

my $DBPATH='employee.gdb',

print "IBPerl version $IBPerl::VERSION\n";

print "1..8\n"; # Test

my $db = new IBPerl::Connection(
    Path=>"$DBPATH",
    User=>'sysdba', Password=>'masterkey');

if ($db->{'Handle'} < 0)
{
    print STDERR "Connection Error:\n$db->{'Error'}\n";
    print "not ok\n"; # Test 1
    exit 1;
}
print "ok\n"; # Test 1

######################################################################

    my $tr = new IBPerl::Transaction(Database=>$db);
    if ($tr->{'Handle'} < 0)
    {
	print STDERR "Transaction Error:\n$tr->{'Error'}\n";
	print "not ok\n"; # Test 2
	exit 1;
    }
    print "ok\n"; # Test 2

    ######################################################################

	my $st = new IBPerl::Statement(Transaction=>$tr,
	    Stmt=>"SELECT * FROM PROJECT");
	if ($st->{'Handle'} < 0)
	{
	    print STDERR "Statement Error:\n$st->{'Error'}\n";
	    print "not ok\n"; # Test 3
	    exit 1;
	}
	print "ok\n"; # Test 3

	if ($st->open == 0)
	{
	    print "ok\n"; # Test 4
	} else {
	    print STDERR "Statement Error:\n$st->{'Error'}\n";
	    print "not ok\n"; # Test 4
	    exit 1;
	}

#	for my $key (keys %$st)
#	{
#	    print "\t$key = $$st{$key}\n";
#	}
	
	my %row;
	while (1)
	{
	    my $ret = $st->fetch(\%row);
	    last if ($ret == 100);
	    if ($ret == -1)
	    {
		print STDERR "Statement Error:\n$st->{'Error'}\n";
		print "not ok\n" # Test 5
	    }
	    last if ($ret != 0);
	    print "ok\n"; # Test 5

	    for my $k (keys %row)
	    {
		print "$k:\t$row{$k}\n";
	    }
	    print "\n";
	}
	if ($st->close == 0)
	{
	    print "ok\n"; # Test 6
	} else {
	    print STDERR "Statement Error:\n$st->{'Error'}\n";
	    print "not ok\n"; # Test 6
	    exit 1;
	}

    ######################################################################

    print "Committing... ";
    if ($tr->commit() < 0)
    {
	print STDERR "Commit Error:\n$tr->{'Error'}\n";
	print "not ok\n"; # Test 7
	exit 1;
    }
    print "ok\n"; # Test 7

######################################################################

print "Disconnecting... ";
if ($db->disconnect() < 0)
{
    print STDERR "Connection Error:\n$tr->{'Error'}\n";
    print "not ok\n"; # Test 8
    exit 1;
}
print "ok\n"; # Test 8

######################################################################

exit 0;
