use ExtUtils::MakeMaker qw( prompt WriteMakefile );

# Saves some headaches for people later.
use 5.005;

{
    unless (-d './Install')
    {
	mkdir './Install', 0755
	    or die "can't make dir ./Install: $!";
    }

    my %config;
    $config{email_address} = prompt( q[
To do a full test of the Log::Dispatch::* modules, we need
to attempt to send an email.  If you want these tests to
be done please supply an address.
Address?] );

    $config{syslog} = prompt( q[ 
Do you want to test Log::Dispatch::Syslog by sending a message as
daemon.notice?
Yes/No?], 'No' );

    delete $config{syslog} if $config{syslog} !~ /^y(?:es)?/i;

    if ($config{syslog})
    {
	my $default;
	foreach ( qw( /var/adm/messages
                      /var/adm/syslog
                      /var/log/messages
                      /var/log/syslog
		      /var/log/syslog
		      /etc/log/syslog ) )
	{
	    if (-e)
	    {
		$default = $_;
		last;
	    }
	}

	$config{syslog_file} = prompt('What file would a message sent as daemon.notice end up in?', $default);

	unless (-r $config{syslog_file})
	{
	    warn "$config{syslog_file} is not readable.  Syslog tests will be skipped\n";
	    delete $config{syslog};
	    delete $config{syslog_file};
	}
    }

    open CFG, ">./Install/TestConfig.pm"
	or die "can't write to ./Install/TestConfig.pm: $!";

    print CFG <<"EOF";
#
#    This file was automatically generated by Makefile.PL. Do not
#    edit, instead do a "make realclean" in the toplevel directory and
#    rerun "perl makefile.PL".
#

package Install::TestConfig;
EOF

    print CFG "\%config = \n(\n";
    foreach (keys %config)
    {
	print CFG "\t$_ => '$config{$_}',\n";
    }
    print CFG ');';
    close CFG;
}

my %extra_pms;
{
    print <<'EOF';

Please list any extra modules you would like added as part of this
installation.  These should be located somewhere under the Dispatch/
directory.  Please type the path after Dispatch/ (including the .pm
extension).

Press enter a blank line when you are done.

EOF

    while (1)
    {
	chomp (my $module = <STDIN>);
	last unless $module;

	if (-e "./Dispatch/$module")
	{
	    $extra_pms{"Dispatch/$module"} = '$(INST_LIBDIR)/Dispatch/' . $module;
	}
	else
	{
	    warn "Couldn't find ./Dispatch/$module\n";
	}
    }
}



WriteMakefile(
	      'NAME'	=> 'Log::Dispatch',
	      'VERSION_FROM' => 'Dispatch.pm',
	      'PM' => {
		       'Dispatch.pm' => '$(INST_LIBDIR)/Dispatch.pm',
		       'Dispatch/ApacheLog.pm' => '$(INST_LIBDIR)/Dispatch/ApacheLog.pm',
		       'Dispatch/Base.pm' => '$(INST_LIBDIR)/Dispatch/Base.pm',
		       'Dispatch/Output.pm' => '$(INST_LIBDIR)/Dispatch/Output.pm',
		       'Dispatch/File.pm' => '$(INST_LIBDIR)/Dispatch/File.pm',
		       'Dispatch/Handle.pm' => '$(INST_LIBDIR)/Dispatch/Handle.pm',
		       'Dispatch/Screen.pm' => '$(INST_LIBDIR)/Dispatch/Screen.pm',
		       'Dispatch/Syslog.pm' => '$(INST_LIBDIR)/Dispatch/Syslog.pm',
		       'Dispatch/Email.pm' => '$(INST_LIBDIR)/Dispatch/Email.pm',
		       'Dispatch/Email/MailSend.pm' => '$(INST_LIBDIR)/Dispatch/Email/MailSend.pm',
		       'Dispatch/Email/MailSendmail.pm' => '$(INST_LIBDIR)/Dispatch/Email/MailSendmail.pm',
		       'Dispatch/Email/MIMELite.pm' => '$(INST_LIBDIR)/Dispatch/Email/MIMELite.pm',

		       %extra_pms,
		      },

	      AUTHOR => 'Dave Rolsky <autarch@urth.org>',
	      ABSTRACT => 'Uniform logging interface to multiple outputs',

	      realclean => { FILES => 'write_mode.tst ./Install/TestConfig.pm ./Install' },
	     );
