# $Id: pod2html.t,v 1.2 2010-12-07 22:42:06 dpchrist Exp $

use Dpchrist::ExtUtils::MakeMaker;

use Test::More tests		=> 4;

use Capture::Tiny		qw( capture );
use Carp;
use Data::Dumper;
use File::Slurp;
use ExtUtils::MakeMaker;

$|				= 1;
$Data::Dumper::Sortkeys		= 1;

my $inc = $INC{'Dpchrist/ExtUtils/MakeMaker.pm'};

die join(' ',
    'incorrect path to Dpchrist::ExtUtils::MakeMaker.pm detected',
    Data::Dumper->Dump([\%INC], [qw(*INC)]),
) unless $inc =~ /lib\/Dpchrist\/ExtUtils\/MakeMaker.pm$/;

my $version = MM->parse_version($inc);

die join(' ',
    'incorrect Dpchrist::ExtUtils::MakeMaker.pm version detected',
    Data::Dumper->Dump([$version], [qw(version)]),
    Data::Dumper->Dump([\%INC], [qw(*INC)]),
) unless $version eq '1.018';

my ($r, $s, $s2);
my ($stdout, $stderr);
my $o = bless {}, 'Foo';

($stdout, $stderr) = capture {
    $r = eval {
	Dpchrist::ExtUtils::MakeMaker::pod2html();
    };
};
ok (								#     1
    !$@
    && defined $r
    && $r eq ''
    && $stderr =~ /WARNING: requires two or more arguments/s,
    'call with no arguments should return empty string ' .
    'and issue warning'
) or confess join(' ',
    Data::Dumper->Dump([$stdout, $stderr, $r, $@],
		     [qw(stdout   stderr   r   @)]),
);

($stdout, $stderr) = capture {
    $r = eval {
	Dpchrist::ExtUtils::MakeMaker::pod2html($o);
    };
};
ok (								#     2
    !$@
    && defined $r
    && $r eq ''
    && $stderr =~ /WARNING: requires two or more arguments/s,
    'call with one argument should return empty string ' .
    'and issue warning'
) or confess join(' ',
    Data::Dumper->Dump([$stdout, $stderr, $r, $@],
		     [qw(stdout   stderr   r   @)]),
);

($stdout, $stderr) = capture {
    $r = eval {
	$s = 'nosuchfile';
	Dpchrist::ExtUtils::MakeMaker::pod2html($o, $s);
    };
};
ok (								#     3
    !$@
    && defined $r
    && $r eq ''
    && $stderr =~ /WARNING: bad file name/s,
    'call with bad file name should return empty string ' .
    'and issue warning'
) or confess join(' ',
    Data::Dumper->Dump([$stdout, $stderr, $s, $r, $@],
		     [qw(stdout   stderr   s   r   @)]),
);

$r = eval {
    $s = join ' ', __FILE__, __LINE__, '~tmp';
    my $s2 = join("\n",
	'package'     . __FILE__ .       __LINE__ . ';',
	'$VERSION = ' . __LINE__ . '.' . __LINE__ . ';',
    );
    write_file($s, $s2);
    Dpchrist::ExtUtils::MakeMaker::pod2html($o, $s);
};
ok (								#     4
    !$@
    && defined $r
    && $r =~ /pod2html.+$s/s,
    'call with correct arguments should generate Makefile fragment'
) or confess join(' ',
    Data::Dumper->Dump([$s, $s2, $r, $@], [qw(s s2 r @)]),
);

