package Locales::DB::Language::rm;

use strict;
use warnings;

# Auto generated from CLDR

$Locales::DB::Language::rm::VERSION = '0.09';

$Locales::DB::Language::rm::cldr_version = '2.0';

%Locales::DB::Language::rm::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => '’',
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Lingua\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ and\ \{1\}",
            'end'    => "\{0\}\,\ and\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0 \%",
        'territory' => "Regiun\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '›',
        'alternate_quotation_start' => '‹',
        'quotation_end'             => '»',
        'quotation_start'           => '«'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => {
            'one' => sub {
                if ( ( ( $_[0] == 1 ) ) ) { return 'one'; }
                return;
              }
        }
    },
    'posix' => {
        'nostr' => {
            'content' => "na\:n",
            'draft'   => 'contributed'
        },
        'yesstr' => {
            'content' => "gea\:g",
            'draft'   => 'contributed'
        }
    },
);

%Locales::DB::Language::rm::code_to_name = (
    'aa'    => 'afar',
    'ab'    => 'abchasian',
    'ace'   => 'aceh',
    'ach'   => 'acoli',
    'ada'   => 'andangme',
    'ady'   => 'adygai',
    'ae'    => 'avestic',
    'af'    => 'afrikaans',
    'afa'   => "lingua\ afro\-asiatica",
    'afh'   => 'afrihili',
    'agq'   => 'Aghem',
    'ain'   => 'ainu',
    'ak'    => 'akan',
    'akk'   => 'accadic',
    'ale'   => 'aleutic',
    'alg'   => "linguas\ algonchinas",
    'alt'   => "altaic\ dal\ sid",
    'am'    => 'amaric',
    'an'    => 'aragonais',
    'ang'   => "englais\ vegl",
    'anp'   => 'angika',
    'apa'   => "linguas\ apachas",
    'ar'    => 'arab',
    'arc'   => 'arameic',
    'arn'   => 'araucanic',
    'arp'   => 'arapaho',
    'art'   => "lingua\ artifiziala",
    'arw'   => 'arawak',
    'as'    => 'assami',
    'asa'   => 'Asu',
    'ast'   => 'asturian',
    'ath'   => "linguas\ athapascas",
    'aus'   => "linguas\ australianas",
    'av'    => 'avaric',
    'awa'   => 'awadhi',
    'ay'    => 'aymara',
    'az'    => 'aserbeidschanic',
    'ba'    => 'baschkir',
    'bad'   => 'banda',
    'bai'   => "lingua\ bamileka",
    'bal'   => 'belutschi',
    'ban'   => 'balinais',
    'bas'   => 'basaa',
    'bat'   => "lingua\ baltica",
    'be'    => 'bieloruss',
    'bej'   => 'bedscha',
    'bem'   => 'bemba',
    'ber'   => 'berb',
    'bez'   => 'Bena',
    'bg'    => 'bulgar',
    'bh'    => 'bihari',
    'bho'   => 'bhojpuri',
    'bi'    => 'bislama',
    'bik'   => 'bikol',
    'bin'   => 'bini',
    'bla'   => 'siksika',
    'bm'    => 'bambara',
    'bn'    => 'bengal',
    'bnt'   => 'bantu',
    'bo'    => 'tibetan',
    'br'    => 'breton',
    'bra'   => 'braj',
    'brx'   => 'Bodo',
    'bs'    => 'bosniac',
    'btk'   => 'batak',
    'bua'   => 'buriat',
    'bug'   => 'bugi',
    'byn'   => 'blin',
    'ca'    => 'catalan',
    'cad'   => 'caddo',
    'cai'   => "linguas\ dals\ Indians\ da\ l\'America\ centrala",
    'car'   => 'caribic',
    'cau'   => "linguas\ dal\ Caucasus",
    'cay'   => 'Cayuga',
    'cch'   => 'atsam',
    'ce'    => 'tschetschen',
    'ceb'   => 'cebuano',
    'cel'   => "linguas\ celticas",
    'cgg'   => 'Chiga',
    'ch'    => 'chamorro',
    'chb'   => 'chibcha',
    'chg'   => 'tschagataic',
    'chk'   => 'chuukais',
    'chm'   => 'mari',
    'chn'   => "patuà\ chinook",
    'cho'   => 'choctaw',
    'chp'   => 'chipewyan',
    'chr'   => 'cherokee',
    'chy'   => 'cheyenne',
    'cmc'   => "linguas\ chamicas",
    'co'    => 'cors',
    'cop'   => 'coptic',
    'cpe'   => "creol\ u\ pidgin\ che\ sa\ basan\ sin\ l\'englais",
    'cpf'   => "creol\ u\ pidgin\ che\ sa\ basan\ sin\ il\ franzos",
    'cpp'   => "creol\ u\ pidgin\ che\ sa\ basan\ sin\ il\ portugais",
    'cr'    => 'cree',
    'crh'   => "tirc\ crimean",
    'crp'   => "creolic\ u\ pidgin",
    'cs'    => 'tschec',
    'csb'   => 'kaschubic',
    'cu'    => "slav\ da\ baselgia",
    'cus'   => "linguas\ cuschiticas",
    'cv'    => 'tschuvasch',
    'cy'    => 'kimric',
    'da'    => 'danais',
    'dak'   => 'dakota',
    'dar'   => 'dargwa',
    'dav'   => 'Taita',
    'day'   => 'dayak',
    'de'    => 'tudestg',
    'de_at' => "tudestg\ austriac",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'delaware',
    'den'   => 'slavey',
    'dgr'   => 'dogrib',
    'din'   => 'dinka',
    'dje'   => 'Zarma',
    'doi'   => 'dogri',
    'dra'   => "lingua\ dravidica",
    'dsb'   => "bass\ sorb",
    'dua'   => 'duala',
    'dum'   => "ollandais\ mesaun",
    'dv'    => 'maledivic',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'diula',
    'dz'    => 'dzongkha',
    'ebu'   => 'Embu',
    'ee'    => 'ewe',
    'efi'   => 'efik',
    'egy'   => "egipzian\ vegl",
    'eka'   => 'ekajuk',
    'el'    => 'grec',
    'elx'   => 'elamitic',
    'en'    => 'englais',
    'en_au' => "englais\ australian",
    'en_ca' => "englais\ canadais",
    'en_gb' => "englais\ britannic",
    'en_us' => "englais\ american",
    'enm'   => "englais\ mesaun",
    'eo'    => 'esperanto',
    'es'    => 'spagnol',
    'es_es' => "spagnol\ iberic",
    'et'    => 'eston',
    'eu'    => 'basc',
    'ewo'   => 'ewondo',
    'fa'    => 'persian',
    'fan'   => 'fang',
    'fat'   => 'fanti',
    'ff'    => 'fulah',
    'fi'    => 'finlandais',
    'fil'   => 'filippino',
    'fiu'   => "lingua\ ungrofinnica",
    'fj'    => 'fidschian',
    'fo'    => 'ferrais',
    'fon'   => 'fon',
    'fr'    => 'franzos',
    'fr_ca' => "franzos\ canadais",
    'fr_ch' => "franzos\ svizzer",
    'frm'   => "franzos\ mesaun",
    'fro'   => "franzos\ vegl",
    'frr'   => "fris\ dal\ nord",
    'frs'   => "fris\ da\ l\'ost",
    'fur'   => 'friulan',
    'fy'    => 'fris',
    'ga'    => 'irlandais',
    'gaa'   => 'ga',
    'gay'   => 'gayo',
    'gba'   => 'gbaya',
    'gd'    => "gaelic\ scot",
    'gem'   => "lingua\ germana",
    'gez'   => 'geez',
    'gil'   => 'gilbertais',
    'gl'    => 'galician',
    'gmh'   => "tudestg\ mesaun",
    'gn'    => 'guarani',
    'goh'   => "vegl\ tudestg\ da\ scrittira",
    'gon'   => 'gondi',
    'gor'   => 'gorontalo',
    'got'   => 'gotic',
    'grb'   => 'grebo',
    'grc'   => "grec\ vegl",
    'gsw'   => "tudestg\ svizzer",
    'gu'    => 'gujarati',
    'guz'   => 'Gusii',
    'gv'    => 'manx',
    'gwi'   => 'gwichʼin',
    'ha'    => 'haussa',
    'hai'   => 'haida',
    'haw'   => 'hawaian',
    'he'    => 'ebraic',
    'hi'    => 'hindi',
    'hil'   => 'hiligaynon',
    'him'   => 'himachali',
    'hit'   => 'ettitic',
    'hmn'   => 'hmong',
    'ho'    => "hiri\ motu",
    'hr'    => 'croat',
    'hsb'   => "aut\ sorb",
    'ht'    => 'haitian',
    'hu'    => 'ungarais',
    'hup'   => 'hupa',
    'hy'    => 'armen',
    'hz'    => 'herero',
    'ia'    => 'interlingua',
    'iba'   => 'iban',
    'id'    => 'indonais',
    'ie'    => 'interlingue',
    'ig'    => 'igbo',
    'ii'    => "sichuan\ yi",
    'ijo'   => 'ijo',
    'ik'    => 'inupiak',
    'ilo'   => 'ilocano',
    'inc'   => "lingua\ indiana",
    'ine'   => "lingua\ indoeuropeica",
    'inh'   => 'ingush',
    'io'    => 'ido',
    'ira'   => "lingua\ da\ l\'Iran",
    'iro'   => "linguas\ irochesas",
    'is'    => 'islandais',
    'it'    => 'talian',
    'iu'    => 'inuktitut',
    'ja'    => 'giapunais',
    'jbo'   => 'lojban',
    'jmc'   => 'Machame',
    'jpr'   => "giudaic\-persian",
    'jrb'   => "giudaic\-arab",
    'jv'    => 'javanais',
    'ka'    => 'georgian',
    'kaa'   => 'karakalpak',
    'kab'   => 'kabyle',
    'kac'   => 'kachin',
    'kaj'   => 'jju',
    'kam'   => 'kamba',
    'kar'   => 'karen',
    'kaw'   => 'kawi',
    'kbd'   => 'kabardic',
    'kcg'   => 'tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'koro',
    'kg'    => 'kongo',
    'kha'   => 'khasi',
    'khi'   => "lingua\ khoisan",
    'kho'   => 'khotanais',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'kikuyu',
    'kj'    => 'kuanyama',
    'kk'    => 'casac',
    'kl'    => 'grönlandais',
    'kln'   => 'Kalenjin',
    'km'    => 'cambodschan',
    'kmb'   => 'kimbundu',
    'kn'    => 'kannada',
    'ko'    => 'corean',
    'kok'   => 'konkani',
    'kos'   => 'kosraean',
    'kpe'   => 'kpelle',
    'kr'    => 'kanuri',
    'krc'   => "karachay\-balkar",
    'krl'   => 'carelian',
    'kro'   => 'kru',
    'kru'   => 'kurukh',
    'ks'    => 'kashmiri',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'curd',
    'kum'   => 'kumuk',
    'kut'   => 'kutenai',
    'kv'    => 'komi',
    'kw'    => 'cornic',
    'ky'    => 'kirghis',
    'la'    => 'latin',
    'lad'   => 'ladino',
    'lag'   => 'Langi',
    'lah'   => 'lahnda',
    'lam'   => 'lamba',
    'lb'    => 'luxemburgais',
    'lez'   => 'lezghian',
    'lg'    => 'ganda',
    'li'    => 'limburgais',
    'ln'    => 'lingala',
    'lo'    => 'laot',
    'lol'   => 'lomongo',
    'loz'   => 'lozi',
    'lt'    => 'lituan',
    'lu'    => "luba\-katanga",
    'lua'   => "luba\-lulua",
    'lui'   => 'luiseno',
    'lun'   => 'lunda',
    'luo'   => 'luo',
    'lus'   => 'lushai',
    'luy'   => 'Luyia',
    'lv'    => 'letton',
    'mad'   => 'madurais',
    'mag'   => 'magahi',
    'mai'   => 'maithili',
    'mak'   => 'makassar',
    'man'   => 'mandingo',
    'map'   => 'austronesian',
    'mas'   => 'masai',
    'mdf'   => 'moksha',
    'mdr'   => 'mandar',
    'men'   => 'mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'malagassi',
    'mga'   => "irlandais\ mesaun",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'marschallais',
    'mi'    => 'maori',
    'mic'   => 'micmac',
    'min'   => 'minangkabau',
    'mis'   => "diversas\ linguas",
    'mk'    => 'macedon',
    'mkh'   => "lingua\ mon\-khmer",
    'ml'    => 'malayalam',
    'mn'    => 'mongolic',
    'mnc'   => 'manchu',
    'mni'   => 'manipuri',
    'mno'   => 'manobo',
    'mo'    => 'moldav',
    'moh'   => 'mohawk',
    'mos'   => 'mossi',
    'mr'    => 'marathi',
    'ms'    => 'malaic',
    'mt'    => 'maltais',
    'mua'   => 'Mundang',
    'mul'   => 'pluriling',
    'mun'   => "lingua\ munda",
    'mus'   => 'creek',
    'mwl'   => 'mirandais',
    'mwr'   => 'marwari',
    'my'    => 'birman',
    'myn'   => "lingau\ maya",
    'myv'   => 'erzya',
    'na'    => 'nauru',
    'nah'   => 'nahuatl',
    'nai'   => "lingua\ indiana\ da\ l\'America\ dal\ Nord",
    'nap'   => 'neapolitan',
    'naq'   => 'Nama',
    'nb'    => "norvegais\ bokmål",
    'nd'    => "ndebele\ dal\ nord",
    'nds'   => "bass\ tudestg",
    'ne'    => 'nepalais',
    'new'   => 'newari',
    'ng'    => 'ndonga',
    'nia'   => 'nias',
    'nic'   => "lingua\ niger\-cordofanica",
    'niu'   => 'niue',
    'nl'    => 'ollandais',
    'nl_be' => 'flam',
    'nmg'   => 'Kwasio',
    'nn'    => "norvegiais\ nynorsk",
    'no'    => 'norvegiais',
    'nog'   => 'nogai',
    'non'   => "nordic\ vegl",
    'nqo'   => "n\'ko",
    'nr'    => "ndebele\ dal\ sid",
    'nso'   => "sotho\ dal\ nord",
    'nub'   => "linguas\ nubicas",
    'nus'   => 'Nuer',
    'nv'    => 'navajo',
    'nwc'   => "newari\ classic",
    'ny'    => 'nyanja',
    'nym'   => 'nyamwezi',
    'nyn'   => 'nyankole',
    'nyo'   => 'nyoro',
    'nzi'   => 'nzima',
    'oc'    => 'occitan',
    'oj'    => 'ojibwa',
    'om'    => 'oromo',
    'or'    => 'oriya',
    'os'    => 'ossetic',
    'osa'   => 'osage',
    'ota'   => "tirc\ ottoman",
    'oto'   => "linguas\ otomangue",
    'pa'    => 'punjabi',
    'paa'   => "lingua\ papuana",
    'pag'   => 'pangasinan',
    'pal'   => 'pahlavi',
    'pam'   => 'pampanga',
    'pap'   => 'papiamento',
    'pau'   => 'palau',
    'peo'   => "persian\ vegl",
    'phi'   => "lingua\ filippina",
    'phn'   => 'fenizian',
    'pi'    => 'pali',
    'pl'    => 'polac',
    'pon'   => 'ponapean',
    'pra'   => 'prakrit',
    'pro'   => "provenzal\ vegl",
    'ps'    => 'paschto',
    'pt'    => 'portugais',
    'pt_br' => "portugais\ brasilian",
    'pt_pt' => "portugais\ iberian",
    'qu'    => 'quechua',
    'raj'   => 'rajasthani',
    'rap'   => 'rapanui',
    'rar'   => 'rarotonga',
    'rm'    => 'rumantsch',
    'rn'    => 'rundi',
    'ro'    => 'rumen',
    'roa'   => "lingua\ romana",
    'rof'   => 'Rombo',
    'rom'   => 'romani',
    'ru'    => 'russ',
    'rup'   => 'aromunic',
    'rw'    => 'kinyarwanda',
    'rwk'   => 'Rwa',
    'sa'    => 'sanscrit',
    'sad'   => 'sandawe',
    'sah'   => 'jakut',
    'sai'   => "lingua\ indiana\ da\ l\'America\ dal\ Sid",
    'sal'   => "lingua\ salish",
    'sam'   => "arameic\ samaritan",
    'saq'   => 'Samburu',
    'sas'   => 'sasak',
    'sat'   => 'santali',
    'sbp'   => 'Sangu',
    'sc'    => 'sard',
    'scn'   => 'sicilian',
    'sco'   => 'scot',
    'sd'    => 'sindhi',
    'se'    => "sami\ dal\ nord",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'selkup',
    'sem'   => "lingua\ semitica",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'sango',
    'sga'   => "irlandais\ vegl",
    'sgn'   => "lingua\ da\ segns",
    'sh'    => "serbo\-croat",
    'shi'   => 'Tachelhit',
    'shn'   => 'shan',
    'si'    => 'singalais',
    'sid'   => 'sidamo',
    'sio'   => "linguas\ sioux",
    'sit'   => "linguas\ sino\-tibetanas",
    'sk'    => 'slovac',
    'sl'    => 'sloven',
    'sla'   => "lingua\ slava",
    'sm'    => 'samoan',
    'sma'   => "sami\ dal\ sid",
    'smi'   => "lingua\ sami",
    'smj'   => "sami\ lule",
    'smn'   => "sami\ inari",
    'sms'   => "sami\ skolt",
    'sn'    => 'shona',
    'snk'   => 'soninke',
    'so'    => 'somali',
    'sog'   => 'sogdian',
    'son'   => 'songhai',
    'sq'    => 'albanais',
    'sr'    => 'serb',
    'srn'   => "sranan\ tongo",
    'srr'   => 'serer',
    'ss'    => 'swazi',
    'ssa'   => "lingua\ nilo\-sahariana",
    'ssy'   => 'Saho',
    'st'    => "sotho\ dal\ sid",
    'su'    => 'sundanais',
    'suk'   => 'sukuma',
    'sus'   => 'susu',
    'sux'   => 'sumeric',
    'sv'    => 'svedais',
    'sw'    => 'suahili',
    'swb'   => 'Comorian',
    'swc'   => "Congo\ Swahili",
    'syc'   => "siric\ classic",
    'syr'   => 'siric',
    'ta'    => 'tamil',
    'tai'   => "lingua\ tai",
    'te'    => 'telugu',
    'tem'   => 'temne',
    'teo'   => 'Teso',
    'ter'   => 'tereno',
    'tet'   => 'tetum',
    'tg'    => 'tadjik',
    'th'    => 'tailandais',
    'ti'    => 'tigrinya',
    'tig'   => 'tigre',
    'tiv'   => 'tiv',
    'tk'    => 'turkmen',
    'tkl'   => 'tokelau',
    'tl'    => 'tagalog',
    'tlh'   => 'klingonic',
    'tli'   => 'tlingit',
    'tmh'   => 'tamasheq',
    'tn'    => 'tswana',
    'to'    => 'tonga',
    'tog'   => "lingua\ tsonga",
    'tpi'   => "tok\ pisin",
    'tr'    => 'tirc',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'tsimshian',
    'tt'    => 'tatar',
    'tum'   => 'tumbuka',
    'tup'   => "linguas\ tupi",
    'tut'   => "linguas\ altaicas",
    'tvl'   => 'tuvalu',
    'tw'    => 'twi',
    'twq'   => 'Tasawaq',
    'ty'    => 'tahitian',
    'tyv'   => 'tuvinian',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'udmurt',
    'ug'    => 'uiguric',
    'uga'   => 'ugaritic',
    'uk'    => 'ucranais',
    'umb'   => 'mbundu',
    'und'   => "linguas\ betg\ determinadas",
    'ur'    => 'urdu',
    'uz'    => 'usbec',
    'vai'   => 'vai',
    've'    => 'venda',
    'vi'    => 'vietnamais',
    'vo'    => 'volapuk',
    'vot'   => 'votic',
    'vun'   => 'Vunjo',
    'wa'    => 'vallon',
    'wae'   => 'Walser',
    'wak'   => "linguas\ wakash",
    'wal'   => 'walamo',
    'war'   => 'waray',
    'was'   => 'washo',
    'wen'   => 'sorb',
    'wo'    => 'wolof',
    'xal'   => 'kalmuk',
    'xh'    => 'xhosa',
    'xog'   => 'Soga',
    'yao'   => 'yao',
    'yap'   => 'yapais',
    'yav'   => 'Yangben',
    'yi'    => 'jiddic',
    'yo'    => 'yoruba',
    'ypk'   => "linguas\ yupik",
    'yue'   => 'Cantonese',
    'za'    => 'zhuang',
    'zap'   => 'zapotec',
    'zbl'   => "simbols\ da\ Bliss",
    'zen'   => 'zenaga',
    'zh'    => 'chinais',
    'znd'   => 'zande',
    'zu'    => 'zulu',
    'zun'   => 'zuni',
    'zxx'   => "nagins\ cuntegns\ linguistics",
    'zza'   => 'zaza',
);

%Locales::DB::Language::rm::name_to_code = (
    'abchasian'                            => 'ab',
    'accadic'                              => 'akk',
    'aceh'                                 => 'ace',
    'acoli'                                => 'ach',
    'adygai'                               => 'ady',
    'afar'                                 => 'aa',
    'afrihili'                             => 'afh',
    'afrikaans'                            => 'af',
    'aghem'                                => 'agq',
    'ainu'                                 => 'ain',
    'akan'                                 => 'ak',
    'albanais'                             => 'sq',
    'aleutic'                              => 'ale',
    'altaicdalsid'                         => 'alt',
    'amaric'                               => 'am',
    'andangme'                             => 'ada',
    'angika'                               => 'anp',
    'arab'                                 => 'ar',
    'aragonais'                            => 'an',
    'arameic'                              => 'arc',
    'arameicsamaritan'                     => 'sam',
    'arapaho'                              => 'arp',
    'araucanic'                            => 'arn',
    'arawak'                               => 'arw',
    'armen'                                => 'hy',
    'aromunic'                             => 'rup',
    'aserbeidschanic'                      => 'az',
    'assami'                               => 'as',
    'asturian'                             => 'ast',
    'asu'                                  => 'asa',
    'atsam'                                => 'cch',
    'austronesian'                         => 'map',
    'autsorb'                              => 'hsb',
    'avaric'                               => 'av',
    'avestic'                              => 'ae',
    'awadhi'                               => 'awa',
    'aymara'                               => 'ay',
    'bafia'                                => 'ksf',
    'balinais'                             => 'ban',
    'bambara'                              => 'bm',
    'banda'                                => 'bad',
    'bantu'                                => 'bnt',
    'basaa'                                => 'bas',
    'basc'                                 => 'eu',
    'baschkir'                             => 'ba',
    'basssorb'                             => 'dsb',
    'basstudestg'                          => 'nds',
    'batak'                                => 'btk',
    'bedscha'                              => 'bej',
    'belutschi'                            => 'bal',
    'bemba'                                => 'bem',
    'bena'                                 => 'bez',
    'bengal'                               => 'bn',
    'berb'                                 => 'ber',
    'bhojpuri'                             => 'bho',
    'bieloruss'                            => 'be',
    'bihari'                               => 'bh',
    'bikol'                                => 'bik',
    'bini'                                 => 'bin',
    'birman'                               => 'my',
    'bislama'                              => 'bi',
    'blin'                                 => 'byn',
    'bodo'                                 => 'brx',
    'bosniac'                              => 'bs',
    'braj'                                 => 'bra',
    'breton'                               => 'br',
    'bugi'                                 => 'bug',
    'bulgar'                               => 'bg',
    'buriat'                               => 'bua',
    'caddo'                                => 'cad',
    'cambodschan'                          => 'km',
    'cantonese'                            => 'yue',
    'carelian'                             => 'krl',
    'caribic'                              => 'car',
    'casac'                                => 'kk',
    'catalan'                              => 'ca',
    'cayuga'                               => 'cay',
    'cebuano'                              => 'ceb',
    'centralmoroccotamazight'              => 'tzm',
    'chamorro'                             => 'ch',
    'cherokee'                             => 'chr',
    'cheyenne'                             => 'chy',
    'chibcha'                              => 'chb',
    'chiga'                                => 'cgg',
    'chinais'                              => 'zh',
    'chipewyan'                            => 'chp',
    'choctaw'                              => 'cho',
    'chuukais'                             => 'chk',
    'colognian'                            => 'ksh',
    'comorian'                             => 'swb',
    'congoswahili'                         => 'swc',
    'coptic'                               => 'cop',
    'corean'                               => 'ko',
    'cornic'                               => 'kw',
    'cors'                                 => 'co',
    'cree'                                 => 'cr',
    'creek'                                => 'mus',
    'creolicupidgin'                       => 'crp',
    'creolupidginchesabasansinilfranzos'   => 'cpf',
    'creolupidginchesabasansinilportugais' => 'cpp',
    'creolupidginchesabasansinlenglais'    => 'cpe',
    'croat'                                => 'hr',
    'curd'                                 => 'ku',
    'dakota'                               => 'dak',
    'danais'                               => 'da',
    'dargwa'                               => 'dar',
    'dayak'                                => 'day',
    'delaware'                             => 'del',
    'dinka'                                => 'din',
    'diula'                                => 'dyu',
    'diversaslinguas'                      => 'mis',
    'dogri'                                => 'doi',
    'dogrib'                               => 'dgr',
    'duala'                                => 'dua',
    'dzongkha'                             => 'dz',
    'ebraic'                               => 'he',
    'efik'                                 => 'efi',
    'egipzianvegl'                         => 'egy',
    'ekajuk'                               => 'eka',
    'elamitic'                             => 'elx',
    'embu'                                 => 'ebu',
    'englais'                              => 'en',
    'englaisamerican'                      => 'en_us',
    'englaisaustralian'                    => 'en_au',
    'englaisbritannic'                     => 'en_gb',
    'englaiscanadais'                      => 'en_ca',
    'englaismesaun'                        => 'enm',
    'englaisvegl'                          => 'ang',
    'erzya'                                => 'myv',
    'esperanto'                            => 'eo',
    'eston'                                => 'et',
    'ettitic'                              => 'hit',
    'ewe'                                  => 'ee',
    'ewondo'                               => 'ewo',
    'fang'                                 => 'fan',
    'fanti'                                => 'fat',
    'fenizian'                             => 'phn',
    'ferrais'                              => 'fo',
    'fidschian'                            => 'fj',
    'filippino'                            => 'fil',
    'finlandais'                           => 'fi',
    'flam'                                 => 'nl_be',
    'fon'                                  => 'fon',
    'franzos'                              => 'fr',
    'franzoscanadais'                      => 'fr_ca',
    'franzosmesaun'                        => 'frm',
    'franzossvizzer'                       => 'fr_ch',
    'franzosvegl'                          => 'fro',
    'fris'                                 => 'fy',
    'frisdalnord'                          => 'frr',
    'frisdalost'                           => 'frs',
    'friulan'                              => 'fur',
    'fulah'                                => 'ff',
    'ga'                                   => 'gaa',
    'gaelicscot'                           => 'gd',
    'galician'                             => 'gl',
    'ganda'                                => 'lg',
    'gayo'                                 => 'gay',
    'gbaya'                                => 'gba',
    'geez'                                 => 'gez',
    'georgian'                             => 'ka',
    'giapunais'                            => 'ja',
    'gilbertais'                           => 'gil',
    'giudaicarab'                          => 'jrb',
    'giudaicpersian'                       => 'jpr',
    'gondi'                                => 'gon',
    'gorontalo'                            => 'gor',
    'gotic'                                => 'got',
    'grebo'                                => 'grb',
    'grec'                                 => 'el',
    'grecvegl'                             => 'grc',
    'grönlandais'                         => 'kl',
    'guarani'                              => 'gn',
    'gujarati'                             => 'gu',
    'gusii'                                => 'guz',
    'gwichʼin'                            => 'gwi',
    'haida'                                => 'hai',
    'haitian'                              => 'ht',
    'haussa'                               => 'ha',
    'hawaian'                              => 'haw',
    'herero'                               => 'hz',
    'hiligaynon'                           => 'hil',
    'himachali'                            => 'him',
    'hindi'                                => 'hi',
    'hirimotu'                             => 'ho',
    'hmong'                                => 'hmn',
    'hupa'                                 => 'hup',
    'iban'                                 => 'iba',
    'ido'                                  => 'io',
    'igbo'                                 => 'ig',
    'ijo'                                  => 'ijo',
    'ilocano'                              => 'ilo',
    'indonais'                             => 'id',
    'ingush'                               => 'inh',
    'interlingua'                          => 'ia',
    'interlingue'                          => 'ie',
    'inuktitut'                            => 'iu',
    'inupiak'                              => 'ik',
    'irlandais'                            => 'ga',
    'irlandaismesaun'                      => 'mga',
    'irlandaisvegl'                        => 'sga',
    'islandais'                            => 'is',
    'jakut'                                => 'sah',
    'javanais'                             => 'jv',
    'jiddic'                               => 'yi',
    'jju'                                  => 'kaj',
    'jolafonyi'                            => 'dyo',
    'kabardic'                             => 'kbd',
    'kabuverdianu'                         => 'kea',
    'kabyle'                               => 'kab',
    'kachin'                               => 'kac',
    'kalenjin'                             => 'kln',
    'kalmuk'                               => 'xal',
    'kamba'                                => 'kam',
    'kannada'                              => 'kn',
    'kanuri'                               => 'kr',
    'karachaybalkar'                       => 'krc',
    'karakalpak'                           => 'kaa',
    'karen'                                => 'kar',
    'kaschubic'                            => 'csb',
    'kashmiri'                             => 'ks',
    'kawi'                                 => 'kaw',
    'khasi'                                => 'kha',
    'khotanais'                            => 'kho',
    'kikuyu'                               => 'ki',
    'kimbundu'                             => 'kmb',
    'kimric'                               => 'cy',
    'kinyarwanda'                          => 'rw',
    'kirghis'                              => 'ky',
    'klingonic'                            => 'tlh',
    'komi'                                 => 'kv',
    'kongo'                                => 'kg',
    'konkani'                              => 'kok',
    'koro'                                 => 'kfo',
    'kosraean'                             => 'kos',
    'koyraborosenni'                       => 'ses',
    'koyrachiini'                          => 'khq',
    'kpelle'                               => 'kpe',
    'kru'                                  => 'kro',
    'kuanyama'                             => 'kj',
    'kumuk'                                => 'kum',
    'kurukh'                               => 'kru',
    'kutenai'                              => 'kut',
    'kwasio'                               => 'nmg',
    'ladino'                               => 'lad',
    'lahnda'                               => 'lah',
    'lamba'                                => 'lam',
    'langi'                                => 'lag',
    'laot'                                 => 'lo',
    'latin'                                => 'la',
    'letton'                               => 'lv',
    'lezghian'                             => 'lez',
    'limburgais'                           => 'li',
    'lingala'                              => 'ln',
    'lingaumaya'                           => 'myn',
    'linguaafroasiatica'                   => 'afa',
    'linguaartifiziala'                    => 'art',
    'linguabaltica'                        => 'bat',
    'linguabamileka'                       => 'bai',
    'linguadaliran'                        => 'ira',
    'linguadasegns'                        => 'sgn',
    'linguadravidica'                      => 'dra',
    'linguafilippina'                      => 'phi',
    'linguagermana'                        => 'gem',
    'linguaindiana'                        => 'inc',
    'linguaindianadalamericadalnord'       => 'nai',
    'linguaindianadalamericadalsid'        => 'sai',
    'linguaindoeuropeica'                  => 'ine',
    'linguakhoisan'                        => 'khi',
    'linguamonkhmer'                       => 'mkh',
    'linguamunda'                          => 'mun',
    'linguanigercordofanica'               => 'nic',
    'linguanilosahariana'                  => 'ssa',
    'linguapapuana'                        => 'paa',
    'linguaromana'                         => 'roa',
    'linguasalgonchinas'                   => 'alg',
    'linguasalish'                         => 'sal',
    'linguasaltaicas'                      => 'tut',
    'linguasami'                           => 'smi',
    'linguasapachas'                       => 'apa',
    'linguasathapascas'                    => 'ath',
    'linguasaustralianas'                  => 'aus',
    'linguasbetgdeterminadas'              => 'und',
    'linguascelticas'                      => 'cel',
    'linguaschamicas'                      => 'cmc',
    'linguascuschiticas'                   => 'cus',
    'linguasdalcaucasus'                   => 'cau',
    'linguasdalsindiansdalamericacentrala' => 'cai',
    'linguasemitica'                       => 'sem',
    'linguasirochesas'                     => 'iro',
    'linguaslava'                          => 'sla',
    'linguasnubicas'                       => 'nub',
    'linguasotomangue'                     => 'oto',
    'linguassinotibetanas'                 => 'sit',
    'linguassioux'                         => 'sio',
    'linguastupi'                          => 'tup',
    'linguaswakash'                        => 'wak',
    'linguasyupik'                         => 'ypk',
    'linguatai'                            => 'tai',
    'linguatsonga'                         => 'tog',
    'linguaungrofinnica'                   => 'fiu',
    'lituan'                               => 'lt',
    'lojban'                               => 'jbo',
    'lomongo'                              => 'lol',
    'lozi'                                 => 'loz',
    'lubakatanga'                          => 'lu',
    'lubalulua'                            => 'lua',
    'luiseno'                              => 'lui',
    'lunda'                                => 'lun',
    'luo'                                  => 'luo',
    'lushai'                               => 'lus',
    'luxemburgais'                         => 'lb',
    'luyia'                                => 'luy',
    'macedon'                              => 'mk',
    'machame'                              => 'jmc',
    'madurais'                             => 'mad',
    'magahi'                               => 'mag',
    'maithili'                             => 'mai',
    'makassar'                             => 'mak',
    'makhuwameetto'                        => 'mgh',
    'makonde'                              => 'kde',
    'malagassi'                            => 'mg',
    'malaic'                               => 'ms',
    'malayalam'                            => 'ml',
    'maledivic'                            => 'dv',
    'maltais'                              => 'mt',
    'manchu'                               => 'mnc',
    'mandar'                               => 'mdr',
    'mandingo'                             => 'man',
    'manipuri'                             => 'mni',
    'manobo'                               => 'mno',
    'manx'                                 => 'gv',
    'maori'                                => 'mi',
    'marathi'                              => 'mr',
    'mari'                                 => 'chm',
    'marschallais'                         => 'mh',
    'marwari'                              => 'mwr',
    'masai'                                => 'mas',
    'mbundu'                               => 'umb',
    'mende'                                => 'men',
    'meru'                                 => 'mer',
    'micmac'                               => 'mic',
    'minangkabau'                          => 'min',
    'mirandais'                            => 'mwl',
    'mohawk'                               => 'moh',
    'moksha'                               => 'mdf',
    'moldav'                               => 'mo',
    'mongolic'                             => 'mn',
    'morisyen'                             => 'mfe',
    'mossi'                                => 'mos',
    'mundang'                              => 'mua',
    'naginscuntegnslinguistics'            => 'zxx',
    'nahuatl'                              => 'nah',
    'nama'                                 => 'naq',
    'nauru'                                => 'na',
    'navajo'                               => 'nv',
    'ndebeledalnord'                       => 'nd',
    'ndebeledalsid'                        => 'nr',
    'ndonga'                               => 'ng',
    'neapolitan'                           => 'nap',
    'nepalais'                             => 'ne',
    'newari'                               => 'new',
    'newariclassic'                        => 'nwc',
    'nias'                                 => 'nia',
    'niue'                                 => 'niu',
    'nko'                                  => 'nqo',
    'nogai'                                => 'nog',
    'nordicvegl'                           => 'non',
    'norvegaisbokmål'                     => 'nb',
    'norvegiais'                           => 'no',
    'norvegiaisnynorsk'                    => 'nn',
    'nuer'                                 => 'nus',
    'nyamwezi'                             => 'nym',
    'nyanja'                               => 'ny',
    'nyankole'                             => 'nyn',
    'nyoro'                                => 'nyo',
    'nzima'                                => 'nzi',
    'occitan'                              => 'oc',
    'ojibwa'                               => 'oj',
    'ollandais'                            => 'nl',
    'ollandaismesaun'                      => 'dum',
    'oriya'                                => 'or',
    'oromo'                                => 'om',
    'osage'                                => 'osa',
    'ossetic'                              => 'os',
    'pahlavi'                              => 'pal',
    'palau'                                => 'pau',
    'pali'                                 => 'pi',
    'pampanga'                             => 'pam',
    'pangasinan'                           => 'pag',
    'papiamento'                           => 'pap',
    'paschto'                              => 'ps',
    'patuàchinook'                        => 'chn',
    'persian'                              => 'fa',
    'persianvegl'                          => 'peo',
    'pluriling'                            => 'mul',
    'polac'                                => 'pl',
    'ponapean'                             => 'pon',
    'portugais'                            => 'pt',
    'portugaisbrasilian'                   => 'pt_br',
    'portugaisiberian'                     => 'pt_pt',
    'prakrit'                              => 'pra',
    'provenzalvegl'                        => 'pro',
    'punjabi'                              => 'pa',
    'quechua'                              => 'qu',
    'rajasthani'                           => 'raj',
    'rapanui'                              => 'rap',
    'rarotonga'                            => 'rar',
    'romani'                               => 'rom',
    'rombo'                                => 'rof',
    'rumantsch'                            => 'rm',
    'rumen'                                => 'ro',
    'rundi'                                => 'rn',
    'russ'                                 => 'ru',
    'rwa'                                  => 'rwk',
    'saho'                                 => 'ssy',
    'samburu'                              => 'saq',
    'samidalnord'                          => 'se',
    'samidalsid'                           => 'sma',
    'samiinari'                            => 'smn',
    'samilule'                             => 'smj',
    'samiskolt'                            => 'sms',
    'samoan'                               => 'sm',
    'sandawe'                              => 'sad',
    'sango'                                => 'sg',
    'sangu'                                => 'sbp',
    'sanscrit'                             => 'sa',
    'santali'                              => 'sat',
    'sard'                                 => 'sc',
    'sasak'                                => 'sas',
    'scot'                                 => 'sco',
    'selkup'                               => 'sel',
    'sena'                                 => 'seh',
    'seneca'                               => 'see',
    'serb'                                 => 'sr',
    'serbocroat'                           => 'sh',
    'serer'                                => 'srr',
    'shambala'                             => 'ksb',
    'shan'                                 => 'shn',
    'shona'                                => 'sn',
    'sichuanyi'                            => 'ii',
    'sicilian'                             => 'scn',
    'sidamo'                               => 'sid',
    'siksika'                              => 'bla',
    'simbolsdabliss'                       => 'zbl',
    'sindhi'                               => 'sd',
    'singalais'                            => 'si',
    'siric'                                => 'syr',
    'siricclassic'                         => 'syc',
    'slavdabaselgia'                       => 'cu',
    'slavey'                               => 'den',
    'slovac'                               => 'sk',
    'sloven'                               => 'sl',
    'soga'                                 => 'xog',
    'sogdian'                              => 'sog',
    'somali'                               => 'so',
    'songhai'                              => 'son',
    'soninke'                              => 'snk',
    'sorb'                                 => 'wen',
    'sothodalnord'                         => 'nso',
    'sothodalsid'                          => 'st',
    'spagnol'                              => 'es',
    'spagnoliberic'                        => 'es_es',
    'sranantongo'                          => 'srn',
    'suahili'                              => 'sw',
    'sukuma'                               => 'suk',
    'sumeric'                              => 'sux',
    'sundanais'                            => 'su',
    'susu'                                 => 'sus',
    'svedais'                              => 'sv',
    'swazi'                                => 'ss',
    'swisshighgerman'                      => 'de_ch',
    'tachelhit'                            => 'shi',
    'tadjik'                               => 'tg',
    'tagalog'                              => 'tl',
    'tahitian'                             => 'ty',
    'tailandais'                           => 'th',
    'taita'                                => 'dav',
    'talian'                               => 'it',
    'tamasheq'                             => 'tmh',
    'tamil'                                => 'ta',
    'taroko'                               => 'trv',
    'tasawaq'                              => 'twq',
    'tatar'                                => 'tt',
    'telugu'                               => 'te',
    'temne'                                => 'tem',
    'tereno'                               => 'ter',
    'teso'                                 => 'teo',
    'tetum'                                => 'tet',
    'tibetan'                              => 'bo',
    'tigre'                                => 'tig',
    'tigrinya'                             => 'ti',
    'tirc'                                 => 'tr',
    'tirccrimean'                          => 'crh',
    'tircottoman'                          => 'ota',
    'tiv'                                  => 'tiv',
    'tlingit'                              => 'tli',
    'tokelau'                              => 'tkl',
    'tokpisin'                             => 'tpi',
    'tonga'                                => 'to',
    'tschagataic'                          => 'chg',
    'tschec'                               => 'cs',
    'tschetschen'                          => 'ce',
    'tschuvasch'                           => 'cv',
    'tsimshian'                            => 'tsi',
    'tsonga'                               => 'ts',
    'tswana'                               => 'tn',
    'tudestg'                              => 'de',
    'tudestgaustriac'                      => 'de_at',
    'tudestgmesaun'                        => 'gmh',
    'tudestgsvizzer'                       => 'gsw',
    'tumbuka'                              => 'tum',
    'turkmen'                              => 'tk',
    'tuvalu'                               => 'tvl',
    'tuvinian'                             => 'tyv',
    'twi'                                  => 'tw',
    'tyap'                                 => 'kcg',
    'ucranais'                             => 'uk',
    'udmurt'                               => 'udm',
    'ugaritic'                             => 'uga',
    'uiguric'                              => 'ug',
    'ungarais'                             => 'hu',
    'urdu'                                 => 'ur',
    'usbec'                                => 'uz',
    'vai'                                  => 'vai',
    'vallon'                               => 'wa',
    'vegltudestgdascrittira'               => 'goh',
    'venda'                                => 've',
    'vietnamais'                           => 'vi',
    'volapuk'                              => 'vo',
    'votic'                                => 'vot',
    'vunjo'                                => 'vun',
    'walamo'                               => 'wal',
    'walser'                               => 'wae',
    'waray'                                => 'war',
    'washo'                                => 'was',
    'wolof'                                => 'wo',
    'xhosa'                                => 'xh',
    'yangben'                              => 'yav',
    'yao'                                  => 'yao',
    'yapais'                               => 'yap',
    'yoruba'                               => 'yo',
    'zande'                                => 'znd',
    'zapotec'                              => 'zap',
    'zarma'                                => 'dje',
    'zaza'                                 => 'zza',
    'zenaga'                               => 'zen',
    'zhuang'                               => 'za',
    'zulu'                                 => 'zu',
    'zuni'                                 => 'zun',
);

1;
