package Locales::DB::Language::ja;

use strict;
use warnings;

# Auto generated from CLDR

$Locales::DB::Language::ja::VERSION = '0.09';

$Locales::DB::Language::ja::cldr_version = '2.0';

%Locales::DB::Language::ja::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}\.\.\.",
            'initial' => "\.\.\.\{0\}",
            'medial'  => "\{0\}\.\.\.\{1\}"
        },
        'language' => "言語\:\ \{0\}",
        'list'     => {
            2        => "\{0\}、\{1\}",
            'end'    => "\{0\}、\{1\}",
            'middle' => "\{0\}、\{1\}",
            'start'  => "\{0\}、\{1\}"
        },
        'locale'    => "\{0\}\(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "地域\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '』',
        'alternate_quotation_start' => '『',
        'quotation_end'             => '」',
        'quotation_start'           => '「'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list'  => ['other'],
        'category_rules' => {}
    },
    'posix' => {
        'nostr'  => "いいえ\:イイエ",
        'yesstr' => "はい\:ハイ"
    },
);

%Locales::DB::Language::ja::code_to_name = (
    'aa'    => 'アファル語',
    'ab'    => 'アブハズ語',
    'ace'   => 'アチェー語',
    'ach'   => 'アチョリ語',
    'ada'   => 'アダングメ語',
    'ady'   => 'アディゲ語',
    'ae'    => 'アヴェスタ語',
    'af'    => 'アフリカーンス語',
    'afa'   => 'セム・ハム諸語',
    'afh'   => 'アフリヒリ語',
    'agq'   => 'Aghem',
    'ain'   => 'アイヌ語',
    'ak'    => 'アカン語',
    'akk'   => 'アッカド語',
    'ale'   => 'アレウト語',
    'alg'   => 'アルゴンキアン語族',
    'alt'   => '南アルタイ語',
    'am'    => 'アムハラ語',
    'an'    => 'アラゴン語',
    'ang'   => '古代英語',
    'anp'   => 'アンギカ語',
    'apa'   => 'アパッチ語族',
    'ar'    => 'アラビア語',
    'arc'   => 'アラム語',
    'arn'   => 'アラウカン語',
    'arp'   => 'アラパホー語',
    'art'   => '人工諸語',
    'arw'   => 'アラワク語',
    'as'    => 'アッサム語',
    'asa'   => 'アス語',
    'ast'   => 'アストゥリアス語',
    'ath'   => 'アサパスカン語族',
    'aus'   => 'オーストラリア語族',
    'av'    => 'アヴァル語',
    'awa'   => 'アワディー語',
    'ay'    => 'アイマラ語',
    'az'    => 'アゼリー語',
    'ba'    => 'バシキール語',
    'bad'   => 'バンダ語',
    'bai'   => 'バミレケ語族',
    'bal'   => 'バルーチー語',
    'ban'   => 'バリ語',
    'bas'   => 'バサ語',
    'bat'   => 'バルト諸語',
    'be'    => 'ベラルーシ語',
    'bej'   => 'ベジャ語',
    'bem'   => 'ベンバ語',
    'ber'   => 'ベルベル諸語',
    'bez'   => 'ベナ語',
    'bg'    => 'ブルガリア語',
    'bh'    => 'ビハール語',
    'bho'   => 'ボージプリー語',
    'bi'    => 'ビスラマ語',
    'bik'   => 'ビコル語',
    'bin'   => 'ビニ語',
    'bla'   => 'シクシカ語',
    'bm'    => 'バンバラ語',
    'bn'    => 'ベンガル語',
    'bnt'   => 'バントゥ諸語',
    'bo'    => 'チベット語',
    'br'    => 'ブルトン語',
    'bra'   => 'ブラジ語',
    'brx'   => 'ボド語',
    'bs'    => 'ボスニア語',
    'btk'   => 'バタク語',
    'bua'   => 'ブリヤート語',
    'bug'   => 'ブギ語',
    'byn'   => 'ビリン語',
    'ca'    => 'カタロニア語',
    'cad'   => 'カドー語',
    'cai'   => '中米インディアン諸語',
    'car'   => 'カリブ語',
    'cau'   => 'コーカサス諸語',
    'cay'   => 'Cayuga',
    'cch'   => 'チャワイ語',
    'ce'    => 'チェチェン語',
    'ceb'   => 'セブアノ語',
    'cel'   => 'ケルト諸語',
    'cgg'   => 'Chiga',
    'ch'    => 'チャモロ語',
    'chb'   => 'チブチャ語',
    'chg'   => 'チャガタイ語',
    'chk'   => 'チューク語',
    'chm'   => 'マリ語',
    'chn'   => "ビーチ・ラ・マー\ 等",
    'cho'   => 'チョクトー語',
    'chp'   => 'チペワイアン語',
    'chr'   => 'チェロキー語',
    'chy'   => 'シャイアン語',
    'cmc'   => 'チャム語族',
    'co'    => 'コルシカ語',
    'cop'   => 'コプト語',
    'cpe'   => '英語が基盤の混成語・混合語',
    'cpf'   => 'フランス語が基盤の混成語・混合語',
    'cpp'   => 'ポルトガル語が基盤の混成語・混合語',
    'cr'    => 'クリー語',
    'crh'   => 'クリミア・タタール語',
    'crp'   => 'その他の混成語・混合語',
    'cs'    => 'チェコ語',
    'csb'   => 'カシューブ語',
    'cu'    => '教会スラブ語',
    'cus'   => 'クシュ諸語',
    'cv'    => 'チュヴァシュ語',
    'cy'    => 'ウェールズ語',
    'da'    => 'デンマーク語',
    'dak'   => 'ダコタ語',
    'dar'   => 'ダルガン語',
    'dav'   => 'Taita',
    'day'   => 'ダヤク語',
    'de'    => 'ドイツ語',
    'de_at' => "ドイツ語\[オーストリア\]",
    'de_ch' => "正統ドイツ語\[スイス\]",
    'del'   => 'デラウェア語',
    'den'   => 'スレイビー語',
    'dgr'   => 'ドグリブ語',
    'din'   => 'ディンカ語',
    'dje'   => 'Zarma',
    'doi'   => 'ドグリ語',
    'dra'   => 'ドラヴィダ諸語',
    'dsb'   => '低ソルビア語',
    'dua'   => 'ドゥアラ語',
    'dum'   => '中世オランダ語',
    'dv'    => 'ディベヒ語',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'デゥウラ語',
    'dz'    => 'ゾンカ語',
    'ebu'   => 'エンブ語',
    'ee'    => 'エウェ語',
    'efi'   => 'エフィック語',
    'egy'   => '古代エジプト語',
    'eka'   => 'エカジュク語',
    'el'    => 'ギリシャ語',
    'elx'   => 'エラム語',
    'en'    => '英語',
    'en_au' => 'オーストラリア英語',
    'en_ca' => 'カナダ英語',
    'en_gb' => 'イギリス英語',
    'en_us' => 'アメリカ英語',
    'enm'   => '中世英語',
    'eo'    => 'エスペラント語',
    'es'    => 'スペイン語',
    'es_es' => "スペイン語\[イベリア半島\]",
    'et'    => 'エストニア語',
    'eu'    => 'バスク語',
    'ewo'   => 'エウォンド語',
    'fa'    => 'ペルシア語',
    'fan'   => 'ファング語',
    'fat'   => 'ファンティー語',
    'ff'    => 'フラニ語',
    'fi'    => 'フィンランド語',
    'fil'   => 'フィリピノ語',
    'fiu'   => 'フィン・ウゴル諸語',
    'fj'    => 'フィジー語',
    'fo'    => 'フェロー語',
    'fon'   => 'フォン語',
    'fr'    => 'フランス語',
    'fr_ca' => "フランス語\[カナダ\]",
    'fr_ch' => "フランス語\[スイス\]",
    'frm'   => '中期フランス語',
    'fro'   => '古フランス語',
    'frr'   => "Northern\ Frisian",
    'frs'   => '東フリジア語',
    'fur'   => 'フリウリ語',
    'fy'    => 'フリジア語',
    'ga'    => 'アイルランド語',
    'gaa'   => 'ガ語',
    'gay'   => 'ガヨ語',
    'gba'   => 'バヤ語',
    'gd'    => 'スコットランド・ゲール語',
    'gem'   => 'ゲルマン諸語',
    'gez'   => 'ゲエズ語',
    'gil'   => 'キリバス語',
    'gl'    => 'ガリシア語',
    'gmh'   => '中高ドイツ語',
    'gn'    => 'グアラニー語',
    'goh'   => '古高ドイツ語',
    'gon'   => 'ゴーンディー語',
    'gor'   => 'ゴロンタロ語',
    'got'   => 'ゴート語',
    'grb'   => 'グレボ語',
    'grc'   => '古代ギリシャ語',
    'gsw'   => 'スイスドイツ語',
    'gu'    => 'グジャラート語',
    'guz'   => 'Gusii',
    'gv'    => 'マン島語',
    'gwi'   => 'グウィッチン語',
    'ha'    => 'ハウサ語',
    'hai'   => 'ハイダ語',
    'haw'   => 'ハワイ語',
    'he'    => 'ヘブライ語',
    'hi'    => 'ヒンディー語',
    'hil'   => 'ヒリガイノン語',
    'him'   => 'ヒマチャル語',
    'hit'   => 'ヒッタイト語',
    'hmn'   => 'フモン語',
    'ho'    => 'ヒリモトゥ語',
    'hr'    => 'クロアチア語',
    'hsb'   => '上ソルビア語',
    'ht'    => 'ハイチ語',
    'hu'    => 'ハンガリー語',
    'hup'   => 'アタパスカ語',
    'hy'    => 'アルメニア語',
    'hz'    => 'ヘレロ語',
    'ia'    => 'インターリングア語',
    'iba'   => 'イバン語',
    'id'    => 'インドネシア語',
    'ie'    => 'インターリング語',
    'ig'    => 'イボ語',
    'ii'    => '四川イ語',
    'ijo'   => 'イジョー語',
    'ik'    => 'イヌピアック語',
    'ilo'   => 'イロカノ語',
    'inc'   => 'インド諸語',
    'ine'   => '印欧諸語',
    'inh'   => 'イングシ語',
    'io'    => 'イド語',
    'ira'   => 'イラン語',
    'iro'   => 'イロコイ語族',
    'is'    => 'アイスランド語',
    'it'    => 'イタリア語',
    'iu'    => 'イヌクウティトット語',
    'ja'    => '日本語',
    'jbo'   => 'ロジバン語',
    'jmc'   => 'Machame',
    'jpr'   => 'ユダヤ・ペルシア語',
    'jrb'   => 'ユダヤ・アラビア語',
    'jv'    => 'ジャワ語',
    'ka'    => 'グルジア語',
    'kaa'   => 'カラ・カルパク語',
    'kab'   => 'カビル語',
    'kac'   => 'カチン語',
    'kaj'   => 'カジェ語',
    'kam'   => 'カンバ語',
    'kar'   => 'カレン語',
    'kaw'   => 'カウィ語',
    'kbd'   => 'カバルド語',
    'kcg'   => 'カタブ語',
    'kde'   => 'Makonde',
    'kea'   => 'カーボベルデ・クレオール語',
    'kfo'   => 'コロ語',
    'kg'    => 'コンゴ語',
    'kha'   => 'カシ語',
    'khi'   => 'コイサン諸語',
    'kho'   => 'コータン語',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'キクユ語',
    'kj'    => 'クアニャマ語',
    'kk'    => 'カザフ語',
    'kl'    => 'グリーンランド語',
    'kln'   => 'Kalenjin',
    'km'    => 'クメール語',
    'kmb'   => 'キンブンドゥ語',
    'kn'    => 'カンナダ語',
    'ko'    => '韓国語',
    'kok'   => 'コンカニ語',
    'kos'   => 'コシャエ語',
    'kpe'   => 'クペレ語',
    'kr'    => 'カヌリ語',
    'krc'   => 'カラチャイ語',
    'krl'   => 'カレリア語',
    'kro'   => 'クルー語',
    'kru'   => 'クルク語',
    'ks'    => 'カシミール語',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'クルド語',
    'kum'   => 'クムク語',
    'kut'   => 'クテナイ語',
    'kv'    => 'コミ語',
    'kw'    => 'コーンウォール語',
    'ky'    => 'キルギス語',
    'la'    => 'ラテン語',
    'lad'   => 'ラジノ語',
    'lag'   => 'Langi',
    'lah'   => 'ラフンダー語',
    'lam'   => 'ランバ語',
    'lb'    => 'ルクセンブルク語',
    'lez'   => 'レズギ語',
    'lg'    => 'ガンダ語',
    'li'    => 'リンブルフ語',
    'ln'    => 'リンガラ語',
    'lo'    => 'ラオ語',
    'lol'   => 'モンゴ語',
    'loz'   => 'ロズィ語',
    'lt'    => 'リトアニア語',
    'lu'    => 'ルバ・カタンガ語',
    'lua'   => 'ルバ・ルルア語',
    'lui'   => 'ルイセーニョ語',
    'lun'   => 'ルンダ語',
    'luo'   => 'ルオ語',
    'lus'   => 'ルシャイ語',
    'luy'   => 'ルヒヤ語',
    'lv'    => 'ラトビア語',
    'mad'   => 'マドゥラ語',
    'mag'   => 'マガヒー語',
    'mai'   => 'マイティリー語',
    'mak'   => 'マカッサル語',
    'man'   => 'マンディンゴ語',
    'map'   => 'オーストロネシア諸語',
    'mas'   => 'マサイ語',
    'mdf'   => 'モクシャ語',
    'mdr'   => 'マンダル語',
    'men'   => 'メンデ語',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'マダガスカル語',
    'mga'   => '中期アイルランド語',
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'マーシャル語',
    'mi'    => 'マオリ語',
    'mic'   => 'ミクマク語',
    'min'   => 'ミナンカバウ語',
    'mis'   => 'その他の言語',
    'mk'    => 'マケドニア語',
    'mkh'   => 'モン・クメール諸語',
    'ml'    => 'マラヤーラム語',
    'mn'    => 'モンゴル語',
    'mnc'   => '満州語',
    'mni'   => 'マニプル語',
    'mno'   => 'マノボ語族',
    'mo'    => 'モルダビア語',
    'moh'   => 'モーホーク語',
    'mos'   => 'モシ語',
    'mr'    => 'マラーティー語',
    'ms'    => 'マレー語',
    'mt'    => 'マルタ語',
    'mua'   => 'Mundang',
    'mul'   => '複数言語',
    'mun'   => 'ムンダ語族',
    'mus'   => 'クリーク語',
    'mwl'   => 'ミランダ語',
    'mwr'   => 'マールワーリー語',
    'my'    => 'ビルマ語',
    'myn'   => 'マヤ語族',
    'myv'   => 'エルジャ語',
    'na'    => 'ナウル語',
    'nah'   => 'ナワトル語',
    'nai'   => '北米インディアン諸語',
    'nap'   => 'ナポリ語',
    'naq'   => 'Nama',
    'nb'    => "ノルウェー語\[ブークモール\]",
    'nd'    => '北ンデベレ語',
    'nds'   => '低地ドイツ語、低地サクソン語',
    'ne'    => 'ネパール語',
    'new'   => 'ネワール語',
    'ng'    => 'ンドンガ語',
    'nia'   => 'ニアス語',
    'nic'   => 'ニジェール・コルドファン諸語',
    'niu'   => 'ニウーエイ語',
    'nl'    => 'オランダ語',
    'nl_be' => 'フレミッシュ語',
    'nmg'   => 'Kwasio',
    'nn'    => "ノルウェー語\[ニーノシュク\]",
    'no'    => 'ノルウェー語',
    'nog'   => 'ノガイ語',
    'non'   => '古ノルド語',
    'nqo'   => 'ンコ語',
    'nr'    => '南ンデベレ語',
    'nso'   => '北部ソト語',
    'nub'   => 'ヌビア語族',
    'nus'   => 'Nuer',
    'nv'    => 'ナバホ語',
    'nwc'   => '古典ネワール語',
    'ny'    => 'ニャンジャ語、チチェワ語、チェワ語',
    'nym'   => 'ニャムウェジ語',
    'nyn'   => 'ニャンコレ語',
    'nyo'   => 'ニョロ語',
    'nzi'   => 'ンゼマ語',
    'oc'    => 'オック語',
    'oj'    => 'オブジワ語',
    'om'    => 'オロモ語',
    'or'    => 'オリヤー語',
    'os'    => 'オセト語',
    'osa'   => 'オセージ語',
    'ota'   => 'オスマントルコ語',
    'oto'   => 'オトミ語族',
    'pa'    => 'パンジャブ語',
    'paa'   => 'パプア諸語',
    'pag'   => 'パンガシナン語',
    'pal'   => 'パフラヴィ語',
    'pam'   => 'パンパンガ語',
    'pap'   => 'パピアメント語',
    'pau'   => 'パラオ語',
    'peo'   => '古代ペルシア語',
    'phi'   => 'フィリピン諸語',
    'phn'   => 'フェニキア語',
    'pi'    => 'パーリ語',
    'pl'    => 'ポーランド語',
    'pon'   => 'ポンペイ語',
    'pra'   => 'プラークリット語族',
    'pro'   => '古期プロバンス語',
    'ps'    => 'パシュトゥ語',
    'pt'    => 'ポルトガル語',
    'pt_br' => "ポルトガル語\[ブラジル\]",
    'pt_pt' => "ポルトガル語\[イベリア半島\]",
    'qu'    => 'ケチュア語',
    'raj'   => 'ラージャスターン語',
    'rap'   => 'ラパヌイ語',
    'rar'   => 'ラロトガ語',
    'rm'    => 'レト・ロマン語',
    'rn'    => 'ルンディ語',
    'ro'    => 'ルーマニア語',
    'roa'   => 'ロマンス諸語',
    'rof'   => 'ロンボ語',
    'rom'   => 'ロマーニー語',
    'ru'    => 'ロシア語',
    'rup'   => 'アルーマニア語',
    'rw'    => 'ルワンダ語',
    'rwk'   => 'ルワ語',
    'sa'    => 'サンスクリット語',
    'sad'   => 'サンダウェ語',
    'sah'   => 'ヤクート語',
    'sai'   => '南米インディアン諸語',
    'sal'   => 'セイリッシュ語族',
    'sam'   => 'サマリア・アラム語',
    'saq'   => 'Samburu',
    'sas'   => 'ササク語',
    'sat'   => 'サンターリー語',
    'sbp'   => 'Sangu',
    'sc'    => 'サルデーニャ語',
    'scn'   => 'シチリア語',
    'sco'   => 'スコットランド語',
    'sd'    => 'シンド語',
    'se'    => '北サーミ語',
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'セリクプ語',
    'sem'   => 'セム諸語',
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'サンゴ語',
    'sga'   => '古期アイルランド語',
    'sgn'   => '手まね言語',
    'sh'    => 'セルボ＝クロアチア語',
    'shi'   => 'Tachelhit',
    'shn'   => 'シャン語',
    'si'    => 'シンハラ語',
    'sid'   => 'シダモ語',
    'sio'   => 'スー語族',
    'sit'   => 'シナ・チベット諸語',
    'sk'    => 'スロバキア語',
    'sl'    => 'スロベニア語',
    'sla'   => 'スラブ諸語',
    'sm'    => 'サモア語',
    'sma'   => '南サーミ語',
    'smi'   => 'サーミ諸語',
    'smj'   => 'ルレ・サーミ語',
    'smn'   => 'イナリ・サーミ語',
    'sms'   => 'スコルト・サーミ語',
    'sn'    => 'ショナ語',
    'snk'   => 'ソニンケ語',
    'so'    => 'ソマリ語',
    'sog'   => 'ソグド語',
    'son'   => 'ソンガイ語',
    'sq'    => 'アルバニア語',
    'sr'    => 'セルビア語',
    'srn'   => 'スリナム語',
    'srr'   => 'セレル語',
    'ss'    => 'シスワティ語',
    'ssa'   => 'ナイル・サハラ諸語',
    'ssy'   => 'Saho',
    'st'    => '南部ソト語',
    'su'    => 'スンダ語',
    'suk'   => 'スクマ語',
    'sus'   => 'スス語',
    'sux'   => 'シュメール語',
    'sv'    => 'スウェーデン語',
    'sw'    => 'スワヒリ語',
    'swb'   => 'コモロ語',
    'swc'   => "Congo\ Swahili",
    'syc'   => "Classical\ Syriac",
    'syr'   => 'シリア語',
    'ta'    => 'タミール語',
    'tai'   => 'タイ諸語',
    'te'    => 'テルグ語',
    'tem'   => 'テムネ語',
    'teo'   => 'Teso',
    'ter'   => 'テレーノ語',
    'tet'   => 'テトゥン語',
    'tg'    => 'タジク語',
    'th'    => 'タイ語',
    'ti'    => 'ティグリニア語',
    'tig'   => 'ティグレ語',
    'tiv'   => 'ティブ語',
    'tk'    => 'トルクメン語',
    'tkl'   => 'トケラウ語',
    'tl'    => 'タガログ語',
    'tlh'   => 'クリンゴン語',
    'tli'   => 'トリンギット語',
    'tmh'   => 'タマシェク語',
    'tn'    => 'ツワナ語',
    'to'    => 'トンガ語',
    'tog'   => "トンガ語\[ニアサ\]",
    'tpi'   => 'トク・ピシン語',
    'tr'    => 'トルコ語',
    'trv'   => 'Taroko',
    'ts'    => 'ツォンガ語',
    'tsi'   => 'チムシュ語',
    'tt'    => 'タタール語',
    'tum'   => 'トゥンブカ語',
    'tup'   => 'トゥピ語族',
    'tut'   => 'アルタイ諸語',
    'tvl'   => 'ツバル語',
    'tw'    => 'トウィ語',
    'twq'   => 'Tasawaq',
    'ty'    => 'タヒチ語',
    'tyv'   => 'トゥヴァ語',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'ウドムルト語',
    'ug'    => 'ウイグル',
    'uga'   => 'ウガリト語',
    'uk'    => 'ウクライナ語',
    'umb'   => 'ウンブンドゥ語',
    'und'   => '非確定',
    'ur'    => 'ウルドゥー語',
    'uz'    => 'ウズベク語',
    'vai'   => 'ヴァイ語',
    've'    => 'ベンダ語',
    'vi'    => 'ベトナム語',
    'vo'    => 'ボラピュク語',
    'vot'   => 'ボート語',
    'vun'   => 'Vunjo',
    'wa'    => 'ワロン語',
    'wae'   => 'ヴァリス語',
    'wak'   => 'ワカシ語族',
    'wal'   => 'ワッラモ語',
    'war'   => 'ワライ語',
    'was'   => 'ワショ語',
    'wen'   => 'ソルビア語族',
    'wo'    => 'ウォロフ語',
    'xal'   => 'カルムイク語',
    'xh'    => 'コサ語',
    'xog'   => 'Soga',
    'yao'   => 'ヤオ語',
    'yap'   => 'ヤップ語',
    'yav'   => 'Yangben',
    'yi'    => 'イディッシュ語',
    'yo'    => 'ヨルバ語',
    'ypk'   => 'ユピック語族',
    'yue'   => '広東語',
    'za'    => 'チワン語',
    'zap'   => 'ザポテック語',
    'zbl'   => 'Blissymbols',
    'zen'   => 'ゼナガ語',
    'zh'    => '中国語',
    'znd'   => 'ザンデ語',
    'zu'    => 'ズールー語',
    'zun'   => 'ズニ語',
    'zxx'   => '言語的内容なし',
    'zza'   => 'Zaza',
);

%Locales::DB::Language::ja::name_to_code = (
    'aghem'                                               => 'agq',
    'bafia'                                               => 'ksf',
    'blissymbols'                                         => 'zbl',
    'cayuga'                                              => 'cay',
    'centralmoroccotamazight'                             => 'tzm',
    'chiga'                                               => 'cgg',
    'classicalsyriac'                                     => 'syc',
    'colognian'                                           => 'ksh',
    'congoswahili'                                        => 'swc',
    'gusii'                                               => 'guz',
    'jolafonyi'                                           => 'dyo',
    'kalenjin'                                            => 'kln',
    'koyraborosenni'                                      => 'ses',
    'koyrachiini'                                         => 'khq',
    'kwasio'                                              => 'nmg',
    'langi'                                               => 'lag',
    'machame'                                             => 'jmc',
    'makhuwameetto'                                       => 'mgh',
    'makonde'                                             => 'kde',
    'meru'                                                => 'mer',
    'morisyen'                                            => 'mfe',
    'mundang'                                             => 'mua',
    'nama'                                                => 'naq',
    'northernfrisian'                                     => 'frr',
    'nuer'                                                => 'nus',
    'saho'                                                => 'ssy',
    'samburu'                                             => 'saq',
    'sangu'                                               => 'sbp',
    'sena'                                                => 'seh',
    'seneca'                                              => 'see',
    'shambala'                                            => 'ksb',
    'soga'                                                => 'xog',
    'tachelhit'                                           => 'shi',
    'taita'                                               => 'dav',
    'taroko'                                              => 'trv',
    'tasawaq'                                             => 'twq',
    'teso'                                                => 'teo',
    'vunjo'                                               => 'vun',
    'yangben'                                             => 'yav',
    'zarma'                                               => 'dje',
    'zaza'                                                => 'zza',
    'その他の混成語・混合語'                   => 'crp',
    'その他の言語'                                  => 'mis',
    'アイスランド語'                               => 'is',
    'アイヌ語'                                        => 'ain',
    'アイマラ語'                                     => 'ay',
    'アイルランド語'                               => 'ga',
    'アカン語'                                        => 'ak',
    'アサパスカン語族'                            => 'ath',
    'アストゥリアス語'                            => 'ast',
    'アス語'                                           => 'asa',
    'アゼリー語'                                     => 'az',
    'アタパスカ語'                                  => 'hup',
    'アダングメ語'                                  => 'ada',
    'アチェー語'                                     => 'ace',
    'アチョリ語'                                     => 'ach',
    'アッカド語'                                     => 'akk',
    'アッサム語'                                     => 'as',
    'アディゲ語'                                     => 'ady',
    'アパッチ語族'                                  => 'apa',
    'アファル語'                                     => 'aa',
    'アフリカーンス語'                            => 'af',
    'アフリヒリ語'                                  => 'afh',
    'アブハズ語'                                     => 'ab',
    'アムハラ語'                                     => 'am',
    'アメリカ英語'                                  => 'en_us',
    'アラウカン語'                                  => 'arn',
    'アラゴン語'                                     => 'an',
    'アラパホー語'                                  => 'arp',
    'アラビア語'                                     => 'ar',
    'アラム語'                                        => 'arc',
    'アラワク語'                                     => 'arw',
    'アルゴンキアン語族'                         => 'alg',
    'アルタイ諸語'                                  => 'tut',
    'アルバニア語'                                  => 'sq',
    'アルメニア語'                                  => 'hy',
    'アルーマニア語'                               => 'rup',
    'アレウト語'                                     => 'ale',
    'アワディー語'                                  => 'awa',
    'アンギカ語'                                     => 'anp',
    'アヴァル語'                                     => 'av',
    'アヴェスタ語'                                  => 'ae',
    'イギリス英語'                                  => 'en_gb',
    'イジョー語'                                     => 'ijo',
    'イタリア語'                                     => 'it',
    'イディッシュ語'                               => 'yi',
    'イド語'                                           => 'io',
    'イナリ・サーミ語'                            => 'smn',
    'イヌクウティトット語'                      => 'iu',
    'イヌピアック語'                               => 'ik',
    'イバン語'                                        => 'iba',
    'イボ語'                                           => 'ig',
    'イラン語'                                        => 'ira',
    'イロカノ語'                                     => 'ilo',
    'イロコイ語族'                                  => 'iro',
    'イングシ語'                                     => 'inh',
    'インターリングア語'                         => 'ia',
    'インターリング語'                            => 'ie',
    'インドネシア語'                               => 'id',
    'インド諸語'                                     => 'inc',
    'ウイグル'                                        => 'ug',
    'ウェールズ語'                                  => 'cy',
    'ウォロフ語'                                     => 'wo',
    'ウガリト語'                                     => 'uga',
    'ウクライナ語'                                  => 'uk',
    'ウズベク語'                                     => 'uz',
    'ウドムルト語'                                  => 'udm',
    'ウルドゥー語'                                  => 'ur',
    'ウンブンドゥ語'                               => 'umb',
    'エウェ語'                                        => 'ee',
    'エウォンド語'                                  => 'ewo',
    'エカジュク語'                                  => 'eka',
    'エストニア語'                                  => 'et',
    'エスペラント語'                               => 'eo',
    'エフィック語'                                  => 'efi',
    'エラム語'                                        => 'elx',
    'エルジャ語'                                     => 'myv',
    'エンブ語'                                        => 'ebu',
    'オスマントルコ語'                            => 'ota',
    'オセト語'                                        => 'os',
    'オセージ語'                                     => 'osa',
    'オック語'                                        => 'oc',
    'オトミ語族'                                     => 'oto',
    'オブジワ語'                                     => 'oj',
    'オランダ語'                                     => 'nl',
    'オリヤー語'                                     => 'or',
    'オロモ語'                                        => 'om',
    'オーストラリア英語'                         => 'en_au',
    'オーストラリア語族'                         => 'aus',
    'オーストロネシア諸語'                      => 'map',
    'カウィ語'                                        => 'kaw',
    'カザフ語'                                        => 'kk',
    'カシミール語'                                  => 'ks',
    'カシューブ語'                                  => 'csb',
    'カシ語'                                           => 'kha',
    'カジェ語'                                        => 'kaj',
    'カタブ語'                                        => 'kcg',
    'カタロニア語'                                  => 'ca',
    'カチン語'                                        => 'kac',
    'カドー語'                                        => 'cad',
    'カナダ英語'                                     => 'en_ca',
    'カヌリ語'                                        => 'kr',
    'カバルド語'                                     => 'kbd',
    'カビル語'                                        => 'kab',
    'カラチャイ語'                                  => 'krc',
    'カラ・カルパク語'                            => 'kaa',
    'カリブ語'                                        => 'car',
    'カルムイク語'                                  => 'xal',
    'カレリア語'                                     => 'krl',
    'カレン語'                                        => 'kar',
    'カンナダ語'                                     => 'kn',
    'カンバ語'                                        => 'kam',
    'カーボベルデ・クレオール語'             => 'kea',
    'ガヨ語'                                           => 'gay',
    'ガリシア語'                                     => 'gl',
    'ガンダ語'                                        => 'lg',
    'ガ語'                                              => 'gaa',
    'キクユ語'                                        => 'ki',
    'キリバス語'                                     => 'gil',
    'キルギス語'                                     => 'ky',
    'キンブンドゥ語'                               => 'kmb',
    'ギリシャ語'                                     => 'el',
    'クアニャマ語'                                  => 'kj',
    'クシュ諸語'                                     => 'cus',
    'クテナイ語'                                     => 'kut',
    'クペレ語'                                        => 'kpe',
    'クムク語'                                        => 'kum',
    'クメール語'                                     => 'km',
    'クリミア・タタール語'                      => 'crh',
    'クリンゴン語'                                  => 'tlh',
    'クリーク語'                                     => 'mus',
    'クリー語'                                        => 'cr',
    'クルク語'                                        => 'kru',
    'クルド語'                                        => 'ku',
    'クルー語'                                        => 'kro',
    'クロアチア語'                                  => 'hr',
    'グアラニー語'                                  => 'gn',
    'グウィッチン語'                               => 'gwi',
    'グジャラート語'                               => 'gu',
    'グリーンランド語'                            => 'kl',
    'グルジア語'                                     => 'ka',
    'グレボ語'                                        => 'grb',
    'ケチュア語'                                     => 'qu',
    'ケルト諸語'                                     => 'cel',
    'ゲエズ語'                                        => 'gez',
    'ゲルマン諸語'                                  => 'gem',
    'コイサン諸語'                                  => 'khi',
    'コサ語'                                           => 'xh',
    'コシャエ語'                                     => 'kos',
    'コプト語'                                        => 'cop',
    'コミ語'                                           => 'kv',
    'コモロ語'                                        => 'swb',
    'コルシカ語'                                     => 'co',
    'コロ語'                                           => 'kfo',
    'コンカニ語'                                     => 'kok',
    'コンゴ語'                                        => 'kg',
    'コーカサス諸語'                               => 'cau',
    'コータン語'                                     => 'kho',
    'コーンウォール語'                            => 'kw',
    'ゴロンタロ語'                                  => 'gor',
    'ゴート語'                                        => 'got',
    'ゴーンディー語'                               => 'gon',
    'ササク語'                                        => 'sas',
    'サマリア・アラム語'                         => 'sam',
    'サモア語'                                        => 'sm',
    'サルデーニャ語'                               => 'sc',
    'サンゴ語'                                        => 'sg',
    'サンスクリット語'                            => 'sa',
    'サンターリー語'                               => 'sat',
    'サンダウェ語'                                  => 'sad',
    'サーミ諸語'                                     => 'smi',
    'ザポテック語'                                  => 'zap',
    'ザンデ語'                                        => 'znd',
    'シクシカ語'                                     => 'bla',
    'シスワティ語'                                  => 'ss',
    'シダモ語'                                        => 'sid',
    'シチリア語'                                     => 'scn',
    'シナ・チベット諸語'                         => 'sit',
    'シャイアン語'                                  => 'chy',
    'シャン語'                                        => 'shn',
    'シュメール語'                                  => 'sux',
    'ショナ語'                                        => 'sn',
    'シリア語'                                        => 'syr',
    'シンド語'                                        => 'sd',
    'シンハラ語'                                     => 'si',
    'ジャワ語'                                        => 'jv',
    'スイスドイツ語'                               => 'gsw',
    'スウェーデン語'                               => 'sv',
    'スクマ語'                                        => 'suk',
    'スコットランド・ゲール語'                => 'gd',
    'スコットランド語'                            => 'sco',
    'スコルト・サーミ語'                         => 'sms',
    'スス語'                                           => 'sus',
    'スペイン語'                                     => 'es',
    'スペイン語イベリア半島'                   => 'es_es',
    'スラブ諸語'                                     => 'sla',
    'スリナム語'                                     => 'srn',
    'スレイビー語'                                  => 'den',
    'スロバキア語'                                  => 'sk',
    'スロベニア語'                                  => 'sl',
    'スワヒリ語'                                     => 'sw',
    'スンダ語'                                        => 'su',
    'スー語族'                                        => 'sio',
    'ズニ語'                                           => 'zun',
    'ズールー語'                                     => 'zu',
    'セイリッシュ語族'                            => 'sal',
    'セブアノ語'                                     => 'ceb',
    'セム・ハム諸語'                               => 'afa',
    'セム諸語'                                        => 'sem',
    'セリクプ語'                                     => 'sel',
    'セルビア語'                                     => 'sr',
    'セルボ＝クロアチア語'                      => 'sh',
    'セレル語'                                        => 'srr',
    'ゼナガ語'                                        => 'zen',
    'ソグド語'                                        => 'sog',
    'ソニンケ語'                                     => 'snk',
    'ソマリ語'                                        => 'so',
    'ソルビア語族'                                  => 'wen',
    'ソンガイ語'                                     => 'son',
    'ゾンカ語'                                        => 'dz',
    'タイ語'                                           => 'th',
    'タイ諸語'                                        => 'tai',
    'タガログ語'                                     => 'tl',
    'タジク語'                                        => 'tg',
    'タタール語'                                     => 'tt',
    'タヒチ語'                                        => 'ty',
    'タマシェク語'                                  => 'tmh',
    'タミール語'                                     => 'ta',
    'ダコタ語'                                        => 'dak',
    'ダヤク語'                                        => 'day',
    'ダルガン語'                                     => 'dar',
    'チェコ語'                                        => 'cs',
    'チェチェン語'                                  => 'ce',
    'チェロキー語'                                  => 'chr',
    'チブチャ語'                                     => 'chb',
    'チベット語'                                     => 'bo',
    'チペワイアン語'                               => 'chp',
    'チムシュ語'                                     => 'tsi',
    'チャガタイ語'                                  => 'chg',
    'チャム語族'                                     => 'cmc',
    'チャモロ語'                                     => 'ch',
    'チャワイ語'                                     => 'cch',
    'チュヴァシュ語'                               => 'cv',
    'チューク語'                                     => 'chk',
    'チョクトー語'                                  => 'cho',
    'チワン語'                                        => 'za',
    'ツォンガ語'                                     => 'ts',
    'ツバル語'                                        => 'tvl',
    'ツワナ語'                                        => 'tn',
    'ティグリニア語'                               => 'ti',
    'ティグレ語'                                     => 'tig',
    'ティブ語'                                        => 'tiv',
    'テトゥン語'                                     => 'tet',
    'テムネ語'                                        => 'tem',
    'テルグ語'                                        => 'te',
    'テレーノ語'                                     => 'ter',
    'ディベヒ語'                                     => 'dv',
    'ディンカ語'                                     => 'din',
    'デゥウラ語'                                     => 'dyu',
    'デラウェア語'                                  => 'del',
    'デンマーク語'                                  => 'da',
    'トゥピ語族'                                     => 'tup',
    'トゥンブカ語'                                  => 'tum',
    'トゥヴァ語'                                     => 'tyv',
    'トウィ語'                                        => 'tw',
    'トク・ピシン語'                               => 'tpi',
    'トケラウ語'                                     => 'tkl',
    'トリンギット語'                               => 'tli',
    'トルクメン語'                                  => 'tk',
    'トルコ語'                                        => 'tr',
    'トンガ語'                                        => 'to',
    'トンガ語ニアサ'                               => 'tog',
    'ドイツ語'                                        => 'de',
    'ドイツ語オーストリア'                      => 'de_at',
    'ドゥアラ語'                                     => 'dua',
    'ドグリブ語'                                     => 'dgr',
    'ドグリ語'                                        => 'doi',
    'ドラヴィダ諸語'                               => 'dra',
    'ナイル・サハラ諸語'                         => 'ssa',
    'ナウル語'                                        => 'na',
    'ナバホ語'                                        => 'nv',
    'ナポリ語'                                        => 'nap',
    'ナワトル語'                                     => 'nah',
    'ニアス語'                                        => 'nia',
    'ニウーエイ語'                                  => 'niu',
    'ニジェール・コルドファン諸語'          => 'nic',
    'ニャムウェジ語'                               => 'nym',
    'ニャンコレ語'                                  => 'nyn',
    'ニャンジャ語、チチェワ語、チェワ語' => 'ny',
    'ニョロ語'                                        => 'nyo',
    'ヌビア語族'                                     => 'nub',
    'ネパール語'                                     => 'ne',
    'ネワール語'                                     => 'new',
    'ノガイ語'                                        => 'nog',
    'ノルウェー語'                                  => 'no',
    'ノルウェー語ニーノシュク'                => 'nn',
    'ノルウェー語ブークモール'                => 'nb',
    'ハイダ語'                                        => 'hai',
    'ハイチ語'                                        => 'ht',
    'ハウサ語'                                        => 'ha',
    'ハワイ語'                                        => 'haw',
    'ハンガリー語'                                  => 'hu',
    'バサ語'                                           => 'bas',
    'バシキール語'                                  => 'ba',
    'バスク語'                                        => 'eu',
    'バタク語'                                        => 'btk',
    'バミレケ語族'                                  => 'bai',
    'バヤ語'                                           => 'gba',
    'バリ語'                                           => 'ban',
    'バルト諸語'                                     => 'bat',
    'バルーチー語'                                  => 'bal',
    'バンダ語'                                        => 'bad',
    'バントゥ諸語'                                  => 'bnt',
    'バンバラ語'                                     => 'bm',
    'パシュトゥ語'                                  => 'ps',
    'パピアメント語'                               => 'pap',
    'パフラヴィ語'                                  => 'pal',
    'パプア諸語'                                     => 'paa',
    'パラオ語'                                        => 'pau',
    'パンガシナン語'                               => 'pag',
    'パンジャブ語'                                  => 'pa',
    'パンパンガ語'                                  => 'pam',
    'パーリ語'                                        => 'pi',
    'ヒッタイト語'                                  => 'hit',
    'ヒマチャル語'                                  => 'him',
    'ヒリガイノン語'                               => 'hil',
    'ヒリモトゥ語'                                  => 'ho',
    'ヒンディー語'                                  => 'hi',
    'ビコル語'                                        => 'bik',
    'ビスラマ語'                                     => 'bi',
    'ビニ語'                                           => 'bin',
    'ビハール語'                                     => 'bh',
    'ビリン語'                                        => 'byn',
    'ビルマ語'                                        => 'my',
    'ビーチ・ラ・マー等'                         => 'chn',
    'ファング語'                                     => 'fan',
    'ファンティー語'                               => 'fat',
    'フィジー語'                                     => 'fj',
    'フィリピノ語'                                  => 'fil',
    'フィリピン諸語'                               => 'phi',
    'フィンランド語'                               => 'fi',
    'フィン・ウゴル諸語'                         => 'fiu',
    'フェニキア語'                                  => 'phn',
    'フェロー語'                                     => 'fo',
    'フォン語'                                        => 'fon',
    'フモン語'                                        => 'hmn',
    'フラニ語'                                        => 'ff',
    'フランス語'                                     => 'fr',
    'フランス語が基盤の混成語・混合語'    => 'cpf',
    'フランス語カナダ'                            => 'fr_ca',
    'フランス語スイス'                            => 'fr_ch',
    'フリウリ語'                                     => 'fur',
    'フリジア語'                                     => 'fy',
    'フレミッシュ語'                               => 'nl_be',
    'ブギ語'                                           => 'bug',
    'ブラジ語'                                        => 'bra',
    'ブリヤート語'                                  => 'bua',
    'ブルガリア語'                                  => 'bg',
    'ブルトン語'                                     => 'br',
    'プラークリット語族'                         => 'pra',
    'ヘブライ語'                                     => 'he',
    'ヘレロ語'                                        => 'hz',
    'ベジャ語'                                        => 'bej',
    'ベトナム語'                                     => 'vi',
    'ベナ語'                                           => 'bez',
    'ベラルーシ語'                                  => 'be',
    'ベルベル諸語'                                  => 'ber',
    'ベンガル語'                                     => 'bn',
    'ベンダ語'                                        => 've',
    'ベンバ語'                                        => 'bem',
    'ペルシア語'                                     => 'fa',
    'ボスニア語'                                     => 'bs',
    'ボド語'                                           => 'brx',
    'ボラピュク語'                                  => 'vo',
    'ボージプリー語'                               => 'bho',
    'ボート語'                                        => 'vot',
    'ポルトガル語'                                  => 'pt',
    'ポルトガル語が基盤の混成語・混合語' => 'cpp',
    'ポルトガル語イベリア半島'                => 'pt_pt',
    'ポルトガル語ブラジル'                      => 'pt_br',
    'ポンペイ語'                                     => 'pon',
    'ポーランド語'                                  => 'pl',
    'マイティリー語'                               => 'mai',
    'マオリ語'                                        => 'mi',
    'マカッサル語'                                  => 'mak',
    'マガヒー語'                                     => 'mag',
    'マケドニア語'                                  => 'mk',
    'マサイ語'                                        => 'mas',
    'マダガスカル語'                               => 'mg',
    'マドゥラ語'                                     => 'mad',
    'マニプル語'                                     => 'mni',
    'マノボ語族'                                     => 'mno',
    'マヤ語族'                                        => 'myn',
    'マラヤーラム語'                               => 'ml',
    'マラーティー語'                               => 'mr',
    'マリ語'                                           => 'chm',
    'マルタ語'                                        => 'mt',
    'マレー語'                                        => 'ms',
    'マンダル語'                                     => 'mdr',
    'マンディンゴ語'                               => 'man',
    'マン島語'                                        => 'gv',
    'マーシャル語'                                  => 'mh',
    'マールワーリー語'                            => 'mwr',
    'ミクマク語'                                     => 'mic',
    'ミナンカバウ語'                               => 'min',
    'ミランダ語'                                     => 'mwl',
    'ムンダ語族'                                     => 'mun',
    'メンデ語'                                        => 'men',
    'モクシャ語'                                     => 'mdf',
    'モシ語'                                           => 'mos',
    'モルダビア語'                                  => 'mo',
    'モンゴル語'                                     => 'mn',
    'モンゴ語'                                        => 'lol',
    'モン・クメール諸語'                         => 'mkh',
    'モーホーク語'                                  => 'moh',
    'ヤオ語'                                           => 'yao',
    'ヤクート語'                                     => 'sah',
    'ヤップ語'                                        => 'yap',
    'ユダヤ・アラビア語'                         => 'jrb',
    'ユダヤ・ペルシア語'                         => 'jpr',
    'ユピック語族'                                  => 'ypk',
    'ヨルバ語'                                        => 'yo',
    'ラオ語'                                           => 'lo',
    'ラジノ語'                                        => 'lad',
    'ラテン語'                                        => 'la',
    'ラトビア語'                                     => 'lv',
    'ラパヌイ語'                                     => 'rap',
    'ラフンダー語'                                  => 'lah',
    'ラロトガ語'                                     => 'rar',
    'ランバ語'                                        => 'lam',
    'ラージャスターン語'                         => 'raj',
    'リトアニア語'                                  => 'lt',
    'リンガラ語'                                     => 'ln',
    'リンブルフ語'                                  => 'li',
    'ルイセーニョ語'                               => 'lui',
    'ルオ語'                                           => 'luo',
    'ルクセンブルク語'                            => 'lb',
    'ルシャイ語'                                     => 'lus',
    'ルバ・カタンガ語'                            => 'lu',
    'ルバ・ルルア語'                               => 'lua',
    'ルヒヤ語'                                        => 'luy',
    'ルレ・サーミ語'                               => 'smj',
    'ルワンダ語'                                     => 'rw',
    'ルワ語'                                           => 'rwk',
    'ルンダ語'                                        => 'lun',
    'ルンディ語'                                     => 'rn',
    'ルーマニア語'                                  => 'ro',
    'レズギ語'                                        => 'lez',
    'レト・ロマン語'                               => 'rm',
    'ロシア語'                                        => 'ru',
    'ロジバン語'                                     => 'jbo',
    'ロズィ語'                                        => 'loz',
    'ロマンス諸語'                                  => 'roa',
    'ロマーニー語'                                  => 'rom',
    'ロンボ語'                                        => 'rof',
    'ワカシ語族'                                     => 'wak',
    'ワショ語'                                        => 'was',
    'ワッラモ語'                                     => 'wal',
    'ワライ語'                                        => 'war',
    'ワロン語'                                        => 'wa',
    'ンコ語'                                           => 'nqo',
    'ンゼマ語'                                        => 'nzi',
    'ンドンガ語'                                     => 'ng',
    'ヴァイ語'                                        => 'vai',
    'ヴァリス語'                                     => 'wae',
    '上ソルビア語'                                  => 'hsb',
    '中世オランダ語'                               => 'dum',
    '中世英語'                                        => 'enm',
    '中国語'                                           => 'zh',
    '中期アイルランド語'                         => 'mga',
    '中期フランス語'                               => 'frm',
    '中米インディアン諸語'                      => 'cai',
    '中高ドイツ語'                                  => 'gmh',
    '人工諸語'                                        => 'art',
    '低ソルビア語'                                  => 'dsb',
    '低地ドイツ語、低地サクソン語'          => 'nds',
    '北サーミ語'                                     => 'se',
    '北ンデベレ語'                                  => 'nd',
    '北米インディアン諸語'                      => 'nai',
    '北部ソト語'                                     => 'nso',
    '南アルタイ語'                                  => 'alt',
    '南サーミ語'                                     => 'sma',
    '南ンデベレ語'                                  => 'nr',
    '南米インディアン諸語'                      => 'sai',
    '南部ソト語'                                     => 'st',
    '印欧諸語'                                        => 'ine',
    '古ノルド語'                                     => 'non',
    '古フランス語'                                  => 'fro',
    '古代エジプト語'                               => 'egy',
    '古代ギリシャ語'                               => 'grc',
    '古代ペルシア語'                               => 'peo',
    '古代英語'                                        => 'ang',
    '古典ネワール語'                               => 'nwc',
    '古期アイルランド語'                         => 'sga',
    '古期プロバンス語'                            => 'pro',
    '古高ドイツ語'                                  => 'goh',
    '四川イ語'                                        => 'ii',
    '広東語'                                           => 'yue',
    '手まね言語'                                     => 'sgn',
    '教会スラブ語'                                  => 'cu',
    '日本語'                                           => 'ja',
    '東フリジア語'                                  => 'frs',
    '正統ドイツ語スイス'                         => 'de_ch',
    '満州語'                                           => 'mnc',
    '英語'                                              => 'en',
    '英語が基盤の混成語・混合語'             => 'cpe',
    '複数言語'                                        => 'mul',
    '言語的内容なし'                               => 'zxx',
    '非確定'                                           => 'und',
    '韓国語'                                           => 'ko',
);

1;
