package Locales::DB::Language::ee;

use strict;
use warnings;

# Auto generated from CLDR

$Locales::DB::Language::ee::VERSION = '0.09';

$Locales::DB::Language::ee::cldr_version = '2.0';

%Locales::DB::Language::ee::misc_info = (
    'characters'   => { 'more_information' => "\.\.\." },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "gbegbɔgblɔ\ \{0\}",
        'list'     => {
            2        => "\{0\}\ kple\ \{1\}",
            'end'    => "\{0\}\,\ kple\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "memama\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '“',
        'alternate_quotation_start' => '“',
        'quotation_end'             => "\'",
        'quotation_start'           => "\'"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => {
            'one' => sub {
                if ( ( ( $_[0] == 1 ) ) ) { return 'one'; }
                return;
              }
        }
    },
    'posix' => {
        'nostr'  => "ao\:A",
        'yesstr' => "ɛ\:Ɛ"
    },
);

%Locales::DB::Language::ee::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'abkhaziagbe',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => 'afrikaangbe',
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'agq'   => 'aghemgbe',
    'ain'   => 'Ainu',
    'ak'    => 'blugbe',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'amhariagbe',
    'an'    => 'Aragonese',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => 'arabiagbe',
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Artificial\ Language",
    'arw'   => 'Arawak',
    'as'    => 'assamegbe',
    'asa'   => 'asagbe',
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'aymargbe',
    'az'    => 'azerbaijangbe',
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'basaagbe',
    'bat'   => "Baltic\ Language",
    'be'    => 'belarusiagbe',
    'bej'   => 'Beja',
    'bem'   => 'bembagbe',
    'ber'   => 'Berber',
    'bez'   => 'benagbe',
    'bg'    => 'bulgariagbe',
    'bh'    => 'Bihari',
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'bambaragbe',
    'bn'    => 'bengalgbe',
    'bnt'   => 'Bantu',
    'bo'    => 'tibetagbe',
    'br'    => 'bretongbe',
    'bra'   => 'Braj',
    'brx'   => 'bodogbe',
    'bs'    => 'bosniagbe',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'katalagbe',
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cay'   => 'Cayuga',
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ Language",
    'cgg'   => 'Chiga',
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'Corsican',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'tsɛkgbe',
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => 'walesgbe',
    'da'    => 'denmarkgbe',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'dav'   => 'Taita',
    'day'   => 'Dayak',
    'de'    => 'germaniagbe',
    'de_at' => "austriatɔwo\ ƒe\ germaniagbe",
    'de_ch' => "swizerlanɖ\ germaniagbe\ kɔkɔtɔ",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'dje'   => 'zamagbe',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'dualagbe',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'divehgbe',
    'dyo'   => "dzola\-fonyigbe",
    'dyu'   => 'Dyula',
    'dz'    => 'dzongkhagbe',
    'ebu'   => 'embugbe',
    'ee'    => 'eʋegbe',
    'efi'   => 'efigbe',
    'egy'   => "Ancient\ Egyptian",
    'eka'   => 'Ekajuk',
    'el'    => 'grisigbe',
    'elx'   => 'Elamite',
    'en'    => 'yevugbe',
    'en_au' => "australiatɔwo\ ƒe\ yevugbe",
    'en_ca' => "kanadatɔwo\ ƒe\ yevugbe",
    'en_gb' => "britaintɔwo\ ƒe\ yevugbe",
    'en_us' => "u\.s\.dukɔmetɔwo\ ƒe\ yevugbe",
    'enm'   => "Middle\ English",
    'eo'    => 'esperantogbe',
    'es'    => 'spaniagbe',
    'es_es' => "iberiatɔwo\ ƒe\ spaniagbe",
    'et'    => 'estoniagbe',
    'eu'    => 'basqugbe',
    'ewo'   => 'ewondogbe',
    'fa'    => 'persiagbe',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'fulagbe',
    'fi'    => 'finlanɖgbe',
    'fil'   => 'filipingbe',
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'fidzigbe',
    'fo'    => 'Faroese',
    'fon'   => 'Fon',
    'fr'    => 'fransegbe',
    'fr_ca' => "kanadatɔwo\ ƒe\ fransegbe",
    'fr_ch' => "swizerlanɖtɔwo\ ƒe\ fransegbe",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => "Western\ Frisian",
    'ga'    => 'irelanɖgbe',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "Scottish\ Gaelic",
    'gem'   => "Germanic\ Language",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'galatagbe',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'guarangbe',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Ancient\ Greek",
    'gsw'   => "swizerlanɖtɔwo\ ƒe\ germaniagbe",
    'gu'    => 'gujarati',
    'guz'   => 'Gusii',
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'hausagbe',
    'hai'   => 'Haida',
    'haw'   => 'hawaigbe',
    'he'    => 'hebrigbe',
    'hi'    => 'hindigbe',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'kroatiagbe',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'haitigbe',
    'hu'    => 'hungarigbe',
    'hup'   => 'Hupa',
    'hy'    => 'armeniagbe',
    'hz'    => 'Herero',
    'ia'    => 'Interlingua',
    'iba'   => 'Iban',
    'id'    => 'indonesiagbe',
    'ie'    => 'Interlingue',
    'ig'    => 'igbogbe',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'icelanɖgbe',
    'it'    => 'italiagbe',
    'iu'    => 'Inuktitut',
    'ja'    => 'dzapangbe',
    'jbo'   => 'Lojban',
    'jmc'   => 'Machame',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'dzavangbe',
    'ka'    => 'gɔgiagbe',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kde'   => 'Makonde',
    'kea'   => "cape\ verdegbe",
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'kazakhstangbe',
    'kl'    => 'Kalaallisut',
    'kln'   => 'Kalenjin',
    'km'    => 'khmergbe',
    'kmb'   => 'Kimbundu',
    'kn'    => 'kannadagbe',
    'ko'    => 'koreagbe',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'kashmirgbe',
    'ksb'   => 'Shambala',
    'ksf'   => 'bafiagbe',
    'ksh'   => 'Colognian',
    'ku'    => 'kurdiagbe',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'kirghistangbe',
    'la'    => 'latin',
    'lad'   => 'Ladino',
    'lag'   => 'Langi',
    'lah'   => 'lahndagbe',
    'lam'   => 'Lamba',
    'lb'    => 'laksembɔggbe',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'lingala',
    'lo'    => 'laogbe',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'lithuaniagbe',
    'lu'    => "luba\-katangagbe",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'luy'   => 'luyiagbe',
    'lv'    => 'latviagbe',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'malagasegbe',
    'mga'   => "Middle\ Irish",
    'mgh'   => "makuwa\-mitogbe",
    'mh'    => 'Marshallese',
    'mi'    => 'maorgbe',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => 'makedoniagbe',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'malayagbe',
    'mn'    => 'mongoliagbe',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'Moldavian',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'marathiagbe',
    'ms'    => 'malaygbe',
    'mt'    => 'maltagbe',
    'mua'   => 'mundangbe',
    'mul'   => "gbegbɔgblɔ\ sɔgbɔwo",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'burmagbe',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'Nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'naq'   => 'Nama',
    'nb'    => "nɔweigbe\ bokmål",
    'nd'    => "dziehe\ ndebelegbe",
    'nds'   => "Low\ German",
    'ne'    => 'nepalgbe',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'hɔlandgbe',
    'nl_be' => 'flemiagbe',
    'nmg'   => 'kwasiogbe',
    'nn'    => "nɔweigbe\ ninɔsk",
    'no'    => 'nɔweigbe',
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "dziehe\ sothogbe",
    'nub'   => "Nubian\ Language",
    'nus'   => 'nuergbe',
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'nyanjagbe',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'Occitan',
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'oriyagbe',
    'os'    => 'ossetiagbe',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'pundzabgbe',
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => 'polandgbe',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'pashtogbe',
    'pt'    => 'pɔtugalgbe',
    'pt_br' => "braziltɔwo\ ƒe\ portugalgbe",
    'pt_pt' => "iberiatɔwo\ ƒe\ portugalgbe",
    'qu'    => 'kwetsuagbe',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => 'romanshgbe',
    'rn'    => 'rundigbe',
    'ro'    => 'romaniagbe',
    'roa'   => "Romance\ Language",
    'rof'   => 'rombogbe',
    'rom'   => 'Romany',
    'ru'    => 'rɔtsiagbe',
    'rup'   => 'Aromanian',
    'rw'    => 'ruwandagbe',
    'rwk'   => 'rwagbe',
    'sa'    => 'sanskrigbe',
    'sad'   => 'Sandawe',
    'sah'   => 'sakagbe',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'saq'   => 'Samburu',
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sbp'   => 'sangugbe',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => 'sindhgbe',
    'se'    => "dziehe\ samigbe",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'sangogbe',
    'sga'   => "Old\ Irish",
    'sgn'   => "Sign\ Language",
    'sh'    => "serbo\-croatiagbe",
    'shi'   => 'Tachelhit',
    'shn'   => 'Shan',
    'si'    => 'sinhalgbe',
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => 'slovakiagbe',
    'sl'    => 'sloveniagbe',
    'sla'   => "Slavic\ Language",
    'sm'    => 'samoagbe',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'shonagbe',
    'snk'   => 'Soninke',
    'so'    => 'somaliagbe',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'albaniagbe',
    'sr'    => 'serbiagbe',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'swatgbe',
    'ssa'   => "Nilo\-Saharan\ Language",
    'ssy'   => 'Saho',
    'st'    => "anyiehe\ sothogbe",
    'su'    => 'sudangbe',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => 'swedengbe',
    'sw'    => 'swahili',
    'swb'   => 'komorogbe',
    'swc'   => "Congo\ Swahili",
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'tamilgbe',
    'tai'   => "Tai\ Language",
    'te'    => 'telegugbe',
    'tem'   => 'Timne',
    'teo'   => 'Teso',
    'ter'   => 'Tereno',
    'tet'   => 'tetumgbe',
    'tg'    => 'tadzikistangbe',
    'th'    => 'tailandgbe',
    'ti'    => 'tigrinyagbe',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'tɛkmengbe',
    'tkl'   => 'Tokelau',
    'tl'    => 'tagalogbe',
    'tlh'   => 'Klingon',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'tswanagbe',
    'to'    => 'tongagbe',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "tok\ pisigbe",
    'tr'    => 'tɛkigbe',
    'trv'   => 'Taroko',
    'ts'    => 'tsongagbe',
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tatar',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'Twi',
    'twq'   => 'tasawakgbe',
    'ty'    => 'tahitigbe',
    'tyv'   => 'Tuvinian',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'Udmurt',
    'ug'    => 'uighurgbe',
    'uga'   => 'Ugaritic',
    'uk'    => 'ukraingbe',
    'umb'   => 'Umbundu',
    'und'   => "gbegbɔgblɔ\ manya",
    'ur'    => 'urdugbe',
    'uz'    => 'uzbekistangbe',
    'vai'   => 'Vai',
    've'    => 'vendagbe',
    'vi'    => 'vietnamgbe',
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'vun'   => 'Vunjo',
    'wa'    => 'Walloon',
    'wae'   => 'walsegbe',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'wolofgbe',
    'xal'   => 'Kalmyk',
    'xh'    => 'xhosagbe',
    'xog'   => 'Soga',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yav'   => 'yangbengbe',
    'yi'    => 'Yiddish',
    'yo'    => 'yorubagbe',
    'ypk'   => "Yupik\ Language",
    'yue'   => 'cantongbe',
    'za'    => 'Zhuang',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'kinagbe',
    'znd'   => 'Zande',
    'zu'    => 'zulugbe',
    'zun'   => 'Zuni',
    'zxx'   => "gbegbɔgblɔ\ manɔmee",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::ee::name_to_code = (
    'abkhaziagbe'                     => 'ab',
    'achinese'                        => 'ace',
    'acoli'                           => 'ach',
    'adangme'                         => 'ada',
    'adyghe'                          => 'ady',
    'afar'                            => 'aa',
    'afrihili'                        => 'afh',
    'afrikaangbe'                     => 'af',
    'afroasiaticlanguage'             => 'afa',
    'aghemgbe'                        => 'agq',
    'ainu'                            => 'ain',
    'akkadian'                        => 'akk',
    'albaniagbe'                      => 'sq',
    'aleut'                           => 'ale',
    'algonquianlanguage'              => 'alg',
    'altaiclanguage'                  => 'tut',
    'amhariagbe'                      => 'am',
    'ancientegyptian'                 => 'egy',
    'ancientgreek'                    => 'grc',
    'angika'                          => 'anp',
    'anyiehesothogbe'                 => 'st',
    'apachelanguage'                  => 'apa',
    'arabiagbe'                       => 'ar',
    'aragonese'                       => 'an',
    'aramaic'                         => 'arc',
    'arapaho'                         => 'arp',
    'araucanian'                      => 'arn',
    'arawak'                          => 'arw',
    'armeniagbe'                      => 'hy',
    'aromanian'                       => 'rup',
    'artificiallanguage'              => 'art',
    'asagbe'                          => 'asa',
    'assamegbe'                       => 'as',
    'asturian'                        => 'ast',
    'athapascanlanguage'              => 'ath',
    'atsam'                           => 'cch',
    'australianlanguage'              => 'aus',
    'australiatɔwoƒeyevugbe'        => 'en_au',
    'austriatɔwoƒegermaniagbe'      => 'de_at',
    'austronesianlanguage'            => 'map',
    'avaric'                          => 'av',
    'avestan'                         => 'ae',
    'awadhi'                          => 'awa',
    'aymargbe'                        => 'ay',
    'azerbaijangbe'                   => 'az',
    'bafiagbe'                        => 'ksf',
    'balinese'                        => 'ban',
    'balticlanguage'                  => 'bat',
    'baluchi'                         => 'bal',
    'bambaragbe'                      => 'bm',
    'bamilekelanguage'                => 'bai',
    'banda'                           => 'bad',
    'bantu'                           => 'bnt',
    'basaagbe'                        => 'bas',
    'bashkir'                         => 'ba',
    'basqugbe'                        => 'eu',
    'batak'                           => 'btk',
    'beja'                            => 'bej',
    'belarusiagbe'                    => 'be',
    'bembagbe'                        => 'bem',
    'benagbe'                         => 'bez',
    'bengalgbe'                       => 'bn',
    'berber'                          => 'ber',
    'bhojpuri'                        => 'bho',
    'bihari'                          => 'bh',
    'bikol'                           => 'bik',
    'bini'                            => 'bin',
    'bislama'                         => 'bi',
    'blin'                            => 'byn',
    'blissymbols'                     => 'zbl',
    'blugbe'                          => 'ak',
    'bodogbe'                         => 'brx',
    'bosniagbe'                       => 'bs',
    'braj'                            => 'bra',
    'braziltɔwoƒeportugalgbe'       => 'pt_br',
    'bretongbe'                       => 'br',
    'britaintɔwoƒeyevugbe'          => 'en_gb',
    'buginese'                        => 'bug',
    'bulgariagbe'                     => 'bg',
    'buriat'                          => 'bua',
    'burmagbe'                        => 'my',
    'caddo'                           => 'cad',
    'cantongbe'                       => 'yue',
    'capeverdegbe'                    => 'kea',
    'carib'                           => 'car',
    'caucasianlanguage'               => 'cau',
    'cayuga'                          => 'cay',
    'cebuano'                         => 'ceb',
    'celticlanguage'                  => 'cel',
    'centralamericanindianlanguage'   => 'cai',
    'centralmoroccotamazight'         => 'tzm',
    'chagatai'                        => 'chg',
    'chamiclanguage'                  => 'cmc',
    'chamorro'                        => 'ch',
    'chechen'                         => 'ce',
    'cherokee'                        => 'chr',
    'cheyenne'                        => 'chy',
    'chibcha'                         => 'chb',
    'chiga'                           => 'cgg',
    'chinookjargon'                   => 'chn',
    'chipewyan'                       => 'chp',
    'choctaw'                         => 'cho',
    'churchslavic'                    => 'cu',
    'chuukese'                        => 'chk',
    'chuvash'                         => 'cv',
    'classicalnewari'                 => 'nwc',
    'classicalsyriac'                 => 'syc',
    'colognian'                       => 'ksh',
    'congoswahili'                    => 'swc',
    'coptic'                          => 'cop',
    'cornish'                         => 'kw',
    'corsican'                        => 'co',
    'cree'                            => 'cr',
    'creek'                           => 'mus',
    'creoleorpidgin'                  => 'crp',
    'crimeanturkish'                  => 'crh',
    'cushiticlanguage'                => 'cus',
    'dakota'                          => 'dak',
    'dargwa'                          => 'dar',
    'dayak'                           => 'day',
    'delaware'                        => 'del',
    'denmarkgbe'                      => 'da',
    'dinka'                           => 'din',
    'divehgbe'                        => 'dv',
    'dogri'                           => 'doi',
    'dogrib'                          => 'dgr',
    'dravidianlanguage'               => 'dra',
    'dualagbe'                        => 'dua',
    'dyula'                           => 'dyu',
    'dzapangbe'                       => 'ja',
    'dzavangbe'                       => 'jv',
    'dziehendebelegbe'                => 'nd',
    'dziehesamigbe'                   => 'se',
    'dziehesothogbe'                  => 'nso',
    'dzolafonyigbe'                   => 'dyo',
    'dzongkhagbe'                     => 'dz',
    'easternfrisian'                  => 'frs',
    'efigbe'                          => 'efi',
    'ekajuk'                          => 'eka',
    'elamite'                         => 'elx',
    'embugbe'                         => 'ebu',
    'englishbasedcreoleorpidgin'      => 'cpe',
    'erzya'                           => 'myv',
    'esperantogbe'                    => 'eo',
    'estoniagbe'                      => 'et',
    'ewondogbe'                       => 'ewo',
    'eʋegbe'                         => 'ee',
    'fang'                            => 'fan',
    'fanti'                           => 'fat',
    'faroese'                         => 'fo',
    'fidzigbe'                        => 'fj',
    'filipingbe'                      => 'fil',
    'finlanɖgbe'                     => 'fi',
    'finnougrianlanguage'             => 'fiu',
    'flemiagbe'                       => 'nl_be',
    'fon'                             => 'fon',
    'fransegbe'                       => 'fr',
    'frenchbasedcreoleorpidgin'       => 'cpf',
    'friulian'                        => 'fur',
    'fulagbe'                         => 'ff',
    'ga'                              => 'gaa',
    'galatagbe'                       => 'gl',
    'ganda'                           => 'lg',
    'gayo'                            => 'gay',
    'gbaya'                           => 'gba',
    'gbegbɔgblɔmanya'               => 'und',
    'gbegbɔgblɔmanɔmee'            => 'zxx',
    'gbegbɔgblɔsɔgbɔwo'           => 'mul',
    'geez'                            => 'gez',
    'germaniagbe'                     => 'de',
    'germaniclanguage'                => 'gem',
    'gilbertese'                      => 'gil',
    'gondi'                           => 'gon',
    'gorontalo'                       => 'gor',
    'gothic'                          => 'got',
    'grebo'                           => 'grb',
    'grisigbe'                        => 'el',
    'guarangbe'                       => 'gn',
    'gujarati'                        => 'gu',
    'gusii'                           => 'guz',
    "gwich\Ê\¼in"                   => 'gwi',
    'gɔgiagbe'                       => 'ka',
    'haida'                           => 'hai',
    'haitigbe'                        => 'ht',
    'hausagbe'                        => 'ha',
    'hawaigbe'                        => 'haw',
    'hebrigbe'                        => 'he',
    'herero'                          => 'hz',
    'hiligaynon'                      => 'hil',
    'himachali'                       => 'him',
    'hindigbe'                        => 'hi',
    'hirimotu'                        => 'ho',
    'hittite'                         => 'hit',
    'hmong'                           => 'hmn',
    'hungarigbe'                      => 'hu',
    'hupa'                            => 'hup',
    'hɔlandgbe'                      => 'nl',
    'iban'                            => 'iba',
    'iberiatɔwoƒeportugalgbe'       => 'pt_pt',
    'iberiatɔwoƒespaniagbe'         => 'es_es',
    'icelanɖgbe'                     => 'is',
    'ido'                             => 'io',
    'igbogbe'                         => 'ig',
    'ijo'                             => 'ijo',
    'iloko'                           => 'ilo',
    'inarisami'                       => 'smn',
    'indiclanguage'                   => 'inc',
    'indoeuropeanlanguage'            => 'ine',
    'indonesiagbe'                    => 'id',
    'ingush'                          => 'inh',
    'interlingua'                     => 'ia',
    'interlingue'                     => 'ie',
    'inuktitut'                       => 'iu',
    'inupiaq'                         => 'ik',
    'iranianlanguage'                 => 'ira',
    'irelanɖgbe'                     => 'ga',
    'iroquoianlanguage'               => 'iro',
    'italiagbe'                       => 'it',
    'jju'                             => 'kaj',
    'judeoarabic'                     => 'jrb',
    'judeopersian'                    => 'jpr',
    'kabardian'                       => 'kbd',
    'kabyle'                          => 'kab',
    'kachin'                          => 'kac',
    'kalaallisut'                     => 'kl',
    'kalenjin'                        => 'kln',
    'kalmyk'                          => 'xal',
    'kamba'                           => 'kam',
    'kanadatɔwoƒefransegbe'         => 'fr_ca',
    'kanadatɔwoƒeyevugbe'           => 'en_ca',
    'kannadagbe'                      => 'kn',
    'kanuri'                          => 'kr',
    'karachaybalkar'                  => 'krc',
    'karakalpak'                      => 'kaa',
    'karelian'                        => 'krl',
    'karen'                           => 'kar',
    'kashmirgbe'                      => 'ks',
    'kashubian'                       => 'csb',
    'katalagbe'                       => 'ca',
    'kawi'                            => 'kaw',
    'kazakhstangbe'                   => 'kk',
    'khasi'                           => 'kha',
    'khmergbe'                        => 'km',
    'khoisanlanguage'                 => 'khi',
    'khotanese'                       => 'kho',
    'kikuyu'                          => 'ki',
    'kimbundu'                        => 'kmb',
    'kinagbe'                         => 'zh',
    'kirghistangbe'                   => 'ky',
    'klingon'                         => 'tlh',
    'komi'                            => 'kv',
    'komorogbe'                       => 'swb',
    'kongo'                           => 'kg',
    'konkani'                         => 'kok',
    'koreagbe'                        => 'ko',
    'koro'                            => 'kfo',
    'kosraean'                        => 'kos',
    'koyraborosenni'                  => 'ses',
    'koyrachiini'                     => 'khq',
    'kpelle'                          => 'kpe',
    'kroatiagbe'                      => 'hr',
    'kru'                             => 'kro',
    'kuanyama'                        => 'kj',
    'kumyk'                           => 'kum',
    'kurdiagbe'                       => 'ku',
    'kurukh'                          => 'kru',
    'kutenai'                         => 'kut',
    'kwasiogbe'                       => 'nmg',
    'kwetsuagbe'                      => 'qu',
    'ladino'                          => 'lad',
    'lahndagbe'                       => 'lah',
    'laksembɔggbe'                   => 'lb',
    'lamba'                           => 'lam',
    'langi'                           => 'lag',
    'laogbe'                          => 'lo',
    'latin'                           => 'la',
    'latviagbe'                       => 'lv',
    'lezghian'                        => 'lez',
    'limburgish'                      => 'li',
    'lingala'                         => 'ln',
    'lithuaniagbe'                    => 'lt',
    'lojban'                          => 'jbo',
    'lowersorbian'                    => 'dsb',
    'lowgerman'                       => 'nds',
    'lozi'                            => 'loz',
    'lubakatangagbe'                  => 'lu',
    'lubalulua'                       => 'lua',
    'luiseno'                         => 'lui',
    'lulesami'                        => 'smj',
    'lunda'                           => 'lun',
    'luo'                             => 'luo',
    'lushai'                          => 'lus',
    'luyiagbe'                        => 'luy',
    'machame'                         => 'jmc',
    'madurese'                        => 'mad',
    'magahi'                          => 'mag',
    'maithili'                        => 'mai',
    'makasar'                         => 'mak',
    'makedoniagbe'                    => 'mk',
    'makonde'                         => 'kde',
    'makuwamitogbe'                   => 'mgh',
    'malagasegbe'                     => 'mg',
    'malayagbe'                       => 'ml',
    'malaygbe'                        => 'ms',
    'maltagbe'                        => 'mt',
    'manchu'                          => 'mnc',
    'mandar'                          => 'mdr',
    'mandingo'                        => 'man',
    'manipuri'                        => 'mni',
    'manobolanguage'                  => 'mno',
    'manx'                            => 'gv',
    'maorgbe'                         => 'mi',
    'marathiagbe'                     => 'mr',
    'mari'                            => 'chm',
    'marshallese'                     => 'mh',
    'marwari'                         => 'mwr',
    'masai'                           => 'mas',
    'mayanlanguage'                   => 'myn',
    'mende'                           => 'men',
    'meru'                            => 'mer',
    'micmac'                          => 'mic',
    'middledutch'                     => 'dum',
    'middleenglish'                   => 'enm',
    'middlefrench'                    => 'frm',
    'middlehighgerman'                => 'gmh',
    'middleirish'                     => 'mga',
    'minangkabau'                     => 'min',
    'mirandese'                       => 'mwl',
    'miscellaneouslanguage'           => 'mis',
    'mohawk'                          => 'moh',
    'moksha'                          => 'mdf',
    'moldavian'                       => 'mo',
    'mongo'                           => 'lol',
    'mongoliagbe'                     => 'mn',
    'monkhmerlanguage'                => 'mkh',
    'morisyen'                        => 'mfe',
    'mossi'                           => 'mos',
    'mundalanguage'                   => 'mun',
    'mundangbe'                       => 'mua',
    'nahuatl'                         => 'nah',
    'nama'                            => 'naq',
    'nauru'                           => 'na',
    'navajo'                          => 'nv',
    'ndonga'                          => 'ng',
    'neapolitan'                      => 'nap',
    'nepalgbe'                        => 'ne',
    'newari'                          => 'new',
    'nias'                            => 'nia',
    'nigerkordofanianlanguage'        => 'nic',
    'nilosaharanlanguage'             => 'ssa',
    'niuean'                          => 'niu',
    'nogai'                           => 'nog',
    'northamericanindianlanguage'     => 'nai',
    'northernfrisian'                 => 'frr',
    'nubianlanguage'                  => 'nub',
    'nuergbe'                         => 'nus',
    'nyamwezi'                        => 'nym',
    'nyanjagbe'                       => 'ny',
    'nyankole'                        => 'nyn',
    'nyasatonga'                      => 'tog',
    'nyoro'                           => 'nyo',
    'nzima'                           => 'nzi',
    "n\â\\ko"                    => 'nqo',
    'nɔweigbe'                       => 'no',
    'nɔweigbebokmål'                => 'nb',
    'nɔweigbeninɔsk'                => 'nn',
    'occitan'                         => 'oc',
    'ojibwa'                          => 'oj',
    'oldenglish'                      => 'ang',
    'oldfrench'                       => 'fro',
    'oldhighgerman'                   => 'goh',
    'oldirish'                        => 'sga',
    'oldnorse'                        => 'non',
    'oldpersian'                      => 'peo',
    "oldproven\Ã\§al"               => 'pro',
    'oriyagbe'                        => 'or',
    'oromo'                           => 'om',
    'osage'                           => 'osa',
    'ossetiagbe'                      => 'os',
    'otomianlanguage'                 => 'oto',
    'ottomanturkish'                  => 'ota',
    'pahlavi'                         => 'pal',
    'palauan'                         => 'pau',
    'pali'                            => 'pi',
    'pampanga'                        => 'pam',
    'pangasinan'                      => 'pag',
    'papiamento'                      => 'pap',
    'papuanlanguage'                  => 'paa',
    'pashtogbe'                       => 'ps',
    'persiagbe'                       => 'fa',
    'philippinelanguage'              => 'phi',
    'phoenician'                      => 'phn',
    'pohnpeian'                       => 'pon',
    'polandgbe'                       => 'pl',
    'portuguesebasedcreoleorpidgin'   => 'cpp',
    'prakritlanguage'                 => 'pra',
    'pundzabgbe'                      => 'pa',
    'pɔtugalgbe'                     => 'pt',
    'rajasthani'                      => 'raj',
    'rapanui'                         => 'rap',
    'rarotongan'                      => 'rar',
    'romancelanguage'                 => 'roa',
    'romaniagbe'                      => 'ro',
    'romanshgbe'                      => 'rm',
    'romany'                          => 'rom',
    'rombogbe'                        => 'rof',
    'rundigbe'                        => 'rn',
    'ruwandagbe'                      => 'rw',
    'rwagbe'                          => 'rwk',
    'rɔtsiagbe'                      => 'ru',
    'saho'                            => 'ssy',
    'sakagbe'                         => 'sah',
    'salishanlanguage'                => 'sal',
    'samaritanaramaic'                => 'sam',
    'samburu'                         => 'saq',
    'samilanguage'                    => 'smi',
    'samoagbe'                        => 'sm',
    'sandawe'                         => 'sad',
    'sangogbe'                        => 'sg',
    'sangugbe'                        => 'sbp',
    'sanskrigbe'                      => 'sa',
    'santali'                         => 'sat',
    'sardinian'                       => 'sc',
    'sasak'                           => 'sas',
    'scots'                           => 'sco',
    'scottishgaelic'                  => 'gd',
    'selkup'                          => 'sel',
    'semiticlanguage'                 => 'sem',
    'sena'                            => 'seh',
    'seneca'                          => 'see',
    'serbiagbe'                       => 'sr',
    'serbocroatiagbe'                 => 'sh',
    'serer'                           => 'srr',
    'shambala'                        => 'ksb',
    'shan'                            => 'shn',
    'shonagbe'                        => 'sn',
    'sichuanyi'                       => 'ii',
    'sicilian'                        => 'scn',
    'sidamo'                          => 'sid',
    'signlanguage'                    => 'sgn',
    'siksika'                         => 'bla',
    'sindhgbe'                        => 'sd',
    'sinhalgbe'                       => 'si',
    'sinotibetanlanguage'             => 'sit',
    'siouanlanguage'                  => 'sio',
    'skoltsami'                       => 'sms',
    'slave'                           => 'den',
    'slaviclanguage'                  => 'sla',
    'slovakiagbe'                     => 'sk',
    'sloveniagbe'                     => 'sl',
    'soga'                            => 'xog',
    'sogdien'                         => 'sog',
    'somaliagbe'                      => 'so',
    'songhai'                         => 'son',
    'soninke'                         => 'snk',
    'sorbianlanguage'                 => 'wen',
    'southamericanindianlanguage'     => 'sai',
    'southernaltai'                   => 'alt',
    'southernsami'                    => 'sma',
    'southndebele'                    => 'nr',
    'spaniagbe'                       => 'es',
    'sranantongo'                     => 'srn',
    'sudangbe'                        => 'su',
    'sukuma'                          => 'suk',
    'sumerian'                        => 'sux',
    'susu'                            => 'sus',
    'swahili'                         => 'sw',
    'swatgbe'                         => 'ss',
    'swedengbe'                       => 'sv',
    'swizerlanɖgermaniagbekɔkɔtɔ' => 'de_ch',
    'swizerlanɖtɔwoƒefransegbe'    => 'fr_ch',
    'swizerlanɖtɔwoƒegermaniagbe'  => 'gsw',
    'syriac'                          => 'syr',
    'tachelhit'                       => 'shi',
    'tadzikistangbe'                  => 'tg',
    'tagalogbe'                       => 'tl',
    'tahitigbe'                       => 'ty',
    'tailandgbe'                      => 'th',
    'tailanguage'                     => 'tai',
    'taita'                           => 'dav',
    'tamashek'                        => 'tmh',
    'tamilgbe'                        => 'ta',
    'taroko'                          => 'trv',
    'tasawakgbe'                      => 'twq',
    'tatar'                           => 'tt',
    'telegugbe'                       => 'te',
    'tereno'                          => 'ter',
    'teso'                            => 'teo',
    'tetumgbe'                        => 'tet',
    'tibetagbe'                       => 'bo',
    'tigre'                           => 'tig',
    'tigrinyagbe'                     => 'ti',
    'timne'                           => 'tem',
    'tiv'                             => 'tiv',
    'tlingit'                         => 'tli',
    'tokelau'                         => 'tkl',
    'tokpisigbe'                      => 'tpi',
    'tongagbe'                        => 'to',
    'tsimshian'                       => 'tsi',
    'tsongagbe'                       => 'ts',
    'tswanagbe'                       => 'tn',
    'tsɛkgbe'                        => 'cs',
    'tumbuka'                         => 'tum',
    'tupilanguage'                    => 'tup',
    'tuvalu'                          => 'tvl',
    'tuvinian'                        => 'tyv',
    'twi'                             => 'tw',
    'tyap'                            => 'kcg',
    'tɛkigbe'                        => 'tr',
    'tɛkmengbe'                      => 'tk',
    "u\.s\.dukɔmetɔwoƒeyevugbe"    => 'en_us',
    'udmurt'                          => 'udm',
    'ugaritic'                        => 'uga',
    'uighurgbe'                       => 'ug',
    'ukraingbe'                       => 'uk',
    'umbundu'                         => 'umb',
    'uppersorbian'                    => 'hsb',
    'urdugbe'                         => 'ur',
    'uzbekistangbe'                   => 'uz',
    'vai'                             => 'vai',
    'vendagbe'                        => 've',
    'vietnamgbe'                      => 'vi',
    "volap\Ã\¼k"                    => 'vo',
    'votic'                           => 'vot',
    'vunjo'                           => 'vun',
    'wakashanlanguage'                => 'wak',
    'walamo'                          => 'wal',
    'walesgbe'                        => 'cy',
    'walloon'                         => 'wa',
    'walsegbe'                        => 'wae',
    'waray'                           => 'war',
    'washo'                           => 'was',
    'westernfrisian'                  => 'fy',
    'wolofgbe'                        => 'wo',
    'xhosagbe'                        => 'xh',
    'yangbengbe'                      => 'yav',
    'yao'                             => 'yao',
    'yapese'                          => 'yap',
    'yevugbe'                         => 'en',
    'yiddish'                         => 'yi',
    'yorubagbe'                       => 'yo',
    'yupiklanguage'                   => 'ypk',
    'zamagbe'                         => 'dje',
    'zande'                           => 'znd',
    'zapotec'                         => 'zap',
    'zaza'                            => 'zza',
    'zenaga'                          => 'zen',
    'zhuang'                          => 'za',
    'zulugbe'                         => 'zu',
    'zuni'                            => 'zun',
);

1;
