package Locales::DB::Language::sr;

# Auto generated from CLDR

$Locales::DB::Language::sr::VERSION = '0.09';

$Locales::DB::Language::sr::cldr_version = '2.0';

%Locales::DB::Language::sr::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}\.\.\.",
            'initial' => "\.\.\.\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "\{0\}",
        'list'     => {
            2        => "\{0\}\ и\ \{1\}",
            'end'    => "\{0\}\ и\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "\{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '’',
        'alternate_quotation_start' => '‘',
        'quotation_end'             => '”',
        'quotation_start'           => '“'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'few',
            'many',
            'other'
        ],
        'category_rules' => {
            'few'  => "n\ mod\ 10\ in\ 2\.\.4\ and\ n\ mod\ 100\ not\ in\ 12\.\.14",
            'many' => "n\ mod\ 10\ is\ 0\ or\ n\ mod\ 10\ in\ 5\.\.9\ or\ n\ mod\ 100\ in\ 11\.\.14",
            'one'  => "n\ mod\ 10\ is\ 1\ and\ n\ mod\ 100\ is\ not\ 11"
        },
        'category_rules_compiled' => {
            'few' => sub {
                if ( ( ( int( $_[0] ) == $_[0] && ( $_[0] % 10 ) >= 2 && ( $_[0] % 10 ) <= 4 ) && ( int( $_[0] ) != $_[0] || ( $_[0] % 100 ) < 12 || ( $_[0] % 100 ) > 14 ) ) ) { return 'few'; }
                return;
            },
            'many' => sub {
                if ( ( ( ( $_[0] % 10 ) == 0 ) ) || ( ( int( $_[0] ) == $_[0] && ( $_[0] % 10 ) >= 5 && ( $_[0] % 10 ) <= 9 ) ) || ( ( int( $_[0] ) == $_[0] && ( $_[0] % 100 ) >= 11 && ( $_[0] % 100 ) <= 14 ) ) ) { return 'many'; }
                return;
            },
            'one' => sub {
                if ( ( ( ( $_[0] % 10 ) == 1 ) && ( ( $_[0] % 100 ) != 11 ) ) ) { return 'one'; }
                return;
              }
        }
    },
    'posix' => {
        'nostr'  => "не\:н",
        'yesstr' => "да\:д"
    },
);

%Locales::DB::Language::sr::code_to_name = (
    'aa'    => 'Афарски',
    'ab'    => 'Абказијски',
    'ace'   => 'Ачинески',
    'ach'   => 'Аколи',
    'ada'   => 'Адангмејски',
    'ady'   => 'Адигејски',
    'ae'    => 'Авестански',
    'af'    => 'Африканерски',
    'afa'   => "Афро\-азијатски",
    'afh'   => 'Африхили',
    'agq'   => 'Aghem',
    'ain'   => 'Аину',
    'ak'    => 'Акан',
    'akk'   => 'Акадијски',
    'ale'   => 'Аљут',
    'alg'   => "Алгонквијански\ језик",
    'alt'   => "Јужни\ алтаи",
    'am'    => 'Амхарски',
    'an'    => 'Арагонежански',
    'ang'   => 'Староенглески',
    'anp'   => 'Ангика',
    'apa'   => "Апачки\ језик",
    'ar'    => 'Арапски',
    'arc'   => 'Армајски',
    'arn'   => 'Ароканијски',
    'arp'   => 'Арапахо',
    'art'   => 'Вештачки',
    'arw'   => 'Аравак',
    'as'    => 'Асемијски',
    'asa'   => 'Asu',
    'ast'   => 'Астуријски',
    'ath'   => 'Атапаскан',
    'aus'   => "Аустралијски\ језик",
    'av'    => 'Аварски',
    'awa'   => 'Авадхи',
    'ay'    => 'ајмара',
    'az'    => 'азерски',
    'ba'    => 'Башкир',
    'bad'   => 'Банда',
    'bai'   => 'Бамилеке',
    'bal'   => 'Балучи',
    'ban'   => 'Балинезијски',
    'bas'   => 'Баса',
    'bat'   => "Балтички\ језик",
    'be'    => 'Белоруски',
    'bej'   => 'Беја',
    'bem'   => 'Бемба',
    'ber'   => 'Бербер',
    'bez'   => 'Bena',
    'bg'    => 'Бугарски',
    'bh'    => 'Бихарски',
    'bho'   => 'Бојпури',
    'bi'    => 'Бислама',
    'bik'   => 'Бикол',
    'bin'   => 'Бини',
    'bla'   => 'Сисика',
    'bm'    => 'Бамбара',
    'bn'    => 'Бенгласки',
    'bnt'   => 'Банту',
    'bo'    => 'Тибетански',
    'br'    => 'Бретонски',
    'bra'   => 'Брај',
    'brx'   => 'Bodo',
    'bs'    => 'Босански',
    'btk'   => 'Батак',
    'bua'   => 'Буриат',
    'bug'   => 'Бугинежански',
    'byn'   => 'Блин',
    'ca'    => 'Каталонски',
    'cad'   => 'Кадо',
    'cai'   => "Централно\ амерички\ Индијански\ језик",
    'car'   => 'Карипски',
    'cau'   => 'Кавкаски',
    'cay'   => 'Cayuga',
    'cch'   => 'Атсамски',
    'ce'    => 'Чеченски',
    'ceb'   => 'Цебуано',
    'cel'   => 'Келтски',
    'cgg'   => 'Chiga',
    'ch'    => 'Чаморо',
    'chb'   => 'Чибча',
    'chg'   => 'Чагатаи',
    'chk'   => 'Чукески',
    'chm'   => 'Мари',
    'chn'   => 'Чинукски',
    'cho'   => 'Чоктавски',
    'chp'   => 'Чипвијански',
    'chr'   => 'Чероки',
    'chy'   => 'Чејенски',
    'cmc'   => "Чамски\ језик",
    'co'    => 'Корзикански',
    'cop'   => 'Коптски',
    'cpe'   => "Креолски\ или\ пиџин\ заснован\ на\ енглеском",
    'cpf'   => "Креолски\ или\ пиџин\ заснован\ на\ француском",
    'cpp'   => "Креолски\ или\ пиџин\ базиран\ на\ португалском",
    'cr'    => 'Кри',
    'crh'   => "Кримеански\ турски",
    'crp'   => "креолски\ или\ пиџин",
    'cs'    => 'Чешки',
    'csb'   => 'Кашубијански',
    'cu'    => 'Старословенски',
    'cus'   => "Кушитички\ језик",
    'cv'    => 'Чувашки',
    'cy'    => 'Велшки',
    'da'    => 'Дански',
    'dak'   => 'Дакота',
    'dar'   => 'Даргва',
    'dav'   => 'Taita',
    'day'   => 'Дајашки',
    'de'    => 'Немачки',
    'de_at' => "Аустријски\ немачки",
    'de_ch' => "Швајцарски\ високи\ немачки",
    'del'   => 'Делавер',
    'den'   => 'Славски',
    'dgr'   => 'Догриб',
    'din'   => 'Динка',
    'dje'   => 'Zarma',
    'doi'   => 'Догри',
    'dra'   => "Дарвидијски\ језик",
    'dsb'   => "Ниски\ сорбијански",
    'dua'   => 'Дуала',
    'dum'   => "Средњи\ холандски",
    'dv'    => 'Дивехијски',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'Ђула',
    'dz'    => 'Џонга',
    'ebu'   => 'Embu',
    'ee'    => 'Еве',
    'efi'   => 'Ефикски',
    'egy'   => 'Староегипатски',
    'eka'   => 'Екајук',
    'el'    => 'Грчки',
    'elx'   => 'Еламитски',
    'en'    => 'Енглески',
    'en_au' => "Аустралијски\ енглески",
    'en_ca' => "Канадски\ енглески",
    'en_gb' => "Британски\ енглески",
    'en_us' => "САД\ енглески",
    'enm'   => "Средњи\ енглески",
    'eo'    => 'Есперанто',
    'es'    => 'Шпански',
    'es_es' => "Иберијски\ шпански",
    'et'    => 'Естонски',
    'eu'    => 'Баскијски',
    'ewo'   => 'Евондо',
    'fa'    => 'Персијски',
    'fan'   => 'Фанг',
    'fat'   => 'Фанти',
    'ff'    => 'Фулах',
    'fi'    => 'Фински',
    'fil'   => 'Тагалог',
    'fiu'   => "Угро\-фински",
    'fj'    => 'Фиджијски',
    'fo'    => 'Фарски',
    'fon'   => 'Фон',
    'fr'    => 'Француски',
    'fr_ca' => "Канадски\ француски",
    'fr_ch' => "Швајцарски\ француски",
    'frm'   => "Средњи\ француски",
    'fro'   => 'Старофранцуски',
    'frr'   => "Северно\-фризијски",
    'frs'   => "Источни\ фризијски",
    'fur'   => 'Фриулијски',
    'fy'    => 'Фризијски',
    'ga'    => 'Ирски',
    'gaa'   => 'Га',
    'gay'   => 'Гајо',
    'gba'   => 'Гбаја',
    'gd'    => "Шкотски\ Галски",
    'gem'   => "Германски\ језик",
    'gez'   => 'Џиз',
    'gil'   => 'Гилбертшки',
    'gl'    => 'Галски',
    'gmh'   => "Средњи\ високи\ немачки",
    'gn'    => 'Гварани',
    'goh'   => 'Старонемачки',
    'gon'   => 'Гонди',
    'gor'   => 'Горонтало',
    'got'   => 'Готски',
    'grb'   => 'Гребо',
    'grc'   => 'Старогрчки',
    'gsw'   => "Швајцарски\ немачки",
    'gu'    => 'Гуџарати',
    'guz'   => 'Gusii',
    'gv'    => 'Манкс',
    'gwi'   => "Гвич\'ин",
    'ha'    => 'Хауса',
    'hai'   => 'Хаида',
    'haw'   => 'Хавајски',
    'he'    => 'Хебрејски',
    'hi'    => 'Хинди',
    'hil'   => 'Хилигајнон',
    'him'   => 'Химачали',
    'hit'   => 'Хитите',
    'hmn'   => 'Хмонг',
    'ho'    => "Хири\ Моту",
    'hr'    => 'Хрватски',
    'hsb'   => "Горњи\ сорбијски",
    'ht'    => 'Хаитски',
    'hu'    => 'Мађарски',
    'hup'   => 'Хупа',
    'hy'    => 'Јерменски',
    'hz'    => 'Хереро',
    'ia'    => 'Интерлингва',
    'iba'   => 'Ибан',
    'id'    => 'Индонежански',
    'ie'    => 'Међујезички',
    'ig'    => 'Игбо',
    'ii'    => "Сичуан\ ји",
    'ijo'   => 'Ијо',
    'ik'    => 'Унупиак',
    'ilo'   => 'Илоко',
    'inc'   => 'Индик',
    'ine'   => "Индо\-европски\ језик",
    'inh'   => 'Ингвишки',
    'io'    => 'Идо',
    'ira'   => "Ирански\ језик",
    'iro'   => 'Ироквојански',
    'is'    => 'Исландски',
    'it'    => 'Италијански',
    'iu'    => 'Инуктитут',
    'ja'    => 'Јапански',
    'jbo'   => 'Лојбан',
    'jmc'   => 'Machame',
    'jpr'   => "Јудео\-персијски",
    'jrb'   => "Јудео\-арапски",
    'jv'    => 'Јавански',
    'ka'    => 'Грузијски',
    'kaa'   => "Кара\-калпашки",
    'kab'   => 'Кабиле',
    'kac'   => 'Качин',
    'kaj'   => 'Ђу',
    'kam'   => 'Камба',
    'kar'   => 'Каренски',
    'kaw'   => 'Кави',
    'kbd'   => 'Кабардијски',
    'kcg'   => 'Тјап',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'Коро',
    'kg'    => 'Конго',
    'kha'   => 'Каси',
    'khi'   => "Коисански\ језик",
    'kho'   => 'Котанешки',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'Кикују',
    'kj'    => 'Куањама',
    'kk'    => 'Козачки',
    'kl'    => 'Калалисут',
    'kln'   => 'Kalenjin',
    'km'    => 'Кмерски',
    'kmb'   => 'Кимбунду',
    'kn'    => 'Канада',
    'ko'    => 'Корејски',
    'kok'   => 'Конкани',
    'kos'   => 'Косреански',
    'kpe'   => 'Кпеле',
    'kr'    => 'Канури',
    'krc'   => "Карачај\-балкар",
    'krl'   => 'Карелијски',
    'kro'   => 'Кру',
    'kru'   => 'Курукх',
    'ks'    => 'Кашмирски',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'Курдски',
    'kum'   => 'Кумик',
    'kut'   => 'Кутенаи',
    'kv'    => 'Коми',
    'kw'    => 'Корнишки',
    'ky'    => 'Киргиски',
    'la'    => 'Латински',
    'lad'   => 'Ладино',
    'lag'   => 'Langi',
    'lah'   => 'Ланда',
    'lam'   => 'Ламба',
    'lb'    => 'Луксембуршки',
    'lez'   => 'Лезгиан',
    'lg'    => 'Ганда',
    'li'    => 'Лимбургиш',
    'ln'    => 'Лингала',
    'lo'    => 'Лаоски',
    'lol'   => 'Монго',
    'loz'   => 'Лози',
    'lt'    => 'Литвански',
    'lu'    => "Луба\-катанга",
    'lua'   => "Луба\-лулуа",
    'lui'   => 'Луисено',
    'lun'   => 'Лунда',
    'luo'   => 'Луо',
    'lus'   => 'Лушаи',
    'luy'   => 'Luyia',
    'lv'    => 'Летонски',
    'mad'   => 'Мадурешки',
    'mag'   => 'Магахи',
    'mai'   => 'Маитили',
    'mak'   => 'Макасар',
    'man'   => 'Мандинго',
    'map'   => 'Аустронежански',
    'mas'   => 'Масаи',
    'mdf'   => 'Мокша',
    'mdr'   => 'Мандар',
    'men'   => 'Менде',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'Малагасијски',
    'mga'   => "Средњи\ ирски",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'Маршалски',
    'mi'    => 'Маорски',
    'mic'   => 'Микмак',
    'min'   => 'Минангкабау',
    'mis'   => "Разни\ језици",
    'mk'    => 'Македонски',
    'mkh'   => "Мон\-кмерски\ језик",
    'ml'    => 'Малајалам',
    'mn'    => 'Монголски',
    'mnc'   => 'Манчу',
    'mni'   => 'Манипури',
    'mno'   => "Манобо\ језик",
    'mo'    => 'Молдавски',
    'moh'   => 'Махавски',
    'mos'   => 'Моси',
    'mr'    => 'Марати',
    'ms'    => 'Малајски',
    'mt'    => 'Мелтешки',
    'mua'   => 'Mundang',
    'mul'   => "Више\ језика",
    'mun'   => "Мунда\ језик",
    'mus'   => 'Кришки',
    'mwl'   => 'Мирандешки',
    'mwr'   => 'Марвари',
    'my'    => 'Бурмански',
    'myn'   => "Мајански\ језик",
    'myv'   => 'Ерзија',
    'na'    => 'Науру',
    'nah'   => 'Нахуатл',
    'nai'   => "Језик\ северноамеричких\ Индијанаца",
    'nap'   => 'Неаполитански',
    'naq'   => 'Nama',
    'nb'    => "Норвешки\ бокмал",
    'nd'    => "Северни\ ндебеле",
    'nds'   => "Ниски\ немачки",
    'ne'    => 'Непалски',
    'new'   => 'Невари',
    'ng'    => 'Ндонга',
    'nia'   => 'Ниас',
    'nic'   => "Нигер\-кордофанијски\ језик",
    'niu'   => 'Ниуеан',
    'nl'    => 'Холандски',
    'nl_be' => 'Фламански',
    'nmg'   => 'Kwasio',
    'nn'    => "Норвешки\ њорск",
    'no'    => 'Норвешки',
    'nog'   => 'Ногаи',
    'non'   => "Стари\ норски",
    'nqo'   => 'Н’ко',
    'nr'    => "Јужни\ ндебеле",
    'nso'   => "Северни\ сото",
    'nub'   => "Нубијски\ језик",
    'nus'   => 'Nuer',
    'nv'    => 'Навахо',
    'nwc'   => "Класични\ невари",
    'ny'    => 'Њања',
    'nym'   => 'Њамвези',
    'nyn'   => 'Њанколе',
    'nyo'   => 'Њоро',
    'nzi'   => 'Нзима',
    'oc'    => 'Провансалски',
    'oj'    => 'Ојибва',
    'om'    => 'Оромо',
    'or'    => 'Оријски',
    'os'    => 'Осетски',
    'osa'   => 'Осаге',
    'ota'   => "Отомански\ турски",
    'oto'   => "Отомански\ језик",
    'pa'    => 'Панџабски',
    'paa'   => "Папуански\ језик",
    'pag'   => 'Пангасински',
    'pal'   => 'Пахлави',
    'pam'   => 'Пампанга',
    'pap'   => 'Папиаменто',
    'pau'   => 'Палауански',
    'peo'   => 'Староперсијски',
    'phi'   => "Филипински\ језик",
    'phn'   => 'Феничански',
    'pi'    => 'Пали',
    'pl'    => 'Пољски',
    'pon'   => 'Понпејски',
    'pra'   => 'Пракритски',
    'pro'   => 'Старопровансалски',
    'ps'    => 'пашто',
    'pt'    => 'Португалски',
    'pt_br' => "Бразилски\ португалски",
    'pt_pt' => "Иберијски\ португалски",
    'qu'    => 'Квенча',
    'raj'   => 'Рађастани',
    'rap'   => 'Рапануи',
    'rar'   => 'Раротонган',
    'rm'    => "Рето\-Романски",
    'rn'    => 'Рунди',
    'ro'    => 'Румунски',
    'roa'   => "Романски\ језик",
    'rof'   => 'Rombo',
    'rom'   => 'Романи',
    'ru'    => 'Руски',
    'rup'   => 'Ароманијски',
    'rw'    => 'Кинјаруанда',
    'rwk'   => 'Rwa',
    'sa'    => 'Санскрит',
    'sad'   => 'Сандаве',
    'sah'   => 'Јакут',
    'sai'   => "Језик\ јужноамеричких\ Индијанаца",
    'sal'   => "Салишански\ језик",
    'sam'   => "Самаритански\ арамејски",
    'saq'   => 'Samburu',
    'sas'   => 'Сасак',
    'sat'   => 'Сантали',
    'sbp'   => 'Sangu',
    'sc'    => 'Сардињаски',
    'scn'   => 'Сицилијански',
    'sco'   => 'Шкотски',
    'sd'    => 'Синди',
    'se'    => "Северни\ сами",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'Селкап',
    'sem'   => "Семитски\ језик",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'Санго',
    'sga'   => 'Староирски',
    'sgn'   => "Знаковни\ језик",
    'sh'    => 'Српскохрватски',
    'shi'   => 'Tachelhit',
    'shn'   => 'Шан',
    'si'    => 'Сингалески',
    'sid'   => 'Сидамо',
    'sio'   => "Сиуански\ језик",
    'sit'   => "Сино\-тибетански\ језик",
    'sk'    => 'Словачки',
    'sl'    => 'Словеначки',
    'sla'   => "Словенски\ језик",
    'sm'    => 'Самоански',
    'sma'   => "Јужни\ сами",
    'smi'   => "Сами\ језик",
    'smj'   => "Луле\ сами",
    'smn'   => "Инари\ сами",
    'sms'   => "Сколтски\ језик",
    'sn'    => 'Шона',
    'snk'   => 'Сонинке',
    'so'    => 'Сомалски',
    'sog'   => 'Соџијенски',
    'son'   => 'Сонгаи',
    'sq'    => 'Албански',
    'sr'    => 'Српски',
    'srn'   => "Сранански\ тонго",
    'srr'   => 'Серер',
    'ss'    => 'Свати',
    'ssa'   => "Нило\-сахарски\ језик",
    'ssy'   => 'Saho',
    'st'    => 'Сесото',
    'su'    => 'Судански',
    'suk'   => 'Сукума',
    'sus'   => 'Сусу',
    'sux'   => 'Сумерски',
    'sv'    => 'Шведски',
    'sw'    => 'Свахили',
    'swb'   => 'Коморски',
    'swc'   => "Congo\ Swahili",
    'syc'   => "Класични\ сиријски",
    'syr'   => 'Сиријски',
    'ta'    => 'Тамилски',
    'tai'   => "Таи\ језик",
    'te'    => 'Телугу',
    'tem'   => 'Тимне',
    'teo'   => 'Teso',
    'ter'   => 'Терено',
    'tet'   => 'Тетум',
    'tg'    => 'Тађик',
    'th'    => 'Тајландски',
    'ti'    => 'Тигриња',
    'tig'   => 'Тигре',
    'tiv'   => 'Тив',
    'tk'    => 'Туркменски',
    'tkl'   => 'Токелау',
    'tl'    => 'Тагалски',
    'tlh'   => 'Клингонски',
    'tli'   => 'Тлингит',
    'tmh'   => 'Тамашек',
    'tn'    => 'Тсвана',
    'to'    => 'Тонга',
    'tog'   => "Њаса\ тонга",
    'tpi'   => "Ток\ Писин",
    'tr'    => 'Турски',
    'trv'   => 'Taroko',
    'ts'    => 'Тсонга',
    'tsi'   => 'Тсимшиан',
    'tt'    => 'Татарски',
    'tum'   => 'Тумбука',
    'tup'   => "Тупи\ језик",
    'tut'   => "Алтаички\ језик",
    'tvl'   => 'Тувалу',
    'tw'    => 'Тви',
    'twq'   => 'Tasawaq',
    'ty'    => 'Тахићански',
    'tyv'   => 'Тувинијски',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'Удмурт',
    'ug'    => 'ујгурски',
    'uga'   => 'Угаритски',
    'uk'    => 'Украјински',
    'umb'   => 'Умбунду',
    'und'   => "Непознат\ или\ неважећи\ језик",
    'ur'    => 'Урду',
    'uz'    => 'Узбечки',
    'vai'   => 'Ваи',
    've'    => 'Венда',
    'vi'    => 'Вијетнамски',
    'vo'    => 'Волапук',
    'vot'   => 'Вотски',
    'vun'   => 'Vunjo',
    'wa'    => 'Валун',
    'wae'   => 'Walser',
    'wak'   => "Вакашански\ језик",
    'wal'   => 'Валамо',
    'war'   => 'Варај',
    'was'   => 'Вашо',
    'wen'   => "Сорбијански\ језик",
    'wo'    => 'Волоф',
    'xal'   => 'Калмик',
    'xh'    => 'Ксхоса',
    'xog'   => 'Soga',
    'yao'   => 'Јао',
    'yap'   => 'Јапешки',
    'yav'   => 'Yangben',
    'yi'    => 'Јидиш',
    'yo'    => 'Јоруба',
    'ypk'   => 'Јупик',
    'yue'   => 'Кантонски',
    'za'    => 'Жуанг',
    'zap'   => 'Запотечки',
    'zbl'   => 'Блисимболи',
    'zen'   => 'Зенага',
    'zh'    => 'Кинески',
    'znd'   => 'Занде',
    'zu'    => 'Зулу',
    'zun'   => 'Зуни',
    'zxx'   => "Без\ лингвистичког\ садржаја",
    'zza'   => 'Заза',
);

%Locales::DB::Language::sr::name_to_code = (
    'aghem'                                                                      => 'agq',
    'asu'                                                                        => 'asa',
    'bafia'                                                                      => 'ksf',
    'bena'                                                                       => 'bez',
    'bodo'                                                                       => 'brx',
    'cayuga'                                                                     => 'cay',
    'centralmoroccotamazight'                                                    => 'tzm',
    'chiga'                                                                      => 'cgg',
    'colognian'                                                                  => 'ksh',
    'congoswahili'                                                               => 'swc',
    'embu'                                                                       => 'ebu',
    'gusii'                                                                      => 'guz',
    'jolafonyi'                                                                  => 'dyo',
    'kabuverdianu'                                                               => 'kea',
    'kalenjin'                                                                   => 'kln',
    'koyraborosenni'                                                             => 'ses',
    'koyrachiini'                                                                => 'khq',
    'kwasio'                                                                     => 'nmg',
    'langi'                                                                      => 'lag',
    'luyia'                                                                      => 'luy',
    'machame'                                                                    => 'jmc',
    'makhuwameetto'                                                              => 'mgh',
    'makonde'                                                                    => 'kde',
    'meru'                                                                       => 'mer',
    'morisyen'                                                                   => 'mfe',
    'mundang'                                                                    => 'mua',
    'nama'                                                                       => 'naq',
    'nuer'                                                                       => 'nus',
    'rombo'                                                                      => 'rof',
    'rwa'                                                                        => 'rwk',
    'saho'                                                                       => 'ssy',
    'samburu'                                                                    => 'saq',
    'sangu'                                                                      => 'sbp',
    'sena'                                                                       => 'seh',
    'seneca'                                                                     => 'see',
    'shambala'                                                                   => 'ksb',
    'soga'                                                                       => 'xog',
    'tachelhit'                                                                  => 'shi',
    'taita'                                                                      => 'dav',
    'taroko'                                                                     => 'trv',
    'tasawaq'                                                                    => 'twq',
    'teso'                                                                       => 'teo',
    'vunjo'                                                                      => 'vun',
    'walser'                                                                     => 'wae',
    'yangben'                                                                    => 'yav',
    'zarma'                                                                      => 'dje',
    'Ђу'                                                                       => 'kaj',
    'Ђула'                                                                   => 'dyu',
    'Јавански'                                                           => 'jv',
    'Јакут'                                                                 => 'sah',
    'Јао'                                                                     => 'yao',
    'Јапански'                                                           => 'ja',
    'Јапешки'                                                             => 'yap',
    'ЈезиксеверноамеричкихИндијанаца'             => 'nai',
    'ЈезикјужноамеричкихИндијанаца'                 => 'sai',
    'Јерменски'                                                         => 'hy',
    'Јидиш'                                                                 => 'yi',
    'Јоруба'                                                               => 'yo',
    'Јудеоарапски'                                                   => 'jrb',
    'Јудеоперсијски'                                               => 'jpr',
    'Јужниалтаи'                                                       => 'alt',
    'Јужниндебеле'                                                   => 'nr',
    'Јужнисами'                                                         => 'sma',
    'Јупик'                                                                 => 'ypk',
    'Њамвези'                                                             => 'nym',
    'Њанколе'                                                             => 'nyn',
    'Њасатонга'                                                         => 'tog',
    'Њања'                                                                   => 'ny',
    'Њоро'                                                                   => 'nyo',
    'Џиз'                                                                     => 'gez',
    'Џонга'                                                                 => 'dz',
    'Абказијски'                                                       => 'ab',
    'Авадхи'                                                               => 'awa',
    'Аварски'                                                             => 'av',
    'Авестански'                                                       => 'ae',
    'Адангмејски'                                                     => 'ada',
    'Адигејски'                                                         => 'ady',
    'Аину'                                                                   => 'ain',
    'Акадијски'                                                         => 'akk',
    'Акан'                                                                   => 'ak',
    'Аколи'                                                                 => 'ach',
    'Албански'                                                           => 'sq',
    'Алгонквијанскијезик'                                     => 'alg',
    'Алтаичкијезик'                                                 => 'tut',
    'Амхарски'                                                           => 'am',
    'Ангика'                                                               => 'anp',
    'Апачкијезик'                                                     => 'apa',
    'Аравак'                                                               => 'arw',
    'Арагонежански'                                                 => 'an',
    'Арапахо'                                                             => 'arp',
    'Арапски'                                                             => 'ar',
    'Армајски'                                                           => 'arc',
    'Ароканијски'                                                     => 'arn',
    'Ароманијски'                                                     => 'rup',
    'Асемијски'                                                         => 'as',
    'Астуријски'                                                       => 'ast',
    'Атапаскан'                                                         => 'ath',
    'Атсамски'                                                           => 'cch',
    'Аустралијскиенглески'                                   => 'en_au',
    'Аустралијскијезик'                                         => 'aus',
    'Аустријскинемачки'                                         => 'de_at',
    'Аустронежански'                                               => 'map',
    'Афарски'                                                             => 'aa',
    'Африканерски'                                                   => 'af',
    'Африхили'                                                           => 'afh',
    'Афроазијатски'                                                 => 'afa',
    'Ачинески'                                                           => 'ace',
    'Аљут'                                                                   => 'ale',
    'Балинезијски'                                                   => 'ban',
    'Балтичкијезик'                                                 => 'bat',
    'Балучи'                                                               => 'bal',
    'Бамбара'                                                             => 'bm',
    'Бамилеке'                                                           => 'bai',
    'Банда'                                                                 => 'bad',
    'Банту'                                                                 => 'bnt',
    'Баса'                                                                   => 'bas',
    'Баскијски'                                                         => 'eu',
    'Батак'                                                                 => 'btk',
    'Башкир'                                                               => 'ba',
    'Безлингвистичкогсадржаја'                           => 'zxx',
    'Белоруски'                                                         => 'be',
    'Бемба'                                                                 => 'bem',
    'Бенгласки'                                                         => 'bn',
    'Бербер'                                                               => 'ber',
    'Беја'                                                                   => 'bej',
    'Бикол'                                                                 => 'bik',
    'Бини'                                                                   => 'bin',
    'Бислама'                                                             => 'bi',
    'Бихарски'                                                           => 'bh',
    'Блин'                                                                   => 'byn',
    'Блисимболи'                                                       => 'zbl',
    'Босански'                                                           => 'bs',
    'Бојпури'                                                             => 'bho',
    'Бразилскипортугалски'                                   => 'pt_br',
    'Брај'                                                                   => 'bra',
    'Бретонски'                                                         => 'br',
    'Британскиенглески'                                         => 'en_gb',
    'Бугарски'                                                           => 'bg',
    'Бугинежански'                                                   => 'bug',
    'Буриат'                                                               => 'bua',
    'Бурмански'                                                         => 'my',
    'Ваи'                                                                     => 'vai',
    'Вакашанскијезик'                                             => 'wak',
    'Валамо'                                                               => 'wal',
    'Валун'                                                                 => 'wa',
    'Варај'                                                                 => 'war',
    'Вашо'                                                                   => 'was',
    'Велшки'                                                               => 'cy',
    'Венда'                                                                 => 've',
    'Вештачки'                                                           => 'art',
    'Вишејезика'                                                       => 'mul',
    'Вијетнамски'                                                     => 'vi',
    'Волапук'                                                             => 'vo',
    'Волоф'                                                                 => 'wo',
    'Вотски'                                                               => 'vot',
    'Га'                                                                       => 'gaa',
    'Галски'                                                               => 'gl',
    'Ганда'                                                                 => 'lg',
    'Гајо'                                                                   => 'gay',
    'Гбаја'                                                                 => 'gba',
    'Гварани'                                                             => 'gn',
    'Гвичин'                                                               => 'gwi',
    'Германскијезик'                                               => 'gem',
    'Гилбертшки'                                                       => 'gil',
    'Гонди'                                                                 => 'gon',
    'Горонтало'                                                         => 'gor',
    'Горњисорбијски'                                               => 'hsb',
    'Готски'                                                               => 'got',
    'Гребо'                                                                 => 'grb',
    'Грузијски'                                                         => 'ka',
    'Грчки'                                                                 => 'el',
    'Гуџарати'                                                           => 'gu',
    'Дакота'                                                               => 'dak',
    'Дански'                                                               => 'da',
    'Дарвидијскијезик'                                           => 'dra',
    'Даргва'                                                               => 'dar',
    'Дајашки'                                                             => 'day',
    'Делавер'                                                             => 'del',
    'Дивехијски'                                                       => 'dv',
    'Динка'                                                                 => 'din',
    'Догри'                                                                 => 'doi',
    'Догриб'                                                               => 'dgr',
    'Дуала'                                                                 => 'dua',
    'Еве'                                                                     => 'ee',
    'Евондо'                                                               => 'ewo',
    'Екајук'                                                               => 'eka',
    'Еламитски'                                                         => 'elx',
    'Енглески'                                                           => 'en',
    'Ерзија'                                                               => 'myv',
    'Есперанто'                                                         => 'eo',
    'Естонски'                                                           => 'et',
    'Ефикски'                                                             => 'efi',
    'Жуанг'                                                                 => 'za',
    'Заза'                                                                   => 'zza',
    'Занде'                                                                 => 'znd',
    'Запотечки'                                                         => 'zap',
    'Зенага'                                                               => 'zen',
    'Знаковнијезик'                                                 => 'sgn',
    'Зулу'                                                                   => 'zu',
    'Зуни'                                                                   => 'zun',
    'Ибан'                                                                   => 'iba',
    'Иберијскипортугалски'                                   => 'pt_pt',
    'Иберијскишпански'                                           => 'es_es',
    'Игбо'                                                                   => 'ig',
    'Идо'                                                                     => 'io',
    'Илоко'                                                                 => 'ilo',
    'Инарисами'                                                         => 'smn',
    'Ингвишки'                                                           => 'inh',
    'Индик'                                                                 => 'inc',
    'Индоевропскијезик'                                         => 'ine',
    'Индонежански'                                                   => 'id',
    'Интерлингва'                                                     => 'ia',
    'Инуктитут'                                                         => 'iu',
    'Иранскијезик'                                                   => 'ira',
    'Ироквојански'                                                   => 'iro',
    'Ирски'                                                                 => 'ga',
    'Исландски'                                                         => 'is',
    'Источнифризијски'                                           => 'frs',
    'Италијански'                                                     => 'it',
    'Ијо'                                                                     => 'ijo',
    'Кабардијски'                                                     => 'kbd',
    'Кабиле'                                                               => 'kab',
    'Кави'                                                                   => 'kaw',
    'Кавкаски'                                                           => 'cau',
    'Кадо'                                                                   => 'cad',
    'Калалисут'                                                         => 'kl',
    'Калмик'                                                               => 'xal',
    'Камба'                                                                 => 'kam',
    'Канада'                                                               => 'kn',
    'Канадскиенглески'                                           => 'en_ca',
    'Канадскифранцуски'                                         => 'fr_ca',
    'Кантонски'                                                         => 'yue',
    'Канури'                                                               => 'kr',
    'Каракалпашки'                                                   => 'kaa',
    'Карачајбалкар'                                                 => 'krc',
    'Карелијски'                                                       => 'krl',
    'Каренски'                                                           => 'kar',
    'Карипски'                                                           => 'car',
    'Каси'                                                                   => 'kha',
    'Каталонски'                                                       => 'ca',
    'Качин'                                                                 => 'kac',
    'Кашмирски'                                                         => 'ks',
    'Кашубијански'                                                   => 'csb',
    'Квенча'                                                               => 'qu',
    'Келтски'                                                             => 'cel',
    'Кикују'                                                               => 'ki',
    'Кимбунду'                                                           => 'kmb',
    'Кинески'                                                             => 'zh',
    'Кинјаруанда'                                                     => 'rw',
    'Киргиски'                                                           => 'ky',
    'Класичниневари'                                               => 'nwc',
    'Класичнисиријски'                                           => 'syc',
    'Клингонски'                                                       => 'tlh',
    'Кмерски'                                                             => 'km',
    'Козачки'                                                             => 'kk',
    'Коисанскијезик'                                               => 'khi',
    'Коми'                                                                   => 'kv',
    'Коморски'                                                           => 'swb',
    'Конго'                                                                 => 'kg',
    'Конкани'                                                             => 'kok',
    'Коптски'                                                             => 'cop',
    'Корејски'                                                           => 'ko',
    'Корзикански'                                                     => 'co',
    'Корнишки'                                                           => 'kw',
    'Коро'                                                                   => 'kfo',
    'Косреански'                                                       => 'kos',
    'Котанешки'                                                         => 'kho',
    'Кпеле'                                                                 => 'kpe',
    'Креолскиилипиџинбазираннапортугалском' => 'cpp',
    'Креолскиилипиџинзаснованнаенглеском'     => 'cpe',
    'Креолскиилипиџинзаснованнафранцуском'   => 'cpf',
    'Кри'                                                                     => 'cr',
    'Кримеанскитурски'                                           => 'crh',
    'Кришки'                                                               => 'mus',
    'Кру'                                                                     => 'kro',
    'Ксхоса'                                                               => 'xh',
    'Куањама'                                                             => 'kj',
    'Кумик'                                                                 => 'kum',
    'Курдски'                                                             => 'ku',
    'Курукх'                                                               => 'kru',
    'Кутенаи'                                                             => 'kut',
    'Кушитичкијезик'                                               => 'cus',
    'Ладино'                                                               => 'lad',
    'Ламба'                                                                 => 'lam',
    'Ланда'                                                                 => 'lah',
    'Лаоски'                                                               => 'lo',
    'Латински'                                                           => 'la',
    'Лезгиан'                                                             => 'lez',
    'Летонски'                                                           => 'lv',
    'Лимбургиш'                                                         => 'li',
    'Лингала'                                                             => 'ln',
    'Литвански'                                                         => 'lt',
    'Лози'                                                                   => 'loz',
    'Лојбан'                                                               => 'jbo',
    'Лубакатанга'                                                     => 'lu',
    'Лубалулуа'                                                         => 'lua',
    'Луисено'                                                             => 'lui',
    'Луксембуршки'                                                   => 'lb',
    'Лулесами'                                                           => 'smj',
    'Лунда'                                                                 => 'lun',
    'Луо'                                                                     => 'luo',
    'Лушаи'                                                                 => 'lus',
    'Магахи'                                                               => 'mag',
    'Мадурешки'                                                         => 'mad',
    'Маитили'                                                             => 'mai',
    'Макасар'                                                             => 'mak',
    'Македонски'                                                       => 'mk',
    'Малагасијски'                                                   => 'mg',
    'Малајалам'                                                         => 'ml',
    'Малајски'                                                           => 'ms',
    'Мандар'                                                               => 'mdr',
    'Мандинго'                                                           => 'man',
    'Манипури'                                                           => 'mni',
    'Манкс'                                                                 => 'gv',
    'Манобојезик'                                                     => 'mno',
    'Манчу'                                                                 => 'mnc',
    'Маорски'                                                             => 'mi',
    'Марати'                                                               => 'mr',
    'Марвари'                                                             => 'mwr',
    'Мари'                                                                   => 'chm',
    'Маршалски'                                                         => 'mh',
    'Масаи'                                                                 => 'mas',
    'Махавски'                                                           => 'moh',
    'Мађарски'                                                           => 'hu',
    'Мајанскијезик'                                                 => 'myn',
    'Мелтешки'                                                           => 'mt',
    'Менде'                                                                 => 'men',
    'Међујезички'                                                     => 'ie',
    'Микмак'                                                               => 'mic',
    'Минангкабау'                                                     => 'min',
    'Мирандешки'                                                       => 'mwl',
    'Мокша'                                                                 => 'mdf',
    'Молдавски'                                                         => 'mo',
    'Монго'                                                                 => 'lol',
    'Монголски'                                                         => 'mn',
    'Монкмерскијезик'                                             => 'mkh',
    'Моси'                                                                   => 'mos',
    'Мундајезик'                                                       => 'mun',
    'Навахо'                                                               => 'nv',
    'Науру'                                                                 => 'na',
    'Нахуатл'                                                             => 'nah',
    'Ндонга'                                                               => 'ng',
    'Неаполитански'                                                 => 'nap',
    'Невари'                                                               => 'new',
    'Немачки'                                                             => 'de',
    'Непалски'                                                           => 'ne',
    'Непознатилиневажећијезик'                           => 'und',
    'Нзима'                                                                 => 'nzi',
    'Ниас'                                                                   => 'nia',
    'Нигеркордофанијскијезик'                             => 'nic',
    'Нилосахарскијезик'                                         => 'ssa',
    'Нискинемачки'                                                   => 'nds',
    'Нискисорбијански'                                           => 'dsb',
    'Ниуеан'                                                               => 'niu',
    'Ногаи'                                                                 => 'nog',
    'Норвешки'                                                           => 'no',
    'Норвешкибокмал'                                               => 'nb',
    'Норвешкињорск'                                                 => 'nn',
    'Нубијскијезик'                                                 => 'nub',
    'Н’ко'                                                                  => 'nqo',
    'Оријски'                                                             => 'or',
    'Оромо'                                                                 => 'om',
    'Осаге'                                                                 => 'osa',
    'Осетски'                                                             => 'os',
    'Отоманскитурски'                                             => 'ota',
    'Отоманскијезик'                                               => 'oto',
    'Ојибва'                                                               => 'oj',
    'Палауански'                                                       => 'pau',
    'Пали'                                                                   => 'pi',
    'Пампанга'                                                           => 'pam',
    'Пангасински'                                                     => 'pag',
    'Панџабски'                                                         => 'pa',
    'Папиаменто'                                                       => 'pap',
    'Папуанскијезик'                                               => 'paa',
    'Пахлави'                                                             => 'pal',
    'Персијски'                                                         => 'fa',
    'Понпејски'                                                         => 'pon',
    'Португалски'                                                     => 'pt',
    'Пољски'                                                               => 'pl',
    'Пракритски'                                                       => 'pra',
    'Провансалски'                                                   => 'oc',
    'Разнијезици'                                                     => 'mis',
    'Рапануи'                                                             => 'rap',
    'Раротонган'                                                       => 'rar',
    'Рађастани'                                                         => 'raj',
    'РетоРомански'                                                   => 'rm',
    'Романи'                                                               => 'rom',
    'Романскијезик'                                                 => 'roa',
    'Румунски'                                                           => 'ro',
    'Рунди'                                                                 => 'rn',
    'Руски'                                                                 => 'ru',
    'САДенглески'                                                     => 'en_us',
    'Салишанскијезик'                                             => 'sal',
    'Самаританскиарамејски'                                 => 'sam',
    'Самијезик'                                                         => 'smi',
    'Самоански'                                                         => 'sm',
    'Санго'                                                                 => 'sg',
    'Сандаве'                                                             => 'sad',
    'Санскрит'                                                           => 'sa',
    'Сантали'                                                             => 'sat',
    'Сардињаски'                                                       => 'sc',
    'Сасак'                                                                 => 'sas',
    'Свати'                                                                 => 'ss',
    'Свахили'                                                             => 'sw',
    'Северниндебеле'                                               => 'nd',
    'Севернисами'                                                     => 'se',
    'Севернисото'                                                     => 'nso',
    'Севернофризијски'                                           => 'frr',
    'Селкап'                                                               => 'sel',
    'Семитскијезик'                                                 => 'sem',
    'Серер'                                                                 => 'srr',
    'Сесото'                                                               => 'st',
    'Сидамо'                                                               => 'sid',
    'Сингалески'                                                       => 'si',
    'Синди'                                                                 => 'sd',
    'Синотибетанскијезик'                                     => 'sit',
    'Сиријски'                                                           => 'syr',
    'Сисика'                                                               => 'bla',
    'Сиуанскијезик'                                                 => 'sio',
    'Сицилијански'                                                   => 'scn',
    'Сичуанји'                                                           => 'ii',
    'Сколтскијезик'                                                 => 'sms',
    'Славски'                                                             => 'den',
    'Словачки'                                                           => 'sk',
    'Словеначки'                                                       => 'sl',
    'Словенскијезик'                                               => 'sla',
    'Сомалски'                                                           => 'so',
    'Сонгаи'                                                               => 'son',
    'Сонинке'                                                             => 'snk',
    'Сорбијанскијезик'                                           => 'wen',
    'Соџијенски'                                                       => 'sog',
    'Срананскитонго'                                               => 'srn',
    'Средњивисокинемачки'                                     => 'gmh',
    'Средњиенглески'                                               => 'enm',
    'Средњиирски'                                                     => 'mga',
    'Средњифранцуски'                                             => 'frm',
    'Средњихоландски'                                             => 'dum',
    'Српски'                                                               => 'sr',
    'Српскохрватски'                                               => 'sh',
    'Старинорски'                                                     => 'non',
    'Старогрчки'                                                       => 'grc',
    'Староегипатски'                                               => 'egy',
    'Староенглески'                                                 => 'ang',
    'Староирски'                                                       => 'sga',
    'Старонемачки'                                                   => 'goh',
    'Староперсијски'                                               => 'peo',
    'Старопровансалски'                                         => 'pro',
    'Старословенски'                                               => 'cu',
    'Старофранцуски'                                               => 'fro',
    'Судански'                                                           => 'su',
    'Сукума'                                                               => 'suk',
    'Сумерски'                                                           => 'sux',
    'Сусу'                                                                   => 'sus',
    'Тагалог'                                                             => 'fil',
    'Тагалски'                                                           => 'tl',
    'Таијезик'                                                           => 'tai',
    'Тамашек'                                                             => 'tmh',
    'Тамилски'                                                           => 'ta',
    'Татарски'                                                           => 'tt',
    'Тахићански'                                                       => 'ty',
    'Тађик'                                                                 => 'tg',
    'Тајландски'                                                       => 'th',
    'Тви'                                                                     => 'tw',
    'Телугу'                                                               => 'te',
    'Терено'                                                               => 'ter',
    'Тетум'                                                                 => 'tet',
    'Тибетански'                                                       => 'bo',
    'Тив'                                                                     => 'tiv',
    'Тигре'                                                                 => 'tig',
    'Тигриња'                                                             => 'ti',
    'Тимне'                                                                 => 'tem',
    'Тлингит'                                                             => 'tli',
    'ТокПисин'                                                           => 'tpi',
    'Токелау'                                                             => 'tkl',
    'Тонга'                                                                 => 'to',
    'Тсвана'                                                               => 'tn',
    'Тсимшиан'                                                           => 'tsi',
    'Тсонга'                                                               => 'ts',
    'Тувалу'                                                               => 'tvl',
    'Тувинијски'                                                       => 'tyv',
    'Тумбука'                                                             => 'tum',
    'Тупијезик'                                                         => 'tup',
    'Туркменски'                                                       => 'tk',
    'Турски'                                                               => 'tr',
    'Тјап'                                                                   => 'kcg',
    'Угаритски'                                                         => 'uga',
    'Угрофински'                                                       => 'fiu',
    'Удмурт'                                                               => 'udm',
    'Узбечки'                                                             => 'uz',
    'Украјински'                                                       => 'uk',
    'Умбунду'                                                             => 'umb',
    'Унупиак'                                                             => 'ik',
    'Урду'                                                                   => 'ur',
    'Фанг'                                                                   => 'fan',
    'Фанти'                                                                 => 'fat',
    'Фарски'                                                               => 'fo',
    'Феничански'                                                       => 'phn',
    'Фиджијски'                                                         => 'fj',
    'Филипинскијезик'                                             => 'phi',
    'Фински'                                                               => 'fi',
    'Фламански'                                                         => 'nl_be',
    'Фон'                                                                     => 'fon',
    'Француски'                                                         => 'fr',
    'Фризијски'                                                         => 'fy',
    'Фриулијски'                                                       => 'fur',
    'Фулах'                                                                 => 'ff',
    'Хавајски'                                                           => 'haw',
    'Хаида'                                                                 => 'hai',
    'Хаитски'                                                             => 'ht',
    'Хауса'                                                                 => 'ha',
    'Хебрејски'                                                         => 'he',
    'Хереро'                                                               => 'hz',
    'Хилигајнон'                                                       => 'hil',
    'Химачали'                                                           => 'him',
    'Хинди'                                                                 => 'hi',
    'ХириМоту'                                                           => 'ho',
    'Хитите'                                                               => 'hit',
    'Хмонг'                                                                 => 'hmn',
    'Холандски'                                                         => 'nl',
    'Хрватски'                                                           => 'hr',
    'Хупа'                                                                   => 'hup',
    'Цебуано'                                                             => 'ceb',
    'ЦентралноамеричкиИндијанскијезик'           => 'cai',
    'Чагатаи'                                                             => 'chg',
    'Чаморо'                                                               => 'ch',
    'Чамскијезик'                                                     => 'cmc',
    'Чероки'                                                               => 'chr',
    'Чеченски'                                                           => 'ce',
    'Чешки'                                                                 => 'cs',
    'Чејенски'                                                           => 'chy',
    'Чибча'                                                                 => 'chb',
    'Чинукски'                                                           => 'chn',
    'Чипвијански'                                                     => 'chp',
    'Чоктавски'                                                         => 'cho',
    'Чувашки'                                                             => 'cv',
    'Чукески'                                                             => 'chk',
    'Шан'                                                                     => 'shn',
    'Швајцарскивисокинемачки'                             => 'de_ch',
    'Швајцарскинемачки'                                         => 'gsw',
    'Швајцарскифранцуски'                                     => 'fr_ch',
    'Шведски'                                                             => 'sv',
    'Шкотски'                                                             => 'sco',
    'ШкотскиГалски'                                                 => 'gd',
    'Шона'                                                                   => 'sn',
    'Шпански'                                                             => 'es',
    'азерски'                                                             => 'az',
    'ајмара'                                                               => 'ay',
    'креолскиилипиџин'                                           => 'crp',
    'пашто'                                                                 => 'ps',
    'ујгурски'                                                           => 'ug',
);

1;
