package Locales::DB::Language::vi;

# Auto generated from CLDR

$Locales::DB::Language::vi::VERSION = '0.07';

$Locales::DB::Language::vi::cldr_version = '2.0';

%Locales::DB::Language::vi::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => "\.",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Ngôn\ ngữ\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ và\ \{1\}",
            'end'    => "\{0\}\ và\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Vùng\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '’',
        'alternate_quotation_start' => '‘',
        'quotation_end'             => '”',
        'quotation_start'           => '“'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list'  => ['other'],
        'category_rules' => {}
    },
    'posix' => {
        'nostr' => {
            'content' => "no\:n",
            'draft'   => 'contributed'
        },
        'yesstr' => {
            'content' => "yes\:y",
            'draft'   => 'contributed'
        }
    },
);

%Locales::DB::Language::vi::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => "Tiếng\ Abkhazia",
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => "Tiếng\ Nam\ Phi",
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'agq'   => 'Aghem',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => "Tiếng\ Amharic",
    'an'    => 'Aragonese',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => "Tiếng\ A\-rập",
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Artificial\ Language",
    'arw'   => 'Arawak',
    'as'    => "Tiếng\ Assam",
    'asa'   => 'Asu',
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => "Tiếng\ Aymara",
    'az'    => "Tiếng\ Azeri",
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basaa',
    'bat'   => "Baltic\ Language",
    'be'    => "Tiếng\ Bê\-la\-rút",
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bez'   => 'Bena',
    'bg'    => "Tiếng\ Bun\-ga\-ri",
    'bh'    => "Tiếng\ Bihari",
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => "Tiếng\ Bengali\ \(Ấn\ Độ\)",
    'bnt'   => 'Bantu',
    'bo'    => "Tiếng\ Tây\ Tạng",
    'br'    => "Tiếng\ Breton",
    'bra'   => 'Braj',
    'brx'   => 'Bodo',
    'bs'    => "Tiếng\ Nam\ Tư",
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => "Tiếng\ Ca\-ta\-lăng",
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cay'   => 'Cayuga',
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ Language",
    'cgg'   => 'Chiga',
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'Corsican',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => "Tiếng\ Séc",
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => "Tiếng\ Xentơ",
    'da'    => "Tiếng\ Đan\ Mạch",
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'dav'   => 'Taita',
    'day'   => 'Dayak',
    'de'    => "Tiếng\ Đức",
    'de_at' => "Austrian\ German",
    'de_ch' => "Tiếng\ Đức\ Chuẩn\ \(Thụy\ Sĩ\)",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'dje'   => 'Zarma',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => "Tiếng\ Divehi",
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'Dyula',
    'dz'    => "Tiếng\ Dzongkha",
    'ebu'   => 'Embu',
    'ee'    => 'Ewe',
    'efi'   => "Tiếng\ Efik",
    'egy'   => "Ancient\ Egyptian",
    'eka'   => 'Ekajuk',
    'el'    => "Tiếng\ Hy\ Lạp",
    'elx'   => 'Elamite',
    'en'    => "Tiếng\ Anh",
    'en_au' => "Australian\ English",
    'en_ca' => "Tiếng\ Anh\ \(Canada\)",
    'en_gb' => "Tiếng\ Anh\ \(Anh\)",
    'en_us' => "Tiếng\ Anh\ \(Mỹ\)",
    'enm'   => "Middle\ English",
    'eo'    => "Tiếng\ Quốc\ Tế\ Ngữ",
    'es'    => "Tiếng\ Tây\ Ban\ Nha",
    'es_es' => "Tiếng\ Tây\ Ban\ Nha\ \(I\-bê\-ri\)",
    'et'    => "Tiếng\ E\-xtô\-ni\-a",
    'eu'    => "Tiếng\ Basque",
    'ewo'   => 'Ewondo',
    'fa'    => "Tiếng\ Ba\ Tư",
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => "Tiếng\ Phần\ Lan",
    'fil'   => "Tiếng\ Philipin",
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => "Tiếng\ Fiji",
    'fo'    => "Tiếng\ Faore",
    'fon'   => 'Fon',
    'fr'    => "Tiếng\ Pháp",
    'fr_ca' => "Tiếng\ Pháp\ \(Canada\)",
    'fr_ch' => "Swiss\ French",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => "Tiếng\ Frisian",
    'ga'    => "Tiếng\ Ai\-len",
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "Tiếng\ Xentơ\ \(Xcốt\ len\)",
    'gem'   => "Germanic\ Language",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => "Tiếng\ Galician",
    'gmh'   => "Middle\ High\ German",
    'gn'    => "Tiếng\ Guarani",
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Ancient\ Greek",
    'gsw'   => "Tiếng\ Đức\ Thụy\ Sĩ",
    'gu'    => "Tiếng\ Gujarati",
    'guz'   => 'Gusii',
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => "Tiếng\ Hausa",
    'hai'   => 'Haida',
    'haw'   => "Tiếng\ Hawaii",
    'he'    => "Tiếng\ Hê\-brơ",
    'hi'    => "Tiếng\ Hin\-đi",
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => "Tiếng\ Crô\-a\-ti\-a",
    'hsb'   => "Upper\ Sorbian",
    'ht'    => "Tiếng\ Haiti",
    'hu'    => "Tiếng\ Hung\-ga\-ri",
    'hup'   => 'Hupa',
    'hy'    => "Tiếng\ Ác\-mê\-ni",
    'hz'    => 'Herero',
    'ia'    => "Tiếng\ Khoa\ Học\ Quốc\ Tế",
    'iba'   => 'Iban',
    'id'    => "Tiếng\ In\-đô\-nê\-xia",
    'ie'    => 'Interlingue',
    'ig'    => "Tiếng\ Igbo",
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => "Tiếng\ Ai\-xơ\-len",
    'it'    => "Tiếng\ Ý",
    'iu'    => 'Inuktitut',
    'ja'    => "Tiếng\ Nhật",
    'jbo'   => 'Lojban',
    'jmc'   => 'Machame',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => "Tiếng\ Gia\-va",
    'ka'    => "Tiếng\ Georgian",
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => "Tiếng\ Kazakh",
    'kl'    => 'Kalaallisut',
    'kln'   => 'Kalenjin',
    'km'    => "Tiếng\ Campuchia",
    'kmb'   => 'Kimbundu',
    'kn'    => "Tiếng\ Kan\-na\-đa",
    'ko'    => "Tiếng\ Hàn\ Quốc",
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => "Tiếng\ Kashmiri",
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => "Tiếng\ Kurd\ \(Iran\)",
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => "Tiếng\ Kyrgyz",
    'la'    => "Tiếng\ La\-tinh",
    'lad'   => 'Ladino',
    'lag'   => 'Langi',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => "Tiếng\ Luxembourg",
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => "Tiếng\ Lingala",
    'lo'    => "Tiếng\ Lào",
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => "Tiếng\ Lít\-va",
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'luy'   => 'Luyia',
    'lv'    => "Tiếng\ Lát\-vi\-a",
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => "Tiếng\ Malagasy",
    'mga'   => "Middle\ Irish",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'Marshallese',
    'mi'    => "Tiếng\ Maori",
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => "Tiếng\ Ma\-xê\-đô\-ni\-a",
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => "Tiếng\ Malayalam",
    'mn'    => "Tiếng\ Mông\ Cổ",
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'Moldavian',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => "Tiếng\ Marathi",
    'ms'    => "Tiếng\ Ma\-lay\-xi\-a",
    'mt'    => "Tiếng\ Mantơ",
    'mua'   => 'Mundang',
    'mul'   => "Multiple\ Languages",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => "Tiếng\ Miến\ Điện",
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'Nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'naq'   => 'Nama',
    'nb'    => "Tiếng\ Na\ Uy\ \(Bokmål\)",
    'nd'    => "Bắc\ Ndebele",
    'nds'   => "Low\ German",
    'ne'    => "Tiếng\ Nê\-pan",
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => "Tiếng\ Hà\ Lan",
    'nl_be' => "Tiếng\ Flemish",
    'nmg'   => 'Kwasio',
    'nn'    => "Tiếng\ Na\ Uy\ \(Nynorsk\)",
    'no'    => "Tiếng\ Na\ Uy",
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Bắc\ Sotho",
    'nub'   => "Nubian\ Language",
    'nus'   => 'Nuer',
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => "Tiếng\ Nyanja",
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => "Tiếng\ Occitan",
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => "Tiếng\ Ô\-ri\-a",
    'os'    => "Tiếng\ Ossetic",
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => "Tiếng\ Punjabi",
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => "Tiếng\ Ba\ Lan",
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => "Tiếng\ Pushto",
    'pt'    => "Tiếng\ Bồ\ Đào\ Nha",
    'pt_br' => "Tiếng\ Bồ\ Đào\ Nha\ \(Braxin\)",
    'pt_pt' => "Tiếng\ Bồ\ Đào\ Nha\ \(I\-bê\-ri\)",
    'qu'    => "Tiếng\ Quechua",
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => "Tiếng\ Rhaeto\-Romance",
    'rn'    => "Tiếng\ Rundi",
    'ro'    => "Tiếng\ Ru\-ma\-ni",
    'roa'   => "Romance\ Language",
    'rof'   => 'Rombo',
    'rom'   => 'Romany',
    'ru'    => "Tiếng\ Nga",
    'rup'   => 'Aromanian',
    'rw'    => "Tiếng\ Kinyarwanda",
    'rwk'   => 'Rwa',
    'sa'    => "Tiếng\ Phạn",
    'sad'   => 'Sandawe',
    'sah'   => 'Sakha',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'saq'   => 'Samburu',
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sbp'   => 'Sangu',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => "Tiếng\ Sin\-hi",
    'se'    => "Bắc\ Sami",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => "Tiếng\ Sango",
    'sga'   => "Old\ Irish",
    'sgn'   => "Sign\ Language",
    'sh'    => "Tiếng\ Xéc\ bi\ \-\ Croatia",
    'shi'   => 'Tachelhit',
    'shn'   => 'Shan',
    'si'    => "Tiếng\ Sinhala",
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => "Tiếng\ Xlô\-vác",
    'sl'    => "Tiếng\ Xlô\-ven",
    'sla'   => "Slavic\ Language",
    'sm'    => "Tiếng\ Samoa",
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => "Tiếng\ Shona",
    'snk'   => 'Soninke',
    'so'    => "Tiếng\ Xô\-ma\-li",
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => "Tiếng\ An\-ba\-ni",
    'sr'    => "Tiếng\ Séc\-bi",
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => "Tiếng\ Swati",
    'ssa'   => "Nilo\-Saharan\ Language",
    'ssy'   => 'Saho',
    'st'    => "Tiếng\ Sesotho",
    'su'    => "Tiếng\ Xu\ đăng",
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => "Tiếng\ Thụy\ Điển",
    'sw'    => "Tiếng\ Bantu\ \(Đông\ Phi\)",
    'swb'   => "Tiếng\ Cômo",
    'swc'   => "Congo\ Swahili",
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => "Tiếng\ Tamil",
    'tai'   => "Tai\ Language",
    'te'    => "Tiếng\ Telugu",
    'tem'   => 'Timne',
    'teo'   => 'Teso',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => "Tiếng\ Tajik",
    'th'    => "Tiếng\ Thái",
    'ti'    => "Tiếng\ Tigrigya",
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => "Tiếng\ Tuôc\-men",
    'tkl'   => 'Tokelau',
    'tl'    => "Tiếng\ Tagalog",
    'tlh'   => "Tiếng\ Klingon",
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => "Tiếng\ Tswana",
    'to'    => "Tiếng\ Tonga",
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tiếng\ Tok\ Pisin",
    'tr'    => "Tiếng\ Thổ\ Nhĩ\ Kỳ",
    'trv'   => 'Taroko',
    'ts'    => "Tiếng\ Tsonga",
    'tsi'   => 'Tsimshian',
    'tt'    => "Tiếng\ Tatar",
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => "Tiếng\ Twi",
    'twq'   => 'Tasawaq',
    'ty'    => "Tiếng\ Tahiti",
    'tyv'   => 'Tuvinian',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'Udmurt',
    'ug'    => "Tiếng\ Uyghur",
    'uga'   => 'Ugaritic',
    'uk'    => "Tiếng\ U\-crai\-na",
    'umb'   => 'Umbundu',
    'und'   => "Tiếng\ không\ xác\ định",
    'ur'    => "Tiếng\ Uđu",
    'uz'    => "Tiếng\ U\-dơ\-bếch",
    'vai'   => 'Vai',
    've'    => "Tiếng\ Venda",
    'vi'    => "Tiếng\ Việt",
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'vun'   => 'Vunjo',
    'wa'    => 'Walloon',
    'wae'   => 'Walser',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => "Tiếng\ Wolof",
    'xal'   => 'Kalmyk',
    'xh'    => "Tiếng\ Bantu",
    'xog'   => 'Soga',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yav'   => 'Yangben',
    'yi'    => "Tiếng\ Y\-đit",
    'yo'    => "Tiếng\ Yoruba",
    'ypk'   => "Yupik\ Language",
    'yue'   => "Tiếng\ Quảng\ Đông",
    'za'    => 'Zhuang',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => "Tiếng\ Trung\ Quốc",
    'znd'   => 'Zande',
    'zu'    => "Tiếng\ Zulu",
    'zun'   => 'Zuni',
    'zxx'   => "Không\ có\ nội\ dung\ ngôn\ ngữ",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::vi::name_to_code = (
    'achinese'                      => 'ace',
    'acoli'                         => 'ach',
    'adangme'                       => 'ada',
    'adyghe'                        => 'ady',
    'afar'                          => 'aa',
    'afrihili'                      => 'afh',
    'afroasiaticlanguage'           => 'afa',
    'aghem'                         => 'agq',
    'ainu'                          => 'ain',
    'akan'                          => 'ak',
    'akkadian'                      => 'akk',
    'aleut'                         => 'ale',
    'algonquianlanguage'            => 'alg',
    'altaiclanguage'                => 'tut',
    'ancientegyptian'               => 'egy',
    'ancientgreek'                  => 'grc',
    'angika'                        => 'anp',
    'apachelanguage'                => 'apa',
    'aragonese'                     => 'an',
    'aramaic'                       => 'arc',
    'arapaho'                       => 'arp',
    'araucanian'                    => 'arn',
    'arawak'                        => 'arw',
    'aromanian'                     => 'rup',
    'artificiallanguage'            => 'art',
    'asturian'                      => 'ast',
    'asu'                           => 'asa',
    'athapascanlanguage'            => 'ath',
    'atsam'                         => 'cch',
    'australianenglish'             => 'en_au',
    'australianlanguage'            => 'aus',
    'austriangerman'                => 'de_at',
    'austronesianlanguage'          => 'map',
    'avaric'                        => 'av',
    'avestan'                       => 'ae',
    'awadhi'                        => 'awa',
    'bafia'                         => 'ksf',
    'balinese'                      => 'ban',
    'balticlanguage'                => 'bat',
    'baluchi'                       => 'bal',
    'bambara'                       => 'bm',
    'bamilekelanguage'              => 'bai',
    'banda'                         => 'bad',
    'bantu'                         => 'bnt',
    'basaa'                         => 'bas',
    'bashkir'                       => 'ba',
    'batak'                         => 'btk',
    'beja'                          => 'bej',
    'bemba'                         => 'bem',
    'bena'                          => 'bez',
    'berber'                        => 'ber',
    'bhojpuri'                      => 'bho',
    'bikol'                         => 'bik',
    'bini'                          => 'bin',
    'bislama'                       => 'bi',
    'blin'                          => 'byn',
    'blissymbols'                   => 'zbl',
    'bodo'                          => 'brx',
    'braj'                          => 'bra',
    'buginese'                      => 'bug',
    'buriat'                        => 'bua',
    'bắcndebele'                  => 'nd',
    'bắcsami'                     => 'se',
    'bắcsotho'                    => 'nso',
    'caddo'                         => 'cad',
    'carib'                         => 'car',
    'caucasianlanguage'             => 'cau',
    'cayuga'                        => 'cay',
    'cebuano'                       => 'ceb',
    'celticlanguage'                => 'cel',
    'centralamericanindianlanguage' => 'cai',
    'centralmoroccotamazight'       => 'tzm',
    'chagatai'                      => 'chg',
    'chamiclanguage'                => 'cmc',
    'chamorro'                      => 'ch',
    'chechen'                       => 'ce',
    'cherokee'                      => 'chr',
    'cheyenne'                      => 'chy',
    'chibcha'                       => 'chb',
    'chiga'                         => 'cgg',
    'chinookjargon'                 => 'chn',
    'chipewyan'                     => 'chp',
    'choctaw'                       => 'cho',
    'churchslavic'                  => 'cu',
    'chuukese'                      => 'chk',
    'chuvash'                       => 'cv',
    'classicalnewari'               => 'nwc',
    'classicalsyriac'               => 'syc',
    'colognian'                     => 'ksh',
    'congoswahili'                  => 'swc',
    'coptic'                        => 'cop',
    'cornish'                       => 'kw',
    'corsican'                      => 'co',
    'cree'                          => 'cr',
    'creek'                         => 'mus',
    'creoleorpidgin'                => 'crp',
    'crimeanturkish'                => 'crh',
    'cushiticlanguage'              => 'cus',
    'dakota'                        => 'dak',
    'dargwa'                        => 'dar',
    'dayak'                         => 'day',
    'delaware'                      => 'del',
    'dinka'                         => 'din',
    'dogri'                         => 'doi',
    'dogrib'                        => 'dgr',
    'dravidianlanguage'             => 'dra',
    'duala'                         => 'dua',
    'dyula'                         => 'dyu',
    'easternfrisian'                => 'frs',
    'ekajuk'                        => 'eka',
    'elamite'                       => 'elx',
    'embu'                          => 'ebu',
    'englishbasedcreoleorpidgin'    => 'cpe',
    'erzya'                         => 'myv',
    'ewe'                           => 'ee',
    'ewondo'                        => 'ewo',
    'fang'                          => 'fan',
    'fanti'                         => 'fat',
    'finnougrianlanguage'           => 'fiu',
    'fon'                           => 'fon',
    'frenchbasedcreoleorpidgin'     => 'cpf',
    'friulian'                      => 'fur',
    'fulah'                         => 'ff',
    'ga'                            => 'gaa',
    'ganda'                         => 'lg',
    'gayo'                          => 'gay',
    'gbaya'                         => 'gba',
    'geez'                          => 'gez',
    'germaniclanguage'              => 'gem',
    'gilbertese'                    => 'gil',
    'gondi'                         => 'gon',
    'gorontalo'                     => 'gor',
    'gothic'                        => 'got',
    'grebo'                         => 'grb',
    'gusii'                         => 'guz',
    "gwich\Ê\¼in"                 => 'gwi',
    'haida'                         => 'hai',
    'herero'                        => 'hz',
    'hiligaynon'                    => 'hil',
    'himachali'                     => 'him',
    'hirimotu'                      => 'ho',
    'hittite'                       => 'hit',
    'hmong'                         => 'hmn',
    'hupa'                          => 'hup',
    'iban'                          => 'iba',
    'ido'                           => 'io',
    'ijo'                           => 'ijo',
    'iloko'                         => 'ilo',
    'inarisami'                     => 'smn',
    'indiclanguage'                 => 'inc',
    'indoeuropeanlanguage'          => 'ine',
    'ingush'                        => 'inh',
    'interlingue'                   => 'ie',
    'inuktitut'                     => 'iu',
    'inupiaq'                       => 'ik',
    'iranianlanguage'               => 'ira',
    'iroquoianlanguage'             => 'iro',
    'jju'                           => 'kaj',
    'jolafonyi'                     => 'dyo',
    'judeoarabic'                   => 'jrb',
    'judeopersian'                  => 'jpr',
    'kabardian'                     => 'kbd',
    'kabuverdianu'                  => 'kea',
    'kabyle'                        => 'kab',
    'kachin'                        => 'kac',
    'kalaallisut'                   => 'kl',
    'kalenjin'                      => 'kln',
    'kalmyk'                        => 'xal',
    'kamba'                         => 'kam',
    'kanuri'                        => 'kr',
    'karachaybalkar'                => 'krc',
    'karakalpak'                    => 'kaa',
    'karelian'                      => 'krl',
    'karen'                         => 'kar',
    'kashubian'                     => 'csb',
    'kawi'                          => 'kaw',
    'khasi'                         => 'kha',
    'khoisanlanguage'               => 'khi',
    'khotanese'                     => 'kho',
    'khôngcónộidungngônngữ'  => 'zxx',
    'kikuyu'                        => 'ki',
    'kimbundu'                      => 'kmb',
    'komi'                          => 'kv',
    'kongo'                         => 'kg',
    'konkani'                       => 'kok',
    'koro'                          => 'kfo',
    'kosraean'                      => 'kos',
    'koyraborosenni'                => 'ses',
    'koyrachiini'                   => 'khq',
    'kpelle'                        => 'kpe',
    'kru'                           => 'kro',
    'kuanyama'                      => 'kj',
    'kumyk'                         => 'kum',
    'kurukh'                        => 'kru',
    'kutenai'                       => 'kut',
    'kwasio'                        => 'nmg',
    'ladino'                        => 'lad',
    'lahnda'                        => 'lah',
    'lamba'                         => 'lam',
    'langi'                         => 'lag',
    'lezghian'                      => 'lez',
    'limburgish'                    => 'li',
    'lojban'                        => 'jbo',
    'lowersorbian'                  => 'dsb',
    'lowgerman'                     => 'nds',
    'lozi'                          => 'loz',
    'lubakatanga'                   => 'lu',
    'lubalulua'                     => 'lua',
    'luiseno'                       => 'lui',
    'lulesami'                      => 'smj',
    'lunda'                         => 'lun',
    'luo'                           => 'luo',
    'lushai'                        => 'lus',
    'luyia'                         => 'luy',
    'machame'                       => 'jmc',
    'madurese'                      => 'mad',
    'magahi'                        => 'mag',
    'maithili'                      => 'mai',
    'makasar'                       => 'mak',
    'makhuwameetto'                 => 'mgh',
    'makonde'                       => 'kde',
    'manchu'                        => 'mnc',
    'mandar'                        => 'mdr',
    'mandingo'                      => 'man',
    'manipuri'                      => 'mni',
    'manobolanguage'                => 'mno',
    'manx'                          => 'gv',
    'mari'                          => 'chm',
    'marshallese'                   => 'mh',
    'marwari'                       => 'mwr',
    'masai'                         => 'mas',
    'mayanlanguage'                 => 'myn',
    'mende'                         => 'men',
    'meru'                          => 'mer',
    'micmac'                        => 'mic',
    'middledutch'                   => 'dum',
    'middleenglish'                 => 'enm',
    'middlefrench'                  => 'frm',
    'middlehighgerman'              => 'gmh',
    'middleirish'                   => 'mga',
    'minangkabau'                   => 'min',
    'mirandese'                     => 'mwl',
    'miscellaneouslanguage'         => 'mis',
    'mohawk'                        => 'moh',
    'moksha'                        => 'mdf',
    'moldavian'                     => 'mo',
    'mongo'                         => 'lol',
    'monkhmerlanguage'              => 'mkh',
    'morisyen'                      => 'mfe',
    'mossi'                         => 'mos',
    'multiplelanguages'             => 'mul',
    'mundalanguage'                 => 'mun',
    'mundang'                       => 'mua',
    'nahuatl'                       => 'nah',
    'nama'                          => 'naq',
    'nauru'                         => 'na',
    'navajo'                        => 'nv',
    'ndonga'                        => 'ng',
    'neapolitan'                    => 'nap',
    'newari'                        => 'new',
    'nias'                          => 'nia',
    'nigerkordofanianlanguage'      => 'nic',
    'nilosaharanlanguage'           => 'ssa',
    'niuean'                        => 'niu',
    'nogai'                         => 'nog',
    'northamericanindianlanguage'   => 'nai',
    'northernfrisian'               => 'frr',
    'nubianlanguage'                => 'nub',
    'nuer'                          => 'nus',
    'nyamwezi'                      => 'nym',
    'nyankole'                      => 'nyn',
    'nyasatonga'                    => 'tog',
    'nyoro'                         => 'nyo',
    'nzima'                         => 'nzi',
    "n\â\\ko"                  => 'nqo',
    'ojibwa'                        => 'oj',
    'oldenglish'                    => 'ang',
    'oldfrench'                     => 'fro',
    'oldhighgerman'                 => 'goh',
    'oldirish'                      => 'sga',
    'oldnorse'                      => 'non',
    'oldpersian'                    => 'peo',
    "oldproven\Ã\§al"             => 'pro',
    'oromo'                         => 'om',
    'osage'                         => 'osa',
    'otomianlanguage'               => 'oto',
    'ottomanturkish'                => 'ota',
    'pahlavi'                       => 'pal',
    'palauan'                       => 'pau',
    'pali'                          => 'pi',
    'pampanga'                      => 'pam',
    'pangasinan'                    => 'pag',
    'papiamento'                    => 'pap',
    'papuanlanguage'                => 'paa',
    'philippinelanguage'            => 'phi',
    'phoenician'                    => 'phn',
    'pohnpeian'                     => 'pon',
    'portuguesebasedcreoleorpidgin' => 'cpp',
    'prakritlanguage'               => 'pra',
    'rajasthani'                    => 'raj',
    'rapanui'                       => 'rap',
    'rarotongan'                    => 'rar',
    'romancelanguage'               => 'roa',
    'romany'                        => 'rom',
    'rombo'                         => 'rof',
    'rwa'                           => 'rwk',
    'saho'                          => 'ssy',
    'sakha'                         => 'sah',
    'salishanlanguage'              => 'sal',
    'samaritanaramaic'              => 'sam',
    'samburu'                       => 'saq',
    'samilanguage'                  => 'smi',
    'sandawe'                       => 'sad',
    'sangu'                         => 'sbp',
    'santali'                       => 'sat',
    'sardinian'                     => 'sc',
    'sasak'                         => 'sas',
    'scots'                         => 'sco',
    'selkup'                        => 'sel',
    'semiticlanguage'               => 'sem',
    'sena'                          => 'seh',
    'seneca'                        => 'see',
    'serer'                         => 'srr',
    'shambala'                      => 'ksb',
    'shan'                          => 'shn',
    'sichuanyi'                     => 'ii',
    'sicilian'                      => 'scn',
    'sidamo'                        => 'sid',
    'signlanguage'                  => 'sgn',
    'siksika'                       => 'bla',
    'sinotibetanlanguage'           => 'sit',
    'siouanlanguage'                => 'sio',
    'skoltsami'                     => 'sms',
    'slave'                         => 'den',
    'slaviclanguage'                => 'sla',
    'soga'                          => 'xog',
    'sogdien'                       => 'sog',
    'songhai'                       => 'son',
    'soninke'                       => 'snk',
    'sorbianlanguage'               => 'wen',
    'southamericanindianlanguage'   => 'sai',
    'southernaltai'                 => 'alt',
    'southernsami'                  => 'sma',
    'southndebele'                  => 'nr',
    'sranantongo'                   => 'srn',
    'sukuma'                        => 'suk',
    'sumerian'                      => 'sux',
    'susu'                          => 'sus',
    'swissfrench'                   => 'fr_ch',
    'syriac'                        => 'syr',
    'tachelhit'                     => 'shi',
    'tailanguage'                   => 'tai',
    'taita'                         => 'dav',
    'tamashek'                      => 'tmh',
    'taroko'                        => 'trv',
    'tasawaq'                       => 'twq',
    'tereno'                        => 'ter',
    'teso'                          => 'teo',
    'tetum'                         => 'tet',
    'tigre'                         => 'tig',
    'timne'                         => 'tem',
    'tiv'                           => 'tiv',
    'tiếngabkhazia'               => 'ab',
    'tiếngailen'                  => 'ga',
    'tiếngaixơlen'               => 'is',
    'tiếngamharic'                => 'am',
    'tiếnganbani'                 => 'sq',
    'tiếnganh'                    => 'en',
    'tiếnganhanh'                 => 'en_gb',
    'tiếnganhcanada'              => 'en_ca',
    'tiếnganhmỹ'                => 'en_us',
    'tiếngarập'                 => 'ar',
    'tiếngassam'                  => 'as',
    'tiếngaymara'                 => 'ay',
    'tiếngazeri'                  => 'az',
    'tiếngbalan'                  => 'pl',
    'tiếngbantu'                  => 'xh',
    'tiếngbantuĐôngphi'         => 'sw',
    'tiếngbasque'                 => 'eu',
    'tiếngbatư'                  => 'fa',
    'tiếngbengaliẤnĐộ'       => 'bn',
    'tiếngbihari'                 => 'bh',
    'tiếngbreton'                 => 'br',
    'tiếngbungari'                => 'bg',
    'tiếngbêlarút'              => 'be',
    'tiếngbồĐàonha'           => 'pt',
    'tiếngbồĐàonhabraxin'     => 'pt_br',
    'tiếngbồĐàonhaibêri'     => 'pt_pt',
    'tiếngcampuchia'              => 'km',
    'tiếngcatalăng'              => 'ca',
    'tiếngcrôatia'               => 'hr',
    'tiếngcômo'                  => 'swb',
    'tiếngdivehi'                 => 'dv',
    'tiếngdzongkha'               => 'dz',
    'tiếngefik'                   => 'efi',
    'tiếngextônia'               => 'et',
    'tiếngfaore'                  => 'fo',
    'tiếngfiji'                   => 'fj',
    'tiếngflemish'                => 'nl_be',
    'tiếngfrisian'                => 'fy',
    'tiếnggalician'               => 'gl',
    'tiếnggeorgian'               => 'ka',
    'tiếnggiava'                  => 'jv',
    'tiếngguarani'                => 'gn',
    'tiếnggujarati'               => 'gu',
    'tiếnghaiti'                  => 'ht',
    'tiếnghausa'                  => 'ha',
    'tiếnghawaii'                 => 'haw',
    'tiếnghinđi'                 => 'hi',
    'tiếnghunggari'               => 'hu',
    'tiếnghylạp'                => 'el',
    'tiếnghàlan'                 => 'nl',
    'tiếnghànquốc'             => 'ko',
    'tiếnghêbrơ'                => 'he',
    'tiếngigbo'                   => 'ig',
    'tiếnginđônêxia'           => 'id',
    'tiếngkannađa'               => 'kn',
    'tiếngkashmiri'               => 'ks',
    'tiếngkazakh'                 => 'kk',
    'tiếngkhoahọcquốctế'    => 'ia',
    'tiếngkhôngxácđịnh'      => 'und',
    'tiếngkinyarwanda'            => 'rw',
    'tiếngklingon'                => 'tlh',
    'tiếngkurdiran'               => 'ku',
    'tiếngkyrgyz'                 => 'ky',
    'tiếnglatinh'                 => 'la',
    'tiếnglingala'                => 'ln',
    'tiếngluxembourg'             => 'lb',
    'tiếnglào'                   => 'lo',
    'tiếnglátvia'                => 'lv',
    'tiếnglítva'                 => 'lt',
    'tiếngmalagasy'               => 'mg',
    'tiếngmalayalam'              => 'ml',
    'tiếngmalayxia'               => 'ms',
    'tiếngmantơ'                 => 'mt',
    'tiếngmaori'                  => 'mi',
    'tiếngmarathi'                => 'mr',
    'tiếngmaxêđônia'           => 'mk',
    'tiếngmiếnĐiện'          => 'my',
    'tiếngmôngcổ'              => 'mn',
    'tiếngnamphi'                 => 'af',
    'tiếngnamtư'                 => 'bs',
    'tiếngnauy'                   => 'no',
    'tiếngnauybokmål'            => 'nb',
    'tiếngnauynynorsk'            => 'nn',
    'tiếngnga'                    => 'ru',
    'tiếngnhật'                 => 'ja',
    'tiếngnyanja'                 => 'ny',
    'tiếngnêpan'                 => 'ne',
    'tiếngoccitan'                => 'oc',
    'tiếngossetic'                => 'os',
    'tiếngphilipin'               => 'fil',
    'tiếngpháp'                  => 'fr',
    'tiếngphápcanada'            => 'fr_ca',
    'tiếngphạn'                 => 'sa',
    'tiếngphầnlan'              => 'fi',
    'tiếngpunjabi'                => 'pa',
    'tiếngpushto'                 => 'ps',
    'tiếngquechua'                => 'qu',
    'tiếngquảngĐông'          => 'yue',
    'tiếngquốctếngữ'        => 'eo',
    'tiếngrhaetoromance'          => 'rm',
    'tiếngrumani'                 => 'ro',
    'tiếngrundi'                  => 'rn',
    'tiếngsamoa'                  => 'sm',
    'tiếngsango'                  => 'sg',
    'tiếngsesotho'                => 'st',
    'tiếngshona'                  => 'sn',
    'tiếngsinhala'                => 'si',
    'tiếngsinhi'                  => 'sd',
    'tiếngswati'                  => 'ss',
    'tiếngséc'                   => 'cs',
    'tiếngsécbi'                 => 'sr',
    'tiếngtagalog'                => 'tl',
    'tiếngtahiti'                 => 'ty',
    'tiếngtajik'                  => 'tg',
    'tiếngtamil'                  => 'ta',
    'tiếngtatar'                  => 'tt',
    'tiếngtelugu'                 => 'te',
    'tiếngthái'                  => 'th',
    'tiếngthổnhĩkỳ'          => 'tr',
    'tiếngthụyĐiển'          => 'sv',
    'tiếngtigrigya'               => 'ti',
    'tiếngtokpisin'               => 'tpi',
    'tiếngtonga'                  => 'to',
    'tiếngtrungquốc'            => 'zh',
    'tiếngtsonga'                 => 'ts',
    'tiếngtswana'                 => 'tn',
    'tiếngtuôcmen'               => 'tk',
    'tiếngtwi'                    => 'tw',
    'tiếngtâybannha'             => 'es',
    'tiếngtâybannhaibêri'       => 'es_es',
    'tiếngtâytạng'             => 'bo',
    'tiếngucraina'                => 'uk',
    'tiếngudơbếch'             => 'uz',
    'tiếnguyghur'                 => 'ug',
    'tiếnguđu'                   => 'ur',
    'tiếngvenda'                  => 've',
    'tiếngviệt'                 => 'vi',
    'tiếngwolof'                  => 'wo',
    'tiếngxentơ'                 => 'cy',
    'tiếngxentơxcốtlen'        => 'gd',
    'tiếngxlôven'                => 'sl',
    'tiếngxlôvác'               => 'sk',
    'tiếngxuđăng'               => 'su',
    'tiếngxécbicroatia'          => 'sh',
    'tiếngxômali'                => 'so',
    'tiếngyoruba'                 => 'yo',
    'tiếngyđit'                  => 'yi',
    'tiếngzulu'                   => 'zu',
    'tiếngÁcmêni'               => 'hy',
    'tiếngÔria'                  => 'or',
    'tiếngÝ'                     => 'it',
    'tiếngĐanmạch'             => 'da',
    'tiếngĐức'                 => 'de',
    'tiếngĐứcchuẩnthụysĩ' => 'de_ch',
    'tiếngĐứcthụysĩ'        => 'gsw',
    'tlingit'                       => 'tli',
    'tokelau'                       => 'tkl',
    'tsimshian'                     => 'tsi',
    'tumbuka'                       => 'tum',
    'tupilanguage'                  => 'tup',
    'tuvalu'                        => 'tvl',
    'tuvinian'                      => 'tyv',
    'tyap'                          => 'kcg',
    'udmurt'                        => 'udm',
    'ugaritic'                      => 'uga',
    'umbundu'                       => 'umb',
    'uppersorbian'                  => 'hsb',
    'vai'                           => 'vai',
    "volap\Ã\¼k"                  => 'vo',
    'votic'                         => 'vot',
    'vunjo'                         => 'vun',
    'wakashanlanguage'              => 'wak',
    'walamo'                        => 'wal',
    'walloon'                       => 'wa',
    'walser'                        => 'wae',
    'waray'                         => 'war',
    'washo'                         => 'was',
    'yangben'                       => 'yav',
    'yao'                           => 'yao',
    'yapese'                        => 'yap',
    'yupiklanguage'                 => 'ypk',
    'zande'                         => 'znd',
    'zapotec'                       => 'zap',
    'zarma'                         => 'dje',
    'zaza'                          => 'zza',
    'zenaga'                        => 'zen',
    'zhuang'                        => 'za',
    'zuni'                          => 'zun',
);

1;
