package Locales::DB::Language::he;

# Auto generated from CLDR

$Locales::DB::Language::he::VERSION = '0.07';

$Locales::DB::Language::he::cldr_version = '2.0';

%Locales::DB::Language::he::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "\{0\}",
        'list'     => {
            2        => "\{0\}\ ו\-\{1\}",
            'end'    => "\{0\}\ ו\-\{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "\{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => "\"",
        'alternate_quotation_start' => "\"",
        'quotation_end'             => '”',
        'quotation_start'           => '“'
    },
    'fallback'    => ['en'],
    'orientation' => {
        'characters' => "right\-to\-left",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => { 'one' => "sub\ \{\ return\ \'one\'\ if\ \(\ \(\(\ \$_\[0\]\ \=\=\ 1\)\)\)\;\ return\;\}\;" }
    },
    'posix' => {
        'nostr'  => "לא\:ל",
        'yesstr' => "כן\:כ"
    },
);

%Locales::DB::Language::he::code_to_name = (
    'aa'    => 'אפארית',
    'ab'    => 'אבחזית',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'אדיגית',
    'ae'    => 'אבסטן',
    'af'    => 'אפריקאנס',
    'afa'   => "שפה\ אפרו\-אסייתית",
    'afh'   => 'אפריהילי',
    'agq'   => 'Aghem',
    'ain'   => 'אינו',
    'ak'    => 'אקאן',
    'akk'   => 'אכדית',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'אמהרית',
    'an'    => 'Aragonese',
    'ang'   => "אנגלית\ עתיקה",
    'anp'   => 'Angika',
    'apa'   => "שפה\ אפאצ׳ית",
    'ar'    => 'ערבית',
    'arc'   => 'ארמית',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "שפה\ מלאכותית",
    'arw'   => 'Arawak',
    'as'    => 'אסאמית',
    'asa'   => 'Asu',
    'ast'   => 'אסטורית',
    'ath'   => "Athapascan\ Language",
    'aus'   => "שפה\ אוסטרלית",
    'av'    => 'Avaric',
    'awa'   => 'אוואדית',
    'ay'    => 'איימארית',
    'az'    => 'אזרית',
    'ba'    => 'בשקירית',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'באלוצ׳י',
    'ban'   => 'בלינזית',
    'bas'   => 'Basaa',
    'bat'   => "שפות\ בלטיות",
    'be'    => 'בלארוסית',
    'bej'   => 'בז׳ה',
    'bem'   => 'Bemba',
    'ber'   => 'ברברית',
    'bez'   => 'Bena',
    'bg'    => 'בולגרית',
    'bh'    => 'ביהארי',
    'bho'   => 'Bhojpuri',
    'bi'    => 'ביסלמה',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'בנגלית',
    'bnt'   => 'בנטו',
    'bo'    => 'טיבטית',
    'br'    => 'ברטונית',
    'bra'   => 'Braj',
    'brx'   => 'Bodo',
    'bs'    => 'בוסנית',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'קטלאנית',
    'cad'   => 'קאדו',
    'cai'   => "שפה\ אינדיאנית\ מרכז\-אמריקאית",
    'car'   => 'Carib',
    'cau'   => "שפה\ קווקזית",
    'cay'   => 'Cayuga',
    'cch'   => 'Atsam',
    'ce'    => 'צ׳צ׳נית',
    'ceb'   => 'קבואנו',
    'cel'   => "שפה\ קלטית",
    'cgg'   => 'Chiga',
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'צ׳אגאטאי',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'צ׳רוקי',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'קורסיקנית',
    'cop'   => 'קופטית',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "טטרית\ של\ קרים",
    'crp'   => "שפה\ קראולית\ או\ פידג׳אנית",
    'cs'    => 'צ׳כית',
    'csb'   => 'Kashubian',
    'cu'    => "סלאבית\ כנסייתית\ עתיקה",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => 'וולשית',
    'da'    => 'דנית',
    'dak'   => 'דקוטה',
    'dar'   => 'Dargwa',
    'dav'   => 'Taita',
    'day'   => 'Dayak',
    'de'    => 'גרמנית',
    'de_at' => "גרמנית\ אוסטרית",
    'de_ch' => "גרמנית\ שוויצרית\ \(גבוהה\)",
    'del'   => 'דלאוור',
    'den'   => 'סלאבית',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'dje'   => 'Zarma',
    'doi'   => 'דוגרי',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "הולנדית\ תיכונה",
    'dv'    => 'דיבהי',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'Dyula',
    'dz'    => 'דזונקה',
    'ebu'   => 'Embu',
    'ee'    => 'Ewe',
    'efi'   => 'אפיק',
    'egy'   => "מצרית\ עתיקה",
    'eka'   => 'Ekajuk',
    'el'    => 'יוונית',
    'elx'   => 'עילמית',
    'en'    => 'אנגלית',
    'en_au' => "אנגלית\ אוסטרלית",
    'en_ca' => "אנגלית\ קנדית",
    'en_gb' => "אנגלית\ בריטית",
    'en_us' => "אנגלית\ אמריקנית",
    'enm'   => "אנגלית\ תיכונה",
    'eo'    => 'אספרנטו',
    'es'    => 'ספרדית',
    'es_es' => "ספרדית\ איברית",
    'et'    => 'אסטונית',
    'eu'    => 'בסקית',
    'ewo'   => 'Ewondo',
    'fa'    => 'פרסית',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'פינית',
    'fil'   => 'פיליפינית',
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'פיג׳ית',
    'fo'    => 'פארואזית',
    'fon'   => 'Fon',
    'fr'    => 'צרפתית',
    'fr_ca' => "צרפתית\ קנדית",
    'fr_ch' => "צרפתית\ שוויצרית",
    'frm'   => "צרפתית\ תיכונה",
    'fro'   => "צרפתית\ עתיקה",
    'frr'   => "פריזית\ צפונית",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => 'פריזית',
    'ga'    => 'אירית',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "גאלית\ סקוטית",
    'gem'   => "שפה\ גרמאנית",
    'gez'   => 'געז',
    'gil'   => 'Gilbertese',
    'gl'    => 'גליציאנית',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'גוארני',
    'goh'   => "Old\ High\ German",
    'gon'   => 'גונדי',
    'gor'   => 'Gorontalo',
    'got'   => 'גותית',
    'grb'   => 'Grebo',
    'grc'   => "יוונית\ עתיקה",
    'gsw'   => "גרמנית\ שוויצרית",
    'gu'    => 'גוג׳ראטית',
    'guz'   => 'Gusii',
    'gv'    => 'מאנית',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'האוסה',
    'hai'   => 'Haida',
    'haw'   => 'הוואית',
    'he'    => 'עברית',
    'hi'    => 'הינדי',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'חיתית',
    'hmn'   => 'Hmong',
    'ho'    => "הארי\ מוטו",
    'hr'    => 'קרואטית',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'האיטית',
    'hu'    => 'הונגרית',
    'hup'   => 'Hupa',
    'hy'    => 'ארמנית',
    'hz'    => 'Herero',
    'ia'    => '‏אינטרלינגואה',
    'iba'   => 'Iban',
    'id'    => 'אינדונזית',
    'ie'    => 'אינטרלינגה',
    'ig'    => 'איגבו',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'ik',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "שפה\ הודו\-אירופית",
    'inh'   => 'אינגושית',
    'io'    => 'אידו',
    'ira'   => "שפה\ איראנית",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'איסלנדית',
    'it'    => 'איטלקית',
    'iu'    => 'אינוקטיטוט',
    'ja'    => 'יפנית',
    'jbo'   => 'Lojban',
    'jmc'   => 'Machame',
    'jpr'   => "פרסית\ יהודית",
    'jrb'   => "ערבית\ יהודית",
    'jv'    => 'יאוונית',
    'ka'    => 'גיאורגית',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'קבילה',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'קזחית',
    'kl'    => 'קאלאליסוטית',
    'kln'   => 'Kalenjin',
    'km'    => 'קמרית',
    'kmb'   => 'Kimbundu',
    'kn'    => 'קנאדה',
    'ko'    => 'קוריאנית',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'קשמירית',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'כורדית',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'קורנית',
    'ky'    => 'קירגיזית',
    'la'    => 'לטינית',
    'lad'   => 'לדינו',
    'lag'   => 'Langi',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'לוקסמבורגית',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'לינגלה',
    'lo'    => 'לאית',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'ליטאית',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'luy'   => 'Luyia',
    'lv'    => 'לטבית',
    'mad'   => 'Madurese',
    'mag'   => 'מאגאהית',
    'mai'   => 'מאיטילית',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => 'אוסטרונזית',
    'mas'   => 'מאסאית',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'מלגשית',
    'mga'   => "אירית\ תיכונה",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'Marshallese',
    'mi'    => 'מאורית',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "שפה\ אחרת",
    'mk'    => 'מקדונית',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'מלאיאלם',
    'mn'    => 'מונגולית',
    'mnc'   => 'Manchu',
    'mni'   => 'מניפורית',
    'mno'   => "Manobo\ Language",
    'mo'    => 'מולדבית',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'מרטהי',
    'ms'    => 'מלאית',
    'mt'    => 'מלטית',
    'mua'   => 'Mundang',
    'mul'   => "מספר\ שפות",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'בורמזית',
    'myn'   => 'מאיה',
    'myv'   => 'Erzya',
    'na'    => 'נאורית',
    'nah'   => 'נאהואטל',
    'nai'   => "שפה\ אינדיאנית\ צפון\-אמריקאית",
    'nap'   => 'נפוליטנית',
    'naq'   => 'Nama',
    'nb'    => "‏נורבגית\ ספרותית",
    'nd'    => "צפון\ נדבלה",
    'nds'   => "גרמנית\ תחתית",
    'ne'    => 'נפאלית',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'הולנדית',
    'nl_be' => 'פלמית',
    'nmg'   => 'Kwasio',
    'nn'    => "נורבגית\ חדשה",
    'no'    => 'נורבגית',
    'nog'   => 'Nogai',
    'non'   => "‏נורדית\ עתיקה",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "סוטו\ הצפונית",
    'nub'   => "שפות\ נבטיות",
    'nus'   => 'Nuer',
    'nv'    => 'נבחו',
    'nwc'   => "נווארית\ קלאסית",
    'ny'    => "ניאנג\'ה",
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'אוקסיטנית',
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'אוריה',
    'os'    => 'אוסטית',
    'osa'   => 'Osage',
    'ota'   => "טורקית\ עותומנית",
    'oto'   => "Otomian\ Language",
    'pa'    => 'פנג׳אבית',
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "פרסית\ עתיקה",
    'phi'   => "שפה\ פיליפינית",
    'phn'   => 'פניקית',
    'pi'    => 'Pali',
    'pl'    => 'פולנית',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'פושטו',
    'pt'    => 'פורטוגלית',
    'pt_br' => "פורטוגזית\ ברזילאית",
    'pt_pt' => "פורטוגלית\ אירופית",
    'qu'    => "קצ\'ואה",
    'raj'   => 'ראג׳סטן',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => 'רומאנש',
    'rn'    => 'קירונדי',
    'ro'    => 'רומנית',
    'roa'   => "Romance\ Language",
    'rof'   => 'Rombo',
    'rom'   => 'רומאנית',
    'ru'    => 'רוסית',
    'rup'   => 'ארומנית',
    'rw'    => 'קינירואנדה',
    'rwk'   => 'Rwa',
    'sa'    => 'סנסקריט',
    'sad'   => 'Sandawe',
    'sah'   => 'Sakha',
    'sai'   => "שפה\ אינדיאנית\ דרום\ אמריקאית",
    'sal'   => "Salishan\ Language",
    'sam'   => "ארמית\ שומרונית",
    'saq'   => 'Samburu',
    'sas'   => 'Sasak',
    'sat'   => 'סאנטלי',
    'sbp'   => 'Sangu',
    'sc'    => 'סרדינית',
    'scn'   => 'סיציליאנית',
    'sco'   => 'סקוטית',
    'sd'    => 'סינדהית',
    'se'    => "לאפית\ צפונית",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'Selkup',
    'sem'   => "שפה\ שמית",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'סנגו',
    'sga'   => "אירית\ עתיקה",
    'sgn'   => "שפת\ סימנים",
    'sh'    => "סרבו\-קרואטית",
    'shi'   => 'Tachelhit',
    'shn'   => 'Shan',
    'si'    => 'סינהלה',
    'sid'   => 'סידמו',
    'sio'   => "Siouan\ Language",
    'sit'   => "שפה\ סינו־טיבטית",
    'sk'    => 'סלובקית',
    'sl'    => 'סלובנית',
    'sla'   => "שפה\ סלאבית",
    'sm'    => 'סמואית',
    'sma'   => "Southern\ Sami",
    'smi'   => "שפת\ סאמי",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'שונה',
    'snk'   => 'Soninke',
    'so'    => 'סומלית',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'אלבנית',
    'sr'    => 'סרבית',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'סיסוואטי',
    'ssa'   => "Nilo\-Saharan\ Language",
    'ssy'   => 'Saho',
    'st'    => 'ססות׳ו',
    'su'    => 'סודנית',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'שומרית',
    'sv'    => 'שוודית',
    'sw'    => 'סווהילית',
    'swb'   => 'קומורו',
    'swc'   => "Congo\ Swahili",
    'syc'   => "Classical\ Syriac",
    'syr'   => 'סורית',
    'ta'    => 'טמילית',
    'tai'   => "Tai\ Language",
    'te'    => 'טלוגו',
    'tem'   => 'Timne',
    'teo'   => 'Teso',
    'ter'   => 'Tereno',
    'tet'   => 'טטום',
    'tg'    => 'טג׳יקית',
    'th'    => 'תאי',
    'ti'    => 'טיגרינאית',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'טורקמנית',
    'tkl'   => 'Tokelau',
    'tl'    => 'טגלוג',
    'tlh'   => 'קלינגון',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'צוואנה',
    'to'    => 'טונגאית',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "טוק\ פיסין",
    'tr'    => 'טורקית',
    'trv'   => 'Taroko',
    'ts'    => 'טסונגה',
    'tsi'   => 'Tsimshian',
    'tt'    => 'טטרית',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'טווי',
    'twq'   => 'Tasawaq',
    'ty'    => 'טהיטית',
    'tyv'   => 'Tuvinian',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'Udmurt',
    'ug'    => 'אויגור',
    'uga'   => 'אוגריתית',
    'uk'    => 'אוקראינית',
    'umb'   => 'Umbundu',
    'und'   => "שפה\ לא\ ידועה\ או\ לא\ תקפה",
    'ur'    => 'אורדו',
    'uz'    => 'אוזבקית',
    'vai'   => 'Vai',
    've'    => 'וונדה',
    'vi'    => 'ויאטנמית',
    'vo'    => '‏וולאפיק',
    'vot'   => 'Votic',
    'vun'   => 'Vunjo',
    'wa'    => 'Walloon',
    'wae'   => 'Walser',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'ג׳ולוף',
    'xal'   => 'Kalmyk',
    'xh'    => 'קסוסה',
    'xog'   => 'Soga',
    'yao'   => 'Yao',
    'yap'   => 'יאפזית',
    'yav'   => 'Yangben',
    'yi'    => 'יידיש',
    'yo'    => 'יורובה',
    'ypk'   => "Yupik\ Language",
    'yue'   => 'קנטונזית',
    'za'    => 'Zhuang',
    'zap'   => 'זאפוטק',
    'zbl'   => 'Blissymbols',
    'zen'   => 'זנאגה',
    'zh'    => 'סינית',
    'znd'   => 'Zande',
    'zu'    => 'זולו',
    'zun'   => 'Zuni',
    'zxx'   => "ללא\ תוכן\ לשוני",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::he::name_to_code = (
    'achinese'                                         => 'ace',
    'acoli'                                            => 'ach',
    'adangme'                                          => 'ada',
    'aghem'                                            => 'agq',
    'aleut'                                            => 'ale',
    'algonquianlanguage'                               => 'alg',
    'altaiclanguage'                                   => 'tut',
    'angika'                                           => 'anp',
    'aragonese'                                        => 'an',
    'arapaho'                                          => 'arp',
    'araucanian'                                       => 'arn',
    'arawak'                                           => 'arw',
    'asu'                                              => 'asa',
    'athapascanlanguage'                               => 'ath',
    'atsam'                                            => 'cch',
    'avaric'                                           => 'av',
    'bafia'                                            => 'ksf',
    'bambara'                                          => 'bm',
    'bamilekelanguage'                                 => 'bai',
    'banda'                                            => 'bad',
    'basaa'                                            => 'bas',
    'batak'                                            => 'btk',
    'bemba'                                            => 'bem',
    'bena'                                             => 'bez',
    'bhojpuri'                                         => 'bho',
    'bikol'                                            => 'bik',
    'bini'                                             => 'bin',
    'blin'                                             => 'byn',
    'blissymbols'                                      => 'zbl',
    'bodo'                                             => 'brx',
    'braj'                                             => 'bra',
    'buginese'                                         => 'bug',
    'buriat'                                           => 'bua',
    'carib'                                            => 'car',
    'cayuga'                                           => 'cay',
    'centralmoroccotamazight'                          => 'tzm',
    'chamiclanguage'                                   => 'cmc',
    'chamorro'                                         => 'ch',
    'cheyenne'                                         => 'chy',
    'chibcha'                                          => 'chb',
    'chiga'                                            => 'cgg',
    'chinookjargon'                                    => 'chn',
    'chipewyan'                                        => 'chp',
    'choctaw'                                          => 'cho',
    'chuukese'                                         => 'chk',
    'chuvash'                                          => 'cv',
    'classicalsyriac'                                  => 'syc',
    'colognian'                                        => 'ksh',
    'congoswahili'                                     => 'swc',
    'cree'                                             => 'cr',
    'creek'                                            => 'mus',
    'cushiticlanguage'                                 => 'cus',
    'dargwa'                                           => 'dar',
    'dayak'                                            => 'day',
    'dinka'                                            => 'din',
    'dogrib'                                           => 'dgr',
    'dravidianlanguage'                                => 'dra',
    'duala'                                            => 'dua',
    'dyula'                                            => 'dyu',
    'easternfrisian'                                   => 'frs',
    'ekajuk'                                           => 'eka',
    'embu'                                             => 'ebu',
    'englishbasedcreoleorpidgin'                       => 'cpe',
    'erzya'                                            => 'myv',
    'ewe'                                              => 'ee',
    'ewondo'                                           => 'ewo',
    'fang'                                             => 'fan',
    'fanti'                                            => 'fat',
    'finnougrianlanguage'                              => 'fiu',
    'fon'                                              => 'fon',
    'frenchbasedcreoleorpidgin'                        => 'cpf',
    'friulian'                                         => 'fur',
    'fulah'                                            => 'ff',
    'ga'                                               => 'gaa',
    'ganda'                                            => 'lg',
    'gayo'                                             => 'gay',
    'gbaya'                                            => 'gba',
    'gilbertese'                                       => 'gil',
    'gorontalo'                                        => 'gor',
    'grebo'                                            => 'grb',
    'gusii'                                            => 'guz',
    "gwich\Ê\¼in"                                    => 'gwi',
    'haida'                                            => 'hai',
    'herero'                                           => 'hz',
    'hiligaynon'                                       => 'hil',
    'himachali'                                        => 'him',
    'hmong'                                            => 'hmn',
    'hupa'                                             => 'hup',
    'iban'                                             => 'iba',
    'ijo'                                              => 'ijo',
    'ik'                                               => 'ik',
    'iloko'                                            => 'ilo',
    'inarisami'                                        => 'smn',
    'indiclanguage'                                    => 'inc',
    'iroquoianlanguage'                                => 'iro',
    'jju'                                              => 'kaj',
    'jolafonyi'                                        => 'dyo',
    'kabardian'                                        => 'kbd',
    'kabuverdianu'                                     => 'kea',
    'kachin'                                           => 'kac',
    'kalenjin'                                         => 'kln',
    'kalmyk'                                           => 'xal',
    'kamba'                                            => 'kam',
    'kanuri'                                           => 'kr',
    'karachaybalkar'                                   => 'krc',
    'karakalpak'                                       => 'kaa',
    'karelian'                                         => 'krl',
    'karen'                                            => 'kar',
    'kashubian'                                        => 'csb',
    'kawi'                                             => 'kaw',
    'khasi'                                            => 'kha',
    'khoisanlanguage'                                  => 'khi',
    'khotanese'                                        => 'kho',
    'kikuyu'                                           => 'ki',
    'kimbundu'                                         => 'kmb',
    'komi'                                             => 'kv',
    'kongo'                                            => 'kg',
    'konkani'                                          => 'kok',
    'koro'                                             => 'kfo',
    'kosraean'                                         => 'kos',
    'koyraborosenni'                                   => 'ses',
    'koyrachiini'                                      => 'khq',
    'kpelle'                                           => 'kpe',
    'kru'                                              => 'kro',
    'kuanyama'                                         => 'kj',
    'kumyk'                                            => 'kum',
    'kurukh'                                           => 'kru',
    'kutenai'                                          => 'kut',
    'kwasio'                                           => 'nmg',
    'lahnda'                                           => 'lah',
    'lamba'                                            => 'lam',
    'langi'                                            => 'lag',
    'lezghian'                                         => 'lez',
    'limburgish'                                       => 'li',
    'lojban'                                           => 'jbo',
    'lowersorbian'                                     => 'dsb',
    'lozi'                                             => 'loz',
    'lubakatanga'                                      => 'lu',
    'lubalulua'                                        => 'lua',
    'luiseno'                                          => 'lui',
    'lulesami'                                         => 'smj',
    'lunda'                                            => 'lun',
    'luo'                                              => 'luo',
    'lushai'                                           => 'lus',
    'luyia'                                            => 'luy',
    'machame'                                          => 'jmc',
    'madurese'                                         => 'mad',
    'makasar'                                          => 'mak',
    'makhuwameetto'                                    => 'mgh',
    'makonde'                                          => 'kde',
    'manchu'                                           => 'mnc',
    'mandar'                                           => 'mdr',
    'mandingo'                                         => 'man',
    'manobolanguage'                                   => 'mno',
    'mari'                                             => 'chm',
    'marshallese'                                      => 'mh',
    'marwari'                                          => 'mwr',
    'mende'                                            => 'men',
    'meru'                                             => 'mer',
    'micmac'                                           => 'mic',
    'middlehighgerman'                                 => 'gmh',
    'minangkabau'                                      => 'min',
    'mirandese'                                        => 'mwl',
    'mohawk'                                           => 'moh',
    'moksha'                                           => 'mdf',
    'mongo'                                            => 'lol',
    'monkhmerlanguage'                                 => 'mkh',
    'morisyen'                                         => 'mfe',
    'mossi'                                            => 'mos',
    'mundalanguage'                                    => 'mun',
    'mundang'                                          => 'mua',
    'nama'                                             => 'naq',
    'ndonga'                                           => 'ng',
    'newari'                                           => 'new',
    'nias'                                             => 'nia',
    'nigerkordofanianlanguage'                         => 'nic',
    'nilosaharanlanguage'                              => 'ssa',
    'niuean'                                           => 'niu',
    'nogai'                                            => 'nog',
    'nuer'                                             => 'nus',
    'nyamwezi'                                         => 'nym',
    'nyankole'                                         => 'nyn',
    'nyasatonga'                                       => 'tog',
    'nyoro'                                            => 'nyo',
    'nzima'                                            => 'nzi',
    "n\â\\ko"                                     => 'nqo',
    'ojibwa'                                           => 'oj',
    'oldhighgerman'                                    => 'goh',
    "oldproven\Ã\§al"                                => 'pro',
    'oromo'                                            => 'om',
    'osage'                                            => 'osa',
    'otomianlanguage'                                  => 'oto',
    'pahlavi'                                          => 'pal',
    'palauan'                                          => 'pau',
    'pali'                                             => 'pi',
    'pampanga'                                         => 'pam',
    'pangasinan'                                       => 'pag',
    'papiamento'                                       => 'pap',
    'papuanlanguage'                                   => 'paa',
    'pohnpeian'                                        => 'pon',
    'portuguesebasedcreoleorpidgin'                    => 'cpp',
    'prakritlanguage'                                  => 'pra',
    'rapanui'                                          => 'rap',
    'rarotongan'                                       => 'rar',
    'romancelanguage'                                  => 'roa',
    'rombo'                                            => 'rof',
    'rwa'                                              => 'rwk',
    'saho'                                             => 'ssy',
    'sakha'                                            => 'sah',
    'salishanlanguage'                                 => 'sal',
    'samburu'                                          => 'saq',
    'sandawe'                                          => 'sad',
    'sangu'                                            => 'sbp',
    'sasak'                                            => 'sas',
    'selkup'                                           => 'sel',
    'sena'                                             => 'seh',
    'seneca'                                           => 'see',
    'serer'                                            => 'srr',
    'shambala'                                         => 'ksb',
    'shan'                                             => 'shn',
    'sichuanyi'                                        => 'ii',
    'siksika'                                          => 'bla',
    'siouanlanguage'                                   => 'sio',
    'skoltsami'                                        => 'sms',
    'soga'                                             => 'xog',
    'sogdien'                                          => 'sog',
    'songhai'                                          => 'son',
    'soninke'                                          => 'snk',
    'sorbianlanguage'                                  => 'wen',
    'southernaltai'                                    => 'alt',
    'southernsami'                                     => 'sma',
    'southndebele'                                     => 'nr',
    'sranantongo'                                      => 'srn',
    'sukuma'                                           => 'suk',
    'susu'                                             => 'sus',
    'tachelhit'                                        => 'shi',
    'tailanguage'                                      => 'tai',
    'taita'                                            => 'dav',
    'tamashek'                                         => 'tmh',
    'taroko'                                           => 'trv',
    'tasawaq'                                          => 'twq',
    'tereno'                                           => 'ter',
    'teso'                                             => 'teo',
    'tigre'                                            => 'tig',
    'timne'                                            => 'tem',
    'tiv'                                              => 'tiv',
    'tlingit'                                          => 'tli',
    'tokelau'                                          => 'tkl',
    'tsimshian'                                        => 'tsi',
    'tumbuka'                                          => 'tum',
    'tupilanguage'                                     => 'tup',
    'tuvalu'                                           => 'tvl',
    'tuvinian'                                         => 'tyv',
    'tyap'                                             => 'kcg',
    'udmurt'                                           => 'udm',
    'umbundu'                                          => 'umb',
    'uppersorbian'                                     => 'hsb',
    'vai'                                              => 'vai',
    'votic'                                            => 'vot',
    'vunjo'                                            => 'vun',
    'wakashanlanguage'                                 => 'wak',
    'walamo'                                           => 'wal',
    'walloon'                                          => 'wa',
    'walser'                                           => 'wae',
    'waray'                                            => 'war',
    'washo'                                            => 'was',
    'yangben'                                          => 'yav',
    'yao'                                              => 'yao',
    'yupiklanguage'                                    => 'ypk',
    'zande'                                            => 'znd',
    'zarma'                                            => 'dje',
    'zaza'                                             => 'zza',
    'zhuang'                                           => 'za',
    'zuni'                                             => 'zun',
    'אבחזית'                                     => 'ab',
    'אבסטן'                                       => 'ae',
    'אדיגית'                                     => 'ady',
    'אוגריתית'                                 => 'uga',
    'אוואדית'                                   => 'awa',
    'אוזבקית'                                   => 'uz',
    'אויגור'                                     => 'ug',
    'אוסטית'                                     => 'os',
    'אוסטרונזית'                             => 'map',
    'אוקסיטנית'                               => 'oc',
    'אוקראינית'                               => 'uk',
    'אורדו'                                       => 'ur',
    'אוריה'                                       => 'or',
    'אזרית'                                       => 'az',
    'איגבו'                                       => 'ig',
    'אידו'                                         => 'io',
    'איטלקית'                                   => 'it',
    'איימארית'                                 => 'ay',
    'אינגושית'                                 => 'inh',
    'אינדונזית'                               => 'id',
    'אינו'                                         => 'ain',
    'אינוקטיטוט'                             => 'iu',
    'אינטרלינגה'                             => 'ie',
    'איסלנדית'                                 => 'is',
    'אירית'                                       => 'ga',
    'איריתעתיקה'                             => 'sga',
    'איריתתיכונה'                           => 'mga',
    'אכדית'                                       => 'akk',
    'אלבנית'                                     => 'sq',
    'אמהרית'                                     => 'am',
    'אנגלית'                                     => 'en',
    'אנגליתאוסטרלית'                     => 'en_au',
    'אנגליתאמריקנית'                     => 'en_us',
    'אנגליתבריטית'                         => 'en_gb',
    'אנגליתעתיקה'                           => 'ang',
    'אנגליתקנדית'                           => 'en_ca',
    'אנגליתתיכונה'                         => 'enm',
    'אסאמית'                                     => 'as',
    'אסטונית'                                   => 'et',
    'אסטורית'                                   => 'ast',
    'אספרנטו'                                   => 'eo',
    'אפארית'                                     => 'aa',
    'אפיק'                                         => 'efi',
    'אפריהילי'                                 => 'afh',
    'אפריקאנס'                                 => 'af',
    'אקאן'                                         => 'ak',
    'ארומנית'                                   => 'rup',
    'ארמית'                                       => 'arc',
    'ארמיתשומרונית'                       => 'sam',
    'ארמנית'                                     => 'hy',
    'באלוצ׳י'                                   => 'bal',
    'בולגרית'                                   => 'bg',
    'בוסנית'                                     => 'bs',
    'בורמזית'                                   => 'my',
    'בז׳ה'                                         => 'bej',
    'ביהארי'                                     => 'bh',
    'ביסלמה'                                     => 'bi',
    'בלארוסית'                                 => 'be',
    'בלינזית'                                   => 'ban',
    'בנגלית'                                     => 'bn',
    'בנטו'                                         => 'bnt',
    'בסקית'                                       => 'eu',
    'ברברית'                                     => 'ber',
    'ברטונית'                                   => 'br',
    'בשקירית'                                   => 'ba',
    'גאליתסקוטית'                           => 'gd',
    'גוארני'                                     => 'gn',
    'גוג׳ראטית'                               => 'gu',
    'גונדי'                                       => 'gon',
    'גותית'                                       => 'got',
    'גיאורגית'                                 => 'ka',
    'גליציאנית'                               => 'gl',
    'געז'                                           => 'gez',
    'גרמנית'                                     => 'de',
    'גרמניתאוסטרית'                       => 'de_at',
    'גרמניתשוויצרית'                     => 'gsw',
    'גרמניתשוויצריתגבוהה'           => 'de_ch',
    'גרמניתתחתית'                           => 'nds',
    'ג׳ולוף'                                     => 'wo',
    'דוגרי'                                       => 'doi',
    'דזונקה'                                     => 'dz',
    'דיבהי'                                       => 'dv',
    'דלאוור'                                     => 'del',
    'דנית'                                         => 'da',
    'דקוטה'                                       => 'dak',
    'האוסה'                                       => 'ha',
    'האיטית'                                     => 'ht',
    'הארימוטו'                                 => 'ho',
    'הוואית'                                     => 'haw',
    'הולנדית'                                   => 'nl',
    'הולנדיתתיכונה'                       => 'dum',
    'הונגרית'                                   => 'hu',
    'הינדי'                                       => 'hi',
    'וולשית'                                     => 'cy',
    'וונדה'                                       => 've',
    'ויאטנמית'                                 => 'vi',
    'זאפוטק'                                     => 'zap',
    'זולו'                                         => 'zu',
    'זנאגה'                                       => 'zen',
    'חיתית'                                       => 'hit',
    'טגלוג'                                       => 'tl',
    'טג׳יקית'                                   => 'tg',
    'טהיטית'                                     => 'ty',
    'טווי'                                         => 'tw',
    'טונגאית'                                   => 'to',
    'טוקפיסין'                                 => 'tpi',
    'טורקית'                                     => 'tr',
    'טורקיתעותומנית'                     => 'ota',
    'טורקמנית'                                 => 'tk',
    'טטום'                                         => 'tet',
    'טטרית'                                       => 'tt',
    'טטריתשלקרים'                           => 'crh',
    'טיבטית'                                     => 'bo',
    'טיגרינאית'                               => 'ti',
    'טלוגו'                                       => 'te',
    'טמילית'                                     => 'ta',
    'טסונגה'                                     => 'ts',
    'יאוונית'                                   => 'jv',
    'יאפזית'                                     => 'yap',
    'יוונית'                                     => 'el',
    'יווניתעתיקה'                           => 'grc',
    'יורובה'                                     => 'yo',
    'יידיש'                                       => 'yi',
    'יפנית'                                       => 'ja',
    'כורדית'                                     => 'ku',
    'לאית'                                         => 'lo',
    'לאפיתצפונית'                           => 'se',
    'לדינו'                                       => 'lad',
    'לוקסמבורגית'                           => 'lb',
    'לטבית'                                       => 'lv',
    'לטינית'                                     => 'la',
    'ליטאית'                                     => 'lt',
    'לינגלה'                                     => 'ln',
    'ללאתוכןלשוני'                         => 'zxx',
    'מאגאהית'                                   => 'mag',
    'מאורית'                                     => 'mi',
    'מאיה'                                         => 'myn',
    'מאיטילית'                                 => 'mai',
    'מאנית'                                       => 'gv',
    'מאסאית'                                     => 'mas',
    'מולדבית'                                   => 'mo',
    'מונגולית'                                 => 'mn',
    'מלאיאלם'                                   => 'ml',
    'מלאית'                                       => 'ms',
    'מלגשית'                                     => 'mg',
    'מלטית'                                       => 'mt',
    'מניפורית'                                 => 'mni',
    'מספרשפות'                                 => 'mul',
    'מצריתעתיקה'                             => 'egy',
    'מקדונית'                                   => 'mk',
    'מרטהי'                                       => 'mr',
    'נאהואטל'                                   => 'nah',
    'נאורית'                                     => 'na',
    'נבחו'                                         => 'nv',
    'נוואריתקלאסית'                       => 'nwc',
    'נורבגית'                                   => 'no',
    'נורבגיתחדשה'                           => 'nn',
    'ניאנגה'                                     => 'ny',
    'נפאלית'                                     => 'ne',
    'נפוליטנית'                               => 'nap',
    'סאנטלי'                                     => 'sat',
    'סודנית'                                     => 'su',
    'סווהילית'                                 => 'sw',
    'סוטוהצפונית'                           => 'nso',
    'סומלית'                                     => 'so',
    'סורית'                                       => 'syr',
    'סידמו'                                       => 'sid',
    'סינדהית'                                   => 'sd',
    'סינהלה'                                     => 'si',
    'סינית'                                       => 'zh',
    'סיסוואטי'                                 => 'ss',
    'סיציליאנית'                             => 'scn',
    'סלאבית'                                     => 'den',
    'סלאביתכנסייתיתעתיקה'           => 'cu',
    'סלובנית'                                   => 'sl',
    'סלובקית'                                   => 'sk',
    'סמואית'                                     => 'sm',
    'סנגו'                                         => 'sg',
    'סנסקריט'                                   => 'sa',
    'ססות׳ו'                                     => 'st',
    'ספרדית'                                     => 'es',
    'ספרדיתאיברית'                         => 'es_es',
    'סקוטית'                                     => 'sco',
    'סרבוקרואטית'                           => 'sh',
    'סרבית'                                       => 'sr',
    'סרדינית'                                   => 'sc',
    'עברית'                                       => 'he',
    'עילמית'                                     => 'elx',
    'ערבית'                                       => 'ar',
    'ערביתיהודית'                           => 'jrb',
    'פארואזית'                                 => 'fo',
    'פולנית'                                     => 'pl',
    'פורטוגזיתברזילאית'               => 'pt_br',
    'פורטוגלית'                               => 'pt',
    'פורטוגליתאירופית'                 => 'pt_pt',
    'פושטו'                                       => 'ps',
    'פיג׳ית'                                     => 'fj',
    'פיליפינית'                               => 'fil',
    'פינית'                                       => 'fi',
    'פלמית'                                       => 'nl_be',
    'פנג׳אבית'                                 => 'pa',
    'פניקית'                                     => 'phn',
    'פריזית'                                     => 'fy',
    'פריזיתצפונית'                         => 'frr',
    'פרסית'                                       => 'fa',
    'פרסיתיהודית'                           => 'jpr',
    'פרסיתעתיקה'                             => 'peo',
    'צוואנה'                                     => 'tn',
    'צפוןנדבלה'                               => 'nd',
    'צרפתית'                                     => 'fr',
    'צרפתיתעתיקה'                           => 'fro',
    'צרפתיתקנדית'                           => 'fr_ca',
    'צרפתיתשוויצרית'                     => 'fr_ch',
    'צרפתיתתיכונה'                         => 'frm',
    'צ׳אגאטאי'                                 => 'chg',
    'צ׳כית'                                       => 'cs',
    'צ׳צ׳נית'                                   => 'ce',
    'צ׳רוקי'                                     => 'chr',
    'קאדו'                                         => 'cad',
    'קאלאליסוטית'                           => 'kl',
    'קבואנו'                                     => 'ceb',
    'קבילה'                                       => 'kab',
    'קומורו'                                     => 'swb',
    'קופטית'                                     => 'cop',
    'קוריאנית'                                 => 'ko',
    'קורנית'                                     => 'kw',
    'קורסיקנית'                               => 'co',
    'קזחית'                                       => 'kk',
    'קטלאנית'                                   => 'ca',
    'קינירואנדה'                             => 'rw',
    'קירגיזית'                                 => 'ky',
    'קירונדי'                                   => 'rn',
    'קלינגון'                                   => 'tlh',
    'קמרית'                                       => 'km',
    'קנאדה'                                       => 'kn',
    'קנטונזית'                                 => 'yue',
    'קסוסה'                                       => 'xh',
    'קצואה'                                       => 'qu',
    'קרואטית'                                   => 'hr',
    'קשמירית'                                   => 'ks',
    'ראג׳סטן'                                   => 'raj',
    'רומאנית'                                   => 'rom',
    'רומאנש'                                     => 'rm',
    'רומנית'                                     => 'ro',
    'רוסית'                                       => 'ru',
    'שוודית'                                     => 'sv',
    'שומרית'                                     => 'sux',
    'שונה'                                         => 'sn',
    'שפהאוסטרלית'                           => 'aus',
    'שפהאחרת'                                   => 'mis',
    'שפהאינדיאניתדרוםאמריקאית' => 'sai',
    'שפהאינדיאניתמרכזאמריקאית' => 'cai',
    'שפהאינדיאניתצפוןאמריקאית' => 'nai',
    'שפהאיראנית'                             => 'ira',
    'שפהאפאצ׳ית'                             => 'apa',
    'שפהאפרואסייתית'                     => 'afa',
    'שפהגרמאנית'                             => 'gem',
    'שפההודואירופית'                     => 'ine',
    'שפהלאידועהאולאתקפה'             => 'und',
    'שפהמלאכותית'                           => 'art',
    'שפהסינו־טיבטית'                     => 'sit',
    'שפהסלאבית'                               => 'sla',
    'שפהפיליפינית'                         => 'phi',
    'שפהקווקזית'                             => 'cau',
    'שפהקלטית'                                 => 'cel',
    'שפהקראוליתאופידג׳אנית'       => 'crp',
    'שפהשמית'                                   => 'sem',
    'שפותבלטיות'                             => 'bat',
    'שפותנבטיות'                             => 'nub',
    'שפתסאמי'                                   => 'smi',
    'שפתסימנים'                               => 'sgn',
    'תאי'                                           => 'th',
    '‏אינטרלינגואה'                      => 'ia',
    '‏וולאפיק'                                => 'vo',
    '‏נורבגיתספרותית'                  => 'nb',
    '‏נורדיתעתיקה'                        => 'non',
);

1;
