package Locales::DB::Language::nds;

# Auto generated from CLDR

$Locales::DB::Language::nds::VERSION = '0.07';

$Locales::DB::Language::nds::cldr_version = '2.0';

%Locales::DB::Language::nds::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => "\.",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Spraak\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ and\ \{1\}",
            'end'    => "\{0\}\,\ and\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0 \%",
        'territory' => "Region\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '‘',
        'alternate_quotation_start' => '‚',
        'quotation_end'             => '“',
        'quotation_start'           => '„'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list'  => [ 'other' ],
        'category_rules' => {}
    },
    'posix' => {
        'nostr' => {
            'content' => "nee\:n",
            'draft'   => 'unconfirmed'
        },
        'yesstr' => {
            'content' => "jo\:j",
            'draft'   => 'unconfirmed'
        }
    },
);

%Locales::DB::Language::nds::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abchaasch',
    'ace'   => 'Aceh',
    'ach'   => 'Acholi',
    'ada'   => 'Adangme',
    'ady'   => 'Adygeisch',
    'ae'    => 'Avestsch',
    'af'    => 'Afrikaansch',
    'afa'   => "Afro\-Asiaatsche\ Spraken",
    'afh'   => 'Afrihili',
    'agq'   => 'Aghem',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadsch',
    'ale'   => 'Aleutsch',
    'alg'   => "Algonkin\-Spraken",
    'alt'   => "Süüd\-Altaisch",
    'am'    => 'Amhaarsch',
    'an'    => 'Aragoneesch',
    'ang'   => 'Ooldengelsch',
    'anp'   => 'Angika',
    'apa'   => 'Apache',
    'ar'    => 'Araabsch',
    'arc'   => 'Aramääsch',
    'arn'   => 'Araukaansch',
    'arp'   => 'Arapaho',
    'art'   => 'Kunstspraken',
    'arw'   => "Arawak\-Spraken",
    'as'    => 'Assameesch',
    'asa'   => 'Asu',
    'ast'   => 'Asturiaansch',
    'ath'   => "Athabasksche\ Spraken",
    'aus'   => "Austraalsche\ Spraken",
    'av'    => 'Awaarsch',
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => 'Aserbaidschaansch',
    'ba'    => 'Baschkiersch',
    'bad'   => 'Banda',
    'bai'   => 'Bamileke',
    'bal'   => 'Belutschisch',
    'ban'   => 'Balineesch',
    'bas'   => 'Basaa',
    'bat'   => "Baltsche\ Spraken",
    'be'    => 'Wittruss’sch',
    'bej'   => 'Bedscha',
    'bem'   => 'Bemba',
    'ber'   => 'Berberspraken',
    'bez'   => 'Bena',
    'bg'    => 'Bulgaarsch',
    'bh'    => 'Bihaarsch',
    'bho'   => 'Bhodschpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'Bengaalsch',
    'bnt'   => 'Bantuspraken',
    'bo'    => 'Tibeetsch',
    'br'    => 'Bretoonsch',
    'bra'   => "Braj\-Bhakha",
    'brx'   => 'Bodo',
    'bs'    => 'Bosnisch',
    'btk'   => 'Batak',
    'bua'   => 'Burjaatsch',
    'bug'   => 'Bugineesch',
    'byn'   => 'Blin',
    'ca'    => 'Katalaansch',
    'cad'   => 'Caddo',
    'cai'   => "Indianerspraken\ in\ Zentralamerika",
    'car'   => "Kariebsche\ Spraken",
    'cau'   => "Kaukaasche\ Spraken",
    'cay'   => 'Cayuga',
    'cch'   => 'Atsam',
    'ce'    => 'Tschetscheensch',
    'ceb'   => 'Cebuano',
    'cel'   => "Keltsche\ Spraken",
    'cgg'   => 'Chiga',
    'ch'    => 'Chamorro',
    'chb'   => "Chibcha\-Spraken",
    'chg'   => 'Tschagataisch',
    'chk'   => 'Trukeesch',
    'chm'   => 'Mari',
    'chn'   => 'Chinook',
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Cham\-Spraken",
    'co'    => 'Koorsch',
    'cop'   => 'Koptsch',
    'cpe'   => "Kreoolsch\-Engelsche\ Spraken",
    'cpf'   => "Kreoolsch\-Franzöösche\ Spraken",
    'cpp'   => "Kreoolsch\-Portugeesche\ Spraken",
    'cr'    => 'Cree',
    'crh'   => 'Krimtataarsch',
    'crp'   => "Kreoolsche\ Spraken",
    'cs'    => 'Tschech’sch',
    'csb'   => 'Kaschuubsch',
    'cu'    => 'Karkenslaavsch',
    'cus'   => "Kuschietsche\ Spraken",
    'cv'    => 'Tschuwasch’sch',
    'cy'    => 'Waliesch',
    'da'    => 'Däänsch',
    'dak'   => 'Dakota',
    'dar'   => 'Dargiensch',
    'dav'   => 'Taita',
    'day'   => 'Dajak',
    'de'    => 'Düütsch',
    'de_at' => "Öösterrieksch\ Hoochdüütsch",
    'de_ch' => "Swiezer\ Hoochdüütsch",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'dje'   => 'Zarma',
    'doi'   => 'Dogri',
    'dra'   => "Drawiedsche\ Spraken",
    'dsb'   => 'Neddersorbsch',
    'dua'   => 'Duala',
    'dum'   => 'Middelnedderlandsch',
    'dv'    => 'Maledievsch',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'Dyula',
    'dz'    => 'Bhutaansch',
    'ebu'   => 'Embu',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => 'Ägyptsch',
    'eka'   => 'Ekajuk',
    'el'    => 'Greeksch',
    'elx'   => 'Elaamsch',
    'en'    => 'Engelsch',
    'en_au' => "Austraalsch\ Engelsch",
    'en_ca' => "Kanaadsch\ Engelsch",
    'en_gb' => "Brietsch\ Engelsch",
    'en_us' => "Amerikaansch\ Engelsch",
    'enm'   => 'Middelengelsch',
    'eo'    => 'Esperanto',
    'es'    => 'Spaansch',
    'es_es' => "Ibeersch\ Spaansch",
    'et'    => 'Eestnisch',
    'eu'    => 'Basksch',
    'ewo'   => 'Ewondo',
    'fa'    => 'Pers’sch',
    'fan'   => 'Pangwe',
    'fat'   => 'Fanti',
    'ff'    => 'Ful',
    'fi'    => 'Finnsch',
    'fil'   => 'Philippiensch',
    'fiu'   => "Finnougrische\ Spraken",
    'fj'    => 'Fidschiaansch',
    'fo'    => 'Färöösch',
    'fon'   => 'Fon',
    'fr'    => 'Franzöösch',
    'fr_ca' => "Kanaadsch\ Franzöösch",
    'fr_ch' => "Swiezer\ Franzöösch",
    'frm'   => 'Middelfranzöösch',
    'fro'   => 'Ooldfranzöösch',
    'frr'   => 'Noordfreesch',
    'frs'   => 'Saterfreesch',
    'fur'   => 'Friuulsch',
    'fy'    => 'Westfreesch',
    'ga'    => 'Iersch',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "Schottsch\ Gäälsch",
    'gem'   => "Germaansche\ Spraken",
    'gez'   => 'Geez',
    'gil'   => 'Gilberteesch',
    'gl'    => 'Galizisch',
    'gmh'   => 'Middelhoochdüütsch',
    'gn'    => 'Guarani',
    'goh'   => 'Ooldhoochdüütsch',
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gootsch',
    'grb'   => 'Grebo',
    'grc'   => 'Ooldgreeksch',
    'gsw'   => 'Swiezerdüütsch',
    'gu'    => 'Gujarati',
    'guz'   => 'Gusii',
    'gv'    => 'Manx',
    'gwi'   => 'Kutchin',
    'ha'    => 'Haussa',
    'hai'   => 'Haida',
    'haw'   => 'Hawaiiaansch',
    'he'    => 'Hebrääsch',
    'hi'    => 'Hindi',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hethitsch',
    'hmn'   => "Miao\-Spraken",
    'ho'    => "Hiri\-Motu",
    'hr'    => 'Kroaatsch',
    'hsb'   => 'Böversorbsch',
    'ht'    => "Haitiaansch\-Kreoolsch",
    'hu'    => 'Ungaarsch',
    'hup'   => 'Hupa',
    'hy'    => 'Armeensch',
    'hz'    => 'Herero',
    'ia'    => 'Interlingua',
    'iba'   => 'Iban',
    'id'    => 'Indoneesch',
    'ie'    => 'Interlingue',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiak',
    'ilo'   => 'Ilokano',
    'inc'   => "Indoarische\ Spraken",
    'ine'   => "Indogermaansche\ Spraken",
    'inh'   => 'Ingusch’sch',
    'io'    => 'Ido',
    'ira'   => "Iraansche\ Spraken",
    'iro'   => "Irokeesche\ Spraken",
    'is'    => 'Ieslandsch',
    'it'    => 'Italieensch',
    'iu'    => 'Inuktitut',
    'ja'    => 'Japaansch',
    'jbo'   => 'Lojban',
    'jmc'   => 'Machame',
    'jpr'   => "Jöödsch\-Pers’sch",
    'jrb'   => "Jöödsch\-Araabsch",
    'jv'    => 'Javaansch',
    'ka'    => 'Georgsch',
    'kaa'   => 'Karakalpaksch',
    'kab'   => 'Kabyylsch',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Kareensch',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardiensch',
    'kcg'   => 'Tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\-Spraken",
    'kho'   => 'Saaksch',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'Kikuyu',
    'kj'    => 'Kwanyama',
    'kk'    => 'Kasach’sch',
    'kl'    => 'Gröönlandsch',
    'kln'   => 'Kalenjin',
    'km'    => 'Kambodschaansch',
    'kmb'   => 'Kimbundu',
    'kn'    => 'Kannada',
    'ko'    => 'Koreaansch',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraeaansch',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuursch',
    'krc'   => "Karatschaisch\-Balkaarsch",
    'krl'   => 'Kareelsch',
    'kro'   => "Kru\-Spraken",
    'kru'   => 'Oraon',
    'ks'    => 'Kaschmiersch',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'Kurdsch',
    'kum'   => 'Kumücksch',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Koornsch',
    'ky'    => 'Kirgiesch',
    'la'    => 'Latiensch',
    'lad'   => 'Ladiensch',
    'lag'   => 'Langi',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxemborgsch',
    'lez'   => 'Lesgisch',
    'lg'    => 'Ganda',
    'li'    => 'Limborgsch',
    'ln'    => 'Lingala',
    'lo'    => 'Laootsch',
    'lol'   => 'Mongo',
    'loz'   => 'Rotse',
    'lt'    => 'Litausch',
    'lu'    => 'Luba',
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'luy'   => 'Luyia',
    'lv'    => 'Lettsch',
    'mad'   => 'Madureesch',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makassarsch',
    'man'   => 'Manding',
    'map'   => "Austroneesche\ Spraken",
    'mas'   => 'Massai',
    'mdf'   => 'Mokscha',
    'mdr'   => 'Mandareesch',
    'men'   => 'Mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'Madagassisch',
    'mga'   => 'Middeliersch',
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'Marschalleesch',
    'mi'    => 'Maori',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Verschedene\ Spraken",
    'mk'    => 'Mazedoonsch',
    'mkh'   => "Mon\-Khmer\-Spraken",
    'ml'    => 'Malayalam',
    'mn'    => 'Mongoolsch',
    'mnc'   => 'Mandschuursch',
    'mni'   => 'Manipuri',
    'mno'   => 'Manobo',
    'mo'    => 'Moldaawsch',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'Marathi',
    'ms'    => 'Malaisch',
    'mt'    => 'Malteesch',
    'mua'   => 'Mundang',
    'mul'   => 'Mehrsprakig',
    'mun'   => "Munda\-Spraken",
    'mus'   => "Muskogee\-Spraken",
    'mwl'   => 'Mirandeesch',
    'mwr'   => 'Marwari',
    'my'    => 'Birmaansch',
    'myn'   => "Maya\-Spraken",
    'myv'   => 'Erzya',
    'na'    => 'Nauruusch',
    'nah'   => 'Nahuatl',
    'nai'   => "Indianerspraken\ in\ Noordamerika",
    'nap'   => 'Neapolitaansch',
    'naq'   => 'Nama',
    'nb'    => "Norweegsch\ Bokmål",
    'nd'    => "Noord\-Ndebele",
    'nds'   => 'Plattdüütsch',
    'ne'    => 'Nepaleesch',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Nigerkordofaansche\ Spraken",
    'niu'   => 'Niue',
    'nl'    => 'Nedderlandsch',
    'nl_be' => 'Fläämsch',
    'nmg'   => 'Kwasio',
    'nn'    => "Norweegsch\ Nynorsk",
    'no'    => 'Norweegsch',
    'nog'   => 'Nogai',
    'non'   => 'Ooldnoorsch',
    'nqo'   => 'N’Ko',
    'nr'    => "Süüd\-Ndebele",
    'nso'   => "Noord\-Sotho",
    'nub'   => "Nuubsche\ Spraken",
    'nus'   => 'Nuer',
    'nv'    => 'Navajo',
    'nwc'   => "Oold\-Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'Okzitaansch',
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'Orija',
    'os'    => 'Ossetsch',
    'osa'   => 'Osage',
    'ota'   => 'Osmaansch',
    'oto'   => "Otomangue\-Spraken",
    'pa'    => 'Pandschabsch',
    'paa'   => 'Papuaspraken',
    'pag'   => 'Pangasinan',
    'pal'   => 'Middelpers’sch',
    'pam'   => 'Pampanggan',
    'pap'   => 'Papiamento',
    'pau'   => 'Palausch',
    'peo'   => 'Ooldpers’sch',
    'phi'   => "Philippinen\-Austroneesche\ Spraken",
    'phn'   => 'Phönieksch',
    'pi'    => 'Pali',
    'pl'    => 'Poolsch',
    'pon'   => 'Ponapeaansch',
    'pra'   => 'Prakrit',
    'pro'   => 'Ooldprovenzaalsch',
    'ps'    => 'Paschtu',
    'pt'    => 'Portugeesch',
    'pt_br' => "Brasiliaansch\ Portugeesch",
    'pt_pt' => "Ibeersch\ Portugeesch",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => "Oosterinsel\-Spraak",
    'rar'   => 'Rarotongaansch',
    'rm'    => 'Rätoromaansch',
    'rn'    => 'Rundi',
    'ro'    => 'Rumäänsch',
    'roa'   => "Romaansche\ Spraken",
    'rof'   => 'Rombo',
    'rom'   => 'Romani',
    'ru'    => 'Russ’sch',
    'rup'   => 'Aromuunsch',
    'rw'    => 'Ruandsch',
    'rwk'   => 'Rwa',
    'sa'    => 'Sanskrit',
    'sad'   => 'Sandawe',
    'sah'   => 'Jakuutsch',
    'sai'   => "Indianerspraken\ in\ Süüdamerika",
    'sal'   => 'Salish',
    'sam'   => 'Samaritaansch',
    'saq'   => 'Samburu',
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sbp'   => 'Sangu',
    'sc'    => 'Sardsch',
    'scn'   => 'Siziliaansch',
    'sco'   => 'Schottsch',
    'sd'    => 'Sindhi',
    'se'    => "Noord\-Saamsch",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'Selkupsch',
    'sem'   => "Semietsche\ Spraken",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'Sango',
    'sga'   => "Oold\-Iersch",
    'sgn'   => 'Tekenspraken',
    'sh'    => "Serbo\-Croatian",
    'shi'   => 'Tachelhit',
    'shn'   => 'Schan',
    'si'    => 'Singhaleesch',
    'sid'   => 'Sidamo',
    'sio'   => "Sioux\-Spraken",
    'sit'   => "Sinotibeetsche\ Spraken",
    'sk'    => 'Slowaaksch',
    'sl'    => 'Sloweensch',
    'sla'   => "Slaavsche\ Spraken",
    'sm'    => 'Samoaansch',
    'sma'   => "Süüd\-Lappsch",
    'smi'   => 'Lappsch',
    'smj'   => "Lule\-Lappsch",
    'smn'   => "Inari\-Lappsch",
    'sms'   => "Skolt\-Lappsch",
    'sn'    => 'Schona',
    'snk'   => 'Soninke',
    'so'    => 'Somaalsch',
    'sog'   => 'Sogdisch',
    'son'   => 'Songhai',
    'sq'    => 'Albaansch',
    'sr'    => 'Serbsch',
    'srn'   => 'Surinaamsch',
    'srr'   => 'Serer',
    'ss'    => 'Swazi',
    'ssa'   => "Nilosaharaansche\ Spraken",
    'ssy'   => 'Saho',
    'st'    => "Süüd\-Sotho",
    'su'    => 'Sundaneesch',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumersch',
    'sv'    => 'Sweedsch',
    'sw'    => 'Suaheli',
    'swb'   => 'Comorian',
    'swc'   => "Congo\ Swahili",
    'syc'   => "Oold\-Syyrsch",
    'syr'   => 'Syyrsch',
    'ta'    => 'Tamilsch',
    'tai'   => 'Thaispraken',
    'te'    => 'Telugu',
    'tem'   => 'Temne',
    'teo'   => 'Teso',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'Tadschiksch',
    'th'    => 'Thai',
    'ti'    => 'Tigrinja',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'Turkmeensch',
    'tkl'   => 'Tokelausch',
    'tl'    => 'Tagalog',
    'tlh'   => 'Klingoonsch',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamaschek',
    'tn'    => 'Tswana',
    'to'    => 'Tongaasch',
    'tog'   => "Tonga\ \(Nyasa\)",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'Törksch',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tataarsch',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\-Spraken",
    'tut'   => "Altaische\ Spraken",
    'tvl'   => 'Elliceaansch',
    'tw'    => 'Twi',
    'twq'   => 'Tasawaq',
    'ty'    => 'Tahitsch',
    'tyv'   => 'Tuwinsch',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'Udmurtsch',
    'ug'    => 'Uiguursch',
    'uga'   => 'Ugaritsch',
    'uk'    => 'Ukrainsch',
    'umb'   => 'Mbundu',
    'und'   => "Unbestimmte\ Spraak",
    'ur'    => 'Urdu',
    'uz'    => 'Usbeeksch',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'Vietnameesch',
    'vo'    => 'Volapük',
    'vot'   => 'Wootsch',
    'vun'   => 'Vunjo',
    'wa'    => 'Walloonsch',
    'wae'   => 'Walser',
    'wak'   => 'Wakashaansch',
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => 'Sorbsch',
    'wo'    => 'Wolof',
    'xal'   => 'Kalmücksch',
    'xh'    => 'Xhosa',
    'xog'   => 'Soga',
    'yao'   => 'Yao',
    'yap'   => 'Yapeesch',
    'yav'   => 'Yangben',
    'yi'    => 'Jiddisch',
    'yo'    => 'Yoruba',
    'ypk'   => 'Yupik',
    'yue'   => 'Cantonese',
    'za'    => 'Zhuang',
    'zap'   => 'Zapoteeksch',
    'zbl'   => "Bliss\-Symbolen",
    'zen'   => 'Zenaga',
    'zh'    => 'Chineesch',
    'znd'   => 'Zande',
    'zu'    => 'Zulu',
    'zun'   => 'Zuni',
    'zxx'   => "Keen\ Spraakinhold",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::nds::name_to_code = (
    'abchaasch'                       => 'ab',
    'aceh'                            => 'ace',
    'acholi'                          => 'ach',
    'adangme'                         => 'ada',
    'adygeisch'                       => 'ady',
    'afar'                            => 'aa',
    'afrihili'                        => 'afh',
    'afrikaansch'                     => 'af',
    'afroasiaatschespraken'           => 'afa',
    'aghem'                           => 'agq',
    'ainu'                            => 'ain',
    'akan'                            => 'ak',
    'akkadsch'                        => 'akk',
    'albaansch'                       => 'sq',
    'aleutsch'                        => 'ale',
    'algonkinspraken'                 => 'alg',
    'altaischespraken'                => 'tut',
    'amerikaanschengelsch'            => 'en_us',
    'amhaarsch'                       => 'am',
    'angika'                          => 'anp',
    'apache'                          => 'apa',
    'araabsch'                        => 'ar',
    'aragoneesch'                     => 'an',
    'aramääsch'                     => 'arc',
    'arapaho'                         => 'arp',
    'araukaansch'                     => 'arn',
    'arawakspraken'                   => 'arw',
    'armeensch'                       => 'hy',
    'aromuunsch'                      => 'rup',
    'aserbaidschaansch'               => 'az',
    'assameesch'                      => 'as',
    'asturiaansch'                    => 'ast',
    'asu'                             => 'asa',
    'athabaskschespraken'             => 'ath',
    'atsam'                           => 'cch',
    'austraalschengelsch'             => 'en_au',
    'austraalschespraken'             => 'aus',
    'austroneeschespraken'            => 'map',
    'avestsch'                        => 'ae',
    'awaarsch'                        => 'av',
    'awadhi'                          => 'awa',
    'aymara'                          => 'ay',
    'bafia'                           => 'ksf',
    'balineesch'                      => 'ban',
    'baltschespraken'                 => 'bat',
    'bambara'                         => 'bm',
    'bamileke'                        => 'bai',
    'banda'                           => 'bad',
    'bantuspraken'                    => 'bnt',
    'basaa'                           => 'bas',
    'baschkiersch'                    => 'ba',
    'basksch'                         => 'eu',
    'batak'                           => 'btk',
    'bedscha'                         => 'bej',
    'belutschisch'                    => 'bal',
    'bemba'                           => 'bem',
    'bena'                            => 'bez',
    'bengaalsch'                      => 'bn',
    'berberspraken'                   => 'ber',
    'bhodschpuri'                     => 'bho',
    'bhutaansch'                      => 'dz',
    'bihaarsch'                       => 'bh',
    'bikol'                           => 'bik',
    'bini'                            => 'bin',
    'birmaansch'                      => 'my',
    'bislama'                         => 'bi',
    'blin'                            => 'byn',
    'blisssymbolen'                   => 'zbl',
    'bodo'                            => 'brx',
    'bosnisch'                        => 'bs',
    'brajbhakha'                      => 'bra',
    'brasiliaanschportugeesch'        => 'pt_br',
    'bretoonsch'                      => 'br',
    'brietschengelsch'                => 'en_gb',
    'bugineesch'                      => 'bug',
    'bulgaarsch'                      => 'bg',
    'burjaatsch'                      => 'bua',
    'böversorbsch'                   => 'hsb',
    'caddo'                           => 'cad',
    'cantonese'                       => 'yue',
    'cayuga'                          => 'cay',
    'cebuano'                         => 'ceb',
    'centralmoroccotamazight'         => 'tzm',
    'chamorro'                        => 'ch',
    'chamspraken'                     => 'cmc',
    'cherokee'                        => 'chr',
    'cheyenne'                        => 'chy',
    'chibchaspraken'                  => 'chb',
    'chiga'                           => 'cgg',
    'chineesch'                       => 'zh',
    'chinook'                         => 'chn',
    'chipewyan'                       => 'chp',
    'choctaw'                         => 'cho',
    'colognian'                       => 'ksh',
    'comorian'                        => 'swb',
    'congoswahili'                    => 'swc',
    'cree'                            => 'cr',
    'dajak'                           => 'day',
    'dakota'                          => 'dak',
    'dargiensch'                      => 'dar',
    'delaware'                        => 'del',
    'dinka'                           => 'din',
    'dogri'                           => 'doi',
    'dogrib'                          => 'dgr',
    'drawiedschespraken'              => 'dra',
    'duala'                           => 'dua',
    'dyula'                           => 'dyu',
    'däänsch'                       => 'da',
    'düütsch'                       => 'de',
    'eestnisch'                       => 'et',
    'efik'                            => 'efi',
    'ekajuk'                          => 'eka',
    'elaamsch'                        => 'elx',
    'elliceaansch'                    => 'tvl',
    'embu'                            => 'ebu',
    'engelsch'                        => 'en',
    'erzya'                           => 'myv',
    'esperanto'                       => 'eo',
    'ewe'                             => 'ee',
    'ewondo'                          => 'ewo',
    'fanti'                           => 'fat',
    'fidschiaansch'                   => 'fj',
    'finnougrischespraken'            => 'fiu',
    'finnsch'                         => 'fi',
    'fläämsch'                      => 'nl_be',
    'fon'                             => 'fon',
    'franzöösch'                    => 'fr',
    'friuulsch'                       => 'fur',
    'ful'                             => 'ff',
    'färöösch'                     => 'fo',
    'ga'                              => 'gaa',
    'galizisch'                       => 'gl',
    'ganda'                           => 'lg',
    'gayo'                            => 'gay',
    'gbaya'                           => 'gba',
    'geez'                            => 'gez',
    'georgsch'                        => 'ka',
    'germaanschespraken'              => 'gem',
    'gilberteesch'                    => 'gil',
    'gondi'                           => 'gon',
    'gootsch'                         => 'got',
    'gorontalo'                       => 'gor',
    'grebo'                           => 'grb',
    'greeksch'                        => 'el',
    'gröönlandsch'                  => 'kl',
    'guarani'                         => 'gn',
    'gujarati'                        => 'gu',
    'gusii'                           => 'guz',
    'haida'                           => 'hai',
    'haitiaanschkreoolsch'            => 'ht',
    'haussa'                          => 'ha',
    'hawaiiaansch'                    => 'haw',
    'hebrääsch'                     => 'he',
    'herero'                          => 'hz',
    'hethitsch'                       => 'hit',
    'hiligaynon'                      => 'hil',
    'himachali'                       => 'him',
    'hindi'                           => 'hi',
    'hirimotu'                        => 'ho',
    'hupa'                            => 'hup',
    'iban'                            => 'iba',
    'ibeerschportugeesch'             => 'pt_pt',
    'ibeerschspaansch'                => 'es_es',
    'ido'                             => 'io',
    'iersch'                          => 'ga',
    'ieslandsch'                      => 'is',
    'igbo'                            => 'ig',
    'ijo'                             => 'ijo',
    'ilokano'                         => 'ilo',
    'inarilappsch'                    => 'smn',
    'indianersprakeninnoordamerika'   => 'nai',
    'indianersprakeninsüüdamerika'  => 'sai',
    'indianersprakeninzentralamerika' => 'cai',
    'indoarischespraken'              => 'inc',
    'indogermaanschespraken'          => 'ine',
    'indoneesch'                      => 'id',
    'ingusch’sch'                   => 'inh',
    'interlingua'                     => 'ia',
    'interlingue'                     => 'ie',
    'inuktitut'                       => 'iu',
    'inupiak'                         => 'ik',
    'iraanschespraken'                => 'ira',
    'irokeeschespraken'               => 'iro',
    'italieensch'                     => 'it',
    'jakuutsch'                       => 'sah',
    'japaansch'                       => 'ja',
    'javaansch'                       => 'jv',
    'jiddisch'                        => 'yi',
    'jju'                             => 'kaj',
    'jolafonyi'                       => 'dyo',
    'jöödscharaabsch'               => 'jrb',
    'jöödschpers’sch'             => 'jpr',
    'kabardiensch'                    => 'kbd',
    'kabuverdianu'                    => 'kea',
    'kabyylsch'                       => 'kab',
    'kachin'                          => 'kac',
    'kalenjin'                        => 'kln',
    'kalmücksch'                     => 'xal',
    'kamba'                           => 'kam',
    'kambodschaansch'                 => 'km',
    'kanaadschengelsch'               => 'en_ca',
    'kanaadschfranzöösch'           => 'fr_ca',
    'kannada'                         => 'kn',
    'kanuursch'                       => 'kr',
    'karakalpaksch'                   => 'kaa',
    'karatschaischbalkaarsch'         => 'krc',
    'kareelsch'                       => 'krl',
    'kareensch'                       => 'kar',
    'kariebschespraken'               => 'car',
    'karkenslaavsch'                  => 'cu',
    'kasach’sch'                    => 'kk',
    'kaschmiersch'                    => 'ks',
    'kaschuubsch'                     => 'csb',
    'katalaansch'                     => 'ca',
    'kaukaaschespraken'               => 'cau',
    'kawi'                            => 'kaw',
    'keenspraakinhold'                => 'zxx',
    'keltschespraken'                 => 'cel',
    'khasi'                           => 'kha',
    'khoisanspraken'                  => 'khi',
    'kikuyu'                          => 'ki',
    'kimbundu'                        => 'kmb',
    'kirgiesch'                       => 'ky',
    'klingoonsch'                     => 'tlh',
    'komi'                            => 'kv',
    'kongo'                           => 'kg',
    'konkani'                         => 'kok',
    'koornsch'                        => 'kw',
    'koorsch'                         => 'co',
    'koptsch'                         => 'cop',
    'koreaansch'                      => 'ko',
    'koro'                            => 'kfo',
    'kosraeaansch'                    => 'kos',
    'koyraborosenni'                  => 'ses',
    'koyrachiini'                     => 'khq',
    'kpelle'                          => 'kpe',
    'kreoolschengelschespraken'       => 'cpe',
    'kreoolschespraken'               => 'crp',
    'kreoolschfranzööschespraken'   => 'cpf',
    'kreoolschportugeeschespraken'    => 'cpp',
    'krimtataarsch'                   => 'crh',
    'kroaatsch'                       => 'hr',
    'kruspraken'                      => 'kro',
    'kumücksch'                      => 'kum',
    'kunstspraken'                    => 'art',
    'kurdsch'                         => 'ku',
    'kuschietschespraken'             => 'cus',
    'kutchin'                         => 'gwi',
    'kutenai'                         => 'kut',
    'kwanyama'                        => 'kj',
    'kwasio'                          => 'nmg',
    'ladiensch'                       => 'lad',
    'lahnda'                          => 'lah',
    'lamba'                           => 'lam',
    'langi'                           => 'lag',
    'laootsch'                        => 'lo',
    'lappsch'                         => 'smi',
    'latiensch'                       => 'la',
    'lesgisch'                        => 'lez',
    'lettsch'                         => 'lv',
    'limborgsch'                      => 'li',
    'lingala'                         => 'ln',
    'litausch'                        => 'lt',
    'lojban'                          => 'jbo',
    'luba'                            => 'lu',
    'lubalulua'                       => 'lua',
    'luiseno'                         => 'lui',
    'lulelappsch'                     => 'smj',
    'lunda'                           => 'lun',
    'luo'                             => 'luo',
    'lushai'                          => 'lus',
    'luxemborgsch'                    => 'lb',
    'luyia'                           => 'luy',
    'machame'                         => 'jmc',
    'madagassisch'                    => 'mg',
    'madureesch'                      => 'mad',
    'magahi'                          => 'mag',
    'maithili'                        => 'mai',
    'makassarsch'                     => 'mak',
    'makhuwameetto'                   => 'mgh',
    'makonde'                         => 'kde',
    'malaisch'                        => 'ms',
    'malayalam'                       => 'ml',
    'maledievsch'                     => 'dv',
    'malteesch'                       => 'mt',
    'mandareesch'                     => 'mdr',
    'manding'                         => 'man',
    'mandschuursch'                   => 'mnc',
    'manipuri'                        => 'mni',
    'manobo'                          => 'mno',
    'manx'                            => 'gv',
    'maori'                           => 'mi',
    'marathi'                         => 'mr',
    'mari'                            => 'chm',
    'marschalleesch'                  => 'mh',
    'marwari'                         => 'mwr',
    'massai'                          => 'mas',
    'mayaspraken'                     => 'myn',
    'mazedoonsch'                     => 'mk',
    'mbundu'                          => 'umb',
    'mehrsprakig'                     => 'mul',
    'mende'                           => 'men',
    'meru'                            => 'mer',
    'miaospraken'                     => 'hmn',
    'micmac'                          => 'mic',
    'middelengelsch'                  => 'enm',
    'middelfranzöösch'              => 'frm',
    'middelhoochdüütsch'            => 'gmh',
    'middeliersch'                    => 'mga',
    'middelnedderlandsch'             => 'dum',
    'middelpers’sch'                => 'pal',
    'minangkabau'                     => 'min',
    'mirandeesch'                     => 'mwl',
    'mohawk'                          => 'moh',
    'mokscha'                         => 'mdf',
    'moldaawsch'                      => 'mo',
    'mongo'                           => 'lol',
    'mongoolsch'                      => 'mn',
    'monkhmerspraken'                 => 'mkh',
    'morisyen'                        => 'mfe',
    'mossi'                           => 'mos',
    'mundang'                         => 'mua',
    'mundaspraken'                    => 'mun',
    'muskogeespraken'                 => 'mus',
    'nahuatl'                         => 'nah',
    'nama'                            => 'naq',
    'nauruusch'                       => 'na',
    'navajo'                          => 'nv',
    'ndonga'                          => 'ng',
    'neapolitaansch'                  => 'nap',
    'nedderlandsch'                   => 'nl',
    'neddersorbsch'                   => 'dsb',
    'nepaleesch'                      => 'ne',
    'newari'                          => 'new',
    'nias'                            => 'nia',
    'nigerkordofaanschespraken'       => 'nic',
    'nilosaharaanschespraken'         => 'ssa',
    'niue'                            => 'niu',
    'nogai'                           => 'nog',
    'noordfreesch'                    => 'frr',
    'noordndebele'                    => 'nd',
    'noordsaamsch'                    => 'se',
    'noordsotho'                      => 'nso',
    'norweegsch'                      => 'no',
    'norweegschbokmål'               => 'nb',
    'norweegschnynorsk'               => 'nn',
    'nuer'                            => 'nus',
    'nuubschespraken'                 => 'nub',
    'nyamwezi'                        => 'nym',
    'nyanja'                          => 'ny',
    'nyankole'                        => 'nyn',
    'nyoro'                           => 'nyo',
    'nzima'                           => 'nzi',
    'n’ko'                          => 'nqo',
    'ojibwa'                          => 'oj',
    'okzitaansch'                     => 'oc',
    'ooldengelsch'                    => 'ang',
    'ooldfranzöösch'                => 'fro',
    'ooldgreeksch'                    => 'grc',
    'ooldhoochdüütsch'              => 'goh',
    'ooldiersch'                      => 'sga',
    'ooldnewari'                      => 'nwc',
    'ooldnoorsch'                     => 'non',
    'ooldpers’sch'                  => 'peo',
    'ooldprovenzaalsch'               => 'pro',
    'ooldsyyrsch'                     => 'syc',
    'oosterinselspraak'               => 'rap',
    'oraon'                           => 'kru',
    'orija'                           => 'or',
    'oromo'                           => 'om',
    'osage'                           => 'osa',
    'osmaansch'                       => 'ota',
    'ossetsch'                        => 'os',
    'otomanguespraken'                => 'oto',
    'palausch'                        => 'pau',
    'pali'                            => 'pi',
    'pampanggan'                      => 'pam',
    'pandschabsch'                    => 'pa',
    'pangasinan'                      => 'pag',
    'pangwe'                          => 'fan',
    'papiamento'                      => 'pap',
    'papuaspraken'                    => 'paa',
    'paschtu'                         => 'ps',
    'pers’sch'                      => 'fa',
    'philippiensch'                   => 'fil',
    'philippinenaustroneeschespraken' => 'phi',
    'phönieksch'                     => 'phn',
    'plattdüütsch'                  => 'nds',
    'ponapeaansch'                    => 'pon',
    'poolsch'                         => 'pl',
    'portugeesch'                     => 'pt',
    'prakrit'                         => 'pra',
    'quechua'                         => 'qu',
    'rajasthani'                      => 'raj',
    'rarotongaansch'                  => 'rar',
    'romaanschespraken'               => 'roa',
    'romani'                          => 'rom',
    'rombo'                           => 'rof',
    'rotse'                           => 'loz',
    'ruandsch'                        => 'rw',
    'rumäänsch'                     => 'ro',
    'rundi'                           => 'rn',
    'russ’sch'                      => 'ru',
    'rwa'                             => 'rwk',
    'rätoromaansch'                  => 'rm',
    'saaksch'                         => 'kho',
    'saho'                            => 'ssy',
    'salish'                          => 'sal',
    'samaritaansch'                   => 'sam',
    'samburu'                         => 'saq',
    'samoaansch'                      => 'sm',
    'sandawe'                         => 'sad',
    'sango'                           => 'sg',
    'sangu'                           => 'sbp',
    'sanskrit'                        => 'sa',
    'santali'                         => 'sat',
    'sardsch'                         => 'sc',
    'sasak'                           => 'sas',
    'saterfreesch'                    => 'frs',
    'schan'                           => 'shn',
    'schona'                          => 'sn',
    'schottsch'                       => 'sco',
    'schottschgäälsch'              => 'gd',
    'selkupsch'                       => 'sel',
    'semietschespraken'               => 'sem',
    'sena'                            => 'seh',
    'seneca'                          => 'see',
    'serbocroatian'                   => 'sh',
    'serbsch'                         => 'sr',
    'serer'                           => 'srr',
    'shambala'                        => 'ksb',
    'sichuanyi'                       => 'ii',
    'sidamo'                          => 'sid',
    'siksika'                         => 'bla',
    'sindhi'                          => 'sd',
    'singhaleesch'                    => 'si',
    'sinotibeetschespraken'           => 'sit',
    'siouxspraken'                    => 'sio',
    'siziliaansch'                    => 'scn',
    'skoltlappsch'                    => 'sms',
    'slaavschespraken'                => 'sla',
    'slave'                           => 'den',
    'slowaaksch'                      => 'sk',
    'sloweensch'                      => 'sl',
    'soga'                            => 'xog',
    'sogdisch'                        => 'sog',
    'somaalsch'                       => 'so',
    'songhai'                         => 'son',
    'soninke'                         => 'snk',
    'sorbsch'                         => 'wen',
    'spaansch'                        => 'es',
    'suaheli'                         => 'sw',
    'sukuma'                          => 'suk',
    'sumersch'                        => 'sux',
    'sundaneesch'                     => 'su',
    'surinaamsch'                     => 'srn',
    'susu'                            => 'sus',
    'swazi'                           => 'ss',
    'sweedsch'                        => 'sv',
    'swiezerdüütsch'                => 'gsw',
    'swiezerfranzöösch'             => 'fr_ch',
    'swiezerhoochdüütsch'           => 'de_ch',
    'syyrsch'                         => 'syr',
    'süüdaltaisch'                  => 'alt',
    'süüdlappsch'                   => 'sma',
    'süüdndebele'                   => 'nr',
    'süüdsotho'                     => 'st',
    'tachelhit'                       => 'shi',
    'tadschiksch'                     => 'tg',
    'tagalog'                         => 'tl',
    'tahitsch'                        => 'ty',
    'taita'                           => 'dav',
    'tamaschek'                       => 'tmh',
    'tamilsch'                        => 'ta',
    'taroko'                          => 'trv',
    'tasawaq'                         => 'twq',
    'tataarsch'                       => 'tt',
    'tekenspraken'                    => 'sgn',
    'telugu'                          => 'te',
    'temne'                           => 'tem',
    'tereno'                          => 'ter',
    'teso'                            => 'teo',
    'tetum'                           => 'tet',
    'thai'                            => 'th',
    'thaispraken'                     => 'tai',
    'tibeetsch'                       => 'bo',
    'tigre'                           => 'tig',
    'tigrinja'                        => 'ti',
    'tiv'                             => 'tiv',
    'tlingit'                         => 'tli',
    'tokelausch'                      => 'tkl',
    'tokpisin'                        => 'tpi',
    'tongaasch'                       => 'to',
    'tonganyasa'                      => 'tog',
    'trukeesch'                       => 'chk',
    'tschagataisch'                   => 'chg',
    'tschech’sch'                   => 'cs',
    'tschetscheensch'                 => 'ce',
    'tschuwasch’sch'                => 'cv',
    'tsimshian'                       => 'tsi',
    'tsonga'                          => 'ts',
    'tswana'                          => 'tn',
    'tumbuka'                         => 'tum',
    'tupispraken'                     => 'tup',
    'turkmeensch'                     => 'tk',
    'tuwinsch'                        => 'tyv',
    'twi'                             => 'tw',
    'tyap'                            => 'kcg',
    'törksch'                        => 'tr',
    'udmurtsch'                       => 'udm',
    'ugaritsch'                       => 'uga',
    'uiguursch'                       => 'ug',
    'ukrainsch'                       => 'uk',
    'unbestimmtespraak'               => 'und',
    'ungaarsch'                       => 'hu',
    'urdu'                            => 'ur',
    'usbeeksch'                       => 'uz',
    'vai'                             => 'vai',
    'venda'                           => 've',
    'verschedenespraken'              => 'mis',
    'vietnameesch'                    => 'vi',
    'volapük'                        => 'vo',
    'vunjo'                           => 'vun',
    'wakashaansch'                    => 'wak',
    'walamo'                          => 'wal',
    'waliesch'                        => 'cy',
    'walloonsch'                      => 'wa',
    'walser'                          => 'wae',
    'waray'                           => 'war',
    'washo'                           => 'was',
    'westfreesch'                     => 'fy',
    'wittruss’sch'                  => 'be',
    'wolof'                           => 'wo',
    'wootsch'                         => 'vot',
    'xhosa'                           => 'xh',
    'yangben'                         => 'yav',
    'yao'                             => 'yao',
    'yapeesch'                        => 'yap',
    'yoruba'                          => 'yo',
    'yupik'                           => 'ypk',
    'zande'                           => 'znd',
    'zapoteeksch'                     => 'zap',
    'zarma'                           => 'dje',
    'zaza'                            => 'zza',
    'zenaga'                          => 'zen',
    'zhuang'                          => 'za',
    'zulu'                            => 'zu',
    'zuni'                            => 'zun',
    'Ägyptsch'                       => 'egy',
    'Öösterriekschhoochdüütsch'   => 'de_at',
);

1;
