package Locales::DB::Language::ku;

# Auto generated from CLDR

$Locales::DB::Language::ku::VERSION = '0.07';

$Locales::DB::Language::ku::cldr_version = '2.0';

%Locales::DB::Language::ku::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => '٪',
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "زمان\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ and\ \{1\}",
            'end'    => "\{0\}\,\ and\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "ناوچە\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => "\â\\",
        'alternate_quotation_start' => "\â\\",
        'quotation_end'             => "\â\\",
        'quotation_start'           => "\â\\"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "right\-to\-left",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => { 'one' => "sub\ \{\ return\ \'one\'\ if\ \(\ \(\(\ \$_\[0\]\ \=\=\ 1\)\)\)\;\ return\;\}\;" }
    },
    'posix' => {
        'nostr'  => "no\:n",
        'yesstr' => "yes\:y"
    },
);

%Locales::DB::Language::ku::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abkhazian',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => 'ئه‌فریكای',
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'agq'   => 'Aghem',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'ئه‌مهه‌رینجی',
    'an'    => 'Aragonese',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => 'عەرەبی',
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Artificial\ Language",
    'arw'   => 'Arawak',
    'as'    => "ئا\ سسامی\ \(زوبان\)",
    'asa'   => 'Asu',
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => 'ئازه‌ربایجانی',
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basaa',
    'bat'   => "Baltic\ Language",
    'be'    => 'بێلاڕووسی',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bez'   => 'Bena',
    'bg'    => 'بۆلگاری',
    'bh'    => 'بیهاری',
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'به‌نگلادێشی',
    'bnt'   => 'Bantu',
    'bo'    => 'Tibetan',
    'br'    => 'برێتونی',
    'bra'   => 'Braj',
    'brx'   => 'Bodo',
    'bs'    => 'بۆسنی',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'كاتالۆنی',
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cay'   => 'Cayuga',
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ Language",
    'cgg'   => 'Chiga',
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'Corsican',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'چه‌كی',
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => 'وێلزی',
    'da'    => 'دانماركی',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'dav'   => 'Taita',
    'day'   => 'Dayak',
    'de'    => 'ئاڵمانی',
    'de_at' => "Austrian\ German",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'dje'   => 'Zarma',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'Divehi',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'Dyula',
    'dz'    => 'Dzongkha',
    'ebu'   => 'Embu',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Ancient\ Egyptian",
    'eka'   => 'Ekajuk',
    'el'    => 'یۆنانی',
    'elx'   => 'Elamite',
    'en'    => 'ئینگلیزی',
    'en_au' => "ئینگلیزیی\ ئۆسترالیایی",
    'en_ca' => "ئینگلیزیی\ کەنەدایی",
    'en_gb' => "ئینگلیزیی\ بریتانیایی",
    'en_us' => "ئینگلیزیی\ ئەمەریکایی",
    'enm'   => "Middle\ English",
    'eo'    => 'ئێسپیرانتۆ',
    'es'    => 'ئیسپانی',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'ئیستۆنی',
    'eu'    => 'باسکی',
    'ewo'   => 'Ewondo',
    'fa'    => 'فارسی',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'فینله‌ندی',
    'fil'   => 'تاگالۆگی',
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'Fijian',
    'fo'    => 'فه‌رئۆیی',
    'fon'   => 'Fon',
    'fr'    => 'فه‌رانسی',
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "Swiss\ French",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => 'فریسی',
    'ga'    => 'ئیرله‌ندی',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "گه‌لیكی\ سكۆتله‌ندی",
    'gem'   => "Germanic\ Language",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'گالیسی',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'گووارانی',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Ancient\ Greek",
    'gsw'   => "Swiss\ German",
    'gu'    => 'گوجاراتی',
    'guz'   => 'Gusii',
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'Hausa',
    'hai'   => 'Haida',
    'haw'   => 'Hawaiian',
    'he'    => 'هیبرێ',
    'hi'    => 'هیندی',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'كرواتی',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => "هه‌نگاری\ \(مه‌جاری\)",
    'hup'   => 'Hupa',
    'hy'    => 'ئەرمەنی',
    'hz'    => 'Herero',
    'ia'    => 'ئینترلینگوی',
    'iba'   => 'Iban',
    'id'    => 'ئێه‌ندونیزی',
    'ie'    => 'ئینتەرلیگ',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'ئیسله‌ندی',
    'it'    => 'ئیتالی',
    'iu'    => 'Inuktitut',
    'ja'    => 'ژاپۆنی',
    'jbo'   => 'Lojban',
    'jmc'   => 'Machame',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'جاڤانی',
    'ka'    => 'گۆرجستانی',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'کازاخی',
    'kl'    => 'Kalaallisut',
    'kln'   => 'Kalenjin',
    'km'    => "کامبۆجی\ \(زوبان\)",
    'kmb'   => 'Kimbundu',
    'kn'    => 'كه‌نه‌دایی',
    'ko'    => 'كۆری',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Kashmiri',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'کوردی',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'كرگیزی',
    'la'    => 'لاتینی',
    'lad'   => 'Ladino',
    'lag'   => 'Langi',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxembourgish',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'لينگالا',
    'lo'    => 'لاو‏ى',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'لیتوانی',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'luy'   => 'Luyia',
    'lv'    => 'لێتۆنی',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagasy',
    'mga'   => "Middle\ Irish",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'Marshallese',
    'mi'    => 'Maori',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => 'ماكێدۆنی',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'مالایلام',
    'mn'    => 'مەنگۆلی',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'Moldavian',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'ماراتی',
    'ms'    => 'مالیزی',
    'mt'    => 'ماڵتایی',
    'mua'   => 'Mundang',
    'mul'   => "Multiple\ Languages",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'Burmese',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'Nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'naq'   => 'Nama',
    'nb'    => "Norwegian\ Bokm\Ã\¥l",
    'nd'    => "North\ Ndebele",
    'nds'   => "Low\ German",
    'ne'    => 'نیپالی',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'هۆڵه‌ندی',
    'nl_be' => 'Flemish',
    'nmg'   => 'Kwasio',
    'nn'    => "Norwegian\ Nynorsk",
    'no'    => 'نۆروێژی',
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Nubian\ Language",
    'nus'   => 'Nuer',
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'ئۆسیتانی',
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'ئۆرییا',
    'os'    => 'Ossetic',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'په‌نجابی',
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => "پۆڵۆنیایی\ \(له‌هستانی\)",
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'پەشتوو',
    'pt'    => 'پورتوگالی',
    'pt_br' => "پورتوگاڵی\ \(برازیل\)",
    'pt_pt' => "پورتوگاڵی\ \(پورتوگاڵ\)",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => 'Romansh',
    'rn'    => 'Rundi',
    'ro'    => 'ڕۆمانی',
    'roa'   => "Romance\ Language",
    'rof'   => 'Rombo',
    'rom'   => 'Romany',
    'ru'    => 'ڕووسی',
    'rup'   => 'Aromanian',
    'rw'    => 'Kinyarwanda',
    'rwk'   => 'Rwa',
    'sa'    => 'سانسکريت',
    'sad'   => 'Sandawe',
    'sah'   => 'Sakha',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'saq'   => 'Samburu',
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sbp'   => 'Sangu',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => "سيندی\(زوبان\)",
    'se'    => "Northern\ Sami",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'Sango',
    'sga'   => "Old\ Irish",
    'sgn'   => "Sign\ Language",
    'sh'    => 'سێربۆكرواتی',
    'shi'   => 'Tachelhit',
    'shn'   => 'Shan',
    'si'    => 'سینهه‌لی',
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => 'سلۆڤاكی',
    'sl'    => 'سلۆڤێنی',
    'sla'   => "Slavic\ Language",
    'sm'    => 'Samoan',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => 'سۆمالی',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'ئاڵبانی',
    'sr'    => 'سه‌ربی',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swati',
    'ssa'   => "Nilo\-Saharan\ Language",
    'ssy'   => 'Saho',
    'st'    => 'سێسۆتۆ',
    'su'    => 'سودانی',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => 'سویدی',
    'sw'    => 'سواهیلی',
    'swb'   => 'Comorian',
    'swc'   => "Congo\ Swahili",
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'تامیلی',
    'tai'   => "Tai\ Language",
    'te'    => 'ته‌لۆگوی',
    'tem'   => 'Timne',
    'teo'   => 'Teso',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'تاجیکی',
    'th'    => 'تایله‌ندی',
    'ti'    => 'تیگرینیای',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'تورکمانی',
    'tkl'   => 'Tokelau',
    'tl'    => 'Tagalog',
    'tlh'   => 'كلینگۆن',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'Tswana',
    'to'    => 'Tonga',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'تورکی',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tatar',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'توی',
    'twq'   => 'Tasawaq',
    'ty'    => 'Tahitian',
    'tyv'   => 'Tuvinian',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'Udmurt',
    'ug'    => 'ئويخووری',
    'uga'   => 'Ugaritic',
    'uk'    => 'ئۆكراینی',
    'umb'   => 'Umbundu',
    'und'   => "زمانی\ نەناسراو",
    'ur'    => 'ئۆردو‌و',
    'uz'    => 'ئوزبەکی',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'ڤیەتنامی',
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'vun'   => 'Vunjo',
    'wa'    => 'Walloon',
    'wae'   => 'Walser',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'Wolof',
    'xal'   => 'Kalmyk',
    'xh'    => 'سسوسا',
    'xog'   => 'Soga',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yav'   => 'Yangben',
    'yi'    => 'یوددی',
    'yo'    => 'Yoruba',
    'ypk'   => "Yupik\ Language",
    'yue'   => 'Cantonese',
    'za'    => 'Zhuang',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'چینی',
    'znd'   => 'Zande',
    'zu'    => 'زولو',
    'zun'   => 'Zuni',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::ku::name_to_code = (
    'abkhazian'                                => 'ab',
    'achinese'                                 => 'ace',
    'acoli'                                    => 'ach',
    'adangme'                                  => 'ada',
    'adyghe'                                   => 'ady',
    'afar'                                     => 'aa',
    'afrihili'                                 => 'afh',
    'afroasiaticlanguage'                      => 'afa',
    'aghem'                                    => 'agq',
    'ainu'                                     => 'ain',
    'akan'                                     => 'ak',
    'akkadian'                                 => 'akk',
    'aleut'                                    => 'ale',
    'algonquianlanguage'                       => 'alg',
    'altaiclanguage'                           => 'tut',
    'ancientegyptian'                          => 'egy',
    'ancientgreek'                             => 'grc',
    'angika'                                   => 'anp',
    'apachelanguage'                           => 'apa',
    'aragonese'                                => 'an',
    'aramaic'                                  => 'arc',
    'arapaho'                                  => 'arp',
    'araucanian'                               => 'arn',
    'arawak'                                   => 'arw',
    'aromanian'                                => 'rup',
    'artificiallanguage'                       => 'art',
    'asturian'                                 => 'ast',
    'asu'                                      => 'asa',
    'athapascanlanguage'                       => 'ath',
    'atsam'                                    => 'cch',
    'australianlanguage'                       => 'aus',
    'austriangerman'                           => 'de_at',
    'austronesianlanguage'                     => 'map',
    'avaric'                                   => 'av',
    'avestan'                                  => 'ae',
    'awadhi'                                   => 'awa',
    'aymara'                                   => 'ay',
    'bafia'                                    => 'ksf',
    'balinese'                                 => 'ban',
    'balticlanguage'                           => 'bat',
    'baluchi'                                  => 'bal',
    'bambara'                                  => 'bm',
    'bamilekelanguage'                         => 'bai',
    'banda'                                    => 'bad',
    'bantu'                                    => 'bnt',
    'basaa'                                    => 'bas',
    'bashkir'                                  => 'ba',
    'batak'                                    => 'btk',
    'beja'                                     => 'bej',
    'bemba'                                    => 'bem',
    'bena'                                     => 'bez',
    'berber'                                   => 'ber',
    'bhojpuri'                                 => 'bho',
    'bikol'                                    => 'bik',
    'bini'                                     => 'bin',
    'bislama'                                  => 'bi',
    'blin'                                     => 'byn',
    'blissymbols'                              => 'zbl',
    'bodo'                                     => 'brx',
    'braj'                                     => 'bra',
    'buginese'                                 => 'bug',
    'buriat'                                   => 'bua',
    'burmese'                                  => 'my',
    'caddo'                                    => 'cad',
    'canadianfrench'                           => 'fr_ca',
    'cantonese'                                => 'yue',
    'carib'                                    => 'car',
    'caucasianlanguage'                        => 'cau',
    'cayuga'                                   => 'cay',
    'cebuano'                                  => 'ceb',
    'celticlanguage'                           => 'cel',
    'centralamericanindianlanguage'            => 'cai',
    'centralmoroccotamazight'                  => 'tzm',
    'chagatai'                                 => 'chg',
    'chamiclanguage'                           => 'cmc',
    'chamorro'                                 => 'ch',
    'chechen'                                  => 'ce',
    'cherokee'                                 => 'chr',
    'cheyenne'                                 => 'chy',
    'chibcha'                                  => 'chb',
    'chiga'                                    => 'cgg',
    'chinookjargon'                            => 'chn',
    'chipewyan'                                => 'chp',
    'choctaw'                                  => 'cho',
    'churchslavic'                             => 'cu',
    'chuukese'                                 => 'chk',
    'chuvash'                                  => 'cv',
    'classicalnewari'                          => 'nwc',
    'classicalsyriac'                          => 'syc',
    'colognian'                                => 'ksh',
    'comorian'                                 => 'swb',
    'congoswahili'                             => 'swc',
    'coptic'                                   => 'cop',
    'cornish'                                  => 'kw',
    'corsican'                                 => 'co',
    'cree'                                     => 'cr',
    'creek'                                    => 'mus',
    'creoleorpidgin'                           => 'crp',
    'crimeanturkish'                           => 'crh',
    'cushiticlanguage'                         => 'cus',
    'dakota'                                   => 'dak',
    'dargwa'                                   => 'dar',
    'dayak'                                    => 'day',
    'delaware'                                 => 'del',
    'dinka'                                    => 'din',
    'divehi'                                   => 'dv',
    'dogri'                                    => 'doi',
    'dogrib'                                   => 'dgr',
    'dravidianlanguage'                        => 'dra',
    'duala'                                    => 'dua',
    'dyula'                                    => 'dyu',
    'dzongkha'                                 => 'dz',
    'easternfrisian'                           => 'frs',
    'efik'                                     => 'efi',
    'ekajuk'                                   => 'eka',
    'elamite'                                  => 'elx',
    'embu'                                     => 'ebu',
    'englishbasedcreoleorpidgin'               => 'cpe',
    'erzya'                                    => 'myv',
    'ewe'                                      => 'ee',
    'ewondo'                                   => 'ewo',
    'fang'                                     => 'fan',
    'fanti'                                    => 'fat',
    'fijian'                                   => 'fj',
    'finnougrianlanguage'                      => 'fiu',
    'flemish'                                  => 'nl_be',
    'fon'                                      => 'fon',
    'frenchbasedcreoleorpidgin'                => 'cpf',
    'friulian'                                 => 'fur',
    'fulah'                                    => 'ff',
    'ga'                                       => 'gaa',
    'ganda'                                    => 'lg',
    'gayo'                                     => 'gay',
    'gbaya'                                    => 'gba',
    'geez'                                     => 'gez',
    'germaniclanguage'                         => 'gem',
    'gilbertese'                               => 'gil',
    'gondi'                                    => 'gon',
    'gorontalo'                                => 'gor',
    'gothic'                                   => 'got',
    'grebo'                                    => 'grb',
    'gusii'                                    => 'guz',
    "gwich\Ê\¼in"                            => 'gwi',
    'haida'                                    => 'hai',
    'haitian'                                  => 'ht',
    'hausa'                                    => 'ha',
    'hawaiian'                                 => 'haw',
    'herero'                                   => 'hz',
    'hiligaynon'                               => 'hil',
    'himachali'                                => 'him',
    'hirimotu'                                 => 'ho',
    'hittite'                                  => 'hit',
    'hmong'                                    => 'hmn',
    'hupa'                                     => 'hup',
    'iban'                                     => 'iba',
    'iberianspanish'                           => 'es_es',
    'ido'                                      => 'io',
    'igbo'                                     => 'ig',
    'ijo'                                      => 'ijo',
    'iloko'                                    => 'ilo',
    'inarisami'                                => 'smn',
    'indiclanguage'                            => 'inc',
    'indoeuropeanlanguage'                     => 'ine',
    'ingush'                                   => 'inh',
    'inuktitut'                                => 'iu',
    'inupiaq'                                  => 'ik',
    'iranianlanguage'                          => 'ira',
    'iroquoianlanguage'                        => 'iro',
    'jju'                                      => 'kaj',
    'jolafonyi'                                => 'dyo',
    'judeoarabic'                              => 'jrb',
    'judeopersian'                             => 'jpr',
    'kabardian'                                => 'kbd',
    'kabuverdianu'                             => 'kea',
    'kabyle'                                   => 'kab',
    'kachin'                                   => 'kac',
    'kalaallisut'                              => 'kl',
    'kalenjin'                                 => 'kln',
    'kalmyk'                                   => 'xal',
    'kamba'                                    => 'kam',
    'kanuri'                                   => 'kr',
    'karachaybalkar'                           => 'krc',
    'karakalpak'                               => 'kaa',
    'karelian'                                 => 'krl',
    'karen'                                    => 'kar',
    'kashmiri'                                 => 'ks',
    'kashubian'                                => 'csb',
    'kawi'                                     => 'kaw',
    'khasi'                                    => 'kha',
    'khoisanlanguage'                          => 'khi',
    'khotanese'                                => 'kho',
    'kikuyu'                                   => 'ki',
    'kimbundu'                                 => 'kmb',
    'kinyarwanda'                              => 'rw',
    'komi'                                     => 'kv',
    'kongo'                                    => 'kg',
    'konkani'                                  => 'kok',
    'koro'                                     => 'kfo',
    'kosraean'                                 => 'kos',
    'koyraborosenni'                           => 'ses',
    'koyrachiini'                              => 'khq',
    'kpelle'                                   => 'kpe',
    'kru'                                      => 'kro',
    'kuanyama'                                 => 'kj',
    'kumyk'                                    => 'kum',
    'kurukh'                                   => 'kru',
    'kutenai'                                  => 'kut',
    'kwasio'                                   => 'nmg',
    'ladino'                                   => 'lad',
    'lahnda'                                   => 'lah',
    'lamba'                                    => 'lam',
    'langi'                                    => 'lag',
    'lezghian'                                 => 'lez',
    'limburgish'                               => 'li',
    'lojban'                                   => 'jbo',
    'lowersorbian'                             => 'dsb',
    'lowgerman'                                => 'nds',
    'lozi'                                     => 'loz',
    'lubakatanga'                              => 'lu',
    'lubalulua'                                => 'lua',
    'luiseno'                                  => 'lui',
    'lulesami'                                 => 'smj',
    'lunda'                                    => 'lun',
    'luo'                                      => 'luo',
    'lushai'                                   => 'lus',
    'luxembourgish'                            => 'lb',
    'luyia'                                    => 'luy',
    'machame'                                  => 'jmc',
    'madurese'                                 => 'mad',
    'magahi'                                   => 'mag',
    'maithili'                                 => 'mai',
    'makasar'                                  => 'mak',
    'makhuwameetto'                            => 'mgh',
    'makonde'                                  => 'kde',
    'malagasy'                                 => 'mg',
    'manchu'                                   => 'mnc',
    'mandar'                                   => 'mdr',
    'mandingo'                                 => 'man',
    'manipuri'                                 => 'mni',
    'manobolanguage'                           => 'mno',
    'manx'                                     => 'gv',
    'maori'                                    => 'mi',
    'mari'                                     => 'chm',
    'marshallese'                              => 'mh',
    'marwari'                                  => 'mwr',
    'masai'                                    => 'mas',
    'mayanlanguage'                            => 'myn',
    'mende'                                    => 'men',
    'meru'                                     => 'mer',
    'micmac'                                   => 'mic',
    'middledutch'                              => 'dum',
    'middleenglish'                            => 'enm',
    'middlefrench'                             => 'frm',
    'middlehighgerman'                         => 'gmh',
    'middleirish'                              => 'mga',
    'minangkabau'                              => 'min',
    'mirandese'                                => 'mwl',
    'miscellaneouslanguage'                    => 'mis',
    'mohawk'                                   => 'moh',
    'moksha'                                   => 'mdf',
    'moldavian'                                => 'mo',
    'mongo'                                    => 'lol',
    'monkhmerlanguage'                         => 'mkh',
    'morisyen'                                 => 'mfe',
    'mossi'                                    => 'mos',
    'multiplelanguages'                        => 'mul',
    'mundalanguage'                            => 'mun',
    'mundang'                                  => 'mua',
    'nahuatl'                                  => 'nah',
    'nama'                                     => 'naq',
    'nauru'                                    => 'na',
    'navajo'                                   => 'nv',
    'ndonga'                                   => 'ng',
    'neapolitan'                               => 'nap',
    'newari'                                   => 'new',
    'nias'                                     => 'nia',
    'nigerkordofanianlanguage'                 => 'nic',
    'nilosaharanlanguage'                      => 'ssa',
    'niuean'                                   => 'niu',
    'nogai'                                    => 'nog',
    'nolinguisticcontent'                      => 'zxx',
    'northamericanindianlanguage'              => 'nai',
    'northernfrisian'                          => 'frr',
    'northernsami'                             => 'se',
    'northernsotho'                            => 'nso',
    'northndebele'                             => 'nd',
    "norwegianbokm\Ã\¥l"                     => 'nb',
    'norwegiannynorsk'                         => 'nn',
    'nubianlanguage'                           => 'nub',
    'nuer'                                     => 'nus',
    'nyamwezi'                                 => 'nym',
    'nyanja'                                   => 'ny',
    'nyankole'                                 => 'nyn',
    'nyasatonga'                               => 'tog',
    'nyoro'                                    => 'nyo',
    'nzima'                                    => 'nzi',
    "n\â\\ko"                             => 'nqo',
    'ojibwa'                                   => 'oj',
    'oldenglish'                               => 'ang',
    'oldfrench'                                => 'fro',
    'oldhighgerman'                            => 'goh',
    'oldirish'                                 => 'sga',
    'oldnorse'                                 => 'non',
    'oldpersian'                               => 'peo',
    "oldproven\Ã\§al"                        => 'pro',
    'oromo'                                    => 'om',
    'osage'                                    => 'osa',
    'ossetic'                                  => 'os',
    'otomianlanguage'                          => 'oto',
    'ottomanturkish'                           => 'ota',
    'pahlavi'                                  => 'pal',
    'palauan'                                  => 'pau',
    'pali'                                     => 'pi',
    'pampanga'                                 => 'pam',
    'pangasinan'                               => 'pag',
    'papiamento'                               => 'pap',
    'papuanlanguage'                           => 'paa',
    'philippinelanguage'                       => 'phi',
    'phoenician'                               => 'phn',
    'pohnpeian'                                => 'pon',
    'portuguesebasedcreoleorpidgin'            => 'cpp',
    'prakritlanguage'                          => 'pra',
    'quechua'                                  => 'qu',
    'rajasthani'                               => 'raj',
    'rapanui'                                  => 'rap',
    'rarotongan'                               => 'rar',
    'romancelanguage'                          => 'roa',
    'romansh'                                  => 'rm',
    'romany'                                   => 'rom',
    'rombo'                                    => 'rof',
    'rundi'                                    => 'rn',
    'rwa'                                      => 'rwk',
    'saho'                                     => 'ssy',
    'sakha'                                    => 'sah',
    'salishanlanguage'                         => 'sal',
    'samaritanaramaic'                         => 'sam',
    'samburu'                                  => 'saq',
    'samilanguage'                             => 'smi',
    'samoan'                                   => 'sm',
    'sandawe'                                  => 'sad',
    'sango'                                    => 'sg',
    'sangu'                                    => 'sbp',
    'santali'                                  => 'sat',
    'sardinian'                                => 'sc',
    'sasak'                                    => 'sas',
    'scots'                                    => 'sco',
    'selkup'                                   => 'sel',
    'semiticlanguage'                          => 'sem',
    'sena'                                     => 'seh',
    'seneca'                                   => 'see',
    'serer'                                    => 'srr',
    'shambala'                                 => 'ksb',
    'shan'                                     => 'shn',
    'shona'                                    => 'sn',
    'sichuanyi'                                => 'ii',
    'sicilian'                                 => 'scn',
    'sidamo'                                   => 'sid',
    'signlanguage'                             => 'sgn',
    'siksika'                                  => 'bla',
    'sinotibetanlanguage'                      => 'sit',
    'siouanlanguage'                           => 'sio',
    'skoltsami'                                => 'sms',
    'slave'                                    => 'den',
    'slaviclanguage'                           => 'sla',
    'soga'                                     => 'xog',
    'sogdien'                                  => 'sog',
    'songhai'                                  => 'son',
    'soninke'                                  => 'snk',
    'sorbianlanguage'                          => 'wen',
    'southamericanindianlanguage'              => 'sai',
    'southernaltai'                            => 'alt',
    'southernsami'                             => 'sma',
    'southndebele'                             => 'nr',
    'sranantongo'                              => 'srn',
    'sukuma'                                   => 'suk',
    'sumerian'                                 => 'sux',
    'susu'                                     => 'sus',
    'swati'                                    => 'ss',
    'swissfrench'                              => 'fr_ch',
    'swissgerman'                              => 'gsw',
    'swisshighgerman'                          => 'de_ch',
    'syriac'                                   => 'syr',
    'tachelhit'                                => 'shi',
    'tagalog'                                  => 'tl',
    'tahitian'                                 => 'ty',
    'tailanguage'                              => 'tai',
    'taita'                                    => 'dav',
    'tamashek'                                 => 'tmh',
    'taroko'                                   => 'trv',
    'tasawaq'                                  => 'twq',
    'tatar'                                    => 'tt',
    'tereno'                                   => 'ter',
    'teso'                                     => 'teo',
    'tetum'                                    => 'tet',
    'tibetan'                                  => 'bo',
    'tigre'                                    => 'tig',
    'timne'                                    => 'tem',
    'tiv'                                      => 'tiv',
    'tlingit'                                  => 'tli',
    'tokelau'                                  => 'tkl',
    'tokpisin'                                 => 'tpi',
    'tonga'                                    => 'to',
    'tsimshian'                                => 'tsi',
    'tsonga'                                   => 'ts',
    'tswana'                                   => 'tn',
    'tumbuka'                                  => 'tum',
    'tupilanguage'                             => 'tup',
    'tuvalu'                                   => 'tvl',
    'tuvinian'                                 => 'tyv',
    'tyap'                                     => 'kcg',
    'udmurt'                                   => 'udm',
    'ugaritic'                                 => 'uga',
    'umbundu'                                  => 'umb',
    'uppersorbian'                             => 'hsb',
    'vai'                                      => 'vai',
    'venda'                                    => 've',
    "volap\Ã\¼k"                             => 'vo',
    'votic'                                    => 'vot',
    'vunjo'                                    => 'vun',
    'wakashanlanguage'                         => 'wak',
    'walamo'                                   => 'wal',
    'walloon'                                  => 'wa',
    'walser'                                   => 'wae',
    'waray'                                    => 'war',
    'washo'                                    => 'was',
    'wolof'                                    => 'wo',
    'yangben'                                  => 'yav',
    'yao'                                      => 'yao',
    'yapese'                                   => 'yap',
    'yoruba'                                   => 'yo',
    'yupiklanguage'                            => 'ypk',
    'zande'                                    => 'znd',
    'zapotec'                                  => 'zap',
    'zarma'                                    => 'dje',
    'zaza'                                     => 'zza',
    'zenaga'                                   => 'zen',
    'zhuang'                                   => 'za',
    'zuni'                                     => 'zun',
    'ئازه‌ربایجانی'              => 'az',
    'ئاسسامیزوبان'                 => 'as',
    'ئاڵبانی'                           => 'sq',
    'ئاڵمانی'                           => 'de',
    'ئه‌فریكای'                      => 'af',
    'ئه‌مهه‌رینجی'               => 'am',
    'ئوزبەکی'                           => 'uz',
    'ئويخووری'                         => 'ug',
    'ئۆردو‌و'                          => 'ur',
    'ئۆرییا'                             => 'or',
    'ئۆسیتانی'                         => 'oc',
    'ئۆكراینی'                         => 'uk',
    'ئیتالی'                             => 'it',
    'ئیرله‌ندی'                      => 'ga',
    'ئیستۆنی'                           => 'et',
    'ئیسله‌ندی'                      => 'is',
    'ئیسپانی'                           => 'es',
    'ئینترلینگوی'                   => 'ia',
    'ئینتەرلیگ'                       => 'ie',
    'ئینگلیزی'                         => 'en',
    'ئینگلیزییئۆسترالیایی' => 'en_au',
    'ئینگلیزییئەمەریکایی'   => 'en_us',
    'ئینگلیزییبریتانیایی'   => 'en_gb',
    'ئینگلیزییکەنەدایی'       => 'en_ca',
    'ئێسپیرانتۆ'                     => 'eo',
    'ئێه‌ندونیزی'                  => 'id',
    'ئەرمەنی'                           => 'hy',
    'باسکی'                               => 'eu',
    'برێتونی'                           => 'br',
    'به‌نگلادێشی'                  => 'bn',
    'بۆسنی'                               => 'bs',
    'بۆلگاری'                           => 'bg',
    'بیهاری'                             => 'bh',
    'بێلاڕووسی'                       => 'be',
    'تاجیکی'                             => 'tg',
    'تامیلی'                             => 'ta',
    'تاگالۆگی'                         => 'fil',
    'تایله‌ندی'                      => 'th',
    'ته‌لۆگوی'                        => 'te',
    'تورکمانی'                         => 'tk',
    'تورکی'                               => 'tr',
    'توی'                                   => 'tw',
    'تیگرینیای'                       => 'ti',
    'جاڤانی'                             => 'jv',
    'دانماركی'                         => 'da',
    'زمانینەناسراو'               => 'und',
    'زولو'                                 => 'zu',
    'سانسکريت'                         => 'sa',
    'سسوسا'                               => 'xh',
    'سلۆڤاكی'                           => 'sk',
    'سلۆڤێنی'                           => 'sl',
    'سه‌ربی'                            => 'sr',
    'سواهیلی'                           => 'sw',
    'سودانی'                             => 'su',
    'سویدی'                               => 'sv',
    'سيندیزوبان'                     => 'sd',
    'سۆمالی'                             => 'so',
    'سینهه‌لی'                        => 'si',
    'سێربۆكرواتی'                   => 'sh',
    'سێسۆتۆ'                             => 'st',
    'عەرەبی'                             => 'ar',
    'فارسی'                               => 'fa',
    'فریسی'                               => 'fy',
    'فه‌رئۆیی'                        => 'fo',
    'فه‌رانسی'                        => 'fr',
    'فینله‌ندی'                      => 'fi',
    'كاتالۆنی'                         => 'ca',
    'كرواتی'                             => 'hr',
    'كرگیزی'                             => 'ky',
    'كلینگۆن'                           => 'tlh',
    'كه‌نه‌دایی'                   => 'kn',
    'كۆری'                                 => 'ko',
    'لاتینی'                             => 'la',
    'لاو‏ى'                              => 'lo',
    'لينگالا'                           => 'ln',
    'لیتوانی'                           => 'lt',
    'لێتۆنی'                             => 'lv',
    'ماراتی'                             => 'mr',
    'ماكێدۆنی'                         => 'mk',
    'مالایلام'                         => 'ml',
    'مالیزی'                             => 'ms',
    'ماڵتایی'                           => 'mt',
    'مەنگۆلی'                           => 'mn',
    'نۆروێژی'                           => 'no',
    'نیپالی'                             => 'ne',
    'هه‌نگاریمه‌جاری'         => 'hu',
    'هۆڵه‌ندی'                        => 'nl',
    'هیبرێ'                               => 'he',
    'هیندی'                               => 'hi',
    'وێلزی'                               => 'cy',
    'په‌نجابی'                        => 'pa',
    'پورتوگالی'                       => 'pt',
    'پورتوگاڵیبرازیل'           => 'pt_br',
    'پورتوگاڵیپورتوگاڵ'       => 'pt_pt',
    'پۆڵۆنیاییله‌هستانی'    => 'pl',
    'پەشتوو'                             => 'ps',
    'چه‌كی'                              => 'cs',
    'چینی'                                 => 'zh',
    'ڕووسی'                               => 'ru',
    'ڕۆمانی'                             => 'ro',
    'ژاپۆنی'                             => 'ja',
    'ڤیەتنامی'                         => 'vi',
    'کازاخی'                             => 'kk',
    'کامبۆجیزوبان'                 => 'km',
    'کوردی'                               => 'ku',
    'گالیسی'                             => 'gl',
    'گه‌لیكیسكۆتله‌ندی'     => 'gd',
    'گوجاراتی'                         => 'gu',
    'گووارانی'                         => 'gn',
    'گۆرجستانی'                       => 'ka',
    'یوددی'                               => 'yi',
    'یۆنانی'                             => 'el',
);

1;
