package Locales::DB::Language::ksh;

# Auto generated from CLDR

$Locales::DB::Language::ksh::VERSION = '0.07';

$Locales::DB::Language::ksh::cldr_version = '2.0';

%Locales::DB::Language::ksh::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => ' ',
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "de\ Schprooch\ afjekööz\ met\ „\{0\}“",
        'list'     => {
            2        => "\{0\}\ un\ \{1\}",
            'end'    => "\{0\}\ un\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ en\ \{1\}",
        'percent'   => "\#\,\#\#0 \%",
        'territory' => "de\ Jääjend\ afjekööz\ met\ „\{0\}“"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '‘',
        'alternate_quotation_start' => '‚',
        'quotation_end'             => '“',
        'quotation_start'           => '„'
    },
    'fallback'    => [ "de_DE\ nl\ nds\ en" ],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'zero',
            'other'
        ],
        'category_rules' => {
            'one'  => "n\ is\ 1",
            'zero' => "n\ is\ 0"
        },
        'category_rules_compiled' => {
            'one'  => "sub\ \{\ return\ \'one\'\ if\ \(\ \(\(\ \$_\[0\]\ \=\=\ 1\)\)\)\;\ return\;\}\;",
            'zero' => "sub\ \{\ return\ \'zero\'\ if\ \(\ \(\(\ \$_\[0\]\ \=\=\ 0\)\)\)\;\ return\;\}\;"
        }
    },
    'posix' => {
        'nostr' => {
            'content' => "nä\:nää\:näh\:n",
            'draft'   => 'unconfirmed'
        },
        'yesstr' => {
            'content' => "jo\:joh\:joo\:j",
            'draft'   => 'unconfirmed'
        }
    },
);

%Locales::DB::Language::ksh::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abchaasesch',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => 'Afrikaans',
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'agq'   => 'Aghem',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'Amhaaresch',
    'an'    => 'Aragonese',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => 'Arabescha',
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Artificial\ Language",
    'arw'   => 'Arawak',
    'as'    => 'Aßameesesch',
    'asa'   => 'Pare',
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'Aimaresch',
    'az'    => 'Asserbaidschaanesch',
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basaa',
    'bat'   => "Baltic\ Language",
    'be'    => 'Wiißrußesch',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bez'   => 'Bena',
    'bg'    => 'Bulljaaresch',
    'bh'    => 'Bihari',
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'Bängjaalesch',
    'bnt'   => 'Bantu',
    'bo'    => 'Tibeetesch',
    'br'    => 'Breton',
    'bra'   => 'Braj',
    'brx'   => 'Boddo',
    'bs'    => 'Boßnesch',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'Kattalanesch',
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cay'   => 'Cayuga',
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ Language",
    'cgg'   => 'Chiga',
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'Corsican',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'Tschäschesch',
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => 'Walliisesch',
    'da'    => 'Dänesch',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'dav'   => 'Taita',
    'day'   => 'Dayak',
    'de'    => 'Deutsch',
    'de_at' => "Deutsch\ uß\ Ößterich",
    'de_ch' => "Deutsch\ uß\ der\ Schweijz",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'dje'   => 'Zarma',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'Divehesch',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'Dyula',
    'dz'    => 'Butanesch',
    'ebu'   => 'Embu',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Ancient\ Egyptian",
    'eka'   => 'Ekajuk',
    'el'    => 'Jriischesch',
    'elx'   => 'Elamite',
    'en'    => 'Änglesch',
    'en_au' => "Änglesch\ uß\ Außtraalije",
    'en_ca' => "Änglesch\ uß\ Kannaada",
    'en_gb' => "Brittesch\ Änglesch",
    'en_us' => "Amärreskaanesch\ Änglesch",
    'enm'   => "Middle\ English",
    'eo'    => 'Esperanto',
    'es'    => 'Schpaanesch',
    'es_es' => "Schpaanesch\ uß\ Schpaaneje",
    'et'    => 'Äßnesch',
    'eu'    => 'Baskesch',
    'ewo'   => 'Ewondo',
    'fa'    => 'Pärsesch',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'Finnesch',
    'fil'   => 'Fillipiinesch',
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'Fidschesch',
    'fo'    => 'Faroese',
    'fon'   => 'Fon',
    'fr'    => 'Franzüüsesch',
    'fr_ca' => "Franzüüsesch\ uß\ Kannada",
    'fr_ch' => "Franzüüsesch\ uß\ de\ Schweijz",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => "Western\ Frisian",
    'ga'    => 'Ieresch',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "Scottish\ Gaelic",
    'gem'   => "Germanic\ Language",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'Jalliizesch',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'Juwaraanesch',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Ancient\ Greek",
    'gsw'   => 'Schwitzerdütsch',
    'gu'    => 'Gutscharatesch',
    'guz'   => 'Gusii',
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'Haußa',
    'hai'   => 'Haida',
    'haw'   => 'Hauajaanesch',
    'he'    => 'Hebrähesch',
    'hi'    => 'Hindi',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'Krowatesch',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => "Ha\'iitesch",
    'hu'    => 'Unjarresch',
    'hup'   => 'Hupa',
    'hy'    => 'Areenesch',
    'hz'    => 'Herero',
    'ia'    => 'Interlingua',
    'iba'   => 'Iban',
    'id'    => 'Indoneesesch',
    'ie'    => 'Interlingue',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'Ißländesch',
    'it'    => 'Etalljänesch',
    'iu'    => 'Inuktitut',
    'ja'    => 'Japaanesch',
    'jbo'   => 'Lojban',
    'jmc'   => 'Machame',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'Javaanesch',
    'ka'    => "Je\'orjesch",
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kapvärdesch',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'Kassakesch',
    'kl'    => 'Kalaallisut',
    'kln'   => 'Kalenjin',
    'km'    => 'Khmer',
    'kmb'   => 'Kimbundu',
    'kn'    => 'Kannada',
    'ko'    => 'Korrejaanesch',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Kschamieresch',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'Kurdesch',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'Kirjiisesch',
    'la'    => 'Lateijnesch',
    'lad'   => 'Ladino',
    'lag'   => 'Langi',
    'lah'   => "de\ Landa\-Schprooche",
    'lam'   => 'Lamba',
    'lb'    => 'Luxemborjesch',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'Lingjalla',
    'lo'    => 'Lahootesch',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'Littouesch',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'luy'   => 'Luyjanesch',
    'lv'    => 'Lättesch',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'Madajaßesch',
    'mga'   => "Middle\ Irish",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'Marshallese',
    'mi'    => 'Maahori',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => 'Mazedoonesch',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'Mallajalam',
    'mn'    => 'Mongjolesch',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'Moldavian',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'Marraatesch',
    'ms'    => 'Mallaijesch',
    'mt'    => 'Malteesesch',
    'mua'   => 'Mundang',
    'mul'   => "\-ongerscheidlijje\ Schprooche\-",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'Burmessesch',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'Nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'naq'   => 'Nama',
    'nb'    => "Norrweejesch\ Bokmål",
    'nd'    => "Nood\-Ndebele",
    'nds'   => "Low\ German",
    'ne'    => 'Nepallessesch',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'Holländesch',
    'nl_be' => 'Flämesch',
    'nmg'   => 'Kwasio',
    'nn'    => "Neu\-Norrweejesch",
    'no'    => 'Norrweejesch',
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Nood\-Sooto",
    'nub'   => "Nubian\ Language",
    'nus'   => 'Nuer',
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => "Schi\-Schewa",
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'Occitan',
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'Oriija',
    'os'    => 'Oßeetesch',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'Panschaabesch',
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => 'Pollnesch',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'Paschtunesch',
    'pt'    => 'Pochtojiesesch',
    'pt_br' => "Brasilljaanesch\ Pochtojiesesch",
    'pt_pt' => "Pochtojiisesch\ uß\ Pochtojall",
    'qu'    => 'Kättschowa',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => "Räto\-Romaanesch",
    'rn'    => "K\-Rundesch",
    'ro'    => 'Rumänesch',
    'roa'   => "Romance\ Language",
    'rof'   => 'Kirombo',
    'rom'   => 'Romany',
    'ru'    => 'Rußßesch',
    'rup'   => 'Aromanian',
    'rw'    => "Kinja\-Ruandesch",
    'rwk'   => 'Rwa',
    'sa'    => 'Sanskrit',
    'sad'   => 'Sandawe',
    'sah'   => 'Jackutesch',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'saq'   => 'Samburu',
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sbp'   => 'Sangu',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => 'Sinndi',
    'se'    => "Nood\-Lappländesch",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'Sangjo',
    'sga'   => "Old\ Irish",
    'sgn'   => "Sign\ Language",
    'sh'    => 'Särbokowatesch',
    'shi'   => 'Tachelhit',
    'shn'   => 'Shan',
    'si'    => 'Singjaleesesch',
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => 'ẞlovakesch',
    'sl'    => 'ẞloveenesch',
    'sla'   => "Slavic\ Language",
    'sm'    => 'Sammohanesch',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => "Schi\-Schona",
    'snk'   => 'Soninke',
    'so'    => 'Somaalesch',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'Albaanesch',
    'sr'    => 'Särbesch',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => "Si\-Swatesch",
    'ssa'   => "Nilo\-Saharan\ Language",
    'ssy'   => 'Saho',
    'st'    => "Söd\-Sooto",
    'su'    => 'Sindaneesesch',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => 'Schweedesch',
    'sw'    => 'Suaheelesch',
    'swb'   => 'Kommooresch',
    'swc'   => "Congo\ Swahili",
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'Tamiilesch',
    'tai'   => "Tai\ Language",
    'te'    => 'Telluuju',
    'tem'   => 'Timne',
    'teo'   => 'Teso',
    'ter'   => 'Tereno',
    'tet'   => 'Tetumsch',
    'tg'    => 'Tadschiikesch',
    'th'    => 'Tailändesch',
    'ti'    => 'Tigrinianesch',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'Törkmeenesch',
    'tkl'   => 'Tokelau',
    'tl'    => 'Tagalog',
    'tlh'   => 'Klingon',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => "Se\-Zwaanesch",
    'to'    => 'Tongjaanesch',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Took\ Pisin",
    'tr'    => 'Törkesch',
    'trv'   => 'Taroko',
    'ts'    => "Xi\-Zongjanesch",
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tatar',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'Twi',
    'twq'   => 'Tasawaq',
    'ty'    => 'Tahitesch',
    'tyv'   => 'Tuvinian',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'Udmurt',
    'ug'    => "Uj\'juuersch",
    'uga'   => 'Ugaritic',
    'uk'    => 'Ukrainesch',
    'umb'   => 'Umbundu',
    'und'   => "\-onbikannt\-",
    'ur'    => "Urdu\/Hindi",
    'uz'    => 'Ußbeekesch',
    'vai'   => 'Vai',
    've'    => 'Wenda',
    'vi'    => 'Vijätnammeesesch',
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'vun'   => 'Vunjo',
    'wa'    => 'Walloon',
    'wae'   => 'Walserdütsch',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'Woloff',
    'xal'   => 'Kalmyk',
    'xh'    => "Isi\-Khoosa",
    'xog'   => 'Soga',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yav'   => 'Yangben',
    'yi'    => 'Yiddish',
    'yo'    => 'Joruuba',
    'ypk'   => "Yupik\ Language",
    'yue'   => "Kanton\-Schineesesch",
    'za'    => 'Zhuang',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'Schineesesch',
    'znd'   => 'Zande',
    'zu'    => 'Suulu',
    'zun'   => 'Zuni',
    'zxx'   => "\-kein\ Schprooch\-",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::ksh::name_to_code = (
    'abchaasesch'                   => 'ab',
    'achinese'                      => 'ace',
    'acoli'                         => 'ach',
    'adangme'                       => 'ada',
    'adyghe'                        => 'ady',
    'afar'                          => 'aa',
    'afrihili'                      => 'afh',
    'afrikaans'                     => 'af',
    'afroasiaticlanguage'           => 'afa',
    'aghem'                         => 'agq',
    'aimaresch'                     => 'ay',
    'ainu'                          => 'ain',
    'akan'                          => 'ak',
    'akkadian'                      => 'akk',
    'albaanesch'                    => 'sq',
    'aleut'                         => 'ale',
    'algonquianlanguage'            => 'alg',
    'altaiclanguage'                => 'tut',
    'amhaaresch'                    => 'am',
    'amärreskaaneschÄnglesch'     => 'en_us',
    'ancientegyptian'               => 'egy',
    'ancientgreek'                  => 'grc',
    'angika'                        => 'anp',
    'apachelanguage'                => 'apa',
    'arabescha'                     => 'ar',
    'aragonese'                     => 'an',
    'aramaic'                       => 'arc',
    'arapaho'                       => 'arp',
    'araucanian'                    => 'arn',
    'arawak'                        => 'arw',
    'areenesch'                     => 'hy',
    'aromanian'                     => 'rup',
    'artificiallanguage'            => 'art',
    'asserbaidschaanesch'           => 'az',
    'asturian'                      => 'ast',
    'athapascanlanguage'            => 'ath',
    'atsam'                         => 'cch',
    'australianlanguage'            => 'aus',
    'austronesianlanguage'          => 'map',
    'avaric'                        => 'av',
    'avestan'                       => 'ae',
    'awadhi'                        => 'awa',
    'aßameesesch'                  => 'as',
    'bafia'                         => 'ksf',
    'balinese'                      => 'ban',
    'balticlanguage'                => 'bat',
    'baluchi'                       => 'bal',
    'bambara'                       => 'bm',
    'bamilekelanguage'              => 'bai',
    'banda'                         => 'bad',
    'bantu'                         => 'bnt',
    'basaa'                         => 'bas',
    'bashkir'                       => 'ba',
    'baskesch'                      => 'eu',
    'batak'                         => 'btk',
    'beja'                          => 'bej',
    'bemba'                         => 'bem',
    'bena'                          => 'bez',
    'berber'                        => 'ber',
    'bhojpuri'                      => 'bho',
    'bihari'                        => 'bh',
    'bikol'                         => 'bik',
    'bini'                          => 'bin',
    'bislama'                       => 'bi',
    'blin'                          => 'byn',
    'blissymbols'                   => 'zbl',
    'boddo'                         => 'brx',
    'boßnesch'                     => 'bs',
    'braj'                          => 'bra',
    'brasilljaaneschpochtojiesesch' => 'pt_br',
    'breton'                        => 'br',
    'britteschÄnglesch'            => 'en_gb',
    'buginese'                      => 'bug',
    'bulljaaresch'                  => 'bg',
    'buriat'                        => 'bua',
    'burmessesch'                   => 'my',
    'butanesch'                     => 'dz',
    'bängjaalesch'                 => 'bn',
    'caddo'                         => 'cad',
    'carib'                         => 'car',
    'caucasianlanguage'             => 'cau',
    'cayuga'                        => 'cay',
    'cebuano'                       => 'ceb',
    'celticlanguage'                => 'cel',
    'centralamericanindianlanguage' => 'cai',
    'centralmoroccotamazight'       => 'tzm',
    'chagatai'                      => 'chg',
    'chamiclanguage'                => 'cmc',
    'chamorro'                      => 'ch',
    'chechen'                       => 'ce',
    'cherokee'                      => 'chr',
    'cheyenne'                      => 'chy',
    'chibcha'                       => 'chb',
    'chiga'                         => 'cgg',
    'chinookjargon'                 => 'chn',
    'chipewyan'                     => 'chp',
    'choctaw'                       => 'cho',
    'churchslavic'                  => 'cu',
    'chuukese'                      => 'chk',
    'chuvash'                       => 'cv',
    'classicalnewari'               => 'nwc',
    'classicalsyriac'               => 'syc',
    'colognian'                     => 'ksh',
    'congoswahili'                  => 'swc',
    'coptic'                        => 'cop',
    'cornish'                       => 'kw',
    'corsican'                      => 'co',
    'cree'                          => 'cr',
    'creek'                         => 'mus',
    'creoleorpidgin'                => 'crp',
    'crimeanturkish'                => 'crh',
    'cushiticlanguage'              => 'cus',
    'dakota'                        => 'dak',
    'dargwa'                        => 'dar',
    'dayak'                         => 'day',
    'delandaschprooche'             => 'lah',
    'delaware'                      => 'del',
    'deutsch'                       => 'de',
    'deutschußderschweijz'         => 'de_ch',
    'deutschußÖßterich'          => 'de_at',
    'dinka'                         => 'din',
    'divehesch'                     => 'dv',
    'dogri'                         => 'doi',
    'dogrib'                        => 'dgr',
    'dravidianlanguage'             => 'dra',
    'duala'                         => 'dua',
    'dyula'                         => 'dyu',
    'dänesch'                      => 'da',
    'easternfrisian'                => 'frs',
    'efik'                          => 'efi',
    'ekajuk'                        => 'eka',
    'elamite'                       => 'elx',
    'embu'                          => 'ebu',
    'englishbasedcreoleorpidgin'    => 'cpe',
    'erzya'                         => 'myv',
    'esperanto'                     => 'eo',
    'etalljänesch'                 => 'it',
    'ewe'                           => 'ee',
    'ewondo'                        => 'ewo',
    'fang'                          => 'fan',
    'fanti'                         => 'fat',
    'faroese'                       => 'fo',
    'fidschesch'                    => 'fj',
    'fillipiinesch'                 => 'fil',
    'finnesch'                      => 'fi',
    'finnougrianlanguage'           => 'fiu',
    'flämesch'                     => 'nl_be',
    'fon'                           => 'fon',
    'franzüüsesch'                => 'fr',
    'franzüüseschußdeschweijz'   => 'fr_ch',
    'franzüüseschußkannada'      => 'fr_ca',
    'frenchbasedcreoleorpidgin'     => 'cpf',
    'friulian'                      => 'fur',
    'fulah'                         => 'ff',
    'ga'                            => 'gaa',
    'ganda'                         => 'lg',
    'gayo'                          => 'gay',
    'gbaya'                         => 'gba',
    'geez'                          => 'gez',
    'germaniclanguage'              => 'gem',
    'gilbertese'                    => 'gil',
    'gondi'                         => 'gon',
    'gorontalo'                     => 'gor',
    'gothic'                        => 'got',
    'grebo'                         => 'grb',
    'gusii'                         => 'guz',
    'gutscharatesch'                => 'gu',
    "gwich\Ê\¼in"                 => 'gwi',
    'haida'                         => 'hai',
    'haiitesch'                     => 'ht',
    'hauajaanesch'                  => 'haw',
    'haußa'                        => 'ha',
    'hebrähesch'                   => 'he',
    'herero'                        => 'hz',
    'hiligaynon'                    => 'hil',
    'himachali'                     => 'him',
    'hindi'                         => 'hi',
    'hirimotu'                      => 'ho',
    'hittite'                       => 'hit',
    'hmong'                         => 'hmn',
    'holländesch'                  => 'nl',
    'hupa'                          => 'hup',
    'iban'                          => 'iba',
    'ido'                           => 'io',
    'ieresch'                       => 'ga',
    'igbo'                          => 'ig',
    'ijo'                           => 'ijo',
    'iloko'                         => 'ilo',
    'inarisami'                     => 'smn',
    'indiclanguage'                 => 'inc',
    'indoeuropeanlanguage'          => 'ine',
    'indoneesesch'                  => 'id',
    'ingush'                        => 'inh',
    'interlingua'                   => 'ia',
    'interlingue'                   => 'ie',
    'inuktitut'                     => 'iu',
    'inupiaq'                       => 'ik',
    'iranianlanguage'               => 'ira',
    'iroquoianlanguage'             => 'iro',
    'isikhoosa'                     => 'xh',
    'ißländesch'                  => 'is',
    'jackutesch'                    => 'sah',
    'jalliizesch'                   => 'gl',
    'japaanesch'                    => 'ja',
    'javaanesch'                    => 'jv',
    'jeorjesch'                     => 'ka',
    'jju'                           => 'kaj',
    'jolafonyi'                     => 'dyo',
    'joruuba'                       => 'yo',
    'jriischesch'                   => 'el',
    'judeoarabic'                   => 'jrb',
    'judeopersian'                  => 'jpr',
    'juwaraanesch'                  => 'gn',
    'kabardian'                     => 'kbd',
    'kabyle'                        => 'kab',
    'kachin'                        => 'kac',
    'kalaallisut'                   => 'kl',
    'kalenjin'                      => 'kln',
    'kalmyk'                        => 'xal',
    'kamba'                         => 'kam',
    'kannada'                       => 'kn',
    'kantonschineesesch'            => 'yue',
    'kanuri'                        => 'kr',
    'kapvärdesch'                  => 'kea',
    'karachaybalkar'                => 'krc',
    'karakalpak'                    => 'kaa',
    'karelian'                      => 'krl',
    'karen'                         => 'kar',
    'kashubian'                     => 'csb',
    'kassakesch'                    => 'kk',
    'kattalanesch'                  => 'ca',
    'kawi'                          => 'kaw',
    'keinschprooch'                 => 'zxx',
    'khasi'                         => 'kha',
    'khmer'                         => 'km',
    'khoisanlanguage'               => 'khi',
    'khotanese'                     => 'kho',
    'kikuyu'                        => 'ki',
    'kimbundu'                      => 'kmb',
    'kinjaruandesch'                => 'rw',
    'kirjiisesch'                   => 'ky',
    'kirombo'                       => 'rof',
    'klingon'                       => 'tlh',
    'komi'                          => 'kv',
    'kommooresch'                   => 'swb',
    'kongo'                         => 'kg',
    'konkani'                       => 'kok',
    'koro'                          => 'kfo',
    'korrejaanesch'                 => 'ko',
    'kosraean'                      => 'kos',
    'koyraborosenni'                => 'ses',
    'koyrachiini'                   => 'khq',
    'kpelle'                        => 'kpe',
    'krowatesch'                    => 'hr',
    'kru'                           => 'kro',
    'krundesch'                     => 'rn',
    'kschamieresch'                 => 'ks',
    'kuanyama'                      => 'kj',
    'kumyk'                         => 'kum',
    'kurdesch'                      => 'ku',
    'kurukh'                        => 'kru',
    'kutenai'                       => 'kut',
    'kwasio'                        => 'nmg',
    'kättschowa'                   => 'qu',
    'ladino'                        => 'lad',
    'lahootesch'                    => 'lo',
    'lamba'                         => 'lam',
    'langi'                         => 'lag',
    'lateijnesch'                   => 'la',
    'lezghian'                      => 'lez',
    'limburgish'                    => 'li',
    'lingjalla'                     => 'ln',
    'littouesch'                    => 'lt',
    'lojban'                        => 'jbo',
    'lowersorbian'                  => 'dsb',
    'lowgerman'                     => 'nds',
    'lozi'                          => 'loz',
    'lubakatanga'                   => 'lu',
    'lubalulua'                     => 'lua',
    'luiseno'                       => 'lui',
    'lulesami'                      => 'smj',
    'lunda'                         => 'lun',
    'luo'                           => 'luo',
    'lushai'                        => 'lus',
    'luxemborjesch'                 => 'lb',
    'luyjanesch'                    => 'luy',
    'lättesch'                     => 'lv',
    'maahori'                       => 'mi',
    'machame'                       => 'jmc',
    'madajaßesch'                  => 'mg',
    'madurese'                      => 'mad',
    'magahi'                        => 'mag',
    'maithili'                      => 'mai',
    'makasar'                       => 'mak',
    'makhuwameetto'                 => 'mgh',
    'makonde'                       => 'kde',
    'mallaijesch'                   => 'ms',
    'mallajalam'                    => 'ml',
    'malteesesch'                   => 'mt',
    'manchu'                        => 'mnc',
    'mandar'                        => 'mdr',
    'mandingo'                      => 'man',
    'manipuri'                      => 'mni',
    'manobolanguage'                => 'mno',
    'manx'                          => 'gv',
    'mari'                          => 'chm',
    'marraatesch'                   => 'mr',
    'marshallese'                   => 'mh',
    'marwari'                       => 'mwr',
    'masai'                         => 'mas',
    'mayanlanguage'                 => 'myn',
    'mazedoonesch'                  => 'mk',
    'mende'                         => 'men',
    'meru'                          => 'mer',
    'micmac'                        => 'mic',
    'middledutch'                   => 'dum',
    'middleenglish'                 => 'enm',
    'middlefrench'                  => 'frm',
    'middlehighgerman'              => 'gmh',
    'middleirish'                   => 'mga',
    'minangkabau'                   => 'min',
    'mirandese'                     => 'mwl',
    'miscellaneouslanguage'         => 'mis',
    'mohawk'                        => 'moh',
    'moksha'                        => 'mdf',
    'moldavian'                     => 'mo',
    'mongjolesch'                   => 'mn',
    'mongo'                         => 'lol',
    'monkhmerlanguage'              => 'mkh',
    'morisyen'                      => 'mfe',
    'mossi'                         => 'mos',
    'mundalanguage'                 => 'mun',
    'mundang'                       => 'mua',
    'nahuatl'                       => 'nah',
    'nama'                          => 'naq',
    'nauru'                         => 'na',
    'navajo'                        => 'nv',
    'ndonga'                        => 'ng',
    'neapolitan'                    => 'nap',
    'nepallessesch'                 => 'ne',
    'neunorrweejesch'               => 'nn',
    'newari'                        => 'new',
    'nias'                          => 'nia',
    'nigerkordofanianlanguage'      => 'nic',
    'nilosaharanlanguage'           => 'ssa',
    'niuean'                        => 'niu',
    'nogai'                         => 'nog',
    'noodlappländesch'             => 'se',
    'noodndebele'                   => 'nd',
    'noodsooto'                     => 'nso',
    'norrweejesch'                  => 'no',
    'norrweejeschbokmål'           => 'nb',
    'northamericanindianlanguage'   => 'nai',
    'northernfrisian'               => 'frr',
    'nubianlanguage'                => 'nub',
    'nuer'                          => 'nus',
    'nyamwezi'                      => 'nym',
    'nyankole'                      => 'nyn',
    'nyasatonga'                    => 'tog',
    'nyoro'                         => 'nyo',
    'nzima'                         => 'nzi',
    "n\â\\ko"                  => 'nqo',
    'occitan'                       => 'oc',
    'ojibwa'                        => 'oj',
    'oldenglish'                    => 'ang',
    'oldfrench'                     => 'fro',
    'oldhighgerman'                 => 'goh',
    'oldirish'                      => 'sga',
    'oldnorse'                      => 'non',
    'oldpersian'                    => 'peo',
    "oldproven\Ã\§al"             => 'pro',
    'onbikannt'                     => 'und',
    'ongerscheidlijjeschprooche'    => 'mul',
    'oriija'                        => 'or',
    'oromo'                         => 'om',
    'osage'                         => 'osa',
    'otomianlanguage'               => 'oto',
    'ottomanturkish'                => 'ota',
    'oßeetesch'                    => 'os',
    'pahlavi'                       => 'pal',
    'palauan'                       => 'pau',
    'pali'                          => 'pi',
    'pampanga'                      => 'pam',
    'pangasinan'                    => 'pag',
    'panschaabesch'                 => 'pa',
    'papiamento'                    => 'pap',
    'papuanlanguage'                => 'paa',
    'pare'                          => 'asa',
    'paschtunesch'                  => 'ps',
    'philippinelanguage'            => 'phi',
    'phoenician'                    => 'phn',
    'pochtojiesesch'                => 'pt',
    'pochtojiiseschußpochtojall'   => 'pt_pt',
    'pohnpeian'                     => 'pon',
    'pollnesch'                     => 'pl',
    'portuguesebasedcreoleorpidgin' => 'cpp',
    'prakritlanguage'               => 'pra',
    'pärsesch'                     => 'fa',
    'rajasthani'                    => 'raj',
    'rapanui'                       => 'rap',
    'rarotongan'                    => 'rar',
    'romancelanguage'               => 'roa',
    'romany'                        => 'rom',
    'rumänesch'                    => 'ro',
    'rußßesch'                    => 'ru',
    'rwa'                           => 'rwk',
    'rätoromaanesch'               => 'rm',
    'saho'                          => 'ssy',
    'salishanlanguage'              => 'sal',
    'samaritanaramaic'              => 'sam',
    'samburu'                       => 'saq',
    'samilanguage'                  => 'smi',
    'sammohanesch'                  => 'sm',
    'sandawe'                       => 'sad',
    'sangjo'                        => 'sg',
    'sangu'                         => 'sbp',
    'sanskrit'                      => 'sa',
    'santali'                       => 'sat',
    'sardinian'                     => 'sc',
    'sasak'                         => 'sas',
    'schineesesch'                  => 'zh',
    'schischewa'                    => 'ny',
    'schischona'                    => 'sn',
    'schpaanesch'                   => 'es',
    'schpaaneschußschpaaneje'      => 'es_es',
    'schweedesch'                   => 'sv',
    'schwitzerdütsch'              => 'gsw',
    'scots'                         => 'sco',
    'scottishgaelic'                => 'gd',
    'selkup'                        => 'sel',
    'semiticlanguage'               => 'sem',
    'sena'                          => 'seh',
    'seneca'                        => 'see',
    'serer'                         => 'srr',
    'sezwaanesch'                   => 'tn',
    'shambala'                      => 'ksb',
    'shan'                          => 'shn',
    'sichuanyi'                     => 'ii',
    'sicilian'                      => 'scn',
    'sidamo'                        => 'sid',
    'signlanguage'                  => 'sgn',
    'siksika'                       => 'bla',
    'sindaneesesch'                 => 'su',
    'singjaleesesch'                => 'si',
    'sinndi'                        => 'sd',
    'sinotibetanlanguage'           => 'sit',
    'siouanlanguage'                => 'sio',
    'siswatesch'                    => 'ss',
    'skoltsami'                     => 'sms',
    'slave'                         => 'den',
    'slaviclanguage'                => 'sla',
    'soga'                          => 'xog',
    'sogdien'                       => 'sog',
    'somaalesch'                    => 'so',
    'songhai'                       => 'son',
    'soninke'                       => 'snk',
    'sorbianlanguage'               => 'wen',
    'southamericanindianlanguage'   => 'sai',
    'southernaltai'                 => 'alt',
    'southernsami'                  => 'sma',
    'southndebele'                  => 'nr',
    'sranantongo'                   => 'srn',
    'suaheelesch'                   => 'sw',
    'sukuma'                        => 'suk',
    'sumerian'                      => 'sux',
    'susu'                          => 'sus',
    'suulu'                         => 'zu',
    'syriac'                        => 'syr',
    'särbesch'                     => 'sr',
    'särbokowatesch'               => 'sh',
    'södsooto'                     => 'st',
    'tachelhit'                     => 'shi',
    'tadschiikesch'                 => 'tg',
    'tagalog'                       => 'tl',
    'tahitesch'                     => 'ty',
    'tailanguage'                   => 'tai',
    'tailändesch'                  => 'th',
    'taita'                         => 'dav',
    'tamashek'                      => 'tmh',
    'tamiilesch'                    => 'ta',
    'taroko'                        => 'trv',
    'tasawaq'                       => 'twq',
    'tatar'                         => 'tt',
    'telluuju'                      => 'te',
    'tereno'                        => 'ter',
    'teso'                          => 'teo',
    'tetumsch'                      => 'tet',
    'tibeetesch'                    => 'bo',
    'tigre'                         => 'tig',
    'tigrinianesch'                 => 'ti',
    'timne'                         => 'tem',
    'tiv'                           => 'tiv',
    'tlingit'                       => 'tli',
    'tokelau'                       => 'tkl',
    'tongjaanesch'                  => 'to',
    'tookpisin'                     => 'tpi',
    'tschäschesch'                 => 'cs',
    'tsimshian'                     => 'tsi',
    'tumbuka'                       => 'tum',
    'tupilanguage'                  => 'tup',
    'tuvalu'                        => 'tvl',
    'tuvinian'                      => 'tyv',
    'twi'                           => 'tw',
    'tyap'                          => 'kcg',
    'törkesch'                     => 'tr',
    'törkmeenesch'                 => 'tk',
    'udmurt'                        => 'udm',
    'ugaritic'                      => 'uga',
    'ujjuuersch'                    => 'ug',
    'ukrainesch'                    => 'uk',
    'umbundu'                       => 'umb',
    'unjarresch'                    => 'hu',
    'uppersorbian'                  => 'hsb',
    "urdu\/hindi"                   => 'ur',
    'ußbeekesch'                   => 'uz',
    'vai'                           => 'vai',
    'vijätnammeesesch'             => 'vi',
    "volap\Ã\¼k"                  => 'vo',
    'votic'                         => 'vot',
    'vunjo'                         => 'vun',
    'wakashanlanguage'              => 'wak',
    'walamo'                        => 'wal',
    'walliisesch'                   => 'cy',
    'walloon'                       => 'wa',
    'walserdütsch'                 => 'wae',
    'waray'                         => 'war',
    'washo'                         => 'was',
    'wenda'                         => 've',
    'westernfrisian'                => 'fy',
    'wiißrußesch'                 => 'be',
    'woloff'                        => 'wo',
    'xizongjanesch'                 => 'ts',
    'yangben'                       => 'yav',
    'yao'                           => 'yao',
    'yapese'                        => 'yap',
    'yiddish'                       => 'yi',
    'yupiklanguage'                 => 'ypk',
    'zande'                         => 'znd',
    'zapotec'                       => 'zap',
    'zarma'                         => 'dje',
    'zaza'                          => 'zza',
    'zenaga'                        => 'zen',
    'zhuang'                        => 'za',
    'zuni'                          => 'zun',
    'Änglesch'                     => 'en',
    'Ängleschußaußtraalije'      => 'en_au',
    'Ängleschußkannaada'          => 'en_ca',
    'Äßnesch'                     => 'et',
    'ẞlovakesch'                  => 'sk',
    'ẞloveenesch'                 => 'sl',
);

1;
