package Locales::DB::Language::ur;

# Auto generated from CLDR

$Locales::DB::Language::ur::VERSION = '0.02';

$Locales::DB::Language::ur::cldr_version = '1.7.1';

%Locales::DB::Language::ur::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "زبان\:\{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "خطہ\:\{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "right\-to\-left",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr' => {
            'content' => "no\:n",
            'draft'   => 'provisional'
        },
        'yesstr' => {
            'content' => "yes\:y",
            'draft'   => 'provisional'
        }
    },
);

%Locales::DB::Language::ur::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abkhazian',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => 'ايفريکانز',
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'امہاری',
    'an'    => 'Aragonese',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => 'عربی',
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Artificial\ Language",
    'arw'   => 'Arawak',
    'as'    => 'آسامی',
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => 'آزربائیجانی',
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basa',
    'bat'   => "Baltic\ Language",
    'be'    => 'بيلاروسی',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bg'    => 'بلغاری',
    'bh'    => 'بِہاری',
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'بنگالی',
    'bnt'   => 'Bantu',
    'bo'    => 'Tibetan',
    'br'    => 'برِیٹن',
    'bra'   => 'Braj',
    'bs'    => 'بوسنی',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'کاٹالانين',
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ Language",
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'Corsican',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'چيک',
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => 'ويلش',
    'da'    => 'ڈينش',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'day'   => 'Dayak',
    'de'    => 'جرمن',
    'de_at' => "Austrian\ German",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'Divehi',
    'dyu'   => 'Dyula',
    'dz'    => 'Dzongkha',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Ancient\ Egyptian",
    'eka'   => 'Ekajuk',
    'el'    => 'يونانی',
    'elx'   => 'Elamite',
    'en'    => 'انگريزی',
    'en_au' => "Australian\ English",
    'en_ca' => "Canadian\ English",
    'en_gb' => "برطانوی\ انگریزی",
    'en_us' => "امریکہ\ کی\ انگریزی",
    'enm'   => "Middle\ English",
    'eo'    => 'ايسپرانٹو',
    'es'    => 'ہسپانوی',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'اسٹونين',
    'eu'    => 'باسکی',
    'ewo'   => 'Ewondo',
    'fa'    => 'فارسی',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'فنّنِش',
    'fil'   => 'ٹيگالاگی',
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'Fijian',
    'fo'    => 'فیروئیز',
    'fon'   => 'Fon',
    'fr'    => 'فرانسيسی',
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "Swiss\ French",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => 'فريژين',
    'ga'    => 'آئيرِش',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "سکاٹ\ گيلِک",
    'gem'   => "Germanic\ Language",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'گاليشيائی',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'گُارانی',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Ancient\ Greek",
    'gsw'   => "Swiss\ German",
    'gu'    => 'گجراتی',
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'Hausa',
    'hai'   => 'Haida',
    'haw'   => 'Hawaiian',
    'he'    => 'عبرانی',
    'hi'    => 'ہندی',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'کراتی',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => 'ہنگیرین',
    'hup'   => 'Hupa',
    'hy'    => 'ارمینی',
    'hz'    => 'Herero',
    'ia'    => 'انٹرلنگوی',
    'iba'   => 'Iban',
    'id'    => 'انڈونيثيائی',
    'ie'    => 'Interlingue',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'برفستانی',
    'it'    => 'اطالوی',
    'iu'    => 'Inuktitut',
    'ja'    => 'جاپانی',
    'jbo'   => 'Lojban',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'جاوی',
    'ka'    => 'جارجی',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'Kazakh',
    'kl'    => 'Kalaallisut',
    'km'    => 'کمبوڈیَن',
    'kmb'   => 'Kimbundu',
    'kn'    => 'کنّاڈا',
    'ko'    => 'کورين',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Kashmiri',
    'ku'    => 'كردش',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'کرغیزی',
    'la'    => 'لاطينی',
    'lad'   => 'Ladino',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxembourgish',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'لِنگَلا',
    'lo'    => 'لاؤشِیَن',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'لتھُواینین',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'lv'    => 'ليٹوين',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagasy',
    'mga'   => "Middle\ Irish",
    'mh'    => 'Marshallese',
    'mi'    => 'Maori',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => 'مقدونيائی',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'مالايالم',
    'mn'    => 'منگؤلی',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'Moldavian',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'مراٹهی',
    'ms'    => 'مالائی',
    'mt'    => 'مالٹی',
    'mul'   => "Multiple\ Languages",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'Burmese',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'Nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'nb'    => "Norwegian\ Bokm\Ã\¥l",
    'nd'    => "North\ Ndebele",
    'nds'   => "Low\ German",
    'ne'    => 'نيپالی',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'ڈچ',
    'nl_be' => 'Flemish',
    'nn'    => "نورویجینی\ \(نینورسک\)",
    'no'    => 'نارويجين',
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Nubian\ Language",
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'آکيٹانی',
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'اورِیا',
    'os'    => 'Ossetic',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'پنجابی',
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => 'پولستانی',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'پشتو',
    'pt'    => 'پُرتگالی',
    'pt_br' => "پرتگالی\ \(ﺑﺮﺍﺯﻳﻞ\)",
    'pt_pt' => "پرتگالی\ \(پرتگال\)",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => "Rhaeto\-Romance",
    'rn'    => 'Rundi',
    'ro'    => 'رومنی',
    'roa'   => "Romance\ Language",
    'rom'   => 'Romany',
    'ru'    => 'روسی',
    'rup'   => 'Aromanian',
    'rw'    => 'Kinyarwanda',
    'sa'    => 'سَنسکرِت',
    'sad'   => 'Sandawe',
    'sah'   => 'Yakut',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => 'سندھی',
    'se'    => "Northern\ Sami",
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'sg'    => 'Sango',
    'sga'   => "Old\ Irish",
    'sgn'   => "Sign\ Language",
    'sh'    => "سربو\-کروئیشین",
    'shn'   => 'Shan',
    'si'    => 'سنہالی',
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => 'سلاواکی',
    'sl'    => 'سلوينی',
    'sla'   => "Slavic\ Language",
    'sm'    => 'Samoan',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => 'سومالی',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'البانی',
    'sr'    => 'صربی',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swati',
    'ssa'   => "Nilo\-Saharan\ Language",
    'st'    => 'سیسوتھو',
    'su'    => 'سُوڈانی',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => 'سويڈش',
    'sw'    => 'سواہیلی',
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'تامِل',
    'tai'   => "Tai\ Language",
    'te'    => 'تيلوگو',
    'tem'   => 'Timne',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'Tajik',
    'th'    => 'تهائی',
    'ti'    => 'تگرینی',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'ترکمانی',
    'tkl'   => 'Tokelau',
    'tl'    => "ٹیگا\ لوگ",
    'tlh'   => 'کلنگان',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'Tswana',
    'to'    => 'Tonga',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'ترکی',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tatar',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'توی',
    'ty'    => 'Tahitian',
    'tyv'   => 'Tuvinian',
    'udm'   => 'Udmurt',
    'ug'    => 'اُئِیگُور',
    'uga'   => 'Ugaritic',
    'uk'    => 'يُوکرينی',
    'umb'   => 'Umbundu',
    'und'   => "Unknown\ or\ Invalid\ Language",
    'ur'    => 'اردو',
    'uz'    => 'ازبک',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'ويتنامی',
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'wa'    => 'Walloon',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'Wolof',
    'xal'   => 'Kalmyk',
    'xh'    => 'خوسہ',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yi'    => 'يادش',
    'yo'    => 'Yoruba',
    'ypk'   => "Yupik\ Language",
    'za'    => 'Zhuang',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'Chinese',
    'znd'   => 'Zande',
    'zu'    => 'زُولُو',
    'zun'   => 'Zuni',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::ur::name_to_code = (
    'abkhazian'                        => 'ab',
    'achinese'                         => 'ace',
    'acoli'                            => 'ach',
    'adangme'                          => 'ada',
    'adyghe'                           => 'ady',
    'afar'                             => 'aa',
    'afrihili'                         => 'afh',
    'afroasiaticlanguage'              => 'afa',
    'ainu'                             => 'ain',
    'akan'                             => 'ak',
    'akkadian'                         => 'akk',
    'aleut'                            => 'ale',
    'algonquianlanguage'               => 'alg',
    'altaiclanguage'                   => 'tut',
    'ancientegyptian'                  => 'egy',
    'ancientgreek'                     => 'grc',
    'angika'                           => 'anp',
    'apachelanguage'                   => 'apa',
    'aragonese'                        => 'an',
    'aramaic'                          => 'arc',
    'arapaho'                          => 'arp',
    'araucanian'                       => 'arn',
    'arawak'                           => 'arw',
    'aromanian'                        => 'rup',
    'artificiallanguage'               => 'art',
    'asturian'                         => 'ast',
    'athapascanlanguage'               => 'ath',
    'atsam'                            => 'cch',
    'australianenglish'                => 'en_au',
    'australianlanguage'               => 'aus',
    'austriangerman'                   => 'de_at',
    'austronesianlanguage'             => 'map',
    'avaric'                           => 'av',
    'avestan'                          => 'ae',
    'awadhi'                           => 'awa',
    'aymara'                           => 'ay',
    'balinese'                         => 'ban',
    'balticlanguage'                   => 'bat',
    'baluchi'                          => 'bal',
    'bambara'                          => 'bm',
    'bamilekelanguage'                 => 'bai',
    'banda'                            => 'bad',
    'bantu'                            => 'bnt',
    'basa'                             => 'bas',
    'bashkir'                          => 'ba',
    'batak'                            => 'btk',
    'beja'                             => 'bej',
    'bemba'                            => 'bem',
    'berber'                           => 'ber',
    'bhojpuri'                         => 'bho',
    'bikol'                            => 'bik',
    'bini'                             => 'bin',
    'bislama'                          => 'bi',
    'blin'                             => 'byn',
    'blissymbols'                      => 'zbl',
    'braj'                             => 'bra',
    'buginese'                         => 'bug',
    'buriat'                           => 'bua',
    'burmese'                          => 'my',
    'caddo'                            => 'cad',
    'canadianenglish'                  => 'en_ca',
    'canadianfrench'                   => 'fr_ca',
    'carib'                            => 'car',
    'caucasianlanguage'                => 'cau',
    'cebuano'                          => 'ceb',
    'celticlanguage'                   => 'cel',
    'centralamericanindianlanguage'    => 'cai',
    'chagatai'                         => 'chg',
    'chamiclanguage'                   => 'cmc',
    'chamorro'                         => 'ch',
    'chechen'                          => 'ce',
    'cherokee'                         => 'chr',
    'cheyenne'                         => 'chy',
    'chibcha'                          => 'chb',
    'chinese'                          => 'zh',
    'chinookjargon'                    => 'chn',
    'chipewyan'                        => 'chp',
    'choctaw'                          => 'cho',
    'churchslavic'                     => 'cu',
    'chuukese'                         => 'chk',
    'chuvash'                          => 'cv',
    'classicalnewari'                  => 'nwc',
    'classicalsyriac'                  => 'syc',
    'coptic'                           => 'cop',
    'cornish'                          => 'kw',
    'corsican'                         => 'co',
    'cree'                             => 'cr',
    'creek'                            => 'mus',
    'creoleorpidgin'                   => 'crp',
    'crimeanturkish'                   => 'crh',
    'cushiticlanguage'                 => 'cus',
    'dakota'                           => 'dak',
    'dargwa'                           => 'dar',
    'dayak'                            => 'day',
    'delaware'                         => 'del',
    'dinka'                            => 'din',
    'divehi'                           => 'dv',
    'dogri'                            => 'doi',
    'dogrib'                           => 'dgr',
    'dravidianlanguage'                => 'dra',
    'duala'                            => 'dua',
    'dyula'                            => 'dyu',
    'dzongkha'                         => 'dz',
    'easternfrisian'                   => 'frs',
    'efik'                             => 'efi',
    'ekajuk'                           => 'eka',
    'elamite'                          => 'elx',
    'englishbasedcreoleorpidgin'       => 'cpe',
    'erzya'                            => 'myv',
    'ewe'                              => 'ee',
    'ewondo'                           => 'ewo',
    'fang'                             => 'fan',
    'fanti'                            => 'fat',
    'fijian'                           => 'fj',
    'finnougrianlanguage'              => 'fiu',
    'flemish'                          => 'nl_be',
    'fon'                              => 'fon',
    'frenchbasedcreoleorpidgin'        => 'cpf',
    'friulian'                         => 'fur',
    'fulah'                            => 'ff',
    'ga'                               => 'gaa',
    'ganda'                            => 'lg',
    'gayo'                             => 'gay',
    'gbaya'                            => 'gba',
    'geez'                             => 'gez',
    'germaniclanguage'                 => 'gem',
    'gilbertese'                       => 'gil',
    'gondi'                            => 'gon',
    'gorontalo'                        => 'gor',
    'gothic'                           => 'got',
    'grebo'                            => 'grb',
    "gwich\Ê\¼in"                    => 'gwi',
    'haida'                            => 'hai',
    'haitian'                          => 'ht',
    'hausa'                            => 'ha',
    'hawaiian'                         => 'haw',
    'herero'                           => 'hz',
    'hiligaynon'                       => 'hil',
    'himachali'                        => 'him',
    'hirimotu'                         => 'ho',
    'hittite'                          => 'hit',
    'hmong'                            => 'hmn',
    'hupa'                             => 'hup',
    'iban'                             => 'iba',
    'iberianspanish'                   => 'es_es',
    'ido'                              => 'io',
    'igbo'                             => 'ig',
    'ijo'                              => 'ijo',
    'iloko'                            => 'ilo',
    'inarisami'                        => 'smn',
    'indiclanguage'                    => 'inc',
    'indoeuropeanlanguage'             => 'ine',
    'ingush'                           => 'inh',
    'interlingue'                      => 'ie',
    'inuktitut'                        => 'iu',
    'inupiaq'                          => 'ik',
    'iranianlanguage'                  => 'ira',
    'iroquoianlanguage'                => 'iro',
    'jju'                              => 'kaj',
    'judeoarabic'                      => 'jrb',
    'judeopersian'                     => 'jpr',
    'kabardian'                        => 'kbd',
    'kabyle'                           => 'kab',
    'kachin'                           => 'kac',
    'kalaallisut'                      => 'kl',
    'kalmyk'                           => 'xal',
    'kamba'                            => 'kam',
    'kanuri'                           => 'kr',
    'karachaybalkar'                   => 'krc',
    'karakalpak'                       => 'kaa',
    'karelian'                         => 'krl',
    'karen'                            => 'kar',
    'kashmiri'                         => 'ks',
    'kashubian'                        => 'csb',
    'kawi'                             => 'kaw',
    'kazakh'                           => 'kk',
    'khasi'                            => 'kha',
    'khoisanlanguage'                  => 'khi',
    'khotanese'                        => 'kho',
    'kikuyu'                           => 'ki',
    'kimbundu'                         => 'kmb',
    'kinyarwanda'                      => 'rw',
    'komi'                             => 'kv',
    'kongo'                            => 'kg',
    'konkani'                          => 'kok',
    'koro'                             => 'kfo',
    'kosraean'                         => 'kos',
    'kpelle'                           => 'kpe',
    'kru'                              => 'kro',
    'kuanyama'                         => 'kj',
    'kumyk'                            => 'kum',
    'kurukh'                           => 'kru',
    'kutenai'                          => 'kut',
    'ladino'                           => 'lad',
    'lahnda'                           => 'lah',
    'lamba'                            => 'lam',
    'lezghian'                         => 'lez',
    'limburgish'                       => 'li',
    'lojban'                           => 'jbo',
    'lowersorbian'                     => 'dsb',
    'lowgerman'                        => 'nds',
    'lozi'                             => 'loz',
    'lubakatanga'                      => 'lu',
    'lubalulua'                        => 'lua',
    'luiseno'                          => 'lui',
    'lulesami'                         => 'smj',
    'lunda'                            => 'lun',
    'luo'                              => 'luo',
    'lushai'                           => 'lus',
    'luxembourgish'                    => 'lb',
    'madurese'                         => 'mad',
    'magahi'                           => 'mag',
    'maithili'                         => 'mai',
    'makasar'                          => 'mak',
    'malagasy'                         => 'mg',
    'manchu'                           => 'mnc',
    'mandar'                           => 'mdr',
    'mandingo'                         => 'man',
    'manipuri'                         => 'mni',
    'manobolanguage'                   => 'mno',
    'manx'                             => 'gv',
    'maori'                            => 'mi',
    'mari'                             => 'chm',
    'marshallese'                      => 'mh',
    'marwari'                          => 'mwr',
    'masai'                            => 'mas',
    'mayanlanguage'                    => 'myn',
    'mende'                            => 'men',
    'micmac'                           => 'mic',
    'middledutch'                      => 'dum',
    'middleenglish'                    => 'enm',
    'middlefrench'                     => 'frm',
    'middlehighgerman'                 => 'gmh',
    'middleirish'                      => 'mga',
    'minangkabau'                      => 'min',
    'mirandese'                        => 'mwl',
    'miscellaneouslanguage'            => 'mis',
    'mohawk'                           => 'moh',
    'moksha'                           => 'mdf',
    'moldavian'                        => 'mo',
    'mongo'                            => 'lol',
    'monkhmerlanguage'                 => 'mkh',
    'morisyen'                         => 'mfe',
    'mossi'                            => 'mos',
    'multiplelanguages'                => 'mul',
    'mundalanguage'                    => 'mun',
    'nahuatl'                          => 'nah',
    'nauru'                            => 'na',
    'navajo'                           => 'nv',
    'ndonga'                           => 'ng',
    'neapolitan'                       => 'nap',
    'newari'                           => 'new',
    'nias'                             => 'nia',
    'nigerkordofanianlanguage'         => 'nic',
    'nilosaharanlanguage'              => 'ssa',
    'niuean'                           => 'niu',
    'nogai'                            => 'nog',
    'nolinguisticcontent'              => 'zxx',
    'northamericanindianlanguage'      => 'nai',
    'northernfrisian'                  => 'frr',
    'northernsami'                     => 'se',
    'northernsotho'                    => 'nso',
    'northndebele'                     => 'nd',
    "norwegianbokm\Ã\¥l"             => 'nb',
    'nubianlanguage'                   => 'nub',
    'nyamwezi'                         => 'nym',
    'nyanja'                           => 'ny',
    'nyankole'                         => 'nyn',
    'nyasatonga'                       => 'tog',
    'nyoro'                            => 'nyo',
    'nzima'                            => 'nzi',
    "n\â\\ko"                     => 'nqo',
    'ojibwa'                           => 'oj',
    'oldenglish'                       => 'ang',
    'oldfrench'                        => 'fro',
    'oldhighgerman'                    => 'goh',
    'oldirish'                         => 'sga',
    'oldnorse'                         => 'non',
    'oldpersian'                       => 'peo',
    "oldproven\Ã\§al"                => 'pro',
    'oromo'                            => 'om',
    'osage'                            => 'osa',
    'ossetic'                          => 'os',
    'otomianlanguage'                  => 'oto',
    'ottomanturkish'                   => 'ota',
    'pahlavi'                          => 'pal',
    'palauan'                          => 'pau',
    'pali'                             => 'pi',
    'pampanga'                         => 'pam',
    'pangasinan'                       => 'pag',
    'papiamento'                       => 'pap',
    'papuanlanguage'                   => 'paa',
    'philippinelanguage'               => 'phi',
    'phoenician'                       => 'phn',
    'pohnpeian'                        => 'pon',
    'portuguesebasedcreoleorpidgin'    => 'cpp',
    'prakritlanguage'                  => 'pra',
    'quechua'                          => 'qu',
    'rajasthani'                       => 'raj',
    'rapanui'                          => 'rap',
    'rarotongan'                       => 'rar',
    'rhaetoromance'                    => 'rm',
    'romancelanguage'                  => 'roa',
    'romany'                           => 'rom',
    'rundi'                            => 'rn',
    'salishanlanguage'                 => 'sal',
    'samaritanaramaic'                 => 'sam',
    'samilanguage'                     => 'smi',
    'samoan'                           => 'sm',
    'sandawe'                          => 'sad',
    'sango'                            => 'sg',
    'santali'                          => 'sat',
    'sardinian'                        => 'sc',
    'sasak'                            => 'sas',
    'scots'                            => 'sco',
    'selkup'                           => 'sel',
    'semiticlanguage'                  => 'sem',
    'serer'                            => 'srr',
    'shan'                             => 'shn',
    'shona'                            => 'sn',
    'sichuanyi'                        => 'ii',
    'sicilian'                         => 'scn',
    'sidamo'                           => 'sid',
    'signlanguage'                     => 'sgn',
    'siksika'                          => 'bla',
    'sinotibetanlanguage'              => 'sit',
    'siouanlanguage'                   => 'sio',
    'skoltsami'                        => 'sms',
    'slave'                            => 'den',
    'slaviclanguage'                   => 'sla',
    'sogdien'                          => 'sog',
    'songhai'                          => 'son',
    'soninke'                          => 'snk',
    'sorbianlanguage'                  => 'wen',
    'southamericanindianlanguage'      => 'sai',
    'southernaltai'                    => 'alt',
    'southernsami'                     => 'sma',
    'southndebele'                     => 'nr',
    'sranantongo'                      => 'srn',
    'sukuma'                           => 'suk',
    'sumerian'                         => 'sux',
    'susu'                             => 'sus',
    'swati'                            => 'ss',
    'swissfrench'                      => 'fr_ch',
    'swissgerman'                      => 'gsw',
    'swisshighgerman'                  => 'de_ch',
    'syriac'                           => 'syr',
    'tahitian'                         => 'ty',
    'tailanguage'                      => 'tai',
    'tajik'                            => 'tg',
    'tamashek'                         => 'tmh',
    'taroko'                           => 'trv',
    'tatar'                            => 'tt',
    'tereno'                           => 'ter',
    'tetum'                            => 'tet',
    'tibetan'                          => 'bo',
    'tigre'                            => 'tig',
    'timne'                            => 'tem',
    'tiv'                              => 'tiv',
    'tlingit'                          => 'tli',
    'tokelau'                          => 'tkl',
    'tokpisin'                         => 'tpi',
    'tonga'                            => 'to',
    'tsimshian'                        => 'tsi',
    'tsonga'                           => 'ts',
    'tswana'                           => 'tn',
    'tumbuka'                          => 'tum',
    'tupilanguage'                     => 'tup',
    'tuvalu'                           => 'tvl',
    'tuvinian'                         => 'tyv',
    'tyap'                             => 'kcg',
    'udmurt'                           => 'udm',
    'ugaritic'                         => 'uga',
    'umbundu'                          => 'umb',
    'unknownorinvalidlanguage'         => 'und',
    'uppersorbian'                     => 'hsb',
    'vai'                              => 'vai',
    'venda'                            => 've',
    "volap\Ã\¼k"                     => 'vo',
    'votic'                            => 'vot',
    'wakashanlanguage'                 => 'wak',
    'walamo'                           => 'wal',
    'walloon'                          => 'wa',
    'waray'                            => 'war',
    'washo'                            => 'was',
    'wolof'                            => 'wo',
    'yakut'                            => 'sah',
    'yao'                              => 'yao',
    'yapese'                           => 'yap',
    'yoruba'                           => 'yo',
    'yupiklanguage'                    => 'ypk',
    'zande'                            => 'znd',
    'zapotec'                          => 'zap',
    'zaza'                             => 'zza',
    'zenaga'                           => 'zen',
    'zhuang'                           => 'za',
    'zuni'                             => 'zun',
    'آئيرِش'                     => 'ga',
    'آزربائیجانی'           => 'az',
    'آسامی'                       => 'as',
    'آکيٹانی'                   => 'oc',
    'اردو'                         => 'ur',
    'ارمینی'                     => 'hy',
    'ازبک'                         => 'uz',
    'اسٹونين'                   => 'et',
    'اطالوی'                     => 'it',
    'البانی'                     => 'sq',
    'امریکہکیانگریزی'   => 'en_us',
    'امہاری'                     => 'am',
    'انٹرلنگوی'               => 'ia',
    'انڈونيثيائی'           => 'id',
    'انگريزی'                   => 'en',
    'اورِیا'                     => 'or',
    'ايسپرانٹو'               => 'eo',
    'ايفريکانز'               => 'af',
    'اُئِیگُور'               => 'ug',
    'باسکی'                       => 'eu',
    'برطانویانگریزی'     => 'en_gb',
    'برفستانی'                 => 'is',
    'برِیٹن'                     => 'br',
    'بلغاری'                     => 'bg',
    'بنگالی'                     => 'bn',
    'بوسنی'                       => 'bs',
    'بيلاروسی'                 => 'be',
    'بِہاری'                     => 'bh',
    'تامِل'                       => 'ta',
    'ترکمانی'                   => 'tk',
    'ترکی'                         => 'tr',
    'تهائی'                       => 'th',
    'توی'                           => 'tw',
    'تيلوگو'                     => 'te',
    'تگرینی'                     => 'ti',
    'جارجی'                       => 'ka',
    'جاوی'                         => 'jv',
    'جاپانی'                     => 'ja',
    'جرمن'                         => 'de',
    'خوسہ'                         => 'xh',
    'روسی'                         => 'ru',
    'رومنی'                       => 'ro',
    'زُولُو'                     => 'zu',
    'سربوکروئیشین'         => 'sh',
    'سلاواکی'                   => 'sk',
    'سلوينی'                     => 'sl',
    'سندھی'                       => 'sd',
    'سنہالی'                     => 'si',
    'سواہیلی'                   => 'sw',
    'سومالی'                     => 'so',
    'سويڈش'                       => 'sv',
    'سَنسکرِت'                 => 'sa',
    'سُوڈانی'                   => 'su',
    'سکاٹگيلِک'               => 'gd',
    'سیسوتھو'                   => 'st',
    'صربی'                         => 'sr',
    'عبرانی'                     => 'he',
    'عربی'                         => 'ar',
    'فارسی'                       => 'fa',
    'فرانسيسی'                 => 'fr',
    'فريژين'                     => 'fy',
    'فنّنِش'                     => 'fi',
    'فیروئیز'                   => 'fo',
    'كردش'                         => 'ku',
    'لاؤشِیَن'                 => 'lo',
    'لاطينی'                     => 'la',
    'لتھُواینین'             => 'lt',
    'ليٹوين'                     => 'lv',
    'لِنگَلا'                   => 'ln',
    'مالائی'                     => 'ms',
    'مالايالم'                 => 'ml',
    'مالٹی'                       => 'mt',
    'مراٹهی'                     => 'mr',
    'مقدونيائی'               => 'mk',
    'منگؤلی'                     => 'mn',
    'نارويجين'                 => 'no',
    'نورویجینینینورسک' => 'nn',
    'نيپالی'                     => 'ne',
    'ويتنامی'                   => 'vi',
    'ويلش'                         => 'cy',
    'يادش'                         => 'yi',
    'يونانی'                     => 'el',
    'يُوکرينی'                 => 'uk',
    'ٹيگالاگی'                 => 'fil',
    'ٹیگالوگ'                   => 'tl',
    'پرتگالیپرتگال'       => 'pt_pt',
    'پرتگالیﺑﺮﺍﺯﻳﻞ' => 'pt_br',
    'پشتو'                         => 'ps',
    'پنجابی'                     => 'pa',
    'پولستانی'                 => 'pl',
    'پُرتگالی'                 => 'pt',
    'چيک'                           => 'cs',
    'ڈينش'                         => 'da',
    'ڈچ'                             => 'nl',
    'کاٹالانين'               => 'ca',
    'کراتی'                       => 'hr',
    'کرغیزی'                     => 'ky',
    'کلنگان'                     => 'tlh',
    'کمبوڈیَن'                 => 'km',
    'کنّاڈا'                     => 'kn',
    'کورين'                       => 'ko',
    'گاليشيائی'               => 'gl',
    'گجراتی'                     => 'gu',
    'گُارانی'                   => 'gn',
    'ہسپانوی'                   => 'es',
    'ہندی'                         => 'hi',
    'ہنگیرین'                   => 'hu',
);

1;
