package Locales::DB::Language::fa;

# Auto generated from CLDR

$Locales::DB::Language::fa::VERSION = '0.02';

$Locales::DB::Language::fa::cldr_version = '1.7.1';

%Locales::DB::Language::fa::misc_info = (
    'cldr_formats' => {
        'decimal'  => "\#\,\#\#0\.\#\#\#\;\'‪\'\-\#\,\#\#0\.\#\#\#\'‬\'",
        'language' => "زبان\:\ \{0\}",
        'locale'   => "\{0\}\ \(\{1\}\)",
        'percent'  => {
            'content'    => "\'‪\'\%\#\,\#\#0\'‬\'",
            'references' => 'R047'
        },
        'territory' => "ناحیه\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "right\-to\-left",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "نه\:ن\:خیر\:خ",
        'yesstr' => "بله\:ب\:آری\:آ"
    },
);

%Locales::DB::Language::fa::code_to_name = (
    'aa'    => 'آفاری',
    'ab'    => 'آبخازی',
    'ace'   => 'آچئی',
    'ach'   => 'آچولیایی',
    'ada'   => 'آدانگمه‌ای',
    'ady'   => 'آدیجیایی',
    'ae'    => 'اوستایی',
    'af'    => 'آفریکانس',
    'afa'   => "زبان\ افریقا\ و\ آسیایی",
    'afh'   => 'آفریهیلی',
    'ain'   => 'آینویی',
    'ak'    => 'آکان',
    'akk'   => 'آکدی',
    'ale'   => 'آلئوتی',
    'alg'   => "زبان\ آلگونکینی",
    'alt'   => "آلتایی\ جنوبی",
    'am'    => 'امهری',
    'an'    => 'آراگونزی',
    'ang'   => "انگلیسی\ باستان",
    'anp'   => 'آنگیکایی',
    'apa'   => "زبان\ آپاچیایی",
    'ar'    => 'عربی',
    'arc'   => 'آرامی',
    'arn'   => 'آروکانیایی',
    'arp'   => 'آراپاهویی',
    'art'   => "زبان\ ساختگی",
    'arw'   => 'آراواکی',
    'as'    => 'آسامی',
    'ast'   => 'Asturian',
    'ath'   => "زبان\ آتاپاسکایی",
    'aus'   => "زبان\ استرالیایی",
    'av'    => 'آواری',
    'awa'   => 'Awadhi',
    'ay'    => 'آیمارایی',
    'az'    => 'آذربایجانی',
    'ba'    => 'باشغیری',
    'bad'   => 'باندایی',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'بلوچی',
    'ban'   => 'بالیایی',
    'bas'   => 'باسایی',
    'bat'   => "زبان\ بالتیکی",
    'be'    => 'بلوروسی',
    'bej'   => 'بجایی',
    'bem'   => 'بمبایی',
    'ber'   => 'بربری',
    'bg'    => 'بلغاری',
    'bh'    => 'بیهاری',
    'bho'   => 'بوجپوری',
    'bi'    => 'بیسلاما',
    'bik'   => 'بیکولی',
    'bin'   => 'بینی',
    'bla'   => 'Siksika',
    'bm'    => 'بامبارایی',
    'bn'    => 'بنگالی',
    'bnt'   => 'بانتویی',
    'bo'    => 'تبتی',
    'br'    => 'برتانیایی',
    'bra'   => 'براج',
    'bs'    => 'بوسنیایی',
    'btk'   => 'باتاکی',
    'bua'   => 'بوریاتی',
    'bug'   => 'بوگیایی',
    'byn'   => 'بلین',
    'ca'    => 'کاتالونیایی',
    'cad'   => 'کادویی',
    'cai'   => "زبان\ سرخپوستی\ امریکای\ مرکزی",
    'car'   => 'کاریبی',
    'cau'   => "زبان\ قفقازی",
    'cch'   => 'Atsam',
    'ce'    => 'چچنی',
    'ceb'   => 'سبویی',
    'cel'   => "زبان\ سلتی",
    'ch'    => 'چامورویی',
    'chb'   => 'چیبچا',
    'chg'   => 'جغتایی',
    'chk'   => 'تروکی',
    'chm'   => 'ماریایی',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'چوکتویی',
    'chp'   => 'چیپه‌ویه‌ای',
    'chr'   => 'چروکیایی',
    'chy'   => 'شایانی',
    'cmc'   => "Chamic\ Language",
    'co'    => 'کورسی',
    'cop'   => 'قبطی',
    'cpe'   => "کریول\ یا\ پیجین\ مبتنی\ بر\ انگلیسی",
    'cpf'   => "کریول\ یا\ پیجین\ مبتنی\ بر\ فرانسوی",
    'cpp'   => "کریول\ یا\ پیجین\ مبتنی\ بر\ پرتغالی",
    'cr'    => 'کریایی',
    'crh'   => "ترکی\ کریمه",
    'crp'   => "کریول\ یا\ پیجین",
    'cs'    => 'چکی',
    'csb'   => 'کاشوبی',
    'cu'    => "اسلاوی\ کلیسایی",
    'cus'   => "زبان\ کوشی",
    'cv'    => 'چوواشی',
    'cy'    => 'ویلزی',
    'da'    => 'دانمارکی',
    'dak'   => 'داکوتایی',
    'dar'   => 'دارقینی',
    'day'   => 'دایاک',
    'de'    => 'آلمانی',
    'de_at' => "آلمانی\ اتریش",
    'de_ch' => "آلمانی\ علیای\ سوئیس",
    'del'   => 'دلاواری',
    'den'   => 'Slave',
    'dgr'   => 'دوگریب',
    'din'   => 'دینکایی',
    'doi'   => 'دوگری',
    'dra'   => "زبان\ دراویدی",
    'dsb'   => "صُربی\ سفلی",
    'dua'   => 'دوآلایی',
    'dum'   => "هلندی\ میانه",
    'dv'    => 'مالدیوی',
    'dyu'   => 'دایولایی',
    'dz'    => 'جونخایی',
    'ee'    => 'اوه‌ای',
    'efi'   => 'افیکی',
    'egy'   => "مصری\ کهن",
    'eka'   => 'اکاجوک',
    'el'    => 'یونانی',
    'elx'   => 'عیلامی',
    'en'    => 'انگلیسی',
    'en_au' => "انگلیسی\ استرالیا",
    'en_ca' => "انگلیسی\ کانادا",
    'en_gb' => "نگلیسی\ بریتانیا",
    'en_us' => "انگلیسی\ امریکا",
    'enm'   => "انگلیسی\ میانه",
    'eo'    => 'اسپرانتو',
    'es'    => 'اسپانیایی',
    'es_es' => "اسپانیایی\ اسپانیا",
    'et'    => 'استونیایی',
    'eu'    => 'باسکی',
    'ewo'   => 'اواندو',
    'fa'    => 'فارسی',
    'fan'   => 'فانکی',
    'fat'   => 'فانتیایی',
    'ff'    => 'فولایی',
    'fi'    => 'فنلاندی',
    'fil'   => 'فیلیپینی',
    'fiu'   => "زبان\ فین\ و\ اوگرایی",
    'fj'    => 'فیجیایی',
    'fo'    => 'فارویی',
    'fon'   => 'فونی',
    'fr'    => 'فرانسوی',
    'fr_ca' => "فرانسوی\ کانادا",
    'fr_ch' => "فرانسوی\ سوئیس",
    'frm'   => "فرانسوی\ میانه",
    'fro'   => "فرانسوی\ باستان",
    'frr'   => "فریزی\ شمالی",
    'frs'   => "فریزی\ شرقی",
    'fur'   => 'فریولیایی',
    'fy'    => "فریزی\ غربی",
    'ga'    => 'ایرلندی',
    'gaa'   => 'گایی',
    'gay'   => 'گایویی',
    'gba'   => 'گبایایی',
    'gd'    => "گیلی\ اسکاتلندی",
    'gem'   => "زبان\ ژرمنی",
    'gez'   => 'گی‌ئزی',
    'gil'   => 'گیلبرتی',
    'gl'    => 'گالیسیایی',
    'gmh'   => "آلمانی\ علیای\ میانه",
    'gn'    => 'گوارانی',
    'goh'   => "آلمانی\ علیای\ باستان",
    'gon'   => 'گوندی',
    'gor'   => 'گورونتالو',
    'got'   => 'گوتی',
    'grb'   => 'گریبویی',
    'grc'   => "یونانی\ کهن",
    'gsw'   => "آلمانی\ سوئیسی",
    'gu'    => 'گجراتی',
    'gv'    => 'مانی',
    'gwi'   => "گویچ\ این",
    'ha'    => 'هوسیایی',
    'hai'   => 'هایدایی',
    'haw'   => 'هاوائیایی',
    'he'    => 'عبری',
    'hi'    => 'هندی',
    'hil'   => 'هیلی‌گاینونی',
    'him'   => 'هیماچالی',
    'hit'   => 'هیتی',
    'hmn'   => 'همونگ',
    'ho'    => "موتویی\ هیری",
    'hr'    => 'کرواتی',
    'hsb'   => "صُربی\ علیا",
    'ht'    => 'هائیتیایی',
    'hu'    => 'مجاری',
    'hup'   => 'هوپا',
    'hy'    => 'ارمنی',
    'hz'    => 'هریرویی',
    'ia'    => 'میان‌زبان',
    'iba'   => 'آیبن',
    'id'    => 'اندونزیایی',
    'ie'    => 'اکسیدنتال',
    'ig'    => 'ایگبویی',
    'ii'    => "یی\ سیچوان",
    'ijo'   => 'ایجویی',
    'ik'    => 'اینوپیک',
    'ilo'   => 'ایلوکویی',
    'inc'   => "زبان\ هندیک",
    'ine'   => "زبان\ هند\ و\ اروپایی",
    'inh'   => 'اینگوشی',
    'io'    => 'ایدو',
    'ira'   => "زبان\ ایرانی",
    'iro'   => "زبان\ ایروکوایی",
    'is'    => 'ایسلندی',
    'it'    => 'ایتالیایی',
    'iu'    => 'اینوکتیتوت',
    'ja'    => 'ژاپنی',
    'jbo'   => 'لوجبان',
    'jpr'   => "فارسی\ یهودی",
    'jrb'   => "عربی\ یهودی",
    'jv'    => 'جاوه‌ای',
    'ka'    => 'گرجی',
    'kaa'   => 'قره‌قالپاقی',
    'kab'   => 'قبایلی',
    'kac'   => 'کاچینی',
    'kaj'   => 'جو',
    'kam'   => 'کامبایی',
    'kar'   => 'کارنی',
    'kaw'   => 'کاویایی',
    'kbd'   => 'کاباردینی',
    'kcg'   => "تایپه\ ای",
    'kfo'   => 'کورو',
    'kg'    => 'کنگویی',
    'kha'   => 'خاسیایی',
    'khi'   => "زبان\ خواسی",
    'kho'   => 'ختنی',
    'ki'    => 'کیکویویی',
    'kj'    => 'کوانیاما',
    'kk'    => 'قزاقی',
    'kl'    => 'گرینلندی',
    'km'    => 'خمری',
    'kmb'   => 'کیمبوندویی',
    'kn'    => 'کاناده‌ای',
    'ko'    => 'کره‌ای',
    'kok'   => 'کنکانی',
    'kos'   => 'Kosraean',
    'kpe'   => 'کپله‌ای',
    'kr'    => 'کانوریایی',
    'krc'   => 'قره‌چایی‐بالکاری',
    'krl'   => 'Karelian',
    'kro'   => 'کرویی',
    'kru'   => 'کوروخی',
    'ks'    => 'کشمیری',
    'ku'    => 'کردی',
    'kum'   => 'کومیکی',
    'kut'   => 'کوتنی',
    'kv'    => 'کومیایی',
    'kw'    => 'کرنوالی',
    'ky'    => 'قرقیزی',
    'la'    => 'لاتینی',
    'lad'   => 'لادینو',
    'lah'   => 'لاهندا',
    'lam'   => 'لامبا',
    'lb'    => 'لوگزامبورگی',
    'lez'   => 'لزگی',
    'lg'    => 'گاندایی',
    'li'    => 'لیمبورگی',
    'ln'    => 'لینگالا',
    'lo'    => 'لائوسی',
    'lol'   => 'مونگویی',
    'loz'   => 'لوزیایی',
    'lt'    => 'لیتوانیایی',
    'lu'    => 'لوبایی‐کاتانگا',
    'lua'   => 'لوبایی‐لولوا',
    'lui'   => 'لویسنو',
    'lun'   => 'لوندایی',
    'luo'   => 'لوئویی',
    'lus'   => 'لوشه‌ای',
    'lv'    => 'لتونیایی',
    'mad'   => 'مادورایی',
    'mag'   => 'ماگاهیایی',
    'mai'   => 'مایدیلی',
    'mak'   => 'ماکاسار',
    'man'   => 'ماندینگویی',
    'map'   => "زبان\ آسترونیزیایی",
    'mas'   => 'ماسایی',
    'mdf'   => 'مکشایی',
    'mdr'   => 'ماندار',
    'men'   => 'منده‌ای',
    'mfe'   => 'Morisyen',
    'mg'    => 'مالاگاسیایی',
    'mga'   => "ایرلندی\ میانه",
    'mh'    => 'مارشالی',
    'mi'    => 'مائوریایی',
    'mic'   => 'میکماکی',
    'min'   => 'مینانگ‌کابویی',
    'mis'   => "زبان\ متفرقه",
    'mk'    => 'مقدونی',
    'mkh'   => "زبان\ مون‌خمری",
    'ml'    => 'مالایالامی',
    'mn'    => 'مغولی',
    'mnc'   => 'مانچویی',
    'mni'   => 'میته‌ای',
    'mno'   => "زبان\ مانوبو",
    'mo'    => 'مولداویایی',
    'moh'   => 'موهاکی',
    'mos'   => 'ماسیایی',
    'mr'    => 'مراتی',
    'ms'    => 'مالزیایی',
    'mt'    => 'مالتی',
    'mul'   => "چندین\ زبان",
    'mun'   => "زبان\ موندایی",
    'mus'   => 'کریکی',
    'mwl'   => 'Mirandese',
    'mwr'   => 'مارواری',
    'my'    => 'برمه‌ای',
    'myn'   => "زبان\ مایایی",
    'myv'   => 'ارزیایی',
    'na'    => 'نائورویی',
    'nah'   => 'ناواتلی',
    'nai'   => "زبان\ سرخپوستی\ امریکای\ شمالی",
    'nap'   => 'ناپلی',
    'nb'    => "بوکسمال\ نروژی",
    'nd'    => "انده‌بله‌ای\ شمالی",
    'nds'   => "آلمانی\ سفلی",
    'ne'    => 'نپالی',
    'new'   => 'نواریایی',
    'ng'    => 'اندونگایی',
    'nia'   => 'نیاسی',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'نیویی',
    'nl'    => 'هلندی',
    'nl_be' => 'فلمنگی',
    'nn'    => "نرس\ جدید\ نروژی",
    'no'    => 'نروژی',
    'nog'   => 'نغایی',
    'non'   => "نرس\ باستان",
    'nqo'   => "N\â\\Ko",
    'nr'    => "انده‌بله‌ای\ جنوبی",
    'nso'   => "سوتویی\ شمالی",
    'nub'   => "زبان\ نوبیایی",
    'nv'    => 'ناواهویی',
    'nwc'   => "نواریایی\ کلاسیک",
    'ny'    => 'نیانجایی',
    'nym'   => 'نیام‌وزیایی',
    'nyn'   => 'نیانکوله‌ای',
    'nyo'   => 'نیورویی',
    'nzi'   => 'نزیمایی',
    'oc'    => 'اوکیتایی',
    'oj'    => 'اوجیبوایی',
    'om'    => 'اورومویی',
    'or'    => 'اوریه‌ای',
    'os'    => 'آسی',
    'osa'   => 'اوسیجی',
    'ota'   => "ترکی\ عثمانی",
    'oto'   => "زبان\ اتومیایی",
    'pa'    => 'پنجابی',
    'paa'   => "زبان\ پاپوایی",
    'pag'   => 'پانگاسینانی',
    'pal'   => 'پهلوی',
    'pam'   => 'پامپانگایی',
    'pap'   => 'پاپیامنتو',
    'pau'   => 'پالائویی',
    'peo'   => "فارسی\ باستان",
    'phi'   => "زبان\ فیلیپینی",
    'phn'   => 'فنیقی',
    'pi'    => 'پالی',
    'pl'    => 'لهستانی',
    'pon'   => 'پناپی',
    'pra'   => "زبان\ پراکریتی",
    'pro'   => "پرووانسی\ باستان",
    'ps'    => 'پشتو',
    'pt'    => 'پرتغالی',
    'pt_br' => "پرتغالی\ برزیل",
    'pt_pt' => "پرتغالی\ پرتغال",
    'qu'    => 'کچوایی',
    'raj'   => 'راجستانی',
    'rap'   => 'راپانویی',
    'rar'   => 'راروتونگایی',
    'rm'    => 'رتو‐رومیایی',
    'rn'    => 'روندیایی',
    'ro'    => 'رومانیایی',
    'roa'   => "زبان\ رومیایی",
    'rom'   => 'رومانویی',
    'ru'    => 'روسی',
    'rup'   => 'Aromanian',
    'rw'    => 'کینیارواندایی',
    'sa'    => 'سنسکریت',
    'sad'   => 'سانداوه‌ای',
    'sah'   => 'یاقوتی',
    'sai'   => "زبان\ سرخپوستی\ امریکای\ جنوبی",
    'sal'   => "زبان\ سالیشی",
    'sam'   => "آرامی\ سامری",
    'sas'   => 'ساساکی',
    'sat'   => 'سانتالی',
    'sc'    => 'ساردینیایی',
    'scn'   => 'سیسیلی',
    'sco'   => 'اسکاتلندی',
    'sd'    => 'سندی',
    'se'    => "Northern\ Sami",
    'sel'   => 'سلکوپی',
    'sem'   => "زبان\ سامی",
    'sg'    => 'سانگویی',
    'sga'   => "ایرلندی\ باستان",
    'sgn'   => "زبان\ نشانه‌ای",
    'sh'    => "صرب\ و\ کرواتی",
    'shn'   => 'شانی',
    'si'    => 'سینهالی',
    'sid'   => 'سیدامویی',
    'sio'   => "زبان\ سویی",
    'sit'   => "زبان\ چین\ و\ تبتی",
    'sk'    => 'اسلواکی',
    'sl'    => 'اسلووینیایی',
    'sla'   => "زبان\ اسلاوی",
    'sm'    => 'ساموآیی',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'شونایی',
    'snk'   => 'سونینکه‌ای',
    'so'    => 'سومالیایی',
    'sog'   => 'سغدی',
    'son'   => 'سونغایی',
    'sq'    => 'آلبانیایی',
    'sr'    => 'صربی',
    'srn'   => 'تاکی‌تاکی',
    'srr'   => 'سریری',
    'ss'    => 'سوازیایی',
    'ssa'   => "زبان\ نیلی\ و\ صحرایی",
    'st'    => "سوتویی\ جنوبی",
    'su'    => 'سوندایی',
    'suk'   => 'سوکومایی',
    'sus'   => 'سوسویی',
    'sux'   => 'سومری',
    'sv'    => 'سوئدی',
    'sw'    => 'سواحلی',
    'syc'   => "سریانی\ کلاسیک",
    'syr'   => 'سریانی',
    'ta'    => 'تامیلی',
    'tai'   => "زبان\ تایی",
    'te'    => 'تلوگویی',
    'tem'   => 'تمنه‌ای',
    'ter'   => 'ترنو',
    'tet'   => 'تتومی',
    'tg'    => 'تاجیکی',
    'th'    => 'تایلندی',
    'ti'    => 'تیگرینیایی',
    'tig'   => 'تیگره‌ای',
    'tiv'   => 'تیوی',
    'tk'    => 'ترکمنی',
    'tkl'   => 'Tokelau',
    'tl'    => 'تاگالوگی',
    'tlh'   => 'کلینگون',
    'tli'   => 'تلین‌گیتی',
    'tmh'   => 'تاماشقی',
    'tn'    => 'تسوانایی',
    'to'    => 'تونگایی',
    'tog'   => "تونگایی\ نیاسا",
    'tpi'   => "زبان\ توک\ پیسینی",
    'tr'    => 'ترکی',
    'trv'   => 'Taroko',
    'ts'    => 'تسونگایی',
    'tsi'   => 'تسیم‌شیانی',
    'tt'    => 'تاتاری',
    'tum'   => 'تومبوکایی',
    'tup'   => "زبان\ توپیایی",
    'tut'   => "زبان\ آلتاییک",
    'tvl'   => 'تووالویی',
    'tw'    => 'توی‌یایی',
    'ty'    => 'تاهیتیایی',
    'tyv'   => 'تووایی',
    'udm'   => 'اودمورتی',
    'ug'    => 'اویغوری',
    'uga'   => 'اوگاریتی',
    'uk'    => 'اوکراینی',
    'umb'   => 'امبوندویی',
    'und'   => "زبان\ نامشخص\ یا\ نامعتبر",
    'ur'    => 'اردو',
    'uz'    => 'ازبکی',
    'vai'   => 'ویایی',
    've'    => 'وندایی',
    'vi'    => 'ویتنامی',
    'vo'    => 'ولاپوک',
    'vot'   => 'وتی',
    'wa'    => 'والونی',
    'wak'   => "زبان\ واکاشی",
    'wal'   => 'والامو',
    'war'   => 'وارایی',
    'was'   => 'واشویی',
    'wen'   => "زبان\ صُربی",
    'wo'    => 'ولوفی',
    'xal'   => 'قلموقی',
    'xh'    => 'خوسایی',
    'yao'   => 'یائویی',
    'yap'   => 'یاپی',
    'yi'    => 'یدی',
    'yo'    => 'یوروبایی',
    'ypk'   => "زبان\ یوپیکی",
    'za'    => 'چوانگی',
    'zap'   => 'زاپوتکی',
    'zbl'   => 'Blissymbols',
    'zen'   => 'زناگا',
    'zh'    => 'چینی',
    'znd'   => 'زانده‌ای',
    'zu'    => 'زولویی',
    'zun'   => 'زونیایی',
    'zxx'   => "بدون\ محتوای\ زبانی",
    'zza'   => 'زازایی',
);

%Locales::DB::Language::fa::name_to_code = (
    'aromanian'                                            => 'rup',
    'asturian'                                             => 'ast',
    'atsam'                                                => 'cch',
    'awadhi'                                               => 'awa',
    'bamilekelanguage'                                     => 'bai',
    'blissymbols'                                          => 'zbl',
    'chamiclanguage'                                       => 'cmc',
    'chinookjargon'                                        => 'chn',
    'inarisami'                                            => 'smn',
    'karelian'                                             => 'krl',
    'kosraean'                                             => 'kos',
    'lulesami'                                             => 'smj',
    'mirandese'                                            => 'mwl',
    'morisyen'                                             => 'mfe',
    'nigerkordofanianlanguage'                             => 'nic',
    'northernsami'                                         => 'se',
    "n\â\\ko"                                         => 'nqo',
    'samilanguage'                                         => 'smi',
    'siksika'                                              => 'bla',
    'skoltsami'                                            => 'sms',
    'slave'                                                => 'den',
    'southernsami'                                         => 'sma',
    'taroko'                                               => 'trv',
    'tokelau'                                              => 'tkl',
    'آبخازی'                                         => 'ab',
    'آدانگمه‌ای'                                => 'ada',
    'آدیجیایی'                                     => 'ady',
    'آذربایجانی'                                 => 'az',
    'آرامی'                                           => 'arc',
    'آرامیسامری'                                 => 'sam',
    'آراواکی'                                       => 'arw',
    'آراپاهویی'                                   => 'arp',
    'آراگونزی'                                     => 'an',
    'آروکانیایی'                                 => 'arn',
    'آسامی'                                           => 'as',
    'آسی'                                               => 'os',
    'آفاری'                                           => 'aa',
    'آفریهیلی'                                     => 'afh',
    'آفریکانس'                                     => 'af',
    'آلئوتی'                                         => 'ale',
    'آلبانیایی'                                   => 'sq',
    'آلتاییجنوبی'                               => 'alt',
    'آلمانی'                                         => 'de',
    'آلمانیاتریش'                               => 'de_at',
    'آلمانیسفلی'                                 => 'nds',
    'آلمانیسوئیسی'                             => 'gsw',
    'آلمانیعلیایباستان'                   => 'goh',
    'آلمانیعلیایسوئیس'                     => 'de_ch',
    'آلمانیعلیایمیانه'                     => 'gmh',
    'آنگیکایی'                                     => 'anp',
    'آواری'                                           => 'av',
    'آچئی'                                             => 'ace',
    'آچولیایی'                                     => 'ach',
    'آکان'                                             => 'ak',
    'آکدی'                                             => 'akk',
    'آیبن'                                             => 'iba',
    'آیمارایی'                                     => 'ay',
    'آینویی'                                         => 'ain',
    'اردو'                                             => 'ur',
    'ارزیایی'                                       => 'myv',
    'ارمنی'                                           => 'hy',
    'ازبکی'                                           => 'uz',
    'استونیایی'                                   => 'et',
    'اسلاویکلیسایی'                           => 'cu',
    'اسلواکی'                                       => 'sk',
    'اسلووینیایی'                               => 'sl',
    'اسپانیایی'                                   => 'es',
    'اسپانیاییاسپانیا'                     => 'es_es',
    'اسپرانتو'                                     => 'eo',
    'اسکاتلندی'                                   => 'sco',
    'افیکی'                                           => 'efi',
    'امبوندویی'                                   => 'umb',
    'امهری'                                           => 'am',
    'انده‌بله‌ایجنوبی'                   => 'nr',
    'انده‌بله‌ایشمالی'                   => 'nd',
    'اندونزیایی'                                 => 'id',
    'اندونگایی'                                   => 'ng',
    'انگلیسی'                                       => 'en',
    'انگلیسیاسترالیا'                       => 'en_au',
    'انگلیسیامریکا'                           => 'en_us',
    'انگلیسیباستان'                           => 'ang',
    'انگلیسیمیانه'                             => 'enm',
    'انگلیسیکانادا'                           => 'en_ca',
    'اواندو'                                         => 'ewo',
    'اوجیبوایی'                                   => 'oj',
    'اودمورتی'                                     => 'udm',
    'اورومویی'                                     => 'om',
    'اوریه‌ای'                                    => 'or',
    'اوستایی'                                       => 'ae',
    'اوسیجی'                                         => 'osa',
    'اوه‌ای'                                        => 'ee',
    'اوکراینی'                                     => 'uk',
    'اوکیتایی'                                     => 'oc',
    'اوگاریتی'                                     => 'uga',
    'اویغوری'                                       => 'ug',
    'اکاجوک'                                         => 'eka',
    'اکسیدنتال'                                   => 'ie',
    'ایتالیایی'                                   => 'it',
    'ایجویی'                                         => 'ijo',
    'ایدو'                                             => 'io',
    'ایرلندی'                                       => 'ga',
    'ایرلندیباستان'                           => 'sga',
    'ایرلندیمیانه'                             => 'mga',
    'ایسلندی'                                       => 'is',
    'ایلوکویی'                                     => 'ilo',
    'اینوپیک'                                       => 'ik',
    'اینوکتیتوت'                                 => 'iu',
    'اینگوشی'                                       => 'inh',
    'ایگبویی'                                       => 'ig',
    'باتاکی'                                         => 'btk',
    'باسایی'                                         => 'bas',
    'باسکی'                                           => 'eu',
    'باشغیری'                                       => 'ba',
    'بالیایی'                                       => 'ban',
    'بامبارایی'                                   => 'bm',
    'بانتویی'                                       => 'bnt',
    'باندایی'                                       => 'bad',
    'بجایی'                                           => 'bej',
    'بدونمحتوایزبانی'                       => 'zxx',
    'براج'                                             => 'bra',
    'بربری'                                           => 'ber',
    'برتانیایی'                                   => 'br',
    'برمه‌ای'                                      => 'my',
    'بلغاری'                                         => 'bg',
    'بلوروسی'                                       => 'be',
    'بلوچی'                                           => 'bal',
    'بلین'                                             => 'byn',
    'بمبایی'                                         => 'bem',
    'بنگالی'                                         => 'bn',
    'بوجپوری'                                       => 'bho',
    'بوریاتی'                                       => 'bua',
    'بوسنیایی'                                     => 'bs',
    'بوکسمالنروژی'                             => 'nb',
    'بوگیایی'                                       => 'bug',
    'بیسلاما'                                       => 'bi',
    'بینی'                                             => 'bin',
    'بیهاری'                                         => 'bh',
    'بیکولی'                                         => 'bik',
    'تاتاری'                                         => 'tt',
    'تاجیکی'                                         => 'tg',
    'تاماشقی'                                       => 'tmh',
    'تامیلی'                                         => 'ta',
    'تاهیتیایی'                                   => 'ty',
    'تاکی‌تاکی'                                  => 'srn',
    'تاگالوگی'                                     => 'tl',
    'تایلندی'                                       => 'th',
    'تایپهای'                                       => 'kcg',
    'تبتی'                                             => 'bo',
    'تتومی'                                           => 'tet',
    'ترنو'                                             => 'ter',
    'تروکی'                                           => 'chk',
    'ترکمنی'                                         => 'tk',
    'ترکی'                                             => 'tr',
    'ترکیعثمانی'                                 => 'ota',
    'ترکیکریمه'                                   => 'crh',
    'تسوانایی'                                     => 'tn',
    'تسونگایی'                                     => 'ts',
    'تسیم‌شیانی'                                => 'tsi',
    'تلوگویی'                                       => 'te',
    'تلین‌گیتی'                                  => 'tli',
    'تمنه‌ای'                                      => 'tem',
    'تومبوکایی'                                   => 'tum',
    'تونگایی'                                       => 'to',
    'تونگایینیاسا'                             => 'tog',
    'تووالویی'                                     => 'tvl',
    'تووایی'                                         => 'tyv',
    'توی‌یایی'                                    => 'tw',
    'تیوی'                                             => 'tiv',
    'تیگره‌ای'                                    => 'tig',
    'تیگرینیایی'                                 => 'ti',
    'جاوه‌ای'                                      => 'jv',
    'جغتایی'                                         => 'chg',
    'جو'                                                 => 'kaj',
    'جونخایی'                                       => 'dz',
    'خاسیایی'                                       => 'kha',
    'ختنی'                                             => 'kho',
    'خمری'                                             => 'km',
    'خوسایی'                                         => 'xh',
    'دارقینی'                                       => 'dar',
    'دانمارکی'                                     => 'da',
    'داکوتایی'                                     => 'dak',
    'دایاک'                                           => 'day',
    'دایولایی'                                     => 'dyu',
    'دلاواری'                                       => 'del',
    'دوآلایی'                                       => 'dua',
    'دوگری'                                           => 'doi',
    'دوگریب'                                         => 'dgr',
    'دینکایی'                                       => 'din',
    'راجستانی'                                     => 'raj',
    'راروتونگایی'                               => 'rar',
    'راپانویی'                                     => 'rap',
    'رتو‐رومیایی'                              => 'rm',
    'روسی'                                             => 'ru',
    'رومانویی'                                     => 'rom',
    'رومانیایی'                                   => 'ro',
    'روندیایی'                                     => 'rn',
    'زازایی'                                         => 'zza',
    'زانده‌ای'                                    => 'znd',
    'زاپوتکی'                                       => 'zap',
    'زبانآتاپاسکایی'                         => 'ath',
    'زبانآسترونیزیایی'                     => 'map',
    'زبانآلتاییک'                               => 'tut',
    'زبانآلگونکینی'                           => 'alg',
    'زبانآپاچیایی'                             => 'apa',
    'زباناتومیایی'                             => 'oto',
    'زباناسترالیایی'                         => 'aus',
    'زباناسلاوی'                                 => 'sla',
    'زبانافریقاوآسیایی'                   => 'afa',
    'زبانایرانی'                                 => 'ira',
    'زبانایروکوایی'                           => 'iro',
    'زبانبالتیکی'                               => 'bat',
    'زبانتایی'                                     => 'tai',
    'زبانتوپیایی'                               => 'tup',
    'زبانتوکپیسینی'                           => 'tpi',
    'زبانخواسی'                                   => 'khi',
    'زباندراویدی'                               => 'dra',
    'زبانرومیایی'                               => 'roa',
    'زبانساختگی'                                 => 'art',
    'زبانسالیشی'                                 => 'sal',
    'زبانسامی'                                     => 'sem',
    'زبانسرخپوستیامریکایجنوبی'     => 'sai',
    'زبانسرخپوستیامریکایشمالی'     => 'nai',
    'زبانسرخپوستیامریکایمرکزی'     => 'cai',
    'زبانسلتی'                                     => 'cel',
    'زبانسویی'                                     => 'sio',
    'زبانصُربی'                                   => 'wen',
    'زبانفیلیپینی'                             => 'phi',
    'زبانفینواوگرایی'                       => 'fiu',
    'زبانقفقازی'                                 => 'cau',
    'زبانمانوبو'                                 => 'mno',
    'زبانمایایی'                                 => 'myn',
    'زبانمتفرقه'                                 => 'mis',
    'زبانموندایی'                               => 'mun',
    'زبانمون‌خمری'                            => 'mkh',
    'زباننامشخصیانامعتبر'               => 'und',
    'زباننشانه‌ای'                            => 'sgn',
    'زباننوبیایی'                               => 'nub',
    'زباننیلیوصحرایی'                       => 'ssa',
    'زبانهندواروپایی'                       => 'ine',
    'زبانهندیک'                                   => 'inc',
    'زبانواکاشی'                                 => 'wak',
    'زبانپاپوایی'                               => 'paa',
    'زبانپراکریتی'                             => 'pra',
    'زبانچینوتبتی'                             => 'sit',
    'زبانژرمنی'                                   => 'gem',
    'زبانکوشی'                                     => 'cus',
    'زبانیوپیکی'                                 => 'ypk',
    'زناگا'                                           => 'zen',
    'زولویی'                                         => 'zu',
    'زونیایی'                                       => 'zun',
    'ساردینیایی'                                 => 'sc',
    'ساساکی'                                         => 'sas',
    'ساموآیی'                                       => 'sm',
    'سانتالی'                                       => 'sat',
    'سانداوه‌ای'                                => 'sad',
    'سانگویی'                                       => 'sg',
    'سبویی'                                           => 'ceb',
    'سریانی'                                         => 'syr',
    'سریانیکلاسیک'                             => 'syc',
    'سریری'                                           => 'srr',
    'سغدی'                                             => 'sog',
    'سلکوپی'                                         => 'sel',
    'سندی'                                             => 'sd',
    'سنسکریت'                                       => 'sa',
    'سوئدی'                                           => 'sv',
    'سواحلی'                                         => 'sw',
    'سوازیایی'                                     => 'ss',
    'سوتوییجنوبی'                               => 'st',
    'سوتوییشمالی'                               => 'nso',
    'سوسویی'                                         => 'sus',
    'سومالیایی'                                   => 'so',
    'سومری'                                           => 'sux',
    'سوندایی'                                       => 'su',
    'سونغایی'                                       => 'son',
    'سونینکه‌ای'                                => 'snk',
    'سوکومایی'                                     => 'suk',
    'سیدامویی'                                     => 'sid',
    'سیسیلی'                                         => 'scn',
    'سینهالی'                                       => 'si',
    'شانی'                                             => 'shn',
    'شایانی'                                         => 'chy',
    'شونایی'                                         => 'sn',
    'صربوکرواتی'                                 => 'sh',
    'صربی'                                             => 'sr',
    'صُربیسفلی'                                   => 'dsb',
    'صُربیعلیا'                                   => 'hsb',
    'عبری'                                             => 'he',
    'عربی'                                             => 'ar',
    'عربییهودی'                                   => 'jrb',
    'عیلامی'                                         => 'elx',
    'فارسی'                                           => 'fa',
    'فارسیباستان'                               => 'peo',
    'فارسییهودی'                                 => 'jpr',
    'فارویی'                                         => 'fo',
    'فانتیایی'                                     => 'fat',
    'فانکی'                                           => 'fan',
    'فرانسوی'                                       => 'fr',
    'فرانسویباستان'                           => 'fro',
    'فرانسویسوئیس'                             => 'fr_ch',
    'فرانسویمیانه'                             => 'frm',
    'فرانسویکانادا'                           => 'fr_ca',
    'فریزیشرقی'                                   => 'frs',
    'فریزیشمالی'                                 => 'frr',
    'فریزیغربی'                                   => 'fy',
    'فریولیایی'                                   => 'fur',
    'فلمنگی'                                         => 'nl_be',
    'فنلاندی'                                       => 'fi',
    'فنیقی'                                           => 'phn',
    'فولایی'                                         => 'ff',
    'فونی'                                             => 'fon',
    'فیجیایی'                                       => 'fj',
    'فیلیپینی'                                     => 'fil',
    'قبایلی'                                         => 'kab',
    'قبطی'                                             => 'cop',
    'قرقیزی'                                         => 'ky',
    'قره‌قالپاقی'                              => 'kaa',
    'قره‌چایی‐بالکاری'                   => 'krc',
    'قزاقی'                                           => 'kk',
    'قلموقی'                                         => 'xal',
    'لائوسی'                                         => 'lo',
    'لاتینی'                                         => 'la',
    'لادینو'                                         => 'lad',
    'لامبا'                                           => 'lam',
    'لاهندا'                                         => 'lah',
    'لتونیایی'                                     => 'lv',
    'لزگی'                                             => 'lez',
    'لهستانی'                                       => 'pl',
    'لوئویی'                                         => 'luo',
    'لوبایی‐لولوا'                            => 'lua',
    'لوبایی‐کاتانگا'                        => 'lu',
    'لوجبان'                                         => 'jbo',
    'لوزیایی'                                       => 'loz',
    'لوشه‌ای'                                      => 'lus',
    'لوندایی'                                       => 'lun',
    'لوگزامبورگی'                               => 'lb',
    'لویسنو'                                         => 'lui',
    'لیتوانیایی'                                 => 'lt',
    'لیمبورگی'                                     => 'li',
    'لینگالا'                                       => 'ln',
    'مائوریایی'                                   => 'mi',
    'مادورایی'                                     => 'mad',
    'مارشالی'                                       => 'mh',
    'مارواری'                                       => 'mwr',
    'ماریایی'                                       => 'chm',
    'ماسایی'                                         => 'mas',
    'ماسیایی'                                       => 'mos',
    'مالاگاسیایی'                               => 'mg',
    'مالایالامی'                                 => 'ml',
    'مالتی'                                           => 'mt',
    'مالدیوی'                                       => 'dv',
    'مالزیایی'                                     => 'ms',
    'ماندار'                                         => 'mdr',
    'ماندینگویی'                                 => 'man',
    'مانچویی'                                       => 'mnc',
    'مانی'                                             => 'gv',
    'ماکاسار'                                       => 'mak',
    'ماگاهیایی'                                   => 'mag',
    'مایدیلی'                                       => 'mai',
    'مجاری'                                           => 'hu',
    'مراتی'                                           => 'mr',
    'مصریکهن'                                       => 'egy',
    'مغولی'                                           => 'mn',
    'مقدونی'                                         => 'mk',
    'منده‌ای'                                      => 'men',
    'موتوییهیری'                                 => 'ho',
    'مولداویایی'                                 => 'mo',
    'مونگویی'                                       => 'lol',
    'موهاکی'                                         => 'moh',
    'مکشایی'                                         => 'mdf',
    'میان‌زبان'                                  => 'ia',
    'میته‌ای'                                      => 'mni',
    'مینانگ‌کابویی'                          => 'min',
    'میکماکی'                                       => 'mic',
    'نائورویی'                                     => 'na',
    'ناواتلی'                                       => 'nah',
    'ناواهویی'                                     => 'nv',
    'ناپلی'                                           => 'nap',
    'نرسباستان'                                   => 'non',
    'نرسجدیدنروژی'                             => 'nn',
    'نروژی'                                           => 'no',
    'نزیمایی'                                       => 'nzi',
    'نغایی'                                           => 'nog',
    'نواریایی'                                     => 'new',
    'نواریاییکلاسیک'                         => 'nwc',
    'نپالی'                                           => 'ne',
    'نگلیسیبریتانیا'                         => 'en_gb',
    'نیاسی'                                           => 'nia',
    'نیام‌وزیایی'                              => 'nym',
    'نیانجایی'                                     => 'ny',
    'نیانکوله‌ای'                              => 'nyn',
    'نیورویی'                                       => 'nyo',
    'نیویی'                                           => 'niu',
    'هائیتیایی'                                   => 'ht',
    'هاوائیایی'                                   => 'haw',
    'هایدایی'                                       => 'hai',
    'هریرویی'                                       => 'hz',
    'هلندی'                                           => 'nl',
    'هلندیمیانه'                                 => 'dum',
    'همونگ'                                           => 'hmn',
    'هندی'                                             => 'hi',
    'هوسیایی'                                       => 'ha',
    'هوپا'                                             => 'hup',
    'هیتی'                                             => 'hit',
    'هیلی‌گاینونی'                            => 'hil',
    'هیماچالی'                                     => 'him',
    'وارایی'                                         => 'war',
    'واشویی'                                         => 'was',
    'والامو'                                         => 'wal',
    'والونی'                                         => 'wa',
    'وتی'                                               => 'vot',
    'ولاپوک'                                         => 'vo',
    'ولوفی'                                           => 'wo',
    'وندایی'                                         => 've',
    'ویایی'                                           => 'vai',
    'ویتنامی'                                       => 'vi',
    'ویلزی'                                           => 'cy',
    'پالائویی'                                     => 'pau',
    'پالی'                                             => 'pi',
    'پامپانگایی'                                 => 'pam',
    'پانگاسینانی'                               => 'pag',
    'پاپیامنتو'                                   => 'pap',
    'پرتغالی'                                       => 'pt',
    'پرتغالیبرزیل'                             => 'pt_br',
    'پرتغالیپرتغال'                           => 'pt_pt',
    'پرووانسیباستان'                         => 'pro',
    'پشتو'                                             => 'ps',
    'پناپی'                                           => 'pon',
    'پنجابی'                                         => 'pa',
    'پهلوی'                                           => 'pal',
    'چامورویی'                                     => 'ch',
    'چروکیایی'                                     => 'chr',
    'چندینزبان'                                   => 'mul',
    'چوانگی'                                         => 'za',
    'چوواشی'                                         => 'cv',
    'چوکتویی'                                       => 'cho',
    'چچنی'                                             => 'ce',
    'چکی'                                               => 'cs',
    'چیبچا'                                           => 'chb',
    'چینی'                                             => 'zh',
    'چیپه‌ویه‌ای'                             => 'chp',
    'ژاپنی'                                           => 'ja',
    'کاباردینی'                                   => 'kbd',
    'کاتالونیایی'                               => 'ca',
    'کادویی'                                         => 'cad',
    'کارنی'                                           => 'kar',
    'کاریبی'                                         => 'car',
    'کاشوبی'                                         => 'csb',
    'کامبایی'                                       => 'kam',
    'کاناده‌ای'                                  => 'kn',
    'کانوریایی'                                   => 'kr',
    'کاویایی'                                       => 'kaw',
    'کاچینی'                                         => 'kac',
    'کردی'                                             => 'ku',
    'کرنوالی'                                       => 'kw',
    'کره‌ای'                                        => 'ko',
    'کرواتی'                                         => 'hr',
    'کرویی'                                           => 'kro',
    'کریایی'                                         => 'cr',
    'کریولیاپیجین'                             => 'crp',
    'کریولیاپیجینمبتنیبرانگلیسی' => 'cpe',
    'کریولیاپیجینمبتنیبرفرانسوی' => 'cpf',
    'کریولیاپیجینمبتنیبرپرتغالی' => 'cpp',
    'کریکی'                                           => 'mus',
    'کشمیری'                                         => 'ks',
    'کلینگون'                                       => 'tlh',
    'کنکانی'                                         => 'kok',
    'کنگویی'                                         => 'kg',
    'کوانیاما'                                     => 'kj',
    'کوتنی'                                           => 'kut',
    'کورسی'                                           => 'co',
    'کورو'                                             => 'kfo',
    'کوروخی'                                         => 'kru',
    'کومیایی'                                       => 'kv',
    'کومیکی'                                         => 'kum',
    'کپله‌ای'                                      => 'kpe',
    'کچوایی'                                         => 'qu',
    'کیمبوندویی'                                 => 'kmb',
    'کینیارواندایی'                           => 'rw',
    'کیکویویی'                                     => 'ki',
    'گالیسیایی'                                   => 'gl',
    'گاندایی'                                       => 'lg',
    'گایویی'                                         => 'gay',
    'گایی'                                             => 'gaa',
    'گبایایی'                                       => 'gba',
    'گجراتی'                                         => 'gu',
    'گرجی'                                             => 'ka',
    'گریبویی'                                       => 'grb',
    'گرینلندی'                                     => 'kl',
    'گوارانی'                                       => 'gn',
    'گوتی'                                             => 'got',
    'گورونتالو'                                   => 'gor',
    'گوندی'                                           => 'gon',
    'گویچاین'                                       => 'gwi',
    'گیلبرتی'                                       => 'gil',
    'گیلیاسکاتلندی'                           => 'gd',
    'گی‌ئزی'                                        => 'gez',
    'یائویی'                                         => 'yao',
    'یاقوتی'                                         => 'sah',
    'یاپی'                                             => 'yap',
    'یدی'                                               => 'yi',
    'یوروبایی'                                     => 'yo',
    'یونانی'                                         => 'el',
    'یونانیکهن'                                   => 'grc',
    'ییسیچوان'                                     => 'ii',
);

1;
