package Locales::DB::Language::eo;

# Auto generated from CLDR

$Locales::DB::Language::eo::VERSION = '0.01';

$Locales::DB::Language::eo::cldr_version = '1.7.1';

%Locales::DB::Language::eo::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Language\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "no\:n",
        'yesstr' => "yes\:y"
    },
);

%Locales::DB::Language::eo::code_to_name = (
    'aa'    => 'afara',
    'ab'    => 'abĥaza',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => 'afrikansa',
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'amhara',
    'an'    => 'Aragonese',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => 'araba',
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Artificial\ Language",
    'arw'   => 'Arawak',
    'as'    => 'asama',
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'ajmara',
    'az'    => 'azerbajĝana',
    'ba'    => 'baŝkira',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basa',
    'bat'   => "Baltic\ Language",
    'be'    => 'belorusa',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bg'    => 'bulgara',
    'bh'    => 'bihara',
    'bho'   => 'Bhojpuri',
    'bi'    => 'bislamo',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'bengala',
    'bnt'   => 'Bantu',
    'bo'    => 'tibeta',
    'br'    => 'bretona',
    'bra'   => 'Braj',
    'bs'    => 'bosnia',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'kataluna',
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ Language",
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'korsika',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'ĉeĥa',
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => 'kimra',
    'da'    => 'dana',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'day'   => 'Dayak',
    'de'    => 'germana',
    'de_at' => "Austrian\ German",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'Divehi',
    'dyu'   => 'Dyula',
    'dz'    => 'dzonko',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Ancient\ Egyptian",
    'eka'   => 'Ekajuk',
    'el'    => 'greka',
    'elx'   => 'Elamite',
    'en'    => 'angla',
    'en_au' => "Australian\ English",
    'en_ca' => "Canadian\ English",
    'en_gb' => "British\ English",
    'en_us' => "U\.S\.\ English",
    'enm'   => "Middle\ English",
    'eo'    => 'esperanto',
    'es'    => 'hispana',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'estona',
    'eu'    => 'eŭska',
    'ewo'   => 'Ewondo',
    'fa'    => 'persa',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'finna',
    'fil'   => 'filipina',
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'fiĝia',
    'fo'    => 'feroa',
    'fon'   => 'Fon',
    'fr'    => 'franca',
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "Swiss\ French",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => 'frisa',
    'ga'    => 'irlanda',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => 'gaela',
    'gem'   => "Germanic\ Language",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'galega',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'gvarania',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Ancient\ Greek",
    'gsw'   => "Swiss\ German",
    'gu'    => 'guĝarata',
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'haŭsa',
    'hai'   => 'Haida',
    'haw'   => 'Hawaiian',
    'he'    => 'hebrea',
    'hi'    => 'hinda',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'kroata',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => 'hungara',
    'hup'   => 'Hupa',
    'hy'    => 'armena',
    'hz'    => 'Herero',
    'ia'    => 'interlingvao',
    'iba'   => 'Iban',
    'id'    => 'indonezia',
    'ie'    => 'okcidentalo',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'eskima',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'islanda',
    'it'    => 'itala',
    'iu'    => 'inuita',
    'ja'    => 'japana',
    'jbo'   => 'Lojban',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'java',
    'ka'    => 'kartvela',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'kazaĥa',
    'kl'    => 'gronlanda',
    'km'    => 'kmera',
    'kmb'   => 'Kimbundu',
    'kn'    => 'kanara',
    'ko'    => 'korea',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'kaŝmira',
    'ku'    => 'kurda',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'kirgiza',
    'la'    => 'latino',
    'lad'   => 'Ladino',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxembourgish',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'lingala',
    'lo'    => 'laŭa',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'litova',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'lv'    => 'latva',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'malagasa',
    'mga'   => "Middle\ Irish",
    'mh'    => 'Marshallese',
    'mi'    => 'maoria',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => 'makedona',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'malajalama',
    'mn'    => 'mongola',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'Moldavian',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'marata',
    'ms'    => 'malaja',
    'mt'    => 'malta',
    'mul'   => "Multiple\ Languages",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'birma',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'naura',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'nb'    => "Norwegian\ Bokm\Ã\¥l",
    'nd'    => "North\ Ndebele",
    'nds'   => "Low\ German",
    'ne'    => 'nepala',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'nederlanda',
    'nl_be' => 'Flemish',
    'nn'    => 'novnorvega',
    'no'    => 'norvega',
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Nubian\ Language",
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'okcitana',
    'oj'    => 'Ojibwa',
    'om'    => 'oroma',
    'or'    => 'orijo',
    'os'    => 'Ossetic',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'panĝaba',
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => 'pola',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'paŝtua',
    'pt'    => 'portugala',
    'pt_br' => 'brazilportugala',
    'pt_pt' => 'portugalportugala',
    'qu'    => 'keĉua',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => 'romanĉa',
    'rn'    => 'burunda',
    'ro'    => 'rumana',
    'roa'   => "Romance\ Language",
    'rom'   => 'Romany',
    'ru'    => 'rusa',
    'rup'   => 'Aromanian',
    'rw'    => 'ruanda',
    'sa'    => 'sanskrito',
    'sad'   => 'Sandawe',
    'sah'   => 'Yakut',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => 'sinda',
    'se'    => "Northern\ Sami",
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'sg'    => 'sangoa',
    'sga'   => "Old\ Irish",
    'sgn'   => "Sign\ Language",
    'sh'    => "serbo\-Kroata",
    'shn'   => 'Shan',
    'si'    => 'sinhala',
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => 'slovaka',
    'sl'    => 'slovena',
    'sla'   => "Slavic\ Language",
    'sm'    => 'samoa',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'ŝona',
    'snk'   => 'Soninke',
    'so'    => 'somala',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'albana',
    'sr'    => 'serba',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'svazia',
    'ssa'   => "Nilo\-Saharan\ Language",
    'st'    => 'sota',
    'su'    => 'sunda',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => 'sveda',
    'sw'    => 'svahila',
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'tamila',
    'tai'   => "Tai\ Language",
    'te'    => 'telugua',
    'tem'   => 'Timne',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'taĝika',
    'th'    => 'taja',
    'ti'    => 'tigraja',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'turkmena',
    'tkl'   => 'Tokelau',
    'tl'    => 'tagaloga',
    'tlh'   => 'klingona',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'cvana',
    'to'    => 'tongaa',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'turka',
    'trv'   => 'Taroko',
    'ts'    => 'conga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'tatara',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'akana',
    'ty'    => 'Tahitian',
    'tyv'   => 'Tuvinian',
    'udm'   => 'Udmurt',
    'ug'    => 'ujgura',
    'uga'   => 'Ugaritic',
    'uk'    => 'ukraina',
    'umb'   => 'Umbundu',
    'und'   => "Unknown\ or\ Invalid\ Language",
    'ur'    => 'urduo',
    'uz'    => 'uzbeka',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'vjetnama',
    'vo'    => 'volapuko',
    'vot'   => 'Votic',
    'wa'    => 'Walloon',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'volofa',
    'xal'   => 'Kalmyk',
    'xh'    => 'ksosa',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yi'    => 'jida',
    'yo'    => 'joruba',
    'ypk'   => "Yupik\ Language",
    'za'    => 'ĝuanga',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'ĉina',
    'znd'   => 'Zande',
    'zu'    => 'zulua',
    'zun'   => 'Zuni',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::eo::name_to_code = (
    'abĥaza'                       => 'ab',
    'achinese'                      => 'ace',
    'acoli'                         => 'ach',
    'adangme'                       => 'ada',
    'adyghe'                        => 'ady',
    'afara'                         => 'aa',
    'afrihili'                      => 'afh',
    'afrikansa'                     => 'af',
    'afroasiaticlanguage'           => 'afa',
    'ainu'                          => 'ain',
    'ajmara'                        => 'ay',
    'akan'                          => 'ak',
    'akana'                         => 'tw',
    'akkadian'                      => 'akk',
    'albana'                        => 'sq',
    'aleut'                         => 'ale',
    'algonquianlanguage'            => 'alg',
    'altaiclanguage'                => 'tut',
    'amhara'                        => 'am',
    'ancientegyptian'               => 'egy',
    'ancientgreek'                  => 'grc',
    'angika'                        => 'anp',
    'angla'                         => 'en',
    'apachelanguage'                => 'apa',
    'araba'                         => 'ar',
    'aragonese'                     => 'an',
    'aramaic'                       => 'arc',
    'arapaho'                       => 'arp',
    'araucanian'                    => 'arn',
    'arawak'                        => 'arw',
    'armena'                        => 'hy',
    'aromanian'                     => 'rup',
    'artificiallanguage'            => 'art',
    'asama'                         => 'as',
    'asturian'                      => 'ast',
    'athapascanlanguage'            => 'ath',
    'atsam'                         => 'cch',
    'australianenglish'             => 'en_au',
    'australianlanguage'            => 'aus',
    'austriangerman'                => 'de_at',
    'austronesianlanguage'          => 'map',
    'avaric'                        => 'av',
    'avestan'                       => 'ae',
    'awadhi'                        => 'awa',
    'azerbajĝana'                  => 'az',
    'balinese'                      => 'ban',
    'balticlanguage'                => 'bat',
    'baluchi'                       => 'bal',
    'bambara'                       => 'bm',
    'bamilekelanguage'              => 'bai',
    'banda'                         => 'bad',
    'bantu'                         => 'bnt',
    'basa'                          => 'bas',
    'batak'                         => 'btk',
    'baŝkira'                      => 'ba',
    'beja'                          => 'bej',
    'belorusa'                      => 'be',
    'bemba'                         => 'bem',
    'bengala'                       => 'bn',
    'berber'                        => 'ber',
    'bhojpuri'                      => 'bho',
    'bihara'                        => 'bh',
    'bikol'                         => 'bik',
    'bini'                          => 'bin',
    'birma'                         => 'my',
    'bislamo'                       => 'bi',
    'blin'                          => 'byn',
    'blissymbols'                   => 'zbl',
    'bosnia'                        => 'bs',
    'braj'                          => 'bra',
    'brazilportugala'               => 'pt_br',
    'bretona'                       => 'br',
    'britishenglish'                => 'en_gb',
    'buginese'                      => 'bug',
    'bulgara'                       => 'bg',
    'buriat'                        => 'bua',
    'burunda'                       => 'rn',
    'caddo'                         => 'cad',
    'canadianenglish'               => 'en_ca',
    'canadianfrench'                => 'fr_ca',
    'carib'                         => 'car',
    'caucasianlanguage'             => 'cau',
    'cebuano'                       => 'ceb',
    'celticlanguage'                => 'cel',
    'centralamericanindianlanguage' => 'cai',
    'chagatai'                      => 'chg',
    'chamiclanguage'                => 'cmc',
    'chamorro'                      => 'ch',
    'chechen'                       => 'ce',
    'cherokee'                      => 'chr',
    'cheyenne'                      => 'chy',
    'chibcha'                       => 'chb',
    'chinookjargon'                 => 'chn',
    'chipewyan'                     => 'chp',
    'choctaw'                       => 'cho',
    'churchslavic'                  => 'cu',
    'chuukese'                      => 'chk',
    'chuvash'                       => 'cv',
    'classicalnewari'               => 'nwc',
    'classicalsyriac'               => 'syc',
    'conga'                         => 'ts',
    'coptic'                        => 'cop',
    'cornish'                       => 'kw',
    'cree'                          => 'cr',
    'creek'                         => 'mus',
    'creoleorpidgin'                => 'crp',
    'crimeanturkish'                => 'crh',
    'cushiticlanguage'              => 'cus',
    'cvana'                         => 'tn',
    'dakota'                        => 'dak',
    'dana'                          => 'da',
    'dargwa'                        => 'dar',
    'dayak'                         => 'day',
    'delaware'                      => 'del',
    'dinka'                         => 'din',
    'divehi'                        => 'dv',
    'dogri'                         => 'doi',
    'dogrib'                        => 'dgr',
    'dravidianlanguage'             => 'dra',
    'duala'                         => 'dua',
    'dyula'                         => 'dyu',
    'dzonko'                        => 'dz',
    'easternfrisian'                => 'frs',
    'efik'                          => 'efi',
    'ekajuk'                        => 'eka',
    'elamite'                       => 'elx',
    'englishbasedcreoleorpidgin'    => 'cpe',
    'erzya'                         => 'myv',
    'eskima'                        => 'ik',
    'esperanto'                     => 'eo',
    'estona'                        => 'et',
    'ewe'                           => 'ee',
    'ewondo'                        => 'ewo',
    'eŭska'                        => 'eu',
    'fang'                          => 'fan',
    'fanti'                         => 'fat',
    'feroa'                         => 'fo',
    'filipina'                      => 'fil',
    'finna'                         => 'fi',
    'finnougrianlanguage'           => 'fiu',
    'fiĝia'                        => 'fj',
    'flemish'                       => 'nl_be',
    'fon'                           => 'fon',
    'franca'                        => 'fr',
    'frenchbasedcreoleorpidgin'     => 'cpf',
    'frisa'                         => 'fy',
    'friulian'                      => 'fur',
    'fulah'                         => 'ff',
    'ga'                            => 'gaa',
    'gaela'                         => 'gd',
    'galega'                        => 'gl',
    'ganda'                         => 'lg',
    'gayo'                          => 'gay',
    'gbaya'                         => 'gba',
    'geez'                          => 'gez',
    'germana'                       => 'de',
    'germaniclanguage'              => 'gem',
    'gilbertese'                    => 'gil',
    'gondi'                         => 'gon',
    'gorontalo'                     => 'gor',
    'gothic'                        => 'got',
    'grebo'                         => 'grb',
    'greka'                         => 'el',
    'gronlanda'                     => 'kl',
    'guĝarata'                     => 'gu',
    'gvarania'                      => 'gn',
    "gwich\Ê\¼in"                 => 'gwi',
    'haida'                         => 'hai',
    'haitian'                       => 'ht',
    'hawaiian'                      => 'haw',
    'haŭsa'                        => 'ha',
    'hebrea'                        => 'he',
    'herero'                        => 'hz',
    'hiligaynon'                    => 'hil',
    'himachali'                     => 'him',
    'hinda'                         => 'hi',
    'hirimotu'                      => 'ho',
    'hispana'                       => 'es',
    'hittite'                       => 'hit',
    'hmong'                         => 'hmn',
    'hungara'                       => 'hu',
    'hupa'                          => 'hup',
    'iban'                          => 'iba',
    'iberianspanish'                => 'es_es',
    'ido'                           => 'io',
    'igbo'                          => 'ig',
    'ijo'                           => 'ijo',
    'iloko'                         => 'ilo',
    'inarisami'                     => 'smn',
    'indiclanguage'                 => 'inc',
    'indoeuropeanlanguage'          => 'ine',
    'indonezia'                     => 'id',
    'ingush'                        => 'inh',
    'interlingvao'                  => 'ia',
    'inuita'                        => 'iu',
    'iranianlanguage'               => 'ira',
    'irlanda'                       => 'ga',
    'iroquoianlanguage'             => 'iro',
    'islanda'                       => 'is',
    'itala'                         => 'it',
    'japana'                        => 'ja',
    'java'                          => 'jv',
    'jida'                          => 'yi',
    'jju'                           => 'kaj',
    'joruba'                        => 'yo',
    'judeoarabic'                   => 'jrb',
    'judeopersian'                  => 'jpr',
    'kabardian'                     => 'kbd',
    'kabyle'                        => 'kab',
    'kachin'                        => 'kac',
    'kalmyk'                        => 'xal',
    'kamba'                         => 'kam',
    'kanara'                        => 'kn',
    'kanuri'                        => 'kr',
    'karachaybalkar'                => 'krc',
    'karakalpak'                    => 'kaa',
    'karelian'                      => 'krl',
    'karen'                         => 'kar',
    'kartvela'                      => 'ka',
    'kashubian'                     => 'csb',
    'kataluna'                      => 'ca',
    'kawi'                          => 'kaw',
    'kazaĥa'                       => 'kk',
    'kaŝmira'                      => 'ks',
    'keĉua'                        => 'qu',
    'khasi'                         => 'kha',
    'khoisanlanguage'               => 'khi',
    'khotanese'                     => 'kho',
    'kikuyu'                        => 'ki',
    'kimbundu'                      => 'kmb',
    'kimra'                         => 'cy',
    'kirgiza'                       => 'ky',
    'klingona'                      => 'tlh',
    'kmera'                         => 'km',
    'komi'                          => 'kv',
    'kongo'                         => 'kg',
    'konkani'                       => 'kok',
    'korea'                         => 'ko',
    'koro'                          => 'kfo',
    'korsika'                       => 'co',
    'kosraean'                      => 'kos',
    'kpelle'                        => 'kpe',
    'kroata'                        => 'hr',
    'kru'                           => 'kro',
    'ksosa'                         => 'xh',
    'kuanyama'                      => 'kj',
    'kumyk'                         => 'kum',
    'kurda'                         => 'ku',
    'kurukh'                        => 'kru',
    'kutenai'                       => 'kut',
    'ladino'                        => 'lad',
    'lahnda'                        => 'lah',
    'lamba'                         => 'lam',
    'latino'                        => 'la',
    'latva'                         => 'lv',
    'laŭa'                         => 'lo',
    'lezghian'                      => 'lez',
    'limburgish'                    => 'li',
    'lingala'                       => 'ln',
    'litova'                        => 'lt',
    'lojban'                        => 'jbo',
    'lowersorbian'                  => 'dsb',
    'lowgerman'                     => 'nds',
    'lozi'                          => 'loz',
    'lubakatanga'                   => 'lu',
    'lubalulua'                     => 'lua',
    'luiseno'                       => 'lui',
    'lulesami'                      => 'smj',
    'lunda'                         => 'lun',
    'luo'                           => 'luo',
    'lushai'                        => 'lus',
    'luxembourgish'                 => 'lb',
    'madurese'                      => 'mad',
    'magahi'                        => 'mag',
    'maithili'                      => 'mai',
    'makasar'                       => 'mak',
    'makedona'                      => 'mk',
    'malagasa'                      => 'mg',
    'malaja'                        => 'ms',
    'malajalama'                    => 'ml',
    'malta'                         => 'mt',
    'manchu'                        => 'mnc',
    'mandar'                        => 'mdr',
    'mandingo'                      => 'man',
    'manipuri'                      => 'mni',
    'manobolanguage'                => 'mno',
    'manx'                          => 'gv',
    'maoria'                        => 'mi',
    'marata'                        => 'mr',
    'mari'                          => 'chm',
    'marshallese'                   => 'mh',
    'marwari'                       => 'mwr',
    'masai'                         => 'mas',
    'mayanlanguage'                 => 'myn',
    'mende'                         => 'men',
    'micmac'                        => 'mic',
    'middledutch'                   => 'dum',
    'middleenglish'                 => 'enm',
    'middlefrench'                  => 'frm',
    'middlehighgerman'              => 'gmh',
    'middleirish'                   => 'mga',
    'minangkabau'                   => 'min',
    'mirandese'                     => 'mwl',
    'miscellaneouslanguage'         => 'mis',
    'mohawk'                        => 'moh',
    'moksha'                        => 'mdf',
    'moldavian'                     => 'mo',
    'mongo'                         => 'lol',
    'mongola'                       => 'mn',
    'monkhmerlanguage'              => 'mkh',
    'morisyen'                      => 'mfe',
    'mossi'                         => 'mos',
    'multiplelanguages'             => 'mul',
    'mundalanguage'                 => 'mun',
    'nahuatl'                       => 'nah',
    'naura'                         => 'na',
    'navajo'                        => 'nv',
    'ndonga'                        => 'ng',
    'neapolitan'                    => 'nap',
    'nederlanda'                    => 'nl',
    'nepala'                        => 'ne',
    'newari'                        => 'new',
    'nias'                          => 'nia',
    'nigerkordofanianlanguage'      => 'nic',
    'nilosaharanlanguage'           => 'ssa',
    'niuean'                        => 'niu',
    'nogai'                         => 'nog',
    'nolinguisticcontent'           => 'zxx',
    'northamericanindianlanguage'   => 'nai',
    'northernfrisian'               => 'frr',
    'northernsami'                  => 'se',
    'northernsotho'                 => 'nso',
    'northndebele'                  => 'nd',
    'norvega'                       => 'no',
    "norwegianbokm\Ã\¥l"          => 'nb',
    'novnorvega'                    => 'nn',
    'nubianlanguage'                => 'nub',
    'nyamwezi'                      => 'nym',
    'nyanja'                        => 'ny',
    'nyankole'                      => 'nyn',
    'nyasatonga'                    => 'tog',
    'nyoro'                         => 'nyo',
    'nzima'                         => 'nzi',
    "n\â\\ko"                  => 'nqo',
    'ojibwa'                        => 'oj',
    'okcidentalo'                   => 'ie',
    'okcitana'                      => 'oc',
    'oldenglish'                    => 'ang',
    'oldfrench'                     => 'fro',
    'oldhighgerman'                 => 'goh',
    'oldirish'                      => 'sga',
    'oldnorse'                      => 'non',
    'oldpersian'                    => 'peo',
    "oldproven\Ã\§al"             => 'pro',
    'orijo'                         => 'or',
    'oroma'                         => 'om',
    'osage'                         => 'osa',
    'ossetic'                       => 'os',
    'otomianlanguage'               => 'oto',
    'ottomanturkish'                => 'ota',
    'pahlavi'                       => 'pal',
    'palauan'                       => 'pau',
    'pali'                          => 'pi',
    'pampanga'                      => 'pam',
    'pangasinan'                    => 'pag',
    'panĝaba'                      => 'pa',
    'papiamento'                    => 'pap',
    'papuanlanguage'                => 'paa',
    'paŝtua'                       => 'ps',
    'persa'                         => 'fa',
    'philippinelanguage'            => 'phi',
    'phoenician'                    => 'phn',
    'pohnpeian'                     => 'pon',
    'pola'                          => 'pl',
    'portugala'                     => 'pt',
    'portugalportugala'             => 'pt_pt',
    'portuguesebasedcreoleorpidgin' => 'cpp',
    'prakritlanguage'               => 'pra',
    'rajasthani'                    => 'raj',
    'rapanui'                       => 'rap',
    'rarotongan'                    => 'rar',
    'romancelanguage'               => 'roa',
    'romany'                        => 'rom',
    'romanĉa'                      => 'rm',
    'ruanda'                        => 'rw',
    'rumana'                        => 'ro',
    'rusa'                          => 'ru',
    'salishanlanguage'              => 'sal',
    'samaritanaramaic'              => 'sam',
    'samilanguage'                  => 'smi',
    'samoa'                         => 'sm',
    'sandawe'                       => 'sad',
    'sangoa'                        => 'sg',
    'sanskrito'                     => 'sa',
    'santali'                       => 'sat',
    'sardinian'                     => 'sc',
    'sasak'                         => 'sas',
    'scots'                         => 'sco',
    'selkup'                        => 'sel',
    'semiticlanguage'               => 'sem',
    'serba'                         => 'sr',
    'serbokroata'                   => 'sh',
    'serer'                         => 'srr',
    'shan'                          => 'shn',
    'sichuanyi'                     => 'ii',
    'sicilian'                      => 'scn',
    'sidamo'                        => 'sid',
    'signlanguage'                  => 'sgn',
    'siksika'                       => 'bla',
    'sinda'                         => 'sd',
    'sinhala'                       => 'si',
    'sinotibetanlanguage'           => 'sit',
    'siouanlanguage'                => 'sio',
    'skoltsami'                     => 'sms',
    'slave'                         => 'den',
    'slaviclanguage'                => 'sla',
    'slovaka'                       => 'sk',
    'slovena'                       => 'sl',
    'sogdien'                       => 'sog',
    'somala'                        => 'so',
    'songhai'                       => 'son',
    'soninke'                       => 'snk',
    'sorbianlanguage'               => 'wen',
    'sota'                          => 'st',
    'southamericanindianlanguage'   => 'sai',
    'southernaltai'                 => 'alt',
    'southernsami'                  => 'sma',
    'southndebele'                  => 'nr',
    'sranantongo'                   => 'srn',
    'sukuma'                        => 'suk',
    'sumerian'                      => 'sux',
    'sunda'                         => 'su',
    'susu'                          => 'sus',
    'svahila'                       => 'sw',
    'svazia'                        => 'ss',
    'sveda'                         => 'sv',
    'swissfrench'                   => 'fr_ch',
    'swissgerman'                   => 'gsw',
    'swisshighgerman'               => 'de_ch',
    'syriac'                        => 'syr',
    'tagaloga'                      => 'tl',
    'tahitian'                      => 'ty',
    'tailanguage'                   => 'tai',
    'taja'                          => 'th',
    'tamashek'                      => 'tmh',
    'tamila'                        => 'ta',
    'taroko'                        => 'trv',
    'tatara'                        => 'tt',
    'taĝika'                       => 'tg',
    'telugua'                       => 'te',
    'tereno'                        => 'ter',
    'tetum'                         => 'tet',
    'tibeta'                        => 'bo',
    'tigraja'                       => 'ti',
    'tigre'                         => 'tig',
    'timne'                         => 'tem',
    'tiv'                           => 'tiv',
    'tlingit'                       => 'tli',
    'tokelau'                       => 'tkl',
    'tokpisin'                      => 'tpi',
    'tongaa'                        => 'to',
    'tsimshian'                     => 'tsi',
    'tumbuka'                       => 'tum',
    'tupilanguage'                  => 'tup',
    'turka'                         => 'tr',
    'turkmena'                      => 'tk',
    'tuvalu'                        => 'tvl',
    'tuvinian'                      => 'tyv',
    'tyap'                          => 'kcg',
    "u\.s\.english"                 => 'en_us',
    'udmurt'                        => 'udm',
    'ugaritic'                      => 'uga',
    'ujgura'                        => 'ug',
    'ukraina'                       => 'uk',
    'umbundu'                       => 'umb',
    'unknownorinvalidlanguage'      => 'und',
    'uppersorbian'                  => 'hsb',
    'urduo'                         => 'ur',
    'uzbeka'                        => 'uz',
    'vai'                           => 'vai',
    'venda'                         => 've',
    'vjetnama'                      => 'vi',
    'volapuko'                      => 'vo',
    'volofa'                        => 'wo',
    'votic'                         => 'vot',
    'wakashanlanguage'              => 'wak',
    'walamo'                        => 'wal',
    'walloon'                       => 'wa',
    'waray'                         => 'war',
    'washo'                         => 'was',
    'yakut'                         => 'sah',
    'yao'                           => 'yao',
    'yapese'                        => 'yap',
    'yupiklanguage'                 => 'ypk',
    'zande'                         => 'znd',
    'zapotec'                       => 'zap',
    'zaza'                          => 'zza',
    'zenaga'                        => 'zen',
    'zulua'                         => 'zu',
    'zuni'                          => 'zun',
    'ĉeĥa'                        => 'cs',
    'ĉina'                         => 'zh',
    'ĝuanga'                       => 'za',
    'ŝona'                         => 'sn',
);

1;
