package Locales::DB::Language::de;

# Auto generated from CLDR

$Locales::DB::Language::de::VERSION = '0.01';

$Locales::DB::Language::de::cldr_version = '1.7.1';

%Locales::DB::Language::de::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Sprache\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0 \%",
        'territory' => "Region\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "nein\:n",
        'yesstr' => "ja\:j"
    },
);

%Locales::DB::Language::de::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abchasisch',
    'ace'   => "Aceh\-Sprache",
    'ach'   => "Acholi\-Sprache",
    'ada'   => 'Adangme',
    'ady'   => 'Adygeisch',
    'ae'    => 'Avestisch',
    'af'    => 'Afrikaans',
    'afa'   => "Afro\-Asiatische\ Sprache",
    'afh'   => 'Afrihili',
    'ain'   => "Ainu\ \(Japan\)",
    'ak'    => 'Akan',
    'akk'   => 'Akkadisch',
    'ale'   => 'Aleutisch',
    'alg'   => "Algonkin\-Sprache",
    'alt'   => "Süd\-Altaisch",
    'am'    => 'Amharisch',
    'an'    => 'Aragonesisch',
    'ang'   => 'Altenglisch',
    'anp'   => 'Angika',
    'apa'   => "Apachen\-Sprache",
    'ar'    => 'Arabisch',
    'arc'   => 'Aramäisch',
    'arn'   => 'Araukanisch',
    'arp'   => "Arapaho\-Sprache",
    'art'   => 'Kunstsprache',
    'arw'   => "Arawak\-Sprachen",
    'as'    => 'Assamesisch',
    'ast'   => 'Asturianisch',
    'ath'   => "Athapaskische\ Sprachen",
    'aus'   => "Australische\ Sprache",
    'av'    => 'Awarisch',
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => 'Aserbaidschanisch',
    'ba'    => 'Baschkirisch',
    'bad'   => "Banda\-Sprache",
    'bai'   => "Bamileke\-Sprache",
    'bal'   => 'Belutschisch',
    'ban'   => 'Balinesisch',
    'bas'   => "Baasa\ \(Kamerun\)",
    'bat'   => "Baltische\ Sprache",
    'be'    => 'Weißrussisch',
    'bej'   => 'Bedauye',
    'bem'   => "Bemba\-Sprache",
    'ber'   => 'Berbersprache',
    'bg'    => 'Bulgarisch',
    'bh'    => 'Biharisch',
    'bho'   => 'Bhodschpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikolano',
    'bin'   => 'Bini',
    'bla'   => "Blackfoot\-Sprache",
    'bm'    => "Bambara\-Sprache",
    'bn'    => 'Bengalisch',
    'bnt'   => 'Bantusprache',
    'bo'    => 'Tibetisch',
    'br'    => 'Bretonisch',
    'bra'   => "Braj\-Bhakha",
    'bs'    => 'Bosnisch',
    'btk'   => 'Batak',
    'bua'   => 'Burjatisch',
    'bug'   => 'Buginesisch',
    'byn'   => 'Blin',
    'ca'    => 'Katalanisch',
    'cad'   => 'Caddo',
    'cai'   => "Zentralamerikanische\ Indianersprache",
    'car'   => "Karibische\ Sprache",
    'cau'   => "Kaukasische\ Sprache",
    'cch'   => 'Atsam',
    'ce'    => 'Tschetschenisch',
    'ceb'   => 'Cebuano',
    'cel'   => "Keltische\ Sprache",
    'ch'    => 'Chamorro',
    'chb'   => "Chibcha\-Sprachen",
    'chg'   => 'Tschagataisch',
    'chk'   => 'Trukesisch',
    'chm'   => 'Tscheremissisch',
    'chn'   => 'Chinook',
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Cham\-Sprache",
    'co'    => 'Korsisch',
    'cop'   => 'Koptisch',
    'cpe'   => "Kreolisch\-Englische\ Sprache",
    'cpf'   => "Kreolisch\-Französische\ Sprache",
    'cpp'   => "Kreolisch\-Portugiesische\ Sprache",
    'cr'    => 'Cree',
    'crh'   => 'Krimtatarisch',
    'crp'   => "Kreolische\ Sprachen",
    'cs'    => 'Tschechisch',
    'csb'   => 'Kaschubisch',
    'cu'    => 'Kirchenslawisch',
    'cus'   => "Kuschitische\ Sprache",
    'cv'    => 'Tschuwaschisch',
    'cy'    => 'Walisisch',
    'da'    => 'Dänisch',
    'dak'   => "Dakota\-Sprache",
    'dar'   => 'Darginisch',
    'day'   => "Bidayuh\-Sprache",
    'de'    => 'Deutsch',
    'de_at' => "Österreichisches\ Deutsch",
    'de_ch' => "Schweizer\ Hochdeutsch",
    'del'   => "Delaware\-Sprache",
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => "Dinka\-Sprache",
    'doi'   => 'Dogri',
    'dra'   => "Drawidische\ Sprache",
    'dsb'   => 'Niedersorbisch',
    'dua'   => 'Duala',
    'dum'   => 'Mittelniederländisch',
    'dv'    => 'Maledivisch',
    'dyu'   => "Dyula\-Sprache",
    'dz'    => 'Bhutanisch',
    'ee'    => "Ewe\-Sprache",
    'efi'   => 'Efik',
    'egy'   => 'Ägyptisch',
    'eka'   => 'Ekajuk',
    'el'    => 'Griechisch',
    'elx'   => 'Elamisch',
    'en'    => 'Englisch',
    'en_au' => "Australisches\ Englisch",
    'en_ca' => "Kanadisches\ Englisch",
    'en_gb' => "Britisches\ Englisch",
    'en_us' => "Amerikanisches\ Englisch",
    'enm'   => 'Mittelenglisch',
    'eo'    => 'Esperanto',
    'es'    => 'Spanisch',
    'es_es' => "Iberisches\ Spanisch",
    'et'    => 'Estnisch',
    'eu'    => 'Baskisch',
    'ewo'   => 'Ewondo',
    'fa'    => 'Persisch',
    'fan'   => "Pangwe\-Sprache",
    'fat'   => "Fanti\-Sprache",
    'ff'    => 'Ful',
    'fi'    => 'Finnisch',
    'fil'   => 'Filipino',
    'fiu'   => "Finnougrische\ Sprache",
    'fj'    => 'Fidschianisch',
    'fo'    => 'Färöisch',
    'fon'   => 'Fongbe',
    'fr'    => 'Französisch',
    'fr_ca' => "Kanadisches\ Französisch",
    'fr_ch' => "Schweizer\ Französisch",
    'frm'   => 'Mittelfranzösisch',
    'fro'   => 'Altfranzösisch',
    'frr'   => 'Nordfriesisch',
    'frs'   => 'Ostfriesisch',
    'fur'   => 'Friulisch',
    'fy'    => 'Friesisch',
    'ga'    => 'Irisch',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "Schottisches\ Gälisch",
    'gem'   => "Germanische\ Sprache",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertesisch',
    'gl'    => 'Galizisch',
    'gmh'   => 'Mittelhochdeutsch',
    'gn'    => 'Guarani',
    'goh'   => 'Althochdeutsch',
    'gon'   => "Gondi\-Sprache",
    'gor'   => 'Mongondou',
    'got'   => 'Gotisch',
    'grb'   => 'Grebo',
    'grc'   => 'Altgriechisch',
    'gsw'   => 'Schweizerdeutsch',
    'gu'    => 'Gujarati',
    'gv'    => 'Manx',
    'gwi'   => 'Kutchin',
    'ha'    => 'Hausa',
    'hai'   => 'Haida',
    'haw'   => 'Hawaiianisch',
    'he'    => 'Hebräisch',
    'hi'    => 'Hindi',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hethitisch',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\-Motu",
    'hr'    => 'Kroatisch',
    'hsb'   => 'Obersorbisch',
    'ht'    => 'Kreolisch',
    'hu'    => 'Ungarisch',
    'hup'   => 'Hupa',
    'hy'    => 'Armenisch',
    'hz'    => 'Herero',
    'ia'    => 'Interlingua',
    'iba'   => 'Iban',
    'id'    => 'Indonesisch',
    'ie'    => 'Interlingue',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => "Ijo\-Sprache",
    'ik'    => 'Inupiak',
    'ilo'   => 'Ilokano',
    'inc'   => "Indoarische\ Sprache",
    'ine'   => "Indogermanische\ Sprachen",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranische\ Sprache",
    'iro'   => "Irokesische\ Sprachen",
    'is'    => 'Isländisch',
    'it'    => 'Italienisch',
    'iu'    => 'Inukitut',
    'ja'    => 'Japanisch',
    'jbo'   => 'Lojban',
    'jpr'   => "Jüdisch\-Persisch",
    'jrb'   => "Jüdisch\-Arabisch",
    'jv'    => 'Javanisch',
    'ka'    => 'Georgisch',
    'kaa'   => 'Karakalpakisch',
    'kab'   => 'Kabylisch',
    'kac'   => "Kachin\-Sprache",
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karenisch',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardinisch',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\-Sprache",
    'kho'   => 'Sakisch',
    'ki'    => 'Kikuyu',
    'kj'    => 'Kwanyama',
    'kk'    => 'Kasachisch',
    'kl'    => 'Grönländisch',
    'km'    => 'Kambodschanisch',
    'kmb'   => 'Kimbundu',
    'kn'    => 'Kannada',
    'ko'    => 'Koreanisch',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraeanisch',
    'kpe'   => 'Kpellé',
    'kr'    => 'Kanuri',
    'krc'   => "Karatschaiisch\-Balkarisch",
    'krl'   => 'Karelisch',
    'kro'   => "Kru\-Sprachen",
    'kru'   => 'Kuruth',
    'ks'    => 'Kaschmirisch',
    'ku'    => 'Kurdisch',
    'kum'   => 'Kumükisch',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Kornisch',
    'ky'    => 'Kirgisisch',
    'la'    => 'Latein',
    'lad'   => 'Ladino',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxemburgisch',
    'lez'   => 'Lesgisch',
    'lg'    => 'Ganda',
    'li'    => 'Limburgisch',
    'ln'    => 'Lingala',
    'lo'    => 'Laotisch',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'Litauisch',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'lv'    => 'Lettisch',
    'mad'   => 'Maduresisch',
    'mag'   => 'Khotta',
    'mai'   => 'Maithili',
    'mak'   => 'Makassarisch',
    'man'   => 'Manding',
    'map'   => "Austronesische\ Sprache",
    'mas'   => 'Massai',
    'mdf'   => "Mokscha\-Mordwinisch",
    'mdr'   => 'Mandaresisch',
    'men'   => 'Mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagassy',
    'mga'   => 'Mittelirisch',
    'mh'    => 'Marschallesisch',
    'mi'    => 'Maori',
    'mic'   => 'Miʼkmaq',
    'min'   => 'Minangkabau',
    'mis'   => "andere\ Sprache",
    'mk'    => 'Mazedonisch',
    'mkh'   => "Mon\-Khmer\-Sprache",
    'ml'    => 'Malayalam',
    'mn'    => 'Mongolisch',
    'mnc'   => 'Mandschurisch',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\-Sprache",
    'mo'    => 'Moldawisch',
    'moh'   => 'Mohawk',
    'mos'   => "Mossi\-Sprache",
    'mr'    => 'Marathi',
    'ms'    => 'Malaiisch',
    'mt'    => 'Maltesisch',
    'mul'   => 'mehrsprachig',
    'mun'   => "Munda\-Sprachen",
    'mus'   => "Muskogee\-Sprachen",
    'mwl'   => 'Mirandesisch',
    'mwr'   => 'Marwari',
    'my'    => 'Birmanisch',
    'myn'   => "Maya\-Sprachen",
    'myv'   => "Ersja\-Mordwinisch",
    'na'    => 'Nauruisch',
    'nah'   => 'Nahuatl',
    'nai'   => "Nordamerikanische\ Indianersprache",
    'nap'   => 'Neapolitanisch',
    'nb'    => "Norwegisch\ Bokmål",
    'nd'    => "Nord\-Ndebele",
    'nds'   => 'Niederdeutsch',
    'ne'    => 'Nepalesisch',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => "Nias\-Sprache",
    'nic'   => "Nigerkordofanische\ Sprache",
    'niu'   => 'Niue',
    'nl'    => 'Niederländisch',
    'nl_be' => 'Flämisch',
    'nn'    => "Norwegisch\ Nynorsk",
    'no'    => 'Norwegisch',
    'nog'   => 'Nogai',
    'non'   => 'Altnordisch',
    'nqo'   => 'N’Ko',
    'nr'    => "Süd\-Ndebele\-Sprache",
    'nso'   => "Nord\-Sotho",
    'nub'   => "Nubische\ Sprache",
    'nv'    => "Navajo\-Sprache",
    'nwc'   => "Alt\-Newari",
    'ny'    => "Nyanja\-Sprache",
    'nym'   => "Nyamwezi\-Sprache",
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'Okzitanisch',
    'oj'    => "Ojibwa\-Sprache",
    'om'    => 'Oromo',
    'or'    => "Oriya\-Sprache",
    'os'    => 'Ossetisch',
    'osa'   => "Osage\-Sprache",
    'ota'   => 'Osmanisch',
    'oto'   => "Otomangue\-Sprachen",
    'pa'    => 'Pandschabisch',
    'paa'   => 'Papuasprachen',
    'pag'   => "Pangasinan\-Sprache",
    'pal'   => 'Mittelpersisch',
    'pam'   => "Pampanggan\-Sprache",
    'pap'   => 'Papiamento',
    'pau'   => 'Palau',
    'peo'   => 'Altpersisch',
    'phi'   => "Philippinen\-Austronesische\ Sprachen",
    'phn'   => 'Phönikisch',
    'pi'    => 'Pali',
    'pl'    => 'Polnisch',
    'pon'   => 'Ponapeanisch',
    'pra'   => 'Prakrit',
    'pro'   => 'Altprovenzalisch',
    'ps'    => 'Paschtu',
    'pt'    => 'Portugiesisch',
    'pt_br' => "Brasilianisches\ Portugiesisch",
    'pt_pt' => "Iberisches\ Portugiesisch",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => "Osterinsel\-Sprache",
    'rar'   => 'Rarotonganisch',
    'rm'    => 'Rätoromanisch',
    'rn'    => "Rundi\-Sprache",
    'ro'    => 'Rumänisch',
    'roa'   => "Romanische\ Sprachen",
    'rom'   => 'Romani',
    'ru'    => 'Russisch',
    'rup'   => 'Aromunisch',
    'rw'    => 'Ruandisch',
    'sa'    => 'Sanskrit',
    'sad'   => "Sandawe\-Sprache",
    'sah'   => 'Jakutisch',
    'sai'   => "Südamerikanische\ Indianersprache",
    'sal'   => "Salish\-Sprache",
    'sam'   => 'Samaritanisch',
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sc'    => 'Sardisch',
    'scn'   => 'Sizilianisch',
    'sco'   => 'Schottisch',
    'sd'    => 'Sindhi',
    'se'    => "Nord\-Samisch",
    'sel'   => 'Selkupisch',
    'sem'   => "Semitische\ Sprachen",
    'sg'    => 'Sango',
    'sga'   => 'Altirisch',
    'sgn'   => 'Gebärdensprache',
    'sh'    => "Serbo\-Kroatisch",
    'shn'   => "Schan\-Sprache",
    'si'    => 'Singhalesisch',
    'sid'   => 'Sidamo',
    'sio'   => "Sioux\-Sprache",
    'sit'   => "Sinotibetische\ Sprache",
    'sk'    => 'Slowakisch',
    'sl'    => 'Slowenisch',
    'sla'   => "Slawische\ Sprachen",
    'sm'    => 'Samoanisch',
    'sma'   => "Süd\-Samisch",
    'smi'   => 'Lappisch',
    'smj'   => "Lule\-Lappisch",
    'smn'   => "Inari\-Lappisch",
    'sms'   => "Skolt\-Lappisch",
    'sn'    => "Schona\-Sprache",
    'snk'   => "Soninke\-Sprache",
    'so'    => 'Somali',
    'sog'   => 'Sogdisch',
    'son'   => "Songhai\-Sprache",
    'sq'    => 'Albanisch',
    'sr'    => 'Serbisch',
    'srn'   => 'Srananisch',
    'srr'   => "Serer\-Sprache",
    'ss'    => 'Swazi',
    'ssa'   => "Nilosaharanische\ Sprache",
    'st'    => "Süd\-Sotho\-Sprache",
    'su'    => 'Sundanesisch',
    'suk'   => "Sukuma\-Sprache",
    'sus'   => 'Susu',
    'sux'   => 'Sumerisch',
    'sv'    => 'Schwedisch',
    'sw'    => 'Suaheli',
    'syc'   => 'Altsyrisch',
    'syr'   => 'Syrisch',
    'ta'    => 'Tamilisch',
    'tai'   => 'Thaisprache',
    'te'    => 'Telugu',
    'tem'   => 'Temne',
    'ter'   => "Tereno\-Sprache",
    'tet'   => "Tetum\-Sprache",
    'tg'    => 'Tadschikisch',
    'th'    => 'Thailändisch',
    'ti'    => 'Tigrinja',
    'tig'   => 'Tigre',
    'tiv'   => "Tiv\-Sprache",
    'tk'    => 'Turkmenisch',
    'tkl'   => 'Tokelauanisch',
    'tl'    => 'Tagalog',
    'tlh'   => 'Klingonisch',
    'tli'   => "Tlingit\-Sprache",
    'tmh'   => 'Tamaseq',
    'tn'    => "Tswana\-Sprache",
    'to'    => 'Tongaisch',
    'tog'   => "Tsonga\-Sprache",
    'tpi'   => 'Neumelanesisch',
    'tr'    => 'Türkisch',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => "Tsimshian\-Sprache",
    'tt'    => 'Tatarisch',
    'tum'   => "Tumbuka\-Sprache",
    'tup'   => "Tupi\-Sprachen",
    'tut'   => "Altaische\ Sprache",
    'tvl'   => 'Elliceanisch',
    'tw'    => 'Twi',
    'ty'    => 'Tahitisch',
    'tyv'   => 'Tuwinisch',
    'udm'   => 'Udmurtisch',
    'ug'    => 'Uigurisch',
    'uga'   => 'Ugaritisch',
    'uk'    => 'Ukrainisch',
    'umb'   => "Mbundu\-Sprache",
    'und'   => "Unbestimmte\ Sprache",
    'ur'    => 'Urdu',
    'uz'    => 'Usbekisch',
    'vai'   => "Vai\-Sprache",
    've'    => "Venda\-Sprache",
    'vi'    => 'Vietnamesisch',
    'vo'    => 'Volapük',
    'vot'   => 'Wotisch',
    'wa'    => 'Wallonisch',
    'wak'   => 'Wakashanisch',
    'wal'   => "Walamo\-Sprache",
    'war'   => 'Waray',
    'was'   => "Washo\-Sprache",
    'wen'   => 'Sorbisch',
    'wo'    => 'Wolof',
    'xal'   => 'Kalmückisch',
    'xh'    => 'Xhosa',
    'yao'   => "Yao\-Sprache",
    'yap'   => 'Yapesisch',
    'yi'    => 'Jiddisch',
    'yo'    => 'Yoruba',
    'ypk'   => "Yupik\-Sprache",
    'za'    => 'Zhuang',
    'zap'   => 'Zapotekisch',
    'zbl'   => "Bliss\-Symbole",
    'zen'   => 'Zenaga',
    'zh'    => 'Chinesisch',
    'znd'   => "Zande\-Sprache",
    'zu'    => 'Zulu',
    'zun'   => "Zuni\-Sprache",
    'zxx'   => "kein\ Sprachinhalt",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::de::name_to_code = (
    'abchasisch'                          => 'ab',
    'acehsprache'                         => 'ace',
    'acholisprache'                       => 'ach',
    'adangme'                             => 'ada',
    'adygeisch'                           => 'ady',
    'afar'                                => 'aa',
    'afrihili'                            => 'afh',
    'afrikaans'                           => 'af',
    'afroasiatischesprache'               => 'afa',
    'ainujapan'                           => 'ain',
    'akan'                                => 'ak',
    'akkadisch'                           => 'akk',
    'albanisch'                           => 'sq',
    'aleutisch'                           => 'ale',
    'algonkinsprache'                     => 'alg',
    'altaischesprache'                    => 'tut',
    'altenglisch'                         => 'ang',
    'altfranzösisch'                     => 'fro',
    'altgriechisch'                       => 'grc',
    'althochdeutsch'                      => 'goh',
    'altirisch'                           => 'sga',
    'altnewari'                           => 'nwc',
    'altnordisch'                         => 'non',
    'altpersisch'                         => 'peo',
    'altprovenzalisch'                    => 'pro',
    'altsyrisch'                          => 'syc',
    'amerikanischesenglisch'              => 'en_us',
    'amharisch'                           => 'am',
    'anderesprache'                       => 'mis',
    'angika'                              => 'anp',
    'apachensprache'                      => 'apa',
    'arabisch'                            => 'ar',
    'aragonesisch'                        => 'an',
    'aramäisch'                          => 'arc',
    'arapahosprache'                      => 'arp',
    'araukanisch'                         => 'arn',
    'arawaksprachen'                      => 'arw',
    'armenisch'                           => 'hy',
    'aromunisch'                          => 'rup',
    'aserbaidschanisch'                   => 'az',
    'assamesisch'                         => 'as',
    'asturianisch'                        => 'ast',
    'athapaskischesprachen'               => 'ath',
    'atsam'                               => 'cch',
    'australischesenglisch'               => 'en_au',
    'australischesprache'                 => 'aus',
    'austronesischesprache'               => 'map',
    'avestisch'                           => 'ae',
    'awadhi'                              => 'awa',
    'awarisch'                            => 'av',
    'aymara'                              => 'ay',
    'baasakamerun'                        => 'bas',
    'balinesisch'                         => 'ban',
    'baltischesprache'                    => 'bat',
    'bambarasprache'                      => 'bm',
    'bamilekesprache'                     => 'bai',
    'bandasprache'                        => 'bad',
    'bantusprache'                        => 'bnt',
    'baschkirisch'                        => 'ba',
    'baskisch'                            => 'eu',
    'batak'                               => 'btk',
    'bedauye'                             => 'bej',
    'belutschisch'                        => 'bal',
    'bembasprache'                        => 'bem',
    'bengalisch'                          => 'bn',
    'berbersprache'                       => 'ber',
    'bhodschpuri'                         => 'bho',
    'bhutanisch'                          => 'dz',
    'bidayuhsprache'                      => 'day',
    'biharisch'                           => 'bh',
    'bikolano'                            => 'bik',
    'bini'                                => 'bin',
    'birmanisch'                          => 'my',
    'bislama'                             => 'bi',
    'blackfootsprache'                    => 'bla',
    'blin'                                => 'byn',
    'blisssymbole'                        => 'zbl',
    'bosnisch'                            => 'bs',
    'brajbhakha'                          => 'bra',
    'brasilianischesportugiesisch'        => 'pt_br',
    'bretonisch'                          => 'br',
    'britischesenglisch'                  => 'en_gb',
    'buginesisch'                         => 'bug',
    'bulgarisch'                          => 'bg',
    'burjatisch'                          => 'bua',
    'caddo'                               => 'cad',
    'cebuano'                             => 'ceb',
    'chamorro'                            => 'ch',
    'chamsprache'                         => 'cmc',
    'cherokee'                            => 'chr',
    'cheyenne'                            => 'chy',
    'chibchasprachen'                     => 'chb',
    'chinesisch'                          => 'zh',
    'chinook'                             => 'chn',
    'chipewyan'                           => 'chp',
    'choctaw'                             => 'cho',
    'cree'                                => 'cr',
    'dakotasprache'                       => 'dak',
    'darginisch'                          => 'dar',
    'delawaresprache'                     => 'del',
    'deutsch'                             => 'de',
    'dinkasprache'                        => 'din',
    'dogri'                               => 'doi',
    'dogrib'                              => 'dgr',
    'drawidischesprache'                  => 'dra',
    'duala'                               => 'dua',
    'dyulasprache'                        => 'dyu',
    'dänisch'                            => 'da',
    'efik'                                => 'efi',
    'ekajuk'                              => 'eka',
    'elamisch'                            => 'elx',
    'elliceanisch'                        => 'tvl',
    'englisch'                            => 'en',
    'ersjamordwinisch'                    => 'myv',
    'esperanto'                           => 'eo',
    'estnisch'                            => 'et',
    'ewesprache'                          => 'ee',
    'ewondo'                              => 'ewo',
    'fantisprache'                        => 'fat',
    'fidschianisch'                       => 'fj',
    'filipino'                            => 'fil',
    'finnisch'                            => 'fi',
    'finnougrischesprache'                => 'fiu',
    'flämisch'                           => 'nl_be',
    'fongbe'                              => 'fon',
    'französisch'                        => 'fr',
    'friesisch'                           => 'fy',
    'friulisch'                           => 'fur',
    'ful'                                 => 'ff',
    'färöisch'                          => 'fo',
    'ga'                                  => 'gaa',
    'galizisch'                           => 'gl',
    'ganda'                               => 'lg',
    'gayo'                                => 'gay',
    'gbaya'                               => 'gba',
    'gebärdensprache'                    => 'sgn',
    'geez'                                => 'gez',
    'georgisch'                           => 'ka',
    'germanischesprache'                  => 'gem',
    'gilbertesisch'                       => 'gil',
    'gondisprache'                        => 'gon',
    'gotisch'                             => 'got',
    'grebo'                               => 'grb',
    'griechisch'                          => 'el',
    'grönländisch'                      => 'kl',
    'guarani'                             => 'gn',
    'gujarati'                            => 'gu',
    'haida'                               => 'hai',
    'hausa'                               => 'ha',
    'hawaiianisch'                        => 'haw',
    'hebräisch'                          => 'he',
    'herero'                              => 'hz',
    'hethitisch'                          => 'hit',
    'hiligaynon'                          => 'hil',
    'himachali'                           => 'him',
    'hindi'                               => 'hi',
    'hirimotu'                            => 'ho',
    'hmong'                               => 'hmn',
    'hupa'                                => 'hup',
    'iban'                                => 'iba',
    'iberischesportugiesisch'             => 'pt_pt',
    'iberischesspanisch'                  => 'es_es',
    'ido'                                 => 'io',
    'igbo'                                => 'ig',
    'ijosprache'                          => 'ijo',
    'ilokano'                             => 'ilo',
    'inarilappisch'                       => 'smn',
    'indoarischesprache'                  => 'inc',
    'indogermanischesprachen'             => 'ine',
    'indonesisch'                         => 'id',
    'ingush'                              => 'inh',
    'interlingua'                         => 'ia',
    'interlingue'                         => 'ie',
    'inukitut'                            => 'iu',
    'inupiak'                             => 'ik',
    'iranischesprache'                    => 'ira',
    'irisch'                              => 'ga',
    'irokesischesprachen'                 => 'iro',
    'isländisch'                         => 'is',
    'italienisch'                         => 'it',
    'jakutisch'                           => 'sah',
    'japanisch'                           => 'ja',
    'javanisch'                           => 'jv',
    'jiddisch'                            => 'yi',
    'jju'                                 => 'kaj',
    'jüdischarabisch'                    => 'jrb',
    'jüdischpersisch'                    => 'jpr',
    'kabardinisch'                        => 'kbd',
    'kabylisch'                           => 'kab',
    'kachinsprache'                       => 'kac',
    'kalmückisch'                        => 'xal',
    'kamba'                               => 'kam',
    'kambodschanisch'                     => 'km',
    'kanadischesenglisch'                 => 'en_ca',
    'kanadischesfranzösisch'             => 'fr_ca',
    'kannada'                             => 'kn',
    'kanuri'                              => 'kr',
    'karakalpakisch'                      => 'kaa',
    'karatschaiischbalkarisch'            => 'krc',
    'karelisch'                           => 'krl',
    'karenisch'                           => 'kar',
    'karibischesprache'                   => 'car',
    'kasachisch'                          => 'kk',
    'kaschmirisch'                        => 'ks',
    'kaschubisch'                         => 'csb',
    'katalanisch'                         => 'ca',
    'kaukasischesprache'                  => 'cau',
    'kawi'                                => 'kaw',
    'keinsprachinhalt'                    => 'zxx',
    'keltischesprache'                    => 'cel',
    'khasi'                               => 'kha',
    'khoisansprache'                      => 'khi',
    'khotta'                              => 'mag',
    'kikuyu'                              => 'ki',
    'kimbundu'                            => 'kmb',
    'kirchenslawisch'                     => 'cu',
    'kirgisisch'                          => 'ky',
    'klingonisch'                         => 'tlh',
    'komi'                                => 'kv',
    'kongo'                               => 'kg',
    'konkani'                             => 'kok',
    'koptisch'                            => 'cop',
    'koreanisch'                          => 'ko',
    'kornisch'                            => 'kw',
    'koro'                                => 'kfo',
    'korsisch'                            => 'co',
    'kosraeanisch'                        => 'kos',
    'kpellé'                             => 'kpe',
    'kreolisch'                           => 'ht',
    'kreolischenglischesprache'           => 'cpe',
    'kreolischesprachen'                  => 'crp',
    'kreolischfranzösischesprache'       => 'cpf',
    'kreolischportugiesischesprache'      => 'cpp',
    'krimtatarisch'                       => 'crh',
    'kroatisch'                           => 'hr',
    'krusprachen'                         => 'kro',
    'kumükisch'                          => 'kum',
    'kunstsprache'                        => 'art',
    'kurdisch'                            => 'ku',
    'kuruth'                              => 'kru',
    'kuschitischesprache'                 => 'cus',
    'kutchin'                             => 'gwi',
    'kutenai'                             => 'kut',
    'kwanyama'                            => 'kj',
    'ladino'                              => 'lad',
    'lahnda'                              => 'lah',
    'lamba'                               => 'lam',
    'laotisch'                            => 'lo',
    'lappisch'                            => 'smi',
    'latein'                              => 'la',
    'lesgisch'                            => 'lez',
    'lettisch'                            => 'lv',
    'limburgisch'                         => 'li',
    'lingala'                             => 'ln',
    'litauisch'                           => 'lt',
    'lojban'                              => 'jbo',
    'lozi'                                => 'loz',
    'lubakatanga'                         => 'lu',
    'lubalulua'                           => 'lua',
    'luiseno'                             => 'lui',
    'lulelappisch'                        => 'smj',
    'lunda'                               => 'lun',
    'luo'                                 => 'luo',
    'lushai'                              => 'lus',
    'luxemburgisch'                       => 'lb',
    'maduresisch'                         => 'mad',
    'maithili'                            => 'mai',
    'makassarisch'                        => 'mak',
    'malagassy'                           => 'mg',
    'malaiisch'                           => 'ms',
    'malayalam'                           => 'ml',
    'maledivisch'                         => 'dv',
    'maltesisch'                          => 'mt',
    'mandaresisch'                        => 'mdr',
    'manding'                             => 'man',
    'mandschurisch'                       => 'mnc',
    'manipuri'                            => 'mni',
    'manobosprache'                       => 'mno',
    'manx'                                => 'gv',
    'maori'                               => 'mi',
    'marathi'                             => 'mr',
    'marschallesisch'                     => 'mh',
    'marwari'                             => 'mwr',
    'massai'                              => 'mas',
    'mayasprachen'                        => 'myn',
    'mazedonisch'                         => 'mk',
    'mbundusprache'                       => 'umb',
    'mehrsprachig'                        => 'mul',
    'mende'                               => 'men',
    'minangkabau'                         => 'min',
    'mirandesisch'                        => 'mwl',
    'mittelenglisch'                      => 'enm',
    'mittelfranzösisch'                  => 'frm',
    'mittelhochdeutsch'                   => 'gmh',
    'mittelirisch'                        => 'mga',
    'mittelniederländisch'               => 'dum',
    'mittelpersisch'                      => 'pal',
    'miʼkmaq'                            => 'mic',
    'mohawk'                              => 'moh',
    'mokschamordwinisch'                  => 'mdf',
    'moldawisch'                          => 'mo',
    'mongo'                               => 'lol',
    'mongolisch'                          => 'mn',
    'mongondou'                           => 'gor',
    'monkhmersprache'                     => 'mkh',
    'morisyen'                            => 'mfe',
    'mossisprache'                        => 'mos',
    'mundasprachen'                       => 'mun',
    'muskogeesprachen'                    => 'mus',
    'nahuatl'                             => 'nah',
    'nauruisch'                           => 'na',
    'navajosprache'                       => 'nv',
    'ndonga'                              => 'ng',
    'neapolitanisch'                      => 'nap',
    'nepalesisch'                         => 'ne',
    'neumelanesisch'                      => 'tpi',
    'newari'                              => 'new',
    'niassprache'                         => 'nia',
    'niederdeutsch'                       => 'nds',
    'niederländisch'                     => 'nl',
    'niedersorbisch'                      => 'dsb',
    'nigerkordofanischesprache'           => 'nic',
    'nilosaharanischesprache'             => 'ssa',
    'niue'                                => 'niu',
    'nogai'                               => 'nog',
    'nordamerikanischeindianersprache'    => 'nai',
    'nordfriesisch'                       => 'frr',
    'nordndebele'                         => 'nd',
    'nordsamisch'                         => 'se',
    'nordsotho'                           => 'nso',
    'norwegisch'                          => 'no',
    'norwegischbokmål'                   => 'nb',
    'norwegischnynorsk'                   => 'nn',
    'nubischesprache'                     => 'nub',
    'nyamwezisprache'                     => 'nym',
    'nyanjasprache'                       => 'ny',
    'nyankole'                            => 'nyn',
    'nyoro'                               => 'nyo',
    'nzima'                               => 'nzi',
    'n’ko'                              => 'nqo',
    'obersorbisch'                        => 'hsb',
    'ojibwasprache'                       => 'oj',
    'okzitanisch'                         => 'oc',
    'oriyasprache'                        => 'or',
    'oromo'                               => 'om',
    'osagesprache'                        => 'osa',
    'osmanisch'                           => 'ota',
    'ossetisch'                           => 'os',
    'osterinselsprache'                   => 'rap',
    'ostfriesisch'                        => 'frs',
    'otomanguesprachen'                   => 'oto',
    'palau'                               => 'pau',
    'pali'                                => 'pi',
    'pampanggansprache'                   => 'pam',
    'pandschabisch'                       => 'pa',
    'pangasinansprache'                   => 'pag',
    'pangwesprache'                       => 'fan',
    'papiamento'                          => 'pap',
    'papuasprachen'                       => 'paa',
    'paschtu'                             => 'ps',
    'persisch'                            => 'fa',
    'philippinenaustronesischesprachen'   => 'phi',
    'phönikisch'                         => 'phn',
    'polnisch'                            => 'pl',
    'ponapeanisch'                        => 'pon',
    'portugiesisch'                       => 'pt',
    'prakrit'                             => 'pra',
    'quechua'                             => 'qu',
    'rajasthani'                          => 'raj',
    'rarotonganisch'                      => 'rar',
    'romani'                              => 'rom',
    'romanischesprachen'                  => 'roa',
    'ruandisch'                           => 'rw',
    'rumänisch'                          => 'ro',
    'rundisprache'                        => 'rn',
    'russisch'                            => 'ru',
    'rätoromanisch'                      => 'rm',
    'sakisch'                             => 'kho',
    'salishsprache'                       => 'sal',
    'samaritanisch'                       => 'sam',
    'samoanisch'                          => 'sm',
    'sandawesprache'                      => 'sad',
    'sango'                               => 'sg',
    'sanskrit'                            => 'sa',
    'santali'                             => 'sat',
    'sardisch'                            => 'sc',
    'sasak'                               => 'sas',
    'schansprache'                        => 'shn',
    'schonasprache'                       => 'sn',
    'schottisch'                          => 'sco',
    'schottischesgälisch'                => 'gd',
    'schwedisch'                          => 'sv',
    'schweizerdeutsch'                    => 'gsw',
    'schweizerfranzösisch'               => 'fr_ch',
    'schweizerhochdeutsch'                => 'de_ch',
    'selkupisch'                          => 'sel',
    'semitischesprachen'                  => 'sem',
    'serbisch'                            => 'sr',
    'serbokroatisch'                      => 'sh',
    'serersprache'                        => 'srr',
    'sichuanyi'                           => 'ii',
    'sidamo'                              => 'sid',
    'sindhi'                              => 'sd',
    'singhalesisch'                       => 'si',
    'sinotibetischesprache'               => 'sit',
    'siouxsprache'                        => 'sio',
    'sizilianisch'                        => 'scn',
    'skoltlappisch'                       => 'sms',
    'slave'                               => 'den',
    'slawischesprachen'                   => 'sla',
    'slowakisch'                          => 'sk',
    'slowenisch'                          => 'sl',
    'sogdisch'                            => 'sog',
    'somali'                              => 'so',
    'songhaisprache'                      => 'son',
    'soninkesprache'                      => 'snk',
    'sorbisch'                            => 'wen',
    'spanisch'                            => 'es',
    'srananisch'                          => 'srn',
    'suaheli'                             => 'sw',
    'sukumasprache'                       => 'suk',
    'sumerisch'                           => 'sux',
    'sundanesisch'                        => 'su',
    'susu'                                => 'sus',
    'swazi'                               => 'ss',
    'syrisch'                             => 'syr',
    'südaltaisch'                        => 'alt',
    'südamerikanischeindianersprache'    => 'sai',
    'südndebelesprache'                  => 'nr',
    'südsamisch'                         => 'sma',
    'südsothosprache'                    => 'st',
    'tadschikisch'                        => 'tg',
    'tagalog'                             => 'tl',
    'tahitisch'                           => 'ty',
    'tamaseq'                             => 'tmh',
    'tamilisch'                           => 'ta',
    'taroko'                              => 'trv',
    'tatarisch'                           => 'tt',
    'telugu'                              => 'te',
    'temne'                               => 'tem',
    'terenosprache'                       => 'ter',
    'tetumsprache'                        => 'tet',
    'thailändisch'                       => 'th',
    'thaisprache'                         => 'tai',
    'tibetisch'                           => 'bo',
    'tigre'                               => 'tig',
    'tigrinja'                            => 'ti',
    'tivsprache'                          => 'tiv',
    'tlingitsprache'                      => 'tli',
    'tokelauanisch'                       => 'tkl',
    'tongaisch'                           => 'to',
    'trukesisch'                          => 'chk',
    'tschagataisch'                       => 'chg',
    'tschechisch'                         => 'cs',
    'tscheremissisch'                     => 'chm',
    'tschetschenisch'                     => 'ce',
    'tschuwaschisch'                      => 'cv',
    'tsimshiansprache'                    => 'tsi',
    'tsonga'                              => 'ts',
    'tsongasprache'                       => 'tog',
    'tswanasprache'                       => 'tn',
    'tumbukasprache'                      => 'tum',
    'tupisprachen'                        => 'tup',
    'turkmenisch'                         => 'tk',
    'tuwinisch'                           => 'tyv',
    'twi'                                 => 'tw',
    'tyap'                                => 'kcg',
    'türkisch'                           => 'tr',
    'udmurtisch'                          => 'udm',
    'ugaritisch'                          => 'uga',
    'uigurisch'                           => 'ug',
    'ukrainisch'                          => 'uk',
    'unbestimmtesprache'                  => 'und',
    'ungarisch'                           => 'hu',
    'urdu'                                => 'ur',
    'usbekisch'                           => 'uz',
    'vaisprache'                          => 'vai',
    'vendasprache'                        => 've',
    'vietnamesisch'                       => 'vi',
    'volapük'                            => 'vo',
    'wakashanisch'                        => 'wak',
    'walamosprache'                       => 'wal',
    'walisisch'                           => 'cy',
    'wallonisch'                          => 'wa',
    'waray'                               => 'war',
    'washosprache'                        => 'was',
    'weißrussisch'                       => 'be',
    'wolof'                               => 'wo',
    'wotisch'                             => 'vot',
    'xhosa'                               => 'xh',
    'yaosprache'                          => 'yao',
    'yapesisch'                           => 'yap',
    'yoruba'                              => 'yo',
    'yupiksprache'                        => 'ypk',
    'zandesprache'                        => 'znd',
    'zapotekisch'                         => 'zap',
    'zaza'                                => 'zza',
    'zenaga'                              => 'zen',
    'zentralamerikanischeindianersprache' => 'cai',
    'zhuang'                              => 'za',
    'zulu'                                => 'zu',
    'zunisprache'                         => 'zun',
    'Ägyptisch'                          => 'egy',
    'Österreichischesdeutsch'            => 'de_at',
);

1;
