package Locales::DB::Language::sv;

# Auto generated from CLDR

$Locales::DB::Language::sv::VERSION = '0.01';

$Locales::DB::Language::sv::cldr_version = '1.7.1';

%Locales::DB::Language::sv::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "språk\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0 \%",
        'territory' => "område\:\ \{0\}"
    },
    'fallback'    => [ "nn\ nb\ da\ en" ],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "nej\:n",
        'yesstr' => "ja\:j"
    },
);

%Locales::DB::Language::sv::code_to_name = (
    'aa'    => 'afar',
    'ab'    => 'abchaziska',
    'ace'   => 'acehnesiska',
    'ach'   => 'acoli',
    'ada'   => 'adangme',
    'ady'   => 'adygeiska',
    'ae'    => 'avestiska',
    'af'    => 'afrikaans',
    'afa'   => "afro\-asiatiskt\ språk",
    'afh'   => 'afrihili',
    'ain'   => "ainu\ \(Japan\)",
    'ak'    => 'akan',
    'akk'   => 'akkadiska',
    'ale'   => 'aleutiska',
    'alg'   => "algonkinskt\ språk",
    'alt'   => 'sydaltaiska',
    'am'    => 'amhariska',
    'an'    => 'aragonesiska',
    'ang'   => 'fornengelska',
    'anp'   => 'angika',
    'apa'   => 'apachespråk',
    'ar'    => 'arabiska',
    'arc'   => "klassisk\ arameiska",
    'arn'   => 'araukanska',
    'arp'   => 'arapaho',
    'art'   => "konstgjort\ språk",
    'arw'   => 'arawakiska',
    'as'    => 'assamesiska',
    'ast'   => 'asturiska',
    'ath'   => "athapaskiskt\ språk",
    'aus'   => "australiskt\ språk",
    'av'    => 'avariska',
    'awa'   => 'awadhi',
    'ay'    => 'aymara',
    'az'    => 'azerbajdzjanska',
    'ba'    => 'basjkiriska',
    'bad'   => 'bandaspråk',
    'bai'   => "bamilekiskt\ språk",
    'bal'   => 'baluchiska',
    'ban'   => 'balinesiska',
    'bas'   => "basa\ \(Kamerun\)",
    'bat'   => "baltiskt\ språk",
    'be'    => 'vitryska',
    'bej'   => 'beyja',
    'bem'   => "bemba\ \(Zambia\)",
    'ber'   => 'berberspråk',
    'bg'    => 'bulgariska',
    'bh'    => "bihariskt\ språk",
    'bho'   => 'bhojpuri',
    'bi'    => 'bislama',
    'bik'   => 'bicolano',
    'bin'   => 'bini',
    'bla'   => 'siksika',
    'bm'    => 'bambara',
    'bn'    => 'bengaliska',
    'bnt'   => 'bantuspråk',
    'bo'    => 'tibetanska',
    'br'    => 'bretonska',
    'bra'   => 'braj',
    'bs'    => 'bosniska',
    'btk'   => 'batakspråk',
    'bua'   => 'burjätiska',
    'bug'   => 'buginesiska',
    'byn'   => 'blin',
    'ca'    => 'katalanska',
    'cad'   => 'caddo',
    'cai'   => "centralamerikanskt\ indianspråk",
    'car'   => 'galibiska',
    'cau'   => "kaukasiskt\ språk",
    'cch'   => 'atsam',
    'ce'    => 'tjetjenska',
    'ceb'   => 'cebuano',
    'cel'   => "keltiskt\ språk",
    'ch'    => 'chamorro',
    'chb'   => 'chibcha',
    'chg'   => 'chagatai',
    'chk'   => 'chuukesiska',
    'chm'   => "mariska\ \(Ryssland\)",
    'chn'   => "chinook\ pidginengelska",
    'cho'   => 'choctaw',
    'chp'   => 'chipewyan',
    'chr'   => 'cherokesiska',
    'chy'   => 'cheyenne',
    'cmc'   => "chamiskt\ språk",
    'co'    => 'korsikanska',
    'cop'   => 'koptiska',
    'cpe'   => "engelskbaserat\ kreol\-\ eller\ pidginspråk",
    'cpf'   => "franskbaserat\ kreol\-\ eller\ pidginspråk",
    'cpp'   => "portugisiskbaserat\ kreol\-\ eller\ pidginspråk",
    'cr'    => 'cree',
    'crh'   => 'krimturkiska',
    'crp'   => "kreol\-\ eller\ pidginspråk",
    'cs'    => 'tjeckiska',
    'csb'   => 'kasjubiska',
    'cu'    => 'kyrkslaviska',
    'cus'   => "kusjitiskt\ språk",
    'cv'    => 'tjuvasjiska',
    'cy'    => 'walesiska',
    'da'    => 'danska',
    'dak'   => 'dakota',
    'dar'   => 'darginska',
    'day'   => 'bidayuhspråk',
    'de'    => 'tyska',
    'de_at' => "österrikisk\ tyska",
    'de_ch' => "schweizisk\ högtyska",
    'del'   => 'delaware',
    'den'   => 'slavej',
    'dgr'   => 'dogrib',
    'din'   => 'dinka',
    'doi'   => "dogri\-kangri",
    'dra'   => "dravidiskt\ språk",
    'dsb'   => 'lågsorbiska',
    'dua'   => 'duala',
    'dum'   => 'medelholländska',
    'dv'    => 'divehi',
    'dyu'   => 'dyula',
    'dz'    => 'bhutanesiska',
    'ee'    => 'ewe',
    'efi'   => 'efik',
    'egy'   => 'fornegyptiska',
    'eka'   => 'ekajuk',
    'el'    => 'grekiska',
    'elx'   => 'elamitiska',
    'en'    => 'engelska',
    'en_au' => "australisk\ engelska",
    'en_ca' => "kanadensisk\ engelska",
    'en_gb' => "brittisk\ engelska",
    'en_us' => "amerikansk\ engelska",
    'enm'   => 'medelengelska',
    'eo'    => 'esperanto',
    'es'    => 'spanska',
    'es_es' => "europeisk\ spanska",
    'et'    => 'estniska',
    'eu'    => 'baskiska',
    'ewo'   => 'ewondo',
    'fa'    => 'persiska',
    'fan'   => "fang\ \(Ekvatorialguinea\)",
    'fat'   => "fanti\ \(dialekt\ av\ akan\)",
    'ff'    => 'fulfulde',
    'fi'    => 'finska',
    'fil'   => 'filippinska',
    'fiu'   => "finsk\-ugriskt\ språk",
    'fj'    => 'fidjianska',
    'fo'    => 'färöiska',
    'fon'   => 'fon',
    'fr'    => 'franska',
    'fr_ca' => "kanadensisk\ franska",
    'fr_ch' => "schweizisk\ franska",
    'frm'   => 'medelfranska',
    'fro'   => 'fornfranska',
    'frr'   => 'nordfrisiska',
    'frs'   => 'östfrisiska',
    'fur'   => 'friuliska',
    'fy'    => 'västfrisiska',
    'ga'    => 'iriska',
    'gaa'   => 'gã',
    'gay'   => 'gayo',
    'gba'   => "gbaya\ \(Centralafrikanska\ republiken\)",
    'gd'    => "skotsk\ gäliska",
    'gem'   => "germanskt\ språk",
    'gez'   => 'geʼez',
    'gil'   => 'gilbertiska',
    'gl'    => 'galiciska',
    'gmh'   => 'medelhögtyska',
    'gn'    => 'guaraní',
    'goh'   => 'fornhögtyska',
    'gon'   => 'gondi',
    'gor'   => 'gorontalo',
    'got'   => 'gotiska',
    'grb'   => 'grebo',
    'grc'   => 'forngrekiska',
    'gsw'   => 'schweizertyska',
    'gu'    => 'gujarati',
    'gv'    => 'manx',
    'gwi'   => 'gwichʼin',
    'ha'    => 'hausa',
    'hai'   => 'haida',
    'haw'   => 'hawaiiska',
    'he'    => 'hebreiska',
    'hi'    => 'hindi',
    'hil'   => 'hiligaynon',
    'him'   => "himachaliskt\ språk",
    'hit'   => 'hettitiska',
    'hmn'   => 'hmong',
    'ho'    => 'hirimotu',
    'hr'    => 'kroatiska',
    'hsb'   => 'högsorbiska',
    'ht'    => 'haitiska',
    'hu'    => 'ungerska',
    'hup'   => 'hupa',
    'hy'    => 'armeniska',
    'hz'    => 'herero',
    'ia'    => 'interlingua',
    'iba'   => 'ibanska',
    'id'    => 'indonesiska',
    'ie'    => 'interlingue',
    'ig'    => 'ibo',
    'ii'    => "szechuan\ yi",
    'ijo'   => 'ijospråk',
    'ik'    => 'iñupiaq',
    'ilo'   => 'iloko',
    'inc'   => "indiskt\ språk",
    'ine'   => "indo\-europeiskt\ språk",
    'inh'   => 'ingusjiska',
    'io'    => 'ido',
    'ira'   => "iranskt\ språk",
    'iro'   => "irokesiskt\ språk",
    'is'    => 'isländska',
    'it'    => 'italienska',
    'iu'    => 'inuktitut',
    'ja'    => 'japanska',
    'jbo'   => 'lojban',
    'jpr'   => "judisk\ persiska",
    'jrb'   => "judisk\ arabiska",
    'jv'    => 'javanesiska',
    'ka'    => 'georgiska',
    'kaa'   => 'karakalpakiska',
    'kab'   => 'kabyliska',
    'kac'   => 'kachin',
    'kaj'   => 'jju',
    'kam'   => "kamba\ \(Kenya\)",
    'kar'   => "karenskt\ språk",
    'kaw'   => 'kawi',
    'kbd'   => 'kabardinska',
    'kcg'   => 'tyap',
    'kfo'   => "koro\ \(Elfenbenskusten\)",
    'kg'    => 'kikongo',
    'kha'   => 'khasi',
    'khi'   => 'khoisanspråk',
    'kho'   => 'khotanesiska',
    'ki'    => 'kikuyu',
    'kj'    => 'kuanyama',
    'kk'    => 'kazakiska',
    'kl'    => 'grönländska',
    'km'    => "central\ kambodjanska",
    'kmb'   => 'kimbundu',
    'kn'    => 'kannada',
    'ko'    => 'koreanska',
    'kok'   => 'konkani',
    'kos'   => 'kosreanska',
    'kpe'   => 'kpellé',
    'kr'    => 'kanuri',
    'krc'   => "karachay\-balkar",
    'krl'   => 'karelska',
    'kro'   => 'kruspråk',
    'kru'   => 'kurukh',
    'ks'    => 'kashmiriska',
    'ku'    => 'kurdiska',
    'kum'   => 'kumykiska',
    'kut'   => 'kutenaj',
    'kv'    => 'komi',
    'kw'    => 'korniska',
    'ky'    => 'kirgisiska',
    'la'    => 'latin',
    'lad'   => 'ladino',
    'lah'   => 'lahnda',
    'lam'   => 'lamba',
    'lb'    => 'luxemburgiska',
    'lez'   => 'lezghien',
    'lg'    => 'luganda',
    'li'    => 'limburgiska',
    'ln'    => 'lingala',
    'lo'    => 'laotiska',
    'lol'   => 'mongo',
    'loz'   => 'lozi',
    'lt'    => 'litauiska',
    'lu'    => "luba\-Katanga",
    'lua'   => "luba\-Lulua",
    'lui'   => 'luiseño',
    'lun'   => 'lunda',
    'luo'   => "luo\ \(Kenya\ och\ Tanzania\)",
    'lus'   => 'lushai',
    'lv'    => 'lettiska',
    'mad'   => 'maduresiska',
    'mag'   => 'magahi',
    'mai'   => 'maithili',
    'mak'   => 'makasar',
    'man'   => 'mandinka',
    'map'   => "austronesiskt\ språk",
    'mas'   => 'massajiska',
    'mdf'   => 'moksja',
    'mdr'   => 'mandar',
    'men'   => "mende\ \(Sierra\ Leone\)",
    'mfe'   => 'Morisyen',
    'mg'    => 'malagassiska',
    'mga'   => 'medeliriska',
    'mh'    => 'marshalliska',
    'mi'    => 'maori',
    'mic'   => 'miʼkmaq',
    'min'   => 'minangkabau',
    'mis'   => "\(annat\ språk\)",
    'mk'    => 'makedonska',
    'mkh'   => "mon\-khmeriskt\ språk",
    'ml'    => 'malayalam',
    'mn'    => 'mongoliska',
    'mnc'   => 'manchuriska',
    'mni'   => 'manipuri',
    'mno'   => 'manobospråk',
    'mo'    => "moldaviska\ \(dialekt\ av\ rumänska\)",
    'moh'   => 'mohawk',
    'mos'   => 'mossi',
    'mr'    => 'marathi',
    'ms'    => 'malajiska',
    'mt'    => 'maltesiska',
    'mul'   => "\(flera\ språk\)",
    'mun'   => 'mundaspråk',
    'mus'   => 'muskogee',
    'mwl'   => 'mirandesiska',
    'mwr'   => 'marwari',
    'my'    => 'burmesiska',
    'myn'   => 'mayaspråk',
    'myv'   => 'ersja',
    'na'    => 'nauriska',
    'nah'   => "aztekiskt\ språk",
    'nai'   => "nordamerikanskt\ indianspråk",
    'nap'   => 'napolitanska',
    'nb'    => "norskt\ bokmål",
    'nd'    => 'nordndebele',
    'nds'   => 'lågtyska',
    'ne'    => 'nepalesiska',
    'new'   => 'newariska',
    'ng'    => 'ndonga',
    'nia'   => 'nias',
    'nic'   => "Niger\-Kongospråk",
    'niu'   => 'niueanska',
    'nl'    => 'holländska',
    'nl_be' => 'flamländska',
    'nn'    => 'nynorska',
    'no'    => 'norska',
    'nog'   => 'nogai',
    'non'   => 'fornnordiska',
    'nqo'   => 'nʼkå',
    'nr'    => 'sydndebele',
    'nso'   => 'nordsotho',
    'nub'   => "nubiskt\ språk",
    'nv'    => 'navaho',
    'nwc'   => "klassisk\ newariska",
    'ny'    => 'nyanja',
    'nym'   => 'nyamwezi',
    'nyn'   => 'nyankole',
    'nyo'   => 'nyoro',
    'nzi'   => 'nzima',
    'oc'    => 'occitanska',
    'oj'    => 'odjibwa',
    'om'    => 'oromo',
    'or'    => 'oriya',
    'os'    => 'ossetiska',
    'osa'   => 'osage',
    'ota'   => 'osmanska',
    'oto'   => 'otomispråk',
    'pa'    => 'punjabi',
    'paa'   => "papuanskt\ språk",
    'pag'   => 'pangasinan',
    'pal'   => 'medelpersiska',
    'pam'   => 'pampanga',
    'pap'   => 'papiamento',
    'pau'   => 'palauanska',
    'peo'   => 'fornpersiska',
    'phi'   => "filippinskt\ språk",
    'phn'   => 'fenikiska',
    'pi'    => 'pali',
    'pl'    => 'polska',
    'pon'   => 'pohnpeiska',
    'pra'   => 'prakritspråk',
    'pro'   => 'fornprovensalska',
    'ps'    => 'afghanska',
    'pt'    => 'portugisiska',
    'pt_br' => "brasiliansk\ portugisiska",
    'pt_pt' => "europeisk\ portugisiska",
    'qu'    => 'quechua',
    'raj'   => 'rajasthaniska',
    'rap'   => 'rapanuiska',
    'rar'   => 'rarotonganska',
    'rm'    => 'rätoromanska',
    'rn'    => 'rundiska',
    'ro'    => 'rumänska',
    'roa'   => "romanskt\ språk",
    'rom'   => 'romani',
    'ru'    => 'ryska',
    'rup'   => 'arumänska',
    'rw'    => 'kinjarwanda',
    'sa'    => 'sanskrit',
    'sad'   => 'sandawe',
    'sah'   => 'jakutiska',
    'sai'   => "sydamerikanskt\ indianspråk",
    'sal'   => "salikiskt\ språk",
    'sam'   => "samaritansk\ arameiska",
    'sas'   => 'sasak',
    'sat'   => 'santaliska',
    'sc'    => 'sardiska',
    'scn'   => 'sicilianska',
    'sco'   => 'skotska',
    'sd'    => 'sindhi',
    'se'    => 'nordsamiska',
    'sel'   => 'selkupiska',
    'sem'   => "semitiskt\ språk",
    'sg'    => 'sango',
    'sga'   => 'forniriska',
    'sgn'   => 'teckenspråk',
    'sh'    => 'serbokroatiska',
    'shn'   => 'shan',
    'si'    => 'singalesiska',
    'sid'   => 'sidamo',
    'sio'   => 'siouxspråk',
    'sit'   => "sino\-tibetanskt\ språk",
    'sk'    => 'slovakiska',
    'sl'    => 'slovenska',
    'sla'   => "slaviskt\ språk",
    'sm'    => 'samoanska',
    'sma'   => 'sydsamiska',
    'smi'   => "samiskt\ språk",
    'smj'   => 'lulesamiska',
    'smn'   => 'enaresamiska',
    'sms'   => 'skoltsamiska',
    'sn'    => 'shona',
    'snk'   => 'soninke',
    'so'    => 'somaliska',
    'sog'   => 'sogdiska',
    'son'   => 'songhaispråk',
    'sq'    => 'albanska',
    'sr'    => 'serbiska',
    'srn'   => "sranan\ tongo",
    'srr'   => 'serer',
    'ss'    => 'siswati',
    'ssa'   => "nilo\-sahariskt\ språk",
    'st'    => 'sydsotho',
    'su'    => 'sundanesiska',
    'suk'   => 'sukuma',
    'sus'   => 'susu',
    'sux'   => 'sumeriska',
    'sv'    => 'svenska',
    'sw'    => 'swahili',
    'syc'   => "klassisk\ syriska",
    'syr'   => 'syriska',
    'ta'    => 'tamilska',
    'tai'   => 'thaispråk',
    'te'    => 'telugiska',
    'tem'   => 'temne',
    'ter'   => 'tereno',
    'tet'   => 'tetum',
    'tg'    => 'tadzjikiska',
    'th'    => 'thailändska',
    'ti'    => 'tigrinja',
    'tig'   => 'tigré',
    'tiv'   => 'tivi',
    'tk'    => 'turkmeniska',
    'tkl'   => 'tokelauiska',
    'tl'    => 'tagalog',
    'tlh'   => 'klingonska',
    'tli'   => 'tlingit',
    'tmh'   => 'tamashek',
    'tn'    => 'setswana',
    'to'    => "tonganska\ \(Tongaöarna\)",
    'tog'   => "tonganska\ \(Niassa\ i\ Moçambique\)",
    'tpi'   => "tok\ pisin",
    'tr'    => 'turkiska',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'tsimshian',
    'tt'    => 'tatariska',
    'tum'   => 'tumbukiska',
    'tup'   => 'tupíspråk',
    'tut'   => "altaiskt\ språk",
    'tvl'   => 'tuvaluanska',
    'tw'    => "twi\ \(dialekt\ av\ akan\)",
    'ty'    => 'tahitiska',
    'tyv'   => 'tuvinska',
    'udm'   => 'udmurtiska',
    'ug'    => 'uiguriska',
    'uga'   => 'ugaritiska',
    'uk'    => 'ukrainska',
    'umb'   => 'umbundu',
    'und'   => "\(obestämt\ språk\)",
    'ur'    => 'urdu',
    'uz'    => 'uzbekiska',
    'vai'   => 'vaj',
    've'    => 'venda',
    'vi'    => 'vietnamesiska',
    'vo'    => 'volapyk',
    'vot'   => 'votiska',
    'wa'    => 'vallonska',
    'wak'   => "wakusjiskt\ språk",
    'wal'   => 'walamo',
    'war'   => "waray\ \(Filippinerna\)",
    'was'   => 'washo',
    'wen'   => "sorbiskt\ språk",
    'wo'    => 'wolof',
    'xal'   => 'kalmuckiska',
    'xh'    => 'xhosa',
    'yao'   => 'kiyao',
    'yap'   => 'japetiska',
    'yi'    => 'jiddisch',
    'yo'    => 'yoruba',
    'ypk'   => "jupiskt\ språk",
    'za'    => 'zhuang',
    'zap'   => 'zapotek',
    'zbl'   => "bliss\-symboler",
    'zen'   => 'zenaga',
    'zh'    => 'kinesiska',
    'znd'   => 'zandéspråk',
    'zu'    => 'zulu',
    'zun'   => 'zuñi',
    'zxx'   => "\(inget\ språkligt\ innehåll\)",
    'zza'   => 'zazaiska',
);

%Locales::DB::Language::sv::name_to_code = (
    'abchaziska'                                   => 'ab',
    'acehnesiska'                                  => 'ace',
    'acoli'                                        => 'ach',
    'adangme'                                      => 'ada',
    'adygeiska'                                    => 'ady',
    'afar'                                         => 'aa',
    'afghanska'                                    => 'ps',
    'afrihili'                                     => 'afh',
    'afrikaans'                                    => 'af',
    "afroasiatiskt\ sprk"                          => 'afa',
    "ainu\ japan"                                  => 'ain',
    'akan'                                         => 'ak',
    'akkadiska'                                    => 'akk',
    'albanska'                                     => 'sq',
    'aleutiska'                                    => 'ale',
    "algonkinskt\ sprk"                            => 'alg',
    "altaiskt\ sprk"                               => 'tut',
    "amerikansk\ engelska"                         => 'en_us',
    'amhariska'                                    => 'am',
    'angika'                                       => 'anp',
    "annat\ sprk"                                  => 'mis',
    'apachesprk'                                   => 'apa',
    'arabiska'                                     => 'ar',
    'aragonesiska'                                 => 'an',
    'arapaho'                                      => 'arp',
    'araukanska'                                   => 'arn',
    'arawakiska'                                   => 'arw',
    'armeniska'                                    => 'hy',
    'arumnska'                                     => 'rup',
    'assamesiska'                                  => 'as',
    'asturiska'                                    => 'ast',
    "athapaskiskt\ sprk"                           => 'ath',
    'atsam'                                        => 'cch',
    "australisk\ engelska"                         => 'en_au',
    "australiskt\ sprk"                            => 'aus',
    "austronesiskt\ sprk"                          => 'map',
    'avariska'                                     => 'av',
    'avestiska'                                    => 'ae',
    'awadhi'                                       => 'awa',
    'aymara'                                       => 'ay',
    'azerbajdzjanska'                              => 'az',
    "aztekiskt\ sprk"                              => 'nah',
    'balinesiska'                                  => 'ban',
    "baltiskt\ sprk"                               => 'bat',
    'baluchiska'                                   => 'bal',
    'bambara'                                      => 'bm',
    "bamilekiskt\ sprk"                            => 'bai',
    'bandasprk'                                    => 'bad',
    'bantusprk'                                    => 'bnt',
    "basa\ kamerun"                                => 'bas',
    'basjkiriska'                                  => 'ba',
    'baskiska'                                     => 'eu',
    'bataksprk'                                    => 'btk',
    "bemba\ zambia"                                => 'bem',
    'bengaliska'                                   => 'bn',
    'berbersprk'                                   => 'ber',
    'beyja'                                        => 'bej',
    'bhojpuri'                                     => 'bho',
    'bhutanesiska'                                 => 'dz',
    'bicolano'                                     => 'bik',
    'bidayuhsprk'                                  => 'day',
    "bihariskt\ sprk"                              => 'bh',
    'bini'                                         => 'bin',
    'bislama'                                      => 'bi',
    'blin'                                         => 'byn',
    'blisssymboler'                                => 'zbl',
    'bosniska'                                     => 'bs',
    'braj'                                         => 'bra',
    "brasiliansk\ portugisiska"                    => 'pt_br',
    'bretonska'                                    => 'br',
    "brittisk\ engelska"                           => 'en_gb',
    'buginesiska'                                  => 'bug',
    'bulgariska'                                   => 'bg',
    'burjtiska'                                    => 'bua',
    'burmesiska'                                   => 'my',
    'caddo'                                        => 'cad',
    'cebuano'                                      => 'ceb',
    "central\ kambodjanska"                        => 'km',
    "centralamerikanskt\ indiansprk"               => 'cai',
    'chagatai'                                     => 'chg',
    "chamiskt\ sprk"                               => 'cmc',
    'chamorro'                                     => 'ch',
    'cherokesiska'                                 => 'chr',
    'cheyenne'                                     => 'chy',
    'chibcha'                                      => 'chb',
    "chinook\ pidginengelska"                      => 'chn',
    'chipewyan'                                    => 'chp',
    'choctaw'                                      => 'cho',
    'chuukesiska'                                  => 'chk',
    'cree'                                         => 'cr',
    'dakota'                                       => 'dak',
    'danska'                                       => 'da',
    'darginska'                                    => 'dar',
    'delaware'                                     => 'del',
    'dinka'                                        => 'din',
    'divehi'                                       => 'dv',
    'dogrib'                                       => 'dgr',
    'dogrikangri'                                  => 'doi',
    "dravidiskt\ sprk"                             => 'dra',
    'duala'                                        => 'dua',
    'dyula'                                        => 'dyu',
    'efik'                                         => 'efi',
    'ekajuk'                                       => 'eka',
    'elamitiska'                                   => 'elx',
    'enaresamiska'                                 => 'smn',
    'engelska'                                     => 'en',
    "engelskbaserat\ kreol\ eller\ pidginsprk"     => 'cpe',
    'ersja'                                        => 'myv',
    'esperanto'                                    => 'eo',
    'estniska'                                     => 'et',
    "europeisk\ portugisiska"                      => 'pt_pt',
    "europeisk\ spanska"                           => 'es_es',
    'ewe'                                          => 'ee',
    'ewondo'                                       => 'ewo',
    "fang\ ekvatorialguinea"                       => 'fan',
    "fanti\ dialekt\ av\ akan"                     => 'fat',
    'fenikiska'                                    => 'phn',
    'fidjianska'                                   => 'fj',
    'filippinska'                                  => 'fil',
    "filippinskt\ sprk"                            => 'phi',
    'finska'                                       => 'fi',
    "finskugriskt\ sprk"                           => 'fiu',
    'flamlndska'                                   => 'nl_be',
    "flera\ sprk"                                  => 'mul',
    'fon'                                          => 'fon',
    'fornegyptiska'                                => 'egy',
    'fornengelska'                                 => 'ang',
    'fornfranska'                                  => 'fro',
    'forngrekiska'                                 => 'grc',
    'fornhgtyska'                                  => 'goh',
    'forniriska'                                   => 'sga',
    'fornnordiska'                                 => 'non',
    'fornpersiska'                                 => 'peo',
    'fornprovensalska'                             => 'pro',
    'franska'                                      => 'fr',
    "franskbaserat\ kreol\ eller\ pidginsprk"      => 'cpf',
    'friska'                                       => 'fo',
    'friuliska'                                    => 'fur',
    'fulfulde'                                     => 'ff',
    'g'                                            => 'gaa',
    'galibiska'                                    => 'car',
    'galiciska'                                    => 'gl',
    'gayo'                                         => 'gay',
    "gbaya\ centralafrikanska\ republiken"         => 'gba',
    'geez'                                         => 'gez',
    'georgiska'                                    => 'ka',
    "germanskt\ sprk"                              => 'gem',
    'gilbertiska'                                  => 'gil',
    'gondi'                                        => 'gon',
    'gorontalo'                                    => 'gor',
    'gotiska'                                      => 'got',
    'grebo'                                        => 'grb',
    'grekiska'                                     => 'el',
    'grnlndska'                                    => 'kl',
    'guaran'                                       => 'gn',
    'gujarati'                                     => 'gu',
    'gwichin'                                      => 'gwi',
    'haida'                                        => 'hai',
    'haitiska'                                     => 'ht',
    'hausa'                                        => 'ha',
    'hawaiiska'                                    => 'haw',
    'hebreiska'                                    => 'he',
    'herero'                                       => 'hz',
    'hettitiska'                                   => 'hit',
    'hgsorbiska'                                   => 'hsb',
    'hiligaynon'                                   => 'hil',
    "himachaliskt\ sprk"                           => 'him',
    'hindi'                                        => 'hi',
    'hirimotu'                                     => 'ho',
    'hmong'                                        => 'hmn',
    'hollndska'                                    => 'nl',
    'hupa'                                         => 'hup',
    'ibanska'                                      => 'iba',
    'ibo'                                          => 'ig',
    'ido'                                          => 'io',
    'ijosprk'                                      => 'ijo',
    'iloko'                                        => 'ilo',
    "indiskt\ sprk"                                => 'inc',
    "indoeuropeiskt\ sprk"                         => 'ine',
    'indonesiska'                                  => 'id',
    "inget\ sprkligt\ innehll"                     => 'zxx',
    'ingusjiska'                                   => 'inh',
    'interlingua'                                  => 'ia',
    'interlingue'                                  => 'ie',
    'inuktitut'                                    => 'iu',
    "iranskt\ sprk"                                => 'ira',
    'iriska'                                       => 'ga',
    "irokesiskt\ sprk"                             => 'iro',
    'islndska'                                     => 'is',
    'italienska'                                   => 'it',
    'iupiaq'                                       => 'ik',
    'jakutiska'                                    => 'sah',
    'japanska'                                     => 'ja',
    'japetiska'                                    => 'yap',
    'javanesiska'                                  => 'jv',
    'jiddisch'                                     => 'yi',
    'jju'                                          => 'kaj',
    "judisk\ arabiska"                             => 'jrb',
    "judisk\ persiska"                             => 'jpr',
    "jupiskt\ sprk"                                => 'ypk',
    'kabardinska'                                  => 'kbd',
    'kabyliska'                                    => 'kab',
    'kachin'                                       => 'kac',
    'kalmuckiska'                                  => 'xal',
    "kamba\ kenya"                                 => 'kam',
    "kanadensisk\ engelska"                        => 'en_ca',
    "kanadensisk\ franska"                         => 'fr_ca',
    'kannada'                                      => 'kn',
    'kanuri'                                       => 'kr',
    'karachaybalkar'                               => 'krc',
    'karakalpakiska'                               => 'kaa',
    'karelska'                                     => 'krl',
    "karenskt\ sprk"                               => 'kar',
    'kashmiriska'                                  => 'ks',
    'kasjubiska'                                   => 'csb',
    'katalanska'                                   => 'ca',
    "kaukasiskt\ sprk"                             => 'cau',
    'kawi'                                         => 'kaw',
    'kazakiska'                                    => 'kk',
    "keltiskt\ sprk"                               => 'cel',
    'khasi'                                        => 'kha',
    'khoisansprk'                                  => 'khi',
    'khotanesiska'                                 => 'kho',
    'kikongo'                                      => 'kg',
    'kikuyu'                                       => 'ki',
    'kimbundu'                                     => 'kmb',
    'kinesiska'                                    => 'zh',
    'kinjarwanda'                                  => 'rw',
    'kirgisiska'                                   => 'ky',
    'kiyao'                                        => 'yao',
    "klassisk\ arameiska"                          => 'arc',
    "klassisk\ newariska"                          => 'nwc',
    "klassisk\ syriska"                            => 'syc',
    'klingonska'                                   => 'tlh',
    'komi'                                         => 'kv',
    'konkani'                                      => 'kok',
    "konstgjort\ sprk"                             => 'art',
    'koptiska'                                     => 'cop',
    'koreanska'                                    => 'ko',
    'korniska'                                     => 'kw',
    "koro\ elfenbenskusten"                        => 'kfo',
    'korsikanska'                                  => 'co',
    'kosreanska'                                   => 'kos',
    'kpell'                                        => 'kpe',
    "kreol\ eller\ pidginsprk"                     => 'crp',
    'krimturkiska'                                 => 'crh',
    'kroatiska'                                    => 'hr',
    'krusprk'                                      => 'kro',
    'kuanyama'                                     => 'kj',
    'kumykiska'                                    => 'kum',
    'kurdiska'                                     => 'ku',
    'kurukh'                                       => 'kru',
    "kusjitiskt\ sprk"                             => 'cus',
    'kutenaj'                                      => 'kut',
    'kyrkslaviska'                                 => 'cu',
    'ladino'                                       => 'lad',
    'lahnda'                                       => 'lah',
    'lamba'                                        => 'lam',
    'laotiska'                                     => 'lo',
    'latin'                                        => 'la',
    'lettiska'                                     => 'lv',
    'lezghien'                                     => 'lez',
    'lgsorbiska'                                   => 'dsb',
    'lgtyska'                                      => 'nds',
    'limburgiska'                                  => 'li',
    'lingala'                                      => 'ln',
    'litauiska'                                    => 'lt',
    'lojban'                                       => 'jbo',
    'lozi'                                         => 'loz',
    'lubakatanga'                                  => 'lu',
    'lubalulua'                                    => 'lua',
    'luganda'                                      => 'lg',
    'luiseo'                                       => 'lui',
    'lulesamiska'                                  => 'smj',
    'lunda'                                        => 'lun',
    "luo\ kenya\ och\ tanzania"                    => 'luo',
    'lushai'                                       => 'lus',
    'luxemburgiska'                                => 'lb',
    'maduresiska'                                  => 'mad',
    'magahi'                                       => 'mag',
    'maithili'                                     => 'mai',
    'makasar'                                      => 'mak',
    'makedonska'                                   => 'mk',
    'malagassiska'                                 => 'mg',
    'malajiska'                                    => 'ms',
    'malayalam'                                    => 'ml',
    'maltesiska'                                   => 'mt',
    'manchuriska'                                  => 'mnc',
    'mandar'                                       => 'mdr',
    'mandinka'                                     => 'man',
    'manipuri'                                     => 'mni',
    'manobosprk'                                   => 'mno',
    'manx'                                         => 'gv',
    'maori'                                        => 'mi',
    'marathi'                                      => 'mr',
    "mariska\ ryssland"                            => 'chm',
    'marshalliska'                                 => 'mh',
    'marwari'                                      => 'mwr',
    'massajiska'                                   => 'mas',
    'mayasprk'                                     => 'myn',
    'medelengelska'                                => 'enm',
    'medelfranska'                                 => 'frm',
    'medelhgtyska'                                 => 'gmh',
    'medelhollndska'                               => 'dum',
    'medeliriska'                                  => 'mga',
    'medelpersiska'                                => 'pal',
    "mende\ sierra\ leone"                         => 'men',
    'mikmaq'                                       => 'mic',
    'minangkabau'                                  => 'min',
    'mirandesiska'                                 => 'mwl',
    'mohawk'                                       => 'moh',
    'moksja'                                       => 'mdf',
    "moldaviska\ dialekt\ av\ rumnska"             => 'mo',
    'mongo'                                        => 'lol',
    'mongoliska'                                   => 'mn',
    "monkhmeriskt\ sprk"                           => 'mkh',
    'morisyen'                                     => 'mfe',
    'mossi'                                        => 'mos',
    'mundasprk'                                    => 'mun',
    'muskogee'                                     => 'mus',
    'napolitanska'                                 => 'nap',
    'nauriska'                                     => 'na',
    'navaho'                                       => 'nv',
    'ndonga'                                       => 'ng',
    'nepalesiska'                                  => 'ne',
    'newariska'                                    => 'new',
    'nias'                                         => 'nia',
    'nigerkongosprk'                               => 'nic',
    "nilosahariskt\ sprk"                          => 'ssa',
    'niueanska'                                    => 'niu',
    'nk'                                           => 'nqo',
    'nogai'                                        => 'nog',
    "nordamerikanskt\ indiansprk"                  => 'nai',
    'nordfrisiska'                                 => 'frr',
    'nordndebele'                                  => 'nd',
    'nordsamiska'                                  => 'se',
    'nordsotho'                                    => 'nso',
    'norska'                                       => 'no',
    "norskt\ bokml"                                => 'nb',
    "nubiskt\ sprk"                                => 'nub',
    'nyamwezi'                                     => 'nym',
    'nyanja'                                       => 'ny',
    'nyankole'                                     => 'nyn',
    'nynorska'                                     => 'nn',
    'nyoro'                                        => 'nyo',
    'nzima'                                        => 'nzi',
    "obestmt\ sprk"                                => 'und',
    'occitanska'                                   => 'oc',
    'odjibwa'                                      => 'oj',
    'oriya'                                        => 'or',
    'oromo'                                        => 'om',
    'osage'                                        => 'osa',
    'osmanska'                                     => 'ota',
    'ossetiska'                                    => 'os',
    'otomisprk'                                    => 'oto',
    'palauanska'                                   => 'pau',
    'pali'                                         => 'pi',
    'pampanga'                                     => 'pam',
    'pangasinan'                                   => 'pag',
    'papiamento'                                   => 'pap',
    "papuanskt\ sprk"                              => 'paa',
    'persiska'                                     => 'fa',
    'pohnpeiska'                                   => 'pon',
    'polska'                                       => 'pl',
    'portugisiska'                                 => 'pt',
    "portugisiskbaserat\ kreol\ eller\ pidginsprk" => 'cpp',
    'prakritsprk'                                  => 'pra',
    'punjabi'                                      => 'pa',
    'quechua'                                      => 'qu',
    'rajasthaniska'                                => 'raj',
    'rapanuiska'                                   => 'rap',
    'rarotonganska'                                => 'rar',
    'romani'                                       => 'rom',
    "romanskt\ sprk"                               => 'roa',
    'rtoromanska'                                  => 'rm',
    'rumnska'                                      => 'ro',
    'rundiska'                                     => 'rn',
    'ryska'                                        => 'ru',
    "salikiskt\ sprk"                              => 'sal',
    "samaritansk\ arameiska"                       => 'sam',
    "samiskt\ sprk"                                => 'smi',
    'samoanska'                                    => 'sm',
    'sandawe'                                      => 'sad',
    'sango'                                        => 'sg',
    'sanskrit'                                     => 'sa',
    'santaliska'                                   => 'sat',
    'sardiska'                                     => 'sc',
    'sasak'                                        => 'sas',
    'schweizertyska'                               => 'gsw',
    "schweizisk\ franska"                          => 'fr_ch',
    "schweizisk\ hgtyska"                          => 'de_ch',
    'selkupiska'                                   => 'sel',
    "semitiskt\ sprk"                              => 'sem',
    'serbiska'                                     => 'sr',
    'serbokroatiska'                               => 'sh',
    'serer'                                        => 'srr',
    'setswana'                                     => 'tn',
    'shan'                                         => 'shn',
    'shona'                                        => 'sn',
    'sicilianska'                                  => 'scn',
    'sidamo'                                       => 'sid',
    'siksika'                                      => 'bla',
    'sindhi'                                       => 'sd',
    'singalesiska'                                 => 'si',
    "sinotibetanskt\ sprk"                         => 'sit',
    'siouxsprk'                                    => 'sio',
    'siswati'                                      => 'ss',
    'skoltsamiska'                                 => 'sms',
    "skotsk\ gliska"                               => 'gd',
    'skotska'                                      => 'sco',
    'slavej'                                       => 'den',
    "slaviskt\ sprk"                               => 'sla',
    'slovakiska'                                   => 'sk',
    'slovenska'                                    => 'sl',
    'sogdiska'                                     => 'sog',
    'somaliska'                                    => 'so',
    'songhaisprk'                                  => 'son',
    'soninke'                                      => 'snk',
    "sorbiskt\ sprk"                               => 'wen',
    'spanska'                                      => 'es',
    "sranan\ tongo"                                => 'srn',
    "sterrikisk\ tyska"                            => 'de_at',
    'stfrisiska'                                   => 'frs',
    'sukuma'                                       => 'suk',
    'sumeriska'                                    => 'sux',
    'sundanesiska'                                 => 'su',
    'susu'                                         => 'sus',
    'svenska'                                      => 'sv',
    'swahili'                                      => 'sw',
    'sydaltaiska'                                  => 'alt',
    "sydamerikanskt\ indiansprk"                   => 'sai',
    'sydndebele'                                   => 'nr',
    'sydsamiska'                                   => 'sma',
    'sydsotho'                                     => 'st',
    'syriska'                                      => 'syr',
    "szechuan\ yi"                                 => 'ii',
    'tadzjikiska'                                  => 'tg',
    'tagalog'                                      => 'tl',
    'tahitiska'                                    => 'ty',
    'tamashek'                                     => 'tmh',
    'tamilska'                                     => 'ta',
    'taroko'                                       => 'trv',
    'tatariska'                                    => 'tt',
    'teckensprk'                                   => 'sgn',
    'telugiska'                                    => 'te',
    'temne'                                        => 'tem',
    'tereno'                                       => 'ter',
    'tetum'                                        => 'tet',
    'thailndska'                                   => 'th',
    'thaisprk'                                     => 'tai',
    'tibetanska'                                   => 'bo',
    'tigr'                                         => 'tig',
    'tigrinja'                                     => 'ti',
    'tivi'                                         => 'tiv',
    'tjeckiska'                                    => 'cs',
    'tjetjenska'                                   => 'ce',
    'tjuvasjiska'                                  => 'cv',
    'tlingit'                                      => 'tli',
    "tok\ pisin"                                   => 'tpi',
    'tokelauiska'                                  => 'tkl',
    "tonganska\ niassa\ i\ moambique"              => 'tog',
    "tonganska\ tongaarna"                         => 'to',
    'tsimshian'                                    => 'tsi',
    'tsonga'                                       => 'ts',
    'tumbukiska'                                   => 'tum',
    'tupsprk'                                      => 'tup',
    'turkiska'                                     => 'tr',
    'turkmeniska'                                  => 'tk',
    'tuvaluanska'                                  => 'tvl',
    'tuvinska'                                     => 'tyv',
    "twi\ dialekt\ av\ akan"                       => 'tw',
    'tyap'                                         => 'kcg',
    'tyska'                                        => 'de',
    'udmurtiska'                                   => 'udm',
    'ugaritiska'                                   => 'uga',
    'uiguriska'                                    => 'ug',
    'ukrainska'                                    => 'uk',
    'umbundu'                                      => 'umb',
    'ungerska'                                     => 'hu',
    'urdu'                                         => 'ur',
    'uzbekiska'                                    => 'uz',
    'vaj'                                          => 'vai',
    'vallonska'                                    => 'wa',
    'venda'                                        => 've',
    'vietnamesiska'                                => 'vi',
    'vitryska'                                     => 'be',
    'volapyk'                                      => 'vo',
    'votiska'                                      => 'vot',
    'vstfrisiska'                                  => 'fy',
    "wakusjiskt\ sprk"                             => 'wak',
    'walamo'                                       => 'wal',
    'walesiska'                                    => 'cy',
    "waray\ filippinerna"                          => 'war',
    'washo'                                        => 'was',
    'wolof'                                        => 'wo',
    'xhosa'                                        => 'xh',
    'yoruba'                                       => 'yo',
    'zandsprk'                                     => 'znd',
    'zapotek'                                      => 'zap',
    'zazaiska'                                     => 'zza',
    'zenaga'                                       => 'zen',
    'zhuang'                                       => 'za',
    'zui'                                          => 'zun',
    'zulu'                                         => 'zu',
);

1;
