package Locales::DB::Language::ja;

# Auto generated from CLDR

$Locales::DB::Language::ja::VERSION = '0.01';

$Locales::DB::Language::ja::cldr_version = '1.7.1';

%Locales::DB::Language::ja::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "言語\:\ \{0\}",
        'locale'    => "\{0\}\(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "地域\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "いいえ\:イイエ",
        'yesstr' => "はい\:ハイ"
    },
);

%Locales::DB::Language::ja::code_to_name = (
    'aa'    => 'アファル語',
    'ab'    => 'アブハズ語',
    'ace'   => 'アチェー語',
    'ach'   => 'アチョリ語',
    'ada'   => 'アダングメ語',
    'ady'   => 'アディゲ語',
    'ae'    => 'アヴェスタ語',
    'af'    => 'アフリカーンス語',
    'afa'   => 'セム・ハム諸語',
    'afh'   => 'アフリヒリ語',
    'ain'   => 'アイヌ語',
    'ak'    => 'アカン語',
    'akk'   => 'アッカド語',
    'ale'   => 'アレウト語',
    'alg'   => 'アルゴンキアン語族',
    'alt'   => '南アルタイ語',
    'am'    => 'アムハラ語',
    'an'    => 'アラゴン語',
    'ang'   => '古代英語',
    'anp'   => 'アンギカ語',
    'apa'   => 'アパッチ語族',
    'ar'    => 'アラビア語',
    'arc'   => 'アラム語',
    'arn'   => 'アラウカン語',
    'arp'   => 'アラパホー語',
    'art'   => '人工諸語',
    'arw'   => 'アラワク語',
    'as'    => 'アッサム語',
    'ast'   => 'アストゥリアス語',
    'ath'   => 'アサパスカン語族',
    'aus'   => 'オーストラリア語族',
    'av'    => 'アヴァル語',
    'awa'   => 'アワディー語',
    'ay'    => 'アイマラ語',
    'az'    => 'アゼルバイジャン語',
    'ba'    => 'バシキール語',
    'bad'   => 'バンダ語',
    'bai'   => 'バミレケ語族',
    'bal'   => 'バルーチー語',
    'ban'   => 'バリ語',
    'bas'   => 'バサ語',
    'bat'   => 'バルト諸語',
    'be'    => 'ベラルーシ語',
    'bej'   => 'ベジャ語',
    'bem'   => 'ベンバ語',
    'ber'   => 'ベルベル諸語',
    'bg'    => 'ブルガリア語',
    'bh'    => 'ビハール語',
    'bho'   => 'ボージプリー語',
    'bi'    => 'ビスラマ語',
    'bik'   => 'ビコル語',
    'bin'   => 'ビニ語',
    'bla'   => 'シクシカ語',
    'bm'    => 'バンバラ語',
    'bn'    => 'ベンガル語',
    'bnt'   => 'バントゥ諸語',
    'bo'    => 'チベット語',
    'br'    => 'ブルトン語',
    'bra'   => 'ブラジ語',
    'bs'    => 'ボスニア語',
    'btk'   => 'バタク語',
    'bua'   => 'ブリヤート語',
    'bug'   => 'ブギ語',
    'byn'   => 'ビリン語',
    'ca'    => 'カタロニア語',
    'cad'   => 'カドー語',
    'cai'   => '中米インディアン諸語',
    'car'   => 'カリブ語',
    'cau'   => 'コーカサス諸語',
    'cch'   => 'チャワイ語',
    'ce'    => 'チェチェン語',
    'ceb'   => 'セブアノ語',
    'cel'   => 'ケルト諸語',
    'ch'    => 'チャモロ語',
    'chb'   => 'チブチャ語',
    'chg'   => 'チャガタイ語',
    'chk'   => 'チューク語',
    'chm'   => 'マリ語',
    'chn'   => "ビーチ・ラ・マー\ 等",
    'cho'   => 'チョクトー語',
    'chp'   => 'チペワイアン語',
    'chr'   => 'チェロキー語',
    'chy'   => 'シャイアン語',
    'cmc'   => 'チャム語族',
    'co'    => 'コルシカ語',
    'cop'   => 'コプト語',
    'cpe'   => '英語が基盤の混成語・混合語',
    'cpf'   => 'フランス語が基盤の混成語・混合語',
    'cpp'   => 'ポルトガル語が基盤の混成語・混合語',
    'cr'    => 'クリー語',
    'crh'   => 'クリミア・タタール語',
    'crp'   => 'その他の混成語・混合語',
    'cs'    => 'チェコ語',
    'csb'   => 'カシューブ語',
    'cu'    => '教会スラブ語',
    'cus'   => 'クシュ諸語',
    'cv'    => 'チュヴァシュ語',
    'cy'    => 'ウェールズ語',
    'da'    => 'デンマーク語',
    'dak'   => 'ダコタ語',
    'dar'   => 'ダルガン語',
    'day'   => 'ダヤク語',
    'de'    => 'ドイツ語',
    'de_at' => 'ドイツ語（オーストリア）',
    'de_ch' => '正統ドイツ語（スイス）',
    'del'   => 'デラウェア語',
    'den'   => 'スレイビー語',
    'dgr'   => 'ドグリブ語',
    'din'   => 'ディンカ語',
    'doi'   => 'ドグリ語',
    'dra'   => 'ドラヴィダ諸語',
    'dsb'   => '低ソルビア語',
    'dua'   => 'ドゥアラ語',
    'dum'   => '中世オランダ語',
    'dv'    => 'ディベヒ語',
    'dyu'   => 'デゥウラ語',
    'dz'    => 'ゾンカ語',
    'ee'    => 'エウェ語',
    'efi'   => 'エフィック語',
    'egy'   => '古代エジプト語',
    'eka'   => 'エカジュク語',
    'el'    => 'ギリシャ語',
    'elx'   => 'エラム語',
    'en'    => '英語',
    'en_au' => "Australian\ English",
    'en_ca' => 'カナダ英語',
    'en_gb' => 'イギリス英語',
    'en_us' => 'アメリカ英語',
    'enm'   => '中世英語',
    'eo'    => 'エスペラント語',
    'es'    => 'スペイン語',
    'es_es' => 'スペイン語（イベリア半島）',
    'et'    => 'エストニア語',
    'eu'    => 'バスク語',
    'ewo'   => 'エウォンド語',
    'fa'    => 'ペルシア語',
    'fan'   => 'ファング語',
    'fat'   => 'ファンティー語',
    'ff'    => 'フラニ語',
    'fi'    => 'フィンランド語',
    'fil'   => 'フィリピノ語',
    'fiu'   => 'フィン・ウゴル諸語',
    'fj'    => 'フィジー語',
    'fo'    => 'フェロー語',
    'fon'   => 'フォン語',
    'fr'    => 'フランス語',
    'fr_ca' => 'フランス語（カナダ）',
    'fr_ch' => 'フランス語（スイス）',
    'frm'   => '中期フランス語',
    'fro'   => '古フランス語',
    'frr'   => "Northern\ Frisian",
    'frs'   => '東フリジア語',
    'fur'   => 'フリウリ語',
    'fy'    => 'フリジア語',
    'ga'    => 'アイルランド語',
    'gaa'   => 'ガ語',
    'gay'   => 'ガヨ語',
    'gba'   => 'バヤ語',
    'gd'    => 'スコットランド・ゲール語',
    'gem'   => 'ゲルマン諸語',
    'gez'   => 'ゲエズ語',
    'gil'   => 'キリバス語',
    'gl'    => 'ガリシア語',
    'gmh'   => '中高ドイツ語',
    'gn'    => 'グアラニー語',
    'goh'   => '古高ドイツ語',
    'gon'   => 'ゴーンディー語',
    'gor'   => 'ゴロンタロ語',
    'got'   => 'ゴート語',
    'grb'   => 'グレボ語',
    'grc'   => '古代ギリシャ語',
    'gsw'   => 'スイスドイツ語（スイス）',
    'gu'    => 'グジャラート語',
    'gv'    => 'マン島語',
    'gwi'   => 'グウィッチン語',
    'ha'    => 'ハウサ語',
    'hai'   => 'ハイダ語',
    'haw'   => 'ハワイ語',
    'he'    => 'ヘブライ語',
    'hi'    => 'ヒンディー語',
    'hil'   => 'ヒリガイノン語',
    'him'   => 'ヒマチャル語',
    'hit'   => 'ヒッタイト語',
    'hmn'   => 'フモン語',
    'ho'    => 'ヒリモトゥ語',
    'hr'    => 'クロアチア語',
    'hsb'   => '上ソルビア語',
    'ht'    => 'ハイチ語',
    'hu'    => 'ハンガリー語',
    'hup'   => 'アタパスカ語',
    'hy'    => 'アルメニア語',
    'hz'    => 'ヘレロ語',
    'ia'    => 'インターリングア語',
    'iba'   => 'イバン語',
    'id'    => 'インドネシア語',
    'ie'    => 'インターリング語',
    'ig'    => 'イボ語',
    'ii'    => '四川イ語',
    'ijo'   => 'イジョー語',
    'ik'    => 'イヌピアック語',
    'ilo'   => 'イロカノ語',
    'inc'   => 'インド諸語',
    'ine'   => '印欧諸語',
    'inh'   => 'イングシ語',
    'io'    => 'イド語',
    'ira'   => 'イラン語',
    'iro'   => 'イロコイ語族',
    'is'    => 'アイスランド語',
    'it'    => 'イタリア語',
    'iu'    => 'イヌクウティトット語',
    'ja'    => '日本語',
    'jbo'   => 'ロジバン語',
    'jpr'   => 'ユダヤ・ペルシア語',
    'jrb'   => 'ユダヤ・アラビア語',
    'jv'    => 'ジャワ語',
    'ka'    => 'グルジア語',
    'kaa'   => 'カラ・カルパク語',
    'kab'   => 'カビル語',
    'kac'   => 'カチン語',
    'kaj'   => 'カジェ語',
    'kam'   => 'カンバ語',
    'kar'   => 'カレン語',
    'kaw'   => 'カウィ語',
    'kbd'   => 'カバルド語',
    'kcg'   => 'カタブ語',
    'kfo'   => 'コロ語',
    'kg'    => 'コンゴ語',
    'kha'   => 'カシ語',
    'khi'   => 'コイサン諸語',
    'kho'   => 'コータン語',
    'ki'    => 'キクユ語',
    'kj'    => 'クアニャマ語',
    'kk'    => 'カザフ語',
    'kl'    => 'グリーンランド語',
    'km'    => 'クメール語',
    'kmb'   => 'キンブンドゥ語',
    'kn'    => 'カンナダ語',
    'ko'    => '韓国語',
    'kok'   => 'コンカニ語',
    'kos'   => 'コシャエ語',
    'kpe'   => 'クペレ語',
    'kr'    => 'カヌリ語',
    'krc'   => 'カラチャイ語',
    'krl'   => 'カレリア語',
    'kro'   => 'クルー語',
    'kru'   => 'クルク語',
    'ks'    => 'カシミール語',
    'ku'    => 'クルド語',
    'kum'   => 'クムク語',
    'kut'   => 'クテナイ語',
    'kv'    => 'コミ語',
    'kw'    => 'コーンウォール語',
    'ky'    => 'キルギス語',
    'la'    => 'ラテン語',
    'lad'   => 'ラジノ語',
    'lah'   => 'ラフンダー語',
    'lam'   => 'ランバ語',
    'lb'    => 'ルクセンブルク語',
    'lez'   => 'レズギ語',
    'lg'    => 'ガンダ語',
    'li'    => 'リンブルフ語',
    'ln'    => 'リンガラ語',
    'lo'    => 'ラオ語',
    'lol'   => 'モンゴ語',
    'loz'   => 'ロズィ語',
    'lt'    => 'リトアニア語',
    'lu'    => 'ルバ・カタンガ語',
    'lua'   => 'ルバ・ルルア語',
    'lui'   => 'ルイセーニョ語',
    'lun'   => 'ルンダ語',
    'luo'   => 'ルオ語',
    'lus'   => 'ルシャイ語',
    'lv'    => 'ラトビア語',
    'mad'   => 'マドゥラ語',
    'mag'   => 'マガヒー語',
    'mai'   => 'マイティリー語',
    'mak'   => 'マカッサル語',
    'man'   => 'マンディンゴ語',
    'map'   => 'オーストロネシア諸語',
    'mas'   => 'マサイ語',
    'mdf'   => 'モクシャ語',
    'mdr'   => 'マンダル語',
    'men'   => 'メンデ語',
    'mfe'   => 'Morisyen',
    'mg'    => 'マダガスカル語',
    'mga'   => '中期アイルランド語',
    'mh'    => 'マーシャル語',
    'mi'    => 'マオリ語',
    'mic'   => 'ミクマク語',
    'min'   => 'ミナンカバウ語',
    'mis'   => 'その他の言語',
    'mk'    => 'マケドニア語',
    'mkh'   => 'モン・クメール諸語',
    'ml'    => 'マラヤーラム語',
    'mn'    => 'モンゴル語',
    'mnc'   => '満州語',
    'mni'   => 'マニプル語',
    'mno'   => 'マノボ語族',
    'mo'    => 'モルダビア語',
    'moh'   => 'モーホーク語',
    'mos'   => 'モシ語',
    'mr'    => 'マラーティー語',
    'ms'    => 'マレー語',
    'mt'    => 'マルタ語',
    'mul'   => '複数言語',
    'mun'   => 'ムンダ語族',
    'mus'   => 'クリーク語',
    'mwl'   => 'ミランダ語',
    'mwr'   => 'マールワーリー語',
    'my'    => 'ビルマ語',
    'myn'   => 'マヤ語族',
    'myv'   => 'エルジャ語',
    'na'    => 'ナウル語',
    'nah'   => 'ナワトル語',
    'nai'   => '北米インディアン諸語',
    'nap'   => 'ナポリ語',
    'nb'    => "ノルウェー語\ \(ブークモール\)",
    'nd'    => '北ンデベレ語',
    'nds'   => '低地ドイツ語、低地サクソン語',
    'ne'    => 'ネパール語',
    'new'   => 'ネワール語',
    'ng'    => 'ンドンガ語',
    'nia'   => 'ニアス語',
    'nic'   => 'ニジェール・コルドファン諸語',
    'niu'   => 'ニウーエイ語',
    'nl'    => 'オランダ語',
    'nl_be' => 'フレミッシュ語',
    'nn'    => "ノルウェー語\ \(ニーノシュク\)",
    'no'    => 'ノルウェー語',
    'nog'   => 'ノガイ語',
    'non'   => '古ノルド語',
    'nqo'   => 'ンコ語',
    'nr'    => '南ンデベレ語',
    'nso'   => '北部ソト語',
    'nub'   => 'ヌビア語族',
    'nv'    => 'ナバホ語',
    'nwc'   => '古典ネワール語',
    'ny'    => 'ニャンジャ語、チチェワ語、チェワ語',
    'nym'   => 'ニャムウェジ語',
    'nyn'   => 'ニャンコレ語',
    'nyo'   => 'ニョロ語',
    'nzi'   => 'ンゼマ語',
    'oc'    => 'オック語',
    'oj'    => 'オブジワ語',
    'om'    => 'オロモ語',
    'or'    => 'オリヤー語',
    'os'    => 'オセト語',
    'osa'   => 'オセージ語',
    'ota'   => 'オスマントルコ語',
    'oto'   => 'オトミ語族',
    'pa'    => 'パンジャブ語',
    'paa'   => 'パプア諸語',
    'pag'   => 'パンガシナン語',
    'pal'   => 'パフラヴィ語',
    'pam'   => 'パンパンガ語',
    'pap'   => 'パピアメント語',
    'pau'   => 'パラオ語',
    'peo'   => '古代ペルシア語',
    'phi'   => 'フィリピン諸語',
    'phn'   => 'フェニキア語',
    'pi'    => 'パーリ語',
    'pl'    => 'ポーランド語',
    'pon'   => 'ポンペイ語',
    'pra'   => 'プラークリット語族',
    'pro'   => '古期プロバンス語',
    'ps'    => 'パシュトゥー語',
    'pt'    => 'ポルトガル語',
    'pt_br' => "ポルトガル語\ \(ブラジル\)",
    'pt_pt' => 'ポルトガル語（イベリア半島）',
    'qu'    => 'ケチュア語',
    'raj'   => 'ラージャスターン語',
    'rap'   => 'ラパヌイ語',
    'rar'   => 'ラロトガ語',
    'rm'    => 'レト・ロマン語',
    'rn'    => 'ルンディ語',
    'ro'    => 'ルーマニア語',
    'roa'   => 'ロマンス諸語',
    'rom'   => 'ロマーニー語',
    'ru'    => 'ロシア語',
    'rup'   => 'アルーマニア語',
    'rw'    => 'ルワンダ語',
    'sa'    => 'サンスクリット語',
    'sad'   => 'サンダウェ語',
    'sah'   => 'ヤクート語',
    'sai'   => '南米インディアン諸語',
    'sal'   => 'セイリッシュ語族',
    'sam'   => 'サマリア・アラム語',
    'sas'   => 'ササク語',
    'sat'   => 'サンターリー語',
    'sc'    => 'サルデーニャ語',
    'scn'   => 'シチリア語',
    'sco'   => 'スコットランド語',
    'sd'    => 'シンド語',
    'se'    => '北サーミ語',
    'sel'   => 'セリクプ語',
    'sem'   => 'セム諸語',
    'sg'    => 'サンゴ語',
    'sga'   => '古期アイルランド語',
    'sgn'   => '手まね言語',
    'sh'    => 'セルボ＝クロアチア語',
    'shn'   => 'シャン語',
    'si'    => 'シンハラ語',
    'sid'   => 'シダモ語',
    'sio'   => 'スー語族',
    'sit'   => 'シナ・チベット諸語',
    'sk'    => 'スロバキア語',
    'sl'    => 'スロベニア語',
    'sla'   => 'スラブ諸語',
    'sm'    => 'サモア語',
    'sma'   => '南サーミ語',
    'smi'   => 'サーミ諸語',
    'smj'   => 'ルレ・サーミ語',
    'smn'   => 'イナリ・サーミ語',
    'sms'   => 'スコルト・サーミ語',
    'sn'    => 'ショナ語',
    'snk'   => 'ソニンケ語',
    'so'    => 'ソマリ語',
    'sog'   => 'ソグド語',
    'son'   => 'ソンガイ語',
    'sq'    => 'アルバニア語',
    'sr'    => 'セルビア語',
    'srn'   => 'スリナム語',
    'srr'   => 'セレル語',
    'ss'    => 'シスワティ語',
    'ssa'   => 'ナイル・サハラ諸語',
    'st'    => '南部ソト語',
    'su'    => 'スンダ語',
    'suk'   => 'スクマ語',
    'sus'   => 'スス語',
    'sux'   => 'シュメール語',
    'sv'    => 'スウェーデン語',
    'sw'    => 'スワヒリ語',
    'syc'   => "Classical\ Syriac",
    'syr'   => 'シリア語',
    'ta'    => 'タミール語',
    'tai'   => 'タイ諸語',
    'te'    => 'テルグ語',
    'tem'   => 'テムネ語',
    'ter'   => 'テレーノ語',
    'tet'   => 'テトゥン語',
    'tg'    => 'タジク語',
    'th'    => 'タイ語',
    'ti'    => 'ティグリニア語',
    'tig'   => 'ティグレ語',
    'tiv'   => 'ティブ語',
    'tk'    => 'トルクメン語',
    'tkl'   => 'トケラウ語',
    'tl'    => 'タガログ語',
    'tlh'   => 'クリンゴン語',
    'tli'   => 'トリンギット語',
    'tmh'   => 'タマシェク語',
    'tn'    => 'ツワナ語',
    'to'    => 'トンガ語',
    'tog'   => "トンガ語\ \(ニアサ\)",
    'tpi'   => 'トク・ピシン語',
    'tr'    => 'トルコ語',
    'trv'   => 'Taroko',
    'ts'    => 'ツォンガ語',
    'tsi'   => 'チムシュ語',
    'tt'    => 'タタール語',
    'tum'   => 'トゥンブカ語',
    'tup'   => 'トゥピ語族',
    'tut'   => 'アルタイ諸語',
    'tvl'   => 'ツバル語',
    'tw'    => 'トウィ語',
    'ty'    => 'タヒチ語',
    'tyv'   => 'トゥヴァ語',
    'udm'   => 'ウドムルト語',
    'ug'    => 'ウイグル語',
    'uga'   => 'ウガリト語',
    'uk'    => 'ウクライナ語',
    'umb'   => 'ウンブンドゥ語',
    'und'   => '非確定',
    'ur'    => 'ウルドゥー語',
    'uz'    => 'ウズベク語',
    'vai'   => 'ヴァイ語',
    've'    => 'ベンダ語',
    'vi'    => 'ベトナム語',
    'vo'    => 'ボラピュク語',
    'vot'   => 'ボート語',
    'wa'    => 'ワロン語',
    'wak'   => 'ワカシ語族',
    'wal'   => 'ワッラモ語',
    'war'   => 'ワライ語',
    'was'   => 'ワショ語',
    'wen'   => 'ソルビア語族',
    'wo'    => 'ウォロフ語',
    'xal'   => 'カルムイク語',
    'xh'    => 'コサ語',
    'yao'   => 'ヤオ語',
    'yap'   => 'ヤップ語',
    'yi'    => 'イディッシュ語',
    'yo'    => 'ヨルバ語',
    'ypk'   => 'ユピック語族',
    'za'    => 'チワン語',
    'zap'   => 'ザポテック語',
    'zbl'   => 'Blissymbols',
    'zen'   => 'ゼナガ語',
    'zh'    => '中国語',
    'znd'   => 'ザンデ語',
    'zu'    => 'ズールー語',
    'zun'   => 'ズニ語',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::ja::name_to_code = (
    ''                        => 'zun',
    "\ "                      => 'tog',
    "australian\ english"     => 'en_au',
    'blissymbols'             => 'zbl',
    "classical\ syriac"       => 'syc',
    'morisyen'                => 'mfe',
    "no\ linguistic\ content" => 'zxx',
    "northern\ frisian"       => 'frr',
    'taroko'                  => 'trv',
    'zaza'                    => 'zza',
);

1;
