package Locales::DB::Language::ga;

# Auto generated from CLDR

$Locales::DB::Language::ga::VERSION = '0.01';

$Locales::DB::Language::ga::cldr_version = '1.7.1';

%Locales::DB::Language::ga::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Language\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'fallback'    => [ 'en_IE' ],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr' => {
            'content' => "níl\:n",
            'draft'   => 'unconfirmed'
        },
        'yesstr' => {
            'content' => "tá\:t",
            'draft'   => 'unconfirmed'
        }
    },
);

%Locales::DB::Language::ga::code_to_name = (
    'aa'    => 'aa',
    'ab'    => 'Abcáisis',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Aivéistis',
    'af'    => 'Afracáinis',
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'Amarais',
    'an'    => 'Aragonese',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => 'Araibis',
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Artificial\ Language",
    'arw'   => 'Arawak',
    'as'    => 'Asaimis',
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => 'Asarbaiseáinis',
    'ba'    => 'Baiscíris',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basa',
    'bat'   => "Baltic\ Language",
    'be'    => 'Bealarúisis',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bg'    => 'Bulgáiris',
    'bh'    => 'Bihairis',
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'Beangáilis',
    'bnt'   => 'Bantu',
    'bo'    => 'Tibéadais',
    'br'    => 'Briotáinis',
    'bra'   => 'Braj',
    'bs'    => 'Boisnis',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'Catalóinis',
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cch'   => 'Atsam',
    'ce'    => 'Sisinis',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ Language",
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'Corsaicis',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Craíais',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'Seicis',
    'csb'   => 'Kashubian',
    'cu'    => "Slavais\ na\ hEaglaise",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Suvaisis',
    'cy'    => 'Breatnais',
    'da'    => 'Danmhairgis',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'day'   => 'Dayak',
    'de'    => 'Gearmáinis',
    'de_at' => "Austrian\ German",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'Divehi',
    'dyu'   => 'Dyula',
    'dz'    => 'Dzongkha',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Ancient\ Egyptian",
    'eka'   => 'Ekajuk',
    'el'    => 'Gréigis',
    'elx'   => 'Elamite',
    'en'    => 'Béarla',
    'en_au' => "Australian\ English",
    'en_ca' => "Canadian\ English",
    'en_gb' => "British\ English",
    'en_us' => "U\.S\.\ English",
    'enm'   => "Middle\ English",
    'eo'    => 'Esperanto',
    'es'    => 'Spáinnis',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'Eastóinis',
    'eu'    => 'Bascais',
    'ewo'   => 'Ewondo',
    'fa'    => 'Peirsis',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'Fionlainnis',
    'fil'   => 'fil',
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'Fidsis',
    'fo'    => 'Faróis',
    'fon'   => 'Fon',
    'fr'    => 'Fraincis',
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "Swiss\ French",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => "Freaslainnis\ Iartharach",
    'ga'    => 'Gaeilge',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "Gaeilge\ na\ hAlban",
    'gem'   => "Germanic\ Language",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'Gailísis',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'Guaráinis',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Ancient\ Greek",
    'gsw'   => "Swiss\ German",
    'gu'    => 'Gúisearáitis',
    'gv'    => 'Mannainis',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'Hausa',
    'hai'   => 'Haida',
    'haw'   => 'Haváíais',
    'he'    => 'Eabhrais',
    'hi'    => 'Hiondúis',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'Cróitis',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => 'Ungáiris',
    'hup'   => 'Hupa',
    'hy'    => 'Airméinis',
    'hz'    => 'Herero',
    'ia'    => 'Interlingua',
    'iba'   => 'Iban',
    'id'    => 'Indinéisis',
    'ie'    => 'Interlingue',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'Íoslainnis',
    'it'    => 'Iodáilis',
    'iu'    => 'Ionúitis',
    'ja'    => 'Seapáinis',
    'jbo'   => 'Lojban',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'Iávais',
    'ka'    => 'Seoirsis',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'Casachais',
    'kl'    => 'Kalaallisut',
    'km'    => 'Cambóidis',
    'kmb'   => 'Kimbundu',
    'kn'    => 'Cannadais',
    'ko'    => 'Cóiréis',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Caismíris',
    'ku'    => 'Coirdis',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornais',
    'ky'    => 'Cirgeasais',
    'la'    => 'Laidin',
    'lad'   => 'Ladino',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Leitseabuirgis',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'ln',
    'lo'    => 'Laosais',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'Liotuáinis',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'lv'    => 'Laitvis',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagásais',
    'mga'   => "Middle\ Irish",
    'mh'    => 'Marshallese',
    'mi'    => 'Maorais',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => 'Macadóinis',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'Mailéalaimis',
    'mn'    => 'Mongóilis',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'Moldáivis',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'Maraitis',
    'ms'    => 'Malaeis',
    'mt'    => 'Maltais',
    'mul'   => "Multiple\ Languages",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'Burmais',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'Nárúis',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'nb'    => "Ioruais\ Bokmål",
    'nd'    => "North\ Ndebele",
    'nds'   => "Low\ German",
    'ne'    => 'Neipealais',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'Ollainnis',
    'nl_be' => 'Flemish',
    'nn'    => "Ioruais\ Nynorsk",
    'no'    => 'Ioruais',
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Nubian\ Language",
    'nv'    => 'Navachóis',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'Ocatáinis',
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'Oraisis',
    'os'    => 'Óiséitis',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'Puinseáibis',
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => 'Polainnis',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'Paistis',
    'pt'    => 'Portaingéilis',
    'pt_br' => "Portaingéilis\ Bhrasaíleach",
    'pt_pt' => "Portaingéilis\ Ibéireach",
    'qu'    => 'Ceatsuais',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => "Rhaeto\-Romance",
    'rn'    => 'Rundi',
    'ro'    => 'Rómáinis',
    'roa'   => "Romance\ Language",
    'rom'   => 'Romany',
    'ru'    => 'Rúisis',
    'rup'   => 'Aromanian',
    'rw'    => 'Kinyarwanda',
    'sa'    => 'Sanscrait',
    'sad'   => 'Sandawe',
    'sah'   => 'Yakut',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sc'    => 'Sairdínis',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => 'Sindis',
    'se'    => "Sáimis\ Thuaidh",
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'sg'    => 'Sango',
    'sga'   => "Old\ Irish",
    'sgn'   => "Sign\ Language",
    'sh'    => "Seirbea\-Chróitis",
    'shn'   => 'Shan',
    'si'    => 'Siolóinis',
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => 'Slóvaicis',
    'sl'    => 'Slóivéinis',
    'sla'   => "Slavic\ Language",
    'sm'    => 'Samóis',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => 'Somáilis',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'Albáinis',
    'sr'    => 'Seirbis',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swati',
    'ssa'   => "Nilo\-Saharan\ Language",
    'st'    => "Sótais\ Dheisceartach",
    'su'    => 'Sundais',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => 'Sualainnis',
    'sw'    => 'Svahaílis',
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'Tamailis',
    'tai'   => "Tai\ Language",
    'te'    => 'Teileagúis',
    'tem'   => 'Timne',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'Tajik',
    'th'    => 'Téalainnis',
    'ti'    => 'Tigrinis',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'Tuircméinis',
    'tkl'   => 'Tokelau',
    'tl'    => 'Tagálaigis',
    'tlh'   => 'Klingon',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'Tswana',
    'to'    => 'Tonga',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'Tuircis',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tatarais',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'Tvís',
    'ty'    => 'Taihítis',
    'tyv'   => 'Tuvinian',
    'udm'   => 'Udmurt',
    'ug'    => 'ug',
    'uga'   => 'Ugaritic',
    'uk'    => 'Úcráinis',
    'umb'   => 'Umbundu',
    'und'   => "Teanga\ Anaithnid\ nó\ Neamhbhailí",
    'ur'    => 'Urdais',
    'uz'    => 'Úisbéicis',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'Vítneamais',
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'wa'    => 'Vallúnais',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'Wolof',
    'xal'   => 'Kalmyk',
    'xh'    => 'Cósais',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yi'    => 'Giúdais',
    'yo'    => 'Yoruba',
    'ypk'   => "Yupik\ Language",
    'za'    => 'Zhuang',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'Sínis',
    'znd'   => 'Zande',
    'zu'    => 'Súlúis',
    'zun'   => 'Zuni',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::ga::name_to_code = (
    'aa'                                  => 'aa',
    'abcisis'                             => 'ab',
    'achinese'                            => 'ace',
    'acoli'                               => 'ach',
    'adangme'                             => 'ada',
    'adyghe'                              => 'ady',
    'afracinis'                           => 'af',
    'afrihili'                            => 'afh',
    "afroasiatic\ language"               => 'afa',
    'ainu'                                => 'ain',
    'airminis'                            => 'hy',
    'aivistis'                            => 'ae',
    'akan'                                => 'ak',
    'akkadian'                            => 'akk',
    'albinis'                             => 'sq',
    'aleut'                               => 'ale',
    "algonquian\ language"                => 'alg',
    "altaic\ language"                    => 'tut',
    'amarais'                             => 'am',
    "ancient\ egyptian"                   => 'egy',
    "ancient\ greek"                      => 'grc',
    'angika'                              => 'anp',
    "apache\ language"                    => 'apa',
    'aragonese'                           => 'an',
    'araibis'                             => 'ar',
    'aramaic'                             => 'arc',
    'arapaho'                             => 'arp',
    'araucanian'                          => 'arn',
    'arawak'                              => 'arw',
    'aromanian'                           => 'rup',
    "artificial\ language"                => 'art',
    'asaimis'                             => 'as',
    'asarbaiseinis'                       => 'az',
    'asturian'                            => 'ast',
    "athapascan\ language"                => 'ath',
    'atsam'                               => 'cch',
    "australian\ english"                 => 'en_au',
    "australian\ language"                => 'aus',
    "austrian\ german"                    => 'de_at',
    "austronesian\ language"              => 'map',
    'avaric'                              => 'av',
    'awadhi'                              => 'awa',
    'aymara'                              => 'ay',
    'baiscris'                            => 'ba',
    'balinese'                            => 'ban',
    "baltic\ language"                    => 'bat',
    'baluchi'                             => 'bal',
    'bambara'                             => 'bm',
    "bamileke\ language"                  => 'bai',
    'banda'                               => 'bad',
    'bantu'                               => 'bnt',
    'barla'                               => 'en',
    'basa'                                => 'bas',
    'bascais'                             => 'eu',
    'batak'                               => 'btk',
    'bealarisis'                          => 'be',
    'beangilis'                           => 'bn',
    'beja'                                => 'bej',
    'bemba'                               => 'bem',
    'berber'                              => 'ber',
    'bhojpuri'                            => 'bho',
    'bihairis'                            => 'bh',
    'bikol'                               => 'bik',
    'bini'                                => 'bin',
    'bislama'                             => 'bi',
    'blin'                                => 'byn',
    'blissymbols'                         => 'zbl',
    'boisnis'                             => 'bs',
    'braj'                                => 'bra',
    'breatnais'                           => 'cy',
    'briotinis'                           => 'br',
    "british\ english"                    => 'en_gb',
    'buginese'                            => 'bug',
    'bulgiris'                            => 'bg',
    'buriat'                              => 'bua',
    'burmais'                             => 'my',
    'caddo'                               => 'cad',
    'caismris'                            => 'ks',
    'cambidis'                            => 'km',
    "canadian\ english"                   => 'en_ca',
    "canadian\ french"                    => 'fr_ca',
    'cannadais'                           => 'kn',
    'carib'                               => 'car',
    'casachais'                           => 'kk',
    'catalinis'                           => 'ca',
    "caucasian\ language"                 => 'cau',
    'ceatsuais'                           => 'qu',
    'cebuano'                             => 'ceb',
    "celtic\ language"                    => 'cel',
    "central\ american\ indian\ language" => 'cai',
    'chagatai'                            => 'chg',
    "chamic\ language"                    => 'cmc',
    'chamorro'                            => 'ch',
    'cherokee'                            => 'chr',
    'cheyenne'                            => 'chy',
    'chibcha'                             => 'chb',
    "chinook\ jargon"                     => 'chn',
    'chipewyan'                           => 'chp',
    'choctaw'                             => 'cho',
    'chuukese'                            => 'chk',
    'cirgeasais'                          => 'ky',
    'ciris'                               => 'ko',
    "classical\ newari"                   => 'nwc',
    "classical\ syriac"                   => 'syc',
    'coirdis'                             => 'ku',
    'coptic'                              => 'cop',
    'cornais'                             => 'kw',
    'corsaicis'                           => 'co',
    'craais'                              => 'cr',
    'creek'                               => 'mus',
    "creole\ or\ pidgin"                  => 'crp',
    "crimean\ turkish"                    => 'crh',
    'crinis'                              => 'uk',
    'critis'                              => 'hr',
    'csais'                               => 'xh',
    "cushitic\ language"                  => 'cus',
    'dakota'                              => 'dak',
    'danmhairgis'                         => 'da',
    'dargwa'                              => 'dar',
    'dayak'                               => 'day',
    'delaware'                            => 'del',
    'dinka'                               => 'din',
    'divehi'                              => 'dv',
    'dogri'                               => 'doi',
    'dogrib'                              => 'dgr',
    "dravidian\ language"                 => 'dra',
    'duala'                               => 'dua',
    'dyula'                               => 'dyu',
    'dzongkha'                            => 'dz',
    'eabhrais'                            => 'he',
    "eastern\ frisian"                    => 'frs',
    'eastinis'                            => 'et',
    'efik'                                => 'efi',
    'ekajuk'                              => 'eka',
    'elamite'                             => 'elx',
    "englishbased\ creole\ or\ pidgin"    => 'cpe',
    'erzya'                               => 'myv',
    'esperanto'                           => 'eo',
    'ewe'                                 => 'ee',
    'ewondo'                              => 'ewo',
    'fang'                                => 'fan',
    'fanti'                               => 'fat',
    'faris'                               => 'fo',
    'fidsis'                              => 'fj',
    'fil'                                 => 'fil',
    "finnougrian\ language"               => 'fiu',
    'fionlainnis'                         => 'fi',
    'flemish'                             => 'nl_be',
    'fon'                                 => 'fon',
    'fraincis'                            => 'fr',
    "freaslainnis\ iartharach"            => 'fy',
    "frenchbased\ creole\ or\ pidgin"     => 'cpf',
    'friulian'                            => 'fur',
    'fulah'                               => 'ff',
    'ga'                                  => 'gaa',
    'gaeilge'                             => 'ga',
    "gaeilge\ na\ halban"                 => 'gd',
    'gailsis'                             => 'gl',
    'ganda'                               => 'lg',
    'gayo'                                => 'gay',
    'gbaya'                               => 'gba',
    'gearminis'                           => 'de',
    'geez'                                => 'gez',
    "germanic\ language"                  => 'gem',
    'gidais'                              => 'yi',
    'gilbertese'                          => 'gil',
    'gisearitis'                          => 'gu',
    'gondi'                               => 'gon',
    'gorontalo'                           => 'gor',
    'gothic'                              => 'got',
    'grebo'                               => 'grb',
    'grigis'                              => 'el',
    'guarinis'                            => 'gn',
    'gwichin'                             => 'gwi',
    'haida'                               => 'hai',
    'haitian'                             => 'ht',
    'hausa'                               => 'ha',
    'havais'                              => 'haw',
    'herero'                              => 'hz',
    'hiligaynon'                          => 'hil',
    'himachali'                           => 'him',
    'hiondis'                             => 'hi',
    "hiri\ motu"                          => 'ho',
    'hittite'                             => 'hit',
    'hmong'                               => 'hmn',
    'hupa'                                => 'hup',
    'iban'                                => 'iba',
    "iberian\ spanish"                    => 'es_es',
    'ido'                                 => 'io',
    'igbo'                                => 'ig',
    'ijo'                                 => 'ijo',
    'iloko'                               => 'ilo',
    "inari\ sami"                         => 'smn',
    "indic\ language"                     => 'inc',
    'indinisis'                           => 'id',
    "indoeuropean\ language"              => 'ine',
    'ingush'                              => 'inh',
    'interlingua'                         => 'ia',
    'interlingue'                         => 'ie',
    'inupiaq'                             => 'ik',
    'iodilis'                             => 'it',
    'ionitis'                             => 'iu',
    'ioruais'                             => 'no',
    "ioruais\ bokml"                      => 'nb',
    "ioruais\ nynorsk"                    => 'nn',
    "iranian\ language"                   => 'ira',
    "iroquoian\ language"                 => 'iro',
    'isbicis'                             => 'uz',
    'isitis'                              => 'os',
    'ivais'                               => 'jv',
    'jju'                                 => 'kaj',
    'judeoarabic'                         => 'jrb',
    'judeopersian'                        => 'jpr',
    'kabardian'                           => 'kbd',
    'kabyle'                              => 'kab',
    'kachin'                              => 'kac',
    'kalaallisut'                         => 'kl',
    'kalmyk'                              => 'xal',
    'kamba'                               => 'kam',
    'kanuri'                              => 'kr',
    'karachaybalkar'                      => 'krc',
    'karakalpak'                          => 'kaa',
    'karelian'                            => 'krl',
    'karen'                               => 'kar',
    'kashubian'                           => 'csb',
    'kawi'                                => 'kaw',
    'khasi'                               => 'kha',
    "khoisan\ language"                   => 'khi',
    'khotanese'                           => 'kho',
    'kikuyu'                              => 'ki',
    'kimbundu'                            => 'kmb',
    'kinyarwanda'                         => 'rw',
    'klingon'                             => 'tlh',
    'komi'                                => 'kv',
    'kongo'                               => 'kg',
    'konkani'                             => 'kok',
    'koro'                                => 'kfo',
    'kosraean'                            => 'kos',
    'kpelle'                              => 'kpe',
    'kru'                                 => 'kro',
    'kuanyama'                            => 'kj',
    'kumyk'                               => 'kum',
    'kurukh'                              => 'kru',
    'kutenai'                             => 'kut',
    'ladino'                              => 'lad',
    'lahnda'                              => 'lah',
    'laidin'                              => 'la',
    'laitvis'                             => 'lv',
    'lamba'                               => 'lam',
    'laosais'                             => 'lo',
    'leitseabuirgis'                      => 'lb',
    'lezghian'                            => 'lez',
    'limburgish'                          => 'li',
    'liotuinis'                           => 'lt',
    'ln'                                  => 'ln',
    'lojban'                              => 'jbo',
    "low\ german"                         => 'nds',
    "lower\ sorbian"                      => 'dsb',
    'lozi'                                => 'loz',
    'lubakatanga'                         => 'lu',
    'lubalulua'                           => 'lua',
    'luiseno'                             => 'lui',
    "lule\ sami"                          => 'smj',
    'lunda'                               => 'lun',
    'luo'                                 => 'luo',
    'lushai'                              => 'lus',
    'macadinis'                           => 'mk',
    'madurese'                            => 'mad',
    'magahi'                              => 'mag',
    'mailalaimis'                         => 'ml',
    'maithili'                            => 'mai',
    'makasar'                             => 'mak',
    'malaeis'                             => 'ms',
    'malagsais'                           => 'mg',
    'maltais'                             => 'mt',
    'manchu'                              => 'mnc',
    'mandar'                              => 'mdr',
    'mandingo'                            => 'man',
    'manipuri'                            => 'mni',
    'mannainis'                           => 'gv',
    "manobo\ language"                    => 'mno',
    'maorais'                             => 'mi',
    'maraitis'                            => 'mr',
    'mari'                                => 'chm',
    'marshallese'                         => 'mh',
    'marwari'                             => 'mwr',
    'masai'                               => 'mas',
    "mayan\ language"                     => 'myn',
    'mende'                               => 'men',
    'micmac'                              => 'mic',
    "middle\ dutch"                       => 'dum',
    "middle\ english"                     => 'enm',
    "middle\ french"                      => 'frm',
    "middle\ high\ german"                => 'gmh',
    "middle\ irish"                       => 'mga',
    'minangkabau'                         => 'min',
    'mirandese'                           => 'mwl',
    "miscellaneous\ language"             => 'mis',
    'mohawk'                              => 'moh',
    'moksha'                              => 'mdf',
    'moldivis'                            => 'mo',
    'mongilis'                            => 'mn',
    'mongo'                               => 'lol',
    "monkhmer\ language"                  => 'mkh',
    'morisyen'                            => 'mfe',
    'mossi'                               => 'mos',
    "multiple\ languages"                 => 'mul',
    "munda\ language"                     => 'mun',
    'nahuatl'                             => 'nah',
    'navachis'                            => 'nv',
    'ndonga'                              => 'ng',
    'neapolitan'                          => 'nap',
    'neipealais'                          => 'ne',
    'newari'                              => 'new',
    'nias'                                => 'nia',
    "nigerkordofanian\ language"          => 'nic',
    "nilosaharan\ language"               => 'ssa',
    'niuean'                              => 'niu',
    'nko'                                 => 'nqo',
    "no\ linguistic\ content"             => 'zxx',
    'nogai'                               => 'nog',
    "north\ american\ indian\ language"   => 'nai',
    "north\ ndebele"                      => 'nd',
    "northern\ frisian"                   => 'frr',
    "northern\ sotho"                     => 'nso',
    'nris'                                => 'na',
    "nubian\ language"                    => 'nub',
    'nyamwezi'                            => 'nym',
    'nyanja'                              => 'ny',
    'nyankole'                            => 'nyn',
    "nyasa\ tonga"                        => 'tog',
    'nyoro'                               => 'nyo',
    'nzima'                               => 'nzi',
    'ocatinis'                            => 'oc',
    'ojibwa'                              => 'oj',
    "old\ english"                        => 'ang',
    "old\ french"                         => 'fro',
    "old\ high\ german"                   => 'goh',
    "old\ irish"                          => 'sga',
    "old\ norse"                          => 'non',
    "old\ persian"                        => 'peo',
    "old\ provenal"                       => 'pro',
    'ollainnis'                           => 'nl',
    'oraisis'                             => 'or',
    'oromo'                               => 'om',
    'osage'                               => 'osa',
    'oslainnis'                           => 'is',
    "otomian\ language"                   => 'oto',
    "ottoman\ turkish"                    => 'ota',
    'pahlavi'                             => 'pal',
    'paistis'                             => 'ps',
    'palauan'                             => 'pau',
    'pali'                                => 'pi',
    'pampanga'                            => 'pam',
    'pangasinan'                          => 'pag',
    'papiamento'                          => 'pap',
    "papuan\ language"                    => 'paa',
    'peirsis'                             => 'fa',
    "philippine\ language"                => 'phi',
    'phoenician'                          => 'phn',
    'pohnpeian'                           => 'pon',
    'polainnis'                           => 'pl',
    'portaingilis'                        => 'pt',
    "portaingilis\ bhrasaleach"           => 'pt_br',
    "portaingilis\ ibireach"              => 'pt_pt',
    "portuguesebased\ creole\ or\ pidgin" => 'cpp',
    "prakrit\ language"                   => 'pra',
    'puinseibis'                          => 'pa',
    'rajasthani'                          => 'raj',
    'rapanui'                             => 'rap',
    'rarotongan'                          => 'rar',
    'rhaetoromance'                       => 'rm',
    'risis'                               => 'ru',
    'rminis'                              => 'ro',
    "romance\ language"                   => 'roa',
    'romany'                              => 'rom',
    'rundi'                               => 'rn',
    'sairdnis'                            => 'sc',
    "salishan\ language"                  => 'sal',
    "samaritan\ aramaic"                  => 'sam',
    "sami\ language"                      => 'smi',
    'samis'                               => 'sm',
    'sandawe'                             => 'sad',
    'sango'                               => 'sg',
    'sanscrait'                           => 'sa',
    'santali'                             => 'sat',
    'sasak'                               => 'sas',
    'scots'                               => 'sco',
    'seapinis'                            => 'ja',
    'seicis'                              => 'cs',
    'seirbeachritis'                      => 'sh',
    'seirbis'                             => 'sr',
    'selkup'                              => 'sel',
    "semitic\ language"                   => 'sem',
    'seoirsis'                            => 'ka',
    'serer'                               => 'srr',
    'shan'                                => 'shn',
    'shona'                               => 'sn',
    "sichuan\ yi"                         => 'ii',
    'sicilian'                            => 'scn',
    'sidamo'                              => 'sid',
    "sign\ language"                      => 'sgn',
    'siksika'                             => 'bla',
    "simis\ thuaidh"                      => 'se',
    'sindis'                              => 'sd',
    "sinotibetan\ language"               => 'sit',
    'siolinis'                            => 'si',
    "siouan\ language"                    => 'sio',
    'sisinis'                             => 'ce',
    "skolt\ sami"                         => 'sms',
    "slavais\ na\ heaglaise"              => 'cu',
    'slave'                               => 'den',
    "slavic\ language"                    => 'sla',
    'slis'                                => 'zu',
    'slivinis'                            => 'sl',
    'slvaicis'                            => 'sk',
    'snis'                                => 'zh',
    'sogdien'                             => 'sog',
    'somilis'                             => 'so',
    'songhai'                             => 'son',
    'soninke'                             => 'snk',
    "sorbian\ language"                   => 'wen',
    "south\ american\ indian\ language"   => 'sai',
    "south\ ndebele"                      => 'nr',
    "southern\ altai"                     => 'alt',
    "southern\ sami"                      => 'sma',
    'spinnis'                             => 'es',
    "sranan\ tongo"                       => 'srn',
    "stais\ dheisceartach"                => 'st',
    'sualainnis'                          => 'sv',
    'sukuma'                              => 'suk',
    'sumerian'                            => 'sux',
    'sundais'                             => 'su',
    'susu'                                => 'sus',
    'suvaisis'                            => 'cv',
    'svahalis'                            => 'sw',
    'swati'                               => 'ss',
    "swiss\ french"                       => 'fr_ch',
    "swiss\ german"                       => 'gsw',
    "swiss\ high\ german"                 => 'de_ch',
    'syriac'                              => 'syr',
    'taglaigis'                           => 'tl',
    "tai\ language"                       => 'tai',
    'taihtis'                             => 'ty',
    'tajik'                               => 'tg',
    'talainnis'                           => 'th',
    'tamailis'                            => 'ta',
    'tamashek'                            => 'tmh',
    'taroko'                              => 'trv',
    'tatarais'                            => 'tt',
    "teanga\ anaithnid\ n\ neamhbhail"    => 'und',
    'teileagis'                           => 'te',
    'tereno'                              => 'ter',
    'tetum'                               => 'tet',
    'tibadais'                            => 'bo',
    'tigre'                               => 'tig',
    'tigrinis'                            => 'ti',
    'timne'                               => 'tem',
    'tiv'                                 => 'tiv',
    'tlingit'                             => 'tli',
    "tok\ pisin"                          => 'tpi',
    'tokelau'                             => 'tkl',
    'tonga'                               => 'to',
    'tsimshian'                           => 'tsi',
    'tsonga'                              => 'ts',
    'tswana'                              => 'tn',
    'tuircis'                             => 'tr',
    'tuircminis'                          => 'tk',
    'tumbuka'                             => 'tum',
    "tupi\ language"                      => 'tup',
    'tuvalu'                              => 'tvl',
    'tuvinian'                            => 'tyv',
    'tvs'                                 => 'tw',
    'tyap'                                => 'kcg',
    'udmurt'                              => 'udm',
    'ug'                                  => 'ug',
    'ugaritic'                            => 'uga',
    'umbundu'                             => 'umb',
    'ungiris'                             => 'hu',
    "upper\ sorbian"                      => 'hsb',
    'urdais'                              => 'ur',
    "us\ english"                         => 'en_us',
    'vai'                                 => 'vai',
    'vallnais'                            => 'wa',
    'venda'                               => 've',
    'volapk'                              => 'vo',
    'votic'                               => 'vot',
    'vtneamais'                           => 'vi',
    "wakashan\ language"                  => 'wak',
    'walamo'                              => 'wal',
    'waray'                               => 'war',
    'washo'                               => 'was',
    'wolof'                               => 'wo',
    'yakut'                               => 'sah',
    'yao'                                 => 'yao',
    'yapese'                              => 'yap',
    'yoruba'                              => 'yo',
    "yupik\ language"                     => 'ypk',
    'zande'                               => 'znd',
    'zapotec'                             => 'zap',
    'zaza'                                => 'zza',
    'zenaga'                              => 'zen',
    'zhuang'                              => 'za',
    'zuni'                                => 'zun',
);

1;
