package Locales::DB::Language::da;

# Auto generated from CLDR

$Locales::DB::Language::da::VERSION = '0.01';

$Locales::DB::Language::da::cldr_version = '1.7.1';

%Locales::DB::Language::da::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Sprog\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0 \%",
        'territory' => "Område\:\ \{0\}"
    },
    'fallback'    => [ "nb\ nn\ sv\ en", "en\ nb\ nn\ sv", "en\ nb\ sv\ nn" ],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "nej\:n",
        'yesstr' => "ja\:j"
    },
);

%Locales::DB::Language::da::code_to_name = (
    'aa'    => 'afar',
    'ab'    => 'abkhasisk',
    'ace'   => 'acehnesisk',
    'ach'   => 'acoli',
    'ada'   => 'adangme',
    'ady'   => 'adyghe',
    'ae'    => 'avestan',
    'af'    => 'afrikaans',
    'afa'   => "afro\-asiatisk\ sprog",
    'afh'   => 'afrihili',
    'ain'   => "ainu\ \(Japan\)",
    'ak'    => 'akan',
    'akk'   => 'akkadisk',
    'ale'   => 'aleutisk',
    'alg'   => "algonkisk\ sprog",
    'alt'   => 'sydaltaisk',
    'am'    => 'amharisk',
    'an'    => 'aragonesisk',
    'ang'   => 'oldengelsk',
    'anp'   => 'angika',
    'apa'   => 'apachesprog',
    'ar'    => 'arabisk',
    'arc'   => "klassisk\ aramæisk",
    'arn'   => 'araukansk',
    'arp'   => 'arapaho',
    'art'   => 'kunstsprog',
    'arw'   => 'arawakisk',
    'as'    => 'assamesisk',
    'ast'   => 'asturisk',
    'ath'   => "athapaskisk\ sprog",
    'aus'   => "australsk\ sprog",
    'av'    => 'avarisk',
    'awa'   => 'awadhi',
    'ay'    => 'aymara',
    'az'    => 'aserbajdsjansk',
    'ba'    => 'bashkirisk',
    'bad'   => 'bandasprog',
    'bai'   => 'bamilekésprog',
    'bal'   => 'baluchisk',
    'ban'   => 'balinesisk',
    'bas'   => "basa\ \(Kamerun\)",
    'bat'   => "baltisk\ sprog",
    'be'    => 'hviderussisk',
    'bej'   => 'beja',
    'bem'   => "bemba\ \(Zambia\)",
    'ber'   => 'berbersprog',
    'bg'    => 'bulgarsk',
    'bh'    => "biharisk\ sprog",
    'bho'   => 'bhojpuri',
    'bi'    => 'bislama',
    'bik'   => 'bicolano',
    'bin'   => 'bini',
    'bla'   => 'siksika',
    'bm'    => 'bambara',
    'bn'    => 'bengalsk',
    'bnt'   => 'bantu',
    'bo'    => 'tibetansk',
    'br'    => 'bretonsk',
    'bra'   => 'braj',
    'bs'    => 'bosnisk',
    'btk'   => 'bataksprog',
    'bua'   => 'buriatisk',
    'bug'   => 'buginesisk',
    'byn'   => 'blin',
    'ca'    => 'katalansk',
    'cad'   => 'caddo',
    'cai'   => "mellemamerikansk\ indiansk\ sprog",
    'car'   => 'galibisk',
    'cau'   => "kaukasisk\ sprog",
    'cch'   => 'atsam',
    'ce'    => 'tjetjensk',
    'ceb'   => 'cebuano',
    'cel'   => "keltisk\ sprog",
    'ch'    => 'chamorro',
    'chb'   => 'chibcha',
    'chg'   => 'chagatai',
    'chk'   => 'chuukese',
    'chm'   => "marisk\ \(Rusland\)",
    'chn'   => "chinook\ pidginengelsk",
    'cho'   => 'choctaw',
    'chp'   => 'chipewyan',
    'chr'   => 'cherokee',
    'chy'   => 'cheyenne',
    'cmc'   => "chamisk\ sprog",
    'co'    => 'korsikansk',
    'cop'   => 'koptisk',
    'cpe'   => "engelsk\ baseret\ kreolsk\ eller\ pidginsprog",
    'cpf'   => "fransk\ baseret\ kreolsk\ eller\ pidgin",
    'cpp'   => "portugisisk\ baseret\ kreolsk\ eller\ pidginsprog",
    'cr'    => 'cree',
    'crh'   => "krim\ tyrkisk",
    'crp'   => "kreolsk\ eller\ pidginsprog",
    'cs'    => 'tjekkisk',
    'csb'   => 'kasjubisk',
    'cu'    => 'kirkeslavisk',
    'cus'   => "kusjitisk\ sprog",
    'cv'    => 'chuvash',
    'cy'    => 'walisisk',
    'da'    => 'dansk',
    'dak'   => 'dakota',
    'dar'   => 'dargwa',
    'day'   => 'bidayuhsprog',
    'de'    => 'tysk',
    'de_at' => "østrigsk\ tysk",
    'de_ch' => 'schweizerhøjtysk',
    'del'   => 'delaware',
    'den'   => 'slavej',
    'dgr'   => 'dogrib',
    'din'   => 'dinka',
    'doi'   => "dogri\-kangri",
    'dra'   => "dravidisk\ sprog",
    'dsb'   => 'nedersorbisk',
    'dua'   => 'duala',
    'dum'   => 'middelhollandsk',
    'dv'    => 'divehi',
    'dyu'   => 'dyula',
    'dz'    => 'dzongkha',
    'ee'    => 'ewe',
    'efi'   => 'efik',
    'egy'   => 'oldegyptisk',
    'eka'   => 'ekajuk',
    'el'    => 'græsk',
    'elx'   => 'elamitisk',
    'en'    => 'engelsk',
    'en_au' => "australsk\ engelsk",
    'en_ca' => "canadisk\ engelsk",
    'en_gb' => "britisk\ engelsk",
    'en_us' => "amerikansk\ engelsk",
    'enm'   => 'middelengelsk',
    'eo'    => 'esperanto',
    'es'    => 'spansk',
    'es_es' => "castiliansk\ spansk",
    'et'    => 'estisk',
    'eu'    => 'baskisk',
    'ewo'   => 'ewondo',
    'fa'    => 'persisk',
    'fan'   => "fang\ \(Ekvatorialguinea\)",
    'fat'   => 'fanti',
    'ff'    => 'fulah',
    'fi'    => 'finsk',
    'fil'   => 'filippinsk',
    'fiu'   => "finsk\-ugrisk\ sprog",
    'fj'    => 'fijiansk',
    'fo'    => 'færøsk',
    'fon'   => 'fon',
    'fr'    => 'fransk',
    'fr_ca' => "canadisk\ fransk",
    'fr_ch' => "schweizisk\ fransk",
    'frm'   => 'middelfransk',
    'fro'   => 'oldfransk',
    'frr'   => 'nordfrisisk',
    'frs'   => 'østfrisisk',
    'fur'   => 'friulian',
    'fy'    => 'frisisk',
    'ga'    => 'irsk',
    'gaa'   => 'ga',
    'gay'   => 'gayo',
    'gba'   => 'gbaya',
    'gd'    => "skotsk\ gælisk",
    'gem'   => "germansk\ sprog",
    'gez'   => 'geez',
    'gil'   => 'gilbertesisk',
    'gl'    => 'galicisk',
    'gmh'   => 'middelhøjtysk',
    'gn'    => 'guarani',
    'goh'   => 'oldhøjtysk',
    'gon'   => 'gondi',
    'gor'   => 'gorontalo',
    'got'   => 'gotisk',
    'grb'   => 'grebo',
    'grc'   => 'oldgræsk',
    'gsw'   => 'schweizertysk',
    'gu'    => 'gujarati',
    'gv'    => 'manx',
    'gwi'   => 'gwichin',
    'ha'    => 'hausa',
    'hai'   => 'haida',
    'haw'   => 'hawaiiansk',
    'he'    => 'hebraisk',
    'hi'    => 'hindi',
    'hil'   => 'hiligaynon',
    'him'   => 'himachalisprog',
    'hit'   => 'hittitisk',
    'hmn'   => 'hmong',
    'ho'    => 'hirimotu',
    'hr'    => 'kroatisk',
    'hsb'   => 'øvresorbisk',
    'ht'    => 'haitisk',
    'hu'    => 'ungarsk',
    'hup'   => 'hupa',
    'hy'    => 'armensk',
    'hz'    => 'herero',
    'ia'    => 'interlingua',
    'iba'   => 'iban',
    'id'    => 'indonesisk',
    'ie'    => 'interlingue',
    'ig'    => 'igbo',
    'ii'    => "sichuan\ yi",
    'ijo'   => 'ijosprog',
    'ik'    => 'inupiak',
    'ilo'   => 'iloko',
    'inc'   => "indisk\ sprog",
    'ine'   => "indo\-europæisk\ sprog",
    'inh'   => 'ingush',
    'io'    => 'ido',
    'ira'   => "iransk\ sprog",
    'iro'   => "irokesisk\ sprog",
    'is'    => 'islandsk',
    'it'    => 'italiensk',
    'iu'    => 'inuktitut',
    'ja'    => 'japansk',
    'jbo'   => 'lojban',
    'jpr'   => "jødisk\-persisk",
    'jrb'   => "jødisk\-arabisk",
    'jv'    => 'javanesisk',
    'ka'    => 'georgisk',
    'kaa'   => 'karakalpakisk',
    'kab'   => 'kabyle',
    'kac'   => 'kachin',
    'kaj'   => 'jju',
    'kam'   => "kamba\ \(Kenya\)",
    'kar'   => "karensk\ sprog",
    'kaw'   => 'kawi',
    'kbd'   => 'kabardian',
    'kcg'   => 'tyap',
    'kfo'   => 'koro',
    'kg'    => 'kongo',
    'kha'   => 'khasi',
    'khi'   => 'khoisansprog',
    'kho'   => 'khotanesisk',
    'ki'    => 'kikuyu',
    'kj'    => 'kuanyama',
    'kk'    => 'kasakhisk',
    'kl'    => 'grønlandsk',
    'km'    => 'khmer',
    'kmb'   => 'kimbundu',
    'kn'    => 'kannaresisk',
    'ko'    => 'koreansk',
    'kok'   => 'konkani',
    'kos'   => 'kosraeansk',
    'kpe'   => 'kpèllé',
    'kr'    => 'kanuri',
    'krc'   => "karatjai\-balkar",
    'krl'   => 'karelsk',
    'kro'   => 'krusprog',
    'kru'   => 'kurukh',
    'ks'    => 'kashmiri',
    'ku'    => 'kurdisk',
    'kum'   => 'kymyk',
    'kut'   => 'kutenaj',
    'kv'    => 'komi',
    'kw'    => 'cornisk',
    'ky'    => 'kirgisisk',
    'la'    => 'latin',
    'lad'   => 'ladino',
    'lah'   => 'lahnda',
    'lam'   => 'lamba',
    'lb'    => 'luxembourgsk',
    'lez'   => 'lezghian',
    'lg'    => 'ganda',
    'li'    => 'limburgsk',
    'ln'    => 'lingala',
    'lo'    => 'laotisk',
    'lol'   => 'mongo',
    'loz'   => 'lozi',
    'lt'    => 'litauisk',
    'lu'    => "luba\-Katanga",
    'lua'   => "luba\-Lulua",
    'lui'   => 'luiseño',
    'lun'   => 'lunda',
    'luo'   => 'luo',
    'lus'   => 'lushai',
    'lv'    => 'lettisk',
    'mad'   => 'maduresisk',
    'mag'   => 'magahi',
    'mai'   => 'maithili',
    'mak'   => 'makasar',
    'man'   => 'mandingo',
    'map'   => "austronesisk\ sprog",
    'mas'   => 'masai',
    'mdf'   => 'moksha',
    'mdr'   => 'mandar',
    'men'   => 'mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'malagasisk',
    'mga'   => 'middelirsk',
    'mh'    => 'marshallese',
    'mi'    => 'maorisk',
    'mic'   => 'micmac',
    'min'   => 'minangkabau',
    'mis'   => "\(annet\ sprog\)",
    'mk'    => 'makedonsk',
    'mkh'   => "mon\-khmer\ sprog",
    'ml'    => 'malayalam',
    'mn'    => 'mongolsk',
    'mnc'   => 'manchu',
    'mni'   => 'manipuri',
    'mno'   => "manobo\ sprog",
    'mo'    => 'moldovisk',
    'moh'   => 'mohawk',
    'mos'   => 'mossi',
    'mr'    => 'marathisk',
    'ms'    => 'malajisk',
    'mt'    => 'maltesisk',
    'mul'   => "\(flere\ sprog\)",
    'mun'   => 'mundasprog',
    'mus'   => 'creek',
    'mwl'   => 'mirandesisk',
    'mwr'   => 'marwari',
    'my'    => 'burmesisk',
    'myn'   => 'mayasprog',
    'myv'   => 'erzya',
    'na'    => 'nauru',
    'nah'   => "aztekisk\ sprog",
    'nai'   => "nordamerikansk\ indiansk\ sprog",
    'nap'   => 'neapolitansk',
    'nb'    => "norsk\ bokmål",
    'nd'    => 'nordndebele',
    'nds'   => 'nedertysk',
    'ne'    => 'nepalesisk',
    'new'   => 'newarisk',
    'ng'    => 'ndonga',
    'nia'   => 'nias',
    'nic'   => "Niger\-Congo\ sprog",
    'niu'   => 'niueansk',
    'nl'    => 'hollandsk',
    'nl_be' => 'flamsk',
    'nn'    => 'nynorsk',
    'no'    => 'norsk',
    'nog'   => 'nogai',
    'non'   => 'oldislandsk',
    'nqo'   => "n\-ko",
    'nr'    => 'sydndebele',
    'nso'   => 'nordsotho',
    'nub'   => "nubisk\ sprog",
    'nv'    => 'navajo',
    'nwc'   => "klassisk\ newarisk",
    'ny'    => 'nyanja',
    'nym'   => 'nyamwezi',
    'nyn'   => 'nyankole',
    'nyo'   => "nyoro\ sprog",
    'nzi'   => 'nzima',
    'oc'    => 'occitansk',
    'oj'    => 'ojibwa',
    'om'    => 'oromo',
    'or'    => 'oriya',
    'os'    => 'ossetisk',
    'osa'   => 'osage',
    'ota'   => "osmannisk\-tyrkisk",
    'oto'   => 'otomisprog',
    'pa'    => 'punjabi',
    'paa'   => "papua\-australsk\ sprog",
    'pag'   => 'pangasinan',
    'pal'   => 'middelpersisk',
    'pam'   => 'pampanga',
    'pap'   => 'papiamento',
    'pau'   => 'palauansk',
    'peo'   => 'oldpersisk',
    'phi'   => "filippinsk\ sprog",
    'phn'   => 'fønikisk',
    'pi'    => 'pali',
    'pl'    => 'polsk',
    'pon'   => 'ponape',
    'pra'   => 'prakritsprog',
    'pro'   => 'oldprovencalsk',
    'ps'    => 'afgansk',
    'pt'    => 'portugisisk',
    'pt_br' => "brasiliansk\ portugisisk",
    'pt_pt' => "iberisk\ portugisisk",
    'qu'    => 'quechua',
    'raj'   => 'rajasthanisk',
    'rap'   => 'rapanuisk',
    'rar'   => 'rarotongansk',
    'rm'    => 'rætoromansk',
    'rn'    => 'rundisk',
    'ro'    => 'rumænsk',
    'roa'   => "romansk\ sprog",
    'rom'   => 'romani',
    'ru'    => 'russisk',
    'rup'   => 'arumænsk',
    'rw'    => 'kinyarwanda',
    'sa'    => 'sanskrit',
    'sad'   => 'sandawe',
    'sah'   => 'yakut',
    'sai'   => "sydamerikansk\ indiansk\ sprog",
    'sal'   => "salikisk\ sprog",
    'sam'   => "samaritansk\ aramæisk",
    'sas'   => 'sasak',
    'sat'   => 'santalisk',
    'sc'    => 'sardisk',
    'scn'   => 'siciliansk',
    'sco'   => 'skotsk',
    'sd'    => 'sindhi',
    'se'    => 'nordsamisk',
    'sel'   => 'selkupisk',
    'sem'   => "semitisk\ sprog",
    'sg'    => 'sango',
    'sga'   => 'oldirsk',
    'sgn'   => 'tegnsprog',
    'sh'    => 'serbokroatisk',
    'shn'   => 'shan',
    'si'    => 'singalesisk',
    'sid'   => 'sidamo',
    'sio'   => "sioux\ sprog",
    'sit'   => "sino\-tibetansk\ sprog",
    'sk'    => 'slovakisk',
    'sl'    => 'slovensk',
    'sla'   => "slavisk\ sprog",
    'sm'    => 'samoansk',
    'sma'   => 'sydsamisk',
    'smi'   => "samisk\ sprog",
    'smj'   => "lule\ sami",
    'smn'   => "inari\ sami",
    'sms'   => "skolt\ sami",
    'sn'    => 'shona',
    'snk'   => 'soninke',
    'so'    => 'somalisk',
    'sog'   => 'sogdisk',
    'son'   => 'songhaisprog',
    'sq'    => 'albansk',
    'sr'    => 'serbisk',
    'srn'   => "sranan\ tongo",
    'srr'   => 'serer',
    'ss'    => 'swati',
    'ssa'   => "nilo\-saharansk\ sprog",
    'st'    => 'sydsotho',
    'su'    => 'sundanesisk',
    'suk'   => 'sukuma',
    'sus'   => 'susu',
    'sux'   => 'sumerisk',
    'sv'    => 'svensk',
    'sw'    => 'swahili',
    'syc'   => "klassisk\ syrisk",
    'syr'   => 'syrisk',
    'ta'    => 'tamilsk',
    'tai'   => 'thaisprog',
    'te'    => 'telugu',
    'tem'   => 'temne',
    'ter'   => 'tereno',
    'tet'   => 'tetum',
    'tg'    => 'tajik',
    'th'    => 'thailandsk',
    'ti'    => 'tigrinya',
    'tig'   => 'tigré',
    'tiv'   => 'tivi',
    'tk'    => 'turkmensk',
    'tkl'   => 'tokelau',
    'tl'    => 'tagalog',
    'tlh'   => 'klingonsk',
    'tli'   => 'tlingit',
    'tmh'   => 'tamashek',
    'tn'    => 'tswana',
    'to'    => "tongansk\ \(Tongaøerne\)",
    'tog'   => "tonganska\ \(Niassa\ i\ Moçambique\)",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'tyrkisk',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'tsimshisk',
    'tt'    => 'tatarisk',
    'tum'   => 'tumbukisk',
    'tup'   => 'tupisprog',
    'tut'   => "altaisk\ sprog",
    'tvl'   => 'tuvaluansk',
    'tw'    => 'twi',
    'ty'    => 'tahitiansk',
    'tyv'   => 'tuvinsk',
    'udm'   => 'udmurt',
    'ug'    => 'uigurisk',
    'uga'   => 'ugaristisk',
    'uk'    => 'ukrainsk',
    'umb'   => 'umbundu',
    'und'   => "\(ukendt\ sprog\)",
    'ur'    => 'urdu',
    'uz'    => 'usbekisk',
    'vai'   => 'vaj',
    've'    => 'venda',
    'vi'    => 'vietnamesisk',
    'vo'    => 'volapyk',
    'vot'   => 'votisk',
    'wa'    => 'vallonsk',
    'wak'   => "wakashansk\ sprog",
    'wal'   => 'walamo',
    'war'   => "waray\ \(Filippinerne\)",
    'was'   => 'washo',
    'wen'   => "vendisk\ sprog",
    'wo'    => 'wolof',
    'xal'   => 'kalmyk',
    'xh'    => 'xhosa',
    'yao'   => 'yao',
    'yap'   => 'yapisk',
    'yi'    => 'jiddisch',
    'yo'    => 'yoruba',
    'ypk'   => "yupisk\ sprog",
    'za'    => 'zhuang',
    'zap'   => 'zapotec',
    'zbl'   => "bliss\-symboler",
    'zen'   => 'zenaga',
    'zh'    => 'kinesisk',
    'znd'   => 'zandésprog',
    'zu'    => 'zulu',
    'zun'   => 'zuni',
    'zxx'   => "\(intet\ sprogligt\ indhold\)",
    'zza'   => 'zazaisk',
);

%Locales::DB::Language::da::name_to_code = (
    'abkhasisk'                                         => 'ab',
    'acehnesisk'                                        => 'ace',
    'acoli'                                             => 'ach',
    'adangme'                                           => 'ada',
    'adyghe'                                            => 'ady',
    'afar'                                              => 'aa',
    'afgansk'                                           => 'ps',
    'afrihili'                                          => 'afh',
    'afrikaans'                                         => 'af',
    "afroasiatisk\ sprog"                               => 'afa',
    "ainu\ japan"                                       => 'ain',
    'akan'                                              => 'ak',
    'akkadisk'                                          => 'akk',
    'albansk'                                           => 'sq',
    'aleutisk'                                          => 'ale',
    "algonkisk\ sprog"                                  => 'alg',
    "altaisk\ sprog"                                    => 'tut',
    "amerikansk\ engelsk"                               => 'en_us',
    'amharisk'                                          => 'am',
    'angika'                                            => 'anp',
    "annet\ sprog"                                      => 'mis',
    'apachesprog'                                       => 'apa',
    'arabisk'                                           => 'ar',
    'aragonesisk'                                       => 'an',
    'arapaho'                                           => 'arp',
    'araukansk'                                         => 'arn',
    'arawakisk'                                         => 'arw',
    'armensk'                                           => 'hy',
    'arumnsk'                                           => 'rup',
    'aserbajdsjansk'                                    => 'az',
    'assamesisk'                                        => 'as',
    'asturisk'                                          => 'ast',
    "athapaskisk\ sprog"                                => 'ath',
    'atsam'                                             => 'cch',
    "australsk\ engelsk"                                => 'en_au',
    "australsk\ sprog"                                  => 'aus',
    "austronesisk\ sprog"                               => 'map',
    'avarisk'                                           => 'av',
    'avestan'                                           => 'ae',
    'awadhi'                                            => 'awa',
    'aymara'                                            => 'ay',
    "aztekisk\ sprog"                                   => 'nah',
    'balinesisk'                                        => 'ban',
    "baltisk\ sprog"                                    => 'bat',
    'baluchisk'                                         => 'bal',
    'bambara'                                           => 'bm',
    'bamileksprog'                                      => 'bai',
    'bandasprog'                                        => 'bad',
    'bantu'                                             => 'bnt',
    "basa\ kamerun"                                     => 'bas',
    'bashkirisk'                                        => 'ba',
    'baskisk'                                           => 'eu',
    'bataksprog'                                        => 'btk',
    'beja'                                              => 'bej',
    "bemba\ zambia"                                     => 'bem',
    'bengalsk'                                          => 'bn',
    'berbersprog'                                       => 'ber',
    'bhojpuri'                                          => 'bho',
    'bicolano'                                          => 'bik',
    'bidayuhsprog'                                      => 'day',
    "biharisk\ sprog"                                   => 'bh',
    'bini'                                              => 'bin',
    'bislama'                                           => 'bi',
    'blin'                                              => 'byn',
    'blisssymboler'                                     => 'zbl',
    'bosnisk'                                           => 'bs',
    'braj'                                              => 'bra',
    "brasiliansk\ portugisisk"                          => 'pt_br',
    'bretonsk'                                          => 'br',
    "britisk\ engelsk"                                  => 'en_gb',
    'buginesisk'                                        => 'bug',
    'bulgarsk'                                          => 'bg',
    'buriatisk'                                         => 'bua',
    'burmesisk'                                         => 'my',
    'caddo'                                             => 'cad',
    "canadisk\ engelsk"                                 => 'en_ca',
    "canadisk\ fransk"                                  => 'fr_ca',
    "castiliansk\ spansk"                               => 'es_es',
    'cebuano'                                           => 'ceb',
    'chagatai'                                          => 'chg',
    "chamisk\ sprog"                                    => 'cmc',
    'chamorro'                                          => 'ch',
    'cherokee'                                          => 'chr',
    'cheyenne'                                          => 'chy',
    'chibcha'                                           => 'chb',
    "chinook\ pidginengelsk"                            => 'chn',
    'chipewyan'                                         => 'chp',
    'choctaw'                                           => 'cho',
    'chuukese'                                          => 'chk',
    'chuvash'                                           => 'cv',
    'cornisk'                                           => 'kw',
    'cree'                                              => 'cr',
    'creek'                                             => 'mus',
    'dakota'                                            => 'dak',
    'dansk'                                             => 'da',
    'dargwa'                                            => 'dar',
    'delaware'                                          => 'del',
    'dinka'                                             => 'din',
    'divehi'                                            => 'dv',
    'dogrib'                                            => 'dgr',
    'dogrikangri'                                       => 'doi',
    "dravidisk\ sprog"                                  => 'dra',
    'duala'                                             => 'dua',
    'dyula'                                             => 'dyu',
    'dzongkha'                                          => 'dz',
    'efik'                                              => 'efi',
    'ekajuk'                                            => 'eka',
    'elamitisk'                                         => 'elx',
    'engelsk'                                           => 'en',
    "engelsk\ baseret\ kreolsk\ eller\ pidginsprog"     => 'cpe',
    'erzya'                                             => 'myv',
    'esperanto'                                         => 'eo',
    'estisk'                                            => 'et',
    'ewe'                                               => 'ee',
    'ewondo'                                            => 'ewo',
    "fang\ ekvatorialguinea"                            => 'fan',
    'fanti'                                             => 'fat',
    'fijiansk'                                          => 'fj',
    'filippinsk'                                        => 'fil',
    "filippinsk\ sprog"                                 => 'phi',
    'finsk'                                             => 'fi',
    "finskugrisk\ sprog"                                => 'fiu',
    'flamsk'                                            => 'nl_be',
    "flere\ sprog"                                      => 'mul',
    'fnikisk'                                           => 'phn',
    'fon'                                               => 'fon',
    'fransk'                                            => 'fr',
    "fransk\ baseret\ kreolsk\ eller\ pidgin"           => 'cpf',
    'frisisk'                                           => 'fy',
    'friulian'                                          => 'fur',
    'frsk'                                              => 'fo',
    'fulah'                                             => 'ff',
    'ga'                                                => 'gaa',
    'galibisk'                                          => 'car',
    'galicisk'                                          => 'gl',
    'ganda'                                             => 'lg',
    'gayo'                                              => 'gay',
    'gbaya'                                             => 'gba',
    'geez'                                              => 'gez',
    'georgisk'                                          => 'ka',
    "germansk\ sprog"                                   => 'gem',
    'gilbertesisk'                                      => 'gil',
    'gondi'                                             => 'gon',
    'gorontalo'                                         => 'gor',
    'gotisk'                                            => 'got',
    'grebo'                                             => 'grb',
    'grnlandsk'                                         => 'kl',
    'grsk'                                              => 'el',
    'guarani'                                           => 'gn',
    'gujarati'                                          => 'gu',
    'gwichin'                                           => 'gwi',
    'haida'                                             => 'hai',
    'haitisk'                                           => 'ht',
    'hausa'                                             => 'ha',
    'hawaiiansk'                                        => 'haw',
    'hebraisk'                                          => 'he',
    'herero'                                            => 'hz',
    'hiligaynon'                                        => 'hil',
    'himachalisprog'                                    => 'him',
    'hindi'                                             => 'hi',
    'hirimotu'                                          => 'ho',
    'hittitisk'                                         => 'hit',
    'hmong'                                             => 'hmn',
    'hollandsk'                                         => 'nl',
    'hupa'                                              => 'hup',
    'hviderussisk'                                      => 'be',
    'iban'                                              => 'iba',
    "iberisk\ portugisisk"                              => 'pt_pt',
    'ido'                                               => 'io',
    'igbo'                                              => 'ig',
    'ijosprog'                                          => 'ijo',
    'iloko'                                             => 'ilo',
    "inari\ sami"                                       => 'smn',
    "indisk\ sprog"                                     => 'inc',
    "indoeuropisk\ sprog"                               => 'ine',
    'indonesisk'                                        => 'id',
    'ingush'                                            => 'inh',
    'interlingua'                                       => 'ia',
    'interlingue'                                       => 'ie',
    "intet\ sprogligt\ indhold"                         => 'zxx',
    'inuktitut'                                         => 'iu',
    'inupiak'                                           => 'ik',
    "iransk\ sprog"                                     => 'ira',
    "irokesisk\ sprog"                                  => 'iro',
    'irsk'                                              => 'ga',
    'islandsk'                                          => 'is',
    'italiensk'                                         => 'it',
    'japansk'                                           => 'ja',
    'javanesisk'                                        => 'jv',
    'jdiskarabisk'                                      => 'jrb',
    'jdiskpersisk'                                      => 'jpr',
    'jiddisch'                                          => 'yi',
    'jju'                                               => 'kaj',
    'kabardian'                                         => 'kbd',
    'kabyle'                                            => 'kab',
    'kachin'                                            => 'kac',
    'kalmyk'                                            => 'xal',
    "kamba\ kenya"                                      => 'kam',
    'kannaresisk'                                       => 'kn',
    'kanuri'                                            => 'kr',
    'karakalpakisk'                                     => 'kaa',
    'karatjaibalkar'                                    => 'krc',
    'karelsk'                                           => 'krl',
    "karensk\ sprog"                                    => 'kar',
    'kasakhisk'                                         => 'kk',
    'kashmiri'                                          => 'ks',
    'kasjubisk'                                         => 'csb',
    'katalansk'                                         => 'ca',
    "kaukasisk\ sprog"                                  => 'cau',
    'kawi'                                              => 'kaw',
    "keltisk\ sprog"                                    => 'cel',
    'khasi'                                             => 'kha',
    'khmer'                                             => 'km',
    'khoisansprog'                                      => 'khi',
    'khotanesisk'                                       => 'kho',
    'kikuyu'                                            => 'ki',
    'kimbundu'                                          => 'kmb',
    'kinesisk'                                          => 'zh',
    'kinyarwanda'                                       => 'rw',
    'kirgisisk'                                         => 'ky',
    'kirkeslavisk'                                      => 'cu',
    "klassisk\ aramisk"                                 => 'arc',
    "klassisk\ newarisk"                                => 'nwc',
    "klassisk\ syrisk"                                  => 'syc',
    'klingonsk'                                         => 'tlh',
    'komi'                                              => 'kv',
    'kongo'                                             => 'kg',
    'konkani'                                           => 'kok',
    'koptisk'                                           => 'cop',
    'koreansk'                                          => 'ko',
    'koro'                                              => 'kfo',
    'korsikansk'                                        => 'co',
    'kosraeansk'                                        => 'kos',
    'kpll'                                              => 'kpe',
    "kreolsk\ eller\ pidginsprog"                       => 'crp',
    "krim\ tyrkisk"                                     => 'crh',
    'kroatisk'                                          => 'hr',
    'krusprog'                                          => 'kro',
    'kuanyama'                                          => 'kj',
    'kunstsprog'                                        => 'art',
    'kurdisk'                                           => 'ku',
    'kurukh'                                            => 'kru',
    "kusjitisk\ sprog"                                  => 'cus',
    'kutenaj'                                           => 'kut',
    'kymyk'                                             => 'kum',
    'ladino'                                            => 'lad',
    'lahnda'                                            => 'lah',
    'lamba'                                             => 'lam',
    'laotisk'                                           => 'lo',
    'latin'                                             => 'la',
    'lettisk'                                           => 'lv',
    'lezghian'                                          => 'lez',
    'limburgsk'                                         => 'li',
    'lingala'                                           => 'ln',
    'litauisk'                                          => 'lt',
    'lojban'                                            => 'jbo',
    'lozi'                                              => 'loz',
    'lubakatanga'                                       => 'lu',
    'lubalulua'                                         => 'lua',
    'luiseo'                                            => 'lui',
    "lule\ sami"                                        => 'smj',
    'lunda'                                             => 'lun',
    'luo'                                               => 'luo',
    'lushai'                                            => 'lus',
    'luxembourgsk'                                      => 'lb',
    'maduresisk'                                        => 'mad',
    'magahi'                                            => 'mag',
    'maithili'                                          => 'mai',
    'makasar'                                           => 'mak',
    'makedonsk'                                         => 'mk',
    'malagasisk'                                        => 'mg',
    'malajisk'                                          => 'ms',
    'malayalam'                                         => 'ml',
    'maltesisk'                                         => 'mt',
    'manchu'                                            => 'mnc',
    'mandar'                                            => 'mdr',
    'mandingo'                                          => 'man',
    'manipuri'                                          => 'mni',
    "manobo\ sprog"                                     => 'mno',
    'manx'                                              => 'gv',
    'maorisk'                                           => 'mi',
    'marathisk'                                         => 'mr',
    "marisk\ rusland"                                   => 'chm',
    'marshallese'                                       => 'mh',
    'marwari'                                           => 'mwr',
    'masai'                                             => 'mas',
    'mayasprog'                                         => 'myn',
    "mellemamerikansk\ indiansk\ sprog"                 => 'cai',
    'mende'                                             => 'men',
    'micmac'                                            => 'mic',
    'middelengelsk'                                     => 'enm',
    'middelfransk'                                      => 'frm',
    'middelhjtysk'                                      => 'gmh',
    'middelhollandsk'                                   => 'dum',
    'middelirsk'                                        => 'mga',
    'middelpersisk'                                     => 'pal',
    'minangkabau'                                       => 'min',
    'mirandesisk'                                       => 'mwl',
    'mohawk'                                            => 'moh',
    'moksha'                                            => 'mdf',
    'moldovisk'                                         => 'mo',
    'mongo'                                             => 'lol',
    'mongolsk'                                          => 'mn',
    "monkhmer\ sprog"                                   => 'mkh',
    'morisyen'                                          => 'mfe',
    'mossi'                                             => 'mos',
    'mundasprog'                                        => 'mun',
    'nauru'                                             => 'na',
    'navajo'                                            => 'nv',
    'ndonga'                                            => 'ng',
    'neapolitansk'                                      => 'nap',
    'nedersorbisk'                                      => 'dsb',
    'nedertysk'                                         => 'nds',
    'nepalesisk'                                        => 'ne',
    'newarisk'                                          => 'new',
    'nias'                                              => 'nia',
    "nigercongo\ sprog"                                 => 'nic',
    "nilosaharansk\ sprog"                              => 'ssa',
    'niueansk'                                          => 'niu',
    'nko'                                               => 'nqo',
    'nogai'                                             => 'nog',
    "nordamerikansk\ indiansk\ sprog"                   => 'nai',
    'nordfrisisk'                                       => 'frr',
    'nordndebele'                                       => 'nd',
    'nordsamisk'                                        => 'se',
    'nordsotho'                                         => 'nso',
    'norsk'                                             => 'no',
    "norsk\ bokml"                                      => 'nb',
    "nubisk\ sprog"                                     => 'nub',
    'nyamwezi'                                          => 'nym',
    'nyanja'                                            => 'ny',
    'nyankole'                                          => 'nyn',
    'nynorsk'                                           => 'nn',
    "nyoro\ sprog"                                      => 'nyo',
    'nzima'                                             => 'nzi',
    'occitansk'                                         => 'oc',
    'ojibwa'                                            => 'oj',
    'oldegyptisk'                                       => 'egy',
    'oldengelsk'                                        => 'ang',
    'oldfransk'                                         => 'fro',
    'oldgrsk'                                           => 'grc',
    'oldhjtysk'                                         => 'goh',
    'oldirsk'                                           => 'sga',
    'oldislandsk'                                       => 'non',
    'oldpersisk'                                        => 'peo',
    'oldprovencalsk'                                    => 'pro',
    'oriya'                                             => 'or',
    'oromo'                                             => 'om',
    'osage'                                             => 'osa',
    'osmannisktyrkisk'                                  => 'ota',
    'ossetisk'                                          => 'os',
    'otomisprog'                                        => 'oto',
    'palauansk'                                         => 'pau',
    'pali'                                              => 'pi',
    'pampanga'                                          => 'pam',
    'pangasinan'                                        => 'pag',
    'papiamento'                                        => 'pap',
    "papuaaustralsk\ sprog"                             => 'paa',
    'persisk'                                           => 'fa',
    'polsk'                                             => 'pl',
    'ponape'                                            => 'pon',
    'portugisisk'                                       => 'pt',
    "portugisisk\ baseret\ kreolsk\ eller\ pidginsprog" => 'cpp',
    'prakritsprog'                                      => 'pra',
    'punjabi'                                           => 'pa',
    'quechua'                                           => 'qu',
    'rajasthanisk'                                      => 'raj',
    'rapanuisk'                                         => 'rap',
    'rarotongansk'                                      => 'rar',
    'romani'                                            => 'rom',
    "romansk\ sprog"                                    => 'roa',
    'rtoromansk'                                        => 'rm',
    'rumnsk'                                            => 'ro',
    'rundisk'                                           => 'rn',
    'russisk'                                           => 'ru',
    "salikisk\ sprog"                                   => 'sal',
    "samaritansk\ aramisk"                              => 'sam',
    "samisk\ sprog"                                     => 'smi',
    'samoansk'                                          => 'sm',
    'sandawe'                                           => 'sad',
    'sango'                                             => 'sg',
    'sanskrit'                                          => 'sa',
    'santalisk'                                         => 'sat',
    'sardisk'                                           => 'sc',
    'sasak'                                             => 'sas',
    'schweizerhjtysk'                                   => 'de_ch',
    'schweizertysk'                                     => 'gsw',
    "schweizisk\ fransk"                                => 'fr_ch',
    'selkupisk'                                         => 'sel',
    "semitisk\ sprog"                                   => 'sem',
    'serbisk'                                           => 'sr',
    'serbokroatisk'                                     => 'sh',
    'serer'                                             => 'srr',
    'shan'                                              => 'shn',
    'shona'                                             => 'sn',
    "sichuan\ yi"                                       => 'ii',
    'siciliansk'                                        => 'scn',
    'sidamo'                                            => 'sid',
    'siksika'                                           => 'bla',
    'sindhi'                                            => 'sd',
    'singalesisk'                                       => 'si',
    "sinotibetansk\ sprog"                              => 'sit',
    "sioux\ sprog"                                      => 'sio',
    "skolt\ sami"                                       => 'sms',
    'skotsk'                                            => 'sco',
    "skotsk\ glisk"                                     => 'gd',
    'slavej'                                            => 'den',
    "slavisk\ sprog"                                    => 'sla',
    'slovakisk'                                         => 'sk',
    'slovensk'                                          => 'sl',
    'sogdisk'                                           => 'sog',
    'somalisk'                                          => 'so',
    'songhaisprog'                                      => 'son',
    'soninke'                                           => 'snk',
    'spansk'                                            => 'es',
    "sranan\ tongo"                                     => 'srn',
    'stfrisisk'                                         => 'frs',
    "strigsk\ tysk"                                     => 'de_at',
    'sukuma'                                            => 'suk',
    'sumerisk'                                          => 'sux',
    'sundanesisk'                                       => 'su',
    'susu'                                              => 'sus',
    'svensk'                                            => 'sv',
    'swahili'                                           => 'sw',
    'swati'                                             => 'ss',
    'sydaltaisk'                                        => 'alt',
    "sydamerikansk\ indiansk\ sprog"                    => 'sai',
    'sydndebele'                                        => 'nr',
    'sydsamisk'                                         => 'sma',
    'sydsotho'                                          => 'st',
    'syrisk'                                            => 'syr',
    'tagalog'                                           => 'tl',
    'tahitiansk'                                        => 'ty',
    'tajik'                                             => 'tg',
    'tamashek'                                          => 'tmh',
    'tamilsk'                                           => 'ta',
    'taroko'                                            => 'trv',
    'tatarisk'                                          => 'tt',
    'tegnsprog'                                         => 'sgn',
    'telugu'                                            => 'te',
    'temne'                                             => 'tem',
    'tereno'                                            => 'ter',
    'tetum'                                             => 'tet',
    'thailandsk'                                        => 'th',
    'thaisprog'                                         => 'tai',
    'tibetansk'                                         => 'bo',
    'tigr'                                              => 'tig',
    'tigrinya'                                          => 'ti',
    'tivi'                                              => 'tiv',
    'tjekkisk'                                          => 'cs',
    'tjetjensk'                                         => 'ce',
    'tlingit'                                           => 'tli',
    "tok\ pisin"                                        => 'tpi',
    'tokelau'                                           => 'tkl',
    "tongansk\ tongaerne"                               => 'to',
    "tonganska\ niassa\ i\ moambique"                   => 'tog',
    'tsimshisk'                                         => 'tsi',
    'tsonga'                                            => 'ts',
    'tswana'                                            => 'tn',
    'tumbukisk'                                         => 'tum',
    'tupisprog'                                         => 'tup',
    'turkmensk'                                         => 'tk',
    'tuvaluansk'                                        => 'tvl',
    'tuvinsk'                                           => 'tyv',
    'twi'                                               => 'tw',
    'tyap'                                              => 'kcg',
    'tyrkisk'                                           => 'tr',
    'tysk'                                              => 'de',
    'udmurt'                                            => 'udm',
    'ugaristisk'                                        => 'uga',
    'uigurisk'                                          => 'ug',
    "ukendt\ sprog"                                     => 'und',
    'ukrainsk'                                          => 'uk',
    'umbundu'                                           => 'umb',
    'ungarsk'                                           => 'hu',
    'urdu'                                              => 'ur',
    'usbekisk'                                          => 'uz',
    'vaj'                                               => 'vai',
    'vallonsk'                                          => 'wa',
    'venda'                                             => 've',
    "vendisk\ sprog"                                    => 'wen',
    'vietnamesisk'                                      => 'vi',
    'volapyk'                                           => 'vo',
    'votisk'                                            => 'vot',
    'vresorbisk'                                        => 'hsb',
    "wakashansk\ sprog"                                 => 'wak',
    'walamo'                                            => 'wal',
    'walisisk'                                          => 'cy',
    "waray\ filippinerne"                               => 'war',
    'washo'                                             => 'was',
    'wolof'                                             => 'wo',
    'xhosa'                                             => 'xh',
    'yakut'                                             => 'sah',
    'yao'                                               => 'yao',
    'yapisk'                                            => 'yap',
    'yoruba'                                            => 'yo',
    "yupisk\ sprog"                                     => 'ypk',
    'zandsprog'                                         => 'znd',
    'zapotec'                                           => 'zap',
    'zazaisk'                                           => 'zza',
    'zenaga'                                            => 'zen',
    'zhuang'                                            => 'za',
    'zulu'                                              => 'zu',
    'zuni'                                              => 'zun',
);

1;
