# ABSTRACT: Peer-to-Peer Publish/Subscribe Network of Objects
package Net::Object::Peer::Emitter;

use 5.10.0;

use Moo;
use strictures 2;
use namespace::clean;

our $VERSION = '0.04'; # TRIAL

with 'BeamX::Peer::Emitter';

around subscribe => sub {

    my $orig = shift;

    push @_, class => 'Net::Object::Peer::Listener';

    &$orig;
};

1;

#
# This file is part of Net-Object-Peer
#
# This software is Copyright (c) 2016 by Smithsonian Astrophysical Observatory.
#
# This is free software, licensed under:
#
#   The GNU General Public License, Version 3, June 2007
#

=pod

=head1 NAME

Net::Object::Peer::Emitter - Peer-to-Peer Publish/Subscribe Network of Objects

=head1 VERSION

version 0.04

=head1 DESCRIPTION

A B<Net::Object::Peer::Emitter> object is used by L<Net::Object::Peer>
to manage outgoing communications with other nodes. It is derived from
L<BeamX::Peer::Emitter>.

=head1 AUTHOR

Diab Jerius <djerius@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2016 by Smithsonian Astrophysical Observatory.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=cut

__END__

#pod =head1 DESCRIPTION
#pod
#pod A B<Net::Object::Peer::Emitter> object is used by L<Net::Object::Peer>
#pod to manage outgoing communications with other nodes. It is derived from
#pod L<BeamX::Peer::Emitter>.
#pod
