#! perl
use Test2::V0;

use CXC::Number::Grid;

subtest 'not' => sub {
    my $grid = CXC::Number::Grid->new(
        edges   => [ -1, 0, 1 ],
        include => [ 1,  0 ],
    );

    my $not_grid = !$grid;

    is( $grid->include,     [ 1, 0 ], 'original include' );
    is( $not_grid->include, [ 0, 1 ], '! include' );
};

subtest 'or' => sub {

    my @A_e = ( 0, 2, 4, 8, 12, 16 );
    my @A_i = ( 0, 1, 0, 1, 0 );

    my @B_e = ( 0, 3, 6, 9, 10, 11, 16 );
    my @B_i = ( 1, 0, 1, 0, 1,  0 );

    my $A = CXC::Number::Grid->new(
        edges   => \@A_e,
        include => \@A_i,
    );

    my $B = CXC::Number::Grid->new(
        edges   => \@B_e,
        include => \@B_i,
    );

    my $AB = $A | $B;

    is(
        $AB,
        object {
            call edges => [ 0, 3, 4, 6, 9, 10, 11, 12, 16 ];
            call include => [ 1, 1, 0, 1, 1, 1, 1, 0 ];
        },
        'raw'
    );

    is(
        $AB->combine_bins,
        object {
            call edges => [ 0, 4, 6, 12, 16 ];
            call include => [ 1, 0, 1, 0 ];
        },
        'combined'
    );

};

done_testing;
