package My::Variant::Form;

use v5.26;
use warnings;

use experimental 'signatures';

use Package::Variant
  importing => {
    'Types::Standard' => ['Str'],
    'Form::Tiny'      => [ 'plugins' => ['+CXC::Form::Tiny::Plugin::OptArgs2'] ],
  },
  subs => [ 'form_field', 'option', 'extends', 'optargs', 'Str' ];

sub make_variant ( $class, $, $, %arguments ) {

    extends $arguments{extends}
      if defined $arguments{extends};

    for my $field ( $arguments{fields}->@* ) {
        form_field $field => ( type => Str() );
        option( comment => uc $field );
    }
}

sub make_variant_package_name ( $class, $package, %arguments ) {
    return $package;
}


1;
