#!/usr/bin/perl

use Module::Build;

use strict;
use warnings;

my $build = Module::Build->new(
    module_name => 'MooseX::GlobRef::Object',
    dist_author => 'Piotr Roszatycki <dexter@debian.org>',
    license => 'perl',
    requires => {
        'perl'               => 5.006,
        'Moose'              => 0,
    },
    optional => {
    },
    build_requires => {
        'Test::Unit::Lite'   => 0.07,
    },
    create_makefile_pl => 'traditional',
    create_readme => 1,
    recursive_test_files => 1,
    add_to_cleanup => [
        'META.yml', '*.bak', '*.gz', 'Makefile.PL', 'Makefile', 'pm_to_blib', 'cover_db',
        'MooseX-GlobRef-Object-*',
    ],
);

$build->create_build_script;
