package Net::SSLLabs::Suite;

use strict;
use warnings;
use Net::SSLLabs::Suite();

sub new {
    my ( $class, $json ) = @_;
    my $self = $json;
    bless $self, $class;
    return $self;
}

sub cipher_strength {
    my ($self) = @_;
    return $self->{cipherStrength};
}

sub name {
    my ($self) = @_;
    return $self->{name};
}

sub ecdh_bits {
    my ($self) = @_;
    return $self->{ecdhBits};
}

sub ecdh_strength {
    my ($self) = @_;
    return $self->{ecdhStrength};
}

sub dh_strength {
    my ($self) = @_;
    return $self->{dhStrength};
}

sub dh_ys {
    my ($self) = @_;
    return $self->{dhYs};
}

sub dh_g {
    my ($self) = @_;
    return $self->{dhG};
}

sub dh_p {
    my ($self) = @_;
    return $self->{dhP};
}

sub id {
    my ($self) = @_;
    return $self->{id};
}

1;
__END__

=head1 NAME

Net::SSLLabs::Suite - Suite object

=head1 METHODS

=head2 new

a new C<Net::SSLLabs::Suite> object, accepts a JSON object as it's parameter.

=head2 id

suite RFC ID (e.g., 5)

=head2 name

suite name (e.g., TLS_RSA_WITH_RC4_128_SHA)

=head2 cipher_strength

suite strength (e.g., 128)

=head2 dh_strength

strength of DH params (e.g., 1024)

=head2 dh_p

DH params, p component

=head2 dh_g

DH params, g component

=head2 dh_ys

DH params, Ys component

=head2 ecdh_bits

ECDH bits

=head2 ecdh_strength

ECDH RSA-equivalent strength

=head2 q

0 if the suite is insecure, null otherwise

