# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JP;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230903131447;

my $formatters = [
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '00777[01]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            (?:
              12|
              57|
              99
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              267|
              3(?:
                7[247]|
                9[278]
              )|
              466|
              5(?:
                47|
                58|
                64
              )|
              6(?:
                3[245]|
                48|
                5[4-68]
              )
            )|
            499[2468]|
            5(?:
              769|
              979[2-69]
            )|
            7468|
            8(?:
              3(?:
                8[7-9]|
                96[2457-9]
              )|
              477|
              51[2-9]
            )|
            9(?:
              802|
              9(?:
                1[23]|
                69
              )
            )|
            1(?:
              45|
              58
            )[67]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d)(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '60',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [36]|
            4(?:
              2(?:
                0|
                9[02-69]
              )|
              7(?:
                0[019]|
                1
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              1|
              5(?:
                4[018]|
                5[017]
              )|
              77|
              88|
              9[69]
            )|
            2(?:
              2[127]|
              3[0-269]|
              4[59]|
              5(?:
                [1-3]|
                5[0-69]|
                9(?:
                  17|
                  99
                )
              )|
              6(?:
                2|
                4[016-9]
              )|
              7(?:
                [1-35]|
                8[0189]
              )|
              8(?:
                [16]|
                3[0134]|
                9[0-5]
              )|
              9(?:
                [028]|
                17
              )
            )|
            4(?:
              2(?:
                [13-79]|
                8[014-6]
              )|
              3[0-57]|
              [45]|
              6[248]|
              7[2-47]|
              9[29]
            )|
            5(?:
              2|
              3(?:
                [045]|
                9(?:
                  [0-58]|
                  6[4-9]|
                  7[0-35689]
                )
              )|
              4[0-369]|
              5[29]|
              8[02389]|
              9[0-3]
            )|
            7(?:
              2[02-46-9]|
              34|
              [58]|
              6[0249]|
              7[57]|
              9(?:
                [23]|
                4[0-59]|
                5[01569]|
                6[0167]
              )
            )|
            8(?:
              2(?:
                [1258]|
                4[0-39]|
                9[0169]
              )|
              3(?:
                [29]|
                60|
                7(?:
                  [017-9]|
                  6[6-8]
                )
              )|
              49|
              51|
              6(?:
                [0-24]|
                36[2-57-9]|
                5(?:
                  [0-389]|
                  5[23]
                )|
                6(?:
                  [01]|
                  9[178]
                )|
                7(?:
                  2[2-468]|
                  3[78]
                )|
                9[0145]
              )|
              7[0-468]|
              8[68]
            )|
            9(?:
              4[15]|
              5[138]|
              7[156]|
              8[189]|
              9(?:
                [1289]|
                3(?:
                  31|
                  4[357]
                )|
                4[0178]
              )
            )|
            (?:
              8294|
              96
            )[1-3]|
            2(?:
              57|
              93
            )[015-9]|
            (?:
              223|
              8699
            )[014-9]|
            (?:
              25[0468]|
              422|
              838
            )[01]|
            (?:
              48|
              8292|
              9[23]
            )[1-9]|
            (?:
              47[59]|
              59[89]|
              8(?:
                68|
                9
              )
            )[019]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [14]|
            [289][2-9]|
            5[3-9]|
            7[2-4679]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '0077',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '008',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '[257-9]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{4,5})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{5})(\\d{5,6})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{6})(\\d{6,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'geographic' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'mobile' => '[7-9]0[1-9]\\d{7}',
                'pager' => '20\\d{8}',
                'personal_number' => '60\\d{7}',
                'specialrate' => '(990\\d{6})|(570\\d{6})',
                'toll_free' => '
          00777(?:
            [01]|
            5\\d
          )\\d\\d|
          (?:
            00(?:
              7778|
              882[1245]
            )|
            (?:
              120|
              800\\d
            )\\d\\d
          )\\d{4}|
          00(?:
            37|
            66|
            78
          )\\d{6,13}
        ',
                'voip' => '50[1-9]\\d{7}'
              };
my %areanames = ();
$areanames{en} = {"817682", "Wajima\,\ Ishikawa",
"811645", "Rumoi\,\ Hokkaido",
"819578", "Shimabara\,\ Nagasaki",
"812856", "Mooka\,\ Tochigi",
"81559", "Numazu\,\ Shizuoka",
"812676", "Saku\,\ Nagano",
"817452", "Yamatotakada\,\ Nara",
"812554", "Joetsu\,\ Niigata",
"818662", "Takahashi\,\ Okayama",
"81233", "Shinjo\,\ Yamagata",
"812572", "Kashiwazaki\,\ Niigata",
"819575", "Isahaya\,\ Nagasaki",
"812373", "Murayama\,\ Yamagata",
"81942", "Kurume\,\ Fukuoka",
"81563", "Nishio\,\ Aichi",
"812913", "Hokota\,\ Ibaraki",
"81534", "Hamamatsu\,\ Shizuoka",
"815766", "Gero\,\ Gifu",
"81177", "Aomori\,\ Aomori",
"81925", "Fukuoka\,\ Fukuoka",
"811585", "Engaru\,\ Hokkaido",
"818360", "Ogori\,\ Yamaguchi",
"81182", "Yokote\,\ Akita",
"815958", "Kameyama\,\ Mie",
"818294", "Hatsukaichi\,\ Hiroshima",
"811541", "Teshikaga\,\ Hokkaido",
"811588", "Okoppe\,\ Hokkaido",
"818669", "Soja\,\ Okayama",
"818247", "Shobara\,\ Hiroshima",
"811947", "Kuji\,\ Iwate",
"818974", "Niihama\,\ Ehime",
"811733", "Goshogawara\,\ Aomori",
"818952", "Uwajima\,\ Ehime",
"819822", "Nobeoka\,\ Miyazaki",
"8168", "Osaka\,\ Osaka",
"81935", "Kitakyushu\,\ Fukuoka",
"812895", "Utsunomiya\,\ Tochigi",
"812787", "Numata\,\ Gunma",
"818544", "Kisuki\,\ Shimane",
"81848", "Onomichi\,\ Hiroshima",
"811553", "Obihiro\,\ Hokkaido",
"81425", "Tachikawa\,\ Tokyo",
"815983", "Matsusaka\,\ Mie",
"811352", "Yoichi\,\ Hokkaido",
"818479", "Tojo\,\ Hiroshima",
"817954", "Nishiwaki\,\ Hyogo",
"812930", "Mito\,\ Ibaraki",
"811374", "Mori\,\ Hokkaido",
"812898", "Kanuma\,\ Tochigi",
"818833", "Kamojima\,\ Tokushima",
"8153964", "Hamamatsu\,\ Shizuoka",
"814754", "Mobara\,\ Chiba",
"814772", "Ichikawa\,\ Chiba",
"8153965", "Hamamatsu\,\ Shizuoka",
"81552", "Kofu\,\ Yamanashi",
"819945", "Kanoya\,\ Kagoshima",
"81551", "Nirasaki\,\ Yamanashi",
"811235", "Yubari\,\ Hokkaido",
"818684", "Tsuyama\,\ Okayama",
"814284", "Tachikawa\,\ Tokyo",
"815744", "Minokamo\,\ Gifu",
"8147950", "Yokaichiba\,\ Chiba",
"81798", "Nishinomiya\,\ Hyogo",
"819948", "Shibushi\,\ Kagoshima",
"811238", "Kuriyama\,\ Hokkaido",
"81126", "Iwamizawa\,\ Hokkaido",
"81896", "Iyomishima\,\ Ehime",
"812993", "Ishioka\,\ Ibaraki",
"81949", "Nogata\,\ Fukuoka",
"81478", "Sawara\,\ Chiba",
"815996", "Ago\,\ Mie",
"818297", "Hatsukaichi\,\ Hiroshima",
"81250", "Niitsu\,\ Niigata",
"818244", "Miyoshi\,\ Hiroshima",
"811732", "Goshogawara\,\ Aomori",
"818977", "Hakata\,\ Ehime",
"811944", "Iwaizumi\,\ Iwate",
"818953", "Uwajima\,\ Ehime",
"819823", "Nobeoka\,\ Miyazaki",
"81568", "Kasugai\,\ Aichi",
"81545", "Fuji\,\ Shizuoka",
"8182943", "Hiroshima\,\ Hiroshima",
"819956", "Kajiki\,\ Kagoshima",
"8125480", "Murakami\,\ Niigata",
"818514", "Ama\,\ Shimane",
"819666", "Minamata\,\ Kumamoto",
"8198293", "Nobeoka\,\ Miyazaki",
"818678", "Niimi\,\ Okayama",
"812372", "Murayama\,\ Yamagata",
"81253", "Niigata\,\ Niigata",
"814998", "Ogasawara\,\ Tokyo",
"811535", "Akkeshi\,\ Hokkaido",
"818366", "Ube\,\ Yamaguchi",
"817683", "Wajima\,\ Ishikawa",
"818675", "Kuse\,\ Okayama",
"81554", "Otsuki\,\ Yamanashi",
"812565", "Sanjo\,\ Niigata",
"817453", "Yamatotakada\,\ Nara",
"818663", "Soja\,\ Okayama",
"812573", "Kashiwazaki\,\ Niigata",
"817718", "Sonobe\,\ Kyoto",
"811559", "Obihiro\,\ Hokkaido",
"817230", "Neyagawa\,\ Osaka",
"817488", "Minakuchi\,\ Shiga",
"81531", "Tahara\,\ Aichi",
"812992", "Ishioka\,\ Ibaraki",
"81944", "Setaka\,\ Fukuoka",
"81532", "Toyohashi\,\ Aichi",
"8199345", "Kagoshima\,\ Kagoshima",
"817725", "Miyazu\,\ Kyoto",
"817715", "Kameoka\,\ Kyoto",
"817485", "Yokaichi\,\ Shiga",
"814287", "Ome\,\ Tokyo",
"8153966", "Hamamatsu\,\ Shizuoka",
"818687", "Mimasaka\,\ Okayama",
"81262", "Nagano\,\ Nagano",
"812936", "Mito\,\ Ibaraki",
"815982", "Matsusaka\,\ Mie",
"818397", "Ogori\,\ Yamaguchi",
"811353", "Yoichi\,\ Hokkaido",
"818832", "Kamojima\,\ Tokushima",
"811377", "Yakumo\,\ Hokkaido",
"817965", "Toyooka\,\ Hyogo",
"814757", "Togane\,\ Chiba",
"8199331", "Kagoshima\,\ Kagoshima",
"812999", "Itako\,\ Ibaraki",
"818896", "Susaki\,\ Kochi",
"811656", "Bifuka\,\ Hokkaido",
"81586", "Ichinomiya\,\ Aichi",
"81473", "Ichikawa\,\ Chiba",
"811876", "Omagari\,\ Akita",
"812784", "Numata\,\ Gunma",
"81793", "Himeji\,\ Hyogo",
"812414", "Yanaizu\,\ Fukushima",
"818547", "Kakeya\,\ Shimane",
"817968", "Hamasaka\,\ Hyogo",
"811552", "Obihiro\,\ Hokkaido",
"81184", "Yurihonjo\,\ Akita",
"817616", "Komatsu\,\ Ishikawa",
"818594", "Yonago\,\ Tottori",
"818879", "Muroto\,\ Kochi",
"811945", "Kuji\,\ Iwate",
"815973", "Owase\,\ Mie",
"81294", "Hitachiota\,\ Ibaraki",
"818245", "Miyoshi\,\ Hiroshima",
"8164", "Osaka\,\ Osaka",
"814703", "Tateyama\,\ Chiba",
"81926", "Fukuoka\,\ Fukuoka",
"8186999", "Seto\,\ Okayama",
"81888", "Kochi\,\ Kochi",
"818248", "Shobara\,\ Hiroshima",
"812613", "Omachi\,\ Nagano",
"817903", "Fukusaki\,\ Hyogo",
"812232", "Iwanuma\,\ Miyagi",
"811587", "Nakayubetsu\,\ Hokkaido",
"81593", "Yokkaichi\,\ Mie",
"81436", "Ichihara\,\ Chiba",
"81797", "Nishinomiya\,\ Hyogo",
"811534", "Nakashibetsu\,\ Hokkaido",
"81482", "Kawaguchi\,\ Saitama",
"812239", "Sendai\,\ Miyagi",
"818490", "Onomichi\,\ Hiroshima",
"819553", "Imari\,\ Saga",
"819577", "Shimabara\,\ Nagasaki",
"81729", "Yao\,\ Osaka",
"81989", "Naha\,\ Okinawa",
"817946", "Miki\,\ Hyogo",
"818556", "Gotsu\,\ Shimane",
"8125489", "Tsugawa\,\ Niigata",
"812564", "Sanjo\,\ Niigata",
"8128798", "Otawara\,\ Tochigi",
"818872", "Muroto\,\ Kochi",
"811337", "Ishikari\,\ Hokkaido",
"818652", "Kurashiki\,\ Okayama",
"818674", "Kuse\,\ Okayama",
"811647", "Haboro\,\ Hokkaido",
"81489", "Soka\,\ Saitama",
"814291", "Hanno\,\ Saitama",
"812649", "Nagano\,\ Nagano",
"81977", "Beppu\,\ Oita",
"812383", "Yonezawa\,\ Yamagata",
"81125", "Takikawa\,\ Hokkaido",
"81722", "Sakai\,\ Osaka",
"8186697", "Kurashiki\,\ Okayama",
"81739", "Tanabe\,\ Wakayama",
"81721", "Tondabayashi\,\ Osaka",
"819746", "Taketa\,\ Oita",
"811754", "Mutsu\,\ Aomori",
"817484", "Yokaichi\,\ Shiga",
"817672", "Hakui\,\ Ishikawa",
"817714", "Kameoka\,\ Kyoto",
"812582", "Nagaoka\,\ Niigata",
"811237", "Kuriyama\,\ Hokkaido",
"819947", "Shibushi\,\ Kagoshima",
"819733", "Hita\,\ Oita",
"817724", "Miyazu\,\ Kyoto",
"819789", "Kitsuki\,\ Oita",
"818464", "Takehara\,\ Hiroshima",
"812589", "Nagaoka\,\ Niigata",
"811362", "Kutchan\,\ Hokkaido",
"817964", "Toyooka\,\ Hyogo",
"819782", "Bungotakada\,\ Oita",
"812788", "Maebashi\,\ Gunma",
"815393", "Hamamatsu\,\ Shizuoka",
"81936", "Kitakyushu\,\ Fukuoka",
"818595", "Yonago\,\ Tottori",
"812546", "Murakami\,\ Niigata",
"812415", "Yanaizu\,\ Fukushima",
"81178", "Hachinohe\,\ Aomori",
"812897", "Kanuma\,\ Tochigi",
"812785", "Numata\,\ Gunma",
"81142", "Date\,\ Hokkaido",
"8198297", "Hyuga\,\ Miyazaki",
"812693", "Nakano\,\ Nagano",
"811563", "Honbetsu\,\ Hokkaido",
"81426", "Hachioji\,\ Tokyo",
"812555", "Itoigawa\,\ Niigata",
"817463", "Yoshino\,\ Nara",
"8161", "Osaka\,\ Osaka",
"8188097", "Tosashimizu\,\ Kochi",
"818873", "Aki\,\ Kochi",
"815979", "Kumano\,\ Mie",
"817475", "Shimonoseki\,\ Yamaguchi",
"811644", "Rumoi\,\ Hokkaido",
"818677", "Niimi\,\ Okayama",
"814796", "Yokaichiba\,\ Chiba",
"811537", "Nakashibetsu\,\ Hokkaido",
"812619", "Omachi\,\ Nagano",
"817996", "Tsuna\,\ Hyogo",
"819552", "Imari\,\ Saga",
"814709", "Kamogawa\,\ Chiba",
"81984", "Kobayashi\,\ Miyazaki",
"819726", "Usuki\,\ Oita",
"819574", "Isahaya\,\ Nagasaki",
"814702", "Tateyama\,\ Chiba",
"81546", "Shizuoka\,\ Shizuoka",
"817940", "Kakogawa\,\ Hyogo",
"818978", "Hakata\,\ Ehime",
"819966", "Izumi\,\ Kagoshima",
"817902", "Fukusaki\,\ Hyogo",
"812612", "Omachi\,\ Nagano",
"818298", "Hatsukaichi\,\ Hiroshima",
"811584", "Engaru\,\ Hokkaido",
"81144", "Tomakomai\,\ Hokkaido",
"812233", "Iwanuma\,\ Miyagi",
"818975", "Niihama\,\ Ehime",
"815972", "Owase\,\ Mie",
"81227", "Sendai\,\ Miyagi",
"818295", "Hatsukaichi\,\ Hiroshima",
"812246", "Ogawara\,\ Miyagi",
"81585", "Ibigawa\,\ Gifu",
"818545", "Kisuki\,\ Shimane",
"81567", "Tsushima\,\ Aichi",
"814758", "Togane\,\ Chiba",
"812894", "Utsunomiya\,\ Tochigi",
"811378", "Imakane\,\ Hokkaido",
"811562", "Honbetsu\,\ Hokkaido",
"812389", "Yonezawa\,\ Yamagata",
"812692", "Nakano\,\ Nagano",
"818398", "Ogori\,\ Yamaguchi",
"8186998", "Seto\,\ Okayama",
"811363", "Kutchan\,\ Hokkaido",
"814755", "Togane\,\ Chiba",
"819783", "Bungotakada\,\ Oita",
"817955", "Sanda\,\ Hyogo",
"8198292", "Nobeoka\,\ Miyazaki",
"811375", "Yakumo\,\ Hokkaido",
"81292", "Mito\,\ Ibaraki",
"81956", "Sasebo\,\ Nagasaki",
"815392", "Hamamatsu\,\ Shizuoka",
"811757", "Noheji\,\ Aomori",
"81276", "Ota\,\ Gunma",
"818685", "Tsuyama\,\ Okayama",
"817487", "Minakuchi\,\ Shiga",
"814285", "Sagamihara\,\ Kanagawa",
"817673", "Hakui\,\ Ishikawa",
"815745", "Minokamo\,\ Gifu",
"812583", "Nagaoka\,\ Niigata",
"811234", "Chitose\,\ Hokkaido",
"817717", "Sonobe\,\ Kyoto",
"819732", "Hita\,\ Oita",
"819944", "Kanoya\,\ Kagoshima",
"8125488", "Tsugawa\,\ Niigata",
"815586", "Shimoda\,\ Shizuoka",
"8182942", "Hiroshima\,\ Hiroshima",
"818467", "Mima\,\ Tokushima",
"811956", "Iwate\,\ Iwate",
"812382", "Yonezawa\,\ Yamagata",
"818688", "Mimasaka\,\ Okayama",
"814288", "Ome\,\ Tokyo",
"81484", "Kawaguchi\,\ Saitama",
"8125481", "Murakami\,\ Niigata",
"81734", "Wakayama\,\ Wakayama",
"81763", "Fukuno\,\ Toyama",
"811453", "Hayakita\,\ Hokkaido",
"8198291", "Nobeoka\,\ Miyazaki",
"8186992", "Bizen\,\ Okayama",
"815754", "Sekigahara\,\ Gifu",
"819967", "Izumi\,\ Kagoshima",
"819955", "Kajiki\,\ Kagoshima",
"812911", "Hokota\,\ Ibaraki",
"819434", "Yame\,\ Fukuoka",
"8198298", "Hyuga\,\ Miyazaki",
"812247", "Ogawara\,\ Miyagi",
"817702", "Tsuruga\,\ Fukui",
"81833", "Kudamatsu\,\ Yamaguchi",
"818554", "Hamada\,\ Shimane",
"8186698", "Kurashiki\,\ Okayama",
"8125482", "Murakami\,\ Niigata",
"818368", "Ube\,\ Yamaguchi",
"81864", "Kurashiki\,\ Okayama",
"81578", "Kamioka\,\ Akita",
"811543", "Kushiro\,\ Hokkaido",
"81934", "Kitakyushu\,\ Fukuoka",
"812566", "Sanjo\,\ Niigata",
"81963", "Kumamoto\,\ Kumamoto",
"81542", "Shizuoka\,\ Shizuoka",
"818676", "Kuse\,\ Okayama",
"819668", "Minamata\,\ Kumamoto",
"818365", "Ube\,\ Yamaguchi",
"815362", "Shinshiro\,\ Aichi",
"811536", "Akkeshi\,\ Hokkaido",
"8182941", "Hiroshima\,\ Hiroshima",
"814797", "Yokaichiba\,\ Chiba",
"8186691", "Kurashiki\,\ Okayama",
"8188099", "Tosashimizu\,\ Kochi",
"817997", "Tsuna\,\ Hyogo",
"818373", "Nagato\,\ Yamaguchi",
"811632", "Teshio\,\ Hokkaido",
"819727", "Usuki\,\ Oita",
"819665", "Hitoyoshi\,\ Kumamoto",
"817944", "Kakogawa\,\ Hyogo",
"817732", "Fukuchiyama\,\ Kyoto",
"811393", "Matsumae\,\ Hokkaido",
"811756", "Noheji\,\ Aomori",
"81463", "Hiratsuka\,\ Kanagawa",
"81823", "Kure\,\ Hiroshima",
"812472", "Ishikawa\,\ Fukushima",
"812935", "Mito\,\ Ibaraki",
"811522", "Shari\,\ Hokkaido",
"817486", "Minakuchi\,\ Shiga",
"81434", "Chiba\,\ Chiba",
"81549", "Shizuoka\,\ Shizuoka",
"81924", "Fukuoka\,\ Fukuoka",
"817716", "Sonobe\,\ Kyoto",
"818466", "Mima\,\ Tokushima",
"812938", "Mito\,\ Ibaraki",
"811957", "Iwate\,\ Iwate",
"812890", "Utsunomiya\,\ Tochigi",
"81952", "Saga\,\ Saga",
"817353", "Shingu\,\ Fukuoka",
"818942", "Yawatahama\,\ Ehime",
"811973", "Mizusawa\,\ Iwate",
"819932", "Ibusuki\,\ Kagoshima",
"819744", "Mie\,\ Oita",
"811863", "Kazuno\,\ Akita",
"81460", "Odawara\,\ Kanagawa",
"817615", "Komatsu\,\ Ishikawa",
"812544", "Shibata\,\ Niigata",
"811875", "Kakunodate\,\ Akita",
"81272", "Maebashi\,\ Gunma",
"811655", "Nayoro\,\ Hokkaido",
"817493", "Hikone\,\ Shiga",
"818895", "Susaki\,\ Kochi",
"818949", "Uwajima\,\ Ehime",
"817618", "Kaga\,\ Ishikawa",
"8147957", "Yokaichiba\,\ Chiba",
"819940", "Shibushi\,\ Kagoshima",
"81535", "Hamamatsu\,\ Shizuoka",
"811878", "Omagari\,\ Akita",
"811658", "Kamikawa\,\ Hokkaido",
"812833", "Utsunomiya\,\ Tochigi",
"815363", "Shinshiro\,\ Aichi",
"8125487", "Tsugawa\,\ Niigata",
"814794", "Choshi\,\ Chiba",
"818372", "Nagato\,\ Yamaguchi",
"817994", "Sumoto\,\ Hyogo",
"812678", "Saku\,\ Nagano",
"812858", "Mooka\,\ Tochigi",
"819576", "Shimabara\,\ Nagasaki",
"818568", "Tsuwano\,\ Shimane",
"819724", "Saiki\,\ Oita",
"811392", "Kikonai\,\ Hokkaido",
"81853", "Izumo\,\ Shimane",
"817733", "Fukuchiyama\,\ Kyoto",
"817947", "Miki\,\ Hyogo",
"81429", "Tokorozawa\,\ Saitama",
"818557", "Kawamoto\,\ Shimane",
"81167", "Furano\,\ Hokkaido",
"811542", "Kushiro\,\ Hokkaido",
"81432", "Chiba\,\ Chiba",
"812675", "Saku\,\ Nagano",
"812855", "Oyama\,\ Tochigi",
"81922", "Fukuoka\,\ Fukuoka",
"811336", "Ishikari\,\ Hokkaido",
"811646", "Haboro\,\ Hokkaido",
"818565", "Masuda\,\ Shimane",
"81939", "Kitakyushu\,\ Fukuoka",
"812560", "Itoigawa\,\ Niigata",
"8186997", "Seto\,\ Okayama",
"812571", "Muika\,\ Niigata",
"812244", "Shiroishi\,\ Miyagi",
"81486", "Urawa\,\ Saitama",
"811549", "Kushiro\,\ Hokkaido",
"815768", "Gero\,\ Gifu",
"817703", "Tsuruga\,\ Fukui",
"811452", "Hayakita\,\ Hokkaido",
"819964", "Satsumasendai\,\ Kagoshima",
"819679", "Takamori\,\ Kumamoto",
"819437", "Tanushimaru\,\ Fukuoka",
"815765", "Gero\,\ Gifu",
"811586", "Nakayubetsu\,\ Hokkaido",
"81986", "Miyakonojo\,\ Miyazaki",
"81726", "Ibaraki\,\ Osaka",
"817238", "Neyagawa\,\ Osaka",
"81468", "Yokosuka\,\ Kanagawa",
"81828", "Hiroshima\,\ Hiroshima",
"812832", "Sano\,\ Tochigi",
"8198299", "Hyuga\,\ Miyazaki",
"811862", "Kazuno\,\ Akita",
"812547", "Murakami\,\ Niigata",
"8124196", "Yanaizu\,\ Fukushima",
"812896", "Kanuma\,\ Tochigi",
"81555", "Fujiyoshida\,\ Yamanashi",
"817492", "Hikone\,\ Shiga",
"815995", "Ago\,\ Mie",
"819808", "Yaeyama\ District\,\ Okinawa",
"811954", "Ninohe\,\ Iwate",
"817352", "Shingu\,\ Fukuoka",
"818943", "Yawatahama\,\ Ehime",
"811972", "Mizusawa\,\ Iwate",
"817914", "Aioi\,\ Hyogo",
"81243", "Nihonmatsu\,\ Fukushima",
"811869", "Odate\,\ Akita",
"819747", "Taketa\,\ Oita",
"8188098", "Tosashimizu\,\ Kochi",
"819933", "Ibusuki\,\ Kagoshima",
"812473", "Ishikawa\,\ Fukushima",
"815998", "Ago\,\ Mie",
"819805", "Nago\,\ Okinawa",
"81439", "Kisarazu\,\ Chiba",
"812839", "Sano\,\ Tochigi",
"811523", "Shari\,\ Hokkaido",
"81862", "Okayama\,\ Okayama",
"81932", "Kitakyushu\,\ Fukuoka",
"81875", "Kan\'onji\,\ Kagawa",
"814771", "Ichikawa\,\ Chiba",
"811236", "Chitose\,\ Hokkaido",
"819946", "Kanoya\,\ Kagoshima",
"815584", "Shimoda\,\ Shizuoka",
"81929", "Fukuoka\,\ Fukuoka",
"81544", "Fujinomiya\,\ Shizuoka",
"819667", "Minamata\,\ Kumamoto",
"811983", "Hanamaki\,\ Iwate",
"819725", "Saiki\,\ Oita",
"811939", "Miyako\,\ Iwate",
"817995", "Sumoto\,\ Hyogo",
"814701", "Kamogawa\,\ Chiba",
"814795", "Choshi\,\ Chiba",
"8126176", "Omachi\,\ Nagano",
"818367", "Ube\,\ Yamaguchi",
"812872", "Otawara\,\ Tochigi",
"812652", "Iida\,\ Nagano",
"818564", "Masuda\,\ Shimane",
"819728", "Usuki\,\ Oita",
"817476", "Shimonoseki\,\ Yamaguchi",
"812674", "Komoro\,\ Nagano",
"818202", "Yanai\,\ Yamaguchi",
"812854", "Oyama\,\ Tochigi",
"817998", "Tsuna\,\ Hyogo",
"812482", "Shirakawa\,\ Fukushima",
"81744", "Yamatotakada\,\ Nara",
"812556", "Itoigawa\,\ Niigata",
"814798", "Yokaichiba\,\ Chiba",
"818240", "Higashi\-ku\,\ Hiroshima",
"812245", "Ogawara\,\ Miyagi",
"818296", "Hiroshima\,\ Hiroshima",
"812962", "Shimodate\,\ Ibaraki",
"812879", "Nasukarasuyama\,\ Tochigi",
"812659", "Ina\,\ Nagano",
"819968", "Izumi\,\ Kagoshima",
"818976", "Niihama\,\ Ehime",
"81124", "Ashibetsu\,\ Hokkaido",
"812489", "Sukagawa\,\ Fukushima",
"811463", "Urakawa\,\ Hokkaido",
"815764", "Gero\,\ Gifu",
"812248", "Ogawara\,\ Miyagi",
"81288", "Imabari\,\ Ehime",
"819957", "Kajiki\,\ Kagoshima",
"811932", "Kamaishi\,\ Iwate",
"819965", "Satsumasendai\,\ Kagoshima",
"812799", "Naganohara\,\ Gunma",
"819543", "Takeo\,\ Saga",
"8112395", "Kuriyama\,\ Hokkaido",
"817956", "Sanda\,\ Hyogo",
"819592", "Oseto\,\ Nagasaki",
"81493", "Higashimatsuyama\,\ Saitama",
"811376", "Yakumo\,\ Hokkaido",
"814756", "Togane\,\ Chiba",
"8112394", "Yubari\,\ Hokkaido",
"81134", "Otaru\,\ Hokkaido",
"811853", "Oga\,\ Akita",
"81857", "Tottori\,\ Tottori",
"81266", "Suwa\,\ Nagano",
"811877", "Omagari\,\ Akita",
"818844", "Anan\,\ Tokushima",
"818693", "Oku\,\ Okayama",
"818546", "Kakeya\,\ Shimane",
"8125483", "Murakami\,\ Niigata",
"8165", "Osaka\,\ Osaka",
"817617", "Kaga\,\ Ishikawa",
"819683", "Yamaga\,\ Kumamoto",
"817915", "Aioi\,\ Hyogo",
"8198290", "Nobeoka\,\ Miyazaki",
"815733", "Ena\,\ Gifu",
"812780", "Maebashi\,\ Gunma",
"815994", "Ago\,\ Mie",
"811955", "Ninohe\,\ Iwate",
"818383", "Hagi\,\ Yamaguchi",
"81577", "Takayama\,\ Gifu",
"818582", "Kurayoshi\,\ Tottori",
"815585", "Shimoda\,\ Shizuoka",
"814286", "Sagamihara\,\ Kanagawa",
"812792", "Shibukawa\,\ Gunma",
"8153976", "Hamamatsu\,\ Shizuoka",
"818686", "Tsuyama\,\ Okayama",
"815746", "Minokamo\,\ Gifu",
"8186993", "Bizen\,\ Okayama",
"81582", "Gifu\,\ Gifu",
"819599", "Oseto\,\ Nagasaki",
"819804", "Nago\,\ Okinawa",
"811958", "Iwate\,\ Iwate",
"812743", "Fujioka\,\ Gunma",
"812937", "Mito\,\ Ibaraki",
"815767", "Gero\,\ Gifu",
"811462", "Urakawa\,\ Hokkaido",
"819435", "Yame\,\ Fukuoka",
"8126174", "Omachi\,\ Nagano",
"819954", "Kajiki\,\ Kagoshima",
"811933", "Kamaishi\,\ Iwate",
"8126175", "Omachi\,\ Nagano",
"815755", "Sekigahara\,\ Gifu",
"8183766", "Shimonoseki\,\ Yamaguchi",
"81946", "Amagi\,\ Fukuoka",
"8162", "Osaka\,\ Osaka",
"819438", "Tanushimaru\,\ Fukuoka",
"812550", "Yasuzuka\,\ Niigata",
"81899", "Matsuyama\,\ Ehime",
"818246", "Miyoshi\,\ Hiroshima",
"812963", "Shimodate\,\ Ibaraki",
"81280", "Koga\,\ Ibaraki",
"811946", "Kuji\,\ Iwate",
"81467", "Fujisawa\,\ Kanagawa",
"81485", "Kumagaya\,\ Saitama",
"81827", "Iwakuni\,\ Yamaguchi",
"812653", "Iida\,\ Nagano",
"817948", "Miki\,\ Hyogo",
"812873", "Otawara\,\ Tochigi",
"81998", "Kagoshima\,\ Kagoshima",
"818567", "Tsuwano\,\ Shimane",
"812857", "Mooka\,\ Tochigi",
"818203", "Yanai\,\ Yamaguchi",
"812677", "Saku\,\ Nagano",
"812483", "Shirakawa\,\ Fukushima",
"818290", "Hiroshima\,\ Hiroshima",
"81584", "Ogaki\,\ Gifu",
"818555", "Gotsu\,\ Shimane",
"811982", "Hanamaki\,\ Iwate",
"819664", "Hitoyoshi\,\ Kumamoto",
"817945", "Kakogawa\,\ Hyogo",
"819979", "Tokunoshima\,\ Kagoshima",
"818558", "Kawamoto\,\ Shimane",
"818364", "Ube\,\ Yamaguchi",
"81778", "Takefu\,\ Fukui",
"818583", "Kurayoshi\,\ Tottori",
"8112396", "Kuriyama\,\ Hokkaido",
"812793", "Shibukawa\,\ Gunma",
"81742", "Nara\,\ Nara",
"812934", "Takahagi\,\ Ibaraki",
"817950", "Sanda\,\ Hyogo",
"812742", "Fujioka\,\ Gunma",
"819682", "Yamaga\,\ Kumamoto",
"815732", "Ena\,\ Gifu",
"818382", "Hagi\,\ Yamaguchi",
"815997", "Ago\,\ Mie",
"811852", "Oga\,\ Akita",
"818894", "Susaki\,\ Kochi",
"811874", "Kakunodate\,\ Akita",
"811654", "Nayoro\,\ Hokkaido",
"818692", "Oku\,\ Okayama",
"812786", "Numata\,\ Gunma",
"812416", "Tajima\,\ Fukushima",
"817614", "Komatsu\,\ Ishikawa",
"818596", "Yonago\,\ Tottori",
"812545", "Murakami\,\ Niigata",
"81892", "Kumakogen\,\ Ehime",
"81985", "Miyazaki\,\ Miyazaki",
"81725", "Izumi\,\ Osaka",
"814280", "Tachikawa\,\ Tokyo",
"819542", "Takeo\,\ Saga",
"8163", "Osaka\,\ Osaka",
"818680", "Okayama\,\ Okayama",
"819593", "Oseto\,\ Nagasaki",
"8153975", "Hamamatsu\,\ Shizuoka",
"818552", "Hamada\,\ Shimane",
"817466", "Totsukawa\,\ Nara",
"811547", "Shiranuka\,\ Hokkaido",
"81723", "Sakai\,\ Osaka",
"81983", "Takanabe\,\ Miyazaki",
"818656", "Kasaoka\,\ Okayama",
"81298", "Tsuchiura\,\ Ibaraki",
"814793", "Choshi\,\ Chiba",
"817993", "Sumoto\,\ Hyogo",
"818377", "Shimonoseki\,\ Yamaguchi",
"814700", "Kamogawa\,\ Chiba",
"819723", "Saiki\,\ Oita",
"811634", "Hamatonbetsu\,\ Hokkaido",
"817942", "Kakogawa\,\ Hyogo",
"817734", "Fukuchiyama\,\ Kyoto",
"811397", "Okushiri\,\ Hokkaido",
"81246", "Iwaki\,\ Fukushima",
"815752", "Sekigahara\,\ Gifu",
"818493", "Onomichi\,\ Hiroshima",
"8111", "Sapporo\,\ Hokkaido",
"819963", "Satsumasendai\,\ Kagoshima",
"817949", "Kakogawa\,\ Hyogo",
"811465", "Shizunai\,\ Hokkaido",
"819432", "Yame\,\ Fukuoka",
"8153970", "Hamamatsu\,\ Shizuoka",
"819975", "Naze\,\ Kagoshima",
"812236", "Sendai\,\ Miyagi",
"8198296", "Hyuga\,\ Miyazaki",
"818559", "Kawamoto\,\ Shimane",
"812243", "Shiroishi\,\ Miyagi",
"819978", "Tokunoshima\,\ Kagoshima",
"81143", "Muroran\,\ Hokkaido",
"817704", "Tsuruga\,\ Fukui",
"811867", "Takanosu\,\ Akita",
"812542", "Shibata\,\ Niigata",
"81480", "Kuki\,\ Saitama",
"818695", "Seto\,\ Okayama",
"812646", "Nagano\,\ Nagano",
"817497", "Nagahama\,\ Shiga",
"811855", "Noshiro\,\ Akita",
"8188095", "Tosashimizu\,\ Kochi",
"8175", "Kyoto\,\ Kyoto",
"811366", "Suttsu\,\ Hokkaido",
"81537", "Kakegawa\,\ Shizuoka",
"819786", "Kitsuki\,\ Oita",
"818698", "Bizen\,\ Okayama",
"814298", "Hanno\,\ Saitama",
"81591", "Tsu\,\ Mie",
"812837", "Sano\,\ Tochigi",
"81592", "Tsu\,\ Mie",
"8126170", "Omachi\,\ Nagano",
"811858", "Noshiro\,\ Akita",
"818388", "Tamagawa\,\ Yamaguchi",
"812474", "Ishikawa\,\ Fukushima",
"812745", "Fujioka\,\ Gunma",
"818796", "Tonosho\,\ Kagawa",
"811524", "Abashiri\,\ Hokkaido",
"817676", "Nanao\,\ Ishikawa",
"815738", "Nakatsugawa\,\ Gifu",
"812586", "Nagaoka\,\ Niigata",
"817368", "Iwade\,\ Wakayama",
"819688", "Tamana\,\ Kumamoto",
"81764", "Toyama\,\ Toyama",
"815583", "Shimoda\,\ Shizuoka",
"81174", "Kanita\,\ Aomori",
"812748", "Tomioka\,\ Gunma",
"818385", "Hagi\,\ Yamaguchi",
"811953", "Ninohe\,\ Iwate",
"815735", "Ena\,\ Gifu",
"817357", "Kushimoto\,\ Wakayama",
"818944", "Yawatahama\,\ Ehime",
"811977", "Kitakami\,\ Iwate",
"812549", "Tsugawa\,\ Niigata",
"819685", "Tamana\,\ Kumamoto",
"819934", "Ibusuki\,\ Kagoshima",
"819742", "Mie\,\ Oita",
"81728", "Neyagawa\,\ Osaka",
"81988", "Naha\,\ Okinawa",
"811938", "Miyako\,\ Iwate",
"81947", "Tagawa\,\ Fukuoka",
"81196", "Morioka\,\ Iwate",
"812957", "Daigo\,\ Ibaraki",
"81466", "Fujisawa\,\ Kanagawa",
"812965", "Shimodate\,\ Ibaraki",
"81594", "Kuwana\,\ Mie",
"812242", "Shiroishi\,\ Miyagi",
"817707", "Obama\,\ Fukui",
"812551", "Joetsu\,\ Niigata",
"8112390", "Yubari\,\ Hokkaido",
"815753", "Sekigahara\,\ Gifu",
"811454", "Mukawa\,\ Hokkaido",
"811935", "Kamaishi\,\ Iwate",
"819962", "Satsumasendai\,\ Kagoshima",
"812968", "Kasama\,\ Ibaraki",
"819433", "Yame\,\ Fukuoka",
"812616", "Omachi\,\ Nagano",
"815367", "Shitara\,\ Aichi",
"812230", "Sendai\,\ Miyagi",
"814792", "Choshi\,\ Chiba",
"813", "Tokyo",
"818374", "Nagato\,\ Yamaguchi",
"817992", "Sumoto\,\ Hyogo",
"819556", "Karatsu\,\ Saga",
"812488", "Sukagawa\,\ Fukushima",
"819722", "Saiki\,\ Oita",
"817737", "Maizuru\,\ Kyoto",
"812878", "Nasukarasuyama\,\ Tochigi",
"811394", "Matsumae\,\ Hokkaido",
"817943", "Kakogawa\,\ Hyogo",
"812658", "Ina\,\ Nagano",
"818553", "Hamada\,\ Shimane",
"81775", "Otsu\,\ Shiga",
"8198295", "Hyuga\,\ Miyazaki",
"811544", "Kushiro\,\ Hokkaido",
"818205", "Yanai\,\ Yamaguchi",
"812485", "Shirakawa\,\ Fukushima",
"81172", "Hirosaki\,\ Aomori",
"812875", "Otawara\,\ Tochigi",
"812655", "Iida\,\ Nagano",
"8198294", "Nobeoka\,\ Miyazaki",
"81495", "Honjo\,\ Saitama",
"81762", "Kanazawa\,\ Ishikawa",
"812640", "Nagano\,\ Nagano",
"811952", "Ninohe\,\ Iwate",
"817354", "Shingu\,\ Fukuoka",
"812386", "Nagai\,\ Yamagata",
"818947", "Uwajima\,\ Ehime",
"811974", "Mizusawa\,\ Iwate",
"812798", "Naganohara\,\ Gunma",
"8188096", "Tosashimizu\,\ Kochi",
"817912", "Aioi\,\ Hyogo",
"819743", "Mie\,\ Oita",
"818588", "Koge\,\ Tottori",
"819937", "Kaseda\,\ Kagoshima",
"812477", "Miharu\,\ Fukushima",
"8167", "Osaka\,\ Osaka",
"812795", "Shibukawa\,\ Gunma",
"811527", "Bihoro\,\ Hokkaido",
"818391", "Ogori\,\ Yamaguchi",
"81179", "Sannohe\,\ Aomori",
"8199343", "Kagoshima\,\ Kagoshima",
"818585", "Kurayoshi\,\ Tottori",
"81877", "Marugame\,\ Kagawa",
"815582", "Shimoda\,\ Shizuoka",
"812580", "Tokamachi\,\ Niigata",
"81738", "Gobo\,\ Wakayama",
"812834", "Utsunomiya\,\ Tochigi",
"81488", "Urawa\,\ Saitama",
"814281", "Sagamihara\,\ Kanagawa",
"811864", "Odate\,\ Akita",
"812543", "Shibata\,\ Niigata",
"817494", "Hikone\,\ Shiga",
"819598", "Fukue\,\ Nagasaki",
"81557", "Ito\,\ Shizuoka",
"812696", "Iiyama\,\ Nagano",
"81550", "Gotenba\,\ Shizuoka",
"81538", "Iwata\,\ Shizuoka",
"8199347", "Kagoshima\,\ Kagoshima",
"812964", "Shimodate\,\ Ibaraki",
"818956", "Uwajima\,\ Ehime",
"819826", "Hyuga\,\ Miyazaki",
"812679", "Saku\,\ Nagano",
"812859", "Oyama\,\ Tochigi",
"815762", "Gero\,\ Gifu",
"81245", "Fukushima\,\ Fukushima",
"819977", "Setouchi\,\ Kagoshima",
"819953", "Okuchi\,\ Kagoshima",
"81268", "Ueda\,\ Nagano",
"811934", "Kamaishi\,\ Iwate",
"811455", "Mukawa\,\ Hokkaido",
"819663", "Hitoyoshi\,\ Kumamoto",
"81553", "Yamanashi\,\ Yamanashi",
"811987", "Tono\,\ Iwate",
"811395", "Esashi\,\ Hokkaido",
"818375", "Mine\,\ Yamaguchi",
"811548", "Teshikaga\,\ Hokkaido",
"815769", "Shokawa\,\ Gifu",
"81222", "Sendai\,\ Miyagi",
"818363", "Ube\,\ Yamaguchi",
"8126178", "Omachi\,\ Nagano",
"817686", "Noto\,\ Ishikawa",
"811398", "Kumaishi\,\ Hokkaido",
"812874", "Otawara\,\ Tochigi",
"812654", "Iida\,\ Nagano",
"818562", "Masuda\,\ Shimane",
"812672", "Komoro\,\ Nagano",
"812852", "Oyama\,\ Tochigi",
"818204", "Yanai\,\ Yamaguchi",
"818378", "Shimonoseki\,\ Yamaguchi",
"817456", "Yamatotakada\,\ Nara",
"812484", "Shirakawa\,\ Fukushima",
"8126171", "Omachi\,\ Nagano",
"818666", "Ibara\,\ Okayama",
"811545", "Kushiro\,\ Hokkaido",
"8112399", "Kuriyama\,\ Hokkaido",
"812576", "Tokamachi\,\ Niigata",
"81569", "Handa\,\ Aichi",
"819687", "Tamana\,\ Kumamoto",
"817367", "Iwade\,\ Wakayama",
"817239", "Neyagawa\,\ Osaka",
"817355", "Shingu\,\ Fukuoka",
"815737", "Nakatsugawa\,\ Gifu",
"811975", "Mizusawa\,\ Iwate",
"8153971", "Hamamatsu\,\ Shizuoka",
"818263", "Kake\,\ Hiroshima",
"815992", "Toba\,\ Mie",
"818387", "Tamagawa\,\ Yamaguchi",
"818584", "Kurayoshi\,\ Tottori",
"811978", "Kitakami\,\ Iwate",
"812794", "Shibukawa\,\ Gunma",
"818476", "Fuchu\,\ Hiroshima",
"81561", "Seto\,\ Aichi",
"819802", "Minamidaito\,\ Okinawa",
"812747", "Tomioka\,\ Gunma",
"8153978", "Hamamatsu\,\ Shizuoka",
"812933", "Takahagi\,\ Ibaraki",
"812835", "Sano\,\ Tochigi",
"811356", "Iwanai\,\ Hokkaido",
"819547", "Kashima\,\ Saga",
"817498", "Nagahama\,\ Shiga",
"819809", "Yaeyama\ District\,\ Okinawa",
"8152", "Nagoya\,\ Aichi",
"81474", "Funabashi\,\ Chiba",
"814776", "Funabashi\,\ Chiba",
"81183", "Yuzawa\,\ Akita",
"811868", "Takanosu\,\ Akita",
"81286", "Utsunomiya\,\ Tochigi",
"811857", "Noshiro\,\ Akita",
"8182920", "Hatsukaichi\,\ Hiroshima",
"812838", "Sano\,\ Tochigi",
"818893", "Sakawa\,\ Kochi",
"811653", "Shibetsu\,\ Hokkaido",
"811873", "Kakunodate\,\ Akita",
"818842", "Anan\,\ Tokushima",
"814297", "Hanno\,\ Saitama",
"817495", "Nagahama\,\ Shiga",
"815999", "Tsu\,\ Mie",
"818697", "Bizen\,\ Okayama",
"81940", "Munakata\,\ Fukuoka",
"811865", "Odate\,\ Akita",
"817613", "Komatsu\,\ Ishikawa",
"81259", "Sado\,\ Niigata",
"812657", "Ina\,\ Nagano",
"81166", "Asahikawa\,\ Hokkaido",
"812877", "Kuroiso\,\ Tochigi",
"817738", "Maizuru\,\ Kyoto",
"81776", "Fukui\,\ Fukui",
"818563", "Masuda\,\ Shimane",
"812853", "Oyama\,\ Tochigi",
"812673", "Komoro\,\ Nagano",
"812487", "Sukagawa\,\ Fukushima",
"8153979", "Hamamatsu\,\ Shizuoka",
"81878", "Takamatsu\,\ Kagawa",
"81564", "Okazaki\,\ Aichi",
"815368", "Shitara\,\ Aichi",
"81533", "Toyohashi\,\ Aichi",
"811984", "Hanamaki\,\ Iwate",
"811635", "Hamatonbetsu\,\ Hokkaido",
"819662", "Hitoyoshi\,\ Kumamoto",
"817735", "Fukuchiyama\,\ Kyoto",
"812376", "Sagae\,\ Yamagata",
"8153967", "Hamamatsu\,\ Shizuoka",
"81234", "Sakata\,\ Yamagata",
"818362", "Ube\,\ Yamaguchi",
"81263", "Matsumoto\,\ Nagano",
"811464", "Shizunai\,\ Hokkaido",
"815763", "Gero\,\ Gifu",
"819974", "Yakushima\,\ Kagoshima",
"818369", "Ube\,\ Yamaguchi",
"819952", "Okuchi\,\ Kagoshima",
"8183768", "Shimonoseki\,\ Yamaguchi",
"811937", "Miyako\,\ Iwate",
"818660", "Seto\,\ Okayama",
"81471", "Kashiwa\,\ Chiba",
"817705", "Obama\,\ Fukui",
"81737", "Yuasa\,\ Wakayama",
"812967", "Kasama\,\ Ibaraki",
"81825", "Hiroshima\,\ Hiroshima",
"81487", "Urawa\,\ Saitama",
"81792", "Himeji\,\ Hyogo",
"811736", "Goshogawara\,\ Aomori",
"81465", "Odawara\,\ Kanagawa",
"812955", "Hitachi\-Omiya\,\ Ibaraki",
"81260", "Anan\,\ Nagano",
"8144", "Kawasaki\,\ Kanagawa",
"81979", "Nakatsu\,\ Oita",
"811854", "Oga\,\ Akita",
"818892", "Sakawa\,\ Kochi",
"818843", "Anan\,\ Tokushima",
"811652", "Shibetsu\,\ Hokkaido",
"818694", "Okayama\,\ Okayama",
"811556", "Obihiro\,\ Hokkaido",
"817612", "Komatsu\,\ Ishikawa",
"815986", "Matsusaka\,\ Mie",
"81948", "Iizuka\,\ Fukuoka",
"819544", "Takeo\,\ Saga",
"81965", "Yatsushiro\,\ Kumamoto",
"81727", "Ikeda\,\ Osaka",
"819597", "Fukue\,\ Nagasaki",
"81987", "Nichinan\,\ Miyazaki",
"812939", "Mito\,\ Ibaraki",
"818836", "Mima\,\ Tokushima",
"81835", "Hofu\,\ Yamaguchi",
"818587", "Koge\,\ Tottori",
"819938", "Kaseda\,\ Kagoshima",
"8112398", "Kuriyama\,\ Hokkaido",
"81252", "Niigata\,\ Niigata",
"81849", "Fukuyama\,\ Hiroshima",
"814770", "Ichikawa\,\ Chiba",
"81188", "Akita\,\ Akita",
"811525", "Abashiri\,\ Hokkaido",
"812797", "Shibukawa\,\ Gunma",
"818948", "Uwajima\,\ Ehime",
"819803", "Nago\,\ Okinawa",
"812475", "Ishikawa\,\ Fukushima",
"812932", "Takahagi\,\ Ibaraki",
"812744", "Fujioka\,\ Gunma",
"819935", "Kaseda\,\ Kagoshima",
"819684", "Yamaga\,\ Kumamoto",
"8126179", "Omachi\,\ Nagano",
"8112391", "Yubari\,\ Hokkaido",
"818806", "Sukumo\,\ Kochi",
"815734", "Ena\,\ Gifu",
"811528", "Bihoro\,\ Hokkaido",
"812996", "Itako\,\ Ibaraki",
"818945", "Yawatahama\,\ Ehime",
"818262", "Kake\,\ Hiroshima",
"818384", "Hagi\,\ Yamaguchi",
"812478", "Miharu\,\ Fukushima",
"815993", "Toba\,\ Mie",
"817905", "Fukusaki\,\ Hyogo",
"812615", "Omachi\,\ Nagano",
"81765", "Uozu\,\ Toyama",
"81927", "Fukuoka\,\ Fukuoka",
"81492", "Kawagoe\,\ Saitama",
"815978", "Kumano\,\ Mie",
"81162", "Wakkanai\,\ Hokkaido",
"811936", "Miyako\,\ Iwate",
"814705", "Tateyama\,\ Chiba",
"812559", "Yasuzuka\,\ Niigata",
"818292", "Hiroshima\,\ Hiroshima",
"812618", "Omachi\,\ Nagano",
"818243", "Higashi\-ku\,\ Hiroshima",
"818972", "Niihama\,\ Ehime",
"811943", "Iwaizumi\,\ Iwate",
"818954", "Uwajima\,\ Ehime",
"819824", "Nobeoka\,\ Miyazaki",
"819233", "Maebaru\,\ Fukuoka",
"812656", "Ina\,\ Nagano",
"817684", "Wajima\,\ Ishikawa",
"812876", "Kuroiso\,\ Tochigi",
"818206", "Yanai\,\ Yamaguchi",
"819558", "Karatsu\,\ Saga",
"812486", "Sukagawa\,\ Fukushima",
"8153969", "Hamamatsu\,\ Shizuoka",
"817454", "Yamatotakada\,\ Nara",
"818299", "Hiroshima\,\ Hiroshima",
"812552", "Joetsu\,\ Niigata",
"81284", "Ashikaga\,\ Tochigi",
"818664", "Takahashi\,\ Okayama",
"8112392", "Yubari\,\ Hokkaido",
"812574", "Kashiwazaki\,\ Niigata",
"8186553", "Kurashiki\,\ Okayama",
"812377", "Sagae\,\ Yamagata",
"819555", "Karatsu\,\ Saga",
"814220", "Kokubunji\,\ Tokyo",
"812917", "Mito\,\ Ibaraki",
"81898", "Imabari\,\ Ehime",
"81583", "Gifu\,\ Gifu",
"81476", "Narita\,\ Chiba",
"818586", "Kurayoshi\,\ Tottori",
"819735", "Hita\,\ Oita",
"818682", "Tsuyama\,\ Okayama",
"814282", "Ome\,\ Tokyo",
"812796", "Shibukawa\,\ Gunma",
"812388", "Nagai\,\ Yamagata",
"815742", "Minokamo\,\ Gifu",
"818474", "Fuchu\,\ Hiroshima",
"817959", "Sanda\,\ Hyogo",
"819738", "Kusu\,\ Oita",
"81138", "Hakodate\,\ Hokkaido",
"818807", "Sukumo\,\ Kochi",
"812385", "Yonezawa\,\ Yamagata",
"812997", "Itako\,\ Ibaraki",
"818690", "Okayama\,\ Okayama",
"815398", "Hamamatsu\,\ Shizuoka",
"812695", "Nakano\,\ Nagano",
"8166", "Osaka\,\ Osaka",
"81937", "Kitakyushu\,\ Fukuoka",
"812783", "Numata\,\ Gunma",
"818542", "Yasugi\,\ Shimane",
"812413", "Kitakata\,\ Fukushima",
"81885", "Komatsushima\,\ Tokushima",
"81992", "Kagoshima\,\ Kagoshima",
"81427", "Sagamihara\,\ Kanagawa",
"818593", "Yonago\,\ Tottori",
"81779", "Ono\,\ Gifu",
"818689", "Okayama\,\ Okayama",
"814289", "Ome\,\ Tokyo",
"812698", "Iiyama\,\ Nagano",
"815395", "Hamamatsu\,\ Shizuoka",
"811354", "Yoichi\,\ Hokkaido",
"817952", "Nishiwaki\,\ Hyogo",
"819596", "Fukue\,\ Nagasaki",
"811372", "Shikabe\,\ Hokkaido",
"814752", "Mobara\,\ Chiba",
"811986", "Tono\,\ Iwate",
"812374", "Murayama\,\ Yamagata",
"817468", "Kamikitayama\,\ Nara",
"8112397", "Kuriyama\,\ Hokkaido",
"81743", "Nara\,\ Nara",
"812914", "Hokota\,\ Ibaraki",
"817687", "Noto\,\ Ishikawa",
"8153972", "Hamamatsu\,\ Shizuoka",
"817457", "Yamatotakada\,\ Nara",
"818655", "Kamogata\,\ Okayama",
"812553", "Joetsu\,\ Niigata",
"818667", "Ibara\,\ Okayama",
"817465", "Yoshino\,\ Nara",
"812577", "Muika\,\ Niigata",
"818249", "Higashi\-ku\,\ Hiroshima",
"812238", "Sendai\,\ Miyagi",
"818293", "Hatsukaichi\,\ Hiroshima",
"81226", "Kesennuma\,\ Miyagi",
"818242", "Higashi\-ku\,\ Hiroshima",
"811734", "Goshogawara\,\ Aomori",
"811942", "Iwaizumi\,\ Iwate",
"818973", "Niihama\,\ Ehime",
"81740", "Imazu\,\ Shiga",
"818957", "Misho\,\ Ehime",
"819827", "Takachiho\,\ Miyazaki",
"819232", "Maebaru\,\ Fukuoka",
"81547", "Shimada\,\ Shizuoka",
"811466", "Erimo\,\ Hokkaido",
"81893", "Ozu\,\ Ehime",
"812235", "Sendai\,\ Miyagi",
"819976", "Naze\,\ Kagoshima",
"818512", "Nishigo\,\ Fukushima",
"815984", "Matsusaka\,\ Mie",
"8183767", "Shimonoseki\,\ Yamaguchi",
"811357", "Iwanai\,\ Hokkaido",
"81236", "Yamagata\,\ Yamagata",
"819546", "Kashima\,\ Saga",
"817953", "Nishiwaki\,\ Hyogo",
"812648", "Nagano\,\ Nagano",
"818834", "Kamojima\,\ Tokushima",
"814753", "Mobara\,\ Chiba",
"819785", "Bungotakada\,\ Oita",
"814777", "Funabashi\,\ Chiba",
"811365", "Kutchan\,\ Hokkaido",
"81566", "Kariya\,\ Aichi",
"811856", "Noshiro\,\ Akita",
"81494", "Chichibu\,\ Saitama",
"812782", "Numata\,\ Gunma",
"818696", "Bizen\,\ Okayama",
"819788", "Kunisaki\,\ Oita",
"812412", "Kitakata\,\ Fukushima",
"818543", "Yasugi\,\ Shimane",
"81774", "Uji\,\ Kyoto",
"811554", "Obihiro\,\ Hokkaido",
"818592", "Yonago\,\ Tottori",
"812419", "Tajima\,\ Fukushima",
"8126172", "Omachi\,\ Nagano",
"819686", "Tamana\,\ Kumamoto",
"817366", "Iwade\,\ Wakayama",
"812588", "Nagaoka\,\ Niigata",
"815736", "Nakatsugawa\,\ Gifu",
"817678", "Nanao\,\ Ishikawa",
"812994", "Ishioka\,\ Ibaraki",
"814240", "Kokubunji\,\ Tokyo",
"818798", "Tonosho\,\ Kagawa",
"812789", "Maebashi\,\ Gunma",
"81277", "Kiryu\,\ Gunma",
"812585", "Nagaoka\,\ Niigata",
"814283", "Ome\,\ Tokyo",
"81282", "Tochigi\,\ Tochigi",
"818683", "Tsuyama\,\ Okayama",
"815743", "Minokamo\,\ Gifu",
"818477", "Tojo\,\ Hiroshima",
"817675", "Nanao\,\ Ishikawa",
"81281", "Utsunomiya\,\ Tochigi",
"8153968", "Hamamatsu\,\ Shizuoka",
"812746", "Tomioka\,\ Gunma",
"81822", "Hiroshima\,\ Hiroshima",
"81462", "Atsugi\,\ Kanagawa",
"815366", "Shitara\,\ Aichi",
"81839", "Yamaguchi\,\ Yamaguchi",
"811532", "Nemuro\,\ Hokkaido",
"81270", "Isesaki\,\ Gunma",
"819557", "Karatsu\,\ Saga",
"81969", "Amakusa\,\ Kumamoto",
"81191", "Ichinoseki\,\ Iwate",
"819573", "Isahaya\,\ Nagasaki",
"812375", "Murayama\,\ Yamagata",
"817736", "Maizuru\,\ Kyoto",
"81192", "Ofunato\,\ Iwate",
"817464", "Yoshino\,\ Nara",
"812562", "Sanjo\,\ Niigata",
"818874", "Aki\,\ Kochi",
"811333", "Tobetsu\,\ Hokkaido",
"818654", "Kamogata\,\ Okayama",
"812378", "Sagae\,\ Yamagata",
"811735", "Goshogawara\,\ Aomori",
"812956", "Hitachi\-Omiya\,\ Ibaraki",
"818679", "Niimi\,\ Okayama",
"815977", "Kumano\,\ Mie",
"81273", "Takasaki\,\ Gunma",
"817706", "Obama\,\ Fukui",
"81938", "Kitakyushu\,\ Fukuoka",
"81176", "Towada\,\ Aomori",
"81950", "Hirado\,\ Nagasaki",
"81766", "Takaoka\,\ Toyama",
"81845", "Innoshima\,\ Hiroshima",
"812234", "Sendai\,\ Miyagi",
"811583", "Monbetsu\,\ Hokkaido",
"811558", "Hiroo\,\ Hokkaido",
"811364", "Kutchan\,\ Hokkaido",
"817962", "Toyooka\,\ Hyogo",
"8125484", "Murakami\,\ Niigata",
"819784", "Bungotakada\,\ Oita",
"8186552", "Kurashiki\,\ Okayama",
"818835", "Mima\,\ Tokushima",
"815985", "Matsusaka\,\ Mie",
"8125485", "Tsugawa\,\ Niigata",
"811555", "Obihiro\,\ Hokkaido",
"81928", "Fukuoka\,\ Fukuoka",
"8178", "Kobe\,\ Hyogo",
"8112393", "Yubari\,\ Hokkaido",
"812893", "Utsunomiya\,\ Tochigi",
"81886", "Tokushima\,\ Tokushima",
"81438", "Kisarazu\,\ Chiba",
"812697", "Iiyama\,\ Nagano",
"81832", "Shimonoseki\,\ Yamaguchi",
"81975", "Oita\,\ Oita",
"8169", "Osaka\,\ Osaka",
"812387", "Nagai\,\ Yamagata",
"8186994", "Seto\,\ Okayama",
"818946", "Uwajima\,\ Ehime",
"812995", "Ishioka\,\ Ibaraki",
"81199", "Morioka\,\ Iwate",
"81543", "Shizuoka\,\ Shizuoka",
"81962", "Kumamoto\,\ Kumamoto",
"8186995", "Seto\,\ Okayama",
"819936", "Kaseda\,\ Kagoshima",
"812476", "Miharu\,\ Fukushima",
"811752", "Mutsu\,\ Aomori",
"817482", "Yokaichi\,\ Shiga",
"812998", "Itako\,\ Ibaraki",
"811526", "Abashiri\,\ Hokkaido",
"817674", "Hakui\,\ Ishikawa",
"812830", "Utsunomiya\,\ Tochigi",
"818808", "Tosashimizu\,\ Kochi",
"817712", "Kameoka\,\ Kyoto",
"811233", "Chitose\,\ Hokkaido",
"812584", "Nagaoka\,\ Niigata",
"81244", "Hobara\,\ Fukushima",
"817969", "Hamasaka\,\ Hyogo",
"819943", "Kanoya\,\ Kagoshima",
"819737", "Kusu\,\ Oita",
"817722", "Miyazu\,\ Kyoto",
"818462", "Takehara\,\ Hiroshima",
"814704", "Tateyama\,\ Chiba",
"819828", "Takachiho\,\ Miyazaki",
"818958", "Misho\,\ Ehime",
"817904", "Fukusaki\,\ Hyogo",
"812614", "Omachi\,\ Nagano",
"812237", "Sendai\,\ Miyagi",
"811582", "Monbetsu\,\ Hokkaido",
"819825", "Hyuga\,\ Miyazaki",
"818955", "Uwajima\,\ Ehime",
"81225", "Ishinomaki\,\ Miyagi",
"815974", "Owase\,\ Mie",
"81420", "Tokorozawa\,\ Saitama",
"8124197", "Yanaizu\,\ Fukushima",
"8126173", "Omachi\,\ Nagano",
"81930", "Yukuhashi\,\ Fukuoka",
"81958", "Nagasaki\,\ Nagasaki",
"812575", "Tokamachi\,\ Niigata",
"811546", "Kushiro\,\ Hokkaido",
"818665", "Takahashi\,\ Okayama",
"81242", "Aizuwakamatsu\,\ Fukushima",
"812563", "Sanjo\,\ Niigata",
"811332", "Tobetsu\,\ Hokkaido",
"818657", "Kasaoka\,\ Okayama",
"817455", "Yamatotakada\,\ Nara",
"815959", "Kameyama\,\ Mie",
"81157", "Kitami\,\ Hokkaido",
"817685", "Wajima\,\ Ishikawa",
"815566", "Minobu\,\ Yamanashi",
"81834", "Tokuyama\,\ Yamaguchi",
"812578", "Muika\,\ Niigata",
"811533", "Nemuro\,\ Hokkaido",
"818668", "Ibara\,\ Okayama",
"819676", "Takamori\,\ Kumamoto",
"81423", "Kokubunji\,\ Tokyo",
"811589", "Okoppe\,\ Hokkaido",
"81863", "Tamano\,\ Okayama",
"8147955", "Yokaichiba\,\ Chiba",
"819554", "Imari\,\ Saga",
"818376", "Mine\,\ Yamaguchi",
"81933", "Kitakyushu\,\ Fukuoka",
"819572", "Isahaya\,\ Nagasaki",
"817688", "Noto\,\ Ishikawa",
"811396", "Esashi\,\ Hokkaido",
"811753", "Mutsu\,\ Aomori",
"818797", "Tonosho\,\ Kagawa",
"817483", "Yokaichi\,\ Shiga",
"817677", "Nanao\,\ Ishikawa",
"818475", "Fuchu\,\ Hiroshima",
"811232", "Chitose\,\ Hokkaido",
"812587", "Nagaoka\,\ Niigata",
"817713", "Kameoka\,\ Kyoto",
"8125486", "Tsugawa\,\ Niigata",
"81249", "Koriyama\,\ Fukushima",
"819734", "Hita\,\ Oita",
"817723", "Miyazu\,\ Kyoto",
"81852", "Matsue\,\ Shimane",
"818463", "Takehara\,\ Hiroshima",
"812899", "Kanuma\,\ Tochigi",
"81464", "Atsugi\,\ Kanagawa",
"812384", "Yonezawa\,\ Yamagata",
"818478", "Tojo\,\ Hiroshima",
"817356", "Kushimoto\,\ Wakayama",
"81433", "Chiba\,\ Chiba",
"81596", "Ise\,\ Mie",
"811976", "Kitakami\,\ Iwate",
"81923", "Fukuoka\,\ Fukuoka",
"811866", "Takanosu\,\ Akita",
"81565", "Toyota\,\ Aichi",
"81587", "Ichinomiya\,\ Aichi",
"81548", "Haibara\,\ Shizuoka",
"812892", "Utsunomiya\,\ Tochigi",
"8186996", "Seto\,\ Okayama",
"812647", "Nagano\,\ Nagano",
"8153973", "Hamamatsu\,\ Shizuoka",
"817496", "Nagahama\,\ Shiga",
"81572", "Tajimi\,\ Gifu",
"812694", "Nakano\,\ Nagano",
"811564", "Kamishihoro\,\ Hokkaido",
"814775", "Funabashi\,\ Chiba",
"8145", "Yokohama\,\ Kanagawa",
"811367", "Suttsu\,\ Hokkaido",
"81235", "Tsuruoka\,\ Yamagata",
"817963", "Toyooka\,\ Hyogo",
"819787", "Kunisaki\,\ Oita",
"812836", "Sano\,\ Tochigi",
"815394", "Hamamatsu\,\ Shizuoka",};
$areanames{ja} = {"81930", "行橋",
"81420", "所沢",
"815952", "上野",
"819825", "日向",
"811582", "紋別",
"812614", "大町",
"819828", "高千穂",
"811456", "門別富川",
"817688", "能都",
"811396", "江差",
"819572", "諫早",
"818376", "美祢",
"817458", "大和榛原",
"811589", "興部",
"819676", "高森",
"812578", "六日町",
"811642", "石狩深川",
"815566", "身延",
"817685", "輪島",
"817455", "大和高田",
"815959", "亀山",
"811332", "当別",
"812563", "三条",
"811546", "釧路",
"812575", "十日町",
"81596", "伊勢",
"818478", "東城",
"817356", "串本",
"812899", "鹿沼",
"817723", "宮津",
"818463", "竹原",
"819734", "日田",
"8125486", "津川",
"811232", "千歳",
"818475", "府中",
"818797", "土庄",
"811753", "むつ",
"815394", "浜松",
"812836", "佐野",
"819787", "国東",
"811367", "寿都",
"8145", "横浜",
"811564", "上士幌",
"817496", "長浜",
"8186996", "岡山瀬戸",
"812892", "宇都宮",
"81548", "榛原",
"81587", "一宮",
"81565", "豊田",
"811643", "石狩深川",
"811333", "当別",
"818654", "鴨方",
"818874", "安芸",
"812562", "三条",
"814992", "伊豆大島",
"817736", "舞鶴",
"819573", "諫早",
"81191", "一関",
"819557", "唐津",
"81969", "天草",
"81270", "伊勢崎",
"81839", "山口",
"81462", "厚木",
"81822", "広島",
"812234", "仙台",
"811583", "紋別",
"817907", "播磨山崎",
"81845", "因島",
"811738", "鰺ケ沢",
"81176", "十和田",
"814707", "大原",
"81938", "北九州",
"815977", "熊野",
"812956", "常陸大宮",
"811735", "五所川原",
"815953", "上野",
"812569", "巻",
"812697", "飯山",
"81438", "木更津",
"812644", "木曾福島",
"812893", "宇都宮",
"8112393", "夕張",
"81928", "福岡",
"8186552", "倉敷",
"818462", "竹原",
"817722", "宮津",
"812584", "長岡",
"81244", "原町",
"811233", "千歳",
"818808", "土佐清水",
"817674", "羽咋",
"812998", "潮来",
"811752", "むつ",
"819936", "加世田",
"81962", "熊本",
"818805", "土佐中村",
"812995", "石岡",
"818946", "宇和",
"812387", "長井",
"81832", "下関",
"818249", "東広島",
"818667", "井原",
"818655", "鴨方",
"818875", "土佐山田",
"8112397", "栗山",
"818878", "嶺北",
"814226", "武蔵野三鷹",
"812235", "仙台",
"81893", "大洲",
"81547", "島田",
"819232", "前原",
"818957", "御荘",
"81740", "今津",
"818973", "新居浜",
"811734", "五所川原",
"818242", "東広島",
"81226", "気仙沼",
"812238", "仙台",
"818592", "米子",
"81774", "宇治",
"818696", "備前",
"812645", "木曾福島",
"81494", "秩父",
"811856", "能代",
"814777", "船橋",
"814753", "茂原",
"812648", "長野",
"817953", "西脇",
"819546", "鹿島",
"81236", "山形",
"8183767", "下関",
"81281", "宇都宮",
"817675", "七尾",
"812585", "長岡",
"81277", "桐生",
"8153961", "天竜",
"814240", "国分寺",
"812994", "石岡",
"815736", "中津川",
"817678", "七尾",
"818804", "土佐中村",
"812588", "長岡",
"819686", "玉名",
"819233", "前原",
"819824", "延岡",
"818972", "新居浜",
"818243", "東広島",
"812618", "大町",
"811936", "宮古",
"81162", "稚内",
"81927", "福岡",
"81765", "魚津",
"812615", "大町",
"81476", "成田",
"812917", "水戸",
"812377", "寒河江",
"8186553", "倉敷",
"812574", "柏崎",
"8112392", "夕張",
"81284", "足利",
"817454", "大和高田",
"818206", "柳井",
"817684", "輪島",
"81138", "函館",
"819738", "玖珠",
"817959", "三田",
"818474", "府中",
"812796", "渋川",
"819735", "日田",
"814752", "茂原",
"818837", "阿波池田",
"817952", "西脇",
"811354", "余市",
"815395", "浜松",
"815987", "三瀬谷",
"818593", "米子",
"811557", "十勝池田",
"81427", "相模原",
"81885", "小松島",
"81937", "北九州",
"8166", "大阪",
"815398", "浜松",
"818362", "宇部",
"81263", "松本",
"81234", "酒田",
"817735", "福知山",
"819662", "人吉",
"812487", "須賀川",
"812673", "小諸",
"812853", "小山",
"81776", "福井",
"817738", "舞鶴",
"812877", "黒磯",
"812657", "伊那",
"81259", "佐渡",
"812955", "常陸大宮",
"811736", "五所川原",
"81465", "小田原",
"81487", "浦和",
"81825", "広島",
"812967", "笠間",
"81737", "湯浅",
"81471", "柏",
"818660", "岡山瀬戸",
"8183768", "下関",
"819952", "大口",
"818369", "宇部",
"814224", "武蔵野三鷹",
"81835", "防府",
"812939", "水戸",
"81987", "日南",
"81965", "八代",
"81727", "池田",
"819597", "福江",
"819544", "武雄",
"81948", "飯塚",
"817612", "小松",
"818694", "岡山",
"818843", "阿南",
"811854", "男鹿",
"815993", "鳥羽",
"818384", "萩",
"818262", "加計",
"818945", "八幡浜",
"812996", "潮来",
"815734", "恵那",
"818806", "宿毛",
"8112391", "夕張",
"819935", "加世田",
"819684", "山鹿",
"812932", "高萩",
"818948", "宇和",
"81188", "秋田",
"81849", "福山",
"814770", "市川",
"81252", "新潟",
"8112398", "栗山",
"818587", "郡家",
"819938", "加世田",
"811455", "鵡川",
"811934", "釜石",
"819953", "大口",
"819977", "瀬戸内",
"812859", "小山",
"812679", "佐久",
"819826", "日向",
"8199347", "鹿児島",
"81538", "磐田",
"81569", "半田",
"812576", "十日町",
"819678", "矢部",
"811545", "釧路",
"818378", "下関",
"817456", "大和高田",
"812852", "小山",
"818204", "柳井",
"812672", "小諸",
"817686", "能都",
"811398", "熊石",
"815565", "鰍沢青柳",
"8153962", "天竜",
"818363", "宇部",
"811548", "弟子屈",
"819675", "熊本一の宮",
"818375", "美祢",
"811395", "江差",
"811987", "遠野",
"819663", "人吉",
"81553", "山梨",
"812933", "高萩",
"812747", "富岡",
"818476", "府中",
"81562", "尾張横須賀",
"812794", "渋川",
"815992", "鳥羽",
"818263", "加計",
"817355", "新宮",
"817239", "寝屋川",
"817367", "岩出",
"817613", "小松",
"81940", "宗像",
"817495", "長浜",
"815999", "津",
"818842", "阿南",
"812838", "佐野",
"8182920", "廿日市",
"81286", "宇都宮",
"81474", "船橋",
"817498", "長浜",
"811356", "岩内",
"812835", "佐野",
"819433", "八女",
"812616", "大町",
"811935", "釜石",
"815753", "関",
"811454", "鵡川",
"812551", "上越",
"817707", "小浜",
"81594", "桑名",
"81196", "盛岡",
"811938", "宮古",
"81947", "田川",
"81988", "那覇",
"81728", "寝屋川",
"81762", "金沢",
"815564", "鰍沢青柳",
"818205", "柳井",
"811544", "釧路",
"818553", "浜田",
"811394", "松前",
"811637", "北見枝幸",
"819722", "佐伯",
"818208", "久賀",
"817992", "洲本",
"818374", "長門",
"813", "東京",
"814792", "銚子",
"819674", "熊本一の宮",
"815367", "設楽",
"815582", "下田",
"8199343", "鹿児島",
"818391", "小郡",
"811527", "美幌",
"812795", "渋川",
"812477", "三春",
"8188096", "土佐清水",
"812798", "長野原",
"817354", "新宮",
"811952", "二戸",
"811566", "十勝清水",
"817494", "彦根",
"812543", "新発田",
"815396", "浜松",
"814281", "相模原",
"81488", "浦和",
"812834", "宇都宮",
"815589", "修善寺大仁",
"81738", "御坊",
"817734", "福知山",
"819723", "佐伯",
"814700", "鴨川",
"817993", "洲本",
"814793", "銚子",
"81298", "土浦",
"818876", "土佐山田",
"818656", "笠岡",
"818552", "浜田",
"814228", "武蔵野三鷹",
"818559", "川本",
"8198296", "日向",
"812236", "仙台",
"814225", "武蔵野三鷹",
"819432", "八女",
"815752", "関",
"81246", "いわき",
"811858", "能代",
"81591", "津",
"814298", "飯能",
"818698", "備前",
"81537", "掛川",
"8175", "京都",
"811855", "能代",
"8153963", "天竜",
"818695", "岡山瀬戸",
"812646", "長野",
"81480", "久喜",
"812542", "新発田",
"811867", "鷹巣",
"819934", "指宿",
"819685", "玉名",
"812549", "津川",
"818944", "八幡浜",
"811977", "北上",
"815735", "恵那",
"818385", "萩",
"811953", "二戸",
"81174", "蟹田",
"815583", "下田",
"819688", "玉名",
"812586", "長岡",
"815738", "中津川",
"817676", "七尾",
"818388", "田万川",
"815758", "郡上八幡",
"81280", "古河",
"818246", "三次",
"81899", "松山",
"812550", "安塚",
"819438", "田主丸",
"81946", "甘木",
"8183766", "下関",
"815755", "関",
"811933", "釜石",
"819954", "加治木",
"814222", "武蔵野三鷹",
"819435", "八女",
"815767", "下呂",
"818364", "宇部",
"818558", "川本",
"814229", "武蔵野三鷹",
"819664", "人吉",
"81584", "大垣",
"818555", "江津",
"818290", "広島",
"818203", "柳井",
"818567", "津和野",
"81998", "鹿児島",
"818382", "萩",
"818264", "安芸吉田",
"815732", "恵那",
"819682", "山鹿",
"812934", "高萩",
"819807", "沖縄宮古",
"812793", "渋川",
"8112396", "栗山",
"81778", "武生",
"8153974", "天竜",
"818680", "岡山",
"819542", "武雄",
"814280", "立川",
"81892", "久万",
"812545", "村上",
"818596", "米子",
"817614", "小松",
"818692", "邑久",
"811852", "男鹿",
"814798", "八日市場",
"81744", "大和高田",
"817998", "津名",
"812854", "小山",
"818202", "柳井",
"812674", "小諸",
"819728", "臼杵",
"814795", "銚子",
"814701", "鴨川",
"817995", "洲本",
"811939", "宮古",
"819725", "佐伯",
"811932", "釜石",
"814223", "武蔵野三鷹",
"81288", "今市",
"81124", "芦別",
"818976", "新居浜",
"8165", "大阪",
"8125483", "村上",
"818693", "邑久",
"818844", "阿南",
"811877", "大曲",
"81857", "鳥取",
"811853", "男鹿",
"81134", "小樽",
"814756", "東金",
"817956", "三田",
"819543", "武雄",
"812799", "長野原",
"811958", "岩手",
"8186993", "備前",
"81581", "高富",
"812792", "渋川",
"815585", "下田",
"81577", "高山",
"818383", "萩",
"811955", "二戸",
"815994", "阿児",
"812780", "前橋",
"815733", "恵那",
"819683", "山鹿",
"815588", "修善寺大仁",
"811646", "羽幌",
"815562", "鰍沢青柳",
"811336", "石狩",
"812855", "小山",
"812675", "佐久",
"811542", "釧路",
"817947", "三木",
"817733", "福知山",
"811392", "木古内",
"819724", "佐伯",
"819576", "島原",
"812858", "真岡",
"812678", "佐久",
"817994", "洲本",
"818372", "長門",
"814794", "銚子",
"8125487", "津川",
"819672", "熊本一の宮",
"811586", "中湧別",
"819679", "高森",
"811452", "早来",
"811549", "釧路",
"81486", "浦和",
"8186997", "岡山瀬戸",
"812977", "竜ケ崎",
"815956", "上野",
"817492", "彦根",
"81555", "吉田",
"818845", "丹生谷",
"812896", "鹿沼",
"812832", "佐野",
"818848", "牟岐",
"81240", "磐城富岡",
"817238", "寝屋川",
"81726", "茨木",
"81986", "都城",
"817960", "八鹿",
"815584", "下田",
"81544", "富士宮",
"8188091", "窪川",
"811236", "千歳",
"814771", "市川",
"81875", "観音寺",
"812839", "佐野",
"815998", "阿児",
"819933", "指宿",
"8188098", "土佐清水",
"819747", "竹田",
"818943", "八幡浜",
"817352", "新宮",
"811954", "二戸",
"815995", "阿児",
"812247", "大河原",
"8198298", "日向",
"819434", "八女",
"812911", "鉾田",
"819955", "加治木",
"819967", "出水",
"8198291", "延岡",
"811453", "早来",
"8186992", "備前",
"815754", "関",
"811393", "松前",
"817732", "福知山",
"819665", "人吉",
"818373", "長門",
"819673", "熊本一の宮",
"818365", "宇部",
"819668", "水俣",
"81963", "熊本",
"815563", "鰍沢青柳",
"812566", "三条",
"81934", "北九州",
"811543", "釧路",
"81578", "神岡",
"814996", "八丈島",
"81424", "武蔵野三鷹",
"81864", "倉敷",
"818368", "宇部",
"8125482", "村上",
"818554", "浜田",
"81833", "下松",
"819932", "指宿",
"811551", "十勝池田",
"817917", "竜野",
"818942", "八幡浜",
"817353", "新宮",
"81952", "佐賀",
"818265", "安芸吉田",
"812938", "水戸",
"818466", "木江",
"817726", "峰山",
"81924", "福岡",
"81434", "千葉",
"818268", "千代田",
"812935", "水戸",
"81823", "呉",
"811756", "野辺地",
"81463", "平塚",
"812833", "宇都宮",
"819940", "志布志",
"8147957", "八日市場",
"817618", "加賀",
"818949", "宇和",
"817493", "彦根",
"817615", "小松",
"812544", "新発田",
"819574", "諫早",
"819726", "臼杵",
"81724", "岸和田貝塚",
"81984", "小林",
"817996", "津名",
"812619", "大町",
"814796", "八日市場",
"811537", "中標津",
"811644", "留萌",
"818677", "新見",
"818873", "安芸",
"8188097", "土佐清水",
"81227", "仙台",
"818975", "新居浜",
"815954", "上野",
"811584", "遠軽",
"812233", "岩沼",
"81144", "苫小牧",
"812612", "大町",
"818978", "伯方",
"81546", "静岡",
"817940", "加古川",
"815392", "浜松",
"8198292", "延岡",
"817955", "三田",
"817967", "八鹿",
"814755", "東金",
"8186998", "岡山瀬戸",
"811562", "本別",
"817958", "丹波柏原",
"812643", "木曾福島",
"812894", "宇都宮",
"814758", "東金",
"81763", "福野",
"81734", "和歌山",
"8125481", "村上",
"81484", "川口",
"811956", "岩手",
"815586", "下田",
"8125488", "津川",
"819732", "日田",
"817717", "園部",
"811234", "千歳",
"812583", "長岡",
"817673", "羽咋",
"815399", "天竜",
"817487", "水口",
"81276", "太田",
"81436", "市原",
"812232", "岩沼",
"812613", "大町",
"818248", "庄原",
"81926", "福岡",
"815756", "郡上八幡",
"818245", "三次",
"81294", "常陸太田",
"818879", "室戸",
"818652", "倉敷",
"818872", "室戸",
"812564", "三条",
"814994", "三宅",
"818556", "江津",
"818490", "尾道",
"812239", "仙台",
"81797", "西宮",
"8188092", "窪川",
"818464", "竹原",
"817724", "宮津",
"819733", "日田",
"819947", "志布志",
"812582", "長岡",
"817672", "羽咋",
"811754", "むつ",
"81721", "富田林",
"81977", "別府",
"812649", "長野",
"81426", "八王子",
"8198297", "日向",
"811563", "本別",
"812642", "木曾福島",
"81178", "八戸",
"812546", "村上",
"818595", "米子",
"81936", "北九州",
"815393", "浜松",
"812589", "長岡",
"818598", "根雨",
"819956", "加治木",
"819823", "延岡",
"811732", "五所川原",
"818244", "三次",
"818297", "廿日市",
"812573", "柏崎",
"812557", "新井",
"817453", "大和高田",
"812565", "三条",
"817683", "輪島",
"818366", "宇部",
"814998", "小笠原",
"812568", "巻",
"81253", "新潟",
"8198293", "延岡",
"819666", "水俣",
"812936", "水戸",
"81262", "長野",
"818473", "甲山",
"815747", "美濃白川",
"818687", "美作",
"814287", "青梅",
"817725", "宮津",
"818266", "千代田",
"81944", "瀬高",
"81531", "田原",
"812992", "石岡",
"818802", "窪川",
"817728", "峰山",
"818594", "米子",
"817616", "小松",
"81184", "本荘",
"818547", "掛合",
"81586", "一宮",
"812999", "潮来",
"8199331", "鹿児島",
"811377", "八雲",
"811353", "余市",
"818397", "小郡",
"81228", "築館",
"81534", "浜松",
"81563", "西尾",
"819575", "諫早",
"811648", "焼尻",
"812572", "柏崎",
"817452", "大和高田",
"812676", "佐久",
"812856", "真岡",
"81559", "沼津",
"811645", "留萌",
"819578", "島原",
"817682", "輪島",
"817459", "大和榛原",
"815955", "上野",
"819822", "延岡",
"811733", "五所川原",
"811947", "久慈",
"818974", "新居浜",
"812579", "小出",
"811588", "興部",
"815958", "亀山",
"811585", "遠軽",
"81177", "青森",
"8188093", "窪川",
"814754", "茂原",
"812898", "鹿沼",
"817954", "西脇",
"811352", "余市",
"818479", "東城",
"81220", "迫",
"812417", "会津山口",
"812787", "沼田",
"818846", "丹生谷",
"812895", "宇都宮",
"815996", "阿児",
"81478", "佐原",
"812993", "石岡",
"818803", "土佐中村",
"81126", "岩見沢",
"811238", "栗山",
"81798", "西宮",
"818472", "甲山",
"811235", "夕張",
"81552", "甲府",
"81958", "長崎",
"8124197", "柳津",
"815974", "尾鷲",
"81225", "石巻",
"818955", "宇和島",
"812237", "仙台",
"8153960", "天竜",
"817904", "福崎",
"818958", "御荘",
"814704", "館山",
"81964", "松橋",
"81933", "北九州",
"8147955", "八日市場",
"819554", "伊万里",
"81863", "玉野",
"81423", "国分寺",
"818668", "井原",
"811533", "根室",
"81834", "徳山",
"818673", "福渡",
"81157", "北見",
"818877", "嶺北",
"818657", "笠岡",
"819913", "硫黄島",
"81242", "会津若松",
"818665", "高梁",
"81923", "福岡",
"811976", "北上",
"81433", "千葉",
"812384", "米沢",
"81464", "厚木",
"81852", "松江",
"819942", "大根占",
"81249", "郡山",
"817713", "亀岡",
"812587", "長岡",
"817677", "七尾",
"817483", "八日市",
"817963", "豊岡",
"819949", "大根占",
"81235", "鶴岡",
"814775", "船橋",
"81572", "多治見",
"812694", "中野",
"812647", "長野",
"811866", "鷹巣",
"818672", "福渡",
"812378", "寒河江",
"819912", "中之島",
"817464", "吉野",
"812375", "村山",
"81192", "大船渡",
"811636", "北見枝幸",
"811532", "根室",
"815366", "設楽",
"811539", "根室標津",
"812617", "大町",
"81766", "高岡",
"81950", "平戸",
"817706", "小浜",
"81273", "高崎",
"818679", "新見",
"815988", "三瀬谷",
"811567", "十勝清水",
"81886", "徳島",
"818838", "阿波池田",
"8178", "神戸",
"811555", "帯広",
"815397", "浜松",
"8125485", "津川",
"815985", "松阪",
"818835", "脇町",
"819784", "豊後高田",
"8125484", "村上",
"817962", "豊岡",
"811364", "倶知安",
"811558", "広尾",
"819737", "玖珠",
"817969", "浜坂",
"819943", "鹿屋",
"817712", "亀岡",
"812830", "宇都宮",
"811526", "網走",
"817482", "八日市",
"818794", "三本松",
"812476", "三春",
"8186995", "岡山瀬戸",
"81543", "静岡",
"81199", "盛岡",
"8186994", "岡山瀬戸",
"8169", "大阪",
"81975", "大分",
"812577", "六日町",
"817465", "吉野",
"812553", "上越",
"817457", "大和高田",
"817473", "五条",
"817687", "能都",
"812914", "鉾田",
"81743", "奈良",
"817468", "上北山",
"812374", "村山",
"811986", "遠野",
"818512", "西郷",
"819976", "名瀬",
"811466", "えりも",
"819827", "高千穂",
"811942", "岩泉",
"818293", "廿日市",
"811554", "帯広",
"818543", "安来",
"819788", "国東",
"812412", "喜多方",
"812782", "沼田",
"81566", "刈谷",
"811365", "倶知安",
"819785", "豊後高田",
"818834", "鴨島",
"811357", "岩内",
"815984", "松阪",
"818795", "三本松",
"812746", "富岡",
"818477", "東城",
"815743", "美濃加茂",
"818683", "津山",
"81282", "栃木",
"814283", "青梅",
"812789", "前橋",
"818798", "土庄",
"817366", "岩出",
"812419", "田島",
"814708", "大原",
"818954", "宇和島",
"811737", "鰺ケ沢",
"811943", "岩泉",
"817908", "播磨山崎",
"818292", "広島",
"812559", "安塚",
"814705", "館山",
"815978", "熊野",
"81492", "川越",
"817905", "福崎",
"81583", "岐阜",
"81898", "今治",
"814220", "国分寺",
"8153977", "天竜",
"819555", "唐津",
"818664", "高梁",
"818299", "広島",
"812552", "上越",
"819558", "唐津",
"812486", "須賀川",
"817472", "五条",
"812876", "黒磯",
"812656", "伊那",
"818690", "岡山",
"812997", "潮来",
"812385", "米沢",
"818807", "宿毛",
"818549", "石見大田",
"815742", "美濃加茂",
"812388", "長井",
"814282", "青梅",
"818682", "津山",
"8126177", "長野",
"818586", "倉吉",
"811372", "鹿部",
"819596", "福江",
"812698", "飯山",
"814289", "青梅",
"818689", "岡山",
"81779", "大野",
"81992", "鹿児島",
"812413", "喜多方",
"818542", "安来",
"812783", "沼田",
"812695", "中野",
"812376", "寒河江",
"811635", "浜頓別",
"811984", "花巻",
"81533", "豊橋",
"815368", "設楽",
"81564", "岡崎",
"81878", "高松",
"818207", "久賀",
"818563", "益田",
"811638", "利尻礼文",
"81166", "旭川",
"8144", "川崎",
"81979", "中津",
"81260", "阿南町",
"81792", "姫路",
"812570", "小出",
"817705", "小浜",
"811937", "宮古",
"819974", "屋久島",
"811464", "静内",
"815763", "下呂",
"818836", "脇町",
"815986", "松阪",
"811556", "帯広",
"811652", "士別",
"818892", "佐川",
"812478", "三春",
"811528", "美幌",
"817364", "和歌山橋本",
"812744", "藤岡",
"812475", "石川",
"819803", "名護",
"812797", "渋川",
"811525", "網走",
"81268", "上田",
"814227", "武蔵野三鷹",
"815762", "下呂",
"81245", "福島",
"818956", "宇和島",
"812964", "下館",
"81550", "御殿場",
"8112399", "栗山",
"818666", "井原",
"812484", "白河",
"818562", "益田",
"812654", "飯田",
"812874", "大田原",
"81222", "仙台",
"815769", "荘川",
"819802", "南大東",
"81561", "瀬戸",
"811978", "北上",
"818584", "倉吉",
"818387", "田万川",
"81229", "古川",
"811975", "水沢",
"815737", "中津川",
"819687", "玉名",
"811865", "大館",
"818697", "備前",
"814297", "飯能",
"811873", "角館",
"811653", "士別",
"818893", "佐川",
"811857", "能代",
"811868", "鷹巣",
"81183", "湯沢",
"814776", "船橋",
"8152", "名古屋",
"819594", "有川",
"819809", "八重山",
"819547", "鹿島",
"817906", "播磨山崎",
"812968", "笠間",
"819962", "川内",
"814706", "大原",
"8112390", "夕張",
"812242", "白石",
"812965", "下館",
"81466", "藤沢",
"812957", "大子",
"812973", "水海道",
"81495", "本庄",
"812655", "飯田",
"8198294", "延岡",
"81172", "弘前",
"812875", "大田原",
"812485", "白河",
"8198295", "日向",
"81775", "大津",
"812658", "伊那",
"819969", "中甑",
"817943", "加古川",
"812878", "烏山",
"817737", "舞鶴",
"819556", "唐津",
"812488", "須賀川",
"812230", "仙台",
"81877", "丸亀",
"818585", "倉吉",
"81179", "三戸",
"8167", "大阪",
"818588", "郡家",
"819937", "加世田",
"819743", "三重",
"817912", "相生",
"811974", "水沢",
"818947", "宇和",
"812386", "長井",
"812640", "長野",
"812696", "飯山",
"81557", "伊東",
"819598", "福江",
"811864", "大館",
"819595", "有川",
"812580", "十日町",
"811397", "奥尻",
"817942", "加古川",
"811634", "浜頓別",
"818377", "下関",
"819677", "矢部",
"812979", "竜ケ崎",
"81983", "高鍋",
"81723", "堺",
"811547", "白糠",
"817466", "十津川",
"817704", "敦賀",
"819978", "徳之島",
"81143", "室蘭",
"812243", "白石",
"812972", "水海道",
"819975", "名瀬",
"811465", "静内",
"819963", "川内",
"817949", "加古川",
"8111", "札幌",
"818493", "尾道",
"811457", "門別富川",
"81592", "津",
"812837", "佐野",
"819786", "杵築",
"811366", "寿都",
"8188095", "土佐清水",
"817497", "長浜",
"8188094", "窪川",
"819742", "三重",
"817365", "和歌山橋本",
"817357", "串本",
"812748", "富岡",
"81764", "富山",
"817368", "岩出",
"811524", "網走",
"818796", "土庄",
"812745", "藤岡",
"812474", "石川",
"812975", "水海道",
"81485", "熊谷",
"8188090", "窪川",
"81827", "岩国",
"81467", "藤沢",
"811946", "久慈",
"812963", "下館",
"8162", "大阪",
"812978", "竜ケ崎",
"819972", "種子島",
"811462", "浦河",
"819979", "徳之島",
"817945", "加古川",
"811982", "花巻",
"812483", "白河",
"812677", "佐久",
"812857", "真岡",
"812873", "大田原",
"812653", "飯田",
"817948", "三木",
"815997", "阿児",
"817362", "和歌山橋本",
"812742", "藤岡",
"817950", "三田",
"81742", "奈良",
"818583", "倉吉",
"819593", "大瀬戸",
"8163", "大阪",
"81725", "和泉",
"81985", "宮崎",
"812416", "田島",
"812786", "沼田",
"811654", "名寄",
"811874", "角館",
"818847", "牟岐",
"818894", "須崎",
"818240", "東広島",
"812556", "糸魚川",
"812482", "白河",
"817476", "下市",
"818564", "益田",
"812652", "飯田",
"812872", "大田原",
"818367", "宇部",
"811983", "花巻",
"819667", "水俣",
"819965", "川内",
"819957", "加治木",
"812248", "大河原",
"819973", "種子島",
"815764", "下呂",
"811463", "浦河",
"812489", "須賀川",
"812659", "伊那",
"819968", "出水",
"812879", "烏山",
"812962", "下館",
"818296", "広島",
"812245", "大河原",
"817617", "加賀",
"818546", "掛合",
"81266", "諏訪",
"8112394", "夕張",
"811376", "八雲",
"81493", "東松山",
"819592", "大瀬戸",
"8112395", "栗山",
"812937", "水戸",
"812743", "藤岡",
"819599", "大瀬戸",
"819804", "名護",
"81582", "岐阜",
"815746", "美濃加茂",
"818686", "津山",
"814286", "相模原",
"818582", "倉吉",
"818267", "千代田",
"8198290", "延岡",
"817363", "和歌山橋本",
"817915", "相生",
"81939", "北九州",
"818565", "益田",
"81922", "福岡",
"81432", "千葉",
"81167", "富良野",
"818557", "川本",
"81429", "所沢",
"81853", "出雲",
"818568", "津和野",
"815363", "新城",
"815765", "下呂",
"819437", "田主丸",
"819964", "川内",
"815757", "郡上八幡",
"815768", "下呂",
"817703", "敦賀",
"812244", "白石",
"812571", "六日町",
"812560", "糸魚川",
"8124196", "柳津",
"812547", "村上",
"811862", "鹿角",
"8198299", "日向",
"81828", "広島",
"81468", "横須賀",
"81929", "福岡",
"819946", "鹿屋",
"81932", "北九州",
"81862", "岡山",
"811523", "斜里",
"81439", "木更津",
"819805", "名護",
"812473", "石川",
"811869", "大館",
"817914", "相生",
"81243", "二本松",
"811972", "水沢",
"819808", "八重山",
"817702", "敦賀",
"812974", "水海道",
"811639", "利尻礼文",
"817944", "加古川",
"811632", "天塩",
"819727", "臼杵",
"817997", "津名",
"8188099", "土佐清水",
"8186691", "倉敷",
"814797", "八日市場",
"811536", "厚岸",
"8182941", "広島",
"815362", "新城",
"818676", "久世",
"81542", "静岡",
"8186698", "倉敷",
"819744", "三重",
"811973", "水沢",
"812890", "宇都宮",
"811957", "岩手",
"815587", "修善寺大仁",
"817716", "園部",
"81549", "静岡",
"817486", "水口",
"811522", "斜里",
"812472", "石川",
"811658", "上川",
"811878", "大曲",
"81535", "浜松",
"817966", "八鹿",
"818895", "須崎",
"811655", "名寄",
"81272", "前橋",
"811875", "角館",
"81460", "小田原",
"811863", "鹿角",
"814709", "鴨川",
"819552", "伊万里",
"812558", "新井",
"815979", "熊野",
"817475", "下市",
"812567", "巻",
"817463", "吉野",
"8161", "大阪",
"812555", "糸魚川",
"812246", "大河原",
"818295", "廿日市",
"815972", "尾鷲",
"818298", "廿日市",
"817902", "福崎",
"819966", "出水",
"814702", "館山",
"81956", "佐世保",
"811375", "八雲",
"81292", "水戸",
"819783", "豊後高田",
"818548", "石見大田",
"811363", "倶知安",
"818398", "小郡",
"812692", "中野",
"812389", "米沢",
"811378", "今金",
"81567", "津島",
"81585", "揖斐川",
"818545", "木次",
"817916", "竜野",
"814288", "青梅",
"818688", "美作",
"815748", "美濃白川",
"812382", "米沢",
"817727", "峰山",
"8182942", "広島",
"818467", "木江",
"819944", "鹿屋",
"815745", "美濃加茂",
"814285", "相模原",
"818685", "津山",
"818793", "三本松",
"811757", "野辺地",
"81593", "四日市",
"811587", "中湧別",
"817903", "福崎",
"81888", "高知",
"8186999", "岡山瀬戸",
"814703", "館山",
"8164", "大阪",
"815973", "尾鷲",
"811945", "久慈",
"812976", "竜ケ崎",
"815957", "上野",
"818674", "久世",
"811647", "羽幌",
"811337", "石狩",
"8128798", "大田原",
"8125489", "津川",
"819208", "対馬佐賀",
"817946", "三木",
"81989", "那覇",
"81729", "八尾",
"819577", "島原",
"819553", "伊万里",
"81482", "川口",
"811534", "中標津",
"819205", "厳原",
"819789", "杵築",
"811237", "栗山",
"817714", "亀岡",
"817484", "八日市",
"818792", "三本松",
"819746", "竹田",
"81739", "田辺",
"8186697", "倉敷",
"81722", "堺",
"81125", "滝川",
"812383", "米沢",
"814291", "飯能",
"81489", "草加",
"812693", "中野",
"81142", "伊達",
"812785", "沼田",
"812897", "鹿沼",
"812415", "柳津",
"812788", "前橋",
"812418", "会津山口",
"819782", "豊後高田",
"817964", "豊岡",
"811362", "倶知安",
"818514", "海士",
"8125480", "村上",
"81545", "富士",
"8182943", "広島",
"81568", "春日井",
"818953", "宇和島",
"811944", "岩泉",
"818977", "伯方",
"81250", "新津",
"811538", "根室標津",
"818663", "総社",
"81554", "大月",
"818675", "久世",
"819204", "郷ノ浦",
"811535", "厚岸",
"812372", "村山",
"818678", "新見",
"817485", "八日市",
"817715", "亀岡",
"8199345", "鹿児島",
"81532", "豊橋",
"817488", "水口",
"817230", "寝屋川",
"811559", "帯広",
"817718", "園部",
"811552", "帯広",
"817968", "浜坂",
"812414", "柳津",
"81793", "姫路",
"812784", "沼田",
"811876", "大曲",
"811656", "美深",
"81473", "市川",
"818896", "須崎",
"814757", "東金",
"817965", "豊岡",
"818832", "鴨島",
"817957", "丹波柏原",
"815982", "松阪",
"812913", "鉾田",
"81942", "久留米",
"812373", "村山",
"81233", "新庄",
"818662", "高梁",
"812554", "上越",
"817474", "五条",
"818952", "宇和島",
"818247", "庄原",
"818669", "総社",
"811541", "弟子屈",
"818294", "廿日市",
"81182", "横手",
"818360", "小郡",
"81925", "福岡",
"815766", "下呂",
"814772", "市川",
"818833", "鴨島",
"811374", "森",
"812930", "水戸",
"815983", "松阪",
"81425", "立川",
"818597", "根雨",
"811553", "帯広",
"818544", "木次",
"81848", "尾道",
"81935", "北九州",
"8168", "大阪",
"81949", "直方",
"81896", "伊予三島",
"819948", "志布志",
"819806", "沖縄宮古",
"815744", "美濃加茂",
"8147950", "八日市場",
"814284", "立川",
"818684", "津山",
"81551", "韮崎",
"819945", "鹿屋",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+81|\D)//g;
      my $self = bless({ country_code => '81', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      my $prefix = qr/^(?:(000[259]\d{6})$|(?:(?:003768)0?)|0)/;
      my @matches = $number =~ /$prefix/;
      if (defined $matches[-1]) {
        no warnings 'uninitialized';
        $number =~ s/$prefix/$1/;
      }
      else {
        $number =~ s/$prefix//;
      }
      $self = bless({ country_code => '81', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;