# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JP;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230113181719;

my $formatters = [
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '00777[01]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            (?:
              12|
              57|
              99
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              267|
              3(?:
                7[247]|
                9[278]
              )|
              466|
              5(?:
                47|
                58|
                64
              )|
              6(?:
                3[245]|
                48|
                5[4-68]
              )
            )|
            499[2468]|
            5(?:
              769|
              979[2-69]
            )|
            7468|
            8(?:
              3(?:
                8[7-9]|
                96[2457-9]
              )|
              477|
              51[2-9]|
              636[457-9]
            )|
            9(?:
              802|
              9(?:
                1[23]|
                69
              )
            )|
            1(?:
              45|
              58
            )[67]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d)(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '60',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [36]|
            4(?:
              2(?:
                0|
                9[02-69]
              )|
              7(?:
                0[019]|
                1
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              1|
              5(?:
                4[018]|
                5[017]
              )|
              77|
              88|
              9[69]
            )|
            2(?:
              2[127]|
              3[0-269]|
              4[59]|
              5(?:
                [1-3]|
                5[0-69]|
                7[015-9]|
                9(?:
                  17|
                  99
                )
              )|
              6(?:
                2|
                4[016-9]
              )|
              7(?:
                [1-35]|
                8[0189]
              )|
              8(?:
                [16]|
                3[0134]|
                9[0-5]
              )|
              9(?:
                [028]|
                17|
                3[015-9]
              )
            )|
            4(?:
              2(?:
                [13-79]|
                8[014-6]
              )|
              3[0-57]|
              [45]|
              6[248]|
              7[2-47]|
              9[29]
            )|
            5(?:
              2|
              3[045]|
              4[0-369]|
              5[29]|
              8[02389]|
              9[0-3]
            )|
            7(?:
              2[02-46-9]|
              34|
              [58]|
              6[0249]|
              7[57]|
              9(?:
                [23]|
                4[0-59]|
                5[01569]|
                6[0167]
              )
            )|
            8(?:
              2(?:
                [1258]|
                4[0-39]|
                9(?:
                  [019]|
                  4[1-3]|
                  6(?:
                    [0-47-9]|
                    5[01346-9]
                  )
                )
              )|
              3(?:
                [29]|
                7(?:
                  [017-9]|
                  6[6-8]
                )
              )|
              49|
              51|
              6(?:
                [0-24]|
                36[23]|
                5(?:
                  [0-389]|
                  5[23]
                )|
                6(?:
                  [01]|
                  9[178]
                )|
                72|
                9[0145]
              )|
              7[0-468]|
              8[68]
            )|
            9(?:
              4[15]|
              5[138]|
              6[1-3]|
              7[156]|
              8[189]|
              9(?:
                [1289]|
                3(?:
                  31|
                  4[357]
                )|
                4[0178]
              )
            )|
            (?:
              223|
              8699
            )[014-9]|
            (?:
              25[0468]|
              422|
              838
            )[01]|
            (?:
              48|
              829(?:
                2|
                66
              )|
              9[23]
            )[1-9]|
            (?:
              47[59]|
              59[89]|
              8(?:
                68|
                9
              )
            )[019]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [14]|
            [289][2-9]|
            5[3-9]|
            7[2-4679]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '0077',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '008',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '[257-9]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{4,5})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{5})(\\d{5,6})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{6})(\\d{6,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'geographic' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'mobile' => '[7-9]0[1-9]\\d{7}',
                'pager' => '20\\d{8}',
                'personal_number' => '60\\d{7}',
                'specialrate' => '(990\\d{6})|(570\\d{6})',
                'toll_free' => '
          00777(?:
            [01]|
            5\\d
          )\\d\\d|
          (?:
            00(?:
              7778|
              882[1245]
            )|
            (?:
              120|
              800\\d
            )\\d\\d
          )\\d{4}|
          00(?:
            37|
            66|
            78
          )\\d{6,13}
        ',
                'voip' => '50[1-9]\\d{7}'
              };
my %areanames = ();
$areanames{en} = {"81298", "Tsuchiura\,\ Ibaraki",
"818376", "Mine\,\ Yamaguchi",
"812693", "Nakano\,\ Nagano",
"818677", "Niimi\,\ Okayama",
"817714", "Kameoka\,\ Kyoto",
"818476", "Fuchu\,\ Hiroshima",
"818656", "Kasaoka\,\ Okayama",
"81559", "Numazu\,\ Shizuoka",
"817494", "Hikone\,\ Shiga",
"819952", "Okuchi\,\ Kagoshima",
"812836", "Sano\,\ Tochigi",
"815745", "Minokamo\,\ Gifu",
"817618", "Kaga\,\ Ishikawa",
"818562", "Masuda\,\ Shimane",
"817465", "Yoshino\,\ Nara",
"81987", "Nichinan\,\ Miyazaki",
"812613", "Omachi\,\ Nagano",
"8198291", "Nobeoka\,\ Miyazaki",
"81551", "Nirasaki\,\ Yamanashi",
"819827", "Takachiho\,\ Miyazaki",
"814287", "Ome\,\ Tokyo",
"818246", "Miyoshi\,\ Hiroshima",
"8198299", "Hyuga\,\ Miyazaki",
"815754", "Sekigahara\,\ Gifu",
"812935", "Mito\,\ Ibaraki",
"818387", "Tamagawa\,\ Yamaguchi",
"818686", "Tsuyama\,\ Okayama",
"81143", "Muroran\,\ Hokkaido",
"812872", "Otawara\,\ Tochigi",
"819665", "Hitoyoshi\,\ Kumamoto",
"81862", "Okayama\,\ Okayama",
"811455", "Mukawa\,\ Hokkaido",
"812572", "Kashiwazaki\,\ Niigata",
"819937", "Kaseda\,\ Kagoshima",
"81557", "Ito\,\ Shizuoka",
"817705", "Obama\,\ Fukui",
"8186999", "Seto\,\ Okayama",
"812646", "Nagano\,\ Nagano",
"818697", "Bizen\,\ Okayama",
"812673", "Komoro\,\ Nagano",
"81587", "Ichinomiya\,\ Aichi",
"819688", "Tamana\,\ Kumamoto",
"817969", "Hamasaka\,\ Hyogo",
"811523", "Shari\,\ Hokkaido",
"817678", "Nanao\,\ Ishikawa",
"8166", "Osaka\,\ Osaka",
"811933", "Kamaishi\,\ Iwate",
"8182942", "Hiroshima\,\ Hiroshima",
"819784", "Bungotakada\,\ Oita",
"818796", "Tonosho\,\ Kagawa",
"812747", "Tomioka\,\ Gunma",
"81222", "Sendai\,\ Miyagi",
"81723", "Sakai\,\ Osaka",
"81989", "Naha\,\ Okinawa",
"817992", "Sumoto\,\ Hyogo",
"811942", "Iwaizumi\,\ Iwate",
"817488", "Minakuchi\,\ Shiga",
"818293", "Hatsukaichi\,\ Hiroshima",
"812383", "Yonezawa\,\ Yamagata",
"817684", "Wajima\,\ Ishikawa",
"812483", "Shirakawa\,\ Fukushima",
"818663", "Soja\,\ Okayama",
"814793", "Choshi\,\ Chiba",
"812783", "Numata\,\ Gunma",
"817912", "Aioi\,\ Hyogo",
"815398", "Hamamatsu\,\ Shizuoka",
"815982", "Matsusaka\,\ Mie",
"812892", "Utsunomiya\,\ Tochigi",
"818879", "Muroto\,\ Kochi",
"812545", "Murakami\,\ Niigata",
"81828", "Hiroshima\,\ Hiroshima",
"81864", "Kurashiki\,\ Okayama",
"81438", "Kisarazu\,\ Chiba",
"81249", "Koriyama\,\ Fukushima",
"819940", "Shibushi\,\ Kagoshima",
"819974", "Yakushima\,\ Kagoshima",
"819553", "Imari\,\ Saga",
"812584", "Nagaoka\,\ Niigata",
"81478", "Sawara\,\ Chiba",
"8112399", "Kuriyama\,\ Hokkaido",
"815994", "Ago\,\ Mie",
"819547", "Kashima\,\ Saga",
"811237", "Kuriyama\,\ Hokkaido",
"815736", "Nakatsugawa\,\ Gifu",
"817612", "Komatsu\,\ Ishikawa",
"818568", "Tsuwano\,\ Shimane",
"817945", "Kakogawa\,\ Hyogo",
"81420", "Tokorozawa\,\ Saitama",
"817954", "Nishiwaki\,\ Hyogo",
"81467", "Fujisawa\,\ Kanagawa",
"815566", "Minobu\,\ Yamanashi",
"8186697", "Kurashiki\,\ Okayama",
"8112391", "Yubari\,\ Hokkaido",
"81825", "Hiroshima\,\ Hiroshima",
"8169", "Osaka\,\ Osaka",
"812878", "Nasukarasuyama\,\ Tochigi",
"812578", "Muika\,\ Niigata",
"812554", "Joetsu\,\ Niigata",
"8126173", "Omachi\,\ Nagano",
"812854", "Oyama\,\ Tochigi",
"819682", "Yamaga\,\ Kumamoto",
"81853", "Izumo\,\ Shimane",
"817352", "Shingu\,\ Fukuoka",
"815769", "Shokawa\,\ Gifu",
"817672", "Hakui\,\ Ishikawa",
"817452", "Yamatotakada\,\ Nara",
"818555", "Gotsu\,\ Shimane",
"812967", "Kasama\,\ Ibaraki",
"8126174", "Omachi\,\ Nagano",
"811532", "Nemuro\,\ Hokkaido",
"815974", "Owase\,\ Mie",
"812560", "Itoigawa\,\ Niigata",
"811587", "Nakayubetsu\,\ Hokkaido",
"818808", "Tosashimizu\,\ Kochi",
"81277", "Kiryu\,\ Gunma",
"812234", "Sendai\,\ Miyagi",
"819965", "Satsumasendai\,\ Kagoshima",
"81892", "Kumakogen\,\ Ehime",
"815958", "Kameyama\,\ Mie",
"811975", "Mizusawa\,\ Iwate",
"812993", "Ishioka\,\ Ibaraki",
"81268", "Ueda\,\ Nagano",
"818977", "Hakata\,\ Ehime",
"818956", "Uwajima\,\ Ehime",
"815583", "Shimoda\,\ Shizuoka",
"811362", "Kutchan\,\ Hokkaido",
"81426", "Hachioji\,\ Tokyo",
"817998", "Tsuna\,\ Hyogo",
"811462", "Urakawa\,\ Hokkaido",
"817737", "Maizuru\,\ Kyoto",
"8183766", "Shimonoseki\,\ Yamaguchi",
"818585", "Kurayoshi\,\ Tottori",
"817482", "Yokaichi\,\ Shiga",
"815392", "Hamamatsu\,\ Shizuoka",
"812898", "Kanuma\,\ Tochigi",
"811876", "Omagari\,\ Akita",
"812913", "Hokota\,\ Ibaraki",
"818544", "Kisuki\,\ Shimane",
"811857", "Noshiro\,\ Akita",
"818844", "Anan\,\ Tokushima",
"811543", "Kushiro\,\ Hokkaido",
"819233", "Maebaru\,\ Fukuoka",
"819725", "Saiki\,\ Oita",
"812895", "Utsunomiya\,\ Tochigi",
"819733", "Hita\,\ Oita",
"815985", "Matsusaka\,\ Mie",
"817915", "Aioi\,\ Hyogo",
"81234", "Sakata\,\ Yamagata",
"819728", "Usuki\,\ Oita",
"811984", "Hanamaki\,\ Iwate",
"81244", "Hobara\,\ Fukushima",
"81436", "Ichihara\,\ Chiba",
"817964", "Toyooka\,\ Hyogo",
"812230", "Sendai\,\ Miyagi",
"812564", "Sanjo\,\ Niigata",
"81476", "Narita\,\ Chiba",
"819597", "Fukue\,\ Nagasaki",
"811945", "Kuji\,\ Iwate",
"818588", "Koge\,\ Tottori",
"8126178", "Omachi\,\ Nagano",
"819433", "Yame\,\ Fukuoka",
"819789", "Kitsuki\,\ Oita",
"817995", "Sumoto\,\ Hyogo",
"818953", "Uwajima\,\ Ehime",
"815586", "Shimoda\,\ Shizuoka",
"812996", "Itako\,\ Ibaraki",
"818947", "Uwajima\,\ Ehime",
"811954", "Ninohe\,\ Iwate",
"817724", "Miyazu\,\ Kyoto",
"811978", "Kitakami\,\ Iwate",
"819679", "Takamori\,\ Kumamoto",
"81227", "Sendai\,\ Miyagi",
"819968", "Izumi\,\ Kagoshima",
"81260", "Anan\,\ Nagano",
"81593", "Yokkaichi\,\ Mie",
"81582", "Gifu\,\ Gifu",
"818558", "Kawamoto\,\ Shimane",
"81492", "Kawagoe\,\ Saitama",
"819742", "Mie\,\ Oita",
"8153969", "Hamamatsu\,\ Shizuoka",
"81552", "Kofu\,\ Yamanashi",
"811546", "Kushiro\,\ Hokkaido",
"8128798", "Otawara\,\ Tochigi",
"818874", "Aki\,\ Kochi",
"811873", "Kakunodate\,\ Akita",
"817702", "Tsuruga\,\ Fukui",
"811452", "Hayakita\,\ Hokkaido",
"812575", "Tokamachi\,\ Niigata",
"812875", "Otawara\,\ Tochigi",
"819662", "Hitoyoshi\,\ Kumamoto",
"811352", "Yoichi\,\ Hokkaido",
"817904", "Fukusaki\,\ Hyogo",
"81425", "Tachikawa\,\ Tokyo",
"819944", "Kanoya\,\ Kagoshima",
"81835", "Hofu\,\ Yamaguchi",
"81845", "Innoshima\,\ Hiroshima",
"812932", "Takahagi\,\ Ibaraki",
"81875", "Kan\'onji\,\ Kagawa",
"811867", "Takanosu\,\ Akita",
"819577", "Shimabara\,\ Nagasaki",
"819556", "Karatsu\,\ Saga",
"812580", "Tokamachi\,\ Niigata",
"8188098", "Tosashimizu\,\ Kochi",
"8153970", "Hamamatsu\,\ Shizuoka",
"815733", "Ena\,\ Gifu",
"811752", "Mutsu\,\ Aomori",
"818514", "Ama\,\ Shimane",
"81464", "Atsugi\,\ Kanagawa",
"81266", "Suwa\,\ Nagano",
"817950", "Sanda\,\ Hyogo",
"81848", "Onomichi\,\ Hiroshima",
"812957", "Daigo\,\ Ibaraki",
"81952", "Saga\,\ Saga",
"817948", "Miki\,\ Hyogo",
"818565", "Masuda\,\ Shimane",
"815742", "Minokamo\,\ Gifu",
"819803", "Nago\,\ Okinawa",
"811337", "Ishikari\,\ Hokkaido",
"819955", "Kajiki\,\ Kagoshima",
"81878", "Takamatsu\,\ Kagawa",
"818594", "Yonago\,\ Tottori",
"818894", "Susaki\,\ Kochi",
"812550", "Yasuzuka\,\ Niigata",
"815764", "Gero\,\ Gifu",
"81584", "Ogaki\,\ Gifu",
"812377", "Sagae\,\ Yamagata",
"81494", "Chichibu\,\ Saitama",
"819722", "Saiki\,\ Oita",
"812676", "Saku\,\ Nagano",
"8153972", "Hamamatsu\,\ Shizuoka",
"811394", "Matsumae\,\ Hokkaido",
"812477", "Miharu\,\ Fukushima",
"818493", "Onomichi\,\ Hiroshima",
"812657", "Ina\,\ Nagano",
"81554", "Otsuki\,\ Yamanashi",
"811526", "Abashiri\,\ Hokkaido",
"815395", "Hamamatsu\,\ Shizuoka",
"811936", "Miyako\,\ Iwate",
"81963", "Kumamoto\,\ Kumamoto",
"811465", "Shizunai\,\ Hokkaido",
"812239", "Sendai\,\ Miyagi",
"818582", "Kurayoshi\,\ Tottori",
"817485", "Yokaichi\,\ Shiga",
"815979", "Kumano\,\ Mie",
"811365", "Kutchan\,\ Hokkaido",
"8126175", "Omachi\,\ Nagano",
"81188", "Akita\,\ Akita",
"8125486", "Tsugawa\,\ Niigata",
"811972", "Mizusawa\,\ Iwate",
"81272", "Maebashi\,\ Gunma",
"818296", "Hiroshima\,\ Hiroshima",
"812247", "Ogawara\,\ Miyagi",
"819962", "Satsumasendai\,\ Kagoshima",
"812486", "Sukagawa\,\ Fukushima",
"818367", "Ube\,\ Yamaguchi",
"818666", "Ibara\,\ Okayama",
"812386", "Nagai\,\ Yamagata",
"818467", "Mima\,\ Tokushima",
"811535", "Akkeshi\,\ Hokkaido",
"814796", "Yokaichiba\,\ Chiba",
"812786", "Numata\,\ Gunma",
"817675", "Nanao\,\ Ishikawa",
"818552", "Hamada\,\ Shimane",
"817455", "Yamatotakada\,\ Nara",
"81242", "Aizuwakamatsu\,\ Fukushima",
"819685", "Tamana\,\ Kumamoto",
"817355", "Shingu\,\ Fukuoka",
"81743", "Nara\,\ Nara",
"811374", "Mori\,\ Hokkaido",
"818373", "Nagato\,\ Yamaguchi",
"811654", "Nayoro\,\ Hokkaido",
"812696", "Iiyama\,\ Nagano",
"819979", "Tokunoshima\,\ Kagoshima",
"819668", "Minamata\,\ Kumamoto",
"81563", "Nishio\,\ Aichi",
"812833", "Utsunomiya\,\ Tochigi",
"815999", "Tsu\,\ Mie",
"81462", "Atsugi\,\ Kanagawa",
"812589", "Nagaoka\,\ Niigata",
"8188095", "Tosashimizu\,\ Kochi",
"812938", "Mito\,\ Ibaraki",
"812551", "Joetsu\,\ Niigata",
"812797", "Shibukawa\,\ Gunma",
"81984", "Kobayashi\,\ Miyazaki",
"812616", "Omachi\,\ Nagano",
"817942", "Kakogawa\,\ Hyogo",
"817468", "Kamikitayama\,\ Nara",
"817615", "Komatsu\,\ Ishikawa",
"818243", "Higashi\-ku\,\ Hiroshima",
"817959", "Sanda\,\ Hyogo",
"817368", "Iwade\,\ Wakayama",
"81899", "Matsuyama\,\ Ehime",
"818683", "Tsuyama\,\ Okayama",
"814776", "Funabashi\,\ Chiba",
"814757", "Togane\,\ Chiba",
"811645", "Rumoi\,\ Hokkaido",
"812542", "Shibata\,\ Niigata",
"812859", "Oyama\,\ Tochigi",
"812559", "Yasuzuka\,\ Niigata",
"817686", "Noto\,\ Ishikawa",
"811367", "Suttsu\,\ Hokkaido",
"817732", "Fukuchiyama\,\ Kyoto",
"817487", "Minakuchi\,\ Shiga",
"818660", "Seto\,\ Okayama",
"819676", "Takamori\,\ Kumamoto",
"812999", "Itako\,\ Ibaraki",
"818972", "Niihama\,\ Ehime",
"8186993", "Bizen\,\ Okayama",
"818290", "Hiroshima\,\ Hiroshima",
"812655", "Iida\,\ Nagano",
"811552", "Obihiro\,\ Hokkaido",
"812475", "Ishikawa\,\ Fukushima",
"811549", "Kushiro\,\ Hokkaido",
"81263", "Matsumoto\,\ Nagano",
"81762", "Kanazawa\,\ Ishikawa",
"812375", "Murayama\,\ Yamagata",
"811852", "Oga\,\ Akita",
"81480", "Kuki\,\ Saitama",
"81885", "Komatsushima\,\ Tokushima",
"812780", "Maebashi\,\ Gunma",
"818835", "Mima\,\ Tokushima",
"8198294", "Nobeoka\,\ Miyazaki",
"8199345", "Kagoshima\,\ Kagoshima",
"812962", "Shimodate\,\ Ibaraki",
"811537", "Nakashibetsu\,\ Hokkaido",
"818698", "Bizen\,\ Okayama",
"817476", "Shimonoseki\,\ Yamaguchi",
"817357", "Kushimoto\,\ Wakayama",
"811393", "Matsumae\,\ Hokkaido",
"819687", "Tamana\,\ Kumamoto",
"817457", "Yamatotakada\,\ Nara",
"815763", "Gero\,\ Gifu",
"817677", "Nanao\,\ Ishikawa",
"8183767", "Shimonoseki\,\ Yamaguchi",
"81888", "Kochi\,\ Kochi",
"811541", "Teshikaga\,\ Hokkaido",
"819786", "Kitsuki\,\ Oita",
"812245", "Ogawara\,\ Miyagi",
"812911", "Hokota\,\ Ibaraki",
"815363", "Shinshiro\,\ Aichi",
"8125480", "Murakami\,\ Niigata",
"811582", "Monbetsu\,\ Hokkaido",
"81942", "Kurume\,\ Fukuoka",
"81932", "Kitakyushu\,\ Fukuoka",
"818365", "Ube\,\ Yamaguchi",
"812748", "Tomioka\,\ Gunma",
"81199", "Morioka\,\ Iwate",
"819828", "Takachiho\,\ Miyazaki",
"814288", "Ome\,\ Tokyo",
"818684", "Tsuyama\,\ Okayama",
"812795", "Shibukawa\,\ Gunma",
"818244", "Miyoshi\,\ Hiroshima",
"812415", "Yanaizu\,\ Fukushima",
"818388", "Tamagawa\,\ Yamaguchi",
"8153965", "Hamamatsu\,\ Shizuoka",
"81191", "Ichinoseki\,\ Iwate",
"81284", "Ashikaga\,\ Tochigi",
"81486", "Urawa\,\ Saitama",
"819938", "Kaseda\,\ Kagoshima",
"81596", "Ise\,\ Mie",
"814770", "Ichikawa\,\ Chiba",
"814755", "Togane\,\ Chiba",
"818678", "Niimi\,\ Okayama",
"812834", "Utsunomiya\,\ Tochigi",
"81532", "Toyohashi\,\ Aichi",
"81473", "Ichikawa\,\ Chiba",
"81542", "Shizuoka\,\ Shizuoka",
"814240", "Kokubunji\,\ Tokyo",
"811653", "Shibetsu\,\ Hokkaido",
"818374", "Nagato\,\ Yamaguchi",
"817716", "Sonobe\,\ Kyoto",
"8147955", "Yokaichiba\,\ Chiba",
"8198293", "Nobeoka\,\ Miyazaki",
"818474", "Fuchu\,\ Hiroshima",
"817496", "Nagahama\,\ Shiga",
"818654", "Kamogata\,\ Okayama",
"811647", "Haboro\,\ Hokkaido",
"81823", "Kure\,\ Hiroshima",
"817617", "Kaga\,\ Ishikawa",
"81572", "Tajimi\,\ Gifu",
"8186994", "Seto\,\ Okayama",
"811232", "Chitose\,\ Hokkaido",
"819542", "Takeo\,\ Saga",
"81433", "Chiba\,\ Chiba",
"812389", "Yonezawa\,\ Yamagata",
"818978", "Hakata\,\ Ehime",
"81725", "Izumi\,\ Osaka",
"81740", "Imazu\,\ Shiga",
"817723", "Miyazu\,\ Kyoto",
"812489", "Sukagawa\,\ Fukushima",
"818669", "Soja\,\ Okayama",
"81944", "Setaka\,\ Fukuoka",
"817997", "Tsuna\,\ Hyogo",
"811953", "Ninohe\,\ Iwate",
"817738", "Maizuru\,\ Kyoto",
"81934", "Kitakyushu\,\ Fukuoka",
"818299", "Hiroshima\,\ Hiroshima",
"811947", "Kuji\,\ Iwate",
"818954", "Uwajima\,\ Ehime",
"811874", "Kakunodate\,\ Akita",
"818546", "Kakeya\,\ Shimane",
"812897", "Kanuma\,\ Tochigi",
"818873", "Aki\,\ Kochi",
"811558", "Hiroo\,\ Hokkaido",
"812789", "Maebashi\,\ Gunma",
"811858", "Noshiro\,\ Akita",
"811983", "Hanamaki\,\ Iwate",
"817963", "Toyooka\,\ Hyogo",
"818262", "Kake\,\ Hiroshima",
"81764", "Toyama\,\ Toyama",
"81126", "Iwamizawa\,\ Hokkaido",
"812968", "Kasama\,\ Ibaraki",
"8112394", "Yubari\,\ Hokkaido",
"81728", "Neyagawa\,\ Osaka",
"81927", "Fukuoka\,\ Fukuoka",
"819734", "Hita\,\ Oita",
"818692", "Oku\,\ Okayama",
"812679", "Saku\,\ Nagano",
"818807", "Sukumo\,\ Kochi",
"819434", "Yame\,\ Fukuoka",
"811588", "Okoppe\,\ Hokkaido",
"818945", "Yawatahama\,\ Ehime",
"8188099", "Tosashimizu\,\ Kochi",
"812742", "Fujioka\,\ Gunma",
"812563", "Sanjo\,\ Niigata",
"812236", "Sendai\,\ Miyagi",
"811939", "Miyako\,\ Iwate",
"81566", "Kariya\,\ Aichi",
"819575", "Isahaya\,\ Nagasaki",
"818382", "Hagi\,\ Yamaguchi",
"811865", "Odate\,\ Akita",
"8126171", "Omachi\,\ Nagano",
"81138", "Hakodate\,\ Hokkaido",
"819822", "Nobeoka\,\ Miyazaki",
"817956", "Sanda\,\ Hyogo",
"814282", "Ome\,\ Tokyo",
"81776", "Fukui\,\ Fukui",
"818893", "Sakawa\,\ Kochi",
"812556", "Itoigawa\,\ Niigata",
"81534", "Hamamatsu\,\ Shizuoka",
"81178", "Hachinohe\,\ Aomori",
"812877", "Kuroiso\,\ Tochigi",
"812577", "Muika\,\ Niigata",
"819932", "Ibusuki\,\ Kagoshima",
"812856", "Mooka\,\ Tochigi",
"81544", "Fujinomiya\,\ Shizuoka",
"814220", "Kokubunji\,\ Tokyo",
"818593", "Yonago\,\ Tottori",
"8153968", "Hamamatsu\,\ Shizuoka",
"8112393", "Yubari\,\ Hokkaido",
"819804", "Nago\,\ Okinawa",
"819957", "Kajiki\,\ Kagoshima",
"819943", "Kanoya\,\ Kagoshima",
"81167", "Furano\,\ Hokkaido",
"819976", "Naze\,\ Kagoshima",
"817903", "Fukusaki\,\ Hyogo",
"81929", "Fukuoka\,\ Fukuoka",
"81282", "Tochigi\,\ Tochigi",
"818202", "Yanai\,\ Yamaguchi",
"81252", "Niigata\,\ Niigata",
"8199331", "Kagoshima\,\ Kagoshima",
"8125482", "Murakami\,\ Niigata",
"8186553", "Kurashiki\,\ Okayama",
"812955", "Hitachi\-Omiya\,\ Ibaraki",
"815734", "Ena\,\ Gifu",
"8153976", "Hamamatsu\,\ Shizuoka",
"812619", "Omachi\,\ Nagano",
"8126179", "Omachi\,\ Nagano",
"811238", "Kuriyama\,\ Hokkaido",
"81792", "Himeji\,\ Hyogo",
"812586", "Nagaoka\,\ Niigata",
"8152", "Nagoya\,\ Aichi",
"814702", "Tateyama\,\ Chiba",
"814771", "Ichikawa\,\ Chiba",
"818567", "Tsuwano\,\ Shimane",
"811735", "Goshogawara\,\ Aomori",
"815996", "Ago\,\ Mie",
"811235", "Yubari\,\ Hokkaido",
"818689", "Okayama\,\ Okayama",
"81125", "Takikawa\,\ Hokkaido",
"817947", "Miki\,\ Hyogo",
"81949", "Nogata\,\ Fukuoka",
"81939", "Kitakyushu\,\ Fukuoka",
"817953", "Nishiwaki\,\ Hyogo",
"8153964", "Hamamatsu\,\ Shizuoka",
"81577", "Takayama\,\ Gifu",
"818249", "Higashi\-ku\,\ Hiroshima",
"81547", "Shimada\,\ Shizuoka",
"812853", "Oyama\,\ Tochigi",
"818596", "Yonago\,\ Tottori",
"81565", "Toyota\,\ Aichi",
"812547", "Murakami\,\ Niigata",
"818896", "Susaki\,\ Kochi",
"81537", "Kakegawa\,\ Shizuoka",
"812553", "Joetsu\,\ Niigata",
"81979", "Nakatsu\,\ Oita",
"811634", "Hamatonbetsu\,\ Hokkaido",
"814752", "Mobara\,\ Chiba",
"819946", "Kanoya\,\ Kagoshima",
"8186995", "Seto\,\ Okayama",
"812839", "Sano\,\ Tochigi",
"818479", "Tojo\,\ Hiroshima",
"814998", "Ogasawara\,\ Tokyo",
"81726", "Ibaraki\,\ Osaka",
"811868", "Takanosu\,\ Akita",
"819578", "Shimabara\,\ Nagasaki",
"812412", "Kitakata\,\ Fukushima",
"812792", "Shibukawa\,\ Gunma",
"8199343", "Kagoshima\,\ Kagoshima",
"815993", "Toba\,\ Mie",
"81568", "Kasugai\,\ Aichi",
"812583", "Nagaoka\,\ Niigata",
"819554", "Imari\,\ Saga",
"814291", "Hanno\,\ Saitama",
"818362", "Ube\,\ Yamaguchi",
"8198295", "Hyuga\,\ Miyazaki",
"811585", "Engaru\,\ Hokkaido",
"818948", "Uwajima\,\ Ehime",
"818462", "Takehara\,\ Hiroshima",
"811977", "Kitakami\,\ Iwate",
"81531", "Tahara\,\ Aichi",
"812242", "Shiroishi\,\ Miyagi",
"81937", "Kitakyushu\,\ Fukuoka",
"815584", "Shimoda\,\ Shizuoka",
"81965", "Yatsushiro\,\ Kumamoto",
"811956", "Iwate\,\ Iwate",
"812994", "Ishioka\,\ Ibaraki",
"819967", "Izumi\,\ Kagoshima",
"818391", "Ogori\,\ Yamaguchi",
"81738", "Gobo\,\ Wakayama",
"81947", "Tagawa\,\ Fukuoka",
"818557", "Kawamoto\,\ Shimane",
"811544", "Kushiro\,\ Hokkaido",
"81977", "Beppu\,\ Oita",
"818843", "Anan\,\ Tokushima",
"81778", "Takefu\,\ Fukui",
"818543", "Yasugi\,\ Shimane",
"812914", "Hokota\,\ Ibaraki",
"81549", "Shizuoka\,\ Shizuoka",
"81176", "Towada\,\ Aomori",
"812965", "Shimodate\,\ Ibaraki",
"8125487", "Tsugawa\,\ Niigata",
"818832", "Kamojima\,\ Tokushima",
"811986", "Tono\,\ Iwate",
"819727", "Usuki\,\ Oita",
"812649", "Nagano\,\ Nagano",
"81924", "Fukuoka\,\ Fukuoka",
"811855", "Noshiro\,\ Akita",
"812372", "Murayama\,\ Yamagata",
"811555", "Obihiro\,\ Hokkaido",
"812652", "Iida\,\ Nagano",
"81183", "Yuzawa\,\ Akita",
"812472", "Ishikawa\,\ Fukushima",
"81192", "Ofunato\,\ Iwate",
"817238", "Neyagawa\,\ Osaka",
"818975", "Niihama\,\ Ehime",
"819598", "Fukue\,\ Nagasaki",
"818587", "Koge\,\ Tottori",
"812233", "Iwanuma\,\ Miyagi",
"817735", "Fukuchiyama\,\ Kyoto",
"81775", "Otsu\,\ Shiga",
"812566", "Sanjo\,\ Niigata",
"815973", "Owase\,\ Mie",
"8112398", "Kuriyama\,\ Hokkaido",
"81797", "Nishinomiya\,\ Hyogo",
"815753", "Sekigahara\,\ Gifu",
"818680", "Okayama\,\ Okayama",
"811732", "Goshogawara\,\ Aomori",
"817367", "Iwade\,\ Wakayama",
"81998", "Kagoshima\,\ Kagoshima",
"814705", "Tateyama\,\ Chiba",
"818240", "Higashi\-ku\,\ Hiroshima",
"818205", "Yanai\,\ Yamaguchi",
"81162", "Wakkanai\,\ Hokkaido",
"818675", "Kuse\,\ Okayama",
"814758", "Togane\,\ Chiba",
"81833", "Kudamatsu\,\ Yamaguchi",
"819809", "Yaeyama\ District\,\ Okinawa",
"811332", "Tobetsu\,\ Hokkaido",
"81423", "Kokubunji\,\ Tokyo",
"812830", "Utsunomiya\,\ Tochigi",
"819935", "Kaseda\,\ Kagoshima",
"817493", "Hikone\,\ Shiga",
"811376", "Yakumo\,\ Hokkaido",
"8186998", "Seto\,\ Okayama",
"812694", "Nakano\,\ Nagano",
"811656", "Bifuka\,\ Hokkaido",
"817713", "Kameoka\,\ Kyoto",
"819667", "Minamata\,\ Kumamoto",
"811357", "Iwanai\,\ Hokkaido",
"81886", "Tokushima\,\ Tokushima",
"811757", "Noheji\,\ Aomori",
"814285", "Sagamihara\,\ Kanagawa",
"812614", "Omachi\,\ Nagano",
"819825", "Hyuga\,\ Miyazaki",
"818385", "Hagi\,\ Yamaguchi",
"812937", "Mito\,\ Ibaraki",
"811862", "Kazuno\,\ Akita",
"819572", "Isahaya\,\ Nagasaki",
"811562", "Honbetsu\,\ Hokkaido",
"812798", "Naganohara\,\ Gunma",
"81281", "Utsunomiya\,\ Tochigi",
"812484", "Shirakawa\,\ Fukushima",
"812248", "Ogawara\,\ Miyagi",
"818664", "Takahashi\,\ Okayama",
"812384", "Yonezawa\,\ Yamagata",
"817683", "Wajima\,\ Ishikawa",
"8198298", "Hyuga\,\ Miyazaki",
"818294", "Hatsukaichi\,\ Hiroshima",
"818368", "Ube\,\ Yamaguchi",
"812745", "Fujioka\,\ Gunma",
"818942", "Yawatahama\,\ Ehime",
"818695", "Seto\,\ Okayama",
"817707", "Obama\,\ Fukui",
"81922", "Fukuoka\,\ Fukuoka",
"819747", "Taketa\,\ Oita",
"81488", "Urawa\,\ Saitama",
"814794", "Choshi\,\ Chiba",
"81259", "Sado\,\ Niigata",
"812784", "Numata\,\ Gunma",
"811524", "Abashiri\,\ Hokkaido",
"812378", "Sagae\,\ Yamagata",
"812658", "Ina\,\ Nagano",
"812478", "Miharu\,\ Fukushima",
"812640", "Nagano\,\ Nagano",
"815766", "Gero\,\ Gifu",
"812674", "Komoro\,\ Nagano",
"811396", "Esashi\,\ Hokkaido",
"818490", "Onomichi\,\ Hiroshima",
"81485", "Kumagaya\,\ Saitama",
"8112395", "Kuriyama\,\ Hokkaido",
"815366", "Shitara\,\ Aichi",
"819783", "Bungotakada\,\ Oita",
"811934", "Kamaishi\,\ Iwate",
"819592", "Oseto\,\ Nagasaki",
"811652", "Shibetsu\,\ Hokkaido",
"8186997", "Seto\,\ Okayama",
"812555", "Itoigawa\,\ Niigata",
"81460", "Odawara\,\ Kanagawa",
"811372", "Shikabe\,\ Hokkaido",
"812855", "Oyama\,\ Tochigi",
"81427", "Sagamihara\,\ Kanagawa",
"81253", "Niigata\,\ Niigata",
"819948", "Shibushi\,\ Kagoshima",
"81877", "Marugame\,\ Kagawa",
"819557", "Karatsu\,\ Saga",
"819576", "Shimabara\,\ Nagasaki",
"811866", "Takanosu\,\ Akita",
"819543", "Takeo\,\ Saga",
"811233", "Chitose\,\ Hokkaido",
"817955", "Sanda\,\ Hyogo",
"81793", "Himeji\,\ Hyogo",
"81292", "Mito\,\ Ibaraki",
"8147950", "Yokaichiba\,\ Chiba",
"81236", "Yamagata\,\ Yamagata",
"812956", "Hitachi\-Omiya\,\ Ibaraki",
"81434", "Chiba\,\ Chiba",
"817944", "Kakogawa\,\ Hyogo",
"81246", "Iwaki\,\ Fukushima",
"812585", "Nagaoka\,\ Niigata",
"811736", "Goshogawara\,\ Aomori",
"815995", "Ago\,\ Mie",
"819975", "Naze\,\ Kagoshima",
"811336", "Ishikari\,\ Hokkaido",
"8188096", "Tosashimizu\,\ Kochi",
"81276", "Ota\,\ Gunma",
"81474", "Funabashi\,\ Chiba",
"812544", "Shibata\,\ Niigata",
"818545", "Kisuki\,\ Shimane",
"81429", "Tokorozawa\,\ Saitama",
"817968", "Hamasaka\,\ Hyogo",
"811392", "Kikonai\,\ Hokkaido",
"819724", "Saiki\,\ Oita",
"815762", "Gero\,\ Gifu",
"81849", "Fukuyama\,\ Hiroshima",
"81466", "Fujisawa\,\ Kanagawa",
"812963", "Shimodate\,\ Ibaraki",
"81839", "Yamaguchi\,\ Yamaguchi",
"8153971", "Hamamatsu\,\ Shizuoka",
"811583", "Monbetsu\,\ Hokkaido",
"819596", "Fukue\,\ Nagasaki",
"818584", "Kurayoshi\,\ Tottori",
"815362", "Shinshiro\,\ Aichi",
"812997", "Itako\,\ Ibaraki",
"818946", "Uwajima\,\ Ehime",
"818973", "Niihama\,\ Ehime",
"819964", "Satsumasendai\,\ Kagoshima",
"811974", "Mizusawa\,\ Iwate",
"8198297", "Hyuga\,\ Miyazaki",
"811958", "Iwate\,\ Iwate",
"81225", "Ishinomaki\,\ Miyagi",
"812235", "Sendai\,\ Miyagi",
"817733", "Fukuchiyama\,\ Kyoto",
"81270", "Isesaki\,\ Gunma",
"8153979", "Hamamatsu\,\ Shizuoka",
"8126176", "Omachi\,\ Nagano",
"811553", "Obihiro\,\ Hokkaido",
"812917", "Mito\,\ Ibaraki",
"811547", "Shiranuka\,\ Hokkaido",
"818554", "Hamada\,\ Shimane",
"812890", "Utsunomiya\,\ Tochigi",
"811853", "Oga\,\ Akita",
"8125485", "Tsugawa\,\ Niigata",
"812697", "Iiyama\,\ Nagano",
"819664", "Hitoyoshi\,\ Kumamoto",
"811354", "Yoichi\,\ Hokkaido",
"817902", "Fukusaki\,\ Hyogo",
"811454", "Mukawa\,\ Hokkaido",
"818203", "Yanai\,\ Yamaguchi",
"81533", "Toyohashi\,\ Aichi",
"811658", "Kamikawa\,\ Hokkaido",
"81543", "Shizuoka\,\ Shizuoka",
"811378", "Imakane\,\ Hokkaido",
"814703", "Tateyama\,\ Chiba",
"81432", "Chiba\,\ Chiba",
"812934", "Takahagi\,\ Ibaraki",
"815755", "Sekigahara\,\ Gifu",
"812796", "Shibukawa\,\ Gunma",
"811754", "Mutsu\,\ Aomori",
"81822", "Hiroshima\,\ Hiroshima",
"812571", "Muika\,\ Niigata",
"812416", "Tajima\,\ Fukushima",
"814283", "Ome\,\ Tokyo",
"819823", "Nobeoka\,\ Miyazaki",
"818512", "Nishigo\,\ Fukushima",
"81586", "Ichinomiya\,\ Aichi",
"815744", "Minokamo\,\ Gifu",
"818383", "Hagi\,\ Yamaguchi",
"817464", "Yoshino\,\ Nara",
"81294", "Hitachiota\,\ Ibaraki",
"814756", "Togane\,\ Chiba",
"814777", "Funabashi\,\ Chiba",
"817715", "Kameoka\,\ Kyoto",
"81950", "Hirado\,\ Nagasaki",
"818892", "Sakawa\,\ Kochi",
"812879", "Nasukarasuyama\,\ Tochigi",
"817495", "Nagahama\,\ Shiga",
"818592", "Yonago\,\ Tottori",
"819933", "Ibusuki\,\ Kagoshima",
"812476", "Miharu\,\ Fukushima",
"812656", "Ina\,\ Nagano",
"812376", "Sagae\,\ Yamagata",
"81898", "Imabari\,\ Ehime",
"818693", "Oku\,\ Okayama",
"812677", "Saku\,\ Nagano",
"817962", "Toyooka\,\ Hyogo",
"811398", "Kumaishi\,\ Hokkaido",
"811982", "Hanamaki\,\ Iwate",
"818263", "Kake\,\ Hiroshima",
"811527", "Bihoro\,\ Hokkaido",
"815768", "Gero\,\ Gifu",
"818836", "Mima\,\ Tokushima",
"817685", "Wajima\,\ Ishikawa",
"8112397", "Kuriyama\,\ Hokkaido",
"812562", "Sanjo\,\ Niigata",
"8186691", "Kurashiki\,\ Okayama",
"815368", "Shitara\,\ Aichi",
"815959", "Kameyama\,\ Mie",
"811937", "Miyako\,\ Iwate",
"81933", "Kitakyushu\,\ Fukuoka",
"812743", "Fujioka\,\ Gunma",
"819785", "Bungotakada\,\ Oita",
"811952", "Ninohe\,\ Iwate",
"81550", "Gotenba\,\ Shizuoka",
"818297", "Hatsukaichi\,\ Hiroshima",
"812246", "Ogawara\,\ Miyagi",
"818466", "Mima\,\ Tokushima",
"812387", "Nagai\,\ Yamagata",
"818366", "Ube\,\ Yamaguchi",
"812487", "Sukagawa\,\ Fukushima",
"818667", "Ibara\,\ Okayama",
"817722", "Miyazu\,\ Kyoto",
"814797", "Yokaichiba\,\ Chiba",
"8125488", "Tsugawa\,\ Niigata",
"8162", "Osaka\,\ Osaka",
"81956", "Sasebo\,\ Nagasaki",
"812787", "Numata\,\ Gunma",
"81157", "Kitami\,\ Hokkaido",
"819744", "Mie\,\ Oita",
"81986", "Miyakonojo\,\ Miyazaki",
"817704", "Tsuruga\,\ Fukui",
"817475", "Shimonoseki\,\ Yamaguchi",
"812899", "Kanuma\,\ Tochigi",
"818872", "Muroto\,\ Kochi",
"81763", "Fukuno\,\ Toyama",
"81262", "Nagano\,\ Nagano",
"818696", "Bizen\,\ Okayama",
"812647", "Nagano\,\ Nagano",
"812373", "Murayama\,\ Yamagata",
"81555", "Fujiyoshida\,\ Yamanashi",
"817454", "Yamatotakada\,\ Nara",
"817674", "Hakui\,\ Ishikawa",
"818397", "Ogori\,\ Yamaguchi",
"812473", "Ishikawa\,\ Fukushima",
"81495", "Honjo\,\ Saitama",
"817354", "Shingu\,\ Fukuoka",
"819684", "Yamaga\,\ Kumamoto",
"812653", "Iida\,\ Nagano",
"81585", "Ibigawa\,\ Gifu",
"811534", "Nakashibetsu\,\ Hokkaido",
"818833", "Kamojima\,\ Tokushima",
"8167", "Osaka\,\ Osaka",
"8198290", "Nobeoka\,\ Miyazaki",
"814297", "Hanno\,\ Saitama",
"8164", "Osaka\,\ Osaka",
"812232", "Iwanuma\,\ Miyagi",
"819788", "Kunisaki\,\ Oita",
"815972", "Owase\,\ Mie",
"8163", "Osaka\,\ Osaka",
"818797", "Tonosho\,\ Kagawa",
"812746", "Tomioka\,\ Gunma",
"812243", "Shiroishi\,\ Miyagi",
"817688", "Noto\,\ Ishikawa",
"8125484", "Murakami\,\ Niigata",
"818363", "Ube\,\ Yamaguchi",
"817484", "Yokaichi\,\ Shiga",
"811464", "Shizunai\,\ Hokkaido",
"818463", "Takehara\,\ Hiroshima",
"811364", "Kutchan\,\ Hokkaido",
"815394", "Hamamatsu\,\ Shizuoka",
"81923", "Fukuoka\,\ Fukuoka",
"81184", "Yurihonjo\,\ Akita",
"818559", "Kawamoto\,\ Shimane",
"818842", "Anan\,\ Tokushima",
"815765", "Gero\,\ Gifu",
"8199347", "Kagoshima\,\ Kagoshima",
"818542", "Yasugi\,\ Shimane",
"811395", "Esashi\,\ Hokkaido",
"81896", "Iyomishima\,\ Ehime",
"818477", "Tojo\,\ Hiroshima",
"818206", "Yanai\,\ Yamaguchi",
"818657", "Kasaoka\,\ Okayama",
"811644", "Rumoi\,\ Hokkaido",
"818377", "Shimonoseki\,\ Yamaguchi",
"818676", "Kuse\,\ Okayama",
"8147957", "Yokaichiba\,\ Chiba",
"817498", "Nagahama\,\ Shiga",
"8182920", "Hatsukaichi\,\ Hiroshima",
"8186552", "Kurashiki\,\ Okayama",
"817718", "Sonobe\,\ Kyoto",
"812837", "Sano\,\ Tochigi",
"815992", "Toba\,\ Mie",
"812930", "Mito\,\ Ibaraki",
"8125483", "Murakami\,\ Niigata",
"812582", "Nagaoka\,\ Niigata",
"812413", "Kitakata\,\ Fukushima",
"81985", "Miyazaki\,\ Miyazaki",
"812793", "Shibukawa\,\ Gunma",
"817614", "Komatsu\,\ Ishikawa",
"817949", "Kakogawa\,\ Hyogo",
"8112392", "Yubari\,\ Hokkaido",
"814286", "Sagamihara\,\ Kanagawa",
"817952", "Nishiwaki\,\ Hyogo",
"819826", "Hyuga\,\ Miyazaki",
"818247", "Shobara\,\ Hiroshima",
"818687", "Mimasaka\,\ Okayama",
"81988", "Naha\,\ Okinawa",
"81958", "Nagasaki\,\ Nagasaki",
"8153967", "Hamamatsu\,\ Shizuoka",
"814753", "Mobara\,\ Chiba",
"811375", "Yakumo\,\ Hokkaido",
"8175", "Kyoto\,\ Kyoto",
"812852", "Oyama\,\ Tochigi",
"819936", "Kaseda\,\ Kagoshima",
"812549", "Tsugawa\,\ Niigata",
"81832", "Shimonoseki\,\ Yamaguchi",
"812552", "Joetsu\,\ Niigata",
"8178", "Kobe\,\ Hyogo",
"811655", "Nayoro\,\ Hokkaido",
"8183768", "Shimonoseki\,\ Yamaguchi",
"819737", "Kusu\,\ Oita",
"81182", "Yokote\,\ Akita",
"81245", "Fukushima\,\ Fukushima",
"81235", "Tsuruoka\,\ Yamagata",
"817725", "Miyazu\,\ Kyoto",
"819593", "Oseto\,\ Nagasaki",
"811586", "Nakayubetsu\,\ Hokkaido",
"8182941", "Hiroshima\,\ Hiroshima",
"812238", "Sendai\,\ Miyagi",
"819782", "Bungotakada\,\ Oita",
"8161", "Osaka\,\ Osaka",
"819437", "Tanushimaru\,\ Fukuoka",
"8124197", "Yanaizu\,\ Fukushima",
"815978", "Kumano\,\ Mie",
"811955", "Ninohe\,\ Iwate",
"818957", "Misho\,\ Ehime",
"811944", "Iwaizumi\,\ Iwate",
"81439", "Kisarazu\,\ Chiba",
"818943", "Yawatahama\,\ Ehime",
"817994", "Sumoto\,\ Hyogo",
"81471", "Kashiwa\,\ Chiba",
"818976", "Niihama\,\ Ehime",
"817736", "Maizuru\,\ Kyoto",
"817682", "Wajima\,\ Ishikawa",
"812565", "Sanjo\,\ Niigata",
"8186992", "Bizen\,\ Okayama",
"817965", "Toyooka\,\ Hyogo",
"8112390", "Yubari\,\ Hokkaido",
"815984", "Matsusaka\,\ Mie",
"811856", "Noshiro\,\ Akita",
"812894", "Utsunomiya\,\ Tochigi",
"811877", "Omagari\,\ Akita",
"811556", "Obihiro\,\ Hokkaido",
"817914", "Aioi\,\ Hyogo",
"819978", "Tokunoshima\,\ Kagoshima",
"817492", "Hikone\,\ Shiga",
"818595", "Yonago\,\ Tottori",
"817712", "Kameoka\,\ Kyoto",
"818895", "Susaki\,\ Kochi",
"81226", "Kesennuma\,\ Miyagi",
"81468", "Yokosuka\,\ Kanagawa",
"81834", "Tokuyama\,\ Yamaguchi",
"819954", "Kajiki\,\ Kagoshima",
"818564", "Masuda\,\ Shimane",
"819573", "Isahaya\,\ Nagasaki",
"811863", "Kazuno\,\ Akita",
"812939", "Mito\,\ Ibaraki",
"811236", "Chitose\,\ Hokkaido",
"819546", "Kashima\,\ Saga",
"811563", "Honbetsu\,\ Hokkaido",
"8198292", "Nobeoka\,\ Miyazaki",
"815998", "Ago\,\ Mie",
"815737", "Nakatsugawa\,\ Gifu",
"812588", "Nagaoka\,\ Niigata",
"817940", "Kakogawa\,\ Hyogo",
"81465", "Odawara\,\ Kanagawa",
"811733", "Goshogawara\,\ Aomori",
"815752", "Sekigahara\,\ Gifu",
"8144", "Kawasaki\,\ Kanagawa",
"81827", "Iwakuni\,\ Yamaguchi",
"812858", "Mooka\,\ Tochigi",
"819945", "Kanoya\,\ Kagoshima",
"811333", "Tobetsu\,\ Hokkaido",
"812574", "Kashiwazaki\,\ Niigata",
"817905", "Fukusaki\,\ Hyogo",
"812874", "Otawara\,\ Tochigi",
"812382", "Yonezawa\,\ Yamagata",
"812998", "Itako\,\ Ibaraki",
"818662", "Takahashi\,\ Okayama",
"812482", "Shirakawa\,\ Fukushima",
"818944", "Yawatahama\,\ Ehime",
"811957", "Iwate\,\ Iwate",
"817993", "Sumoto\,\ Hyogo",
"819435", "Yame\,\ Fukuoka",
"819966", "Izumi\,\ Kagoshima",
"81935", "Kitakyushu\,\ Fukuoka",
"81166", "Asahikawa\,\ Hokkaido",
"818292", "Hiroshima\,\ Hiroshima",
"811976", "Kitakami\,\ Iwate",
"811943", "Iwaizumi\,\ Iwate",
"81561", "Seto\,\ Aichi",
"8112396", "Kuriyama\,\ Hokkaido",
"81975", "Oita\,\ Oita",
"812893", "Utsunomiya\,\ Tochigi",
"819735", "Hita\,\ Oita",
"81569", "Handa\,\ Aichi",
"818556", "Gotsu\,\ Shimane",
"815983", "Matsusaka\,\ Mie",
"812782", "Numata\,\ Gunma",
"814792", "Choshi\,\ Chiba",
"811548", "Teshikaga\,\ Hokkaido",
"81765", "Uozu\,\ Toyama",
"811987", "Tono\,\ Iwate",
"81938", "Kitakyushu\,\ Fukuoka",
"81737", "Yuasa\,\ Wakayama",
"81948", "Iizuka\,\ Fukuoka",
"811522", "Shari\,\ Hokkaido",
"81852", "Matsue\,\ Shimane",
"811875", "Kakunodate\,\ Akita",
"812672", "Komoro\,\ Nagano",
"819726", "Usuki\,\ Oita",
"81893", "Ozu\,\ Ehime",
"818955", "Uwajima\,\ Ehime",
"8153973", "Hamamatsu\,\ Shizuoka",
"818586", "Kurayoshi\,\ Tottori",
"811932", "Kamaishi\,\ Iwate",
"8165", "Osaka\,\ Osaka",
"81926", "Fukuoka\,\ Fukuoka",
"8168", "Osaka\,\ Osaka",
"811734", "Goshogawara\,\ Aomori",
"814289", "Ome\,\ Tokyo",
"815735", "Ena\,\ Gifu",
"81969", "Amakusa\,\ Kumamoto",
"817946", "Miki\,\ Hyogo",
"81545", "Fuji\,\ Shizuoka",
"812873", "Otawara\,\ Tochigi",
"81567", "Tsushima\,\ Aichi",
"81535", "Hamamatsu\,\ Shizuoka",
"812573", "Kashiwazaki\,\ Niigata",
"812546", "Murakami\,\ Niigata",
"814772", "Ichikawa\,\ Chiba",
"814701", "Kamogawa\,\ Chiba",
"81739", "Tanabe\,\ Wakayama",
"81144", "Tomakomai\,\ Hokkaido",
"819953", "Okuchi\,\ Kagoshima",
"819947", "Shibushi\,\ Kagoshima",
"81134", "Otaru\,\ Hokkaido",
"81578", "Kamioka\,\ Akita",
"819805", "Nago\,\ Okinawa",
"818679", "Niimi\,\ Okayama",
"812692", "Nakano\,\ Nagano",
"814281", "Sagamihara\,\ Kanagawa",
"812612", "Omachi\,\ Nagano",
"819558", "Karatsu\,\ Saga",
"814709", "Kamogawa\,\ Chiba",
"81548", "Haibara\,\ Shizuoka",
"81779", "Ono\,\ Gifu",
"811564", "Kamishihoro\,\ Hokkaido",
"811864", "Odate\,\ Akita",
"81174", "Kanita\,\ Aomori",
"819574", "Isahaya\,\ Nagasaki",
"81538", "Iwata\,\ Shizuoka",
"818563", "Masuda\,\ Shimane",
"818464", "Takehara\,\ Hiroshima",
"811363", "Kutchan\,\ Hokkaido",
"818298", "Hatsukaichi\,\ Hiroshima",
"817483", "Yokaichi\,\ Shiga",
"818364", "Ube\,\ Yamaguchi",
"811463", "Urakawa\,\ Hokkaido",
"812388", "Nagai\,\ Yamagata",
"812992", "Ishioka\,\ Ibaraki",
"818668", "Ibara\,\ Okayama",
"815582", "Shimoda\,\ Shizuoka",
"812488", "Sukagawa\,\ Fukushima",
"812244", "Shiroishi\,\ Miyagi",
"817706", "Obama\,\ Fukui",
"812788", "Maebashi\,\ Gunma",
"814798", "Yokaichiba\,\ Chiba",
"811559", "Obihiro\,\ Hokkaido",
"819232", "Maebaru\,\ Fukuoka",
"811542", "Kushiro\,\ Hokkaido",
"819746", "Taketa\,\ Oita",
"815393", "Hamamatsu\,\ Shizuoka",
"812678", "Saku\,\ Nagano",
"818834", "Kamojima\,\ Tokushima",
"8198296", "Hyuga\,\ Miyazaki",
"811533", "Nemuro\,\ Hokkaido",
"817353", "Shingu\,\ Fukuoka",
"811397", "Okushiri\,\ Hokkaido",
"812474", "Ishikawa\,\ Fukushima",
"819683", "Yamaga\,\ Kumamoto",
"812654", "Iida\,\ Nagano",
"818690", "Okayama\,\ Okayama",
"817453", "Yamatotakada\,\ Nara",
"815767", "Gero\,\ Gifu",
"812374", "Murayama\,\ Yamagata",
"817673", "Hakui\,\ Ishikawa",
"811528", "Bihoro\,\ Hokkaido",
"81487", "Urawa\,\ Saitama",
"81722", "Sakai\,\ Osaka",
"815367", "Shitara\,\ Aichi",
"811938", "Miyako\,\ Iwate",
"811589", "Okoppe\,\ Hokkaido",
"8145", "Yokohama\,\ Kanagawa",
"817366", "Iwade\,\ Wakayama",
"815746", "Minokamo\,\ Gifu",
"8186996", "Seto\,\ Okayama",
"817466", "Totsukawa\,\ Nara",
"814280", "Tachikawa\,\ Tokyo",
"81172", "Hirosaki\,\ Aomori",
"81863", "Tamano\,\ Okayama",
"818375", "Mine\,\ Yamaguchi",
"81142", "Date\,\ Hokkaido",
"818655", "Kamogata\,\ Okayama",
"818475", "Fuchu\,\ Hiroshima",
"812835", "Sano\,\ Tochigi",
"814754", "Mobara\,\ Chiba",
"811632", "Teshio\,\ Hokkaido",
"812698", "Iiyama\,\ Nagano",
"81798", "Nishinomiya\,\ Hyogo",
"819666", "Minamata\,\ Kumamoto",
"811356", "Iwanai\,\ Hokkaido",
"81196", "Morioka\,\ Iwate",
"811377", "Yakumo\,\ Hokkaido",
"81591", "Tsu\,\ Mie",
"818245", "Miyoshi\,\ Hiroshima",
"812794", "Shibukawa\,\ Gunma",
"811756", "Noheji\,\ Aomori",
"817613", "Komatsu\,\ Ishikawa",
"81288", "Imabari\,\ Ehime",
"812414", "Yanaizu\,\ Fukushima",
"8188097", "Tosashimizu\,\ Kochi",
"81489", "Soka\,\ Saitama",
"812618", "Omachi\,\ Nagano",
"814700", "Kamogawa\,\ Chiba",
"819552", "Imari\,\ Saga",
"818685", "Tsuyama\,\ Okayama",
"812936", "Mito\,\ Ibaraki",
"817463", "Yoshino\,\ Nara",
"818384", "Hagi\,\ Yamaguchi",
"8126172", "Omachi\,\ Nagano",
"818248", "Shobara\,\ Hiroshima",
"815743", "Minokamo\,\ Gifu",
"8186698", "Kurashiki\,\ Okayama",
"818688", "Mimasaka\,\ Okayama",
"812615", "Omachi\,\ Nagano",
"819824", "Nobeoka\,\ Miyazaki",
"814284", "Tachikawa\,\ Tokyo",
"8153975", "Hamamatsu\,\ Shizuoka",
"819934", "Ibusuki\,\ Kagoshima",
"812695", "Nakano\,\ Nagano",
"819802", "Minamidaito\,\ Okinawa",
"8125489", "Tsugawa\,\ Niigata",
"8111", "Sapporo\,\ Hokkaido",
"814775", "Funabashi\,\ Chiba",
"8125481", "Murakami\,\ Niigata",
"818478", "Tojo\,\ Hiroshima",
"818378", "Shimonoseki\,\ Yamaguchi",
"818204", "Yanai\,\ Yamaguchi",
"811646", "Haboro\,\ Hokkaido",
"811453", "Hayakita\,\ Hokkaido",
"817497", "Nagahama\,\ Shiga",
"812838", "Sano\,\ Tochigi",
"819663", "Hitoyoshi\,\ Kumamoto",
"811353", "Yoichi\,\ Hokkaido",
"818674", "Kuse\,\ Okayama",
"817717", "Sonobe\,\ Kyoto",
"813", "Tokyo",
"811753", "Mutsu\,\ Aomori",
"817616", "Komatsu\,\ Ishikawa",
"815732", "Ena\,\ Gifu",
"811869", "Odate\,\ Akita",
"81463", "Hiratsuka\,\ Kanagawa",
"81280", "Koga\,\ Ibaraki",
"812933", "Takahagi\,\ Ibaraki",
"814704", "Tateyama\,\ Chiba",
"81250", "Niitsu\,\ Niigata",
"818360", "Ogori\,\ Yamaguchi",
"817486", "Minakuchi\,\ Shiga",
"811935", "Kamaishi\,\ Iwate",
"811466", "Erimo\,\ Hokkaido",
"817687", "Noto\,\ Ishikawa",
"811366", "Suttsu\,\ Hokkaido",
"81273", "Takasaki\,\ Gunma",
"818952", "Uwajima\,\ Ehime",
"818949", "Uwajima\,\ Ehime",
"812675", "Saku\,\ Nagano",
"81233", "Shinjo\,\ Yamagata",
"81742", "Nara\,\ Nara",
"817703", "Tsuruga\,\ Fukui",
"81243", "Nihonmatsu\,\ Fukushima",
"819743", "Mie\,\ Oita",
"811525", "Abashiri\,\ Hokkaido",
"81857", "Tottori\,\ Tottori",
"8124196", "Yanaizu\,\ Fukushima",
"818398", "Ogori\,\ Yamaguchi",
"812648", "Nagano\,\ Nagano",
"811536", "Akkeshi\,\ Hokkaido",
"812785", "Numata\,\ Gunma",
"814795", "Choshi\,\ Chiba",
"817456", "Yamatotakada\,\ Nara",
"818694", "Okayama\,\ Okayama",
"819732", "Hita\,\ Oita",
"817676", "Nanao\,\ Ishikawa",
"817356", "Kushimoto\,\ Wakayama",
"814298", "Hanno\,\ Saitama",
"819686", "Tamana\,\ Kumamoto",
"812744", "Fujioka\,\ Gunma",
"81286", "Utsunomiya\,\ Tochigi",
"818295", "Hatsukaichi\,\ Hiroshima",
"81594", "Kuwana\,\ Mie",
"81484", "Kawaguchi\,\ Saitama",
"819787", "Kunisaki\,\ Oita",
"819432", "Yame\,\ Fukuoka",
"818665", "Takahashi\,\ Okayama",
"817239", "Neyagawa\,\ Osaka",
"812485", "Shirakawa\,\ Fukushima",
"818798", "Tonosho\,\ Kagawa",
"81962", "Kumamoto\,\ Kumamoto",
"812385", "Yonezawa\,\ Yamagata",
"819599", "Oseto\,\ Nagasaki",
"818682", "Tsuyama\,\ Okayama",
"81124", "Ashibetsu\,\ Hokkaido",
"81983", "Takanabe\,\ Miyazaki",
"81729", "Yao\,\ Osaka",
"819555", "Karatsu\,\ Saga",
"817943", "Kakogawa\,\ Hyogo",
"81766", "Takaoka\,\ Toyama",
"818242", "Higashi\-ku\,\ Hiroshima",
"812576", "Tokamachi\,\ Niigata",
"819808", "Yaeyama\ District\,\ Okinawa",
"812543", "Shibata\,\ Niigata",
"812857", "Mooka\,\ Tochigi",
"81564", "Okazaki\,\ Aichi",
"812876", "Kuroiso\,\ Tochigi",
"81992", "Kagoshima\,\ Kagoshima",
"8153978", "Hamamatsu\,\ Shizuoka",
"81721", "Tondabayashi\,\ Osaka",
"819977", "Setouchi\,\ Kagoshima",
"811635", "Hamatonbetsu\,\ Hokkaido",
"81946", "Amagi\,\ Fukuoka",
"812832", "Sano\,\ Tochigi",
"81936", "Kitakyushu\,\ Fukuoka",
"819956", "Kajiki\,\ Kagoshima",
"818652", "Kurashiki\,\ Okayama",
"818372", "Nagato\,\ Yamaguchi",
"812419", "Tajima\,\ Fukushima",
"812799", "Naganohara\,\ Gunma",
"8153966", "Hamamatsu\,\ Shizuoka",
"819544", "Takeo\,\ Saga",
"815997", "Ago\,\ Mie",
"811234", "Chitose\,\ Hokkaido",
"81177", "Aomori\,\ Aomori",
"812587", "Nagaoka\,\ Niigata",
"815738", "Nakatsugawa\,\ Gifu",
"818369", "Ube\,\ Yamaguchi",
"818958", "Misho\,\ Ehime",
"817734", "Fukuchiyama\,\ Kyoto",
"81727", "Ikeda\,\ Osaka",
"81592", "Tsu\,\ Mie",
"81928", "Fukuoka\,\ Fukuoka",
"81482", "Kawaguchi\,\ Saitama",
"811973", "Mizusawa\,\ Iwate",
"811946", "Kuji\,\ Iwate",
"817996", "Tsuna\,\ Hyogo",
"818974", "Niihama\,\ Ehime",
"819963", "Satsumasendai\,\ Kagoshima",
"811854", "Oga\,\ Akita",
"812896", "Kanuma\,\ Tochigi",
"818553", "Hamada\,\ Shimane",
"815986", "Matsusaka\,\ Mie",
"811554", "Obihiro\,\ Hokkaido",
"818547", "Kakeya\,\ Shimane",
"81493", "Higashimatsuyama\,\ Saitama",
"81583", "Gifu\,\ Gifu",
"81553", "Yamanashi\,\ Yamanashi",
"8126170", "Omachi\,\ Nagano",
"811878", "Omagari\,\ Akita",
"81734", "Wakayama\,\ Wakayama",
"819738", "Kusu\,\ Oita",
"81744", "Yamatotakada\,\ Nara",
"812964", "Shimodate\,\ Ibaraki",
"819723", "Saiki\,\ Oita",
"81940", "Munakata\,\ Fukuoka",
"811545", "Kushiro\,\ Hokkaido",
"81930", "Yukuhashi\,\ Fukuoka",
"81925", "Fukuoka\,\ Fukuoka",
"8182943", "Hiroshima\,\ Hiroshima",
"812659", "Ina\,\ Nagano",
"815585", "Shimoda\,\ Shizuoka",
"818806", "Sukumo\,\ Kochi",
"812995", "Ishioka\,\ Ibaraki",
"817230", "Neyagawa\,\ Osaka",
"818583", "Kurayoshi\,\ Tottori",
"812237", "Sendai\,\ Miyagi",
"81774", "Uji\,\ Kyoto",
"815977", "Kumano\,\ Mie",
"81546", "Shizuoka\,\ Shizuoka",
"81179", "Sannohe\,\ Aomori",
"819438", "Tanushimaru\,\ Fukuoka",
"811584", "Engaru\,\ Hokkaido",};
$areanames{ja} = {"817963", "豊岡",
"818262", "加計",
"81764", "富山",
"81126", "岩見沢",
"812968", "笠間",
"819734", "日田",
"818807", "宿毛",
"819434", "八女",
"818945", "八幡浜",
"812742", "藤岡",
"8188099", "土佐清水",
"812563", "三条",
"811939", "宮古",
"812389", "米沢",
"81725", "和泉",
"817723", "宮津",
"818669", "総社",
"81944", "瀬高",
"811953", "二戸",
"8188091", "窪川",
"817738", "舞鶴",
"818954", "宇和島",
"811947", "久慈",
"811874", "角館",
"817917", "竜野",
"815987", "三瀬谷",
"812897", "鹿沼",
"818846", "丹生谷",
"818873", "安芸",
"811558", "広尾",
"819957", "加治木",
"819943", "鹿屋",
"819976", "名瀬",
"8199331", "鹿児島",
"81252", "新潟",
"8125482", "村上",
"812955", "常陸大宮",
"812619", "大町",
"811238", "栗山",
"81792", "姫路",
"812586", "長岡",
"8152", "名古屋",
"814702", "館山",
"814771", "市川",
"818567", "津和野",
"811735", "五所川原",
"818382", "萩",
"81138", "函館",
"814282", "青梅",
"818893", "佐川",
"81776", "福井",
"81534", "浜松",
"812877", "黒磯",
"819932", "指宿",
"812856", "真岡",
"819804", "名護",
"818698", "備前",
"817357", "串本",
"819687", "玉名",
"815763", "下呂",
"817677", "七尾",
"8183767", "下関",
"818794", "三本松",
"8125480", "村上",
"811582", "紋別",
"81932", "北九州",
"818365", "宇部",
"811367", "寿都",
"817487", "水口",
"812999", "潮来",
"818972", "新居浜",
"818290", "広島",
"812475", "石川",
"811852", "男鹿",
"81480", "久喜",
"81885", "小松島",
"812780", "前橋",
"815397", "浜松",
"818835", "脇町",
"814755", "東金",
"818678", "新見",
"812834", "宇都宮",
"818208", "久賀",
"81473", "市川",
"814240", "国分寺",
"81542", "静岡",
"817716", "園部",
"818474", "府中",
"81572", "多治見",
"81199", "盛岡",
"819828", "高千穂",
"818684", "津山",
"812795", "渋川",
"812979", "竜ケ崎",
"814229", "武蔵野三鷹",
"81284", "足利",
"81596", "伊勢",
"814992", "伊豆大島",
"819935", "加世田",
"811457", "門別富川",
"819667", "水俣",
"817713", "亀岡",
"811757", "野辺地",
"814285", "相模原",
"812614", "大町",
"812937", "水戸",
"818385", "萩",
"812418", "会津山口",
"811562", "本別",
"811732", "五所川原",
"814705", "館山",
"818240", "東広島",
"81162", "稚内",
"819809", "八重山",
"811524", "網走",
"812378", "寒河江",
"812658", "伊那",
"812640", "長野",
"815766", "下呂",
"81485", "熊谷",
"8112395", "栗山",
"811934", "釜石",
"812248", "大河原",
"818664", "高梁",
"812384", "米沢",
"812745", "藤岡",
"818942", "八幡浜",
"81922", "福岡",
"819747", "竹田",
"818265", "安芸吉田",
"814794", "銚子",
"819946", "鹿屋",
"8186995", "岡山瀬戸",
"819973", "種子島",
"812839", "佐野",
"818479", "東城",
"811868", "鷹巣",
"819578", "島原",
"8199343", "鹿児島",
"812792", "渋川",
"812583", "長岡",
"818689", "岡山",
"81949", "直方",
"812974", "水海道",
"812853", "小山",
"814224", "武蔵野三鷹",
"81565", "豊田",
"818896", "須崎",
"81537", "掛川",
"81979", "中津",
"814752", "茂原",
"818832", "鴨島",
"817966", "八鹿",
"811855", "能代",
"81183", "湯沢",
"812472", "石川",
"818975", "新居浜",
"819598", "福江",
"818587", "郡家",
"812566", "三条",
"8153963", "天竜",
"817726", "峰山",
"818362", "宇部",
"811585", "遠軽",
"8198295", "日向",
"811977", "北上",
"812994", "石岡",
"811956", "岩手",
"81947", "田川",
"818843", "阿南",
"81977", "別府",
"818876", "土佐山田",
"81778", "武生",
"812973", "水海道",
"819806", "沖縄宮古",
"812578", "六日町",
"814223", "武蔵野三鷹",
"812854", "小山",
"81828", "広島",
"81438", "木更津",
"81249", "郡山",
"819974", "屋久島",
"8188094", "窪川",
"812584", "長岡",
"812993", "石岡",
"81268", "上田",
"818977", "伯方",
"818956", "宇和島",
"811362", "倶知安",
"81426", "八王子",
"817998", "津名",
"8183766", "下関",
"817482", "八日市",
"818585", "倉吉",
"815392", "浜松",
"811876", "大曲",
"811857", "能代",
"818844", "阿南",
"8188093", "窪川",
"819682", "山鹿",
"817352", "新宮",
"815769", "荘川",
"817672", "羽咋",
"811587", "中湧別",
"81277", "桐生",
"815958", "亀山",
"811975", "水沢",
"814287", "青梅",
"818387", "田万川",
"812935", "水戸",
"818686", "津山",
"81143", "室蘭",
"812872", "大田原",
"819665", "人吉",
"81862", "岡山",
"811455", "鵡川",
"819937", "加世田",
"817714", "亀岡",
"818476", "府中",
"81559", "沼津",
"819952", "大口",
"812836", "佐野",
"819949", "大根占",
"811648", "焼尻",
"814707", "大原",
"817618", "加賀",
"817465", "吉野",
"818562", "益田",
"81987", "日南",
"812613", "大町",
"81581", "高富",
"811942", "岩泉",
"812383", "米沢",
"818663", "総社",
"814793", "銚子",
"817912", "相生",
"815982", "松阪",
"812892", "宇都宮",
"818879", "室戸",
"81557", "伊東",
"811538", "根室標津",
"817969", "浜坂",
"818267", "千代田",
"811523", "斜里",
"817458", "大和榛原",
"812569", "巻",
"8166", "大阪",
"811933", "釜石",
"818802", "窪川",
"818796", "土庄",
"812747", "富岡",
"81222", "仙台",
"81723", "堺",
"81989", "那覇",
"811972", "水沢",
"818367", "宇部",
"818666", "井原",
"812386", "長井",
"814796", "八日市場",
"817675", "七尾",
"819685", "玉名",
"817355", "新宮",
"815764", "下呂",
"81494", "秩父",
"812477", "三春",
"818493", "尾道",
"81554", "大月",
"811526", "網走",
"818837", "阿波池田",
"815395", "浜松",
"811936", "宮古",
"817485", "八日市",
"818582", "倉吉",
"811365", "倶知安",
"818793", "三本松",
"815748", "美濃白川",
"817368", "岩出",
"818683", "津山",
"81899", "松山",
"814776", "船橋",
"814757", "東金",
"812859", "小山",
"818473", "甲山",
"819979", "徳之島",
"81563", "西尾",
"812833", "宇都宮",
"81462", "厚木",
"812589", "長岡",
"812797", "渋川",
"81984", "小林",
"812616", "大町",
"818953", "宇和島",
"811954", "二戸",
"818947", "宇和",
"812996", "潮来",
"818805", "土佐中村",
"817724", "宮津",
"819968", "出水",
"81582", "岐阜",
"818558", "川本",
"819742", "三重",
"818874", "安芸",
"8128798", "大田原",
"811873", "角館",
"819733", "日田",
"812895", "宇都宮",
"815985", "松阪",
"817915", "相生",
"8153961", "天竜",
"819728", "臼杵",
"81244", "原町",
"817964", "豊岡",
"81436", "市原",
"812230", "仙台",
"812564", "三条",
"811945", "久慈",
"819433", "八女",
"818514", "海士",
"812976", "竜ケ崎",
"81266", "諏訪",
"817950", "三田",
"812957", "大子",
"81952", "佐賀",
"811737", "鰺ケ沢",
"817948", "三木",
"818565", "益田",
"819803", "名護",
"819955", "加治木",
"814226", "武蔵野三鷹",
"812550", "安塚",
"818894", "須崎",
"811452", "早来",
"819662", "人吉",
"812875", "大田原",
"819944", "鹿屋",
"81845", "因島",
"812932", "高萩",
"81875", "観音寺",
"811567", "十勝清水",
"8188098", "土佐清水",
"811752", "むつ",
"811533", "根室",
"811397", "奥尻",
"812654", "飯田",
"817453", "大和高田",
"812374", "村山",
"811528", "美幌",
"8126177", "長野",
"81722", "堺",
"815367", "設楽",
"811551", "十勝池田",
"811938", "宮古",
"8145", "横浜",
"818464", "竹原",
"811463", "浦河",
"812388", "長井",
"815582", "下田",
"818668", "井原",
"812244", "白石",
"817706", "小浜",
"814798", "八日市場",
"811559", "帯広",
"811542", "釧路",
"819232", "前原",
"812645", "木曾福島",
"81196", "盛岡",
"811356", "岩内",
"811377", "八雲",
"811643", "石狩深川",
"818245", "三次",
"817613", "小松",
"81288", "今市",
"812414", "柳津",
"8188097", "土佐清水",
"814700", "鴨川",
"812618", "大町",
"819552", "伊万里",
"817366", "岩出",
"815746", "美濃加茂",
"814280", "立川",
"81172", "弘前",
"81863", "玉野",
"818375", "美祢",
"81142", "伊達",
"818655", "鴨方",
"811632", "天塩",
"811987", "遠野",
"81948", "飯塚",
"812672", "小諸",
"819726", "臼杵",
"819594", "有川",
"815953", "上野",
"812998", "潮来",
"812482", "白河",
"817993", "洲本",
"819966", "出水",
"81935", "北九州",
"818292", "広島",
"81561", "瀬戸",
"818556", "江津",
"812782", "沼田",
"81134", "小樽",
"817907", "播磨山崎",
"818679", "新見",
"812692", "中野",
"815565", "鰍沢青柳",
"81779", "大野",
"811864", "大館",
"81538", "磐田",
"819574", "諫早",
"8168", "大阪",
"812978", "竜ケ崎",
"815735", "恵那",
"81969", "天草",
"817946", "三木",
"81545", "富士",
"812573", "柏崎",
"812546", "村上",
"818597", "根雨",
"814228", "武蔵野三鷹",
"811635", "浜頓別",
"81946", "甘木",
"818652", "倉敷",
"818372", "長門",
"812419", "田島",
"811234", "千歳",
"815997", "阿児",
"819544", "武雄",
"81124", "芦別",
"819555", "唐津",
"817943", "加古川",
"81766", "高岡",
"818242", "東広島",
"817957", "丹波柏原",
"812576", "十日町",
"812543", "新発田",
"819808", "八重山",
"812557", "新井",
"81992", "鹿児島",
"81721", "富田林",
"819738", "玖珠",
"81744", "大和高田",
"812964", "下館",
"819723", "佐伯",
"812642", "木曾福島",
"811545", "釧路",
"81930", "行橋",
"8182943", "広島",
"81925", "福岡",
"812659", "伊那",
"815585", "下田",
"817230", "寝屋川",
"815956", "上野",
"812237", "仙台",
"81774", "宇治",
"815977", "熊野",
"819438", "田主丸",
"818958", "御荘",
"817734", "福知山",
"81482", "川口",
"81964", "松橋",
"817996", "津名",
"819963", "川内",
"818553", "浜田",
"811554", "帯広",
"818547", "掛合",
"81583", "岐阜",
"811878", "大曲",
"818478", "東城",
"81562", "尾張横須賀",
"818204", "柳井",
"811646", "羽幌",
"817497", "長浜",
"812838", "佐野",
"811353", "余市",
"818674", "久世",
"817616", "小松",
"815732", "恵那",
"811869", "大館",
"81463", "平塚",
"81250", "新津",
"815757", "郡上八幡",
"817363", "和歌山橋本",
"815743", "美濃加茂",
"815562", "鰍沢青柳",
"818688", "美作",
"819824", "延岡",
"812695", "中野",
"811536", "厚岸",
"812785", "沼田",
"817456", "大和高田",
"818694", "岡山",
"81286", "宇都宮",
"818295", "廿日市",
"81594", "桑名",
"819787", "国東",
"812485", "白河",
"818798", "土庄",
"819599", "大瀬戸",
"818360", "小郡",
"819677", "矢部",
"811466", "えりも",
"817687", "能都",
"812675", "佐久",
"81233", "新庄",
"817703", "敦賀",
"81857", "鳥取",
"819823", "延岡",
"817364", "和歌山橋本",
"815744", "美濃加茂",
"81950", "平戸",
"812579", "小出",
"817495", "長浜",
"818592", "米子",
"812697", "飯山",
"818673", "福渡",
"811354", "余市",
"817902", "福崎",
"818203", "柳井",
"81543", "静岡",
"815755", "関",
"812571", "六日町",
"812416", "田島",
"819785", "豊後高田",
"818297", "廿日市",
"812246", "大河原",
"818466", "木江",
"812487", "須賀川",
"812787", "沼田",
"81157", "北見",
"81986", "都城",
"817704", "敦賀",
"817475", "下市",
"812656", "伊那",
"81898", "今治",
"818693", "邑久",
"812376", "寒河江",
"812677", "佐久",
"811982", "花巻",
"815768", "下呂",
"819205", "厳原",
"817685", "輪島",
"815959", "亀山",
"819675", "熊本一の宮",
"81933", "北九州",
"81434", "千葉",
"817944", "加古川",
"81246", "いわき",
"815995", "阿児",
"811637", "北見枝幸",
"811336", "石狩",
"8188096", "土佐清水",
"81276", "太田",
"812544", "新発田",
"811652", "士別",
"812555", "糸魚川",
"81460", "小田原",
"811372", "鹿部",
"81253", "新潟",
"81427", "相模原",
"819948", "志布志",
"819557", "唐津",
"819576", "島原",
"811866", "鷹巣",
"811233", "千歳",
"819543", "武雄",
"817955", "三田",
"81793", "姫路",
"81292", "水戸",
"819964", "川内",
"815587", "修善寺大仁",
"817728", "峰山",
"811958", "岩手",
"81225", "石巻",
"812235", "仙台",
"817733", "福知山",
"818878", "嶺北",
"811553", "帯広",
"812917", "水戸",
"812890", "宇都宮",
"811547", "白糠",
"818554", "浜田",
"8125485", "津川",
"818545", "木次",
"81429", "所沢",
"817968", "浜坂",
"811392", "木古内",
"819724", "佐伯",
"817459", "大和榛原",
"812963", "下館",
"81839", "山口",
"811539", "根室標津",
"819596", "福江",
"812568", "巻",
"815362", "新城",
"81439", "木更津",
"81471", "柏",
"817994", "洲本",
"819672", "熊本一の宮",
"817736", "舞鶴",
"817682", "輪島",
"818848", "牟岐",
"8186992", "備前",
"8112390", "夕張",
"811556", "帯広",
"8183768", "下関",
"81182", "横手",
"817472", "五条",
"81220", "迫",
"81235", "鶴岡",
"815954", "上野",
"819593", "大瀬戸",
"8182941", "広島",
"819782", "豊後高田",
"8161", "大阪",
"81465", "小田原",
"815752", "関",
"81827", "岩国",
"812858", "真岡",
"811333", "当別",
"812574", "柏崎",
"817905", "福崎",
"819978", "徳之島",
"81424", "武蔵野三鷹",
"817492", "彦根",
"818595", "米子",
"81834", "徳山",
"819573", "諫早",
"811863", "鹿角",
"819546", "鹿島",
"811236", "千歳",
"8198292", "延岡",
"815737", "中津川",
"812588", "長岡",
"812243", "白石",
"819969", "中甑",
"811464", "静内",
"818463", "竹原",
"81923", "福岡",
"818559", "川本",
"8199347", "鹿児島",
"818542", "安来",
"811395", "江差",
"818696", "備前",
"812647", "長野",
"812373", "村山",
"817454", "大和高田",
"818397", "小郡",
"812653", "飯田",
"81585", "揖斐川",
"811534", "中標津",
"8167", "大阪",
"8198290", "延岡",
"814297", "飯能",
"8164", "大阪",
"812232", "岩沼",
"819912", "中之島",
"815972", "尾鷲",
"817949", "加古川",
"8112392", "夕張",
"819826", "日向",
"817952", "西脇",
"818247", "庄原",
"81988", "那覇",
"811375", "八雲",
"812549", "津川",
"8178", "神戸",
"812552", "上越",
"811655", "名寄",
"81896", "伊予三島",
"818206", "柳井",
"818657", "笠岡",
"811644", "留萌",
"818377", "下関",
"818676", "久世",
"8147957", "八日市場",
"8182920", "廿日市",
"8186552", "倉敷",
"817718", "園部",
"815992", "鳥羽",
"812930", "水戸",
"812413", "喜多方",
"817614", "小松",
"811983", "花巻",
"8112394", "夕張",
"81728", "寝屋川",
"81927", "福岡",
"812679", "佐久",
"818692", "邑久",
"811588", "興部",
"812236", "仙台",
"815957", "上野",
"81566", "刈谷",
"819595", "有川",
"818978", "伯方",
"81740", "今津",
"812489", "須賀川",
"817997", "津名",
"81934", "北九州",
"818299", "広島",
"818546", "掛合",
"812789", "前橋",
"811858", "能代",
"81167", "富良野",
"81929", "福岡",
"817903", "福崎",
"818672", "福渡",
"81282", "栃木",
"818202", "柳井",
"8186553", "倉敷",
"815734", "恵那",
"815996", "阿児",
"819575", "諫早",
"811865", "大館",
"817956", "三田",
"819822", "延岡",
"815564", "鰍沢青柳",
"812556", "糸魚川",
"81178", "八戸",
"812577", "六日町",
"81544", "富士宮",
"814220", "国分寺",
"818593", "米子",
"8112393", "夕張",
"812962", "下館",
"811537", "中標津",
"817476", "下市",
"811393", "松前",
"812644", "木曾福島",
"817457", "大和高田",
"818268", "千代田",
"81888", "高知",
"811541", "弟子屈",
"819786", "杵築",
"812245", "大河原",
"812911", "鉾田",
"815363", "新城",
"81942", "久留米",
"812748", "富岡",
"817686", "能都",
"817732", "福知山",
"818660", "岡山瀬戸",
"819676", "高森",
"8186993", "備前",
"815589", "修善寺大仁",
"812655", "飯田",
"811552", "帯広",
"811549", "釧路",
"81263", "松本",
"812375", "村山",
"81762", "金沢",
"8199345", "鹿児島",
"8198294", "延岡",
"81532", "豊橋",
"818374", "長門",
"811653", "士別",
"8147955", "八日市場",
"8198293", "延岡",
"817496", "長浜",
"818654", "鴨方",
"811647", "羽幌",
"81823", "呉",
"814708", "大原",
"817617", "加賀",
"8186994", "岡山瀬戸",
"819542", "武雄",
"811232", "千歳",
"81433", "千葉",
"814288", "青梅",
"815756", "郡上八幡",
"818244", "三次",
"812415", "柳津",
"818388", "田万川",
"81191", "一関",
"81486", "浦和",
"819938", "加世田",
"811639", "利尻礼文",
"814770", "市川",
"812830", "宇都宮",
"817493", "彦根",
"811376", "八雲",
"812694", "中野",
"8186998", "岡山瀬戸",
"811656", "美深",
"811357", "岩内",
"81886", "徳島",
"819825", "日向",
"811862", "鹿角",
"819572", "諫早",
"812798", "長野原",
"81797", "西宮",
"815753", "関",
"818680", "岡山",
"817367", "岩出",
"81998", "鹿児島",
"815747", "美濃白川",
"818205", "柳井",
"818675", "久世",
"814758", "東金",
"81833", "下松",
"811332", "当別",
"81423", "国分寺",
"812478", "三春",
"818838", "阿波池田",
"812674", "小諸",
"817473", "五条",
"811396", "江差",
"818490", "尾道",
"815366", "設楽",
"819783", "豊後高田",
"819592", "大瀬戸",
"81281", "宇都宮",
"812484", "白河",
"819673", "熊本一の宮",
"817683", "輪島",
"8198298", "日向",
"818294", "廿日市",
"818368", "宇部",
"818695", "岡山瀬戸",
"817707", "小浜",
"81488", "浦和",
"81259", "佐渡",
"812784", "沼田",
"817906", "播磨山崎",
"814998", "小笠原",
"81726", "茨木",
"812412", "喜多方",
"815993", "鳥羽",
"81568", "春日井",
"819554", "伊万里",
"811235", "夕張",
"81125", "滝川",
"817947", "三木",
"811738", "鰺ケ沢",
"81939", "北九州",
"817953", "西脇",
"81577", "高山",
"818249", "東広島",
"81547", "島田",
"818596", "米子",
"812547", "村上",
"812553", "上越",
"811634", "浜頓別",
"811986", "遠野",
"812649", "長野",
"819727", "臼杵",
"81924", "福岡",
"812372", "村山",
"811555", "帯広",
"812652", "飯田",
"81192", "大船渡",
"817238", "寝屋川",
"812233", "岩沼",
"817735", "福知山",
"81775", "大津",
"815973", "尾鷲",
"8112398", "栗山",
"819913", "硫黄島",
"814291", "飯能",
"818948", "宇和",
"818462", "竹原",
"81531", "田原",
"812242", "白石",
"81937", "北九州",
"815584", "下田",
"81965", "八代",
"818391", "小郡",
"819967", "出水",
"81738", "御坊",
"811544", "釧路",
"818557", "川本",
"818543", "安来",
"81549", "静岡",
"812914", "鉾田",
"81176", "十和田",
"812965", "下館",
"8125487", "津川",
"81420", "所沢",
"817954", "西脇",
"81467", "藤沢",
"815566", "身延",
"8186697", "倉敷",
"8112391", "夕張",
"81825", "広島",
"812878", "烏山",
"8169", "大阪",
"812554", "上越",
"812545", "村上",
"811642", "石狩深川",
"81864", "倉敷",
"819940", "志布志",
"819553", "伊万里",
"81478", "佐原",
"8112399", "栗山",
"819547", "鹿島",
"815994", "阿児",
"811237", "栗山",
"815736", "中津川",
"817612", "小松",
"818568", "津和野",
"817945", "加古川",
"815583", "下田",
"811462", "浦河",
"817737", "舞鶴",
"815988", "三瀬谷",
"812898", "鹿沼",
"812913", "鉾田",
"818544", "木次",
"811557", "十勝池田",
"819233", "前原",
"811543", "釧路",
"819725", "佐伯",
"81853", "出雲",
"817452", "大和高田",
"818555", "江津",
"817960", "八鹿",
"812967", "笠間",
"811532", "根室",
"815974", "尾鷲",
"812560", "糸魚川",
"818808", "土佐清水",
"812234", "仙台",
"819965", "川内",
"81892", "久万",
"819827", "高千穂",
"818246", "三次",
"8198299", "日向",
"815754", "関",
"8153977", "天竜",
"812572", "柏崎",
"818376", "美祢",
"81298", "土浦",
"812693", "中野",
"818677", "新見",
"818207", "久賀",
"818656", "笠岡",
"817494", "彦根",
"815745", "美濃加茂",
"817365", "和歌山橋本",
"8198291", "延岡",
"81551", "韮崎",
"817992", "洲本",
"818293", "廿日市",
"817488", "水口",
"817684", "輪島",
"819204", "郷ノ浦",
"812483", "白河",
"819674", "熊本一の宮",
"812783", "沼田",
"815398", "浜松",
"817474", "五条",
"817705", "小浜",
"8186999", "岡山瀬戸",
"812646", "長野",
"818697", "備前",
"812673", "小諸",
"81587", "一宮",
"819688", "玉名",
"817678", "七尾",
"8182942", "広島",
"815952", "上野",
"819784", "豊後高田",
"81272", "前橋",
"812247", "大河原",
"818296", "広島",
"819962", "川内",
"812486", "須賀川",
"818467", "木江",
"811535", "厚岸",
"812786", "沼田",
"817455", "大和高田",
"818552", "浜田",
"81242", "会津若松",
"818549", "石見大田",
"81743", "奈良",
"81584", "大垣",
"812377", "寒河江",
"812643", "木曾福島",
"812676", "佐久",
"819722", "佐伯",
"811394", "松前",
"812657", "伊那",
"81963", "熊本",
"811465", "静内",
"812239", "仙台",
"815979", "熊野",
"81188", "秋田",
"8125486", "津川",
"817942", "加古川",
"817468", "上北山",
"817615", "小松",
"818243", "東広島",
"817959", "三田",
"811645", "留萌",
"812542", "新発田",
"812559", "安塚",
"811374", "森",
"811654", "名寄",
"818373", "長門",
"812696", "飯山",
"819668", "水俣",
"815999", "津",
"8188095", "土佐清水",
"812938", "水戸",
"812551", "上越",
"812417", "会津山口",
"815586", "下田",
"819679", "高森",
"811978", "北上",
"81227", "仙台",
"815955", "上野",
"81260", "阿南町",
"81593", "四日市",
"81492", "川越",
"81552", "甲府",
"811546", "釧路",
"817702", "敦賀",
"81234", "酒田",
"811984", "花巻",
"81476", "成田",
"819597", "福江",
"818588", "郡家",
"819789", "杵築",
"817995", "洲本",
"81464", "厚木",
"815563", "鰍沢青柳",
"81848", "尾道",
"815742", "美濃加茂",
"81229", "古川",
"817362", "和歌山橋本",
"811636", "北見枝幸",
"811337", "石狩",
"81878", "高松",
"818594", "米子",
"812575", "十日町",
"811352", "余市",
"817904", "福崎",
"81425", "立川",
"81835", "防府",
"811867", "鷹巣",
"819577", "島原",
"819556", "唐津",
"812580", "十日町",
"815733", "恵那",
"812678", "佐久",
"8198296", "日向",
"818834", "鴨島",
"817353", "新宮",
"812474", "石川",
"819683", "山鹿",
"818690", "岡山",
"815767", "下呂",
"817673", "羽咋",
"81487", "浦和",
"811589", "興部",
"811363", "倶知安",
"817483", "八日市",
"818298", "廿日市",
"818364", "宇部",
"812992", "石岡",
"818795", "三本松",
"812488", "須賀川",
"812788", "前橋",
"819746", "竹田",
"815393", "浜松",
"812698", "飯山",
"81798", "西宮",
"819666", "水俣",
"81591", "津",
"811456", "門別富川",
"812794", "渋川",
"811756", "野辺地",
"81489", "草加",
"818685", "津山",
"812936", "水戸",
"8186996", "岡山瀬戸",
"817466", "十津川",
"812972", "水海道",
"814222", "武蔵野三鷹",
"818475", "府中",
"812835", "佐野",
"814754", "茂原",
"81765", "魚津",
"81938", "北九州",
"817967", "八鹿",
"81737", "湯浅",
"811522", "斜里",
"81852", "松江",
"811875", "角館",
"818803", "土佐中村",
"81893", "大洲",
"818955", "宇和島",
"812567", "巻",
"818586", "倉吉",
"811932", "釜石",
"812382", "米沢",
"81724", "岸和田貝塚",
"818662", "高梁",
"815588", "修善寺大仁",
"817727", "峰山",
"818944", "八幡浜",
"811957", "岩手",
"819435", "八女",
"81166", "旭川",
"811976", "北上",
"811943", "岩泉",
"8112396", "栗山",
"81975", "大分",
"819735", "日田",
"812893", "宇都宮",
"81569", "半田",
"815983", "松阪",
"818877", "嶺北",
"814792", "銚子",
"811548", "弟子屈",
"81739", "田辺",
"814994", "三宅",
"81144", "苫小牧",
"819953", "大口",
"819947", "志布志",
"819805", "名護",
"81578", "神岡",
"814281", "相模原",
"812612", "大町",
"819558", "唐津",
"814709", "鴨川",
"81548", "榛原",
"811564", "上士幌",
"81174", "蟹田",
"818563", "益田",
"81926", "福岡",
"8165", "大阪",
"811734", "五所川原",
"814289", "青梅",
"8153974", "天竜",
"812873", "大田原",
"81567", "津島",
"81535", "浜松",
"811638", "利尻礼文",
"814772", "市川",
"814701", "鴨川",
"819977", "瀬戸内",
"812832", "佐野",
"81936", "北九州",
"819956", "加治木",
"814225", "武蔵野三鷹",
"818472", "甲山",
"812975", "水海道",
"812799", "長野原",
"81177", "青森",
"812587", "長岡",
"815738", "中津川",
"818682", "津山",
"81983", "高鍋",
"81729", "八尾",
"812857", "真岡",
"81564", "岡崎",
"812876", "黒磯",
"8188090", "窪川",
"81734", "和歌山",
"81940", "宗像",
"818792", "三本松",
"818806", "宿毛",
"812995", "石岡",
"818583", "倉吉",
"81179", "三戸",
"81546", "静岡",
"811584", "遠軽",
"818369", "宇部",
"81727", "池田",
"81592", "津",
"81928", "福岡",
"811973", "水沢",
"811946", "久慈",
"818974", "新居浜",
"818847", "牟岐",
"812896", "鹿沼",
"811854", "男鹿",
"815986", "松阪",
"817916", "竜野",
"81493", "東松山",
"81553", "山梨",
"8111", "札幌",
"814775", "船橋",
"8125481", "村上",
"818378", "下関",
"811453", "早来",
"819663", "人吉",
"817717", "園部",
"813", "東京",
"811753", "むつ",
"81280", "古河",
"812933", "高萩",
"814704", "館山",
"817463", "吉野",
"818384", "萩",
"818248", "庄原",
"8186698", "倉敷",
"812615", "大町",
"814284", "立川",
"819934", "指宿",
"819802", "南大東",
"8125489", "津川",
"818264", "安芸吉田",
"818398", "小郡",
"812648", "長野",
"814795", "銚子",
"819732", "日田",
"817676", "七尾",
"817356", "串本",
"814298", "飯能",
"819686", "玉名",
"812744", "藤岡",
"81484", "川口",
"819432", "八女",
"818665", "高梁",
"817239", "寝屋川",
"81962", "熊本",
"812385", "米沢",
"817486", "水口",
"811935", "釜石",
"8188092", "窪川",
"811366", "寿都",
"81273", "高崎",
"818952", "宇和島",
"818949", "宇和",
"81742", "奈良",
"81243", "二本松",
"819743", "三重",
"815396", "浜松",
"811525", "網走",
"8124196", "柳津",
"814283", "青梅",
"818512", "西郷",
"81586", "一宮",
"818383", "萩",
"817464", "吉野",
"81294", "常陸太田",
"814756", "東金",
"814777", "船橋",
"817715", "亀岡",
"818892", "佐川",
"812879", "烏山",
"819933", "指宿",
"819664", "人吉",
"811454", "鵡川",
"81533", "豊橋",
"811658", "上川",
"811378", "今金",
"819942", "大根占",
"814703", "館山",
"81432", "千葉",
"812934", "高萩",
"812796", "渋川",
"811754", "むつ",
"81822", "広島",
"812617", "大町",
"811952", "二戸",
"81550", "御殿場",
"812387", "長井",
"818366", "宇部",
"817722", "宮津",
"818667", "井原",
"814797", "八日市場",
"8125488", "津川",
"81956", "佐世保",
"8162", "大阪",
"819744", "三重",
"812899", "鹿沼",
"818872", "室戸",
"81763", "福野",
"81262", "長野",
"812476", "三春",
"8153962", "天竜",
"817962", "豊岡",
"811398", "熊石",
"818263", "加計",
"811527", "美幌",
"818836", "脇町",
"8112397", "栗山",
"812562", "三条",
"815368", "設楽",
"8186691", "倉敷",
"811937", "宮古",
"812743", "藤岡",
"8147950", "八日市場",
"812956", "常陸大宮",
"81236", "山形",
"812977", "竜ケ崎",
"812585", "長岡",
"811736", "五所川原",
"818598", "根雨",
"819975", "名瀬",
"812570", "小出",
"81474", "船橋",
"814227", "武蔵野三鷹",
"8186997", "岡山瀬戸",
"812855", "小山",
"814996", "八丈島",
"817908", "播磨山崎",
"81877", "丸亀",
"811566", "十勝清水",
"8153960", "天竜",
"812997", "潮来",
"818946", "宇和",
"818973", "新居浜",
"811974", "水沢",
"8198297", "日向",
"81240", "磐城富岡",
"81270", "伊勢崎",
"815399", "天竜",
"811853", "男鹿",
"81228", "築館",
"815762", "下呂",
"818845", "丹生谷",
"81849", "福山",
"81466", "藤沢",
"811583", "紋別",
"818584", "倉吉",
"818957", "御荘",
"811944", "岩泉",
"818943", "八幡浜",
"818976", "新居浜",
"812565", "三条",
"817965", "豊岡",
"818548", "石見大田",
"815984", "松阪",
"812894", "宇都宮",
"811856", "能代",
"811877", "大曲",
"817914", "相生",
"818875", "土佐山田",
"819737", "玖珠",
"81245", "福島",
"817725", "宮津",
"811586", "中湧別",
"812238", "仙台",
"818804", "土佐中村",
"819437", "田主丸",
"815978", "熊野",
"8124197", "柳津",
"811955", "二戸",
"817940", "加古川",
"811733", "五所川原",
"817958", "丹波柏原",
"8144", "川崎",
"819807", "沖縄宮古",
"819945", "鹿屋",
"812558", "新井",
"812874", "大田原",
"817712", "亀岡",
"818895", "須崎",
"81226", "気仙沼",
"81468", "横須賀",
"819954", "加治木",
"818564", "益田",
"812939", "水戸",
"811563", "本別",
"815998", "阿児",
"819678", "矢部",
"819208", "対馬佐賀",
"817688", "能都",
"8125484", "村上",
"818363", "宇部",
"817484", "八日市",
"811364", "倶知安",
"815394", "浜松",
"81184", "本荘",
"818842", "阿南",
"815765", "下呂",
"81555", "吉田",
"817674", "羽咋",
"812473", "石川",
"817354", "新宮",
"81495", "本庄",
"819684", "山鹿",
"818266", "千代田",
"818833", "鴨島",
"819788", "国東",
"8163", "大阪",
"818797", "土庄",
"812746", "富岡",
"815758", "郡上八幡",
"814286", "相模原",
"818687", "美作",
"81958", "長崎",
"814753", "茂原",
"812852", "小山",
"8175", "京都",
"819936", "加世田",
"81832", "下関",
"818477", "東城",
"819972", "種子島",
"817498", "長浜",
"812837", "佐野",
"8125483", "村上",
"814706", "大原",
"812582", "長岡",
"81985", "宮崎",
"812793", "渋川",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+81|\D)//g;
      my $self = bless({ country_code => '81', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '81', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;