# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20210309172131;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8001111',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '845464',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              3873|
              5(?:
                242|
                39[4-6]
              )|
              (?:
                697|
                768
              )[347]|
              9467
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{4,5})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              [2-69][02-9]|
              [78]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [25]|
            7(?:
              0|
              6(?:
                [03-9]|
                2[356]
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[1389]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '1534[0-24-8]\\d{5}',
                'geographic' => '1534[0-24-8]\\d{5}',
                'mobile' => '
          7(?:
            (?:
              (?:
                50|
                82
              )9|
              937
            )\\d|
            7(?:
              00[378]|
              97[7-9]
            )
          )\\d{5}
        ',
                'pager' => '
          76(?:
            464|
            652
          )\\d{5}|
          76(?:
            0[0-2]|
            2[356]|
            34|
            4[01347]|
            5[49]|
            6[0-369]|
            77|
            81|
            9[139]
          )\\d{6}
        ',
                'personal_number' => '701511\\d{4}',
                'specialrate' => '(
          (?:
            8(?:
              4(?:
                4(?:
                  4(?:
                    05|
                    42|
                    69
                  )|
                  703
                )|
                5(?:
                  041|
                  800
                )
              )|
              7(?:
                0002|
                1206
              )
            )|
            90(?:
              066[59]|
              1810|
              71(?:
                07|
                55
              )
            )
          )\\d{4}
        )|(
          (?:
            3(?:
              0(?:
                07(?:
                  35|
                  81
                )|
                8901
              )|
              3\\d{4}|
              4(?:
                4(?:
                  4(?:
                    05|
                    42|
                    69
                  )|
                  703
                )|
                5(?:
                  041|
                  800
                )
              )|
              7(?:
                0002|
                1206
              )
            )|
            55\\d{4}
          )\\d{4}
        )',
                'toll_free' => '
          80(?:
            07(?:
              35|
              81
            )|
            8901
          )\\d{4}
        ',
                'voip' => '56\\d{8}'
              };
my %areanames = ();
$areanames{en} = {"441361", "Duns",
"441455", "Hinckley",
"441948", "Whitchurch",
"441360", "Killearn",
"441453", "Dursley",
"441561", "Laurencekirk",
"441560", "Moscow",
"441728", "Saxmundham",
"442825", "Ballymena",
"441859", "Harris",
"4412297", "Millom",
"441777", "Retford",
"4414340", "Bellingham\/Haltwhistle\/Hexham",
"441376", "Braintree",
"441995", "Garstang",
"441576", "Lockerbie",
"441993", "Witney",
"441372", "Esher",
"4412299", "Millom",
"441674", "Montrose",
"441572", "Oakham",
"441917", "Sunderland",
"441408", "Golspie",
"4414343", "Haltwhistle",
"441953", "Wymondham",
"441955", "Wick",
"441626", "Newton\ Abbot",
"441479", "Grantown\-on\-Spey",
"441524", "Lancaster",
"4415078", "Alford\ \(Lincs\)",
"441875", "Tranent",
"441324", "Falkirk",
"441622", "Maidstone",
"441873", "Abergavenny",
"441381", "Fortrose",
"441380", "Devizes",
"4414375", "Clynderwen\ \(Clunderwen\)",
"441581", "New\ Luce",
"441493", "Great\ Yarmouth",
"441840", "Camelford",
"441580", "Cranbrook",
"441841", "Newquay\ \(Padstow\)",
"441495", "Pontypool",
"442830", "Newry",
"44117", "Bristol",
"441899", "Biggar",
"441937", "Wetherby",
"441908", "Milton\ Keynes",
"44292", "Cardiff",
"4417683", "Appleby",
"44147985", "Dulnain\ Bridge",
"442893", "Ballyclare",
"441214", "Birmingham",
"441770", "Isle\ of\ Arran",
"442895", "Belfast",
"441688", "Isle\ of\ Mull\ \-\ Tobermory",
"441771", "Maud",
"441202", "Bournemouth",
"4413397", "Ballater",
"441283", "Burton\-on\-Trent",
"441431", "Helmsdale",
"441910", "Tyneside\/Durham\/Sunderland",
"441798", "Pulborough",
"4415076", "Louth",
"441911", "Tyneside\/Durham\/Sunderland",
"441285", "Cirencester",
"441206", "Colchester",
"4418902", "Coldstream",
"4418475", "Thurso",
"4416863", "Llanidloes",
"4413399", "Ballater",
"441554", "Llanelli",
"441567", "Killin",
"441652", "Brigg",
"441766", "Porthmadog",
"4414235", "Harrogate",
"441354", "Chatteris",
"441367", "Faringdon",
"442879", "Magherafelt",
"441925", "Warrington",
"441923", "Watford",
"441743", "Shrewsbury",
"441656", "Bridgend",
"441745", "Rhyl",
"441838", "Dalmally",
"441807", "Ballindalloch",
"441394", "Felixstowe",
"4416860", "Newtown\/Llanidloes",
"441692", "North\ Walsham",
"441594", "Lydney",
"441234", "Bedford",
"4414305", "North\ Cave",
"441786", "Stirling",
"441387", "Dumfries",
"441931", "Shap",
"442837", "Armagh",
"441782", "Stoke\-on\-Trent",
"441246", "Chesterfield",
"441829", "Tarporley",
"4415074", "Alford\ \(Lincs\)",
"441668", "Bamburgh",
"4418512", "Stornoway",
"441263", "Cromer",
"441242", "Cheltenham",
"441425", "Ringwood",
"441758", "Pwllheli",
"4415071", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441442", "Hemel\ Hempstead",
"441350", "Dunkeld",
"441225", "Bath",
"441465", "Girvan",
"441142", "Sheffield",
"441223", "Cambridge",
"441309", "Forres",
"441463", "Inverness",
"441550", "Llandovery",
"441509", "Loughborough",
"441869", "Bicester",
"441446", "Barry",
"4419757", "Strathdon",
"441628", "Maidenhead",
"441983", "Isle\ of\ Wight",
"4418901", "Coldstream\/Ayton",
"4414370", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"4418516", "Great\ Bernera",
"441211", "Birmingham",
"441985", "Warminster",
"441210", "Birmingham",
"4418904", "Coldstream",
"441677", "Bedale",
"441914", "Tyneside",
"441902", "Wolverhampton",
"44161", "Manchester",
"4419759", "Alford\ \(Aberdeen\)",
"441963", "Wincanton",
"4414373", "Clynderwen\ \(Clunderwen\)",
"4415072", "Spilsby\ \(Horncastle\)",
"441942", "Wigan",
"441639", "Neath",
"441722", "Salisbury",
"4418906", "Ayton",
"4418511", "Great\ Bernera\/Stornoway",
"441527", "Redditch",
"441946", "Whitehaven",
"441327", "Daventry",
"4418514", "Great\ Bernera",
"441726", "St\ Austell",
"441485", "Hunstanton",
"441590", "Lymington",
"4414345", "Haltwhistle",
"441483", "Guildford",
"441591", "Llanwrtyd\ Wells",
"441406", "Holbeach",
"441889", "Rugeley",
"441549", "Lairg",
"441934", "Weston\-super\-Mare",
"441349", "Dingwall",
"441578", "Lauder",
"441698", "Motherwell",
"442885", "Ballygawley",
"4416865", "Newtown",
"441217", "Birmingham",
"4418908", "Coldstream",
"4414233", "Boroughbridge",
"4414300", "North\ Cave\/Market\ Weighton",
"441335", "Ashbourne",
"441333", "Peat\ Inn\ \(Leven\ \(Fife\)\)",
"441295", "Banbury",
"441670", "Morpeth",
"441535", "Keighley",
"441788", "Rugby",
"441671", "Newton\ Stewart",
"441293", "Crawley",
"441557", "Kirkcudbright",
"441564", "Lapworth",
"441756", "Skipton",
"441357", "Strathaven",
"441643", "Minehead",
"441364", "Ashburton",
"4413873", "Langholm",
"441248", "Bangor\ \(Gwynedd\)",
"4418473", "Thurso",
"441279", "Bishops\ Stortford",
"441752", "Plymouth",
"441666", "Malmesbury",
"441397", "Fort\ William",
"441796", "Pitlochry",
"441844", "Thame",
"441584", "Ludlow",
"441208", "Bodmin",
"441237", "Bideford",
"441597", "Llandrindod\ Wells",
"441384", "Dudley",
"441792", "Swansea",
"441603", "Norwich",
"4418470", "Thurso\/Tongue",
"442842", "Kircubbin",
"4418518", "Stornoway",
"4414230", "Harrogate\/Boroughbridge",
"4414303", "North\ Cave",
"441253", "Blackpool",
"441255", "Clacton\-on\-Sea",
"441320", "Fort\ Augustus",
"441832", "Clopton",
"441768", "Penrith",
"441520", "Lochcarron",
"441700", "Rothesay",
"441497", "Hay\-on\-Wye",
"441759", "Pocklington",
"441484", "Huddersfield",
"4413391", "Aboyne\/Ballater",
"441669", "Rothbury",
"441935", "Yeovil",
"4415394", "Hawkshead",
"441276", "Camberley",
"441933", "Wellingborough",
"4413394", "Ballater",
"441828", "Coupar\ Angus",
"4419752", "Alford\ \(Aberdeen\)",
"441957", "Mid\ Yell",
"441420", "Alton",
"441261", "Banff",
"441877", "Callander",
"441260", "Congleton",
"4412298", "Barrow\-in\-Furness",
"441997", "Strathpeffer",
"442890", "Belfast",
"441775", "Spalding",
"442891", "Bangor\ \(Co\.\ Down\)",
"441984", "Watchet\ \(Williton\)",
"441773", "Ripley",
"4415079", "Alford\ \(Lincs\)",
"441433", "Hathersage",
"441915", "Sunderland",
"441280", "Buckingham",
"441913", "Durham",
"441435", "Heathfield",
"4413396", "Ballater",
"441224", "Aberdeen",
"44238", "Southampton",
"441457", "Glossop",
"4415396", "Sedbergh",
"441464", "Insch",
"441799", "Saffron\ Walden",
"441689", "Orpington",
"4419645", "Hornsea",
"441920", "Ware",
"441740", "Sedgefield",
"4413882", "Stanhope\ \(Eastgate\)",
"4415077", "Louth",
"442827", "Ballymoney",
"441951", "Colonsay",
"441950", "Sandwick",
"441909", "Worksop",
"4412294", "Barrow\-in\-Furness",
"4416974", "Raughton\ Head",
"441427", "Gainsborough",
"441870", "Isle\ of\ Benbecula",
"441254", "Blackburn",
"44291", "Cardiff",
"441267", "Carmarthen",
"441871", "Castlebay",
"4412291", "Barrow\-in\-Furness\/Millom",
"441383", "Dunfermline",
"441506", "Bathgate",
"4413398", "Aboyne",
"441843", "Thanet",
"441490", "Corwen",
"441306", "Dorking",
"441583", "Carradale",
"441491", "Henley\-on\-Thames",
"441845", "Thirsk",
"441738", "Perth",
"441707", "Welwyn\ Garden\ City",
"441862", "Tain",
"441478", "Isle\ of\ Skye\ \-\ Portree",
"441502", "Lowestoft",
"4420", "London",
"441449", "Stowmarket",
"441604", "Northampton",
"441866", "Kilchrenan",
"441302", "Doncaster",
"441644", "New\ Galloway",
"441409", "Holsworthy",
"441363", "Crediton",
"441342", "East\ Grinstead",
"441450", "Hawick",
"441451", "Stow\-on\-the\-Wold",
"441563", "Kilmarnock",
"441542", "Keith",
"441565", "Knutsford",
"441882", "Kinloch\ Rannoch",
"442820", "Ballycastle",
"441346", "Fraserburgh",
"442821", "Martinstown",
"441803", "Torquay",
"441747", "Shaftesbury",
"441805", "Torrington",
"44241", "Coventry",
"441546", "Lochgilphead",
"441886", "Bromyard\ \(Knightwick\/Leigh\ Sinton\)",
"442897", "Saintfield",
"441636", "Newark\-on\-Trent",
"441858", "Market\ Harborough",
"441534", "Jersey",
"441294", "Ardrossan",
"441729", "Settle",
"4412296", "Barrow\-in\-Furness",
"441978", "Wrexham",
"441334", "St\ Andrews",
"441949", "Whatton",
"441287", "Guisborough",
"441494", "High\ Wycombe",
"441769", "South\ Molton",
"441487", "Warboys",
"441659", "Sanquhar",
"441600", "Monmouth",
"4412292", "Barrow\-in\-Furness",
"441967", "Strontian",
"441954", "Madingley",
"441325", "Darlington",
"441874", "Brecon",
"4419640", "Hornsea\/Patrington",
"441250", "Blairgowrie",
"441209", "Redruth",
"441323", "Eastbourne",
"441525", "Leighton\ Buzzard",
"4419758", "Strathdon",
"441994", "St\ Clears",
"442881", "Newtownstewart",
"442880", "Carrickmore",
"441278", "Bridgwater",
"441987", "Ebbsfleet",
"441249", "Chippenham",
"4419643", "Patrington",
"441330", "Banchory",
"441673", "Market\ Rasen",
"441822", "Tavistock",
"441530", "Coalville",
"441675", "Coleshill",
"441290", "Cumnock",
"441291", "Chepstow",
"441531", "Ledbury",
"441789", "Stratford\-upon\-Avon",
"44239", "Portsmouth",
"441227", "Canterbury",
"441454", "Chipping\ Sodbury",
"441467", "Inverurie",
"441641", "Strathy",
"441579", "Liskeard",
"441348", "Fishguard",
"4419754", "Alford\ \(Aberdeen\)",
"441888", "Turriff",
"4418909", "Ayton",
"442867", "Lisnaskea",
"441548", "Kingsbridge",
"441379", "Diss",
"4419751", "Alford\ \(Aberdeen\)\/Strathdon",
"441424", "Hastings",
"441257", "Coppull",
"441264", "Andover",
"441595", "Lerwick\,\ Foula\ \&\ Fair\ Isle",
"441235", "Abingdon",
"4418907", "Ayton",
"441481", "Guernsey",
"441233", "Ashford\ \(Kent\)",
"441593", "Lybster",
"441480", "Huntingdon",
"441395", "Budleigh\ Salterton",
"441852", "Kilmelford",
"441704", "Southport",
"4413392", "Aboyne",
"441972", "Glenborrodale",
"441856", "Orkney",
"441638", "Newmarket",
"441353", "Ely",
"441647", "Moretonhampstead",
"441892", "Tunbridge\ Wells",
"441355", "East\ Kilbride",
"441461", "Gretna",
"4413881", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441460", "Chard",
"441553", "Kings\ Lynn",
"441555", "Lanark",
"4418517", "Stornoway",
"441744", "St\ Helens",
"441896", "Galashiels",
"441924", "Wakefield",
"441980", "Amesbury",
"441476", "Grantham",
"441981", "Wormbridge",
"441215", "Birmingham",
"4418519", "Great\ Bernera",
"442894", "Antrim",
"441629", "Matlock",
"441213", "Birmingham",
"441732", "Sevenoaks",
"442887", "Dungannon",
"441508", "Brooke",
"441297", "Axminster",
"441472", "Grimsby",
"441308", "Bridport",
"441337", "Ladybank",
"4419756", "Strathdon",
"441736", "Penzance",
"441284", "Bury\ St\ Edmunds",
"441241", "Arbroath",
"4414307", "Market\ Weighton",
"442889", "Fivemiletown",
"441724", "Scunthorpe",
"441299", "Bewdley",
"441539", "Kendal",
"441944", "West\ Heslerton",
"441932", "Weybridge",
"441404", "Honiton",
"4419644", "Patrington",
"441678", "Bala",
"441780", "Stamford",
"4414309", "Market\ Weighton",
"441275", "Clevedon",
"441690", "Betws\-y\-Coed",
"441691", "Oswestry",
"441273", "Brighton",
"4419641", "Hornsea\/Patrington",
"4413395", "Aboyne",
"441328", "Fakenham",
"441761", "Temple\ Cloud",
"4415395", "Grange\-over\-Sands",
"441760", "Swaffham",
"441528", "Laggan",
"4414239", "Boroughbridge",
"4418477", "Tongue",
"4419646", "Patrington",
"441444", "Haywards\ Heath",
"441609", "Northallerton",
"441144", "Sheffield",
"441650", "Cemmaes\ Road",
"441651", "Oldmeldrum",
"441912", "Tyneside",
"441577", "Kinross",
"44131", "Edinburgh",
"441432", "Hereford",
"4414237", "Harrogate",
"441904", "York",
"44151", "Liverpool",
"441377", "Driffield",
"441776", "Stranraer",
"441436", "Helensburgh",
"441916", "Tyneside",
"441772", "Preston",
"4418479", "Tongue",
"441200", "Clitheroe",
"441259", "Alloa",
"4414379", "Haverfordwest",
"441503", "Looe",
"441386", "Evesham",
"441505", "Johnstone",
"441787", "Sudbury",
"441794", "Romsey",
"441469", "Killingholme",
"441586", "Campbeltown",
"441303", "Folkestone",
"441305", "Dorchester",
"441684", "Malvern",
"4419648", "Hornsea",
"441382", "Dundee",
"441863", "Ardgay",
"441842", "Thetford",
"441697", "Brampton",
"4419750", "Alford\ \(Aberdeen\)\/Strathdon",
"441865", "Oxford",
"441582", "Luton",
"441834", "Narberth",
"441620", "North\ Berwick",
"4414377", "Haverfordwest",
"441621", "Maldon",
"441989", "Ross\-on\-Wye",
"441358", "Ellon",
"44116", "Leicester",
"442844", "Downpatrick",
"441558", "Llandeilo",
"441371", "Great\ Dunmow",
"441633", "Newport",
"441570", "Lampeter",
"441635", "Newbury",
"4413880", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441969", "Leyburn",
"441571", "Lochinver",
"4412295", "Barrow\-in\-Furness",
"44118", "Reading",
"441207", "Consett",
"441598", "Lynton",
"441398", "Dulverton",
"441366", "Downham\ Market",
"441754", "Skegness",
"441767", "Sandy",
"441489", "Bishops\ Waltham",
"441566", "Launceston",
"441343", "Elgin",
"441664", "Melton\ Mowbray",
"441806", "Shetland",
"441362", "Dereham",
"441543", "Cannock",
"441883", "Caterham",
"441545", "Llanarth",
"4419753", "Strathdon",
"441562", "Kidderminster",
"441885", "Pencombe",
"441322", "Dartford",
"441624", "Isle\ of\ Man",
"4413390", "Aboyne\/Ballater",
"441522", "Lincoln",
"44247", "Coventry",
"441830", "Kirkwhelpington",
"441727", "St\ Albans",
"442840", "Banbridge",
"441326", "Falmouth",
"442841", "Rostrevor",
"441526", "Martin",
"441289", "Berwick\-upon\-Tweed",
"441947", "Whitby",
"441407", "Holyhead",
"441438", "Stevenage",
"441790", "Spilsby",
"441918", "Tyneside",
"441749", "Shepton\ Mallet",
"441929", "Wareham",
"441681", "Isle\ of\ Mull\ \-\ Fionnphort",
"441778", "Bourne",
"441680", "Isle\ of\ Mull\ \-\ Craignure",
"441750", "Selkirk",
"441751", "Pickering",
"4416867", "Llanidloes",
"441709", "Rotherham",
"441661", "Prudhoe",
"4416869", "Newtown",
"441938", "Welshpool",
"4413393", "Aboyne",
"44147982", "Nethy\ Bridge",
"441825", "Uckfield",
"441823", "Taunton",
"4417687", "Keswick",
"441672", "Marlborough",
"441676", "Meriden",
"441269", "Ammanford",
"441429", "Hartlepool",
"4414349", "Bellingham",
"441236", "Coatbridge",
"4419642", "Hornsea",
"441784", "Staines",
"4412180", "Birmingham",
"441797", "Rye",
"4413885", "Stanhope\ \(Eastgate\)",
"441400", "Honington",
"441592", "Kirkcaldy",
"441687", "Mallaig",
"4412290", "Barrow\-in\-Furness\/Millom",
"441392", "Exeter",
"441694", "Church\ Stretton",
"441855", "Ballachulish",
"442829", "Kilrea",
"441808", "Tomatin",
"441837", "Okehampton",
"4414347", "Hexham",
"441244", "Chester",
"44115", "Nottingham",
"441368", "Dunbar",
"441568", "Leominster",
"441720", "Isles\ of\ Scilly",
"441721", "Peebles",
"441473", "Ipswich",
"442838", "Portadown",
"441475", "Greenock",
"441216", "Birmingham",
"4419467", "Gosforth",
"441900", "Workington",
"441959", "Westerham",
"441388", "Bishop\ Auckland",
"441879", "Scarinish",
"441212", "Birmingham",
"441204", "Bolton",
"441588", "Bishops\ Castle",
"4419755", "Alford\ \(Aberdeen\)",
"441848", "Thornhill",
"441733", "Peterborough",
"4416973", "Wigton",
"441356", "Brechin",
"441757", "Selby",
"441764", "Crieff",
"441499", "Inveraray",
"441556", "Castle\ Douglas",
"44147981", "Aviemore",
"441895", "Uxbridge",
"441654", "Machynlleth",
"441667", "Nairn",
"441141", "Sheffield",
"441440", "Haverhill",
"441352", "Mold",
"441140", "Sheffield",
"4412293", "Millom",
"441824", "Ruthin",
"441375", "Grays\ Thurrock",
"441373", "Frome",
"441630", "Market\ Drayton",
"441575", "Kirriemuir",
"441631", "Oban",
"441573", "Kelso",
"441488", "Hungerford",
"441992", "Lea\ Valley",
"441456", "Glenurquhart",
"4418513", "Stornoway",
"4414371", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"4418900", "Coldstream\/Ayton",
"441599", "Kyle",
"441239", "Cardigan",
"4414308", "Market\ Weighton",
"441340", "Craigellachie\ \(Aberlour\)",
"441452", "Gloucester",
"441341", "Barmouth",
"441968", "Penicuik",
"441540", "Kingussie",
"4414374", "Clynderwen\ \(Clunderwen\)",
"441880", "Tarbert",
"441501", "Harthill",
"4414376", "Haverfordwest",
"441559", "Llandysul",
"4418510", "Great\ Bernera\/Stornoway",
"441301", "Arrochar",
"4418903", "Coldstream",
"441496", "Port\ Ellen",
"441300", "Cerne\ Abbas",
"4414238", "Harrogate",
"441359", "Pakenham",
"441988", "Wigtown",
"441277", "Brentwood",
"441492", "Colwyn\ Bay",
"441872", "Truro",
"441623", "Mansfield",
"442311", "Southampton",
"442310", "Portsmouth",
"441625", "Macclesfield",
"4416862", "Llanidloes",
"441952", "Telford",
"441228", "Carlisle",
"4418478", "Thurso",
"441876", "Lochmaddy",
"441922", "Walsall",
"4414378", "Haverfordwest",
"441258", "Blandford",
"4414301", "North\ Cave\/Market\ Weighton",
"4414236", "Harrogate",
"441763", "Royston",
"441765", "Ripon",
"4419649", "Hornsea",
"441547", "Knighton",
"442868", "Kesh",
"441926", "Warwick",
"4414342", "Bellingham",
"441887", "Aberfeldy",
"4414304", "North\ Cave",
"441746", "Bridgnorth",
"441655", "Maybole",
"441653", "Malton",
"441347", "Easingwold",
"441637", "Newquay",
"441608", "Chipping\ Norton",
"441282", "Burnley",
"442896", "Belfast",
"441474", "Gravesend",
"441286", "Caernarfon",
"441529", "Sleaford",
"4415075", "Spilsby\ \(Horncastle\)",
"4419647", "Patrington",
"441329", "Fareham",
"442892", "Lisburn",
"4418476", "Tongue",
"441205", "Boston",
"441243", "Chichester",
"4418474", "Thurso",
"441245", "Chelmsford",
"441422", "Halifax",
"441262", "Bridlington",
"4418471", "Thurso\/Tongue",
"441706", "Rochdale",
"4414231", "Harrogate\/Boroughbridge",
"441307", "Forfar",
"4414306", "Market\ Weighton",
"441974", "Llanon",
"441785", "Stafford",
"441538", "Ipstones",
"441298", "Buxton",
"441270", "Crewe",
"441854", "Ullapool",
"441695", "Skelmersdale",
"441271", "Barnstaple",
"441702", "Southend\-on\-Sea",
"4414234", "Boroughbridge",
"441986", "Bungay",
"441827", "Tamworth",
"4418515", "Stornoway",
"441470", "Isle\ of\ Skye\ \-\ Edinbane",
"441471", "Isle\ of\ Skye\ \-\ Broadford",
"441903", "Worthing",
"441905", "Worcester",
"441982", "Builth\ Wells",
"441730", "Petersfield",
"441226", "Barnsley",
"441466", "Huntly",
"4414341", "Bellingham\/Haltwhistle\/Hexham",
"441389", "Dumbarton",
"441878", "Lochboisdale",
"441445", "Gairloch",
"441462", "Hitchin",
"441145", "Sheffield",
"441443", "Pontypridd",
"441143", "Sheffield",
"4414344", "Bellingham",
"4414302", "North\ Cave",
"441569", "Stonehaven",
"44281", "Northern\ Ireland",
"4414346", "Hexham",
"441971", "Scourie",
"441970", "Aberystwyth",
"441405", "Goole",
"441369", "Dunoon",
"442877", "Limavady",
"441403", "Horsham",
"441482", "Kingston\-upon\-Hull",
"441274", "Bradford",
"4414232", "Harrogate",
"441809", "Tomdoun",
"4416868", "Newtown",
"442828", "Larne",
"4418905", "Ayton",
"4418472", "Thurso",
"441943", "Guiseley",
"441962", "Winchester",
"441945", "Wisbech",
"441458", "Glastonbury",
"441725", "Rockbourne",
"441723", "Scarborough",
"441268", "Basildon",
"441428", "Haslemere",
"4414348", "Hexham",
"441753", "Slough",
"441646", "Milford\ Haven",
"4415073", "Louth",
"441544", "Kington",
"4414372", "Clynderwen\ \(Clunderwen\)",
"441884", "Tiverton",
"441939", "Wem",
"441642", "Middlesbrough",
"441665", "Alnwick",
"441344", "Bracknell",
"441663", "New\ Mills",
"441332", "Derby",
"44147984", "Carrbridge",
"441634", "Medway",
"44141", "Glasgow",
"4416866", "Newtown",
"442886", "Cookstown",
"441292", "Ayr",
"441477", "Holmes\ Chapel",
"441821", "Kinrossie",
"441737", "Redhill",
"441708", "Romford",
"442882", "Omagh",
"441536", "Kettering",
"441296", "Aylesbury",
"441779", "Peterhead",
"441928", "Runcorn",
"441252", "Aldershot",
"44147983", "Boat\ of\ Garten",
"442866", "Enniskillen",
"441835", "St\ Boswells",
"441748", "Richmond",
"4416861", "Newtown\/Llanidloes",
"441833", "Barnard\ Castle",
"441256", "Basingstoke",
"442843", "Newcastle\ \(Co\.\ Down\)",
"4416864", "Llanidloes",
"441919", "Durham",
"441439", "Helmsley",
"441288", "Bude",
"442870", "Coleraine",
"441795", "Sittingbourne",
"442871", "Londonderry",
"44113", "Leeds",
"441793", "Swindon",
"441304", "Dover",
"441977", "Pontefract",
"44147986", "Cairngorm",
"4415070", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441857", "Sanday",
"441606", "Northwich",
"441864", "Abington\ \(Crawford\)",
"441685", "Merthyr\ Tydfil",
"442898", "Belfast",
"4415242", "Hornby",
"441683", "Moffat",
"4417684", "Pooley\ Bridge",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+44|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      my $prefix = qr/^(?:0|([0-24-8]\d{5})$)/;
      my @matches = $number =~ /$prefix/;
      if (defined $matches[-1]) {
        no warnings 'uninitialized';
        $number =~ s/$prefix/1534$1/;
      }
      else {
        $number =~ s/$prefix//;
      }
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;