package oEdtk::prodEdtk;
use strict;

BEGIN{
		use Exporter ();
		use vars 	qw($VERSION @ISA @EXPORT); # @EXPORT_OK %EXPORT_TAGS);
		$VERSION 	=0.421;
		@ISA 	= qw(Exporter);
		@EXPORT 	= qw(
					prodEdtk_Current_Rec
					prodEdtk_Previous_Rec
					prodEdtk_rec		trtEdtkEnr
					prodEdtkOpen		prodEdtkClose
					fiEdtkOpen		foEdtkOpen
					foEdtkClose		prodEdtkAppUsage

					maj_sans_accents	mntSignX		mnt2txtUS
					date2time			nowTime		toDate
					toC7date			c7Flux		trimSP
					clean_adress_line

					recEdtk_erase		recEdtk_redefine
					recEdtk_motif		recEdtk_output
					recEdtk_pre_process recEdtk_join_tmplte
					recEdtk_process
					recEdtk_post_process
					trtEdtk_Add_Value

					env_System_Completion
					*OUT *IN  @DATATAB $LAST_ENR
					%motifs %ouTags %evalSsTrt
					);
	}

#
# CODE - DOC AT THE END
#

# METHODE GENERIQUE D'EXTRACTION ET DE TRAITEMENT DES DONNEES

 our @DATATAB;			# le tableau dans lequel les enregistrements sont ventils
 					# changer en OEDTK_DATATAB
 our $LAST_ENR		="";	# QUID LAST_ENR ????
 our $CURRENT_REC	=""; # enrgistrement courant
 our $PREVIOUS_REC	=""; # enregistrement prcdent

 our %motifs;		#rendre prive
 our %ouTags;		#rendre prive
 our %evalSsTrt;	#rendre prive

 my $TestAppMarkUp	="";
 my $pushValue		="";

 # PLANNED : CONFIGURATION OF OUTPUT SYSTEM
# my $PROD_EXT="-V1";
 my $C7r	="<SK>";	# un commentaire compuset (rem)
 my $C7o	="<";	# une ouverture de balise compuset (open)
 my $C7c	=">";	# une fermeture de balise compuset (close)


	sub recEdtk_erase ($){
		# FONCTION POUR SUPPRIMER LE TRAITEMENT D'UN ENREGISTREMENT
		#
		#  appel :
		# 	recEdtk_erase ($keyRec);
		my $keyRec=shift;
		$evalSsTrt{$keyRec}[0]="";
		$evalSsTrt{$keyRec}[1]="";	
		$evalSsTrt{$keyRec}[2]="";	
		$motifs{$keyRec}="";
		$ouTags{$keyRec}="-1";
	1;
	}

	sub recEdtk_redefine ($$){
		# FONCTION POUR REDEFINIR LE TRAITEMENT D'UN ENREGISTREMENT
		#
		#  appel :
		# 	recEdtk_redefine ($keyRec, "A2 A10 A15 A10 A15 A*");
		my $keyRec=shift;
		my $motif =shift;
		recEdtk_erase($keyRec);
		recEdtk_motif($keyRec, $motif);
	1;
	}


	sub recEdtk_motif ($$){
		# FONCTION POUR DCRIRE LE MOTIF UNPACK DE L'ENREGISTREMENT
		#
		#  appel :
		# 	recEdtk_motif ($keyRec, "A2 A10 A15 A10 A15 A*");
		my $keyRec=shift;
		my $motif =shift;
		$motifs{$keyRec}=$motif;	
	1;
	}

	sub recEdtk_join_tmplte ($$$){
		# FONCTION POUR COMPLTER LES DESCRIPTIF DU MOTIF UNPACK DE L'ENREGISTREMENT
		# ET DU FORMAT DE SORTIE EN PARALLLE
		#
		#  appel :
		# 	recEdtk_join_tmplte ("abc", 'A2', '<#tag=%s>');
		# 	recEdtk_join_tmplte ($keyRec, $motif, $output);

		my $keyRec=shift;
		my $motif	=shift;
		$motif	||="A*";
		my $output=shift;
		$output	||="%s";
		$motifs{$keyRec}.=$motif;	
		$ouTags{$keyRec}.=$output;
		$ouTags{$keyRec}=~s/^\-1//; # lorsque recEdtk_join_tmplte est utilis pour dfinir ouTags dynamiquement en cours de trtEdtkEnr, la valeur par dfaut de ouTags = '-1' (pas de traitement) => on le retire pour ne pas polluer la sortie
	1;
	}


	sub recEdtk_output ($$){
		# FONCTION POUR DCRIRE LE FORMAT DE SORTIE DE L'ENREGISTREMENT POUR SPRINTF
		#
		#  appel :
		# 	recEdtk_output ($keyRec, "<#GESTION=%s><#PENOCOD=%s><#LICCODC=%s><SK>%s");
		my $keyRec=shift;
		my $format=shift;
		$ouTags{$keyRec}=$format;	
	1;
	}

	sub recEdtk_pre_process ($$){
		# FONCTION POUR ASSOCIER UN PR TRAITEMENT  UN ENREGISTREMENT
		#  ce traitement est effectu avant le chargement de l'enregistrement dans DATATAB
		#  le contenu de l'enregistrement prcdent est toujours disponible dans DATATAB
		#  le type de l'enregistrement courant est connu dans le contexte d'execution
		# 
		#  appel :
		# 	recEdtk_pre_process ($keyRec, \&fonction);
		my $keyRec=shift;
		my $refFonction=shift;
		$evalSsTrt{$keyRec}[0]=$refFonction;
	1;	
	}

	sub recEdtk_process ($$){
		# FONCTION POUR ASSOCIER UN TRAITEMENT  UN ENREGISTREMENT
		#  ce traitement est effectu juste aprs le chargement de l'enregistrement dans DATATAB
		#
		#  appel :
		# 	recEdtk_process ($keyRec, \&fonction);
		my $keyRec=shift;
		my $refFonction=shift;
		$evalSsTrt{$keyRec}[1]=$refFonction;	
	1;
	}

	sub recEdtk_post_process ($$){
		# FONCTION POUR ASSOCIER UN POST TRAITEMENT  UN ENREGISTREMENT
		#  ce traitement est effectu juste aprs le reformatage de l'enregistrement dans format_sortie
		#  la ligne d'enregistrement est connu dans le contexte d'excution, dans sa forme "format_sortie"
		#
		#  appel :
		# 	recEdtk_post_process ($keyRec, \&fonction);
		my $keyRec=shift;
		my $refFonction=shift;
		$evalSsTrt{$keyRec}[2]=$refFonction;	
	1;
	}

	sub prodEdtk_rec ($$\$;$$) {
		# ANALYSE ET TRAITEMENT COMBINES DES ENREGISTREMENTS
		#  il encapsule l'analyse et le traitement complet de l'enregistrement (trtEdtkEnr)
		#  il faut un appel par longueur de cle, dans l'ordre dcroissant (de la cle la plus stricte  la moins contraingnante)
		#  APPEL :
		#	prodEdtk_rec ($offsetKey, $lenKey, $ligne [,$offsetRec, $lenRec]);
		#  RETOURNE : statut
		#
		#	exemple 			if 		(prodEdtk_rec (0, 3, $ligne)){
		#					} elsif 	(prodEdtk_rec (0, 2, $ligne)){
		#						etc.
		my $offsetKey	=shift;
		my $lenKey	=shift;
		my $refLigne	=shift;
		my $offsetRec	=shift;	# optionnel
		$offsetRec	||=0;
		my $lenRec	=shift;	# optionnel
		$lenRec		||="";

		if (${$refLigne}=~m/^.{$offsetKey}(\w{$lenKey})/s && trtEdtkEnr($1,$refLigne,$offsetRec,$lenRec)){
			# l'enregistrement a t identifi et trait
			# on dite l'enregistrement 
			print OUT ${$refLigne};
			return 1;
		}
	# SINON ON A PAS RECONNU L'ENREGISTREMENT, C'EST UN ECHEC
	return 0;
	}

	sub trtEdtkEnr ($\$;$$){
		# TRAITEMENT PRINCIPAL DES ENREGISTREMENTS
		# MTHODE GNRIQUE V0.2.1 27/04/2009 10:05:03 (le passage de rfrence devient implicite)
		# LA FONCTION A BESOIN DU TYPE DE L'ENREGISTEMENT ET DE LA RFRENCE  UNE LIGNE DE DONNES
		#  appel :
		#	trtEdtkEnr($Rec_ID, $ligne [,$offsetRec,$lenRec]);
		#  retourne : statut, $Rec_ID
		my $Rec_ID	=shift;
		my $refLigne	=shift;
		my $offsetRec	=shift;		# OFFSET OPTIONNEL DE DONNES  SUPPRIMER EN TTE DE LIGNE
		my $lenRec	=shift;		# LONGUEUR VENTUELLE DE DONNEES  TRAITER
		# VALEURS PAR DFAUT
		$ouTags{$Rec_ID} 	||="-1"; 
		$motifs{$Rec_ID} 	||="";
		$offsetRec 		||=0;
		$lenRec			||="";

		# SI MOTIF D'EXTRACTION DU TYPE D'ENREGISTREMENT N'EST PAS CONNU,
		#  ET SI IL N'Y A AUCUN PRE TRAITEMENT ASSOCI AU TYPE D'ENREGISTREMENT,
		#  ALORS LE TYPE D'ENREGISTREMENT N'EST PAS CONNU
		#
		# CE CONTRLE PERMET DE DFINIR DYNAMIQUEMENT UN TYPE D'ENREGISTREMENT EN FOCNTION DU CONTEXTE
		#  C'EST A DIRE QU'UN ENREGISTREMENT TYP "1" POURRA AVOIR DES CARACTRISITQUES DIFFRENTES
		#  EN FONCTION DU TYPE D'ENREGISTREMENT TRAIT PRCDEMMENT.
		#  CES CARACTRISITIQUES PEUVENT TRE DFINIES AU MOMENT DU PR TRAITEMENT.
		#
		if ($motifs{$Rec_ID} eq "" && !($evalSsTrt{$Rec_ID}[0])) {
			warn "INFO trtEdtkEnr() > LIGNE $. REC. >$Rec_ID< (offset $offsetRec) UNKNOWN\n";
			return 0;
		}

		$PREVIOUS_REC	=$CURRENT_REC;
		$CURRENT_REC	=$Rec_ID;
	
		# STEP 0 : EVAL PRE TRAITEMENT de $refLigne
		&{$evalSsTrt{$Rec_ID}[0]}($refLigne) if $evalSsTrt{$Rec_ID}[0];
		
		# ON S'ASSURE DE BIEN VIDER LE TABLEAU DE LECTURE DE L'ENREGISTREMENT PRECEDENT
		undef @DATATAB;

		# EVENTUELLEMENT SUPPRESSION DES DONNEES NON UTILES (OFFSET ET HORS DATA UTILES (lenData))
		${$refLigne}=~s/^.{$offsetRec}(.{1,$lenRec}).*/$1/ if ($offsetRec > 0);
		
		# ECLATEMENT DE L'ENREGISTREMENT EN CHAMPS
		@DATATAB =unpack ($motifs{$Rec_ID},${$refLigne}) 
				or die "ERROR trtEdtkEnr() > LIGNE $. typEnr >$Rec_ID< motif >$motifs{$Rec_ID}< UNKNOWN\nDIE";
		
		# STEP 1 : EVAL TRAITEMENT CHAMPS
		&{$evalSsTrt{$Rec_ID}[1]} if $evalSsTrt{$Rec_ID}[1];
		
		# STRUCTURATION DE L'ENREGISTREMENT POUR SORTIE
		if ($ouTags{$Rec_ID} ne "-1"){
			${$refLigne}  ="${C7o}a${Rec_ID}${C7c}";
			${$refLigne} .=sprintf ($ouTags{$Rec_ID},@DATATAB) 
						or die "ERROR trtEdtkEnr() > LIGNE $. typEnr >$Rec_ID< ouTags >$ouTags{$Rec_ID}<\nDIE";
			${$refLigne} .="${C7o}e${Rec_ID}${C7c}\n";
		} else {
			${$refLigne}="";
		}
		$LAST_ENR=$Rec_ID;
		
		# STEP 2 : EVAL POST TRAITEMENT
		&{$evalSsTrt{$Rec_ID}[2]} if $evalSsTrt{$Rec_ID}[2];
	
		# VENTUELLEMENT AJOUT DE DONNES COMPLMENTAIRES 
		${$refLigne} .=$pushValue;
		$pushValue ="";	
		${$refLigne} =~s/\s{2,}/ /g;	#	CONCATNATION DES BLANCS
		#$LAST_ENR=$Rec_ID;

	return 1, $Rec_ID;
	}

	sub trtEdtk_Add_Value ($){
		$pushValue .=shift;
	1;
	}

	sub prodEdtk_Previous_Rec () {
		return $PREVIOUS_REC;
	}
	
	sub prodEdtk_Current_Rec () {
		return $CURRENT_REC;
	}


sub mnt2txtUS (\$){
	# traitement des montants au format Texte
	# le sparateur de dcimal "," est transform en "." pour les commandes de chargement US / C7
	# le sparateur de millier "." ou " " est supprim
	# recoit : une variable alphanumerique formatte pour l'affichage
	# 		mnt2txtUS($value);
	
	my $refMontant  =shift;	
	${$refMontant}||="";

	if (${$refMontant}){
		${$refMontant}=~s/\s+//g;	# suppression des blancs
		${$refMontant}=~s/\.//g;		# suppression des sparateurs de milliers
		${$refMontant}=~s/\,/\./g;	# remplacement du sparateur de dcimal
	} else {
		${$refMontant}=0;
	}			
1;
}

sub mntSignX(\$;$) {
	# traitement des montants signs alphanumeriques
	# recoit : une reference a une variable alphanumerique
	#          un nombre de dcimal aprs la virgule (optionnel, 0 par dfaut)

	my ($refMontant, $decimal)=@_;
	${$refMontant}	||="";
	$decimal		||=0;

	# controle de la validite de la valeur transmise
	${$refMontant}=~s/\s+//g;
	if (${$refMontant} eq "" || ${$refMontant} eq 0) {
		${$refMontant} =0;
		return 1;
	} elsif (${$refMontant}=~/\D{2,}/){
		warn "INFO value (${$refMontant}) not numeric.\n";
		return -1;
	}

	my %hXVal;
	$hXVal{'p'}=0;
	$hXVal{'q'}=1;
	$hXVal{'r'}=2;
	$hXVal{'s'}=3;
	$hXVal{'t'}=4;
	$hXVal{'u'}=5;
	$hXVal{'v'}=6;
	$hXVal{'w'}=7;
	$hXVal{'x'}=8;
	$hXVal{'y'}=9;

	if ( ${$refMontant}=~s/(\D{1})$/$hXVal{$1}/ ) {
		# une valeur avec signe negatif alphanumerique 213y => -2139
		${$refMontant}=(${$refMontant}*(-1));
  	} elsif (${$refMontant}=~/^-{1}/){
		# une valeur avec un signe negatif -123456
	}

	${$refMontant}=${$refMontant}/(10**$decimal);

1;
}

sub date2time ($){
	my $date=shift; # une date au format AAAAMMJJ
	my $tmpDate="AAAAMMJJ";
	my $decalage=0;
	my $jours=-1;
	my $time=time;
	my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday) =
		gmtime($time);
	my $nowDate=sprintf ("%4.0f%02.0f%02.0f", $year+1900, $mon+1, $mday);

	if ($nowDate > $date){
		# date est plus ancien
		$decalage=-1;
	}elsif ($nowDate < $date){
		# date est plus rcent
		$decalage=+1;
	}

	while ($date ne $tmpDate){
		$jours++;
		# une journe comporte 86400 secondes
		($sec,$min,$hour,$mday,$mon,$year,$wday,$yday) =
			gmtime($time+($decalage*$jours*86400));
		$tmpDate=sprintf ("%4.0f%02.0f%02.0f", $year+1900, $mon+1, $mday);
	}
return ($time+($decalage*$jours*86400)), ($decalage*$jours);
}

sub nowTime(){
	my $time =time;
	my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday) =
		gmtime($time);
	$time =sprintf ("%4.0f%02.0f%02.0f%02.0f%02.0f%02.0f", $year+1900, $mon+1, $mday, $hour, $min, $sec);
	return $time;	
}

sub toDate(\$) {
	# RECOIT UNE REFERENCE SUR UNE DATE AU FORMAT AAAAMMJJ
	# FORMATE AU FORMAT JJ/MM/AAAA
	my $refVar  =shift;
	${$refVar}||="";
	${$refVar}=~s/(\d{4})(\d{2})(\d{2})(.*)/$3\/$2\/$1/o;
1;
}

sub toC7date(\$) {
	# RECOIT UNE REFERENCE SUR UNE DATE AU FORMAT AAAAMMJJ
	# FORMATE AU FORMAT <C7J>JJ<C7M>MM><C7A>AAAA
	my $refVar  =shift;
	${$refVar}||="";
	${$refVar}=~s/(\d{4})(\d{2})(\d{2})(.*)/\<C7j\>$3\<C7m\>$2\<C7a\>$1/o;
1;
}

sub c7Flux(\$) {
	# LES SIGNES "INFRIEUR" ET "SUPRIEUR" SONT DES DLMITEURS RSERVS  COMPUSET
	# LES FLUX MTIERS SONT TRAITS POUR REMPLACER CES SIGNES PAR DES ACCOLADES
	# A L'DITION, COMPUSET RTABLI CES SIGNES POUR RETROUVER L'AFFICHAGE ATTENDUS
	#
	# DANS LA CONFIGURATION COMPUSET, LES LIGNES SUIVANTES SONT UTILISEES POUR RETABLIR LES CARACTERES ORIGINAUX :
	# LE CARACTRE { DANS LE FLUX DE DATA EST REMPLAC PAR LE SIGNE INFRIEUR  LA COMPOSITION
	#	<TF,{,<,>
	# LE CARACTRE } DANS LE FLUX DE DATA EST REMPLAC PAR LE SIGNE SUPRIEUR  LA COMPOSITION
	#	<TF,},>,>
	#
	# l'appel de la fonction se fait par passage de rfrence de faon implicite
	#	c7Flux($chaine);

	my $refChaine  =shift;
	${$refChaine}||="";
	${$refChaine}=~s/</{/g;
	${$refChaine}=~s/>/}/g;
1;
}

sub clean_adress_line (\$) {
	# CETTE FONCTION PERMET UN NETTOYAGE DES LIGNES D'ADRESSE POUR CONSTRUIRE LES BLOCS D'ADRESSE DESTINTATIRE
	# elle travaille sur la rfrence de la variable directement mais retourne aussi la chaine resultante
	my $rLine=shift;
	${$rLine}||="";		# valeur par dfaut dans le cas o le champs serait undef

	chomp(${$rLine});		# pour tre sr de ne pas avoir de retour  la ligne en fin de champ
	trimSP($rLine);
	
	${$rLine}=~s/^\s+//;	# on supprime les blancs conscutifs en dbut de chane (on a fait un trimSP en premier...)
	${$rLine}=~s/\s+$//;	# on supprime les blancs conscutifs en fin de chane (...)

	${$rLine}=~s/\s\,/\,/g;	# on supprime les blancs devant les virgules
	${$rLine}=~s/\,\./\,/g;	# on supprime les points derrire les virgules (contexte adresses)
	${$rLine}=~s/^\,//;		# on supprime les virgules en dbut de chane
	${$rLine}=~s/\s\./\./g;	# on supprime les espaces devant les points
	${$rLine}=~s/^\.//;		# on supprime les points en dbut de chane

	# POUR VITER L'UTILISATION DES BLANCS FORCS ENTRE DES CHAMPS D'ADRESSE (EX : <PEADNUM>`<PEADBTQ>`<PEVONAT>`<LIBVOIX><NLIF>)
	# on rajoute un blanc en fin de champ s'il contient au moins un caractre
	if (${$rLine} =~/\w+$/) { ${$rLine} .=" "; }

return ${$rLine};
}

sub maj_sans_accents (\$) {
	# CETTE FONCTION PERMET DE CONVERTIR LES CARACTRES ACCENTUS EN CARACTRES MAJUSCULES NON ACCENTUS
	# l'utilisation de la localisation provoque un bug dans la commande "sort".
	# On ne s'appuie pas sur la possibilit de rtablir le comportement par dfaut par chappement
	# (la directive no locale ou lorsqu'on sort du bloc englobant la directive use locale)
	# de faon  adopter un mode de fonctionnement standard et simplifi.
	# NB : la localisation ralentit considrablement les tris.
	# (cf. doc Perl concernant la localisation : perllocale)
	#
	# l'appel de la fonction se fait par passage de rfrence implicite
	#	maj_sans_accents($chaine);
	
	my $refChaine  =shift;
	${$refChaine}||="";
	${$refChaine}=~s/[]/a/g;
	${$refChaine}=~s/[]/e/g;
	${$refChaine}=~s/[]/i/g;
	${$refChaine}=~s/[]/o/g;
	${$refChaine}=~s/[]/u/g;
	${$refChaine}= uc ${$refChaine};
	
return 1;
}

sub trimSP(\$) {
	# SUPPRESSION DES ESPACES CONSECUTIFS (TRAILING BLANK) PAR GROUPAGE
	# le parametre doit etre une reference, exemple : trimSP($chaine)
	# retourne le nombre de caracteres retires
	my $rChaine  =shift;
	${$rChaine}||="";
	return ${$rChaine} =~s/\s{2,}/ /go;
}

sub IsTestApp () {
	$TestAppMarkUp ="<editTST>";
1;
}

sub prodEdtkOpen($$;$) {
	my $fi =shift;
	my $fo =shift;
	my $single_job_id 	=shift;
	$single_job_id  	||="";
	my $appRef		=$0;
	
	open (IN,   "$fi")	or die "ERROR ouverture $fi, code retour $!\nDIE";
	open (OUT, "> $fo")	or die "ERROR ouverture $fo, code retour $!\nDIE";

	$appRef	=~/([\w-]+)\.pl$/i;
	print OUT "$TestAppMarkUp<#appRef=$1><#jobUid=$single_job_id><debFlux>";
	print OUT nowTime();
	print OUT "<SK>\n";
1;
}

sub fiEdtkOpen ($;$){ # GESTION ENTREE DANS LE CONTEXTE DE PRODUCTION EXCEL
	my $fi =shift;
	open (IN, "$fi")	or die "ERROR ouverture $fi, code retour $!\nDIE";

1;
}

sub foEdtkOpen ($){ # GESTION ENTREE DANS LE CONTEXTE DE PRODUCTION EXCEL
	my $fo =shift;
	open (OUT, "> $fo")	or die "ERROR ouverture $fo - code retour $!\nDIE";

1;
}

sub prodEdtkClose ($$){
	my ($fi,$fo)=@_;

	# SI LE FLUX D'ENTREE FAIT MOINS DE 1 LIGNE (variable $.), SORTIES EN ERREUR
	if ($. < 1) {
		print "\nANOMALIE, FLUX D'ENTREE INCOMPLET ($. lignes)\n\n";
		print  OUT  " <DEBUG>ANOMALIE DANS LE FLUX\n<QUIT,3>ANOMALIE, FLUX D'ENTREE INCOMPLET ($. lignes)";
		# FLUX INVALIDE ARRET
		die -1;
	}

	print OUT "<FinFlux>";
	print OUT nowTime();
	print OUT "<SK>\n";
	close (OUT) or die "ERROR fermeture $fo, code retour $!\nDIE";
	close (IN)  or die "ERROR fermeture $fi, code retour $!\nDIE";

1;
}

sub foEdtkClose ($) {
	my $f =shift;
	
	close (OUT) or die "ERROR fermeture $f - code retour $!\nDIE";
1;
}


sub prodEdtkAppUsage() {
        my $app="";
        $0=~/([\w-]+[\.plmex]*$)/;
        $1 ? $app="application.pl" : $app=$1;
        print STDOUT << "EOF";

        Usage : $app <fichier_entree> <fichier_sortie> [option]
EOF
exit 1;
}

END {}
1;
