package OpenInteract2::Action::TemplatesUsedBox;

# $Id: TemplatesUsedBox.pm,v 1.9 2004/02/18 05:23:09 lachoy Exp $

use strict;
use base qw( OpenInteract2::Action );
use OpenInteract2::Context   qw( CTX );

$OpenInteract2::Action::TemplatesUsedBox::VERSION = sprintf("%d.%02d", q$Revision: 1.9 $ =~ /(\d+)\.(\d+)/);

# Simple handler to put the list of templates used into a more
# manageable form -- note that we can handle template objects and
# 'package::name' strings in \@{ $R->{templates_used} }

sub handler {
    my ( $self ) = @_;
    my $controller = $self->controller;
    my $request = CTX->request;
    unless ( $controller->isa( 'OpenInteract2::Controller::ManageTemplates' ) ) {
        return $request->language_handle->maketext( 'base_template.error.no_manage' );
    }
    my %tmpl_by_package = ();
    my %tmpl_used       = ();
    my $templates_used = $controller->get_templates_used;
    my $template_class = CTX->lookup_class( 'template' );
    foreach my $template ( @{ $templates_used } ) {
        my ( $package, $name, $full_name );
        if ( ref $template ) {
            ( $package, $name ) = ( $template->{package}, $template->{name} );
        }
        else {
            ( $package, $name ) = $template_class->parse_name( $template );
            if ( $package and ! $name ) {
                $name    = $package;
                $package = '';
            }
            $full_name = $template;
        }
        next if ( $tmpl_used{ $package }{ $name } );
        $tmpl_used{ $package }{ $name }++;
        push @{ $tmpl_by_package{ $package } },
                            { name      => $name,
                              package   => $package,
                              full_name => $full_name };
    }
    foreach my $package ( keys %tmpl_by_package ) {
        $tmpl_by_package{ $package } = [ sort { $b->{name} cmp $a->{name} }
                                         @{ $tmpl_by_package{ $package } } ];
    }
    return $self->generate_content(
                    { templates_used => \%tmpl_by_package },
                    { name => 'base_template::templates_used_box' } );
}

1;

__END__

=head1 NAME

OpenInteract2::Action::TemplatesUsedBox -- Generate 'Templates Used' box contents

=head1 SYNOPSIS

 # Add the box to a particular page
 [% OI.box_add( 'templates_used_box' ) %]

=head1 DESCRIPTION

B<templates_used> (if in 'site admin' group)

Displays a listing of the templates used for a request along with
links so you can quickly jump to one and edit it.

=head1 BUGS

None known.

=head1 TO DO

=head1 SEE ALSO

L<OpenInteract2::Action::Box|OpenInteract2::Action::Box>

=head1 COPYRIGHT

Copyright (c) 2001-2003 Chris Winters. All rights reserved.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 AUTHORS

Chris Winters E<lt>chris@cwinters.comE<gt>
