package OpenInteract2::Controller::Raw;

# $Id: Raw.pm,v 1.5 2003/06/11 02:43:29 lachoy Exp $

use strict;
use base qw( OpenInteract2::Controller );
use OpenInteract2::Context   qw( DEBUG LOG );
use OpenInteract2::Constants qw( :log );
use OpenInteract2::Exception qw( oi_error );

sub execute {
    my ( $self ) = @_;
    my $action = $self->initial_action;
    DEBUG && LOG( LDEBUG, 'Executing top-level action [', $action->name,
                          "] with task [", $action->task, "]" );
    $action->request( $self->request );
    $action->response( $self->response );
    my $content = eval { $action->execute };
    if ( $@ ) {
        LOG( LERROR, "Caught exception generating content: $@" );
        $content = $@;
    }
    else {
        DEBUG && LOG( LDEBUG, "Generated content ok" );
    }
    $self->response->content( \$content );
    return $self;
}

1;

__END__

=head1 NAME

OpenInteract2::Controller::Raw - Basic controller just outputting action content

=head1 SYNOPSIS

 [myaction]
 controller = raw

=head1 DESCRIPTION

This controller doesn't modify the content generated by the action. It
just adds the content directly to the response.

=head1 METHODS

C<execute()>

Executes the initial action and sets the returned content to the
response.

=head1 BUGS

None known.

=head1 TO DO

Nothing known.

=head1 SEE ALSO

L<OpenInteract2::Controller|OpenInteract2::Controller>

=head1 COPYRIGHT

Copyright (c) 2002-2003 Chris Winters. All rights reserved.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 AUTHORS

Chris Winters E<lt>chris@cwinters.comE<gt>
