package OpenInteract::Handler::PageScan;

# $Id: PageScan.pm,v 1.3 2002/01/17 23:38:38 lachoy Exp $

use strict;
use OpenInteract::Handler::GenericDispatcher qw( DEFAULT_SECURITY_KEY );
use OpenInteract::PageScan;
use SPOPS::Secure qw( :level );

@OpenInteract::Handler::PageScan::ISA     = qw( OpenInteract::Handler::GenericDispatcher SPOPS::Secure );
$OpenInteract::Handler::PageScan::VERSION = sprintf("%d.%02d", q$Revision: 1.3 $ =~ /(\d+)\.(\d+)/);
$OpenInteract::Handler::PageScan::author            = 'chris@cwinters.com';
$OpenInteract::Handler::PageScan::default_method    = 'show';
@OpenInteract::Handler::PageScan::forbidden_methods = ();
%OpenInteract::Handler::PageScan::security          = (
   DEFAULT_SECURITY_KEY() => SEC_LEVEL_WRITE,
);

sub show {
    my ( $class, $p ) = @_;
    my $R = OpenInteract::Request->instance;
    $R->{page}{title} = "Scan for new pages";
    return $R->template->handler( {}, $p, { name => 'base_page::page_scan_form' } );
}

sub run {
    my ( $class, $p ) = @_;
    my $R = OpenInteract::Request->instance;

    my $scan_dir = $R->apache->param( 'scan_directory' );

    my $scanner = OpenInteract::PageScan->new({ file_root => $scan_dir,
                                                DEBUG     => $R->DEBUG });
    my $new_files = $scanner->find_new_files;
    my @pages  = ();
    my @errors = ();

    foreach my $location ( @{ $new_files } ) {
        my $file_info = $scanner->get_file_info( $location );
        $R->DEBUG && $R->scrib( 1, "Trying to add file [$location] [$file_info->{mime_type}]" );
        my $page = eval { $scanner->add_location( $location, $file_info ) };
        if ( $@ ) {
            push @errors, { error => "$@", location => $location };
        }
        else {
            push @pages, $page if ( $page );
        }
    }

    $R->{page}{title} = "Page scanning results";
    return $R->template->handler( {}, { page_list  => \@pages,
                                        error_list => \@errors },
                                  { name => 'base_page::page_scan_results' } );
}

1;
