use KinoSearch;

1;

__END__

__BINDING__

my $xs_code = <<'END_XS_CODE';
MODULE = KinoSearch   PACKAGE = KinoSearch::Posting::ScorePosting

SV*
get_prox(self)
    kino_ScorePosting *self;
CODE:
{
    AV *out_av            = newAV();
    chy_u32_t *positions  = Kino_ScorePost_Get_Prox(self);
    chy_u32_t i, max;

    for (i = 0, max = Kino_ScorePost_Get_Freq(self); i < max; i++) {
        SV *pos_sv = newSVuv(positions[i]);
        av_push(out_av, pos_sv);
    }

    RETVAL = newRV_noinc((SV*)out_av);
}
OUTPUT: RETVAL
END_XS_CODE

my $synopsis = <<'END_SYNOPSIS';
    # ScorePosting is used indirectly, by specifying in FieldType subclass.
    package MySchema::Category;
    use base qw( KinoSearch::FieldType::FullTextType );
    # (It's the default, so you don't need to spec it.)
    # sub posting {
    #     my $self = shift;
    #     return KinoSearch::Posting::ScorePosting->new(@_);
    # }
END_SYNOPSIS

Boilerplater::Binding::Perl::Class->register(
    parcel            => "KinoSearch",
    class_name        => "KinoSearch::Posting::ScorePosting",
    xs_code           => $xs_code,
    bind_constructors => ["new"],
#    make_pod => {
#        synopsis => $synopsis,
#    }
);

__COPYRIGHT__

Copyright 2005-2009 Marvin Humphrey

This program is free software; you can redistribute it and/or modify
under the same terms as Perl itself.

