use strict;
use warnings;


package Dist::Zilla::App::Command::cpanm;

# ABSTRACT: install your dist using cpanminus
our $VERSION = '1.0.1'; # VERSION

use Dist::Zilla::App '-command';


sub opt_spec
{
    [ 'keep-build-dir|keep' => 'keep the build directory even after a success' ]
}


sub execute
{
    my ( $self, $opt, $arg ) = @_;

    my @params = $ENV{DZIL_CPANM_OPTS}
        ? ( install_command => ["cpanm $ENV{DZIL_CPANM_OPTS} ."] )
        : ( install_command => ["cpanm ."] );
    push @params, ( keep_build_dir => 1 ) if $opt->keep_build_dir;

    $self->zilla->install( {@params} );
}

1;

=head1 NAME

Dist::Zilla::App::Command::cpanm - installs your dist using cpanminus

=head1 VERSION

version 1.0.1

=head1 SYNOPSIS

    $ dzil cpanm
    
=head1 DESCRIPTION

Installs your distribution as if you had typed:

    dzil install --install-command="cpanm ."    # Really no fun at all!

B<Examples>

=over

=item As simple as it gets:

    $ dzil cpanm

=item For those of us who aren't using Perl Brew:

    $ export DZIL_CPANM_OPTS='--verbose --interactive --sudo'
    $ dzil cpanm

=back

=head1 SEE ALSO

=over 2

=item * L<Dist::Zilla::Dist::Builder/install>

=back

=head1 REPOSITORY

=over 2

=item * L<https://github.com/cpanic/Dist-Zilla-App-Command-cpanm>

=item * L<http://search.cpan.org/dist/Dist-Zilla-App-Command-cpanm/lib/Dist/Zilla/App/Command/cpan.pm>

=back

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Dist::Zilla::App::Command::cpanm

=head1 ACKNOWLEDGEMENTS

Shamelessly butchered Richard Signes Dist::Zilla::App::Command::install code.

The need was great.

=head1 AUTHOR

Iain Campbell <cpanic@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Iain Campbell.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
