/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 1 "parse_tab.lem"

#include "parse_int.h"

struct st_csv_limit {
	size_t						limit;
	size_t						offset;
};

struct st_csv_column_type {
	const char *name;
	size_t name_len;
	size_t size;
};

struct st_csv_join {
	int op;
	Expr *table;
	Token *alias;
	Expr *condition;
};
#line 30 "parse_tab.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    ParseTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 141
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  Token 
typedef union {
  ParseTOKENTYPE yy0;
  ExprList* yy42;
  struct st_csv_column_type yy66;
  csv_select_t* yy81;
  struct st_csv_join yy95;
  Token yy98;
  Expr * yy102;
  struct st_csv_limit yy170;
  int yy172;
  Expr* yy202;
  ExprList * yy214;
  int yy281;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  csv_parse_t *parse ;
#define ParseARG_PDECL , csv_parse_t *parse 
#define ParseARG_FETCH  csv_parse_t *parse  = yypParser->parse 
#define ParseARG_STORE yypParser->parse  = parse 
#define YYNSTATE 314
#define YYNRULE 136
#define YYERRORSYMBOL 100
#define YYERRSYMDT yy281
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   198,   44,   56,   43,  221,  234,  234,  242,  308,  242,
 /*    10 */   242,  242,   46,   45,  243,  228,  241,  228,  228,  228,
 /*    20 */   144,  145,  302,  211,  211,  212,   48,   90,   16,   16,
 /*    30 */   451,   57,  313,  300,  247,   51,  300,  234,  234,  299,
 /*    40 */    82,  148,  169,  170,  171,  172,   75,  173,  174,  175,
 /*    50 */   178,  179,  180,  181,   24,   24,   24,  182,  183,  184,
 /*    60 */   185,  186,   18,  187,  188,  300,  189,  190,  192,  194,
 /*    70 */   196,   48,  198,   44,  243,   43,  261,  288,  234,  242,
 /*    80 */   234,  242,  242,  242,   46,   45,  243,   85,  147,  235,
 /*    90 */   149,  244,   16,   16,  155,  222,   85,   84,  226,   11,
 /*   100 */    11,   11,   11,   13,   13,   13,   13,   18,   18,   18,
 /*   110 */   234,  247,  234,  291,  169,  170,  171,  172,  150,  173,
 /*   120 */   174,  175,  178,  179,  180,  181,   18,  314,  221,  182,
 /*   130 */   183,  184,  185,  186,  234,  187,  188,   81,  189,  190,
 /*   140 */   192,  194,  196,  210,  198,   44,  243,   43,   78,  220,
 /*   150 */   234,  242,   51,  242,  242,  242,   46,   45,  243,  160,
 /*   160 */   213,   83,    5,  208,  306,  202,  234,   13,   13,   13,
 /*   170 */    13,   18,   18,   18,  310,   74,  163,  165,  225,   58,
 /*   180 */    73,  215,  234,  203,  227,   61,  169,  170,  171,  172,
 /*   190 */   201,  173,  174,  175,  178,  179,  180,  181,  296,  297,
 /*   200 */   217,  182,  183,  184,  185,  186,  307,  187,  188,  281,
 /*   210 */   189,  190,  192,  194,  196,  236,  198,   44,  243,   43,
 /*   220 */   238,  288,  234,  242,   62,  242,  242,  242,   46,   45,
 /*   230 */   243,  229,   55,  199,  229,  229,  245,  242,   72,  242,
 /*   240 */   242,  242,  282,  199,  243,  112,  230,  240,   64,  230,
 /*   250 */   230,  166,  282,  257,  234,  129,  246,   72,  169,  170,
 /*   260 */   171,  172,  283,  173,  174,  175,  178,  179,  180,  181,
 /*   270 */   248,  167,  283,  182,  183,  184,  185,  186,   18,  187,
 /*   280 */   188,  168,  189,  190,  192,  194,  196,  206,  198,   44,
 /*   290 */   243,   43,  177,   89,  234,  242,   80,  242,  242,  242,
 /*   300 */    46,   45,  243,  258,  243,  259,   95,   53,   16,   16,
 /*   310 */   295,  311,  311,  298,  311,  311,  311,   65,  257,  205,
 /*   320 */    66,  224,  157,   18,   18,   18,  234,   93,  161,  164,
 /*   330 */   169,  170,  171,  172,  309,  173,  174,  175,  178,  179,
 /*   340 */   180,  181,   18,  311,  197,  182,  183,  184,  185,  186,
 /*   350 */    69,  187,  188,   70,  189,  190,  192,  194,  196,  290,
 /*   360 */   198,   44,  243,   43,   48,  207,  234,  242,  258,  242,
 /*   370 */   242,  242,   46,   45,  243,  209,   91,  156,   92,  204,
 /*   380 */   292,   67,    2,   52,  140,  199,  223,   18,   18,   18,
 /*   390 */   231,    4,  232,  158,  282,  159,  233,  106,  234,   86,
 /*   400 */   162,   87,  169,  170,  171,  172,  237,  173,  174,  175,
 /*   410 */   178,  179,  180,  181,  283,  239,   59,  182,  183,  184,
 /*   420 */   185,  186,   71,  187,  188,   54,  189,  190,  192,  194,
 /*   430 */   196,    6,  176,    8,  243,  152,   10,  301,   12,    3,
 /*   440 */   301,  214,  199,   16,   16,   15,  199,  199,   17,   19,
 /*   450 */   282,  282,   14,   63,  128,  282,  282,  260,  134,  103,
 /*   460 */    94,   49,   22,   76,   23,    1,   26,   27,   28,  301,
 /*   470 */   283,  283,  151,  199,  199,  283,  283,   18,   29,   30,
 /*   480 */   199,  199,  282,  282,   33,  136,  104,   36,   38,  282,
 /*   490 */   282,  191,  139,  105,  276,  193,   18,  277,  195,   60,
 /*   500 */   278,   39,  283,  283,  146,   40,    7,    9,  153,  283,
 /*   510 */   283,  279,   21,   14,   11,   11,   11,   11,   13,   13,
 /*   520 */    13,   13,   18,   18,   18,  176,  289,  154,  287,   32,
 /*   530 */   199,  199,  199,   77,  293,  294,   16,   16,  199,  282,
 /*   540 */   282,  282,  141,  138,  107,   14,   79,  282,   96,  303,
 /*   550 */   143,  176,  304,  301,  255,   20,  301,   50,  305,  283,
 /*   560 */   283,  283,   16,   16,  199,  151,  199,  283,  216,   68,
 /*   570 */    18,   14,  142,  282,  218,  282,  108,  219,  200,  452,
 /*   580 */   312,  452,  452,  452,  452,  301,   32,  452,  452,  452,
 /*   590 */   452,  151,  452,  283,  452,  283,   18,  452,  452,    7,
 /*   600 */     9,  153,  452,  452,  452,   21,   14,   11,   11,   11,
 /*   610 */    11,   13,   13,   13,   13,   18,   18,   18,  452,  452,
 /*   620 */   146,  452,  452,  452,  452,    7,    9,  153,  452,  452,
 /*   630 */   452,   21,   14,   11,   11,   11,   11,   13,   13,   13,
 /*   640 */    13,   18,   18,   18,  176,  452,  452,  265,  199,  199,
 /*   650 */   199,  452,  452,  452,  452,   16,   16,  282,  282,  282,
 /*   660 */    98,  109,  130,  452,   14,  452,   25,  452,  452,  452,
 /*   670 */   176,  199,  452,  452,   31,  452,  199,  283,  283,  283,
 /*   680 */   282,   16,   16,  110,  151,  282,  452,  199,  111,   18,
 /*   690 */    14,  452,   31,  452,  452,  452,  282,  452,  452,   99,
 /*   700 */   283,  452,  452,  452,  452,  283,  452,  452,  452,  452,
 /*   710 */   151,  452,  452,  452,  452,   18,  283,  452,    7,    9,
 /*   720 */   153,  452,  452,  452,   21,   14,   11,   11,   11,   11,
 /*   730 */    13,   13,   13,   13,   18,   18,   18,  452,  452,  452,
 /*   740 */   452,  452,  452,  452,    7,    9,  153,  452,  452,  452,
 /*   750 */    21,   14,   11,   11,   11,   11,   13,   13,   13,   13,
 /*   760 */    18,   18,   18,  176,  452,  452,  272,   35,  199,  199,
 /*   770 */   199,  452,  452,  452,   16,   16,  452,  282,  282,  282,
 /*   780 */   113,  114,  115,   14,  452,  452,  452,  452,  452,  176,
 /*   790 */   452,  452,  452,   88,  452,  199,  452,  283,  283,  283,
 /*   800 */    16,   16,  452,  151,  282,  452,  452,  116,   18,   14,
 /*   810 */   452,  199,  452,  452,  452,  452,  452,  452,  452,  452,
 /*   820 */   282,  452,  452,  117,  283,  452,  452,  452,  452,  151,
 /*   830 */   452,  452,  452,  452,   18,  452,  452,    7,    9,  153,
 /*   840 */   283,  452,  452,   21,   14,   11,   11,   11,   11,   13,
 /*   850 */    13,   13,   13,   18,   18,   18,  452,  452,  452,   88,
 /*   860 */   452,  452,  452,    7,    9,  153,  452,  452,  452,   21,
 /*   870 */    14,   11,   11,   11,   11,   13,   13,   13,   13,   18,
 /*   880 */    18,   18,  176,  452,  452,  249,  199,  452,  199,  452,
 /*   890 */   452,  452,  199,   16,   16,  282,  452,  282,  100,  452,
 /*   900 */    97,  282,   14,  452,  118,  452,  452,  452,  176,  452,
 /*   910 */   452,  250,  452,  452,  199,  283,  452,  283,  452,   16,
 /*   920 */    16,  283,  151,  282,  452,  452,  119,   18,   14,  452,
 /*   930 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*   940 */   452,  452,  452,  283,  452,  452,  452,  452,  151,  452,
 /*   950 */   452,  452,  452,   18,  452,  452,    7,    9,  153,  452,
 /*   960 */   452,  452,   21,   14,   11,   11,   11,   11,   13,   13,
 /*   970 */    13,   13,   18,   18,   18,  452,  452,  452,  452,  452,
 /*   980 */   452,  452,    7,    9,  153,  452,  452,  452,   21,   14,
 /*   990 */    11,   11,   11,   11,   13,   13,   13,   13,   18,   18,
 /*  1000 */    18,  176,  452,  452,  251,  199,  199,  452,  452,  452,
 /*  1010 */   452,  199,   16,   16,  282,  282,  452,  101,  120,  199,
 /*  1020 */   282,   14,  452,  121,  452,  452,  452,  176,  282,  452,
 /*  1030 */   252,  122,  452,  199,  283,  283,  452,  452,   16,   16,
 /*  1040 */   283,  151,  282,  452,  452,  123,   18,   14,  283,  452,
 /*  1050 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  1060 */   452,  452,  283,  452,  452,  452,  452,  151,  452,  452,
 /*  1070 */   452,  452,   18,  452,  452,    7,    9,  153,  452,  452,
 /*  1080 */   452,   21,   14,   11,   11,   11,   11,   13,   13,   13,
 /*  1090 */    13,   18,   18,   18,  452,  452,  452,  452,  452,  452,
 /*  1100 */   452,    7,    9,  153,  452,  452,  452,   21,   14,   11,
 /*  1110 */    11,   11,   11,   13,   13,   13,   13,   18,   18,   18,
 /*  1120 */   176,  452,  452,  253,  199,  199,  199,  452,  452,  452,
 /*  1130 */   199,   16,   16,  282,  282,  282,  102,  124,  125,  282,
 /*  1140 */    14,  452,  126,  452,  452,  452,  176,  452,  452,  254,
 /*  1150 */   452,  452,  199,  283,  283,  283,  452,   16,   16,  283,
 /*  1160 */   151,  282,  452,  452,  127,   18,   14,  452,  452,  452,
 /*  1170 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  1180 */   452,  283,  452,  452,  452,  452,  151,  452,  452,  452,
 /*  1190 */   452,   18,  452,  452,    7,    9,  153,  452,  452,  452,
 /*  1200 */    21,   14,   11,   11,   11,   11,   13,   13,   13,   13,
 /*  1210 */    18,   18,   18,  452,  452,  452,  452,  452,  452,  452,
 /*  1220 */     7,    9,  153,  452,  452,  452,   21,   14,   11,   11,
 /*  1230 */    11,   11,   13,   13,   13,   13,   18,   18,   18,  176,
 /*  1240 */   452,  452,  256,  199,  199,  199,  452,  452,  452,  199,
 /*  1250 */    16,   16,  282,  282,  282,  135,  285,  286,  282,   14,
 /*  1260 */   452,  137,  452,  452,  452,  176,  452,  452,  262,  452,
 /*  1270 */   452,  199,  283,  283,  283,  452,   16,   16,  283,  151,
 /*  1280 */   282,  452,  452,  131,   18,   14,  452,  452,  452,  452,
 /*  1290 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  1300 */   283,  452,  452,  452,  452,  151,  452,  452,  452,  452,
 /*  1310 */    18,  452,  452,    7,    9,  153,  452,  452,  452,   21,
 /*  1320 */    14,   11,   11,   11,   11,   13,   13,   13,   13,   18,
 /*  1330 */    18,   18,  452,  452,  452,  452,  452,  452,  452,    7,
 /*  1340 */     9,  153,  452,  452,  452,   21,   14,   11,   11,   11,
 /*  1350 */    11,   13,   13,   13,   13,   18,   18,   18,  176,  452,
 /*  1360 */   452,  263,  199,  199,  452,  452,  452,  452,  452,   16,
 /*  1370 */    16,  282,  282,  452,  132,  133,  452,  452,   14,  452,
 /*  1380 */   452,  452,  452,  452,  176,  452,  452,  264,  452,  452,
 /*  1390 */   452,  283,  283,  452,  452,   16,   16,  452,  151,  452,
 /*  1400 */   452,  452,  452,   18,   14,  452,  452,  452,  452,  452,
 /*  1410 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  1420 */   452,  452,  452,  452,  151,  452,  452,  452,  452,   18,
 /*  1430 */   452,  452,    7,    9,  153,  452,  452,  452,   21,   14,
 /*  1440 */    11,   11,   11,   11,   13,   13,   13,   13,   18,   18,
 /*  1450 */    18,  452,  452,  452,  452,  452,  452,  452,    7,    9,
 /*  1460 */   153,  452,  452,  452,   21,   14,   11,   11,   11,   11,
 /*  1470 */    13,   13,   13,   13,   18,   18,   18,  176,  452,  452,
 /*  1480 */   266,  452,  452,  452,  452,  452,  452,  452,   16,   16,
 /*  1490 */   452,  452,  452,  452,  452,  452,  452,   14,  452,  452,
 /*  1500 */   452,  452,  452,  176,  452,  452,  267,  452,  452,  452,
 /*  1510 */   452,  452,  452,  452,   16,   16,  452,  151,  452,  452,
 /*  1520 */   452,  452,   18,   14,  452,  452,  452,  452,  452,  452,
 /*  1530 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  1540 */   452,  452,  452,  151,  452,  452,  452,  452,   18,  452,
 /*  1550 */   452,    7,    9,  153,  452,  452,  452,   21,   14,   11,
 /*  1560 */    11,   11,   11,   13,   13,   13,   13,   18,   18,   18,
 /*  1570 */   452,  452,  452,  452,  452,  452,  452,    7,    9,  153,
 /*  1580 */   452,  452,  452,   21,   14,   11,   11,   11,   11,   13,
 /*  1590 */    13,   13,   13,   18,   18,   18,  176,  452,  452,  268,
 /*  1600 */   452,  452,  452,  452,  452,  452,  452,   16,   16,  452,
 /*  1610 */   452,  452,  452,  452,  452,  452,   14,  452,  452,  452,
 /*  1620 */   452,  452,  176,  452,  452,  269,  452,  452,  452,  452,
 /*  1630 */   452,  452,  452,   16,   16,  452,  151,  452,  452,  452,
 /*  1640 */   452,   18,   14,  452,  452,  452,  452,  452,  452,  452,
 /*  1650 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  1660 */   452,  452,  151,  452,  452,  452,  452,   18,  452,  452,
 /*  1670 */     7,    9,  153,  452,  452,  452,   21,   14,   11,   11,
 /*  1680 */    11,   11,   13,   13,   13,   13,   18,   18,   18,  452,
 /*  1690 */   452,  452,  452,  452,  452,  452,    7,    9,  153,  452,
 /*  1700 */   452,  452,   21,   14,   11,   11,   11,   11,   13,   13,
 /*  1710 */    13,   13,   18,   18,   18,  176,  452,  452,  270,  452,
 /*  1720 */   452,  452,  452,  452,  452,  452,   16,   16,  452,  452,
 /*  1730 */   452,  452,  452,  452,  452,   14,  452,  452,  452,  452,
 /*  1740 */   452,  176,  452,  452,  271,  452,  452,  452,  452,  452,
 /*  1750 */   452,  452,   16,   16,  452,  151,  452,  452,  452,  452,
 /*  1760 */    18,   14,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  1770 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  1780 */   452,  151,  452,  452,  452,  452,   18,  452,  452,    7,
 /*  1790 */     9,  153,  452,  452,  452,   21,   14,   11,   11,   11,
 /*  1800 */    11,   13,   13,   13,   13,   18,   18,   18,  452,  452,
 /*  1810 */   452,  452,  452,  452,  452,    7,    9,  153,  452,  452,
 /*  1820 */   452,   21,   14,   11,   11,   11,   11,   13,   13,   13,
 /*  1830 */    13,   18,   18,   18,  176,  452,  452,  452,   34,  452,
 /*  1840 */   452,  452,  452,  452,  452,   16,   16,  452,  452,  452,
 /*  1850 */   452,  452,  452,  452,   14,  452,  452,  452,  452,  452,
 /*  1860 */   176,  452,  452,  273,  452,  452,  452,  452,  452,  452,
 /*  1870 */   452,   16,   16,  452,  151,  452,  452,  452,  452,   18,
 /*  1880 */    14,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  1890 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  1900 */   151,  452,  452,  452,  452,   18,  452,  452,    7,    9,
 /*  1910 */   153,  452,  452,  452,   21,   14,   11,   11,   11,   11,
 /*  1920 */    13,   13,   13,   13,   18,   18,   18,  452,  452,  452,
 /*  1930 */   452,  452,  452,  452,    7,    9,  153,  452,  452,  452,
 /*  1940 */    21,   14,   11,   11,   11,   11,   13,   13,   13,   13,
 /*  1950 */    18,   18,   18,  176,  452,  452,  452,  452,  452,  452,
 /*  1960 */   452,  452,  452,  452,   16,   16,  452,  452,  452,  452,
 /*  1970 */   452,  452,  452,   14,  452,  452,  452,  452,  452,  176,
 /*  1980 */   452,  452,  274,  452,  452,  452,  452,  452,  452,  452,
 /*  1990 */    16,   16,  452,  151,  452,  452,  452,  452,   18,   14,
 /*  2000 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  2010 */   452,  452,  452,  452,  452,  452,  452,   37,  452,  151,
 /*  2020 */   452,  452,  452,  452,   18,  452,  452,    7,    9,  153,
 /*  2030 */   452,  452,  452,   21,   14,   11,   11,   11,   11,   13,
 /*  2040 */    13,   13,   13,   18,   18,   18,  452,  452,  452,  452,
 /*  2050 */   452,  452,  452,    7,    9,  153,  452,  452,  452,   21,
 /*  2060 */    14,   11,   11,   11,   11,   13,   13,   13,   13,   18,
 /*  2070 */    18,   18,  176,  452,  452,  275,  452,  452,  452,  452,
 /*  2080 */   452,  452,  452,   16,   16,  452,  452,  452,  452,  452,
 /*  2090 */   452,  452,   14,  452,  452,  452,  452,  452,  176,  452,
 /*  2100 */   452,  452,   41,  452,  452,  452,  452,  452,  452,   16,
 /*  2110 */    16,  452,  151,  452,  452,  452,  452,   18,   14,  452,
 /*  2120 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  2130 */   452,  452,  452,  452,  452,  452,  452,  452,  151,  452,
 /*  2140 */   452,  452,  452,   18,  452,  452,    7,    9,  153,  452,
 /*  2150 */   452,  452,   21,   14,   11,   11,   11,   11,   13,   13,
 /*  2160 */    13,   13,   18,   18,   18,  452,  452,  452,  452,  452,
 /*  2170 */   452,  452,    7,    9,  153,  452,  452,  452,   21,   14,
 /*  2180 */    11,   11,   11,   11,   13,   13,   13,   13,   18,   18,
 /*  2190 */    18,  176,  452,  452,  452,   42,  452,  452,  452,  452,
 /*  2200 */   452,  452,   16,   16,  452,  452,  452,  452,  452,  452,
 /*  2210 */   452,   14,  452,  452,  452,  452,  452,  176,  452,  452,
 /*  2220 */   280,  452,  452,  452,  452,  452,  452,  452,   16,   16,
 /*  2230 */   452,  151,  452,  452,  452,  452,   18,   14,  452,  452,
 /*  2240 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  2250 */   452,  452,  452,  452,  452,  452,  452,  151,  452,  452,
 /*  2260 */   452,  452,   18,  452,  452,    7,    9,  153,  452,  452,
 /*  2270 */   452,   21,   14,   11,   11,   11,   11,   13,   13,   13,
 /*  2280 */    13,   18,   18,   18,  452,  452,  452,  452,  452,  452,
 /*  2290 */   452,    7,    9,  153,  452,  452,  452,   21,   14,   11,
 /*  2300 */    11,   11,   11,   13,   13,   13,   13,   18,   18,   18,
 /*  2310 */   176,  452,  452,  284,  452,  452,  452,  452,  452,  452,
 /*  2320 */   452,   16,   16,  452,  452,  452,  452,  452,  452,  452,
 /*  2330 */    14,  452,  452,  452,  452,  452,  176,  452,  452,  452,
 /*  2340 */   452,  452,  452,  452,  452,  452,  452,   16,   16,  452,
 /*  2350 */   151,  452,  452,  452,  452,   18,   14,  452,  452,  452,
 /*  2360 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  2370 */   452,  452,  452,  452,  452,  452,  151,  452,  452,  452,
 /*  2380 */   452,   18,  452,  452,    7,    9,  153,  452,  452,  452,
 /*  2390 */    21,   14,   11,   11,   11,   11,   13,   13,   13,   13,
 /*  2400 */    18,   18,   18,  452,  452,  452,  452,  452,  452,  452,
 /*  2410 */     7,    9,  153,  452,  452,  452,   21,   14,   11,   11,
 /*  2420 */    11,   11,   13,   13,   13,   13,   18,   18,   18,  176,
 /*  2430 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  2440 */    16,   16,  452,  452,  452,  452,  452,  176,  452,   14,
 /*  2450 */   452,  452,  452,  452,  452,  452,  452,  452,   16,   16,
 /*  2460 */   452,  452,  452,  452,  452,  452,  452,   14,  452,  151,
 /*  2470 */   452,  452,  452,  452,   18,  452,  452,  452,  452,  452,
 /*  2480 */   452,  452,  452,  452,  452,  452,  452,  151,  452,  452,
 /*  2490 */   452,  452,   18,  452,  452,  452,  452,  452,  452,  452,
 /*  2500 */   452,  452,  452,   47,    9,  153,  452,  452,  452,   21,
 /*  2510 */    14,   11,   11,   11,   11,   13,   13,   13,   13,   18,
 /*  2520 */    18,   18,    9,  153,  452,  452,  452,   21,   14,   11,
 /*  2530 */    11,   11,   11,   13,   13,   13,   13,   18,   18,   18,
 /*  2540 */   176,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  2550 */   452,   16,   16,  452,  452,  452,  452,  452,  452,  452,
 /*  2560 */    14,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  2570 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  2580 */   151,  452,  452,  452,  452,   18,  452,  452,  452,  452,
 /*  2590 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  2600 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  2610 */   452,  452,  452,  452,  452,  452,  153,  452,  452,  452,
 /*  2620 */    21,   14,   11,   11,   11,   11,   13,   13,   13,   13,
 /*  2630 */    18,   18,   18,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */     4,    5,    7,    7,    1,   10,   10,   11,  132,   13,
 /*    10 */    14,   15,   16,   17,   18,   11,  119,   13,   14,   15,
 /*    20 */    16,   17,   30,   31,   32,   33,   34,  121,   16,   17,
 /*    30 */   101,  102,  103,   10,  110,  106,   13,   42,   42,  133,
 /*    40 */   134,  117,   46,   47,   48,   49,    9,   51,   52,   53,
 /*    50 */    54,   55,   56,   57,   58,   59,   60,   61,   62,   63,
 /*    60 */    64,   65,   50,   67,   68,   42,   70,   71,   72,   73,
 /*    70 */    74,   34,    4,    5,   78,    7,    8,    9,   10,   11,
 /*    80 */    10,   13,   14,   15,   16,   17,   18,  110,  111,  112,
 /*    90 */   118,  119,   16,   17,  104,  105,  110,  107,  112,   87,
 /*   100 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*   110 */    42,  110,   42,  123,   46,   47,   48,   49,  117,   51,
 /*   120 */    52,   53,   54,   55,   56,   57,   50,    0,    1,   61,
 /*   130 */    62,   63,   64,   65,   10,   67,   68,  110,   70,   71,
 /*   140 */    72,   73,   74,  132,    4,    5,   78,    7,  124,  103,
 /*   150 */    10,   11,  106,   13,   14,   15,   16,   17,   18,    2,
 /*   160 */   130,  131,  138,  136,  132,  110,   42,   91,   92,   93,
 /*   170 */    94,   95,   96,   97,   50,  120,   19,   20,    8,    9,
 /*   180 */    23,   24,   42,   26,  115,   28,   46,   47,   48,   49,
 /*   190 */    50,   51,   52,   53,   54,   55,   56,   57,   38,   39,
 /*   200 */    43,   61,   62,   63,   64,   65,    9,   67,   68,  110,
 /*   210 */    70,   71,   72,   73,   74,  110,    4,    5,   78,    7,
 /*   220 */   110,    9,   10,   11,   27,   13,   14,   15,   16,   17,
 /*   230 */    18,   11,  110,  110,   14,   15,  110,   11,    9,   13,
 /*   240 */    14,   15,  119,  110,   18,  122,   11,    8,    9,   14,
 /*   250 */    15,   22,  119,   13,   42,  122,    8,    9,   46,   47,
 /*   260 */    48,   49,  139,   51,   52,   53,   54,   55,   56,   57,
 /*   270 */   121,  110,  139,   61,   62,   63,   64,   65,   50,   67,
 /*   280 */    68,  110,   70,   71,   72,   73,   74,    9,    4,    5,
 /*   290 */    78,    7,    5,  110,   10,   11,  110,   13,   14,   15,
 /*   300 */    16,   17,   18,   13,   78,   18,  125,    7,   16,   17,
 /*   310 */   137,   10,   11,  137,   13,   14,   15,  110,   78,   41,
 /*   320 */   110,  108,   10,   95,   96,   97,   42,  113,    4,    4,
 /*   330 */    46,   47,   48,   49,   50,   51,   52,   53,   54,   55,
 /*   340 */    56,   57,   50,   42,  113,   61,   62,   63,   64,   65,
 /*   350 */   109,   67,   68,  116,   70,   71,   72,   73,   74,  121,
 /*   360 */     4,    5,   78,    7,   34,   37,   10,   11,   78,   13,
 /*   370 */    14,   15,   16,   17,   18,   35,  127,    5,  128,   40,
 /*   380 */   129,  114,  135,  126,   12,  110,    1,   95,   96,   97,
 /*   390 */    18,  135,   18,    7,  119,   11,    8,  122,   42,    3,
 /*   400 */     5,    3,   46,   47,   48,   49,    6,   51,   52,   53,
 /*   410 */    54,   55,   56,   57,  139,    6,   24,   61,   62,   63,
 /*   420 */    64,   65,   21,   67,   68,    7,   70,   71,   72,   73,
 /*   430 */    74,   25,    5,    7,   78,   45,    7,   10,    7,    7,
 /*   440 */    13,  110,  110,   16,   17,    7,  110,  110,    7,    7,
 /*   450 */   119,  119,   25,  122,  122,  119,  119,   18,  122,  122,
 /*   460 */     7,   25,    7,   76,    7,    7,    7,    7,    7,   42,
 /*   470 */   139,  139,   45,  110,  110,  139,  139,   50,    7,    7,
 /*   480 */   110,  110,  119,  119,    7,  122,  122,    7,    7,  119,
 /*   490 */   119,    7,  122,  122,    8,    7,   97,    8,    7,   36,
 /*   500 */     8,    7,  139,  139,   77,    7,   79,   80,   81,  139,
 /*   510 */   139,    8,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   520 */    93,   94,   95,   96,   97,    5,    8,   11,    8,    9,
 /*   530 */   110,  110,  110,   27,   11,   11,   16,   17,  110,  119,
 /*   540 */   119,  119,  122,  122,  122,   25,    9,  119,   36,   30,
 /*   550 */   122,    5,   30,   10,    8,    9,   13,   29,    9,  139,
 /*   560 */   139,  139,   16,   17,  110,   45,  110,  139,   10,   76,
 /*   570 */    50,   25,   25,  119,   44,  119,  122,   45,  122,  140,
 /*   580 */    13,  140,  140,  140,  140,   42,   66,  140,  140,  140,
 /*   590 */   140,   45,  140,  139,  140,  139,   50,  140,  140,   79,
 /*   600 */    80,   81,  140,  140,  140,   85,   86,   87,   88,   89,
 /*   610 */    90,   91,   92,   93,   94,   95,   96,   97,  140,  140,
 /*   620 */    77,  140,  140,  140,  140,   79,   80,   81,  140,  140,
 /*   630 */   140,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*   640 */    94,   95,   96,   97,    5,  140,  140,    8,  110,  110,
 /*   650 */   110,  140,  140,  140,  140,   16,   17,  119,  119,  119,
 /*   660 */   122,  122,  122,  140,   25,  140,   27,  140,  140,  140,
 /*   670 */     5,  110,  140,  140,    9,  140,  110,  139,  139,  139,
 /*   680 */   119,   16,   17,  122,   45,  119,  140,  110,  122,   50,
 /*   690 */    25,  140,   27,  140,  140,  140,  119,  140,  140,  122,
 /*   700 */   139,  140,  140,  140,  140,  139,  140,  140,  140,  140,
 /*   710 */    45,  140,  140,  140,  140,   50,  139,  140,   79,   80,
 /*   720 */    81,  140,  140,  140,   85,   86,   87,   88,   89,   90,
 /*   730 */    91,   92,   93,   94,   95,   96,   97,  140,  140,  140,
 /*   740 */   140,  140,  140,  140,   79,   80,   81,  140,  140,  140,
 /*   750 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*   760 */    95,   96,   97,    5,  140,  140,    8,    9,  110,  110,
 /*   770 */   110,  140,  140,  140,   16,   17,  140,  119,  119,  119,
 /*   780 */   122,  122,  122,   25,  140,  140,  140,  140,  140,    5,
 /*   790 */   140,  140,  140,    9,  140,  110,  140,  139,  139,  139,
 /*   800 */    16,   17,  140,   45,  119,  140,  140,  122,   50,   25,
 /*   810 */   140,  110,  140,  140,  140,  140,  140,  140,  140,  140,
 /*   820 */   119,  140,  140,  122,  139,  140,  140,  140,  140,   45,
 /*   830 */   140,  140,  140,  140,   50,  140,  140,   79,   80,   81,
 /*   840 */   139,  140,  140,   85,   86,   87,   88,   89,   90,   91,
 /*   850 */    92,   93,   94,   95,   96,   97,  140,  140,  140,   75,
 /*   860 */   140,  140,  140,   79,   80,   81,  140,  140,  140,   85,
 /*   870 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*   880 */    96,   97,    5,  140,  140,    8,  110,  140,  110,  140,
 /*   890 */   140,  140,  110,   16,   17,  119,  140,  119,  122,  140,
 /*   900 */   122,  119,   25,  140,  122,  140,  140,  140,    5,  140,
 /*   910 */   140,    8,  140,  140,  110,  139,  140,  139,  140,   16,
 /*   920 */    17,  139,   45,  119,  140,  140,  122,   50,   25,  140,
 /*   930 */   140,  140,  140,  140,  140,  140,  140,  140,  140,  140,
 /*   940 */   140,  140,  140,  139,  140,  140,  140,  140,   45,  140,
 /*   950 */   140,  140,  140,   50,  140,  140,   79,   80,   81,  140,
 /*   960 */   140,  140,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   970 */    93,   94,   95,   96,   97,  140,  140,  140,  140,  140,
 /*   980 */   140,  140,   79,   80,   81,  140,  140,  140,   85,   86,
 /*   990 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*  1000 */    97,    5,  140,  140,    8,  110,  110,  140,  140,  140,
 /*  1010 */   140,  110,   16,   17,  119,  119,  140,  122,  122,  110,
 /*  1020 */   119,   25,  140,  122,  140,  140,  140,    5,  119,  140,
 /*  1030 */     8,  122,  140,  110,  139,  139,  140,  140,   16,   17,
 /*  1040 */   139,   45,  119,  140,  140,  122,   50,   25,  139,  140,
 /*  1050 */   140,  140,  140,  140,  140,  140,  140,  140,  140,  140,
 /*  1060 */   140,  140,  139,  140,  140,  140,  140,   45,  140,  140,
 /*  1070 */   140,  140,   50,  140,  140,   79,   80,   81,  140,  140,
 /*  1080 */   140,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*  1090 */    94,   95,   96,   97,  140,  140,  140,  140,  140,  140,
 /*  1100 */   140,   79,   80,   81,  140,  140,  140,   85,   86,   87,
 /*  1110 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*  1120 */     5,  140,  140,    8,  110,  110,  110,  140,  140,  140,
 /*  1130 */   110,   16,   17,  119,  119,  119,  122,  122,  122,  119,
 /*  1140 */    25,  140,  122,  140,  140,  140,    5,  140,  140,    8,
 /*  1150 */   140,  140,  110,  139,  139,  139,  140,   16,   17,  139,
 /*  1160 */    45,  119,  140,  140,  122,   50,   25,  140,  140,  140,
 /*  1170 */   140,  140,  140,  140,  140,  140,  140,  140,  140,  140,
 /*  1180 */   140,  139,  140,  140,  140,  140,   45,  140,  140,  140,
 /*  1190 */   140,   50,  140,  140,   79,   80,   81,  140,  140,  140,
 /*  1200 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*  1210 */    95,   96,   97,  140,  140,  140,  140,  140,  140,  140,
 /*  1220 */    79,   80,   81,  140,  140,  140,   85,   86,   87,   88,
 /*  1230 */    89,   90,   91,   92,   93,   94,   95,   96,   97,    5,
 /*  1240 */   140,  140,    8,  110,  110,  110,  140,  140,  140,  110,
 /*  1250 */    16,   17,  119,  119,  119,  122,  122,  122,  119,   25,
 /*  1260 */   140,  122,  140,  140,  140,    5,  140,  140,    8,  140,
 /*  1270 */   140,  110,  139,  139,  139,  140,   16,   17,  139,   45,
 /*  1280 */   119,  140,  140,  122,   50,   25,  140,  140,  140,  140,
 /*  1290 */   140,  140,  140,  140,  140,  140,  140,  140,  140,  140,
 /*  1300 */   139,  140,  140,  140,  140,   45,  140,  140,  140,  140,
 /*  1310 */    50,  140,  140,   79,   80,   81,  140,  140,  140,   85,
 /*  1320 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*  1330 */    96,   97,  140,  140,  140,  140,  140,  140,  140,   79,
 /*  1340 */    80,   81,  140,  140,  140,   85,   86,   87,   88,   89,
 /*  1350 */    90,   91,   92,   93,   94,   95,   96,   97,    5,  140,
 /*  1360 */   140,    8,  110,  110,  140,  140,  140,  140,  140,   16,
 /*  1370 */    17,  119,  119,  140,  122,  122,  140,  140,   25,  140,
 /*  1380 */   140,  140,  140,  140,    5,  140,  140,    8,  140,  140,
 /*  1390 */   140,  139,  139,  140,  140,   16,   17,  140,   45,  140,
 /*  1400 */   140,  140,  140,   50,   25,  140,  140,  140,  140,  140,
 /*  1410 */   140,  140,  140,  140,  140,  140,  140,  140,  140,  140,
 /*  1420 */   140,  140,  140,  140,   45,  140,  140,  140,  140,   50,
 /*  1430 */   140,  140,   79,   80,   81,  140,  140,  140,   85,   86,
 /*  1440 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*  1450 */    97,  140,  140,  140,  140,  140,  140,  140,   79,   80,
 /*  1460 */    81,  140,  140,  140,   85,   86,   87,   88,   89,   90,
 /*  1470 */    91,   92,   93,   94,   95,   96,   97,    5,  140,  140,
 /*  1480 */     8,  140,  140,  140,  140,  140,  140,  140,   16,   17,
 /*  1490 */   140,  140,  140,  140,  140,  140,  140,   25,  140,  140,
 /*  1500 */   140,  140,  140,    5,  140,  140,    8,  140,  140,  140,
 /*  1510 */   140,  140,  140,  140,   16,   17,  140,   45,  140,  140,
 /*  1520 */   140,  140,   50,   25,  140,  140,  140,  140,  140,  140,
 /*  1530 */   140,  140,  140,  140,  140,  140,  140,  140,  140,  140,
 /*  1540 */   140,  140,  140,   45,  140,  140,  140,  140,   50,  140,
 /*  1550 */   140,   79,   80,   81,  140,  140,  140,   85,   86,   87,
 /*  1560 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*  1570 */   140,  140,  140,  140,  140,  140,  140,   79,   80,   81,
 /*  1580 */   140,  140,  140,   85,   86,   87,   88,   89,   90,   91,
 /*  1590 */    92,   93,   94,   95,   96,   97,    5,  140,  140,    8,
 /*  1600 */   140,  140,  140,  140,  140,  140,  140,   16,   17,  140,
 /*  1610 */   140,  140,  140,  140,  140,  140,   25,  140,  140,  140,
 /*  1620 */   140,  140,    5,  140,  140,    8,  140,  140,  140,  140,
 /*  1630 */   140,  140,  140,   16,   17,  140,   45,  140,  140,  140,
 /*  1640 */   140,   50,   25,  140,  140,  140,  140,  140,  140,  140,
 /*  1650 */   140,  140,  140,  140,  140,  140,  140,  140,  140,  140,
 /*  1660 */   140,  140,   45,  140,  140,  140,  140,   50,  140,  140,
 /*  1670 */    79,   80,   81,  140,  140,  140,   85,   86,   87,   88,
 /*  1680 */    89,   90,   91,   92,   93,   94,   95,   96,   97,  140,
 /*  1690 */   140,  140,  140,  140,  140,  140,   79,   80,   81,  140,
 /*  1700 */   140,  140,   85,   86,   87,   88,   89,   90,   91,   92,
 /*  1710 */    93,   94,   95,   96,   97,    5,  140,  140,    8,  140,
 /*  1720 */   140,  140,  140,  140,  140,  140,   16,   17,  140,  140,
 /*  1730 */   140,  140,  140,  140,  140,   25,  140,  140,  140,  140,
 /*  1740 */   140,    5,  140,  140,    8,  140,  140,  140,  140,  140,
 /*  1750 */   140,  140,   16,   17,  140,   45,  140,  140,  140,  140,
 /*  1760 */    50,   25,  140,  140,  140,  140,  140,  140,  140,  140,
 /*  1770 */   140,  140,  140,  140,  140,  140,  140,  140,  140,  140,
 /*  1780 */   140,   45,  140,  140,  140,  140,   50,  140,  140,   79,
 /*  1790 */    80,   81,  140,  140,  140,   85,   86,   87,   88,   89,
 /*  1800 */    90,   91,   92,   93,   94,   95,   96,   97,  140,  140,
 /*  1810 */   140,  140,  140,  140,  140,   79,   80,   81,  140,  140,
 /*  1820 */   140,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*  1830 */    94,   95,   96,   97,    5,  140,  140,  140,    9,  140,
 /*  1840 */   140,  140,  140,  140,  140,   16,   17,  140,  140,  140,
 /*  1850 */   140,  140,  140,  140,   25,  140,  140,  140,  140,  140,
 /*  1860 */     5,  140,  140,    8,  140,  140,  140,  140,  140,  140,
 /*  1870 */   140,   16,   17,  140,   45,  140,  140,  140,  140,   50,
 /*  1880 */    25,  140,  140,  140,  140,  140,  140,  140,  140,  140,
 /*  1890 */   140,  140,  140,  140,  140,  140,  140,  140,  140,  140,
 /*  1900 */    45,  140,  140,  140,  140,   50,  140,  140,   79,   80,
 /*  1910 */    81,  140,  140,  140,   85,   86,   87,   88,   89,   90,
 /*  1920 */    91,   92,   93,   94,   95,   96,   97,  140,  140,  140,
 /*  1930 */   140,  140,  140,  140,   79,   80,   81,  140,  140,  140,
 /*  1940 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*  1950 */    95,   96,   97,    5,  140,  140,  140,  140,  140,  140,
 /*  1960 */   140,  140,  140,  140,   16,   17,  140,  140,  140,  140,
 /*  1970 */   140,  140,  140,   25,  140,  140,  140,  140,  140,    5,
 /*  1980 */   140,  140,    8,  140,  140,  140,  140,  140,  140,  140,
 /*  1990 */    16,   17,  140,   45,  140,  140,  140,  140,   50,   25,
 /*  2000 */   140,  140,  140,  140,  140,  140,  140,  140,  140,  140,
 /*  2010 */   140,  140,  140,  140,  140,  140,  140,   69,  140,   45,
 /*  2020 */   140,  140,  140,  140,   50,  140,  140,   79,   80,   81,
 /*  2030 */   140,  140,  140,   85,   86,   87,   88,   89,   90,   91,
 /*  2040 */    92,   93,   94,   95,   96,   97,  140,  140,  140,  140,
 /*  2050 */   140,  140,  140,   79,   80,   81,  140,  140,  140,   85,
 /*  2060 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*  2070 */    96,   97,    5,  140,  140,    8,  140,  140,  140,  140,
 /*  2080 */   140,  140,  140,   16,   17,  140,  140,  140,  140,  140,
 /*  2090 */   140,  140,   25,  140,  140,  140,  140,  140,    5,  140,
 /*  2100 */   140,  140,    9,  140,  140,  140,  140,  140,  140,   16,
 /*  2110 */    17,  140,   45,  140,  140,  140,  140,   50,   25,  140,
 /*  2120 */   140,  140,  140,  140,  140,  140,  140,  140,  140,  140,
 /*  2130 */   140,  140,  140,  140,  140,  140,  140,  140,   45,  140,
 /*  2140 */   140,  140,  140,   50,  140,  140,   79,   80,   81,  140,
 /*  2150 */   140,  140,   85,   86,   87,   88,   89,   90,   91,   92,
 /*  2160 */    93,   94,   95,   96,   97,  140,  140,  140,  140,  140,
 /*  2170 */   140,  140,   79,   80,   81,  140,  140,  140,   85,   86,
 /*  2180 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*  2190 */    97,    5,  140,  140,  140,    9,  140,  140,  140,  140,
 /*  2200 */   140,  140,   16,   17,  140,  140,  140,  140,  140,  140,
 /*  2210 */   140,   25,  140,  140,  140,  140,  140,    5,  140,  140,
 /*  2220 */     8,  140,  140,  140,  140,  140,  140,  140,   16,   17,
 /*  2230 */   140,   45,  140,  140,  140,  140,   50,   25,  140,  140,
 /*  2240 */   140,  140,  140,  140,  140,  140,  140,  140,  140,  140,
 /*  2250 */   140,  140,  140,  140,  140,  140,  140,   45,  140,  140,
 /*  2260 */   140,  140,   50,  140,  140,   79,   80,   81,  140,  140,
 /*  2270 */   140,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*  2280 */    94,   95,   96,   97,  140,  140,  140,  140,  140,  140,
 /*  2290 */   140,   79,   80,   81,  140,  140,  140,   85,   86,   87,
 /*  2300 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*  2310 */     5,  140,  140,    8,  140,  140,  140,  140,  140,  140,
 /*  2320 */   140,   16,   17,  140,  140,  140,  140,  140,  140,  140,
 /*  2330 */    25,  140,  140,  140,  140,  140,    5,  140,  140,  140,
 /*  2340 */   140,  140,  140,  140,  140,  140,  140,   16,   17,  140,
 /*  2350 */    45,  140,  140,  140,  140,   50,   25,  140,  140,  140,
 /*  2360 */   140,  140,  140,  140,  140,  140,  140,  140,  140,  140,
 /*  2370 */   140,  140,  140,  140,  140,  140,   45,  140,  140,  140,
 /*  2380 */   140,   50,  140,  140,   79,   80,   81,  140,  140,  140,
 /*  2390 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*  2400 */    95,   96,   97,  140,  140,  140,  140,  140,  140,  140,
 /*  2410 */    79,   80,   81,  140,  140,  140,   85,   86,   87,   88,
 /*  2420 */    89,   90,   91,   92,   93,   94,   95,   96,   97,    5,
 /*  2430 */   140,  140,  140,  140,  140,  140,  140,  140,  140,  140,
 /*  2440 */    16,   17,  140,  140,  140,  140,  140,    5,  140,   25,
 /*  2450 */   140,  140,  140,  140,  140,  140,  140,  140,   16,   17,
 /*  2460 */   140,  140,  140,  140,  140,  140,  140,   25,  140,   45,
 /*  2470 */   140,  140,  140,  140,   50,  140,  140,  140,  140,  140,
 /*  2480 */   140,  140,  140,  140,  140,  140,  140,   45,  140,  140,
 /*  2490 */   140,  140,   50,  140,  140,  140,  140,  140,  140,  140,
 /*  2500 */   140,  140,  140,   79,   80,   81,  140,  140,  140,   85,
 /*  2510 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*  2520 */    96,   97,   80,   81,  140,  140,  140,   85,   86,   87,
 /*  2530 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*  2540 */     5,  140,  140,  140,  140,  140,  140,  140,  140,  140,
 /*  2550 */   140,   16,   17,  140,  140,  140,  140,  140,  140,  140,
 /*  2560 */    25,  140,  140,  140,  140,  140,  140,  140,  140,  140,
 /*  2570 */   140,  140,  140,  140,  140,  140,  140,  140,  140,  140,
 /*  2580 */    45,  140,  140,  140,  140,   50,  140,  140,  140,  140,
 /*  2590 */   140,  140,  140,  140,  140,  140,  140,  140,  140,  140,
 /*  2600 */   140,  140,  140,  140,  140,  140,  140,  140,  140,  140,
 /*  2610 */   140,  140,  140,  140,  140,  140,   81,  140,  140,  140,
 /*  2620 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*  2630 */    95,   96,   97,
};
#define YY_SHIFT_USE_DFLT (-9)
#define YY_SHIFT_MAX 219
static const short yy_shift_ofst[] = {
 /*     0 */     3,   -4,   68,  140,  212,  284,  356,  356,  356,  356,
 /*    10 */   356,  356,  356,  356,  356,  356,  356,  356,  356,  356,
 /*    20 */   356,  356,  356,  356,  356,  356,  356,  356,  356,  356,
 /*    30 */   356,  356,  356,  356,  356,  356,  356,  356,  356,  356,
 /*    40 */   356,  356,  356,  356,  356,  356,  356,  356,  356,  356,
 /*    50 */   356,  157,   -8,   70,  226,   -5,   -5,  127,   70,   70,
 /*    60 */    70,   -9,   -9,  427,  226,  543,  543,  372,  124,   70,
 /*    70 */    70,   70,   70,   70,   37,   70,   70,   70,  197,   70,
 /*    80 */   160,  160,   70,   70,  300,  312,  324,  325,  312,  330,
 /*    90 */   340,  328,  339,   -9,   -9,   -9,   -9,  520,  546,  639,
 /*   100 */   665,  758,  784,  877,  903,  996, 1022, 1115, 1141, 1234,
 /*   110 */  1260, 1353, 1379, 1472, 1498, 1591, 1617, 1710, 1736, 1829,
 /*   120 */  1855, 1948, 1974, 2067, 2093, 2186, 2212, 2305, 2331, 2331,
 /*   130 */  2424, 2331, 2331, 2331, 2442, 2535, 2535,   12,   12,   76,
 /*   140 */     4,  292,  301,  228,  220,  235,   23,  170,  229,  239,
 /*   150 */   248,  240,  290,  287,  278,  385,  374,  386,  384,  388,
 /*   160 */   396,  395,  400,  398,  409,  401,  418,  392,  406,  426,
 /*   170 */   429,  431,  432,  438,  441,  442,  390,  439,  453,  455,
 /*   180 */   457,  458,  459,  460,  461,  471,  472,  477,  480,  481,
 /*   190 */   484,  486,  488,  489,  491,  492,  494,  503,  498,  387,
 /*   200 */   399,  518,  436,  506,  516,  523,  524,  463,  537,  512,
 /*   210 */   528,  519,  522,  549,  493,  558,  547,  530,  532,  567,
};
#define YY_REDUCE_USE_DFLT (-125)
#define YY_REDUCE_MAX 96
static const short yy_reduce_ofst[] = {
 /*     0 */   -71,  123,  133,  275,  133,  331,  332,  336,  337,  363,
 /*    10 */   364,  370,  371,  420,  421,  422,  428,  454,  456,  538,
 /*    20 */   539,  540,  561,  566,  577,  658,  659,  660,  685,  701,
 /*    30 */   776,  778,  782,  804,  895,  896,  901,  909,  923, 1014,
 /*    40 */  1015, 1016, 1020, 1042, 1133, 1134, 1135, 1139, 1161, 1252,
 /*    50 */  1253,  -10,  -94,  -23,  -28,  -76,    1,   46,  -14,   55,
 /*    60 */    27,   24,   30, -124, -103,   11,   32,   69,   99,  105,
 /*    70 */   110,  122,  126,  161,  149,  171,   99,  183,  181,  186,
 /*    80 */   173,  176,  207,  210,  213,  214,  241,  237,  231,  238,
 /*    90 */   249,  250,  251,  267,  247,  257,  256,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   320,  450,  450,  450,  368,  450,  450,  450,  450,  450,
 /*    10 */   450,  450,  450,  450,  450,  450,  450,  450,  450,  450,
 /*    20 */   450,  450,  450,  450,  450,  450,  450,  450,  450,  450,
 /*    30 */   450,  450,  450,  450,  450,  450,  450,  450,  450,  450,
 /*    40 */   450,  450,  450,  450,  450,  450,  450,  450,  450,  450,
 /*    50 */   450,  450,  365,  450,  450,  342,  342,  320,  450,  450,
 /*    60 */   450,  417,  357,  421,  450,  421,  421,  328,  450,  450,
 /*    70 */   450,  450,  450,  450,  365,  450,  450,  450,  354,  450,
 /*    80 */   373,  373,  450,  450,  450,  450,  323,  340,  450,  365,
 /*    90 */   367,  369,  376,  331,  447,  359,  447,  450,  450,  450,
 /*   100 */   450,  450,  450,  450,  450,  450,  450,  450,  450,  450,
 /*   110 */   450,  450,  450,  450,  450,  450,  450,  450,  450,  450,
 /*   120 */   450,  450,  450,  450,  450,  450,  450,  450,  349,  448,
 /*   130 */   450,  366,  350,  361,  428,  441,  429,  446,  432,  430,
 /*   140 */   450,  431,  450,  433,  450,  450,  450,  450,  450,  450,
 /*   150 */   450,  450,  450,  450,  377,  450,  450,  329,  450,  450,
 /*   160 */   450,  450,  450,  450,  450,  450,  450,  450,  450,  450,
 /*   170 */   450,  450,  450,  450,  450,  450,  450,  450,  450,  450,
 /*   180 */   450,  450,  450,  450,  450,  450,  450,  450,  450,  450,
 /*   190 */   408,  450,  410,  450,  412,  450,  450,  450,  450,  436,
 /*   200 */   434,  450,  450,  450,  450,  450,  450,  450,  370,  450,
 /*   210 */   450,  450,  450,  355,  436,  450,  450,  450,  381,  450,
 /*   220 */   315,  318,  317,  319,  321,  325,  326,  332,  333,  334,
 /*   230 */   335,  336,  337,  330,  426,  327,  322,  324,  338,  339,
 /*   240 */   341,  346,  424,  425,  347,  344,  343,  345,  348,  383,
 /*   250 */   384,  385,  386,  388,  389,  390,  391,  438,  439,  442,
 /*   260 */   443,  392,  393,  394,  395,  396,  397,  398,  399,  400,
 /*   270 */   401,  402,  404,  405,  406,  407,  409,  411,  413,  414,
 /*   280 */   415,  427,  435,  437,  440,  444,  445,  403,  449,  387,
 /*   290 */   351,  352,  353,  378,  379,  371,  374,  375,  372,  360,
 /*   300 */   422,  423,  362,  363,  364,  356,  358,  416,  418,  419,
 /*   310 */   420,  380,  382,  316,
};
#define YY_SZ_ACTTAB (int)(sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  ParseARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "SEMI",          "CREATE",        "TABLE",       
  "IF",            "NOT",           "EXISTS",        "LP",          
  "RP",            "COMMA",         "ID",            "INT",         
  "DEFAULT",       "ARG",           "FLOAT",         "HEX",         
  "ADD",           "SUB",           "NULL",          "DROP",        
  "INSERT",        "INTO",          "VALUES",        "UPDATE",      
  "SET",           "EQ",            "DELETE",        "FROM",        
  "SELECT",        "ON",            "JOIN",          "INNER",       
  "CROSS",         "LEFT",          "WHERE",         "GROUP",       
  "BY",            "ORDER",         "ASC",           "DESC",        
  "LIMIT",         "OFFSET",        "QID",           "SHOW",        
  "VARIABLES",     "LIKE",          "SUM",           "MIN",         
  "MAX",           "COUNT",         "MUL",           "AVG",         
  "ABS",           "ROUND",         "CONCAT",        "LOWER",       
  "UPPER",         "TRIM",          "LEADING",       "TRAILING",    
  "BOTH",          "LTRIM",         "RTRIM",         "LENGTH",      
  "CHAR_LENGTH",   "SUBSTR",        "FOR",           "LOCATE",      
  "POSITION",      "IN",            "ASCII",         "CURRENT_TIMESTAMP",
  "CURRENT_TIME",  "CURRENT_DATE",  "CONVERT",       "USING",       
  "DOT",           "ALIAS",         "QUEST",         "AND",         
  "OR",            "IS",            "NOTLIKE",       "ISNULL",      
  "NOTNULL",       "BETWEEN",       "NE",            "GT",          
  "GE",            "LT",            "LE",            "BITAND",      
  "BITOR",         "SHL",           "SHR",           "DIV",         
  "MOD",           "EXP",           "MINUS",         "PLUS",        
  "error",         "input",         "cmdlist",       "ecmd",        
  "cmdx",          "cmd",           "explain",       "create_table",
  "create_table_args",  "ifnotexists",   "id",            "columnlist",  
  "column",        "ctype",         "carglist",      "carg",        
  "ifexists",      "inscollist",    "itemlist",      "arg",         
  "setlist",       "where_opt",     "expr",          "select",      
  "selcollist",    "from",          "join_opt",      "groupby_opt", 
  "orderby_opt",   "limit_opt",     "tablelist",     "tlp",         
  "as",            "join_entry",    "join_type",     "exprlist",    
  "sortlist",      "sortorder",     "sclp",          "field",       
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "cmdx ::= cmd",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "ecmd ::= explain cmdx SEMI",
 /*   6 */ "explain ::=",
 /*   7 */ "cmd ::= create_table create_table_args",
 /*   8 */ "create_table ::= CREATE TABLE ifnotexists id",
 /*   9 */ "ifnotexists ::=",
 /*  10 */ "ifnotexists ::= IF NOT EXISTS",
 /*  11 */ "create_table_args ::= LP columnlist RP",
 /*  12 */ "columnlist ::= columnlist COMMA column",
 /*  13 */ "columnlist ::= column",
 /*  14 */ "column ::= id ctype carglist",
 /*  15 */ "ctype ::= ID",
 /*  16 */ "ctype ::= ID LP INT RP",
 /*  17 */ "carglist ::=",
 /*  18 */ "carglist ::= carglist carg",
 /*  19 */ "carg ::= DEFAULT ARG|INT|FLOAT|HEX",
 /*  20 */ "carg ::= DEFAULT ADD INT|FLOAT|HEX",
 /*  21 */ "carg ::= DEFAULT SUB INT|FLOAT|HEX",
 /*  22 */ "carg ::= NULL",
 /*  23 */ "carg ::= NOT NULL",
 /*  24 */ "cmd ::= DROP TABLE ifexists id",
 /*  25 */ "ifexists ::= IF EXISTS",
 /*  26 */ "ifexists ::=",
 /*  27 */ "cmd ::= INSERT INTO id inscollist VALUES LP itemlist RP",
 /*  28 */ "inscollist ::=",
 /*  29 */ "inscollist ::= LP inscollist RP",
 /*  30 */ "inscollist ::= inscollist COMMA id",
 /*  31 */ "inscollist ::= id",
 /*  32 */ "itemlist ::= itemlist COMMA arg",
 /*  33 */ "itemlist ::= arg",
 /*  34 */ "cmd ::= UPDATE id SET setlist where_opt",
 /*  35 */ "setlist ::= setlist COMMA id EQ expr",
 /*  36 */ "setlist ::= id EQ expr",
 /*  37 */ "cmd ::= DELETE FROM id where_opt",
 /*  38 */ "cmd ::= select",
 /*  39 */ "select ::= SELECT selcollist from join_opt where_opt groupby_opt orderby_opt limit_opt",
 /*  40 */ "from ::=",
 /*  41 */ "from ::= FROM tablelist",
 /*  42 */ "tlp ::= tablelist COMMA",
 /*  43 */ "tlp ::=",
 /*  44 */ "tablelist ::= tlp id as",
 /*  45 */ "join_opt ::=",
 /*  46 */ "join_opt ::= join_opt join_entry",
 /*  47 */ "join_entry ::= join_type id as ON expr",
 /*  48 */ "join_type ::= JOIN",
 /*  49 */ "join_type ::= INNER|CROSS JOIN",
 /*  50 */ "join_type ::= LEFT JOIN",
 /*  51 */ "where_opt ::=",
 /*  52 */ "where_opt ::= WHERE expr",
 /*  53 */ "groupby_opt ::=",
 /*  54 */ "groupby_opt ::= GROUP BY exprlist",
 /*  55 */ "orderby_opt ::=",
 /*  56 */ "orderby_opt ::= ORDER BY sortlist",
 /*  57 */ "sortlist ::= sortlist COMMA id sortorder",
 /*  58 */ "sortlist ::= id sortorder",
 /*  59 */ "sortorder ::=",
 /*  60 */ "sortorder ::= ASC",
 /*  61 */ "sortorder ::= DESC",
 /*  62 */ "limit_opt ::=",
 /*  63 */ "limit_opt ::= LIMIT INT",
 /*  64 */ "limit_opt ::= LIMIT INT OFFSET INT",
 /*  65 */ "limit_opt ::= LIMIT INT COMMA INT",
 /*  66 */ "cmd ::= SET ID EQ INT|FLOAT|ARG|ID|QID|HEX",
 /*  67 */ "cmd ::= SHOW VARIABLES",
 /*  68 */ "cmd ::= SHOW VARIABLES LIKE ARG",
 /*  69 */ "expr ::= SUM LP expr RP",
 /*  70 */ "expr ::= MIN LP expr RP",
 /*  71 */ "expr ::= MAX LP expr RP",
 /*  72 */ "expr ::= COUNT LP expr RP",
 /*  73 */ "expr ::= COUNT LP MUL RP",
 /*  74 */ "expr ::= AVG LP expr RP",
 /*  75 */ "expr ::= ABS LP expr RP",
 /*  76 */ "expr ::= ROUND LP expr RP",
 /*  77 */ "expr ::= ROUND LP expr COMMA expr RP",
 /*  78 */ "expr ::= CONCAT LP exprlist RP",
 /*  79 */ "expr ::= LOWER LP expr RP",
 /*  80 */ "expr ::= UPPER LP expr RP",
 /*  81 */ "expr ::= TRIM LP expr RP",
 /*  82 */ "expr ::= TRIM LP LEADING|TRAILING|BOTH expr RP",
 /*  83 */ "expr ::= TRIM LP LEADING|TRAILING|BOTH expr FROM expr RP",
 /*  84 */ "expr ::= LTRIM LP expr RP",
 /*  85 */ "expr ::= RTRIM LP expr RP",
 /*  86 */ "expr ::= LENGTH LP expr RP",
 /*  87 */ "expr ::= CHAR_LENGTH LP expr RP",
 /*  88 */ "expr ::= SUBSTR LP expr FROM|COMMA expr FOR|COMMA expr RP",
 /*  89 */ "expr ::= SUBSTR LP expr FROM|COMMA expr RP",
 /*  90 */ "expr ::= LOCATE LP expr COMMA expr RP",
 /*  91 */ "expr ::= LOCATE LP expr COMMA expr COMMA expr RP",
 /*  92 */ "expr ::= POSITION LP expr IN expr RP",
 /*  93 */ "expr ::= ASCII LP expr RP",
 /*  94 */ "expr ::= CURRENT_TIMESTAMP",
 /*  95 */ "expr ::= CURRENT_TIMESTAMP LP RP",
 /*  96 */ "expr ::= CURRENT_TIME",
 /*  97 */ "expr ::= CURRENT_TIME LP RP",
 /*  98 */ "expr ::= CURRENT_DATE",
 /*  99 */ "expr ::= CURRENT_DATE LP RP",
 /* 100 */ "expr ::= CONVERT LP expr COMMA|USING ctype RP",
 /* 101 */ "expr ::= IF LP expr COMMA expr COMMA expr RP",
 /* 102 */ "sclp ::= selcollist COMMA",
 /* 103 */ "sclp ::=",
 /* 104 */ "selcollist ::= sclp expr as",
 /* 105 */ "selcollist ::= sclp MUL",
 /* 106 */ "selcollist ::= sclp id DOT MUL",
 /* 107 */ "as ::=",
 /* 108 */ "as ::= ALIAS ID|QID|ARG",
 /* 109 */ "as ::= ID|QID|ARG",
 /* 110 */ "arg ::= ARG|INT|FLOAT|HEX",
 /* 111 */ "arg ::= QUEST|NULL",
 /* 112 */ "id ::= ID|QID",
 /* 113 */ "field ::= id DOT id",
 /* 114 */ "expr ::= expr AND expr",
 /* 115 */ "expr ::= expr OR expr",
 /* 116 */ "expr ::= expr LT|LE|GT|GE expr",
 /* 117 */ "expr ::= expr BITAND|BITOR|SHL|SHR expr",
 /* 118 */ "expr ::= expr EQ|NE expr",
 /* 119 */ "expr ::= expr ADD|SUB expr",
 /* 120 */ "expr ::= expr MUL|DIV|MOD|EXP expr",
 /* 121 */ "expr ::= arg",
 /* 122 */ "expr ::= id",
 /* 123 */ "expr ::= field",
 /* 124 */ "expr ::= expr LIKE ARG|QUEST",
 /* 125 */ "expr ::= expr NOT LIKE ARG|QUEST",
 /* 126 */ "expr ::= LP expr RP",
 /* 127 */ "expr ::= NOT expr",
 /* 128 */ "expr ::= expr IS NULL",
 /* 129 */ "expr ::= expr IS NOT NULL",
 /* 130 */ "expr ::= SUB expr",
 /* 131 */ "expr ::= ADD expr",
 /* 132 */ "expr ::= expr BETWEEN expr AND expr",
 /* 133 */ "exprlist ::=",
 /* 134 */ "exprlist ::= exprlist expr",
 /* 135 */ "exprlist ::= exprlist COMMA",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#if YYSTACKDEPTH<=0
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
    case 32:
    case 33:
    case 34:
    case 35:
    case 36:
    case 37:
    case 38:
    case 39:
    case 40:
    case 41:
    case 42:
    case 43:
    case 44:
    case 45:
    case 46:
    case 47:
    case 48:
    case 49:
    case 50:
    case 51:
    case 52:
    case 53:
    case 54:
    case 55:
    case 56:
    case 57:
    case 58:
    case 59:
    case 60:
    case 61:
    case 62:
    case 63:
    case 64:
    case 65:
    case 66:
    case 67:
    case 68:
    case 69:
    case 70:
    case 71:
    case 72:
    case 73:
    case 74:
    case 75:
    case 76:
    case 77:
    case 78:
    case 79:
    case 80:
    case 81:
    case 82:
    case 83:
    case 84:
    case 85:
    case 86:
    case 87:
    case 88:
    case 89:
    case 90:
    case 91:
    case 92:
    case 93:
    case 94:
    case 95:
    case 96:
    case 97:
    case 98:
    case 99:
#line 28 "parse_tab.lem"
{
	/*
	if( (yypminor->yy0).dyn )
		free( (char *) (yypminor->yy0).str );
	*/
}
#line 1207 "parse_tab.c"
      break;
    case 110:
    case 115:
    case 119:
    case 139:
#line 422 "parse_tab.lem"
{ csv_expr_free( (yypminor->yy102) ); }
#line 1215 "parse_tab.c"
      break;
    case 114:
    case 118:
    case 120:
#line 91 "parse_tab.lem"
{ csv_exprlist_free( (yypminor->yy214) ); }
#line 1222 "parse_tab.c"
      break;
    case 117:
    case 124:
    case 125:
    case 126:
    case 127:
    case 128:
    case 130:
    case 131:
    case 135:
    case 136:
    case 138:
#line 136 "parse_tab.lem"
{ csv_exprlist_free( (yypminor->yy42) ); }
#line 1237 "parse_tab.c"
      break;
    case 121:
    case 122:
#line 224 "parse_tab.lem"
{ csv_expr_free( (yypminor->yy202) ); }
#line 1243 "parse_tab.c"
      break;
    case 123:
#line 177 "parse_tab.lem"
{ csv_select_free( (yypminor->yy81) ); }
#line 1248 "parse_tab.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from ParseAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      int iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( j>=0 && j<YY_SZ_ACTTAB && yy_lookahead[j]==YYWILDCARD ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  /* int stateno = pParser->yystack[pParser->yyidx].stateno; */
 
  if( stateno>YY_REDUCE_MAX ||
      (i = yy_reduce_ofst[stateno])==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   ParseARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
#line 37 "parse_tab.lem"

	csv_error_msg( parse, CSV_ERR_STACKOVERFLOW, "Stack overflow" );
#line 1411 "parse_tab.c"
   ParseARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#if YYSTACKDEPTH>0 
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 101, 1 },
  { 102, 2 },
  { 102, 1 },
  { 104, 1 },
  { 103, 1 },
  { 103, 3 },
  { 106, 0 },
  { 105, 2 },
  { 107, 4 },
  { 109, 0 },
  { 109, 3 },
  { 108, 3 },
  { 111, 3 },
  { 111, 1 },
  { 112, 3 },
  { 113, 1 },
  { 113, 4 },
  { 114, 0 },
  { 114, 2 },
  { 115, 2 },
  { 115, 3 },
  { 115, 3 },
  { 115, 1 },
  { 115, 2 },
  { 105, 4 },
  { 116, 2 },
  { 116, 0 },
  { 105, 8 },
  { 117, 0 },
  { 117, 3 },
  { 117, 3 },
  { 117, 1 },
  { 118, 3 },
  { 118, 1 },
  { 105, 5 },
  { 120, 5 },
  { 120, 3 },
  { 105, 4 },
  { 105, 1 },
  { 123, 8 },
  { 125, 0 },
  { 125, 2 },
  { 131, 2 },
  { 131, 0 },
  { 130, 3 },
  { 126, 0 },
  { 126, 2 },
  { 133, 5 },
  { 134, 1 },
  { 134, 2 },
  { 134, 2 },
  { 121, 0 },
  { 121, 2 },
  { 127, 0 },
  { 127, 3 },
  { 128, 0 },
  { 128, 3 },
  { 136, 4 },
  { 136, 2 },
  { 137, 0 },
  { 137, 1 },
  { 137, 1 },
  { 129, 0 },
  { 129, 2 },
  { 129, 4 },
  { 129, 4 },
  { 105, 4 },
  { 105, 2 },
  { 105, 4 },
  { 122, 4 },
  { 122, 4 },
  { 122, 4 },
  { 122, 4 },
  { 122, 4 },
  { 122, 4 },
  { 122, 4 },
  { 122, 4 },
  { 122, 6 },
  { 122, 4 },
  { 122, 4 },
  { 122, 4 },
  { 122, 4 },
  { 122, 5 },
  { 122, 7 },
  { 122, 4 },
  { 122, 4 },
  { 122, 4 },
  { 122, 4 },
  { 122, 8 },
  { 122, 6 },
  { 122, 6 },
  { 122, 8 },
  { 122, 6 },
  { 122, 4 },
  { 122, 1 },
  { 122, 3 },
  { 122, 1 },
  { 122, 3 },
  { 122, 1 },
  { 122, 3 },
  { 122, 6 },
  { 122, 8 },
  { 138, 2 },
  { 138, 0 },
  { 124, 3 },
  { 124, 2 },
  { 124, 4 },
  { 132, 0 },
  { 132, 2 },
  { 132, 1 },
  { 119, 1 },
  { 119, 1 },
  { 110, 1 },
  { 139, 3 },
  { 122, 3 },
  { 122, 3 },
  { 122, 3 },
  { 122, 3 },
  { 122, 3 },
  { 122, 3 },
  { 122, 3 },
  { 122, 1 },
  { 122, 1 },
  { 122, 1 },
  { 122, 3 },
  { 122, 4 },
  { 122, 3 },
  { 122, 2 },
  { 122, 3 },
  { 122, 4 },
  { 122, 2 },
  { 122, 2 },
  { 122, 5 },
  { 135, 0 },
  { 135, 2 },
  { 135, 2 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  memset(&yygotominor, 0, sizeof(yygotominor));


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0:
      case 1:
      case 2:
      case 3:
      case 7:
      case 13:
#line 49 "parse_tab.lem"
{
}
#line 1661 "parse_tab.c"
        break;
      case 4:
      case 5:
#line 53 "parse_tab.lem"
{
  yy_destructor(1,&yymsp[0].minor);
}
#line 1669 "parse_tab.c"
        break;
      case 6:
#line 55 "parse_tab.lem"
{ csv_begin_parse( parse ); }
#line 1674 "parse_tab.c"
        break;
      case 8:
#line 61 "parse_tab.lem"
{
	csv_start_table( parse, yymsp[0].minor.yy102, yymsp[-1].minor.yy172 );
  yy_destructor(2,&yymsp[-3].minor);
  yy_destructor(3,&yymsp[-2].minor);
}
#line 1683 "parse_tab.c"
        break;
      case 9:
      case 26:
#line 66 "parse_tab.lem"
{ yygotominor.yy172 = 0; }
#line 1689 "parse_tab.c"
        break;
      case 10:
#line 67 "parse_tab.lem"
{ yygotominor.yy172 = 1;   yy_destructor(4,&yymsp[-2].minor);
  yy_destructor(5,&yymsp[-1].minor);
  yy_destructor(6,&yymsp[0].minor);
}
#line 1697 "parse_tab.c"
        break;
      case 11:
#line 69 "parse_tab.lem"
{
  yy_destructor(7,&yymsp[-2].minor);
  yy_destructor(8,&yymsp[0].minor);
}
#line 1705 "parse_tab.c"
        break;
      case 12:
#line 71 "parse_tab.lem"
{
  yy_destructor(9,&yymsp[-1].minor);
}
#line 1712 "parse_tab.c"
        break;
      case 14:
#line 74 "parse_tab.lem"
{
	csv_table_add_column( parse, yymsp[-2].minor.yy102, yymsp[-1].minor.yy66.name, yymsp[-1].minor.yy66.name_len, yymsp[-1].minor.yy66.size, yymsp[0].minor.yy214 );
}
#line 1719 "parse_tab.c"
        break;
      case 15:
#line 79 "parse_tab.lem"
{
	yygotominor.yy66.name = yymsp[0].minor.yy0.str;
	yygotominor.yy66.name_len = yymsp[0].minor.yy0.len;
	yygotominor.yy66.size = 0;
}
#line 1728 "parse_tab.c"
        break;
      case 16:
#line 84 "parse_tab.lem"
{
	yygotominor.yy66.name = yymsp[-3].minor.yy0.str;
	yygotominor.yy66.name_len = yymsp[-3].minor.yy0.len;
	yygotominor.yy66.size = (size_t) atoi( yymsp[-1].minor.yy0.str );
  yy_destructor(7,&yymsp[-2].minor);
  yy_destructor(8,&yymsp[0].minor);
}
#line 1739 "parse_tab.c"
        break;
      case 17:
#line 92 "parse_tab.lem"
{ yygotominor.yy214 = 0; }
#line 1744 "parse_tab.c"
        break;
      case 18:
#line 93 "parse_tab.lem"
{ yygotominor.yy214 = csv_exprlist_add( yymsp[-1].minor.yy214, yymsp[0].minor.yy102, 0 ); }
#line 1749 "parse_tab.c"
        break;
      case 19:
#line 97 "parse_tab.lem"
{
	yygotominor.yy102 = csv_expr( yymsp[0].major, 0, 0, 0, &yymsp[0].minor.yy0 );
	yygotominor.yy102->var.iv = yymsp[-1].major;
}
#line 1757 "parse_tab.c"
        break;
      case 20:
#line 101 "parse_tab.lem"
{
	yygotominor.yy102 = csv_expr( yymsp[0].major, 0, 0, 0, &yymsp[0].minor.yy0 );
	yygotominor.yy102->var.iv = yymsp[-2].major;
  yy_destructor(16,&yymsp[-1].minor);
}
#line 1766 "parse_tab.c"
        break;
      case 21:
#line 105 "parse_tab.lem"
{
	yygotominor.yy102 = csv_expr( yymsp[0].major, 0, 0, 0, &yymsp[0].minor.yy0 );
	yygotominor.yy102 = csv_expr( TK_MINUS, yygotominor.yy102, 0, 0, 0 );
	yygotominor.yy102->var.iv = yymsp[-2].major;
  yy_destructor(17,&yymsp[-1].minor);
}
#line 1776 "parse_tab.c"
        break;
      case 22:
#line 110 "parse_tab.lem"
{
	yygotominor.yy102 = csv_expr( TK_ISNULL, 0, 0, 0, 0 );
	yygotominor.yy102->var.iv = TK_ISNULL;
  yy_destructor(18,&yymsp[0].minor);
}
#line 1785 "parse_tab.c"
        break;
      case 23:
#line 114 "parse_tab.lem"
{
	yygotominor.yy102 = csv_expr( TK_NOTNULL, 0, 0, 0, 0 );
	yygotominor.yy102->var.iv = TK_NOTNULL;
  yy_destructor(5,&yymsp[-1].minor);
  yy_destructor(18,&yymsp[0].minor);
}
#line 1795 "parse_tab.c"
        break;
      case 24:
#line 121 "parse_tab.lem"
{
	csv_start_drop_table( parse, yymsp[0].minor.yy102, yymsp[-1].minor.yy172 );
  yy_destructor(19,&yymsp[-3].minor);
  yy_destructor(3,&yymsp[-2].minor);
}
#line 1804 "parse_tab.c"
        break;
      case 25:
#line 126 "parse_tab.lem"
{ yygotominor.yy172 = 1;   yy_destructor(4,&yymsp[-1].minor);
  yy_destructor(6,&yymsp[0].minor);
}
#line 1811 "parse_tab.c"
        break;
      case 27:
#line 131 "parse_tab.lem"
{
	csv_start_insert( parse, yymsp[-5].minor.yy102, yymsp[-4].minor.yy42, yymsp[-1].minor.yy214 );
  yy_destructor(20,&yymsp[-7].minor);
  yy_destructor(21,&yymsp[-6].minor);
  yy_destructor(22,&yymsp[-3].minor);
  yy_destructor(7,&yymsp[-2].minor);
  yy_destructor(8,&yymsp[0].minor);
}
#line 1823 "parse_tab.c"
        break;
      case 28:
      case 40:
      case 43:
      case 45:
      case 53:
      case 55:
      case 103:
      case 133:
#line 137 "parse_tab.lem"
{ yygotominor.yy42 = 0; }
#line 1835 "parse_tab.c"
        break;
      case 29:
#line 138 "parse_tab.lem"
{ yygotominor.yy42 = yymsp[-1].minor.yy42;   yy_destructor(7,&yymsp[-2].minor);
  yy_destructor(8,&yymsp[0].minor);
}
#line 1842 "parse_tab.c"
        break;
      case 30:
#line 140 "parse_tab.lem"
{ yygotominor.yy42 = csv_exprlist_add( yymsp[-2].minor.yy42, yymsp[0].minor.yy102, 0 );   yy_destructor(9,&yymsp[-1].minor);
}
#line 1848 "parse_tab.c"
        break;
      case 31:
#line 141 "parse_tab.lem"
{ yygotominor.yy42 = csv_exprlist_add( 0, yymsp[0].minor.yy102, 0 ); }
#line 1853 "parse_tab.c"
        break;
      case 32:
#line 145 "parse_tab.lem"
{ yygotominor.yy214 = csv_exprlist_add( yymsp[-2].minor.yy214, yymsp[0].minor.yy102, 0 );   yy_destructor(9,&yymsp[-1].minor);
}
#line 1859 "parse_tab.c"
        break;
      case 33:
#line 146 "parse_tab.lem"
{ yygotominor.yy214 = csv_exprlist_add( 0, yymsp[0].minor.yy102, 0 ); }
#line 1864 "parse_tab.c"
        break;
      case 34:
#line 150 "parse_tab.lem"
{
	csv_start_update( parse, yymsp[-3].minor.yy102, yymsp[-1].minor.yy214, yymsp[0].minor.yy202 );
  yy_destructor(23,&yymsp[-4].minor);
  yy_destructor(24,&yymsp[-2].minor);
}
#line 1873 "parse_tab.c"
        break;
      case 35:
#line 157 "parse_tab.lem"
{
	yymsp[-2].minor.yy102->left = yymsp[0].minor.yy202;
	yygotominor.yy214 = csv_exprlist_add( yymsp[-4].minor.yy214, yymsp[-2].minor.yy102, 0 );
  yy_destructor(9,&yymsp[-3].minor);
  yy_destructor(25,&yymsp[-1].minor);
}
#line 1883 "parse_tab.c"
        break;
      case 36:
#line 161 "parse_tab.lem"
{
	yymsp[-2].minor.yy102->left = yymsp[0].minor.yy202;
	yygotominor.yy214 = csv_exprlist_add( 0, yymsp[-2].minor.yy102, 0 );
  yy_destructor(25,&yymsp[-1].minor);
}
#line 1892 "parse_tab.c"
        break;
      case 37:
#line 168 "parse_tab.lem"
{
	csv_start_delete( parse, yymsp[-1].minor.yy102, yymsp[0].minor.yy202 );
  yy_destructor(26,&yymsp[-3].minor);
  yy_destructor(27,&yymsp[-2].minor);
}
#line 1901 "parse_tab.c"
        break;
      case 38:
#line 174 "parse_tab.lem"
{ csv_select_start( parse, yymsp[0].minor.yy81 ); }
#line 1906 "parse_tab.c"
        break;
      case 39:
#line 181 "parse_tab.lem"
{
	yygotominor.yy81 = csv_select_new( parse, yymsp[-6].minor.yy42, yymsp[-5].minor.yy42, yymsp[-4].minor.yy42, yymsp[-3].minor.yy202, yymsp[-2].minor.yy42, yymsp[-1].minor.yy42, yymsp[0].minor.yy170.limit, yymsp[0].minor.yy170.offset );
  yy_destructor(28,&yymsp[-7].minor);
}
#line 1914 "parse_tab.c"
        break;
      case 41:
#line 190 "parse_tab.lem"
{ yygotominor.yy42 = yymsp[0].minor.yy42;   yy_destructor(27,&yymsp[-1].minor);
}
#line 1920 "parse_tab.c"
        break;
      case 42:
      case 102:
      case 135:
#line 196 "parse_tab.lem"
{ yygotominor.yy42 = yymsp[-1].minor.yy42;   yy_destructor(9,&yymsp[0].minor);
}
#line 1928 "parse_tab.c"
        break;
      case 44:
#line 198 "parse_tab.lem"
{
	yygotominor.yy42 = csv_exprlist_add( yymsp[-2].minor.yy42, yymsp[-1].minor.yy102, yymsp[0].minor.yy98.len ? &yymsp[0].minor.yy98 : 0 );
}
#line 1935 "parse_tab.c"
        break;
      case 46:
#line 207 "parse_tab.lem"
{
	yygotominor.yy42 = csv_exprlist_add(
		yymsp[-1].minor.yy42, csv_expr( yymsp[0].minor.yy95.op, yymsp[0].minor.yy95.table, yymsp[0].minor.yy95.condition, 0, 0 ), yymsp[0].minor.yy95.alias );
}
#line 1943 "parse_tab.c"
        break;
      case 47:
#line 211 "parse_tab.lem"
{
	yygotominor.yy95.op = yymsp[-4].minor.yy172;
	yygotominor.yy95.table = yymsp[-3].minor.yy102;
	yygotominor.yy95.alias = yymsp[-2].minor.yy98.len ? &yymsp[-2].minor.yy98 : 0;
	yygotominor.yy95.condition = yymsp[0].minor.yy202;
  yy_destructor(29,&yymsp[-1].minor);
}
#line 1954 "parse_tab.c"
        break;
      case 48:
      case 49:
#line 218 "parse_tab.lem"
{ yygotominor.yy172 = TK_INNER;   yy_destructor(30,&yymsp[0].minor);
}
#line 1961 "parse_tab.c"
        break;
      case 50:
#line 220 "parse_tab.lem"
{ yygotominor.yy172 = TK_LEFT;   yy_destructor(33,&yymsp[-1].minor);
  yy_destructor(30,&yymsp[0].minor);
}
#line 1968 "parse_tab.c"
        break;
      case 51:
#line 225 "parse_tab.lem"
{ yygotominor.yy202 = 0; }
#line 1973 "parse_tab.c"
        break;
      case 52:
#line 226 "parse_tab.lem"
{ yygotominor.yy202 = yymsp[0].minor.yy202;   yy_destructor(34,&yymsp[-1].minor);
}
#line 1979 "parse_tab.c"
        break;
      case 54:
#line 232 "parse_tab.lem"
{ yygotominor.yy42 = yymsp[0].minor.yy42;   yy_destructor(35,&yymsp[-2].minor);
  yy_destructor(36,&yymsp[-1].minor);
}
#line 1986 "parse_tab.c"
        break;
      case 56:
#line 241 "parse_tab.lem"
{ yygotominor.yy42 = yymsp[0].minor.yy42;   yy_destructor(37,&yymsp[-2].minor);
  yy_destructor(36,&yymsp[-1].minor);
}
#line 1993 "parse_tab.c"
        break;
      case 57:
#line 242 "parse_tab.lem"
{
	yymsp[-1].minor.yy102->flags |= yymsp[0].minor.yy172;
	yygotominor.yy42 = csv_exprlist_add( yymsp[-3].minor.yy42, yymsp[-1].minor.yy102, 0 );
  yy_destructor(9,&yymsp[-2].minor);
}
#line 2002 "parse_tab.c"
        break;
      case 58:
#line 246 "parse_tab.lem"
{
	yymsp[-1].minor.yy102->flags |= yymsp[0].minor.yy172;
	yygotominor.yy42 = csv_exprlist_add( 0, yymsp[-1].minor.yy102, 0 );
}
#line 2010 "parse_tab.c"
        break;
      case 59:
#line 252 "parse_tab.lem"
{ yygotominor.yy172 = EXPR_SORT_ASC; }
#line 2015 "parse_tab.c"
        break;
      case 60:
#line 253 "parse_tab.lem"
{ yygotominor.yy172 = EXPR_SORT_ASC;   yy_destructor(38,&yymsp[0].minor);
}
#line 2021 "parse_tab.c"
        break;
      case 61:
#line 254 "parse_tab.lem"
{ yygotominor.yy172 = 0;   yy_destructor(39,&yymsp[0].minor);
}
#line 2027 "parse_tab.c"
        break;
      case 62:
#line 259 "parse_tab.lem"
{ yygotominor.yy170.limit = 0; yygotominor.yy170.offset = 0; }
#line 2032 "parse_tab.c"
        break;
      case 63:
#line 260 "parse_tab.lem"
{ yygotominor.yy170.limit = atoi( yymsp[0].minor.yy0.str ); yygotominor.yy170.offset = 0;   yy_destructor(40,&yymsp[-1].minor);
}
#line 2038 "parse_tab.c"
        break;
      case 64:
#line 261 "parse_tab.lem"
{
	yygotominor.yy170.limit = atoi( yymsp[-2].minor.yy0.str ); yygotominor.yy170.offset = atoi( yymsp[0].minor.yy0.str );
  yy_destructor(40,&yymsp[-3].minor);
  yy_destructor(41,&yymsp[-1].minor);
}
#line 2047 "parse_tab.c"
        break;
      case 65:
#line 264 "parse_tab.lem"
{
	yygotominor.yy170.offset = atoi( yymsp[-2].minor.yy0.str ); yygotominor.yy170.limit = atoi( yymsp[0].minor.yy0.str );
  yy_destructor(40,&yymsp[-3].minor);
  yy_destructor(9,&yymsp[-1].minor);
}
#line 2056 "parse_tab.c"
        break;
      case 66:
#line 270 "parse_tab.lem"
{
	csv_set_start( parse,
		csv_expr( yymsp[-2].major, 0, 0, 0, &yymsp[-2].minor.yy0 ), csv_expr( yymsp[0].major, 0, 0, 0, &yymsp[0].minor.yy0 ) );
  yy_destructor(24,&yymsp[-3].minor);
  yy_destructor(25,&yymsp[-1].minor);
}
#line 2066 "parse_tab.c"
        break;
      case 67:
#line 277 "parse_tab.lem"
{
	csv_start_show_variables( parse, NULL );
  yy_destructor(43,&yymsp[-1].minor);
  yy_destructor(44,&yymsp[0].minor);
}
#line 2075 "parse_tab.c"
        break;
      case 68:
#line 281 "parse_tab.lem"
{
	csv_start_show_variables( parse, csv_expr( yymsp[0].major, 0, 0, 0, &yymsp[0].minor.yy0 ) );
  yy_destructor(43,&yymsp[-3].minor);
  yy_destructor(44,&yymsp[-2].minor);
  yy_destructor(45,&yymsp[-1].minor);
}
#line 2085 "parse_tab.c"
        break;
      case 69:
      case 70:
      case 71:
      case 72:
      case 74:
      case 75:
      case 76:
      case 79:
      case 80:
      case 84:
      case 85:
      case 86:
      case 87:
      case 93:
#line 287 "parse_tab.lem"
{ yygotominor.yy202 = csv_expr( yymsp[-3].major, yymsp[-1].minor.yy202, 0, 0, &yymsp[-3].minor.yy0 ); expr_token_len( yygotominor.yy202, &yymsp[0].minor.yy0 );   yy_destructor(7,&yymsp[-2].minor);
}
#line 2104 "parse_tab.c"
        break;
      case 73:
#line 295 "parse_tab.lem"
{ yygotominor.yy202 = csv_expr( yymsp[-3].major, 0, 0, 0, &yymsp[-3].minor.yy0 ); expr_token_len( yygotominor.yy202, &yymsp[0].minor.yy0 );   yy_destructor(7,&yymsp[-2].minor);
  yy_destructor(50,&yymsp[-1].minor);
}
#line 2111 "parse_tab.c"
        break;
      case 77:
      case 90:
#line 305 "parse_tab.lem"
{ yygotominor.yy202 = csv_expr( yymsp[-5].major, yymsp[-3].minor.yy202, yymsp[-1].minor.yy202, 0, &yymsp[-5].minor.yy0 ); expr_token_len( yygotominor.yy202, &yymsp[0].minor.yy0 );   yy_destructor(7,&yymsp[-4].minor);
  yy_destructor(9,&yymsp[-2].minor);
}
#line 2119 "parse_tab.c"
        break;
      case 78:
#line 309 "parse_tab.lem"
{ yygotominor.yy202 = csv_expr( yymsp[-3].major, 0, 0, yymsp[-1].minor.yy42, &yymsp[-3].minor.yy0 ); expr_token_len( yygotominor.yy202, &yymsp[0].minor.yy0 );   yy_destructor(7,&yymsp[-2].minor);
}
#line 2125 "parse_tab.c"
        break;
      case 81:
#line 314 "parse_tab.lem"
{
	yygotominor.yy202 = csv_expr( yymsp[-3].major, yymsp[-1].minor.yy202, csv_expr( TK_BOTH, 0, 0, 0, 0 ), 0, &yymsp[-3].minor.yy0 );
	expr_token_len( yygotominor.yy202, &yymsp[0].minor.yy0 );
  yy_destructor(7,&yymsp[-2].minor);
}
#line 2134 "parse_tab.c"
        break;
      case 82:
#line 318 "parse_tab.lem"
{
	yygotominor.yy202 = csv_expr( yymsp[-4].major, yymsp[-1].minor.yy202, csv_expr( yymsp[-2].major, 0, 0, 0, &yymsp[-2].minor.yy0 ), 0, &yymsp[-4].minor.yy0 );
	expr_token_len( yygotominor.yy202, &yymsp[0].minor.yy0 );
  yy_destructor(7,&yymsp[-3].minor);
}
#line 2143 "parse_tab.c"
        break;
      case 83:
#line 322 "parse_tab.lem"
{
	yygotominor.yy202 = csv_expr( yymsp[-6].major, yymsp[-1].minor.yy202, csv_expr( yymsp[-4].major, yymsp[-3].minor.yy202, 0, 0, &yymsp[-4].minor.yy0 ), 0, &yymsp[-6].minor.yy0 );
	expr_token_len( yygotominor.yy202, &yymsp[0].minor.yy0 );
  yy_destructor(7,&yymsp[-5].minor);
  yy_destructor(27,&yymsp[-2].minor);
}
#line 2153 "parse_tab.c"
        break;
      case 88:
#line 334 "parse_tab.lem"
{
	ExprList *l = csv_exprlist_add( 0, yymsp[-3].minor.yy202, 0 );
	l = csv_exprlist_add( l, yymsp[-1].minor.yy202, 0 );
	yygotominor.yy202 = csv_expr( yymsp[-7].major, yymsp[-5].minor.yy202, 0, l, &yymsp[-7].minor.yy0 );
	expr_token_len( yygotominor.yy202, &yymsp[0].minor.yy0 );
  yy_destructor(7,&yymsp[-6].minor);
}
#line 2164 "parse_tab.c"
        break;
      case 89:
#line 340 "parse_tab.lem"
{
	yygotominor.yy202 = csv_expr( yymsp[-5].major, yymsp[-3].minor.yy202, 0, csv_exprlist_add( 0, yymsp[-1].minor.yy202, 0 ), &yymsp[-5].minor.yy0 );
	expr_token_len( yygotominor.yy202, &yymsp[0].minor.yy0 );
  yy_destructor(7,&yymsp[-4].minor);
}
#line 2173 "parse_tab.c"
        break;
      case 91:
#line 346 "parse_tab.lem"
{
	yygotominor.yy202 = csv_expr( yymsp[-7].major, yymsp[-5].minor.yy202, yymsp[-3].minor.yy202, csv_exprlist_add( 0, yymsp[-1].minor.yy202, 0 ), &yymsp[-7].minor.yy0 );
	expr_token_len( yygotominor.yy202, &yymsp[0].minor.yy0 );
  yy_destructor(7,&yymsp[-6].minor);
  yy_destructor(9,&yymsp[-4].minor);
  yy_destructor(9,&yymsp[-2].minor);
}
#line 2184 "parse_tab.c"
        break;
      case 92:
#line 351 "parse_tab.lem"
{ yygotominor.yy202 = csv_expr( TK_LOCATE, yymsp[-3].minor.yy202, yymsp[-1].minor.yy202, 0, &yymsp[-5].minor.yy0 ); expr_token_len( yygotominor.yy202, &yymsp[0].minor.yy0 );   yy_destructor(7,&yymsp[-4].minor);
  yy_destructor(69,&yymsp[-2].minor);
}
#line 2191 "parse_tab.c"
        break;
      case 94:
      case 96:
      case 98:
#line 356 "parse_tab.lem"
{ yygotominor.yy202 = csv_expr( yymsp[0].major, 0, 0, 0, &yymsp[0].minor.yy0 ); }
#line 2198 "parse_tab.c"
        break;
      case 95:
      case 97:
      case 99:
#line 358 "parse_tab.lem"
{ yygotominor.yy202 = csv_expr( yymsp[-2].major, 0, 0, 0, &yymsp[-2].minor.yy0 ); expr_token_len( yygotominor.yy202, &yymsp[0].minor.yy0 );   yy_destructor(7,&yymsp[-1].minor);
}
#line 2206 "parse_tab.c"
        break;
      case 100:
#line 367 "parse_tab.lem"
{
	Token __t;
	Expr *__x;
	__t.str = yymsp[-1].minor.yy66.name, __t.len = yymsp[-1].minor.yy66.name_len;
	Newxz( __x, 1, Expr );
	__x->var.iv = (long) yymsp[-1].minor.yy66.size;
	__x->var.flags = VAR_HAS_IV;
	__x->op = yymsp[-2].major;
	yygotominor.yy202 = csv_expr( yymsp[-5].major, yymsp[-3].minor.yy202, csv_expr( TK_PLAIN, __x, 0, 0, &__t ), 0, &yymsp[-5].minor.yy0 );
	expr_token_len( yygotominor.yy202, &yymsp[0].minor.yy0 );
  yy_destructor(7,&yymsp[-4].minor);
}
#line 2222 "parse_tab.c"
        break;
      case 101:
#line 380 "parse_tab.lem"
{
	ExprList *l = csv_exprlist_add( 0, yymsp[-3].minor.yy202, 0 );
	l = csv_exprlist_add( l, yymsp[-1].minor.yy202, 0 );
	yygotominor.yy202 = csv_expr( yymsp[-7].major, yymsp[-5].minor.yy202, 0, l, 0 );
  yy_destructor(7,&yymsp[-6].minor);
  yy_destructor(9,&yymsp[-4].minor);
  yy_destructor(9,&yymsp[-2].minor);
  yy_destructor(8,&yymsp[0].minor);
}
#line 2235 "parse_tab.c"
        break;
      case 104:
#line 394 "parse_tab.lem"
{
	yygotominor.yy42 = csv_exprlist_add( yymsp[-2].minor.yy42, yymsp[-1].minor.yy202, yymsp[0].minor.yy98.len ? &yymsp[0].minor.yy98 : 0 );
}
#line 2242 "parse_tab.c"
        break;
      case 105:
#line 397 "parse_tab.lem"
{
	yygotominor.yy42 = csv_exprlist_add( yymsp[-1].minor.yy42, csv_expr( TK_ALL, 0, 0, 0, 0 ), 0 );
  yy_destructor(50,&yymsp[0].minor);
}
#line 2250 "parse_tab.c"
        break;
      case 106:
#line 400 "parse_tab.lem"
{
	yygotominor.yy42 = csv_exprlist_add( yymsp[-3].minor.yy42,
		csv_expr( TK_DOT, yymsp[-2].minor.yy102, csv_expr( TK_ALL, 0, 0, 0, 0 ), 0, &yymsp[-1].minor.yy0 ), 0 );
  yy_destructor(50,&yymsp[0].minor);
}
#line 2259 "parse_tab.c"
        break;
      case 107:
#line 408 "parse_tab.lem"
{ yygotominor.yy98.len = 0; }
#line 2264 "parse_tab.c"
        break;
      case 108:
#line 409 "parse_tab.lem"
{ yygotominor.yy98 = yymsp[0].minor.yy0;   yy_destructor(77,&yymsp[-1].minor);
}
#line 2270 "parse_tab.c"
        break;
      case 109:
#line 410 "parse_tab.lem"
{ yygotominor.yy98 = yymsp[0].minor.yy0; }
#line 2275 "parse_tab.c"
        break;
      case 110:
      case 111:
      case 112:
#line 416 "parse_tab.lem"
{ yygotominor.yy102 = csv_expr( yymsp[0].major, 0, 0, 0, &yymsp[0].minor.yy0 ); }
#line 2282 "parse_tab.c"
        break;
      case 113:
#line 429 "parse_tab.lem"
{ yygotominor.yy102 = csv_expr( TK_DOT, yymsp[-2].minor.yy102, yymsp[0].minor.yy102, 0, &yymsp[-1].minor.yy0 ); }
#line 2287 "parse_tab.c"
        break;
      case 114:
      case 115:
      case 116:
      case 117:
      case 118:
      case 119:
      case 120:
#line 447 "parse_tab.lem"
{ yygotominor.yy202 = csv_expr( yymsp[-1].major, yymsp[-2].minor.yy202, yymsp[0].minor.yy202, 0, &yymsp[-1].minor.yy0 ); }
#line 2298 "parse_tab.c"
        break;
      case 121:
      case 122:
      case 123:
#line 457 "parse_tab.lem"
{ yygotominor.yy202 = yymsp[0].minor.yy102; }
#line 2305 "parse_tab.c"
        break;
      case 124:
#line 460 "parse_tab.lem"
{
	yygotominor.yy202 = csv_expr( TK_LIKE, yymsp[-2].minor.yy202, csv_expr( yymsp[0].major, 0, 0, 0, &yymsp[0].minor.yy0 ), 0, &yymsp[-1].minor.yy0 );
}
#line 2312 "parse_tab.c"
        break;
      case 125:
#line 463 "parse_tab.lem"
{
	yygotominor.yy202 = csv_expr( TK_NOTLIKE, yymsp[-3].minor.yy202, csv_expr( yymsp[0].major, 0, 0, 0, &yymsp[0].minor.yy0 ), 0, &yymsp[-2].minor.yy0 );
	expr_token_len( yygotominor.yy202, &yymsp[-1].minor.yy0 );
}
#line 2320 "parse_tab.c"
        break;
      case 126:
#line 467 "parse_tab.lem"
{
	yygotominor.yy202 = yymsp[-1].minor.yy202;
	expr_token_len( yygotominor.yy202, &yymsp[-2].minor.yy0 );
	expr_token_len( yygotominor.yy202, &yymsp[0].minor.yy0 );
}
#line 2329 "parse_tab.c"
        break;
      case 127:
#line 472 "parse_tab.lem"
{ yygotominor.yy202 = csv_expr( yymsp[-1].major, yymsp[0].minor.yy202, 0, 0, 0 ); }
#line 2334 "parse_tab.c"
        break;
      case 128:
#line 473 "parse_tab.lem"
{ yygotominor.yy202 = csv_expr( TK_ISNULL, yymsp[-2].minor.yy202, 0, 0, 0 );   yy_destructor(81,&yymsp[-1].minor);
  yy_destructor(18,&yymsp[0].minor);
}
#line 2341 "parse_tab.c"
        break;
      case 129:
#line 474 "parse_tab.lem"
{ yygotominor.yy202 = csv_expr( TK_NOTNULL, yymsp[-3].minor.yy202, 0, 0, 0 );   yy_destructor(81,&yymsp[-2].minor);
  yy_destructor(5,&yymsp[-1].minor);
  yy_destructor(18,&yymsp[0].minor);
}
#line 2349 "parse_tab.c"
        break;
      case 130:
#line 475 "parse_tab.lem"
{ yygotominor.yy202 = csv_expr( TK_MINUS, yymsp[0].minor.yy202, 0, 0, &yymsp[-1].minor.yy0 ); }
#line 2354 "parse_tab.c"
        break;
      case 131:
#line 476 "parse_tab.lem"
{ yygotominor.yy202 = csv_expr( TK_PLUS, yymsp[0].minor.yy202, 0, 0, &yymsp[-1].minor.yy0 ); }
#line 2359 "parse_tab.c"
        break;
      case 132:
#line 477 "parse_tab.lem"
{
	ExprList *l = csv_exprlist_add( 0, yymsp[-2].minor.yy202, 0 );
	l = csv_exprlist_add( l, yymsp[0].minor.yy202, 0 );
	yygotominor.yy202 = csv_expr( TK_BETWEEN, yymsp[-4].minor.yy202, 0, l, 0 );
  yy_destructor(85,&yymsp[-3].minor);
  yy_destructor(79,&yymsp[-1].minor);
}
#line 2370 "parse_tab.c"
        break;
      case 134:
#line 488 "parse_tab.lem"
{ yygotominor.yy42 = csv_exprlist_add( yymsp[-1].minor.yy42, yymsp[0].minor.yy202, 0 ); }
#line 2375 "parse_tab.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  ParseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  ParseARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 41 "parse_tab.lem"

	if( ! parse->csv->last_errno )
		csv_error_msg(
			parse, CSV_ERR_SYNTAX, "Syntax error near '%s'", TOKEN.str );
#line 2438 "parse_tab.c"
  ParseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  ParseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      memset(&yyminorunion, 0, sizeof(yyminorunion));
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  ParseARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
