# *** DO NOT EDIT *** generated file *** DO NOT EDIT ***
#
# generated by lib/Net/IDN/UTS46/GenTests.PL from data/IdnaTest.txt
# see repository at http://github.com/cfaerber/Net-IDN-Encode for source files
#
use strict;
use utf8;
use warnings;

BEGIN {
  binmode STDOUT, ':utf8';
  binmode STDERR, ':utf8';
}

use Test::More tests => 5025 + 1;
use Test::NoWarnings;

use Unicode::UCD;
use Net::IDN::UTS46 (':all');

no warnings 'utf8';

our $UCD_VERSION = eval('v'.(Unicode::UCD::UnicodeVersion()));

my %p = ("TransitionalProcessing" => "0");

is(eval{uts46_to_unicode("fass.de", %p)},	"fass.de",	"to_unicode\(\'fass\.de\'\)\ \[data\/IdnaTest\.txt\:61\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("faß.de", %p)},	"faß.de",	"to_unicode\(\'faß\.de\'\)\ \[data\/IdnaTest\.txt\:62\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("faß.de", %p)},	"faß.de",	"to_unicode\(\'faß\.de\'\)\ \[data\/IdnaTest\.txt\:63\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Faß.de", %p)},	"faß.de",	"to_unicode\(\'Faß\.de\'\)\ \[data\/IdnaTest\.txt\:64\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Faß.de", %p)},	"faß.de",	"to_unicode\(\'Faß\.de\'\)\ \[data\/IdnaTest\.txt\:65\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--fa-hia.de", %p)},	"faß.de",	"to_unicode\(\'xn\-\-fa\-hia\.de\'\)\ \[data\/IdnaTest\.txt\:66\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("à\x{05D0}", %p)},	undef,	"to_unicode\(\'à\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:70\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0300}\x{05D0}", %p)},	undef,	"to_unicode\(\'a\\u0300\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:71\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0300}\x{05D0}", %p)},	undef,	"to_unicode\(\'A\\u0300\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:72\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("À\x{05D0}", %p)},	undef,	"to_unicode\(\'À\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:73\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0à.\x{05D0}", %p)},	"0à.\x{05D0}",	"to_unicode\(\'0à\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:74\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0a\x{0300}.\x{05D0}", %p)},	"0à.\x{05D0}",	"to_unicode\(\'0a\\u0300\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:75\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0A\x{0300}.\x{05D0}", %p)},	"0à.\x{05D0}",	"to_unicode\(\'0A\\u0300\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:76\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0À.\x{05D0}", %p)},	"0à.\x{05D0}",	"to_unicode\(\'0À\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:77\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--0-sfa.xn--4db", %p)},	"0à.\x{05D0}",	"to_unicode\(\'xn\-\-0\-sfa\.xn\-\-4db\'\)\ \[data\/IdnaTest\.txt\:78\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("à.\x{05D0}\x{0308}", %p)},	"à.\x{05D0}\x{0308}",	"to_unicode\(\'à\.\\u05D0\\u0308\'\)\ \[data\/IdnaTest\.txt\:79\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0300}.\x{05D0}\x{0308}", %p)},	"à.\x{05D0}\x{0308}",	"to_unicode\(\'a\\u0300\.\\u05D0\\u0308\'\)\ \[data\/IdnaTest\.txt\:80\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0300}.\x{05D0}\x{0308}", %p)},	"à.\x{05D0}\x{0308}",	"to_unicode\(\'A\\u0300\.\\u05D0\\u0308\'\)\ \[data\/IdnaTest\.txt\:81\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("À.\x{05D0}\x{0308}", %p)},	"à.\x{05D0}\x{0308}",	"to_unicode\(\'À\.\\u05D0\\u0308\'\)\ \[data\/IdnaTest\.txt\:82\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--0ca.xn--ssa73l", %p)},	"à.\x{05D0}\x{0308}",	"to_unicode\(\'xn\-\-0ca\.xn\-\-ssa73l\'\)\ \[data\/IdnaTest\.txt\:83\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("à.\x{05D0}0\x{0660}\x{05D0}", %p)},	undef,	"to_unicode\(\'à\.\\u05D00\\u0660\\u05D0\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:84\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0300}.\x{05D0}0\x{0660}\x{05D0}", %p)},	undef,	"to_unicode\(\'a\\u0300\.\\u05D00\\u0660\\u05D0\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:85\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0300}.\x{05D0}0\x{0660}\x{05D0}", %p)},	undef,	"to_unicode\(\'A\\u0300\.\\u05D00\\u0660\\u05D0\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:86\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("À.\x{05D0}0\x{0660}\x{05D0}", %p)},	undef,	"to_unicode\(\'À\.\\u05D00\\u0660\\u05D0\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:87\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}.\x{05D0}", %p)},	undef,	"to_unicode\(\'\\u0308\.\\u05D0\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:88\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("à.\x{05D0}0\x{0660}", %p)},	undef,	"to_unicode\(\'à\.\\u05D00\\u0660\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:89\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0300}.\x{05D0}0\x{0660}", %p)},	undef,	"to_unicode\(\'a\\u0300\.\\u05D00\\u0660\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:90\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0300}.\x{05D0}0\x{0660}", %p)},	undef,	"to_unicode\(\'A\\u0300\.\\u05D00\\u0660\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:91\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("À.\x{05D0}0\x{0660}", %p)},	undef,	"to_unicode\(\'À\.\\u05D00\\u0660\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:92\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("àˇ.\x{05D0}", %p)},	"àˇ.\x{05D0}",	"to_unicode\(\'àˇ\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:93\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0300}ˇ.\x{05D0}", %p)},	"àˇ.\x{05D0}",	"to_unicode\(\'a\\u0300ˇ\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:94\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0300}ˇ.\x{05D0}", %p)},	"àˇ.\x{05D0}",	"to_unicode\(\'A\\u0300ˇ\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:95\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Àˇ.\x{05D0}", %p)},	"àˇ.\x{05D0}",	"to_unicode\(\'Àˇ\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:96\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--0ca88g.xn--4db", %p)},	"àˇ.\x{05D0}",	"to_unicode\(\'xn\-\-0ca88g\.xn\-\-4db\'\)\ \[data\/IdnaTest\.txt\:97\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("à\x{0308}.\x{05D0}", %p)},	"à\x{0308}.\x{05D0}",	"to_unicode\(\'à\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:98\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0300}\x{0308}.\x{05D0}", %p)},	"à\x{0308}.\x{05D0}",	"to_unicode\(\'a\\u0300\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:99\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0300}\x{0308}.\x{05D0}", %p)},	"à\x{0308}.\x{05D0}",	"to_unicode\(\'A\\u0300\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:100\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("À\x{0308}.\x{05D0}", %p)},	"à\x{0308}.\x{05D0}",	"to_unicode\(\'À\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:101\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--0ca81i.xn--4db", %p)},	"à\x{0308}.\x{05D0}",	"to_unicode\(\'xn\-\-0ca81i\.xn\-\-4db\'\)\ \[data\/IdnaTest\.txt\:102\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{200C}b", %p)},	undef,	"to_unicode\(\'a\\u200Cb\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:106\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{200C}b", %p)},	undef,	"to_unicode\(\'a\\u200Cb\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:107\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200C}B", %p)},	undef,	"to_unicode\(\'A\\u200CB\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:108\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200C}B", %p)},	undef,	"to_unicode\(\'A\\u200CB\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:109\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200C}b", %p)},	undef,	"to_unicode\(\'A\\u200Cb\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:110\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200C}b", %p)},	undef,	"to_unicode\(\'A\\u200Cb\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:111\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ab", %p)},	"ab",	"to_unicode\(\'ab\'\)\ \[data\/IdnaTest\.txt\:112\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{094D}\x{200C}b", %p)},	"a\x{094D}\x{200C}b",	"to_unicode\(\'a\\u094D\\u200Cb\'\)\ \[data\/IdnaTest\.txt\:113\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{094D}\x{200C}b", %p)},	"a\x{094D}\x{200C}b",	"to_unicode\(\'a\\u094D\\u200Cb\'\)\ \[data\/IdnaTest\.txt\:114\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200C}B", %p)},	"a\x{094D}\x{200C}b",	"to_unicode\(\'A\\u094D\\u200CB\'\)\ \[data\/IdnaTest\.txt\:115\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200C}B", %p)},	"a\x{094D}\x{200C}b",	"to_unicode\(\'A\\u094D\\u200CB\'\)\ \[data\/IdnaTest\.txt\:116\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200C}b", %p)},	"a\x{094D}\x{200C}b",	"to_unicode\(\'A\\u094D\\u200Cb\'\)\ \[data\/IdnaTest\.txt\:117\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200C}b", %p)},	"a\x{094D}\x{200C}b",	"to_unicode\(\'A\\u094D\\u200Cb\'\)\ \[data\/IdnaTest\.txt\:118\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ab-fsf", %p)},	"a\x{094D}b",	"to_unicode\(\'xn\-\-ab\-fsf\'\)\ \[data\/IdnaTest\.txt\:119\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{094D}b", %p)},	"a\x{094D}b",	"to_unicode\(\'a\\u094Db\'\)\ \[data\/IdnaTest\.txt\:120\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}B", %p)},	"a\x{094D}b",	"to_unicode\(\'A\\u094DB\'\)\ \[data\/IdnaTest\.txt\:121\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}b", %p)},	"a\x{094D}b",	"to_unicode\(\'A\\u094Db\'\)\ \[data\/IdnaTest\.txt\:122\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ab-fsf604u", %p)},	"a\x{094D}\x{200C}b",	"to_unicode\(\'xn\-\-ab\-fsf604u\'\)\ \[data\/IdnaTest\.txt\:123\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200C}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'\\u0308\\u200C\\u0308\\u0628b\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:124\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200C}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'\\u0308\\u200C\\u0308\\u0628b\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:125\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200C}\x{0308}\x{0628}B", %p)},	undef,	"to_unicode\(\'\\u0308\\u200C\\u0308\\u0628B\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:126\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200C}\x{0308}\x{0628}B", %p)},	undef,	"to_unicode\(\'\\u0308\\u200C\\u0308\\u0628B\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:127\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0628}\x{0308}\x{200C}\x{0308}", %p)},	undef,	"to_unicode\(\'a\\u0628\\u0308\\u200C\\u0308\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:128\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0628}\x{0308}\x{200C}\x{0308}", %p)},	undef,	"to_unicode\(\'a\\u0628\\u0308\\u200C\\u0308\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:129\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200C}\x{0308}", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200C\\u0308\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:130\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200C}\x{0308}", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200C\\u0308\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:131\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0628}\x{0308}\x{200C}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'a\\u0628\\u0308\\u200C\\u0308\\u0628b\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:132\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200C}\x{0308}\x{0628}B", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200C\\u0308\\u0628B\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:133\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200C}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200C\\u0308\\u0628b\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:134\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{200D}b", %p)},	undef,	"to_unicode\(\'a\\u200Db\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:135\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{200D}b", %p)},	undef,	"to_unicode\(\'a\\u200Db\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:136\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200D}B", %p)},	undef,	"to_unicode\(\'A\\u200DB\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:137\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200D}B", %p)},	undef,	"to_unicode\(\'A\\u200DB\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:138\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200D}b", %p)},	undef,	"to_unicode\(\'A\\u200Db\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:139\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200D}b", %p)},	undef,	"to_unicode\(\'A\\u200Db\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:140\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{094D}\x{200D}b", %p)},	"a\x{094D}\x{200D}b",	"to_unicode\(\'a\\u094D\\u200Db\'\)\ \[data\/IdnaTest\.txt\:141\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{094D}\x{200D}b", %p)},	"a\x{094D}\x{200D}b",	"to_unicode\(\'a\\u094D\\u200Db\'\)\ \[data\/IdnaTest\.txt\:142\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200D}B", %p)},	"a\x{094D}\x{200D}b",	"to_unicode\(\'A\\u094D\\u200DB\'\)\ \[data\/IdnaTest\.txt\:143\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200D}B", %p)},	"a\x{094D}\x{200D}b",	"to_unicode\(\'A\\u094D\\u200DB\'\)\ \[data\/IdnaTest\.txt\:144\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200D}b", %p)},	"a\x{094D}\x{200D}b",	"to_unicode\(\'A\\u094D\\u200Db\'\)\ \[data\/IdnaTest\.txt\:145\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200D}b", %p)},	"a\x{094D}\x{200D}b",	"to_unicode\(\'A\\u094D\\u200Db\'\)\ \[data\/IdnaTest\.txt\:146\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ab-fsf014u", %p)},	"a\x{094D}\x{200D}b",	"to_unicode\(\'xn\-\-ab\-fsf014u\'\)\ \[data\/IdnaTest\.txt\:147\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:148\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:149\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200D}\x{0308}\x{0628}B", %p)},	undef,	"to_unicode\(\'\\u0308\\u200D\\u0308\\u0628B\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:150\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200D}\x{0308}\x{0628}B", %p)},	undef,	"to_unicode\(\'\\u0308\\u200D\\u0308\\u0628B\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:151\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0628}\x{0308}\x{200D}\x{0308}", %p)},	undef,	"to_unicode\(\'a\\u0628\\u0308\\u200D\\u0308\'\)\ throws\ error\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:152\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0628}\x{0308}\x{200D}\x{0308}", %p)},	undef,	"to_unicode\(\'a\\u0628\\u0308\\u200D\\u0308\'\)\ throws\ error\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:153\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200D}\x{0308}", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200D\\u0308\'\)\ throws\ error\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:154\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200D}\x{0308}", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200D\\u0308\'\)\ throws\ error\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:155\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'a\\u0628\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:156\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'a\\u0628\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:157\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}B", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200D\\u0308\\u0628B\'\)\ throws\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:158\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}B", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200D\\u0308\\u0628B\'\)\ throws\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:159\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:160\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:161\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("¡", %p)},	"¡",	"to_unicode\(\'\¡\'\)\ \[data\/IdnaTest\.txt\:165\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--7a", %p)},	"¡",	"to_unicode\(\'xn\-\-7a\'\)\ \[data\/IdnaTest\.txt\:166\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("᧚", %p)},	"᧚",	"to_unicode\(\'᧚\'\)\ \[data\/IdnaTest\.txt\:167\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("xn--pkf", %p)},	"᧚",	"to_unicode\(\'xn\-\-pkf\'\)\ \[data\/IdnaTest\.txt\:168\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("。", %p)},	undef,	"to_unicode\(\'\。\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:169\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("ꭠ", %p)},	"ꭠ",	"to_unicode\(\'ꭠ\'\)\ \[data\/IdnaTest\.txt\:170\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("xn--3y9a", %p)},	"ꭠ",	"to_unicode\(\'xn\-\-3y9a\'\)\ \[data\/IdnaTest\.txt\:171\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("1234567890ä1234567890123456789012345678901234567890123456", %p)},	"1234567890ä1234567890123456789012345678901234567890123456",	"to_unicode\(\'1234567890ä1234567890123456789012345678901234567890123456\'\)\ \[data\/IdnaTest\.txt\:172\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1234567890a\x{0308}1234567890123456789012345678901234567890123456", %p)},	"1234567890ä1234567890123456789012345678901234567890123456",	"to_unicode\(\'1234567890a\\u03081234567890123456789012345678901234567890123456\'\)\ \[data\/IdnaTest\.txt\:173\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1234567890A\x{0308}1234567890123456789012345678901234567890123456", %p)},	"1234567890ä1234567890123456789012345678901234567890123456",	"to_unicode\(\'1234567890A\\u03081234567890123456789012345678901234567890123456\'\)\ \[data\/IdnaTest\.txt\:174\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1234567890Ä1234567890123456789012345678901234567890123456", %p)},	"1234567890ä1234567890123456789012345678901234567890123456",	"to_unicode\(\'1234567890Ä1234567890123456789012345678901234567890123456\'\)\ \[data\/IdnaTest\.txt\:175\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("www.eXample.cOm", %p)},	"www.example.com",	"to_unicode\(\'www\.eXample\.cOm\'\)\ \[data\/IdnaTest\.txt\:176\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Bücher.de", %p)},	"bücher.de",	"to_unicode\(\'Bücher\.de\'\)\ \[data\/IdnaTest\.txt\:177\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Bu\x{0308}cher.de", %p)},	"bücher.de",	"to_unicode\(\'Bu\\u0308cher\.de\'\)\ \[data\/IdnaTest\.txt\:178\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("bu\x{0308}cher.de", %p)},	"bücher.de",	"to_unicode\(\'bu\\u0308cher\.de\'\)\ \[data\/IdnaTest\.txt\:179\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("bücher.de", %p)},	"bücher.de",	"to_unicode\(\'bücher\.de\'\)\ \[data\/IdnaTest\.txt\:180\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("BÜCHER.DE", %p)},	"bücher.de",	"to_unicode\(\'BÜCHER\.DE\'\)\ \[data\/IdnaTest\.txt\:181\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("BU\x{0308}CHER.DE", %p)},	"bücher.de",	"to_unicode\(\'BU\\u0308CHER\.DE\'\)\ \[data\/IdnaTest\.txt\:182\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--bcher-kva.de", %p)},	"bücher.de",	"to_unicode\(\'xn\-\-bcher\-kva\.de\'\)\ \[data\/IdnaTest\.txt\:183\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ÖBB", %p)},	"öbb",	"to_unicode\(\'ÖBB\'\)\ \[data\/IdnaTest\.txt\:184\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("O\x{0308}BB", %p)},	"öbb",	"to_unicode\(\'O\\u0308BB\'\)\ \[data\/IdnaTest\.txt\:185\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("o\x{0308}bb", %p)},	"öbb",	"to_unicode\(\'o\\u0308bb\'\)\ \[data\/IdnaTest\.txt\:186\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("öbb", %p)},	"öbb",	"to_unicode\(\'öbb\'\)\ \[data\/IdnaTest\.txt\:187\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Öbb", %p)},	"öbb",	"to_unicode\(\'Öbb\'\)\ \[data\/IdnaTest\.txt\:188\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("O\x{0308}bb", %p)},	"öbb",	"to_unicode\(\'O\\u0308bb\'\)\ \[data\/IdnaTest\.txt\:189\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--bb-eka", %p)},	"öbb",	"to_unicode\(\'xn\-\-bb\-eka\'\)\ \[data\/IdnaTest\.txt\:190\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βόλος.com", %p)},	"βόλος.com",	"to_unicode\(\'βόλος\.com\'\)\ \[data\/IdnaTest\.txt\:191\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βόλος.com", %p)},	"βόλος.com",	"to_unicode\(\'βόλος\.com\'\)\ \[data\/IdnaTest\.txt\:192\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βο\x{0301}λος.com", %p)},	"βόλος.com",	"to_unicode\(\'βο\\u0301λος\.com\'\)\ \[data\/IdnaTest\.txt\:193\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βο\x{0301}λος.com", %p)},	"βόλος.com",	"to_unicode\(\'βο\\u0301λος\.com\'\)\ \[data\/IdnaTest\.txt\:194\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ΒΟ\x{0301}ΛΟΣ.COM", %p)},	"βόλοσ.com",	"to_unicode\(\'ΒΟ\\u0301ΛΟΣ\.COM\'\)\ \[data\/IdnaTest\.txt\:195\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ΒΌΛΟΣ.COM", %p)},	"βόλοσ.com",	"to_unicode\(\'ΒΌΛΟΣ\.COM\'\)\ \[data\/IdnaTest\.txt\:196\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βόλοσ.com", %p)},	"βόλοσ.com",	"to_unicode\(\'βόλοσ\.com\'\)\ \[data\/IdnaTest\.txt\:197\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βο\x{0301}λοσ.com", %p)},	"βόλοσ.com",	"to_unicode\(\'βο\\u0301λοσ\.com\'\)\ \[data\/IdnaTest\.txt\:198\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βο\x{0301}λοσ.com", %p)},	"βόλοσ.com",	"to_unicode\(\'Βο\\u0301λοσ\.com\'\)\ \[data\/IdnaTest\.txt\:199\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βόλοσ.com", %p)},	"βόλοσ.com",	"to_unicode\(\'Βόλοσ\.com\'\)\ \[data\/IdnaTest\.txt\:200\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--nxasmq6b.com", %p)},	"βόλοσ.com",	"to_unicode\(\'xn\-\-nxasmq6b\.com\'\)\ \[data\/IdnaTest\.txt\:201\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βο\x{0301}λος.com", %p)},	"βόλος.com",	"to_unicode\(\'Βο\\u0301λος\.com\'\)\ \[data\/IdnaTest\.txt\:202\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βο\x{0301}λος.com", %p)},	"βόλος.com",	"to_unicode\(\'Βο\\u0301λος\.com\'\)\ \[data\/IdnaTest\.txt\:203\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βόλος.com", %p)},	"βόλος.com",	"to_unicode\(\'Βόλος\.com\'\)\ \[data\/IdnaTest\.txt\:204\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βόλος.com", %p)},	"βόλος.com",	"to_unicode\(\'Βόλος\.com\'\)\ \[data\/IdnaTest\.txt\:205\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--nxasmm1c.com", %p)},	"βόλος.com",	"to_unicode\(\'xn\-\-nxasmm1c\.com\'\)\ \[data\/IdnaTest\.txt\:206\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--nxasmm1c", %p)},	"βόλος",	"to_unicode\(\'xn\-\-nxasmm1c\'\)\ \[data\/IdnaTest\.txt\:207\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βόλος", %p)},	"βόλος",	"to_unicode\(\'βόλος\'\)\ \[data\/IdnaTest\.txt\:208\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βόλος", %p)},	"βόλος",	"to_unicode\(\'βόλος\'\)\ \[data\/IdnaTest\.txt\:209\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βο\x{0301}λος", %p)},	"βόλος",	"to_unicode\(\'βο\\u0301λος\'\)\ \[data\/IdnaTest\.txt\:210\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βο\x{0301}λος", %p)},	"βόλος",	"to_unicode\(\'βο\\u0301λος\'\)\ \[data\/IdnaTest\.txt\:211\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ΒΟ\x{0301}ΛΟΣ", %p)},	"βόλοσ",	"to_unicode\(\'ΒΟ\\u0301ΛΟΣ\'\)\ \[data\/IdnaTest\.txt\:212\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ΒΌΛΟΣ", %p)},	"βόλοσ",	"to_unicode\(\'ΒΌΛΟΣ\'\)\ \[data\/IdnaTest\.txt\:213\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βόλοσ", %p)},	"βόλοσ",	"to_unicode\(\'βόλοσ\'\)\ \[data\/IdnaTest\.txt\:214\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βο\x{0301}λοσ", %p)},	"βόλοσ",	"to_unicode\(\'βο\\u0301λοσ\'\)\ \[data\/IdnaTest\.txt\:215\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βο\x{0301}λοσ", %p)},	"βόλοσ",	"to_unicode\(\'Βο\\u0301λοσ\'\)\ \[data\/IdnaTest\.txt\:216\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βόλοσ", %p)},	"βόλοσ",	"to_unicode\(\'Βόλοσ\'\)\ \[data\/IdnaTest\.txt\:217\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--nxasmq6b", %p)},	"βόλοσ",	"to_unicode\(\'xn\-\-nxasmq6b\'\)\ \[data\/IdnaTest\.txt\:218\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βόλος", %p)},	"βόλος",	"to_unicode\(\'Βόλος\'\)\ \[data\/IdnaTest\.txt\:219\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βόλος", %p)},	"βόλος",	"to_unicode\(\'Βόλος\'\)\ \[data\/IdnaTest\.txt\:220\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βο\x{0301}λος", %p)},	"βόλος",	"to_unicode\(\'Βο\\u0301λος\'\)\ \[data\/IdnaTest\.txt\:221\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βο\x{0301}λος", %p)},	"βόλος",	"to_unicode\(\'Βο\\u0301λος\'\)\ \[data\/IdnaTest\.txt\:222\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com", %p)},	"www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com",	"to_unicode\(\'www\.ශ\\u0DCA\\u200Dර\\u0DD3\.com\'\)\ \[data\/IdnaTest\.txt\:223\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com", %p)},	"www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com",	"to_unicode\(\'www\.ශ\\u0DCA\\u200Dර\\u0DD3\.com\'\)\ \[data\/IdnaTest\.txt\:224\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("www.xn--10cl1a0b.com", %p)},	"www.ශ\x{0DCA}ර\x{0DD3}.com",	"to_unicode\(\'www\.xn\-\-10cl1a0b\.com\'\)\ \[data\/IdnaTest\.txt\:225\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("www.ශ\x{0DCA}ර\x{0DD3}.com", %p)},	"www.ශ\x{0DCA}ර\x{0DD3}.com",	"to_unicode\(\'www\.ශ\\u0DCAර\\u0DD3\.com\'\)\ \[data\/IdnaTest\.txt\:226\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("www.xn--10cl1a0b660p.com", %p)},	"www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com",	"to_unicode\(\'www\.xn\-\-10cl1a0b660p\.com\'\)\ \[data\/IdnaTest\.txt\:227\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u200C\\u0627\\u06CC\'\)\ \[data\/IdnaTest\.txt\:228\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u200C\\u0627\\u06CC\'\)\ \[data\/IdnaTest\.txt\:229\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--mgba3gch31f", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}",	"to_unicode\(\'xn\-\-mgba3gch31f\'\)\ \[data\/IdnaTest\.txt\:230\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u0627\\u06CC\'\)\ \[data\/IdnaTest\.txt\:231\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--mgba3gch31f060k", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}",	"to_unicode\(\'xn\-\-mgba3gch31f060k\'\)\ \[data\/IdnaTest\.txt\:232\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--mgba3gch31f060k.com", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.com",	"to_unicode\(\'xn\-\-mgba3gch31f060k\.com\'\)\ \[data\/IdnaTest\.txt\:233\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.com", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.com",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u200C\\u0627\\u06CC\.com\'\)\ \[data\/IdnaTest\.txt\:234\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.com", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.com",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u200C\\u0627\\u06CC\.com\'\)\ \[data\/IdnaTest\.txt\:235\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--mgba3gch31f.com", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}.com",	"to_unicode\(\'xn\-\-mgba3gch31f\.com\'\)\ \[data\/IdnaTest\.txt\:236\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}.com", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}.com",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u0627\\u06CC\.com\'\)\ \[data\/IdnaTest\.txt\:237\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b．c。d｡", %p)},	"a.b.c.d.",	"to_unicode\(\'a\.b．c\。d｡\'\)\ \[data\/IdnaTest\.txt\:238\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b.c。d。", %p)},	"a.b.c.d.",	"to_unicode\(\'a\.b\.c\。d\。\'\)\ \[data\/IdnaTest\.txt\:239\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b.c.d.", %p)},	"a.b.c.d.",	"to_unicode\(\'a\.b\.c\.d\.\'\)\ \[data\/IdnaTest\.txt\:240\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("U\x{0308}.xn--tda", %p)},	"ü.ü",	"to_unicode\(\'U\\u0308\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:241\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ü.xn--tda", %p)},	"ü.ü",	"to_unicode\(\'Ü\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:242\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ü.xn--tda", %p)},	"ü.ü",	"to_unicode\(\'ü\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:243\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("u\x{0308}.xn--tda", %p)},	"ü.ü",	"to_unicode\(\'u\\u0308\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:244\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--tda.xn--tda", %p)},	"ü.ü",	"to_unicode\(\'xn\-\-tda\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:245\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ü.ü", %p)},	"ü.ü",	"to_unicode\(\'ü\.ü\'\)\ \[data\/IdnaTest\.txt\:246\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("u\x{0308}.u\x{0308}", %p)},	"ü.ü",	"to_unicode\(\'u\\u0308\.u\\u0308\'\)\ \[data\/IdnaTest\.txt\:247\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("U\x{0308}.U\x{0308}", %p)},	"ü.ü",	"to_unicode\(\'U\\u0308\.U\\u0308\'\)\ \[data\/IdnaTest\.txt\:248\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ü.Ü", %p)},	"ü.ü",	"to_unicode\(\'Ü\.Ü\'\)\ \[data\/IdnaTest\.txt\:249\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ü.ü", %p)},	"ü.ü",	"to_unicode\(\'Ü\.ü\'\)\ \[data\/IdnaTest\.txt\:250\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("U\x{0308}.u\x{0308}", %p)},	"ü.ü",	"to_unicode\(\'U\\u0308\.u\\u0308\'\)\ \[data\/IdnaTest\.txt\:251\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--u-ccb", %p)},	undef,	"to_unicode\(\'xn\-\-u\-ccb\'\)\ throws\ error\ V1\ \[data\/IdnaTest\.txt\:252\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a⒈com", %p)},	undef,	"to_unicode\(\'a⒈com\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:253\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a1.com", %p)},	"a1.com",	"to_unicode\(\'a1\.com\'\)\ \[data\/IdnaTest\.txt\:254\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A⒈COM", %p)},	undef,	"to_unicode\(\'A⒈COM\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:255\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A⒈Com", %p)},	undef,	"to_unicode\(\'A⒈Com\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:256\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--a-ecp.ru", %p)},	undef,	"to_unicode\(\'xn\-\-a\-ecp\.ru\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:257\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--0.pt", %p)},	undef,	"to_unicode\(\'xn\-\-0\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:258\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--a.pt", %p)},	undef,	"to_unicode\(\'xn\-\-a\.pt\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:259\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--a-Ä.pt", %p)},	undef,	"to_unicode\(\'xn\-\-a\-Ä\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:260\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--a-A\x{0308}.pt", %p)},	undef,	"to_unicode\(\'xn\-\-a\-A\\u0308\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:261\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--a-a\x{0308}.pt", %p)},	undef,	"to_unicode\(\'xn\-\-a\-a\\u0308\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:262\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--a-ä.pt", %p)},	undef,	"to_unicode\(\'xn\-\-a\-ä\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:263\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("XN--A-Ä.PT", %p)},	undef,	"to_unicode\(\'XN\-\-A\-Ä\.PT\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:264\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("XN--A-A\x{0308}.PT", %p)},	undef,	"to_unicode\(\'XN\-\-A\-A\\u0308\.PT\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:265\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Xn--A-A\x{0308}.pt", %p)},	undef,	"to_unicode\(\'Xn\-\-A\-A\\u0308\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:266\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Xn--A-Ä.pt", %p)},	undef,	"to_unicode\(\'Xn\-\-A\-Ä\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:267\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("日本語。ＪＰ", %p)},	"日本語.jp",	"to_unicode\(\'日本語\。ＪＰ\'\)\ \[data\/IdnaTest\.txt\:268\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("日本語。JP", %p)},	"日本語.jp",	"to_unicode\(\'日本語\。JP\'\)\ \[data\/IdnaTest\.txt\:269\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--wgv71a119e.jp", %p)},	"日本語.jp",	"to_unicode\(\'xn\-\-wgv71a119e\.jp\'\)\ \[data\/IdnaTest\.txt\:270\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("日本語.jp", %p)},	"日本語.jp",	"to_unicode\(\'日本語\.jp\'\)\ \[data\/IdnaTest\.txt\:271\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("日本語。ｊｐ", %p)},	"日本語.jp",	"to_unicode\(\'日本語\。ｊｐ\'\)\ \[data\/IdnaTest\.txt\:272\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("日本語。Ｊｐ", %p)},	"日本語.jp",	"to_unicode\(\'日本語\。Ｊｐ\'\)\ \[data\/IdnaTest\.txt\:273\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("☕", %p)},	"☕",	"to_unicode\(\'\☕\'\)\ \[data\/IdnaTest\.txt\:274\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--53h", %p)},	"☕",	"to_unicode\(\'xn\-\-53h\'\)\ \[data\/IdnaTest\.txt\:275\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.aß\x{200C}\x{200D}b\x{200C}\x{200D}cßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\x{0302}ßz", %p)},	undef,	"to_unicode\(\'1\.aß\\u200C\\u200Db\\u200C\\u200Dcßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\\u0302ßz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:276\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.aß\x{200C}\x{200D}b\x{200C}\x{200D}cßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\x{0302}ßz", %p)},	undef,	"to_unicode\(\'1\.aß\\u200C\\u200Db\\u200C\\u200Dcßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\\u0302ßz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:277\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ASS\x{200C}\x{200D}B\x{200C}\x{200D}CSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSS\x{0302}SSZ", %p)},	undef,	"to_unicode\(\'1\.ASS\\u200C\\u200DB\\u200C\\u200DCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSS\\u0302SSZ\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:278\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ASS\x{200C}\x{200D}B\x{200C}\x{200D}CSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSS\x{0302}SSZ", %p)},	undef,	"to_unicode\(\'1\.ASS\\u200C\\u200DB\\u200C\\u200DCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSS\\u0302SSZ\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:279\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ASS\x{200C}\x{200D}B\x{200C}\x{200D}CSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ", %p)},	undef,	"to_unicode\(\'1\.ASS\\u200C\\u200DB\\u200C\\u200DCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:280\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ASS\x{200C}\x{200D}B\x{200C}\x{200D}CSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ", %p)},	undef,	"to_unicode\(\'1\.ASS\\u200C\\u200DB\\u200C\\u200DCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:281\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz", %p)},	undef,	"to_unicode\(\'1\.ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:282\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz", %p)},	undef,	"to_unicode\(\'1\.ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:283\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\x{0302}ssz", %p)},	undef,	"to_unicode\(\'1\.ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\\u0302ssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:284\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\x{0302}ssz", %p)},	undef,	"to_unicode\(\'1\.ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\\u0302ssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:285\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.Ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\x{0302}ssz", %p)},	undef,	"to_unicode\(\'1\.Ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\\u0302ssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:286\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.Ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\x{0302}ssz", %p)},	undef,	"to_unicode\(\'1\.Ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\\u0302ssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:287\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.Ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz", %p)},	undef,	"to_unicode\(\'1\.Ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:288\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.Ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz", %p)},	undef,	"to_unicode\(\'1\.Ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:289\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.Aß\x{200C}\x{200D}b\x{200C}\x{200D}cßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\x{0302}ßz", %p)},	undef,	"to_unicode\(\'1\.Aß\\u200C\\u200Db\\u200C\\u200Dcßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\\u0302ßz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:290\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.Aß\x{200C}\x{200D}b\x{200C}\x{200D}cßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\x{0302}ßz", %p)},	undef,	"to_unicode\(\'1\.Aß\\u200C\\u200Db\\u200C\\u200Dcßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\\u0302ßz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:291\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}x\x{200D}n\x{200C}-\x{200D}-bß", %p)},	undef,	"to_unicode\(\'\\u200Cx\\u200Dn\\u200C\-\\u200D\-bß\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:292\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}x\x{200D}n\x{200C}-\x{200D}-bß", %p)},	undef,	"to_unicode\(\'\\u200Cx\\u200Dn\\u200C\-\\u200D\-bß\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:293\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}X\x{200D}N\x{200C}-\x{200D}-BSS", %p)},	undef,	"to_unicode\(\'\\u200CX\\u200DN\\u200C\-\\u200D\-BSS\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:294\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}X\x{200D}N\x{200C}-\x{200D}-BSS", %p)},	undef,	"to_unicode\(\'\\u200CX\\u200DN\\u200C\-\\u200D\-BSS\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:295\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}x\x{200D}n\x{200C}-\x{200D}-bss", %p)},	undef,	"to_unicode\(\'\\u200Cx\\u200Dn\\u200C\-\\u200D\-bss\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:296\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}x\x{200D}n\x{200C}-\x{200D}-bss", %p)},	undef,	"to_unicode\(\'\\u200Cx\\u200Dn\\u200C\-\\u200D\-bss\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:297\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}X\x{200D}n\x{200C}-\x{200D}-Bss", %p)},	undef,	"to_unicode\(\'\\u200CX\\u200Dn\\u200C\-\\u200D\-Bss\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:298\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}X\x{200D}n\x{200C}-\x{200D}-Bss", %p)},	undef,	"to_unicode\(\'\\u200CX\\u200Dn\\u200C\-\\u200D\-Bss\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:299\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--bss", %p)},	"夙",	"to_unicode\(\'xn\-\-bss\'\)\ \[data\/IdnaTest\.txt\:300\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("夙", %p)},	"夙",	"to_unicode\(\'夙\'\)\ \[data\/IdnaTest\.txt\:301\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}X\x{200D}n\x{200C}-\x{200D}-Bß", %p)},	undef,	"to_unicode\(\'\\u200CX\\u200Dn\\u200C\-\\u200D\-Bß\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:302\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}X\x{200D}n\x{200C}-\x{200D}-Bß", %p)},	undef,	"to_unicode\(\'\\u200CX\\u200Dn\\u200C\-\\u200D\-Bß\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:303\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("ˣ\x{034F}ℕ\x{200B}﹣\x{00AD}－\x{180C}ℬ\x{FE00}ſ\x{2064}𝔰󠇯ﬄ", %p)},	"夡夞夜夙",	"to_unicode\(\'ˣ\\u034Fℕ\\u200B﹣\\u00AD－\\u180Cℬ\\uFE00ſ\\u2064𝔰\󠇯ﬄ\'\)\ \[data\/IdnaTest\.txt\:304\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("x\x{034F}N\x{200B}-\x{00AD}-\x{180C}B\x{FE00}s\x{2064}s󠇯ffl", %p)},	"夡夞夜夙",	"to_unicode\(\'x\\u034FN\\u200B\-\\u00AD\-\\u180CB\\uFE00s\\u2064s\󠇯ffl\'\)\ \[data\/IdnaTest\.txt\:305\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("x\x{034F}n\x{200B}-\x{00AD}-\x{180C}b\x{FE00}s\x{2064}s󠇯ffl", %p)},	"夡夞夜夙",	"to_unicode\(\'x\\u034Fn\\u200B\-\\u00AD\-\\u180Cb\\uFE00s\\u2064s\󠇯ffl\'\)\ \[data\/IdnaTest\.txt\:306\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("X\x{034F}N\x{200B}-\x{00AD}-\x{180C}B\x{FE00}S\x{2064}S󠇯FFL", %p)},	"夡夞夜夙",	"to_unicode\(\'X\\u034FN\\u200B\-\\u00AD\-\\u180CB\\uFE00S\\u2064S\󠇯FFL\'\)\ \[data\/IdnaTest\.txt\:307\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("X\x{034F}n\x{200B}-\x{00AD}-\x{180C}B\x{FE00}s\x{2064}s󠇯ffl", %p)},	"夡夞夜夙",	"to_unicode\(\'X\\u034Fn\\u200B\-\\u00AD\-\\u180CB\\uFE00s\\u2064s\󠇯ffl\'\)\ \[data\/IdnaTest\.txt\:308\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("xn--bssffl", %p)},	"夡夞夜夙",	"to_unicode\(\'xn\-\-bssffl\'\)\ \[data\/IdnaTest\.txt\:309\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("夡夞夜夙", %p)},	"夡夞夜夙",	"to_unicode\(\'夡夞夜夙\'\)\ \[data\/IdnaTest\.txt\:310\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("ˣ\x{034F}ℕ\x{200B}﹣\x{00AD}－\x{180C}ℬ\x{FE00}S\x{2064}𝔰󠇯FFL", %p)},	"夡夞夜夙",	"to_unicode\(\'ˣ\\u034Fℕ\\u200B﹣\\u00AD－\\u180Cℬ\\uFE00S\\u2064𝔰\󠇯FFL\'\)\ \[data\/IdnaTest\.txt\:311\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("x\x{034F}N\x{200B}-\x{00AD}-\x{180C}B\x{FE00}S\x{2064}s󠇯FFL", %p)},	"夡夞夜夙",	"to_unicode\(\'x\\u034FN\\u200B\-\\u00AD\-\\u180CB\\uFE00S\\u2064s\󠇯FFL\'\)\ \[data\/IdnaTest\.txt\:312\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("ˣ\x{034F}ℕ\x{200B}﹣\x{00AD}－\x{180C}ℬ\x{FE00}s\x{2064}𝔰󠇯ffl", %p)},	"夡夞夜夙",	"to_unicode\(\'ˣ\\u034Fℕ\\u200B﹣\\u00AD－\\u180Cℬ\\uFE00s\\u2064𝔰\󠇯ffl\'\)\ \[data\/IdnaTest\.txt\:313\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:314\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:315\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	"123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ \[data\/IdnaTest\.txt\:316\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901234\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ \[data\/IdnaTest\.txt\:317\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901234\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ \[data\/IdnaTest\.txt\:318\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901234\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:319\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ä1234567890123456789012345678901234567890123456789012345", %p)},	"ä1234567890123456789012345678901234567890123456789012345",	"to_unicode\(\'ä1234567890123456789012345678901234567890123456789012345\'\)\ \[data\/IdnaTest\.txt\:320\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0308}1234567890123456789012345678901234567890123456789012345", %p)},	"ä1234567890123456789012345678901234567890123456789012345",	"to_unicode\(\'a\\u03081234567890123456789012345678901234567890123456789012345\'\)\ \[data\/IdnaTest\.txt\:321\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0308}1234567890123456789012345678901234567890123456789012345", %p)},	"ä1234567890123456789012345678901234567890123456789012345",	"to_unicode\(\'A\\u03081234567890123456789012345678901234567890123456789012345\'\)\ \[data\/IdnaTest\.txt\:322\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ä1234567890123456789012345678901234567890123456789012345", %p)},	"ä1234567890123456789012345678901234567890123456789012345",	"to_unicode\(\'Ä1234567890123456789012345678901234567890123456789012345\'\)\ \[data\/IdnaTest\.txt\:323\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--1234567890123456789012345678901234567890123456789012345-9te", %p)},	"ä1234567890123456789012345678901234567890123456789012345",	"to_unicode\(\'xn\-\-1234567890123456789012345678901234567890123456789012345\-9te\'\)\ \[data\/IdnaTest\.txt\:324\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:325\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:326\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:327\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:328\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.xn\-\-1234567890123456789012345678901234567890123456789012345\-kue\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:329\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:330\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:331\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:332\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:333\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.xn\-\-1234567890123456789012345678901234567890123456789012345\-kue\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:334\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ \[data\/IdnaTest\.txt\:335\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ \[data\/IdnaTest\.txt\:336\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ \[data\/IdnaTest\.txt\:337\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ \[data\/IdnaTest\.txt\:338\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ \[data\/IdnaTest\.txt\:339\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ \[data\/IdnaTest\.txt\:340\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ \[data\/IdnaTest\.txt\:341\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ \[data\/IdnaTest\.txt\:342\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ \[data\/IdnaTest\.txt\:343\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ \[data\/IdnaTest\.txt\:344\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ \[data\/IdnaTest\.txt\:345\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ \[data\/IdnaTest\.txt\:346\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:347\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:348\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:349\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:350\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b..-q--a-.e", %p)},	undef,	"to_unicode\(\'a\.b\.\.\-q\-\-a\-\.e\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:351\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b..-q--ä-.e", %p)},	undef,	"to_unicode\(\'a\.b\.\.\-q\-\-ä\-\.e\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:352\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b..-q--a\x{0308}-.e", %p)},	undef,	"to_unicode\(\'a\.b\.\.\-q\-\-a\\u0308\-\.e\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:353\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A.B..-Q--A\x{0308}-.E", %p)},	undef,	"to_unicode\(\'A\.B\.\.\-Q\-\-A\\u0308\-\.E\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:354\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A.B..-Q--Ä-.E", %p)},	undef,	"to_unicode\(\'A\.B\.\.\-Q\-\-Ä\-\.E\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:355\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b..xn---q----jra.e", %p)},	undef,	"to_unicode\(\'a\.b\.\.xn\-\-\-q\-\-\-\-jra\.e\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:356\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a..c", %p)},	undef,	"to_unicode\(\'a\.\.c\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:357\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.-b.", %p)},	undef,	"to_unicode\(\'a\.\-b\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:358\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b-.c", %p)},	undef,	"to_unicode\(\'a\.b\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:359\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.-.c", %p)},	undef,	"to_unicode\(\'a\.\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:360\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.bc--de.f", %p)},	undef,	"to_unicode\(\'a\.bc\-\-de\.f\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:361\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ä.\x{00AD}.c", %p)},	undef,	"to_unicode\(\'ä\.\\u00AD\.c\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:362\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0308}.\x{00AD}.c", %p)},	undef,	"to_unicode\(\'a\\u0308\.\\u00AD\.c\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:363\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0308}.\x{00AD}.C", %p)},	undef,	"to_unicode\(\'A\\u0308\.\\u00AD\.C\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:364\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ä.\x{00AD}.C", %p)},	undef,	"to_unicode\(\'Ä\.\\u00AD\.C\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:365\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ä.-b.", %p)},	undef,	"to_unicode\(\'ä\.\-b\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:366\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0308}.-b.", %p)},	undef,	"to_unicode\(\'a\\u0308\.\-b\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:367\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0308}.-B.", %p)},	undef,	"to_unicode\(\'A\\u0308\.\-B\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:368\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ä.-B.", %p)},	undef,	"to_unicode\(\'Ä\.\-B\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:369\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ä.b-.c", %p)},	undef,	"to_unicode\(\'ä\.b\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:370\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0308}.b-.c", %p)},	undef,	"to_unicode\(\'a\\u0308\.b\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:371\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0308}.B-.C", %p)},	undef,	"to_unicode\(\'A\\u0308\.B\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:372\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ä.B-.C", %p)},	undef,	"to_unicode\(\'Ä\.B\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:373\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ä.-.c", %p)},	undef,	"to_unicode\(\'ä\.\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:374\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0308}.-.c", %p)},	undef,	"to_unicode\(\'a\\u0308\.\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:375\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0308}.-.C", %p)},	undef,	"to_unicode\(\'A\\u0308\.\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:376\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ä.-.C", %p)},	undef,	"to_unicode\(\'Ä\.\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:377\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ä.bc--de.f", %p)},	undef,	"to_unicode\(\'ä\.bc\-\-de\.f\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:378\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0308}.bc--de.f", %p)},	undef,	"to_unicode\(\'a\\u0308\.bc\-\-de\.f\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:379\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0308}.BC--DE.F", %p)},	undef,	"to_unicode\(\'A\\u0308\.BC\-\-DE\.F\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:380\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ä.BC--DE.F", %p)},	undef,	"to_unicode\(\'Ä\.BC\-\-DE\.F\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:381\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b.\x{0308}c.d", %p)},	undef,	"to_unicode\(\'a\.b\.\\u0308c\.d\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:382\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A.B.\x{0308}C.D", %p)},	undef,	"to_unicode\(\'A\.B\.\\u0308C\.D\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:383\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b.xn--c-bcb.d", %p)},	undef,	"to_unicode\(\'a\.b\.xn\-\-c\-bcb\.d\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:384\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A0", %p)},	"a0",	"to_unicode\(\'A0\'\)\ \[data\/IdnaTest\.txt\:385\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0A", %p)},	"0a",	"to_unicode\(\'0A\'\)\ \[data\/IdnaTest\.txt\:386\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0A.\x{05D0}", %p)},	"0a.\x{05D0}",	"to_unicode\(\'0A\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:387\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0a.xn--4db", %p)},	"0a.\x{05D0}",	"to_unicode\(\'0a\.xn\-\-4db\'\)\ \[data\/IdnaTest\.txt\:388\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("c.xn--0-eha.xn--4db", %p)},	"c.0ü.\x{05D0}",	"to_unicode\(\'c\.xn\-\-0\-eha\.xn\-\-4db\'\)\ \[data\/IdnaTest\.txt\:389\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("c.0ü.\x{05D0}", %p)},	"c.0ü.\x{05D0}",	"to_unicode\(\'c\.0ü\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:390\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("c.0u\x{0308}.\x{05D0}", %p)},	"c.0ü.\x{05D0}",	"to_unicode\(\'c\.0u\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:391\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("C.0U\x{0308}.\x{05D0}", %p)},	"c.0ü.\x{05D0}",	"to_unicode\(\'C\.0U\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:392\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("C.0Ü.\x{05D0}", %p)},	"c.0ü.\x{05D0}",	"to_unicode\(\'C\.0Ü\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:393\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("b-.\x{05D0}", %p)},	undef,	"to_unicode\(\'b\-\.\\u05D0\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:394\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("d.xn----dha.xn--4db", %p)},	undef,	"to_unicode\(\'d\.xn\-\-\-\-dha\.xn\-\-4db\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:395\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{05D0}", %p)},	undef,	"to_unicode\(\'a\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:396\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{05D0}", %p)},	undef,	"to_unicode\(\'A\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:397\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{05D0}\x{05C7}", %p)},	"\x{05D0}\x{05C7}",	"to_unicode\(\'\\u05D0\\u05C7\'\)\ \[data\/IdnaTest\.txt\:398\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--vdbr", %p)},	"\x{05D0}\x{05C7}",	"to_unicode\(\'xn\-\-vdbr\'\)\ \[data\/IdnaTest\.txt\:399\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{05D0}9\x{05C7}", %p)},	"\x{05D0}9\x{05C7}",	"to_unicode\(\'\\u05D09\\u05C7\'\)\ \[data\/IdnaTest\.txt\:400\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--9-ihcz", %p)},	"\x{05D0}9\x{05C7}",	"to_unicode\(\'xn\-\-9\-ihcz\'\)\ \[data\/IdnaTest\.txt\:401\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{05D0}a\x{05C7}", %p)},	undef,	"to_unicode\(\'\\u05D0a\\u05C7\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:402\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{05D0}A\x{05C7}", %p)},	undef,	"to_unicode\(\'\\u05D0A\\u05C7\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:403\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{05D0}\x{05EA}", %p)},	"\x{05D0}\x{05EA}",	"to_unicode\(\'\\u05D0\\u05EA\'\)\ \[data\/IdnaTest\.txt\:404\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--4db6c", %p)},	"\x{05D0}\x{05EA}",	"to_unicode\(\'xn\-\-4db6c\'\)\ \[data\/IdnaTest\.txt\:405\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}\x{05F3}\x{05EA}", %p)},	"\x{05D0}\x{05F3}\x{05EA}",	"to_unicode\(\'\\u05D0\\u05F3\\u05EA\'\)\ \[data\/IdnaTest\.txt\:406\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--4db6c0a", %p)},	"\x{05D0}\x{05F3}\x{05EA}",	"to_unicode\(\'xn\-\-4db6c0a\'\)\ \[data\/IdnaTest\.txt\:407\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{05D0}Tz", %p)},	undef,	"to_unicode\(\'a\\u05D0Tz\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:408\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{05D0}tz", %p)},	undef,	"to_unicode\(\'a\\u05D0tz\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:409\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{05D0}TZ", %p)},	undef,	"to_unicode\(\'A\\u05D0TZ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:410\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{05D0}tz", %p)},	undef,	"to_unicode\(\'A\\u05D0tz\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:411\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}T\x{05EA}", %p)},	undef,	"to_unicode\(\'\\u05D0T\\u05EA\'\)\ throws\ error\ B2\ \[data\/IdnaTest\.txt\:412\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}t\x{05EA}", %p)},	undef,	"to_unicode\(\'\\u05D0t\\u05EA\'\)\ throws\ error\ B2\ \[data\/IdnaTest\.txt\:413\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}7\x{05EA}", %p)},	"\x{05D0}7\x{05EA}",	"to_unicode\(\'\\u05D07\\u05EA\'\)\ \[data\/IdnaTest\.txt\:414\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--7-zhc3f", %p)},	"\x{05D0}7\x{05EA}",	"to_unicode\(\'xn\-\-7\-zhc3f\'\)\ \[data\/IdnaTest\.txt\:415\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}\x{0667}\x{05EA}", %p)},	"\x{05D0}\x{0667}\x{05EA}",	"to_unicode\(\'\\u05D0\\u0667\\u05EA\'\)\ \[data\/IdnaTest\.txt\:416\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--4db6c6t", %p)},	"\x{05D0}\x{0667}\x{05EA}",	"to_unicode\(\'xn\-\-4db6c6t\'\)\ \[data\/IdnaTest\.txt\:417\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a7\x{0667}z", %p)},	undef,	"to_unicode\(\'a7\\u0667z\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:418\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A7\x{0667}Z", %p)},	undef,	"to_unicode\(\'A7\\u0667Z\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:419\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A7\x{0667}z", %p)},	undef,	"to_unicode\(\'A7\\u0667z\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:420\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}7\x{0667}\x{05EA}", %p)},	undef,	"to_unicode\(\'\\u05D07\\u0667\\u05EA\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:421\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{0BCD}\x{200D}", %p)},	"ஹ\x{0BCD}\x{200D}",	"to_unicode\(\'ஹ\\u0BCD\\u200D\'\)\ \[data\/IdnaTest\.txt\:422\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{0BCD}\x{200D}", %p)},	"ஹ\x{0BCD}\x{200D}",	"to_unicode\(\'ஹ\\u0BCD\\u200D\'\)\ \[data\/IdnaTest\.txt\:423\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--dmc4b", %p)},	"ஹ\x{0BCD}",	"to_unicode\(\'xn\-\-dmc4b\'\)\ \[data\/IdnaTest\.txt\:424\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{0BCD}", %p)},	"ஹ\x{0BCD}",	"to_unicode\(\'ஹ\\u0BCD\'\)\ \[data\/IdnaTest\.txt\:425\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--dmc4b194h", %p)},	"ஹ\x{0BCD}\x{200D}",	"to_unicode\(\'xn\-\-dmc4b194h\'\)\ \[data\/IdnaTest\.txt\:426\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{200D}", %p)},	undef,	"to_unicode\(\'ஹ\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:427\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{200D}", %p)},	undef,	"to_unicode\(\'ஹ\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:428\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--dmc", %p)},	"ஹ",	"to_unicode\(\'xn\-\-dmc\'\)\ \[data\/IdnaTest\.txt\:429\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ", %p)},	"ஹ",	"to_unicode\(\'ஹ\'\)\ \[data\/IdnaTest\.txt\:430\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:431\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:432\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{0BCD}\x{200C}", %p)},	"ஹ\x{0BCD}\x{200C}",	"to_unicode\(\'ஹ\\u0BCD\\u200C\'\)\ \[data\/IdnaTest\.txt\:433\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{0BCD}\x{200C}", %p)},	"ஹ\x{0BCD}\x{200C}",	"to_unicode\(\'ஹ\\u0BCD\\u200C\'\)\ \[data\/IdnaTest\.txt\:434\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--dmc4by94h", %p)},	"ஹ\x{0BCD}\x{200C}",	"to_unicode\(\'xn\-\-dmc4by94h\'\)\ \[data\/IdnaTest\.txt\:435\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{200C}", %p)},	undef,	"to_unicode\(\'ஹ\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:436\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{200C}", %p)},	undef,	"to_unicode\(\'ஹ\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:437\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:438\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:439\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{200C}\x{06ED}\x{06EF}", %p)},	"\x{0644}\x{0670}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'\\u0644\\u0670\\u200C\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:440\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{200C}\x{06ED}\x{06EF}", %p)},	"\x{0644}\x{0670}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'\\u0644\\u0670\\u200C\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:441\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb2gxqia", %p)},	"\x{0644}\x{0670}\x{06ED}\x{06EF}",	"to_unicode\(\'xn\-\-ghb2gxqia\'\)\ \[data\/IdnaTest\.txt\:442\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{06ED}\x{06EF}", %p)},	"\x{0644}\x{0670}\x{06ED}\x{06EF}",	"to_unicode\(\'\\u0644\\u0670\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:443\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb2gxqia7523a", %p)},	"\x{0644}\x{0670}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'xn\-\-ghb2gxqia7523a\'\)\ \[data\/IdnaTest\.txt\:444\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{200C}\x{06EF}", %p)},	"\x{0644}\x{0670}\x{200C}\x{06EF}",	"to_unicode\(\'\\u0644\\u0670\\u200C\\u06EF\'\)\ \[data\/IdnaTest\.txt\:445\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{200C}\x{06EF}", %p)},	"\x{0644}\x{0670}\x{200C}\x{06EF}",	"to_unicode\(\'\\u0644\\u0670\\u200C\\u06EF\'\)\ \[data\/IdnaTest\.txt\:446\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb2g3q", %p)},	"\x{0644}\x{0670}\x{06EF}",	"to_unicode\(\'xn\-\-ghb2g3q\'\)\ \[data\/IdnaTest\.txt\:447\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{06EF}", %p)},	"\x{0644}\x{0670}\x{06EF}",	"to_unicode\(\'\\u0644\\u0670\\u06EF\'\)\ \[data\/IdnaTest\.txt\:448\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb2g3qq34f", %p)},	"\x{0644}\x{0670}\x{200C}\x{06EF}",	"to_unicode\(\'xn\-\-ghb2g3qq34f\'\)\ \[data\/IdnaTest\.txt\:449\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{200C}\x{06ED}\x{06EF}", %p)},	"\x{0644}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'\\u0644\\u200C\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:450\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{200C}\x{06ED}\x{06EF}", %p)},	"\x{0644}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'\\u0644\\u200C\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:451\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb25aga", %p)},	"\x{0644}\x{06ED}\x{06EF}",	"to_unicode\(\'xn\-\-ghb25aga\'\)\ \[data\/IdnaTest\.txt\:452\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{06ED}\x{06EF}", %p)},	"\x{0644}\x{06ED}\x{06EF}",	"to_unicode\(\'\\u0644\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:453\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb25aga828w", %p)},	"\x{0644}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'xn\-\-ghb25aga828w\'\)\ \[data\/IdnaTest\.txt\:454\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{200C}\x{06EF}", %p)},	"\x{0644}\x{200C}\x{06EF}",	"to_unicode\(\'\\u0644\\u200C\\u06EF\'\)\ \[data\/IdnaTest\.txt\:455\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{200C}\x{06EF}", %p)},	"\x{0644}\x{200C}\x{06EF}",	"to_unicode\(\'\\u0644\\u200C\\u06EF\'\)\ \[data\/IdnaTest\.txt\:456\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb65a", %p)},	"\x{0644}\x{06EF}",	"to_unicode\(\'xn\-\-ghb65a\'\)\ \[data\/IdnaTest\.txt\:457\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{06EF}", %p)},	"\x{0644}\x{06EF}",	"to_unicode\(\'\\u0644\\u06EF\'\)\ \[data\/IdnaTest\.txt\:458\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb65a953d", %p)},	"\x{0644}\x{200C}\x{06EF}",	"to_unicode\(\'xn\-\-ghb65a953d\'\)\ \[data\/IdnaTest\.txt\:459\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{200C}\x{06ED}", %p)},	undef,	"to_unicode\(\'\\u0644\\u0670\\u200C\\u06ED\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:460\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{200C}\x{06ED}", %p)},	undef,	"to_unicode\(\'\\u0644\\u0670\\u200C\\u06ED\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:461\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb2gxq", %p)},	"\x{0644}\x{0670}\x{06ED}",	"to_unicode\(\'xn\-\-ghb2gxq\'\)\ \[data\/IdnaTest\.txt\:462\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{06ED}", %p)},	"\x{0644}\x{0670}\x{06ED}",	"to_unicode\(\'\\u0644\\u0670\\u06ED\'\)\ \[data\/IdnaTest\.txt\:463\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06EF}\x{200C}\x{06EF}", %p)},	undef,	"to_unicode\(\'\\u06EF\\u200C\\u06EF\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:464\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06EF}\x{200C}\x{06EF}", %p)},	undef,	"to_unicode\(\'\\u06EF\\u200C\\u06EF\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:465\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--cmba", %p)},	"\x{06EF}\x{06EF}",	"to_unicode\(\'xn\-\-cmba\'\)\ \[data\/IdnaTest\.txt\:466\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06EF}\x{06EF}", %p)},	"\x{06EF}\x{06EF}",	"to_unicode\(\'\\u06EF\\u06EF\'\)\ \[data\/IdnaTest\.txt\:467\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0644\\u200C\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:468\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0644\\u200C\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:469\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb", %p)},	"\x{0644}",	"to_unicode\(\'xn\-\-ghb\'\)\ \[data\/IdnaTest\.txt\:470\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}", %p)},	"\x{0644}",	"to_unicode\(\'\\u0644\'\)\ \[data\/IdnaTest\.txt\:471\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒕∝\x{FE0E}񋆨．-󠄠", %p)},	undef,	"to_unicode\(\'⒕\∝\\uFE0E񋆨．\-\󠄠\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:475\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("14.∝\x{FE0E}񋆨.-󠄠", %p)},	undef,	"to_unicode\(\'14\.\∝\\uFE0E񋆨\.\-\󠄠\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:476\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07CE}.\x{076D}", %p)},	"\x{07CE}.\x{076D}",	"to_unicode\(\'\\u07CE\.\\u076D\'\)\ \[data\/IdnaTest\.txt\:477\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("xn--psb.xn--xpb", %p)},	"\x{07CE}.\x{076D}",	"to_unicode\(\'xn\-\-psb\.xn\-\-xpb\'\)\ \[data\/IdnaTest\.txt\:478\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("≯\x{0600}｡-", %p)},	undef,	"to_unicode\(\'\≯\\u0600｡\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:479\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{0600}｡-", %p)},	undef,	"to_unicode\(\'\>\\u0338\\u0600｡\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:480\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{0600}。-", %p)},	undef,	"to_unicode\(\'\≯\\u0600\。\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:481\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{0600}。-", %p)},	undef,	"to_unicode\(\'\>\\u0338\\u0600\。\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:482\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾛\x{0602}⾕.\x{115F}\x{000F}ςႭ", %p)},	undef,	"to_unicode\(\'⾛\\u0602⾕\.\\u115F\\u000FςႭ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:483\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("走\x{0602}谷.\x{115F}\x{000F}ςႭ", %p)},	undef,	"to_unicode\(\'走\\u0602谷\.\\u115F\\u000FςႭ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:484\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("走\x{0602}谷.\x{115F}\x{000F}ςⴍ", %p)},	undef,	"to_unicode\(\'走\\u0602谷\.\\u115F\\u000Fςⴍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:485\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("走\x{0602}谷.\x{115F}\x{000F}ΣႭ", %p)},	undef,	"to_unicode\(\'走\\u0602谷\.\\u115F\\u000FΣႭ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:486\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("走\x{0602}谷.\x{115F}\x{000F}σⴍ", %p)},	undef,	"to_unicode\(\'走\\u0602谷\.\\u115F\\u000Fσⴍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:487\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("走\x{0602}谷.\x{115F}\x{000F}Σⴍ", %p)},	undef,	"to_unicode\(\'走\\u0602谷\.\\u115F\\u000FΣⴍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:488\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾛\x{0602}⾕.\x{115F}\x{000F}ςⴍ", %p)},	undef,	"to_unicode\(\'⾛\\u0602⾕\.\\u115F\\u000Fςⴍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:489\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾛\x{0602}⾕.\x{115F}\x{000F}ΣႭ", %p)},	undef,	"to_unicode\(\'⾛\\u0602⾕\.\\u115F\\u000FΣႭ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:490\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾛\x{0602}⾕.\x{115F}\x{000F}σⴍ", %p)},	undef,	"to_unicode\(\'⾛\\u0602⾕\.\\u115F\\u000Fσⴍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:491\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾛\x{0602}⾕.\x{115F}\x{000F}Σⴍ", %p)},	undef,	"to_unicode\(\'⾛\\u0602⾕\.\\u115F\\u000FΣⴍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:492\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}≠\x{07E0}≯.솣-\x{0692}Ⴀ", %p)},	undef,	"to_unicode\(\'\\u200D\≠\\u07E0\≯\.솣\-\\u0692Ⴀ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B5\ \[data\/IdnaTest\.txt\:493\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}≠\x{07E0}≯.솣-\x{0692}Ⴀ", %p)},	undef,	"to_unicode\(\'\\u200D\≠\\u07E0\≯\.솣\-\\u0692Ⴀ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B5\ \[data\/IdnaTest\.txt\:494\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}=\x{0338}\x{07E0}>\x{0338}.솣-\x{0692}Ⴀ", %p)},	undef,	"to_unicode\(\'\\u200D\=\\u0338\\u07E0\>\\u0338\.솣\-\\u0692Ⴀ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B5\ \[data\/IdnaTest\.txt\:495\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}=\x{0338}\x{07E0}>\x{0338}.솣-\x{0692}Ⴀ", %p)},	undef,	"to_unicode\(\'\\u200D\=\\u0338\\u07E0\>\\u0338\.솣\-\\u0692Ⴀ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B5\ \[data\/IdnaTest\.txt\:496\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}=\x{0338}\x{07E0}>\x{0338}.솣-\x{0692}ⴀ", %p)},	undef,	"to_unicode\(\'\\u200D\=\\u0338\\u07E0\>\\u0338\.솣\-\\u0692ⴀ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B5\ \[data\/IdnaTest\.txt\:497\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}=\x{0338}\x{07E0}>\x{0338}.솣-\x{0692}ⴀ", %p)},	undef,	"to_unicode\(\'\\u200D\=\\u0338\\u07E0\>\\u0338\.솣\-\\u0692ⴀ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B5\ \[data\/IdnaTest\.txt\:498\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}≠\x{07E0}≯.솣-\x{0692}ⴀ", %p)},	undef,	"to_unicode\(\'\\u200D\≠\\u07E0\≯\.솣\-\\u0692ⴀ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B5\ \[data\/IdnaTest\.txt\:499\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}≠\x{07E0}≯.솣-\x{0692}ⴀ", %p)},	undef,	"to_unicode\(\'\\u200D\≠\\u07E0\≯\.솣\-\\u0692ⴀ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B5\ \[data\/IdnaTest\.txt\:500\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򺓺．𐸛\x{1B36}ᠠ\x{0664}", %p)},	undef,	"to_unicode\(\'򺓺．𐸛\\u1B36ᠠ\\u0664\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:501\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򺓺.𐸛\x{1B36}ᠠ\x{0664}", %p)},	undef,	"to_unicode\(\'򺓺\.𐸛\\u1B36ᠠ\\u0664\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:502\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E9D9}\x{302C}.\x{A953}", %p)},	undef,	"to_unicode\(\'\\uE9D9\\u302C\.\\uA953\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:503\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠷ\x{09CD}𒚉。\x{0732}Ⴣꡐ", %p)},	undef,	"to_unicode\(\'ᠷ\\u09CD𒚉\。\\u0732Ⴣꡐ\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:504\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠷ\x{09CD}𒚉。\x{0732}ⴣꡐ", %p)},	undef,	"to_unicode\(\'ᠷ\\u09CD𒚉\。\\u0732ⴣꡐ\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:505\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹢\x{2D7F}ς⋀。\x{0FB6}렧", %p)},	undef,	"to_unicode\(\'𐹢\\u2D7Fς\⋀\。\\u0FB6렧\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:506\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹢\x{2D7F}ς⋀。\x{0FB6}렧", %p)},	undef,	"to_unicode\(\'𐹢\\u2D7Fς\⋀\。\\u0FB6렧\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:507\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹢\x{2D7F}Σ⋀。\x{0FB6}렧", %p)},	undef,	"to_unicode\(\'𐹢\\u2D7FΣ\⋀\。\\u0FB6렧\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:508\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹢\x{2D7F}Σ⋀。\x{0FB6}렧", %p)},	undef,	"to_unicode\(\'𐹢\\u2D7FΣ\⋀\。\\u0FB6렧\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:509\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹢\x{2D7F}σ⋀。\x{0FB6}렧", %p)},	undef,	"to_unicode\(\'𐹢\\u2D7Fσ\⋀\。\\u0FB6렧\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:510\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹢\x{2D7F}σ⋀。\x{0FB6}렧", %p)},	undef,	"to_unicode\(\'𐹢\\u2D7Fσ\⋀\。\\u0FB6렧\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:511\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-\x{200D}。ᡠ\x{200C}\x{200D}⒈", %p)},	undef,	"to_unicode\(\'\-\\u200D\。ᡠ\\u200C\\u200D⒈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:512\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200D}。ᡠ\x{200C}\x{200D}⒈", %p)},	undef,	"to_unicode\(\'\-\\u200D\。ᡠ\\u200C\\u200D⒈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:513\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200D}。ᡠ\x{200C}\x{200D}1.", %p)},	undef,	"to_unicode\(\'\-\\u200D\。ᡠ\\u200C\\u200D1\.\'\)\ throws\ error\ V3\ C2\ C1\ \[data\/IdnaTest\.txt\:514\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200D}。ᡠ\x{200C}\x{200D}1.", %p)},	undef,	"to_unicode\(\'\-\\u200D\。ᡠ\\u200C\\u200D1\.\'\)\ throws\ error\ V3\ C2\ C1\ \[data\/IdnaTest\.txt\:515\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}򈘂.Ⴒ\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200C򈘂\.Ⴒ\\uABED\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:516\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}򈘂.Ⴒ\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200C򈘂\.Ⴒ\\uABED\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:517\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}򈘂.ⴒ\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200C򈘂\.ⴒ\\uABED\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:518\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}򈘂.ⴒ\x{ABED}", %p)},	undef,	"to_unicode\(\'\\u200C򈘂\.ⴒ\\uABED\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:519\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("繱\x{1039}\x{200D}.８︒", %p)},	undef,	"to_unicode\(\'繱\\u1039\\u200D\.８︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:520\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("繱\x{1039}\x{200D}.8。", %p)},	"繱\x{1039}\x{200D}.8.",	"to_unicode\(\'繱\\u1039\\u200D\.8\。\'\)\ \[data\/IdnaTest\.txt\:521\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("繱\x{1039}\x{200D}.8。", %p)},	"繱\x{1039}\x{200D}.8.",	"to_unicode\(\'繱\\u1039\\u200D\.8\。\'\)\ \[data\/IdnaTest\.txt\:522\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--9jd5457c.8.", %p)},	"繱\x{1039}.8.",	"to_unicode\(\'xn\-\-9jd5457c\.8\.\'\)\ \[data\/IdnaTest\.txt\:523\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("繱\x{1039}.8.", %p)},	"繱\x{1039}.8.",	"to_unicode\(\'繱\\u1039\.8\.\'\)\ \[data\/IdnaTest\.txt\:524\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--9jd812ffm5e.8.", %p)},	"繱\x{1039}\x{200D}.8.",	"to_unicode\(\'xn\-\-9jd812ffm5e\.8\.\'\)\ \[data\/IdnaTest\.txt\:525\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("繱\x{1039}\x{200D}.8.", %p)},	"繱\x{1039}\x{200D}.8.",	"to_unicode\(\'繱\\u1039\\u200D\.8\.\'\)\ \[data\/IdnaTest\.txt\:526\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("繱\x{1039}\x{200D}.8.", %p)},	"繱\x{1039}\x{200D}.8.",	"to_unicode\(\'繱\\u1039\\u200D\.8\.\'\)\ \[data\/IdnaTest\.txt\:527\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅕．\x{1927}", %p)},	undef,	"to_unicode\(\'\󠅕．\\u1927\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:528\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅕.\x{1927}", %p)},	undef,	"to_unicode\(\'\󠅕\.\\u1927\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:529\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß󠇦。\x{200D}", %p)},	undef,	"to_unicode\(\'ß\󠇦\。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:530\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß󠇦。\x{200D}", %p)},	undef,	"to_unicode\(\'ß\󠇦\。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:531\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS󠇦。\x{200D}", %p)},	undef,	"to_unicode\(\'SS\󠇦\。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:532\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS󠇦。\x{200D}", %p)},	undef,	"to_unicode\(\'SS\󠇦\。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:533\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss󠇦。\x{200D}", %p)},	undef,	"to_unicode\(\'ss\󠇦\。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:534\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss󠇦。\x{200D}", %p)},	undef,	"to_unicode\(\'ss\󠇦\。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:535\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss󠇦。\x{200D}", %p)},	undef,	"to_unicode\(\'Ss\󠇦\。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:536\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss󠇦。\x{200D}", %p)},	undef,	"to_unicode\(\'Ss\󠇦\。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:537\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss.", %p)},	"ss.",	"to_unicode\(\'ss\.\'\)\ \[data\/IdnaTest\.txt\:538\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠯓\x{200C}⒈．󠅵", %p)},	undef,	"to_unicode\(\'\󠯓\\u200C⒈．\󠅵\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:539\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠯓\x{200C}⒈．󠅵", %p)},	undef,	"to_unicode\(\'\󠯓\\u200C⒈．\󠅵\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:540\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠯓\x{200C}1..󠅵", %p)},	undef,	"to_unicode\(\'\󠯓\\u200C1\.\.\󠅵\'\)\ throws\ error\ P1\ V6\ C1\ A4_2\ \[data\/IdnaTest\.txt\:541\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠯓\x{200C}1..󠅵", %p)},	undef,	"to_unicode\(\'\󠯓\\u200C1\.\.\󠅵\'\)\ throws\ error\ P1\ V6\ C1\ A4_2\ \[data\/IdnaTest\.txt\:542\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򸕹\x{1072}󠆈ß。󚭹", %p)},	undef,	"to_unicode\(\'򸕹\\u1072\󠆈ß\。󚭹\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:543\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򸕹\x{1072}󠆈SS。󚭹", %p)},	undef,	"to_unicode\(\'򸕹\\u1072\󠆈SS\。󚭹\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:544\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򸕹\x{1072}󠆈ss。󚭹", %p)},	undef,	"to_unicode\(\'򸕹\\u1072\󠆈ss\。󚭹\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:545\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򸕹\x{1072}󠆈Ss。󚭹", %p)},	undef,	"to_unicode\(\'򸕹\\u1072\󠆈Ss\。󚭹\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:546\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06A8}\x{200C}𐮂。󻋜䉜\x{200D}񒑺", %p)},	undef,	"to_unicode\(\'\\u06A8\\u200C𐮂\。󻋜䉜\\u200D񒑺\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:547\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06A8}\x{200C}𐮂。󻋜䉜\x{200D}񒑺", %p)},	undef,	"to_unicode\(\'\\u06A8\\u200C𐮂\。󻋜䉜\\u200D񒑺\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:548\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񞀎ς\x{07DA}⒈.≮𑂹\x{200D}\x{067F}", %p)},	undef,	"to_unicode\(\'񞀎ς\\u07DA⒈\.\≮𑂹\\u200D\\u067F\'\)\ throws\ error\ P1\ V6\ B5\ B1\ \[data\/IdnaTest\.txt\:549\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񞀎ς\x{07DA}⒈.<\x{0338}𑂹\x{200D}\x{067F}", %p)},	undef,	"to_unicode\(\'񞀎ς\\u07DA⒈\.\<\\u0338𑂹\\u200D\\u067F\'\)\ throws\ error\ P1\ V6\ B5\ B1\ \[data\/IdnaTest\.txt\:550\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񞀎ς\x{07DA}1..≮𑂹\x{200D}\x{067F}", %p)},	undef,	"to_unicode\(\'񞀎ς\\u07DA1\.\.\≮𑂹\\u200D\\u067F\'\)\ throws\ error\ P1\ V6\ B5\ A4_2\ B1\ \[data\/IdnaTest\.txt\:551\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񞀎ς\x{07DA}1..<\x{0338}𑂹\x{200D}\x{067F}", %p)},	undef,	"to_unicode\(\'񞀎ς\\u07DA1\.\.\<\\u0338𑂹\\u200D\\u067F\'\)\ throws\ error\ P1\ V6\ B5\ A4_2\ B1\ \[data\/IdnaTest\.txt\:552\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񞀎Σ\x{07DA}1..<\x{0338}𑂹\x{200D}\x{067F}", %p)},	undef,	"to_unicode\(\'񞀎Σ\\u07DA1\.\.\<\\u0338𑂹\\u200D\\u067F\'\)\ throws\ error\ P1\ V6\ B5\ A4_2\ B1\ \[data\/IdnaTest\.txt\:553\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񞀎Σ\x{07DA}1..≮𑂹\x{200D}\x{067F}", %p)},	undef,	"to_unicode\(\'񞀎Σ\\u07DA1\.\.\≮𑂹\\u200D\\u067F\'\)\ throws\ error\ P1\ V6\ B5\ A4_2\ B1\ \[data\/IdnaTest\.txt\:554\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񞀎σ\x{07DA}1..≮𑂹\x{200D}\x{067F}", %p)},	undef,	"to_unicode\(\'񞀎σ\\u07DA1\.\.\≮𑂹\\u200D\\u067F\'\)\ throws\ error\ P1\ V6\ B5\ A4_2\ B1\ \[data\/IdnaTest\.txt\:555\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񞀎σ\x{07DA}1..<\x{0338}𑂹\x{200D}\x{067F}", %p)},	undef,	"to_unicode\(\'񞀎σ\\u07DA1\.\.\<\\u0338𑂹\\u200D\\u067F\'\)\ throws\ error\ P1\ V6\ B5\ A4_2\ B1\ \[data\/IdnaTest\.txt\:556\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񞀎Σ\x{07DA}⒈.<\x{0338}𑂹\x{200D}\x{067F}", %p)},	undef,	"to_unicode\(\'񞀎Σ\\u07DA⒈\.\<\\u0338𑂹\\u200D\\u067F\'\)\ throws\ error\ P1\ V6\ B5\ B1\ \[data\/IdnaTest\.txt\:557\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񞀎Σ\x{07DA}⒈.≮𑂹\x{200D}\x{067F}", %p)},	undef,	"to_unicode\(\'񞀎Σ\\u07DA⒈\.\≮𑂹\\u200D\\u067F\'\)\ throws\ error\ P1\ V6\ B5\ B1\ \[data\/IdnaTest\.txt\:558\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񞀎σ\x{07DA}⒈.≮𑂹\x{200D}\x{067F}", %p)},	undef,	"to_unicode\(\'񞀎σ\\u07DA⒈\.\≮𑂹\\u200D\\u067F\'\)\ throws\ error\ P1\ V6\ B5\ B1\ \[data\/IdnaTest\.txt\:559\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񞀎σ\x{07DA}⒈.<\x{0338}𑂹\x{200D}\x{067F}", %p)},	undef,	"to_unicode\(\'񞀎σ\\u07DA⒈\.\<\\u0338𑂹\\u200D\\u067F\'\)\ throws\ error\ P1\ V6\ B5\ B1\ \[data\/IdnaTest\.txt\:560\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3164}\x{0CCD}Ⴀ𑇋.\x{180B}", %p)},	undef,	"to_unicode\(\'\\u3164\\u0CCDႠ𑇋\.\\u180B\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:561\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1160}\x{0CCD}Ⴀ𑇋.\x{180B}", %p)},	undef,	"to_unicode\(\'\\u1160\\u0CCDႠ𑇋\.\\u180B\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:562\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1160}\x{0CCD}ⴀ𑇋.\x{180B}", %p)},	undef,	"to_unicode\(\'\\u1160\\u0CCDⴀ𑇋\.\\u180B\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:563\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3164}\x{0CCD}ⴀ𑇋.\x{180B}", %p)},	undef,	"to_unicode\(\'\\u3164\\u0CCDⴀ𑇋\.\\u180B\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:564\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠜈\x{200D}．\x{1BF3}󠄀󠆦\x{1B6D}", %p)},	undef,	"to_unicode\(\'\󠜈\\u200D．\\u1BF3\󠄀\󠆦\\u1B6D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:565\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠜈\x{200D}．\x{1BF3}󠄀󠆦\x{1B6D}", %p)},	undef,	"to_unicode\(\'\󠜈\\u200D．\\u1BF3\󠄀\󠆦\\u1B6D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:566\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠜈\x{200D}.\x{1BF3}󠄀󠆦\x{1B6D}", %p)},	undef,	"to_unicode\(\'\󠜈\\u200D\.\\u1BF3\󠄀\󠆦\\u1B6D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:567\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠜈\x{200D}.\x{1BF3}󠄀󠆦\x{1B6D}", %p)},	undef,	"to_unicode\(\'\󠜈\\u200D\.\\u1BF3\󠄀\󠆦\\u1B6D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:568\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮𐸧𞶡.≯𼫗ᡖ", %p)},	undef,	"to_unicode\(\'\≮𐸧𞶡\.\≯𼫗ᡖ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:569\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}𐸧𞶡.>\x{0338}𼫗ᡖ", %p)},	undef,	"to_unicode\(\'\<\\u0338𐸧𞶡\.\>\\u0338𼫗ᡖ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:570\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05C7}𐥴\x{0857}№｡\x{1BAA}ꡊ", %p)},	undef,	"to_unicode\(\'\\u05C7𐥴\\u0857№｡\\u1BAAꡊ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:571\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05C7}𐥴\x{0857}No。\x{1BAA}ꡊ", %p)},	undef,	"to_unicode\(\'\\u05C7𐥴\\u0857No\。\\u1BAAꡊ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:572\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05C7}𐥴\x{0857}no。\x{1BAA}ꡊ", %p)},	undef,	"to_unicode\(\'\\u05C7𐥴\\u0857no\。\\u1BAAꡊ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:573\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05C7}𐥴\x{0857}NO。\x{1BAA}ꡊ", %p)},	undef,	"to_unicode\(\'\\u05C7𐥴\\u0857NO\。\\u1BAAꡊ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:574\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0F9F}。􃍩", %p)},	undef,	"to_unicode\(\'\\u0F9F\。􃍩\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:575\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9C0}\x{1B6B}．\x{1160}", %p)},	undef,	"to_unicode\(\'\\uA9C0\\u1B6B．\\u1160\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:576\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9C0}\x{1B6B}.\x{1160}", %p)},	undef,	"to_unicode\(\'\\uA9C0\\u1B6B\.\\u1160\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:577\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{08A7}\x{200D}。󴀴\x{079E}", %p)},	undef,	"to_unicode\(\'\-\\u08A7\\u200D\。󴀴\\u079E\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:578\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{08A7}\x{200D}。󴀴\x{079E}", %p)},	undef,	"to_unicode\(\'\-\\u08A7\\u200D\。󴀴\\u079E\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:579\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{072B}\x{1920}≯󞉲。󠇨⾇滸𐹭", %p)},	undef,	"to_unicode\(\'\\u072B\\u1920\≯󞉲\。\󠇨⾇滸𐹭\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:580\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{072B}\x{1920}>\x{0338}󞉲。󠇨⾇滸𐹭", %p)},	undef,	"to_unicode\(\'\\u072B\\u1920\>\\u0338󞉲\。\󠇨⾇滸𐹭\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:581\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{072B}\x{1920}≯󞉲。󠇨舛滸𐹭", %p)},	undef,	"to_unicode\(\'\\u072B\\u1920\≯󞉲\。\󠇨舛滸𐹭\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:582\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{072B}\x{1920}>\x{0338}󞉲。󠇨舛滸𐹭", %p)},	undef,	"to_unicode\(\'\\u072B\\u1920\>\\u0338󞉲\。\󠇨舛滸𐹭\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:583\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("蔏｡\x{08FB}", %p)},	undef,	"to_unicode\(\'蔏｡\\u08FB\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:584\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("蔏。\x{08FB}", %p)},	undef,	"to_unicode\(\'蔏\。\\u08FB\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:585\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𝟿𐮂。\x{034E}", %p)},	undef,	"to_unicode\(\'𝟿𐮂\。\\u034E\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:586\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("9𐮂。\x{034E}", %p)},	undef,	"to_unicode\(\'9𐮂\。\\u034E\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:587\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("󧫃-䟖F。\x{069B}⒈𐹣", %p)},	undef,	"to_unicode\(\'󧫃\-䟖F\。\\u069B⒈𐹣\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:588\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󧫃-䟖F。\x{069B}1.𐹣", %p)},	undef,	"to_unicode\(\'󧫃\-䟖F\。\\u069B1\.𐹣\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:589\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󧫃-䟖f。\x{069B}1.𐹣", %p)},	undef,	"to_unicode\(\'󧫃\-䟖f\。\\u069B1\.𐹣\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:590\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󧫃-䟖f。\x{069B}⒈𐹣", %p)},	undef,	"to_unicode\(\'󧫃\-䟖f\。\\u069B⒈𐹣\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:591\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}｡𐹣", %p)},	undef,	"to_unicode\(\'\\u200C｡𐹣\'\)\ throws\ error\ C1\ B1\ \[data\/IdnaTest\.txt\:592\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}｡𐹣", %p)},	undef,	"to_unicode\(\'\\u200C｡𐹣\'\)\ throws\ error\ C1\ B1\ \[data\/IdnaTest\.txt\:593\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}。𐹣", %p)},	undef,	"to_unicode\(\'\\u200C\。𐹣\'\)\ throws\ error\ C1\ B1\ \[data\/IdnaTest\.txt\:594\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}。𐹣", %p)},	undef,	"to_unicode\(\'\\u200C\。𐹣\'\)\ throws\ error\ C1\ B1\ \[data\/IdnaTest\.txt\:595\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𞠃.≯\x{200C}-\x{0714}", %p)},	undef,	"to_unicode\(\'𞠃\.\≯\\u200C\-\\u0714\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:596\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞠃.≯\x{200C}-\x{0714}", %p)},	undef,	"to_unicode\(\'𞠃\.\≯\\u200C\-\\u0714\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:597\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞠃.>\x{0338}\x{200C}-\x{0714}", %p)},	undef,	"to_unicode\(\'𞠃\.\>\\u0338\\u200C\-\\u0714\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:598\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞠃.>\x{0338}\x{200C}-\x{0714}", %p)},	undef,	"to_unicode\(\'𞠃\.\>\\u0338\\u200C\-\\u0714\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:599\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{036D}-。≠𐾢", %p)},	undef,	"to_unicode\(\'\\u036D\-\。\≠𐾢\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:600\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{036D}-。=\x{0338}𐾢", %p)},	undef,	"to_unicode\(\'\\u036D\-\。\=\\u0338𐾢\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:601\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞀪\x{1A60}。\x{200D}𐥚", %p)},	undef,	"to_unicode\(\'𞀪\\u1A60\。\\u200D𐥚\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:602\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞀪\x{1A60}。\x{200D}𐥚", %p)},	undef,	"to_unicode\(\'𞀪\\u1A60\。\\u200D𐥚\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:603\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{059D}\x{AAF6}2｡㧉𱃺", %p)},	undef,	"to_unicode\(\'\\u059D\\uAAF62｡㧉𱃺\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:604\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{AAF6}\x{059D}2｡㧉𱃺", %p)},	undef,	"to_unicode\(\'\\uAAF6\\u059D2｡㧉𱃺\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:605\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{AAF6}\x{059D}2。㧉𱃺", %p)},	undef,	"to_unicode\(\'\\uAAF6\\u059D2\。㧉𱃺\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:606\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񪨑𐹾𞺉。≯6", %p)},	undef,	"to_unicode\(\'\\u200C񪨑𐹾𞺉\。\≯6\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:607\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񪨑𐹾𞺉。≯6", %p)},	undef,	"to_unicode\(\'\\u200C񪨑𐹾𞺉\。\≯6\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:608\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񪨑𐹾𞺉。>\x{0338}6", %p)},	undef,	"to_unicode\(\'\\u200C񪨑𐹾𞺉\。\>\\u03386\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:609\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񪨑𐹾𞺉。>\x{0338}6", %p)},	undef,	"to_unicode\(\'\\u200C񪨑𐹾𞺉\。\>\\u03386\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:610\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񪨑𐹾\x{064A}。≯6", %p)},	undef,	"to_unicode\(\'\\u200C񪨑𐹾\\u064A\。\≯6\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:611\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񪨑𐹾\x{064A}。≯6", %p)},	undef,	"to_unicode\(\'\\u200C񪨑𐹾\\u064A\。\≯6\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:612\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񪨑𐹾\x{064A}。>\x{0338}6", %p)},	undef,	"to_unicode\(\'\\u200C񪨑𐹾\\u064A\。\>\\u03386\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:613\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񪨑𐹾\x{064A}。>\x{0338}6", %p)},	undef,	"to_unicode\(\'\\u200C񪨑𐹾\\u064A\。\>\\u03386\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:614\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1734}．𐹹𛂿-\x{200D}", %p)},	undef,	"to_unicode\(\'\\u1734．𐹹𛂿\-\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:615\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1734}．𐹹𛂿-\x{200D}", %p)},	undef,	"to_unicode\(\'\\u1734．𐹹𛂿\-\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:616\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1734}.𐹹𛂿-\x{200D}", %p)},	undef,	"to_unicode\(\'\\u1734\.𐹹𛂿\-\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:617\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1734}.𐹹𛂿-\x{200D}", %p)},	undef,	"to_unicode\(\'\\u1734\.𐹹𛂿\-\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:618\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🕰ς􍵐｡\x{FFA0}", %p)},	undef,	"to_unicode\(\'🕰ς􍵐｡\\uFFA0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:619\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🕰ς􍵐。\x{1160}", %p)},	undef,	"to_unicode\(\'🕰ς􍵐\。\\u1160\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:620\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🕰Σ􍵐。\x{1160}", %p)},	undef,	"to_unicode\(\'🕰Σ􍵐\。\\u1160\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:621\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🕰σ􍵐。\x{1160}", %p)},	undef,	"to_unicode\(\'🕰σ􍵐\。\\u1160\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:622\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🕰Σ􍵐｡\x{FFA0}", %p)},	undef,	"to_unicode\(\'🕰Σ􍵐｡\\uFFA0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:623\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🕰σ􍵐｡\x{FFA0}", %p)},	undef,	"to_unicode\(\'🕰σ􍵐｡\\uFFA0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:624\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08B1}󠅲𐫟\x{08A1}.𐸛\x{1BAA}Ⴃ", %p)},	undef,	"to_unicode\(\'\\u08B1\󠅲𐫟\\u08A1\.𐸛\\u1BAAႣ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:625\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08B1}󠅲𐫟\x{08A1}.𐸛\x{1BAA}ⴃ", %p)},	undef,	"to_unicode\(\'\\u08B1\󠅲𐫟\\u08A1\.𐸛\\u1BAAⴃ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:626\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹡𑓂-킼.\x{ABED}\x{1C33}\x{06DD}≯", %p)},	undef,	"to_unicode\(\'𐹡𑓂\-킼\.\\uABED\\u1C33\\u06DD\≯\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:627\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹡𑓂-킼.\x{ABED}\x{1C33}\x{06DD}>\x{0338}", %p)},	undef,	"to_unicode\(\'𐹡𑓂\-킼\.\\uABED\\u1C33\\u06DD\>\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:628\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-。ꡇ\x{0667}򹘐\x{0ACD}", %p)},	undef,	"to_unicode\(\'\-\。ꡇ\\u0667򹘐\\u0ACD\'\)\ throws\ error\ P1\ V3\ V6\ B5\ \[data\/IdnaTest\.txt\:629\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}󉡂\x{0F96}．\x{0737}󻨮𐫃𐋡", %p)},	undef,	"to_unicode\(\'\\u200D󉡂\\u0F96．\\u0737󻨮𐫃𐋡\'\)\ throws\ error\ P1\ V6\ V5\ C2\ B1\ \[data\/IdnaTest\.txt\:630\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}󉡂\x{0F96}．\x{0737}󻨮𐫃𐋡", %p)},	undef,	"to_unicode\(\'\\u200D󉡂\\u0F96．\\u0737󻨮𐫃𐋡\'\)\ throws\ error\ P1\ V6\ V5\ C2\ B1\ \[data\/IdnaTest\.txt\:631\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}󉡂\x{0F96}.\x{0737}󻨮𐫃𐋡", %p)},	undef,	"to_unicode\(\'\\u200D󉡂\\u0F96\.\\u0737󻨮𐫃𐋡\'\)\ throws\ error\ P1\ V6\ V5\ C2\ B1\ \[data\/IdnaTest\.txt\:632\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}󉡂\x{0F96}.\x{0737}󻨮𐫃𐋡", %p)},	undef,	"to_unicode\(\'\\u200D󉡂\\u0F96\.\\u0737󻨮𐫃𐋡\'\)\ throws\ error\ P1\ V6\ V5\ C2\ B1\ \[data\/IdnaTest\.txt\:633\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒󷫏ς򔩯｡\x{0644}", %p)},	undef,	"to_unicode\(\'︒󷫏ς򔩯｡\\u0644\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:634\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。󷫏ς򔩯。\x{0644}", %p)},	undef,	"to_unicode\(\'\。󷫏ς򔩯\。\\u0644\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:635\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。󷫏Σ򔩯。\x{0644}", %p)},	undef,	"to_unicode\(\'\。󷫏Σ򔩯\。\\u0644\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:636\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。󷫏σ򔩯。\x{0644}", %p)},	undef,	"to_unicode\(\'\。󷫏σ򔩯\。\\u0644\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:637\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒󷫏Σ򔩯｡\x{0644}", %p)},	undef,	"to_unicode\(\'︒󷫏Σ򔩯｡\\u0644\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:638\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒󷫏σ򔩯｡\x{0644}", %p)},	undef,	"to_unicode\(\'︒󷫏σ򔩯｡\\u0644\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:639\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FD93}．\x{FB73}򾟛≯\x{0B82}", %p)},	undef,	"to_unicode\(\'\\uFD93．\\uFB73򾟛\≯\\u0B82\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:640\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FD93}．\x{FB73}򾟛>\x{0338}\x{0B82}", %p)},	undef,	"to_unicode\(\'\\uFD93．\\uFB73򾟛\>\\u0338\\u0B82\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:641\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0647}\x{0645}\x{062C}.\x{0684}򾟛≯\x{0B82}", %p)},	undef,	"to_unicode\(\'\\u0647\\u0645\\u062C\.\\u0684򾟛\≯\\u0B82\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:642\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0647}\x{0645}\x{062C}.\x{0684}򾟛>\x{0338}\x{0B82}", %p)},	undef,	"to_unicode\(\'\\u0647\\u0645\\u062C\.\\u0684򾟛\>\\u0338\\u0B82\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:643\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0A42}򜖴.𐨝", %p)},	undef,	"to_unicode\(\'\\u0A42򜖴\.𐨝\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:644\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒉💰≠｡Ⴟ□Ⴈ", %p)},	undef,	"to_unicode\(\'⒉💰\≠｡Ⴟ\□Ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:645\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒉💰=\x{0338}｡Ⴟ□Ⴈ", %p)},	undef,	"to_unicode\(\'⒉💰\=\\u0338｡Ⴟ\□Ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:646\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2.💰≠。Ⴟ□Ⴈ", %p)},	undef,	"to_unicode\(\'2\.💰\≠\。Ⴟ\□Ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:647\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2.💰=\x{0338}。Ⴟ□Ⴈ", %p)},	undef,	"to_unicode\(\'2\.💰\=\\u0338\。Ⴟ\□Ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:648\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2.💰=\x{0338}。ⴟ□ⴈ", %p)},	undef,	"to_unicode\(\'2\.💰\=\\u0338\。ⴟ\□ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:649\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2.💰≠。ⴟ□ⴈ", %p)},	undef,	"to_unicode\(\'2\.💰\≠\。ⴟ\□ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:650\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒉💰=\x{0338}｡ⴟ□ⴈ", %p)},	undef,	"to_unicode\(\'⒉💰\=\\u0338｡ⴟ\□ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:651\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒉💰≠｡ⴟ□ⴈ", %p)},	undef,	"to_unicode\(\'⒉💰\≠｡ⴟ\□ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:652\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-𑚫\x{0321}Ⴥ。-\x{0660}𐮩\x{035B}", %p)},	undef,	"to_unicode\(\'\-𑚫\\u0321Ⴥ\。\-\\u0660𐮩\\u035B\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:653\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("-𑚫\x{0321}ⴥ。-\x{0660}𐮩\x{035B}", %p)},	undef,	"to_unicode\(\'\-𑚫\\u0321ⴥ\。\-\\u0660𐮩\\u035B\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:654\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{1B3A}。\x{1B44}︒\x{06AF}\x{0695}", %p)},	undef,	"to_unicode\(\'\\u1B3A\。\\u1B44︒\\u06AF\\u0695\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:655\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{1B3A}。\x{1B44}。\x{06AF}\x{0695}", %p)},	undef,	"to_unicode\(\'\\u1B3A\。\\u1B44\。\\u06AF\\u0695\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:656\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴙᡡ.\x{0FB8}\x{200D}", %p)},	undef,	"to_unicode\(\'Ⴙᡡ\.\\u0FB8\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:657\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴙᡡ.\x{0FB8}\x{200D}", %p)},	undef,	"to_unicode\(\'Ⴙᡡ\.\\u0FB8\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:658\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴙᡡ.\x{0FB8}\x{200D}", %p)},	undef,	"to_unicode\(\'ⴙᡡ\.\\u0FB8\\u200D\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:659\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴙᡡ.\x{0FB8}\x{200D}", %p)},	undef,	"to_unicode\(\'ⴙᡡ\.\\u0FB8\\u200D\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:660\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{FE05}｡₆０𐭧ᠺ", %p)},	undef,	"to_unicode\(\'\\uFE05｡₆０𐭧ᠺ\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:661\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{FE05}。60𐭧ᠺ", %p)},	undef,	"to_unicode\(\'\\uFE05\。60𐭧ᠺ\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:662\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("6\x{072C}｡-\x{20EE}", %p)},	undef,	"to_unicode\(\'6\\u072C｡\-\\u20EE\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:663\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("6\x{072C}。-\x{20EE}", %p)},	undef,	"to_unicode\(\'6\\u072C\。\-\\u20EE\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:664\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}𜳍\x{0662}｡\x{0A4D}ς\x{FDBF}\x{2DEA}", %p)},	undef,	"to_unicode\(\'\\u200D𜳍\\u0662｡\\u0A4Dς\\uFDBF\\u2DEA\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:665\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𜳍\x{0662}｡\x{0A4D}ς\x{FDBF}\x{2DEA}", %p)},	undef,	"to_unicode\(\'\\u200D𜳍\\u0662｡\\u0A4Dς\\uFDBF\\u2DEA\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:666\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𜳍\x{0662}。\x{0A4D}ς\x{062D}\x{062C}\x{064A}\x{2DEA}", %p)},	undef,	"to_unicode\(\'\\u200D𜳍\\u0662\。\\u0A4Dς\\u062D\\u062C\\u064A\\u2DEA\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:667\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𜳍\x{0662}。\x{0A4D}ς\x{062D}\x{062C}\x{064A}\x{2DEA}", %p)},	undef,	"to_unicode\(\'\\u200D𜳍\\u0662\。\\u0A4Dς\\u062D\\u062C\\u064A\\u2DEA\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:668\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𜳍\x{0662}。\x{0A4D}Σ\x{062D}\x{062C}\x{064A}\x{2DEA}", %p)},	undef,	"to_unicode\(\'\\u200D𜳍\\u0662\。\\u0A4DΣ\\u062D\\u062C\\u064A\\u2DEA\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:669\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𜳍\x{0662}。\x{0A4D}Σ\x{062D}\x{062C}\x{064A}\x{2DEA}", %p)},	undef,	"to_unicode\(\'\\u200D𜳍\\u0662\。\\u0A4DΣ\\u062D\\u062C\\u064A\\u2DEA\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:670\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𜳍\x{0662}。\x{0A4D}σ\x{062D}\x{062C}\x{064A}\x{2DEA}", %p)},	undef,	"to_unicode\(\'\\u200D𜳍\\u0662\。\\u0A4Dσ\\u062D\\u062C\\u064A\\u2DEA\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:671\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𜳍\x{0662}。\x{0A4D}σ\x{062D}\x{062C}\x{064A}\x{2DEA}", %p)},	undef,	"to_unicode\(\'\\u200D𜳍\\u0662\。\\u0A4Dσ\\u062D\\u062C\\u064A\\u2DEA\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:672\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𜳍\x{0662}｡\x{0A4D}Σ\x{FDBF}\x{2DEA}", %p)},	undef,	"to_unicode\(\'\\u200D𜳍\\u0662｡\\u0A4DΣ\\uFDBF\\u2DEA\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:673\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𜳍\x{0662}｡\x{0A4D}Σ\x{FDBF}\x{2DEA}", %p)},	undef,	"to_unicode\(\'\\u200D𜳍\\u0662｡\\u0A4DΣ\\uFDBF\\u2DEA\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:674\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𜳍\x{0662}｡\x{0A4D}σ\x{FDBF}\x{2DEA}", %p)},	undef,	"to_unicode\(\'\\u200D𜳍\\u0662｡\\u0A4Dσ\\uFDBF\\u2DEA\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:675\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𜳍\x{0662}｡\x{0A4D}σ\x{FDBF}\x{2DEA}", %p)},	undef,	"to_unicode\(\'\\u200D𜳍\\u0662｡\\u0A4Dσ\\uFDBF\\u2DEA\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:676\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈񊼈Ⴓ⒪．󠁐񥏀𐷵\x{0665}", %p)},	undef,	"to_unicode\(\'⒈񊼈Ⴓ⒪．\󠁐񥏀𐷵\\u0665\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:677\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.񊼈Ⴓ(o).󠁐񥏀𐷵\x{0665}", %p)},	undef,	"to_unicode\(\'1\.񊼈Ⴓ\(o\)\.\󠁐񥏀𐷵\\u0665\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:678\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.񊼈ⴓ(o).󠁐񥏀𐷵\x{0665}", %p)},	undef,	"to_unicode\(\'1\.񊼈ⴓ\(o\)\.\󠁐񥏀𐷵\\u0665\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:679\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.񊼈Ⴓ(O).󠁐񥏀𐷵\x{0665}", %p)},	undef,	"to_unicode\(\'1\.񊼈Ⴓ\(O\)\.\󠁐񥏀𐷵\\u0665\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:680\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈񊼈ⴓ⒪．󠁐񥏀𐷵\x{0665}", %p)},	undef,	"to_unicode\(\'⒈񊼈ⴓ⒪．\󠁐񥏀𐷵\\u0665\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:681\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0772}.\x{0855}𞯝𐹰𐫐", %p)},	undef,	"to_unicode\(\'\\u0772\.\\u0855𞯝𐹰𐫐\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:682\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FC92}-｡𐨿񔅥", %p)},	undef,	"to_unicode\(\'\\uFC92\-｡𐨿񔅥\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B3\ \[data\/IdnaTest\.txt\:683\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{064A}\x{0632}-。𐨿񔅥", %p)},	undef,	"to_unicode\(\'\\u064A\\u0632\-\。𐨿񔅥\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B3\ \[data\/IdnaTest\.txt\:684\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-󠧚ꡐ．\x{1DEF}𜒩🄉", %p)},	undef,	"to_unicode\(\'\-\󠧚ꡐ．\\u1DEF𜒩🄉\'\)\ throws\ error\ P1\ V3\ V6\ V5\ \[data\/IdnaTest\.txt\:685\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-󠧚ꡐ.\x{1DEF}𜒩8,", %p)},	undef,	"to_unicode\(\'\-\󠧚ꡐ\.\\u1DEF𜒩8\,\'\)\ throws\ error\ P1\ V3\ V6\ V5\ \[data\/IdnaTest\.txt\:686\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🏧󠗑󰭊􋱔.ᡥ𝟝", %p)},	undef,	"to_unicode\(\'🏧\󠗑󰭊􋱔\.ᡥ𝟝\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:687\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🏧󠗑󰭊􋱔.ᡥ5", %p)},	undef,	"to_unicode\(\'🏧\󠗑󰭊􋱔\.ᡥ5\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:688\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{066C}．\x{FE0F}", %p)},	undef,	"to_unicode\(\'\≮\\u066C．\\uFE0F\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:689\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{066C}．\x{FE0F}", %p)},	undef,	"to_unicode\(\'\<\\u0338\\u066C．\\uFE0F\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:690\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{066C}.\x{FE0F}", %p)},	undef,	"to_unicode\(\'\≮\\u066C\.\\uFE0F\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:691\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{066C}.\x{FE0F}", %p)},	undef,	"to_unicode\(\'\<\\u0338\\u066C\.\\uFE0F\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:692\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹭ᯛ\x{1BF3}｡脥", %p)},	undef,	"to_unicode\(\'𐹭ᯛ\\u1BF3｡脥\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:693\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹭ᯛ\x{1BF3}。脥", %p)},	undef,	"to_unicode\(\'𐹭ᯛ\\u1BF3\。脥\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:694\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{1BF3}\x{115F}𞣱򃜐.-", %p)},	undef,	"to_unicode\(\'\\u1BF3\\u115F𞣱򃜐\.\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B5\ \[data\/IdnaTest\.txt\:695\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{200C}｡\x{AAED}", %p)},	undef,	"to_unicode\(\'\\u200C｡\\uAAED\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:696\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{200C}｡\x{AAED}", %p)},	undef,	"to_unicode\(\'\\u200C｡\\uAAED\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:697\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{200C}。\x{AAED}", %p)},	undef,	"to_unicode\(\'\\u200C\。\\uAAED\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:698\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{200C}。\x{AAED}", %p)},	undef,	"to_unicode\(\'\\u200C\。\\uAAED\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:699\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{077A}𑒺．𐫎Ⴎ", %p)},	undef,	"to_unicode\(\'\\u077A𑒺．𐫎Ⴎ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:700\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{077A}𑒺.𐫎Ⴎ", %p)},	undef,	"to_unicode\(\'\\u077A𑒺\.𐫎Ⴎ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:701\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{077A}𑒺.𐫎ⴎ", %p)},	undef,	"to_unicode\(\'\\u077A𑒺\.𐫎ⴎ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:702\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{077A}𑒺．𐫎ⴎ", %p)},	undef,	"to_unicode\(\'\\u077A𑒺．𐫎ⴎ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:703\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{07DD}\x{1921}Ξ．蚗㛨󠫺", %p)},	undef,	"to_unicode\(\'\\u07DD\\u1921Ξ．蚗㛨\󠫺\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:704\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07DD}\x{1921}Ξ.蚗㛨󠫺", %p)},	undef,	"to_unicode\(\'\\u07DD\\u1921Ξ\.蚗㛨\󠫺\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:705\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07DD}\x{1921}ξ.蚗㛨󠫺", %p)},	undef,	"to_unicode\(\'\\u07DD\\u1921ξ\.蚗㛨\󠫺\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:706\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07DD}\x{1921}ξ．蚗㛨󠫺", %p)},	undef,	"to_unicode\(\'\\u07DD\\u1921ξ．蚗㛨\󠫺\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:707\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡Ⴛ\x{083F}︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡Ⴛ\\u083F︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:708\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡Ⴛ\x{083F}︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡Ⴛ\\u083F︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:709\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡Ⴛ\x{083F}︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡Ⴛ\\u083F︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:710\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡Ⴛ\x{083F}︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡Ⴛ\\u083F︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:711\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。Ⴛ\x{083F}。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-\。Ⴛ\\u083F\。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:712\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。Ⴛ\x{083F}。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-\。Ⴛ\\u083F\。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:713\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。Ⴛ\x{083F}。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-\。Ⴛ\\u083F\。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:714\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。Ⴛ\x{083F}。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-\。Ⴛ\\u083F\。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:715\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。ⴛ\x{083F}。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-\。ⴛ\\u083F\。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:716\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。ⴛ\x{083F}。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-\。ⴛ\\u083F\。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:717\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。ⴛ\x{083F}。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-\。ⴛ\\u083F\。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:718\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。ⴛ\x{083F}。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-\。ⴛ\\u083F\。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:719\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡ⴛ\x{083F}︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡ⴛ\\u083F︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:720\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡ⴛ\x{083F}︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡ⴛ\\u083F︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:721\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡ⴛ\x{083F}︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡ⴛ\\u083F︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:722\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡ⴛ\x{083F}︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡ⴛ\\u083F︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:723\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠵜.︒󠲅\x{200C}𐹽", %p)},	undef,	"to_unicode\(\'\󠵜\.︒\󠲅\\u200C𐹽\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:724\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠵜.︒󠲅\x{200C}𐹽", %p)},	undef,	"to_unicode\(\'\󠵜\.︒\󠲅\\u200C𐹽\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:725\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠵜.。󠲅\x{200C}𐹽", %p)},	undef,	"to_unicode\(\'\󠵜\.\。\󠲅\\u200C𐹽\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ C1\ \[data\/IdnaTest\.txt\:726\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠵜.。󠲅\x{200C}𐹽", %p)},	undef,	"to_unicode\(\'\󠵜\.\。\󠲅\\u200C𐹽\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ C1\ \[data\/IdnaTest\.txt\:727\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FC48}.𐹢Ⴑ񣞍\x{0765}", %p)},	undef,	"to_unicode\(\'\\uFC48\.𐹢Ⴑ񣞍\\u0765\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:728\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0645}\x{0645}.𐹢Ⴑ񣞍\x{0765}", %p)},	undef,	"to_unicode\(\'\\u0645\\u0645\.𐹢Ⴑ񣞍\\u0765\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:729\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0645}\x{0645}.𐹢ⴑ񣞍\x{0765}", %p)},	undef,	"to_unicode\(\'\\u0645\\u0645\.𐹢ⴑ񣞍\\u0765\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:730\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FC48}.𐹢ⴑ񣞍\x{0765}", %p)},	undef,	"to_unicode\(\'\\uFC48\.𐹢ⴑ񣞍\\u0765\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:731\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠁁𼉗．𝟭Ⴛ", %p)},	undef,	"to_unicode\(\'\󠁁𼉗．𝟭Ⴛ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:732\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠁁𼉗.1Ⴛ", %p)},	undef,	"to_unicode\(\'\󠁁𼉗\.1Ⴛ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:733\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠁁𼉗.1ⴛ", %p)},	undef,	"to_unicode\(\'\󠁁𼉗\.1ⴛ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:734\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠁁𼉗．𝟭ⴛ", %p)},	undef,	"to_unicode\(\'\󠁁𼉗．𝟭ⴛ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:735\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("-\x{1A65}齀。릿\x{0637}", %p)},	undef,	"to_unicode\(\'\-\\u1A65齀\。릿\\u0637\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:736\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("-\x{1A65}齀。릿\x{0637}", %p)},	undef,	"to_unicode\(\'\-\\u1A65齀\。릿\\u0637\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:737\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("󠇕\x{0687}鹝꾗。񺧞\x{200D}\x{200D}⏃", %p)},	undef,	"to_unicode\(\'\󠇕\\u0687鹝꾗\。񺧞\\u200D\\u200D\⏃\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:738\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠇕\x{0687}鹝꾗。񺧞\x{200D}\x{200D}⏃", %p)},	undef,	"to_unicode\(\'\󠇕\\u0687鹝꾗\。񺧞\\u200D\\u200D\⏃\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:739\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠇕\x{0687}鹝꾗。񺧞\x{200D}\x{200D}⏃", %p)},	undef,	"to_unicode\(\'\󠇕\\u0687鹝꾗\。񺧞\\u200D\\u200D\⏃\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:740\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠇕\x{0687}鹝꾗。񺧞\x{200D}\x{200D}⏃", %p)},	undef,	"to_unicode\(\'\󠇕\\u0687鹝꾗\。񺧞\\u200D\\u200D\⏃\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:741\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮．-𐻡--", %p)},	undef,	"to_unicode\(\'\≮．\-𐻡\-\-\'\)\ throws\ error\ P1\ V6\ V2\ V3\ B1\ \[data\/IdnaTest\.txt\:742\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}．-𐻡--", %p)},	undef,	"to_unicode\(\'\<\\u0338．\-𐻡\-\-\'\)\ throws\ error\ P1\ V6\ V2\ V3\ B1\ \[data\/IdnaTest\.txt\:743\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮.-𐻡--", %p)},	undef,	"to_unicode\(\'\≮\.\-𐻡\-\-\'\)\ throws\ error\ P1\ V6\ V2\ V3\ B1\ \[data\/IdnaTest\.txt\:744\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}.-𐻡--", %p)},	undef,	"to_unicode\(\'\<\\u0338\.\-𐻡\-\-\'\)\ throws\ error\ P1\ V6\ V2\ V3\ B1\ \[data\/IdnaTest\.txt\:745\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0664}⭼。\x{200D}ς𝟩", %p)},	undef,	"to_unicode\(\'\\u0664\⭼\。\\u200Dς𝟩\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:746\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0664}⭼。\x{200D}ς𝟩", %p)},	undef,	"to_unicode\(\'\\u0664\⭼\。\\u200Dς𝟩\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:747\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0664}⭼。\x{200D}ς7", %p)},	undef,	"to_unicode\(\'\\u0664\⭼\。\\u200Dς7\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:748\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0664}⭼。\x{200D}ς7", %p)},	undef,	"to_unicode\(\'\\u0664\⭼\。\\u200Dς7\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:749\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0664}⭼。\x{200D}Σ7", %p)},	undef,	"to_unicode\(\'\\u0664\⭼\。\\u200DΣ7\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:750\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0664}⭼。\x{200D}Σ7", %p)},	undef,	"to_unicode\(\'\\u0664\⭼\。\\u200DΣ7\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:751\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0664}⭼。\x{200D}σ7", %p)},	undef,	"to_unicode\(\'\\u0664\⭼\。\\u200Dσ7\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:752\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0664}⭼。\x{200D}σ7", %p)},	undef,	"to_unicode\(\'\\u0664\⭼\。\\u200Dσ7\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:753\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0664}⭼。\x{200D}Σ𝟩", %p)},	undef,	"to_unicode\(\'\\u0664\⭼\。\\u200DΣ𝟩\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:754\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0664}⭼。\x{200D}Σ𝟩", %p)},	undef,	"to_unicode\(\'\\u0664\⭼\。\\u200DΣ𝟩\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:755\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0664}⭼。\x{200D}σ𝟩", %p)},	undef,	"to_unicode\(\'\\u0664\⭼\。\\u200Dσ𝟩\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:756\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0664}⭼。\x{200D}σ𝟩", %p)},	undef,	"to_unicode\(\'\\u0664\⭼\。\\u200Dσ𝟩\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:757\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ς񩓤８.𞫘", %p)},	undef,	"to_unicode\(\'ς񩓤８\.𞫘\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:758\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς񩓤8.𞫘", %p)},	undef,	"to_unicode\(\'ς񩓤8\.𞫘\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:759\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ񩓤8.𞫘", %p)},	undef,	"to_unicode\(\'Σ񩓤8\.𞫘\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:760\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ񩓤8.𞫘", %p)},	undef,	"to_unicode\(\'σ񩓤8\.𞫘\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:761\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ񩓤８.𞫘", %p)},	undef,	"to_unicode\(\'Σ񩓤８\.𞫘\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:762\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ񩓤８.𞫘", %p)},	undef,	"to_unicode\(\'σ񩓤８\.𞫘\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:763\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{07CE}🄀\x{0843}．-\x{07E6}𑌁", %p)},	undef,	"to_unicode\(\'\\u200C\\u07CE🄀\\u0843．\-\\u07E6𑌁\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:764\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{07CE}🄀\x{0843}．-\x{07E6}𑌁", %p)},	undef,	"to_unicode\(\'\\u200C\\u07CE🄀\\u0843．\-\\u07E6𑌁\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:765\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200C}\x{07CE}0.\x{0843}.-\x{07E6}𑌁", %p)},	undef,	"to_unicode\(\'\\u200C\\u07CE0\.\\u0843\.\-\\u07E6𑌁\'\)\ throws\ error\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:766\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200C}\x{07CE}0.\x{0843}.-\x{07E6}𑌁", %p)},	undef,	"to_unicode\(\'\\u200C\\u07CE0\.\\u0843\.\-\\u07E6𑌁\'\)\ throws\ error\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:767\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("􉿃。𞸝넯򆰡", %p)},	undef,	"to_unicode\(\'􉿃\。𞸝넯򆰡\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:768\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("􉿃。𞸝넯򆰡", %p)},	undef,	"to_unicode\(\'􉿃\。𞸝넯򆰡\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:769\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("􉿃。\x{06BA}넯򆰡", %p)},	undef,	"to_unicode\(\'􉿃\。\\u06BA넯򆰡\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:770\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("􉿃。\x{06BA}넯򆰡", %p)},	undef,	"to_unicode\(\'􉿃\。\\u06BA넯򆰡\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:771\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡇႸ。\x{0600}Ⴈ\x{08F9}", %p)},	undef,	"to_unicode\(\'ᡇႸ\。\\u0600Ⴈ\\u08F9\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:772\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡇⴘ。\x{0600}ⴈ\x{08F9}", %p)},	undef,	"to_unicode\(\'ᡇⴘ\。\\u0600ⴈ\\u08F9\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:773\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒚♰\x{08B0}。牣𐹤Ⴜᣥ", %p)},	undef,	"to_unicode\(\'⒚\♰\\u08B0\。牣𐹤Ⴜᣥ\'\)\ throws\ error\ P1\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:774\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("19.♰\x{08B0}。牣𐹤Ⴜᣥ", %p)},	undef,	"to_unicode\(\'19\.\♰\\u08B0\。牣𐹤Ⴜᣥ\'\)\ throws\ error\ P1\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:775\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("19.♰\x{08B0}。牣𐹤ⴜᣥ", %p)},	undef,	"to_unicode\(\'19\.\♰\\u08B0\。牣𐹤ⴜᣥ\'\)\ throws\ error\ B1\ B5\ \[data\/IdnaTest\.txt\:776\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⒚♰\x{08B0}。牣𐹤ⴜᣥ", %p)},	undef,	"to_unicode\(\'⒚\♰\\u08B0\。牣𐹤ⴜᣥ\'\)\ throws\ error\ P1\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:777\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-𐋱𞧐⒈.Ⴓ", %p)},	undef,	"to_unicode\(\'\-𐋱𞧐⒈\.Ⴓ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:778\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-𐋱𞧐1..Ⴓ", %p)},	undef,	"to_unicode\(\'\-𐋱𞧐1\.\.Ⴓ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ A4_2\ \[data\/IdnaTest\.txt\:779\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-𐋱𞧐1..ⴓ", %p)},	undef,	"to_unicode\(\'\-𐋱𞧐1\.\.ⴓ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ A4_2\ \[data\/IdnaTest\.txt\:780\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-𐋱𞧐⒈.ⴓ", %p)},	undef,	"to_unicode\(\'\-𐋱𞧐⒈\.ⴓ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:781\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}긃.󰎽-", %p)},	undef,	"to_unicode\(\'\\u200C긃\.󰎽\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:782\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}긃.󰎽-", %p)},	undef,	"to_unicode\(\'\\u200C긃\.󰎽\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:783\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}긃.󰎽-", %p)},	undef,	"to_unicode\(\'\\u200C긃\.󰎽\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:784\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}긃.󰎽-", %p)},	undef,	"to_unicode\(\'\\u200C긃\.󰎽\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:785\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("뉓泓񢊆.𑘿\x{200D}", %p)},	undef,	"to_unicode\(\'뉓泓񢊆\.𑘿\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:786\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("뉓泓񢊆.𑘿\x{200D}", %p)},	undef,	"to_unicode\(\'뉓泓񢊆\.𑘿\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:787\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹾ß｡𝨾\x{2B75}򨟲", %p)},	undef,	"to_unicode\(\'\\u200D𐹾ß｡𝨾\\u2B75򨟲\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:788\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹾ß｡𝨾\x{2B75}򨟲", %p)},	undef,	"to_unicode\(\'\\u200D𐹾ß｡𝨾\\u2B75򨟲\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:789\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹾ß。𝨾\x{2B75}򨟲", %p)},	undef,	"to_unicode\(\'\\u200D𐹾ß\。𝨾\\u2B75򨟲\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:790\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹾ß。𝨾\x{2B75}򨟲", %p)},	undef,	"to_unicode\(\'\\u200D𐹾ß\。𝨾\\u2B75򨟲\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:791\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹾SS。𝨾\x{2B75}򨟲", %p)},	undef,	"to_unicode\(\'\\u200D𐹾SS\。𝨾\\u2B75򨟲\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:792\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹾SS。𝨾\x{2B75}򨟲", %p)},	undef,	"to_unicode\(\'\\u200D𐹾SS\。𝨾\\u2B75򨟲\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:793\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹾ss。𝨾\x{2B75}򨟲", %p)},	undef,	"to_unicode\(\'\\u200D𐹾ss\。𝨾\\u2B75򨟲\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:794\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹾ss。𝨾\x{2B75}򨟲", %p)},	undef,	"to_unicode\(\'\\u200D𐹾ss\。𝨾\\u2B75򨟲\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:795\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹾Ss。𝨾\x{2B75}򨟲", %p)},	undef,	"to_unicode\(\'\\u200D𐹾Ss\。𝨾\\u2B75򨟲\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:796\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹾Ss。𝨾\x{2B75}򨟲", %p)},	undef,	"to_unicode\(\'\\u200D𐹾Ss\。𝨾\\u2B75򨟲\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:797\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹾SS｡𝨾\x{2B75}򨟲", %p)},	undef,	"to_unicode\(\'\\u200D𐹾SS｡𝨾\\u2B75򨟲\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:798\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹾SS｡𝨾\x{2B75}򨟲", %p)},	undef,	"to_unicode\(\'\\u200D𐹾SS｡𝨾\\u2B75򨟲\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:799\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹾ss｡𝨾\x{2B75}򨟲", %p)},	undef,	"to_unicode\(\'\\u200D𐹾ss｡𝨾\\u2B75򨟲\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:800\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹾ss｡𝨾\x{2B75}򨟲", %p)},	undef,	"to_unicode\(\'\\u200D𐹾ss｡𝨾\\u2B75򨟲\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:801\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹾Ss｡𝨾\x{2B75}򨟲", %p)},	undef,	"to_unicode\(\'\\u200D𐹾Ss｡𝨾\\u2B75򨟲\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:802\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹾Ss｡𝨾\x{2B75}򨟲", %p)},	undef,	"to_unicode\(\'\\u200D𐹾Ss｡𝨾\\u2B75򨟲\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:803\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0ACD}．𐨿-≮≠", %p)},	undef,	"to_unicode\(\'\\u0ACD．𐨿\-\≮\≠\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:804\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0ACD}．𐨿-<\x{0338}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0ACD．𐨿\-\<\\u0338\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:805\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0ACD}.𐨿-≮≠", %p)},	undef,	"to_unicode\(\'\\u0ACD\.𐨿\-\≮\≠\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:806\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0ACD}.𐨿-<\x{0338}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0ACD\.𐨿\-\<\\u0338\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:807\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2D7F}Ⴑ\x{115F}．𑖿Ⅎ", %p)},	undef,	"to_unicode\(\'\\u2D7FႱ\\u115F．𑖿Ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:808\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2D7F}Ⴑ\x{115F}.𑖿Ⅎ", %p)},	undef,	"to_unicode\(\'\\u2D7FႱ\\u115F\.𑖿Ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:809\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2D7F}ⴑ\x{115F}.𑖿ⅎ", %p)},	undef,	"to_unicode\(\'\\u2D7Fⴑ\\u115F\.𑖿ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:810\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2D7F}Ⴑ\x{115F}.𑖿ⅎ", %p)},	undef,	"to_unicode\(\'\\u2D7FႱ\\u115F\.𑖿ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:811\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2D7F}ⴑ\x{115F}．𑖿ⅎ", %p)},	undef,	"to_unicode\(\'\\u2D7Fⴑ\\u115F．𑖿ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:812\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2D7F}Ⴑ\x{115F}．𑖿ⅎ", %p)},	undef,	"to_unicode\(\'\\u2D7FႱ\\u115F．𑖿ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:813\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󖗚。Ⴃ𐳖\x{0601}똯", %p)},	undef,	"to_unicode\(\'󖗚\。Ⴃ𐳖\\u0601똯\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:814\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󖗚。Ⴃ𐳖\x{0601}똯", %p)},	undef,	"to_unicode\(\'󖗚\。Ⴃ𐳖\\u0601똯\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:815\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󖗚。ⴃ𐳖\x{0601}똯", %p)},	undef,	"to_unicode\(\'󖗚\。ⴃ𐳖\\u0601똯\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:816\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󖗚。ⴃ𐳖\x{0601}똯", %p)},	undef,	"to_unicode\(\'󖗚\。ⴃ𐳖\\u0601똯\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:817\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢥ｡⳻󠷡󠆏\x{3164}", %p)},	undef,	"to_unicode\(\'ᢥ｡⳻\󠷡\󠆏\\u3164\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:818\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢥ。⳻󠷡󠆏\x{1160}", %p)},	undef,	"to_unicode\(\'ᢥ\。⳻\󠷡\󠆏\\u1160\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:819\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐼣⾇．ᡙ-𐋰", %p)},	undef,	"to_unicode\(\'𐼣⾇．ᡙ\-𐋰\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:820\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐼣舛.ᡙ-𐋰", %p)},	undef,	"to_unicode\(\'𐼣舛\.ᡙ\-𐋰\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:821\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴉ猕󝌩≮．︒", %p)},	undef,	"to_unicode\(\'Ⴉ猕󝌩\≮．︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:822\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴉ猕󝌩<\x{0338}．︒", %p)},	undef,	"to_unicode\(\'Ⴉ猕󝌩\<\\u0338．︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:823\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴉ猕󝌩≮.。", %p)},	undef,	"to_unicode\(\'Ⴉ猕󝌩\≮\.\。\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:824\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴉ猕󝌩<\x{0338}.。", %p)},	undef,	"to_unicode\(\'Ⴉ猕󝌩\<\\u0338\.\。\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:825\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴉ猕󝌩<\x{0338}.。", %p)},	undef,	"to_unicode\(\'ⴉ猕󝌩\<\\u0338\.\。\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:826\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴉ猕󝌩≮.。", %p)},	undef,	"to_unicode\(\'ⴉ猕󝌩\≮\.\。\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:827\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴉ猕󝌩<\x{0338}．︒", %p)},	undef,	"to_unicode\(\'ⴉ猕󝌩\<\\u0338．︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:828\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴉ猕󝌩≮．︒", %p)},	undef,	"to_unicode\(\'ⴉ猕󝌩\≮．︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:829\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("🜙｡\x{0635}鳳ꡱ\x{08FC}", %p)},	undef,	"to_unicode\(\'🜙｡\\u0635鳳ꡱ\\u08FC\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:830\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("🜙。\x{0635}鳳ꡱ\x{08FC}", %p)},	undef,	"to_unicode\(\'🜙\。\\u0635鳳ꡱ\\u08FC\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:831\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}𐹮。ß", %p)},	undef,	"to_unicode\(\'\\u200D𐹮\。ß\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:832\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}𐹮。ß", %p)},	undef,	"to_unicode\(\'\\u200D𐹮\。ß\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:833\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}𐹮。SS", %p)},	undef,	"to_unicode\(\'\\u200D𐹮\。SS\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:834\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}𐹮。SS", %p)},	undef,	"to_unicode\(\'\\u200D𐹮\。SS\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:835\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Å둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'Å둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:836\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Å둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'Å둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:837\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{030A}둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'A\\u030A둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:838\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{030A}둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'A\\u030A둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:839\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Å둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'Å둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:840\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Å둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'Å둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:841\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{030A}둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'A\\u030A둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:842\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{030A}둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'A\\u030A둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:843\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{030A}둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'a\\u030A둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:844\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{030A}둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'a\\u030A둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:845\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("å둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'å둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:846\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("å둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'å둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:847\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{030A}둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'a\\u030A둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:848\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{030A}둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'a\\u030A둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:849\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("å둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'å둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:850\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("å둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'å둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:851\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{035F}󪒅󠆬ᢐ.󈌵-\x{A8EB}", %p)},	undef,	"to_unicode\(\'\\u035F󪒅\󠆬ᢐ\.󈌵\-\\uA8EB\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:852\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ς.ß𣽞\x{0668}𑓂", %p)},	undef,	"to_unicode\(\'ς\.ß𣽞\\u0668𑓂\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:853\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ς.ß𣽞\x{0668}𑓂", %p)},	undef,	"to_unicode\(\'ς\.ß𣽞\\u0668𑓂\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:854\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("Σ.SS𣽞\x{0668}𑓂", %p)},	undef,	"to_unicode\(\'Σ\.SS𣽞\\u0668𑓂\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:855\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("σ.ss𣽞\x{0668}𑓂", %p)},	undef,	"to_unicode\(\'σ\.ss𣽞\\u0668𑓂\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:856\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("Σ.ss𣽞\x{0668}𑓂", %p)},	undef,	"to_unicode\(\'Σ\.ss𣽞\\u0668𑓂\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:857\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("Σ.ß𣽞\x{0668}𑓂", %p)},	undef,	"to_unicode\(\'Σ\.ß𣽞\\u0668𑓂\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:858\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("σ.ß𣽞\x{0668}𑓂", %p)},	undef,	"to_unicode\(\'σ\.ß𣽞\\u0668𑓂\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:859\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("Σ.SS𣽞\x{0668}𑓂", %p)},	undef,	"to_unicode\(\'Σ\.SS𣽞\\u0668𑓂\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:860\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("σ.ss𣽞\x{0668}𑓂", %p)},	undef,	"to_unicode\(\'σ\.ss𣽞\\u0668𑓂\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:861\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("Σ.ss𣽞\x{0668}𑓂", %p)},	undef,	"to_unicode\(\'Σ\.ss𣽞\\u0668𑓂\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:862\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("Σ.ß𣽞\x{0668}𑓂", %p)},	undef,	"to_unicode\(\'Σ\.ß𣽞\\u0668𑓂\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:863\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("σ.ß𣽞\x{0668}𑓂", %p)},	undef,	"to_unicode\(\'σ\.ß𣽞\\u0668𑓂\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:864\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{06EF}󠄚｡𐹫𑂁", %p)},	undef,	"to_unicode\(\'\\u06EF\󠄚｡𐹫𑂁\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:865\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{06EF}󠄚。𐹫𑂁", %p)},	undef,	"to_unicode\(\'\\u06EF\󠄚\。𐹫𑂁\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:866\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("񊧏\x{200C}𞭭｡௸񗷞-\x{FD57}", %p)},	undef,	"to_unicode\(\'񊧏\\u200C𞭭｡௸񗷞\-\\uFD57\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:867\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񊧏\x{200C}𞭭｡௸񗷞-\x{FD57}", %p)},	undef,	"to_unicode\(\'񊧏\\u200C𞭭｡௸񗷞\-\\uFD57\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:868\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񊧏\x{200C}𞭭。௸񗷞-\x{062A}\x{0645}\x{062E}", %p)},	undef,	"to_unicode\(\'񊧏\\u200C𞭭\。௸񗷞\-\\u062A\\u0645\\u062E\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:869\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񊧏\x{200C}𞭭。௸񗷞-\x{062A}\x{0645}\x{062E}", %p)},	undef,	"to_unicode\(\'񊧏\\u200C𞭭\。௸񗷞\-\\u062A\\u0645\\u062E\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:870\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("룱\x{200D}𞳕\x{200C}。\x{0485}︒", %p)},	undef,	"to_unicode\(\'룱\\u200D𞳕\\u200C\。\\u0485︒\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ C2\ C1\ \[data\/IdnaTest\.txt\:871\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("룱\x{200D}𞳕\x{200C}。\x{0485}︒", %p)},	undef,	"to_unicode\(\'룱\\u200D𞳕\\u200C\。\\u0485︒\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ C2\ C1\ \[data\/IdnaTest\.txt\:872\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("룱\x{200D}𞳕\x{200C}。\x{0485}︒", %p)},	undef,	"to_unicode\(\'룱\\u200D𞳕\\u200C\。\\u0485︒\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ C2\ C1\ \[data\/IdnaTest\.txt\:873\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("룱\x{200D}𞳕\x{200C}。\x{0485}︒", %p)},	undef,	"to_unicode\(\'룱\\u200D𞳕\\u200C\。\\u0485︒\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ C2\ C1\ \[data\/IdnaTest\.txt\:874\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("룱\x{200D}𞳕\x{200C}。\x{0485}。", %p)},	undef,	"to_unicode\(\'룱\\u200D𞳕\\u200C\。\\u0485\。\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ C2\ C1\ \[data\/IdnaTest\.txt\:875\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("룱\x{200D}𞳕\x{200C}。\x{0485}。", %p)},	undef,	"to_unicode\(\'룱\\u200D𞳕\\u200C\。\\u0485\。\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ C2\ C1\ \[data\/IdnaTest\.txt\:876\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("룱\x{200D}𞳕\x{200C}。\x{0485}。", %p)},	undef,	"to_unicode\(\'룱\\u200D𞳕\\u200C\。\\u0485\。\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ C2\ C1\ \[data\/IdnaTest\.txt\:877\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("룱\x{200D}𞳕\x{200C}。\x{0485}。", %p)},	undef,	"to_unicode\(\'룱\\u200D𞳕\\u200C\。\\u0485\。\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ C2\ C1\ \[data\/IdnaTest\.txt\:878\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄄．\x{FE03}⒈ß", %p)},	undef,	"to_unicode\(\'🄄．\\uFE03⒈ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:879\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("3,.\x{FE03}1.ß", %p)},	undef,	"to_unicode\(\'3\,\.\\uFE031\.ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:880\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("3,.\x{FE03}1.SS", %p)},	undef,	"to_unicode\(\'3\,\.\\uFE031\.SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:881\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄄．\x{FE03}⒈SS", %p)},	undef,	"to_unicode\(\'🄄．\\uFE03⒈SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:882\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄄．\x{FE03}⒈ss", %p)},	undef,	"to_unicode\(\'🄄．\\uFE03⒈ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:883\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄄．\x{FE03}⒈Ss", %p)},	undef,	"to_unicode\(\'🄄．\\uFE03⒈Ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:884\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򢋻𑄳｡𐰕񷒾\x{FEFF}", %p)},	undef,	"to_unicode\(\'򢋻𑄳｡𐰕񷒾\\uFEFF\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:885\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򢋻𑄳。𐰕񷒾\x{FEFF}", %p)},	undef,	"to_unicode\(\'򢋻𑄳\。𐰕񷒾\\uFEFF\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:886\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1A73}\x{094D}\x{1BF2}．≠\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u1A73\\u094D\\u1BF2．\≠\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:887\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1A73}\x{094D}\x{1BF2}．≠\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u1A73\\u094D\\u1BF2．\≠\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:888\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1A73}\x{094D}\x{1BF2}．=\x{0338}\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u1A73\\u094D\\u1BF2．\=\\u0338\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:889\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1A73}\x{094D}\x{1BF2}．=\x{0338}\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u1A73\\u094D\\u1BF2．\=\\u0338\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:890\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1A73}\x{094D}\x{1BF2}.≠\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u1A73\\u094D\\u1BF2\.\≠\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:891\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1A73}\x{094D}\x{1BF2}.≠\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u1A73\\u094D\\u1BF2\.\≠\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:892\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1A73}\x{094D}\x{1BF2}.=\x{0338}\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u1A73\\u094D\\u1BF2\.\=\\u0338\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:893\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1A73}\x{094D}\x{1BF2}.=\x{0338}\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u1A73\\u094D\\u1BF2\.\=\\u0338\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:894\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴁ𐋨娤.\x{200D}\x{0981}\x{0601}\x{0A70}", %p)},	undef,	"to_unicode\(\'Ⴁ𐋨娤\.\\u200D\\u0981\\u0601\\u0A70\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:895\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴁ𐋨娤.\x{200D}\x{0981}\x{0601}\x{0A70}", %p)},	undef,	"to_unicode\(\'Ⴁ𐋨娤\.\\u200D\\u0981\\u0601\\u0A70\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:896\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴁ𐋨娤.\x{200D}\x{0981}\x{0601}\x{0A70}", %p)},	undef,	"to_unicode\(\'ⴁ𐋨娤\.\\u200D\\u0981\\u0601\\u0A70\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:897\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴁ𐋨娤.\x{200D}\x{0981}\x{0601}\x{0A70}", %p)},	undef,	"to_unicode\(\'ⴁ𐋨娤\.\\u200D\\u0981\\u0601\\u0A70\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:898\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄀Ⴄ𐹾󠅩。⒈\x{0736}ß", %p)},	undef,	"to_unicode\(\'🄀Ⴄ𐹾\󠅩\。⒈\\u0736ß\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:899\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0.Ⴄ𐹾󠅩。1.\x{0736}ß", %p)},	undef,	"to_unicode\(\'0\.Ⴄ𐹾\󠅩\。1\.\\u0736ß\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:900\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("0.ⴄ𐹾󠅩。1.\x{0736}ß", %p)},	undef,	"to_unicode\(\'0\.ⴄ𐹾\󠅩\。1\.\\u0736ß\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:901\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("0.Ⴄ𐹾󠅩。1.\x{0736}SS", %p)},	undef,	"to_unicode\(\'0\.Ⴄ𐹾\󠅩\。1\.\\u0736SS\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:902\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("0.ⴄ𐹾󠅩。1.\x{0736}ss", %p)},	undef,	"to_unicode\(\'0\.ⴄ𐹾\󠅩\。1\.\\u0736ss\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:903\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("0.Ⴄ𐹾󠅩。1.\x{0736}Ss", %p)},	undef,	"to_unicode\(\'0\.Ⴄ𐹾\󠅩\。1\.\\u0736Ss\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:904\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄀ⴄ𐹾󠅩。⒈\x{0736}ß", %p)},	undef,	"to_unicode\(\'🄀ⴄ𐹾\󠅩\。⒈\\u0736ß\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:905\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄀Ⴄ𐹾󠅩。⒈\x{0736}SS", %p)},	undef,	"to_unicode\(\'🄀Ⴄ𐹾\󠅩\。⒈\\u0736SS\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:906\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄀ⴄ𐹾󠅩。⒈\x{0736}ss", %p)},	undef,	"to_unicode\(\'🄀ⴄ𐹾\󠅩\。⒈\\u0736ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:907\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄀Ⴄ𐹾󠅩。⒈\x{0736}Ss", %p)},	undef,	"to_unicode\(\'🄀Ⴄ𐹾\󠅩\。⒈\\u0736Ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:908\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠.\x{200C}-𐹸", %p)},	undef,	"to_unicode\(\'\≠\.\\u200C\-𐹸\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:909\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠.\x{200C}-𐹸", %p)},	undef,	"to_unicode\(\'\≠\.\\u200C\-𐹸\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:910\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}.\x{200C}-𐹸", %p)},	undef,	"to_unicode\(\'\=\\u0338\.\\u200C\-𐹸\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:911\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}.\x{200C}-𐹸", %p)},	undef,	"to_unicode\(\'\=\\u0338\.\\u200C\-𐹸\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:912\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0665}۱｡\x{180B}𐡼\x{0663}", %p)},	undef,	"to_unicode\(\'\\u0665۱｡\\u180B𐡼\\u0663\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:913\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0665}۱。\x{180B}𐡼\x{0663}", %p)},	undef,	"to_unicode\(\'\\u0665۱\。\\u180B𐡼\\u0663\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:914\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}\x{066B}⒖。󙀷񅖙\x{0DCA}", %p)},	undef,	"to_unicode\(\'\\u200C\\u066B⒖\。󙀷񅖙\\u0DCA\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:915\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{066B}⒖。󙀷񅖙\x{0DCA}", %p)},	undef,	"to_unicode\(\'\\u200C\\u066B⒖\。󙀷񅖙\\u0DCA\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:916\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{066B}15.。󙀷񅖙\x{0DCA}", %p)},	undef,	"to_unicode\(\'\\u200C\\u066B15\.\。󙀷񅖙\\u0DCA\'\)\ throws\ error\ P1\ V6\ B1\ C1\ A4_2\ \[data\/IdnaTest\.txt\:917\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{066B}15.。󙀷񅖙\x{0DCA}", %p)},	undef,	"to_unicode\(\'\\u200C\\u066B15\.\。󙀷񅖙\\u0DCA\'\)\ throws\ error\ P1\ V6\ B1\ C1\ A4_2\ \[data\/IdnaTest\.txt\:918\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B4D}.-逋𰶞򼥘", %p)},	undef,	"to_unicode\(\'\\u0B4D\.\-逋𰶞򼥘\'\)\ throws\ error\ P1\ V5\ V3\ V6\ \[data\/IdnaTest\.txt\:919\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0847}。\x{3164}\x{200D}ς", %p)},	undef,	"to_unicode\(\'\\u0847\。\\u3164\\u200Dς\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:920\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0847}。\x{3164}\x{200D}ς", %p)},	undef,	"to_unicode\(\'\\u0847\。\\u3164\\u200Dς\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:921\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0847}。\x{1160}\x{200D}ς", %p)},	undef,	"to_unicode\(\'\\u0847\。\\u1160\\u200Dς\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:922\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0847}。\x{1160}\x{200D}ς", %p)},	undef,	"to_unicode\(\'\\u0847\。\\u1160\\u200Dς\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:923\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0847}。\x{1160}\x{200D}Σ", %p)},	undef,	"to_unicode\(\'\\u0847\。\\u1160\\u200DΣ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:924\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0847}。\x{1160}\x{200D}Σ", %p)},	undef,	"to_unicode\(\'\\u0847\。\\u1160\\u200DΣ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:925\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0847}。\x{1160}\x{200D}σ", %p)},	undef,	"to_unicode\(\'\\u0847\。\\u1160\\u200Dσ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:926\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0847}。\x{1160}\x{200D}σ", %p)},	undef,	"to_unicode\(\'\\u0847\。\\u1160\\u200Dσ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:927\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0847}。\x{3164}\x{200D}Σ", %p)},	undef,	"to_unicode\(\'\\u0847\。\\u3164\\u200DΣ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:928\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0847}。\x{3164}\x{200D}Σ", %p)},	undef,	"to_unicode\(\'\\u0847\。\\u3164\\u200DΣ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:929\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0847}。\x{3164}\x{200D}σ", %p)},	undef,	"to_unicode\(\'\\u0847\。\\u3164\\u200Dσ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:930\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0847}。\x{3164}\x{200D}σ", %p)},	undef,	"to_unicode\(\'\\u0847\。\\u3164\\u200Dσ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:931\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0843}Ⴃ｡򯬎\x{0309}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0843Ⴃ｡򯬎\\u0309\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:932\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0843}Ⴃ｡򯬎\x{0309}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0843Ⴃ｡򯬎\\u0309\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:933\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0843}Ⴃ。򯬎\x{0309}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0843Ⴃ\。򯬎\\u0309\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:934\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0843}Ⴃ。򯬎\x{0309}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0843Ⴃ\。򯬎\\u0309\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:935\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0843}ⴃ。򯬎\x{0309}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0843ⴃ\。򯬎\\u0309\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:936\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0843}ⴃ。򯬎\x{0309}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0843ⴃ\。򯬎\\u0309\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:937\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0843}ⴃ｡򯬎\x{0309}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0843ⴃ｡򯬎\\u0309\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:938\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0843}ⴃ｡򯬎\x{0309}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0843ⴃ｡򯬎\\u0309\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:939\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᠯ󠯘．ς\x{0761}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᠯ\󠯘．ς\\u0761\\u200C\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:940\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᠯ󠯘．ς\x{0761}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᠯ\󠯘．ς\\u0761\\u200C\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:941\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᠯ󠯘.ς\x{0761}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᠯ\󠯘\.ς\\u0761\\u200C\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:942\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᠯ󠯘.ς\x{0761}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᠯ\󠯘\.ς\\u0761\\u200C\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:943\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᠯ󠯘.Σ\x{0761}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᠯ\󠯘\.Σ\\u0761\\u200C\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:944\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᠯ󠯘.Σ\x{0761}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᠯ\󠯘\.Σ\\u0761\\u200C\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:945\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᠯ󠯘.σ\x{0761}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᠯ\󠯘\.σ\\u0761\\u200C\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:946\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᠯ󠯘.σ\x{0761}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᠯ\󠯘\.σ\\u0761\\u200C\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:947\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᠯ󠯘．Σ\x{0761}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᠯ\󠯘．Σ\\u0761\\u200C\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:948\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᠯ󠯘．Σ\x{0761}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᠯ\󠯘．Σ\\u0761\\u200C\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:949\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᠯ󠯘．σ\x{0761}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᠯ\󠯘．σ\\u0761\\u200C\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:950\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᠯ󠯘．σ\x{0761}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᠯ\󠯘．σ\\u0761\\u200C\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:951\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{17B5}。𐳺\x{0845}󠃧", %p)},	undef,	"to_unicode\(\'\\u17B5\。𐳺\\u0845\󠃧\'\)\ throws\ error\ P1\ V5\ V6\ B3\ \[data\/IdnaTest\.txt\:952\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򾏛暑．⾑\x{0662}", %p)},	undef,	"to_unicode\(\'򾏛暑．⾑\\u0662\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:953\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򾏛暑.襾\x{0662}", %p)},	undef,	"to_unicode\(\'򾏛暑\.襾\\u0662\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:954\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{17D1}≯\x{08AA}。\x{060D}\x{08EC}", %p)},	undef,	"to_unicode\(\'\\u17D1\≯\\u08AA\。\\u060D\\u08EC\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:955\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{17D1}>\x{0338}\x{08AA}。\x{060D}\x{08EC}", %p)},	undef,	"to_unicode\(\'\\u17D1\>\\u0338\\u08AA\。\\u060D\\u08EC\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:956\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞫹񏔜𑚶\x{103A}.򕔔Ⴗ", %p)},	undef,	"to_unicode\(\'𞫹񏔜𑚶\\u103A\.򕔔Ⴗ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:957\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞫹񏔜𑚶\x{103A}.򕔔ⴗ", %p)},	undef,	"to_unicode\(\'𞫹񏔜𑚶\\u103A\.򕔔ⴗ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:958\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠆽｡𐨿񃱏񛂙", %p)},	undef,	"to_unicode\(\'\󠆽｡𐨿񃱏񛂙\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:959\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠆽。𐨿񃱏񛂙", %p)},	undef,	"to_unicode\(\'\󠆽\。𐨿񃱏񛂙\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:960\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BA9}\x{200C}．𞥖\x{200C}ꡓ", %p)},	undef,	"to_unicode\(\'\\u1BA9\\u200C．𞥖\\u200Cꡓ\'\)\ throws\ error\ P1\ V5\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:961\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BA9}\x{200C}．𞥖\x{200C}ꡓ", %p)},	undef,	"to_unicode\(\'\\u1BA9\\u200C．𞥖\\u200Cꡓ\'\)\ throws\ error\ P1\ V5\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:962\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BA9}\x{200C}.𞥖\x{200C}ꡓ", %p)},	undef,	"to_unicode\(\'\\u1BA9\\u200C\.𞥖\\u200Cꡓ\'\)\ throws\ error\ P1\ V5\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:963\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BA9}\x{200C}.𞥖\x{200C}ꡓ", %p)},	undef,	"to_unicode\(\'\\u1BA9\\u200C\.𞥖\\u200Cꡓ\'\)\ throws\ error\ P1\ V5\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:964\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡉ񥜐ß.ጧ", %p)},	undef,	"to_unicode\(\'ᡉ񥜐ß\.ጧ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:965\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡉ񥜐SS.ጧ", %p)},	undef,	"to_unicode\(\'ᡉ񥜐SS\.ጧ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:966\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡉ񥜐ss.ጧ", %p)},	undef,	"to_unicode\(\'ᡉ񥜐ss\.ጧ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:967\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡉ񥜐Ss.ጧ", %p)},	undef,	"to_unicode\(\'ᡉ񥜐Ss\.ጧ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:968\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑍴\x{200C}.򞞰\x{200C}", %p)},	undef,	"to_unicode\(\'𑍴\\u200C\.򞞰\\u200C\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:969\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑍴\x{200C}.򞞰\x{200C}", %p)},	undef,	"to_unicode\(\'𑍴\\u200C\.򞞰\\u200C\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:970\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06CC}򶕐\x{0663}。Ⴜ", %p)},	undef,	"to_unicode\(\'\\u06CC򶕐\\u0663\。Ⴜ\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:971\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06CC}򶕐\x{0663}。ⴜ", %p)},	undef,	"to_unicode\(\'\\u06CC򶕐\\u0663\。ⴜ\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:972\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0600}⮣\x{200C}\x{135F}｡󯅪𐠨", %p)},	undef,	"to_unicode\(\'\\u0600\⮣\\u200C\\u135F｡󯅪𐠨\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:973\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0600}⮣\x{200C}\x{135F}｡󯅪𐠨", %p)},	undef,	"to_unicode\(\'\\u0600\⮣\\u200C\\u135F｡󯅪𐠨\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:974\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0600}⮣\x{200C}\x{135F}。󯅪𐠨", %p)},	undef,	"to_unicode\(\'\\u0600\⮣\\u200C\\u135F\。󯅪𐠨\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:975\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0600}⮣\x{200C}\x{135F}。󯅪𐠨", %p)},	undef,	"to_unicode\(\'\\u0600\⮣\\u200C\\u135F\。󯅪𐠨\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:976\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴒ。デßꡢ𑂹", %p)},	undef,	"to_unicode\(\'Ⴒ\。デßꡢ𑂹\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:977\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴒ。テ\x{3099}ßꡢ𑂹", %p)},	undef,	"to_unicode\(\'Ⴒ\。テ\\u3099ßꡢ𑂹\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:978\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ⴒ。テ\x{3099}ßꡢ𑂹", %p)},	"ⴒ.デßꡢ𑂹",	"to_unicode\(\'ⴒ\。テ\\u3099ßꡢ𑂹\'\)\ \[data\/IdnaTest\.txt\:979\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ⴒ。テ\x{3099}ßꡢ𑂹", %p)},	"ⴒ.デßꡢ𑂹",	"to_unicode\(\'ⴒ\。テ\\u3099ßꡢ𑂹\'\)\ \[data\/IdnaTest\.txt\:980\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ⴒ。デßꡢ𑂹", %p)},	"ⴒ.デßꡢ𑂹",	"to_unicode\(\'ⴒ\。デßꡢ𑂹\'\)\ \[data\/IdnaTest\.txt\:981\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ⴒ。デßꡢ𑂹", %p)},	"ⴒ.デßꡢ𑂹",	"to_unicode\(\'ⴒ\。デßꡢ𑂹\'\)\ \[data\/IdnaTest\.txt\:982\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴒ。デSSꡢ𑂹", %p)},	undef,	"to_unicode\(\'Ⴒ\。デSSꡢ𑂹\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:983\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴒ。テ\x{3099}SSꡢ𑂹", %p)},	undef,	"to_unicode\(\'Ⴒ\。テ\\u3099SSꡢ𑂹\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:984\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ⴒ。テ\x{3099}ssꡢ𑂹", %p)},	"ⴒ.デssꡢ𑂹",	"to_unicode\(\'ⴒ\。テ\\u3099ssꡢ𑂹\'\)\ \[data\/IdnaTest\.txt\:985\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ⴒ。デssꡢ𑂹", %p)},	"ⴒ.デssꡢ𑂹",	"to_unicode\(\'ⴒ\。デssꡢ𑂹\'\)\ \[data\/IdnaTest\.txt\:986\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴒ。デSsꡢ𑂹", %p)},	undef,	"to_unicode\(\'Ⴒ\。デSsꡢ𑂹\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:987\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴒ。テ\x{3099}Ssꡢ𑂹", %p)},	undef,	"to_unicode\(\'Ⴒ\。テ\\u3099Ssꡢ𑂹\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:988\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("xn--9kj.xn--ss-mj4a0834c49ue", %p)},	"ⴒ.デssꡢ𑂹",	"to_unicode\(\'xn\-\-9kj\.xn\-\-ss\-mj4a0834c49ue\'\)\ \[data\/IdnaTest\.txt\:989\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ⴒ.デssꡢ𑂹", %p)},	"ⴒ.デssꡢ𑂹",	"to_unicode\(\'ⴒ\.デssꡢ𑂹\'\)\ \[data\/IdnaTest\.txt\:990\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ⴒ.テ\x{3099}ssꡢ𑂹", %p)},	"ⴒ.デssꡢ𑂹",	"to_unicode\(\'ⴒ\.テ\\u3099ssꡢ𑂹\'\)\ \[data\/IdnaTest\.txt\:991\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴒ.テ\x{3099}SSꡢ𑂹", %p)},	undef,	"to_unicode\(\'Ⴒ\.テ\\u3099SSꡢ𑂹\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:992\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴒ.デSSꡢ𑂹", %p)},	undef,	"to_unicode\(\'Ⴒ\.デSSꡢ𑂹\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:993\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴒ.デSsꡢ𑂹", %p)},	undef,	"to_unicode\(\'Ⴒ\.デSsꡢ𑂹\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:994\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴒ.テ\x{3099}Ssꡢ𑂹", %p)},	undef,	"to_unicode\(\'Ⴒ\.テ\\u3099Ssꡢ𑂹\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:995\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("xn--9kj.xn--zca146vs88eyh1d", %p)},	"ⴒ.デßꡢ𑂹",	"to_unicode\(\'xn\-\-9kj\.xn\-\-zca146vs88eyh1d\'\)\ \[data\/IdnaTest\.txt\:996\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ⴒ.デßꡢ𑂹", %p)},	"ⴒ.デßꡢ𑂹",	"to_unicode\(\'ⴒ\.デßꡢ𑂹\'\)\ \[data\/IdnaTest\.txt\:997\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ⴒ.デßꡢ𑂹", %p)},	"ⴒ.デßꡢ𑂹",	"to_unicode\(\'ⴒ\.デßꡢ𑂹\'\)\ \[data\/IdnaTest\.txt\:998\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ⴒ.テ\x{3099}ßꡢ𑂹", %p)},	"ⴒ.デßꡢ𑂹",	"to_unicode\(\'ⴒ\.テ\\u3099ßꡢ𑂹\'\)\ \[data\/IdnaTest\.txt\:999\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ⴒ.テ\x{3099}ßꡢ𑂹", %p)},	"ⴒ.デßꡢ𑂹",	"to_unicode\(\'ⴒ\.テ\\u3099ßꡢ𑂹\'\)\ \[data\/IdnaTest\.txt\:1000\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𑖿\x{0BCD}．７-\x{08A9}", %p)},	undef,	"to_unicode\(\'𑖿\\u0BCD．７\-\\u08A9\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1001\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𑖿\x{0BCD}.7-\x{08A9}", %p)},	undef,	"to_unicode\(\'𑖿\\u0BCD\.7\-\\u08A9\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1002\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("≯\x{17D2}🟌.\x{1734}񌂒\x{1DC1}\x{0625}", %p)},	undef,	"to_unicode\(\'\≯\\u17D2🟌\.\\u1734񌂒\\u1DC1\\u0625\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1003\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{17D2}🟌.\x{1734}񌂒\x{1DC1}\x{0627}\x{0655}", %p)},	undef,	"to_unicode\(\'\>\\u0338\\u17D2🟌\.\\u1734񌂒\\u1DC1\\u0627\\u0655\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1004\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑖲򠍜Ⴗ쏔。𐴋", %p)},	undef,	"to_unicode\(\'𑖲򠍜Ⴗ쏔\。𐴋\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1005\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑖲򠍜Ⴗ쏔。𐴋", %p)},	undef,	"to_unicode\(\'𑖲򠍜Ⴗ쏔\。𐴋\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1006\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑖲򠍜ⴗ쏔。𐴋", %p)},	undef,	"to_unicode\(\'𑖲򠍜ⴗ쏔\。𐴋\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1007\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑖲򠍜ⴗ쏔。𐴋", %p)},	undef,	"to_unicode\(\'𑖲򠍜ⴗ쏔\。𐴋\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1008\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß｡𐋳Ⴌ\x{0591}", %p)},	undef,	"to_unicode\(\'ß｡𐋳Ⴌ\\u0591\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1009\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß。𐋳Ⴌ\x{0591}", %p)},	undef,	"to_unicode\(\'ß\。𐋳Ⴌ\\u0591\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1010\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ß。𐋳ⴌ\x{0591}", %p)},	"ß.𐋳ⴌ\x{0591}",	"to_unicode\(\'ß\。𐋳ⴌ\\u0591\'\)\ \[data\/IdnaTest\.txt\:1011\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ß。𐋳ⴌ\x{0591}", %p)},	"ß.𐋳ⴌ\x{0591}",	"to_unicode\(\'ß\。𐋳ⴌ\\u0591\'\)\ \[data\/IdnaTest\.txt\:1012\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("SS。𐋳Ⴌ\x{0591}", %p)},	undef,	"to_unicode\(\'SS\。𐋳Ⴌ\\u0591\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1013\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ss。𐋳ⴌ\x{0591}", %p)},	"ss.𐋳ⴌ\x{0591}",	"to_unicode\(\'ss\。𐋳ⴌ\\u0591\'\)\ \[data\/IdnaTest\.txt\:1014\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ss.xn--ccb723rvh6l", %p)},	"ss.𐋳ⴌ\x{0591}",	"to_unicode\(\'ss\.xn\-\-ccb723rvh6l\'\)\ \[data\/IdnaTest\.txt\:1015\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ss.𐋳ⴌ\x{0591}", %p)},	"ss.𐋳ⴌ\x{0591}",	"to_unicode\(\'ss\.𐋳ⴌ\\u0591\'\)\ \[data\/IdnaTest\.txt\:1016\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("SS.𐋳Ⴌ\x{0591}", %p)},	undef,	"to_unicode\(\'SS\.𐋳Ⴌ\\u0591\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1017\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--zca.xn--ccb723rvh6l", %p)},	"ß.𐋳ⴌ\x{0591}",	"to_unicode\(\'xn\-\-zca\.xn\-\-ccb723rvh6l\'\)\ \[data\/IdnaTest\.txt\:1018\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ß.𐋳ⴌ\x{0591}", %p)},	"ß.𐋳ⴌ\x{0591}",	"to_unicode\(\'ß\.𐋳ⴌ\\u0591\'\)\ \[data\/IdnaTest\.txt\:1019\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ß.𐋳ⴌ\x{0591}", %p)},	"ß.𐋳ⴌ\x{0591}",	"to_unicode\(\'ß\.𐋳ⴌ\\u0591\'\)\ \[data\/IdnaTest\.txt\:1020\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ß｡𐋳ⴌ\x{0591}", %p)},	"ß.𐋳ⴌ\x{0591}",	"to_unicode\(\'ß｡𐋳ⴌ\\u0591\'\)\ \[data\/IdnaTest\.txt\:1021\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ß｡𐋳ⴌ\x{0591}", %p)},	"ß.𐋳ⴌ\x{0591}",	"to_unicode\(\'ß｡𐋳ⴌ\\u0591\'\)\ \[data\/IdnaTest\.txt\:1022\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("SS｡𐋳Ⴌ\x{0591}", %p)},	undef,	"to_unicode\(\'SS｡𐋳Ⴌ\\u0591\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1023\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ss｡𐋳ⴌ\x{0591}", %p)},	"ss.𐋳ⴌ\x{0591}",	"to_unicode\(\'ss｡𐋳ⴌ\\u0591\'\)\ \[data\/IdnaTest\.txt\:1024\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("-ꡝ𐩁.\x{200C}➇\x{ABED}", %p)},	undef,	"to_unicode\(\'\-ꡝ𐩁\.\\u200C➇\\uABED\'\)\ throws\ error\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:1025\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("-ꡝ𐩁.\x{200C}➇\x{ABED}", %p)},	undef,	"to_unicode\(\'\-ꡝ𐩁\.\\u200C➇\\uABED\'\)\ throws\ error\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:1026\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("\x{0B42}\x{08B4}\x{17CD}\x{0DCA}.󠆇\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0B42\\u08B4\\u17CD\\u0DCA\.\󠆇\\u200D\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1027\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("\x{0B42}\x{08B4}\x{17CD}\x{0DCA}.󠆇\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0B42\\u08B4\\u17CD\\u0DCA\.\󠆇\\u200D\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1028\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("󠅡\x{200D}󠨿ꡁ.\x{07D3}\x{200C}󠜔", %p)},	undef,	"to_unicode\(\'\󠅡\\u200D\󠨿ꡁ\.\\u07D3\\u200C\󠜔\'\)\ throws\ error\ P1\ V6\ C2\ B3\ C1\ \[data\/IdnaTest\.txt\:1029\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅡\x{200D}󠨿ꡁ.\x{07D3}\x{200C}󠜔", %p)},	undef,	"to_unicode\(\'\󠅡\\u200D\󠨿ꡁ\.\\u07D3\\u200C\󠜔\'\)\ throws\ error\ P1\ V6\ C2\ B3\ C1\ \[data\/IdnaTest\.txt\:1030\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴑ．\x{07D1}\x{FB8A}\x{0634}", %p)},	undef,	"to_unicode\(\'Ⴑ．\\u07D1\\uFB8A\\u0634\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1031\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴑ.\x{07D1}\x{0698}\x{0634}", %p)},	undef,	"to_unicode\(\'Ⴑ\.\\u07D1\\u0698\\u0634\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1032\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ⴑ.\x{07D1}\x{0698}\x{0634}", %p)},	"ⴑ.\x{07D1}\x{0698}\x{0634}",	"to_unicode\(\'ⴑ\.\\u07D1\\u0698\\u0634\'\)\ \[data\/IdnaTest\.txt\:1033\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("xn--8kj.xn--zgb3ro7a", %p)},	"ⴑ.\x{07D1}\x{0698}\x{0634}",	"to_unicode\(\'xn\-\-8kj\.xn\-\-zgb3ro7a\'\)\ \[data\/IdnaTest\.txt\:1034\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ⴑ．\x{07D1}\x{FB8A}\x{0634}", %p)},	"ⴑ.\x{07D1}\x{0698}\x{0634}",	"to_unicode\(\'ⴑ．\\u07D1\\uFB8A\\u0634\'\)\ \[data\/IdnaTest\.txt\:1035\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𝩝玵\x{A9C0}。𕹊𝟵", %p)},	undef,	"to_unicode\(\'𝩝玵\\uA9C0\。𕹊𝟵\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1036\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝩝玵\x{A9C0}。𕹊9", %p)},	undef,	"to_unicode\(\'𝩝玵\\uA9C0\。𕹊9\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1037\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{06CF}󂎶𝟗｡Ⴣꜟ𐰾󄮷", %p)},	undef,	"to_unicode\(\'\\u200C\\u06CF󂎶𝟗｡Ⴣꜟ𐰾󄮷\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ \[data\/IdnaTest\.txt\:1038\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{06CF}󂎶𝟗｡Ⴣꜟ𐰾󄮷", %p)},	undef,	"to_unicode\(\'\\u200C\\u06CF󂎶𝟗｡Ⴣꜟ𐰾󄮷\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ \[data\/IdnaTest\.txt\:1039\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{06CF}󂎶9。Ⴣꜟ𐰾󄮷", %p)},	undef,	"to_unicode\(\'\\u200C\\u06CF󂎶9\。Ⴣꜟ𐰾󄮷\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ \[data\/IdnaTest\.txt\:1040\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{06CF}󂎶9。Ⴣꜟ𐰾󄮷", %p)},	undef,	"to_unicode\(\'\\u200C\\u06CF󂎶9\。Ⴣꜟ𐰾󄮷\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ \[data\/IdnaTest\.txt\:1041\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{06CF}󂎶9。ⴣꜟ𐰾󄮷", %p)},	undef,	"to_unicode\(\'\\u200C\\u06CF󂎶9\。ⴣꜟ𐰾󄮷\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ \[data\/IdnaTest\.txt\:1042\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{06CF}󂎶9。ⴣꜟ𐰾󄮷", %p)},	undef,	"to_unicode\(\'\\u200C\\u06CF󂎶9\。ⴣꜟ𐰾󄮷\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ \[data\/IdnaTest\.txt\:1043\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{06CF}󂎶𝟗｡ⴣꜟ𐰾󄮷", %p)},	undef,	"to_unicode\(\'\\u200C\\u06CF󂎶𝟗｡ⴣꜟ𐰾󄮷\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ \[data\/IdnaTest\.txt\:1044\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{06CF}󂎶𝟗｡ⴣꜟ𐰾󄮷", %p)},	undef,	"to_unicode\(\'\\u200C\\u06CF󂎶𝟗｡ⴣꜟ𐰾󄮷\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ \[data\/IdnaTest\.txt\:1045\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07D0}｡\x{1B70}𹝗󠇑-", %p)},	undef,	"to_unicode\(\'\\u07D0｡\\u1B70𹝗\󠇑\-\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:1046\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07D0}。\x{1B70}𹝗󠇑-", %p)},	undef,	"to_unicode\(\'\\u07D0\。\\u1B70𹝗\󠇑\-\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:1047\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞧺󨸝。絧\x{0EB7}", %p)},	undef,	"to_unicode\(\'𞧺󨸝\。絧\\u0EB7\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1048\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1B39}Ⴋ．𝟳≯︒\x{17B8}", %p)},	undef,	"to_unicode\(\'\\u1B39Ⴋ．𝟳\≯︒\\u17B8\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1049\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1B39}Ⴋ．𝟳>\x{0338}︒\x{17B8}", %p)},	undef,	"to_unicode\(\'\\u1B39Ⴋ．𝟳\>\\u0338︒\\u17B8\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1050\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1B39}Ⴋ.7≯。\x{17B8}", %p)},	undef,	"to_unicode\(\'\\u1B39Ⴋ\.7\≯\。\\u17B8\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1051\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1B39}Ⴋ.7>\x{0338}。\x{17B8}", %p)},	undef,	"to_unicode\(\'\\u1B39Ⴋ\.7\>\\u0338\。\\u17B8\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1052\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1B39}ⴋ.7>\x{0338}。\x{17B8}", %p)},	undef,	"to_unicode\(\'\\u1B39ⴋ\.7\>\\u0338\。\\u17B8\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1053\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1B39}ⴋ.7≯。\x{17B8}", %p)},	undef,	"to_unicode\(\'\\u1B39ⴋ\.7\≯\。\\u17B8\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1054\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1B39}ⴋ．𝟳>\x{0338}︒\x{17B8}", %p)},	undef,	"to_unicode\(\'\\u1B39ⴋ．𝟳\>\\u0338︒\\u17B8\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1055\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1B39}ⴋ．𝟳≯︒\x{17B8}", %p)},	undef,	"to_unicode\(\'\\u1B39ⴋ．𝟳\≯︒\\u17B8\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1056\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}F\x{ABED}。⤵︒\x{06AD}𐹸", %p)},	undef,	"to_unicode\(\'\\u200DF\\uABED\。\⤵︒\\u06AD𐹸\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:1057\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}F\x{ABED}。⤵︒\x{06AD}𐹸", %p)},	undef,	"to_unicode\(\'\\u200DF\\uABED\。\⤵︒\\u06AD𐹸\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:1058\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}F\x{ABED}。⤵。\x{06AD}𐹸", %p)},	undef,	"to_unicode\(\'\\u200DF\\uABED\。\⤵\。\\u06AD𐹸\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:1059\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}F\x{ABED}。⤵。\x{06AD}𐹸", %p)},	undef,	"to_unicode\(\'\\u200DF\\uABED\。\⤵\。\\u06AD𐹸\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:1060\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}f\x{ABED}。⤵。\x{06AD}𐹸", %p)},	undef,	"to_unicode\(\'\\u200Df\\uABED\。\⤵\。\\u06AD𐹸\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:1061\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}f\x{ABED}。⤵。\x{06AD}𐹸", %p)},	undef,	"to_unicode\(\'\\u200Df\\uABED\。\⤵\。\\u06AD𐹸\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:1062\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("xn--f-0w5e.xn--0ri.xn--gkb6716k", %p)},	"f\x{ABED}.⤵.\x{06AD}𐹸",	"to_unicode\(\'xn\-\-f\-0w5e\.xn\-\-0ri\.xn\-\-gkb6716k\'\)\ \[data\/IdnaTest\.txt\:1063\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("f\x{ABED}.⤵.\x{06AD}𐹸", %p)},	"f\x{ABED}.⤵.\x{06AD}𐹸",	"to_unicode\(\'f\\uABED\.\⤵\.\\u06AD𐹸\'\)\ \[data\/IdnaTest\.txt\:1064\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("F\x{ABED}.⤵.\x{06AD}𐹸", %p)},	"f\x{ABED}.⤵.\x{06AD}𐹸",	"to_unicode\(\'F\\uABED\.\⤵\.\\u06AD𐹸\'\)\ \[data\/IdnaTest\.txt\:1065\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}f\x{ABED}。⤵︒\x{06AD}𐹸", %p)},	undef,	"to_unicode\(\'\\u200Df\\uABED\。\⤵︒\\u06AD𐹸\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:1066\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}f\x{ABED}。⤵︒\x{06AD}𐹸", %p)},	undef,	"to_unicode\(\'\\u200Df\\uABED\。\⤵︒\\u06AD𐹸\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:1067\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0775}🄇𐸷︒｡𐹰\x{0F84}", %p)},	undef,	"to_unicode\(\'\\u0775🄇𐸷︒｡𐹰\\u0F84\'\)\ throws\ error\ P1\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:1068\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0775}6,𐸷。。𐹰\x{0F84}", %p)},	undef,	"to_unicode\(\'\\u07756\,𐸷\。\。𐹰\\u0F84\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:1069\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐽜.\x{2DF3}\x{0748}𞬜", %p)},	undef,	"to_unicode\(\'𐽜\.\\u2DF3\\u0748𞬜\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1070\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐽜.\x{0748}\x{2DF3}𞬜", %p)},	undef,	"to_unicode\(\'𐽜\.\\u0748\\u2DF3𞬜\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1071\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴂ䠺。\x{084E}旤𺹼\x{0850}", %p)},	undef,	"to_unicode\(\'Ⴂ䠺\。\\u084E旤𺹼\\u0850\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1072\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴂ䠺。\x{084E}旤𺹼\x{0850}", %p)},	undef,	"to_unicode\(\'ⴂ䠺\。\\u084E旤𺹼\\u0850\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1073\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄇伐︒.򟳭\x{1039}", %p)},	undef,	"to_unicode\(\'🄇伐︒\.򟳭\\u1039\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1074\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("6,伐。.򟳭\x{1039}", %p)},	undef,	"to_unicode\(\'6\,伐\。\.򟳭\\u1039\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1075\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹤\x{0DCA}⺶。\x{200D}𐫚Ⴚ\x{1B44}", %p)},	undef,	"to_unicode\(\'\\u200D𐹤\\u0DCA⺶\。\\u200D𐫚Ⴚ\\u1B44\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1076\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐹤\x{0DCA}⺶。\x{200D}𐫚Ⴚ\x{1B44}", %p)},	undef,	"to_unicode\(\'\\u200D𐹤\\u0DCA⺶\。\\u200D𐫚Ⴚ\\u1B44\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1077\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}𐹤\x{0DCA}⺶。\x{200D}𐫚ⴚ\x{1B44}", %p)},	undef,	"to_unicode\(\'\\u200D𐹤\\u0DCA⺶\。\\u200D𐫚ⴚ\\u1B44\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:1078\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}𐹤\x{0DCA}⺶。\x{200D}𐫚ⴚ\x{1B44}", %p)},	undef,	"to_unicode\(\'\\u200D𐹤\\u0DCA⺶\。\\u200D𐫚ⴚ\\u1B44\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:1079\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0FAB}．󐓯򑿜", %p)},	undef,	"to_unicode\(\'\\u0FAB．󐓯򑿜\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1080\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FAB}.󐓯򑿜", %p)},	undef,	"to_unicode\(\'\\u0FAB\.󐓯򑿜\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1081\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{072D}\x{200C}Ⴆ.≠\x{FE8D}", %p)},	undef,	"to_unicode\(\'\\u072D\\u200CႦ\.\≠\\uFE8D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1082\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{072D}\x{200C}Ⴆ.≠\x{FE8D}", %p)},	undef,	"to_unicode\(\'\\u072D\\u200CႦ\.\≠\\uFE8D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1083\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{072D}\x{200C}Ⴆ.=\x{0338}\x{FE8D}", %p)},	undef,	"to_unicode\(\'\\u072D\\u200CႦ\.\=\\u0338\\uFE8D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1084\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{072D}\x{200C}Ⴆ.=\x{0338}\x{FE8D}", %p)},	undef,	"to_unicode\(\'\\u072D\\u200CႦ\.\=\\u0338\\uFE8D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1085\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{072D}\x{200C}Ⴆ.≠\x{0627}", %p)},	undef,	"to_unicode\(\'\\u072D\\u200CႦ\.\≠\\u0627\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1086\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{072D}\x{200C}Ⴆ.≠\x{0627}", %p)},	undef,	"to_unicode\(\'\\u072D\\u200CႦ\.\≠\\u0627\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1087\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{072D}\x{200C}Ⴆ.=\x{0338}\x{0627}", %p)},	undef,	"to_unicode\(\'\\u072D\\u200CႦ\.\=\\u0338\\u0627\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1088\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{072D}\x{200C}Ⴆ.=\x{0338}\x{0627}", %p)},	undef,	"to_unicode\(\'\\u072D\\u200CႦ\.\=\\u0338\\u0627\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1089\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{072D}\x{200C}ⴆ.=\x{0338}\x{0627}", %p)},	undef,	"to_unicode\(\'\\u072D\\u200Cⴆ\.\=\\u0338\\u0627\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1090\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{072D}\x{200C}ⴆ.=\x{0338}\x{0627}", %p)},	undef,	"to_unicode\(\'\\u072D\\u200Cⴆ\.\=\\u0338\\u0627\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1091\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{072D}\x{200C}ⴆ.≠\x{0627}", %p)},	undef,	"to_unicode\(\'\\u072D\\u200Cⴆ\.\≠\\u0627\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1092\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{072D}\x{200C}ⴆ.≠\x{0627}", %p)},	undef,	"to_unicode\(\'\\u072D\\u200Cⴆ\.\≠\\u0627\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1093\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{072D}\x{200C}ⴆ.=\x{0338}\x{FE8D}", %p)},	undef,	"to_unicode\(\'\\u072D\\u200Cⴆ\.\=\\u0338\\uFE8D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1094\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{072D}\x{200C}ⴆ.=\x{0338}\x{FE8D}", %p)},	undef,	"to_unicode\(\'\\u072D\\u200Cⴆ\.\=\\u0338\\uFE8D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1095\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{072D}\x{200C}ⴆ.≠\x{FE8D}", %p)},	undef,	"to_unicode\(\'\\u072D\\u200Cⴆ\.\≠\\uFE8D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1096\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{072D}\x{200C}ⴆ.≠\x{FE8D}", %p)},	undef,	"to_unicode\(\'\\u072D\\u200Cⴆ\.\≠\\uFE8D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1097\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07F2}󂉽𝟥ꘌ．\x{07CA}", %p)},	undef,	"to_unicode\(\'\\u07F2󂉽𝟥ꘌ．\\u07CA\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1098\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07F2}󂉽3ꘌ.\x{07CA}", %p)},	undef,	"to_unicode\(\'\\u07F2󂉽3ꘌ\.\\u07CA\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1099\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-.󠆌򝒅-", %p)},	undef,	"to_unicode\(\'\-\.\󠆌򝒅\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1100\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򲼁\x{200C}｡\x{200C}𐳲ς", %p)},	undef,	"to_unicode\(\'򲼁\\u200C｡\\u200C𐳲ς\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1101\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򲼁\x{200C}｡\x{200C}𐳲ς", %p)},	undef,	"to_unicode\(\'򲼁\\u200C｡\\u200C𐳲ς\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1102\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򲼁\x{200C}。\x{200C}𐳲ς", %p)},	undef,	"to_unicode\(\'򲼁\\u200C\。\\u200C𐳲ς\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1103\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򲼁\x{200C}。\x{200C}𐳲ς", %p)},	undef,	"to_unicode\(\'򲼁\\u200C\。\\u200C𐳲ς\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1104\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򲼁\x{200C}。\x{200C}𐳲Σ", %p)},	undef,	"to_unicode\(\'򲼁\\u200C\。\\u200C𐳲Σ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1105\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򲼁\x{200C}。\x{200C}𐳲Σ", %p)},	undef,	"to_unicode\(\'򲼁\\u200C\。\\u200C𐳲Σ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1106\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򲼁\x{200C}。\x{200C}𐳲σ", %p)},	undef,	"to_unicode\(\'򲼁\\u200C\。\\u200C𐳲σ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1107\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򲼁\x{200C}。\x{200C}𐳲σ", %p)},	undef,	"to_unicode\(\'򲼁\\u200C\。\\u200C𐳲σ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1108\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򲼁\x{200C}｡\x{200C}𐳲Σ", %p)},	undef,	"to_unicode\(\'򲼁\\u200C｡\\u200C𐳲Σ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1109\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򲼁\x{200C}｡\x{200C}𐳲Σ", %p)},	undef,	"to_unicode\(\'򲼁\\u200C｡\\u200C𐳲Σ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1110\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򲼁\x{200C}｡\x{200C}𐳲σ", %p)},	undef,	"to_unicode\(\'򲼁\\u200C｡\\u200C𐳲σ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1111\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򲼁\x{200C}｡\x{200C}𐳲σ", %p)},	undef,	"to_unicode\(\'򲼁\\u200C｡\\u200C𐳲σ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1112\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("堕𑍍󠇣。ᠻᢕ\x{200C}-", %p)},	undef,	"to_unicode\(\'堕𑍍\󠇣\。ᠻᢕ\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:1113\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("堕𑍍󠇣。ᠻᢕ\x{200C}-", %p)},	undef,	"to_unicode\(\'堕𑍍\󠇣\。ᠻᢕ\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:1114\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹥\x{0BCD}ꡜ\x{0678}｡\x{077E}ς\x{062A}ς", %p)},	undef,	"to_unicode\(\'𐹥\\u0BCDꡜ\\u0678｡\\u077Eς\\u062Aς\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1115\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹥\x{0BCD}ꡜ\x{064A}\x{0674}。\x{077E}ς\x{062A}ς", %p)},	undef,	"to_unicode\(\'𐹥\\u0BCDꡜ\\u064A\\u0674\。\\u077Eς\\u062Aς\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1116\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹥\x{0BCD}ꡜ\x{064A}\x{0674}。\x{077E}Σ\x{062A}Σ", %p)},	undef,	"to_unicode\(\'𐹥\\u0BCDꡜ\\u064A\\u0674\。\\u077EΣ\\u062AΣ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1117\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹥\x{0BCD}ꡜ\x{064A}\x{0674}。\x{077E}σ\x{062A}σ", %p)},	undef,	"to_unicode\(\'𐹥\\u0BCDꡜ\\u064A\\u0674\。\\u077Eσ\\u062Aσ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1118\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹥\x{0BCD}ꡜ\x{064A}\x{0674}。\x{077E}Σ\x{062A}σ", %p)},	undef,	"to_unicode\(\'𐹥\\u0BCDꡜ\\u064A\\u0674\。\\u077EΣ\\u062Aσ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1119\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹥\x{0BCD}ꡜ\x{064A}\x{0674}。\x{077E}Σ\x{062A}ς", %p)},	undef,	"to_unicode\(\'𐹥\\u0BCDꡜ\\u064A\\u0674\。\\u077EΣ\\u062Aς\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1120\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹥\x{0BCD}ꡜ\x{064A}\x{0674}。\x{077E}σ\x{062A}ς", %p)},	undef,	"to_unicode\(\'𐹥\\u0BCDꡜ\\u064A\\u0674\。\\u077Eσ\\u062Aς\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1121\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹥\x{0BCD}ꡜ\x{0678}｡\x{077E}Σ\x{062A}Σ", %p)},	undef,	"to_unicode\(\'𐹥\\u0BCDꡜ\\u0678｡\\u077EΣ\\u062AΣ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1122\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹥\x{0BCD}ꡜ\x{0678}｡\x{077E}σ\x{062A}σ", %p)},	undef,	"to_unicode\(\'𐹥\\u0BCDꡜ\\u0678｡\\u077Eσ\\u062Aσ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1123\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹥\x{0BCD}ꡜ\x{0678}｡\x{077E}Σ\x{062A}σ", %p)},	undef,	"to_unicode\(\'𐹥\\u0BCDꡜ\\u0678｡\\u077EΣ\\u062Aσ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1124\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹥\x{0BCD}ꡜ\x{0678}｡\x{077E}Σ\x{062A}ς", %p)},	undef,	"to_unicode\(\'𐹥\\u0BCDꡜ\\u0678｡\\u077EΣ\\u062Aς\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1125\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹥\x{0BCD}ꡜ\x{0678}｡\x{077E}σ\x{062A}ς", %p)},	undef,	"to_unicode\(\'𐹥\\u0BCDꡜ\\u0678｡\\u077Eσ\\u062Aς\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1126\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𸷣．-𝟻ß", %p)},	undef,	"to_unicode\(\'𸷣．\-𝟻ß\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1127\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𸷣.-5ß", %p)},	undef,	"to_unicode\(\'𸷣\.\-5ß\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1128\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𸷣.-5SS", %p)},	undef,	"to_unicode\(\'𸷣\.\-5SS\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1129\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𸷣．-𝟻SS", %p)},	undef,	"to_unicode\(\'𸷣．\-𝟻SS\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1130\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𸷣．-𝟻ss", %p)},	undef,	"to_unicode\(\'𸷣．\-𝟻ss\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1131\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𸷣．-𝟻Ss", %p)},	undef,	"to_unicode\(\'𸷣．\-𝟻Ss\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1132\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𑄴.𐅾Ⴥ񓴸", %p)},	undef,	"to_unicode\(\'\\u200D𑄴\.𐅾Ⴥ񓴸\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1133\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𑄴.𐅾Ⴥ񓴸", %p)},	undef,	"to_unicode\(\'\\u200D𑄴\.𐅾Ⴥ񓴸\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1134\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𑄴.𐅾ⴥ񓴸", %p)},	undef,	"to_unicode\(\'\\u200D𑄴\.𐅾ⴥ񓴸\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1135\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𑄴.𐅾ⴥ񓴸", %p)},	undef,	"to_unicode\(\'\\u200D𑄴\.𐅾ⴥ񓴸\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1136\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򒭷。ß󞑓\x{200D}", %p)},	undef,	"to_unicode\(\'򒭷\。ß󞑓\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1137\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򒭷。ß󞑓\x{200D}", %p)},	undef,	"to_unicode\(\'򒭷\。ß󞑓\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1138\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򒭷。SS󞑓\x{200D}", %p)},	undef,	"to_unicode\(\'򒭷\。SS󞑓\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1139\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򒭷。SS󞑓\x{200D}", %p)},	undef,	"to_unicode\(\'򒭷\。SS󞑓\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1140\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򒭷。ss󞑓\x{200D}", %p)},	undef,	"to_unicode\(\'򒭷\。ss󞑓\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1141\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򒭷。ss󞑓\x{200D}", %p)},	undef,	"to_unicode\(\'򒭷\。ss󞑓\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1142\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򒭷。Ss󞑓\x{200D}", %p)},	undef,	"to_unicode\(\'򒭷\。Ss󞑓\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1143\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򒭷。Ss󞑓\x{200D}", %p)},	undef,	"to_unicode\(\'򒭷\。Ss󞑓\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1144\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󙀇。󠄘䷚𞤛", %p)},	undef,	"to_unicode\(\'\\u200C󙀇\。\󠄘䷚𞤛\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1145\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󙀇。󠄘䷚𞤛", %p)},	undef,	"to_unicode\(\'\\u200C󙀇\。\󠄘䷚𞤛\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1146\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐸾\x{200C}𝪟。𐹾", %p)},	undef,	"to_unicode\(\'𐸾\\u200C𝪟\。𐹾\'\)\ throws\ error\ P1\ V6\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1147\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐸾\x{200C}𝪟。𐹾", %p)},	undef,	"to_unicode\(\'𐸾\\u200C𝪟\。𐹾\'\)\ throws\ error\ P1\ V6\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1148\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A929}񂥚\x{200C}😋｡\x{1BAA}𑂹ς≠", %p)},	undef,	"to_unicode\(\'\\uA929񂥚\\u200C😋｡\\u1BAA𑂹ς\≠\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1149\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A929}񂥚\x{200C}😋｡\x{1BAA}𑂹ς≠", %p)},	undef,	"to_unicode\(\'\\uA929񂥚\\u200C😋｡\\u1BAA𑂹ς\≠\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1150\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A929}񂥚\x{200C}😋｡\x{1BAA}𑂹ς=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uA929񂥚\\u200C😋｡\\u1BAA𑂹ς\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1151\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A929}񂥚\x{200C}😋｡\x{1BAA}𑂹ς=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uA929񂥚\\u200C😋｡\\u1BAA𑂹ς\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1152\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A929}񂥚\x{200C}😋。\x{1BAA}𑂹ς≠", %p)},	undef,	"to_unicode\(\'\\uA929񂥚\\u200C😋\。\\u1BAA𑂹ς\≠\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1153\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A929}񂥚\x{200C}😋。\x{1BAA}𑂹ς≠", %p)},	undef,	"to_unicode\(\'\\uA929񂥚\\u200C😋\。\\u1BAA𑂹ς\≠\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1154\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A929}񂥚\x{200C}😋。\x{1BAA}𑂹ς=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uA929񂥚\\u200C😋\。\\u1BAA𑂹ς\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1155\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A929}񂥚\x{200C}😋。\x{1BAA}𑂹ς=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uA929񂥚\\u200C😋\。\\u1BAA𑂹ς\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1156\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A929}񂥚\x{200C}😋。\x{1BAA}𑂹Σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uA929񂥚\\u200C😋\。\\u1BAA𑂹Σ\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1157\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A929}񂥚\x{200C}😋。\x{1BAA}𑂹Σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uA929񂥚\\u200C😋\。\\u1BAA𑂹Σ\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1158\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A929}񂥚\x{200C}😋。\x{1BAA}𑂹Σ≠", %p)},	undef,	"to_unicode\(\'\\uA929񂥚\\u200C😋\。\\u1BAA𑂹Σ\≠\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1159\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A929}񂥚\x{200C}😋。\x{1BAA}𑂹Σ≠", %p)},	undef,	"to_unicode\(\'\\uA929񂥚\\u200C😋\。\\u1BAA𑂹Σ\≠\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1160\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A929}񂥚\x{200C}😋。\x{1BAA}𑂹σ≠", %p)},	undef,	"to_unicode\(\'\\uA929񂥚\\u200C😋\。\\u1BAA𑂹σ\≠\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1161\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A929}񂥚\x{200C}😋。\x{1BAA}𑂹σ≠", %p)},	undef,	"to_unicode\(\'\\uA929񂥚\\u200C😋\。\\u1BAA𑂹σ\≠\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1162\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A929}񂥚\x{200C}😋。\x{1BAA}𑂹σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uA929񂥚\\u200C😋\。\\u1BAA𑂹σ\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1163\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A929}񂥚\x{200C}😋。\x{1BAA}𑂹σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uA929񂥚\\u200C😋\。\\u1BAA𑂹σ\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1164\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A929}񂥚\x{200C}😋｡\x{1BAA}𑂹Σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uA929񂥚\\u200C😋｡\\u1BAA𑂹Σ\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1165\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A929}񂥚\x{200C}😋｡\x{1BAA}𑂹Σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uA929񂥚\\u200C😋｡\\u1BAA𑂹Σ\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1166\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A929}񂥚\x{200C}😋｡\x{1BAA}𑂹Σ≠", %p)},	undef,	"to_unicode\(\'\\uA929񂥚\\u200C😋｡\\u1BAA𑂹Σ\≠\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1167\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A929}񂥚\x{200C}😋｡\x{1BAA}𑂹Σ≠", %p)},	undef,	"to_unicode\(\'\\uA929񂥚\\u200C😋｡\\u1BAA𑂹Σ\≠\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1168\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A929}񂥚\x{200C}😋｡\x{1BAA}𑂹σ≠", %p)},	undef,	"to_unicode\(\'\\uA929񂥚\\u200C😋｡\\u1BAA𑂹σ\≠\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1169\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A929}񂥚\x{200C}😋｡\x{1BAA}𑂹σ≠", %p)},	undef,	"to_unicode\(\'\\uA929񂥚\\u200C😋｡\\u1BAA𑂹σ\≠\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1170\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A929}񂥚\x{200C}😋｡\x{1BAA}𑂹σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uA929񂥚\\u200C😋｡\\u1BAA𑂹σ\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1171\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A929}񂥚\x{200C}😋｡\x{1BAA}𑂹σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uA929񂥚\\u200C😋｡\\u1BAA𑂹σ\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1172\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒋｡⒈\x{200D}򛶪", %p)},	undef,	"to_unicode\(\'⒋｡⒈\\u200D򛶪\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1173\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒋｡⒈\x{200D}򛶪", %p)},	undef,	"to_unicode\(\'⒋｡⒈\\u200D򛶪\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1174\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4.。1.\x{200D}򛶪", %p)},	undef,	"to_unicode\(\'4\.\。1\.\\u200D򛶪\'\)\ throws\ error\ P1\ V6\ A4_2\ C2\ \[data\/IdnaTest\.txt\:1175\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4.。1.\x{200D}򛶪", %p)},	undef,	"to_unicode\(\'4\.\。1\.\\u200D򛶪\'\)\ throws\ error\ P1\ V6\ A4_2\ C2\ \[data\/IdnaTest\.txt\:1176\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06EE}ß｡\x{1A17}\x{2D7F}򂚄ᡣ", %p)},	undef,	"to_unicode\(\'\\u06EEß｡\\u1A17\\u2D7F򂚄ᡣ\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1177\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06EE}ß｡\x{2D7F}\x{1A17}򂚄ᡣ", %p)},	undef,	"to_unicode\(\'\\u06EEß｡\\u2D7F\\u1A17򂚄ᡣ\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1178\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06EE}ß。\x{2D7F}\x{1A17}򂚄ᡣ", %p)},	undef,	"to_unicode\(\'\\u06EEß\。\\u2D7F\\u1A17򂚄ᡣ\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1179\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06EE}SS。\x{2D7F}\x{1A17}򂚄ᡣ", %p)},	undef,	"to_unicode\(\'\\u06EESS\。\\u2D7F\\u1A17򂚄ᡣ\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1180\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06EE}ss。\x{2D7F}\x{1A17}򂚄ᡣ", %p)},	undef,	"to_unicode\(\'\\u06EEss\。\\u2D7F\\u1A17򂚄ᡣ\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1181\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06EE}Ss。\x{2D7F}\x{1A17}򂚄ᡣ", %p)},	undef,	"to_unicode\(\'\\u06EESs\。\\u2D7F\\u1A17򂚄ᡣ\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1182\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06EE}SS｡\x{2D7F}\x{1A17}򂚄ᡣ", %p)},	undef,	"to_unicode\(\'\\u06EESS｡\\u2D7F\\u1A17򂚄ᡣ\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1183\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06EE}ss｡\x{2D7F}\x{1A17}򂚄ᡣ", %p)},	undef,	"to_unicode\(\'\\u06EEss｡\\u2D7F\\u1A17򂚄ᡣ\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1184\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06EE}Ss｡\x{2D7F}\x{1A17}򂚄ᡣ", %p)},	undef,	"to_unicode\(\'\\u06EESs｡\\u2D7F\\u1A17򂚄ᡣ\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1185\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06EE}SS｡\x{1A17}\x{2D7F}򂚄ᡣ", %p)},	undef,	"to_unicode\(\'\\u06EESS｡\\u1A17\\u2D7F򂚄ᡣ\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1186\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06EE}ss｡\x{1A17}\x{2D7F}򂚄ᡣ", %p)},	undef,	"to_unicode\(\'\\u06EEss｡\\u1A17\\u2D7F򂚄ᡣ\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1187\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06EE}Ss｡\x{1A17}\x{2D7F}򂚄ᡣ", %p)},	undef,	"to_unicode\(\'\\u06EESs｡\\u1A17\\u2D7F򂚄ᡣ\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1188\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0661}\x{ABED}򚝪.󠀣\x{FE2E}𑁆\x{17D2}", %p)},	undef,	"to_unicode\(\'\\u0661\\uABED򚝪\.\󠀣\\uFE2E𑁆\\u17D2\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1189\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0661}\x{ABED}򚝪.󠀣𑁆\x{17D2}\x{FE2E}", %p)},	undef,	"to_unicode\(\'\\u0661\\uABED򚝪\.\󠀣𑁆\\u17D2\\uFE2E\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1190\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴓ𑂹\x{200D}򒾎．\x{062E}\x{1CDF}", %p)},	undef,	"to_unicode\(\'Ⴓ𑂹\\u200D򒾎．\\u062E\\u1CDF\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1191\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴓ𑂹\x{200D}򒾎.\x{062E}\x{1CDF}", %p)},	undef,	"to_unicode\(\'Ⴓ𑂹\\u200D򒾎\.\\u062E\\u1CDF\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1192\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴓ𑂹\x{200D}򒾎.\x{062E}\x{1CDF}", %p)},	undef,	"to_unicode\(\'ⴓ𑂹\\u200D򒾎\.\\u062E\\u1CDF\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1193\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴓ𑂹\x{200D}򒾎．\x{062E}\x{1CDF}", %p)},	undef,	"to_unicode\(\'ⴓ𑂹\\u200D򒾎．\\u062E\\u1CDF\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1194\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0BCD}.🄆꡶", %p)},	undef,	"to_unicode\(\'\\u0BCD\.🄆꡶\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1195\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0BCD}.5,꡶", %p)},	undef,	"to_unicode\(\'\\u0BCD\.5\,꡶\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1196\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񥛿𴫊۸。󠠾-", %p)},	undef,	"to_unicode\(\'񥛿𴫊۸\。\󠠾\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1197\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𷍞\x{06AF}𐹦。\x{0667}\x{0854}\x{084F}", %p)},	undef,	"to_unicode\(\'𷍞\\u06AF𐹦\。\\u0667\\u0854\\u084F\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:1198\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}ꡀႾ🄂.𝨛\x{07E6}򄚍\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200DꡀႾ🄂\.𝨛\\u07E6򄚍\\u200C\'\)\ throws\ error\ P1\ V6\ V5\ C2\ B1\ C1\ \[data\/IdnaTest\.txt\:1199\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}ꡀႾ🄂.𝨛\x{07E6}򄚍\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200DꡀႾ🄂\.𝨛\\u07E6򄚍\\u200C\'\)\ throws\ error\ P1\ V6\ V5\ C2\ B1\ C1\ \[data\/IdnaTest\.txt\:1200\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}ꡀႾ1,.𝨛\x{07E6}򄚍\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200DꡀႾ1\,\.𝨛\\u07E6򄚍\\u200C\'\)\ throws\ error\ P1\ V6\ V5\ C2\ B1\ C1\ \[data\/IdnaTest\.txt\:1201\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}ꡀႾ1,.𝨛\x{07E6}򄚍\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200DꡀႾ1\,\.𝨛\\u07E6򄚍\\u200C\'\)\ throws\ error\ P1\ V6\ V5\ C2\ B1\ C1\ \[data\/IdnaTest\.txt\:1202\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}ꡀⴞ1,.𝨛\x{07E6}򄚍\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200Dꡀⴞ1\,\.𝨛\\u07E6򄚍\\u200C\'\)\ throws\ error\ P1\ V6\ V5\ C2\ B1\ C1\ \[data\/IdnaTest\.txt\:1203\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}ꡀⴞ1,.𝨛\x{07E6}򄚍\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200Dꡀⴞ1\,\.𝨛\\u07E6򄚍\\u200C\'\)\ throws\ error\ P1\ V6\ V5\ C2\ B1\ C1\ \[data\/IdnaTest\.txt\:1204\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}ꡀⴞ🄂.𝨛\x{07E6}򄚍\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200Dꡀⴞ🄂\.𝨛\\u07E6򄚍\\u200C\'\)\ throws\ error\ P1\ V6\ V5\ C2\ B1\ C1\ \[data\/IdnaTest\.txt\:1205\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}ꡀⴞ🄂.𝨛\x{07E6}򄚍\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200Dꡀⴞ🄂\.𝨛\\u07E6򄚍\\u200C\'\)\ throws\ error\ P1\ V6\ V5\ C2\ B1\ C1\ \[data\/IdnaTest\.txt\:1206\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0665}ᡙ．\x{1BAA}񒂱⾆", %p)},	undef,	"to_unicode\(\'\\u0665ᡙ．\\u1BAA񒂱⾆\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1207\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0665}ᡙ.\x{1BAA}񒂱舌", %p)},	undef,	"to_unicode\(\'\\u0665ᡙ\.\\u1BAA񒂱舌\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1208\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㇕󠤹󏶍.񵧳", %p)},	undef,	"to_unicode\(\'㇕\󠤹󏶍\.񵧳\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1209\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠇜𞓇-򒬁.4Ⴄ\x{200C}", %p)},	undef,	"to_unicode\(\'\󠇜𞓇\-򒬁\.4Ⴄ\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1210\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠇜𞓇-򒬁.4Ⴄ\x{200C}", %p)},	undef,	"to_unicode\(\'\󠇜𞓇\-򒬁\.4Ⴄ\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1211\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠇜𞓇-򒬁.4ⴄ\x{200C}", %p)},	undef,	"to_unicode\(\'\󠇜𞓇\-򒬁\.4ⴄ\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1212\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠇜𞓇-򒬁.4ⴄ\x{200C}", %p)},	undef,	"to_unicode\(\'\󠇜𞓇\-򒬁\.4ⴄ\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1213\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᚭ｡󠫫ß\x{0825}", %p)},	undef,	"to_unicode\(\'ᚭ｡\󠫫ß\\u0825\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1214\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᚭ。󠫫ß\x{0825}", %p)},	undef,	"to_unicode\(\'ᚭ\。\󠫫ß\\u0825\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1215\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᚭ。󠫫SS\x{0825}", %p)},	undef,	"to_unicode\(\'ᚭ\。\󠫫SS\\u0825\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1216\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᚭ。󠫫ss\x{0825}", %p)},	undef,	"to_unicode\(\'ᚭ\。\󠫫ss\\u0825\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1217\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᚭ。󠫫Ss\x{0825}", %p)},	undef,	"to_unicode\(\'ᚭ\。\󠫫Ss\\u0825\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1218\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᚭ｡󠫫SS\x{0825}", %p)},	undef,	"to_unicode\(\'ᚭ｡\󠫫SS\\u0825\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1219\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᚭ｡󠫫ss\x{0825}", %p)},	undef,	"to_unicode\(\'ᚭ｡\󠫫ss\\u0825\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1220\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᚭ｡󠫫Ss\x{0825}", %p)},	undef,	"to_unicode\(\'ᚭ｡\󠫫Ss\\u0825\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1221\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("₁｡ᠻ\x{063D}", %p)},	undef,	"to_unicode\(\'₁｡ᠻ\\u063D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1222\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("1。ᠻ\x{063D}", %p)},	undef,	"to_unicode\(\'1\。ᠻ\\u063D\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1223\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("􎑪\x{200C}.\x{FE7E}񵐊𥏫", %p)},	undef,	"to_unicode\(\'􎑪\\u200C\.\\uFE7E񵐊𥏫\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1224\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("􎑪\x{200C}.\x{FE7E}񵐊𥏫", %p)},	undef,	"to_unicode\(\'􎑪\\u200C\.\\uFE7E񵐊𥏫\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1225\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("􎑪\x{200C}.\x{0020}\x{0652}񵐊𥏫", %p)},	undef,	"to_unicode\(\'􎑪\\u200C\.\\u0020\\u0652񵐊𥏫\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1226\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("􎑪\x{200C}.\x{0020}\x{0652}񵐊𥏫", %p)},	undef,	"to_unicode\(\'􎑪\\u200C\.\\u0020\\u0652񵐊𥏫\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1227\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝪤≯｡╎", %p)},	undef,	"to_unicode\(\'𝪤\≯｡\╎\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1228\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝪤>\x{0338}｡╎", %p)},	undef,	"to_unicode\(\'𝪤\>\\u0338｡\╎\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1229\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝪤≯。╎", %p)},	undef,	"to_unicode\(\'𝪤\≯\。\╎\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1230\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝪤>\x{0338}。╎", %p)},	undef,	"to_unicode\(\'𝪤\>\\u0338\。\╎\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1231\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴋ≮􋆞。\x{200D}\x{08EB}𐋣", %p)},	undef,	"to_unicode\(\'Ⴋ\≮􋆞\。\\u200D\\u08EB𐋣\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1232\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴋ≮􋆞。\x{200D}\x{08EB}𐋣", %p)},	undef,	"to_unicode\(\'Ⴋ\≮􋆞\。\\u200D\\u08EB𐋣\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1233\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴋ<\x{0338}􋆞。\x{200D}\x{08EB}𐋣", %p)},	undef,	"to_unicode\(\'Ⴋ\<\\u0338􋆞\。\\u200D\\u08EB𐋣\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1234\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴋ<\x{0338}􋆞。\x{200D}\x{08EB}𐋣", %p)},	undef,	"to_unicode\(\'Ⴋ\<\\u0338􋆞\。\\u200D\\u08EB𐋣\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1235\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴋ<\x{0338}􋆞。\x{200D}\x{08EB}𐋣", %p)},	undef,	"to_unicode\(\'ⴋ\<\\u0338􋆞\。\\u200D\\u08EB𐋣\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1236\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴋ<\x{0338}􋆞。\x{200D}\x{08EB}𐋣", %p)},	undef,	"to_unicode\(\'ⴋ\<\\u0338􋆞\。\\u200D\\u08EB𐋣\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1237\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴋ≮􋆞。\x{200D}\x{08EB}𐋣", %p)},	undef,	"to_unicode\(\'ⴋ\≮􋆞\。\\u200D\\u08EB𐋣\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1238\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴋ≮􋆞。\x{200D}\x{08EB}𐋣", %p)},	undef,	"to_unicode\(\'ⴋ\≮􋆞\。\\u200D\\u08EB𐋣\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1239\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑋪.򕱀≯", %p)},	undef,	"to_unicode\(\'𑋪\.򕱀\≯\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1240\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑋪.򕱀>\x{0338}", %p)},	undef,	"to_unicode\(\'𑋪\.򕱀\>\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1241\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򁟟\x{0C4D}．\x{A802}É\x{180B}𑘿", %p)},	undef,	"to_unicode\(\'򁟟\\u0C4D．\\uA802É\\u180B𑘿\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1242\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򁟟\x{0C4D}．\x{A802}E\x{0301}\x{180B}𑘿", %p)},	undef,	"to_unicode\(\'򁟟\\u0C4D．\\uA802E\\u0301\\u180B𑘿\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1243\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򁟟\x{0C4D}.\x{A802}É\x{180B}𑘿", %p)},	undef,	"to_unicode\(\'򁟟\\u0C4D\.\\uA802É\\u180B𑘿\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1244\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򁟟\x{0C4D}.\x{A802}E\x{0301}\x{180B}𑘿", %p)},	undef,	"to_unicode\(\'򁟟\\u0C4D\.\\uA802E\\u0301\\u180B𑘿\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1245\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򁟟\x{0C4D}.\x{A802}e\x{0301}\x{180B}𑘿", %p)},	undef,	"to_unicode\(\'򁟟\\u0C4D\.\\uA802e\\u0301\\u180B𑘿\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1246\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򁟟\x{0C4D}.\x{A802}é\x{180B}𑘿", %p)},	undef,	"to_unicode\(\'򁟟\\u0C4D\.\\uA802é\\u180B𑘿\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1247\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򁟟\x{0C4D}．\x{A802}e\x{0301}\x{180B}𑘿", %p)},	undef,	"to_unicode\(\'򁟟\\u0C4D．\\uA802e\\u0301\\u180B𑘿\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1248\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򁟟\x{0C4D}．\x{A802}é\x{180B}𑘿", %p)},	undef,	"to_unicode\(\'򁟟\\u0C4D．\\uA802é\\u180B𑘿\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1249\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡶ\x{200D}𑖿｡︒ꡒ", %p)},	undef,	"to_unicode\(\'ᡶ\\u200D𑖿｡︒ꡒ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1250\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡶ\x{200D}𑖿｡︒ꡒ", %p)},	undef,	"to_unicode\(\'ᡶ\\u200D𑖿｡︒ꡒ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1251\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ᡶ\x{200D}𑖿。。ꡒ", %p)},	undef,	"to_unicode\(\'ᡶ\\u200D𑖿\。\。ꡒ\'\)\ throws\ error\ C2\ A4_2\ \[data\/IdnaTest\.txt\:1252\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ᡶ\x{200D}𑖿。。ꡒ", %p)},	undef,	"to_unicode\(\'ᡶ\\u200D𑖿\。\。ꡒ\'\)\ throws\ error\ C2\ A4_2\ \[data\/IdnaTest\.txt\:1253\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𐵞񱐾\x{1BF3}\x{200C}｡ᡏ\x{FE0B}≮", %p)},	undef,	"to_unicode\(\'𐵞񱐾\\u1BF3\\u200C｡ᡏ\\uFE0B\≮\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1254\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐵞񱐾\x{1BF3}\x{200C}｡ᡏ\x{FE0B}<\x{0338}", %p)},	undef,	"to_unicode\(\'𐵞񱐾\\u1BF3\\u200C｡ᡏ\\uFE0B\<\\u0338\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1255\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐵞񱐾\x{1BF3}\x{200C}。ᡏ\x{FE0B}≮", %p)},	undef,	"to_unicode\(\'𐵞񱐾\\u1BF3\\u200C\。ᡏ\\uFE0B\≮\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1256\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐵞񱐾\x{1BF3}\x{200C}。ᡏ\x{FE0B}<\x{0338}", %p)},	undef,	"to_unicode\(\'𐵞񱐾\\u1BF3\\u200C\。ᡏ\\uFE0B\<\\u0338\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1257\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴣ．\x{0325}ꡇ", %p)},	undef,	"to_unicode\(\'Ⴣ．\\u0325ꡇ\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1258\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴣ.\x{0325}ꡇ", %p)},	undef,	"to_unicode\(\'Ⴣ\.\\u0325ꡇ\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1259\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ⴣ.\x{0325}ꡇ", %p)},	undef,	"to_unicode\(\'ⴣ\.\\u0325ꡇ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1260\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ⴣ．\x{0325}ꡇ", %p)},	undef,	"to_unicode\(\'ⴣ．\\u0325ꡇ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1261\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⟯𐮙．󂮼𫜏Ⴤ񨋴", %p)},	undef,	"to_unicode\(\'\⟯𐮙．󂮼𫜏Ⴤ񨋴\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1262\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⟯𐮙.󂮼𫜏Ⴤ񨋴", %p)},	undef,	"to_unicode\(\'\⟯𐮙\.󂮼𫜏Ⴤ񨋴\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1263\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⟯𐮙.󂮼𫜏ⴤ񨋴", %p)},	undef,	"to_unicode\(\'\⟯𐮙\.󂮼𫜏ⴤ񨋴\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1264\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⟯𐮙．󂮼𫜏ⴤ񨋴", %p)},	undef,	"to_unicode\(\'\⟯𐮙．󂮼𫜏ⴤ񨋴\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1265\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DCD}𝨮≮．🀴", %p)},	undef,	"to_unicode\(\'\\u1DCD𝨮\≮．🀴\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1266\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DCD}𝨮<\x{0338}．🀴", %p)},	undef,	"to_unicode\(\'\\u1DCD𝨮\<\\u0338．🀴\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1267\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DCD}𝨮≮.🀴", %p)},	undef,	"to_unicode\(\'\\u1DCD𝨮\≮\.🀴\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1268\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DCD}𝨮<\x{0338}.🀴", %p)},	undef,	"to_unicode\(\'\\u1DCD𝨮\<\\u0338\.🀴\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1269\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹦𞳸≮Ⴢ．Ⴃ", %p)},	undef,	"to_unicode\(\'𐹦𞳸\≮Ⴢ．Ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1270\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹦𞳸<\x{0338}Ⴢ．Ⴃ", %p)},	undef,	"to_unicode\(\'𐹦𞳸\<\\u0338Ⴢ．Ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1271\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹦𞳸≮Ⴢ.Ⴃ", %p)},	undef,	"to_unicode\(\'𐹦𞳸\≮Ⴢ\.Ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1272\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹦𞳸<\x{0338}Ⴢ.Ⴃ", %p)},	undef,	"to_unicode\(\'𐹦𞳸\<\\u0338Ⴢ\.Ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1273\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹦𞳸<\x{0338}ⴢ.ⴃ", %p)},	undef,	"to_unicode\(\'𐹦𞳸\<\\u0338ⴢ\.ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1274\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹦𞳸≮ⴢ.ⴃ", %p)},	undef,	"to_unicode\(\'𐹦𞳸\≮ⴢ\.ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1275\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹦𞳸≮Ⴢ.ⴃ", %p)},	undef,	"to_unicode\(\'𐹦𞳸\≮Ⴢ\.ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1276\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹦𞳸<\x{0338}Ⴢ.ⴃ", %p)},	undef,	"to_unicode\(\'𐹦𞳸\<\\u0338Ⴢ\.ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1277\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹦𞳸<\x{0338}ⴢ．ⴃ", %p)},	undef,	"to_unicode\(\'𐹦𞳸\<\\u0338ⴢ．ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1278\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹦𞳸≮ⴢ．ⴃ", %p)},	undef,	"to_unicode\(\'𐹦𞳸\≮ⴢ．ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1279\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹦𞳸≮Ⴢ．ⴃ", %p)},	undef,	"to_unicode\(\'𐹦𞳸\≮Ⴢ．ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1280\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹦𞳸<\x{0338}Ⴢ．ⴃ", %p)},	undef,	"to_unicode\(\'𐹦𞳸\<\\u0338Ⴢ．ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1281\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{A8E7}。-", %p)},	undef,	"to_unicode\(\'\\uA8E7\。\-\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:1282\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𑋪𽣟󠽐｡饈≠𐹻", %p)},	undef,	"to_unicode\(\'𑋪𽣟\󠽐｡饈\≠𐹻\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1283\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑋪𽣟󠽐｡饈=\x{0338}𐹻", %p)},	undef,	"to_unicode\(\'𑋪𽣟\󠽐｡饈\=\\u0338𐹻\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1284\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑋪𽣟󠽐。饈≠𐹻", %p)},	undef,	"to_unicode\(\'𑋪𽣟\󠽐\。饈\≠𐹻\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1285\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑋪𽣟󠽐。饈=\x{0338}𐹻", %p)},	undef,	"to_unicode\(\'𑋪𽣟\󠽐\。饈\=\\u0338𐹻\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1286\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{067A}𐫫⁷｡≯邅󠃞4", %p)},	undef,	"to_unicode\(\'\\u067A𐫫⁷｡\≯邅\󠃞4\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1287\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{067A}𐫫⁷｡>\x{0338}邅󠃞4", %p)},	undef,	"to_unicode\(\'\\u067A𐫫⁷｡\>\\u0338邅\󠃞4\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1288\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{067A}𐫫7。≯邅󠃞4", %p)},	undef,	"to_unicode\(\'\\u067A𐫫7\。\≯邅\󠃞4\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1289\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{067A}𐫫7。>\x{0338}邅󠃞4", %p)},	undef,	"to_unicode\(\'\\u067A𐫫7\。\>\\u0338邅\󠃞4\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1290\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񱙏ᡇ-𝨊.\x{0665}𐋫𐹶򍙹", %p)},	undef,	"to_unicode\(\'񱙏ᡇ\-𝨊\.\\u0665𐋫𐹶򍙹\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1291\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񎹶ᠴ\x{0B41}.넨-󶗾", %p)},	undef,	"to_unicode\(\'񎹶ᠴ\\u0B41\.넨\-󶗾\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1292\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񎹶ᠴ\x{0B41}.넨-󶗾", %p)},	undef,	"to_unicode\(\'񎹶ᠴ\\u0B41\.넨\-󶗾\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1293\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{076E}\x{06CC}\x{200D}⒈。𐋣-", %p)},	undef,	"to_unicode\(\'\\u076E\\u06CC\\u200D⒈\。𐋣\-\'\)\ throws\ error\ P1\ V6\ V3\ C2\ \[data\/IdnaTest\.txt\:1294\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{076E}\x{06CC}\x{200D}⒈。𐋣-", %p)},	undef,	"to_unicode\(\'\\u076E\\u06CC\\u200D⒈\。𐋣\-\'\)\ throws\ error\ P1\ V6\ V3\ C2\ \[data\/IdnaTest\.txt\:1295\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{076E}\x{06CC}\x{200D}1.。𐋣-", %p)},	undef,	"to_unicode\(\'\\u076E\\u06CC\\u200D1\.\。𐋣\-\'\)\ throws\ error\ V3\ C2\ A4_2\ \[data\/IdnaTest\.txt\:1296\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{076E}\x{06CC}\x{200D}1.。𐋣-", %p)},	undef,	"to_unicode\(\'\\u076E\\u06CC\\u200D1\.\。𐋣\-\'\)\ throws\ error\ V3\ C2\ A4_2\ \[data\/IdnaTest\.txt\:1297\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴌ。󭾖𞥉", %p)},	undef,	"to_unicode\(\'Ⴌ\。󭾖𞥉\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1298\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴌ。󭾖𞥉", %p)},	undef,	"to_unicode\(\'ⴌ\。󭾖𞥉\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1299\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡒ𐠗.\x{17D2}󠄓-󩚨", %p)},	undef,	"to_unicode\(\'ᡒ𐠗\.\\u17D2\󠄓\-󩚨\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1300\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈󊻊\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'⒈󊻊\\u200D\-\。웈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:1301\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈󊻊\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'⒈󊻊\\u200D\-\。웈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:1302\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈󊻊\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'⒈󊻊\\u200D\-\。웈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:1303\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈󊻊\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'⒈󊻊\\u200D\-\。웈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:1304\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.󊻊\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'1\.󊻊\\u200D\-\。웈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:1305\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.󊻊\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'1\.󊻊\\u200D\-\。웈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:1306\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.󊻊\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'1\.󊻊\\u200D\-\。웈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:1307\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.󊻊\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'1\.󊻊\\u200D\-\。웈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:1308\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("て。\x{200C}㇎𐨸", %p)},	undef,	"to_unicode\(\'て\。\\u200C㇎𐨸\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:1309\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("て。\x{200C}㇎𐨸", %p)},	undef,	"to_unicode\(\'て\。\\u200C㇎𐨸\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:1310\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--m9j.xn--wkk6036d", %p)},	"て.㇎𐨸",	"to_unicode\(\'xn\-\-m9j\.xn\-\-wkk6036d\'\)\ \[data\/IdnaTest\.txt\:1311\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("て.㇎𐨸", %p)},	"て.㇎𐨸",	"to_unicode\(\'て\.㇎𐨸\'\)\ \[data\/IdnaTest\.txt\:1312\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("ς｡\x{A8C4}\x{1712}", %p)},	undef,	"to_unicode\(\'ς｡\\uA8C4\\u1712\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1313\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("ς。\x{A8C4}\x{1712}", %p)},	undef,	"to_unicode\(\'ς\。\\uA8C4\\u1712\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1314\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("Σ。\x{A8C4}\x{1712}", %p)},	undef,	"to_unicode\(\'Σ\。\\uA8C4\\u1712\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1315\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("σ。\x{A8C4}\x{1712}", %p)},	undef,	"to_unicode\(\'σ\。\\uA8C4\\u1712\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1316\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("Σ｡\x{A8C4}\x{1712}", %p)},	undef,	"to_unicode\(\'Σ｡\\uA8C4\\u1712\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1317\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("σ｡\x{A8C4}\x{1712}", %p)},	undef,	"to_unicode\(\'σ｡\\uA8C4\\u1712\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1318\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𑈵󡚑񟺼.ႢႵ", %p)},	undef,	"to_unicode\(\'𑈵󡚑񟺼\.ႢႵ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1319\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑈵󡚑񟺼.ⴂⴕ", %p)},	undef,	"to_unicode\(\'𑈵󡚑񟺼\.ⴂⴕ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1320\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑈵󡚑񟺼.Ⴂⴕ", %p)},	undef,	"to_unicode\(\'𑈵󡚑񟺼\.Ⴂⴕ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1321\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🀾🄈⾛\x{0741}．\x{200D}󡉠\x{068D}", %p)},	undef,	"to_unicode\(\'🀾🄈⾛\\u0741．\\u200D󡉠\\u068D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1322\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🀾🄈⾛\x{0741}．\x{200D}󡉠\x{068D}", %p)},	undef,	"to_unicode\(\'🀾🄈⾛\\u0741．\\u200D󡉠\\u068D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1323\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🀾7,走\x{0741}.\x{200D}󡉠\x{068D}", %p)},	undef,	"to_unicode\(\'🀾7\,走\\u0741\.\\u200D󡉠\\u068D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1324\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🀾7,走\x{0741}.\x{200D}󡉠\x{068D}", %p)},	undef,	"to_unicode\(\'🀾7\,走\\u0741\.\\u200D󡉠\\u068D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1325\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡙ｡Ӏ򧥽", %p)},	undef,	"to_unicode\(\'ᡙ｡Ӏ򧥽\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1326\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡙ。Ӏ򧥽", %p)},	undef,	"to_unicode\(\'ᡙ\。Ӏ򧥽\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1327\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡙ。ӏ򧥽", %p)},	undef,	"to_unicode\(\'ᡙ\。ӏ򧥽\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1328\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡙ｡ӏ򧥽", %p)},	undef,	"to_unicode\(\'ᡙ｡ӏ򧥽\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1329\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0666}-。񅭣⺖ᄾ", %p)},	undef,	"to_unicode\(\'\\u0666\-\。񅭣⺖ᄾ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1330\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("-𐋷󠇐。\x{07EF}", %p)},	undef,	"to_unicode\(\'\-𐋷\󠇐\。\\u07EF\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:1331\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}𐹴󠴚멈.\x{2D7F}􍼶", %p)},	undef,	"to_unicode\(\'\\u200C𐹴\󠴚멈\.\\u2D7F􍼶\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:1332\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}𐹴󠴚멈.\x{2D7F}􍼶", %p)},	undef,	"to_unicode\(\'\\u200C𐹴\󠴚멈\.\\u2D7F􍼶\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:1333\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}𐹴󠴚멈.\x{2D7F}􍼶", %p)},	undef,	"to_unicode\(\'\\u200C𐹴\󠴚멈\.\\u2D7F􍼶\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:1334\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}𐹴󠴚멈.\x{2D7F}􍼶", %p)},	undef,	"to_unicode\(\'\\u200C𐹴\󠴚멈\.\\u2D7F􍼶\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:1335\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮.ᢣ𐹵", %p)},	undef,	"to_unicode\(\'\≮\.ᢣ𐹵\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1336\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}.ᢣ𐹵", %p)},	undef,	"to_unicode\(\'\<\\u0338\.ᢣ𐹵\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1337\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞤴⾆｡\x{200C}𑘿񡭠𐲈", %p)},	undef,	"to_unicode\(\'𞤴⾆｡\\u200C𑘿񡭠𐲈\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:1338\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞤴⾆｡\x{200C}𑘿񡭠𐲈", %p)},	undef,	"to_unicode\(\'𞤴⾆｡\\u200C𑘿񡭠𐲈\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:1339\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞤴舌。\x{200C}𑘿񡭠𐲈", %p)},	undef,	"to_unicode\(\'𞤴舌\。\\u200C𑘿񡭠𐲈\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:1340\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞤴舌。\x{200C}𑘿񡭠𐲈", %p)},	undef,	"to_unicode\(\'𞤴舌\。\\u200C𑘿񡭠𐲈\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:1341\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴠ-.𝟷ς𞷼ς", %p)},	undef,	"to_unicode\(\'\\u200CჀ\-\.𝟷ς𞷼ς\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1342\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴠ-.𝟷ς𞷼ς", %p)},	undef,	"to_unicode\(\'\\u200CჀ\-\.𝟷ς𞷼ς\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1343\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴠ-.1ς𞷼ς", %p)},	undef,	"to_unicode\(\'\\u200CჀ\-\.1ς𞷼ς\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1344\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴠ-.1ς𞷼ς", %p)},	undef,	"to_unicode\(\'\\u200CჀ\-\.1ς𞷼ς\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1345\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴠ-.1ς𞷼ς", %p)},	undef,	"to_unicode\(\'\\u200Cⴠ\-\.1ς𞷼ς\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1346\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴠ-.1ς𞷼ς", %p)},	undef,	"to_unicode\(\'\\u200Cⴠ\-\.1ς𞷼ς\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1347\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴠ-.1Σ𞷼Σ", %p)},	undef,	"to_unicode\(\'\\u200CჀ\-\.1Σ𞷼Σ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1348\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴠ-.1Σ𞷼Σ", %p)},	undef,	"to_unicode\(\'\\u200CჀ\-\.1Σ𞷼Σ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1349\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴠ-.1σ𞷼σ", %p)},	undef,	"to_unicode\(\'\\u200Cⴠ\-\.1σ𞷼σ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1350\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴠ-.1σ𞷼σ", %p)},	undef,	"to_unicode\(\'\\u200Cⴠ\-\.1σ𞷼σ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1351\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴠ-.𝟷ς𞷼ς", %p)},	undef,	"to_unicode\(\'\\u200Cⴠ\-\.𝟷ς𞷼ς\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1352\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴠ-.𝟷ς𞷼ς", %p)},	undef,	"to_unicode\(\'\\u200Cⴠ\-\.𝟷ς𞷼ς\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1353\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴠ-.𝟷Σ𞷼Σ", %p)},	undef,	"to_unicode\(\'\\u200CჀ\-\.𝟷Σ𞷼Σ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1354\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴠ-.𝟷Σ𞷼Σ", %p)},	undef,	"to_unicode\(\'\\u200CჀ\-\.𝟷Σ𞷼Σ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1355\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴠ-.𝟷σ𞷼σ", %p)},	undef,	"to_unicode\(\'\\u200Cⴠ\-\.𝟷σ𞷼σ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1356\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴠ-.𝟷σ𞷼σ", %p)},	undef,	"to_unicode\(\'\\u200Cⴠ\-\.𝟷σ𞷼σ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1357\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0E4C}\x{18A9}󸥿｡𝟪Ⴜ", %p)},	undef,	"to_unicode\(\'\\u0E4C\\u18A9󸥿｡𝟪Ⴜ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1358\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0E4C}\x{18A9}󸥿。8Ⴜ", %p)},	undef,	"to_unicode\(\'\\u0E4C\\u18A9󸥿\。8Ⴜ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1359\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0E4C}\x{18A9}󸥿。8ⴜ", %p)},	undef,	"to_unicode\(\'\\u0E4C\\u18A9󸥿\。8ⴜ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1360\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0E4C}\x{18A9}󸥿｡𝟪ⴜ", %p)},	undef,	"to_unicode\(\'\\u0E4C\\u18A9󸥿｡𝟪ⴜ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1361\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("䪏\x{0640}᠇𑓀｡뭕𐫃\x{1072}", %p)},	undef,	"to_unicode\(\'䪏\\u0640᠇𑓀｡뭕𐫃\\u1072\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1362\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("䪏\x{0640}᠇𑓀｡뭕𐫃\x{1072}", %p)},	undef,	"to_unicode\(\'䪏\\u0640᠇𑓀｡뭕𐫃\\u1072\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1363\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("䪏\x{0640}᠇𑓀。뭕𐫃\x{1072}", %p)},	undef,	"to_unicode\(\'䪏\\u0640᠇𑓀\。뭕𐫃\\u1072\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1364\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("䪏\x{0640}᠇𑓀。뭕𐫃\x{1072}", %p)},	undef,	"to_unicode\(\'䪏\\u0640᠇𑓀\。뭕𐫃\\u1072\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1365\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𑍍｡󠙉󠇂", %p)},	undef,	"to_unicode\(\'𑍍｡\󠙉\󠇂\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1366\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑍍。󠙉󠇂", %p)},	undef,	"to_unicode\(\'𑍍\。\󠙉\󠇂\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1367\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𙞤󠁧。ς\x{200D}\x{0600}𑄴", %p)},	undef,	"to_unicode\(\'𙞤\󠁧\。ς\\u200D\\u0600𑄴\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:1368\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𙞤󠁧。ς\x{200D}\x{0600}𑄴", %p)},	undef,	"to_unicode\(\'𙞤\󠁧\。ς\\u200D\\u0600𑄴\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:1369\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𙞤󠁧。Σ\x{200D}\x{0600}𑄴", %p)},	undef,	"to_unicode\(\'𙞤\󠁧\。Σ\\u200D\\u0600𑄴\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:1370\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𙞤󠁧。Σ\x{200D}\x{0600}𑄴", %p)},	undef,	"to_unicode\(\'𙞤\󠁧\。Σ\\u200D\\u0600𑄴\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:1371\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𙞤󠁧。σ\x{200D}\x{0600}𑄴", %p)},	undef,	"to_unicode\(\'𙞤\󠁧\。σ\\u200D\\u0600𑄴\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:1372\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𙞤󠁧。σ\x{200D}\x{0600}𑄴", %p)},	undef,	"to_unicode\(\'𙞤\󠁧\。σ\\u200D\\u0600𑄴\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:1373\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{0842}\x{07CB}𑄳．\x{0DCA}", %p)},	undef,	"to_unicode\(\'\\u0842\\u07CB𑄳．\\u0DCA\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1374\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{0842}\x{07CB}𑄳.\x{0DCA}", %p)},	undef,	"to_unicode\(\'\\u0842\\u07CB𑄳\.\\u0DCA\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1375\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("󋮸󑧠񛎑-。\x{200C}", %p)},	undef,	"to_unicode\(\'󋮸󑧠񛎑\-\。\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:1376\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󋮸󑧠񛎑-。\x{200C}", %p)},	undef,	"to_unicode\(\'󋮸󑧠񛎑\-\。\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:1377\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐹵．𞡮", %p)},	undef,	"to_unicode\(\'𐹵．𞡮\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:1378\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐹵.𞡮", %p)},	undef,	"to_unicode\(\'𐹵\.𞡮\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:1379\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-ᢉ｡Ↄ", %p)},	undef,	"to_unicode\(\'\-ᢉ｡Ↄ\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1380\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-ᢉ。Ↄ", %p)},	undef,	"to_unicode\(\'\-ᢉ\。Ↄ\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1381\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("-ᢉ。ↄ", %p)},	undef,	"to_unicode\(\'\-ᢉ\。ↄ\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1382\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("-ᢉ｡ↄ", %p)},	undef,	"to_unicode\(\'\-ᢉ｡ↄ\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1383\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}-︒\x{0817}。ß哑\x{200C}𞤆", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\\u0817\。ß哑\\u200C𞤆\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1384\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-︒\x{0817}。ß哑\x{200C}𞤆", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\\u0817\。ß哑\\u200C𞤆\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1385\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-。\x{0817}。ß哑\x{200C}𞤆", %p)},	undef,	"to_unicode\(\'\\u200D\-\。\\u0817\。ß哑\\u200C𞤆\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1386\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-。\x{0817}。ß哑\x{200C}𞤆", %p)},	undef,	"to_unicode\(\'\\u200D\-\。\\u0817\。ß哑\\u200C𞤆\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1387\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-。\x{0817}。SS哑\x{200C}𞤆", %p)},	undef,	"to_unicode\(\'\\u200D\-\。\\u0817\。SS哑\\u200C𞤆\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1388\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-。\x{0817}。SS哑\x{200C}𞤆", %p)},	undef,	"to_unicode\(\'\\u200D\-\。\\u0817\。SS哑\\u200C𞤆\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1389\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-。\x{0817}。ss哑\x{200C}𞤆", %p)},	undef,	"to_unicode\(\'\\u200D\-\。\\u0817\。ss哑\\u200C𞤆\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1390\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-。\x{0817}。ss哑\x{200C}𞤆", %p)},	undef,	"to_unicode\(\'\\u200D\-\。\\u0817\。ss哑\\u200C𞤆\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1391\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-。\x{0817}。Ss哑\x{200C}𞤆", %p)},	undef,	"to_unicode\(\'\\u200D\-\。\\u0817\。Ss哑\\u200C𞤆\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1392\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-。\x{0817}。Ss哑\x{200C}𞤆", %p)},	undef,	"to_unicode\(\'\\u200D\-\。\\u0817\。Ss哑\\u200C𞤆\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1393\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-︒\x{0817}。SS哑\x{200C}𞤆", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\\u0817\。SS哑\\u200C𞤆\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1394\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-︒\x{0817}。SS哑\x{200C}𞤆", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\\u0817\。SS哑\\u200C𞤆\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1395\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-︒\x{0817}。ss哑\x{200C}𞤆", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\\u0817\。ss哑\\u200C𞤆\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1396\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-︒\x{0817}。ss哑\x{200C}𞤆", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\\u0817\。ss哑\\u200C𞤆\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1397\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-︒\x{0817}。Ss哑\x{200C}𞤆", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\\u0817\。Ss哑\\u200C𞤆\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1398\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-︒\x{0817}。Ss哑\x{200C}𞤆", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\\u0817\。Ss哑\\u200C𞤆\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1399\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒．𑂵\x{1BAB}", %p)},	undef,	"to_unicode\(\'︒．𑂵\\u1BAB\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1400\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("。.𑂵\x{1BAB}", %p)},	undef,	"to_unicode\(\'\。\.𑂵\\u1BAB\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1401\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{07AB}。\x{200D}", %p)},	undef,	"to_unicode\(\'\\u07AB\。\\u200D\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:1402\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07AB}。\x{200D}", %p)},	undef,	"to_unicode\(\'\\u07AB\。\\u200D\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:1403\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}⥤｡𞶣", %p)},	undef,	"to_unicode\(\'\\u200D\⥤｡𞶣\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1404\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}⥤｡𞶣", %p)},	undef,	"to_unicode\(\'\\u200D\⥤｡𞶣\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1405\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}⥤。𞶣", %p)},	undef,	"to_unicode\(\'\\u200D\⥤\。𞶣\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1406\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}⥤。𞶣", %p)},	undef,	"to_unicode\(\'\\u200D\⥤\。𞶣\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1407\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-Ⴄ𝟢\x{0669}．\x{1C32}ς", %p)},	undef,	"to_unicode\(\'\-Ⴄ𝟢\\u0669．\\u1C32ς\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1408\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-Ⴄ0\x{0669}.\x{1C32}ς", %p)},	undef,	"to_unicode\(\'\-Ⴄ0\\u0669\.\\u1C32ς\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1409\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("-ⴄ0\x{0669}.\x{1C32}ς", %p)},	undef,	"to_unicode\(\'\-ⴄ0\\u0669\.\\u1C32ς\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:1410\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-Ⴄ0\x{0669}.\x{1C32}Σ", %p)},	undef,	"to_unicode\(\'\-Ⴄ0\\u0669\.\\u1C32Σ\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1411\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("-ⴄ0\x{0669}.\x{1C32}σ", %p)},	undef,	"to_unicode\(\'\-ⴄ0\\u0669\.\\u1C32σ\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:1412\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("-ⴄ𝟢\x{0669}．\x{1C32}ς", %p)},	undef,	"to_unicode\(\'\-ⴄ𝟢\\u0669．\\u1C32ς\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:1413\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-Ⴄ𝟢\x{0669}．\x{1C32}Σ", %p)},	undef,	"to_unicode\(\'\-Ⴄ𝟢\\u0669．\\u1C32Σ\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1414\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("-ⴄ𝟢\x{0669}．\x{1C32}σ", %p)},	undef,	"to_unicode\(\'\-ⴄ𝟢\\u0669．\\u1C32σ\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:1415\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("򟣀。-", %p)},	undef,	"to_unicode\(\'򟣀\。\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1416\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋠𐋮．񓓍𑖴ß≯", %p)},	undef,	"to_unicode\(\'\⋠𐋮．񓓍𑖴ß\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1417\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≼\x{0338}𐋮．񓓍𑖴ß>\x{0338}", %p)},	undef,	"to_unicode\(\'\≼\\u0338𐋮．񓓍𑖴ß\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1418\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋠𐋮.񓓍𑖴ß≯", %p)},	undef,	"to_unicode\(\'\⋠𐋮\.񓓍𑖴ß\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1419\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≼\x{0338}𐋮.񓓍𑖴ß>\x{0338}", %p)},	undef,	"to_unicode\(\'\≼\\u0338𐋮\.񓓍𑖴ß\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1420\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≼\x{0338}𐋮.񓓍𑖴SS>\x{0338}", %p)},	undef,	"to_unicode\(\'\≼\\u0338𐋮\.񓓍𑖴SS\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1421\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋠𐋮.񓓍𑖴SS≯", %p)},	undef,	"to_unicode\(\'\⋠𐋮\.񓓍𑖴SS\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1422\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋠𐋮.񓓍𑖴ss≯", %p)},	undef,	"to_unicode\(\'\⋠𐋮\.񓓍𑖴ss\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1423\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≼\x{0338}𐋮.񓓍𑖴ss>\x{0338}", %p)},	undef,	"to_unicode\(\'\≼\\u0338𐋮\.񓓍𑖴ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1424\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≼\x{0338}𐋮.񓓍𑖴Ss>\x{0338}", %p)},	undef,	"to_unicode\(\'\≼\\u0338𐋮\.񓓍𑖴Ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1425\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋠𐋮.񓓍𑖴Ss≯", %p)},	undef,	"to_unicode\(\'\⋠𐋮\.񓓍𑖴Ss\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1426\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≼\x{0338}𐋮．񓓍𑖴SS>\x{0338}", %p)},	undef,	"to_unicode\(\'\≼\\u0338𐋮．񓓍𑖴SS\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1427\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋠𐋮．񓓍𑖴SS≯", %p)},	undef,	"to_unicode\(\'\⋠𐋮．񓓍𑖴SS\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1428\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋠𐋮．񓓍𑖴ss≯", %p)},	undef,	"to_unicode\(\'\⋠𐋮．񓓍𑖴ss\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1429\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≼\x{0338}𐋮．񓓍𑖴ss>\x{0338}", %p)},	undef,	"to_unicode\(\'\≼\\u0338𐋮．񓓍𑖴ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1430\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≼\x{0338}𐋮．񓓍𑖴Ss>\x{0338}", %p)},	undef,	"to_unicode\(\'\≼\\u0338𐋮．񓓍𑖴Ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1431\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋠𐋮．񓓍𑖴Ss≯", %p)},	undef,	"to_unicode\(\'\⋠𐋮．񓓍𑖴Ss\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1432\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1𐋸\x{0662}｡𑋥\x{08DE}򫰮", %p)},	undef,	"to_unicode\(\'1𐋸\\u0662｡𑋥\\u08DE򫰮\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1433\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1𐋸\x{0662}。𑋥\x{08DE}򫰮", %p)},	undef,	"to_unicode\(\'1𐋸\\u0662\。𑋥\\u08DE򫰮\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1434\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("儭-｡\x{0663}Ⴢ򈡄\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-｡\\u0663Ⴢ򈡄\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1435\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("儭-｡\x{0663}Ⴢ򈡄\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-｡\\u0663Ⴢ򈡄\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1436\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("儭-。\x{0663}Ⴢ򈡄\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-\。\\u0663Ⴢ򈡄\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1437\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("儭-。\x{0663}Ⴢ򈡄\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-\。\\u0663Ⴢ򈡄\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1438\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("儭-。\x{0663}ⴢ򈡄\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-\。\\u0663ⴢ򈡄\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1439\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("儭-。\x{0663}ⴢ򈡄\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-\。\\u0663ⴢ򈡄\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1440\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("儭-｡\x{0663}ⴢ򈡄\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-｡\\u0663ⴢ򈡄\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1441\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("儭-｡\x{0663}ⴢ򈡄\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-｡\\u0663ⴢ򈡄\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1442\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟺𐋷\x{0845}．ᡀ𚎑", %p)},	undef,	"to_unicode\(\'𝟺𐋷\\u0845．ᡀ𚎑\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1443\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4𐋷\x{0845}.ᡀ𚎑", %p)},	undef,	"to_unicode\(\'4𐋷\\u0845\.ᡀ𚎑\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1444\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯-\x{06BE}\x{20D4}.⒈𐹱", %p)},	undef,	"to_unicode\(\'\≯\-\\u06BE\\u20D4\.⒈𐹱\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1445\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}-\x{06BE}\x{20D4}.⒈𐹱", %p)},	undef,	"to_unicode\(\'\>\\u0338\-\\u06BE\\u20D4\.⒈𐹱\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1446\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯-\x{06BE}\x{20D4}.1.𐹱", %p)},	undef,	"to_unicode\(\'\≯\-\\u06BE\\u20D4\.1\.𐹱\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1447\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}-\x{06BE}\x{20D4}.1.𐹱", %p)},	undef,	"to_unicode\(\'\>\\u0338\-\\u06BE\\u20D4\.1\.𐹱\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1448\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝩔．󚝷蚀", %p)},	undef,	"to_unicode\(\'𝩔．󚝷蚀\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1449\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝩔.󚝷蚀", %p)},	undef,	"to_unicode\(\'𝩔\.󚝷蚀\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1450\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0867}Ⴘ.𞮸\x{0F84}ß\x{102D}", %p)},	undef,	"to_unicode\(\'\\u0867Ⴘ\.𞮸\\u0F84ß\\u102D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1451\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0867}ⴘ.𞮸\x{0F84}ß\x{102D}", %p)},	undef,	"to_unicode\(\'\\u0867ⴘ\.𞮸\\u0F84ß\\u102D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1452\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0867}Ⴘ.𞮸\x{0F84}SS\x{102D}", %p)},	undef,	"to_unicode\(\'\\u0867Ⴘ\.𞮸\\u0F84SS\\u102D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1453\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0867}ⴘ.𞮸\x{0F84}ss\x{102D}", %p)},	undef,	"to_unicode\(\'\\u0867ⴘ\.𞮸\\u0F84ss\\u102D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1454\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0867}Ⴘ.𞮸\x{0F84}Ss\x{102D}", %p)},	undef,	"to_unicode\(\'\\u0867Ⴘ\.𞮸\\u0F84Ss\\u102D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1455\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FAD}\x{0605}󋧄｡凬", %p)},	undef,	"to_unicode\(\'\\u0FAD\\u0605󋧄｡凬\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1456\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FAD}\x{0605}󋧄。凬", %p)},	undef,	"to_unicode\(\'\\u0FAD\\u0605󋧄\。凬\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1457\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⇿🄈\x{200D}𐮀｡\x{1734}", %p)},	undef,	"to_unicode\(\'\⇿🄈\\u200D𐮀｡\\u1734\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1458\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⇿🄈\x{200D}𐮀｡\x{1734}", %p)},	undef,	"to_unicode\(\'\⇿🄈\\u200D𐮀｡\\u1734\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1459\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⇿7,\x{200D}𐮀。\x{1734}", %p)},	undef,	"to_unicode\(\'\⇿7\,\\u200D𐮀\。\\u1734\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1460\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⇿7,\x{200D}𐮀。\x{1734}", %p)},	undef,	"to_unicode\(\'\⇿7\,\\u200D𐮀\。\\u1734\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1461\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{08A3}。𑋪\x{062B}", %p)},	undef,	"to_unicode\(\'\\u08A3\。𑋪\\u062B\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1462\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0743}≮.\x{0E36}", %p)},	undef,	"to_unicode\(\'\\u0743\≮\.\\u0E36\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1463\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0743}<\x{0338}.\x{0E36}", %p)},	undef,	"to_unicode\(\'\\u0743\<\\u0338\.\\u0E36\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1464\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴢ≯褦．ᢋꡱႾ\x{0679}", %p)},	undef,	"to_unicode\(\'Ⴢ\≯褦．ᢋꡱႾ\\u0679\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1465\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴢ>\x{0338}褦．ᢋꡱႾ\x{0679}", %p)},	undef,	"to_unicode\(\'Ⴢ\>\\u0338褦．ᢋꡱႾ\\u0679\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1466\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴢ≯褦.ᢋꡱႾ\x{0679}", %p)},	undef,	"to_unicode\(\'Ⴢ\≯褦\.ᢋꡱႾ\\u0679\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1467\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴢ>\x{0338}褦.ᢋꡱႾ\x{0679}", %p)},	undef,	"to_unicode\(\'Ⴢ\>\\u0338褦\.ᢋꡱႾ\\u0679\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1468\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴢ>\x{0338}褦.ᢋꡱⴞ\x{0679}", %p)},	undef,	"to_unicode\(\'ⴢ\>\\u0338褦\.ᢋꡱⴞ\\u0679\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1469\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴢ≯褦.ᢋꡱⴞ\x{0679}", %p)},	undef,	"to_unicode\(\'ⴢ\≯褦\.ᢋꡱⴞ\\u0679\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1470\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴢ>\x{0338}褦．ᢋꡱⴞ\x{0679}", %p)},	undef,	"to_unicode\(\'ⴢ\>\\u0338褦．ᢋꡱⴞ\\u0679\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1471\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴢ≯褦．ᢋꡱⴞ\x{0679}", %p)},	undef,	"to_unicode\(\'ⴢ\≯褦．ᢋꡱⴞ\\u0679\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1472\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񔻃\x{1B3C}\x{200C}\x{2D7F}。\x{0760}ᡟ\x{0778}", %p)},	undef,	"to_unicode\(\'񔻃\\u1B3C\\u200C\\u2D7F\。\\u0760ᡟ\\u0778\'\)\ throws\ error\ P1\ V6\ C1\ B2\ \[data\/IdnaTest\.txt\:1473\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񔻃\x{1B3C}\x{200C}\x{2D7F}。\x{0760}ᡟ\x{0778}", %p)},	undef,	"to_unicode\(\'񔻃\\u1B3C\\u200C\\u2D7F\。\\u0760ᡟ\\u0778\'\)\ throws\ error\ P1\ V6\ C1\ B2\ \[data\/IdnaTest\.txt\:1474\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.≯", %p)},	undef,	"to_unicode\(\'\\u200C\.\≯\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1475\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.≯", %p)},	undef,	"to_unicode\(\'\\u200C\.\≯\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1476\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.>\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200C\.\>\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1477\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.>\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200C\.\>\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1478\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𣴟𽙙-．𑇀-悜", %p)},	undef,	"to_unicode\(\'𣴟𽙙\-．𑇀\-悜\'\)\ throws\ error\ P1\ V3\ V6\ V5\ \[data\/IdnaTest\.txt\:1479\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𣴟𽙙-.𑇀-悜", %p)},	undef,	"to_unicode\(\'𣴟𽙙\-\.𑇀\-悜\'\)\ throws\ error\ P1\ V3\ V6\ V5\ \[data\/IdnaTest\.txt\:1480\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐫀𐿓➻ᢗ.-\x{200D}\x{0FA1}\x{1B42}", %p)},	undef,	"to_unicode\(\'𐫀𐿓\➻ᢗ\.\-\\u200D\\u0FA1\\u1B42\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:1481\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐫀𐿓➻ᢗ.-\x{200D}\x{0FA1}\x{1B42}", %p)},	undef,	"to_unicode\(\'𐫀𐿓\➻ᢗ\.\-\\u200D\\u0FA1\\u1B42\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:1482\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒐\x{200C}衃Ⴝ.\x{067F}Ⴔ", %p)},	undef,	"to_unicode\(\'⒐\\u200C衃Ⴝ\.\\u067FႴ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1483\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒐\x{200C}衃Ⴝ.\x{067F}Ⴔ", %p)},	undef,	"to_unicode\(\'⒐\\u200C衃Ⴝ\.\\u067FႴ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1484\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("9.\x{200C}衃Ⴝ.\x{067F}Ⴔ", %p)},	undef,	"to_unicode\(\'9\.\\u200C衃Ⴝ\.\\u067FႴ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1485\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("9.\x{200C}衃Ⴝ.\x{067F}Ⴔ", %p)},	undef,	"to_unicode\(\'9\.\\u200C衃Ⴝ\.\\u067FႴ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1486\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("9.\x{200C}衃ⴝ.\x{067F}ⴔ", %p)},	undef,	"to_unicode\(\'9\.\\u200C衃ⴝ\.\\u067Fⴔ\'\)\ throws\ error\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1487\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("9.\x{200C}衃ⴝ.\x{067F}ⴔ", %p)},	undef,	"to_unicode\(\'9\.\\u200C衃ⴝ\.\\u067Fⴔ\'\)\ throws\ error\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1488\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("9.\x{200C}衃Ⴝ.\x{067F}ⴔ", %p)},	undef,	"to_unicode\(\'9\.\\u200C衃Ⴝ\.\\u067Fⴔ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1489\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("9.\x{200C}衃Ⴝ.\x{067F}ⴔ", %p)},	undef,	"to_unicode\(\'9\.\\u200C衃Ⴝ\.\\u067Fⴔ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1490\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒐\x{200C}衃ⴝ.\x{067F}ⴔ", %p)},	undef,	"to_unicode\(\'⒐\\u200C衃ⴝ\.\\u067Fⴔ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1491\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒐\x{200C}衃ⴝ.\x{067F}ⴔ", %p)},	undef,	"to_unicode\(\'⒐\\u200C衃ⴝ\.\\u067Fⴔ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1492\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒐\x{200C}衃Ⴝ.\x{067F}ⴔ", %p)},	undef,	"to_unicode\(\'⒐\\u200C衃Ⴝ\.\\u067Fⴔ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1493\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒐\x{200C}衃Ⴝ.\x{067F}ⴔ", %p)},	undef,	"to_unicode\(\'⒐\\u200C衃Ⴝ\.\\u067Fⴔ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1494\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0756}\x{200C}。--🞞", %p)},	undef,	"to_unicode\(\'\\u0756\\u200C\。\-\-🞞\'\)\ throws\ error\ V3\ B3\ C1\ \[data\/IdnaTest\.txt\:1495\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0756}\x{200C}。--🞞", %p)},	undef,	"to_unicode\(\'\\u0756\\u200C\。\-\-🞞\'\)\ throws\ error\ V3\ B3\ C1\ \[data\/IdnaTest\.txt\:1496\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{FD74}．\x{062E}", %p)},	"\x{0637}\x{0645}\x{064A}.\x{062E}",	"to_unicode\(\'\\uFD74．\\u062E\'\)\ \[data\/IdnaTest\.txt\:1497\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0637}\x{0645}\x{064A}.\x{062E}", %p)},	"\x{0637}\x{0645}\x{064A}.\x{062E}",	"to_unicode\(\'\\u0637\\u0645\\u064A\.\\u062E\'\)\ \[data\/IdnaTest\.txt\:1498\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--2gb2ap.xn--tgb", %p)},	"\x{0637}\x{0645}\x{064A}.\x{062E}",	"to_unicode\(\'xn\-\-2gb2ap\.xn\-\-tgb\'\)\ \[data\/IdnaTest\.txt\:1499\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{1DE4}-．-\x{0E3A}", %p)},	undef,	"to_unicode\(\'\\u1DE4\-．\-\\u0E3A\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:1500\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{1DE4}-.-\x{0E3A}", %p)},	undef,	"to_unicode\(\'\\u1DE4\-\.\-\\u0E3A\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:1501\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("\x{030C}\x{06A7}-.𝩦", %p)},	undef,	"to_unicode\(\'\\u030C\\u06A7\-\.𝩦\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:1502\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{07E3}\x{FB1E}\x{1AB8}𐹯.\x{A953}⒌򕠠", %p)},	undef,	"to_unicode\(\'\\u07E3\\uFB1E\\u1AB8𐹯\.\\uA953⒌򕠠\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1503\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07E3}\x{FB1E}\x{1AB8}𐹯.\x{A953}5.򕠠", %p)},	undef,	"to_unicode\(\'\\u07E3\\uFB1E\\u1AB8𐹯\.\\uA9535\.򕠠\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1504\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06D7}₀。󠀠\x{200C}𐻼\x{200D}", %p)},	undef,	"to_unicode\(\'\\u06D7₀\。\󠀠\\u200C𐻼\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1505\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06D7}₀。󠀠\x{200C}𐻼\x{200D}", %p)},	undef,	"to_unicode\(\'\\u06D7₀\。\󠀠\\u200C𐻼\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1506\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06D7}0。󠀠\x{200C}𐻼\x{200D}", %p)},	undef,	"to_unicode\(\'\\u06D70\。\󠀠\\u200C𐻼\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1507\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06D7}0。󠀠\x{200C}𐻼\x{200D}", %p)},	undef,	"to_unicode\(\'\\u06D70\。\󠀠\\u200C𐻼\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1508\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴚ𐋸\x{2060}。𝟝󋷳\x{0D4D}", %p)},	undef,	"to_unicode\(\'Ⴚ𐋸\\u2060\。𝟝󋷳\\u0D4D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1509\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴚ𐋸\x{2060}。5󋷳\x{0D4D}", %p)},	undef,	"to_unicode\(\'Ⴚ𐋸\\u2060\。5󋷳\\u0D4D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1510\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴚ𐋸\x{2060}。5󋷳\x{0D4D}", %p)},	undef,	"to_unicode\(\'ⴚ𐋸\\u2060\。5󋷳\\u0D4D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1511\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴚ𐋸\x{2060}。𝟝󋷳\x{0D4D}", %p)},	undef,	"to_unicode\(\'ⴚ𐋸\\u2060\。𝟝󋷳\\u0D4D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1512\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}-\x{0645}\x{1AB4}.\x{0D62}\x{0F9F}", %p)},	undef,	"to_unicode\(\'\\u200D\-\\u0645\\u1AB4\.\\u0D62\\u0F9F\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1513\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}-\x{0645}\x{1AB4}.\x{0D62}\x{0F9F}", %p)},	undef,	"to_unicode\(\'\\u200D\-\\u0645\\u1AB4\.\\u0D62\\u0F9F\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1514\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("≠.ꡝ", %p)},	undef,	"to_unicode\(\'\≠\.ꡝ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1515\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}.ꡝ", %p)},	undef,	"to_unicode\(\'\=\\u0338\.ꡝ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1516\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ᢕ\x{1A1B}｡㌪", %p)},	"ᢕ\x{1A1B}.ハイツ",	"to_unicode\(\'ᢕ\\u1A1B｡㌪\'\)\ \[data\/IdnaTest\.txt\:1517\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ᢕ\x{1A1B}。ハイツ", %p)},	"ᢕ\x{1A1B}.ハイツ",	"to_unicode\(\'ᢕ\\u1A1B\。ハイツ\'\)\ \[data\/IdnaTest\.txt\:1518\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--fbf49e.xn--eck4c5a", %p)},	"ᢕ\x{1A1B}.ハイツ",	"to_unicode\(\'xn\-\-fbf49e\.xn\-\-eck4c5a\'\)\ \[data\/IdnaTest\.txt\:1519\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ᢕ\x{1A1B}.ハイツ", %p)},	"ᢕ\x{1A1B}.ハイツ",	"to_unicode\(\'ᢕ\\u1A1B\.ハイツ\'\)\ \[data\/IdnaTest\.txt\:1520\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0757}\x{0366}≮.\x{AAF6}-", %p)},	undef,	"to_unicode\(\'\\u0757\\u0366\≮\.\\uAAF6\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B3\ \[data\/IdnaTest\.txt\:1521\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0757}\x{0366}<\x{0338}.\x{AAF6}-", %p)},	undef,	"to_unicode\(\'\\u0757\\u0366\<\\u0338\.\\uAAF6\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B3\ \[data\/IdnaTest\.txt\:1522\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("₆榎𑤮\x{094D}｡᠇\x{034B}𞻖󠳶", %p)},	undef,	"to_unicode\(\'₆榎𑤮\\u094D｡᠇\\u034B𞻖\󠳶\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1523\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("6榎𑤮\x{094D}。᠇\x{034B}𞻖󠳶", %p)},	undef,	"to_unicode\(\'6榎𑤮\\u094D\。᠇\\u034B𞻖\󠳶\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1524\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󺸫．󆺙", %p)},	undef,	"to_unicode\(\'󺸫．󆺙\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1525\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󺸫.󆺙", %p)},	undef,	"to_unicode\(\'󺸫\.󆺙\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1526\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}︒｡ᢟ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D︒｡ᢟ\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1527\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}︒｡ᢟ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D︒｡ᢟ\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1528\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。。ᢟ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D\。\。ᢟ\\u200C\'\)\ throws\ error\ C2\ A4_2\ C1\ \[data\/IdnaTest\.txt\:1529\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。。ᢟ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D\。\。ᢟ\\u200C\'\)\ throws\ error\ C2\ A4_2\ C1\ \[data\/IdnaTest\.txt\:1530\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--pbf", %p)},	"ᢟ",	"to_unicode\(\'xn\-\-pbf\'\)\ \[data\/IdnaTest\.txt\:1531\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢟ", %p)},	"ᢟ",	"to_unicode\(\'ᢟ\'\)\ \[data\/IdnaTest\.txt\:1532\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0604}\x{200C}𐹬。≩", %p)},	undef,	"to_unicode\(\'\\u0604\\u200C𐹬\。\≩\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1533\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0604}\x{200C}𐹬。≩", %p)},	undef,	"to_unicode\(\'\\u0604\\u200C𐹬\。\≩\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1534\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{A9C0}𖬳\x{0F74}𝟭。-⋎", %p)},	undef,	"to_unicode\(\'\\uA9C0𖬳\\u0F74𝟭\。\-\⋎\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:1535\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{A9C0}\x{0F74}𖬳𝟭。-⋎", %p)},	undef,	"to_unicode\(\'\\uA9C0\\u0F74𖬳𝟭\。\-\⋎\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:1536\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{A9C0}\x{0F74}𖬳1。-⋎", %p)},	undef,	"to_unicode\(\'\\uA9C0\\u0F74𖬳1\。\-\⋎\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:1537\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("񃬫。뙏", %p)},	undef,	"to_unicode\(\'񃬫\。뙏\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1538\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񃬫。뙏", %p)},	undef,	"to_unicode\(\'񃬫\。뙏\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1539\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󋢒\x{A948}󇽘ᢉ.\x{074F}", %p)},	undef,	"to_unicode\(\'󋢒\\uA948󇽘ᢉ\.\\u074F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1540\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}｡溑", %p)},	undef,	"to_unicode\(\'\\u200D｡溑\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:1541\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}｡溑", %p)},	undef,	"to_unicode\(\'\\u200D｡溑\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:1542\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。溑", %p)},	undef,	"to_unicode\(\'\\u200D\。溑\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:1543\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。溑", %p)},	undef,	"to_unicode\(\'\\u200D\。溑\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:1544\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--c9w", %p)},	"溑",	"to_unicode\(\'xn\-\-c9w\'\)\ \[data\/IdnaTest\.txt\:1545\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("溑", %p)},	"溑",	"to_unicode\(\'溑\'\)\ \[data\/IdnaTest\.txt\:1546\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{075F}皥．-", %p)},	undef,	"to_unicode\(\'\\u075F皥．\-\'\)\ throws\ error\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:1547\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{075F}皥.-", %p)},	undef,	"to_unicode\(\'\\u075F皥\.\-\'\)\ throws\ error\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:1548\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𞡍󠅛ᠫ．⒈\x{06B4}", %p)},	undef,	"to_unicode\(\'𞡍\󠅛ᠫ．⒈\\u06B4\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1549\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𞡍󠅛ᠫ.1.\x{06B4}", %p)},	undef,	"to_unicode\(\'𞡍\󠅛ᠫ\.1\.\\u06B4\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1550\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴛ\x{200C}𝨬\x{200D}。\x{FFA0}ā\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C𝨬\\u200D\。\\uFFA0ā\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1551\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}𝨬\x{200D}。\x{FFA0}ā\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C𝨬\\u200D\。\\uFFA0ā\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1552\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}𝨬\x{200D}。\x{FFA0}a\x{0304}\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C𝨬\\u200D\。\\uFFA0a\\u0304\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1553\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}𝨬\x{200D}。\x{FFA0}a\x{0304}\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C𝨬\\u200D\。\\uFFA0a\\u0304\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1554\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}𝨬\x{200D}。\x{1160}ā\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C𝨬\\u200D\。\\u1160ā\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1555\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}𝨬\x{200D}。\x{1160}ā\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C𝨬\\u200D\。\\u1160ā\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1556\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}𝨬\x{200D}。\x{1160}a\x{0304}\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C𝨬\\u200D\。\\u1160a\\u0304\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1557\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}𝨬\x{200D}。\x{1160}a\x{0304}\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C𝨬\\u200D\。\\u1160a\\u0304\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1558\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}𝨬\x{200D}。\x{1160}a\x{0304}\x{0600}", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C𝨬\\u200D\。\\u1160a\\u0304\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1559\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}𝨬\x{200D}。\x{1160}a\x{0304}\x{0600}", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C𝨬\\u200D\。\\u1160a\\u0304\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1560\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}𝨬\x{200D}。\x{1160}ā\x{0600}", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C𝨬\\u200D\。\\u1160ā\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1561\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}𝨬\x{200D}。\x{1160}ā\x{0600}", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C𝨬\\u200D\。\\u1160ā\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1562\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}𝨬\x{200D}。\x{1160}Ā\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C𝨬\\u200D\。\\u1160Ā\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1563\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}𝨬\x{200D}。\x{1160}Ā\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C𝨬\\u200D\。\\u1160Ā\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1564\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}𝨬\x{200D}。\x{1160}A\x{0304}\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C𝨬\\u200D\。\\u1160A\\u0304\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1565\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}𝨬\x{200D}。\x{1160}A\x{0304}\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C𝨬\\u200D\。\\u1160A\\u0304\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1566\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}𝨬\x{200D}。\x{FFA0}a\x{0304}\x{0600}", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C𝨬\\u200D\。\\uFFA0a\\u0304\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1567\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}𝨬\x{200D}。\x{FFA0}a\x{0304}\x{0600}", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C𝨬\\u200D\。\\uFFA0a\\u0304\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1568\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}𝨬\x{200D}。\x{FFA0}ā\x{0600}", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C𝨬\\u200D\。\\uFFA0ā\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1569\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}𝨬\x{200D}。\x{FFA0}ā\x{0600}", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C𝨬\\u200D\。\\uFFA0ā\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1570\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}𝨬\x{200D}。\x{FFA0}Ā\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C𝨬\\u200D\。\\uFFA0Ā\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1571\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}𝨬\x{200D}。\x{FFA0}Ā\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C𝨬\\u200D\。\\uFFA0Ā\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1572\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}𝨬\x{200D}。\x{FFA0}A\x{0304}\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C𝨬\\u200D\。\\uFFA0A\\u0304\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1573\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}𝨬\x{200D}。\x{FFA0}A\x{0304}\x{0600}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C𝨬\\u200D\。\\uFFA0A\\u0304\\u0600\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1574\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FDEB}\x{200C}｡曳⾑𐋰≯", %p)},	undef,	"to_unicode\(\'\\uFDEB\\u200C｡曳⾑𐋰\≯\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1575\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FDEB}\x{200C}｡曳⾑𐋰≯", %p)},	undef,	"to_unicode\(\'\\uFDEB\\u200C｡曳⾑𐋰\≯\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1576\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FDEB}\x{200C}｡曳⾑𐋰>\x{0338}", %p)},	undef,	"to_unicode\(\'\\uFDEB\\u200C｡曳⾑𐋰\>\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1577\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FDEB}\x{200C}｡曳⾑𐋰>\x{0338}", %p)},	undef,	"to_unicode\(\'\\uFDEB\\u200C｡曳⾑𐋰\>\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1578\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FDEB}\x{200C}。曳襾𐋰≯", %p)},	undef,	"to_unicode\(\'\\uFDEB\\u200C\。曳襾𐋰\≯\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1579\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FDEB}\x{200C}。曳襾𐋰≯", %p)},	undef,	"to_unicode\(\'\\uFDEB\\u200C\。曳襾𐋰\≯\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1580\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FDEB}\x{200C}。曳襾𐋰>\x{0338}", %p)},	undef,	"to_unicode\(\'\\uFDEB\\u200C\。曳襾𐋰\>\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1581\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FDEB}\x{200C}。曳襾𐋰>\x{0338}", %p)},	undef,	"to_unicode\(\'\\uFDEB\\u200C\。曳襾𐋰\>\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1582\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯⒈。ß", %p)},	undef,	"to_unicode\(\'\≯⒈\。ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1583\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}⒈。ß", %p)},	undef,	"to_unicode\(\'\>\\u0338⒈\。ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1584\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯1.。ß", %p)},	undef,	"to_unicode\(\'\≯1\.\。ß\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1585\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}1.。ß", %p)},	undef,	"to_unicode\(\'\>\\u03381\.\。ß\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1586\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}1.。SS", %p)},	undef,	"to_unicode\(\'\>\\u03381\.\。SS\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1587\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯1.。SS", %p)},	undef,	"to_unicode\(\'\≯1\.\。SS\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1588\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}⒈。SS", %p)},	undef,	"to_unicode\(\'\>\\u0338⒈\。SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1589\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯⒈。SS", %p)},	undef,	"to_unicode\(\'\≯⒈\。SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1590\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0603}\x{200D}𐣙｡\x{067D}-₆Ⴙ", %p)},	undef,	"to_unicode\(\'\\u0603\\u200D𐣙｡\\u067D\-₆Ⴙ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1591\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0603}\x{200D}𐣙｡\x{067D}-₆Ⴙ", %p)},	undef,	"to_unicode\(\'\\u0603\\u200D𐣙｡\\u067D\-₆Ⴙ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1592\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0603}\x{200D}𐣙。\x{067D}-6Ⴙ", %p)},	undef,	"to_unicode\(\'\\u0603\\u200D𐣙\。\\u067D\-6Ⴙ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1593\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0603}\x{200D}𐣙。\x{067D}-6Ⴙ", %p)},	undef,	"to_unicode\(\'\\u0603\\u200D𐣙\。\\u067D\-6Ⴙ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1594\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0603}\x{200D}𐣙。\x{067D}-6ⴙ", %p)},	undef,	"to_unicode\(\'\\u0603\\u200D𐣙\。\\u067D\-6ⴙ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1595\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0603}\x{200D}𐣙。\x{067D}-6ⴙ", %p)},	undef,	"to_unicode\(\'\\u0603\\u200D𐣙\。\\u067D\-6ⴙ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1596\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0603}\x{200D}𐣙｡\x{067D}-₆ⴙ", %p)},	undef,	"to_unicode\(\'\\u0603\\u200D𐣙｡\\u067D\-₆ⴙ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1597\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0603}\x{200D}𐣙｡\x{067D}-₆ⴙ", %p)},	undef,	"to_unicode\(\'\\u0603\\u200D𐣙｡\\u067D\-₆ⴙ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1598\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}｡≠", %p)},	undef,	"to_unicode\(\'\\u200C｡\≠\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1599\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}｡≠", %p)},	undef,	"to_unicode\(\'\\u200C｡\≠\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1600\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}｡=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200C｡\=\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1601\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}｡=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200C｡\=\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1602\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。≠", %p)},	undef,	"to_unicode\(\'\\u200C\。\≠\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1603\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。≠", %p)},	undef,	"to_unicode\(\'\\u200C\。\≠\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1604\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200C\。\=\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1605\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200C\。\=\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1606\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("\x{A953}𝪥.\x{076F}𑈵\x{05C1}\x{200C}", %p)},	undef,	"to_unicode\(\'\\uA953𝪥\.\\u076F𑈵\\u05C1\\u200C\'\)\ throws\ error\ V5\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1607\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("\x{A953}𝪥.\x{076F}𑈵\x{05C1}\x{200C}", %p)},	undef,	"to_unicode\(\'\\uA953𝪥\.\\u076F𑈵\\u05C1\\u200C\'\)\ throws\ error\ V5\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1608\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𻠷\x{200D}򑄕.\x{2DE1}Ↄ≠-", %p)},	undef,	"to_unicode\(\'𻠷\\u200D򑄕\.\\u2DE1Ↄ\≠\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ C2\ \[data\/IdnaTest\.txt\:1609\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𻠷\x{200D}򑄕.\x{2DE1}Ↄ≠-", %p)},	undef,	"to_unicode\(\'𻠷\\u200D򑄕\.\\u2DE1Ↄ\≠\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ C2\ \[data\/IdnaTest\.txt\:1610\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𻠷\x{200D}򑄕.\x{2DE1}Ↄ=\x{0338}-", %p)},	undef,	"to_unicode\(\'𻠷\\u200D򑄕\.\\u2DE1Ↄ\=\\u0338\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ C2\ \[data\/IdnaTest\.txt\:1611\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𻠷\x{200D}򑄕.\x{2DE1}Ↄ=\x{0338}-", %p)},	undef,	"to_unicode\(\'𻠷\\u200D򑄕\.\\u2DE1Ↄ\=\\u0338\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ C2\ \[data\/IdnaTest\.txt\:1612\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𻠷\x{200D}򑄕.\x{2DE1}ↄ=\x{0338}-", %p)},	undef,	"to_unicode\(\'𻠷\\u200D򑄕\.\\u2DE1ↄ\=\\u0338\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ C2\ \[data\/IdnaTest\.txt\:1613\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𻠷\x{200D}򑄕.\x{2DE1}ↄ=\x{0338}-", %p)},	undef,	"to_unicode\(\'𻠷\\u200D򑄕\.\\u2DE1ↄ\=\\u0338\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ C2\ \[data\/IdnaTest\.txt\:1614\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𻠷\x{200D}򑄕.\x{2DE1}ↄ≠-", %p)},	undef,	"to_unicode\(\'𻠷\\u200D򑄕\.\\u2DE1ↄ\≠\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ C2\ \[data\/IdnaTest\.txt\:1615\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𻠷\x{200D}򑄕.\x{2DE1}ↄ≠-", %p)},	undef,	"to_unicode\(\'𻠷\\u200D򑄕\.\\u2DE1ↄ\≠\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ C2\ \[data\/IdnaTest\.txt\:1616\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07CD}ς\x{200D}𝟳。蔑𯨺", %p)},	undef,	"to_unicode\(\'\\u07CDς\\u200D𝟳\。蔑𯨺\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1617\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07CD}ς\x{200D}𝟳。蔑𯨺", %p)},	undef,	"to_unicode\(\'\\u07CDς\\u200D𝟳\。蔑𯨺\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1618\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07CD}ς\x{200D}7。蔑𯨺", %p)},	undef,	"to_unicode\(\'\\u07CDς\\u200D7\。蔑𯨺\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1619\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07CD}ς\x{200D}7。蔑𯨺", %p)},	undef,	"to_unicode\(\'\\u07CDς\\u200D7\。蔑𯨺\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1620\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07CD}Σ\x{200D}7。蔑𯨺", %p)},	undef,	"to_unicode\(\'\\u07CDΣ\\u200D7\。蔑𯨺\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1621\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07CD}Σ\x{200D}7。蔑𯨺", %p)},	undef,	"to_unicode\(\'\\u07CDΣ\\u200D7\。蔑𯨺\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1622\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07CD}σ\x{200D}7。蔑𯨺", %p)},	undef,	"to_unicode\(\'\\u07CDσ\\u200D7\。蔑𯨺\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1623\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07CD}σ\x{200D}7。蔑𯨺", %p)},	undef,	"to_unicode\(\'\\u07CDσ\\u200D7\。蔑𯨺\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1624\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07CD}Σ\x{200D}𝟳。蔑𯨺", %p)},	undef,	"to_unicode\(\'\\u07CDΣ\\u200D𝟳\。蔑𯨺\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1625\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07CD}Σ\x{200D}𝟳。蔑𯨺", %p)},	undef,	"to_unicode\(\'\\u07CDΣ\\u200D𝟳\。蔑𯨺\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1626\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07CD}σ\x{200D}𝟳。蔑𯨺", %p)},	undef,	"to_unicode\(\'\\u07CDσ\\u200D𝟳\。蔑𯨺\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1627\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07CD}σ\x{200D}𝟳。蔑𯨺", %p)},	undef,	"to_unicode\(\'\\u07CDσ\\u200D𝟳\。蔑𯨺\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:1628\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹶.𐹹", %p)},	undef,	"to_unicode\(\'𐹶\.𐹹\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:1629\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-\x{06A1}.񝧄", %p)},	undef,	"to_unicode\(\'\-\\u06A1\.񝧄\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1630\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯𐪳𑒵。誆⒈", %p)},	undef,	"to_unicode\(\'\≯𐪳𑒵\。誆⒈\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1631\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}𐪳𑒵。誆⒈", %p)},	undef,	"to_unicode\(\'\>\\u0338𐪳𑒵\。誆⒈\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1632\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯𐪳𑒵。誆1.", %p)},	undef,	"to_unicode\(\'\≯𐪳𑒵\。誆1\.\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1633\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}𐪳𑒵。誆1.", %p)},	undef,	"to_unicode\(\'\>\\u0338𐪳𑒵\。誆1\.\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1634\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0F79}\x{FC74}䐊\x{1BA5}．︒𐲞💫\x{0647}", %p)},	undef,	"to_unicode\(\'\\u0F79\\uFC74䐊\\u1BA5．︒𐲞💫\\u0647\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1635\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("\x{0FB3}\x{0F71}\x{0F80}\x{062A}\x{0649}䐊\x{1BA5}.。𐲞💫\x{0647}", %p)},	undef,	"to_unicode\(\'\\u0FB3\\u0F71\\u0F80\\u062A\\u0649䐊\\u1BA5\.\。𐲞💫\\u0647\'\)\ throws\ error\ V5\ B1\ A4_2\ \[data\/IdnaTest\.txt\:1636\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("퀬-\x{DF7E}񒆢.\x{200C}𞣕򷤗۴", %p)},	undef,	"to_unicode\(\'퀬\-\\uDF7E񒆢\.\\u200C𞣕򷤗۴\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1637\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("퀬-\x{DF7E}񒆢.\x{200C}𞣕򷤗۴", %p)},	undef,	"to_unicode\(\'퀬\-\\uDF7E񒆢\.\\u200C𞣕򷤗۴\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1638\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("퀬-\x{DF7E}񒆢.\x{200C}𞣕򷤗۴", %p)},	undef,	"to_unicode\(\'퀬\-\\uDF7E񒆢\.\\u200C𞣕򷤗۴\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1639\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("퀬-\x{DF7E}񒆢.\x{200C}𞣕򷤗۴", %p)},	undef,	"to_unicode\(\'퀬\-\\uDF7E񒆢\.\\u200C𞣕򷤗۴\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1640\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("퀬", %p)},	"퀬",	"to_unicode\(\'퀬\'\)\ \[data\/IdnaTest\.txt\:1641\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("퀬", %p)},	"퀬",	"to_unicode\(\'퀬\'\)\ \[data\/IdnaTest\.txt\:1642\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--8n7b", %p)},	"퀬",	"to_unicode\(\'xn\-\-8n7b\'\)\ \[data\/IdnaTest\.txt\:1643\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴌ.\x{0664}︒\x{0F84}𞴌", %p)},	undef,	"to_unicode\(\'Ⴌ\.\\u0664︒\\u0F84𞴌\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1644\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴌ.\x{0664}。\x{0F84}𞴌", %p)},	undef,	"to_unicode\(\'Ⴌ\.\\u0664\。\\u0F84𞴌\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1645\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴌ.\x{0664}。\x{0F84}𞴌", %p)},	undef,	"to_unicode\(\'ⴌ\.\\u0664\。\\u0F84𞴌\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1646\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴌ.\x{0664}︒\x{0F84}𞴌", %p)},	undef,	"to_unicode\(\'ⴌ\.\\u0664︒\\u0F84𞴌\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1647\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򻖲󠬬。𞸙\x{A927}", %p)},	undef,	"to_unicode\(\'򻖲\󠬬\。𞸙\\uA927\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1648\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򻖲󠬬。\x{0636}\x{A927}", %p)},	undef,	"to_unicode\(\'򻖲\󠬬\。\\u0636\\uA927\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1649\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}󠜤\x{0362}．\x{0F7B}󠅑\x{1A60}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D\󠜤\\u0362．\\u0F7B\󠅑\\u1A60\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:1650\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}󠜤\x{0362}．\x{0F7B}󠅑\x{1A60}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D\󠜤\\u0362．\\u0F7B\󠅑\\u1A60\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:1651\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}󠜤\x{0362}.\x{0F7B}󠅑\x{1A60}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D\󠜤\\u0362\.\\u0F7B\󠅑\\u1A60\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:1652\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}󠜤\x{0362}.\x{0F7B}󠅑\x{1A60}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D\󠜤\\u0362\.\\u0F7B\󠅑\\u1A60\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:1653\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񵫶｡🄂", %p)},	undef,	"to_unicode\(\'񵫶｡🄂\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1654\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񵫶。1,", %p)},	undef,	"to_unicode\(\'񵫶\。1\,\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1655\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{036E}刍.🠗", %p)},	undef,	"to_unicode\(\'\\u036E刍\.🠗\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1656\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⺄3｡\x{0FA9}𝟒", %p)},	undef,	"to_unicode\(\'⺄3｡\\u0FA9𝟒\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1657\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⺄3。\x{0FA9}4", %p)},	undef,	"to_unicode\(\'⺄3\。\\u0FA94\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1658\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐫡６Ⴔ辘.𞫬𐮈\x{200C}", %p)},	undef,	"to_unicode\(\'𐫡６Ⴔ辘\.𞫬𐮈\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1659\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐫡６Ⴔ辘.𞫬𐮈\x{200C}", %p)},	undef,	"to_unicode\(\'𐫡６Ⴔ辘\.𞫬𐮈\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1660\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐫡6Ⴔ辘.𞫬𐮈\x{200C}", %p)},	undef,	"to_unicode\(\'𐫡6Ⴔ辘\.𞫬𐮈\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1661\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐫡6Ⴔ辘.𞫬𐮈\x{200C}", %p)},	undef,	"to_unicode\(\'𐫡6Ⴔ辘\.𞫬𐮈\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1662\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐫡6ⴔ辘.𞫬𐮈\x{200C}", %p)},	undef,	"to_unicode\(\'𐫡6ⴔ辘\.𞫬𐮈\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1663\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐫡6ⴔ辘.𞫬𐮈\x{200C}", %p)},	undef,	"to_unicode\(\'𐫡6ⴔ辘\.𞫬𐮈\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1664\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐫡６ⴔ辘.𞫬𐮈\x{200C}", %p)},	undef,	"to_unicode\(\'𐫡６ⴔ辘\.𞫬𐮈\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1665\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐫡６ⴔ辘.𞫬𐮈\x{200C}", %p)},	undef,	"to_unicode\(\'𐫡６ⴔ辘\.𞫬𐮈\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1666\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑘷.ᡱ\x{06C6}򵶨۹", %p)},	undef,	"to_unicode\(\'𑘷\.ᡱ\\u06C6򵶨۹\'\)\ throws\ error\ P1\ V5\ V6\ B5\ \[data\/IdnaTest\.txt\:1667\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A87D}≯．󁛲𳎟", %p)},	undef,	"to_unicode\(\'\\uA87D\≯．󁛲𳎟\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1668\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A87D}>\x{0338}．󁛲𳎟", %p)},	undef,	"to_unicode\(\'\\uA87D\>\\u0338．󁛲𳎟\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1669\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A87D}≯.󁛲𳎟", %p)},	undef,	"to_unicode\(\'\\uA87D\≯\.󁛲𳎟\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1670\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A87D}>\x{0338}.󁛲𳎟", %p)},	undef,	"to_unicode\(\'\\uA87D\>\\u0338\.󁛲𳎟\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1671\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ςო\x{072D}.ς𐫟", %p)},	undef,	"to_unicode\(\'ςო\\u072D\.ς𐫟\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1672\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("Σო\x{072D}.Σ𐫟", %p)},	undef,	"to_unicode\(\'Σო\\u072D\.Σ𐫟\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1673\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("σო\x{072D}.σ𐫟", %p)},	undef,	"to_unicode\(\'σო\\u072D\.σ𐫟\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1674\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("Σო\x{072D}.σ𐫟", %p)},	undef,	"to_unicode\(\'Σო\\u072D\.σ𐫟\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1675\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("Σო\x{072D}.ς𐫟", %p)},	undef,	"to_unicode\(\'Σო\\u072D\.ς𐫟\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1676\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("σო\x{072D}.ς𐫟", %p)},	undef,	"to_unicode\(\'σო\\u072D\.ς𐫟\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1677\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("򇋓\x{A67C}쐮𐮭｡⩒", %p)},	undef,	"to_unicode\(\'򇋓\\uA67C쐮𐮭｡\⩒\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1678\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򇋓\x{A67C}쐮𐮭｡⩒", %p)},	undef,	"to_unicode\(\'򇋓\\uA67C쐮𐮭｡\⩒\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1679\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򇋓\x{A67C}쐮𐮭。⩒", %p)},	undef,	"to_unicode\(\'򇋓\\uA67C쐮𐮭\。\⩒\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1680\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򇋓\x{A67C}쐮𐮭。⩒", %p)},	undef,	"to_unicode\(\'򇋓\\uA67C쐮𐮭\。\⩒\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1681\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("﹅．\x{200D}䤫≠Ⴞ", %p)},	undef,	"to_unicode\(\'\﹅．\\u200D䤫\≠Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1682\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("﹅．\x{200D}䤫≠Ⴞ", %p)},	undef,	"to_unicode\(\'\﹅．\\u200D䤫\≠Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1683\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("﹅．\x{200D}䤫=\x{0338}Ⴞ", %p)},	undef,	"to_unicode\(\'\﹅．\\u200D䤫\=\\u0338Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1684\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("﹅．\x{200D}䤫=\x{0338}Ⴞ", %p)},	undef,	"to_unicode\(\'\﹅．\\u200D䤫\=\\u0338Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1685\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("﹅.\x{200D}䤫≠Ⴞ", %p)},	undef,	"to_unicode\(\'\﹅\.\\u200D䤫\≠Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1686\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("﹅.\x{200D}䤫≠Ⴞ", %p)},	undef,	"to_unicode\(\'\﹅\.\\u200D䤫\≠Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1687\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("﹅.\x{200D}䤫=\x{0338}Ⴞ", %p)},	undef,	"to_unicode\(\'\﹅\.\\u200D䤫\=\\u0338Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1688\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("﹅.\x{200D}䤫=\x{0338}Ⴞ", %p)},	undef,	"to_unicode\(\'\﹅\.\\u200D䤫\=\\u0338Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1689\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("﹅.\x{200D}䤫=\x{0338}ⴞ", %p)},	undef,	"to_unicode\(\'\﹅\.\\u200D䤫\=\\u0338ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1690\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("﹅.\x{200D}䤫=\x{0338}ⴞ", %p)},	undef,	"to_unicode\(\'\﹅\.\\u200D䤫\=\\u0338ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1691\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("﹅.\x{200D}䤫≠ⴞ", %p)},	undef,	"to_unicode\(\'\﹅\.\\u200D䤫\≠ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1692\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("﹅.\x{200D}䤫≠ⴞ", %p)},	undef,	"to_unicode\(\'\﹅\.\\u200D䤫\≠ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1693\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("﹅．\x{200D}䤫=\x{0338}ⴞ", %p)},	undef,	"to_unicode\(\'\﹅．\\u200D䤫\=\\u0338ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1694\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("﹅．\x{200D}䤫=\x{0338}ⴞ", %p)},	undef,	"to_unicode\(\'\﹅．\\u200D䤫\=\\u0338ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1695\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("﹅．\x{200D}䤫≠ⴞ", %p)},	undef,	"to_unicode\(\'\﹅．\\u200D䤫\≠ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1696\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("﹅．\x{200D}䤫≠ⴞ", %p)},	undef,	"to_unicode\(\'\﹅．\\u200D䤫\≠ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1697\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐱎𑄴．𐹱▟", %p)},	undef,	"to_unicode\(\'𐱎𑄴．𐹱\▟\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1698\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐱎𑄴.𐹱▟", %p)},	undef,	"to_unicode\(\'𐱎𑄴\.𐹱\▟\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1699\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒊⒈󠅵。9", %p)},	undef,	"to_unicode\(\'⒊⒈\󠅵\。9\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1700\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("3.1.󠅵。9", %p)},	undef,	"to_unicode\(\'3\.1\.\󠅵\。9\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:1701\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}𑄫≮．𐹾𴙜4₉", %p)},	undef,	"to_unicode\(\'\-\\u200C𑄫\≮．𐹾𴙜4₉\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1702\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}𑄫≮．𐹾𴙜4₉", %p)},	undef,	"to_unicode\(\'\-\\u200C𑄫\≮．𐹾𴙜4₉\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1703\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}𑄫<\x{0338}．𐹾𴙜4₉", %p)},	undef,	"to_unicode\(\'\-\\u200C𑄫\<\\u0338．𐹾𴙜4₉\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1704\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}𑄫<\x{0338}．𐹾𴙜4₉", %p)},	undef,	"to_unicode\(\'\-\\u200C𑄫\<\\u0338．𐹾𴙜4₉\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1705\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}𑄫≮.𐹾𴙜49", %p)},	undef,	"to_unicode\(\'\-\\u200C𑄫\≮\.𐹾𴙜49\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1706\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}𑄫≮.𐹾𴙜49", %p)},	undef,	"to_unicode\(\'\-\\u200C𑄫\≮\.𐹾𴙜49\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1707\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}𑄫<\x{0338}.𐹾𴙜49", %p)},	undef,	"to_unicode\(\'\-\\u200C𑄫\<\\u0338\.𐹾𴙜49\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1708\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}𑄫<\x{0338}.𐹾𴙜49", %p)},	undef,	"to_unicode\(\'\-\\u200C𑄫\<\\u0338\.𐹾𴙜49\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1709\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-≯딾｡\x{08B4}", %p)},	undef,	"to_unicode\(\'\-\≯딾｡\\u08B4\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1710\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("->\x{0338}딾｡\x{08B4}", %p)},	undef,	"to_unicode\(\'\-\>\\u0338딾｡\\u08B4\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1711\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-≯딾。\x{08B4}", %p)},	undef,	"to_unicode\(\'\-\≯딾\。\\u08B4\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1712\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("->\x{0338}딾。\x{08B4}", %p)},	undef,	"to_unicode\(\'\-\>\\u0338딾\。\\u08B4\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1713\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⪽⒈𐹢-｡󠗪\x{200C}", %p)},	undef,	"to_unicode\(\'\⪽⒈𐹢\-｡\󠗪\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1714\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⪽⒈𐹢-｡󠗪\x{200C}", %p)},	undef,	"to_unicode\(\'\⪽⒈𐹢\-｡\󠗪\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1715\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⪽1.𐹢-。󠗪\x{200C}", %p)},	undef,	"to_unicode\(\'\⪽1\.𐹢\-\。\󠗪\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1716\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⪽1.𐹢-。󠗪\x{200C}", %p)},	undef,	"to_unicode\(\'\⪽1\.𐹢\-\。\󠗪\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1717\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{1A73}．\x{031D}", %p)},	undef,	"to_unicode\(\'\\u1A73．\\u031D\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1718\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{1A73}.\x{031D}", %p)},	undef,	"to_unicode\(\'\\u1A73\.\\u031D\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1719\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("훉≮｡\x{FE00}", %p)},	undef,	"to_unicode\(\'훉\≮｡\\uFE00\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1720\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("훉<\x{0338}｡\x{FE00}", %p)},	undef,	"to_unicode\(\'훉\<\\u0338｡\\uFE00\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1721\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("훉≮。\x{FE00}", %p)},	undef,	"to_unicode\(\'훉\≮\。\\uFE00\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1722\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("훉<\x{0338}。\x{FE00}", %p)},	undef,	"to_unicode\(\'훉\<\\u0338\。\\uFE00\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1723\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0AC3}񂔠⭤．򬚵𝟸𑚫\x{08A4}", %p)},	undef,	"to_unicode\(\'\\u0AC3񂔠\⭤．򬚵𝟸𑚫\\u08A4\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1724\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0AC3}񂔠⭤.򬚵2𑚫\x{08A4}", %p)},	undef,	"to_unicode\(\'\\u0AC3񂔠\⭤\.򬚵2𑚫\\u08A4\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1725\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󨭺ß𐫁\x{200C}。\x{0666}𐧍\x{06B4}-", %p)},	undef,	"to_unicode\(\'󨭺ß𐫁\\u200C\。\\u0666𐧍\\u06B4\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:1726\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󨭺ß𐫁\x{200C}。\x{0666}𐧍\x{06B4}-", %p)},	undef,	"to_unicode\(\'󨭺ß𐫁\\u200C\。\\u0666𐧍\\u06B4\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:1727\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󨭺SS𐫁\x{200C}。\x{0666}𐧍\x{06B4}-", %p)},	undef,	"to_unicode\(\'󨭺SS𐫁\\u200C\。\\u0666𐧍\\u06B4\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:1728\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󨭺SS𐫁\x{200C}。\x{0666}𐧍\x{06B4}-", %p)},	undef,	"to_unicode\(\'󨭺SS𐫁\\u200C\。\\u0666𐧍\\u06B4\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:1729\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󨭺ss𐫁\x{200C}。\x{0666}𐧍\x{06B4}-", %p)},	undef,	"to_unicode\(\'󨭺ss𐫁\\u200C\。\\u0666𐧍\\u06B4\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:1730\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󨭺ss𐫁\x{200C}。\x{0666}𐧍\x{06B4}-", %p)},	undef,	"to_unicode\(\'󨭺ss𐫁\\u200C\。\\u0666𐧍\\u06B4\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:1731\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󨭺Ss𐫁\x{200C}。\x{0666}𐧍\x{06B4}-", %p)},	undef,	"to_unicode\(\'󨭺Ss𐫁\\u200C\。\\u0666𐧍\\u06B4\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:1732\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󨭺Ss𐫁\x{200C}。\x{0666}𐧍\x{06B4}-", %p)},	undef,	"to_unicode\(\'󨭺Ss𐫁\\u200C\。\\u0666𐧍\\u06B4\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:1733\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06C6}。Ↄ🙣놮-", %p)},	undef,	"to_unicode\(\'\\u06C6\。Ↄ🙣놮\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1734\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06C6}。Ↄ🙣놮-", %p)},	undef,	"to_unicode\(\'\\u06C6\。Ↄ🙣놮\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1735\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{06C6}。ↄ🙣놮-", %p)},	undef,	"to_unicode\(\'\\u06C6\。ↄ🙣놮\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1736\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{06C6}。ↄ🙣놮-", %p)},	undef,	"to_unicode\(\'\\u06C6\。ↄ🙣놮\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1737\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𐶗\x{200D}.𘎮\x{06A3}", %p)},	undef,	"to_unicode\(\'𐶗\\u200D\.𘎮\\u06A3\'\)\ throws\ error\ P1\ V6\ B3\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1738\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐶗\x{200D}.𘎮\x{06A3}", %p)},	undef,	"to_unicode\(\'𐶗\\u200D\.𘎮\\u06A3\'\)\ throws\ error\ P1\ V6\ B3\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1739\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴜ\x{08ED}𞫅≯。𖾏\x{0304}𝨨", %p)},	undef,	"to_unicode\(\'Ⴜ\\u08ED𞫅\≯\。𖾏\\u0304𝨨\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:1740\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴜ\x{08ED}𞫅>\x{0338}。𖾏\x{0304}𝨨", %p)},	undef,	"to_unicode\(\'Ⴜ\\u08ED𞫅\>\\u0338\。𖾏\\u0304𝨨\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:1741\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴜ\x{08ED}𞫅>\x{0338}。𖾏\x{0304}𝨨", %p)},	undef,	"to_unicode\(\'ⴜ\\u08ED𞫅\>\\u0338\。𖾏\\u0304𝨨\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:1742\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴜ\x{08ED}𞫅≯。𖾏\x{0304}𝨨", %p)},	undef,	"to_unicode\(\'ⴜ\\u08ED𞫅\≯\。𖾏\\u0304𝨨\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:1743\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("𐋵。𐳜", %p)},	"𐋵.𐳜",	"to_unicode\(\'𐋵\。𐳜\'\)\ \[data\/IdnaTest\.txt\:1744\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("xn--p97c.xn--4c0d", %p)},	"𐋵.𐳜",	"to_unicode\(\'xn\-\-p97c\.xn\-\-4c0d\'\)\ \[data\/IdnaTest\.txt\:1745\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("𐋵.𐳜", %p)},	"𐋵.𐳜",	"to_unicode\(\'𐋵\.𐳜\'\)\ \[data\/IdnaTest\.txt\:1746\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("≮󠁽．򷇻𐨎\x{2E48}󭵷", %p)},	undef,	"to_unicode\(\'\≮\󠁽．򷇻𐨎\\u2E48󭵷\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1747\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}󠁽．򷇻𐨎\x{2E48}󭵷", %p)},	undef,	"to_unicode\(\'\<\\u0338\󠁽．򷇻𐨎\\u2E48󭵷\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1748\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮󠁽.򷇻𐨎\x{2E48}󭵷", %p)},	undef,	"to_unicode\(\'\≮\󠁽\.򷇻𐨎\\u2E48󭵷\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1749\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}󠁽.򷇻𐨎\x{2E48}󭵷", %p)},	undef,	"to_unicode\(\'\<\\u0338\󠁽\.򷇻𐨎\\u2E48󭵷\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1750\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𖬲\x{031F}ꡍ．\x{A947}\x{0664}⎈", %p)},	undef,	"to_unicode\(\'𖬲\\u031Fꡍ．\\uA947\\u0664\⎈\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1751\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{031F}𖬲ꡍ．\x{A947}\x{0664}⎈", %p)},	undef,	"to_unicode\(\'\\u031F𖬲ꡍ．\\uA947\\u0664\⎈\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1752\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{031F}𖬲ꡍ.\x{A947}\x{0664}⎈", %p)},	undef,	"to_unicode\(\'\\u031F𖬲ꡍ\.\\uA947\\u0664\⎈\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1753\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𞶅ᡣ\x{200C}\x{07E7}．𑂹\x{20E5}", %p)},	undef,	"to_unicode\(\'𞶅ᡣ\\u200C\\u07E7．𑂹\\u20E5\'\)\ throws\ error\ P1\ V6\ V5\ B2\ \[data\/IdnaTest\.txt\:1754\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞶅ᡣ\x{200C}\x{07E7}．\x{20E5}𑂹", %p)},	undef,	"to_unicode\(\'𞶅ᡣ\\u200C\\u07E7．\\u20E5𑂹\'\)\ throws\ error\ P1\ V6\ V5\ B2\ \[data\/IdnaTest\.txt\:1755\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞶅ᡣ\x{200C}\x{07E7}.\x{20E5}𑂹", %p)},	undef,	"to_unicode\(\'𞶅ᡣ\\u200C\\u07E7\.\\u20E5𑂹\'\)\ throws\ error\ P1\ V6\ V5\ B2\ \[data\/IdnaTest\.txt\:1756\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑄴｡\x{200D}󙤲⮡񤩻", %p)},	undef,	"to_unicode\(\'𑄴｡\\u200D󙤲\⮡񤩻\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:1757\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑄴｡\x{200D}󙤲⮡񤩻", %p)},	undef,	"to_unicode\(\'𑄴｡\\u200D󙤲\⮡񤩻\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:1758\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑄴。\x{200D}󙤲⮡񤩻", %p)},	undef,	"to_unicode\(\'𑄴\。\\u200D󙤲\⮡񤩻\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:1759\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑄴。\x{200D}󙤲⮡񤩻", %p)},	undef,	"to_unicode\(\'𑄴\。\\u200D󙤲\⮡񤩻\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:1760\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-𞶌。⒚", %p)},	undef,	"to_unicode\(\'\-𞶌\。⒚\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1761\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-𞶌。19.", %p)},	undef,	"to_unicode\(\'\-𞶌\。19\.\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1762\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󙭿\x{0638}\x{200C}｡\x{074E}\x{200D}", %p)},	undef,	"to_unicode\(\'󙭿\\u0638\\u200C｡\\u074E\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:1763\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󙭿\x{0638}\x{200C}｡\x{074E}\x{200D}", %p)},	undef,	"to_unicode\(\'󙭿\\u0638\\u200C｡\\u074E\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:1764\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󙭿\x{0638}\x{200C}。\x{074E}\x{200D}", %p)},	undef,	"to_unicode\(\'󙭿\\u0638\\u200C\。\\u074E\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:1765\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󙭿\x{0638}\x{200C}。\x{074E}\x{200D}", %p)},	undef,	"to_unicode\(\'󙭿\\u0638\\u200C\。\\u074E\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:1766\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ß\x{033E}𑍰。ᡣ8₅", %p)},	"ß\x{033E}𑍰.ᡣ85",	"to_unicode\(\'ß\\u033E𑍰\。ᡣ8₅\'\)\ \[data\/IdnaTest\.txt\:1767\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ß\x{033E}𑍰。ᡣ8₅", %p)},	"ß\x{033E}𑍰.ᡣ85",	"to_unicode\(\'ß\\u033E𑍰\。ᡣ8₅\'\)\ \[data\/IdnaTest\.txt\:1768\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ß\x{033E}𑍰。ᡣ85", %p)},	"ß\x{033E}𑍰.ᡣ85",	"to_unicode\(\'ß\\u033E𑍰\。ᡣ85\'\)\ \[data\/IdnaTest\.txt\:1769\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ß\x{033E}𑍰。ᡣ85", %p)},	"ß\x{033E}𑍰.ᡣ85",	"to_unicode\(\'ß\\u033E𑍰\。ᡣ85\'\)\ \[data\/IdnaTest\.txt\:1770\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("SS\x{033E}𑍰。ᡣ85", %p)},	"ss\x{033E}𑍰.ᡣ85",	"to_unicode\(\'SS\\u033E𑍰\。ᡣ85\'\)\ \[data\/IdnaTest\.txt\:1771\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ss\x{033E}𑍰。ᡣ85", %p)},	"ss\x{033E}𑍰.ᡣ85",	"to_unicode\(\'ss\\u033E𑍰\。ᡣ85\'\)\ \[data\/IdnaTest\.txt\:1772\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("Ss\x{033E}𑍰。ᡣ85", %p)},	"ss\x{033E}𑍰.ᡣ85",	"to_unicode\(\'Ss\\u033E𑍰\。ᡣ85\'\)\ \[data\/IdnaTest\.txt\:1773\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--ss-izb2489y.xn--85-f8o", %p)},	"ss\x{033E}𑍰.ᡣ85",	"to_unicode\(\'xn\-\-ss\-izb2489y\.xn\-\-85\-f8o\'\)\ \[data\/IdnaTest\.txt\:1774\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ss\x{033E}𑍰.ᡣ85", %p)},	"ss\x{033E}𑍰.ᡣ85",	"to_unicode\(\'ss\\u033E𑍰\.ᡣ85\'\)\ \[data\/IdnaTest\.txt\:1775\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("SS\x{033E}𑍰.ᡣ85", %p)},	"ss\x{033E}𑍰.ᡣ85",	"to_unicode\(\'SS\\u033E𑍰\.ᡣ85\'\)\ \[data\/IdnaTest\.txt\:1776\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("Ss\x{033E}𑍰.ᡣ85", %p)},	"ss\x{033E}𑍰.ᡣ85",	"to_unicode\(\'Ss\\u033E𑍰\.ᡣ85\'\)\ \[data\/IdnaTest\.txt\:1777\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--zca82j0w93b.xn--85-f8o", %p)},	"ß\x{033E}𑍰.ᡣ85",	"to_unicode\(\'xn\-\-zca82j0w93b\.xn\-\-85\-f8o\'\)\ \[data\/IdnaTest\.txt\:1778\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ß\x{033E}𑍰.ᡣ85", %p)},	"ß\x{033E}𑍰.ᡣ85",	"to_unicode\(\'ß\\u033E𑍰\.ᡣ85\'\)\ \[data\/IdnaTest\.txt\:1779\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ß\x{033E}𑍰.ᡣ85", %p)},	"ß\x{033E}𑍰.ᡣ85",	"to_unicode\(\'ß\\u033E𑍰\.ᡣ85\'\)\ \[data\/IdnaTest\.txt\:1780\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("SS\x{033E}𑍰。ᡣ8₅", %p)},	"ss\x{033E}𑍰.ᡣ85",	"to_unicode\(\'SS\\u033E𑍰\。ᡣ8₅\'\)\ \[data\/IdnaTest\.txt\:1781\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ss\x{033E}𑍰。ᡣ8₅", %p)},	"ss\x{033E}𑍰.ᡣ85",	"to_unicode\(\'ss\\u033E𑍰\。ᡣ8₅\'\)\ \[data\/IdnaTest\.txt\:1782\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("Ss\x{033E}𑍰。ᡣ8₅", %p)},	"ss\x{033E}𑍰.ᡣ85",	"to_unicode\(\'Ss\\u033E𑍰\。ᡣ8₅\'\)\ \[data\/IdnaTest\.txt\:1783\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0D4D}𑘳魅𝟣．₃\x{066C}ß", %p)},	undef,	"to_unicode\(\'\\u0D4D𑘳魅𝟣．₃\\u066Cß\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1784\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0D4D}𑘳魅1.3\x{066C}ß", %p)},	undef,	"to_unicode\(\'\\u0D4D𑘳魅1\.3\\u066Cß\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1785\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0D4D}𑘳魅1.3\x{066C}SS", %p)},	undef,	"to_unicode\(\'\\u0D4D𑘳魅1\.3\\u066CSS\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1786\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0D4D}𑘳魅1.3\x{066C}ss", %p)},	undef,	"to_unicode\(\'\\u0D4D𑘳魅1\.3\\u066Css\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1787\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0D4D}𑘳魅1.3\x{066C}Ss", %p)},	undef,	"to_unicode\(\'\\u0D4D𑘳魅1\.3\\u066CSs\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1788\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0D4D}𑘳魅𝟣．₃\x{066C}SS", %p)},	undef,	"to_unicode\(\'\\u0D4D𑘳魅𝟣．₃\\u066CSS\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1789\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0D4D}𑘳魅𝟣．₃\x{066C}ss", %p)},	undef,	"to_unicode\(\'\\u0D4D𑘳魅𝟣．₃\\u066Css\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1790\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0D4D}𑘳魅𝟣．₃\x{066C}Ss", %p)},	undef,	"to_unicode\(\'\\u0D4D𑘳魅𝟣．₃\\u066CSs\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1791\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𐫖｡𑈵⒈\x{1039}⚺", %p)},	undef,	"to_unicode\(\'𐫖｡𑈵⒈\\u1039\⚺\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1792\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐫖。𑈵1.\x{1039}⚺", %p)},	undef,	"to_unicode\(\'𐫖\。𑈵1\.\\u1039\⚺\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1793\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𑘸છ。嵨", %p)},	undef,	"to_unicode\(\'𑘸છ\。嵨\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1794\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴔ≠Ⴀ.𐹶𐹱", %p)},	undef,	"to_unicode\(\'Ⴔ\≠Ⴀ\.𐹶𐹱\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1795\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴔ=\x{0338}Ⴀ.𐹶𐹱", %p)},	undef,	"to_unicode\(\'Ⴔ\=\\u0338Ⴀ\.𐹶𐹱\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1796\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴔ=\x{0338}ⴀ.𐹶𐹱", %p)},	undef,	"to_unicode\(\'ⴔ\=\\u0338ⴀ\.𐹶𐹱\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1797\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴔ≠ⴀ.𐹶𐹱", %p)},	undef,	"to_unicode\(\'ⴔ\≠ⴀ\.𐹶𐹱\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1798\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}⒙\x{0A47}｡\x{0656}", %p)},	undef,	"to_unicode\(\'\-\\u200C⒙\\u0A47｡\\u0656\'\)\ throws\ error\ P1\ V3\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1799\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}⒙\x{0A47}｡\x{0656}", %p)},	undef,	"to_unicode\(\'\-\\u200C⒙\\u0A47｡\\u0656\'\)\ throws\ error\ P1\ V3\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1800\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}18.\x{0A47}。\x{0656}", %p)},	undef,	"to_unicode\(\'\-\\u200C18\.\\u0A47\。\\u0656\'\)\ throws\ error\ V3\ V5\ C1\ \[data\/IdnaTest\.txt\:1801\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}18.\x{0A47}。\x{0656}", %p)},	undef,	"to_unicode\(\'\-\\u200C18\.\\u0A47\。\\u0656\'\)\ throws\ error\ V3\ V5\ C1\ \[data\/IdnaTest\.txt\:1802\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒.ʌ\x{07DF}-𐹲", %p)},	undef,	"to_unicode\(\'︒\.ʌ\\u07DF\-𐹲\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1803\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("。.ʌ\x{07DF}-𐹲", %p)},	undef,	"to_unicode\(\'\。\.ʌ\\u07DF\-𐹲\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1804\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("。.Ʌ\x{07DF}-𐹲", %p)},	undef,	"to_unicode\(\'\。\.Ʌ\\u07DF\-𐹲\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1805\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("︒.Ʌ\x{07DF}-𐹲", %p)},	undef,	"to_unicode\(\'︒\.Ʌ\\u07DF\-𐹲\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1806\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0A41}︒。􋔒󠄻", %p)},	undef,	"to_unicode\(\'\\u0A41︒\。􋔒\󠄻\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1807\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0A41}。。􋔒󠄻", %p)},	undef,	"to_unicode\(\'\\u0A41\。\。􋔒\󠄻\'\)\ throws\ error\ P1\ V5\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1808\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0632}ß􈠸。ꡄ", %p)},	undef,	"to_unicode\(\'\\u0632ß􈠸\。ꡄ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1809\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0632}SS􈠸。ꡄ", %p)},	undef,	"to_unicode\(\'\\u0632SS􈠸\。ꡄ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1810\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0632}ss􈠸。ꡄ", %p)},	undef,	"to_unicode\(\'\\u0632ss􈠸\。ꡄ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1811\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0632}Ss􈠸。ꡄ", %p)},	undef,	"to_unicode\(\'\\u0632Ss􈠸\。ꡄ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1812\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2D7F}\x{200D}\x{0723}𐹹。򲑃󬗝\x{200C}\x{0F79}", %p)},	undef,	"to_unicode\(\'\\u2D7F\\u200D\\u0723𐹹\。򲑃󬗝\\u200C\\u0F79\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1813\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2D7F}\x{200D}\x{0723}𐹹。򲑃󬗝\x{200C}\x{0F79}", %p)},	undef,	"to_unicode\(\'\\u2D7F\\u200D\\u0723𐹹\。򲑃󬗝\\u200C\\u0F79\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1814\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2D7F}\x{200D}\x{0723}𐹹。򲑃󬗝\x{200C}\x{0FB3}\x{0F71}\x{0F80}", %p)},	undef,	"to_unicode\(\'\\u2D7F\\u200D\\u0723𐹹\。򲑃󬗝\\u200C\\u0FB3\\u0F71\\u0F80\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1815\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2D7F}\x{200D}\x{0723}𐹹。򲑃󬗝\x{200C}\x{0FB3}\x{0F71}\x{0F80}", %p)},	undef,	"to_unicode\(\'\\u2D7F\\u200D\\u0723𐹹\。򲑃󬗝\\u200C\\u0FB3\\u0F71\\u0F80\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1816\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍．-ß\x{200C}≠", %p)},	undef,	"to_unicode\(\'\󠝍．\-ß\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1817\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍．-ß\x{200C}≠", %p)},	undef,	"to_unicode\(\'\󠝍．\-ß\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1818\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍．-ß\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\󠝍．\-ß\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1819\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍．-ß\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\󠝍．\-ß\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1820\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍.-ß\x{200C}≠", %p)},	undef,	"to_unicode\(\'\󠝍\.\-ß\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1821\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍.-ß\x{200C}≠", %p)},	undef,	"to_unicode\(\'\󠝍\.\-ß\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1822\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍.-ß\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\󠝍\.\-ß\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1823\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍.-ß\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\󠝍\.\-ß\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1824\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍.-SS\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\󠝍\.\-SS\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1825\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍.-SS\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\󠝍\.\-SS\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1826\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍.-SS\x{200C}≠", %p)},	undef,	"to_unicode\(\'\󠝍\.\-SS\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1827\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍.-SS\x{200C}≠", %p)},	undef,	"to_unicode\(\'\󠝍\.\-SS\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1828\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍.-ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\󠝍\.\-ss\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1829\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍.-ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\󠝍\.\-ss\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1830\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍.-ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\󠝍\.\-ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1831\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍.-ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\󠝍\.\-ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1832\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍.-Ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\󠝍\.\-Ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1833\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍.-Ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\󠝍\.\-Ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1834\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍.-Ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\󠝍\.\-Ss\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1835\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍.-Ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\󠝍\.\-Ss\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1836\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍．-SS\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\󠝍．\-SS\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1837\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍．-SS\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\󠝍．\-SS\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1838\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍．-SS\x{200C}≠", %p)},	undef,	"to_unicode\(\'\󠝍．\-SS\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1839\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍．-SS\x{200C}≠", %p)},	undef,	"to_unicode\(\'\󠝍．\-SS\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1840\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍．-ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\󠝍．\-ss\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1841\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍．-ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\󠝍．\-ss\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1842\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍．-ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\󠝍．\-ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1843\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍．-ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\󠝍．\-ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1844\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍．-Ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\󠝍．\-Ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1845\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍．-Ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\󠝍．\-Ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1846\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍．-Ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\󠝍．\-Ss\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1847\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝍．-Ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\󠝍．\-Ss\\u200C\≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1848\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07DF}\x{200C}｡≯𐋲≠", %p)},	undef,	"to_unicode\(\'\\u07DF\\u200C｡\≯𐋲\≠\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:1849\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07DF}\x{200C}｡≯𐋲≠", %p)},	undef,	"to_unicode\(\'\\u07DF\\u200C｡\≯𐋲\≠\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:1850\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07DF}\x{200C}｡>\x{0338}𐋲=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u07DF\\u200C｡\>\\u0338𐋲\=\\u0338\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:1851\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07DF}\x{200C}｡>\x{0338}𐋲=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u07DF\\u200C｡\>\\u0338𐋲\=\\u0338\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:1852\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07DF}\x{200C}。≯𐋲≠", %p)},	undef,	"to_unicode\(\'\\u07DF\\u200C\。\≯𐋲\≠\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:1853\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07DF}\x{200C}。≯𐋲≠", %p)},	undef,	"to_unicode\(\'\\u07DF\\u200C\。\≯𐋲\≠\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:1854\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07DF}\x{200C}。>\x{0338}𐋲=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u07DF\\u200C\。\>\\u0338𐋲\=\\u0338\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:1855\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07DF}\x{200C}。>\x{0338}𐋲=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u07DF\\u200C\。\>\\u0338𐋲\=\\u0338\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:1856\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹩\x{088E}\x{031C}􊧭。\x{20E9}🄀", %p)},	undef,	"to_unicode\(\'𐹩\\u088E\\u031C􊧭\。\\u20E9🄀\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1857\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹩\x{088E}\x{031C}􊧭。\x{20E9}0.", %p)},	undef,	"to_unicode\(\'𐹩\\u088E\\u031C􊧭\。\\u20E90\.\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1858\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ．\x{200D}\x{0767}󙄁ς", %p)},	undef,	"to_unicode\(\'Ⴄ．\\u200D\\u0767󙄁ς\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1859\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ．\x{200D}\x{0767}󙄁ς", %p)},	undef,	"to_unicode\(\'Ⴄ．\\u200D\\u0767󙄁ς\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1860\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ.\x{200D}\x{0767}󙄁ς", %p)},	undef,	"to_unicode\(\'Ⴄ\.\\u200D\\u0767󙄁ς\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1861\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ.\x{200D}\x{0767}󙄁ς", %p)},	undef,	"to_unicode\(\'Ⴄ\.\\u200D\\u0767󙄁ς\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1862\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ.\x{200D}\x{0767}󙄁ς", %p)},	undef,	"to_unicode\(\'ⴄ\.\\u200D\\u0767󙄁ς\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1863\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ.\x{200D}\x{0767}󙄁ς", %p)},	undef,	"to_unicode\(\'ⴄ\.\\u200D\\u0767󙄁ς\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1864\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ.\x{200D}\x{0767}󙄁Σ", %p)},	undef,	"to_unicode\(\'Ⴄ\.\\u200D\\u0767󙄁Σ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1865\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ.\x{200D}\x{0767}󙄁Σ", %p)},	undef,	"to_unicode\(\'Ⴄ\.\\u200D\\u0767󙄁Σ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1866\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ.\x{200D}\x{0767}󙄁σ", %p)},	undef,	"to_unicode\(\'ⴄ\.\\u200D\\u0767󙄁σ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1867\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ.\x{200D}\x{0767}󙄁σ", %p)},	undef,	"to_unicode\(\'ⴄ\.\\u200D\\u0767󙄁σ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1868\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ．\x{200D}\x{0767}󙄁ς", %p)},	undef,	"to_unicode\(\'ⴄ．\\u200D\\u0767󙄁ς\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1869\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ．\x{200D}\x{0767}󙄁ς", %p)},	undef,	"to_unicode\(\'ⴄ．\\u200D\\u0767󙄁ς\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1870\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ．\x{200D}\x{0767}󙄁Σ", %p)},	undef,	"to_unicode\(\'Ⴄ．\\u200D\\u0767󙄁Σ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1871\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ．\x{200D}\x{0767}󙄁Σ", %p)},	undef,	"to_unicode\(\'Ⴄ．\\u200D\\u0767󙄁Σ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1872\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ．\x{200D}\x{0767}󙄁σ", %p)},	undef,	"to_unicode\(\'ⴄ．\\u200D\\u0767󙄁σ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1873\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ．\x{200D}\x{0767}󙄁σ", %p)},	undef,	"to_unicode\(\'ⴄ．\\u200D\\u0767󙄁σ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1874\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󐠫\x{0365}.Ⴕ", %p)},	undef,	"to_unicode\(\'󐠫\\u0365\.Ⴕ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1875\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󐠫\x{0365}.ⴕ", %p)},	undef,	"to_unicode\(\'󐠫\\u0365\.ⴕ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1876\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{0AC3}𞨮。\x{200C}𑘿󠔹\x{200D}", %p)},	undef,	"to_unicode\(\'\≯\\u0AC3𞨮\。\\u200C𑘿\󠔹\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1877\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{0AC3}𞨮。\x{200C}𑘿󠔹\x{200D}", %p)},	undef,	"to_unicode\(\'\≯\\u0AC3𞨮\。\\u200C𑘿\󠔹\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1878\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{0AC3}𞨮。\x{200C}𑘿󠔹\x{200D}", %p)},	undef,	"to_unicode\(\'\>\\u0338\\u0AC3𞨮\。\\u200C𑘿\󠔹\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1879\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{0AC3}𞨮。\x{200C}𑘿󠔹\x{200D}", %p)},	undef,	"to_unicode\(\'\>\\u0338\\u0AC3𞨮\。\\u200C𑘿\󠔹\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1880\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1DF0}｡񊩧", %p)},	undef,	"to_unicode\(\'\\u200C\\u1DF0｡񊩧\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1881\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1DF0}｡񊩧", %p)},	undef,	"to_unicode\(\'\\u200C\\u1DF0｡񊩧\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1882\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1DF0}。񊩧", %p)},	undef,	"to_unicode\(\'\\u200C\\u1DF0\。񊩧\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1883\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1DF0}。񊩧", %p)},	undef,	"to_unicode\(\'\\u200C\\u1DF0\。񊩧\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1884\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈𑁅焅.񖠲\x{200D}\x{06D1}", %p)},	undef,	"to_unicode\(\'⒈𑁅焅\.񖠲\\u200D\\u06D1\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:1885\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈𑁅焅.񖠲\x{200D}\x{06D1}", %p)},	undef,	"to_unicode\(\'⒈𑁅焅\.񖠲\\u200D\\u06D1\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:1886\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.𑁅焅.񖠲\x{200D}\x{06D1}", %p)},	undef,	"to_unicode\(\'1\.𑁅焅\.񖠲\\u200D\\u06D1\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:1887\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.𑁅焅.񖠲\x{200D}\x{06D1}", %p)},	undef,	"to_unicode\(\'1\.𑁅焅\.񖠲\\u200D\\u06D1\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:1888\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠁐ς≮.ς\x{A9B8}ᡤ0", %p)},	undef,	"to_unicode\(\'\󠁐ς\≮\.ς\\uA9B8ᡤ0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1889\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠁐ς<\x{0338}.ς\x{A9B8}ᡤ0", %p)},	undef,	"to_unicode\(\'\󠁐ς\<\\u0338\.ς\\uA9B8ᡤ0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1890\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠁐Σ<\x{0338}.Σ\x{A9B8}ᡤ0", %p)},	undef,	"to_unicode\(\'\󠁐Σ\<\\u0338\.Σ\\uA9B8ᡤ0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1891\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠁐Σ≮.Σ\x{A9B8}ᡤ0", %p)},	undef,	"to_unicode\(\'\󠁐Σ\≮\.Σ\\uA9B8ᡤ0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1892\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠁐σ≮.σ\x{A9B8}ᡤ0", %p)},	undef,	"to_unicode\(\'\󠁐σ\≮\.σ\\uA9B8ᡤ0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1893\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠁐σ<\x{0338}.σ\x{A9B8}ᡤ0", %p)},	undef,	"to_unicode\(\'\󠁐σ\<\\u0338\.σ\\uA9B8ᡤ0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1894\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򎲖ß𑁅ᡦ.\x{0E34}\x{0850}", %p)},	undef,	"to_unicode\(\'򎲖ß𑁅ᡦ\.\\u0E34\\u0850\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1895\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򎲖SS𑁅ᡦ.\x{0E34}\x{0850}", %p)},	undef,	"to_unicode\(\'򎲖SS𑁅ᡦ\.\\u0E34\\u0850\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1896\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򎲖ss𑁅ᡦ.\x{0E34}\x{0850}", %p)},	undef,	"to_unicode\(\'򎲖ss𑁅ᡦ\.\\u0E34\\u0850\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1897\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򎲖Ss𑁅ᡦ.\x{0E34}\x{0850}", %p)},	undef,	"to_unicode\(\'򎲖Ss𑁅ᡦ\.\\u0E34\\u0850\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1898\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{0717}｡⒈", %p)},	undef,	"to_unicode\(\'\-\\u0717｡⒈\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1899\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{0717}。1.", %p)},	undef,	"to_unicode\(\'\-\\u0717\。1\.\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:1900\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("𨇆ᢪ𝟡。ᡆ\x{0BCD}", %p)},	"𨇆ᢪ9.ᡆ\x{0BCD}",	"to_unicode\(\'𨇆ᢪ𝟡\。ᡆ\\u0BCD\'\)\ \[data\/IdnaTest\.txt\:1901\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("𨇆ᢪ9。ᡆ\x{0BCD}", %p)},	"𨇆ᢪ9.ᡆ\x{0BCD}",	"to_unicode\(\'𨇆ᢪ9\。ᡆ\\u0BCD\'\)\ \[data\/IdnaTest\.txt\:1902\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("xn--9-rdkz5694a.xn--xmc994d", %p)},	"𨇆ᢪ9.ᡆ\x{0BCD}",	"to_unicode\(\'xn\-\-9\-rdkz5694a\.xn\-\-xmc994d\'\)\ \[data\/IdnaTest\.txt\:1903\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("𨇆ᢪ9.ᡆ\x{0BCD}", %p)},	"𨇆ᢪ9.ᡆ\x{0BCD}",	"to_unicode\(\'𨇆ᢪ9\.ᡆ\\u0BCD\'\)\ \[data\/IdnaTest\.txt\:1904\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("𐹨𞺸𐹽󠆼.\x{200D}", %p)},	undef,	"to_unicode\(\'𐹨𞺸𐹽\󠆼\.\\u200D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:1905\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("𐹨𞺸𐹽󠆼.\x{200D}", %p)},	undef,	"to_unicode\(\'𐹨𞺸𐹽\󠆼\.\\u200D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:1906\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹨\x{0630}𐹽󠆼.\x{200D}", %p)},	undef,	"to_unicode\(\'𐹨\\u0630𐹽\󠆼\.\\u200D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:1907\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹨\x{0630}𐹽󠆼.\x{200D}", %p)},	undef,	"to_unicode\(\'𐹨\\u0630𐹽\󠆼\.\\u200D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:1908\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𝟘．Ⴇ񜚙𞸀򋝟", %p)},	undef,	"to_unicode\(\'𝟘．Ⴇ񜚙𞸀򋝟\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1909\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0.Ⴇ񜚙\x{0627}򋝟", %p)},	undef,	"to_unicode\(\'0\.Ⴇ񜚙\\u0627򋝟\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1910\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0.ⴇ񜚙\x{0627}򋝟", %p)},	undef,	"to_unicode\(\'0\.ⴇ񜚙\\u0627򋝟\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1911\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟘．ⴇ񜚙𞸀򋝟", %p)},	undef,	"to_unicode\(\'𝟘．ⴇ񜚙𞸀򋝟\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1912\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1734}😅.󠂱ᠨ", %p)},	undef,	"to_unicode\(\'\\u1734😅\.\󠂱ᠨ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1913\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-ᠺ.򀬭", %p)},	undef,	"to_unicode\(\'\\u200D\-ᠺ\.򀬭\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1914\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}-ᠺ.򀬭", %p)},	undef,	"to_unicode\(\'\\u200D\-ᠺ\.򀬭\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1915\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡖ\x{0767}\x{06D5}寐｡\x{200C}≯⩓", %p)},	undef,	"to_unicode\(\'ᡖ\\u0767\\u06D5寐｡\\u200C\≯\⩓\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:1916\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡖ\x{0767}\x{06D5}寐｡\x{200C}≯⩓", %p)},	undef,	"to_unicode\(\'ᡖ\\u0767\\u06D5寐｡\\u200C\≯\⩓\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:1917\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡖ\x{0767}\x{06D5}寐｡\x{200C}>\x{0338}⩓", %p)},	undef,	"to_unicode\(\'ᡖ\\u0767\\u06D5寐｡\\u200C\>\\u0338\⩓\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:1918\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡖ\x{0767}\x{06D5}寐｡\x{200C}>\x{0338}⩓", %p)},	undef,	"to_unicode\(\'ᡖ\\u0767\\u06D5寐｡\\u200C\>\\u0338\⩓\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:1919\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡖ\x{0767}\x{06D5}寐。\x{200C}≯⩓", %p)},	undef,	"to_unicode\(\'ᡖ\\u0767\\u06D5寐\。\\u200C\≯\⩓\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:1920\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡖ\x{0767}\x{06D5}寐。\x{200C}≯⩓", %p)},	undef,	"to_unicode\(\'ᡖ\\u0767\\u06D5寐\。\\u200C\≯\⩓\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:1921\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡖ\x{0767}\x{06D5}寐。\x{200C}>\x{0338}⩓", %p)},	undef,	"to_unicode\(\'ᡖ\\u0767\\u06D5寐\。\\u200C\>\\u0338\⩓\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:1922\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡖ\x{0767}\x{06D5}寐。\x{200C}>\x{0338}⩓", %p)},	undef,	"to_unicode\(\'ᡖ\\u0767\\u06D5寐\。\\u200C\>\\u0338\⩓\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:1923\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}｡򧯞ႺႴ\x{FE85}", %p)},	undef,	"to_unicode\(\'\\u200D｡򧯞ႺႴ\\uFE85\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1924\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}｡򧯞ႺႴ\x{FE85}", %p)},	undef,	"to_unicode\(\'\\u200D｡򧯞ႺႴ\\uFE85\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1925\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。򧯞ႺႴ\x{0624}", %p)},	undef,	"to_unicode\(\'\\u200D\。򧯞ႺႴ\\u0624\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1926\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。򧯞ႺႴ\x{0624}", %p)},	undef,	"to_unicode\(\'\\u200D\。򧯞ႺႴ\\u0624\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1927\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。򧯞ႺႴ\x{0648}\x{0654}", %p)},	undef,	"to_unicode\(\'\\u200D\。򧯞ႺႴ\\u0648\\u0654\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1928\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。򧯞ႺႴ\x{0648}\x{0654}", %p)},	undef,	"to_unicode\(\'\\u200D\。򧯞ႺႴ\\u0648\\u0654\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1929\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。򧯞ⴚⴔ\x{0648}\x{0654}", %p)},	undef,	"to_unicode\(\'\\u200D\。򧯞ⴚⴔ\\u0648\\u0654\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1930\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。򧯞ⴚⴔ\x{0648}\x{0654}", %p)},	undef,	"to_unicode\(\'\\u200D\。򧯞ⴚⴔ\\u0648\\u0654\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1931\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。򧯞ⴚⴔ\x{0624}", %p)},	undef,	"to_unicode\(\'\\u200D\。򧯞ⴚⴔ\\u0624\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1932\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。򧯞ⴚⴔ\x{0624}", %p)},	undef,	"to_unicode\(\'\\u200D\。򧯞ⴚⴔ\\u0624\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1933\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。򧯞Ⴚⴔ\x{0624}", %p)},	undef,	"to_unicode\(\'\\u200D\。򧯞Ⴚⴔ\\u0624\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1934\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。򧯞Ⴚⴔ\x{0624}", %p)},	undef,	"to_unicode\(\'\\u200D\。򧯞Ⴚⴔ\\u0624\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1935\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。򧯞Ⴚⴔ\x{0648}\x{0654}", %p)},	undef,	"to_unicode\(\'\\u200D\。򧯞Ⴚⴔ\\u0648\\u0654\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1936\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。򧯞Ⴚⴔ\x{0648}\x{0654}", %p)},	undef,	"to_unicode\(\'\\u200D\。򧯞Ⴚⴔ\\u0648\\u0654\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1937\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}｡򧯞ⴚⴔ\x{FE85}", %p)},	undef,	"to_unicode\(\'\\u200D｡򧯞ⴚⴔ\\uFE85\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1938\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}｡򧯞ⴚⴔ\x{FE85}", %p)},	undef,	"to_unicode\(\'\\u200D｡򧯞ⴚⴔ\\uFE85\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1939\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}｡򧯞Ⴚⴔ\x{FE85}", %p)},	undef,	"to_unicode\(\'\\u200D｡򧯞Ⴚⴔ\\uFE85\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1940\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}｡򧯞Ⴚⴔ\x{FE85}", %p)},	undef,	"to_unicode\(\'\\u200D｡򧯞Ⴚⴔ\\uFE85\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1941\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-3.\x{200D}ヌᡰ", %p)},	undef,	"to_unicode\(\'\-3\.\\u200Dヌᡰ\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:1942\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-3.\x{200D}ヌᡰ", %p)},	undef,	"to_unicode\(\'\-3\.\\u200Dヌᡰ\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:1943\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⑰\x{0665}ß\x{200D}。󠟐򑉓\x{FC75}-", %p)},	undef,	"to_unicode\(\'⑰\\u0665ß\\u200D\。\󠟐򑉓\\uFC75\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1944\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⑰\x{0665}ß\x{200D}。󠟐򑉓\x{FC75}-", %p)},	undef,	"to_unicode\(\'⑰\\u0665ß\\u200D\。\󠟐򑉓\\uFC75\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1945\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("17\x{0665}ß\x{200D}。󠟐򑉓\x{062A}\x{064A}-", %p)},	undef,	"to_unicode\(\'17\\u0665ß\\u200D\。\󠟐򑉓\\u062A\\u064A\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1946\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("17\x{0665}ß\x{200D}。󠟐򑉓\x{062A}\x{064A}-", %p)},	undef,	"to_unicode\(\'17\\u0665ß\\u200D\。\󠟐򑉓\\u062A\\u064A\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1947\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("17\x{0665}SS\x{200D}。󠟐򑉓\x{062A}\x{064A}-", %p)},	undef,	"to_unicode\(\'17\\u0665SS\\u200D\。\󠟐򑉓\\u062A\\u064A\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1948\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("17\x{0665}SS\x{200D}。󠟐򑉓\x{062A}\x{064A}-", %p)},	undef,	"to_unicode\(\'17\\u0665SS\\u200D\。\󠟐򑉓\\u062A\\u064A\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1949\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("17\x{0665}ss\x{200D}。󠟐򑉓\x{062A}\x{064A}-", %p)},	undef,	"to_unicode\(\'17\\u0665ss\\u200D\。\󠟐򑉓\\u062A\\u064A\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1950\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("17\x{0665}ss\x{200D}。󠟐򑉓\x{062A}\x{064A}-", %p)},	undef,	"to_unicode\(\'17\\u0665ss\\u200D\。\󠟐򑉓\\u062A\\u064A\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1951\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("17\x{0665}Ss\x{200D}。󠟐򑉓\x{062A}\x{064A}-", %p)},	undef,	"to_unicode\(\'17\\u0665Ss\\u200D\。\󠟐򑉓\\u062A\\u064A\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1952\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("17\x{0665}Ss\x{200D}。󠟐򑉓\x{062A}\x{064A}-", %p)},	undef,	"to_unicode\(\'17\\u0665Ss\\u200D\。\󠟐򑉓\\u062A\\u064A\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1953\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⑰\x{0665}SS\x{200D}。󠟐򑉓\x{FC75}-", %p)},	undef,	"to_unicode\(\'⑰\\u0665SS\\u200D\。\󠟐򑉓\\uFC75\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1954\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⑰\x{0665}SS\x{200D}。󠟐򑉓\x{FC75}-", %p)},	undef,	"to_unicode\(\'⑰\\u0665SS\\u200D\。\󠟐򑉓\\uFC75\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1955\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⑰\x{0665}ss\x{200D}。󠟐򑉓\x{FC75}-", %p)},	undef,	"to_unicode\(\'⑰\\u0665ss\\u200D\。\󠟐򑉓\\uFC75\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1956\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⑰\x{0665}ss\x{200D}。󠟐򑉓\x{FC75}-", %p)},	undef,	"to_unicode\(\'⑰\\u0665ss\\u200D\。\󠟐򑉓\\uFC75\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1957\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⑰\x{0665}Ss\x{200D}。󠟐򑉓\x{FC75}-", %p)},	undef,	"to_unicode\(\'⑰\\u0665Ss\\u200D\。\󠟐򑉓\\uFC75\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1958\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⑰\x{0665}Ss\x{200D}。󠟐򑉓\x{FC75}-", %p)},	undef,	"to_unicode\(\'⑰\\u0665Ss\\u200D\。\󠟐򑉓\\uFC75\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1959\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꇟ-\x{07D5}𐫠。񛳊\x{200C}", %p)},	undef,	"to_unicode\(\'ꇟ\-\\u07D5𐫠\。񛳊\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1960\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꇟ-\x{07D5}𐫠。񛳊\x{200C}", %p)},	undef,	"to_unicode\(\'ꇟ\-\\u07D5𐫠\。񛳊\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1961\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{066C}.\x{0FA3}\x{FB58}𐨿蟵", %p)},	undef,	"to_unicode\(\'\\u066C\.\\u0FA3\\uFB58𐨿蟵\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1962\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{066C}.\x{0FA3}\x{067E}𐨿蟵", %p)},	undef,	"to_unicode\(\'\\u066C\.\\u0FA3\\u067E𐨿蟵\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1963\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-.򟊕\x{0756}\x{0C4D}", %p)},	undef,	"to_unicode\(\'\-\.򟊕\\u0756\\u0C4D\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1964\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󆕀ς.\x{FDC8}녫ß", %p)},	undef,	"to_unicode\(\'󆕀ς\.\\uFDC8녫ß\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1965\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󆕀ς.\x{FDC8}녫ß", %p)},	undef,	"to_unicode\(\'󆕀ς\.\\uFDC8녫ß\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1966\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󆕀Σ.\x{FDC8}녫SS", %p)},	undef,	"to_unicode\(\'󆕀Σ\.\\uFDC8녫SS\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1967\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󆕀Σ.\x{FDC8}녫SS", %p)},	undef,	"to_unicode\(\'󆕀Σ\.\\uFDC8녫SS\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1968\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󆕀σ.\x{FDC8}녫ss", %p)},	undef,	"to_unicode\(\'󆕀σ\.\\uFDC8녫ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1969\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󆕀σ.\x{FDC8}녫ss", %p)},	undef,	"to_unicode\(\'󆕀σ\.\\uFDC8녫ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1970\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󆕀Σ.\x{FDC8}녫Ss", %p)},	undef,	"to_unicode\(\'󆕀Σ\.\\uFDC8녫Ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1971\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󆕀Σ.\x{FDC8}녫Ss", %p)},	undef,	"to_unicode\(\'󆕀Σ\.\\uFDC8녫Ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1972\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ𑖿\x{200D}｡≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ𑖿\\u200D｡\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1973\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ𑖿\x{200D}｡≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ𑖿\\u200D｡\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1974\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ𑖿\x{200D}｡=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ𑖿\\u200D｡\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1975\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ𑖿\x{200D}｡=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ𑖿\\u200D｡\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1976\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ𑖿\x{200D}。≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ𑖿\\u200D\。\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1977\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ𑖿\x{200D}。≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ𑖿\\u200D\。\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1978\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ𑖿\x{200D}。=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ𑖿\\u200D\。\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1979\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ𑖿\x{200D}。=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ𑖿\\u200D\。\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1980\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ𑖿\x{200D}。=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ𑖿\\u200D\。\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1981\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ𑖿\x{200D}。=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ𑖿\\u200D\。\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1982\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ𑖿\x{200D}。≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ𑖿\\u200D\。\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1983\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ𑖿\x{200D}。≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ𑖿\\u200D\。\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1984\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ𑖿\x{200D}｡=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ𑖿\\u200D｡\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1985\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ𑖿\x{200D}｡=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ𑖿\\u200D｡\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1986\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ𑖿\x{200D}｡≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ𑖿\\u200D｡\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1987\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ𑖿\x{200D}｡≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ𑖿\\u200D｡\≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1988\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋺\x{09CD}\x{0BCD}򽕵．\x{200C}\x{1BF2}\x{0719}", %p)},	undef,	"to_unicode\(\'𐋺\\u09CD\\u0BCD򽕵．\\u200C\\u1BF2\\u0719\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1989\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋺\x{09CD}\x{0BCD}򽕵．\x{200C}\x{1BF2}\x{0719}", %p)},	undef,	"to_unicode\(\'𐋺\\u09CD\\u0BCD򽕵．\\u200C\\u1BF2\\u0719\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1990\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋺\x{09CD}\x{0BCD}򽕵.\x{200C}\x{1BF2}\x{0719}", %p)},	undef,	"to_unicode\(\'𐋺\\u09CD\\u0BCD򽕵\.\\u200C\\u1BF2\\u0719\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1991\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋺\x{09CD}\x{0BCD}򽕵.\x{200C}\x{1BF2}\x{0719}", %p)},	undef,	"to_unicode\(\'𐋺\\u09CD\\u0BCD򽕵\.\\u200C\\u1BF2\\u0719\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1992\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񶪗𑍰．≯", %p)},	undef,	"to_unicode\(\'񶪗𑍰．\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1993\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񶪗𑍰．>\x{0338}", %p)},	undef,	"to_unicode\(\'񶪗𑍰．\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1994\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񶪗𑍰.≯", %p)},	undef,	"to_unicode\(\'񶪗𑍰\.\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1995\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񶪗𑍰.>\x{0338}", %p)},	undef,	"to_unicode\(\'񶪗𑍰\.\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1996\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐱼Ⴓ．\x{3099}", %p)},	undef,	"to_unicode\(\'\\u200D𐱼Ⴓ．\\u3099\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1997\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐱼Ⴓ．\x{3099}", %p)},	undef,	"to_unicode\(\'\\u200D𐱼Ⴓ．\\u3099\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1998\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐱼Ⴓ.\x{3099}", %p)},	undef,	"to_unicode\(\'\\u200D𐱼Ⴓ\.\\u3099\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1999\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐱼Ⴓ.\x{3099}", %p)},	undef,	"to_unicode\(\'\\u200D𐱼Ⴓ\.\\u3099\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:2000\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐱼ⴓ.\x{3099}", %p)},	undef,	"to_unicode\(\'\\u200D𐱼ⴓ\.\\u3099\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:2001\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐱼ⴓ.\x{3099}", %p)},	undef,	"to_unicode\(\'\\u200D𐱼ⴓ\.\\u3099\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:2002\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐱼ⴓ．\x{3099}", %p)},	undef,	"to_unicode\(\'\\u200D𐱼ⴓ．\\u3099\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:2003\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}𐱼ⴓ．\x{3099}", %p)},	undef,	"to_unicode\(\'\\u200D𐱼ⴓ．\\u3099\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:2004\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐭮ß\x{0E36}．\x{0698}", %p)},	undef,	"to_unicode\(\'𐭮ß\\u0E36．\\u0698\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2005\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐭮ß\x{0E36}.\x{0698}", %p)},	undef,	"to_unicode\(\'𐭮ß\\u0E36\.\\u0698\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2006\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐭮SS\x{0E36}.\x{0698}", %p)},	undef,	"to_unicode\(\'𐭮SS\\u0E36\.\\u0698\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2007\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐭮ss\x{0E36}.\x{0698}", %p)},	undef,	"to_unicode\(\'𐭮ss\\u0E36\.\\u0698\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2008\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐭮Ss\x{0E36}.\x{0698}", %p)},	undef,	"to_unicode\(\'𐭮Ss\\u0E36\.\\u0698\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2009\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐭮SS\x{0E36}．\x{0698}", %p)},	undef,	"to_unicode\(\'𐭮SS\\u0E36．\\u0698\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2010\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐭮ss\x{0E36}．\x{0698}", %p)},	undef,	"to_unicode\(\'𐭮ss\\u0E36．\\u0698\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2011\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐭮Ss\x{0E36}．\x{0698}", %p)},	undef,	"to_unicode\(\'𐭮Ss\\u0E36．\\u0698\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2012\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{A806}\x{2DE4}鸮\x{1714}.ς", %p)},	undef,	"to_unicode\(\'\\uA806\\u2DE4鸮\\u1714\.ς\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2013\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{A806}\x{2DE4}鸮\x{1714}.Σ", %p)},	undef,	"to_unicode\(\'\\uA806\\u2DE4鸮\\u1714\.Σ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2014\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{A806}\x{2DE4}鸮\x{1714}.σ", %p)},	undef,	"to_unicode\(\'\\uA806\\u2DE4鸮\\u1714\.σ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2015\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⒗𐫤。-\x{A806}", %p)},	undef,	"to_unicode\(\'⒗𐫤\。\-\\uA806\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2016\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("16.𐫤。-\x{A806}", %p)},	undef,	"to_unicode\(\'16\.𐫤\。\-\\uA806\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2017\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ᠤ\x{0855}🎮｡𐹡ꡛ⒈", %p)},	undef,	"to_unicode\(\'ᠤ\\u0855🎮｡𐹡ꡛ⒈\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2018\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("ᠤ\x{0855}🎮。𐹡ꡛ1.", %p)},	undef,	"to_unicode\(\'ᠤ\\u0855🎮\。𐹡ꡛ1\.\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2019\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{2433}𕔫𝟧𐹶.\x{0679}8\x{1DC2}𐹻", %p)},	undef,	"to_unicode\(\'\\u2433𕔫𝟧𐹶\.\\u06798\\u1DC2𐹻\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B4\ \[data\/IdnaTest\.txt\:2020\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2433}𕔫5𐹶.\x{0679}8\x{1DC2}𐹻", %p)},	undef,	"to_unicode\(\'\\u2433𕔫5𐹶\.\\u06798\\u1DC2𐹻\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B4\ \[data\/IdnaTest\.txt\:2021\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹺.🄀⒒-򹉒", %p)},	undef,	"to_unicode\(\'𐹺\.🄀⒒\-򹉒\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2022\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹺.0.11.-򹉒", %p)},	undef,	"to_unicode\(\'𐹺\.0\.11\.\-򹉒\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2023\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς-。\x{200C}𝟭-", %p)},	undef,	"to_unicode\(\'ς\-\。\\u200C𝟭\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2024\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς-。\x{200C}𝟭-", %p)},	undef,	"to_unicode\(\'ς\-\。\\u200C𝟭\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2025\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς-。\x{200C}1-", %p)},	undef,	"to_unicode\(\'ς\-\。\\u200C1\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2026\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς-。\x{200C}1-", %p)},	undef,	"to_unicode\(\'ς\-\。\\u200C1\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2027\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ-。\x{200C}1-", %p)},	undef,	"to_unicode\(\'Σ\-\。\\u200C1\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2028\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ-。\x{200C}1-", %p)},	undef,	"to_unicode\(\'Σ\-\。\\u200C1\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2029\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ-。\x{200C}1-", %p)},	undef,	"to_unicode\(\'σ\-\。\\u200C1\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2030\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ-。\x{200C}1-", %p)},	undef,	"to_unicode\(\'σ\-\。\\u200C1\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2031\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ-。\x{200C}𝟭-", %p)},	undef,	"to_unicode\(\'Σ\-\。\\u200C𝟭\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2032\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ-。\x{200C}𝟭-", %p)},	undef,	"to_unicode\(\'Σ\-\。\\u200C𝟭\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2033\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ-。\x{200C}𝟭-", %p)},	undef,	"to_unicode\(\'σ\-\。\\u200C𝟭\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2034\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ-。\x{200C}𝟭-", %p)},	undef,	"to_unicode\(\'σ\-\。\\u200C𝟭\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2035\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0ACD}-\x{1BAB}．\x{1DEB}Ⴄ", %p)},	undef,	"to_unicode\(\'\\u0ACD\-\\u1BAB．\\u1DEBႤ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2036\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0ACD}-\x{1BAB}.\x{1DEB}Ⴄ", %p)},	undef,	"to_unicode\(\'\\u0ACD\-\\u1BAB\.\\u1DEBႤ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2037\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0ACD}-\x{1BAB}.\x{1DEB}ⴄ", %p)},	undef,	"to_unicode\(\'\\u0ACD\-\\u1BAB\.\\u1DEBⴄ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2038\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0ACD}-\x{1BAB}．\x{1DEB}ⴄ", %p)},	undef,	"to_unicode\(\'\\u0ACD\-\\u1BAB．\\u1DEBⴄ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2039\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("񢒷℟ᢨ\x{FD05}｡⦟⒈", %p)},	undef,	"to_unicode\(\'񢒷℟ᢨ\\uFD05｡\⦟⒈\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2040\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񢒷℟ᢨ\x{0635}\x{0649}。⦟1.", %p)},	undef,	"to_unicode\(\'񢒷℟ᢨ\\u0635\\u0649\。\⦟1\.\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2041\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠁂．ᡇ\x{0348}\x{200C}", %p)},	undef,	"to_unicode\(\'\󠁂．ᡇ\\u0348\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2042\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠁂．ᡇ\x{0348}\x{200C}", %p)},	undef,	"to_unicode\(\'\󠁂．ᡇ\\u0348\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2043\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠁂.ᡇ\x{0348}\x{200C}", %p)},	undef,	"to_unicode\(\'\󠁂\.ᡇ\\u0348\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2044\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠁂.ᡇ\x{0348}\x{200C}", %p)},	undef,	"to_unicode\(\'\󠁂\.ᡇ\\u0348\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2045\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("慹ᢏ≮\x{0DCA}．\x{FE8E}", %p)},	undef,	"to_unicode\(\'慹ᢏ\≮\\u0DCA．\\uFE8E\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2046\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("慹ᢏ<\x{0338}\x{0DCA}．\x{FE8E}", %p)},	undef,	"to_unicode\(\'慹ᢏ\<\\u0338\\u0DCA．\\uFE8E\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2047\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("慹ᢏ≮\x{0DCA}.\x{0627}", %p)},	undef,	"to_unicode\(\'慹ᢏ\≮\\u0DCA\.\\u0627\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2048\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("慹ᢏ<\x{0338}\x{0DCA}.\x{0627}", %p)},	undef,	"to_unicode\(\'慹ᢏ\<\\u0338\\u0DCA\.\\u0627\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2049\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。𖬵⒈ꡍ󨮞", %p)},	undef,	"to_unicode\(\'\\u200D\。𖬵⒈ꡍ󨮞\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2050\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。𖬵⒈ꡍ󨮞", %p)},	undef,	"to_unicode\(\'\\u200D\。𖬵⒈ꡍ󨮞\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2051\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。𖬵1.ꡍ󨮞", %p)},	undef,	"to_unicode\(\'\\u200D\。𖬵1\.ꡍ󨮞\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2052\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。𖬵1.ꡍ󨮞", %p)},	undef,	"to_unicode\(\'\\u200D\。𖬵1\.ꡍ󨮞\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2053\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("₈ᠥ．𞤤≠", %p)},	undef,	"to_unicode\(\'₈ᠥ．𞤤\≠\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:2054\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("₈ᠥ．𞤤=\x{0338}", %p)},	undef,	"to_unicode\(\'₈ᠥ．𞤤\=\\u0338\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:2055\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("8ᠥ.𞤤≠", %p)},	undef,	"to_unicode\(\'8ᠥ\.𞤤\≠\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:2056\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("8ᠥ.𞤤=\x{0338}", %p)},	undef,	"to_unicode\(\'8ᠥ\.𞤤\=\\u0338\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:2057\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06A7}\x{069F}񰍸.⒒\x{0680}\x{2DF0}", %p)},	undef,	"to_unicode\(\'\\u06A7\\u069F񰍸\.⒒\\u0680\\u2DF0\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2058\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06A7}\x{069F}񰍸.11.\x{0680}\x{2DF0}", %p)},	undef,	"to_unicode\(\'\\u06A7\\u069F񰍸\.11\.\\u0680\\u2DF0\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2059\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑍀-𐹢𝟜.󠔸𝩜⒏", %p)},	undef,	"to_unicode\(\'𑍀\-𐹢𝟜\.\󠔸𝩜⒏\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2060\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑍀-𐹢4.󠔸𝩜8.", %p)},	undef,	"to_unicode\(\'𑍀\-𐹢4\.\󠔸𝩜8\.\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2061\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⫐｡Ⴠ-򏐆", %p)},	undef,	"to_unicode\(\'\⫐｡Ⴠ\-򏐆\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2062\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⫐。Ⴠ-򏐆", %p)},	undef,	"to_unicode\(\'\⫐\。Ⴠ\-򏐆\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2063\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⫐。ⴠ-򏐆", %p)},	undef,	"to_unicode\(\'\⫐\。ⴠ\-򏐆\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2064\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⫐｡ⴠ-򏐆", %p)},	undef,	"to_unicode\(\'\⫐｡ⴠ\-򏐆\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2065\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{17D2}⟃．⦟⋫", %p)},	undef,	"to_unicode\(\'\\u17D2\⟃．\⦟\⋫\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2066\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{17D2}⟃．⦟⊳\x{0338}", %p)},	undef,	"to_unicode\(\'\\u17D2\⟃．\⦟\⊳\\u0338\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2067\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{17D2}⟃.⦟⋫", %p)},	undef,	"to_unicode\(\'\\u17D2\⟃\.\⦟\⋫\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2068\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{17D2}⟃.⦟⊳\x{0338}", %p)},	undef,	"to_unicode\(\'\\u17D2\⟃\.\⦟\⊳\\u0338\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2069\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("򣎳-𐹦。󓽪ᠹ", %p)},	undef,	"to_unicode\(\'򣎳\-𐹦\。󓽪ᠹ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2070\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{072A}。󠑏𞣒𐿦𐹦", %p)},	undef,	"to_unicode\(\'\\u072A\。\󠑏𞣒𐿦𐹦\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2071\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0790}ꌄ｡\x{200D}ᣬ", %p)},	undef,	"to_unicode\(\'\\u0790ꌄ｡\\u200Dᣬ\'\)\ throws\ error\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2072\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0790}ꌄ｡\x{200D}ᣬ", %p)},	undef,	"to_unicode\(\'\\u0790ꌄ｡\\u200Dᣬ\'\)\ throws\ error\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2073\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0790}ꌄ。\x{200D}ᣬ", %p)},	undef,	"to_unicode\(\'\\u0790ꌄ\。\\u200Dᣬ\'\)\ throws\ error\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2074\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0790}ꌄ。\x{200D}ᣬ", %p)},	undef,	"to_unicode\(\'\\u0790ꌄ\。\\u200Dᣬ\'\)\ throws\ error\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2075\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("₀𐹧。򾂚≯-", %p)},	undef,	"to_unicode\(\'₀𐹧\。򾂚\≯\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2076\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("₀𐹧。򾂚>\x{0338}-", %p)},	undef,	"to_unicode\(\'₀𐹧\。򾂚\>\\u0338\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2077\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0𐹧。򾂚≯-", %p)},	undef,	"to_unicode\(\'0𐹧\。򾂚\≯\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2078\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0𐹧。򾂚>\x{0338}-", %p)},	undef,	"to_unicode\(\'0𐹧\。򾂚\>\\u0338\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2079\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠣖𐹨-\x{08DF}.𐋤\x{0766}", %p)},	undef,	"to_unicode\(\'\󠣖𐹨\-\\u08DF\.𐋤\\u0766\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2080\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠｡\x{0337}\x{0665}Ⴡ\x{0711}", %p)},	undef,	"to_unicode\(\'\≠｡\\u0337\\u0665Ⴡ\\u0711\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2081\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}｡\x{0337}\x{0665}Ⴡ\x{0711}", %p)},	undef,	"to_unicode\(\'\=\\u0338｡\\u0337\\u0665Ⴡ\\u0711\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2082\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠。\x{0337}\x{0665}Ⴡ\x{0711}", %p)},	undef,	"to_unicode\(\'\≠\。\\u0337\\u0665Ⴡ\\u0711\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2083\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}。\x{0337}\x{0665}Ⴡ\x{0711}", %p)},	undef,	"to_unicode\(\'\=\\u0338\。\\u0337\\u0665Ⴡ\\u0711\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2084\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}。\x{0337}\x{0665}ⴡ\x{0711}", %p)},	undef,	"to_unicode\(\'\=\\u0338\。\\u0337\\u0665ⴡ\\u0711\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2085\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠。\x{0337}\x{0665}ⴡ\x{0711}", %p)},	undef,	"to_unicode\(\'\≠\。\\u0337\\u0665ⴡ\\u0711\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2086\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}｡\x{0337}\x{0665}ⴡ\x{0711}", %p)},	undef,	"to_unicode\(\'\=\\u0338｡\\u0337\\u0665ⴡ\\u0711\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2087\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠｡\x{0337}\x{0665}ⴡ\x{0711}", %p)},	undef,	"to_unicode\(\'\≠｡\\u0337\\u0665ⴡ\\u0711\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2088\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0335}≠.Ⴀ𐫓", %p)},	undef,	"to_unicode\(\'\\u0335\≠\.Ⴀ𐫓\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2089\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0335}=\x{0338}.Ⴀ𐫓", %p)},	undef,	"to_unicode\(\'\\u0335\=\\u0338\.Ⴀ𐫓\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2090\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0335}=\x{0338}.ⴀ𐫓", %p)},	undef,	"to_unicode\(\'\\u0335\=\\u0338\.ⴀ𐫓\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2091\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0335}≠.ⴀ𐫓", %p)},	undef,	"to_unicode\(\'\\u0335\≠\.ⴀ𐫓\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2092\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("󠇌\x{08F6}\x{069F}．\x{06EE}閪𐹺\x{1CD2}", %p)},	undef,	"to_unicode\(\'\󠇌\\u08F6\\u069F．\\u06EE閪𐹺\\u1CD2\'\)\ throws\ error\ V5\ B1\ B2\ \[data\/IdnaTest\.txt\:2093\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("󠇌\x{08F6}\x{069F}.\x{06EE}閪𐹺\x{1CD2}", %p)},	undef,	"to_unicode\(\'\󠇌\\u08F6\\u069F\.\\u06EE閪𐹺\\u1CD2\'\)\ throws\ error\ V5\ B1\ B2\ \[data\/IdnaTest\.txt\:2094\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}󠄪𞢊\x{1C2F}｡󠇂\x{0953}-ᛟ", %p)},	undef,	"to_unicode\(\'\\u200D\󠄪𞢊\\u1C2F｡\󠇂\\u0953\-ᛟ\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:2095\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}󠄪𞢊\x{1C2F}｡󠇂\x{0953}-ᛟ", %p)},	undef,	"to_unicode\(\'\\u200D\󠄪𞢊\\u1C2F｡\󠇂\\u0953\-ᛟ\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:2096\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}󠄪𞢊\x{1C2F}。󠇂\x{0953}-ᛟ", %p)},	undef,	"to_unicode\(\'\\u200D\󠄪𞢊\\u1C2F\。\󠇂\\u0953\-ᛟ\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:2097\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}󠄪𞢊\x{1C2F}。󠇂\x{0953}-ᛟ", %p)},	undef,	"to_unicode\(\'\\u200D\󠄪𞢊\\u1C2F\。\󠇂\\u0953\-ᛟ\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:2098\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("헁񿙡\x{1A60}򁰰。\x{071C}𝟜", %p)},	undef,	"to_unicode\(\'헁񿙡\\u1A60򁰰\。\\u071C𝟜\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2099\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("헁񿙡\x{1A60}򁰰。\x{071C}𝟜", %p)},	undef,	"to_unicode\(\'헁񿙡\\u1A60򁰰\。\\u071C𝟜\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2100\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("헁񿙡\x{1A60}򁰰。\x{071C}4", %p)},	undef,	"to_unicode\(\'헁񿙡\\u1A60򁰰\。\\u071C4\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2101\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("헁񿙡\x{1A60}򁰰。\x{071C}4", %p)},	undef,	"to_unicode\(\'헁񿙡\\u1A60򁰰\。\\u071C4\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2102\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹻｡񫡍\x{200C}Ⴞ", %p)},	undef,	"to_unicode\(\'𐹻｡񫡍\\u200CႾ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2103\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹻｡񫡍\x{200C}Ⴞ", %p)},	undef,	"to_unicode\(\'𐹻｡񫡍\\u200CႾ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2104\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹻。񫡍\x{200C}Ⴞ", %p)},	undef,	"to_unicode\(\'𐹻\。񫡍\\u200CႾ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2105\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹻。񫡍\x{200C}Ⴞ", %p)},	undef,	"to_unicode\(\'𐹻\。񫡍\\u200CႾ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2106\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹻。񫡍\x{200C}ⴞ", %p)},	undef,	"to_unicode\(\'𐹻\。񫡍\\u200Cⴞ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2107\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹻。񫡍\x{200C}ⴞ", %p)},	undef,	"to_unicode\(\'𐹻\。񫡍\\u200Cⴞ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2108\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹻｡񫡍\x{200C}ⴞ", %p)},	undef,	"to_unicode\(\'𐹻｡񫡍\\u200Cⴞ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2109\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹻｡񫡍\x{200C}ⴞ", %p)},	undef,	"to_unicode\(\'𐹻｡񫡍\\u200Cⴞ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2110\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B4D}.\x{06DA}\x{0F84}馋", %p)},	undef,	"to_unicode\(\'\\u0B4D\.\\u06DA\\u0F84馋\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2111\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B4D}.\x{0F84}\x{06DA}馋", %p)},	undef,	"to_unicode\(\'\\u0B4D\.\\u0F84\\u06DA馋\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2112\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򿒓򔸨\x{200D}｡󱾁", %p)},	undef,	"to_unicode\(\'򿒓򔸨\\u200D｡󱾁\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2113\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򿒓򔸨\x{200D}｡󱾁", %p)},	undef,	"to_unicode\(\'򿒓򔸨\\u200D｡󱾁\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2114\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򿒓򔸨\x{200D}。󱾁", %p)},	undef,	"to_unicode\(\'򿒓򔸨\\u200D\。󱾁\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2115\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򿒓򔸨\x{200D}。󱾁", %p)},	undef,	"to_unicode\(\'򿒓򔸨\\u200D\。󱾁\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2116\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0626}󠞂姶🄉．۷\x{200D}󠚦\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0626\󠞂姶🄉．۷\\u200D\󠚦\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:2117\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0626}󠞂姶🄉．۷\x{200D}󠚦\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0626\󠞂姶🄉．۷\\u200D\󠚦\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:2118\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{064A}\x{0654}󠞂姶🄉．۷\x{200D}󠚦\x{200D}", %p)},	undef,	"to_unicode\(\'\\u064A\\u0654\󠞂姶🄉．۷\\u200D\󠚦\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:2119\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{064A}\x{0654}󠞂姶🄉．۷\x{200D}󠚦\x{200D}", %p)},	undef,	"to_unicode\(\'\\u064A\\u0654\󠞂姶🄉．۷\\u200D\󠚦\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ C2\ \[data\/IdnaTest\.txt\:2120\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0626}󠞂姶8,.۷\x{200D}󠚦\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0626\󠞂姶8\,\.۷\\u200D\󠚦\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2121\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0626}󠞂姶8,.۷\x{200D}󠚦\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0626\󠞂姶8\,\.۷\\u200D\󠚦\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2122\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{064A}\x{0654}󠞂姶8,.۷\x{200D}󠚦\x{200D}", %p)},	undef,	"to_unicode\(\'\\u064A\\u0654\󠞂姶8\,\.۷\\u200D\󠚦\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2123\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{064A}\x{0654}󠞂姶8,.۷\x{200D}󠚦\x{200D}", %p)},	undef,	"to_unicode\(\'\\u064A\\u0654\󠞂姶8\,\.۷\\u200D\󠚦\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2124\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{FCCB}.𐹴⿆\x{A8C4}", %p)},	undef,	"to_unicode\(\'\\uFCCB\.𐹴⿆\\uA8C4\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2125\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0644}\x{062E}.𐹴麥\x{A8C4}", %p)},	undef,	"to_unicode\(\'\\u0644\\u062E\.𐹴麥\\uA8C4\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2126\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴔ\x{0724}｡𐹼\x{0C48}۹", %p)},	undef,	"to_unicode\(\'Ⴔ\\u0724｡𐹼\\u0C48۹\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2127\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴔ\x{0724}｡𐹼\x{0C46}\x{0C56}۹", %p)},	undef,	"to_unicode\(\'Ⴔ\\u0724｡𐹼\\u0C46\\u0C56۹\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2128\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴔ\x{0724}。𐹼\x{0C48}۹", %p)},	undef,	"to_unicode\(\'Ⴔ\\u0724\。𐹼\\u0C48۹\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2129\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴔ\x{0724}。𐹼\x{0C46}\x{0C56}۹", %p)},	undef,	"to_unicode\(\'Ⴔ\\u0724\。𐹼\\u0C46\\u0C56۹\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2130\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ⴔ\x{0724}。𐹼\x{0C46}\x{0C56}۹", %p)},	undef,	"to_unicode\(\'ⴔ\\u0724\。𐹼\\u0C46\\u0C56۹\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2131\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ⴔ\x{0724}。𐹼\x{0C48}۹", %p)},	undef,	"to_unicode\(\'ⴔ\\u0724\。𐹼\\u0C48۹\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2132\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ⴔ\x{0724}｡𐹼\x{0C46}\x{0C56}۹", %p)},	undef,	"to_unicode\(\'ⴔ\\u0724｡𐹼\\u0C46\\u0C56۹\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2133\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ⴔ\x{0724}｡𐹼\x{0C48}۹", %p)},	undef,	"to_unicode\(\'ⴔ\\u0724｡𐹼\\u0C48۹\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2134\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("󠏬𐫂\x{200C}．︒-󠇕-", %p)},	undef,	"to_unicode\(\'\󠏬𐫂\\u200C．︒\-\󠇕\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:2135\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠏬𐫂\x{200C}．︒-󠇕-", %p)},	undef,	"to_unicode\(\'\󠏬𐫂\\u200C．︒\-\󠇕\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:2136\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠏬𐫂\x{200C}.。-󠇕-", %p)},	undef,	"to_unicode\(\'\󠏬𐫂\\u200C\.\。\-\󠇕\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ A4_2\ \[data\/IdnaTest\.txt\:2137\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠏬𐫂\x{200C}.。-󠇕-", %p)},	undef,	"to_unicode\(\'\󠏬𐫂\\u200C\.\。\-\󠇕\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ A4_2\ \[data\/IdnaTest\.txt\:2138\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{0661}⒖\x{200C}.𝪩\x{FBD9}", %p)},	undef,	"to_unicode\(\'⒈\\u0661⒖\\u200C\.𝪩\\uFBD9\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:2139\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{0661}⒖\x{200C}.𝪩\x{FBD9}", %p)},	undef,	"to_unicode\(\'⒈\\u0661⒖\\u200C\.𝪩\\uFBD9\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:2140\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("1.\x{0661}15.\x{200C}.𝪩\x{06C6}", %p)},	undef,	"to_unicode\(\'1\.\\u066115\.\\u200C\.𝪩\\u06C6\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:2141\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("1.\x{0661}15.\x{200C}.𝪩\x{06C6}", %p)},	undef,	"to_unicode\(\'1\.\\u066115\.\\u200C\.𝪩\\u06C6\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:2142\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{20ED}。-\x{1734}Ⴋ", %p)},	undef,	"to_unicode\(\'\\u20ED\。\-\\u1734Ⴋ\'\)\ throws\ error\ P1\ V5\ V3\ V6\ \[data\/IdnaTest\.txt\:2143\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{20ED}。-\x{1734}ⴋ", %p)},	undef,	"to_unicode\(\'\\u20ED\。\-\\u1734ⴋ\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:2144\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ßჀ.\x{07CD}刯Ⴝ", %p)},	undef,	"to_unicode\(\'ßჀ\.\\u07CD刯Ⴝ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2145\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ßⴠ.\x{07CD}刯ⴝ", %p)},	undef,	"to_unicode\(\'ßⴠ\.\\u07CD刯ⴝ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2146\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("SSჀ.\x{07CD}刯Ⴝ", %p)},	undef,	"to_unicode\(\'SSჀ\.\\u07CD刯Ⴝ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2147\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ssⴠ.\x{07CD}刯ⴝ", %p)},	undef,	"to_unicode\(\'ssⴠ\.\\u07CD刯ⴝ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2148\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ssⴠ.\x{07CD}刯Ⴝ", %p)},	undef,	"to_unicode\(\'Ssⴠ\.\\u07CD刯Ⴝ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2149\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B4D}ႣℲ｡\x{06B6}툻𞧥", %p)},	undef,	"to_unicode\(\'\\u0B4DႣℲ｡\\u06B6툻𞧥\'\)\ throws\ error\ P1\ V5\ V6\ B2\ \[data\/IdnaTest\.txt\:2150\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B4D}ႣℲ｡\x{06B6}툻𞧥", %p)},	undef,	"to_unicode\(\'\\u0B4DႣℲ｡\\u06B6툻𞧥\'\)\ throws\ error\ P1\ V5\ V6\ B2\ \[data\/IdnaTest\.txt\:2151\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B4D}ႣℲ。\x{06B6}툻𞧥", %p)},	undef,	"to_unicode\(\'\\u0B4DႣℲ\。\\u06B6툻𞧥\'\)\ throws\ error\ P1\ V5\ V6\ B2\ \[data\/IdnaTest\.txt\:2152\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B4D}ႣℲ。\x{06B6}툻𞧥", %p)},	undef,	"to_unicode\(\'\\u0B4DႣℲ\。\\u06B6툻𞧥\'\)\ throws\ error\ P1\ V5\ V6\ B2\ \[data\/IdnaTest\.txt\:2153\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B4D}ⴃⅎ。\x{06B6}툻𞧥", %p)},	undef,	"to_unicode\(\'\\u0B4Dⴃⅎ\。\\u06B6툻𞧥\'\)\ throws\ error\ P1\ V5\ V6\ B2\ \[data\/IdnaTest\.txt\:2154\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B4D}ⴃⅎ。\x{06B6}툻𞧥", %p)},	undef,	"to_unicode\(\'\\u0B4Dⴃⅎ\。\\u06B6툻𞧥\'\)\ throws\ error\ P1\ V5\ V6\ B2\ \[data\/IdnaTest\.txt\:2155\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B4D}Ⴃⅎ。\x{06B6}툻𞧥", %p)},	undef,	"to_unicode\(\'\\u0B4DႣⅎ\。\\u06B6툻𞧥\'\)\ throws\ error\ P1\ V5\ V6\ B2\ \[data\/IdnaTest\.txt\:2156\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B4D}Ⴃⅎ。\x{06B6}툻𞧥", %p)},	undef,	"to_unicode\(\'\\u0B4DႣⅎ\。\\u06B6툻𞧥\'\)\ throws\ error\ P1\ V5\ V6\ B2\ \[data\/IdnaTest\.txt\:2157\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B4D}ⴃⅎ｡\x{06B6}툻𞧥", %p)},	undef,	"to_unicode\(\'\\u0B4Dⴃⅎ｡\\u06B6툻𞧥\'\)\ throws\ error\ P1\ V5\ V6\ B2\ \[data\/IdnaTest\.txt\:2158\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B4D}ⴃⅎ｡\x{06B6}툻𞧥", %p)},	undef,	"to_unicode\(\'\\u0B4Dⴃⅎ｡\\u06B6툻𞧥\'\)\ throws\ error\ P1\ V5\ V6\ B2\ \[data\/IdnaTest\.txt\:2159\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B4D}Ⴃⅎ｡\x{06B6}툻𞧥", %p)},	undef,	"to_unicode\(\'\\u0B4DႣⅎ｡\\u06B6툻𞧥\'\)\ throws\ error\ P1\ V5\ V6\ B2\ \[data\/IdnaTest\.txt\:2160\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B4D}Ⴃⅎ｡\x{06B6}툻𞧥", %p)},	undef,	"to_unicode\(\'\\u0B4DႣⅎ｡\\u06B6툻𞧥\'\)\ throws\ error\ P1\ V5\ V6\ B2\ \[data\/IdnaTest\.txt\:2161\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("🝞.\x{07E7}𐹫ᢏ", %p)},	undef,	"to_unicode\(\'🝞\.\\u07E7𐹫ᢏ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2162\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("\x{0845}𝪩。₇𑚶", %p)},	"\x{0845}𝪩.7𑚶",	"to_unicode\(\'\\u0845𝪩\。₇𑚶\'\)\ \[data\/IdnaTest\.txt\:2163\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("\x{0845}𝪩。7𑚶", %p)},	"\x{0845}𝪩.7𑚶",	"to_unicode\(\'\\u0845𝪩\。7𑚶\'\)\ \[data\/IdnaTest\.txt\:2164\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("xn--3vb6099u.xn--7-4j0j", %p)},	"\x{0845}𝪩.7𑚶",	"to_unicode\(\'xn\-\-3vb6099u\.xn\-\-7\-4j0j\'\)\ \[data\/IdnaTest\.txt\:2165\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("\x{0845}𝪩.7𑚶", %p)},	"\x{0845}𝪩.7𑚶",	"to_unicode\(\'\\u0845𝪩\.7𑚶\'\)\ \[data\/IdnaTest\.txt\:2166\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴣ\x{0663}.\x{200C}\x{A672}≮\x{FDE2}", %p)},	undef,	"to_unicode\(\'Ⴣ\\u0663\.\\u200C\\uA672\≮\\uFDE2\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2167\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴣ\x{0663}.\x{200C}\x{A672}≮\x{FDE2}", %p)},	undef,	"to_unicode\(\'Ⴣ\\u0663\.\\u200C\\uA672\≮\\uFDE2\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2168\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴣ\x{0663}.\x{200C}\x{A672}<\x{0338}\x{FDE2}", %p)},	undef,	"to_unicode\(\'Ⴣ\\u0663\.\\u200C\\uA672\<\\u0338\\uFDE2\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2169\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴣ\x{0663}.\x{200C}\x{A672}<\x{0338}\x{FDE2}", %p)},	undef,	"to_unicode\(\'Ⴣ\\u0663\.\\u200C\\uA672\<\\u0338\\uFDE2\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2170\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴣ\x{0663}.\x{200C}\x{A672}<\x{0338}\x{FDE2}", %p)},	undef,	"to_unicode\(\'ⴣ\\u0663\.\\u200C\\uA672\<\\u0338\\uFDE2\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2171\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴣ\x{0663}.\x{200C}\x{A672}<\x{0338}\x{FDE2}", %p)},	undef,	"to_unicode\(\'ⴣ\\u0663\.\\u200C\\uA672\<\\u0338\\uFDE2\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2172\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴣ\x{0663}.\x{200C}\x{A672}≮\x{FDE2}", %p)},	undef,	"to_unicode\(\'ⴣ\\u0663\.\\u200C\\uA672\≮\\uFDE2\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2173\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴣ\x{0663}.\x{200C}\x{A672}≮\x{FDE2}", %p)},	undef,	"to_unicode\(\'ⴣ\\u0663\.\\u200C\\uA672\≮\\uFDE2\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2174\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𝟵隁⽷．𖬰\x{200C}", %p)},	undef,	"to_unicode\(\'𝟵隁⽷．𖬰\\u200C\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2175\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𝟵隁⽷．𖬰\x{200C}", %p)},	undef,	"to_unicode\(\'𝟵隁⽷．𖬰\\u200C\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2176\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("9隁糸.𖬰\x{200C}", %p)},	undef,	"to_unicode\(\'9隁糸\.𖬰\\u200C\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2177\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("9隁糸.𖬰\x{200C}", %p)},	undef,	"to_unicode\(\'9隁糸\.𖬰\\u200C\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2178\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⒏𐹷｡Ⴣ𑘿彦", %p)},	undef,	"to_unicode\(\'⒏𐹷｡Ⴣ𑘿彦\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2179\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("8.𐹷。Ⴣ𑘿彦", %p)},	undef,	"to_unicode\(\'8\.𐹷\。Ⴣ𑘿彦\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2180\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("8.𐹷。ⴣ𑘿彦", %p)},	undef,	"to_unicode\(\'8\.𐹷\。ⴣ𑘿彦\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2181\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⒏𐹷｡ⴣ𑘿彦", %p)},	undef,	"to_unicode\(\'⒏𐹷｡ⴣ𑘿彦\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2182\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-问󕀙⒛。\x{0664}-󘖶橬", %p)},	undef,	"to_unicode\(\'\-问󕀙⒛\。\\u0664\-󘖶橬\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2183\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-问󕀙20.。\x{0664}-󘖶橬", %p)},	undef,	"to_unicode\(\'\-问󕀙20\.\。\\u0664\-󘖶橬\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:2184\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DFE}Ⴌ\x{200C}𐫥。𝟸", %p)},	undef,	"to_unicode\(\'\\u1DFEႬ\\u200C𐫥\。𝟸\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2185\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DFE}Ⴌ\x{200C}𐫥。𝟸", %p)},	undef,	"to_unicode\(\'\\u1DFEႬ\\u200C𐫥\。𝟸\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2186\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DFE}Ⴌ\x{200C}𐫥。2", %p)},	undef,	"to_unicode\(\'\\u1DFEႬ\\u200C𐫥\。2\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2187\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DFE}Ⴌ\x{200C}𐫥。2", %p)},	undef,	"to_unicode\(\'\\u1DFEႬ\\u200C𐫥\。2\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2188\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{1DFE}ⴌ\x{200C}𐫥。2", %p)},	undef,	"to_unicode\(\'\\u1DFEⴌ\\u200C𐫥\。2\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2189\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{1DFE}ⴌ\x{200C}𐫥。2", %p)},	undef,	"to_unicode\(\'\\u1DFEⴌ\\u200C𐫥\。2\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2190\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{1DFE}ⴌ\x{200C}𐫥。𝟸", %p)},	undef,	"to_unicode\(\'\\u1DFEⴌ\\u200C𐫥\。𝟸\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2191\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{1DFE}ⴌ\x{200C}𐫥。𝟸", %p)},	undef,	"to_unicode\(\'\\u1DFEⴌ\\u200C𐫥\。𝟸\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2192\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{DC5F}。\x{1BF2}𐹫󠇷", %p)},	undef,	"to_unicode\(\'\\uDC5F\。\\u1BF2𐹫\󠇷\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2193\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FE28}\x{135D}⾶｡₇︒눇≮", %p)},	undef,	"to_unicode\(\'\\uFE28\\u135D⾶｡₇︒눇\≮\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2194\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FE28}\x{135D}⾶｡₇︒눇<\x{0338}", %p)},	undef,	"to_unicode\(\'\\uFE28\\u135D⾶｡₇︒눇\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2195\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FE28}\x{135D}飛。7。눇≮", %p)},	undef,	"to_unicode\(\'\\uFE28\\u135D飛\。7\。눇\≮\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2196\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FE28}\x{135D}飛。7。눇<\x{0338}", %p)},	undef,	"to_unicode\(\'\\uFE28\\u135D飛\。7\。눇\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2197\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}\x{2DFD}𐹽\x{200D}．\x{200C}⿃", %p)},	undef,	"to_unicode\(\'\\u200C\\u2DFD𐹽\\u200D．\\u200C⿃\'\)\ throws\ error\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:2198\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}\x{2DFD}𐹽\x{200D}．\x{200C}⿃", %p)},	undef,	"to_unicode\(\'\\u200C\\u2DFD𐹽\\u200D．\\u200C⿃\'\)\ throws\ error\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:2199\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}\x{2DFD}𐹽\x{200D}.\x{200C}鳥", %p)},	undef,	"to_unicode\(\'\\u200C\\u2DFD𐹽\\u200D\.\\u200C鳥\'\)\ throws\ error\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:2200\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}\x{2DFD}𐹽\x{200D}.\x{200C}鳥", %p)},	undef,	"to_unicode\(\'\\u200C\\u2DFD𐹽\\u200D\.\\u200C鳥\'\)\ throws\ error\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:2201\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("󠶡．\x{200D}🜮𐥮󠇠", %p)},	undef,	"to_unicode\(\'\󠶡．\\u200D🜮𐥮\󠇠\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2202\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠶡．\x{200D}🜮𐥮󠇠", %p)},	undef,	"to_unicode\(\'\󠶡．\\u200D🜮𐥮\󠇠\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2203\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠶡.\x{200D}🜮𐥮󠇠", %p)},	undef,	"to_unicode\(\'\󠶡\.\\u200D🜮𐥮\󠇠\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2204\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠶡.\x{200D}🜮𐥮󠇠", %p)},	undef,	"to_unicode\(\'\󠶡\.\\u200D🜮𐥮\󠇠\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2205\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("ᡉ𑇊.\x{0726}\x{200D}", %p)},	undef,	"to_unicode\(\'ᡉ𑇊\.\\u0726\\u200D\'\)\ throws\ error\ B3\ C2\ \[data\/IdnaTest\.txt\:2206\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("ᡉ𑇊.\x{0726}\x{200D}", %p)},	undef,	"to_unicode\(\'ᡉ𑇊\.\\u0726\\u200D\'\)\ throws\ error\ B3\ C2\ \[data\/IdnaTest\.txt\:2207\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("xn--87e0688j.xn--wnb", %p)},	"ᡉ𑇊.\x{0726}",	"to_unicode\(\'xn\-\-87e0688j\.xn\-\-wnb\'\)\ \[data\/IdnaTest\.txt\:2208\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("ᡉ𑇊.\x{0726}", %p)},	"ᡉ𑇊.\x{0726}",	"to_unicode\(\'ᡉ𑇊\.\\u0726\'\)\ \[data\/IdnaTest\.txt\:2209\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0662}\x{103A}-．򡕻\x{09CD}𞜎", %p)},	undef,	"to_unicode\(\'\\u0662\\u103A\-．򡕻\\u09CD𞜎\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2210\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0662}\x{103A}-.򡕻\x{09CD}𞜎", %p)},	undef,	"to_unicode\(\'\\u0662\\u103A\-\.򡕻\\u09CD𞜎\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2211\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{1A60}-\x{0664}｡𝉄\x{200C}𐹢≮", %p)},	undef,	"to_unicode\(\'4\\u1A60\-\\u0664｡𝉄\\u200C𐹢\≮\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2212\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{1A60}-\x{0664}｡𝉄\x{200C}𐹢≮", %p)},	undef,	"to_unicode\(\'4\\u1A60\-\\u0664｡𝉄\\u200C𐹢\≮\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2213\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{1A60}-\x{0664}｡𝉄\x{200C}𐹢<\x{0338}", %p)},	undef,	"to_unicode\(\'4\\u1A60\-\\u0664｡𝉄\\u200C𐹢\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2214\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{1A60}-\x{0664}｡𝉄\x{200C}𐹢<\x{0338}", %p)},	undef,	"to_unicode\(\'4\\u1A60\-\\u0664｡𝉄\\u200C𐹢\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2215\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{1A60}-\x{0664}。𝉄\x{200C}𐹢≮", %p)},	undef,	"to_unicode\(\'4\\u1A60\-\\u0664\。𝉄\\u200C𐹢\≮\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2216\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{1A60}-\x{0664}。𝉄\x{200C}𐹢≮", %p)},	undef,	"to_unicode\(\'4\\u1A60\-\\u0664\。𝉄\\u200C𐹢\≮\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2217\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{1A60}-\x{0664}。𝉄\x{200C}𐹢<\x{0338}", %p)},	undef,	"to_unicode\(\'4\\u1A60\-\\u0664\。𝉄\\u200C𐹢\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2218\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{1A60}-\x{0664}。𝉄\x{200C}𐹢<\x{0338}", %p)},	undef,	"to_unicode\(\'4\\u1A60\-\\u0664\。𝉄\\u200C𐹢\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2219\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。\x{FFA0}\x{0F84}\x{0342}", %p)},	undef,	"to_unicode\(\'\\u200C\。\\uFFA0\\u0F84\\u0342\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2220\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。\x{FFA0}\x{0F84}\x{0342}", %p)},	undef,	"to_unicode\(\'\\u200C\。\\uFFA0\\u0F84\\u0342\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2221\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。\x{1160}\x{0F84}\x{0342}", %p)},	undef,	"to_unicode\(\'\\u200C\。\\u1160\\u0F84\\u0342\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2222\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。\x{1160}\x{0F84}\x{0342}", %p)},	undef,	"to_unicode\(\'\\u200C\。\\u1160\\u0F84\\u0342\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2223\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯񙛤．\x{200D}䷕񆡚", %p)},	undef,	"to_unicode\(\'\≯񙛤．\\u200D䷕񆡚\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2224\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯񙛤．\x{200D}䷕񆡚", %p)},	undef,	"to_unicode\(\'\≯񙛤．\\u200D䷕񆡚\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2225\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}񙛤．\x{200D}䷕񆡚", %p)},	undef,	"to_unicode\(\'\>\\u0338񙛤．\\u200D䷕񆡚\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2226\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}񙛤．\x{200D}䷕񆡚", %p)},	undef,	"to_unicode\(\'\>\\u0338񙛤．\\u200D䷕񆡚\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2227\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯񙛤.\x{200D}䷕񆡚", %p)},	undef,	"to_unicode\(\'\≯񙛤\.\\u200D䷕񆡚\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2228\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯񙛤.\x{200D}䷕񆡚", %p)},	undef,	"to_unicode\(\'\≯񙛤\.\\u200D䷕񆡚\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2229\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}񙛤.\x{200D}䷕񆡚", %p)},	undef,	"to_unicode\(\'\>\\u0338񙛤\.\\u200D䷕񆡚\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2230\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}񙛤.\x{200D}䷕񆡚", %p)},	undef,	"to_unicode\(\'\>\\u0338񙛤\.\\u200D䷕񆡚\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2231\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ᡦß\x{FDC5}｡𝟕\x{07E3}", %p)},	undef,	"to_unicode\(\'ᡦß\\uFDC5｡𝟕\\u07E3\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2232\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ᡦß\x{0635}\x{0645}\x{0645}。7\x{07E3}", %p)},	undef,	"to_unicode\(\'ᡦß\\u0635\\u0645\\u0645\。7\\u07E3\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2233\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ᡦSS\x{0635}\x{0645}\x{0645}。7\x{07E3}", %p)},	undef,	"to_unicode\(\'ᡦSS\\u0635\\u0645\\u0645\。7\\u07E3\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2234\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ᡦss\x{0635}\x{0645}\x{0645}。7\x{07E3}", %p)},	undef,	"to_unicode\(\'ᡦss\\u0635\\u0645\\u0645\。7\\u07E3\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2235\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ᡦSs\x{0635}\x{0645}\x{0645}。7\x{07E3}", %p)},	undef,	"to_unicode\(\'ᡦSs\\u0635\\u0645\\u0645\。7\\u07E3\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2236\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ᡦSS\x{FDC5}｡𝟕\x{07E3}", %p)},	undef,	"to_unicode\(\'ᡦSS\\uFDC5｡𝟕\\u07E3\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2237\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ᡦss\x{FDC5}｡𝟕\x{07E3}", %p)},	undef,	"to_unicode\(\'ᡦss\\uFDC5｡𝟕\\u07E3\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2238\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ᡦSs\x{FDC5}｡𝟕\x{07E3}", %p)},	undef,	"to_unicode\(\'ᡦSs\\uFDC5｡𝟕\\u07E3\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2239\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ß\x{0611}\x{1CD8}𞫑。\x{FCEB}򴍇𐹥", %p)},	undef,	"to_unicode\(\'ß\\u0611\\u1CD8𞫑\。\\uFCEB򴍇𐹥\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ \[data\/IdnaTest\.txt\:2240\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{1CD8}\x{0611}𞫑。\x{FCEB}򴍇𐹥", %p)},	undef,	"to_unicode\(\'ß\\u1CD8\\u0611𞫑\。\\uFCEB򴍇𐹥\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ \[data\/IdnaTest\.txt\:2241\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{1CD8}\x{0611}𞫑。\x{0643}\x{0644}򴍇𐹥", %p)},	undef,	"to_unicode\(\'ß\\u1CD8\\u0611𞫑\。\\u0643\\u0644򴍇𐹥\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ \[data\/IdnaTest\.txt\:2242\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{1CD8}\x{0611}𞫑。\x{0643}\x{0644}򴍇𐹥", %p)},	undef,	"to_unicode\(\'SS\\u1CD8\\u0611𞫑\。\\u0643\\u0644򴍇𐹥\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ \[data\/IdnaTest\.txt\:2243\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{1CD8}\x{0611}𞫑。\x{0643}\x{0644}򴍇𐹥", %p)},	undef,	"to_unicode\(\'ss\\u1CD8\\u0611𞫑\。\\u0643\\u0644򴍇𐹥\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ \[data\/IdnaTest\.txt\:2244\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{1CD8}\x{0611}𞫑。\x{0643}\x{0644}򴍇𐹥", %p)},	undef,	"to_unicode\(\'Ss\\u1CD8\\u0611𞫑\。\\u0643\\u0644򴍇𐹥\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ \[data\/IdnaTest\.txt\:2245\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{1CD8}\x{0611}𞫑。\x{FCEB}򴍇𐹥", %p)},	undef,	"to_unicode\(\'SS\\u1CD8\\u0611𞫑\。\\uFCEB򴍇𐹥\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ \[data\/IdnaTest\.txt\:2246\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{1CD8}\x{0611}𞫑。\x{FCEB}򴍇𐹥", %p)},	undef,	"to_unicode\(\'ss\\u1CD8\\u0611𞫑\。\\uFCEB򴍇𐹥\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ \[data\/IdnaTest\.txt\:2247\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{1CD8}\x{0611}𞫑。\x{FCEB}򴍇𐹥", %p)},	undef,	"to_unicode\(\'Ss\\u1CD8\\u0611𞫑\。\\uFCEB򴍇𐹥\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ \[data\/IdnaTest\.txt\:2248\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{0611}\x{1CD8}𞫑。\x{FCEB}򴍇𐹥", %p)},	undef,	"to_unicode\(\'SS\\u0611\\u1CD8𞫑\。\\uFCEB򴍇𐹥\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ \[data\/IdnaTest\.txt\:2249\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{0611}\x{1CD8}𞫑。\x{FCEB}򴍇𐹥", %p)},	undef,	"to_unicode\(\'ss\\u0611\\u1CD8𞫑\。\\uFCEB򴍇𐹥\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ \[data\/IdnaTest\.txt\:2250\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{0611}\x{1CD8}𞫑。\x{FCEB}򴍇𐹥", %p)},	undef,	"to_unicode\(\'Ss\\u0611\\u1CD8𞫑\。\\uFCEB򴍇𐹥\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ \[data\/IdnaTest\.txt\:2251\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-｡🗦⒌\x{076B}", %p)},	undef,	"to_unicode\(\'\-｡🗦⒌\\u076B\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2252\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("-。🗦5.\x{076B}", %p)},	undef,	"to_unicode\(\'\-\。🗦5\.\\u076B\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2253\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𓯃ς．-≮𐢞", %p)},	undef,	"to_unicode\(\'𓯃ς．\-\≮𐢞\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2254\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𓯃ς．-<\x{0338}𐢞", %p)},	undef,	"to_unicode\(\'𓯃ς．\-\<\\u0338𐢞\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2255\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𓯃ς.-≮𐢞", %p)},	undef,	"to_unicode\(\'𓯃ς\.\-\≮𐢞\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2256\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𓯃ς.-<\x{0338}𐢞", %p)},	undef,	"to_unicode\(\'𓯃ς\.\-\<\\u0338𐢞\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2257\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𓯃Σ.-<\x{0338}𐢞", %p)},	undef,	"to_unicode\(\'𓯃Σ\.\-\<\\u0338𐢞\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2258\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𓯃Σ.-≮𐢞", %p)},	undef,	"to_unicode\(\'𓯃Σ\.\-\≮𐢞\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2259\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𓯃σ.-≮𐢞", %p)},	undef,	"to_unicode\(\'𓯃σ\.\-\≮𐢞\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2260\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𓯃σ.-<\x{0338}𐢞", %p)},	undef,	"to_unicode\(\'𓯃σ\.\-\<\\u0338𐢞\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2261\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𓯃Σ．-<\x{0338}𐢞", %p)},	undef,	"to_unicode\(\'𓯃Σ．\-\<\\u0338𐢞\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2262\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𓯃Σ．-≮𐢞", %p)},	undef,	"to_unicode\(\'𓯃Σ．\-\≮𐢞\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2263\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𓯃σ．-≮𐢞", %p)},	undef,	"to_unicode\(\'𓯃σ．\-\≮𐢞\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2264\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𓯃σ．-<\x{0338}𐢞", %p)},	undef,	"to_unicode\(\'𓯃σ．\-\<\\u0338𐢞\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2265\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠣ\x{0697}ꡜ．񪁡⎩\x{17D2}𞶊", %p)},	undef,	"to_unicode\(\'ᠣ\\u0697ꡜ．񪁡\⎩\\u17D2𞶊\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2266\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠣ\x{0697}ꡜ.񪁡⎩\x{17D2}𞶊", %p)},	undef,	"to_unicode\(\'ᠣ\\u0697ꡜ\.񪁡\⎩\\u17D2𞶊\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2267\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐪟\x{06AA}\x{0757}\x{0761}。𐋦𝅼󠄧", %p)},	"𐪟\x{06AA}\x{0757}\x{0761}.𐋦𝅼",	"to_unicode\(\'𐪟\\u06AA\\u0757\\u0761\。𐋦𝅼\󠄧\'\)\ \[data\/IdnaTest\.txt\:2268\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--dkb06a4a7332t.xn--987cj167a", %p)},	"𐪟\x{06AA}\x{0757}\x{0761}.𐋦𝅼",	"to_unicode\(\'xn\-\-dkb06a4a7332t\.xn\-\-987cj167a\'\)\ \[data\/IdnaTest\.txt\:2269\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐪟\x{06AA}\x{0757}\x{0761}.𐋦𝅼", %p)},	"𐪟\x{06AA}\x{0757}\x{0761}.𐋦𝅼",	"to_unicode\(\'𐪟\\u06AA\\u0757\\u0761\.𐋦𝅼\'\)\ \[data\/IdnaTest\.txt\:2270\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("₂󘈲--。ᢢ\x{200C}𞾰\x{1BAA}", %p)},	undef,	"to_unicode\(\'₂󘈲\-\-\。ᢢ\\u200C𞾰\\u1BAA\'\)\ throws\ error\ P1\ V2\ V3\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:2271\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("₂󘈲--。ᢢ\x{200C}𞾰\x{1BAA}", %p)},	undef,	"to_unicode\(\'₂󘈲\-\-\。ᢢ\\u200C𞾰\\u1BAA\'\)\ throws\ error\ P1\ V2\ V3\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:2272\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2󘈲--。ᢢ\x{200C}𞾰\x{1BAA}", %p)},	undef,	"to_unicode\(\'2󘈲\-\-\。ᢢ\\u200C𞾰\\u1BAA\'\)\ throws\ error\ P1\ V2\ V3\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:2273\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2󘈲--。ᢢ\x{200C}𞾰\x{1BAA}", %p)},	undef,	"to_unicode\(\'2󘈲\-\-\。ᢢ\\u200C𞾰\\u1BAA\'\)\ throws\ error\ P1\ V2\ V3\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:2274\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-􆒿．ᢖ\x{0853}-", %p)},	undef,	"to_unicode\(\'\-􆒿．ᢖ\\u0853\-\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2275\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-􆒿.ᢖ\x{0853}-", %p)},	undef,	"to_unicode\(\'\-􆒿\.ᢖ\\u0853\-\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2276\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-ß｡ᡪ𐹥\x{07DE}", %p)},	undef,	"to_unicode\(\'\\u200C\-ß｡ᡪ𐹥\\u07DE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2277\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-ß｡ᡪ𐹥\x{07DE}", %p)},	undef,	"to_unicode\(\'\\u200C\-ß｡ᡪ𐹥\\u07DE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2278\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-ß。ᡪ𐹥\x{07DE}", %p)},	undef,	"to_unicode\(\'\\u200C\-ß\。ᡪ𐹥\\u07DE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2279\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-ß。ᡪ𐹥\x{07DE}", %p)},	undef,	"to_unicode\(\'\\u200C\-ß\。ᡪ𐹥\\u07DE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2280\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-SS。ᡪ𐹥\x{07DE}", %p)},	undef,	"to_unicode\(\'\\u200C\-SS\。ᡪ𐹥\\u07DE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2281\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-SS。ᡪ𐹥\x{07DE}", %p)},	undef,	"to_unicode\(\'\\u200C\-SS\。ᡪ𐹥\\u07DE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2282\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-ss。ᡪ𐹥\x{07DE}", %p)},	undef,	"to_unicode\(\'\\u200C\-ss\。ᡪ𐹥\\u07DE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2283\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-ss。ᡪ𐹥\x{07DE}", %p)},	undef,	"to_unicode\(\'\\u200C\-ss\。ᡪ𐹥\\u07DE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2284\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-Ss。ᡪ𐹥\x{07DE}", %p)},	undef,	"to_unicode\(\'\\u200C\-Ss\。ᡪ𐹥\\u07DE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2285\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-Ss。ᡪ𐹥\x{07DE}", %p)},	undef,	"to_unicode\(\'\\u200C\-Ss\。ᡪ𐹥\\u07DE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2286\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-SS｡ᡪ𐹥\x{07DE}", %p)},	undef,	"to_unicode\(\'\\u200C\-SS｡ᡪ𐹥\\u07DE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2287\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-SS｡ᡪ𐹥\x{07DE}", %p)},	undef,	"to_unicode\(\'\\u200C\-SS｡ᡪ𐹥\\u07DE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2288\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-ss｡ᡪ𐹥\x{07DE}", %p)},	undef,	"to_unicode\(\'\\u200C\-ss｡ᡪ𐹥\\u07DE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2289\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-ss｡ᡪ𐹥\x{07DE}", %p)},	undef,	"to_unicode\(\'\\u200C\-ss｡ᡪ𐹥\\u07DE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2290\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-Ss｡ᡪ𐹥\x{07DE}", %p)},	undef,	"to_unicode\(\'\\u200C\-Ss｡ᡪ𐹥\\u07DE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2291\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}-Ss｡ᡪ𐹥\x{07DE}", %p)},	undef,	"to_unicode\(\'\\u200C\-Ss｡ᡪ𐹥\\u07DE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2292\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("꧐Ӏ\x{1039}\x{1DEF}．눵", %p)},	undef,	"to_unicode\(\'꧐Ӏ\\u1039\\u1DEF．눵\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2293\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("꧐Ӏ\x{1039}\x{1DEF}．눵", %p)},	undef,	"to_unicode\(\'꧐Ӏ\\u1039\\u1DEF．눵\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2294\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("꧐Ӏ\x{1039}\x{1DEF}.눵", %p)},	undef,	"to_unicode\(\'꧐Ӏ\\u1039\\u1DEF\.눵\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2295\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("꧐Ӏ\x{1039}\x{1DEF}.눵", %p)},	undef,	"to_unicode\(\'꧐Ӏ\\u1039\\u1DEF\.눵\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2296\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("꧐ӏ\x{1039}\x{1DEF}.눵", %p)},	"꧐ӏ\x{1039}\x{1DEF}.눵",	"to_unicode\(\'꧐ӏ\\u1039\\u1DEF\.눵\'\)\ \[data\/IdnaTest\.txt\:2297\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("꧐ӏ\x{1039}\x{1DEF}.눵", %p)},	"꧐ӏ\x{1039}\x{1DEF}.눵",	"to_unicode\(\'꧐ӏ\\u1039\\u1DEF\.눵\'\)\ \[data\/IdnaTest\.txt\:2298\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--s5a859c44knm0l.xn--2e1b", %p)},	"꧐ӏ\x{1039}\x{1DEF}.눵",	"to_unicode\(\'xn\-\-s5a859c44knm0l\.xn\-\-2e1b\'\)\ \[data\/IdnaTest\.txt\:2299\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("꧐ӏ\x{1039}\x{1DEF}．눵", %p)},	"꧐ӏ\x{1039}\x{1DEF}.눵",	"to_unicode\(\'꧐ӏ\\u1039\\u1DEF．눵\'\)\ \[data\/IdnaTest\.txt\:2300\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("꧐ӏ\x{1039}\x{1DEF}．눵", %p)},	"꧐ӏ\x{1039}\x{1DEF}.눵",	"to_unicode\(\'꧐ӏ\\u1039\\u1DEF．눵\'\)\ \[data\/IdnaTest\.txt\:2301\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0FBC}｡鞯𐫦\x{17CB}", %p)},	undef,	"to_unicode\(\'\\u0FBC｡鞯𐫦\\u17CB\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2302\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0FBC}。鞯𐫦\x{17CB}", %p)},	undef,	"to_unicode\(\'\\u0FBC\。鞯𐫦\\u17CB\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2303\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𹺛🕢。񶐎≯⾇", %p)},	undef,	"to_unicode\(\'𹺛🕢\。񶐎\≯⾇\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2304\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𹺛🕢。񶐎>\x{0338}⾇", %p)},	undef,	"to_unicode\(\'𹺛🕢\。񶐎\>\\u0338⾇\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2305\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𹺛🕢。񶐎≯舛", %p)},	undef,	"to_unicode\(\'𹺛🕢\。񶐎\≯舛\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2306\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𹺛🕢。񶐎>\x{0338}舛", %p)},	undef,	"to_unicode\(\'𹺛🕢\。񶐎\>\\u0338舛\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2307\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{062F}\x{066B}\x{200C}．\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u062F\\u066B\\u200C．\\u200D\\u200C\'\)\ throws\ error\ B3\ C1\ C2\ \[data\/IdnaTest\.txt\:2308\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{062F}\x{066B}\x{200C}．\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u062F\\u066B\\u200C．\\u200D\\u200C\'\)\ throws\ error\ B3\ C1\ C2\ \[data\/IdnaTest\.txt\:2309\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{062F}\x{066B}\x{200C}.\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u062F\\u066B\\u200C\.\\u200D\\u200C\'\)\ throws\ error\ B3\ C1\ C2\ \[data\/IdnaTest\.txt\:2310\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{062F}\x{066B}\x{200C}.\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u062F\\u066B\\u200C\.\\u200D\\u200C\'\)\ throws\ error\ B3\ C1\ C2\ \[data\/IdnaTest\.txt\:2311\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ugb4j.", %p)},	"\x{062F}\x{066B}.",	"to_unicode\(\'xn\-\-ugb4j\.\'\)\ \[data\/IdnaTest\.txt\:2312\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{062F}\x{066B}.", %p)},	"\x{062F}\x{066B}.",	"to_unicode\(\'\\u062F\\u066B\.\'\)\ \[data\/IdnaTest\.txt\:2313\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񎹄砪≯𐫉｡≯\x{17BA}󣺋\x{200C}", %p)},	undef,	"to_unicode\(\'񎹄砪\≯𐫉｡\≯\\u17BA󣺋\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2314\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񎹄砪≯𐫉｡≯\x{17BA}󣺋\x{200C}", %p)},	undef,	"to_unicode\(\'񎹄砪\≯𐫉｡\≯\\u17BA󣺋\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2315\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񎹄砪>\x{0338}𐫉｡>\x{0338}\x{17BA}󣺋\x{200C}", %p)},	undef,	"to_unicode\(\'񎹄砪\>\\u0338𐫉｡\>\\u0338\\u17BA󣺋\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2316\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񎹄砪>\x{0338}𐫉｡>\x{0338}\x{17BA}󣺋\x{200C}", %p)},	undef,	"to_unicode\(\'񎹄砪\>\\u0338𐫉｡\>\\u0338\\u17BA󣺋\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2317\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񎹄砪≯𐫉。≯\x{17BA}󣺋\x{200C}", %p)},	undef,	"to_unicode\(\'񎹄砪\≯𐫉\。\≯\\u17BA󣺋\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2318\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񎹄砪≯𐫉。≯\x{17BA}󣺋\x{200C}", %p)},	undef,	"to_unicode\(\'񎹄砪\≯𐫉\。\≯\\u17BA󣺋\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2319\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񎹄砪>\x{0338}𐫉。>\x{0338}\x{17BA}󣺋\x{200C}", %p)},	undef,	"to_unicode\(\'񎹄砪\>\\u0338𐫉\。\>\\u0338\\u17BA󣺋\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2320\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񎹄砪>\x{0338}𐫉。>\x{0338}\x{17BA}󣺋\x{200C}", %p)},	undef,	"to_unicode\(\'񎹄砪\>\\u0338𐫉\。\>\\u0338\\u17BA󣺋\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2321\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴥ.\x{094D}㊸", %p)},	undef,	"to_unicode\(\'Ⴥ\.\\u094D㊸\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2322\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴥ.\x{094D}43", %p)},	undef,	"to_unicode\(\'Ⴥ\.\\u094D43\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2323\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴥ.\x{094D}43", %p)},	undef,	"to_unicode\(\'ⴥ\.\\u094D43\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2324\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴥ.\x{094D}㊸", %p)},	undef,	"to_unicode\(\'ⴥ\.\\u094D㊸\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2325\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𝟎\x{066C}。Ⴒᡋ\x{1DD3}𐹴", %p)},	undef,	"to_unicode\(\'𝟎\\u066C\。Ⴒᡋ\\u1DD3𐹴\'\)\ throws\ error\ P1\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2326\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0\x{066C}。Ⴒᡋ\x{1DD3}𐹴", %p)},	undef,	"to_unicode\(\'0\\u066C\。Ⴒᡋ\\u1DD3𐹴\'\)\ throws\ error\ P1\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2327\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("0\x{066C}。ⴒᡋ\x{1DD3}𐹴", %p)},	undef,	"to_unicode\(\'0\\u066C\。ⴒᡋ\\u1DD3𐹴\'\)\ throws\ error\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2328\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𝟎\x{066C}。ⴒᡋ\x{1DD3}𐹴", %p)},	undef,	"to_unicode\(\'𝟎\\u066C\。ⴒᡋ\\u1DD3𐹴\'\)\ throws\ error\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2329\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("󝆆\x{20EB}\x{FFA0}\x{1DE1}.򼇅𑓂", %p)},	undef,	"to_unicode\(\'󝆆\\u20EB\\uFFA0\\u1DE1\.򼇅𑓂\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2330\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󝆆\x{20EB}\x{1160}\x{1DE1}.򼇅𑓂", %p)},	undef,	"to_unicode\(\'󝆆\\u20EB\\u1160\\u1DE1\.򼇅𑓂\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2331\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{AA31}.۳\x{200C}\x{0C4D}", %p)},	undef,	"to_unicode\(\'\\uAA31\.۳\\u200C\\u0C4D\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2332\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{AA31}.۳\x{200C}\x{0C4D}", %p)},	undef,	"to_unicode\(\'\\uAA31\.۳\\u200C\\u0C4D\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2333\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𐫜．︒ᠦ", %p)},	undef,	"to_unicode\(\'𐫜．︒ᠦ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2334\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐫜.。ᠦ", %p)},	undef,	"to_unicode\(\'𐫜\.\。ᠦ\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:2335\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("\x{0C4D}\x{0FB3}｡𐦽", %p)},	undef,	"to_unicode\(\'\\u0C4D\\u0FB3｡𐦽\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2336\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("\x{0C4D}\x{0FB3}。𐦽", %p)},	undef,	"to_unicode\(\'\\u0C4D\\u0FB3\。𐦽\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2337\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𞯟。𐫒񥂰", %p)},	undef,	"to_unicode\(\'𞯟\。𐫒񥂰\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2338\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0BCD}㴼．\x{200C}\x{0669}\x{FE29}񅋵", %p)},	undef,	"to_unicode\(\'\\u0BCD㴼．\\u200C\\u0669\\uFE29񅋵\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2339\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0BCD}㴼．\x{200C}\x{0669}\x{FE29}񅋵", %p)},	undef,	"to_unicode\(\'\\u0BCD㴼．\\u200C\\u0669\\uFE29񅋵\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2340\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0BCD}㴼.\x{200C}\x{0669}\x{FE29}񅋵", %p)},	undef,	"to_unicode\(\'\\u0BCD㴼\.\\u200C\\u0669\\uFE29񅋵\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2341\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0BCD}㴼.\x{200C}\x{0669}\x{FE29}񅋵", %p)},	undef,	"to_unicode\(\'\\u0BCD㴼\.\\u200C\\u0669\\uFE29񅋵\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2342\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𬙭\x{0600}👙｡\x{0955}", %p)},	undef,	"to_unicode\(\'𬙭\\u0600👙｡\\u0955\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2343\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𬙭\x{0600}👙。\x{0955}", %p)},	undef,	"to_unicode\(\'𬙭\\u0600👙\。\\u0955\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2344\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢔ뾜󠛸\x{09CD}。\x{089D}\x{0600}", %p)},	undef,	"to_unicode\(\'ᢔ뾜\󠛸\\u09CD\。\\u089D\\u0600\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2345\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢔ뾜󠛸\x{09CD}。\x{089D}\x{0600}", %p)},	undef,	"to_unicode\(\'ᢔ뾜\󠛸\\u09CD\。\\u089D\\u0600\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2346\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹷≠｡𐋲󠱲\x{200C}", %p)},	undef,	"to_unicode\(\'𐹷\≠｡𐋲\󠱲\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2347\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹷≠｡𐋲󠱲\x{200C}", %p)},	undef,	"to_unicode\(\'𐹷\≠｡𐋲\󠱲\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2348\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹷=\x{0338}｡𐋲󠱲\x{200C}", %p)},	undef,	"to_unicode\(\'𐹷\=\\u0338｡𐋲\󠱲\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2349\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹷=\x{0338}｡𐋲󠱲\x{200C}", %p)},	undef,	"to_unicode\(\'𐹷\=\\u0338｡𐋲\󠱲\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2350\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹷≠。𐋲󠱲\x{200C}", %p)},	undef,	"to_unicode\(\'𐹷\≠\。𐋲\󠱲\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2351\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹷≠。𐋲󠱲\x{200C}", %p)},	undef,	"to_unicode\(\'𐹷\≠\。𐋲\󠱲\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2352\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹷=\x{0338}。𐋲󠱲\x{200C}", %p)},	undef,	"to_unicode\(\'𐹷\=\\u0338\。𐋲\󠱲\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2353\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹷=\x{0338}。𐋲󠱲\x{200C}", %p)},	undef,	"to_unicode\(\'𐹷\=\\u0338\。𐋲\󠱲\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2354\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115F}򯏪\x{0ACD}．\x{200D}\x{0D4D}𞩪", %p)},	undef,	"to_unicode\(\'\\u115F򯏪\\u0ACD．\\u200D\\u0D4D𞩪\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2355\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115F}򯏪\x{0ACD}．\x{200D}\x{0D4D}𞩪", %p)},	undef,	"to_unicode\(\'\\u115F򯏪\\u0ACD．\\u200D\\u0D4D𞩪\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2356\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115F}򯏪\x{0ACD}.\x{200D}\x{0D4D}𞩪", %p)},	undef,	"to_unicode\(\'\\u115F򯏪\\u0ACD\.\\u200D\\u0D4D𞩪\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2357\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115F}򯏪\x{0ACD}.\x{200D}\x{0D4D}𞩪", %p)},	undef,	"to_unicode\(\'\\u115F򯏪\\u0ACD\.\\u200D\\u0D4D𞩪\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2358\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񦞷\x{1714}󠄄\x{0F19}。≮", %p)},	undef,	"to_unicode\(\'񦞷\\u1714\󠄄\\u0F19\。\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2359\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񦞷\x{1714}󠄄\x{0F19}。<\x{0338}", %p)},	undef,	"to_unicode\(\'񦞷\\u1714\󠄄\\u0F19\。\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2360\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝨬.󠅙暀≠", %p)},	undef,	"to_unicode\(\'𝨬\.\󠅙暀\≠\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2361\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝨬.󠅙暀=\x{0338}", %p)},	undef,	"to_unicode\(\'𝨬\.\󠅙暀\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2362\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{068E}\x{0CCD}｡𞮆𿵧󠁶", %p)},	undef,	"to_unicode\(\'\\u068E\\u0CCD｡𞮆𿵧\󠁶\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2363\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{068E}\x{0CCD}。𞮆𿵧󠁶", %p)},	undef,	"to_unicode\(\'\\u068E\\u0CCD\。𞮆𿵧\󠁶\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2364\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A92A}\x{200D}⒈｡Ⴌ𐢐", %p)},	undef,	"to_unicode\(\'\\uA92A\\u200D⒈｡Ⴌ𐢐\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:2365\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A92A}\x{200D}⒈｡Ⴌ𐢐", %p)},	undef,	"to_unicode\(\'\\uA92A\\u200D⒈｡Ⴌ𐢐\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:2366\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A92A}\x{200D}1.。Ⴌ𐢐", %p)},	undef,	"to_unicode\(\'\\uA92A\\u200D1\.\。Ⴌ𐢐\'\)\ throws\ error\ P1\ V5\ V6\ C2\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:2367\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A92A}\x{200D}1.。Ⴌ𐢐", %p)},	undef,	"to_unicode\(\'\\uA92A\\u200D1\.\。Ⴌ𐢐\'\)\ throws\ error\ P1\ V5\ V6\ C2\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:2368\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{A92A}\x{200D}1.。ⴌ𐢐", %p)},	undef,	"to_unicode\(\'\\uA92A\\u200D1\.\。ⴌ𐢐\'\)\ throws\ error\ V5\ C2\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:2369\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{A92A}\x{200D}1.。ⴌ𐢐", %p)},	undef,	"to_unicode\(\'\\uA92A\\u200D1\.\。ⴌ𐢐\'\)\ throws\ error\ V5\ C2\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:2370\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{A92A}\x{200D}⒈｡ⴌ𐢐", %p)},	undef,	"to_unicode\(\'\\uA92A\\u200D⒈｡ⴌ𐢐\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:2371\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A92A}\x{200D}⒈｡ⴌ𐢐", %p)},	undef,	"to_unicode\(\'\\uA92A\\u200D⒈｡ⴌ𐢐\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:2372\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠾸𐨿񃰂\x{0691}.ς𡛬󵼸", %p)},	undef,	"to_unicode\(\'\󠾸𐨿񃰂\\u0691\.ς𡛬󵼸\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2373\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠾸𐨿񃰂\x{0691}.Σ𡛬󵼸", %p)},	undef,	"to_unicode\(\'\󠾸𐨿񃰂\\u0691\.Σ𡛬󵼸\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2374\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠾸𐨿񃰂\x{0691}.σ𡛬󵼸", %p)},	undef,	"to_unicode\(\'\󠾸𐨿񃰂\\u0691\.σ𡛬󵼸\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2375\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢛ。\x{200C}ᠳ񩿹", %p)},	undef,	"to_unicode\(\'ᢛ\。\\u200Cᠳ񩿹\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2376\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢛ。\x{200C}ᠳ񩿹", %p)},	undef,	"to_unicode\(\'ᢛ\。\\u200Cᠳ񩿹\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2377\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{06DA}\x{20E2}.\x{A672}ꡋ𐫉𝅿", %p)},	undef,	"to_unicode\(\'\\u06DA\\u20E2\.\\uA672ꡋ𐫉𝅿\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2378\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("䂹򪾥𐋦．\x{200D}", %p)},	undef,	"to_unicode\(\'䂹򪾥𐋦．\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2379\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䂹򪾥𐋦．\x{200D}", %p)},	undef,	"to_unicode\(\'䂹򪾥𐋦．\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2380\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䂹򪾥𐋦.\x{200D}", %p)},	undef,	"to_unicode\(\'䂹򪾥𐋦\.\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2381\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䂹򪾥𐋦.\x{200D}", %p)},	undef,	"to_unicode\(\'䂹򪾥𐋦\.\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2382\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0BCD}\x{200C}\x{0667}\x{200C}｡𐲟🄉", %p)},	undef,	"to_unicode\(\'\\u0BCD\\u200C\\u0667\\u200C｡𐲟🄉\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2383\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0BCD}\x{200C}\x{0667}\x{200C}｡𐲟🄉", %p)},	undef,	"to_unicode\(\'\\u0BCD\\u200C\\u0667\\u200C｡𐲟🄉\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2384\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0BCD}\x{200C}\x{0667}\x{200C}。𐲟8,", %p)},	undef,	"to_unicode\(\'\\u0BCD\\u200C\\u0667\\u200C\。𐲟8\,\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ B3\ \[data\/IdnaTest\.txt\:2385\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0BCD}\x{200C}\x{0667}\x{200C}。𐲟8,", %p)},	undef,	"to_unicode\(\'\\u0BCD\\u200C\\u0667\\u200C\。𐲟8\,\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ B3\ \[data\/IdnaTest\.txt\:2386\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒｡Ⴃ≯", %p)},	undef,	"to_unicode\(\'︒｡Ⴃ\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2387\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒｡Ⴃ>\x{0338}", %p)},	undef,	"to_unicode\(\'︒｡Ⴃ\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2388\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。。Ⴃ≯", %p)},	undef,	"to_unicode\(\'\。\。Ⴃ\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2389\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。。Ⴃ>\x{0338}", %p)},	undef,	"to_unicode\(\'\。\。Ⴃ\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2390\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。。ⴃ>\x{0338}", %p)},	undef,	"to_unicode\(\'\。\。ⴃ\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2391\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。。ⴃ≯", %p)},	undef,	"to_unicode\(\'\。\。ⴃ\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2392\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒｡ⴃ>\x{0338}", %p)},	undef,	"to_unicode\(\'︒｡ⴃ\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2393\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒｡ⴃ≯", %p)},	undef,	"to_unicode\(\'︒｡ⴃ\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2394\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹡｡󠁙\x{200D}", %p)},	undef,	"to_unicode\(\'𐹡｡\󠁙\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2395\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹡｡󠁙\x{200D}", %p)},	undef,	"to_unicode\(\'𐹡｡\󠁙\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2396\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹡。󠁙\x{200D}", %p)},	undef,	"to_unicode\(\'𐹡\。\󠁙\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2397\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹡。󠁙\x{200D}", %p)},	undef,	"to_unicode\(\'𐹡\。\󠁙\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2398\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴞ𐹮｡︒𐫁\x{200D}Ⴏ", %p)},	undef,	"to_unicode\(\'Ⴞ𐹮｡︒𐫁\\u200DႯ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ C2\ \[data\/IdnaTest\.txt\:2399\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴞ𐹮｡︒𐫁\x{200D}Ⴏ", %p)},	undef,	"to_unicode\(\'Ⴞ𐹮｡︒𐫁\\u200DႯ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ C2\ \[data\/IdnaTest\.txt\:2400\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴞ𐹮。。𐫁\x{200D}Ⴏ", %p)},	undef,	"to_unicode\(\'Ⴞ𐹮\。\。𐫁\\u200DႯ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ A4_2\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2401\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴞ𐹮。。𐫁\x{200D}Ⴏ", %p)},	undef,	"to_unicode\(\'Ⴞ𐹮\。\。𐫁\\u200DႯ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ A4_2\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2402\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ⴞ𐹮。。𐫁\x{200D}ⴏ", %p)},	undef,	"to_unicode\(\'ⴞ𐹮\。\。𐫁\\u200Dⴏ\'\)\ throws\ error\ B5\ B6\ A4_2\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2403\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ⴞ𐹮。。𐫁\x{200D}ⴏ", %p)},	undef,	"to_unicode\(\'ⴞ𐹮\。\。𐫁\\u200Dⴏ\'\)\ throws\ error\ B5\ B6\ A4_2\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2404\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ⴞ𐹮｡︒𐫁\x{200D}ⴏ", %p)},	undef,	"to_unicode\(\'ⴞ𐹮｡︒𐫁\\u200Dⴏ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ C2\ \[data\/IdnaTest\.txt\:2405\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴞ𐹮｡︒𐫁\x{200D}ⴏ", %p)},	undef,	"to_unicode\(\'ⴞ𐹮｡︒𐫁\\u200Dⴏ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ C2\ \[data\/IdnaTest\.txt\:2406\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴆ𝟹。-\x{1DF1}-𐫝", %p)},	undef,	"to_unicode\(\'\\u200CႦ𝟹\。\-\\u1DF1\-𐫝\'\)\ throws\ error\ P1\ V6\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:2407\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴆ𝟹。-\x{1DF1}-𐫝", %p)},	undef,	"to_unicode\(\'\\u200CႦ𝟹\。\-\\u1DF1\-𐫝\'\)\ throws\ error\ P1\ V6\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:2408\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴆ3。-\x{1DF1}-𐫝", %p)},	undef,	"to_unicode\(\'\\u200CႦ3\。\-\\u1DF1\-𐫝\'\)\ throws\ error\ P1\ V6\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:2409\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴆ3。-\x{1DF1}-𐫝", %p)},	undef,	"to_unicode\(\'\\u200CႦ3\。\-\\u1DF1\-𐫝\'\)\ throws\ error\ P1\ V6\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:2410\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200C}ⴆ3。-\x{1DF1}-𐫝", %p)},	undef,	"to_unicode\(\'\\u200Cⴆ3\。\-\\u1DF1\-𐫝\'\)\ throws\ error\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:2411\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200C}ⴆ3。-\x{1DF1}-𐫝", %p)},	undef,	"to_unicode\(\'\\u200Cⴆ3\。\-\\u1DF1\-𐫝\'\)\ throws\ error\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:2412\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200C}ⴆ𝟹。-\x{1DF1}-𐫝", %p)},	undef,	"to_unicode\(\'\\u200Cⴆ𝟹\。\-\\u1DF1\-𐫝\'\)\ throws\ error\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:2413\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200C}ⴆ𝟹。-\x{1DF1}-𐫝", %p)},	undef,	"to_unicode\(\'\\u200Cⴆ𝟹\。\-\\u1DF1\-𐫝\'\)\ throws\ error\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:2414\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("箃Ⴡ-\x{0342}｡≠-👣", %p)},	undef,	"to_unicode\(\'箃Ⴡ\-\\u0342｡\≠\-👣\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2415\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("箃Ⴡ-\x{0342}｡=\x{0338}-👣", %p)},	undef,	"to_unicode\(\'箃Ⴡ\-\\u0342｡\=\\u0338\-👣\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2416\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("箃Ⴡ-\x{0342}。≠-👣", %p)},	undef,	"to_unicode\(\'箃Ⴡ\-\\u0342\。\≠\-👣\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2417\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("箃Ⴡ-\x{0342}。=\x{0338}-👣", %p)},	undef,	"to_unicode\(\'箃Ⴡ\-\\u0342\。\=\\u0338\-👣\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2418\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("箃ⴡ-\x{0342}。=\x{0338}-👣", %p)},	undef,	"to_unicode\(\'箃ⴡ\-\\u0342\。\=\\u0338\-👣\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2419\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("箃ⴡ-\x{0342}。≠-👣", %p)},	undef,	"to_unicode\(\'箃ⴡ\-\\u0342\。\≠\-👣\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2420\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("箃ⴡ-\x{0342}｡=\x{0338}-👣", %p)},	undef,	"to_unicode\(\'箃ⴡ\-\\u0342｡\=\\u0338\-👣\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2421\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("箃ⴡ-\x{0342}｡≠-👣", %p)},	undef,	"to_unicode\(\'箃ⴡ\-\\u0342｡\≠\-👣\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2422\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07DC}.ꡜ", %p)},	"\x{07DC}.ꡜ",	"to_unicode\(\'\\u07DC\.ꡜ\'\)\ \[data\/IdnaTest\.txt\:2423\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("xn--3sb.xn--1c9a", %p)},	"\x{07DC}.ꡜ",	"to_unicode\(\'xn\-\-3sb\.xn\-\-1c9a\'\)\ \[data\/IdnaTest\.txt\:2424\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}\x{200D}.ᢏ", %p)},	undef,	"to_unicode\(\'\\u200C\\u200D\.ᢏ\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:2425\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200D}.ᢏ", %p)},	undef,	"to_unicode\(\'\\u200C\\u200D\.ᢏ\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:2426\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--89e", %p)},	"ᢏ",	"to_unicode\(\'xn\-\-89e\'\)\ \[data\/IdnaTest\.txt\:2427\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢏ", %p)},	"ᢏ",	"to_unicode\(\'ᢏ\'\)\ \[data\/IdnaTest\.txt\:2428\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("≤𐹮ᡱ.ς\x{1BAA}蜹", %p)},	undef,	"to_unicode\(\'\≤𐹮ᡱ\.ς\\u1BAA蜹\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2429\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("≤𐹮ᡱ.Σ\x{1BAA}蜹", %p)},	undef,	"to_unicode\(\'\≤𐹮ᡱ\.Σ\\u1BAA蜹\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2430\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("≤𐹮ᡱ.σ\x{1BAA}蜹", %p)},	undef,	"to_unicode\(\'\≤𐹮ᡱ\.σ\\u1BAA蜹\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2431\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("򩎰ス􅲆𐹡．򉬄", %p)},	undef,	"to_unicode\(\'򩎰ス􅲆𐹡．򉬄\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2432\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򩎰ス􅲆𐹡.򉬄", %p)},	undef,	"to_unicode\(\'򩎰ス􅲆𐹡\.򉬄\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2433\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05C7}𜖴．\x{05BB}\x{D850}ꡢ", %p)},	undef,	"to_unicode\(\'\\u05C7𜖴．\\u05BB\\uD850ꡢ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2434\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05C7}𜖴.\x{05BB}\x{D850}ꡢ", %p)},	undef,	"to_unicode\(\'\\u05C7𜖴\.\\u05BB\\uD850ꡢ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2435\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0662}󤺆\x{200C}。ᢡ", %p)},	undef,	"to_unicode\(\'\\u0662󤺆\\u200C\。ᢡ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2436\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0662}󤺆\x{200C}。ᢡ", %p)},	undef,	"to_unicode\(\'\\u0662󤺆\\u200C\。ᢡ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2437\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𑋪\x{200D}\x{200C}。-\x{200C}", %p)},	undef,	"to_unicode\(\'𑋪\\u200D\\u200C\。\-\\u200C\'\)\ throws\ error\ V5\ V3\ C1\ \[data\/IdnaTest\.txt\:2438\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𑋪\x{200D}\x{200C}。-\x{200C}", %p)},	undef,	"to_unicode\(\'𑋪\\u200D\\u200C\。\-\\u200C\'\)\ throws\ error\ V5\ V3\ C1\ \[data\/IdnaTest\.txt\:2439\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("︒｡\x{1039}\x{0720}", %p)},	undef,	"to_unicode\(\'︒｡\\u1039\\u0720\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2440\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。。\x{1039}\x{0720}", %p)},	undef,	"to_unicode\(\'\。\。\\u1039\\u0720\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2441\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢇß。ጫᡏ\x{068C}𝟐", %p)},	undef,	"to_unicode\(\'ᢇß\。ጫᡏ\\u068C𝟐\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:2442\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢇß。ጫᡏ\x{068C}2", %p)},	undef,	"to_unicode\(\'ᢇß\。ጫᡏ\\u068C2\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:2443\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢇSS。ጫᡏ\x{068C}2", %p)},	undef,	"to_unicode\(\'ᢇSS\。ጫᡏ\\u068C2\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:2444\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢇss。ጫᡏ\x{068C}2", %p)},	undef,	"to_unicode\(\'ᢇss\。ጫᡏ\\u068C2\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:2445\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢇSs。ጫᡏ\x{068C}2", %p)},	undef,	"to_unicode\(\'ᢇSs\。ጫᡏ\\u068C2\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:2446\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢇSS。ጫᡏ\x{068C}𝟐", %p)},	undef,	"to_unicode\(\'ᢇSS\。ጫᡏ\\u068C𝟐\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:2447\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢇss。ጫᡏ\x{068C}𝟐", %p)},	undef,	"to_unicode\(\'ᢇss\。ጫᡏ\\u068C𝟐\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:2448\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢇSs。ጫᡏ\x{068C}𝟐", %p)},	undef,	"to_unicode\(\'ᢇSs\。ጫᡏ\\u068C𝟐\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:2449\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞾰\x{FCDE}ᚲ.\x{0F83}󠀥𝟚\x{AAF6}", %p)},	undef,	"to_unicode\(\'𞾰\\uFCDEᚲ\.\\u0F83\󠀥𝟚\\uAAF6\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:2450\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞾰\x{064A}\x{0647}ᚲ.\x{0F83}󠀥2\x{AAF6}", %p)},	undef,	"to_unicode\(\'𞾰\\u064A\\u0647ᚲ\.\\u0F83\󠀥2\\uAAF6\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:2451\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{1B44}︒\x{200D}.𑕮𬺥", %p)},	undef,	"to_unicode\(\'\-\\u1B44︒\\u200D\.𑕮𬺥\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2452\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{1B44}︒\x{200D}.𑕮𬺥", %p)},	undef,	"to_unicode\(\'\-\\u1B44︒\\u200D\.𑕮𬺥\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2453\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{1B44}。\x{200D}.𑕮𬺥", %p)},	undef,	"to_unicode\(\'\-\\u1B44\。\\u200D\.𑕮𬺥\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2454\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{1B44}。\x{200D}.𑕮𬺥", %p)},	undef,	"to_unicode\(\'\-\\u1B44\。\\u200D\.𑕮𬺥\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2455\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠖺.≯\x{1AB5}", %p)},	undef,	"to_unicode\(\'\󠖺\.\≯\\u1AB5\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2456\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠖺.>\x{0338}\x{1AB5}", %p)},	undef,	"to_unicode\(\'\󠖺\.\>\\u0338\\u1AB5\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2457\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{09CD}‡\x{0601}。𞴅", %p)},	undef,	"to_unicode\(\'\-\\u09CD\‡\\u0601\。𞴅\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2458\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06A2}．\x{0717}\x{115F}", %p)},	undef,	"to_unicode\(\'\\u06A2．\\u0717\\u115F\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2459\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06A2}.\x{0717}\x{115F}", %p)},	undef,	"to_unicode\(\'\\u06A2\.\\u0717\\u115F\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2460\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㨛񻘅.︒𝟕𑜨", %p)},	undef,	"to_unicode\(\'㨛񻘅\.︒𝟕𑜨\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2461\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㨛񻘅.。7𑜨", %p)},	undef,	"to_unicode\(\'㨛񻘅\.\。7𑜨\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2462\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0663}񥐑-｡𐦱𐍷\x{0764}≮", %p)},	undef,	"to_unicode\(\'\\u0663񥐑\-｡𐦱𐍷\\u0764\≮\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:2463\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0663}񥐑-｡𐦱𐍷\x{0764}<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0663񥐑\-｡𐦱𐍷\\u0764\<\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:2464\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0663}񥐑-。𐦱𐍷\x{0764}≮", %p)},	undef,	"to_unicode\(\'\\u0663񥐑\-\。𐦱𐍷\\u0764\≮\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:2465\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0663}񥐑-。𐦱𐍷\x{0764}<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0663񥐑\-\。𐦱𐍷\\u0764\<\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:2466\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200C}\x{0FA2}\x{0750}．℞ჁႶ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\u0FA2\\u0750．℞ჁႶ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2467\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200C}\x{0FA2}\x{0750}．℞ჁႶ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\u0FA2\\u0750．℞ჁႶ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2468\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200C}\x{0FA1}\x{0FB7}\x{0750}．℞ჁႶ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\u0FA1\\u0FB7\\u0750．℞ჁႶ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2469\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200C}\x{0FA1}\x{0FB7}\x{0750}．℞ჁႶ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\u0FA1\\u0FB7\\u0750．℞ჁႶ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2470\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200C}\x{0FA1}\x{0FB7}\x{0750}.℞ჁႶ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\u0FA1\\u0FB7\\u0750\.℞ჁႶ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2471\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200C}\x{0FA1}\x{0FB7}\x{0750}.℞ჁႶ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\u0FA1\\u0FB7\\u0750\.℞ჁႶ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2472\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ß\x{200C}\x{0FA1}\x{0FB7}\x{0750}.℞ⴡⴖ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\u0FA1\\u0FB7\\u0750\.℞ⴡⴖ\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2473\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ß\x{200C}\x{0FA1}\x{0FB7}\x{0750}.℞ⴡⴖ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\u0FA1\\u0FB7\\u0750\.℞ⴡⴖ\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2474\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("SS\x{200C}\x{0FA1}\x{0FB7}\x{0750}.℞ჁႶ", %p)},	undef,	"to_unicode\(\'SS\\u200C\\u0FA1\\u0FB7\\u0750\.℞ჁႶ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2475\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{200C}\x{0FA1}\x{0FB7}\x{0750}.℞ჁႶ", %p)},	undef,	"to_unicode\(\'SS\\u200C\\u0FA1\\u0FB7\\u0750\.℞ჁႶ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2476\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ss\x{200C}\x{0FA1}\x{0FB7}\x{0750}.℞ⴡⴖ", %p)},	undef,	"to_unicode\(\'ss\\u200C\\u0FA1\\u0FB7\\u0750\.℞ⴡⴖ\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2477\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ss\x{200C}\x{0FA1}\x{0FB7}\x{0750}.℞ⴡⴖ", %p)},	undef,	"to_unicode\(\'ss\\u200C\\u0FA1\\u0FB7\\u0750\.℞ⴡⴖ\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2478\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ss\x{200C}\x{0FA1}\x{0FB7}\x{0750}.℞Ⴡⴖ", %p)},	undef,	"to_unicode\(\'Ss\\u200C\\u0FA1\\u0FB7\\u0750\.℞Ⴡⴖ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2479\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200C}\x{0FA1}\x{0FB7}\x{0750}.℞Ⴡⴖ", %p)},	undef,	"to_unicode\(\'Ss\\u200C\\u0FA1\\u0FB7\\u0750\.℞Ⴡⴖ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2480\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ß\x{200C}\x{0FA1}\x{0FB7}\x{0750}．℞ⴡⴖ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\u0FA1\\u0FB7\\u0750．℞ⴡⴖ\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2481\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ß\x{200C}\x{0FA1}\x{0FB7}\x{0750}．℞ⴡⴖ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\u0FA1\\u0FB7\\u0750．℞ⴡⴖ\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2482\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("SS\x{200C}\x{0FA1}\x{0FB7}\x{0750}．℞ჁႶ", %p)},	undef,	"to_unicode\(\'SS\\u200C\\u0FA1\\u0FB7\\u0750．℞ჁႶ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2483\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{200C}\x{0FA1}\x{0FB7}\x{0750}．℞ჁႶ", %p)},	undef,	"to_unicode\(\'SS\\u200C\\u0FA1\\u0FB7\\u0750．℞ჁႶ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2484\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ss\x{200C}\x{0FA1}\x{0FB7}\x{0750}．℞ⴡⴖ", %p)},	undef,	"to_unicode\(\'ss\\u200C\\u0FA1\\u0FB7\\u0750．℞ⴡⴖ\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2485\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ss\x{200C}\x{0FA1}\x{0FB7}\x{0750}．℞ⴡⴖ", %p)},	undef,	"to_unicode\(\'ss\\u200C\\u0FA1\\u0FB7\\u0750．℞ⴡⴖ\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2486\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ss\x{200C}\x{0FA1}\x{0FB7}\x{0750}．℞Ⴡⴖ", %p)},	undef,	"to_unicode\(\'Ss\\u200C\\u0FA1\\u0FB7\\u0750．℞Ⴡⴖ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2487\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200C}\x{0FA1}\x{0FB7}\x{0750}．℞Ⴡⴖ", %p)},	undef,	"to_unicode\(\'Ss\\u200C\\u0FA1\\u0FB7\\u0750．℞Ⴡⴖ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2488\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ß\x{200C}\x{0FA2}\x{0750}．℞ⴡⴖ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\u0FA2\\u0750．℞ⴡⴖ\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2489\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ß\x{200C}\x{0FA2}\x{0750}．℞ⴡⴖ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\u0FA2\\u0750．℞ⴡⴖ\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2490\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("SS\x{200C}\x{0FA2}\x{0750}．℞ჁႶ", %p)},	undef,	"to_unicode\(\'SS\\u200C\\u0FA2\\u0750．℞ჁႶ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2491\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{200C}\x{0FA2}\x{0750}．℞ჁႶ", %p)},	undef,	"to_unicode\(\'SS\\u200C\\u0FA2\\u0750．℞ჁႶ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2492\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ss\x{200C}\x{0FA2}\x{0750}．℞ⴡⴖ", %p)},	undef,	"to_unicode\(\'ss\\u200C\\u0FA2\\u0750．℞ⴡⴖ\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2493\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ss\x{200C}\x{0FA2}\x{0750}．℞ⴡⴖ", %p)},	undef,	"to_unicode\(\'ss\\u200C\\u0FA2\\u0750．℞ⴡⴖ\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2494\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ss\x{200C}\x{0FA2}\x{0750}．℞Ⴡⴖ", %p)},	undef,	"to_unicode\(\'Ss\\u200C\\u0FA2\\u0750．℞Ⴡⴖ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2495\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200C}\x{0FA2}\x{0750}．℞Ⴡⴖ", %p)},	undef,	"to_unicode\(\'Ss\\u200C\\u0FA2\\u0750．℞Ⴡⴖ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2496\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。ς󠁳", %p)},	undef,	"to_unicode\(\'\\u200D\。ς\󠁳\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2497\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。ς󠁳", %p)},	undef,	"to_unicode\(\'\\u200D\。ς\󠁳\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2498\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。Σ󠁳", %p)},	undef,	"to_unicode\(\'\\u200D\。Σ\󠁳\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2499\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。Σ󠁳", %p)},	undef,	"to_unicode\(\'\\u200D\。Σ\󠁳\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2500\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。σ󠁳", %p)},	undef,	"to_unicode\(\'\\u200D\。σ\󠁳\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2501\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。σ󠁳", %p)},	undef,	"to_unicode\(\'\\u200D\。σ\󠁳\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2502\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐮧ß.𐮍\x{200D}ᠨ-", %p)},	undef,	"to_unicode\(\'𐮧ß\.𐮍\\u200Dᠨ\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2503\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐮧ß.𐮍\x{200D}ᠨ-", %p)},	undef,	"to_unicode\(\'𐮧ß\.𐮍\\u200Dᠨ\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2504\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐮧SS.𐮍\x{200D}ᠨ-", %p)},	undef,	"to_unicode\(\'𐮧SS\.𐮍\\u200Dᠨ\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2505\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐮧SS.𐮍\x{200D}ᠨ-", %p)},	undef,	"to_unicode\(\'𐮧SS\.𐮍\\u200Dᠨ\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2506\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐮧ss.𐮍\x{200D}ᠨ-", %p)},	undef,	"to_unicode\(\'𐮧ss\.𐮍\\u200Dᠨ\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2507\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐮧ss.𐮍\x{200D}ᠨ-", %p)},	undef,	"to_unicode\(\'𐮧ss\.𐮍\\u200Dᠨ\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2508\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐮧Ss.𐮍\x{200D}ᠨ-", %p)},	undef,	"to_unicode\(\'𐮧Ss\.𐮍\\u200Dᠨ\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2509\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐮧Ss.𐮍\x{200D}ᠨ-", %p)},	undef,	"to_unicode\(\'𐮧Ss\.𐮍\\u200Dᠨ\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2510\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0816}\x{200D}𐮭．\x{0662}󔿾-", %p)},	undef,	"to_unicode\(\'\\u0816\\u200D𐮭．\\u0662󔿾\-\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2511\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0816}\x{200D}𐮭．\x{0662}󔿾-", %p)},	undef,	"to_unicode\(\'\\u0816\\u200D𐮭．\\u0662󔿾\-\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2512\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0816}\x{200D}𐮭.\x{0662}󔿾-", %p)},	undef,	"to_unicode\(\'\\u0816\\u200D𐮭\.\\u0662󔿾\-\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2513\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0816}\x{200D}𐮭.\x{0662}󔿾-", %p)},	undef,	"to_unicode\(\'\\u0816\\u200D𐮭\.\\u0662󔿾\-\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2514\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒒񷻕򨢣𑍫.-򌀇", %p)},	undef,	"to_unicode\(\'⒒񷻕򨢣𑍫\.\-򌀇\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:2515\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("11.񷻕򨢣𑍫.-򌀇", %p)},	undef,	"to_unicode\(\'11\.񷻕򨢣𑍫\.\-򌀇\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:2516\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-｡\x{200D}", %p)},	undef,	"to_unicode\(\'\-｡\\u200D\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:2517\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-｡\x{200D}", %p)},	undef,	"to_unicode\(\'\-｡\\u200D\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:2518\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-。\x{200D}", %p)},	undef,	"to_unicode\(\'\-\。\\u200D\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:2519\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-。\x{200D}", %p)},	undef,	"to_unicode\(\'\-\。\\u200D\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:2520\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{0776}．ς¹-\x{DB09}", %p)},	undef,	"to_unicode\(\'\≮\\u0776．ς¹\-\\uDB09\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2521\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{0776}．ς¹-\x{DB09}", %p)},	undef,	"to_unicode\(\'\<\\u0338\\u0776．ς¹\-\\uDB09\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2522\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{0776}.ς1-\x{DB09}", %p)},	undef,	"to_unicode\(\'\≮\\u0776\.ς1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2523\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{0776}.ς1-\x{DB09}", %p)},	undef,	"to_unicode\(\'\<\\u0338\\u0776\.ς1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2524\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{0776}.Σ1-\x{DB09}", %p)},	undef,	"to_unicode\(\'\<\\u0338\\u0776\.Σ1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2525\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{0776}.Σ1-\x{DB09}", %p)},	undef,	"to_unicode\(\'\≮\\u0776\.Σ1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2526\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{0776}.σ1-\x{DB09}", %p)},	undef,	"to_unicode\(\'\≮\\u0776\.σ1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2527\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{0776}.σ1-\x{DB09}", %p)},	undef,	"to_unicode\(\'\<\\u0338\\u0776\.σ1\-\\uDB09\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2528\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{0776}．Σ¹-\x{DB09}", %p)},	undef,	"to_unicode\(\'\<\\u0338\\u0776．Σ¹\-\\uDB09\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2529\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{0776}．Σ¹-\x{DB09}", %p)},	undef,	"to_unicode\(\'\≮\\u0776．Σ¹\-\\uDB09\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2530\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{0776}．σ¹-\x{DB09}", %p)},	undef,	"to_unicode\(\'\≮\\u0776．σ¹\-\\uDB09\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2531\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{0776}．σ¹-\x{DB09}", %p)},	undef,	"to_unicode\(\'\<\\u0338\\u0776．σ¹\-\\uDB09\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2532\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ቬ񊱈󙪶｡\x{07B9}𝟠", %p)},	undef,	"to_unicode\(\'ቬ񊱈󙪶｡\\u07B9𝟠\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2533\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ቬ񊱈󙪶。\x{07B9}8", %p)},	undef,	"to_unicode\(\'ቬ񊱈󙪶\。\\u07B98\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2534\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("𞺯。蔫\x{068A}", %p)},	undef,	"to_unicode\(\'𞺯\。蔫\\u068A\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:2535\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0639}。蔫\x{068A}", %p)},	undef,	"to_unicode\(\'\\u0639\。蔫\\u068A\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:2536\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򰡪₃｡ꡤ󤪓\x{0FAA}\x{067B}", %p)},	undef,	"to_unicode\(\'򰡪₃｡ꡤ󤪓\\u0FAA\\u067B\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2537\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򰡪3。ꡤ󤪓\x{0FAA}\x{067B}", %p)},	undef,	"to_unicode\(\'򰡪3\。ꡤ󤪓\\u0FAA\\u067B\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2538\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󊧧𐮅≠.ß", %p)},	undef,	"to_unicode\(\'󊧧𐮅\≠\.ß\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2539\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󊧧𐮅=\x{0338}.ß", %p)},	undef,	"to_unicode\(\'󊧧𐮅\=\\u0338\.ß\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2540\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󊧧𐮅=\x{0338}.SS", %p)},	undef,	"to_unicode\(\'󊧧𐮅\=\\u0338\.SS\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2541\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󊧧𐮅≠.SS", %p)},	undef,	"to_unicode\(\'󊧧𐮅\≠\.SS\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2542\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0770}\x{08AA}𑍴⒊.\x{0666}𞤵\x{05AE}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0770\\u08AA𑍴⒊\.\\u0666𞤵\\u05AE\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2543\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0770}\x{08AA}𑍴⒊.\x{0666}𞤵\x{05AE}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0770\\u08AA𑍴⒊\.\\u0666𞤵\\u05AE\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2544\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0770}\x{08AA}𑍴3..\x{0666}𞤵\x{05AE}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0770\\u08AA𑍴3\.\.\\u0666𞤵\\u05AE\\u200C\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ C1\ \[data\/IdnaTest\.txt\:2545\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0770}\x{08AA}𑍴3..\x{0666}𞤵\x{05AE}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0770\\u08AA𑍴3\.\.\\u0666𞤵\\u05AE\\u200C\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ C1\ \[data\/IdnaTest\.txt\:2546\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς\x{200D}-.Ⴣ󰬳", %p)},	undef,	"to_unicode\(\'ς\\u200D\-\.Ⴣ󰬳\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2547\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς\x{200D}-.Ⴣ󰬳", %p)},	undef,	"to_unicode\(\'ς\\u200D\-\.Ⴣ󰬳\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2548\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς\x{200D}-.ⴣ󰬳", %p)},	undef,	"to_unicode\(\'ς\\u200D\-\.ⴣ󰬳\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2549\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς\x{200D}-.ⴣ󰬳", %p)},	undef,	"to_unicode\(\'ς\\u200D\-\.ⴣ󰬳\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2550\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ\x{200D}-.Ⴣ󰬳", %p)},	undef,	"to_unicode\(\'Σ\\u200D\-\.Ⴣ󰬳\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2551\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ\x{200D}-.Ⴣ󰬳", %p)},	undef,	"to_unicode\(\'Σ\\u200D\-\.Ⴣ󰬳\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2552\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ\x{200D}-.ⴣ󰬳", %p)},	undef,	"to_unicode\(\'σ\\u200D\-\.ⴣ󰬳\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2553\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ\x{200D}-.ⴣ󰬳", %p)},	undef,	"to_unicode\(\'σ\\u200D\-\.ⴣ󰬳\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2554\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠。󠷆𝟲", %p)},	undef,	"to_unicode\(\'\≠\。\󠷆𝟲\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2555\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}。󠷆𝟲", %p)},	undef,	"to_unicode\(\'\=\\u0338\。\󠷆𝟲\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2556\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠。󠷆6", %p)},	undef,	"to_unicode\(\'\≠\。\󠷆6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2557\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}。󠷆6", %p)},	undef,	"to_unicode\(\'\=\\u0338\。\󠷆6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2558\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򉄵.蠔", %p)},	undef,	"to_unicode\(\'򉄵\.蠔\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2559\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FAE}\x{200D}．뼽", %p)},	undef,	"to_unicode\(\'\\u0FAE\\u200D．뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2560\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FAE}\x{200D}．뼽", %p)},	undef,	"to_unicode\(\'\\u0FAE\\u200D．뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2561\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FAE}\x{200D}．뼽", %p)},	undef,	"to_unicode\(\'\\u0FAE\\u200D．뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2562\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FAE}\x{200D}．뼽", %p)},	undef,	"to_unicode\(\'\\u0FAE\\u200D．뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2563\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FAE}\x{200D}.뼽", %p)},	undef,	"to_unicode\(\'\\u0FAE\\u200D\.뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2564\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FAE}\x{200D}.뼽", %p)},	undef,	"to_unicode\(\'\\u0FAE\\u200D\.뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2565\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FAE}\x{200D}.뼽", %p)},	undef,	"to_unicode\(\'\\u0FAE\\u200D\.뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2566\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FAE}\x{200D}.뼽", %p)},	undef,	"to_unicode\(\'\\u0FAE\\u200D\.뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2567\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("₇𑄳򯨓𐸬。⬅\x{0685}-\x{FD46}", %p)},	undef,	"to_unicode\(\'₇𑄳򯨓𐸬\。\⬅\\u0685\-\\uFD46\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2568\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("7𑄳򯨓𐸬。⬅\x{0685}-\x{FD46}", %p)},	undef,	"to_unicode\(\'7𑄳򯨓𐸬\。\⬅\\u0685\-\\uFD46\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2569\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("-｡\x{07E0}", %p)},	undef,	"to_unicode\(\'\-｡\\u07E0\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2570\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("-。\x{07E0}", %p)},	undef,	"to_unicode\(\'\-\。\\u07E0\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2571\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{1B6B}򪃩｡-⒈\x{075C}\x{07E1}", %p)},	undef,	"to_unicode\(\'\\u1B6B򪃩｡\-⒈\\u075C\\u07E1\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2572\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1B6B}򪃩。-1.\x{075C}\x{07E1}", %p)},	undef,	"to_unicode\(\'\\u1B6B򪃩\。\-1\.\\u075C\\u07E1\'\)\ throws\ error\ P1\ V5\ V6\ V3\ \[data\/IdnaTest\.txt\:2573\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("璛\x{2D7F}\x{0677}.-", %p)},	undef,	"to_unicode\(\'璛\\u2D7F\\u0677\.\-\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:2574\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("璛\x{2D7F}\x{06C7}\x{0674}.-", %p)},	undef,	"to_unicode\(\'璛\\u2D7F\\u06C7\\u0674\.\-\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:2575\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0596}ꡜ\x{A806}샕．𐹳휁", %p)},	undef,	"to_unicode\(\'\\u0596ꡜ\\uA806샕．𐹳휁\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2576\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0596}ꡜ\x{A806}샕．𐹳휁", %p)},	undef,	"to_unicode\(\'\\u0596ꡜ\\uA806샕．𐹳휁\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2577\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0596}ꡜ\x{A806}샕.𐹳휁", %p)},	undef,	"to_unicode\(\'\\u0596ꡜ\\uA806샕\.𐹳휁\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2578\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0596}ꡜ\x{A806}샕.𐹳휁", %p)},	undef,	"to_unicode\(\'\\u0596ꡜ\\uA806샕\.𐹳휁\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2579\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("󌥊．󔾋", %p)},	undef,	"to_unicode\(\'󌥊．󔾋\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2580\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󌥊.󔾋", %p)},	undef,	"to_unicode\(\'󌥊\.󔾋\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2581\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06B3}𐺰｡\x{ABED}𐮇Ⴍ-", %p)},	undef,	"to_unicode\(\'\\u06B3𐺰｡\\uABED𐮇Ⴍ\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:2582\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06B3}𐺰。\x{ABED}𐮇Ⴍ-", %p)},	undef,	"to_unicode\(\'\\u06B3𐺰\。\\uABED𐮇Ⴍ\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:2583\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06B3}𐺰。\x{ABED}𐮇ⴍ-", %p)},	undef,	"to_unicode\(\'\\u06B3𐺰\。\\uABED𐮇ⴍ\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:2584\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06B3}𐺰｡\x{ABED}𐮇ⴍ-", %p)},	undef,	"to_unicode\(\'\\u06B3𐺰｡\\uABED𐮇ⴍ\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:2585\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞹥𐧞\x{FE99}。򴶪₄Ⴋ𷮑", %p)},	undef,	"to_unicode\(\'𞹥𐧞\\uFE99\。򴶪₄Ⴋ𷮑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2586\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞹥𐧞\x{062B}。򴶪4Ⴋ𷮑", %p)},	undef,	"to_unicode\(\'𞹥𐧞\\u062B\。򴶪4Ⴋ𷮑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2587\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞹥𐧞\x{062B}。򴶪4ⴋ𷮑", %p)},	undef,	"to_unicode\(\'𞹥𐧞\\u062B\。򴶪4ⴋ𷮑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2588\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞹥𐧞\x{FE99}。򴶪₄ⴋ𷮑", %p)},	undef,	"to_unicode\(\'𞹥𐧞\\uFE99\。򴶪₄ⴋ𷮑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2589\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{066E}︒󠚂.≠", %p)},	undef,	"to_unicode\(\'4\\u066E︒\󠚂\.\≠\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2590\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{066E}︒󠚂.=\x{0338}", %p)},	undef,	"to_unicode\(\'4\\u066E︒\󠚂\.\=\\u0338\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2591\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{066E}。󠚂.≠", %p)},	undef,	"to_unicode\(\'4\\u066E\。\󠚂\.\≠\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2592\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{066E}。󠚂.=\x{0338}", %p)},	undef,	"to_unicode\(\'4\\u066E\。\󠚂\.\=\\u0338\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2593\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟓。\x{1920}", %p)},	undef,	"to_unicode\(\'𝟓\。\\u1920\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2594\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("5。\x{1920}", %p)},	undef,	"to_unicode\(\'5\。\\u1920\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2595\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񩈣.⾕", %p)},	undef,	"to_unicode\(\'\\u200C񩈣\.⾕\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2596\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񩈣.⾕", %p)},	undef,	"to_unicode\(\'\\u200C񩈣\.⾕\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2597\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񩈣.谷", %p)},	undef,	"to_unicode\(\'\\u200C񩈣\.谷\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2598\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񩈣.谷", %p)},	undef,	"to_unicode\(\'\\u200C񩈣\.谷\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2599\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒򖒱\x{200D}.-󠄫\x{200C}", %p)},	undef,	"to_unicode\(\'︒򖒱\\u200D\.\-\󠄫\\u200C\'\)\ throws\ error\ P1\ V6\ V3\ C2\ C1\ \[data\/IdnaTest\.txt\:2600\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒򖒱\x{200D}.-󠄫\x{200C}", %p)},	undef,	"to_unicode\(\'︒򖒱\\u200D\.\-\󠄫\\u200C\'\)\ throws\ error\ P1\ V6\ V3\ C2\ C1\ \[data\/IdnaTest\.txt\:2601\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。򖒱\x{200D}.-󠄫\x{200C}", %p)},	undef,	"to_unicode\(\'\。򖒱\\u200D\.\-\󠄫\\u200C\'\)\ throws\ error\ P1\ V6\ V3\ C2\ C1\ \[data\/IdnaTest\.txt\:2602\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。򖒱\x{200D}.-󠄫\x{200C}", %p)},	undef,	"to_unicode\(\'\。򖒱\\u200D\.\-\󠄫\\u200C\'\)\ throws\ error\ P1\ V6\ V3\ C2\ C1\ \[data\/IdnaTest\.txt\:2603\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{06A5}。ꡖ", %p)},	undef,	"to_unicode\(\'\≯\\u06A5\。ꡖ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2604\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{06A5}。ꡖ", %p)},	undef,	"to_unicode\(\'\>\\u0338\\u06A5\。ꡖ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2605\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1C36}󷠎𐅓。ᡕ\x{0600}", %p)},	undef,	"to_unicode\(\'\\u1C36󷠎𐅓\。ᡕ\\u0600\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2606\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{1DF3}\x{084F}⁷𝟹｡𝟬", %p)},	undef,	"to_unicode\(\'\\u1DF3\\u084F⁷𝟹｡𝟬\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2607\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{1DF3}\x{084F}73。0", %p)},	undef,	"to_unicode\(\'\\u1DF3\\u084F73\。0\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2608\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}．𝟗", %p)},	undef,	"to_unicode\(\'\\u200D．𝟗\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2609\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}．𝟗", %p)},	undef,	"to_unicode\(\'\\u200D．𝟗\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2610\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}.9", %p)},	undef,	"to_unicode\(\'\\u200D\.9\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2611\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}.9", %p)},	undef,	"to_unicode\(\'\\u200D\.9\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2612\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("9", %p)},	"9",	"to_unicode\(\'9\'\)\ \[data\/IdnaTest\.txt\:2613\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡬ\x{072F}𔾦。ᢚ\x{1039}", %p)},	undef,	"to_unicode\(\'ᡬ\\u072F𔾦\。ᢚ\\u1039\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2614\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("ᢤ５ᢐ겙。\x{0329}𐣴", %p)},	undef,	"to_unicode\(\'ᢤ５ᢐ겙\。\\u0329𐣴\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2615\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("ᢤ５ᢐ겙。\x{0329}𐣴", %p)},	undef,	"to_unicode\(\'ᢤ５ᢐ겙\。\\u0329𐣴\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2616\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("ᢤ5ᢐ겙。\x{0329}𐣴", %p)},	undef,	"to_unicode\(\'ᢤ5ᢐ겙\。\\u0329𐣴\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2617\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("ᢤ5ᢐ겙。\x{0329}𐣴", %p)},	undef,	"to_unicode\(\'ᢤ5ᢐ겙\。\\u0329𐣴\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2618\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴍ𖮿ᡎ\x{0F7C}。Ⴞ\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴍ𖮿ᡎ\\u0F7C\。Ⴞ\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2619\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴍ𖮿ᡎ\x{0F7C}。Ⴞ\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴍ𖮿ᡎ\\u0F7C\。Ⴞ\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2620\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴍ𖮿ᡎ\x{0F7C}。ⴞ\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'ⴍ𖮿ᡎ\\u0F7C\。ⴞ\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2621\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴍ𖮿ᡎ\x{0F7C}。ⴞ\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'ⴍ𖮿ᡎ\\u0F7C\。ⴞ\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2622\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋰。򒠍", %p)},	undef,	"to_unicode\(\'𐋰\。򒠍\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2623\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𚡜\x{17B4}\x{0D4D}.𐹴", %p)},	undef,	"to_unicode\(\'𚡜\\u17B4\\u0D4D\.𐹴\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2624\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{059F}Ⴋ񴹛󂑻．򰟨𝟢휪\x{05B7}", %p)},	undef,	"to_unicode\(\'\\u059FႫ񴹛󂑻．򰟨𝟢휪\\u05B7\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2625\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{059F}Ⴋ񴹛󂑻．򰟨𝟢휪\x{05B7}", %p)},	undef,	"to_unicode\(\'\\u059FႫ񴹛󂑻．򰟨𝟢휪\\u05B7\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2626\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{059F}Ⴋ񴹛󂑻.򰟨0휪\x{05B7}", %p)},	undef,	"to_unicode\(\'\\u059FႫ񴹛󂑻\.򰟨0휪\\u05B7\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2627\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{059F}Ⴋ񴹛󂑻.򰟨0휪\x{05B7}", %p)},	undef,	"to_unicode\(\'\\u059FႫ񴹛󂑻\.򰟨0휪\\u05B7\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2628\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{059F}ⴋ񴹛󂑻.򰟨0휪\x{05B7}", %p)},	undef,	"to_unicode\(\'\\u059Fⴋ񴹛󂑻\.򰟨0휪\\u05B7\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2629\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{059F}ⴋ񴹛󂑻.򰟨0휪\x{05B7}", %p)},	undef,	"to_unicode\(\'\\u059Fⴋ񴹛󂑻\.򰟨0휪\\u05B7\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2630\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{059F}ⴋ񴹛󂑻．򰟨𝟢휪\x{05B7}", %p)},	undef,	"to_unicode\(\'\\u059Fⴋ񴹛󂑻．򰟨𝟢휪\\u05B7\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2631\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{059F}ⴋ񴹛󂑻．򰟨𝟢휪\x{05B7}", %p)},	undef,	"to_unicode\(\'\\u059Fⴋ񴹛󂑻．򰟨𝟢휪\\u05B7\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2632\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐦲．𐼰𐹴", %p)},	undef,	"to_unicode\(\'𐦲．𐼰𐹴\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2633\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐦲.𐼰𐹴", %p)},	undef,	"to_unicode\(\'𐦲\.𐼰𐹴\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2634\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{09CD}₃.8\x{1B44}\x{200D}󠲑", %p)},	undef,	"to_unicode\(\'\\u09CD₃\.8\\u1B44\\u200D\󠲑\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2635\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{09CD}3.8\x{1B44}\x{200D}󠲑", %p)},	undef,	"to_unicode\(\'\\u09CD3\.8\\u1B44\\u200D\󠲑\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2636\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠝃⩷\x{0FC6}。𐤒󠁖\x{1A1B}", %p)},	undef,	"to_unicode\(\'\󠝃\⩷\\u0FC6\。𐤒\󠁖\\u1A1B\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:2637\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡟ≠\x{0E3A}򑒮｡𞯴𝩗\x{FFA0}", %p)},	undef,	"to_unicode\(\'ꡟ\≠\\u0E3A򑒮｡𞯴𝩗\\uFFA0\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2638\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡟ=\x{0338}\x{0E3A}򑒮｡𞯴𝩗\x{FFA0}", %p)},	undef,	"to_unicode\(\'ꡟ\=\\u0338\\u0E3A򑒮｡𞯴𝩗\\uFFA0\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2639\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡟ≠\x{0E3A}򑒮。𞯴𝩗\x{1160}", %p)},	undef,	"to_unicode\(\'ꡟ\≠\\u0E3A򑒮\。𞯴𝩗\\u1160\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2640\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡟ=\x{0338}\x{0E3A}򑒮。𞯴𝩗\x{1160}", %p)},	undef,	"to_unicode\(\'ꡟ\=\\u0338\\u0E3A򑒮\。𞯴𝩗\\u1160\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2641\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("鱊。\x{200C}", %p)},	undef,	"to_unicode\(\'鱊\。\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2642\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("鱊。\x{200C}", %p)},	undef,	"to_unicode\(\'鱊\。\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2643\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--rt6a.", %p)},	"鱊.",	"to_unicode\(\'xn\-\-rt6a\.\'\)\ \[data\/IdnaTest\.txt\:2644\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("鱊.", %p)},	"鱊.",	"to_unicode\(\'鱊\.\'\)\ \[data\/IdnaTest\.txt\:2645\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("8𐹽．𑚲", %p)},	undef,	"to_unicode\(\'8𐹽．𑚲\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2646\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("8𐹽.𑚲", %p)},	undef,	"to_unicode\(\'8𐹽\.𑚲\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2647\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⤴𞨡．ᡆ", %p)},	undef,	"to_unicode\(\'\⤴𞨡．ᡆ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2648\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⤴𞨡.ᡆ", %p)},	undef,	"to_unicode\(\'\⤴𞨡\.ᡆ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2649\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07CF}ᡐ4．\x{200D}", %p)},	undef,	"to_unicode\(\'\\u07CFᡐ4．\\u200D\'\)\ throws\ error\ B2\ C2\ \[data\/IdnaTest\.txt\:2650\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07CF}ᡐ4．\x{200D}", %p)},	undef,	"to_unicode\(\'\\u07CFᡐ4．\\u200D\'\)\ throws\ error\ B2\ C2\ \[data\/IdnaTest\.txt\:2651\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07CF}ᡐ4.\x{200D}", %p)},	undef,	"to_unicode\(\'\\u07CFᡐ4\.\\u200D\'\)\ throws\ error\ B2\ C2\ \[data\/IdnaTest\.txt\:2652\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07CF}ᡐ4.\x{200D}", %p)},	undef,	"to_unicode\(\'\\u07CFᡐ4\.\\u200D\'\)\ throws\ error\ B2\ C2\ \[data\/IdnaTest\.txt\:2653\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⒗\x{FE02}\x{1B6B}-.𐹧󠑍", %p)},	undef,	"to_unicode\(\'⒗\\uFE02\\u1B6B\-\.𐹧\󠑍\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2654\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("16.\x{FE02}\x{1B6B}-.𐹧󠑍", %p)},	undef,	"to_unicode\(\'16\.\\uFE02\\u1B6B\-\.𐹧\󠑍\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2655\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-｡䏛", %p)},	undef,	"to_unicode\(\'\-｡䏛\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2656\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-。䏛", %p)},	undef,	"to_unicode\(\'\-\。䏛\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2657\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}烴．\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C烴．\\u200D\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:2658\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}烴．\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C烴．\\u200D\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:2659\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}烴.\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C烴\.\\u200D\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:2660\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}烴.\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C烴\.\\u200D\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:2661\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--srx.", %p)},	"烴.",	"to_unicode\(\'xn\-\-srx\.\'\)\ \[data\/IdnaTest\.txt\:2662\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("烴.", %p)},	"烴.",	"to_unicode\(\'烴\.\'\)\ \[data\/IdnaTest\.txt\:2663\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈₠򝇵｡𐹫\x{200D}򃦻Ⴕ", %p)},	undef,	"to_unicode\(\'⒈₠򝇵｡𐹫\\u200D򃦻Ⴕ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2664\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈₠򝇵｡𐹫\x{200D}򃦻Ⴕ", %p)},	undef,	"to_unicode\(\'⒈₠򝇵｡𐹫\\u200D򃦻Ⴕ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2665\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.₠򝇵。𐹫\x{200D}򃦻Ⴕ", %p)},	undef,	"to_unicode\(\'1\.₠򝇵\。𐹫\\u200D򃦻Ⴕ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2666\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.₠򝇵。𐹫\x{200D}򃦻Ⴕ", %p)},	undef,	"to_unicode\(\'1\.₠򝇵\。𐹫\\u200D򃦻Ⴕ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2667\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.₠򝇵。𐹫\x{200D}򃦻ⴕ", %p)},	undef,	"to_unicode\(\'1\.₠򝇵\。𐹫\\u200D򃦻ⴕ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2668\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.₠򝇵。𐹫\x{200D}򃦻ⴕ", %p)},	undef,	"to_unicode\(\'1\.₠򝇵\。𐹫\\u200D򃦻ⴕ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2669\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈₠򝇵｡𐹫\x{200D}򃦻ⴕ", %p)},	undef,	"to_unicode\(\'⒈₠򝇵｡𐹫\\u200D򃦻ⴕ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2670\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈₠򝇵｡𐹫\x{200D}򃦻ⴕ", %p)},	undef,	"to_unicode\(\'⒈₠򝇵｡𐹫\\u200D򃦻ⴕ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2671\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("𐲘\x{074E}-ß｡󠅉効𐹺𥈡", %p)},	undef,	"to_unicode\(\'𐲘\\u074E\-ß｡\󠅉効𐹺𥈡\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:2672\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("𐲘\x{074E}-ß。󠅉効𐹺𥈡", %p)},	undef,	"to_unicode\(\'𐲘\\u074E\-ß\。\󠅉効𐹺𥈡\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:2673\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("𐲘\x{074E}-SS。󠅉効𐹺𥈡", %p)},	undef,	"to_unicode\(\'𐲘\\u074E\-SS\。\󠅉効𐹺𥈡\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:2674\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("𐲘\x{074E}-ss。󠅉効𐹺𥈡", %p)},	undef,	"to_unicode\(\'𐲘\\u074E\-ss\。\󠅉効𐹺𥈡\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:2675\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("𐲘\x{074E}-Ss。󠅉効𐹺𥈡", %p)},	undef,	"to_unicode\(\'𐲘\\u074E\-Ss\。\󠅉効𐹺𥈡\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:2676\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("𐲘\x{074E}-SS｡󠅉効𐹺𥈡", %p)},	undef,	"to_unicode\(\'𐲘\\u074E\-SS｡\󠅉効𐹺𥈡\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:2677\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("𐲘\x{074E}-ss｡󠅉効𐹺𥈡", %p)},	undef,	"to_unicode\(\'𐲘\\u074E\-ss｡\󠅉効𐹺𥈡\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:2678\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("𐲘\x{074E}-Ss｡󠅉効𐹺𥈡", %p)},	undef,	"to_unicode\(\'𐲘\\u074E\-Ss｡\󠅉効𐹺𥈡\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:2679\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("𑄳.🐜", %p)},	undef,	"to_unicode\(\'𑄳\.🐜\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2680\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("󠉙3𞱢｡𝟘𑍍𐷥", %p)},	undef,	"to_unicode\(\'\󠉙3𞱢｡𝟘𑍍𐷥\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2681\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠉙3𞱢。0𑍍𐷥", %p)},	undef,	"to_unicode\(\'\󠉙3𞱢\。0𑍍𐷥\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2682\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0679}６\x{A8EE}ᡮ。\x{0592}", %p)},	undef,	"to_unicode\(\'\\u0679６\\uA8EEᡮ\。\\u0592\'\)\ throws\ error\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:2683\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0679}6\x{A8EE}ᡮ。\x{0592}", %p)},	undef,	"to_unicode\(\'\\u06796\\uA8EEᡮ\。\\u0592\'\)\ throws\ error\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:2684\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𐹾-𠥔Ⴂ。򝾣\x{200D}", %p)},	undef,	"to_unicode\(\'𐹾\-𠥔Ⴂ\。򝾣\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2685\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹾-𠥔Ⴂ。򝾣\x{200D}", %p)},	undef,	"to_unicode\(\'𐹾\-𠥔Ⴂ\。򝾣\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2686\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹾-𠥔ⴂ。򝾣\x{200D}", %p)},	undef,	"to_unicode\(\'𐹾\-𠥔ⴂ\。򝾣\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2687\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹾-𠥔ⴂ。򝾣\x{200D}", %p)},	undef,	"to_unicode\(\'𐹾\-𠥔ⴂ\。򝾣\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2688\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．\x{06AE}５≯ß", %p)},	undef,	"to_unicode\(\'⾆．\\u06AE５\≯ß\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2689\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．\x{06AE}５>\x{0338}ß", %p)},	undef,	"to_unicode\(\'⾆．\\u06AE５\>\\u0338ß\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2690\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.\x{06AE}5≯ß", %p)},	undef,	"to_unicode\(\'舌\.\\u06AE5\≯ß\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2691\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.\x{06AE}5>\x{0338}ß", %p)},	undef,	"to_unicode\(\'舌\.\\u06AE5\>\\u0338ß\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2692\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.\x{06AE}5>\x{0338}SS", %p)},	undef,	"to_unicode\(\'舌\.\\u06AE5\>\\u0338SS\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2693\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.\x{06AE}5≯SS", %p)},	undef,	"to_unicode\(\'舌\.\\u06AE5\≯SS\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2694\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.\x{06AE}5≯ss", %p)},	undef,	"to_unicode\(\'舌\.\\u06AE5\≯ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2695\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.\x{06AE}5>\x{0338}ss", %p)},	undef,	"to_unicode\(\'舌\.\\u06AE5\>\\u0338ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2696\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.\x{06AE}5>\x{0338}Ss", %p)},	undef,	"to_unicode\(\'舌\.\\u06AE5\>\\u0338Ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2697\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.\x{06AE}5≯Ss", %p)},	undef,	"to_unicode\(\'舌\.\\u06AE5\≯Ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2698\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．\x{06AE}５>\x{0338}SS", %p)},	undef,	"to_unicode\(\'⾆．\\u06AE５\>\\u0338SS\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2699\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．\x{06AE}５≯SS", %p)},	undef,	"to_unicode\(\'⾆．\\u06AE５\≯SS\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2700\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．\x{06AE}５≯ss", %p)},	undef,	"to_unicode\(\'⾆．\\u06AE５\≯ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2701\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．\x{06AE}５>\x{0338}ss", %p)},	undef,	"to_unicode\(\'⾆．\\u06AE５\>\\u0338ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2702\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．\x{06AE}５>\x{0338}Ss", %p)},	undef,	"to_unicode\(\'⾆．\\u06AE５\>\\u0338Ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2703\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．\x{06AE}５≯Ss", %p)},	undef,	"to_unicode\(\'⾆．\\u06AE５\≯Ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2704\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9C0}8\x{200D}．򉈡ꡂ", %p)},	undef,	"to_unicode\(\'\\uA9C08\\u200D．򉈡ꡂ\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2705\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9C0}8\x{200D}．򉈡ꡂ", %p)},	undef,	"to_unicode\(\'\\uA9C08\\u200D．򉈡ꡂ\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2706\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9C0}8\x{200D}.򉈡ꡂ", %p)},	undef,	"to_unicode\(\'\\uA9C08\\u200D\.򉈡ꡂ\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2707\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9C0}8\x{200D}.򉈡ꡂ", %p)},	undef,	"to_unicode\(\'\\uA9C08\\u200D\.򉈡ꡂ\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2708\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󡆸\x{1A69}≮񀹄．񁆗⁷\x{0355}𐫎", %p)},	undef,	"to_unicode\(\'󡆸\\u1A69\≮񀹄．񁆗⁷\\u0355𐫎\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2709\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󡆸\x{1A69}<\x{0338}񀹄．񁆗⁷\x{0355}𐫎", %p)},	undef,	"to_unicode\(\'󡆸\\u1A69\<\\u0338񀹄．񁆗⁷\\u0355𐫎\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2710\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󡆸\x{1A69}≮񀹄.񁆗7\x{0355}𐫎", %p)},	undef,	"to_unicode\(\'󡆸\\u1A69\≮񀹄\.񁆗7\\u0355𐫎\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2711\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󡆸\x{1A69}<\x{0338}񀹄.񁆗7\x{0355}𐫎", %p)},	undef,	"to_unicode\(\'󡆸\\u1A69\<\\u0338񀹄\.񁆗7\\u0355𐫎\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2712\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{0842}.ς", %p)},	"\x{0842}.ς",	"to_unicode\(\'\\u0842\.ς\'\)\ \[data\/IdnaTest\.txt\:2713\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{0842}.ς", %p)},	"\x{0842}.ς",	"to_unicode\(\'\\u0842\.ς\'\)\ \[data\/IdnaTest\.txt\:2714\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{0842}.Σ", %p)},	"\x{0842}.σ",	"to_unicode\(\'\\u0842\.Σ\'\)\ \[data\/IdnaTest\.txt\:2715\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{0842}.σ", %p)},	"\x{0842}.σ",	"to_unicode\(\'\\u0842\.σ\'\)\ \[data\/IdnaTest\.txt\:2716\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("xn--0vb.xn--4xa", %p)},	"\x{0842}.σ",	"to_unicode\(\'xn\-\-0vb\.xn\-\-4xa\'\)\ \[data\/IdnaTest\.txt\:2717\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("xn--0vb.xn--3xa", %p)},	"\x{0842}.ς",	"to_unicode\(\'xn\-\-0vb\.xn\-\-3xa\'\)\ \[data\/IdnaTest\.txt\:2718\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}Ⴚ｡ς", %p)},	undef,	"to_unicode\(\'\\u200CႺ｡ς\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2719\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴚ｡ς", %p)},	undef,	"to_unicode\(\'\\u200CႺ｡ς\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2720\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴚ。ς", %p)},	undef,	"to_unicode\(\'\\u200CႺ\。ς\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2721\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴚ。ς", %p)},	undef,	"to_unicode\(\'\\u200CႺ\。ς\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2722\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}ⴚ。ς", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ\。ς\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2723\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}ⴚ。ς", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ\。ς\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2724\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}Ⴚ。Σ", %p)},	undef,	"to_unicode\(\'\\u200CႺ\。Σ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2725\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴚ。Σ", %p)},	undef,	"to_unicode\(\'\\u200CႺ\。Σ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2726\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}ⴚ。σ", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ\。σ\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2727\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}ⴚ。σ", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ\。σ\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2728\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--ilj.xn--4xa", %p)},	"ⴚ.σ",	"to_unicode\(\'xn\-\-ilj\.xn\-\-4xa\'\)\ \[data\/IdnaTest\.txt\:2729\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴚ.σ", %p)},	"ⴚ.σ",	"to_unicode\(\'ⴚ\.σ\'\)\ \[data\/IdnaTest\.txt\:2730\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴚ.Σ", %p)},	undef,	"to_unicode\(\'Ⴚ\.Σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2731\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴚ.ς", %p)},	"ⴚ.ς",	"to_unicode\(\'ⴚ\.ς\'\)\ \[data\/IdnaTest\.txt\:2732\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴚ.ς", %p)},	"ⴚ.ς",	"to_unicode\(\'ⴚ\.ς\'\)\ \[data\/IdnaTest\.txt\:2733\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴚ.ς", %p)},	undef,	"to_unicode\(\'Ⴚ\.ς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2734\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--ilj.xn--3xa", %p)},	"ⴚ.ς",	"to_unicode\(\'xn\-\-ilj\.xn\-\-3xa\'\)\ \[data\/IdnaTest\.txt\:2735\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴚ.σ", %p)},	undef,	"to_unicode\(\'Ⴚ\.σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2736\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}ⴚ｡ς", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ｡ς\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2737\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}ⴚ｡ς", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ｡ς\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2738\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}Ⴚ｡Σ", %p)},	undef,	"to_unicode\(\'\\u200CႺ｡Σ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2739\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴚ｡Σ", %p)},	undef,	"to_unicode\(\'\\u200CႺ｡Σ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2740\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}ⴚ｡σ", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ｡σ\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2741\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}ⴚ｡σ", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ｡σ\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2742\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ᡆ．𐹹", %p)},	undef,	"to_unicode\(\'ᡆ．𐹹\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2743\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ᡆ.𐹹", %p)},	undef,	"to_unicode\(\'ᡆ\.𐹹\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2744\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{200D}⾕。\x{200C}\x{0E38}\x{AAF6}ᠳ", %p)},	undef,	"to_unicode\(\'\\u200D⾕\。\\u200C\\u0E38\\uAAF6ᠳ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:2745\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{200D}⾕。\x{200C}\x{0E38}\x{AAF6}ᠳ", %p)},	undef,	"to_unicode\(\'\\u200D⾕\。\\u200C\\u0E38\\uAAF6ᠳ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:2746\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{200D}⾕。\x{200C}\x{AAF6}\x{0E38}ᠳ", %p)},	undef,	"to_unicode\(\'\\u200D⾕\。\\u200C\\uAAF6\\u0E38ᠳ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:2747\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{200D}⾕。\x{200C}\x{AAF6}\x{0E38}ᠳ", %p)},	undef,	"to_unicode\(\'\\u200D⾕\。\\u200C\\uAAF6\\u0E38ᠳ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:2748\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{200D}谷。\x{200C}\x{AAF6}\x{0E38}ᠳ", %p)},	undef,	"to_unicode\(\'\\u200D谷\。\\u200C\\uAAF6\\u0E38ᠳ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:2749\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{200D}谷。\x{200C}\x{AAF6}\x{0E38}ᠳ", %p)},	undef,	"to_unicode\(\'\\u200D谷\。\\u200C\\uAAF6\\u0E38ᠳ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:2750\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{0683}-뉔．ꡟ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0683\-뉔．ꡟ\\u200C\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:2751\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{0683}-뉔．ꡟ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0683\-뉔．ꡟ\\u200C\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:2752\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{0683}-뉔．ꡟ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0683\-뉔．ꡟ\\u200C\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:2753\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{0683}-뉔．ꡟ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0683\-뉔．ꡟ\\u200C\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:2754\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{0683}-뉔.ꡟ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0683\-뉔\.ꡟ\\u200C\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:2755\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{0683}-뉔.ꡟ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0683\-뉔\.ꡟ\\u200C\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:2756\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{0683}-뉔.ꡟ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0683\-뉔\.ꡟ\\u200C\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:2757\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{0683}-뉔.ꡟ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0683\-뉔\.ꡟ\\u200C\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:2758\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𻠅５ᦛς.\x{1BF3}\x{067D}\x{0AC2}𖬲", %p)},	undef,	"to_unicode\(\'𻠅５ᦛς\.\\u1BF3\\u067D\\u0AC2𖬲\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2759\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𻠅5ᦛς.\x{1BF3}\x{067D}\x{0AC2}𖬲", %p)},	undef,	"to_unicode\(\'𻠅5ᦛς\.\\u1BF3\\u067D\\u0AC2𖬲\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2760\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𻠅5ᦛΣ.\x{1BF3}\x{067D}\x{0AC2}𖬲", %p)},	undef,	"to_unicode\(\'𻠅5ᦛΣ\.\\u1BF3\\u067D\\u0AC2𖬲\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2761\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𻠅5ᦛσ.\x{1BF3}\x{067D}\x{0AC2}𖬲", %p)},	undef,	"to_unicode\(\'𻠅5ᦛσ\.\\u1BF3\\u067D\\u0AC2𖬲\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2762\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𻠅５ᦛΣ.\x{1BF3}\x{067D}\x{0AC2}𖬲", %p)},	undef,	"to_unicode\(\'𻠅５ᦛΣ\.\\u1BF3\\u067D\\u0AC2𖬲\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2763\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𻠅５ᦛσ.\x{1BF3}\x{067D}\x{0AC2}𖬲", %p)},	undef,	"to_unicode\(\'𻠅５ᦛσ\.\\u1BF3\\u067D\\u0AC2𖬲\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2764\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("淽。\x{0852}", %p)},	"淽.\x{0852}",	"to_unicode\(\'淽\。\\u0852\'\)\ \[data\/IdnaTest\.txt\:2765\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("xn--34w.xn--hwb", %p)},	"淽.\x{0852}",	"to_unicode\(\'xn\-\-34w\.xn\-\-hwb\'\)\ \[data\/IdnaTest\.txt\:2766\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("淽.\x{0852}", %p)},	"淽.\x{0852}",	"to_unicode\(\'淽\.\\u0852\'\)\ \[data\/IdnaTest\.txt\:2767\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹳\x{05BC}。-", %p)},	undef,	"to_unicode\(\'𐹳\\u05BC\。\-\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:2768\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("򟓒Ⴓ󠒾｡\x{1C2F}", %p)},	undef,	"to_unicode\(\'򟓒Ⴓ\󠒾｡\\u1C2F\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2769\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򟓒Ⴓ󠒾。\x{1C2F}", %p)},	undef,	"to_unicode\(\'򟓒Ⴓ\󠒾\。\\u1C2F\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2770\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򟓒ⴓ󠒾。\x{1C2F}", %p)},	undef,	"to_unicode\(\'򟓒ⴓ\󠒾\。\\u1C2F\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2771\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򟓒ⴓ󠒾｡\x{1C2F}", %p)},	undef,	"to_unicode\(\'򟓒ⴓ\󠒾｡\\u1C2F\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2772\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{062E}Ⴇ｡ßႣ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u062EႧ｡ßႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2773\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{062E}Ⴇ｡ßႣ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u062EႧ｡ßႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2774\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{062E}Ⴇ。ßႣ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u062EႧ\。ßႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2775\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{062E}Ⴇ。ßႣ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u062EႧ\。ßႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2776\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{062E}ⴇ。ßⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u062Eⴇ\。ßⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2777\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{062E}ⴇ。ßⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u062Eⴇ\。ßⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2778\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{062E}Ⴇ。SSႣ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u062EႧ\。SSႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2779\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{062E}Ⴇ。SSႣ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u062EႧ\。SSႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2780\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{062E}ⴇ。ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u062Eⴇ\。ssⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2781\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{062E}ⴇ。ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u062Eⴇ\。ssⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2782\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{062E}Ⴇ。Ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u062EႧ\。Ssⴃ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2783\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{062E}Ⴇ。Ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u062EႧ\。Ssⴃ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2784\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{062E}ⴇ｡ßⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u062Eⴇ｡ßⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2785\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{062E}ⴇ｡ßⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u062Eⴇ｡ßⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2786\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{062E}Ⴇ｡SSႣ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u062EႧ｡SSႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2787\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{062E}Ⴇ｡SSႣ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u062EႧ｡SSႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2788\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{062E}ⴇ｡ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u062Eⴇ｡ssⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2789\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{062E}ⴇ｡ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u062Eⴇ｡ssⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2790\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{062E}Ⴇ｡Ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u062EႧ｡Ssⴃ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2791\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{0668}\x{062E}Ⴇ｡Ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\u0668\\u062EႧ｡Ssⴃ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2792\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󤚠｡𞷿", %p)},	undef,	"to_unicode\(\'󤚠｡𞷿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2793\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󤚠。𞷿", %p)},	undef,	"to_unicode\(\'󤚠\。𞷿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2794\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("󠅤\x{200D}｡\x{A953}\x{A8EE}", %p)},	undef,	"to_unicode\(\'\󠅤\\u200D｡\\uA953\\uA8EE\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2795\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("󠅤\x{200D}｡\x{A953}\x{A8EE}", %p)},	undef,	"to_unicode\(\'\󠅤\\u200D｡\\uA953\\uA8EE\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2796\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("󠅤\x{200D}。\x{A953}\x{A8EE}", %p)},	undef,	"to_unicode\(\'\󠅤\\u200D\。\\uA953\\uA8EE\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2797\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("󠅤\x{200D}。\x{A953}\x{A8EE}", %p)},	undef,	"to_unicode\(\'\󠅤\\u200D\。\\uA953\\uA8EE\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2798\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-≠\x{0755}．ꡝ\x{084C}≮𿹕", %p)},	undef,	"to_unicode\(\'\-\≠\\u0755．ꡝ\\u084C\≮𿹕\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:2799\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-=\x{0338}\x{0755}．ꡝ\x{084C}<\x{0338}𿹕", %p)},	undef,	"to_unicode\(\'\-\=\\u0338\\u0755．ꡝ\\u084C\<\\u0338𿹕\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:2800\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-≠\x{0755}.ꡝ\x{084C}≮𿹕", %p)},	undef,	"to_unicode\(\'\-\≠\\u0755\.ꡝ\\u084C\≮𿹕\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:2801\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-=\x{0338}\x{0755}.ꡝ\x{084C}<\x{0338}𿹕", %p)},	undef,	"to_unicode\(\'\-\=\\u0338\\u0755\.ꡝ\\u084C\<\\u0338𿹕\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:2802\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠃐≯\x{FC69}𞠷．񯫡≮𑖿ꡨ", %p)},	undef,	"to_unicode\(\'\󠃐\≯\\uFC69𞠷．񯫡\≮𑖿ꡨ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2803\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠃐>\x{0338}\x{FC69}𞠷．񯫡<\x{0338}𑖿ꡨ", %p)},	undef,	"to_unicode\(\'\󠃐\>\\u0338\\uFC69𞠷．񯫡\<\\u0338𑖿ꡨ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2804\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠃐≯\x{0626}\x{064A}𞠷.񯫡≮𑖿ꡨ", %p)},	undef,	"to_unicode\(\'\󠃐\≯\\u0626\\u064A𞠷\.񯫡\≮𑖿ꡨ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2805\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠃐>\x{0338}\x{064A}\x{0654}\x{064A}𞠷.񯫡<\x{0338}𑖿ꡨ", %p)},	undef,	"to_unicode\(\'\󠃐\>\\u0338\\u064A\\u0654\\u064A𞠷\.񯫡\<\\u0338𑖿ꡨ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2806\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠񠄐.𐹧𑈵-𞥋", %p)},	undef,	"to_unicode\(\'\≠񠄐\.𐹧𑈵\-𞥋\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2807\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}񠄐.𐹧𑈵-𞥋", %p)},	undef,	"to_unicode\(\'\=\\u0338񠄐\.𐹧𑈵\-𞥋\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2808\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠆇\x{1CD7}≠｡\x{06DD}𐋤", %p)},	undef,	"to_unicode\(\'\󠆇\\u1CD7\≠｡\\u06DD𐋤\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2809\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠆇\x{1CD7}=\x{0338}｡\x{06DD}𐋤", %p)},	undef,	"to_unicode\(\'\󠆇\\u1CD7\=\\u0338｡\\u06DD𐋤\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2810\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠆇\x{1CD7}≠。\x{06DD}𐋤", %p)},	undef,	"to_unicode\(\'\󠆇\\u1CD7\≠\。\\u06DD𐋤\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2811\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠆇\x{1CD7}=\x{0338}。\x{06DD}𐋤", %p)},	undef,	"to_unicode\(\'\󠆇\\u1CD7\=\\u0338\。\\u06DD𐋤\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2812\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß򓍟𺖭｡\x{07AF}󠢂ß", %p)},	undef,	"to_unicode\(\'ß򓍟𺖭｡\\u07AF\󠢂ß\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2813\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß򓍟𺖭。\x{07AF}󠢂ß", %p)},	undef,	"to_unicode\(\'ß򓍟𺖭\。\\u07AF\󠢂ß\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2814\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS򓍟𺖭。\x{07AF}󠢂SS", %p)},	undef,	"to_unicode\(\'SS򓍟𺖭\。\\u07AF\󠢂SS\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2815\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss򓍟𺖭。\x{07AF}󠢂ss", %p)},	undef,	"to_unicode\(\'ss򓍟𺖭\。\\u07AF\󠢂ss\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2816\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss򓍟𺖭。\x{07AF}󠢂Ss", %p)},	undef,	"to_unicode\(\'Ss򓍟𺖭\。\\u07AF\󠢂Ss\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2817\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS򓍟𺖭｡\x{07AF}󠢂SS", %p)},	undef,	"to_unicode\(\'SS򓍟𺖭｡\\u07AF\󠢂SS\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2818\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss򓍟𺖭｡\x{07AF}󠢂ss", %p)},	undef,	"to_unicode\(\'ss򓍟𺖭｡\\u07AF\󠢂ss\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2819\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss򓍟𺖭｡\x{07AF}󠢂Ss", %p)},	undef,	"to_unicode\(\'Ss򓍟𺖭｡\\u07AF\󠢂Ss\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2820\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D\。\\u200C\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:2821\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D\。\\u200C\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:2822\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1713}𐱍\x{200D}.𝩔𞡿񴥼", %p)},	undef,	"to_unicode\(\'\\u1713𐱍\\u200D\.𝩔𞡿񴥼\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2823\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1713}𐱍\x{200D}.𝩔𞡿񴥼", %p)},	undef,	"to_unicode\(\'\\u1713𐱍\\u200D\.𝩔𞡿񴥼\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2824\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{FE98}\x{200C}临。ᢗ򁣒ⶏ\x{066B}", %p)},	undef,	"to_unicode\(\'\\u200C\\uFE98\\u200C临\。ᢗ򁣒ⶏ\\u066B\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2825\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{FE98}\x{200C}临。ᢗ򁣒ⶏ\x{066B}", %p)},	undef,	"to_unicode\(\'\\u200C\\uFE98\\u200C临\。ᢗ򁣒ⶏ\\u066B\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2826\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{062A}\x{200C}临。ᢗ򁣒ⶏ\x{066B}", %p)},	undef,	"to_unicode\(\'\\u200C\\u062A\\u200C临\。ᢗ򁣒ⶏ\\u066B\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2827\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{062A}\x{200C}临。ᢗ򁣒ⶏ\x{066B}", %p)},	undef,	"to_unicode\(\'\\u200C\\u062A\\u200C临\。ᢗ򁣒ⶏ\\u066B\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2828\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠿴．\x{0363}", %p)},	undef,	"to_unicode\(\'\󠿴．\\u0363\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2829\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠿴.\x{0363}", %p)},	undef,	"to_unicode\(\'\󠿴\.\\u0363\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2830\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{07EA}𑘿．𑍍", %p)},	undef,	"to_unicode\(\'\\u07EA𑘿．𑍍\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2831\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{07EA}𑘿.𑍍", %p)},	undef,	"to_unicode\(\'\\u07EA𑘿\.𑍍\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2832\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𑖼򬆟멹。⒛⧪", %p)},	undef,	"to_unicode\(\'𑖼򬆟멹\。⒛\⧪\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2833\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑖼򬆟멹。⒛⧪", %p)},	undef,	"to_unicode\(\'𑖼򬆟멹\。⒛\⧪\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2834\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑖼򬆟멹。20.⧪", %p)},	undef,	"to_unicode\(\'𑖼򬆟멹\。20\.\⧪\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2835\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑖼򬆟멹。20.⧪", %p)},	undef,	"to_unicode\(\'𑖼򬆟멹\。20\.\⧪\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2836\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴅ󙐭릖⊨.\x{0645}𐹫⒊", %p)},	undef,	"to_unicode\(\'Ⴅ󙐭릖\⊨\.\\u0645𐹫⒊\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2837\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴅ󙐭릖⊨.\x{0645}𐹫⒊", %p)},	undef,	"to_unicode\(\'Ⴅ󙐭릖\⊨\.\\u0645𐹫⒊\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2838\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴅ󙐭릖⊨.\x{0645}𐹫3.", %p)},	undef,	"to_unicode\(\'Ⴅ󙐭릖\⊨\.\\u0645𐹫3\.\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2839\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴅ󙐭릖⊨.\x{0645}𐹫3.", %p)},	undef,	"to_unicode\(\'Ⴅ󙐭릖\⊨\.\\u0645𐹫3\.\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2840\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴅ󙐭릖⊨.\x{0645}𐹫3.", %p)},	undef,	"to_unicode\(\'ⴅ󙐭릖\⊨\.\\u0645𐹫3\.\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2841\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴅ󙐭릖⊨.\x{0645}𐹫3.", %p)},	undef,	"to_unicode\(\'ⴅ󙐭릖\⊨\.\\u0645𐹫3\.\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2842\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴅ󙐭릖⊨.\x{0645}𐹫⒊", %p)},	undef,	"to_unicode\(\'ⴅ󙐭릖\⊨\.\\u0645𐹫⒊\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2843\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴅ󙐭릖⊨.\x{0645}𐹫⒊", %p)},	undef,	"to_unicode\(\'ⴅ󙐭릖\⊨\.\\u0645𐹫⒊\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2844\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}｡︒", %p)},	undef,	"to_unicode\(\'\\u200C｡︒\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2845\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}｡︒", %p)},	undef,	"to_unicode\(\'\\u200C｡︒\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2846\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。。", %p)},	undef,	"to_unicode\(\'\\u200C\。\。\'\)\ throws\ error\ C1\ A4_2\ \[data\/IdnaTest\.txt\:2847\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。。", %p)},	undef,	"to_unicode\(\'\\u200C\。\。\'\)\ throws\ error\ C1\ A4_2\ \[data\/IdnaTest\.txt\:2848\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{075F}．₄", %p)},	undef,	"to_unicode\(\'\≯\\u075F．₄\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2849\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{075F}．₄", %p)},	undef,	"to_unicode\(\'\>\\u0338\\u075F．₄\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2850\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{075F}.4", %p)},	undef,	"to_unicode\(\'\≯\\u075F\.4\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2851\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{075F}.4", %p)},	undef,	"to_unicode\(\'\>\\u0338\\u075F\.4\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2852\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡘ-𝟹.ß-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡘ\-𝟹\.ß\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2853\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡘ-𝟹.ß-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡘ\-𝟹\.ß\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2854\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡘ-3.ß-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡘ\-3\.ß\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2855\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡘ-3.ß-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡘ\-3\.ß\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2856\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡘ-3.SS-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡘ\-3\.SS\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2857\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡘ-3.SS-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡘ\-3\.SS\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2858\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡘ-3.ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡘ\-3\.ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2859\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡘ-3.ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡘ\-3\.ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2860\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡘ-3.Ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡘ\-3\.Ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2861\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡘ-3.Ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡘ\-3\.Ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2862\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡘ-𝟹.SS-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡘ\-𝟹\.SS\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2863\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡘ-𝟹.SS-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡘ\-𝟹\.SS\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2864\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡘ-𝟹.ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡘ\-𝟹\.ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2865\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡘ-𝟹.ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡘ\-𝟹\.ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2866\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡘ-𝟹.Ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡘ\-𝟹\.Ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2867\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡘ-𝟹.Ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'ᡘ\-𝟹\.Ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2868\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐰠𝟦\x{0626}󎅯｡Ӏ", %p)},	undef,	"to_unicode\(\'𐰠𝟦\\u0626󎅯｡Ӏ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2869\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐰠𝟦\x{064A}\x{0654}󎅯｡Ӏ", %p)},	undef,	"to_unicode\(\'𐰠𝟦\\u064A\\u0654󎅯｡Ӏ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2870\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐰠4\x{0626}󎅯。Ӏ", %p)},	undef,	"to_unicode\(\'𐰠4\\u0626󎅯\。Ӏ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2871\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐰠4\x{064A}\x{0654}󎅯。Ӏ", %p)},	undef,	"to_unicode\(\'𐰠4\\u064A\\u0654󎅯\。Ӏ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2872\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐰠4\x{064A}\x{0654}󎅯。ӏ", %p)},	undef,	"to_unicode\(\'𐰠4\\u064A\\u0654󎅯\。ӏ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2873\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐰠4\x{0626}󎅯。ӏ", %p)},	undef,	"to_unicode\(\'𐰠4\\u0626󎅯\。ӏ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2874\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐰠𝟦\x{064A}\x{0654}󎅯｡ӏ", %p)},	undef,	"to_unicode\(\'𐰠𝟦\\u064A\\u0654󎅯｡ӏ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2875\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐰠𝟦\x{0626}󎅯｡ӏ", %p)},	undef,	"to_unicode\(\'𐰠𝟦\\u0626󎅯｡ӏ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2876\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-.𐹪𞦭\x{0F91}󠥢", %p)},	undef,	"to_unicode\(\'\-\.𐹪𞦭\\u0F91\󠥢\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2877\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򷈞ᢕ。󠀬󠢬", %p)},	undef,	"to_unicode\(\'򷈞ᢕ\。\󠀬\󠢬\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2878\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠ႷꡩႫ｡\x{D907}󠀢\x{0671}觴", %p)},	undef,	"to_unicode\(\'\≠ႷꡩႫ｡\\uD907\󠀢\\u0671觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2879\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}ႷꡩႫ｡\x{D907}󠀢\x{0671}觴", %p)},	undef,	"to_unicode\(\'\=\\u0338ႷꡩႫ｡\\uD907\󠀢\\u0671觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2880\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠ႷꡩႫ。\x{D907}󠀢\x{0671}觴", %p)},	undef,	"to_unicode\(\'\≠ႷꡩႫ\。\\uD907\󠀢\\u0671觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2881\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}ႷꡩႫ。\x{D907}󠀢\x{0671}觴", %p)},	undef,	"to_unicode\(\'\=\\u0338ႷꡩႫ\。\\uD907\󠀢\\u0671觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2882\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}ⴗꡩⴋ。\x{D907}󠀢\x{0671}觴", %p)},	undef,	"to_unicode\(\'\=\\u0338ⴗꡩⴋ\。\\uD907\󠀢\\u0671觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2883\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠ⴗꡩⴋ。\x{D907}󠀢\x{0671}觴", %p)},	undef,	"to_unicode\(\'\≠ⴗꡩⴋ\。\\uD907\󠀢\\u0671觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2884\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠Ⴗꡩⴋ。\x{D907}󠀢\x{0671}觴", %p)},	undef,	"to_unicode\(\'\≠Ⴗꡩⴋ\。\\uD907\󠀢\\u0671觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2885\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}Ⴗꡩⴋ。\x{D907}󠀢\x{0671}觴", %p)},	undef,	"to_unicode\(\'\=\\u0338Ⴗꡩⴋ\。\\uD907\󠀢\\u0671觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2886\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}ⴗꡩⴋ｡\x{D907}󠀢\x{0671}觴", %p)},	undef,	"to_unicode\(\'\=\\u0338ⴗꡩⴋ｡\\uD907\󠀢\\u0671觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2887\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠ⴗꡩⴋ｡\x{D907}󠀢\x{0671}觴", %p)},	undef,	"to_unicode\(\'\≠ⴗꡩⴋ｡\\uD907\󠀢\\u0671觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2888\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠Ⴗꡩⴋ｡\x{D907}󠀢\x{0671}觴", %p)},	undef,	"to_unicode\(\'\≠Ⴗꡩⴋ｡\\uD907\󠀢\\u0671觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2889\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}Ⴗꡩⴋ｡\x{D907}󠀢\x{0671}觴", %p)},	undef,	"to_unicode\(\'\=\\u0338Ⴗꡩⴋ｡\\uD907\󠀢\\u0671觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2890\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹶.\x{FD12}", %p)},	undef,	"to_unicode\(\'𐹶\.\\uFD12\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2891\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹶.\x{0637}\x{064A}", %p)},	undef,	"to_unicode\(\'𐹶\.\\u0637\\u064A\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2892\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{1714}𝟯｡\x{200D}񹒧𐹡\x{A953}", %p)},	undef,	"to_unicode\(\'\\u1714𝟯｡\\u200D񹒧𐹡\\uA953\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2893\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1714}𝟯｡\x{200D}񹒧𐹡\x{A953}", %p)},	undef,	"to_unicode\(\'\\u1714𝟯｡\\u200D񹒧𐹡\\uA953\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2894\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1714}3。\x{200D}񹒧𐹡\x{A953}", %p)},	undef,	"to_unicode\(\'\\u17143\。\\u200D񹒧𐹡\\uA953\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2895\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1714}3。\x{200D}񹒧𐹡\x{A953}", %p)},	undef,	"to_unicode\(\'\\u17143\。\\u200D񹒧𐹡\\uA953\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2896\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򷠯4𱂩.≯𐹡\x{1932}󠇶", %p)},	undef,	"to_unicode\(\'򷠯4𱂩\.\≯𐹡\\u1932\󠇶\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2897\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򷠯4𱂩.>\x{0338}𐹡\x{1932}󠇶", %p)},	undef,	"to_unicode\(\'򷠯4𱂩\.\>\\u0338𐹡\\u1932\󠇶\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2898\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񵲚𝟯。⒈\x{A94A}𝟚񰩭", %p)},	undef,	"to_unicode\(\'񵲚𝟯\。⒈\\uA94A𝟚񰩭\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2899\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񵲚3。1.\x{A94A}2񰩭", %p)},	undef,	"to_unicode\(\'񵲚3\。1\.\\uA94A2񰩭\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2900\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}₅⒈。≯𝟴\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D₅⒈\。\≯𝟴\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2901\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}₅⒈。≯𝟴\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D₅⒈\。\≯𝟴\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2902\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}₅⒈。>\x{0338}𝟴\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D₅⒈\。\>\\u0338𝟴\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2903\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}₅⒈。>\x{0338}𝟴\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D₅⒈\。\>\\u0338𝟴\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2904\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}51.。≯8\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D51\.\。\≯8\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ A4_2\ \[data\/IdnaTest\.txt\:2905\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}51.。≯8\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D51\.\。\≯8\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ A4_2\ \[data\/IdnaTest\.txt\:2906\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}51.。>\x{0338}8\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D51\.\。\>\\u03388\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ A4_2\ \[data\/IdnaTest\.txt\:2907\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}51.。>\x{0338}8\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D51\.\。\>\\u03388\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ A4_2\ \[data\/IdnaTest\.txt\:2908\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06BE}𐮍\x{1B37}．𳵷ᠺ≠\x{200C}", %p)},	undef,	"to_unicode\(\'\\u06BE𐮍\\u1B37．𳵷ᠺ\≠\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2909\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06BE}𐮍\x{1B37}．𳵷ᠺ≠\x{200C}", %p)},	undef,	"to_unicode\(\'\\u06BE𐮍\\u1B37．𳵷ᠺ\≠\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2910\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06BE}𐮍\x{1B37}．𳵷ᠺ=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u06BE𐮍\\u1B37．𳵷ᠺ\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2911\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06BE}𐮍\x{1B37}．𳵷ᠺ=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u06BE𐮍\\u1B37．𳵷ᠺ\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2912\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06BE}𐮍\x{1B37}.𳵷ᠺ≠\x{200C}", %p)},	undef,	"to_unicode\(\'\\u06BE𐮍\\u1B37\.𳵷ᠺ\≠\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2913\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06BE}𐮍\x{1B37}.𳵷ᠺ≠\x{200C}", %p)},	undef,	"to_unicode\(\'\\u06BE𐮍\\u1B37\.𳵷ᠺ\≠\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2914\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06BE}𐮍\x{1B37}.𳵷ᠺ=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u06BE𐮍\\u1B37\.𳵷ᠺ\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2915\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06BE}𐮍\x{1B37}.𳵷ᠺ=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u06BE𐮍\\u1B37\.𳵷ᠺ\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2916\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{073F}｡𺘼𐹪", %p)},	undef,	"to_unicode\(\'\\u073F｡𺘼𐹪\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2917\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{073F}。𺘼𐹪", %p)},	undef,	"to_unicode\(\'\\u073F\。𺘼𐹪\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2918\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𝟥\x{0669}。\x{AAB3}", %p)},	undef,	"to_unicode\(\'𝟥\\u0669\。\\uAAB3\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2919\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("3\x{0669}。\x{AAB3}", %p)},	undef,	"to_unicode\(\'3\\u0669\。\\uAAB3\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2920\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ᢖ\x{066B}𐹸.\x{063E}긷", %p)},	undef,	"to_unicode\(\'ᢖ\\u066B𐹸\.\\u063E긷\'\)\ throws\ error\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:2921\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ᢖ\x{066B}𐹸.\x{063E}긷", %p)},	undef,	"to_unicode\(\'ᢖ\\u066B𐹸\.\\u063E긷\'\)\ throws\ error\ B5\ B6\ B2\ B3\ \[data\/IdnaTest\.txt\:2922\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("︒Ↄ\x{1DC7}򍐳．Ⴗ𞢍", %p)},	undef,	"to_unicode\(\'︒Ↄ\\u1DC7򍐳．Ⴗ𞢍\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2923\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。Ↄ\x{1DC7}򍐳.Ⴗ𞢍", %p)},	undef,	"to_unicode\(\'\。Ↄ\\u1DC7򍐳\.Ⴗ𞢍\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2924\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。ↄ\x{1DC7}򍐳.ⴗ𞢍", %p)},	undef,	"to_unicode\(\'\。ↄ\\u1DC7򍐳\.ⴗ𞢍\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2925\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒ↄ\x{1DC7}򍐳．ⴗ𞢍", %p)},	undef,	"to_unicode\(\'︒ↄ\\u1DC7򍐳．ⴗ𞢍\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2926\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐹵.\x{1AB2}", %p)},	undef,	"to_unicode\(\'𐹵\.\\u1AB2\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2927\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ς≯｡\x{06DD}", %p)},	undef,	"to_unicode\(\'ς\≯｡\\u06DD\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2928\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς>\x{0338}｡\x{06DD}", %p)},	undef,	"to_unicode\(\'ς\>\\u0338｡\\u06DD\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2929\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς≯。\x{06DD}", %p)},	undef,	"to_unicode\(\'ς\≯\。\\u06DD\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2930\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς>\x{0338}。\x{06DD}", %p)},	undef,	"to_unicode\(\'ς\>\\u0338\。\\u06DD\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2931\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ>\x{0338}。\x{06DD}", %p)},	undef,	"to_unicode\(\'Σ\>\\u0338\。\\u06DD\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2932\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ≯。\x{06DD}", %p)},	undef,	"to_unicode\(\'Σ\≯\。\\u06DD\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2933\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ≯。\x{06DD}", %p)},	undef,	"to_unicode\(\'σ\≯\。\\u06DD\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2934\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ>\x{0338}。\x{06DD}", %p)},	undef,	"to_unicode\(\'σ\>\\u0338\。\\u06DD\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2935\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ>\x{0338}｡\x{06DD}", %p)},	undef,	"to_unicode\(\'Σ\>\\u0338｡\\u06DD\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2936\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ≯｡\x{06DD}", %p)},	undef,	"to_unicode\(\'Σ\≯｡\\u06DD\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2937\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ≯｡\x{06DD}", %p)},	undef,	"to_unicode\(\'σ\≯｡\\u06DD\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2938\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ>\x{0338}｡\x{06DD}", %p)},	undef,	"to_unicode\(\'σ\>\\u0338｡\\u06DD\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2939\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{103A}\x{200D}\x{064A}。\x{0600}", %p)},	undef,	"to_unicode\(\'\\u103A\\u200D\\u064A\。\\u0600\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2940\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("􅭎\x{0A42}Ⴊ򼸑.≮", %p)},	undef,	"to_unicode\(\'􅭎\\u0A42Ⴊ򼸑\.\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2941\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("􅭎\x{0A42}Ⴊ򼸑.<\x{0338}", %p)},	undef,	"to_unicode\(\'􅭎\\u0A42Ⴊ򼸑\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2942\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("􅭎\x{0A42}ⴊ򼸑.<\x{0338}", %p)},	undef,	"to_unicode\(\'􅭎\\u0A42ⴊ򼸑\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2943\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("􅭎\x{0A42}ⴊ򼸑.≮", %p)},	undef,	"to_unicode\(\'􅭎\\u0A42ⴊ򼸑\.\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2944\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{072B}．۲", %p)},	"\x{072B}.۲",	"to_unicode\(\'\\u072B．۲\'\)\ \[data\/IdnaTest\.txt\:2945\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{072B}.۲", %p)},	"\x{072B}.۲",	"to_unicode\(\'\\u072B\.۲\'\)\ \[data\/IdnaTest\.txt\:2946\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--1nb.xn--fmb", %p)},	"\x{072B}.۲",	"to_unicode\(\'xn\-\-1nb\.xn\-\-fmb\'\)\ \[data\/IdnaTest\.txt\:2947\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹩𾤨｡ᢕ🄄", %p)},	undef,	"to_unicode\(\'𐹩𾤨｡ᢕ🄄\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2948\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹩𾤨。ᢕ3,", %p)},	undef,	"to_unicode\(\'𐹩𾤨\。ᢕ3\,\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2949\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("-\x{A953}𐡃󠇀｡\x{200D}\x{A953}", %p)},	undef,	"to_unicode\(\'\-\\uA953𐡃\󠇀｡\\u200D\\uA953\'\)\ throws\ error\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:2950\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("-\x{A953}𐡃󠇀｡\x{200D}\x{A953}", %p)},	undef,	"to_unicode\(\'\-\\uA953𐡃\󠇀｡\\u200D\\uA953\'\)\ throws\ error\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:2951\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("-\x{A953}𐡃󠇀。\x{200D}\x{A953}", %p)},	undef,	"to_unicode\(\'\-\\uA953𐡃\󠇀\。\\u200D\\uA953\'\)\ throws\ error\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:2952\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("-\x{A953}𐡃󠇀。\x{200D}\x{A953}", %p)},	undef,	"to_unicode\(\'\-\\uA953𐡃\󠇀\。\\u200D\\uA953\'\)\ throws\ error\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:2953\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𑄰\x{200C}𒻝🄆｡\x{200C}\x{09CD}󠄟", %p)},	undef,	"to_unicode\(\'𑄰\\u200C𒻝🄆｡\\u200C\\u09CD\󠄟\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2954\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑄰\x{200C}𒻝🄆｡\x{200C}\x{09CD}󠄟", %p)},	undef,	"to_unicode\(\'𑄰\\u200C𒻝🄆｡\\u200C\\u09CD\󠄟\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2955\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑄰\x{200C}𒻝5,。\x{200C}\x{09CD}󠄟", %p)},	undef,	"to_unicode\(\'𑄰\\u200C𒻝5\,\。\\u200C\\u09CD\󠄟\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2956\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑄰\x{200C}𒻝5,。\x{200C}\x{09CD}󠄟", %p)},	undef,	"to_unicode\(\'𑄰\\u200C𒻝5\,\。\\u200C\\u09CD\󠄟\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2957\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("兎｡\x{07E0}󠵲𑇀\x{ABED}", %p)},	undef,	"to_unicode\(\'兎｡\\u07E0\󠵲𑇀\\uABED\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2958\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("兎。\x{07E0}󠵲𑇀\x{ABED}", %p)},	undef,	"to_unicode\(\'兎\。\\u07E0\󠵲𑇀\\uABED\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2959\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟙｡\x{200D}𝟸\x{200D}⁷", %p)},	undef,	"to_unicode\(\'𝟙｡\\u200D𝟸\\u200D⁷\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2960\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟙｡\x{200D}𝟸\x{200D}⁷", %p)},	undef,	"to_unicode\(\'𝟙｡\\u200D𝟸\\u200D⁷\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2961\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1。\x{200D}2\x{200D}7", %p)},	undef,	"to_unicode\(\'1\。\\u200D2\\u200D7\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2962\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1。\x{200D}2\x{200D}7", %p)},	undef,	"to_unicode\(\'1\。\\u200D2\\u200D7\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2963\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.27", %p)},	"1.27",	"to_unicode\(\'1\.27\'\)\ \[data\/IdnaTest\.txt\:2964\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐮮-｡,𝟷", %p)},	undef,	"to_unicode\(\'𐮮\-｡\,𝟷\'\)\ throws\ error\ P1\ V3\ V6\ B3\ \[data\/IdnaTest\.txt\:2965\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐮮-。,1", %p)},	undef,	"to_unicode\(\'𐮮\-\。\,1\'\)\ throws\ error\ P1\ V3\ V6\ B3\ \[data\/IdnaTest\.txt\:2966\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20EA}񋹂𞴌．𐹬⁹", %p)},	undef,	"to_unicode\(\'\\u20EA񋹂𞴌．𐹬⁹\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2967\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20EA}񋹂𞴌.𐹬9", %p)},	undef,	"to_unicode\(\'\\u20EA񋹂𞴌\.𐹬9\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2968\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴜ񹃏\x{1DD8}⾇。Ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴜ񹃏\\u1DD8⾇\。Ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2969\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴜ񹃏\x{1DD8}⾇。Ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴜ񹃏\\u1DD8⾇\。Ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2970\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴜ񹃏\x{1DD8}舛。Ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴜ񹃏\\u1DD8舛\。Ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2971\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴜ񹃏\x{1DD8}舛。Ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴜ񹃏\\u1DD8舛\。Ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2972\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴜ񹃏\x{1DD8}舛。ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'ⴜ񹃏\\u1DD8舛\。ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2973\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴜ񹃏\x{1DD8}舛。ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'ⴜ񹃏\\u1DD8舛\。ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2974\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴜ񹃏\x{1DD8}⾇。ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'ⴜ񹃏\\u1DD8⾇\。ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2975\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴜ񹃏\x{1DD8}⾇。ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'ⴜ񹃏\\u1DD8⾇\。ⴏ\♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2976\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1734}𝟰.\x{200D}", %p)},	undef,	"to_unicode\(\'\\u1734𝟰\.\\u200D\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2977\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1734}𝟰.\x{200D}", %p)},	undef,	"to_unicode\(\'\\u1734𝟰\.\\u200D\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2978\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1734}4.\x{200D}", %p)},	undef,	"to_unicode\(\'\\u17344\.\\u200D\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2979\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1734}4.\x{200D}", %p)},	undef,	"to_unicode\(\'\\u17344\.\\u200D\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2980\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񝪛Ⴞ癀｡\x{0ACD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'񝪛Ⴞ癀｡\\u0ACD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2981\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񝪛Ⴞ癀｡\x{0ACD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'񝪛Ⴞ癀｡\\u0ACD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2982\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񝪛Ⴞ癀｡\x{0ACD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'񝪛Ⴞ癀｡\\u0ACD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2983\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񝪛Ⴞ癀｡\x{0ACD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'񝪛Ⴞ癀｡\\u0ACD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2984\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񝪛Ⴞ癀。\x{0ACD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'񝪛Ⴞ癀\。\\u0ACD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2985\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񝪛Ⴞ癀。\x{0ACD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'񝪛Ⴞ癀\。\\u0ACD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2986\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񝪛Ⴞ癀。\x{0ACD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'񝪛Ⴞ癀\。\\u0ACD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2987\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񝪛Ⴞ癀。\x{0ACD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'񝪛Ⴞ癀\。\\u0ACD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2988\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񝪛ⴞ癀。\x{0ACD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'񝪛ⴞ癀\。\\u0ACD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2989\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񝪛ⴞ癀。\x{0ACD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'񝪛ⴞ癀\。\\u0ACD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2990\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񝪛ⴞ癀。\x{0ACD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'񝪛ⴞ癀\。\\u0ACD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2991\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񝪛ⴞ癀。\x{0ACD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'񝪛ⴞ癀\。\\u0ACD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2992\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񝪛ⴞ癀｡\x{0ACD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'񝪛ⴞ癀｡\\u0ACD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2993\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񝪛ⴞ癀｡\x{0ACD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'񝪛ⴞ癀｡\\u0ACD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2994\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񝪛ⴞ癀｡\x{0ACD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'񝪛ⴞ癀｡\\u0ACD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2995\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񝪛ⴞ癀｡\x{0ACD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'񝪛ⴞ癀｡\\u0ACD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2996\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󙧵-𑜫。ᠽ", %p)},	undef,	"to_unicode\(\'󙧵\-𑜫\。ᠽ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2997\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡕ𝟧≯ꡊ．氁𻖋ꁫ", %p)},	undef,	"to_unicode\(\'ꡕ𝟧\≯ꡊ．氁𻖋ꁫ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2998\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡕ𝟧>\x{0338}ꡊ．氁𻖋ꁫ", %p)},	undef,	"to_unicode\(\'ꡕ𝟧\>\\u0338ꡊ．氁𻖋ꁫ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2999\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡕ5≯ꡊ.氁𻖋ꁫ", %p)},	undef,	"to_unicode\(\'ꡕ5\≯ꡊ\.氁𻖋ꁫ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3000\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡕ5>\x{0338}ꡊ.氁𻖋ꁫ", %p)},	undef,	"to_unicode\(\'ꡕ5\>\\u0338ꡊ\.氁𻖋ꁫ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3001\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0660}\x{0650}．\x{05A9}", %p)},	undef,	"to_unicode\(\'\\u0660\\u0650．\\u05A9\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3002\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0660}\x{0650}.\x{05A9}", %p)},	undef,	"to_unicode\(\'\\u0660\\u0650\.\\u05A9\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3003\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-𝨱⒏．⒎𶇻󠠁", %p)},	undef,	"to_unicode\(\'\-𝨱⒏．⒎𶇻\󠠁\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3004\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-𝨱8..7.𶇻󠠁", %p)},	undef,	"to_unicode\(\'\-𝨱8\.\.7\.𶇻\󠠁\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3005\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}．≮", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D．\≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3006\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}．≮", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D．\≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3007\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}．<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D．\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3008\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}．<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D．\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3009\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}.≮", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D\.\≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3010\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}.≮", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D\.\≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3011\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}.<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3012\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}.<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3013\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}.<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3014\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}.<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3015\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}.≮", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D\.\≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3016\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}.≮", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D\.\≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3017\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}．<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D．\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3018\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}．<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D．\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3019\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}．≮", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D．\≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3020\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}．≮", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D．\≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3021\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("歷｡\x{0660}≯󧓻\x{200D}", %p)},	undef,	"to_unicode\(\'歷｡\\u0660\≯󧓻\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3022\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("歷｡\x{0660}≯󧓻\x{200D}", %p)},	undef,	"to_unicode\(\'歷｡\\u0660\≯󧓻\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3023\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("歷｡\x{0660}>\x{0338}󧓻\x{200D}", %p)},	undef,	"to_unicode\(\'歷｡\\u0660\>\\u0338󧓻\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3024\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("歷｡\x{0660}>\x{0338}󧓻\x{200D}", %p)},	undef,	"to_unicode\(\'歷｡\\u0660\>\\u0338󧓻\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3025\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("歷。\x{0660}≯󧓻\x{200D}", %p)},	undef,	"to_unicode\(\'歷\。\\u0660\≯󧓻\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3026\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("歷。\x{0660}≯󧓻\x{200D}", %p)},	undef,	"to_unicode\(\'歷\。\\u0660\≯󧓻\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3027\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("歷。\x{0660}>\x{0338}󧓻\x{200D}", %p)},	undef,	"to_unicode\(\'歷\。\\u0660\>\\u0338󧓻\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3028\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("歷。\x{0660}>\x{0338}󧓻\x{200D}", %p)},	undef,	"to_unicode\(\'歷\。\\u0660\>\\u0338󧓻\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3029\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0732}\x{200D}．󱉀󠛓", %p)},	undef,	"to_unicode\(\'\\u0732\\u200D．󱉀\󠛓\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3030\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0732}\x{200D}．󱉀󠛓", %p)},	undef,	"to_unicode\(\'\\u0732\\u200D．󱉀\󠛓\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3031\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0732}\x{200D}.󱉀󠛓", %p)},	undef,	"to_unicode\(\'\\u0732\\u200D\.󱉀\󠛓\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3032\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0732}\x{200D}.󱉀󠛓", %p)},	undef,	"to_unicode\(\'\\u0732\\u200D\.󱉀\󠛓\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3033\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{200C}ꡎ｡񔟅𐽯", %p)},	undef,	"to_unicode\(\'\\u200D\\u200Cꡎ｡񔟅𐽯\'\)\ throws\ error\ P1\ V6\ C2\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3034\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{200C}ꡎ｡񔟅𐽯", %p)},	undef,	"to_unicode\(\'\\u200D\\u200Cꡎ｡񔟅𐽯\'\)\ throws\ error\ P1\ V6\ C2\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3035\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{200C}ꡎ。񔟅𐽯", %p)},	undef,	"to_unicode\(\'\\u200D\\u200Cꡎ\。񔟅𐽯\'\)\ throws\ error\ P1\ V6\ C2\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3036\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{200C}ꡎ。񔟅𐽯", %p)},	undef,	"to_unicode\(\'\\u200D\\u200Cꡎ\。񔟅𐽯\'\)\ throws\ error\ P1\ V6\ C2\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3037\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0693}≠𝟫-.ς⒍\x{0600}≠", %p)},	undef,	"to_unicode\(\'\\u0693\≠𝟫\-\.ς⒍\\u0600\≠\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3038\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0693}=\x{0338}𝟫-.ς⒍\x{0600}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0693\=\\u0338𝟫\-\.ς⒍\\u0600\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3039\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0693}≠9-.ς6.\x{0600}≠", %p)},	undef,	"to_unicode\(\'\\u0693\≠9\-\.ς6\.\\u0600\≠\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3040\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0693}=\x{0338}9-.ς6.\x{0600}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0693\=\\u03389\-\.ς6\.\\u0600\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3041\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0693}=\x{0338}9-.Σ6.\x{0600}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0693\=\\u03389\-\.Σ6\.\\u0600\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3042\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0693}≠9-.Σ6.\x{0600}≠", %p)},	undef,	"to_unicode\(\'\\u0693\≠9\-\.Σ6\.\\u0600\≠\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3043\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0693}≠9-.σ6.\x{0600}≠", %p)},	undef,	"to_unicode\(\'\\u0693\≠9\-\.σ6\.\\u0600\≠\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3044\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0693}=\x{0338}9-.σ6.\x{0600}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0693\=\\u03389\-\.σ6\.\\u0600\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3045\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0693}=\x{0338}𝟫-.Σ⒍\x{0600}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0693\=\\u0338𝟫\-\.Σ⒍\\u0600\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3046\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0693}≠𝟫-.Σ⒍\x{0600}≠", %p)},	undef,	"to_unicode\(\'\\u0693\≠𝟫\-\.Σ⒍\\u0600\≠\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3047\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0693}≠𝟫-.σ⒍\x{0600}≠", %p)},	undef,	"to_unicode\(\'\\u0693\≠𝟫\-\.σ⒍\\u0600\≠\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3048\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0693}=\x{0338}𝟫-.σ⒍\x{0600}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0693\=\\u0338𝟫\-\.σ⒍\\u0600\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3049\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񵥬.-\x{0682}\x{1CD1}\x{1B39}", %p)},	undef,	"to_unicode\(\'񵥬\.\-\\u0682\\u1CD1\\u1B39\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:3050\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢌ⒈ß\x{0A4D}。񑜉-", %p)},	undef,	"to_unicode\(\'ᢌ⒈ß\\u0A4D\。񑜉\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3051\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢌ1.ß\x{0A4D}。񑜉-", %p)},	undef,	"to_unicode\(\'ᢌ1\.ß\\u0A4D\。񑜉\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3052\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢌ1.SS\x{0A4D}。񑜉-", %p)},	undef,	"to_unicode\(\'ᢌ1\.SS\\u0A4D\。񑜉\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3053\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢌ1.ss\x{0A4D}。񑜉-", %p)},	undef,	"to_unicode\(\'ᢌ1\.ss\\u0A4D\。񑜉\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3054\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢌ1.Ss\x{0A4D}。񑜉-", %p)},	undef,	"to_unicode\(\'ᢌ1\.Ss\\u0A4D\。񑜉\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3055\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢌ⒈SS\x{0A4D}。񑜉-", %p)},	undef,	"to_unicode\(\'ᢌ⒈SS\\u0A4D\。񑜉\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3056\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢌ⒈ss\x{0A4D}。񑜉-", %p)},	undef,	"to_unicode\(\'ᢌ⒈ss\\u0A4D\。񑜉\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3057\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢌ⒈Ss\x{0A4D}。񑜉-", %p)},	undef,	"to_unicode\(\'ᢌ⒈Ss\\u0A4D\。񑜉\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3058\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𚑍．\x{0ACD}ςႦ\x{200D}", %p)},	undef,	"to_unicode\(\'𚑍．\\u0ACDςႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3059\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𚑍．\x{0ACD}ςႦ\x{200D}", %p)},	undef,	"to_unicode\(\'𚑍．\\u0ACDςႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3060\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𚑍.\x{0ACD}ςႦ\x{200D}", %p)},	undef,	"to_unicode\(\'𚑍\.\\u0ACDςႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3061\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𚑍.\x{0ACD}ςႦ\x{200D}", %p)},	undef,	"to_unicode\(\'𚑍\.\\u0ACDςႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3062\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𚑍.\x{0ACD}ςⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'𚑍\.\\u0ACDςⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3063\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𚑍.\x{0ACD}ςⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'𚑍\.\\u0ACDςⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3064\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𚑍.\x{0ACD}ΣႦ\x{200D}", %p)},	undef,	"to_unicode\(\'𚑍\.\\u0ACDΣႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3065\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𚑍.\x{0ACD}ΣႦ\x{200D}", %p)},	undef,	"to_unicode\(\'𚑍\.\\u0ACDΣႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3066\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𚑍.\x{0ACD}σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'𚑍\.\\u0ACDσⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3067\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𚑍.\x{0ACD}σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'𚑍\.\\u0ACDσⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3068\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𚑍.\x{0ACD}Σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'𚑍\.\\u0ACDΣⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3069\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𚑍.\x{0ACD}Σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'𚑍\.\\u0ACDΣⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3070\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𚑍．\x{0ACD}ςⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'𚑍．\\u0ACDςⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3071\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𚑍．\x{0ACD}ςⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'𚑍．\\u0ACDςⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3072\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𚑍．\x{0ACD}ΣႦ\x{200D}", %p)},	undef,	"to_unicode\(\'𚑍．\\u0ACDΣႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3073\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𚑍．\x{0ACD}ΣႦ\x{200D}", %p)},	undef,	"to_unicode\(\'𚑍．\\u0ACDΣႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3074\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𚑍．\x{0ACD}σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'𚑍．\\u0ACDσⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3075\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𚑍．\x{0ACD}σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'𚑍．\\u0ACDσⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3076\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𚑍．\x{0ACD}Σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'𚑍．\\u0ACDΣⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3077\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𚑍．\x{0ACD}Σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'𚑍．\\u0ACDΣⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3078\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆𐹬.󠻍", %p)},	undef,	"to_unicode\(\'⾆𐹬\.\󠻍\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3079\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌𐹬.󠻍", %p)},	undef,	"to_unicode\(\'舌𐹬\.\󠻍\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3080\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠘿𐹭𝩛。⦣⒈", %p)},	undef,	"to_unicode\(\'\󠘿𐹭𝩛\。\⦣⒈\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3081\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠘿𐹭𝩛。⦣1.", %p)},	undef,	"to_unicode\(\'\󠘿𐹭𝩛\。\⦣1\.\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3082\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{200C}\x{0348}︒．\x{094D}", %p)},	undef,	"to_unicode\(\'⒈\\u200C\\u0348︒．\\u094D\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3083\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{200C}\x{0348}︒．\x{094D}", %p)},	undef,	"to_unicode\(\'⒈\\u200C\\u0348︒．\\u094D\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3084\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.\x{200C}\x{0348}。.\x{094D}", %p)},	undef,	"to_unicode\(\'1\.\\u200C\\u0348\。\.\\u094D\'\)\ throws\ error\ V5\ C1\ A4_2\ \[data\/IdnaTest\.txt\:3085\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.\x{200C}\x{0348}。.\x{094D}", %p)},	undef,	"to_unicode\(\'1\.\\u200C\\u0348\。\.\\u094D\'\)\ throws\ error\ V5\ C1\ A4_2\ \[data\/IdnaTest\.txt\:3086\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0823}。䰀\x{06DD}𐶡\x{A980}", %p)},	undef,	"to_unicode\(\'\\u0823\。䰀\\u06DD𐶡\\uA980\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3087\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200D}.𑚶𯞬", %p)},	undef,	"to_unicode\(\'ß\\u200D\.𑚶𯞬\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3088\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200D}.𑚶𯞬", %p)},	undef,	"to_unicode\(\'ß\\u200D\.𑚶𯞬\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3089\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{200D}.𑚶𯞬", %p)},	undef,	"to_unicode\(\'SS\\u200D\.𑚶𯞬\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3090\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{200D}.𑚶𯞬", %p)},	undef,	"to_unicode\(\'SS\\u200D\.𑚶𯞬\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3091\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{200D}.𑚶𯞬", %p)},	undef,	"to_unicode\(\'ss\\u200D\.𑚶𯞬\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3092\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{200D}.𑚶𯞬", %p)},	undef,	"to_unicode\(\'ss\\u200D\.𑚶𯞬\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3093\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200D}.𑚶𯞬", %p)},	undef,	"to_unicode\(\'Ss\\u200D\.𑚶𯞬\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3094\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200D}.𑚶𯞬", %p)},	undef,	"to_unicode\(\'Ss\\u200D\.𑚶𯞬\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3095\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0CCD}\x{200C}≮.≮", %p)},	undef,	"to_unicode\(\'\\u0CCD\\u200C\≮\.\≮\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3096\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0CCD}\x{200C}<\x{0338}.<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0CCD\\u200C\<\\u0338\.\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3097\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A69F}．\x{FFA0}", %p)},	undef,	"to_unicode\(\'\\uA69F．\\uFFA0\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3098\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A69F}.\x{1160}", %p)},	undef,	"to_unicode\(\'\\uA69F\.\\u1160\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3099\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡯ𞱺。𰞔", %p)},	undef,	"to_unicode\(\'ꡯ𞱺\。𰞔\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3100\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("爕򾉋．𝟰気", %p)},	undef,	"to_unicode\(\'爕򾉋．𝟰気\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3101\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("爕򾉋.4気", %p)},	undef,	"to_unicode\(\'爕򾉋\.4気\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3102\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒋𑚶Ⴝ-．\x{FD67}\x{1B44}󠄕", %p)},	undef,	"to_unicode\(\'⒋𑚶Ⴝ\-．\\uFD67\\u1B44\󠄕\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3103\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4.𑚶Ⴝ-.\x{0634}\x{062D}\x{0645}\x{1B44}󠄕", %p)},	undef,	"to_unicode\(\'4\.𑚶Ⴝ\-\.\\u0634\\u062D\\u0645\\u1B44\󠄕\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3104\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("4.𑚶ⴝ-.\x{0634}\x{062D}\x{0645}\x{1B44}󠄕", %p)},	undef,	"to_unicode\(\'4\.𑚶ⴝ\-\.\\u0634\\u062D\\u0645\\u1B44\󠄕\'\)\ throws\ error\ V3\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:3105\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⒋𑚶ⴝ-．\x{FD67}\x{1B44}󠄕", %p)},	undef,	"to_unicode\(\'⒋𑚶ⴝ\-．\\uFD67\\u1B44\󠄕\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3106\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򊼓。񎊯󘙦--", %p)},	undef,	"to_unicode\(\'򊼓\。񎊯󘙦\-\-\'\)\ throws\ error\ P1\ V6\ V2\ V3\ \[data\/IdnaTest\.txt\:3107\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200D}ᡲ｡\x{200C}𐨿", %p)},	undef,	"to_unicode\(\'\\u200Dᡲ｡\\u200C𐨿\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3108\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200D}ᡲ｡\x{200C}𐨿", %p)},	undef,	"to_unicode\(\'\\u200Dᡲ｡\\u200C𐨿\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3109\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200D}ᡲ。\x{200C}𐨿", %p)},	undef,	"to_unicode\(\'\\u200Dᡲ\。\\u200C𐨿\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3110\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200D}ᡲ。\x{200C}𐨿", %p)},	undef,	"to_unicode\(\'\\u200Dᡲ\。\\u200C𐨿\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3111\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𐴟𐿖\x{07D2}｡\x{0842}񡖿ᡨ", %p)},	undef,	"to_unicode\(\'𐴟𐿖\\u07D2｡\\u0842񡖿ᡨ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3112\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐴟𐿖\x{07D2}。\x{0842}񡖿ᡨ", %p)},	undef,	"to_unicode\(\'𐴟𐿖\\u07D2\。\\u0842񡖿ᡨ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3113\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0F8E}𐬓􎖤\x{1BAB}.\x{071D}\x{0630}", %p)},	undef,	"to_unicode\(\'\\u0F8E𐬓􎖤\\u1BAB\.\\u071D\\u0630\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3114\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򟘰킃󠁎ᠪ｡ς\x{069C}ς", %p)},	undef,	"to_unicode\(\'򟘰킃\󠁎ᠪ｡ς\\u069Cς\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3115\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򟘰킃󠁎ᠪ｡ς\x{069C}ς", %p)},	undef,	"to_unicode\(\'򟘰킃\󠁎ᠪ｡ς\\u069Cς\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3116\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򟘰킃󠁎ᠪ。ς\x{069C}ς", %p)},	undef,	"to_unicode\(\'򟘰킃\󠁎ᠪ\。ς\\u069Cς\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3117\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򟘰킃󠁎ᠪ。ς\x{069C}ς", %p)},	undef,	"to_unicode\(\'򟘰킃\󠁎ᠪ\。ς\\u069Cς\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3118\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򟘰킃󠁎ᠪ。Σ\x{069C}Σ", %p)},	undef,	"to_unicode\(\'򟘰킃\󠁎ᠪ\。Σ\\u069CΣ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3119\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򟘰킃󠁎ᠪ。Σ\x{069C}Σ", %p)},	undef,	"to_unicode\(\'򟘰킃\󠁎ᠪ\。Σ\\u069CΣ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3120\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򟘰킃󠁎ᠪ。σ\x{069C}σ", %p)},	undef,	"to_unicode\(\'򟘰킃\󠁎ᠪ\。σ\\u069Cσ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3121\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򟘰킃󠁎ᠪ。σ\x{069C}σ", %p)},	undef,	"to_unicode\(\'򟘰킃\󠁎ᠪ\。σ\\u069Cσ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3122\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򟘰킃󠁎ᠪ。Σ\x{069C}σ", %p)},	undef,	"to_unicode\(\'򟘰킃\󠁎ᠪ\。Σ\\u069Cσ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3123\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򟘰킃󠁎ᠪ。Σ\x{069C}σ", %p)},	undef,	"to_unicode\(\'򟘰킃\󠁎ᠪ\。Σ\\u069Cσ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3124\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򟘰킃󠁎ᠪ。Σ\x{069C}ς", %p)},	undef,	"to_unicode\(\'򟘰킃\󠁎ᠪ\。Σ\\u069Cς\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3125\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򟘰킃󠁎ᠪ。Σ\x{069C}ς", %p)},	undef,	"to_unicode\(\'򟘰킃\󠁎ᠪ\。Σ\\u069Cς\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3126\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򟘰킃󠁎ᠪ。σ\x{069C}ς", %p)},	undef,	"to_unicode\(\'򟘰킃\󠁎ᠪ\。σ\\u069Cς\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3127\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򟘰킃󠁎ᠪ。σ\x{069C}ς", %p)},	undef,	"to_unicode\(\'򟘰킃\󠁎ᠪ\。σ\\u069Cς\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3128\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򟘰킃󠁎ᠪ｡Σ\x{069C}Σ", %p)},	undef,	"to_unicode\(\'򟘰킃\󠁎ᠪ｡Σ\\u069CΣ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3129\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򟘰킃󠁎ᠪ｡Σ\x{069C}Σ", %p)},	undef,	"to_unicode\(\'򟘰킃\󠁎ᠪ｡Σ\\u069CΣ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3130\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򟘰킃󠁎ᠪ｡σ\x{069C}σ", %p)},	undef,	"to_unicode\(\'򟘰킃\󠁎ᠪ｡σ\\u069Cσ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3131\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򟘰킃󠁎ᠪ｡σ\x{069C}σ", %p)},	undef,	"to_unicode\(\'򟘰킃\󠁎ᠪ｡σ\\u069Cσ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3132\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򟘰킃󠁎ᠪ｡Σ\x{069C}σ", %p)},	undef,	"to_unicode\(\'򟘰킃\󠁎ᠪ｡Σ\\u069Cσ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3133\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򟘰킃󠁎ᠪ｡Σ\x{069C}σ", %p)},	undef,	"to_unicode\(\'򟘰킃\󠁎ᠪ｡Σ\\u069Cσ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3134\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򟘰킃󠁎ᠪ｡Σ\x{069C}ς", %p)},	undef,	"to_unicode\(\'򟘰킃\󠁎ᠪ｡Σ\\u069Cς\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3135\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򟘰킃󠁎ᠪ｡Σ\x{069C}ς", %p)},	undef,	"to_unicode\(\'򟘰킃\󠁎ᠪ｡Σ\\u069Cς\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3136\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򟘰킃󠁎ᠪ｡σ\x{069C}ς", %p)},	undef,	"to_unicode\(\'򟘰킃\󠁎ᠪ｡σ\\u069Cς\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3137\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򟘰킃󠁎ᠪ｡σ\x{069C}ς", %p)},	undef,	"to_unicode\(\'򟘰킃\󠁎ᠪ｡σ\\u069Cς\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3138\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("蔰。󠄣\x{031A}-\x{0B4D}", %p)},	undef,	"to_unicode\(\'蔰\。\󠄣\\u031A\-\\u0B4D\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3139\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ςჅ。ꡫ", %p)},	undef,	"to_unicode\(\'ςჅ\。ꡫ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3140\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ςⴥ。ꡫ", %p)},	"ςⴥ.ꡫ",	"to_unicode\(\'ςⴥ\。ꡫ\'\)\ \[data\/IdnaTest\.txt\:3141\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ςⴥ。ꡫ", %p)},	"ςⴥ.ꡫ",	"to_unicode\(\'ςⴥ\。ꡫ\'\)\ \[data\/IdnaTest\.txt\:3142\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ΣჅ。ꡫ", %p)},	undef,	"to_unicode\(\'ΣჅ\。ꡫ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3143\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("σⴥ。ꡫ", %p)},	"σⴥ.ꡫ",	"to_unicode\(\'σⴥ\。ꡫ\'\)\ \[data\/IdnaTest\.txt\:3144\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("Σⴥ。ꡫ", %p)},	"σⴥ.ꡫ",	"to_unicode\(\'Σⴥ\。ꡫ\'\)\ \[data\/IdnaTest\.txt\:3145\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("xn--4xa203s.xn--hd9a", %p)},	"σⴥ.ꡫ",	"to_unicode\(\'xn\-\-4xa203s\.xn\-\-hd9a\'\)\ \[data\/IdnaTest\.txt\:3146\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("σⴥ.ꡫ", %p)},	"σⴥ.ꡫ",	"to_unicode\(\'σⴥ\.ꡫ\'\)\ \[data\/IdnaTest\.txt\:3147\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ΣჅ.ꡫ", %p)},	undef,	"to_unicode\(\'ΣჅ\.ꡫ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3148\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("Σⴥ.ꡫ", %p)},	"σⴥ.ꡫ",	"to_unicode\(\'Σⴥ\.ꡫ\'\)\ \[data\/IdnaTest\.txt\:3149\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("xn--3xa403s.xn--hd9a", %p)},	"ςⴥ.ꡫ",	"to_unicode\(\'xn\-\-3xa403s\.xn\-\-hd9a\'\)\ \[data\/IdnaTest\.txt\:3150\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ςⴥ.ꡫ", %p)},	"ςⴥ.ꡫ",	"to_unicode\(\'ςⴥ\.ꡫ\'\)\ \[data\/IdnaTest\.txt\:3151\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ςⴥ.ꡫ", %p)},	"ςⴥ.ꡫ",	"to_unicode\(\'ςⴥ\.ꡫ\'\)\ \[data\/IdnaTest\.txt\:3152\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0A4D}Ⴉ𐯩．\x{1DF4}", %p)},	undef,	"to_unicode\(\'\\u0A4DႩ𐯩．\\u1DF4\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3153\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0A4D}Ⴉ𐯩.\x{1DF4}", %p)},	undef,	"to_unicode\(\'\\u0A4DႩ𐯩\.\\u1DF4\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3154\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0A4D}ⴉ𐯩.\x{1DF4}", %p)},	undef,	"to_unicode\(\'\\u0A4Dⴉ𐯩\.\\u1DF4\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3155\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0A4D}ⴉ𐯩．\x{1DF4}", %p)},	undef,	"to_unicode\(\'\\u0A4Dⴉ𐯩．\\u1DF4\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3156\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("💧≮񰐇\x{0AC2}。𞦞", %p)},	undef,	"to_unicode\(\'💧\≮񰐇\\u0AC2\。𞦞\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3157\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("💧<\x{0338}񰐇\x{0AC2}。𞦞", %p)},	undef,	"to_unicode\(\'💧\<\\u0338񰐇\\u0AC2\。𞦞\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3158\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0689}｡\x{200D}ẏ\x{200C}\x{0757}", %p)},	undef,	"to_unicode\(\'\\u0689｡\\u200Dẏ\\u200C\\u0757\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3159\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0689}｡\x{200D}ẏ\x{200C}\x{0757}", %p)},	undef,	"to_unicode\(\'\\u0689｡\\u200Dẏ\\u200C\\u0757\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3160\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0689}｡\x{200D}y\x{0307}\x{200C}\x{0757}", %p)},	undef,	"to_unicode\(\'\\u0689｡\\u200Dy\\u0307\\u200C\\u0757\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3161\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0689}｡\x{200D}y\x{0307}\x{200C}\x{0757}", %p)},	undef,	"to_unicode\(\'\\u0689｡\\u200Dy\\u0307\\u200C\\u0757\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3162\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0689}。\x{200D}ẏ\x{200C}\x{0757}", %p)},	undef,	"to_unicode\(\'\\u0689\。\\u200Dẏ\\u200C\\u0757\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3163\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0689}。\x{200D}ẏ\x{200C}\x{0757}", %p)},	undef,	"to_unicode\(\'\\u0689\。\\u200Dẏ\\u200C\\u0757\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3164\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0689}。\x{200D}y\x{0307}\x{200C}\x{0757}", %p)},	undef,	"to_unicode\(\'\\u0689\。\\u200Dy\\u0307\\u200C\\u0757\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3165\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0689}。\x{200D}y\x{0307}\x{200C}\x{0757}", %p)},	undef,	"to_unicode\(\'\\u0689\。\\u200Dy\\u0307\\u200C\\u0757\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3166\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0689}。\x{200D}Y\x{0307}\x{200C}\x{0757}", %p)},	undef,	"to_unicode\(\'\\u0689\。\\u200DY\\u0307\\u200C\\u0757\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3167\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0689}。\x{200D}Y\x{0307}\x{200C}\x{0757}", %p)},	undef,	"to_unicode\(\'\\u0689\。\\u200DY\\u0307\\u200C\\u0757\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3168\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0689}。\x{200D}Ẏ\x{200C}\x{0757}", %p)},	undef,	"to_unicode\(\'\\u0689\。\\u200DẎ\\u200C\\u0757\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3169\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0689}。\x{200D}Ẏ\x{200C}\x{0757}", %p)},	undef,	"to_unicode\(\'\\u0689\。\\u200DẎ\\u200C\\u0757\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3170\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0689}｡\x{200D}Y\x{0307}\x{200C}\x{0757}", %p)},	undef,	"to_unicode\(\'\\u0689｡\\u200DY\\u0307\\u200C\\u0757\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3171\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0689}｡\x{200D}Y\x{0307}\x{200C}\x{0757}", %p)},	undef,	"to_unicode\(\'\\u0689｡\\u200DY\\u0307\\u200C\\u0757\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3172\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0689}｡\x{200D}Ẏ\x{200C}\x{0757}", %p)},	undef,	"to_unicode\(\'\\u0689｡\\u200DẎ\\u200C\\u0757\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3173\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0689}｡\x{200D}Ẏ\x{200C}\x{0757}", %p)},	undef,	"to_unicode\(\'\\u0689｡\\u200DẎ\\u200C\\u0757\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3174\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0661}\x{0E39}。𕄦\x{0B4D}", %p)},	undef,	"to_unicode\(\'\\u0661\\u0E39\。𕄦\\u0B4D\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3175\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-≠\x{1039}｡嵕𞾸۴\x{103A}", %p)},	undef,	"to_unicode\(\'\-\≠\\u1039｡嵕𞾸۴\\u103A\'\)\ throws\ error\ P1\ V3\ V6\ B5\ \[data\/IdnaTest\.txt\:3176\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-=\x{0338}\x{1039}｡嵕𞾸۴\x{103A}", %p)},	undef,	"to_unicode\(\'\-\=\\u0338\\u1039｡嵕𞾸۴\\u103A\'\)\ throws\ error\ P1\ V3\ V6\ B5\ \[data\/IdnaTest\.txt\:3177\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-≠\x{1039}。嵕𞾸۴\x{103A}", %p)},	undef,	"to_unicode\(\'\-\≠\\u1039\。嵕𞾸۴\\u103A\'\)\ throws\ error\ P1\ V3\ V6\ B5\ \[data\/IdnaTest\.txt\:3178\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-=\x{0338}\x{1039}。嵕𞾸۴\x{103A}", %p)},	undef,	"to_unicode\(\'\-\=\\u0338\\u1039\。嵕𞾸۴\\u103A\'\)\ throws\ error\ P1\ V3\ V6\ B5\ \[data\/IdnaTest\.txt\:3179\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񖚂𐹯\x{062D}．\x{077F}\x{200D}≯\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C񖚂𐹯\\u062D．\\u077F\\u200D\≯\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3180\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񖚂𐹯\x{062D}．\x{077F}\x{200D}≯\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C񖚂𐹯\\u062D．\\u077F\\u200D\≯\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3181\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񖚂𐹯\x{062D}．\x{077F}\x{200D}>\x{0338}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C񖚂𐹯\\u062D．\\u077F\\u200D\>\\u0338\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3182\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񖚂𐹯\x{062D}．\x{077F}\x{200D}>\x{0338}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C񖚂𐹯\\u062D．\\u077F\\u200D\>\\u0338\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3183\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񖚂𐹯\x{062D}.\x{077F}\x{200D}≯\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C񖚂𐹯\\u062D\.\\u077F\\u200D\≯\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3184\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񖚂𐹯\x{062D}.\x{077F}\x{200D}≯\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C񖚂𐹯\\u062D\.\\u077F\\u200D\≯\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3185\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񖚂𐹯\x{062D}.\x{077F}\x{200D}>\x{0338}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C񖚂𐹯\\u062D\.\\u077F\\u200D\>\\u0338\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3186\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}񖚂𐹯\x{062D}.\x{077F}\x{200D}>\x{0338}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C񖚂𐹯\\u062D\.\\u077F\\u200D\>\\u0338\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3187\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮．\x{17B5}\x{06AA}\x{0771}", %p)},	undef,	"to_unicode\(\'\≮．\\u17B5\\u06AA\\u0771\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3188\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}．\x{17B5}\x{06AA}\x{0771}", %p)},	undef,	"to_unicode\(\'\<\\u0338．\\u17B5\\u06AA\\u0771\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3189\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮.\x{17B5}\x{06AA}\x{0771}", %p)},	undef,	"to_unicode\(\'\≮\.\\u17B5\\u06AA\\u0771\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3190\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}.\x{17B5}\x{06AA}\x{0771}", %p)},	undef,	"to_unicode\(\'\<\\u0338\.\\u17B5\\u06AA\\u0771\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3191\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞠎\x{200D}｡ႩႵ", %p)},	undef,	"to_unicode\(\'𞠎\\u200D｡ႩႵ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3192\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞠎\x{200D}｡ႩႵ", %p)},	undef,	"to_unicode\(\'𞠎\\u200D｡ႩႵ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3193\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞠎\x{200D}。ႩႵ", %p)},	undef,	"to_unicode\(\'𞠎\\u200D\。ႩႵ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3194\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞠎\x{200D}。ႩႵ", %p)},	undef,	"to_unicode\(\'𞠎\\u200D\。ႩႵ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3195\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𞠎\x{200D}。ⴉⴕ", %p)},	undef,	"to_unicode\(\'𞠎\\u200D\。ⴉⴕ\'\)\ throws\ error\ B3\ C2\ \[data\/IdnaTest\.txt\:3196\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𞠎\x{200D}。ⴉⴕ", %p)},	undef,	"to_unicode\(\'𞠎\\u200D\。ⴉⴕ\'\)\ throws\ error\ B3\ C2\ \[data\/IdnaTest\.txt\:3197\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𞠎\x{200D}。Ⴉⴕ", %p)},	undef,	"to_unicode\(\'𞠎\\u200D\。Ⴉⴕ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3198\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞠎\x{200D}。Ⴉⴕ", %p)},	undef,	"to_unicode\(\'𞠎\\u200D\。Ⴉⴕ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3199\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--e55h.xn--0kjya", %p)},	"𞠎.ⴉⴕ",	"to_unicode\(\'xn\-\-e55h\.xn\-\-0kjya\'\)\ \[data\/IdnaTest\.txt\:3200\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𞠎.ⴉⴕ", %p)},	"𞠎.ⴉⴕ",	"to_unicode\(\'𞠎\.ⴉⴕ\'\)\ \[data\/IdnaTest\.txt\:3201\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𞠎.ႩႵ", %p)},	undef,	"to_unicode\(\'𞠎\.ႩႵ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3202\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞠎.Ⴉⴕ", %p)},	undef,	"to_unicode\(\'𞠎\.Ⴉⴕ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3203\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𞠎\x{200D}｡ⴉⴕ", %p)},	undef,	"to_unicode\(\'𞠎\\u200D｡ⴉⴕ\'\)\ throws\ error\ B3\ C2\ \[data\/IdnaTest\.txt\:3204\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𞠎\x{200D}｡ⴉⴕ", %p)},	undef,	"to_unicode\(\'𞠎\\u200D｡ⴉⴕ\'\)\ throws\ error\ B3\ C2\ \[data\/IdnaTest\.txt\:3205\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𞠎\x{200D}｡Ⴉⴕ", %p)},	undef,	"to_unicode\(\'𞠎\\u200D｡Ⴉⴕ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3206\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞠎\x{200D}｡Ⴉⴕ", %p)},	undef,	"to_unicode\(\'𞠎\\u200D｡Ⴉⴕ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3207\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}ㄤ．𝨣򾭅󠆻", %p)},	undef,	"to_unicode\(\'\\u200C\\u200Cㄤ．𝨣򾭅\󠆻\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3208\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}ㄤ．𝨣򾭅󠆻", %p)},	undef,	"to_unicode\(\'\\u200C\\u200Cㄤ．𝨣򾭅\󠆻\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3209\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}ㄤ.𝨣򾭅󠆻", %p)},	undef,	"to_unicode\(\'\\u200C\\u200Cㄤ\.𝨣򾭅\󠆻\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3210\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}ㄤ.𝨣򾭅󠆻", %p)},	undef,	"to_unicode\(\'\\u200C\\u200Cㄤ\.𝨣򾭅\󠆻\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3211\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋻｡-\x{200C}ꡋႷ", %p)},	undef,	"to_unicode\(\'𐋻｡\-\\u200CꡋႷ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:3212\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋻｡-\x{200C}ꡋႷ", %p)},	undef,	"to_unicode\(\'𐋻｡\-\\u200CꡋႷ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:3213\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋻。-\x{200C}ꡋႷ", %p)},	undef,	"to_unicode\(\'𐋻\。\-\\u200CꡋႷ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:3214\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋻。-\x{200C}ꡋႷ", %p)},	undef,	"to_unicode\(\'𐋻\。\-\\u200CꡋႷ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:3215\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐋻。-\x{200C}ꡋⴗ", %p)},	undef,	"to_unicode\(\'𐋻\。\-\\u200Cꡋⴗ\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3216\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐋻。-\x{200C}ꡋⴗ", %p)},	undef,	"to_unicode\(\'𐋻\。\-\\u200Cꡋⴗ\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3217\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐋻｡-\x{200C}ꡋⴗ", %p)},	undef,	"to_unicode\(\'𐋻｡\-\\u200Cꡋⴗ\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3218\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐋻｡-\x{200C}ꡋⴗ", %p)},	undef,	"to_unicode\(\'𐋻｡\-\\u200Cꡋⴗ\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3219\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⋉\x{FBF6}．≠\x{200C}", %p)},	undef,	"to_unicode\(\'\⋉\\uFBF6．\≠\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3220\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋉\x{FBF6}．≠\x{200C}", %p)},	undef,	"to_unicode\(\'\⋉\\uFBF6．\≠\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3221\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋉\x{FBF6}．=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'\⋉\\uFBF6．\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3222\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋉\x{FBF6}．=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'\⋉\\uFBF6．\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3223\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋉\x{0626}\x{06D0}.≠\x{200C}", %p)},	undef,	"to_unicode\(\'\⋉\\u0626\\u06D0\.\≠\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3224\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋉\x{0626}\x{06D0}.≠\x{200C}", %p)},	undef,	"to_unicode\(\'\⋉\\u0626\\u06D0\.\≠\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3225\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋉\x{064A}\x{0654}\x{06D0}.=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'\⋉\\u064A\\u0654\\u06D0\.\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3226\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⋉\x{064A}\x{0654}\x{06D0}.=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'\⋉\\u064A\\u0654\\u06D0\.\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3227\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DEE}\x{0366}｡\x{FCC7}\x{1BF3}󠼨", %p)},	undef,	"to_unicode\(\'\\u1DEE\\u0366｡\\uFCC7\\u1BF3\󠼨\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3228\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DEE}\x{0366}。\x{0643}\x{0644}\x{1BF3}󠼨", %p)},	undef,	"to_unicode\(\'\\u1DEE\\u0366\。\\u0643\\u0644\\u1BF3\󠼨\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3229\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴔ\x{0AC5}₃󠁸．𝟳\x{1DE4}𝆈", %p)},	undef,	"to_unicode\(\'Ⴔ\\u0AC5₃\󠁸．𝟳\\u1DE4𝆈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3230\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴔ\x{0AC5}3󠁸.7\x{1DE4}𝆈", %p)},	undef,	"to_unicode\(\'Ⴔ\\u0AC53\󠁸\.7\\u1DE4𝆈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3231\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴔ\x{0AC5}3󠁸.7\x{1DE4}𝆈", %p)},	undef,	"to_unicode\(\'ⴔ\\u0AC53\󠁸\.7\\u1DE4𝆈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3232\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴔ\x{0AC5}₃󠁸．𝟳\x{1DE4}𝆈", %p)},	undef,	"to_unicode\(\'ⴔ\\u0AC5₃\󠁸．𝟳\\u1DE4𝆈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3233\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䏈\x{200C}。\x{200C}⒈𲱳", %p)},	undef,	"to_unicode\(\'䏈\\u200C\。\\u200C⒈𲱳\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3234\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䏈\x{200C}。\x{200C}⒈𲱳", %p)},	undef,	"to_unicode\(\'䏈\\u200C\。\\u200C⒈𲱳\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3235\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䏈\x{200C}。\x{200C}1.𲱳", %p)},	undef,	"to_unicode\(\'䏈\\u200C\。\\u200C1\.𲱳\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3236\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䏈\x{200C}。\x{200C}1.𲱳", %p)},	undef,	"to_unicode\(\'䏈\\u200C\。\\u200C1\.𲱳\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3237\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("１𑁆ß\x{2CF0}｡󠓏", %p)},	undef,	"to_unicode\(\'１𑁆ß\\u2CF0｡\󠓏\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3238\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1𑁆ß\x{2CF0}。󠓏", %p)},	undef,	"to_unicode\(\'1𑁆ß\\u2CF0\。\󠓏\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3239\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1𑁆SS\x{2CF0}。󠓏", %p)},	undef,	"to_unicode\(\'1𑁆SS\\u2CF0\。\󠓏\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3240\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1𑁆ss\x{2CF0}。󠓏", %p)},	undef,	"to_unicode\(\'1𑁆ss\\u2CF0\。\󠓏\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3241\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1𑁆Ss\x{2CF0}。󠓏", %p)},	undef,	"to_unicode\(\'1𑁆Ss\\u2CF0\。\󠓏\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3242\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("１𑁆SS\x{2CF0}｡󠓏", %p)},	undef,	"to_unicode\(\'１𑁆SS\\u2CF0｡\󠓏\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3243\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("１𑁆ss\x{2CF0}｡󠓏", %p)},	undef,	"to_unicode\(\'１𑁆ss\\u2CF0｡\󠓏\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3244\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("１𑁆Ss\x{2CF0}｡󠓏", %p)},	undef,	"to_unicode\(\'１𑁆Ss\\u2CF0｡\󠓏\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3245\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}򠙛𞭯\x{A806}｡ᡮ⒈", %p)},	undef,	"to_unicode\(\'\\u200D򠙛𞭯\\uA806｡ᡮ⒈\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3246\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}򠙛𞭯\x{A806}｡ᡮ⒈", %p)},	undef,	"to_unicode\(\'\\u200D򠙛𞭯\\uA806｡ᡮ⒈\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3247\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}򠙛𞭯\x{A806}。ᡮ1.", %p)},	undef,	"to_unicode\(\'\\u200D򠙛𞭯\\uA806\。ᡮ1\.\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3248\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}򠙛𞭯\x{A806}。ᡮ1.", %p)},	undef,	"to_unicode\(\'\\u200D򠙛𞭯\\uA806\。ᡮ1\.\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3249\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠇙．𞾾󢲮򜠀𐫘", %p)},	undef,	"to_unicode\(\'\󠇙．𞾾󢲮򜠀𐫘\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:3250\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠇙.𞾾󢲮򜠀𐫘", %p)},	undef,	"to_unicode\(\'\󠇙\.𞾾󢲮򜠀𐫘\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:3251\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{071B}𞭈⒈．⛊８򀄷\x{08AA}", %p)},	undef,	"to_unicode\(\'\\u071B𞭈⒈．\⛊８򀄷\\u08AA\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3252\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{071B}𞭈1..⛊8򀄷\x{08AA}", %p)},	undef,	"to_unicode\(\'\\u071B𞭈1\.\.\⛊8򀄷\\u08AA\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:3253\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠅄\x{07E9}𑈯\x{06D0}。-󠓉󙒛", %p)},	undef,	"to_unicode\(\'\󠅄\\u07E9𑈯\\u06D0\。\-\󠓉󙒛\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3254\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-.\x{1734}剘ß\x{06B0}", %p)},	undef,	"to_unicode\(\'\-\.\\u1734剘ß\\u06B0\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:3255\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-.\x{1734}剘SS\x{06B0}", %p)},	undef,	"to_unicode\(\'\-\.\\u1734剘SS\\u06B0\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:3256\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-.\x{1734}剘ss\x{06B0}", %p)},	undef,	"to_unicode\(\'\-\.\\u1734剘ss\\u06B0\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:3257\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-.\x{1734}剘Ss\x{06B0}", %p)},	undef,	"to_unicode\(\'\-\.\\u1734剘Ss\\u06B0\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:3258\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🌞𞿦｡-", %p)},	undef,	"to_unicode\(\'🌞𞿦｡\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:3259\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🌞𞿦。-", %p)},	undef,	"to_unicode\(\'🌞𞿦\。\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:3260\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈󠽆𐹸｡≠𐹻𐹦", %p)},	undef,	"to_unicode\(\'⒈\󠽆𐹸｡\≠𐹻𐹦\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3261\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈󠽆𐹸｡=\x{0338}𐹻𐹦", %p)},	undef,	"to_unicode\(\'⒈\󠽆𐹸｡\=\\u0338𐹻𐹦\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3262\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.󠽆𐹸。≠𐹻𐹦", %p)},	undef,	"to_unicode\(\'1\.\󠽆𐹸\。\≠𐹻𐹦\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3263\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.󠽆𐹸。=\x{0338}𐹻𐹦", %p)},	undef,	"to_unicode\(\'1\.\󠽆𐹸\。\=\\u0338𐹻𐹦\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3264\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹠󠬾Ⴎ\x{200C}.㖾\x{0669}", %p)},	undef,	"to_unicode\(\'𐹠\󠬾Ⴎ\\u200C\.㖾\\u0669\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3265\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹠󠬾Ⴎ\x{200C}.㖾\x{0669}", %p)},	undef,	"to_unicode\(\'𐹠\󠬾Ⴎ\\u200C\.㖾\\u0669\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3266\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹠󠬾ⴎ\x{200C}.㖾\x{0669}", %p)},	undef,	"to_unicode\(\'𐹠\󠬾ⴎ\\u200C\.㖾\\u0669\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3267\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹠󠬾ⴎ\x{200C}.㖾\x{0669}", %p)},	undef,	"to_unicode\(\'𐹠\󠬾ⴎ\\u200C\.㖾\\u0669\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3268\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𱅿．\x{07C7}\x{06B8}ႳႧ", %p)},	undef,	"to_unicode\(\'𱅿．\\u07C7\\u06B8ႳႧ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3269\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𱅿.\x{07C7}\x{06B8}ႳႧ", %p)},	undef,	"to_unicode\(\'𱅿\.\\u07C7\\u06B8ႳႧ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3270\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𱅿.\x{07C7}\x{06B8}ⴓⴇ", %p)},	undef,	"to_unicode\(\'𱅿\.\\u07C7\\u06B8ⴓⴇ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3271\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𱅿.\x{07C7}\x{06B8}Ⴓⴇ", %p)},	undef,	"to_unicode\(\'𱅿\.\\u07C7\\u06B8Ⴓⴇ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3272\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𱅿．\x{07C7}\x{06B8}ⴓⴇ", %p)},	undef,	"to_unicode\(\'𱅿．\\u07C7\\u06B8ⴓⴇ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3273\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𱅿．\x{07C7}\x{06B8}Ⴓⴇ", %p)},	undef,	"to_unicode\(\'𱅿．\\u07C7\\u06B8Ⴓⴇ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3274\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}󊝻.𞠞𐭫", %p)},	undef,	"to_unicode\(\'\\u200D󊝻\.𞠞𐭫\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3275\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}󊝻.𞠞𐭫", %p)},	undef,	"to_unicode\(\'\\u200D󊝻\.𞠞𐭫\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3276\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󲔏⒛󠊁．ᠯ⒈", %p)},	undef,	"to_unicode\(\'󲔏⒛\󠊁．ᠯ⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3277\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󲔏20.󠊁.ᠯ1.", %p)},	undef,	"to_unicode\(\'󲔏20\.\󠊁\.ᠯ1\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3278\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{075E}８𻪑-｡񅴬𑇀𐪞\x{09CD}", %p)},	undef,	"to_unicode\(\'\\u075E８𻪑\-｡񅴬𑇀𐪞\\u09CD\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3279\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{075E}8𻪑-。񅴬𑇀𐪞\x{09CD}", %p)},	undef,	"to_unicode\(\'\\u075E8𻪑\-\。񅴬𑇀𐪞\\u09CD\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3280\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴕ。۰≮ß𐨍", %p)},	undef,	"to_unicode\(\'Ⴕ\。۰\≮ß𐨍\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3281\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴕ。۰<\x{0338}ß𐨍", %p)},	undef,	"to_unicode\(\'Ⴕ\。۰\<\\u0338ß𐨍\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3282\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴕ。۰<\x{0338}ß𐨍", %p)},	undef,	"to_unicode\(\'ⴕ\。۰\<\\u0338ß𐨍\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3283\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴕ。۰≮ß𐨍", %p)},	undef,	"to_unicode\(\'ⴕ\。۰\≮ß𐨍\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3284\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴕ。۰≮SS𐨍", %p)},	undef,	"to_unicode\(\'Ⴕ\。۰\≮SS𐨍\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3285\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴕ。۰<\x{0338}SS𐨍", %p)},	undef,	"to_unicode\(\'Ⴕ\。۰\<\\u0338SS𐨍\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3286\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴕ。۰<\x{0338}ss𐨍", %p)},	undef,	"to_unicode\(\'ⴕ\。۰\<\\u0338ss𐨍\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3287\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴕ。۰≮ss𐨍", %p)},	undef,	"to_unicode\(\'ⴕ\。۰\≮ss𐨍\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3288\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴕ。۰≮Ss𐨍", %p)},	undef,	"to_unicode\(\'Ⴕ\。۰\≮Ss𐨍\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3289\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴕ。۰<\x{0338}Ss𐨍", %p)},	undef,	"to_unicode\(\'Ⴕ\。۰\<\\u0338Ss𐨍\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3290\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{076F}-.\x{0F19}꒱\x{0FA4}", %p)},	undef,	"to_unicode\(\'\\u076F\-\.\\u0F19꒱\\u0FA4\'\)\ throws\ error\ V3\ V5\ B3\ \[data\/IdnaTest\.txt\:3291\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{06FC}\x{200C}.≯䕵🍀", %p)},	undef,	"to_unicode\(\'\\u06FC\\u200C\.\≯䕵🍀\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:3292\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06FC}\x{200C}.≯䕵🍀", %p)},	undef,	"to_unicode\(\'\\u06FC\\u200C\.\≯䕵🍀\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:3293\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06FC}\x{200C}.>\x{0338}䕵🍀", %p)},	undef,	"to_unicode\(\'\\u06FC\\u200C\.\>\\u0338䕵🍀\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:3294\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06FC}\x{200C}.>\x{0338}䕵🍀", %p)},	undef,	"to_unicode\(\'\\u06FC\\u200C\.\>\\u0338䕵🍀\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:3295\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{034F}ß\x{FD90}.𐫚۳︒", %p)},	undef,	"to_unicode\(\'\\u034Fß\\uFD90\.𐫚۳︒\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B3\ \[data\/IdnaTest\.txt\:3296\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{034F}ß\x{FD90}.𐫚۳。", %p)},	undef,	"to_unicode\(\'\\u034Fß\\uFD90\.𐫚۳\。\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3297\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{034F}SS\x{FD90}.𐫚۳。", %p)},	undef,	"to_unicode\(\'\\u034FSS\\uFD90\.𐫚۳\。\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3298\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{034F}ss\x{FD90}.𐫚۳。", %p)},	undef,	"to_unicode\(\'\\u034Fss\\uFD90\.𐫚۳\。\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3299\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{034F}Ss\x{FD90}.𐫚۳。", %p)},	undef,	"to_unicode\(\'\\u034FSs\\uFD90\.𐫚۳\。\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3300\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{034F}SS\x{FD90}.𐫚۳︒", %p)},	undef,	"to_unicode\(\'\\u034FSS\\uFD90\.𐫚۳︒\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B3\ \[data\/IdnaTest\.txt\:3301\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{034F}ss\x{FD90}.𐫚۳︒", %p)},	undef,	"to_unicode\(\'\\u034Fss\\uFD90\.𐫚۳︒\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B3\ \[data\/IdnaTest\.txt\:3302\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{034F}Ss\x{FD90}.𐫚۳︒", %p)},	undef,	"to_unicode\(\'\\u034FSs\\uFD90\.𐫚۳︒\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B3\ \[data\/IdnaTest\.txt\:3303\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-≮⤨\x{1DD8}.󠴭Ⴁᡓ", %p)},	undef,	"to_unicode\(\'\-\≮\⤨\\u1DD8\.\󠴭Ⴁᡓ\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3304\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-<\x{0338}⤨\x{1DD8}.󠴭Ⴁᡓ", %p)},	undef,	"to_unicode\(\'\-\<\\u0338\⤨\\u1DD8\.\󠴭Ⴁᡓ\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3305\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-<\x{0338}⤨\x{1DD8}.󠴭ⴁᡓ", %p)},	undef,	"to_unicode\(\'\-\<\\u0338\⤨\\u1DD8\.\󠴭ⴁᡓ\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3306\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-≮⤨\x{1DD8}.󠴭ⴁᡓ", %p)},	undef,	"to_unicode\(\'\-\≮\⤨\\u1DD8\.\󠴭ⴁᡓ\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3307\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐮉｡ᢟ\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'𐮉｡ᢟ\\u200D\\u200C\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3308\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐮉｡ᢟ\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'𐮉｡ᢟ\\u200D\\u200C\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3309\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐮉。ᢟ\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'𐮉\。ᢟ\\u200D\\u200C\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3310\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐮉。ᢟ\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'𐮉\。ᢟ\\u200D\\u200C\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3311\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--g29c.xn--pbf", %p)},	"𐮉.ᢟ",	"to_unicode\(\'xn\-\-g29c\.xn\-\-pbf\'\)\ \[data\/IdnaTest\.txt\:3312\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐮉.ᢟ", %p)},	"𐮉.ᢟ",	"to_unicode\(\'𐮉\.ᢟ\'\)\ \[data\/IdnaTest\.txt\:3313\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("𝩑𑍲．ꡣ\x{1DFF}𐹢", %p)},	undef,	"to_unicode\(\'𝩑𑍲．ꡣ\\u1DFF𐹢\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:3314\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("𝩑𑍲.ꡣ\x{1DFF}𐹢", %p)},	undef,	"to_unicode\(\'𝩑𑍲\.ꡣ\\u1DFF𐹢\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:3315\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⅎ󠀽𵭘。≯⾑", %p)},	undef,	"to_unicode\(\'Ⅎ\󠀽𵭘\。\≯⾑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3316\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ󠀽𵭘。>\x{0338}⾑", %p)},	undef,	"to_unicode\(\'Ⅎ\󠀽𵭘\。\>\\u0338⾑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3317\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ󠀽𵭘。≯襾", %p)},	undef,	"to_unicode\(\'Ⅎ\󠀽𵭘\。\≯襾\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3318\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ󠀽𵭘。>\x{0338}襾", %p)},	undef,	"to_unicode\(\'Ⅎ\󠀽𵭘\。\>\\u0338襾\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3319\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ󠀽𵭘。>\x{0338}襾", %p)},	undef,	"to_unicode\(\'ⅎ\󠀽𵭘\。\>\\u0338襾\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3320\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ󠀽𵭘。≯襾", %p)},	undef,	"to_unicode\(\'ⅎ\󠀽𵭘\。\≯襾\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3321\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ󠀽𵭘。>\x{0338}⾑", %p)},	undef,	"to_unicode\(\'ⅎ\󠀽𵭘\。\>\\u0338⾑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3322\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ󠀽𵭘。≯⾑", %p)},	undef,	"to_unicode\(\'ⅎ\󠀽𵭘\。\≯⾑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3323\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ς\x{200D}\x{0EBC}𐹯｡-", %p)},	undef,	"to_unicode\(\'ς\\u200D\\u0EBC𐹯｡\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3324\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ς\x{200D}\x{0EBC}𐹯｡-", %p)},	undef,	"to_unicode\(\'ς\\u200D\\u0EBC𐹯｡\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3325\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ς\x{200D}\x{0EBC}𐹯。-", %p)},	undef,	"to_unicode\(\'ς\\u200D\\u0EBC𐹯\。\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3326\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("ς\x{200D}\x{0EBC}𐹯。-", %p)},	undef,	"to_unicode\(\'ς\\u200D\\u0EBC𐹯\。\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3327\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("Σ\x{200D}\x{0EBC}𐹯。-", %p)},	undef,	"to_unicode\(\'Σ\\u200D\\u0EBC𐹯\。\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3328\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("Σ\x{200D}\x{0EBC}𐹯。-", %p)},	undef,	"to_unicode\(\'Σ\\u200D\\u0EBC𐹯\。\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3329\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("σ\x{200D}\x{0EBC}𐹯。-", %p)},	undef,	"to_unicode\(\'σ\\u200D\\u0EBC𐹯\。\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3330\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("σ\x{200D}\x{0EBC}𐹯。-", %p)},	undef,	"to_unicode\(\'σ\\u200D\\u0EBC𐹯\。\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3331\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("Σ\x{200D}\x{0EBC}𐹯｡-", %p)},	undef,	"to_unicode\(\'Σ\\u200D\\u0EBC𐹯｡\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3332\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("Σ\x{200D}\x{0EBC}𐹯｡-", %p)},	undef,	"to_unicode\(\'Σ\\u200D\\u0EBC𐹯｡\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3333\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("σ\x{200D}\x{0EBC}𐹯｡-", %p)},	undef,	"to_unicode\(\'σ\\u200D\\u0EBC𐹯｡\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3334\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("σ\x{200D}\x{0EBC}𐹯｡-", %p)},	undef,	"to_unicode\(\'σ\\u200D\\u0EBC𐹯｡\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3335\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}.ßႩ-", %p)},	undef,	"to_unicode\(\'\\u200C\.ßႩ\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:3336\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.ßႩ-", %p)},	undef,	"to_unicode\(\'\\u200C\.ßႩ\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:3337\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}.ßⴉ-", %p)},	undef,	"to_unicode\(\'\\u200C\.ßⴉ\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3338\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}.ßⴉ-", %p)},	undef,	"to_unicode\(\'\\u200C\.ßⴉ\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3339\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}.SSႩ-", %p)},	undef,	"to_unicode\(\'\\u200C\.SSႩ\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:3340\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.SSႩ-", %p)},	undef,	"to_unicode\(\'\\u200C\.SSႩ\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:3341\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}.ssⴉ-", %p)},	undef,	"to_unicode\(\'\\u200C\.ssⴉ\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3342\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}.ssⴉ-", %p)},	undef,	"to_unicode\(\'\\u200C\.ssⴉ\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3343\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}.Ssⴉ-", %p)},	undef,	"to_unicode\(\'\\u200C\.Ssⴉ\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3344\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{200C}.Ssⴉ-", %p)},	undef,	"to_unicode\(\'\\u200C\.Ssⴉ\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3345\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("󆎶ᡄ㓱。⾑", %p)},	undef,	"to_unicode\(\'󆎶ᡄ㓱\。⾑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3346\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󆎶ᡄ㓱。襾", %p)},	undef,	"to_unicode\(\'󆎶ᡄ㓱\。襾\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3347\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡥ\x{06D5}\x{0665}≮。≯⯯\x{200D}", %p)},	undef,	"to_unicode\(\'ꡥ\\u06D5\\u0665\≮\。\≯\⯯\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3348\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡥ\x{06D5}\x{0665}≮。≯⯯\x{200D}", %p)},	undef,	"to_unicode\(\'ꡥ\\u06D5\\u0665\≮\。\≯\⯯\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3349\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡥ\x{06D5}\x{0665}<\x{0338}。>\x{0338}⯯\x{200D}", %p)},	undef,	"to_unicode\(\'ꡥ\\u06D5\\u0665\<\\u0338\。\>\\u0338\⯯\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3350\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡥ\x{06D5}\x{0665}<\x{0338}。>\x{0338}⯯\x{200D}", %p)},	undef,	"to_unicode\(\'ꡥ\\u06D5\\u0665\<\\u0338\。\>\\u0338\⯯\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3351\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟞｡󛼏ꡛᠪ⩋", %p)},	undef,	"to_unicode\(\'𝟞｡󛼏ꡛᠪ\⩋\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3352\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("6。󛼏ꡛᠪ⩋", %p)},	undef,	"to_unicode\(\'6\。󛼏ꡛᠪ\⩋\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3353\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("-𐣴。\x{2DE5}\x{2D7F}", %p)},	undef,	"to_unicode\(\'\-𐣴\。\\u2DE5\\u2D7F\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:3354\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("-𐣴。\x{2D7F}\x{2DE5}", %p)},	undef,	"to_unicode\(\'\-𐣴\。\\u2D7F\\u2DE5\'\)\ throws\ error\ V3\ V5\ B1\ \[data\/IdnaTest\.txt\:3355\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}⼨𝟏.𝨨񊚚\x{0665}򤝋", %p)},	undef,	"to_unicode\(\'\\u200C⼨𝟏\.𝨨񊚚\\u0665򤝋\'\)\ throws\ error\ P1\ V5\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:3356\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}⼨𝟏.𝨨񊚚\x{0665}򤝋", %p)},	undef,	"to_unicode\(\'\\u200C⼨𝟏\.𝨨񊚚\\u0665򤝋\'\)\ throws\ error\ P1\ V5\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:3357\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}寸1.𝨨񊚚\x{0665}򤝋", %p)},	undef,	"to_unicode\(\'\\u200C寸1\.𝨨񊚚\\u0665򤝋\'\)\ throws\ error\ P1\ V5\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:3358\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}寸1.𝨨񊚚\x{0665}򤝋", %p)},	undef,	"to_unicode\(\'\\u200C寸1\.𝨨񊚚\\u0665򤝋\'\)\ throws\ error\ P1\ V5\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:3359\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("齙--𝟰.ß", %p)},	"齙--4.ß",	"to_unicode\(\'齙\-\-𝟰\.ß\'\)\ \[data\/IdnaTest\.txt\:3360\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("齙--𝟰.ß", %p)},	"齙--4.ß",	"to_unicode\(\'齙\-\-𝟰\.ß\'\)\ \[data\/IdnaTest\.txt\:3361\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("齙--4.ß", %p)},	"齙--4.ß",	"to_unicode\(\'齙\-\-4\.ß\'\)\ \[data\/IdnaTest\.txt\:3362\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("齙--4.ß", %p)},	"齙--4.ß",	"to_unicode\(\'齙\-\-4\.ß\'\)\ \[data\/IdnaTest\.txt\:3363\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("齙--4.SS", %p)},	"齙--4.ss",	"to_unicode\(\'齙\-\-4\.SS\'\)\ \[data\/IdnaTest\.txt\:3364\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn----4-p16k.ss", %p)},	"齙--4.ss",	"to_unicode\(\'xn\-\-\-\-4\-p16k\.ss\'\)\ \[data\/IdnaTest\.txt\:3365\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn----4-p16k.xn--zca", %p)},	"齙--4.ß",	"to_unicode\(\'xn\-\-\-\-4\-p16k\.xn\-\-zca\'\)\ \[data\/IdnaTest\.txt\:3366\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("齙--𝟰.SS", %p)},	"齙--4.ss",	"to_unicode\(\'齙\-\-𝟰\.SS\'\)\ \[data\/IdnaTest\.txt\:3367\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0B4D}.\x{0660}𐨌\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0B4D\.\\u0660𐨌\\u200C\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:3368\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0B4D}.\x{0660}𐨌\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0B4D\.\\u0660𐨌\\u200C\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:3369\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{AB27}𑖼｡\x{DEDE}-\x{200D}", %p)},	undef,	"to_unicode\(\'\\uAB27𑖼｡\\uDEDE\-\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3370\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{AB27}𑖼｡\x{DEDE}-\x{200D}", %p)},	undef,	"to_unicode\(\'\\uAB27𑖼｡\\uDEDE\-\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3371\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{AB27}𑖼。\x{DEDE}-\x{200D}", %p)},	undef,	"to_unicode\(\'\\uAB27𑖼\。\\uDEDE\-\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3372\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{AB27}𑖼。\x{DEDE}-\x{200D}", %p)},	undef,	"to_unicode\(\'\\uAB27𑖼\。\\uDEDE\-\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3373\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{AB27}𑖼", %p)},	undef,	"to_unicode\(\'\\uAB27𑖼\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3374\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{0ACD}．\x{08A3}-\x{0591}悎", %p)},	undef,	"to_unicode\(\'\\u0ACD．\\u08A3\-\\u0591悎\'\)\ throws\ error\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:3375\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{0ACD}.\x{08A3}-\x{0591}悎", %p)},	undef,	"to_unicode\(\'\\u0ACD\.\\u08A3\-\\u0591悎\'\)\ throws\ error\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:3376\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("񹭻󠗀．\x{067B}􆘢", %p)},	undef,	"to_unicode\(\'񹭻\󠗀．\\u067B􆘢\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3377\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񹭻󠗀.\x{067B}􆘢", %p)},	undef,	"to_unicode\(\'񹭻\󠗀\.\\u067B􆘢\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3378\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ᡨ𞺲\x{07D1}.𐋲", %p)},	undef,	"to_unicode\(\'ᡨ𞺲\\u07D1\.𐋲\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:3379\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ᡨ\x{0642}\x{07D1}.𐋲", %p)},	undef,	"to_unicode\(\'ᡨ\\u0642\\u07D1\.𐋲\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:3380\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𐰿ꡏ\x{06BB}\x{0668}.\x{DF56}", %p)},	undef,	"to_unicode\(\'𐰿ꡏ\\u06BB\\u0668\.\\uDF56\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:3381\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐰿ꡏ\x{06BB}\x{0668}", %p)},	undef,	"to_unicode\(\'𐰿ꡏ\\u06BB\\u0668\'\)\ throws\ error\ B2\ \[data\/IdnaTest\.txt\:3382\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ↄ。\x{1734}\x{0E47}𞻻", %p)},	undef,	"to_unicode\(\'Ↄ\。\\u1734\\u0E47𞻻\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3383\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ↄ。\x{1734}\x{0E47}𞻻", %p)},	undef,	"to_unicode\(\'ↄ\。\\u1734\\u0E47𞻻\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3384\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⭂-。𭨲≮𑚶", %p)},	undef,	"to_unicode\(\'\⭂\-\。𭨲\≮𑚶\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3385\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⭂-。𭨲<\x{0338}𑚶", %p)},	undef,	"to_unicode\(\'\⭂\-\。𭨲\<\\u0338𑚶\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3386\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠆷\x{200D}。𚦖≮Ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C\󠆷\\u200D\。𚦖\≮Ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3387\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠆷\x{200D}。𚦖≮Ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C\󠆷\\u200D\。𚦖\≮Ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3388\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠆷\x{200D}。𚦖<\x{0338}Ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C\󠆷\\u200D\。𚦖\<\\u0338Ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3389\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠆷\x{200D}。𚦖<\x{0338}Ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C\󠆷\\u200D\。𚦖\<\\u0338Ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3390\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠆷\x{200D}。𚦖<\x{0338}ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C\󠆷\\u200D\。𚦖\<\\u0338ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3391\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠆷\x{200D}。𚦖<\x{0338}ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C\󠆷\\u200D\。𚦖\<\\u0338ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3392\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠆷\x{200D}。𚦖≮ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C\󠆷\\u200D\。𚦖\≮ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3393\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠆷\x{200D}。𚦖≮ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C\󠆷\\u200D\。𚦖\≮ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3394\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹡-\x{AAF6}ꡨ。︒䖐⾆", %p)},	undef,	"to_unicode\(\'𐹡\-\\uAAF6ꡨ\。︒䖐⾆\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3395\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("𐹡-\x{AAF6}ꡨ。。䖐舌", %p)},	undef,	"to_unicode\(\'𐹡\-\\uAAF6ꡨ\。\。䖐舌\'\)\ throws\ error\ B1\ A4_2\ \[data\/IdnaTest\.txt\:3396\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0F79}Ⴐ｡쪡", %p)},	undef,	"to_unicode\(\'\\u0F79Ⴐ｡쪡\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3397\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0F79}Ⴐ｡쪡", %p)},	undef,	"to_unicode\(\'\\u0F79Ⴐ｡쪡\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3398\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FB3}\x{0F71}\x{0F80}Ⴐ。쪡", %p)},	undef,	"to_unicode\(\'\\u0FB3\\u0F71\\u0F80Ⴐ\。쪡\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3399\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FB3}\x{0F71}\x{0F80}Ⴐ。쪡", %p)},	undef,	"to_unicode\(\'\\u0FB3\\u0F71\\u0F80Ⴐ\。쪡\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3400\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0FB3}\x{0F71}\x{0F80}ⴐ。쪡", %p)},	undef,	"to_unicode\(\'\\u0FB3\\u0F71\\u0F80ⴐ\。쪡\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3401\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0FB3}\x{0F71}\x{0F80}ⴐ。쪡", %p)},	undef,	"to_unicode\(\'\\u0FB3\\u0F71\\u0F80ⴐ\。쪡\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3402\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0F79}ⴐ｡쪡", %p)},	undef,	"to_unicode\(\'\\u0F79ⴐ｡쪡\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3403\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0F79}ⴐ｡쪡", %p)},	undef,	"to_unicode\(\'\\u0F79ⴐ｡쪡\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3404\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0ACD}쩁𐹡.󿍹", %p)},	undef,	"to_unicode\(\'\\u0ACD쩁𐹡\.󿍹\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3405\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0ACD}쩁𐹡.󿍹", %p)},	undef,	"to_unicode\(\'\\u0ACD쩁𐹡\.󿍹\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3406\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡐ０\x{200C}｡󠴚𕎃", %p)},	undef,	"to_unicode\(\'ꡐ０\\u200C｡\󠴚𕎃\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3407\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡐ０\x{200C}｡󠴚𕎃", %p)},	undef,	"to_unicode\(\'ꡐ０\\u200C｡\󠴚𕎃\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3408\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡐ0\x{200C}。󠴚𕎃", %p)},	undef,	"to_unicode\(\'ꡐ0\\u200C\。\󠴚𕎃\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3409\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡐ0\x{200C}。󠴚𕎃", %p)},	undef,	"to_unicode\(\'ꡐ0\\u200C\。\󠴚𕎃\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3410\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("忰９ꍩ\x{1BE9}．\x{200D}ß", %p)},	undef,	"to_unicode\(\'忰９ꍩ\\u1BE9．\\u200Dß\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3411\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("忰９ꍩ\x{1BE9}．\x{200D}ß", %p)},	undef,	"to_unicode\(\'忰９ꍩ\\u1BE9．\\u200Dß\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3412\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("忰9ꍩ\x{1BE9}.\x{200D}ß", %p)},	undef,	"to_unicode\(\'忰9ꍩ\\u1BE9\.\\u200Dß\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3413\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("忰9ꍩ\x{1BE9}.\x{200D}ß", %p)},	undef,	"to_unicode\(\'忰9ꍩ\\u1BE9\.\\u200Dß\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3414\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("忰9ꍩ\x{1BE9}.\x{200D}SS", %p)},	undef,	"to_unicode\(\'忰9ꍩ\\u1BE9\.\\u200DSS\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3415\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("忰9ꍩ\x{1BE9}.\x{200D}SS", %p)},	undef,	"to_unicode\(\'忰9ꍩ\\u1BE9\.\\u200DSS\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3416\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("忰9ꍩ\x{1BE9}.\x{200D}ss", %p)},	undef,	"to_unicode\(\'忰9ꍩ\\u1BE9\.\\u200Dss\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3417\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("忰9ꍩ\x{1BE9}.\x{200D}ss", %p)},	undef,	"to_unicode\(\'忰9ꍩ\\u1BE9\.\\u200Dss\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3418\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("忰9ꍩ\x{1BE9}.\x{200D}Ss", %p)},	undef,	"to_unicode\(\'忰9ꍩ\\u1BE9\.\\u200DSs\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3419\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("忰9ꍩ\x{1BE9}.\x{200D}Ss", %p)},	undef,	"to_unicode\(\'忰9ꍩ\\u1BE9\.\\u200DSs\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3420\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("xn--9-9pl2595ado0c.ss", %p)},	"忰9ꍩ\x{1BE9}.ss",	"to_unicode\(\'xn\-\-9\-9pl2595ado0c\.ss\'\)\ \[data\/IdnaTest\.txt\:3421\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("忰9ꍩ\x{1BE9}.ss", %p)},	"忰9ꍩ\x{1BE9}.ss",	"to_unicode\(\'忰9ꍩ\\u1BE9\.ss\'\)\ \[data\/IdnaTest\.txt\:3422\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("忰９ꍩ\x{1BE9}．\x{200D}SS", %p)},	undef,	"to_unicode\(\'忰９ꍩ\\u1BE9．\\u200DSS\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3423\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("忰９ꍩ\x{1BE9}．\x{200D}SS", %p)},	undef,	"to_unicode\(\'忰９ꍩ\\u1BE9．\\u200DSS\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3424\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("忰９ꍩ\x{1BE9}．\x{200D}ss", %p)},	undef,	"to_unicode\(\'忰９ꍩ\\u1BE9．\\u200Dss\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3425\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("忰９ꍩ\x{1BE9}．\x{200D}ss", %p)},	undef,	"to_unicode\(\'忰９ꍩ\\u1BE9．\\u200Dss\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3426\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("忰９ꍩ\x{1BE9}．\x{200D}Ss", %p)},	undef,	"to_unicode\(\'忰９ꍩ\\u1BE9．\\u200DSs\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3427\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("忰９ꍩ\x{1BE9}．\x{200D}Ss", %p)},	undef,	"to_unicode\(\'忰９ꍩ\\u1BE9．\\u200DSs\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3428\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ꗷ\x{1BAB}.\x{069C}𞣶", %p)},	undef,	"to_unicode\(\'ꗷ\\u1BAB\.\\u069C𞣶\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3429\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒐≯-。︒򐇻-񍘎", %p)},	undef,	"to_unicode\(\'⒐\≯\-\。︒򐇻\-񍘎\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3430\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒐>\x{0338}-。︒򐇻-񍘎", %p)},	undef,	"to_unicode\(\'⒐\>\\u0338\-\。︒򐇻\-񍘎\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3431\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("9.≯-。。򐇻-񍘎", %p)},	undef,	"to_unicode\(\'9\.\≯\-\。\。򐇻\-񍘎\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3432\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("9.>\x{0338}-。。򐇻-񍘎", %p)},	undef,	"to_unicode\(\'9\.\>\\u0338\-\。\。򐇻\-񍘎\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3433\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񌜃\x{A8EB}Ⴡ󠣼．\x{0847}", %p)},	undef,	"to_unicode\(\'񌜃\\uA8EBჁ\󠣼．\\u0847\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3434\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񌜃\x{A8EB}Ⴡ󠣼.\x{0847}", %p)},	undef,	"to_unicode\(\'񌜃\\uA8EBჁ\󠣼\.\\u0847\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3435\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񌜃\x{A8EB}ⴡ󠣼.\x{0847}", %p)},	undef,	"to_unicode\(\'񌜃\\uA8EBⴡ\󠣼\.\\u0847\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3436\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񌜃\x{A8EB}ⴡ󠣼．\x{0847}", %p)},	undef,	"to_unicode\(\'񌜃\\uA8EBⴡ\󠣼．\\u0847\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3437\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{1DCB}。𐋩ᢥ-ᡕ", %p)},	undef,	"to_unicode\(\'\\u1DCB\。𐋩ᢥ\-ᡕ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3438\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("싇。⾇𐼓Ⴝ", %p)},	undef,	"to_unicode\(\'싇\。⾇𐼓Ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3439\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("싇。⾇𐼓Ⴝ", %p)},	undef,	"to_unicode\(\'싇\。⾇𐼓Ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3440\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("싇。舛𐼓Ⴝ", %p)},	undef,	"to_unicode\(\'싇\。舛𐼓Ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3441\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("싇。舛𐼓Ⴝ", %p)},	undef,	"to_unicode\(\'싇\。舛𐼓Ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3442\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("싇。舛𐼓ⴝ", %p)},	undef,	"to_unicode\(\'싇\。舛𐼓ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3443\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("싇。舛𐼓ⴝ", %p)},	undef,	"to_unicode\(\'싇\。舛𐼓ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3444\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("싇。⾇𐼓ⴝ", %p)},	undef,	"to_unicode\(\'싇\。⾇𐼓ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3445\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("싇。⾇𐼓ⴝ", %p)},	undef,	"to_unicode\(\'싇\。⾇𐼓ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3446\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹮ς。\x{200C}\x{07D4}Ⴠ", %p)},	undef,	"to_unicode\(\'𐹮ς\。\\u200C\\u07D4Ⴠ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3447\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹮ς。\x{200C}\x{07D4}Ⴠ", %p)},	undef,	"to_unicode\(\'𐹮ς\。\\u200C\\u07D4Ⴠ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3448\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹮ς。\x{200C}\x{07D4}ⴠ", %p)},	undef,	"to_unicode\(\'𐹮ς\。\\u200C\\u07D4ⴠ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:3449\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹮ς。\x{200C}\x{07D4}ⴠ", %p)},	undef,	"to_unicode\(\'𐹮ς\。\\u200C\\u07D4ⴠ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:3450\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𐹮Σ。\x{200C}\x{07D4}Ⴠ", %p)},	undef,	"to_unicode\(\'𐹮Σ\。\\u200C\\u07D4Ⴠ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3451\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹮Σ。\x{200C}\x{07D4}Ⴠ", %p)},	undef,	"to_unicode\(\'𐹮Σ\。\\u200C\\u07D4Ⴠ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3452\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹮σ。\x{200C}\x{07D4}ⴠ", %p)},	undef,	"to_unicode\(\'𐹮σ\。\\u200C\\u07D4ⴠ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:3453\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹮σ。\x{200C}\x{07D4}ⴠ", %p)},	undef,	"to_unicode\(\'𐹮σ\。\\u200C\\u07D4ⴠ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:3454\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("򗡮\x{200C}𐹲.\x{067A}-ß", %p)},	undef,	"to_unicode\(\'򗡮\\u200C𐹲\.\\u067A\-ß\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3455\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򗡮\x{200C}𐹲.\x{067A}-ß", %p)},	undef,	"to_unicode\(\'򗡮\\u200C𐹲\.\\u067A\-ß\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3456\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򗡮\x{200C}𐹲.\x{067A}-SS", %p)},	undef,	"to_unicode\(\'򗡮\\u200C𐹲\.\\u067A\-SS\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3457\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򗡮\x{200C}𐹲.\x{067A}-SS", %p)},	undef,	"to_unicode\(\'򗡮\\u200C𐹲\.\\u067A\-SS\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3458\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򗡮\x{200C}𐹲.\x{067A}-ss", %p)},	undef,	"to_unicode\(\'򗡮\\u200C𐹲\.\\u067A\-ss\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3459\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򗡮\x{200C}𐹲.\x{067A}-ss", %p)},	undef,	"to_unicode\(\'򗡮\\u200C𐹲\.\\u067A\-ss\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3460\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򗡮\x{200C}𐹲.\x{067A}-Ss", %p)},	undef,	"to_unicode\(\'򗡮\\u200C𐹲\.\\u067A\-Ss\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3461\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򗡮\x{200C}𐹲.\x{067A}-Ss", %p)},	undef,	"to_unicode\(\'򗡮\\u200C𐹲\.\\u067A\-Ss\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3462\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200D}\x{17B5}ᢠ.-𞳲𰞝\x{FEEF}", %p)},	undef,	"to_unicode\(\'\\u200C\\u200D\\u17B5ᢠ\.\-𞳲𰞝\\uFEEF\'\)\ throws\ error\ P1\ V6\ V3\ C1\ C2\ B1\ \[data\/IdnaTest\.txt\:3463\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200D}\x{17B5}ᢠ.-𞳲𰞝\x{FEEF}", %p)},	undef,	"to_unicode\(\'\\u200C\\u200D\\u17B5ᢠ\.\-𞳲𰞝\\uFEEF\'\)\ throws\ error\ P1\ V6\ V3\ C1\ C2\ B1\ \[data\/IdnaTest\.txt\:3464\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200D}\x{17B5}ᢠ.-𞳲𰞝\x{0649}", %p)},	undef,	"to_unicode\(\'\\u200C\\u200D\\u17B5ᢠ\.\-𞳲𰞝\\u0649\'\)\ throws\ error\ P1\ V6\ V3\ C1\ C2\ B1\ \[data\/IdnaTest\.txt\:3465\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200D}\x{17B5}ᢠ.-𞳲𰞝\x{0649}", %p)},	undef,	"to_unicode\(\'\\u200C\\u200D\\u17B5ᢠ\.\-𞳲𰞝\\u0649\'\)\ throws\ error\ P1\ V6\ V3\ C1\ C2\ B1\ \[data\/IdnaTest\.txt\:3466\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񹸓｡\x{0633}≠", %p)},	undef,	"to_unicode\(\'񹸓｡\\u0633\≠\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:3467\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񹸓｡\x{0633}=\x{0338}", %p)},	undef,	"to_unicode\(\'񹸓｡\\u0633\=\\u0338\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:3468\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񹸓。\x{0633}≠", %p)},	undef,	"to_unicode\(\'񹸓\。\\u0633\≠\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:3469\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񹸓。\x{0633}=\x{0338}", %p)},	undef,	"to_unicode\(\'񹸓\。\\u0633\=\\u0338\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:3470\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑍱𞦝｡\x{0668}𐹰덝۵", %p)},	undef,	"to_unicode\(\'𑍱𞦝｡\\u0668𐹰덝۵\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3471\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑍱𞦝｡\x{0668}𐹰덝۵", %p)},	undef,	"to_unicode\(\'𑍱𞦝｡\\u0668𐹰덝۵\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3472\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑍱𞦝。\x{0668}𐹰덝۵", %p)},	undef,	"to_unicode\(\'𑍱𞦝\。\\u0668𐹰덝۵\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3473\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑍱𞦝。\x{0668}𐹰덝۵", %p)},	undef,	"to_unicode\(\'𑍱𞦝\。\\u0668𐹰덝۵\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3474\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴏ󠄭-．\x{200D}Ⴉ", %p)},	undef,	"to_unicode\(\'Ⴏ\󠄭\-．\\u200DႩ\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3475\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴏ󠄭-．\x{200D}Ⴉ", %p)},	undef,	"to_unicode\(\'Ⴏ\󠄭\-．\\u200DႩ\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3476\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴏ󠄭-.\x{200D}Ⴉ", %p)},	undef,	"to_unicode\(\'Ⴏ\󠄭\-\.\\u200DႩ\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3477\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴏ󠄭-.\x{200D}Ⴉ", %p)},	undef,	"to_unicode\(\'Ⴏ\󠄭\-\.\\u200DႩ\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3478\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴏ󠄭-.\x{200D}ⴉ", %p)},	undef,	"to_unicode\(\'ⴏ\󠄭\-\.\\u200Dⴉ\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:3479\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴏ󠄭-.\x{200D}ⴉ", %p)},	undef,	"to_unicode\(\'ⴏ\󠄭\-\.\\u200Dⴉ\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:3480\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴏ󠄭-．\x{200D}ⴉ", %p)},	undef,	"to_unicode\(\'ⴏ\󠄭\-．\\u200Dⴉ\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:3481\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴏ󠄭-．\x{200D}ⴉ", %p)},	undef,	"to_unicode\(\'ⴏ\󠄭\-．\\u200Dⴉ\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:3482\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("󠌣\x{1B6C}¤񼀤。𐹼\x{2063}𝩑", %p)},	undef,	"to_unicode\(\'\󠌣\\u1B6C\¤񼀤\。𐹼\\u2063𝩑\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3483\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠ᡞ.𐅥🄇⒈", %p)},	undef,	"to_unicode\(\'\≠ᡞ\.𐅥🄇⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3484\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}ᡞ.𐅥🄇⒈", %p)},	undef,	"to_unicode\(\'\=\\u0338ᡞ\.𐅥🄇⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3485\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠ᡞ.𐅥6,1.", %p)},	undef,	"to_unicode\(\'\≠ᡞ\.𐅥6\,1\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3486\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}ᡞ.𐅥6,1.", %p)},	undef,	"to_unicode\(\'\=\\u0338ᡞ\.𐅥6\,1\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3487\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9B8}⩩ß.ᠤ򂅯\x{200C}𐹦", %p)},	undef,	"to_unicode\(\'\\uA9B8\⩩ß\.ᠤ򂅯\\u200C𐹦\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3488\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9B8}⩩ß.ᠤ򂅯\x{200C}𐹦", %p)},	undef,	"to_unicode\(\'\\uA9B8\⩩ß\.ᠤ򂅯\\u200C𐹦\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3489\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9B8}⩩SS.ᠤ򂅯\x{200C}𐹦", %p)},	undef,	"to_unicode\(\'\\uA9B8\⩩SS\.ᠤ򂅯\\u200C𐹦\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3490\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9B8}⩩SS.ᠤ򂅯\x{200C}𐹦", %p)},	undef,	"to_unicode\(\'\\uA9B8\⩩SS\.ᠤ򂅯\\u200C𐹦\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3491\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9B8}⩩ss.ᠤ򂅯\x{200C}𐹦", %p)},	undef,	"to_unicode\(\'\\uA9B8\⩩ss\.ᠤ򂅯\\u200C𐹦\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3492\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9B8}⩩ss.ᠤ򂅯\x{200C}𐹦", %p)},	undef,	"to_unicode\(\'\\uA9B8\⩩ss\.ᠤ򂅯\\u200C𐹦\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3493\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9B8}⩩Ss.ᠤ򂅯\x{200C}𐹦", %p)},	undef,	"to_unicode\(\'\\uA9B8\⩩Ss\.ᠤ򂅯\\u200C𐹦\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3494\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9B8}⩩Ss.ᠤ򂅯\x{200C}𐹦", %p)},	undef,	"to_unicode\(\'\\uA9B8\⩩Ss\.ᠤ򂅯\\u200C𐹦\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3495\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{0678}𮓵Ⴇ｡𑂳", %p)},	undef,	"to_unicode\(\'ß\\u0678𮓵Ⴇ｡𑂳\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3496\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{064A}\x{0674}𮓵Ⴇ。𑂳", %p)},	undef,	"to_unicode\(\'ß\\u064A\\u0674𮓵Ⴇ\。𑂳\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3497\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{064A}\x{0674}𮓵ⴇ。𑂳", %p)},	undef,	"to_unicode\(\'ß\\u064A\\u0674𮓵ⴇ\。𑂳\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3498\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{064A}\x{0674}𮓵Ⴇ。𑂳", %p)},	undef,	"to_unicode\(\'SS\\u064A\\u0674𮓵Ⴇ\。𑂳\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3499\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{064A}\x{0674}𮓵ⴇ。𑂳", %p)},	undef,	"to_unicode\(\'ss\\u064A\\u0674𮓵ⴇ\。𑂳\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3500\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{064A}\x{0674}𮓵Ⴇ。𑂳", %p)},	undef,	"to_unicode\(\'Ss\\u064A\\u0674𮓵Ⴇ\。𑂳\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3501\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{0678}𮓵ⴇ｡𑂳", %p)},	undef,	"to_unicode\(\'ß\\u0678𮓵ⴇ｡𑂳\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3502\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{0678}𮓵Ⴇ｡𑂳", %p)},	undef,	"to_unicode\(\'SS\\u0678𮓵Ⴇ｡𑂳\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3503\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{0678}𮓵ⴇ｡𑂳", %p)},	undef,	"to_unicode\(\'ss\\u0678𮓵ⴇ｡𑂳\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3504\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{0678}𮓵Ⴇ｡𑂳", %p)},	undef,	"to_unicode\(\'Ss\\u0678𮓵Ⴇ｡𑂳\'\)\ throws\ error\ P1\ V6\ V5\ B5\ \[data\/IdnaTest\.txt\:3505\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("\x{ABED}。𝨁-𑁆", %p)},	undef,	"to_unicode\(\'\\uABED\。𝨁\-𑁆\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3506\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⮉-．𒿏󠁼ß", %p)},	undef,	"to_unicode\(\'\⮉\-．𒿏\󠁼ß\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3507\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⮉-.𒿏󠁼ß", %p)},	undef,	"to_unicode\(\'\⮉\-\.𒿏\󠁼ß\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3508\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⮉-.𒿏󠁼SS", %p)},	undef,	"to_unicode\(\'\⮉\-\.𒿏\󠁼SS\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3509\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⮉-.𒿏󠁼ss", %p)},	undef,	"to_unicode\(\'\⮉\-\.𒿏\󠁼ss\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3510\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⮉-.𒿏󠁼Ss", %p)},	undef,	"to_unicode\(\'\⮉\-\.𒿏\󠁼Ss\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3511\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⮉-．𒿏󠁼SS", %p)},	undef,	"to_unicode\(\'\⮉\-．𒿏\󠁼SS\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3512\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⮉-．𒿏󠁼ss", %p)},	undef,	"to_unicode\(\'\⮉\-．𒿏\󠁼ss\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3513\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⮉-．𒿏󠁼Ss", %p)},	undef,	"to_unicode\(\'\⮉\-．𒿏\󠁼Ss\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3514\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0775}-≮。𐹽\x{FE29}\x{0724}", %p)},	undef,	"to_unicode\(\'\\u0775\-\≮\。𐹽\\uFE29\\u0724\'\)\ throws\ error\ P1\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3515\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0775}-<\x{0338}。𐹽\x{FE29}\x{0724}", %p)},	undef,	"to_unicode\(\'\\u0775\-\<\\u0338\。𐹽\\uFE29\\u0724\'\)\ throws\ error\ P1\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3516\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟥󠳮\x{0CCD}\x{0347}．𑖿\x{0F84}8󠇩", %p)},	undef,	"to_unicode\(\'𝟥\󠳮\\u0CCD\\u0347．𑖿\\u0F848\󠇩\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3517\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("3󠳮\x{0CCD}\x{0347}.𑖿\x{0F84}8󠇩", %p)},	undef,	"to_unicode\(\'3\󠳮\\u0CCD\\u0347\.𑖿\\u0F848\󠇩\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3518\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-｡񃲑\x{200D}\x{0E4C}", %p)},	undef,	"to_unicode\(\'\-｡񃲑\\u200D\\u0E4C\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3519\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-｡񃲑\x{200D}\x{0E4C}", %p)},	undef,	"to_unicode\(\'\-｡񃲑\\u200D\\u0E4C\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3520\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-。񃲑\x{200D}\x{0E4C}", %p)},	undef,	"to_unicode\(\'\-\。񃲑\\u200D\\u0E4C\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3521\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-。񃲑\x{200D}\x{0E4C}", %p)},	undef,	"to_unicode\(\'\-\。񃲑\\u200D\\u0E4C\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3522\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟓➲𝟐񱬭｡𝩎򮖚", %p)},	undef,	"to_unicode\(\'𝟓\➲𝟐񱬭｡𝩎򮖚\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3523\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("5➲2񱬭。𝩎򮖚", %p)},	undef,	"to_unicode\(\'5\➲2񱬭\。𝩎򮖚\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3524\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-.-├񷏳", %p)},	undef,	"to_unicode\(\'\-\.\-\├񷏳\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3525\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{059D}ᢝ｡\x{200D}🔘", %p)},	undef,	"to_unicode\(\'\\u059Dᢝ｡\\u200D🔘\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:3526\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{059D}ᢝ｡\x{200D}🔘", %p)},	undef,	"to_unicode\(\'\\u059Dᢝ｡\\u200D🔘\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:3527\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{059D}ᢝ。\x{200D}🔘", %p)},	undef,	"to_unicode\(\'\\u059Dᢝ\。\\u200D🔘\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:3528\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{059D}ᢝ。\x{200D}🔘", %p)},	undef,	"to_unicode\(\'\\u059Dᢝ\。\\u200D🔘\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:3529\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("쥥󂿯Ⴎ．\x{200C}⒈⒈ᡥ", %p)},	undef,	"to_unicode\(\'쥥󂿯Ⴎ．\\u200C⒈⒈ᡥ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3530\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󂿯Ⴎ．\x{200C}⒈⒈ᡥ", %p)},	undef,	"to_unicode\(\'쥥󂿯Ⴎ．\\u200C⒈⒈ᡥ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3531\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󂿯Ⴎ．\x{200C}⒈⒈ᡥ", %p)},	undef,	"to_unicode\(\'쥥󂿯Ⴎ．\\u200C⒈⒈ᡥ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3532\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󂿯Ⴎ．\x{200C}⒈⒈ᡥ", %p)},	undef,	"to_unicode\(\'쥥󂿯Ⴎ．\\u200C⒈⒈ᡥ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3533\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󂿯Ⴎ.\x{200C}1.1.ᡥ", %p)},	undef,	"to_unicode\(\'쥥󂿯Ⴎ\.\\u200C1\.1\.ᡥ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3534\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󂿯Ⴎ.\x{200C}1.1.ᡥ", %p)},	undef,	"to_unicode\(\'쥥󂿯Ⴎ\.\\u200C1\.1\.ᡥ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3535\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󂿯Ⴎ.\x{200C}1.1.ᡥ", %p)},	undef,	"to_unicode\(\'쥥󂿯Ⴎ\.\\u200C1\.1\.ᡥ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3536\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󂿯Ⴎ.\x{200C}1.1.ᡥ", %p)},	undef,	"to_unicode\(\'쥥󂿯Ⴎ\.\\u200C1\.1\.ᡥ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3537\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󂿯ⴎ.\x{200C}1.1.ᡥ", %p)},	undef,	"to_unicode\(\'쥥󂿯ⴎ\.\\u200C1\.1\.ᡥ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3538\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󂿯ⴎ.\x{200C}1.1.ᡥ", %p)},	undef,	"to_unicode\(\'쥥󂿯ⴎ\.\\u200C1\.1\.ᡥ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3539\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󂿯ⴎ.\x{200C}1.1.ᡥ", %p)},	undef,	"to_unicode\(\'쥥󂿯ⴎ\.\\u200C1\.1\.ᡥ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3540\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󂿯ⴎ.\x{200C}1.1.ᡥ", %p)},	undef,	"to_unicode\(\'쥥󂿯ⴎ\.\\u200C1\.1\.ᡥ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3541\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󂿯ⴎ．\x{200C}⒈⒈ᡥ", %p)},	undef,	"to_unicode\(\'쥥󂿯ⴎ．\\u200C⒈⒈ᡥ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3542\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󂿯ⴎ．\x{200C}⒈⒈ᡥ", %p)},	undef,	"to_unicode\(\'쥥󂿯ⴎ．\\u200C⒈⒈ᡥ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3543\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󂿯ⴎ．\x{200C}⒈⒈ᡥ", %p)},	undef,	"to_unicode\(\'쥥󂿯ⴎ．\\u200C⒈⒈ᡥ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3544\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("쥥󂿯ⴎ．\x{200C}⒈⒈ᡥ", %p)},	undef,	"to_unicode\(\'쥥󂿯ⴎ．\\u200C⒈⒈ᡥ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3545\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠀲𝟶\x{067C}-。\x{0B4D}", %p)},	undef,	"to_unicode\(\'\󠀲𝟶\\u067C\-\。\\u0B4D\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3546\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠀲0\x{067C}-。\x{0B4D}", %p)},	undef,	"to_unicode\(\'\󠀲0\\u067C\-\。\\u0B4D\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3547\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς．𐸹ꜘ⒈", %p)},	undef,	"to_unicode\(\'ς．𐸹ꜘ⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3548\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς.𐸹ꜘ1.", %p)},	undef,	"to_unicode\(\'ς\.𐸹ꜘ1\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3549\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ.𐸹ꜘ1.", %p)},	undef,	"to_unicode\(\'Σ\.𐸹ꜘ1\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3550\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ.𐸹ꜘ1.", %p)},	undef,	"to_unicode\(\'σ\.𐸹ꜘ1\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3551\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ．𐸹ꜘ⒈", %p)},	undef,	"to_unicode\(\'Σ．𐸹ꜘ⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3552\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ．𐸹ꜘ⒈", %p)},	undef,	"to_unicode\(\'σ．𐸹ꜘ⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3553\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠳘-｡𐹹򐴥򻚗", %p)},	undef,	"to_unicode\(\'\󠳘\-｡𐹹򐴥򻚗\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3554\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠳘-。𐹹򐴥򻚗", %p)},	undef,	"to_unicode\(\'\󠳘\-\。𐹹򐴥򻚗\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3555\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞵆-󠔪｡𝟻\x{200C}\x{05F7}", %p)},	undef,	"to_unicode\(\'𞵆\-\󠔪｡𝟻\\u200C\\u05F7\'\)\ throws\ error\ P1\ V6\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:3556\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞵆-󠔪｡𝟻\x{200C}\x{05F7}", %p)},	undef,	"to_unicode\(\'𞵆\-\󠔪｡𝟻\\u200C\\u05F7\'\)\ throws\ error\ P1\ V6\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:3557\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞵆-󠔪。5\x{200C}\x{05F7}", %p)},	undef,	"to_unicode\(\'𞵆\-\󠔪\。5\\u200C\\u05F7\'\)\ throws\ error\ P1\ V6\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:3558\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞵆-󠔪。5\x{200C}\x{05F7}", %p)},	undef,	"to_unicode\(\'𞵆\-\󠔪\。5\\u200C\\u05F7\'\)\ throws\ error\ P1\ V6\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:3559\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}ß．\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200Dß．\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3560\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}ß．\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200Dß．\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3561\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}ß．\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200Dß．\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3562\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}ß．\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200Dß．\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3563\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}ß.\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200Dß\.\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3564\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}ß.\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200Dß\.\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3565\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}ß.\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200Dß\.\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3566\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}ß.\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200Dß\.\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3567\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}SS.\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200DSS\.\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3568\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}SS.\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200DSS\.\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3569\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}SS.\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200DSS\.\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3570\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}SS.\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200DSS\.\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3571\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}ss.\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200Dss\.\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3572\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}ss.\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200Dss\.\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3573\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}ss.\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200Dss\.\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3574\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}ss.\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200Dss\.\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3575\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}Ss.\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200DSs\.\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3576\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}Ss.\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200DSs\.\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3577\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}Ss.\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200DSs\.\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3578\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}Ss.\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200DSs\.\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3579\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}SS．\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200DSS．\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3580\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}SS．\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200DSS．\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3581\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}SS．\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200DSS．\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3582\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}SS．\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200DSS．\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3583\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}ss．\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200Dss．\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3584\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}ss．\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200Dss．\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3585\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}ss．\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200Dss．\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3586\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}ss．\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200Dss．\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3587\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}Ss．\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200DSs．\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3588\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}Ss．\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200DSs．\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3589\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}Ss．\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200DSs．\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3590\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("𐹸늿\x{200D}Ss．\x{074E}0\x{135D}", %p)},	undef,	"to_unicode\(\'𐹸늿\\u200DSs．\\u074E0\\u135D\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3591\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("9\x{0C3E}．󡇎\x{0722}", %p)},	undef,	"to_unicode\(\'9\\u0C3E．󡇎\\u0722\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3592\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("9\x{0C3E}.󡇎\x{0722}", %p)},	undef,	"to_unicode\(\'9\\u0C3E\.󡇎\\u0722\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3593\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.𐱇󠽵ß⺀", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.𐱇\󠽵ß⺀\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3594\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.𐱇󠽵ß⺀", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.𐱇\󠽵ß⺀\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3595\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1160}.𐱇󠽵ß⺀", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.𐱇\󠽵ß⺀\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3596\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1160}.𐱇󠽵ß⺀", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.𐱇\󠽵ß⺀\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3597\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1160}.𐱇󠽵SS⺀", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.𐱇\󠽵SS⺀\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3598\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1160}.𐱇󠽵SS⺀", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.𐱇\󠽵SS⺀\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3599\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1160}.𐱇󠽵ss⺀", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.𐱇\󠽵ss⺀\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3600\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1160}.𐱇󠽵ss⺀", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.𐱇\󠽵ss⺀\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3601\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1160}.𐱇󠽵Ss⺀", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.𐱇\󠽵Ss⺀\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3602\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{1160}.𐱇󠽵Ss⺀", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.𐱇\󠽵Ss⺀\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3603\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.𐱇󠽵SS⺀", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.𐱇\󠽵SS⺀\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3604\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.𐱇󠽵SS⺀", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.𐱇\󠽵SS⺀\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3605\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.𐱇󠽵ss⺀", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.𐱇\󠽵ss⺀\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3606\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.𐱇󠽵ss⺀", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.𐱇\󠽵ss⺀\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3607\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.𐱇󠽵Ss⺀", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.𐱇\󠽵Ss⺀\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3608\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.𐱇󠽵Ss⺀", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.𐱇\󠽵Ss⺀\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3609\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒Ⴖ𝅷．\x{200C}", %p)},	undef,	"to_unicode\(\'︒Ⴖ\𝅷．\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3610\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒Ⴖ𝅷．\x{200C}", %p)},	undef,	"to_unicode\(\'︒Ⴖ\𝅷．\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3611\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。Ⴖ𝅷.\x{200C}", %p)},	undef,	"to_unicode\(\'\。Ⴖ\𝅷\.\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3612\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。Ⴖ𝅷.\x{200C}", %p)},	undef,	"to_unicode\(\'\。Ⴖ\𝅷\.\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3613\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。ⴖ𝅷.\x{200C}", %p)},	undef,	"to_unicode\(\'\。ⴖ\𝅷\.\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3614\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。ⴖ𝅷.\x{200C}", %p)},	undef,	"to_unicode\(\'\。ⴖ\𝅷\.\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3615\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒ⴖ𝅷．\x{200C}", %p)},	undef,	"to_unicode\(\'︒ⴖ\𝅷．\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3616\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒ⴖ𝅷．\x{200C}", %p)},	undef,	"to_unicode\(\'︒ⴖ\𝅷．\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3617\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠸ．\x{200C}Ⴃ\x{0F90}", %p)},	undef,	"to_unicode\(\'ᠸ．\\u200CႣ\\u0F90\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3618\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠸ．\x{200C}Ⴃ\x{0F90}", %p)},	undef,	"to_unicode\(\'ᠸ．\\u200CႣ\\u0F90\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3619\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠸ.\x{200C}Ⴃ\x{0F90}", %p)},	undef,	"to_unicode\(\'ᠸ\.\\u200CႣ\\u0F90\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3620\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠸ.\x{200C}Ⴃ\x{0F90}", %p)},	undef,	"to_unicode\(\'ᠸ\.\\u200CႣ\\u0F90\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3621\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ᠸ.\x{200C}ⴃ\x{0F90}", %p)},	undef,	"to_unicode\(\'ᠸ\.\\u200Cⴃ\\u0F90\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:3622\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ᠸ.\x{200C}ⴃ\x{0F90}", %p)},	undef,	"to_unicode\(\'ᠸ\.\\u200Cⴃ\\u0F90\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:3623\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--r7e.xn--gfd191m", %p)},	"ᠸ.ⴃ\x{0F90}",	"to_unicode\(\'xn\-\-r7e\.xn\-\-gfd191m\'\)\ \[data\/IdnaTest\.txt\:3624\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ᠸ.ⴃ\x{0F90}", %p)},	"ᠸ.ⴃ\x{0F90}",	"to_unicode\(\'ᠸ\.ⴃ\\u0F90\'\)\ \[data\/IdnaTest\.txt\:3625\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ᠸ.Ⴃ\x{0F90}", %p)},	undef,	"to_unicode\(\'ᠸ\.Ⴃ\\u0F90\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3626\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ᠸ．\x{200C}ⴃ\x{0F90}", %p)},	undef,	"to_unicode\(\'ᠸ．\\u200Cⴃ\\u0F90\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:3627\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ᠸ．\x{200C}ⴃ\x{0F90}", %p)},	undef,	"to_unicode\(\'ᠸ．\\u200Cⴃ\\u0F90\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:3628\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}\x{200C}。２䫷⋻", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\。２䫷\⋻\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3629\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{200C}。２䫷⋻", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\。２䫷\⋻\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3630\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{200C}。2䫷⋻", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\。2䫷\⋻\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3631\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{200C}。2䫷⋻", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\。2䫷\⋻\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3632\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--2-poow91p", %p)},	"2䫷⋻",	"to_unicode\(\'xn\-\-2\-poow91p\'\)\ \[data\/IdnaTest\.txt\:3633\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2䫷⋻", %p)},	"2䫷⋻",	"to_unicode\(\'2䫷\⋻\'\)\ \[data\/IdnaTest\.txt\:3634\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-󠅾󥘨。򻀠", %p)},	undef,	"to_unicode\(\'\-\󠅾󥘨\。򻀠\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3635\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󝺜︒\x{200C}㟀．\x{07E7}⒈", %p)},	undef,	"to_unicode\(\'󝺜︒\\u200C㟀．\\u07E7⒈\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3636\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󝺜︒\x{200C}㟀．\x{07E7}⒈", %p)},	undef,	"to_unicode\(\'󝺜︒\\u200C㟀．\\u07E7⒈\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3637\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󝺜。\x{200C}㟀.\x{07E7}1.", %p)},	undef,	"to_unicode\(\'󝺜\。\\u200C㟀\.\\u07E71\.\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3638\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󝺜。\x{200C}㟀.\x{07E7}1.", %p)},	undef,	"to_unicode\(\'󝺜\。\\u200C㟀\.\\u07E71\.\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3639\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("󠆮ꡬ\x{05AA}。-\x{200D}", %p)},	undef,	"to_unicode\(\'\󠆮ꡬ\\u05AA\。\-\\u200D\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:3640\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("󠆮ꡬ\x{05AA}。-\x{200D}", %p)},	undef,	"to_unicode\(\'\󠆮ꡬ\\u05AA\。\-\\u200D\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:3641\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}．Ⴉ≠𐬉", %p)},	undef,	"to_unicode\(\'\\u200C．Ⴉ\≠𐬉\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3642\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}．Ⴉ≠𐬉", %p)},	undef,	"to_unicode\(\'\\u200C．Ⴉ\≠𐬉\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3643\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}．Ⴉ=\x{0338}𐬉", %p)},	undef,	"to_unicode\(\'\\u200C．Ⴉ\=\\u0338𐬉\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3644\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}．Ⴉ=\x{0338}𐬉", %p)},	undef,	"to_unicode\(\'\\u200C．Ⴉ\=\\u0338𐬉\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3645\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.Ⴉ≠𐬉", %p)},	undef,	"to_unicode\(\'\\u200C\.Ⴉ\≠𐬉\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3646\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.Ⴉ≠𐬉", %p)},	undef,	"to_unicode\(\'\\u200C\.Ⴉ\≠𐬉\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3647\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.Ⴉ=\x{0338}𐬉", %p)},	undef,	"to_unicode\(\'\\u200C\.Ⴉ\=\\u0338𐬉\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3648\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.Ⴉ=\x{0338}𐬉", %p)},	undef,	"to_unicode\(\'\\u200C\.Ⴉ\=\\u0338𐬉\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3649\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.ⴉ=\x{0338}𐬉", %p)},	undef,	"to_unicode\(\'\\u200C\.ⴉ\=\\u0338𐬉\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3650\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.ⴉ=\x{0338}𐬉", %p)},	undef,	"to_unicode\(\'\\u200C\.ⴉ\=\\u0338𐬉\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3651\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.ⴉ≠𐬉", %p)},	undef,	"to_unicode\(\'\\u200C\.ⴉ\≠𐬉\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3652\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.ⴉ≠𐬉", %p)},	undef,	"to_unicode\(\'\\u200C\.ⴉ\≠𐬉\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3653\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}．ⴉ=\x{0338}𐬉", %p)},	undef,	"to_unicode\(\'\\u200C．ⴉ\=\\u0338𐬉\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3654\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}．ⴉ=\x{0338}𐬉", %p)},	undef,	"to_unicode\(\'\\u200C．ⴉ\=\\u0338𐬉\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3655\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}．ⴉ≠𐬉", %p)},	undef,	"to_unicode\(\'\\u200C．ⴉ\≠𐬉\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3656\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}．ⴉ≠𐬉", %p)},	undef,	"to_unicode\(\'\\u200C．ⴉ\≠𐬉\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3657\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐮈。≯ς", %p)},	undef,	"to_unicode\(\'𐮈\。\≯ς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3658\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐮈。>\x{0338}ς", %p)},	undef,	"to_unicode\(\'𐮈\。\>\\u0338ς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3659\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐮈。>\x{0338}Σ", %p)},	undef,	"to_unicode\(\'𐮈\。\>\\u0338Σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3660\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐮈。≯Σ", %p)},	undef,	"to_unicode\(\'𐮈\。\≯Σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3661\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐮈。≯σ", %p)},	undef,	"to_unicode\(\'𐮈\。\≯σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3662\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐮈。>\x{0338}σ", %p)},	undef,	"to_unicode\(\'𐮈\。\>\\u0338σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3663\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐱸𞴇.𞥂︒򨹓Ⴐ", %p)},	undef,	"to_unicode\(\'𐱸𞴇\.𞥂︒򨹓Ⴐ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3664\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐱸𞴇.𞥂。򨹓Ⴐ", %p)},	undef,	"to_unicode\(\'𐱸𞴇\.𞥂\。򨹓Ⴐ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3665\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐱸𞴇.𞥂。򨹓ⴐ", %p)},	undef,	"to_unicode\(\'𐱸𞴇\.𞥂\。򨹓ⴐ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3666\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐱸𞴇.𞥂︒򨹓ⴐ", %p)},	undef,	"to_unicode\(\'𐱸𞴇\.𞥂︒򨹓ⴐ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3667\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴥ🠠⸄⧲｡󠇠", %p)},	undef,	"to_unicode\(\'Ⴥ🠠\⸄\⧲｡\󠇠\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3668\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴥ🠠⸄⧲。󠇠", %p)},	undef,	"to_unicode\(\'Ⴥ🠠\⸄\⧲\。\󠇠\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3669\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ⴥ🠠⸄⧲。󠇠", %p)},	"ⴥ🠠⸄⧲.",	"to_unicode\(\'ⴥ🠠\⸄\⧲\。\󠇠\'\)\ \[data\/IdnaTest\.txt\:3670\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--fxi61ietai923l.", %p)},	"ⴥ🠠⸄⧲.",	"to_unicode\(\'xn\-\-fxi61ietai923l\.\'\)\ \[data\/IdnaTest\.txt\:3671\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ⴥ🠠⸄⧲.", %p)},	"ⴥ🠠⸄⧲.",	"to_unicode\(\'ⴥ🠠\⸄\⧲\.\'\)\ \[data\/IdnaTest\.txt\:3672\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴥ🠠⸄⧲.", %p)},	undef,	"to_unicode\(\'Ⴥ🠠\⸄\⧲\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3673\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ⴥ🠠⸄⧲｡󠇠", %p)},	"ⴥ🠠⸄⧲.",	"to_unicode\(\'ⴥ🠠\⸄\⧲｡\󠇠\'\)\ \[data\/IdnaTest\.txt\:3674\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("🄈。󠦐ᢙ", %p)},	undef,	"to_unicode\(\'🄈\。\󠦐ᢙ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3675\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("7,。󠦐ᢙ", %p)},	undef,	"to_unicode\(\'7\,\。\󠦐ᢙ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3676\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{063D}。섖쮖ß", %p)},	undef,	"to_unicode\(\'\≮\\u063D\。섖쮖ß\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3677\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{063D}。섖쮖ß", %p)},	undef,	"to_unicode\(\'\<\\u0338\\u063D\。섖쮖ß\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3678\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{063D}。섖쮖SS", %p)},	undef,	"to_unicode\(\'\<\\u0338\\u063D\。섖쮖SS\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3679\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{063D}。섖쮖SS", %p)},	undef,	"to_unicode\(\'\≮\\u063D\。섖쮖SS\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3680\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{063D}。섖쮖ss", %p)},	undef,	"to_unicode\(\'\≮\\u063D\。섖쮖ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3681\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{063D}。섖쮖ss", %p)},	undef,	"to_unicode\(\'\<\\u0338\\u063D\。섖쮖ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3682\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{063D}。섖쮖Ss", %p)},	undef,	"to_unicode\(\'\<\\u0338\\u063D\。섖쮖Ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3683\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{063D}。섖쮖Ss", %p)},	undef,	"to_unicode\(\'\≮\\u063D\。섖쮖Ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3684\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1A6A}󠍨-。\x{06A2}", %p)},	undef,	"to_unicode\(\'\\u1A6A\󠍨\-\。\\u06A2\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3685\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞱦\x{06DD}\x{0845}\x{0E3A}。\x{069E}\x{0726}\x{200C}\x{062C}", %p)},	undef,	"to_unicode\(\'𞱦\\u06DD\\u0845\\u0E3A\。\\u069E\\u0726\\u200C\\u062C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3686\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1AB6}.𞨕򗡺", %p)},	undef,	"to_unicode\(\'\\u1AB6\.𞨕򗡺\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3687\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("--。󶅄\x{07D9}\x{FD60}\x{FDB5}", %p)},	undef,	"to_unicode\(\'\-\-\。󶅄\\u07D9\\uFD60\\uFDB5\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3688\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("--。󶅄\x{07D9}\x{0633}\x{0645}\x{062D}\x{0644}\x{062D}\x{0645}", %p)},	undef,	"to_unicode\(\'\-\-\。󶅄\\u07D9\\u0633\\u0645\\u062D\\u0644\\u062D\\u0645\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3689\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񰋴𐋥𚴢.≯\x{08A2}\x{06C1}򮁎", %p)},	undef,	"to_unicode\(\'񰋴𐋥𚴢\.\≯\\u08A2\\u06C1򮁎\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3690\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񰋴𐋥𚴢.>\x{0338}\x{08A2}\x{06C1}򮁎", %p)},	undef,	"to_unicode\(\'񰋴𐋥𚴢\.\>\\u0338\\u08A2\\u06C1򮁎\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3691\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䔛󠅆󙭅𐹸．-䤷", %p)},	undef,	"to_unicode\(\'䔛\󠅆󙭅𐹸．\-䤷\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:3692\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䔛󠅆󙭅𐹸.-䤷", %p)},	undef,	"to_unicode\(\'䔛\󠅆󙭅𐹸\.\-䤷\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:3693\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0665}．\x{200D}-", %p)},	undef,	"to_unicode\(\'\\u0665．\\u200D\-\'\)\ throws\ error\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:3694\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0665}．\x{200D}-", %p)},	undef,	"to_unicode\(\'\\u0665．\\u200D\-\'\)\ throws\ error\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:3695\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0665}.\x{200D}-", %p)},	undef,	"to_unicode\(\'\\u0665\.\\u200D\-\'\)\ throws\ error\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:3696\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0665}.\x{200D}-", %p)},	undef,	"to_unicode\(\'\\u0665\.\\u200D\-\'\)\ throws\ error\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:3697\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򳥎帷｡≯萺🢓-", %p)},	undef,	"to_unicode\(\'򳥎帷｡\≯萺🢓\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3698\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򳥎帷｡>\x{0338}萺🢓-", %p)},	undef,	"to_unicode\(\'򳥎帷｡\>\\u0338萺🢓\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3699\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򳥎帷。≯萺🢓-", %p)},	undef,	"to_unicode\(\'򳥎帷\。\≯萺🢓\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3700\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򳥎帷。>\x{0338}萺🢓-", %p)},	undef,	"to_unicode\(\'򳥎帷\。\>\\u0338萺🢓\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3701\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}攌\x{1BAA}。\x{0641}-Ⴘ", %p)},	undef,	"to_unicode\(\'\\u200D攌\\u1BAA\。\\u0641\-Ⴘ\'\)\ throws\ error\ P1\ V6\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:3702\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}攌\x{1BAA}。\x{0641}-Ⴘ", %p)},	undef,	"to_unicode\(\'\\u200D攌\\u1BAA\。\\u0641\-Ⴘ\'\)\ throws\ error\ P1\ V6\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:3703\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{200D}攌\x{1BAA}。\x{0641}-ⴘ", %p)},	undef,	"to_unicode\(\'\\u200D攌\\u1BAA\。\\u0641\-ⴘ\'\)\ throws\ error\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:3704\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{200D}攌\x{1BAA}。\x{0641}-ⴘ", %p)},	undef,	"to_unicode\(\'\\u200D攌\\u1BAA\。\\u0641\-ⴘ\'\)\ throws\ error\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:3705\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}ꖨ．⒗３􆤫۳", %p)},	undef,	"to_unicode\(\'\\u200Cꖨ．⒗３􆤫۳\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3706\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ꖨ．⒗３􆤫۳", %p)},	undef,	"to_unicode\(\'\\u200Cꖨ．⒗３􆤫۳\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3707\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ꖨ.16.3􆤫۳", %p)},	undef,	"to_unicode\(\'\\u200Cꖨ\.16\.3􆤫۳\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3708\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ꖨ.16.3􆤫۳", %p)},	undef,	"to_unicode\(\'\\u200Cꖨ\.16\.3􆤫۳\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3709\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈걾6.𞼾\x{06A6}", %p)},	undef,	"to_unicode\(\'⒈걾6\.𞼾\\u06A6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3710\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈걾6.𞼾\x{06A6}", %p)},	undef,	"to_unicode\(\'⒈걾6\.𞼾\\u06A6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3711\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.걾6.𞼾\x{06A6}", %p)},	undef,	"to_unicode\(\'1\.걾6\.𞼾\\u06A6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3712\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.걾6.𞼾\x{06A6}", %p)},	undef,	"to_unicode\(\'1\.걾6\.𞼾\\u06A6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3713\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐭹𝟶≮≮.\x{07EC}\x{063F}", %p)},	undef,	"to_unicode\(\'𐭹𝟶\≮\≮\.\\u07EC\\u063F\'\)\ throws\ error\ P1\ V6\ V5\ B3\ B1\ \[data\/IdnaTest\.txt\:3714\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐭹𝟶<\x{0338}<\x{0338}.\x{07EC}\x{063F}", %p)},	undef,	"to_unicode\(\'𐭹𝟶\<\\u0338\<\\u0338\.\\u07EC\\u063F\'\)\ throws\ error\ P1\ V6\ V5\ B3\ B1\ \[data\/IdnaTest\.txt\:3715\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐭹0≮≮.\x{07EC}\x{063F}", %p)},	undef,	"to_unicode\(\'𐭹0\≮\≮\.\\u07EC\\u063F\'\)\ throws\ error\ P1\ V6\ V5\ B3\ B1\ \[data\/IdnaTest\.txt\:3716\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐭹0<\x{0338}<\x{0338}.\x{07EC}\x{063F}", %p)},	undef,	"to_unicode\(\'𐭹0\<\\u0338\<\\u0338\.\\u07EC\\u063F\'\)\ throws\ error\ P1\ V6\ V5\ B3\ B1\ \[data\/IdnaTest\.txt\:3717\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝩎.𐹥\x{115F}", %p)},	undef,	"to_unicode\(\'𝩎\.𐹥\\u115F\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3718\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("𝟏\x{05A2}\x{0E4B}.\x{200D}", %p)},	undef,	"to_unicode\(\'𝟏\\u05A2\\u0E4B\.\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3719\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("𝟏\x{05A2}\x{0E4B}.\x{200D}", %p)},	undef,	"to_unicode\(\'𝟏\\u05A2\\u0E4B\.\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3720\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("𝟏\x{0E4B}\x{05A2}.\x{200D}", %p)},	undef,	"to_unicode\(\'𝟏\\u0E4B\\u05A2\.\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3721\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("𝟏\x{0E4B}\x{05A2}.\x{200D}", %p)},	undef,	"to_unicode\(\'𝟏\\u0E4B\\u05A2\.\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3722\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("1\x{0E4B}\x{05A2}.\x{200D}", %p)},	undef,	"to_unicode\(\'1\\u0E4B\\u05A2\.\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3723\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("1\x{0E4B}\x{05A2}.\x{200D}", %p)},	undef,	"to_unicode\(\'1\\u0E4B\\u05A2\.\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3724\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--1-efc467d.", %p)},	"1\x{0E4B}\x{05A2}.",	"to_unicode\(\'xn\-\-1\-efc467d\.\'\)\ \[data\/IdnaTest\.txt\:3725\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("1\x{0E4B}\x{05A2}.", %p)},	"1\x{0E4B}\x{05A2}.",	"to_unicode\(\'1\\u0E4B\\u05A2\.\'\)\ \[data\/IdnaTest\.txt\:3726\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ꡏ≠\x{07DF}\x{103A}｡-\x{200C}𐮀", %p)},	undef,	"to_unicode\(\'ꡏ\≠\\u07DF\\u103A｡\-\\u200C𐮀\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ B1\ C1\ \[data\/IdnaTest\.txt\:3727\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡏ≠\x{07DF}\x{103A}｡-\x{200C}𐮀", %p)},	undef,	"to_unicode\(\'ꡏ\≠\\u07DF\\u103A｡\-\\u200C𐮀\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ B1\ C1\ \[data\/IdnaTest\.txt\:3728\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡏ=\x{0338}\x{07DF}\x{103A}｡-\x{200C}𐮀", %p)},	undef,	"to_unicode\(\'ꡏ\=\\u0338\\u07DF\\u103A｡\-\\u200C𐮀\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ B1\ C1\ \[data\/IdnaTest\.txt\:3729\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡏ=\x{0338}\x{07DF}\x{103A}｡-\x{200C}𐮀", %p)},	undef,	"to_unicode\(\'ꡏ\=\\u0338\\u07DF\\u103A｡\-\\u200C𐮀\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ B1\ C1\ \[data\/IdnaTest\.txt\:3730\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡏ≠\x{07DF}\x{103A}。-\x{200C}𐮀", %p)},	undef,	"to_unicode\(\'ꡏ\≠\\u07DF\\u103A\。\-\\u200C𐮀\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ B1\ C1\ \[data\/IdnaTest\.txt\:3731\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡏ≠\x{07DF}\x{103A}。-\x{200C}𐮀", %p)},	undef,	"to_unicode\(\'ꡏ\≠\\u07DF\\u103A\。\-\\u200C𐮀\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ B1\ C1\ \[data\/IdnaTest\.txt\:3732\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡏ=\x{0338}\x{07DF}\x{103A}。-\x{200C}𐮀", %p)},	undef,	"to_unicode\(\'ꡏ\=\\u0338\\u07DF\\u103A\。\-\\u200C𐮀\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ B1\ C1\ \[data\/IdnaTest\.txt\:3733\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡏ=\x{0338}\x{07DF}\x{103A}。-\x{200C}𐮀", %p)},	undef,	"to_unicode\(\'ꡏ\=\\u0338\\u07DF\\u103A\。\-\\u200C𐮀\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ B1\ C1\ \[data\/IdnaTest\.txt\:3734\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("𐹹𑜩-\x{08AA}｡𐫚", %p)},	undef,	"to_unicode\(\'𐹹𑜩\-\\u08AA｡𐫚\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3735\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("𐹹𑜩-\x{08AA}。𐫚", %p)},	undef,	"to_unicode\(\'𐹹𑜩\-\\u08AA\。𐫚\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3736\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("F\x{1AB4}｡񸃫🌿", %p)},	undef,	"to_unicode\(\'F\\u1AB4｡񸃫🌿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3737\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("F\x{1AB4}。񸃫🌿", %p)},	undef,	"to_unicode\(\'F\\u1AB4\。񸃫🌿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3738\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("f\x{1AB4}。񸃫🌿", %p)},	undef,	"to_unicode\(\'f\\u1AB4\。񸃫🌿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3739\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("f\x{1AB4}｡񸃫🌿", %p)},	undef,	"to_unicode\(\'f\\u1AB4｡񸃫🌿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3740\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑈵𑍍\x{05C1}。𝟮Ⴘ\x{1B03}𪌓", %p)},	undef,	"to_unicode\(\'𑈵𑍍\\u05C1\。𝟮Ⴘ\\u1B03𪌓\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3741\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑈵𑍍\x{05C1}。2Ⴘ\x{1B03}𪌓", %p)},	undef,	"to_unicode\(\'𑈵𑍍\\u05C1\。2Ⴘ\\u1B03𪌓\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3742\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𑈵𑍍\x{05C1}。2ⴘ\x{1B03}𪌓", %p)},	undef,	"to_unicode\(\'𑈵𑍍\\u05C1\。2ⴘ\\u1B03𪌓\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3743\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𑈵𑍍\x{05C1}。𝟮ⴘ\x{1B03}𪌓", %p)},	undef,	"to_unicode\(\'𑈵𑍍\\u05C1\。𝟮ⴘ\\u1B03𪌓\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3744\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("󙐃\x{200C}\x{200C}⒈。勉\x{08F6}", %p)},	undef,	"to_unicode\(\'󙐃\\u200C\\u200C⒈\。勉\\u08F6\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3745\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󙐃\x{200C}\x{200C}⒈。勉\x{08F6}", %p)},	undef,	"to_unicode\(\'󙐃\\u200C\\u200C⒈\。勉\\u08F6\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3746\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󙐃\x{200C}\x{200C}1.。勉\x{08F6}", %p)},	undef,	"to_unicode\(\'󙐃\\u200C\\u200C1\.\。勉\\u08F6\'\)\ throws\ error\ P1\ V6\ C1\ A4_2\ \[data\/IdnaTest\.txt\:3747\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󙐃\x{200C}\x{200C}1.。勉\x{08F6}", %p)},	undef,	"to_unicode\(\'󙐃\\u200C\\u200C1\.\。勉\\u08F6\'\)\ throws\ error\ P1\ V6\ C1\ A4_2\ \[data\/IdnaTest\.txt\:3748\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07DE}.􋧲򆔛򚝌", %p)},	undef,	"to_unicode\(\'\\u07DE\.􋧲򆔛򚝌\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3749\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}｡⒈≯𝟵", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C｡⒈\≯𝟵\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3750\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}｡⒈≯𝟵", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C｡⒈\≯𝟵\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3751\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}｡⒈>\x{0338}𝟵", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C｡⒈\>\\u0338𝟵\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3752\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}｡⒈>\x{0338}𝟵", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C｡⒈\>\\u0338𝟵\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3753\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}。1.≯9", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C\。1\.\≯9\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3754\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}。1.≯9", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C\。1\.\≯9\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3755\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}。1.>\x{0338}9", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C\。1\.\>\\u03389\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3756\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}。1.>\x{0338}9", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C\。1\.\>\\u03389\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3757\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115F}󠁔񹨕.񡆍≯ᡱ", %p)},	undef,	"to_unicode\(\'\\u115F\󠁔񹨕\.񡆍\≯ᡱ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3758\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115F}󠁔񹨕.񡆍>\x{0338}ᡱ", %p)},	undef,	"to_unicode\(\'\\u115F\󠁔񹨕\.񡆍\>\\u0338ᡱ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3759\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⽛󠇧\x{200D}\x{06A4}.𑆻-\x{20E0}򔔷", %p)},	undef,	"to_unicode\(\'⽛\󠇧\\u200D\\u06A4\.𑆻\-\\u20E0򔔷\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3760\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⽛󠇧\x{200D}\x{06A4}.𑆻-\x{20E0}򔔷", %p)},	undef,	"to_unicode\(\'⽛\󠇧\\u200D\\u06A4\.𑆻\-\\u20E0򔔷\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3761\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("牙󠇧\x{200D}\x{06A4}.𑆻-\x{20E0}򔔷", %p)},	undef,	"to_unicode\(\'牙\󠇧\\u200D\\u06A4\.𑆻\-\\u20E0򔔷\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3762\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("牙󠇧\x{200D}\x{06A4}.𑆻-\x{20E0}򔔷", %p)},	undef,	"to_unicode\(\'牙\󠇧\\u200D\\u06A4\.𑆻\-\\u20E0򔔷\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3763\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{035D}．\x{2D7F}-", %p)},	undef,	"to_unicode\(\'\\u035D．\\u2D7F\-\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:3764\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{035D}.\x{2D7F}-", %p)},	undef,	"to_unicode\(\'\\u035D\.\\u2D7F\-\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:3765\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("䮸ß.┶☍紙\x{0710}", %p)},	undef,	"to_unicode\(\'䮸ß\.\┶\☍紙\\u0710\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3766\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䮸SS.┶☍紙\x{0710}", %p)},	undef,	"to_unicode\(\'䮸SS\.\┶\☍紙\\u0710\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3767\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䮸ss.┶☍紙\x{0710}", %p)},	undef,	"to_unicode\(\'䮸ss\.\┶\☍紙\\u0710\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3768\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䮸Ss.┶☍紙\x{0710}", %p)},	undef,	"to_unicode\(\'䮸Ss\.\┶\☍紙\\u0710\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3769\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-Ⴞ.-⎟≈𞴈", %p)},	undef,	"to_unicode\(\'\-Ⴞ\.\-\⎟\≈𞴈\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3770\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-ⴞ.-⎟≈𞴈", %p)},	undef,	"to_unicode\(\'\-ⴞ\.\-\⎟\≈𞴈\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3771\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󊡝𐹮𑜝｡𵘅\x{07EA}𚷖ᠥ", %p)},	undef,	"to_unicode\(\'󊡝𐹮𑜝｡𵘅\\u07EA𚷖ᠥ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3772\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󊡝𐹮𑜝。𵘅\x{07EA}𚷖ᠥ", %p)},	undef,	"to_unicode\(\'󊡝𐹮𑜝\。𵘅\\u07EA𚷖ᠥ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3773\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1B02}-\x{200D}\x{1CE8}．\x{067A}\x{200D}񻭁", %p)},	undef,	"to_unicode\(\'\\u1B02\-\\u200D\\u1CE8．\\u067A\\u200D񻭁\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:3774\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1B02}-\x{200D}\x{1CE8}．\x{067A}\x{200D}񻭁", %p)},	undef,	"to_unicode\(\'\\u1B02\-\\u200D\\u1CE8．\\u067A\\u200D񻭁\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:3775\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1B02}-\x{200D}\x{1CE8}.\x{067A}\x{200D}񻭁", %p)},	undef,	"to_unicode\(\'\\u1B02\-\\u200D\\u1CE8\.\\u067A\\u200D񻭁\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:3776\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1B02}-\x{200D}\x{1CE8}.\x{067A}\x{200D}񻭁", %p)},	undef,	"to_unicode\(\'\\u1B02\-\\u200D\\u1CE8\.\\u067A\\u200D񻭁\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:3777\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("۱。≠\x{0667}", %p)},	undef,	"to_unicode\(\'۱\。\≠\\u0667\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3778\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("۱。=\x{0338}\x{0667}", %p)},	undef,	"to_unicode\(\'۱\。\=\\u0338\\u0667\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3779\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{A8C4}廊.\x{07D4}", %p)},	undef,	"to_unicode\(\'\\uA8C4廊\.\\u07D4\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3780\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}\x{17CF}-．-Ⴐ𐹥", %p)},	undef,	"to_unicode\(\'\\u200D\\u17CF\-．\-Ⴐ𐹥\'\)\ throws\ error\ P1\ V3\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3781\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{17CF}-．-Ⴐ𐹥", %p)},	undef,	"to_unicode\(\'\\u200D\\u17CF\-．\-Ⴐ𐹥\'\)\ throws\ error\ P1\ V3\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3782\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{17CF}-.-Ⴐ𐹥", %p)},	undef,	"to_unicode\(\'\\u200D\\u17CF\-\.\-Ⴐ𐹥\'\)\ throws\ error\ P1\ V3\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3783\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{17CF}-.-Ⴐ𐹥", %p)},	undef,	"to_unicode\(\'\\u200D\\u17CF\-\.\-Ⴐ𐹥\'\)\ throws\ error\ P1\ V3\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3784\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}\x{17CF}-.-ⴐ𐹥", %p)},	undef,	"to_unicode\(\'\\u200D\\u17CF\-\.\-ⴐ𐹥\'\)\ throws\ error\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3785\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}\x{17CF}-.-ⴐ𐹥", %p)},	undef,	"to_unicode\(\'\\u200D\\u17CF\-\.\-ⴐ𐹥\'\)\ throws\ error\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3786\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}\x{17CF}-．-ⴐ𐹥", %p)},	undef,	"to_unicode\(\'\\u200D\\u17CF\-．\-ⴐ𐹥\'\)\ throws\ error\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3787\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200D}\x{17CF}-．-ⴐ𐹥", %p)},	undef,	"to_unicode\(\'\\u200D\\u17CF\-．\-ⴐ𐹥\'\)\ throws\ error\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3788\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ᡈ𐹯挏򨆦.-", %p)},	undef,	"to_unicode\(\'ᡈ𐹯挏򨆦\.\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ \[data\/IdnaTest\.txt\:3789\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("𞸷｡𐹪\x{084C}", %p)},	undef,	"to_unicode\(\'𞸷｡𐹪\\u084C\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3790\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{062E}。𐹪\x{084C}", %p)},	undef,	"to_unicode\(\'\\u062E\。𐹪\\u084C\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3791\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴞ󠛸盥．ꡧ릫", %p)},	undef,	"to_unicode\(\'Ⴞ\󠛸盥．ꡧ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3792\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴞ󠛸盥．ꡧ릫", %p)},	undef,	"to_unicode\(\'Ⴞ\󠛸盥．ꡧ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3793\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴞ󠛸盥.ꡧ릫", %p)},	undef,	"to_unicode\(\'Ⴞ\󠛸盥\.ꡧ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3794\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴞ󠛸盥.ꡧ릫", %p)},	undef,	"to_unicode\(\'Ⴞ\󠛸盥\.ꡧ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3795\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴞ󠛸盥.ꡧ릫", %p)},	undef,	"to_unicode\(\'ⴞ\󠛸盥\.ꡧ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3796\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴞ󠛸盥.ꡧ릫", %p)},	undef,	"to_unicode\(\'ⴞ\󠛸盥\.ꡧ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3797\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴞ󠛸盥．ꡧ릫", %p)},	undef,	"to_unicode\(\'ⴞ\󠛸盥．ꡧ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3798\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴞ󠛸盥．ꡧ릫", %p)},	undef,	"to_unicode\(\'ⴞ\󠛸盥．ꡧ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3799\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("✦󃕌𐮮𐹸｡≯\x{200C}\x{A8E5}", %p)},	undef,	"to_unicode\(\'\✦󃕌𐮮𐹸｡\≯\\u200C\\uA8E5\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3800\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("✦󃕌𐮮𐹸｡≯\x{200C}\x{A8E5}", %p)},	undef,	"to_unicode\(\'\✦󃕌𐮮𐹸｡\≯\\u200C\\uA8E5\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3801\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("✦󃕌𐮮𐹸｡>\x{0338}\x{200C}\x{A8E5}", %p)},	undef,	"to_unicode\(\'\✦󃕌𐮮𐹸｡\>\\u0338\\u200C\\uA8E5\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3802\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("✦󃕌𐮮𐹸｡>\x{0338}\x{200C}\x{A8E5}", %p)},	undef,	"to_unicode\(\'\✦󃕌𐮮𐹸｡\>\\u0338\\u200C\\uA8E5\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3803\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("✦󃕌𐮮𐹸。≯\x{200C}\x{A8E5}", %p)},	undef,	"to_unicode\(\'\✦󃕌𐮮𐹸\。\≯\\u200C\\uA8E5\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3804\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("✦󃕌𐮮𐹸。≯\x{200C}\x{A8E5}", %p)},	undef,	"to_unicode\(\'\✦󃕌𐮮𐹸\。\≯\\u200C\\uA8E5\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3805\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("✦󃕌𐮮𐹸。>\x{0338}\x{200C}\x{A8E5}", %p)},	undef,	"to_unicode\(\'\✦󃕌𐮮𐹸\。\>\\u0338\\u200C\\uA8E5\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3806\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("✦󃕌𐮮𐹸。>\x{0338}\x{200C}\x{A8E5}", %p)},	undef,	"to_unicode\(\'\✦󃕌𐮮𐹸\。\>\\u0338\\u200C\\uA8E5\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3807\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("ᛎ\x{0351}⎛\x{200D}｡\x{0662}\x{0668}𐦋-", %p)},	undef,	"to_unicode\(\'ᛎ\\u0351\⎛\\u200D｡\\u0662\\u0668𐦋\-\'\)\ throws\ error\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3808\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("ᛎ\x{0351}⎛\x{200D}｡\x{0662}\x{0668}𐦋-", %p)},	undef,	"to_unicode\(\'ᛎ\\u0351\⎛\\u200D｡\\u0662\\u0668𐦋\-\'\)\ throws\ error\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3809\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("ᛎ\x{0351}⎛\x{200D}。\x{0662}\x{0668}𐦋-", %p)},	undef,	"to_unicode\(\'ᛎ\\u0351\⎛\\u200D\。\\u0662\\u0668𐦋\-\'\)\ throws\ error\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3810\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("ᛎ\x{0351}⎛\x{200D}。\x{0662}\x{0668}𐦋-", %p)},	undef,	"to_unicode\(\'ᛎ\\u0351\⎛\\u200D\。\\u0662\\u0668𐦋\-\'\)\ throws\ error\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3811\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0666}.\x{06FB}", %p)},	undef,	"to_unicode\(\'\\u0666\.\\u06FB\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3812\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200D}𑁆｡⒈", %p)},	undef,	"to_unicode\(\'ß\\u200D𑁆｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3813\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200D}𑁆｡⒈", %p)},	undef,	"to_unicode\(\'ß\\u200D𑁆｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3814\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("ß\x{200D}𑁆。1.", %p)},	undef,	"to_unicode\(\'ß\\u200D𑁆\。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3815\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("ß\x{200D}𑁆。1.", %p)},	undef,	"to_unicode\(\'ß\\u200D𑁆\。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3816\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("SS\x{200D}𑁆。1.", %p)},	undef,	"to_unicode\(\'SS\\u200D𑁆\。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3817\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("SS\x{200D}𑁆。1.", %p)},	undef,	"to_unicode\(\'SS\\u200D𑁆\。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3818\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("ss\x{200D}𑁆。1.", %p)},	undef,	"to_unicode\(\'ss\\u200D𑁆\。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3819\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("ss\x{200D}𑁆。1.", %p)},	undef,	"to_unicode\(\'ss\\u200D𑁆\。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3820\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("Ss\x{200D}𑁆。1.", %p)},	undef,	"to_unicode\(\'Ss\\u200D𑁆\。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3821\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("Ss\x{200D}𑁆。1.", %p)},	undef,	"to_unicode\(\'Ss\\u200D𑁆\。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3822\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("xn--ss-tn4o.1.", %p)},	"ss𑁆.1.",	"to_unicode\(\'xn\-\-ss\-tn4o\.1\.\'\)\ \[data\/IdnaTest\.txt\:3823\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("ss𑁆.1.", %p)},	"ss𑁆.1.",	"to_unicode\(\'ss𑁆\.1\.\'\)\ \[data\/IdnaTest\.txt\:3824\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("SS𑁆.1.", %p)},	"ss𑁆.1.",	"to_unicode\(\'SS𑁆\.1\.\'\)\ \[data\/IdnaTest\.txt\:3825\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("Ss𑁆.1.", %p)},	"ss𑁆.1.",	"to_unicode\(\'Ss𑁆\.1\.\'\)\ \[data\/IdnaTest\.txt\:3826\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("SS\x{200D}𑁆｡⒈", %p)},	undef,	"to_unicode\(\'SS\\u200D𑁆｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3827\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{200D}𑁆｡⒈", %p)},	undef,	"to_unicode\(\'SS\\u200D𑁆｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3828\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{200D}𑁆｡⒈", %p)},	undef,	"to_unicode\(\'ss\\u200D𑁆｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3829\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{200D}𑁆｡⒈", %p)},	undef,	"to_unicode\(\'ss\\u200D𑁆｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3830\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200D}𑁆｡⒈", %p)},	undef,	"to_unicode\(\'Ss\\u200D𑁆｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3831\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200D}𑁆｡⒈", %p)},	undef,	"to_unicode\(\'Ss\\u200D𑁆｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3832\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1B44}\x{200C}򦃽𐴮。\x{200D}", %p)},	undef,	"to_unicode\(\'\\u1B44\\u200C򦃽𐴮\。\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3833\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1B44}\x{200C}򦃽𐴮。\x{200D}", %p)},	undef,	"to_unicode\(\'\\u1B44\\u200C򦃽𐴮\。\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3834\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ᡏ｡ꡂ\x{17BC}", %p)},	"ᡏ.ꡂ\x{17BC}",	"to_unicode\(\'ᡏ｡ꡂ\\u17BC\'\)\ \[data\/IdnaTest\.txt\:3835\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ᡏ。ꡂ\x{17BC}", %p)},	"ᡏ.ꡂ\x{17BC}",	"to_unicode\(\'ᡏ\。ꡂ\\u17BC\'\)\ \[data\/IdnaTest\.txt\:3836\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("xn--f8e.xn--73e9015e", %p)},	"ᡏ.ꡂ\x{17BC}",	"to_unicode\(\'xn\-\-f8e\.xn\-\-73e9015e\'\)\ \[data\/IdnaTest\.txt\:3837\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ᡏ.ꡂ\x{17BC}", %p)},	"ᡏ.ꡂ\x{17BC}",	"to_unicode\(\'ᡏ\.ꡂ\\u17BC\'\)\ \[data\/IdnaTest\.txt\:3838\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("ᡦ\x{17D2}。\x{071F}\x{0954}\x{200C}𑄴", %p)},	undef,	"to_unicode\(\'ᡦ\\u17D2\。\\u071F\\u0954\\u200C𑄴\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:3839\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("ᡦ\x{17D2}。\x{071F}\x{0954}\x{200C}𑄴", %p)},	undef,	"to_unicode\(\'ᡦ\\u17D2\。\\u071F\\u0954\\u200C𑄴\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:3840\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("xn--u4e90a.xn--pnb44if575b", %p)},	"ᡦ\x{17D2}.\x{071F}𑄴\x{0954}",	"to_unicode\(\'xn\-\-u4e90a\.xn\-\-pnb44if575b\'\)\ \[data\/IdnaTest\.txt\:3841\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("ᡦ\x{17D2}.\x{071F}𑄴\x{0954}", %p)},	"ᡦ\x{17D2}.\x{071F}𑄴\x{0954}",	"to_unicode\(\'ᡦ\\u17D2\.\\u071F𑄴\\u0954\'\)\ \[data\/IdnaTest\.txt\:3842\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{A4CE}.𑈶\x{0684}", %p)},	undef,	"to_unicode\(\'\\uA4CE\.𑈶\\u0684\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3843\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("\x{0713}𑜫．ß𑇀𑆸", %p)},	"\x{0713}𑜫.ß𑇀𑆸",	"to_unicode\(\'\\u0713𑜫．ß𑇀𑆸\'\)\ \[data\/IdnaTest\.txt\:3844\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("\x{0713}𑜫．ß𑇀𑆸", %p)},	"\x{0713}𑜫.ß𑇀𑆸",	"to_unicode\(\'\\u0713𑜫．ß𑇀𑆸\'\)\ \[data\/IdnaTest\.txt\:3845\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("\x{0713}𑜫.ß𑇀𑆸", %p)},	"\x{0713}𑜫.ß𑇀𑆸",	"to_unicode\(\'\\u0713𑜫\.ß𑇀𑆸\'\)\ \[data\/IdnaTest\.txt\:3846\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("\x{0713}𑜫.ß𑇀𑆸", %p)},	"\x{0713}𑜫.ß𑇀𑆸",	"to_unicode\(\'\\u0713𑜫\.ß𑇀𑆸\'\)\ \[data\/IdnaTest\.txt\:3847\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("\x{0713}𑜫.SS𑇀𑆸", %p)},	"\x{0713}𑜫.ss𑇀𑆸",	"to_unicode\(\'\\u0713𑜫\.SS𑇀𑆸\'\)\ \[data\/IdnaTest\.txt\:3848\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("\x{0713}𑜫.ss𑇀𑆸", %p)},	"\x{0713}𑜫.ss𑇀𑆸",	"to_unicode\(\'\\u0713𑜫\.ss𑇀𑆸\'\)\ \[data\/IdnaTest\.txt\:3849\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("\x{0713}𑜫.Ss𑇀𑆸", %p)},	"\x{0713}𑜫.ss𑇀𑆸",	"to_unicode\(\'\\u0713𑜫\.Ss𑇀𑆸\'\)\ \[data\/IdnaTest\.txt\:3850\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("xn--dnb6240l.xn--ss-jk5o5a", %p)},	"\x{0713}𑜫.ss𑇀𑆸",	"to_unicode\(\'xn\-\-dnb6240l\.xn\-\-ss\-jk5o5a\'\)\ \[data\/IdnaTest\.txt\:3851\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("xn--dnb6240l.xn--zca2180lxa", %p)},	"\x{0713}𑜫.ß𑇀𑆸",	"to_unicode\(\'xn\-\-dnb6240l\.xn\-\-zca2180lxa\'\)\ \[data\/IdnaTest\.txt\:3852\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("\x{0713}𑜫．SS𑇀𑆸", %p)},	"\x{0713}𑜫.ss𑇀𑆸",	"to_unicode\(\'\\u0713𑜫．SS𑇀𑆸\'\)\ \[data\/IdnaTest\.txt\:3853\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("\x{0713}𑜫．ss𑇀𑆸", %p)},	"\x{0713}𑜫.ss𑇀𑆸",	"to_unicode\(\'\\u0713𑜫．ss𑇀𑆸\'\)\ \[data\/IdnaTest\.txt\:3854\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("\x{0713}𑜫．Ss𑇀𑆸", %p)},	"\x{0713}𑜫.ss𑇀𑆸",	"to_unicode\(\'\\u0713𑜫．Ss𑇀𑆸\'\)\ \[data\/IdnaTest\.txt\:3855\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𝟠≮\x{200C}｡\x{0734}\x{17B4}", %p)},	undef,	"to_unicode\(\'𝟠\≮\\u200C｡\\u0734\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3856\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟠≮\x{200C}｡\x{0734}\x{17B4}", %p)},	undef,	"to_unicode\(\'𝟠\≮\\u200C｡\\u0734\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3857\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟠<\x{0338}\x{200C}｡\x{0734}\x{17B4}", %p)},	undef,	"to_unicode\(\'𝟠\<\\u0338\\u200C｡\\u0734\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3858\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟠<\x{0338}\x{200C}｡\x{0734}\x{17B4}", %p)},	undef,	"to_unicode\(\'𝟠\<\\u0338\\u200C｡\\u0734\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3859\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("8≮\x{200C}。\x{0734}\x{17B4}", %p)},	undef,	"to_unicode\(\'8\≮\\u200C\。\\u0734\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3860\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("8≮\x{200C}。\x{0734}\x{17B4}", %p)},	undef,	"to_unicode\(\'8\≮\\u200C\。\\u0734\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3861\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("8<\x{0338}\x{200C}。\x{0734}\x{17B4}", %p)},	undef,	"to_unicode\(\'8\<\\u0338\\u200C\。\\u0734\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3862\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("8<\x{0338}\x{200C}。\x{0734}\x{17B4}", %p)},	undef,	"to_unicode\(\'8\<\\u0338\\u200C\。\\u0734\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3863\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡙ≯︒𫅍．Ⴀ", %p)},	undef,	"to_unicode\(\'ᡙ\≯︒𫅍．Ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3864\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡙ>\x{0338}︒𫅍．Ⴀ", %p)},	undef,	"to_unicode\(\'ᡙ\>\\u0338︒𫅍．Ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3865\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡙ≯。𫅍.Ⴀ", %p)},	undef,	"to_unicode\(\'ᡙ\≯\。𫅍\.Ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3866\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡙ>\x{0338}。𫅍.Ⴀ", %p)},	undef,	"to_unicode\(\'ᡙ\>\\u0338\。𫅍\.Ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3867\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡙ>\x{0338}。𫅍.ⴀ", %p)},	undef,	"to_unicode\(\'ᡙ\>\\u0338\。𫅍\.ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3868\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡙ≯。𫅍.ⴀ", %p)},	undef,	"to_unicode\(\'ᡙ\≯\。𫅍\.ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3869\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡙ>\x{0338}︒𫅍．ⴀ", %p)},	undef,	"to_unicode\(\'ᡙ\>\\u0338︒𫅍．ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3870\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡙ≯︒𫅍．ⴀ", %p)},	undef,	"to_unicode\(\'ᡙ\≯︒𫅍．ⴀ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3871\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{17D1}．-\x{08FE}", %p)},	undef,	"to_unicode\(\'\\u17D1．\-\\u08FE\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:3872\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("\x{17D1}.-\x{08FE}", %p)},	undef,	"to_unicode\(\'\\u17D1\.\-\\u08FE\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:3873\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ᵬ󠅳．핒⒒⒈󍤢", %p)},	undef,	"to_unicode\(\'ᵬ\󠅳．핒⒒⒈󍤢\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3874\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᵬ󠅳．핒⒒⒈󍤢", %p)},	undef,	"to_unicode\(\'ᵬ\󠅳．핒⒒⒈󍤢\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3875\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᵬ󠅳.핒11.1.󍤢", %p)},	undef,	"to_unicode\(\'ᵬ\󠅳\.핒11\.1\.󍤢\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3876\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᵬ󠅳.핒11.1.󍤢", %p)},	undef,	"to_unicode\(\'ᵬ\󠅳\.핒11\.1\.󍤢\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3877\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ς\x{0ACD}𐋢．𐹨", %p)},	undef,	"to_unicode\(\'ς\\u0ACD𐋢．𐹨\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3878\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("ς\x{0ACD}𐋢.𐹨", %p)},	undef,	"to_unicode\(\'ς\\u0ACD𐋢\.𐹨\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3879\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("Σ\x{0ACD}𐋢.𐹨", %p)},	undef,	"to_unicode\(\'Σ\\u0ACD𐋢\.𐹨\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3880\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("σ\x{0ACD}𐋢.𐹨", %p)},	undef,	"to_unicode\(\'σ\\u0ACD𐋢\.𐹨\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3881\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("Σ\x{0ACD}𐋢．𐹨", %p)},	undef,	"to_unicode\(\'Σ\\u0ACD𐋢．𐹨\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3882\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("σ\x{0ACD}𐋢．𐹨", %p)},	undef,	"to_unicode\(\'σ\\u0ACD𐋢．𐹨\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3883\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{A806}\x{200C}𐋻\x{200D}.\x{2DE3}\x{072B}𐹥", %p)},	undef,	"to_unicode\(\'\\uA806\\u200C𐋻\\u200D\.\\u2DE3\\u072B𐹥\'\)\ throws\ error\ V5\ C2\ B1\ \[data\/IdnaTest\.txt\:3884\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{A806}\x{200C}𐋻\x{200D}.\x{2DE3}\x{072B}𐹥", %p)},	undef,	"to_unicode\(\'\\uA806\\u200C𐋻\\u200D\.\\u2DE3\\u072B𐹥\'\)\ throws\ error\ V5\ C2\ B1\ \[data\/IdnaTest\.txt\:3885\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𝍕。𸻞\x{08A2}", %p)},	undef,	"to_unicode\(\'𝍕\。𸻞\\u08A2\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3886\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐬨􆧪。򨳋", %p)},	undef,	"to_unicode\(\'𐬨􆧪\。򨳋\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3887\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹾\x{1DC7}ꡔ。ς񶞒󠤤\x{17B5}", %p)},	undef,	"to_unicode\(\'𐹾\\u1DC7ꡔ\。ς񶞒\󠤤\\u17B5\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3888\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹾\x{1DC7}ꡔ。Σ񶞒󠤤\x{17B5}", %p)},	undef,	"to_unicode\(\'𐹾\\u1DC7ꡔ\。Σ񶞒\󠤤\\u17B5\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3889\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹾\x{1DC7}ꡔ。σ񶞒󠤤\x{17B5}", %p)},	undef,	"to_unicode\(\'𐹾\\u1DC7ꡔ\。σ񶞒\󠤤\\u17B5\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3890\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-𐯽\x{074E}\x{0819}。\x{0CCD}𝟥", %p)},	undef,	"to_unicode\(\'\-𐯽\\u074E\\u0819\。\\u0CCD𝟥\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3891\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-𐯽\x{074E}\x{0819}。\x{0CCD}3", %p)},	undef,	"to_unicode\(\'\-𐯽\\u074E\\u0819\。\\u0CCD3\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3892\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠔟｡򡵱≮𐽨", %p)},	undef,	"to_unicode\(\'\\u200C\󠔟｡򡵱\≮𐽨\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3893\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠔟｡򡵱≮𐽨", %p)},	undef,	"to_unicode\(\'\\u200C\󠔟｡򡵱\≮𐽨\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3894\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠔟｡򡵱<\x{0338}𐽨", %p)},	undef,	"to_unicode\(\'\\u200C\󠔟｡򡵱\<\\u0338𐽨\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3895\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠔟｡򡵱<\x{0338}𐽨", %p)},	undef,	"to_unicode\(\'\\u200C\󠔟｡򡵱\<\\u0338𐽨\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3896\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠔟。򡵱≮𐽨", %p)},	undef,	"to_unicode\(\'\\u200C\󠔟\。򡵱\≮𐽨\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3897\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠔟。򡵱≮𐽨", %p)},	undef,	"to_unicode\(\'\\u200C\󠔟\。򡵱\≮𐽨\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3898\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠔟。򡵱<\x{0338}𐽨", %p)},	undef,	"to_unicode\(\'\\u200C\󠔟\。򡵱\<\\u0338𐽨\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3899\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}󠔟。򡵱<\x{0338}𐽨", %p)},	undef,	"to_unicode\(\'\\u200C\󠔟\。򡵱\<\\u0338𐽨\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3900\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈꘍𿅦．𝟡𓕹", %p)},	undef,	"to_unicode\(\'⒈꘍𿅦．𝟡𓕹\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3901\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.꘍𿅦.9𓕹", %p)},	undef,	"to_unicode\(\'1\.꘍𿅦\.9𓕹\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3902\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{AAED}\x{06CC}𐪆.𐹷󠁈", %p)},	undef,	"to_unicode\(\'\\uAAED\\u06CC𐪆\.𐹷\󠁈\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3903\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("ς．𑄴\x{1734}", %p)},	undef,	"to_unicode\(\'ς．𑄴\\u1734\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3904\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("ς.𑄴\x{1734}", %p)},	undef,	"to_unicode\(\'ς\.𑄴\\u1734\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3905\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("Σ.𑄴\x{1734}", %p)},	undef,	"to_unicode\(\'Σ\.𑄴\\u1734\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3906\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("σ.𑄴\x{1734}", %p)},	undef,	"to_unicode\(\'σ\.𑄴\\u1734\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3907\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("Σ．𑄴\x{1734}", %p)},	undef,	"to_unicode\(\'Σ．𑄴\\u1734\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3908\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("σ．𑄴\x{1734}", %p)},	undef,	"to_unicode\(\'σ．𑄴\\u1734\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3909\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{1073}\x{200C}≯𐼸．󠅛", %p)},	undef,	"to_unicode\(\'\\u1073\\u200C\≯𐼸．\󠅛\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3910\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1073}\x{200C}≯𐼸．󠅛", %p)},	undef,	"to_unicode\(\'\\u1073\\u200C\≯𐼸．\󠅛\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3911\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1073}\x{200C}>\x{0338}𐼸．󠅛", %p)},	undef,	"to_unicode\(\'\\u1073\\u200C\>\\u0338𐼸．\󠅛\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3912\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1073}\x{200C}>\x{0338}𐼸．󠅛", %p)},	undef,	"to_unicode\(\'\\u1073\\u200C\>\\u0338𐼸．\󠅛\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3913\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1073}\x{200C}≯𐼸.󠅛", %p)},	undef,	"to_unicode\(\'\\u1073\\u200C\≯𐼸\.\󠅛\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3914\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1073}\x{200C}≯𐼸.󠅛", %p)},	undef,	"to_unicode\(\'\\u1073\\u200C\≯𐼸\.\󠅛\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3915\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1073}\x{200C}>\x{0338}𐼸.󠅛", %p)},	undef,	"to_unicode\(\'\\u1073\\u200C\>\\u0338𐼸\.\󠅛\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3916\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1073}\x{200C}>\x{0338}𐼸.󠅛", %p)},	undef,	"to_unicode\(\'\\u1073\\u200C\>\\u0338𐼸\.\󠅛\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3917\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羚｡≯", %p)},	undef,	"to_unicode\(\'羚｡\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3918\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羚｡>\x{0338}", %p)},	undef,	"to_unicode\(\'羚｡\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3919\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羚。≯", %p)},	undef,	"to_unicode\(\'羚\。\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3920\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羚。>\x{0338}", %p)},	undef,	"to_unicode\(\'羚\。\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3921\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A953}\x{1759}．\x{0850}", %p)},	undef,	"to_unicode\(\'\\uA953\\u1759．\\u0850\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3922\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A953}\x{1759}.\x{0850}", %p)},	undef,	"to_unicode\(\'\\uA953\\u1759\.\\u0850\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3923\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򛝏\x{2DED}\x{200D}｡𐹡ҠჀ𝟑", %p)},	undef,	"to_unicode\(\'򛝏\\u2DED\\u200D｡𐹡ҠჀ𝟑\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3924\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򛝏\x{2DED}\x{200D}｡𐹡ҠჀ𝟑", %p)},	undef,	"to_unicode\(\'򛝏\\u2DED\\u200D｡𐹡ҠჀ𝟑\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3925\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򛝏\x{2DED}\x{200D}。𐹡ҠჀ3", %p)},	undef,	"to_unicode\(\'򛝏\\u2DED\\u200D\。𐹡ҠჀ3\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3926\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򛝏\x{2DED}\x{200D}。𐹡ҠჀ3", %p)},	undef,	"to_unicode\(\'򛝏\\u2DED\\u200D\。𐹡ҠჀ3\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3927\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򛝏\x{2DED}\x{200D}。𐹡ҡⴠ3", %p)},	undef,	"to_unicode\(\'򛝏\\u2DED\\u200D\。𐹡ҡⴠ3\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3928\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򛝏\x{2DED}\x{200D}。𐹡ҡⴠ3", %p)},	undef,	"to_unicode\(\'򛝏\\u2DED\\u200D\。𐹡ҡⴠ3\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3929\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򛝏\x{2DED}\x{200D}。𐹡Ҡⴠ3", %p)},	undef,	"to_unicode\(\'򛝏\\u2DED\\u200D\。𐹡Ҡⴠ3\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3930\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򛝏\x{2DED}\x{200D}。𐹡Ҡⴠ3", %p)},	undef,	"to_unicode\(\'򛝏\\u2DED\\u200D\。𐹡Ҡⴠ3\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3931\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򛝏\x{2DED}\x{200D}｡𐹡ҡⴠ𝟑", %p)},	undef,	"to_unicode\(\'򛝏\\u2DED\\u200D｡𐹡ҡⴠ𝟑\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3932\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򛝏\x{2DED}\x{200D}｡𐹡ҡⴠ𝟑", %p)},	undef,	"to_unicode\(\'򛝏\\u2DED\\u200D｡𐹡ҡⴠ𝟑\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3933\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򛝏\x{2DED}\x{200D}｡𐹡Ҡⴠ𝟑", %p)},	undef,	"to_unicode\(\'򛝏\\u2DED\\u200D｡𐹡Ҡⴠ𝟑\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3934\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򛝏\x{2DED}\x{200D}｡𐹡Ҡⴠ𝟑", %p)},	undef,	"to_unicode\(\'򛝏\\u2DED\\u200D｡𐹡Ҡⴠ𝟑\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3935\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{063F}。\x{0661}\x{17D3}", %p)},	undef,	"to_unicode\(\'\\u063F\。\\u0661\\u17D3\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3936\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("򈾫\x{A8C4}｡𐹾𒜸𑇀ß", %p)},	undef,	"to_unicode\(\'򈾫\\uA8C4｡𐹾𒜸𑇀ß\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3937\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򈾫\x{A8C4}。𐹾𒜸𑇀ß", %p)},	undef,	"to_unicode\(\'򈾫\\uA8C4\。𐹾𒜸𑇀ß\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3938\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򈾫\x{A8C4}。𐹾𒜸𑇀SS", %p)},	undef,	"to_unicode\(\'򈾫\\uA8C4\。𐹾𒜸𑇀SS\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3939\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򈾫\x{A8C4}。𐹾𒜸𑇀ss", %p)},	undef,	"to_unicode\(\'򈾫\\uA8C4\。𐹾𒜸𑇀ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3940\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򈾫\x{A8C4}。𐹾𒜸𑇀Ss", %p)},	undef,	"to_unicode\(\'򈾫\\uA8C4\。𐹾𒜸𑇀Ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3941\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򈾫\x{A8C4}｡𐹾𒜸𑇀SS", %p)},	undef,	"to_unicode\(\'򈾫\\uA8C4｡𐹾𒜸𑇀SS\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3942\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򈾫\x{A8C4}｡𐹾𒜸𑇀ss", %p)},	undef,	"to_unicode\(\'򈾫\\uA8C4｡𐹾𒜸𑇀ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3943\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򈾫\x{A8C4}｡𐹾𒜸𑇀Ss", %p)},	undef,	"to_unicode\(\'򈾫\\uA8C4｡𐹾𒜸𑇀Ss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3944\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹨򏝨\x{17B4}.󠪅︒≠", %p)},	undef,	"to_unicode\(\'𐹨򏝨\\u17B4\.\󠪅︒\≠\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3945\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹨򏝨\x{17B4}.󠪅︒=\x{0338}", %p)},	undef,	"to_unicode\(\'𐹨򏝨\\u17B4\.\󠪅︒\=\\u0338\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3946\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹨򏝨\x{17B4}.󠪅。≠", %p)},	undef,	"to_unicode\(\'𐹨򏝨\\u17B4\.\󠪅\。\≠\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3947\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹨򏝨\x{17B4}.󠪅。=\x{0338}", %p)},	undef,	"to_unicode\(\'𐹨򏝨\\u17B4\.\󠪅\。\=\\u0338\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3948\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠬩񲜍ỗ⒈．񣽍񝩖\x{1DF0}𝟫", %p)},	undef,	"to_unicode\(\'\󠬩񲜍ỗ⒈．񣽍񝩖\\u1DF0𝟫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3949\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠬩񲜍o\x{0302}\x{0303}⒈．񣽍񝩖\x{1DF0}𝟫", %p)},	undef,	"to_unicode\(\'\󠬩񲜍o\\u0302\\u0303⒈．񣽍񝩖\\u1DF0𝟫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3950\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠬩񲜍ỗ1..񣽍񝩖\x{1DF0}9", %p)},	undef,	"to_unicode\(\'\󠬩񲜍ỗ1\.\.񣽍񝩖\\u1DF09\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3951\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠬩񲜍o\x{0302}\x{0303}1..񣽍񝩖\x{1DF0}9", %p)},	undef,	"to_unicode\(\'\󠬩񲜍o\\u0302\\u03031\.\.񣽍񝩖\\u1DF09\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3952\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠬩񲜍O\x{0302}\x{0303}1..񣽍񝩖\x{1DF0}9", %p)},	undef,	"to_unicode\(\'\󠬩񲜍O\\u0302\\u03031\.\.񣽍񝩖\\u1DF09\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3953\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠬩񲜍Ỗ1..񣽍񝩖\x{1DF0}9", %p)},	undef,	"to_unicode\(\'\󠬩񲜍Ỗ1\.\.񣽍񝩖\\u1DF09\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3954\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠬩񲜍O\x{0302}\x{0303}⒈．񣽍񝩖\x{1DF0}𝟫", %p)},	undef,	"to_unicode\(\'\󠬩񲜍O\\u0302\\u0303⒈．񣽍񝩖\\u1DF0𝟫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3955\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠬩񲜍Ỗ⒈．񣽍񝩖\x{1DF0}𝟫", %p)},	undef,	"to_unicode\(\'\󠬩񲜍Ỗ⒈．񣽍񝩖\\u1DF0𝟫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3956\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}｡ᡅ", %p)},	undef,	"to_unicode\(\'\\u200D｡ᡅ\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3957\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}｡ᡅ", %p)},	undef,	"to_unicode\(\'\\u200D｡ᡅ\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3958\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。ᡅ", %p)},	undef,	"to_unicode\(\'\\u200D\。ᡅ\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3959\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。ᡅ", %p)},	undef,	"to_unicode\(\'\\u200D\。ᡅ\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3960\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--47e", %p)},	"ᡅ",	"to_unicode\(\'xn\-\-47e\'\)\ \[data\/IdnaTest\.txt\:3961\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡅ", %p)},	"ᡅ",	"to_unicode\(\'ᡅ\'\)\ \[data\/IdnaTest\.txt\:3962\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("𑌀ꡫ.\x{07D8}", %p)},	undef,	"to_unicode\(\'𑌀ꡫ\.\\u07D8\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3963\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𝆋\x{200C}-。󚇠ß", %p)},	undef,	"to_unicode\(\'𝆋\\u200C\-\。󚇠ß\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3964\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝆋\x{200C}-。󚇠ß", %p)},	undef,	"to_unicode\(\'𝆋\\u200C\-\。󚇠ß\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3965\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝆋\x{200C}-。󚇠SS", %p)},	undef,	"to_unicode\(\'𝆋\\u200C\-\。󚇠SS\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3966\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝆋\x{200C}-。󚇠SS", %p)},	undef,	"to_unicode\(\'𝆋\\u200C\-\。󚇠SS\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3967\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝆋\x{200C}-。󚇠ss", %p)},	undef,	"to_unicode\(\'𝆋\\u200C\-\。󚇠ss\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3968\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝆋\x{200C}-。󚇠ss", %p)},	undef,	"to_unicode\(\'𝆋\\u200C\-\。󚇠ss\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3969\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝆋\x{200C}-。󚇠Ss", %p)},	undef,	"to_unicode\(\'𝆋\\u200C\-\。󚇠Ss\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3970\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝆋\x{200C}-。󚇠Ss", %p)},	undef,	"to_unicode\(\'𝆋\\u200C\-\。󚇠Ss\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3971\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ς🀸⒗.\x{1C2E}􂲆\x{06B3}", %p)},	undef,	"to_unicode\(\'\\u200Cς🀸⒗\.\\u1C2E􂲆\\u06B3\'\)\ throws\ error\ P1\ V6\ V5\ C1\ B1\ \[data\/IdnaTest\.txt\:3972\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ς🀸⒗.\x{1C2E}􂲆\x{06B3}", %p)},	undef,	"to_unicode\(\'\\u200Cς🀸⒗\.\\u1C2E􂲆\\u06B3\'\)\ throws\ error\ P1\ V6\ V5\ C1\ B1\ \[data\/IdnaTest\.txt\:3973\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ς🀸16..\x{1C2E}􂲆\x{06B3}", %p)},	undef,	"to_unicode\(\'\\u200Cς🀸16\.\.\\u1C2E􂲆\\u06B3\'\)\ throws\ error\ P1\ V5\ V6\ C1\ A4_2\ B1\ \[data\/IdnaTest\.txt\:3974\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ς🀸16..\x{1C2E}􂲆\x{06B3}", %p)},	undef,	"to_unicode\(\'\\u200Cς🀸16\.\.\\u1C2E􂲆\\u06B3\'\)\ throws\ error\ P1\ V5\ V6\ C1\ A4_2\ B1\ \[data\/IdnaTest\.txt\:3975\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Σ🀸16..\x{1C2E}􂲆\x{06B3}", %p)},	undef,	"to_unicode\(\'\\u200CΣ🀸16\.\.\\u1C2E􂲆\\u06B3\'\)\ throws\ error\ P1\ V5\ V6\ C1\ A4_2\ B1\ \[data\/IdnaTest\.txt\:3976\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Σ🀸16..\x{1C2E}􂲆\x{06B3}", %p)},	undef,	"to_unicode\(\'\\u200CΣ🀸16\.\.\\u1C2E􂲆\\u06B3\'\)\ throws\ error\ P1\ V5\ V6\ C1\ A4_2\ B1\ \[data\/IdnaTest\.txt\:3977\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}σ🀸16..\x{1C2E}􂲆\x{06B3}", %p)},	undef,	"to_unicode\(\'\\u200Cσ🀸16\.\.\\u1C2E􂲆\\u06B3\'\)\ throws\ error\ P1\ V5\ V6\ C1\ A4_2\ B1\ \[data\/IdnaTest\.txt\:3978\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}σ🀸16..\x{1C2E}􂲆\x{06B3}", %p)},	undef,	"to_unicode\(\'\\u200Cσ🀸16\.\.\\u1C2E􂲆\\u06B3\'\)\ throws\ error\ P1\ V5\ V6\ C1\ A4_2\ B1\ \[data\/IdnaTest\.txt\:3979\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Σ🀸⒗.\x{1C2E}􂲆\x{06B3}", %p)},	undef,	"to_unicode\(\'\\u200CΣ🀸⒗\.\\u1C2E􂲆\\u06B3\'\)\ throws\ error\ P1\ V6\ V5\ C1\ B1\ \[data\/IdnaTest\.txt\:3980\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Σ🀸⒗.\x{1C2E}􂲆\x{06B3}", %p)},	undef,	"to_unicode\(\'\\u200CΣ🀸⒗\.\\u1C2E􂲆\\u06B3\'\)\ throws\ error\ P1\ V6\ V5\ C1\ B1\ \[data\/IdnaTest\.txt\:3981\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}σ🀸⒗.\x{1C2E}􂲆\x{06B3}", %p)},	undef,	"to_unicode\(\'\\u200Cσ🀸⒗\.\\u1C2E􂲆\\u06B3\'\)\ throws\ error\ P1\ V6\ V5\ C1\ B1\ \[data\/IdnaTest\.txt\:3982\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}σ🀸⒗.\x{1C2E}􂲆\x{06B3}", %p)},	undef,	"to_unicode\(\'\\u200Cσ🀸⒗\.\\u1C2E􂲆\\u06B3\'\)\ throws\ error\ P1\ V6\ V5\ C1\ B1\ \[data\/IdnaTest\.txt\:3983\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-.𐿙", %p)},	undef,	"to_unicode\(\'\-\.𐿙\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3984\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񜲳\x{076D}.\x{0FA2}\x{0758}", %p)},	undef,	"to_unicode\(\'񜲳\\u076D\.\\u0FA2\\u0758\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:3985\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񜲳\x{076D}.\x{0FA1}\x{0FB7}\x{0758}", %p)},	undef,	"to_unicode\(\'񜲳\\u076D\.\\u0FA1\\u0FB7\\u0758\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:3986\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FE6}ᠬ񃣈.𐫯", %p)},	undef,	"to_unicode\(\'\\u0FE6ᠬ񃣈\.𐫯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3987\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2𭡦\x{077B}ß。\x{07DE}", %p)},	undef,	"to_unicode\(\'2𭡦\\u077Bß\。\\u07DE\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3988\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2𭡦\x{077B}SS。\x{07DE}", %p)},	undef,	"to_unicode\(\'2𭡦\\u077BSS\。\\u07DE\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3989\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2𭡦\x{077B}ss。\x{07DE}", %p)},	undef,	"to_unicode\(\'2𭡦\\u077Bss\。\\u07DE\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3990\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2𭡦\x{077B}Ss。\x{07DE}", %p)},	undef,	"to_unicode\(\'2𭡦\\u077BSs\。\\u07DE\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3991\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}≮．\x{0639}ß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\≮．\\u0639ß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:3992\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}≮．\x{0639}ß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\≮．\\u0639ß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:3993\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}<\x{0338}．\x{0639}ß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\<\\u0338．\\u0639ß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:3994\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}<\x{0338}．\x{0639}ß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\<\\u0338．\\u0639ß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:3995\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}≮.\x{0639}ß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\≮\.\\u0639ß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:3996\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}≮.\x{0639}ß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\≮\.\\u0639ß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:3997\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}<\x{0338}.\x{0639}ß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\<\\u0338\.\\u0639ß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:3998\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}<\x{0338}.\x{0639}ß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\<\\u0338\.\\u0639ß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:3999\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}<\x{0338}.\x{0639}SS-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\<\\u0338\.\\u0639SS\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4000\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}<\x{0338}.\x{0639}SS-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\<\\u0338\.\\u0639SS\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4001\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}≮.\x{0639}SS-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\≮\.\\u0639SS\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4002\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}≮.\x{0639}SS-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\≮\.\\u0639SS\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4003\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}≮.\x{0639}ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\≮\.\\u0639ss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4004\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}≮.\x{0639}ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\≮\.\\u0639ss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4005\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}<\x{0338}.\x{0639}ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\<\\u0338\.\\u0639ss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4006\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}<\x{0338}.\x{0639}ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\<\\u0338\.\\u0639ss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4007\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}<\x{0338}.\x{0639}Ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\<\\u0338\.\\u0639Ss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4008\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}<\x{0338}.\x{0639}Ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\<\\u0338\.\\u0639Ss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4009\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}≮.\x{0639}Ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\≮\.\\u0639Ss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4010\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}≮.\x{0639}Ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\≮\.\\u0639Ss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4011\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}<\x{0338}．\x{0639}SS-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\<\\u0338．\\u0639SS\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4012\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}<\x{0338}．\x{0639}SS-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\<\\u0338．\\u0639SS\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4013\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}≮．\x{0639}SS-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\≮．\\u0639SS\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4014\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}≮．\x{0639}SS-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\≮．\\u0639SS\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4015\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}≮．\x{0639}ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\≮．\\u0639ss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4016\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}≮．\x{0639}ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\≮．\\u0639ss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4017\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}<\x{0338}．\x{0639}ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\<\\u0338．\\u0639ss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4018\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}<\x{0338}．\x{0639}ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\<\\u0338．\\u0639ss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4019\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}<\x{0338}．\x{0639}Ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\<\\u0338．\\u0639Ss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4020\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}<\x{0338}．\x{0639}Ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\<\\u0338．\\u0639Ss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4021\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}≮．\x{0639}Ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\≮．\\u0639Ss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4022\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㸳\x{06A6}≮．\x{0639}Ss-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳\\u06A6\≮．\\u0639Ss\-\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4023\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-򍯄\x{0FA3}\x{081E}.\x{AAEC}-︒", %p)},	undef,	"to_unicode\(\'\-򍯄\\u0FA3\\u081E\.\\uAAEC\-︒\'\)\ throws\ error\ P1\ V3\ V6\ V5\ \[data\/IdnaTest\.txt\:4024\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-򍯄\x{0FA3}\x{081E}.\x{AAEC}-。", %p)},	undef,	"to_unicode\(\'\-򍯄\\u0FA3\\u081E\.\\uAAEC\-\。\'\)\ throws\ error\ P1\ V3\ V6\ V5\ \[data\/IdnaTest\.txt\:4025\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒.񴻫𝨖", %p)},	undef,	"to_unicode\(\'︒\.񴻫𝨖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4026\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。.񴻫𝨖", %p)},	undef,	"to_unicode\(\'\。\.񴻫𝨖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4027\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠄻󠄙。\x{200C}⓾\x{200C}\x{074D}", %p)},	undef,	"to_unicode\(\'\󠄻\󠄙\。\\u200C⓾\\u200C\\u074D\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:4028\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠄻󠄙。\x{200C}⓾\x{200C}\x{074D}", %p)},	undef,	"to_unicode\(\'\󠄻\󠄙\。\\u200C⓾\\u200C\\u074D\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:4029\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞼸ᠷ\x{066B}｡\x{08F4}\x{07E5}𝩞", %p)},	undef,	"to_unicode\(\'𞼸ᠷ\\u066B｡\\u08F4\\u07E5𝩞\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B1\ \[data\/IdnaTest\.txt\:4030\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞼸ᠷ\x{066B}。\x{08F4}\x{07E5}𝩞", %p)},	undef,	"to_unicode\(\'𞼸ᠷ\\u066B\。\\u08F4\\u07E5𝩞\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B1\ \[data\/IdnaTest\.txt\:4031\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A69F}.-񛴭", %p)},	undef,	"to_unicode\(\'\\uA69F\.\-񛴭\'\)\ throws\ error\ P1\ V5\ V3\ V6\ \[data\/IdnaTest\.txt\:4032\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠦠．赏", %p)},	undef,	"to_unicode\(\'\󠦠．赏\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4033\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠦠.赏", %p)},	undef,	"to_unicode\(\'\󠦠\.赏\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4034\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07D1}\x{0630}｡Ⴁ", %p)},	undef,	"to_unicode\(\'\\u07D1\\u0630｡Ⴁ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4035\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07D1}\x{0630}。Ⴁ", %p)},	undef,	"to_unicode\(\'\\u07D1\\u0630\。Ⴁ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4036\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07D1}\x{0630}。ⴁ", %p)},	"\x{07D1}\x{0630}.ⴁ",	"to_unicode\(\'\\u07D1\\u0630\。ⴁ\'\)\ \[data\/IdnaTest\.txt\:4037\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("xn--vgb74f.xn--skj", %p)},	"\x{07D1}\x{0630}.ⴁ",	"to_unicode\(\'xn\-\-vgb74f\.xn\-\-skj\'\)\ \[data\/IdnaTest\.txt\:4038\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07D1}\x{0630}.ⴁ", %p)},	"\x{07D1}\x{0630}.ⴁ",	"to_unicode\(\'\\u07D1\\u0630\.ⴁ\'\)\ \[data\/IdnaTest\.txt\:4039\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{07D1}\x{0630}.Ⴁ", %p)},	undef,	"to_unicode\(\'\\u07D1\\u0630\.Ⴁ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4040\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07D1}\x{0630}｡ⴁ", %p)},	"\x{07D1}\x{0630}.ⴁ",	"to_unicode\(\'\\u07D1\\u0630｡ⴁ\'\)\ \[data\/IdnaTest\.txt\:4041\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0A01}Ⴊᡨς｡-", %p)},	undef,	"to_unicode\(\'\\u0A01Ⴊᡨς｡\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ \[data\/IdnaTest\.txt\:4042\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0A01}Ⴊᡨς。-", %p)},	undef,	"to_unicode\(\'\\u0A01Ⴊᡨς\。\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ \[data\/IdnaTest\.txt\:4043\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0A01}ⴊᡨς。-", %p)},	undef,	"to_unicode\(\'\\u0A01ⴊᡨς\。\-\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:4044\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0A01}ႪᡨΣ。-", %p)},	undef,	"to_unicode\(\'\\u0A01ႪᡨΣ\。\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ \[data\/IdnaTest\.txt\:4045\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0A01}ⴊᡨσ。-", %p)},	undef,	"to_unicode\(\'\\u0A01ⴊᡨσ\。\-\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:4046\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0A01}Ⴊᡨσ。-", %p)},	undef,	"to_unicode\(\'\\u0A01Ⴊᡨσ\。\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ \[data\/IdnaTest\.txt\:4047\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0A01}ⴊᡨς｡-", %p)},	undef,	"to_unicode\(\'\\u0A01ⴊᡨς｡\-\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:4048\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0A01}ႪᡨΣ｡-", %p)},	undef,	"to_unicode\(\'\\u0A01ႪᡨΣ｡\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ \[data\/IdnaTest\.txt\:4049\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("\x{0A01}ⴊᡨσ｡-", %p)},	undef,	"to_unicode\(\'\\u0A01ⴊᡨσ｡\-\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:4050\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0A01}Ⴊᡨσ｡-", %p)},	undef,	"to_unicode\(\'\\u0A01Ⴊᡨσ｡\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ \[data\/IdnaTest\.txt\:4051\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴍ．𦛀\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴍ．𦛀\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4052\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴍ．𦛀\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴍ．𦛀\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4053\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴍ.𦛀\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴍ\.𦛀\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4054\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴍ.𦛀\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴍ\.𦛀\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4055\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴍ.𦛀\x{200C}", %p)},	undef,	"to_unicode\(\'ⴍ\.𦛀\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:4056\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴍ.𦛀\x{200C}", %p)},	undef,	"to_unicode\(\'ⴍ\.𦛀\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:4057\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--4kj.xn--2m2k", %p)},	"ⴍ.𦛀",	"to_unicode\(\'xn\-\-4kj\.xn\-\-2m2k\'\)\ \[data\/IdnaTest\.txt\:4058\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴍ.𦛀", %p)},	"ⴍ.𦛀",	"to_unicode\(\'ⴍ\.𦛀\'\)\ \[data\/IdnaTest\.txt\:4059\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴍ.𦛀", %p)},	undef,	"to_unicode\(\'Ⴍ\.𦛀\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4060\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴍ．𦛀\x{200C}", %p)},	undef,	"to_unicode\(\'ⴍ．𦛀\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:4061\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ⴍ．𦛀\x{200C}", %p)},	undef,	"to_unicode\(\'ⴍ．𦛀\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:4062\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("󈯇𐆔.\x{07E6}\x{1A60}󆫚𑓂", %p)},	undef,	"to_unicode\(\'󈯇𐆔\.\\u07E6\\u1A60󆫚𑓂\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4063\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{0F8F}\x{06B5}｡\x{0662}᠈", %p)},	undef,	"to_unicode\(\'\≯\\u0F8F\\u06B5｡\\u0662᠈\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4064\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{0F8F}\x{06B5}｡\x{0662}᠈", %p)},	undef,	"to_unicode\(\'\>\\u0338\\u0F8F\\u06B5｡\\u0662᠈\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4065\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{0F8F}\x{06B5}。\x{0662}᠈", %p)},	undef,	"to_unicode\(\'\≯\\u0F8F\\u06B5\。\\u0662᠈\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4066\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{0F8F}\x{06B5}。\x{0662}᠈", %p)},	undef,	"to_unicode\(\'\>\\u0338\\u0F8F\\u06B5\。\\u0662᠈\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4067\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򪗢\x{0601}\x{FC34}\x{0666}。ႨꡍႯ", %p)},	undef,	"to_unicode\(\'򪗢\\u0601\\uFC34\\u0666\。ႨꡍႯ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4068\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򪗢\x{0601}\x{0642}\x{0645}\x{0666}。ႨꡍႯ", %p)},	undef,	"to_unicode\(\'򪗢\\u0601\\u0642\\u0645\\u0666\。ႨꡍႯ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4069\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򪗢\x{0601}\x{0642}\x{0645}\x{0666}。ⴈꡍⴏ", %p)},	undef,	"to_unicode\(\'򪗢\\u0601\\u0642\\u0645\\u0666\。ⴈꡍⴏ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4070\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򪗢\x{0601}\x{0642}\x{0645}\x{0666}。Ⴈꡍⴏ", %p)},	undef,	"to_unicode\(\'򪗢\\u0601\\u0642\\u0645\\u0666\。Ⴈꡍⴏ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4071\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򪗢\x{0601}\x{FC34}\x{0666}。ⴈꡍⴏ", %p)},	undef,	"to_unicode\(\'򪗢\\u0601\\uFC34\\u0666\。ⴈꡍⴏ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4072\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򪗢\x{0601}\x{FC34}\x{0666}。Ⴈꡍⴏ", %p)},	undef,	"to_unicode\(\'򪗢\\u0601\\uFC34\\u0666\。Ⴈꡍⴏ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4073\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐤺。𑖼", %p)},	undef,	"to_unicode\(\'𐤺\。𑖼\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4074\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("𝟔𐹽．\x{AAEC}⎤９\x{075F}", %p)},	undef,	"to_unicode\(\'𝟔𐹽．\\uAAEC\⎤９\\u075F\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:4075\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("6𐹽.\x{AAEC}⎤9\x{075F}", %p)},	undef,	"to_unicode\(\'6𐹽\.\\uAAEC\⎤9\\u075F\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:4076\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𐫐𐹾𞽂．𝩏", %p)},	undef,	"to_unicode\(\'𐫐𐹾𞽂．𝩏\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4077\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐫐𐹾𞽂.𝩏", %p)},	undef,	"to_unicode\(\'𐫐𐹾𞽂\.𝩏\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4078\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("❫󥖿ᠠ．𞲻\x{200D}𞤙", %p)},	undef,	"to_unicode\(\'\❫󥖿ᠠ．𞲻\\u200D𞤙\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4079\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("❫󥖿ᠠ．𞲻\x{200D}𞤙", %p)},	undef,	"to_unicode\(\'\❫󥖿ᠠ．𞲻\\u200D𞤙\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4080\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("❫󥖿ᠠ.𞲻\x{200D}𞤙", %p)},	undef,	"to_unicode\(\'\❫󥖿ᠠ\.𞲻\\u200D𞤙\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4081\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("❫󥖿ᠠ.𞲻\x{200D}𞤙", %p)},	undef,	"to_unicode\(\'\❫󥖿ᠠ\.𞲻\\u200D𞤙\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4082\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{072E}󈐓\x{FBD4}-．≠𹔭\x{1BF3}", %p)},	undef,	"to_unicode\(\'\\u072E󈐓\\uFBD4\-．\≠𹔭\\u1BF3\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4083\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{072E}󈐓\x{FBD4}-．=\x{0338}𹔭\x{1BF3}", %p)},	undef,	"to_unicode\(\'\\u072E󈐓\\uFBD4\-．\=\\u0338𹔭\\u1BF3\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4084\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{072E}󈐓\x{06AD}-.≠𹔭\x{1BF3}", %p)},	undef,	"to_unicode\(\'\\u072E󈐓\\u06AD\-\.\≠𹔭\\u1BF3\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4085\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{072E}󈐓\x{06AD}-.=\x{0338}𹔭\x{1BF3}", %p)},	undef,	"to_unicode\(\'\\u072E󈐓\\u06AD\-\.\=\\u0338𹔭\\u1BF3\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4086\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟛．󗹙", %p)},	undef,	"to_unicode\(\'𝟛．󗹙\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4087\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("3.󗹙", %p)},	undef,	"to_unicode\(\'3\.󗹙\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4088\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200D}.Ⴞ𐋷", %p)},	undef,	"to_unicode\(\'\-\\u200D\.Ⴞ𐋷\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:4089\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200D}.Ⴞ𐋷", %p)},	undef,	"to_unicode\(\'\-\\u200D\.Ⴞ𐋷\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:4090\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("-\x{200D}.ⴞ𐋷", %p)},	undef,	"to_unicode\(\'\-\\u200D\.ⴞ𐋷\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:4091\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("-\x{200D}.ⴞ𐋷", %p)},	undef,	"to_unicode\(\'\-\\u200D\.ⴞ𐋷\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:4092\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}ςß\x{A675}．𑘿", %p)},	undef,	"to_unicode\(\'\\u200Dςß\\uA675．𑘿\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4093\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}ςß\x{A675}．𑘿", %p)},	undef,	"to_unicode\(\'\\u200Dςß\\uA675．𑘿\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4094\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}ςß\x{A675}.𑘿", %p)},	undef,	"to_unicode\(\'\\u200Dςß\\uA675\.𑘿\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4095\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}ςß\x{A675}.𑘿", %p)},	undef,	"to_unicode\(\'\\u200Dςß\\uA675\.𑘿\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4096\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}ΣSS\x{A675}.𑘿", %p)},	undef,	"to_unicode\(\'\\u200DΣSS\\uA675\.𑘿\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4097\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}ΣSS\x{A675}.𑘿", %p)},	undef,	"to_unicode\(\'\\u200DΣSS\\uA675\.𑘿\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4098\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}σss\x{A675}.𑘿", %p)},	undef,	"to_unicode\(\'\\u200Dσss\\uA675\.𑘿\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4099\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}σss\x{A675}.𑘿", %p)},	undef,	"to_unicode\(\'\\u200Dσss\\uA675\.𑘿\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4100\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}Σss\x{A675}.𑘿", %p)},	undef,	"to_unicode\(\'\\u200DΣss\\uA675\.𑘿\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4101\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}Σss\x{A675}.𑘿", %p)},	undef,	"to_unicode\(\'\\u200DΣss\\uA675\.𑘿\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4102\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}Σß\x{A675}.𑘿", %p)},	undef,	"to_unicode\(\'\\u200DΣß\\uA675\.𑘿\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4103\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}Σß\x{A675}.𑘿", %p)},	undef,	"to_unicode\(\'\\u200DΣß\\uA675\.𑘿\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4104\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}σß\x{A675}.𑘿", %p)},	undef,	"to_unicode\(\'\\u200Dσß\\uA675\.𑘿\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4105\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}σß\x{A675}.𑘿", %p)},	undef,	"to_unicode\(\'\\u200Dσß\\uA675\.𑘿\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4106\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}ΣSS\x{A675}．𑘿", %p)},	undef,	"to_unicode\(\'\\u200DΣSS\\uA675．𑘿\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4107\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}ΣSS\x{A675}．𑘿", %p)},	undef,	"to_unicode\(\'\\u200DΣSS\\uA675．𑘿\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4108\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}σss\x{A675}．𑘿", %p)},	undef,	"to_unicode\(\'\\u200Dσss\\uA675．𑘿\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4109\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}σss\x{A675}．𑘿", %p)},	undef,	"to_unicode\(\'\\u200Dσss\\uA675．𑘿\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4110\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}Σss\x{A675}．𑘿", %p)},	undef,	"to_unicode\(\'\\u200DΣss\\uA675．𑘿\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4111\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}Σss\x{A675}．𑘿", %p)},	undef,	"to_unicode\(\'\\u200DΣss\\uA675．𑘿\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4112\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}Σß\x{A675}．𑘿", %p)},	undef,	"to_unicode\(\'\\u200DΣß\\uA675．𑘿\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4113\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}Σß\x{A675}．𑘿", %p)},	undef,	"to_unicode\(\'\\u200DΣß\\uA675．𑘿\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4114\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}σß\x{A675}．𑘿", %p)},	undef,	"to_unicode\(\'\\u200Dσß\\uA675．𑘿\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4115\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200D}σß\x{A675}．𑘿", %p)},	undef,	"to_unicode\(\'\\u200Dσß\\uA675．𑘿\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:4116\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("≠．\x{200D}", %p)},	undef,	"to_unicode\(\'\≠．\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4117\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠．\x{200D}", %p)},	undef,	"to_unicode\(\'\≠．\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4118\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}．\x{200D}", %p)},	undef,	"to_unicode\(\'\=\\u0338．\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4119\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}．\x{200D}", %p)},	undef,	"to_unicode\(\'\=\\u0338．\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4120\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠.\x{200D}", %p)},	undef,	"to_unicode\(\'\≠\.\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4121\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠.\x{200D}", %p)},	undef,	"to_unicode\(\'\≠\.\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4122\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}.\x{200D}", %p)},	undef,	"to_unicode\(\'\=\\u0338\.\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4123\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}.\x{200D}", %p)},	undef,	"to_unicode\(\'\=\\u0338\.\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4124\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐦽｡\x{070F}\x{0643}󠳠򲯕", %p)},	undef,	"to_unicode\(\'𐦽｡\\u070F\\u0643\󠳠򲯕\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4125\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐦽。\x{070F}\x{0643}󠳠򲯕", %p)},	undef,	"to_unicode\(\'𐦽\。\\u070F\\u0643\󠳠򲯕\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4126\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󦨋\x{0B4D}ς．ς\x{2D7F}", %p)},	undef,	"to_unicode\(\'󦨋\\u0B4Dς．ς\\u2D7F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4127\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󦨋\x{0B4D}ς.ς\x{2D7F}", %p)},	undef,	"to_unicode\(\'󦨋\\u0B4Dς\.ς\\u2D7F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4128\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󦨋\x{0B4D}Σ.Σ\x{2D7F}", %p)},	undef,	"to_unicode\(\'󦨋\\u0B4DΣ\.Σ\\u2D7F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4129\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󦨋\x{0B4D}σ.ς\x{2D7F}", %p)},	undef,	"to_unicode\(\'󦨋\\u0B4Dσ\.ς\\u2D7F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4130\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󦨋\x{0B4D}σ.σ\x{2D7F}", %p)},	undef,	"to_unicode\(\'󦨋\\u0B4Dσ\.σ\\u2D7F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4131\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󦨋\x{0B4D}Σ.σ\x{2D7F}", %p)},	undef,	"to_unicode\(\'󦨋\\u0B4DΣ\.σ\\u2D7F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4132\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󦨋\x{0B4D}Σ.ς\x{2D7F}", %p)},	undef,	"to_unicode\(\'󦨋\\u0B4DΣ\.ς\\u2D7F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4133\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󦨋\x{0B4D}Σ．Σ\x{2D7F}", %p)},	undef,	"to_unicode\(\'󦨋\\u0B4DΣ．Σ\\u2D7F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4134\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󦨋\x{0B4D}σ．ς\x{2D7F}", %p)},	undef,	"to_unicode\(\'󦨋\\u0B4Dσ．ς\\u2D7F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4135\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󦨋\x{0B4D}σ．σ\x{2D7F}", %p)},	undef,	"to_unicode\(\'󦨋\\u0B4Dσ．σ\\u2D7F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4136\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󦨋\x{0B4D}Σ．σ\x{2D7F}", %p)},	undef,	"to_unicode\(\'󦨋\\u0B4DΣ．σ\\u2D7F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4137\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󦨋\x{0B4D}Σ．ς\x{2D7F}", %p)},	undef,	"to_unicode\(\'󦨋\\u0B4DΣ．ς\\u2D7F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4138\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0649}\x{0843}牅\x{20E3}｡\x{FEFA}\x{0BCD}񣨧Ⴙ", %p)},	undef,	"to_unicode\(\'\\u0649\\u0843牅\\u20E3｡\\uFEFA\\u0BCD񣨧Ⴙ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4139\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0649}\x{0843}牅\x{20E3}。\x{0644}\x{0625}\x{0BCD}񣨧Ⴙ", %p)},	undef,	"to_unicode\(\'\\u0649\\u0843牅\\u20E3\。\\u0644\\u0625\\u0BCD񣨧Ⴙ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4140\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0649}\x{0843}牅\x{20E3}。\x{0644}\x{0627}\x{0BCD}\x{0655}񣨧Ⴙ", %p)},	undef,	"to_unicode\(\'\\u0649\\u0843牅\\u20E3\。\\u0644\\u0627\\u0BCD\\u0655񣨧Ⴙ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4141\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0649}\x{0843}牅\x{20E3}。\x{0644}\x{0627}\x{0BCD}\x{0655}񣨧ⴙ", %p)},	undef,	"to_unicode\(\'\\u0649\\u0843牅\\u20E3\。\\u0644\\u0627\\u0BCD\\u0655񣨧ⴙ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4142\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0649}\x{0843}牅\x{20E3}。\x{0644}\x{0625}\x{0BCD}񣨧ⴙ", %p)},	undef,	"to_unicode\(\'\\u0649\\u0843牅\\u20E3\。\\u0644\\u0625\\u0BCD񣨧ⴙ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4143\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0649}\x{0843}牅\x{20E3}｡\x{FEFA}\x{0BCD}񣨧ⴙ", %p)},	undef,	"to_unicode\(\'\\u0649\\u0843牅\\u20E3｡\\uFEFA\\u0BCD񣨧ⴙ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4144\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{EA0B}｡륧", %p)},	undef,	"to_unicode\(\'\\uEA0B｡륧\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4145\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{EA0B}｡륧", %p)},	undef,	"to_unicode\(\'\\uEA0B｡륧\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4146\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{EA0B}。륧", %p)},	undef,	"to_unicode\(\'\\uEA0B\。륧\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4147\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{EA0B}。륧", %p)},	undef,	"to_unicode\(\'\\uEA0B\。륧\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4148\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹱\x{200D}。򠊑", %p)},	undef,	"to_unicode\(\'𐹱\\u200D\。򠊑\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4149\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹱\x{200D}。򠊑", %p)},	undef,	"to_unicode\(\'𐹱\\u200D\。򠊑\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4150\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴘꡁ𑚰｡-", %p)},	undef,	"to_unicode\(\'Ⴘꡁ𑚰｡\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:4151\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴘꡁ𑚰。-", %p)},	undef,	"to_unicode\(\'Ⴘꡁ𑚰\。\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:4152\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("ⴘꡁ𑚰。-", %p)},	undef,	"to_unicode\(\'ⴘꡁ𑚰\。\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:4153\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("ⴘꡁ𑚰｡-", %p)},	undef,	"to_unicode\(\'ⴘꡁ𑚰｡\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:4154\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{1714}ꡊ₆\x{06B5}。󠢀𐶳", %p)},	undef,	"to_unicode\(\'\\u1714ꡊ₆\\u06B5\。\󠢀𐶳\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:4155\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1714}ꡊ6\x{06B5}。󠢀𐶳", %p)},	undef,	"to_unicode\(\'\\u1714ꡊ6\\u06B5\。\󠢀𐶳\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:4156\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򄘈.🂹ᡯ\x{0772}\x{072A}", %p)},	undef,	"to_unicode\(\'򄘈\.🂹ᡯ\\u0772\\u072A\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4157\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{076F}񰱲。-ꡀ", %p)},	undef,	"to_unicode\(\'\\u076F񰱲\。\-ꡀ\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:4158\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς\x{06C4}⾑．\x{200C}\x{07D1}\x{200C}⒈", %p)},	undef,	"to_unicode\(\'ς\\u06C4⾑．\\u200C\\u07D1\\u200C⒈\'\)\ throws\ error\ P1\ V6\ B5\ B1\ C1\ \[data\/IdnaTest\.txt\:4159\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς\x{06C4}⾑．\x{200C}\x{07D1}\x{200C}⒈", %p)},	undef,	"to_unicode\(\'ς\\u06C4⾑．\\u200C\\u07D1\\u200C⒈\'\)\ throws\ error\ P1\ V6\ B5\ B1\ C1\ \[data\/IdnaTest\.txt\:4160\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ς\x{06C4}襾.\x{200C}\x{07D1}\x{200C}1.", %p)},	undef,	"to_unicode\(\'ς\\u06C4襾\.\\u200C\\u07D1\\u200C1\.\'\)\ throws\ error\ B5\ B1\ C1\ \[data\/IdnaTest\.txt\:4161\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ς\x{06C4}襾.\x{200C}\x{07D1}\x{200C}1.", %p)},	undef,	"to_unicode\(\'ς\\u06C4襾\.\\u200C\\u07D1\\u200C1\.\'\)\ throws\ error\ B5\ B1\ C1\ \[data\/IdnaTest\.txt\:4162\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("Σ\x{06C4}襾.\x{200C}\x{07D1}\x{200C}1.", %p)},	undef,	"to_unicode\(\'Σ\\u06C4襾\.\\u200C\\u07D1\\u200C1\.\'\)\ throws\ error\ B5\ B1\ C1\ \[data\/IdnaTest\.txt\:4163\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("Σ\x{06C4}襾.\x{200C}\x{07D1}\x{200C}1.", %p)},	undef,	"to_unicode\(\'Σ\\u06C4襾\.\\u200C\\u07D1\\u200C1\.\'\)\ throws\ error\ B5\ B1\ C1\ \[data\/IdnaTest\.txt\:4164\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("σ\x{06C4}襾.\x{200C}\x{07D1}\x{200C}1.", %p)},	undef,	"to_unicode\(\'σ\\u06C4襾\.\\u200C\\u07D1\\u200C1\.\'\)\ throws\ error\ B5\ B1\ C1\ \[data\/IdnaTest\.txt\:4165\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("σ\x{06C4}襾.\x{200C}\x{07D1}\x{200C}1.", %p)},	undef,	"to_unicode\(\'σ\\u06C4襾\.\\u200C\\u07D1\\u200C1\.\'\)\ throws\ error\ B5\ B1\ C1\ \[data\/IdnaTest\.txt\:4166\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Σ\x{06C4}⾑．\x{200C}\x{07D1}\x{200C}⒈", %p)},	undef,	"to_unicode\(\'Σ\\u06C4⾑．\\u200C\\u07D1\\u200C⒈\'\)\ throws\ error\ P1\ V6\ B5\ B1\ C1\ \[data\/IdnaTest\.txt\:4167\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ\x{06C4}⾑．\x{200C}\x{07D1}\x{200C}⒈", %p)},	undef,	"to_unicode\(\'Σ\\u06C4⾑．\\u200C\\u07D1\\u200C⒈\'\)\ throws\ error\ P1\ V6\ B5\ B1\ C1\ \[data\/IdnaTest\.txt\:4168\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ\x{06C4}⾑．\x{200C}\x{07D1}\x{200C}⒈", %p)},	undef,	"to_unicode\(\'σ\\u06C4⾑．\\u200C\\u07D1\\u200C⒈\'\)\ throws\ error\ P1\ V6\ B5\ B1\ C1\ \[data\/IdnaTest\.txt\:4169\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ\x{06C4}⾑．\x{200C}\x{07D1}\x{200C}⒈", %p)},	undef,	"to_unicode\(\'σ\\u06C4⾑．\\u200C\\u07D1\\u200C⒈\'\)\ throws\ error\ P1\ V6\ B5\ B1\ C1\ \[data\/IdnaTest\.txt\:4170\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡤ󐿐．𐦞", %p)},	undef,	"to_unicode\(\'ꡤ󐿐．𐦞\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4171\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡤ󐿐.𐦞", %p)},	undef,	"to_unicode\(\'ꡤ󐿐\.𐦞\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4172\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9C0}󿉛\x{1C32}｡\x{200C}\x{0645}򱧗", %p)},	undef,	"to_unicode\(\'\\uA9C0󿉛\\u1C32｡\\u200C\\u0645򱧗\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:4173\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9C0}󿉛\x{1C32}｡\x{200C}\x{0645}򱧗", %p)},	undef,	"to_unicode\(\'\\uA9C0󿉛\\u1C32｡\\u200C\\u0645򱧗\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:4174\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9C0}󿉛\x{1C32}。\x{200C}\x{0645}򱧗", %p)},	undef,	"to_unicode\(\'\\uA9C0󿉛\\u1C32\。\\u200C\\u0645򱧗\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:4175\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9C0}󿉛\x{1C32}。\x{200C}\x{0645}򱧗", %p)},	undef,	"to_unicode\(\'\\uA9C0󿉛\\u1C32\。\\u200C\\u0645򱧗\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:4176\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡘ\x{0E4C}𾎮-．\x{200C}먿", %p)},	undef,	"to_unicode\(\'ᡘ\\u0E4C𾎮\-．\\u200C먿\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:4177\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡘ\x{0E4C}𾎮-．\x{200C}먿", %p)},	undef,	"to_unicode\(\'ᡘ\\u0E4C𾎮\-．\\u200C먿\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:4178\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡘ\x{0E4C}𾎮-．\x{200C}먿", %p)},	undef,	"to_unicode\(\'ᡘ\\u0E4C𾎮\-．\\u200C먿\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:4179\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡘ\x{0E4C}𾎮-．\x{200C}먿", %p)},	undef,	"to_unicode\(\'ᡘ\\u0E4C𾎮\-．\\u200C먿\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:4180\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡘ\x{0E4C}𾎮-.\x{200C}먿", %p)},	undef,	"to_unicode\(\'ᡘ\\u0E4C𾎮\-\.\\u200C먿\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:4181\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡘ\x{0E4C}𾎮-.\x{200C}먿", %p)},	undef,	"to_unicode\(\'ᡘ\\u0E4C𾎮\-\.\\u200C먿\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:4182\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡘ\x{0E4C}𾎮-.\x{200C}먿", %p)},	undef,	"to_unicode\(\'ᡘ\\u0E4C𾎮\-\.\\u200C먿\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:4183\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡘ\x{0E4C}𾎮-.\x{200C}먿", %p)},	undef,	"to_unicode\(\'ᡘ\\u0E4C𾎮\-\.\\u200C먿\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:4184\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("􅬜｡ᡖ", %p)},	undef,	"to_unicode\(\'􅬜｡ᡖ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4185\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("􅬜。ᡖ", %p)},	undef,	"to_unicode\(\'􅬜\。ᡖ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4186\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("嬃\x{009A}．\x{200D}\x{05AA}", %p)},	undef,	"to_unicode\(\'嬃\\u009A．\\u200D\\u05AA\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4187\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("嬃\x{009A}．\x{200D}\x{05AA}", %p)},	undef,	"to_unicode\(\'嬃\\u009A．\\u200D\\u05AA\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4188\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("嬃\x{009A}.\x{200D}\x{05AA}", %p)},	undef,	"to_unicode\(\'嬃\\u009A\.\\u200D\\u05AA\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4189\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("嬃\x{009A}.\x{200D}\x{05AA}", %p)},	undef,	"to_unicode\(\'嬃\\u009A\.\\u200D\\u05AA\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4190\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹤󠱎≯．󣎔򅋾", %p)},	undef,	"to_unicode\(\'𐹤\󠱎\≯．󣎔򅋾\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4191\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹤󠱎>\x{0338}．󣎔򅋾", %p)},	undef,	"to_unicode\(\'𐹤\󠱎\>\\u0338．󣎔򅋾\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4192\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹤󠱎≯.󣎔򅋾", %p)},	undef,	"to_unicode\(\'𐹤\󠱎\≯\.󣎔򅋾\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4193\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹤󠱎>\x{0338}.󣎔򅋾", %p)},	undef,	"to_unicode\(\'𐹤\󠱎\>\\u0338\.󣎔򅋾\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4194\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񂩳\x{07D6}\x{0659}\x{1BAB}.𞶀", %p)},	undef,	"to_unicode\(\'񂩳\\u07D6\\u0659\\u1BAB\.𞶀\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4195\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񂩳\x{07D6}\x{1BAB}\x{0659}.𞶀", %p)},	undef,	"to_unicode\(\'񂩳\\u07D6\\u1BAB\\u0659\.𞶀\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4196\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.򴈶", %p)},	undef,	"to_unicode\(\'\\u200C\.򴈶\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4197\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.򴈶", %p)},	undef,	"to_unicode\(\'\\u200C\.򴈶\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4198\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򠪓Ⴃ䠅．\x{FB65}", %p)},	undef,	"to_unicode\(\'򠪓Ⴃ䠅．\\uFB65\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4199\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򠪓Ⴃ䠅.\x{067F}", %p)},	undef,	"to_unicode\(\'򠪓Ⴃ䠅\.\\u067F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4200\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򠪓ⴃ䠅.\x{067F}", %p)},	undef,	"to_unicode\(\'򠪓ⴃ䠅\.\\u067F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4201\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򠪓ⴃ䠅．\x{FB65}", %p)},	undef,	"to_unicode\(\'򠪓ⴃ䠅．\\uFB65\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4202\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0741}\x{0662}𐹮𐮑｡𝟨Ⴅ", %p)},	undef,	"to_unicode\(\'\\u0741\\u0662𐹮𐮑｡𝟨Ⴅ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:4203\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0741}\x{0662}𐹮𐮑。6Ⴅ", %p)},	undef,	"to_unicode\(\'\\u0741\\u0662𐹮𐮑\。6Ⴅ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:4204\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0741}\x{0662}𐹮𐮑。6ⴅ", %p)},	undef,	"to_unicode\(\'\\u0741\\u0662𐹮𐮑\。6ⴅ\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:4205\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{0741}\x{0662}𐹮𐮑｡𝟨ⴅ", %p)},	undef,	"to_unicode\(\'\\u0741\\u0662𐹮𐮑｡𝟨ⴅ\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:4206\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-｡︒", %p)},	undef,	"to_unicode\(\'\-｡︒\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4207\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-。。", %p)},	undef,	"to_unicode\(\'\-\。\。\'\)\ throws\ error\ V3\ A4_2\ \[data\/IdnaTest\.txt\:4208\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡊჀ｡-⁵--", %p)},	undef,	"to_unicode\(\'ꡊჀ｡\-⁵\-\-\'\)\ throws\ error\ P1\ V6\ V2\ V3\ \[data\/IdnaTest\.txt\:4209\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡊჀ。-5--", %p)},	undef,	"to_unicode\(\'ꡊჀ\。\-5\-\-\'\)\ throws\ error\ P1\ V6\ V2\ V3\ \[data\/IdnaTest\.txt\:4210\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ꡊⴠ。-5--", %p)},	undef,	"to_unicode\(\'ꡊⴠ\。\-5\-\-\'\)\ throws\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:4211\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("ꡊⴠ｡-⁵--", %p)},	undef,	"to_unicode\(\'ꡊⴠ｡\-⁵\-\-\'\)\ throws\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:4212\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("≯\x{D8DD}󠍣｡\x{066C}𐹣≯𞡾", %p)},	undef,	"to_unicode\(\'\≯\\uD8DD\󠍣｡\\u066C𐹣\≯𞡾\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4213\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{D8DD}󠍣｡\x{066C}𐹣>\x{0338}𞡾", %p)},	undef,	"to_unicode\(\'\>\\u0338\\uD8DD\󠍣｡\\u066C𐹣\>\\u0338𞡾\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4214\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{D8DD}󠍣。\x{066C}𐹣≯𞡾", %p)},	undef,	"to_unicode\(\'\≯\\uD8DD\󠍣\。\\u066C𐹣\≯𞡾\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4215\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{D8DD}󠍣。\x{066C}𐹣>\x{0338}𞡾", %p)},	undef,	"to_unicode\(\'\>\\u0338\\uD8DD\󠍣\。\\u066C𐹣\>\\u0338𞡾\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4216\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㍔\x{0329}\x{084A}\x{200D}。𑌼𵟣\x{05B2}𐹾", %p)},	undef,	"to_unicode\(\'㍔\\u0329\\u084A\\u200D\。𑌼𵟣\\u05B2𐹾\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C2\ B1\ \[data\/IdnaTest\.txt\:4217\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㍔\x{0329}\x{084A}\x{200D}。𑌼𵟣\x{05B2}𐹾", %p)},	undef,	"to_unicode\(\'㍔\\u0329\\u084A\\u200D\。𑌼𵟣\\u05B2𐹾\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C2\ B1\ \[data\/IdnaTest\.txt\:4218\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ルーブル\x{0329}\x{084A}\x{200D}。𑌼𵟣\x{05B2}𐹾", %p)},	undef,	"to_unicode\(\'ルーブル\\u0329\\u084A\\u200D\。𑌼𵟣\\u05B2𐹾\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C2\ B1\ \[data\/IdnaTest\.txt\:4219\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ルーブル\x{0329}\x{084A}\x{200D}。𑌼𵟣\x{05B2}𐹾", %p)},	undef,	"to_unicode\(\'ルーブル\\u0329\\u084A\\u200D\。𑌼𵟣\\u05B2𐹾\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C2\ B1\ \[data\/IdnaTest\.txt\:4220\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ルーフ\x{3099}ル\x{0329}\x{084A}\x{200D}。𑌼𵟣\x{05B2}𐹾", %p)},	undef,	"to_unicode\(\'ルーフ\\u3099ル\\u0329\\u084A\\u200D\。𑌼𵟣\\u05B2𐹾\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C2\ B1\ \[data\/IdnaTest\.txt\:4221\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ルーフ\x{3099}ル\x{0329}\x{084A}\x{200D}。𑌼𵟣\x{05B2}𐹾", %p)},	undef,	"to_unicode\(\'ルーフ\\u3099ル\\u0329\\u084A\\u200D\。𑌼𵟣\\u05B2𐹾\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C2\ B1\ \[data\/IdnaTest\.txt\:4222\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}.F", %p)},	undef,	"to_unicode\(\'\\u200D\.F\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4223\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}.F", %p)},	undef,	"to_unicode\(\'\\u200D\.F\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4224\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("f", %p)},	"f",	"to_unicode\(\'f\'\)\ \[data\/IdnaTest\.txt\:4225\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}㨲｡ß", %p)},	undef,	"to_unicode\(\'\\u200D㨲｡ß\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4226\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}㨲｡ß", %p)},	undef,	"to_unicode\(\'\\u200D㨲｡ß\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4227\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}㨲。ß", %p)},	undef,	"to_unicode\(\'\\u200D㨲\。ß\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4228\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}㨲。ß", %p)},	undef,	"to_unicode\(\'\\u200D㨲\。ß\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4229\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}㨲。SS", %p)},	undef,	"to_unicode\(\'\\u200D㨲\。SS\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4230\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}㨲。SS", %p)},	undef,	"to_unicode\(\'\\u200D㨲\。SS\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4231\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--9bm.ss", %p)},	"㨲.ss",	"to_unicode\(\'xn\-\-9bm\.ss\'\)\ \[data\/IdnaTest\.txt\:4232\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㨲.ss", %p)},	"㨲.ss",	"to_unicode\(\'㨲\.ss\'\)\ \[data\/IdnaTest\.txt\:4233\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}㨲｡SS", %p)},	undef,	"to_unicode\(\'\\u200D㨲｡SS\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4234\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}㨲｡SS", %p)},	undef,	"to_unicode\(\'\\u200D㨲｡SS\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4235\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹲ᠵ｡ᡡ", %p)},	undef,	"to_unicode\(\'𐹲ᠵ｡ᡡ\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4236\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("𐹲ᠵ。ᡡ", %p)},	undef,	"to_unicode\(\'𐹲ᠵ\。ᡡ\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:4237\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("⾑\x{06CC}\x{0646}。𐹻ᡘ", %p)},	undef,	"to_unicode\(\'⾑\\u06CC\\u0646\。𐹻ᡘ\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:4238\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("襾\x{06CC}\x{0646}。𐹻ᡘ", %p)},	undef,	"to_unicode\(\'襾\\u06CC\\u0646\。𐹻ᡘ\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:4239\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("񞭓ς-𝍆｡\x{07D5}-ꡑ", %p)},	undef,	"to_unicode\(\'񞭓ς\-𝍆｡\\u07D5\-ꡑ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4240\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񞭓ς-𝍆。\x{07D5}-ꡑ", %p)},	undef,	"to_unicode\(\'񞭓ς\-𝍆\。\\u07D5\-ꡑ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4241\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񞭓Σ-𝍆。\x{07D5}-ꡑ", %p)},	undef,	"to_unicode\(\'񞭓Σ\-𝍆\。\\u07D5\-ꡑ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4242\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񞭓σ-𝍆。\x{07D5}-ꡑ", %p)},	undef,	"to_unicode\(\'񞭓σ\-𝍆\。\\u07D5\-ꡑ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4243\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񞭓Σ-𝍆｡\x{07D5}-ꡑ", %p)},	undef,	"to_unicode\(\'񞭓Σ\-𝍆｡\\u07D5\-ꡑ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4244\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񞭓σ-𝍆｡\x{07D5}-ꡑ", %p)},	undef,	"to_unicode\(\'񞭓σ\-𝍆｡\\u07D5\-ꡑ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4245\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}．󅘺", %p)},	undef,	"to_unicode\(\'\\u200D．󅘺\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4246\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}．󅘺", %p)},	undef,	"to_unicode\(\'\\u200D．󅘺\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4247\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}.󅘺", %p)},	undef,	"to_unicode\(\'\\u200D\.󅘺\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4248\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}.󅘺", %p)},	undef,	"to_unicode\(\'\\u200D\.󅘺\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4249\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𲻩\x{EC0E}｡≠𝟲", %p)},	undef,	"to_unicode\(\'𲻩\\uEC0E｡\≠𝟲\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4250\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𲻩\x{EC0E}｡=\x{0338}𝟲", %p)},	undef,	"to_unicode\(\'𲻩\\uEC0E｡\=\\u0338𝟲\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4251\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𲻩\x{EC0E}。≠6", %p)},	undef,	"to_unicode\(\'𲻩\\uEC0E\。\≠6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4252\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𲻩\x{EC0E}。=\x{0338}6", %p)},	undef,	"to_unicode\(\'𲻩\\uEC0E\。\=\\u03386\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4253\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0F8F}ᠯ\x{200D}.\x{088C}", %p)},	undef,	"to_unicode\(\'\\u0F8Fᠯ\\u200D\.\\u088C\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:4254\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0F8F}ᠯ\x{200D}.\x{088C}", %p)},	undef,	"to_unicode\(\'\\u0F8Fᠯ\\u200D\.\\u088C\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:4255\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08FE}ꡔ𞨰\x{0B4D}．󣢅", %p)},	undef,	"to_unicode\(\'\\u08FEꡔ𞨰\\u0B4D．󣢅\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:4256\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{08FE}ꡔ𞨰\x{0B4D}.󣢅", %p)},	undef,	"to_unicode\(\'\\u08FEꡔ𞨰\\u0B4D\.󣢅\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:4257\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0848}。\x{302C}\x{200C}≯🌐", %p)},	undef,	"to_unicode\(\'\\u0848\。\\u302C\\u200C\≯🌐\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:4258\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0848}。\x{302C}\x{200C}≯🌐", %p)},	undef,	"to_unicode\(\'\\u0848\。\\u302C\\u200C\≯🌐\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:4259\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0848}。\x{302C}\x{200C}>\x{0338}🌐", %p)},	undef,	"to_unicode\(\'\\u0848\。\\u302C\\u200C\>\\u0338🌐\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:4260\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0848}。\x{302C}\x{200C}>\x{0338}🌐", %p)},	undef,	"to_unicode\(\'\\u0848\。\\u302C\\u200C\>\\u0338🌐\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:4261\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝨪𝟕.\x{063A}󯏭Ⴉ", %p)},	undef,	"to_unicode\(\'𝨪𝟕\.\\u063A󯏭Ⴉ\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4262\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝨪7.\x{063A}󯏭Ⴉ", %p)},	undef,	"to_unicode\(\'𝨪7\.\\u063A󯏭Ⴉ\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4263\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝨪7.\x{063A}󯏭ⴉ", %p)},	undef,	"to_unicode\(\'𝨪7\.\\u063A󯏭ⴉ\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4264\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝨪𝟕.\x{063A}󯏭ⴉ", %p)},	undef,	"to_unicode\(\'𝨪𝟕\.\\u063A󯏭ⴉ\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4265\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("閃9\x{0F77}。Ↄ𐹻\x{07DA}\x{AAF6}", %p)},	undef,	"to_unicode\(\'閃9\\u0F77\。Ↄ𐹻\\u07DA\\uAAF6\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4266\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("閃9\x{0FB2}\x{0F71}\x{0F80}。Ↄ𐹻\x{07DA}\x{AAF6}", %p)},	undef,	"to_unicode\(\'閃9\\u0FB2\\u0F71\\u0F80\。Ↄ𐹻\\u07DA\\uAAF6\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4267\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("閃9\x{0FB2}\x{0F71}\x{0F80}。ↄ𐹻\x{07DA}\x{AAF6}", %p)},	undef,	"to_unicode\(\'閃9\\u0FB2\\u0F71\\u0F80\。ↄ𐹻\\u07DA\\uAAF6\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:4268\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("閃9\x{0F77}。ↄ𐹻\x{07DA}\x{AAF6}", %p)},	undef,	"to_unicode\(\'閃9\\u0F77\。ↄ𐹻\\u07DA\\uAAF6\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:4269\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{1734}\x{06A9}𑄴２.𐋢\x{AA2E}\x{0F18}︒", %p)},	undef,	"to_unicode\(\'\\u1734\\u06A9𑄴２\.𐋢\\uAA2E\\u0F18︒\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:4270\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{1734}\x{06A9}𑄴2.𐋢\x{AA2E}\x{0F18}。", %p)},	undef,	"to_unicode\(\'\\u1734\\u06A9𑄴2\.𐋢\\uAA2E\\u0F18\。\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:4271\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𱛛｡≠-󠬇⾛", %p)},	undef,	"to_unicode\(\'𱛛｡\≠\-\󠬇⾛\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4272\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𱛛｡=\x{0338}-󠬇⾛", %p)},	undef,	"to_unicode\(\'𱛛｡\=\\u0338\-\󠬇⾛\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4273\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𱛛。≠-󠬇走", %p)},	undef,	"to_unicode\(\'𱛛\。\≠\-\󠬇走\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4274\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𱛛。=\x{0338}-󠬇走", %p)},	undef,	"to_unicode\(\'𱛛\。\=\\u0338\-\󠬇走\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4275\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡊ𐹵Ⴊ。-≠\x{1160}", %p)},	undef,	"to_unicode\(\'ᡊ𐹵Ⴊ\。\-\≠\\u1160\'\)\ throws\ error\ P1\ V6\ V3\ B5\ \[data\/IdnaTest\.txt\:4276\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡊ𐹵Ⴊ。-=\x{0338}\x{1160}", %p)},	undef,	"to_unicode\(\'ᡊ𐹵Ⴊ\。\-\=\\u0338\\u1160\'\)\ throws\ error\ P1\ V6\ V3\ B5\ \[data\/IdnaTest\.txt\:4277\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡊ𐹵ⴊ。-=\x{0338}\x{1160}", %p)},	undef,	"to_unicode\(\'ᡊ𐹵ⴊ\。\-\=\\u0338\\u1160\'\)\ throws\ error\ P1\ V3\ V6\ B5\ \[data\/IdnaTest\.txt\:4278\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡊ𐹵ⴊ。-≠\x{1160}", %p)},	undef,	"to_unicode\(\'ᡊ𐹵ⴊ\。\-\≠\\u1160\'\)\ throws\ error\ P1\ V3\ V6\ B5\ \[data\/IdnaTest\.txt\:4279\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐥳𐹶𝟒≯｡\x{200C}", %p)},	undef,	"to_unicode\(\'𐥳𐹶𝟒\≯｡\\u200C\'\)\ throws\ error\ P1\ V6\ B3\ B4\ C1\ \[data\/IdnaTest\.txt\:4280\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐥳𐹶𝟒≯｡\x{200C}", %p)},	undef,	"to_unicode\(\'𐥳𐹶𝟒\≯｡\\u200C\'\)\ throws\ error\ P1\ V6\ B3\ B4\ C1\ \[data\/IdnaTest\.txt\:4281\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐥳𐹶𝟒>\x{0338}｡\x{200C}", %p)},	undef,	"to_unicode\(\'𐥳𐹶𝟒\>\\u0338｡\\u200C\'\)\ throws\ error\ P1\ V6\ B3\ B4\ C1\ \[data\/IdnaTest\.txt\:4282\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐥳𐹶𝟒>\x{0338}｡\x{200C}", %p)},	undef,	"to_unicode\(\'𐥳𐹶𝟒\>\\u0338｡\\u200C\'\)\ throws\ error\ P1\ V6\ B3\ B4\ C1\ \[data\/IdnaTest\.txt\:4283\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐥳𐹶4≯。\x{200C}", %p)},	undef,	"to_unicode\(\'𐥳𐹶4\≯\。\\u200C\'\)\ throws\ error\ P1\ V6\ B3\ B4\ C1\ \[data\/IdnaTest\.txt\:4284\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐥳𐹶4≯。\x{200C}", %p)},	undef,	"to_unicode\(\'𐥳𐹶4\≯\。\\u200C\'\)\ throws\ error\ P1\ V6\ B3\ B4\ C1\ \[data\/IdnaTest\.txt\:4285\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐥳𐹶4>\x{0338}。\x{200C}", %p)},	undef,	"to_unicode\(\'𐥳𐹶4\>\\u0338\。\\u200C\'\)\ throws\ error\ P1\ V6\ B3\ B4\ C1\ \[data\/IdnaTest\.txt\:4286\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐥳𐹶4>\x{0338}。\x{200C}", %p)},	undef,	"to_unicode\(\'𐥳𐹶4\>\\u0338\。\\u200C\'\)\ throws\ error\ P1\ V6\ B3\ B4\ C1\ \[data\/IdnaTest\.txt\:4287\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟎。甯", %p)},	"0.甯",	"to_unicode\(\'𝟎\。甯\'\)\ \[data\/IdnaTest\.txt\:4288\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0。甯", %p)},	"0.甯",	"to_unicode\(\'0\。甯\'\)\ \[data\/IdnaTest\.txt\:4289\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0.xn--qny", %p)},	"0.甯",	"to_unicode\(\'0\.xn\-\-qny\'\)\ \[data\/IdnaTest\.txt\:4290\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0.甯", %p)},	"0.甯",	"to_unicode\(\'0\.甯\'\)\ \[data\/IdnaTest\.txt\:4291\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("-⾆．\x{A953}", %p)},	undef,	"to_unicode\(\'\-⾆．\\uA953\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:4292\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("-舌.\x{A953}", %p)},	undef,	"to_unicode\(\'\-舌\.\\uA953\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:4293\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-｡\x{06BB}", %p)},	undef,	"to_unicode\(\'\-｡\\u06BB\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:4294\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-。\x{06BB}", %p)},	undef,	"to_unicode\(\'\-\。\\u06BB\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:4295\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⧴Ⴋ.≮", %p)},	undef,	"to_unicode\(\'\⧴Ⴋ\.\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4296\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⧴Ⴋ.<\x{0338}", %p)},	undef,	"to_unicode\(\'\⧴Ⴋ\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4297\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⧴ⴋ.<\x{0338}", %p)},	undef,	"to_unicode\(\'\⧴ⴋ\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4298\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⧴ⴋ.≮", %p)},	undef,	"to_unicode\(\'\⧴ⴋ\.\≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4299\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("璼󠋇｡\x{200C}\x{0345}", %p)},	undef,	"to_unicode\(\'璼\󠋇｡\\u200C\\u0345\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4300\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("璼󠋇｡\x{200C}\x{0345}", %p)},	undef,	"to_unicode\(\'璼\󠋇｡\\u200C\\u0345\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4301\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("璼󠋇。\x{200C}\x{0345}", %p)},	undef,	"to_unicode\(\'璼\󠋇\。\\u200C\\u0345\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4302\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("璼󠋇。\x{200C}\x{0345}", %p)},	undef,	"to_unicode\(\'璼\󠋇\。\\u200C\\u0345\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4303\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("璼󠋇。\x{200C}Ι", %p)},	undef,	"to_unicode\(\'璼\󠋇\。\\u200CΙ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4304\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("璼󠋇。\x{200C}Ι", %p)},	undef,	"to_unicode\(\'璼\󠋇\。\\u200CΙ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4305\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("璼󠋇。\x{200C}ι", %p)},	undef,	"to_unicode\(\'璼\󠋇\。\\u200Cι\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4306\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("璼󠋇。\x{200C}ι", %p)},	undef,	"to_unicode\(\'璼\󠋇\。\\u200Cι\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4307\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("璼󠋇｡\x{200C}Ι", %p)},	undef,	"to_unicode\(\'璼\󠋇｡\\u200CΙ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4308\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("璼󠋇｡\x{200C}Ι", %p)},	undef,	"to_unicode\(\'璼\󠋇｡\\u200CΙ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4309\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("璼󠋇｡\x{200C}ι", %p)},	undef,	"to_unicode\(\'璼\󠋇｡\\u200Cι\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4310\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("璼󠋇｡\x{200C}ι", %p)},	undef,	"to_unicode\(\'璼\󠋇｡\\u200Cι\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4311\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹥8󶁡｡-5\x{030A}", %p)},	undef,	"to_unicode\(\'𐹥8󶁡｡\-5\\u030A\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:4312\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐹥8󶁡。-5\x{030A}", %p)},	undef,	"to_unicode\(\'𐹥8󶁡\。\-5\\u030A\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:4313\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200C\.\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:4314\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200C\.\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:4315\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{200D}튛.ꡐ", %p)},	undef,	"to_unicode\(\'\\u200D튛\.ꡐ\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4316\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{200D}튛.ꡐ", %p)},	undef,	"to_unicode\(\'\\u200D튛\.ꡐ\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4317\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{200D}튛.ꡐ", %p)},	undef,	"to_unicode\(\'\\u200D튛\.ꡐ\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4318\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{200D}튛.ꡐ", %p)},	undef,	"to_unicode\(\'\\u200D튛\.ꡐ\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4319\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("xn--157b.xn--pc9a", %p)},	"튛.ꡐ",	"to_unicode\(\'xn\-\-157b\.xn\-\-pc9a\'\)\ \[data\/IdnaTest\.txt\:4320\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("튛.ꡐ", %p)},	"튛.ꡐ",	"to_unicode\(\'튛\.ꡐ\'\)\ \[data\/IdnaTest\.txt\:4321\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("튛.ꡐ", %p)},	"튛.ꡐ",	"to_unicode\(\'튛\.ꡐ\'\)\ \[data\/IdnaTest\.txt\:4322\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ꡀ𐹥𞯍.ᡟⴞ", %p)},	undef,	"to_unicode\(\'ꡀ𐹥𞯍\.ᡟⴞ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4323\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡀ𐹥𞯍.ᡟႾ", %p)},	undef,	"to_unicode\(\'ꡀ𐹥𞯍\.ᡟႾ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4324\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞹰𐹦\x{2DE7}𝟧．\x{0662}\x{0663}Ⴇ", %p)},	undef,	"to_unicode\(\'𞹰𐹦\\u2DE7𝟧．\\u0662\\u0663Ⴇ\'\)\ throws\ error\ P1\ V6\ B4\ B1\ \[data\/IdnaTest\.txt\:4325\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0641}𐹦\x{2DE7}5.\x{0662}\x{0663}Ⴇ", %p)},	undef,	"to_unicode\(\'\\u0641𐹦\\u2DE75\.\\u0662\\u0663Ⴇ\'\)\ throws\ error\ P1\ V6\ B4\ B1\ \[data\/IdnaTest\.txt\:4326\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{0641}𐹦\x{2DE7}5.\x{0662}\x{0663}ⴇ", %p)},	undef,	"to_unicode\(\'\\u0641𐹦\\u2DE75\.\\u0662\\u0663ⴇ\'\)\ throws\ error\ B4\ B1\ \[data\/IdnaTest\.txt\:4327\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.1 (perl v5.15.8) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.1; is(eval{uts46_to_unicode("𞹰𐹦\x{2DE7}𝟧．\x{0662}\x{0663}ⴇ", %p)},	undef,	"to_unicode\(\'𞹰𐹦\\u2DE7𝟧．\\u0662\\u0663ⴇ\'\)\ throws\ error\ B4\ B1\ \[data\/IdnaTest\.txt\:4328\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴗ．𝨆\x{1BF3}\x{FEFF}󙢹", %p)},	undef,	"to_unicode\(\'Ⴗ．𝨆\\u1BF3\\uFEFF󙢹\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4329\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴗ.𝨆\x{1BF3}\x{FEFF}󙢹", %p)},	undef,	"to_unicode\(\'Ⴗ\.𝨆\\u1BF3\\uFEFF󙢹\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4330\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴗ.𝨆\x{1BF3}\x{FEFF}󙢹", %p)},	undef,	"to_unicode\(\'ⴗ\.𝨆\\u1BF3\\uFEFF󙢹\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4331\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴗ．𝨆\x{1BF3}\x{FEFF}󙢹", %p)},	undef,	"to_unicode\(\'ⴗ．𝨆\\u1BF3\\uFEFF󙢹\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4332\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟾򱚉．򱗯𐹮", %p)},	undef,	"to_unicode\(\'𝟾򱚉．򱗯𐹮\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4333\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("8򱚉.򱗯𐹮", %p)},	undef,	"to_unicode\(\'8򱚉\.򱗯𐹮\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4334\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈酫︒。𝨂", %p)},	undef,	"to_unicode\(\'⒈酫︒\。𝨂\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4335\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("1.酫。。𝨂", %p)},	undef,	"to_unicode\(\'1\.酫\。\。𝨂\'\)\ throws\ error\ V5\ A4_2\ \[data\/IdnaTest\.txt\:4336\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𝩑\x{200C}≮𝩆.\x{200C}𑄴", %p)},	undef,	"to_unicode\(\'𝩑\\u200C\≮𝩆\.\\u200C𑄴\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:4337\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝩑\x{200C}≮𝩆.\x{200C}𑄴", %p)},	undef,	"to_unicode\(\'𝩑\\u200C\≮𝩆\.\\u200C𑄴\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:4338\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝩑\x{200C}<\x{0338}𝩆.\x{200C}𑄴", %p)},	undef,	"to_unicode\(\'𝩑\\u200C\<\\u0338𝩆\.\\u200C𑄴\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:4339\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝩑\x{200C}<\x{0338}𝩆.\x{200C}𑄴", %p)},	undef,	"to_unicode\(\'𝩑\\u200C\<\\u0338𝩆\.\\u200C𑄴\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:4340\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞫀。ႷႽ¹\x{200D}", %p)},	undef,	"to_unicode\(\'𞫀\。ႷႽ¹\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4341\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞫀。ႷႽ¹\x{200D}", %p)},	undef,	"to_unicode\(\'𞫀\。ႷႽ¹\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4342\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞫀。ႷႽ1\x{200D}", %p)},	undef,	"to_unicode\(\'𞫀\。ႷႽ1\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4343\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞫀。ႷႽ1\x{200D}", %p)},	undef,	"to_unicode\(\'𞫀\。ႷႽ1\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4344\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞫀。ⴗⴝ1\x{200D}", %p)},	undef,	"to_unicode\(\'𞫀\。ⴗⴝ1\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4345\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞫀。ⴗⴝ1\x{200D}", %p)},	undef,	"to_unicode\(\'𞫀\。ⴗⴝ1\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4346\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞫀。Ⴗⴝ1\x{200D}", %p)},	undef,	"to_unicode\(\'𞫀\。Ⴗⴝ1\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4347\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞫀。Ⴗⴝ1\x{200D}", %p)},	undef,	"to_unicode\(\'𞫀\。Ⴗⴝ1\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4348\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞫀。ⴗⴝ¹\x{200D}", %p)},	undef,	"to_unicode\(\'𞫀\。ⴗⴝ¹\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4349\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞫀。ⴗⴝ¹\x{200D}", %p)},	undef,	"to_unicode\(\'𞫀\。ⴗⴝ¹\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4350\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞫀。Ⴗⴝ¹\x{200D}", %p)},	undef,	"to_unicode\(\'𞫀\。Ⴗⴝ¹\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4351\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞫀。Ⴗⴝ¹\x{200D}", %p)},	undef,	"to_unicode\(\'𞫀\。Ⴗⴝ¹\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4352\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{1734}\x{1BF2}2.𐩬󠆅-", %p)},	undef,	"to_unicode\(\'\\u1734\\u1BF22\.𐩬\󠆅\-\'\)\ throws\ error\ V5\ V3\ B3\ \[data\/IdnaTest\.txt\:4353\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("󠭮򔘮\x{0663}｡𼈛𑄳\x{07D1}ꡠ", %p)},	undef,	"to_unicode\(\'\󠭮򔘮\\u0663｡𼈛𑄳\\u07D1ꡠ\'\)\ throws\ error\ P1\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:4354\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠭮򔘮\x{0663}。𼈛𑄳\x{07D1}ꡠ", %p)},	undef,	"to_unicode\(\'\󠭮򔘮\\u0663\。𼈛𑄳\\u07D1ꡠ\'\)\ throws\ error\ P1\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:4355\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡷ񷗓\x{0660}\x{0A41}｡ςᠵ\x{0748}\x{200C}", %p)},	undef,	"to_unicode\(\'ᡷ񷗓\\u0660\\u0A41｡ςᠵ\\u0748\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4356\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡷ񷗓\x{0660}\x{0A41}｡ςᠵ\x{0748}\x{200C}", %p)},	undef,	"to_unicode\(\'ᡷ񷗓\\u0660\\u0A41｡ςᠵ\\u0748\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4357\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡷ񷗓\x{0660}\x{0A41}。ςᠵ\x{0748}\x{200C}", %p)},	undef,	"to_unicode\(\'ᡷ񷗓\\u0660\\u0A41\。ςᠵ\\u0748\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4358\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡷ񷗓\x{0660}\x{0A41}。ςᠵ\x{0748}\x{200C}", %p)},	undef,	"to_unicode\(\'ᡷ񷗓\\u0660\\u0A41\。ςᠵ\\u0748\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4359\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡷ񷗓\x{0660}\x{0A41}。Σᠵ\x{0748}\x{200C}", %p)},	undef,	"to_unicode\(\'ᡷ񷗓\\u0660\\u0A41\。Σᠵ\\u0748\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4360\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡷ񷗓\x{0660}\x{0A41}。Σᠵ\x{0748}\x{200C}", %p)},	undef,	"to_unicode\(\'ᡷ񷗓\\u0660\\u0A41\。Σᠵ\\u0748\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4361\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡷ񷗓\x{0660}\x{0A41}。σᠵ\x{0748}\x{200C}", %p)},	undef,	"to_unicode\(\'ᡷ񷗓\\u0660\\u0A41\。σᠵ\\u0748\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4362\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡷ񷗓\x{0660}\x{0A41}。σᠵ\x{0748}\x{200C}", %p)},	undef,	"to_unicode\(\'ᡷ񷗓\\u0660\\u0A41\。σᠵ\\u0748\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4363\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡷ񷗓\x{0660}\x{0A41}｡Σᠵ\x{0748}\x{200C}", %p)},	undef,	"to_unicode\(\'ᡷ񷗓\\u0660\\u0A41｡Σᠵ\\u0748\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4364\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡷ񷗓\x{0660}\x{0A41}｡Σᠵ\x{0748}\x{200C}", %p)},	undef,	"to_unicode\(\'ᡷ񷗓\\u0660\\u0A41｡Σᠵ\\u0748\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4365\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡷ񷗓\x{0660}\x{0A41}｡σᠵ\x{0748}\x{200C}", %p)},	undef,	"to_unicode\(\'ᡷ񷗓\\u0660\\u0A41｡σᠵ\\u0748\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4366\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡷ񷗓\x{0660}\x{0A41}｡σᠵ\x{0748}\x{200C}", %p)},	undef,	"to_unicode\(\'ᡷ񷗓\\u0660\\u0A41｡σᠵ\\u0748\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4367\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}--≮。𐹯", %p)},	undef,	"to_unicode\(\'\\u200D\-\-\≮\。𐹯\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:4368\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}--≮。𐹯", %p)},	undef,	"to_unicode\(\'\\u200D\-\-\≮\。𐹯\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:4369\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}--<\x{0338}。𐹯", %p)},	undef,	"to_unicode\(\'\\u200D\-\-\<\\u0338\。𐹯\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:4370\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}--<\x{0338}。𐹯", %p)},	undef,	"to_unicode\(\'\\u200D\-\-\<\\u0338\。𐹯\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:4371\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑓂。𶕹\x{FE2E}⒕", %p)},	undef,	"to_unicode\(\'𑓂\。𶕹\\uFE2E⒕\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4372\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑓂。𶕹\x{FE2E}14.", %p)},	undef,	"to_unicode\(\'𑓂\。𶕹\\uFE2E14\.\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4373\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򍑒\x{0765}．\x{1AB3}\x{0666}", %p)},	undef,	"to_unicode\(\'򍑒\\u0765．\\u1AB3\\u0666\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:4374\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򍑒\x{0765}.\x{1AB3}\x{0666}", %p)},	undef,	"to_unicode\(\'򍑒\\u0765\.\\u1AB3\\u0666\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:4375\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("󠅆𐮅-。ᢉ", %p)},	undef,	"to_unicode\(\'\󠅆𐮅\-\。ᢉ\'\)\ throws\ error\ V3\ B3\ \[data\/IdnaTest\.txt\:4376\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𝟠4󠅊⥄．\x{200D}𐋵\x{06E0}\x{200D}", %p)},	undef,	"to_unicode\(\'𝟠4\󠅊\⥄．\\u200D𐋵\\u06E0\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4377\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𝟠4󠅊⥄．\x{200D}𐋵\x{06E0}\x{200D}", %p)},	undef,	"to_unicode\(\'𝟠4\󠅊\⥄．\\u200D𐋵\\u06E0\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4378\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("84󠅊⥄.\x{200D}𐋵\x{06E0}\x{200D}", %p)},	undef,	"to_unicode\(\'84\󠅊\⥄\.\\u200D𐋵\\u06E0\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4379\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("84󠅊⥄.\x{200D}𐋵\x{06E0}\x{200D}", %p)},	undef,	"to_unicode\(\'84\󠅊\⥄\.\\u200D𐋵\\u06E0\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:4380\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("xn--84-utz.xn--wlb9710k", %p)},	"84⥄.𐋵\x{06E0}",	"to_unicode\(\'xn\-\-84\-utz\.xn\-\-wlb9710k\'\)\ \[data\/IdnaTest\.txt\:4381\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("84⥄.𐋵\x{06E0}", %p)},	"84⥄.𐋵\x{06E0}",	"to_unicode\(\'84\⥄\.𐋵\\u06E0\'\)\ \[data\/IdnaTest\.txt\:4382\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("-\x{0660}｡𐮁", %p)},	undef,	"to_unicode\(\'\-\\u0660｡𐮁\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:4383\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("-\x{0660}。𐮁", %p)},	undef,	"to_unicode\(\'\-\\u0660\。𐮁\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:4384\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("≮𝟕．謖ß≯", %p)},	undef,	"to_unicode\(\'\≮𝟕．謖ß\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4385\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}𝟕．謖ß>\x{0338}", %p)},	undef,	"to_unicode\(\'\<\\u0338𝟕．謖ß\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4386\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮7.謖ß≯", %p)},	undef,	"to_unicode\(\'\≮7\.謖ß\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4387\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}7.謖ß>\x{0338}", %p)},	undef,	"to_unicode\(\'\<\\u03387\.謖ß\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4388\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}7.謖SS>\x{0338}", %p)},	undef,	"to_unicode\(\'\<\\u03387\.謖SS\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4389\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮7.謖SS≯", %p)},	undef,	"to_unicode\(\'\≮7\.謖SS\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4390\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮7.謖ss≯", %p)},	undef,	"to_unicode\(\'\≮7\.謖ss\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4391\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}7.謖ss>\x{0338}", %p)},	undef,	"to_unicode\(\'\<\\u03387\.謖ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4392\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}7.謖Ss>\x{0338}", %p)},	undef,	"to_unicode\(\'\<\\u03387\.謖Ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4393\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮7.謖Ss≯", %p)},	undef,	"to_unicode\(\'\≮7\.謖Ss\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4394\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}𝟕．謖SS>\x{0338}", %p)},	undef,	"to_unicode\(\'\<\\u0338𝟕．謖SS\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4395\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮𝟕．謖SS≯", %p)},	undef,	"to_unicode\(\'\≮𝟕．謖SS\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4396\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮𝟕．謖ss≯", %p)},	undef,	"to_unicode\(\'\≮𝟕．謖ss\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4397\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}𝟕．謖ss>\x{0338}", %p)},	undef,	"to_unicode\(\'\<\\u0338𝟕．謖ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4398\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}𝟕．謖Ss>\x{0338}", %p)},	undef,	"to_unicode\(\'\<\\u0338𝟕．謖Ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4399\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮𝟕．謖Ss≯", %p)},	undef,	"to_unicode\(\'\≮𝟕．謖Ss\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4400\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("朶Ⴉ𐣶.\x{FE0F}\x{1BA2}🞚-", %p)},	undef,	"to_unicode\(\'朶Ⴉ𐣶\.\\uFE0F\\u1BA2🞚\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:4401\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("朶ⴉ𐣶.\x{FE0F}\x{1BA2}🞚-", %p)},	undef,	"to_unicode\(\'朶ⴉ𐣶\.\\uFE0F\\u1BA2🞚\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:4402\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞶐。󪅒\x{200C}≮\x{200D}", %p)},	undef,	"to_unicode\(\'𞶐\。󪅒\\u200C\≮\\u200D\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:4403\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞶐。󪅒\x{200C}≮\x{200D}", %p)},	undef,	"to_unicode\(\'𞶐\。󪅒\\u200C\≮\\u200D\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:4404\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞶐。󪅒\x{200C}<\x{0338}\x{200D}", %p)},	undef,	"to_unicode\(\'𞶐\。󪅒\\u200C\<\\u0338\\u200D\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:4405\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𞶐。󪅒\x{200C}<\x{0338}\x{200D}", %p)},	undef,	"to_unicode\(\'𞶐\。󪅒\\u200C\<\\u0338\\u200D\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:4406\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򨰆⒈｡\x{200C}𝟤", %p)},	undef,	"to_unicode\(\'򨰆⒈｡\\u200C𝟤\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4407\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򨰆⒈｡\x{200C}𝟤", %p)},	undef,	"to_unicode\(\'򨰆⒈｡\\u200C𝟤\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4408\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򨰆1.。\x{200C}2", %p)},	undef,	"to_unicode\(\'򨰆1\.\。\\u200C2\'\)\ throws\ error\ P1\ V6\ A4_2\ C1\ \[data\/IdnaTest\.txt\:4409\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򨰆1.。\x{200C}2", %p)},	undef,	"to_unicode\(\'򨰆1\.\。\\u200C2\'\)\ throws\ error\ P1\ V6\ A4_2\ C1\ \[data\/IdnaTest\.txt\:4410\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠚄\x{0661}\x{200D}．𐹦񭳐\x{0604}", %p)},	undef,	"to_unicode\(\'\󠚄\\u0661\\u200D．𐹦񭳐\\u0604\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4411\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠚄\x{0661}\x{200D}．𐹦񭳐\x{0604}", %p)},	undef,	"to_unicode\(\'\󠚄\\u0661\\u200D．𐹦񭳐\\u0604\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4412\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠚄\x{0661}\x{200D}.𐹦񭳐\x{0604}", %p)},	undef,	"to_unicode\(\'\󠚄\\u0661\\u200D\.𐹦񭳐\\u0604\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4413\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠚄\x{0661}\x{200D}.𐹦񭳐\x{0604}", %p)},	undef,	"to_unicode\(\'\󠚄\\u0661\\u200D\.𐹦񭳐\\u0604\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4414\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0760}\x{0662}\x{0A4D}𐪑．\x{094D}󠆠󨚹", %p)},	undef,	"to_unicode\(\'\\u0760\\u0662\\u0A4D𐪑．\\u094D\󠆠󨚹\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4415\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0760}\x{0662}\x{0A4D}𐪑.\x{094D}󠆠󨚹", %p)},	undef,	"to_unicode\(\'\\u0760\\u0662\\u0A4D𐪑\.\\u094D\󠆠󨚹\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4416\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0669}｡𐹥\x{0662}񔂚", %p)},	undef,	"to_unicode\(\'\\u0669｡𐹥\\u0662񔂚\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4417\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0669}。𐹥\x{0662}񔂚", %p)},	undef,	"to_unicode\(\'\\u0669\。𐹥\\u0662񔂚\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4418\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1160}󠊾.8󃜔\x{06FA}", %p)},	undef,	"to_unicode\(\'\\u1160\󠊾\.8󃜔\\u06FA\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4419\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{200D}\x{200C}\x{1C37}｡ß\x{A671}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\\u1C37｡ß\\uA671\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4420\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{200D}\x{200C}\x{1C37}｡ß\x{A671}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\\u1C37｡ß\\uA671\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4421\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{200D}\x{200C}\x{1C37}。ß\x{A671}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\\u1C37\。ß\\uA671\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4422\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{200D}\x{200C}\x{1C37}。ß\x{A671}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\\u1C37\。ß\\uA671\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4423\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{200D}\x{200C}\x{1C37}。SS\x{A671}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\\u1C37\。SS\\uA671\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4424\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{200D}\x{200C}\x{1C37}。SS\x{A671}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\\u1C37\。SS\\uA671\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4425\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{200D}\x{200C}\x{1C37}。ss\x{A671}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\\u1C37\。ss\\uA671\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4426\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{200D}\x{200C}\x{1C37}。ss\x{A671}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\\u1C37\。ss\\uA671\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4427\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{200D}\x{200C}\x{1C37}。Ss\x{A671}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\\u1C37\。Ss\\uA671\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4428\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{200D}\x{200C}\x{1C37}。Ss\x{A671}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\\u1C37\。Ss\\uA671\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4429\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{200D}\x{200C}\x{1C37}｡SS\x{A671}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\\u1C37｡SS\\uA671\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4430\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{200D}\x{200C}\x{1C37}｡SS\x{A671}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\\u1C37｡SS\\uA671\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4431\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{200D}\x{200C}\x{1C37}｡ss\x{A671}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\\u1C37｡ss\\uA671\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4432\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{200D}\x{200C}\x{1C37}｡ss\x{A671}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\\u1C37｡ss\\uA671\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4433\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{200D}\x{200C}\x{1C37}｡Ss\x{A671}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\\u1C37｡Ss\\uA671\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4434\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.1 (perl v5.10.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.1; is(eval{uts46_to_unicode("\x{200D}\x{200C}\x{1C37}｡Ss\x{A671}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\\u1C37｡Ss\\uA671\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:4435\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("︒\x{200C}ヶ䒩.\x{076A}", %p)},	undef,	"to_unicode\(\'︒\\u200Cヶ䒩\.\\u076A\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4436\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒\x{200C}ヶ䒩.\x{076A}", %p)},	undef,	"to_unicode\(\'︒\\u200Cヶ䒩\.\\u076A\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4437\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("。\x{200C}ヶ䒩.\x{076A}", %p)},	undef,	"to_unicode\(\'\。\\u200Cヶ䒩\.\\u076A\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:4438\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("。\x{200C}ヶ䒩.\x{076A}", %p)},	undef,	"to_unicode\(\'\。\\u200Cヶ䒩\.\\u076A\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:4439\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("xn--qekw60d.xn--upb", %p)},	"ヶ䒩.\x{076A}",	"to_unicode\(\'xn\-\-qekw60d\.xn\-\-upb\'\)\ \[data\/IdnaTest\.txt\:4440\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v4.1 (perl v5.8.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v4.1; is(eval{uts46_to_unicode("ヶ䒩.\x{076A}", %p)},	"ヶ䒩.\x{076A}",	"to_unicode\(\'ヶ䒩\.\\u076A\'\)\ \[data\/IdnaTest\.txt\:4441\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}⒈󣡃.񈸴\x{A9C0}", %p)},	undef,	"to_unicode\(\'\\u200C⒈󣡃\.񈸴\\uA9C0\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4442\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}⒈󣡃.񈸴\x{A9C0}", %p)},	undef,	"to_unicode\(\'\\u200C⒈󣡃\.񈸴\\uA9C0\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4443\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}1.󣡃.񈸴\x{A9C0}", %p)},	undef,	"to_unicode\(\'\\u200C1\.󣡃\.񈸴\\uA9C0\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4444\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}1.󣡃.񈸴\x{A9C0}", %p)},	undef,	"to_unicode\(\'\\u200C1\.󣡃\.񈸴\\uA9C0\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4445\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{200C}ᢍ🃑。\x{0CCD}򏔌\x{200D}", %p)},	undef,	"to_unicode\(\'⒈\\u200Cᢍ🃑\。\\u0CCD򏔌\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C1\ C2\ \[data\/IdnaTest\.txt\:4446\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{200C}ᢍ🃑。\x{0CCD}򏔌\x{200D}", %p)},	undef,	"to_unicode\(\'⒈\\u200Cᢍ🃑\。\\u0CCD򏔌\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C1\ C2\ \[data\/IdnaTest\.txt\:4447\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.\x{200C}ᢍ🃑。\x{0CCD}򏔌\x{200D}", %p)},	undef,	"to_unicode\(\'1\.\\u200Cᢍ🃑\。\\u0CCD򏔌\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:4448\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.\x{200C}ᢍ🃑。\x{0CCD}򏔌\x{200D}", %p)},	undef,	"to_unicode\(\'1\.\\u200Cᢍ🃑\。\\u0CCD򏔌\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:4449\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{035E}｡𝟫\x{1B72}䬺⒈", %p)},	undef,	"to_unicode\(\'\\u035E｡𝟫\\u1B72䬺⒈\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4450\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{035E}。9\x{1B72}䬺1.", %p)},	undef,	"to_unicode\(\'\\u035E\。9\\u1B72䬺1\.\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4451\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𲈷≯。盚ꡨ", %p)},	undef,	"to_unicode\(\'𲈷\≯\。盚ꡨ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4452\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𲈷>\x{0338}。盚ꡨ", %p)},	undef,	"to_unicode\(\'𲈷\>\\u0338\。盚ꡨ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4453\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-񃟯󠄯。-𑚲𐫳≯", %p)},	undef,	"to_unicode\(\'\-񃟯\󠄯\。\-𑚲𐫳\≯\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4454\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-񃟯󠄯。-𑚲𐫳>\x{0338}", %p)},	undef,	"to_unicode\(\'\-񃟯\󠄯\。\-𑚲𐫳\>\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4455\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󲓝\x{1BF3}\x{200C}\x{09CD}．\x{FD59}񄳨", %p)},	undef,	"to_unicode\(\'󲓝\\u1BF3\\u200C\\u09CD．\\uFD59񄳨\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4456\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󲓝\x{1BF3}\x{200C}\x{09CD}.\x{062C}\x{0645}\x{062D}񄳨", %p)},	undef,	"to_unicode\(\'󲓝\\u1BF3\\u200C\\u09CD\.\\u062C\\u0645\\u062D񄳨\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4457\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("⾇.𐫍ᢊᢐ\x{200D}", %p)},	undef,	"to_unicode\(\'⾇\.𐫍ᢊᢐ\\u200D\'\)\ throws\ error\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4458\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("⾇.𐫍ᢊᢐ\x{200D}", %p)},	undef,	"to_unicode\(\'⾇\.𐫍ᢊᢐ\\u200D\'\)\ throws\ error\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4459\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("舛.𐫍ᢊᢐ\x{200D}", %p)},	undef,	"to_unicode\(\'舛\.𐫍ᢊᢐ\\u200D\'\)\ throws\ error\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4460\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("舛.𐫍ᢊᢐ\x{200D}", %p)},	undef,	"to_unicode\(\'舛\.𐫍ᢊᢐ\\u200D\'\)\ throws\ error\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:4461\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("4񠡉。ᡔ≯", %p)},	undef,	"to_unicode\(\'4񠡉\。ᡔ\≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4462\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4񠡉。ᡔ>\x{0338}", %p)},	undef,	"to_unicode\(\'4񠡉\。ᡔ\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4463\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󕔢\x{0625}򃁪硲．\x{0688}", %p)},	undef,	"to_unicode\(\'󕔢\\u0625򃁪硲．\\u0688\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4464\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󕔢\x{0627}\x{0655}򃁪硲．\x{0688}", %p)},	undef,	"to_unicode\(\'󕔢\\u0627\\u0655򃁪硲．\\u0688\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4465\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󕔢\x{0625}򃁪硲.\x{0688}", %p)},	undef,	"to_unicode\(\'󕔢\\u0625򃁪硲\.\\u0688\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4466\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󕔢\x{0627}\x{0655}򃁪硲.\x{0688}", %p)},	undef,	"to_unicode\(\'󕔢\\u0627\\u0655򃁪硲\.\\u0688\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4467\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.\x{1A78}𐹴Ⴆ\x{032C}", %p)},	undef,	"to_unicode\(\'\\u200C\.\\u1A78𐹴Ⴆ\\u032C\'\)\ throws\ error\ P1\ V5\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:4468\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.\x{1A78}𐹴Ⴆ\x{032C}", %p)},	undef,	"to_unicode\(\'\\u200C\.\\u1A78𐹴Ⴆ\\u032C\'\)\ throws\ error\ P1\ V5\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:4469\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}.\x{1A78}𐹴ⴆ\x{032C}", %p)},	undef,	"to_unicode\(\'\\u200C\.\\u1A78𐹴ⴆ\\u032C\'\)\ throws\ error\ V5\ C1\ B1\ \[data\/IdnaTest\.txt\:4470\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.2 (perl v5.11.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.2; is(eval{uts46_to_unicode("\x{200C}.\x{1A78}𐹴ⴆ\x{032C}", %p)},	undef,	"to_unicode\(\'\\u200C\.\\u1A78𐹴ⴆ\\u032C\'\)\ throws\ error\ V5\ C1\ B1\ \[data\/IdnaTest\.txt\:4471\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐫁．\x{0C4D}\x{200D}Ϟ", %p)},	undef,	"to_unicode\(\'𐫁．\\u0C4D\\u200DϞ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4472\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐫁.\x{0C4D}\x{200D}Ϟ", %p)},	undef,	"to_unicode\(\'𐫁\.\\u0C4D\\u200DϞ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4473\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐫁.\x{0C4D}\x{200D}ϟ", %p)},	undef,	"to_unicode\(\'𐫁\.\\u0C4D\\u200Dϟ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4474\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𐫁．\x{0C4D}\x{200D}ϟ", %p)},	undef,	"to_unicode\(\'𐫁．\\u0C4D\\u200Dϟ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4475\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{200C}\x{FD8E}𑁆。\x{0724}ꡜ-腍", %p)},	undef,	"to_unicode\(\'\\u200C\\uFD8E𑁆\。\\u0724ꡜ\-腍\'\)\ throws\ error\ B1\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:4476\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{200C}\x{FD8E}𑁆。\x{0724}ꡜ-腍", %p)},	undef,	"to_unicode\(\'\\u200C\\uFD8E𑁆\。\\u0724ꡜ\-腍\'\)\ throws\ error\ B1\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:4477\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{200C}\x{0645}\x{062E}\x{062C}𑁆。\x{0724}ꡜ-腍", %p)},	undef,	"to_unicode\(\'\\u200C\\u0645\\u062E\\u062C𑁆\。\\u0724ꡜ\-腍\'\)\ throws\ error\ B1\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:4478\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{200C}\x{0645}\x{062E}\x{062C}𑁆。\x{0724}ꡜ-腍", %p)},	undef,	"to_unicode\(\'\\u200C\\u0645\\u062E\\u062C𑁆\。\\u0724ꡜ\-腍\'\)\ throws\ error\ B1\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:4479\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-򤨓𐹮󰫾｡𝟛񔡰🄅", %p)},	undef,	"to_unicode\(\'\-򤨓𐹮󰫾｡𝟛񔡰🄅\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4480\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-򤨓𐹮󰫾。3񔡰4,", %p)},	undef,	"to_unicode\(\'\-򤨓𐹮󰫾\。3񔡰4\,\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4481\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⌮．Ⴂ\x{07D2}𑁆𐋮", %p)},	undef,	"to_unicode\(\'\⌮．Ⴂ\\u07D2𑁆𐋮\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4482\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⌮.Ⴂ\x{07D2}𑁆𐋮", %p)},	undef,	"to_unicode\(\'\⌮\.Ⴂ\\u07D2𑁆𐋮\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:4483\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("⌮.ⴂ\x{07D2}𑁆𐋮", %p)},	undef,	"to_unicode\(\'\⌮\.ⴂ\\u07D2𑁆𐋮\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:4484\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("⌮．ⴂ\x{07D2}𑁆𐋮", %p)},	undef,	"to_unicode\(\'\⌮．ⴂ\\u07D2𑁆𐋮\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:4485\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("軥𐫬.-\x{0AC4}", %p)},	undef,	"to_unicode\(\'軥𐫬\.\-\\u0AC4\'\)\ throws\ error\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:4486\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0602}ᡈ\x{06B6}.󠅕-", %p)},	undef,	"to_unicode\(\'\\u0602ᡈ\\u06B6\.\󠅕\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:4487\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("-𝨉0｡\x{2DE5}\x{1939}톇십", %p)},	undef,	"to_unicode\(\'\-𝨉0｡\\u2DE5\\u1939톇십\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:4488\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("-𝨉0｡\x{1939}\x{2DE5}톇십", %p)},	undef,	"to_unicode\(\'\-𝨉0｡\\u1939\\u2DE5톇십\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:4489\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("-𝨉0｡\x{1939}\x{2DE5}톇십", %p)},	undef,	"to_unicode\(\'\-𝨉0｡\\u1939\\u2DE5톇십\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:4490\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("-𝨉0。\x{1939}\x{2DE5}톇십", %p)},	undef,	"to_unicode\(\'\-𝨉0\。\\u1939\\u2DE5톇십\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:4491\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("-𝨉0。\x{1939}\x{2DE5}톇십", %p)},	undef,	"to_unicode\(\'\-𝨉0\。\\u1939\\u2DE5톇십\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:4492\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ᢖ︒--｡󠅥靈\x{0604}𖪥", %p)},	undef,	"to_unicode\(\'ᢖ︒\-\-｡\󠅥靈\\u0604𖪥\'\)\ throws\ error\ P1\ V2\ V3\ V6\ B5\ \[data\/IdnaTest\.txt\:4493\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢖ。--。󠅥靈\x{0604}𖪥", %p)},	undef,	"to_unicode\(\'ᢖ\。\-\-\。\󠅥靈\\u0604𖪥\'\)\ throws\ error\ P1\ V3\ V6\ B5\ \[data\/IdnaTest\.txt\:4494\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115F}ႿႵრ｡\x{0F84}", %p)},	undef,	"to_unicode\(\'\\u115FႿႵრ｡\\u0F84\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4495\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115F}ႿႵრ。\x{0F84}", %p)},	undef,	"to_unicode\(\'\\u115FႿႵრ\。\\u0F84\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4496\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115F}ⴟⴕრ。\x{0F84}", %p)},	undef,	"to_unicode\(\'\\u115Fⴟⴕრ\。\\u0F84\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4497\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115F}Ⴟⴕრ。\x{0F84}", %p)},	undef,	"to_unicode\(\'\\u115FႿⴕრ\。\\u0F84\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4498\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115F}ⴟⴕრ｡\x{0F84}", %p)},	undef,	"to_unicode\(\'\\u115Fⴟⴕრ｡\\u0F84\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4499\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{115F}Ⴟⴕრ｡\x{0F84}", %p)},	undef,	"to_unicode\(\'\\u115FႿⴕრ｡\\u0F84\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:4500\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄃𐹣.𐹦\x{0AE2}", %p)},	undef,	"to_unicode\(\'🄃𐹣\.𐹦\\u0AE2\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4501\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2,𐹣.𐹦\x{0AE2}", %p)},	undef,	"to_unicode\(\'2\,𐹣\.𐹦\\u0AE2\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4502\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑴤\x{200C}𞶿．\x{069F}ꡃ𑋪", %p)},	undef,	"to_unicode\(\'𑴤\\u200C𞶿．\\u069Fꡃ𑋪\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:4503\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑴤\x{200C}𞶿．\x{069F}ꡃ𑋪", %p)},	undef,	"to_unicode\(\'𑴤\\u200C𞶿．\\u069Fꡃ𑋪\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:4504\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑴤\x{200C}𞶿.\x{069F}ꡃ𑋪", %p)},	undef,	"to_unicode\(\'𑴤\\u200C𞶿\.\\u069Fꡃ𑋪\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:4505\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑴤\x{200C}𞶿.\x{069F}ꡃ𑋪", %p)},	undef,	"to_unicode\(\'𑴤\\u200C𞶿\.\\u069Fꡃ𑋪\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:4506\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{200D}𐿵\x{200C}。\x{06CD}\x{0A3C}\x{17B5}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200D𐿵\\u200C\。\\u06CD\\u0A3C\\u17B5\'\)\ throws\ error\ P1\ V6\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:4507\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{200D}𐿵\x{200C}。\x{06CD}\x{0A3C}\x{17B5}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200D𐿵\\u200C\。\\u06CD\\u0A3C\\u17B5\'\)\ throws\ error\ P1\ V6\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:4508\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐢒。󠋴𓟷\x{0BCD}", %p)},	undef,	"to_unicode\(\'𐢒\。\󠋴𓟷\\u0BCD\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4509\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B4D}≠．𞷺𐹶", %p)},	undef,	"to_unicode\(\'\\u0B4D\≠．𞷺𐹶\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4510\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B4D}=\x{0338}．𞷺𐹶", %p)},	undef,	"to_unicode\(\'\\u0B4D\=\\u0338．𞷺𐹶\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4511\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B4D}≠.𞷺𐹶", %p)},	undef,	"to_unicode\(\'\\u0B4D\≠\.𞷺𐹶\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4512\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B4D}=\x{0338}.𞷺𐹶", %p)},	undef,	"to_unicode\(\'\\u0B4D\=\\u0338\.𞷺𐹶\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:4513\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟛\x{0F87}\x{1714}｡\x{0B82}-", %p)},	undef,	"to_unicode\(\'𝟛\\u0F87\\u1714｡\\u0B82\-\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:4514\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟛\x{1714}\x{0F87}｡\x{0B82}-", %p)},	undef,	"to_unicode\(\'𝟛\\u1714\\u0F87｡\\u0B82\-\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:4515\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("3\x{1714}\x{0F87}。\x{0B82}-", %p)},	undef,	"to_unicode\(\'3\\u1714\\u0F87\。\\u0B82\-\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:4516\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠫ𝪦𑍍Ⴇ.4", %p)},	undef,	"to_unicode\(\'ᠫ𝪦𑍍Ⴇ\.4\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4517\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("ᠫ𝪦𑍍ⴇ.4", %p)},	"ᠫ𝪦𑍍ⴇ.4",	"to_unicode\(\'ᠫ𝪦𑍍ⴇ\.4\'\)\ \[data\/IdnaTest\.txt\:4518\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.024000, which is too old"; is(eval{uts46_to_unicode("xn--e7e497h3m2olwqg.4", %p)},	"ᠫ𝪦𑍍ⴇ.4",	"to_unicode\(\'xn\-\-e7e497h3m2olwqg\.4\'\)\ \[data\/IdnaTest\.txt\:4519\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ᄹ｡󠇣󖮆‴", %p)},	undef,	"to_unicode\(\'ᄹ｡\󠇣󖮆\‴\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4520\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᄹ。󠇣󖮆′′′", %p)},	undef,	"to_unicode\(\'ᄹ\。\󠇣󖮆\′\′\′\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4521\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴆ򏌭．\x{302C}\x{2DF2}\x{068D}", %p)},	undef,	"to_unicode\(\'Ⴆ򏌭．\\u302C\\u2DF2\\u068D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:4522\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴆ򏌭．\x{2DF2}\x{302C}\x{068D}", %p)},	undef,	"to_unicode\(\'Ⴆ򏌭．\\u2DF2\\u302C\\u068D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:4523\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴆ򏌭.\x{2DF2}\x{302C}\x{068D}", %p)},	undef,	"to_unicode\(\'Ⴆ򏌭\.\\u2DF2\\u302C\\u068D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:4524\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴆ򏌭.\x{2DF2}\x{302C}\x{068D}", %p)},	undef,	"to_unicode\(\'ⴆ򏌭\.\\u2DF2\\u302C\\u068D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:4525\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴆ򏌭．\x{2DF2}\x{302C}\x{068D}", %p)},	undef,	"to_unicode\(\'ⴆ򏌭．\\u2DF2\\u302C\\u068D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:4526\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴆ򏌭．\x{302C}\x{2DF2}\x{068D}", %p)},	undef,	"to_unicode\(\'ⴆ򏌭．\\u302C\\u2DF2\\u068D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:4527\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß𐥙︒𐫃．帼F🠖\x{200C}", %p)},	undef,	"to_unicode\(\'ß𐥙︒𐫃．帼F🠖\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4528\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß𐥙︒𐫃．帼F🠖\x{200C}", %p)},	undef,	"to_unicode\(\'ß𐥙︒𐫃．帼F🠖\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4529\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß𐥙。𐫃.帼F🠖\x{200C}", %p)},	undef,	"to_unicode\(\'ß𐥙\。𐫃\.帼F🠖\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4530\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß𐥙。𐫃.帼F🠖\x{200C}", %p)},	undef,	"to_unicode\(\'ß𐥙\。𐫃\.帼F🠖\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4531\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß𐥙。𐫃.帼f🠖\x{200C}", %p)},	undef,	"to_unicode\(\'ß𐥙\。𐫃\.帼f🠖\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4532\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß𐥙。𐫃.帼f🠖\x{200C}", %p)},	undef,	"to_unicode\(\'ß𐥙\。𐫃\.帼f🠖\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4533\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS𐥙。𐫃.帼F🠖\x{200C}", %p)},	undef,	"to_unicode\(\'SS𐥙\。𐫃\.帼F🠖\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4534\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS𐥙。𐫃.帼F🠖\x{200C}", %p)},	undef,	"to_unicode\(\'SS𐥙\。𐫃\.帼F🠖\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4535\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss𐥙。𐫃.帼f🠖\x{200C}", %p)},	undef,	"to_unicode\(\'ss𐥙\。𐫃\.帼f🠖\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4536\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss𐥙。𐫃.帼f🠖\x{200C}", %p)},	undef,	"to_unicode\(\'ss𐥙\。𐫃\.帼f🠖\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4537\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss𐥙。𐫃.帼F🠖\x{200C}", %p)},	undef,	"to_unicode\(\'Ss𐥙\。𐫃\.帼F🠖\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4538\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss𐥙。𐫃.帼F🠖\x{200C}", %p)},	undef,	"to_unicode\(\'Ss𐥙\。𐫃\.帼F🠖\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4539\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß𐥙︒𐫃．帼f🠖\x{200C}", %p)},	undef,	"to_unicode\(\'ß𐥙︒𐫃．帼f🠖\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4540\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß𐥙︒𐫃．帼f🠖\x{200C}", %p)},	undef,	"to_unicode\(\'ß𐥙︒𐫃．帼f🠖\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4541\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS𐥙︒𐫃．帼F🠖\x{200C}", %p)},	undef,	"to_unicode\(\'SS𐥙︒𐫃．帼F🠖\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4542\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS𐥙︒𐫃．帼F🠖\x{200C}", %p)},	undef,	"to_unicode\(\'SS𐥙︒𐫃．帼F🠖\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4543\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss𐥙︒𐫃．帼f🠖\x{200C}", %p)},	undef,	"to_unicode\(\'ss𐥙︒𐫃．帼f🠖\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4544\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss𐥙︒𐫃．帼f🠖\x{200C}", %p)},	undef,	"to_unicode\(\'ss𐥙︒𐫃．帼f🠖\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4545\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss𐥙︒𐫃．帼F🠖\x{200C}", %p)},	undef,	"to_unicode\(\'Ss𐥙︒𐫃．帼F🠖\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4546\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss𐥙︒𐫃．帼F🠖\x{200C}", %p)},	undef,	"to_unicode\(\'Ss𐥙︒𐫃．帼F🠖\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:4547\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򽌣｡𐹾\x{06A6}\x{200D}", %p)},	undef,	"to_unicode\(\'򽌣｡𐹾\\u06A6\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4548\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򽌣｡𐹾\x{06A6}\x{200D}", %p)},	undef,	"to_unicode\(\'򽌣｡𐹾\\u06A6\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4549\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򽌣。𐹾\x{06A6}\x{200D}", %p)},	undef,	"to_unicode\(\'򽌣\。𐹾\\u06A6\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4550\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("򽌣。𐹾\x{06A6}\x{200D}", %p)},	undef,	"to_unicode\(\'򽌣\。𐹾\\u06A6\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4551\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🡉.񾕀𝟨𐨿", %p)},	undef,	"to_unicode\(\'🡉\.񾕀𝟨𐨿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4552\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🡉.񾕀6𐨿", %p)},	undef,	"to_unicode\(\'🡉\.񾕀6𐨿\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4553\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0350}𐸌。-۹ႱႨ", %p)},	undef,	"to_unicode\(\'\\u0350𐸌\。\-۹ႱႨ\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:4554\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0350}𐸌。-۹ⴑⴈ", %p)},	undef,	"to_unicode\(\'\\u0350𐸌\。\-۹ⴑⴈ\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:4555\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0350}𐸌。-۹Ⴑⴈ", %p)},	undef,	"to_unicode\(\'\\u0350𐸌\。\-۹Ⴑⴈ\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:4556\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07CE}．-ᢏ︒", %p)},	undef,	"to_unicode\(\'\\u07CE．\-ᢏ︒\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4557\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{07CE}.-ᢏ。", %p)},	undef,	"to_unicode\(\'\\u07CE\.\-ᢏ\。\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:4558\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200C}𐪙.󠆺--", %p)},	undef,	"to_unicode\(\'\\u200C𐪙\.\󠆺\-\-\'\)\ throws\ error\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:4559\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("\x{200C}𐪙.󠆺--", %p)},	undef,	"to_unicode\(\'\\u200C𐪙\.\󠆺\-\-\'\)\ throws\ error\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:4560\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𐋸󃄒Ⴢ.Ⴁ", %p)},	undef,	"to_unicode\(\'𐋸󃄒Ⴢ\.Ⴁ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4561\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋸󃄒ⴢ.ⴁ", %p)},	undef,	"to_unicode\(\'𐋸󃄒ⴢ\.ⴁ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4562\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐋸󃄒Ⴢ.ⴁ", %p)},	undef,	"to_unicode\(\'𐋸󃄒Ⴢ\.ⴁ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4563\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("􉿵𑁆₄򣚆｡󾎹🐶ς", %p)},	undef,	"to_unicode\(\'􉿵𑁆₄򣚆｡󾎹🐶ς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4564\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("􉿵𑁆4򣚆。󾎹🐶ς", %p)},	undef,	"to_unicode\(\'􉿵𑁆4򣚆\。󾎹🐶ς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4565\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("􉿵𑁆4򣚆。󾎹🐶Σ", %p)},	undef,	"to_unicode\(\'􉿵𑁆4򣚆\。󾎹🐶Σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4566\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("􉿵𑁆4򣚆。󾎹🐶σ", %p)},	undef,	"to_unicode\(\'􉿵𑁆4򣚆\。󾎹🐶σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4567\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("􉿵𑁆₄򣚆｡󾎹🐶Σ", %p)},	undef,	"to_unicode\(\'􉿵𑁆₄򣚆｡󾎹🐶Σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4568\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("􉿵𑁆₄򣚆｡󾎹🐶σ", %p)},	undef,	"to_unicode\(\'􉿵𑁆₄򣚆｡󾎹🐶σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4569\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{0E39}\x{07CC}。\x{1037}ꡓ", %p)},	undef,	"to_unicode\(\'\\u0E39\\u07CC\。\\u1037ꡓ\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:4570\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0603}\x{062B}𑂁｡󦳹Ⴑ\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0603\\u062B𑂁｡󦳹Ⴑ\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4571\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0603}\x{062B}𑂁｡󦳹Ⴑ\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0603\\u062B𑂁｡󦳹Ⴑ\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4572\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0603}\x{062B}𑂁。󦳹Ⴑ\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0603\\u062B𑂁\。󦳹Ⴑ\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4573\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0603}\x{062B}𑂁。󦳹Ⴑ\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0603\\u062B𑂁\。󦳹Ⴑ\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4574\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0603}\x{062B}𑂁。󦳹ⴑ\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0603\\u062B𑂁\。󦳹ⴑ\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4575\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0603}\x{062B}𑂁。󦳹ⴑ\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0603\\u062B𑂁\。󦳹ⴑ\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4576\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0603}\x{062B}𑂁｡󦳹ⴑ\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0603\\u062B𑂁｡󦳹ⴑ\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4577\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0603}\x{062B}𑂁｡󦳹ⴑ\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0603\\u062B𑂁｡󦳹ⴑ\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4578\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{0ACD}\x{FC5A}𑀾\x{200D}｡-𐹥", %p)},	undef,	"to_unicode\(\'\\u0ACD\\uFC5A𑀾\\u200D｡\-𐹥\'\)\ throws\ error\ V5\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:4579\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{0ACD}\x{FC5A}𑀾\x{200D}｡-𐹥", %p)},	undef,	"to_unicode\(\'\\u0ACD\\uFC5A𑀾\\u200D｡\-𐹥\'\)\ throws\ error\ V5\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:4580\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{0ACD}\x{064A}\x{064A}𑀾\x{200D}。-𐹥", %p)},	undef,	"to_unicode\(\'\\u0ACD\\u064A\\u064A𑀾\\u200D\。\-𐹥\'\)\ throws\ error\ V5\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:4581\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v6.0 (perl v5.13.7) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v6.0; is(eval{uts46_to_unicode("\x{0ACD}\x{064A}\x{064A}𑀾\x{200D}。-𐹥", %p)},	undef,	"to_unicode\(\'\\u0ACD\\u064A\\u064A𑀾\\u200D\。\-𐹥\'\)\ throws\ error\ V5\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:4582\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("񆥔｡\x{0855}︒쯙𝟧", %p)},	undef,	"to_unicode\(\'񆥔｡\\u0855︒쯙𝟧\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:4583\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񆥔｡\x{0855}︒쯙𝟧", %p)},	undef,	"to_unicode\(\'񆥔｡\\u0855︒쯙𝟧\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:4584\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񆥔。\x{0855}。쯙5", %p)},	undef,	"to_unicode\(\'񆥔\。\\u0855\。쯙5\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4585\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("񆥔。\x{0855}。쯙5", %p)},	undef,	"to_unicode\(\'񆥔\。\\u0855\。쯙5\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:4586\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡮ-。ᡴ≮뻐", %p)},	undef,	"to_unicode\(\'ꡮ\-\。ᡴ\≮뻐\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4587\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡮ-。ᡴ<\x{0338}뻐", %p)},	undef,	"to_unicode\(\'ꡮ\-\。ᡴ\<\\u0338뻐\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:4588\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐱙-񈞻．\x{07E1}≠", %p)},	undef,	"to_unicode\(\'𐱙\-񈞻．\\u07E1\≠\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4589\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐱙-񈞻．\x{07E1}=\x{0338}", %p)},	undef,	"to_unicode\(\'𐱙\-񈞻．\\u07E1\=\\u0338\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4590\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐱙-񈞻.\x{07E1}≠", %p)},	undef,	"to_unicode\(\'𐱙\-񈞻\.\\u07E1\≠\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4591\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𐱙-񈞻.\x{07E1}=\x{0338}", %p)},	undef,	"to_unicode\(\'𐱙\-񈞻\.\\u07E1\=\\u0338\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:4592\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-񄚵ςႼ．𐹢", %p)},	undef,	"to_unicode\(\'\-񄚵ςႼ．𐹢\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4593\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-񄚵ςႼ.𐹢", %p)},	undef,	"to_unicode\(\'\-񄚵ςႼ\.𐹢\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4594\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-񄚵ςⴜ.𐹢", %p)},	undef,	"to_unicode\(\'\-񄚵ςⴜ\.𐹢\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4595\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-񄚵ΣႼ.𐹢", %p)},	undef,	"to_unicode\(\'\-񄚵ΣႼ\.𐹢\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4596\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-񄚵σⴜ.𐹢", %p)},	undef,	"to_unicode\(\'\-񄚵σⴜ\.𐹢\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4597\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-񄚵Σⴜ.𐹢", %p)},	undef,	"to_unicode\(\'\-񄚵Σⴜ\.𐹢\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4598\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-񄚵ςⴜ．𐹢", %p)},	undef,	"to_unicode\(\'\-񄚵ςⴜ．𐹢\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4599\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-񄚵ΣႼ．𐹢", %p)},	undef,	"to_unicode\(\'\-񄚵ΣႼ．𐹢\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4600\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-񄚵σⴜ．𐹢", %p)},	undef,	"to_unicode\(\'\-񄚵σⴜ．𐹢\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4601\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-񄚵Σⴜ．𐹢", %p)},	undef,	"to_unicode\(\'\-񄚵Σⴜ．𐹢\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4602\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠠍.\x{200D}𝟮\x{0F86}", %p)},	undef,	"to_unicode\(\'\󠠍\.\\u200D𝟮\\u0F86\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4603\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠠍.\x{200D}𝟮\x{0F86}", %p)},	undef,	"to_unicode\(\'\󠠍\.\\u200D𝟮\\u0F86\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4604\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠠍.\x{200D}2\x{0F86}", %p)},	undef,	"to_unicode\(\'\󠠍\.\\u200D2\\u0F86\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4605\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠠍.\x{200D}2\x{0F86}", %p)},	undef,	"to_unicode\(\'\󠠍\.\\u200D2\\u0F86\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4606\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯𝟖｡\x{0D4D}𐮊򔦳", %p)},	undef,	"to_unicode\(\'\≯𝟖｡\\u0D4D𐮊򔦳\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:4607\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}𝟖｡\x{0D4D}𐮊򔦳", %p)},	undef,	"to_unicode\(\'\>\\u0338𝟖｡\\u0D4D𐮊򔦳\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:4608\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯8。\x{0D4D}𐮊򔦳", %p)},	undef,	"to_unicode\(\'\≯8\。\\u0D4D𐮊򔦳\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:4609\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}8。\x{0D4D}𐮊򔦳", %p)},	undef,	"to_unicode\(\'\>\\u03388\。\\u0D4D𐮊򔦳\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:4610\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05C2}Ↄ\x{0664}｡\x{200C}", %p)},	undef,	"to_unicode\(\'\\u05C2Ↄ\\u0664｡\\u200C\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:4611\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05C2}Ↄ\x{0664}｡\x{200C}", %p)},	undef,	"to_unicode\(\'\\u05C2Ↄ\\u0664｡\\u200C\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:4612\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05C2}Ↄ\x{0664}。\x{200C}", %p)},	undef,	"to_unicode\(\'\\u05C2Ↄ\\u0664\。\\u200C\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:4613\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05C2}Ↄ\x{0664}。\x{200C}", %p)},	undef,	"to_unicode\(\'\\u05C2Ↄ\\u0664\。\\u200C\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:4614\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{05C2}ↄ\x{0664}。\x{200C}", %p)},	undef,	"to_unicode\(\'\\u05C2ↄ\\u0664\。\\u200C\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:4615\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{05C2}ↄ\x{0664}。\x{200C}", %p)},	undef,	"to_unicode\(\'\\u05C2ↄ\\u0664\。\\u200C\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:4616\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{05C2}ↄ\x{0664}｡\x{200C}", %p)},	undef,	"to_unicode\(\'\\u05C2ↄ\\u0664｡\\u200C\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:4617\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v5.0 (perl v5.9.5) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v5.0; is(eval{uts46_to_unicode("\x{05C2}ↄ\x{0664}｡\x{200C}", %p)},	undef,	"to_unicode\(\'\\u05C2ↄ\\u0664｡\\u200C\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:4618\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0962}𝟵\x{200D}𞺻.\x{200D}\x{06AA}⒈", %p)},	undef,	"to_unicode\(\'\\u0962𝟵\\u200D𞺻\.\\u200D\\u06AA⒈\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4619\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0962}𝟵\x{200D}𞺻.\x{200D}\x{06AA}⒈", %p)},	undef,	"to_unicode\(\'\\u0962𝟵\\u200D𞺻\.\\u200D\\u06AA⒈\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:4620\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0962}9\x{200D}\x{063A}.\x{200D}\x{06AA}1.", %p)},	undef,	"to_unicode\(\'\\u09629\\u200D\\u063A\.\\u200D\\u06AA1\.\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:4621\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0962}9\x{200D}\x{063A}.\x{200D}\x{06AA}1.", %p)},	undef,	"to_unicode\(\'\\u09629\\u200D\\u063A\.\\u200D\\u06AA1\.\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:4622\]") or ($@ and diag($@));
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𑖿。嬶ß葽", %p)},	undef,	"to_unicode\(\'𑖿\。嬶ß葽\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4623\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𑖿。嬶SS葽", %p)},	undef,	"to_unicode\(\'𑖿\。嬶SS葽\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4624\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𑖿。嬶ss葽", %p)},	undef,	"to_unicode\(\'𑖿\。嬶ss葽\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4625\]") or ($@ and diag($@)); }
SKIP: { skip sprintf("requires Unicode® v7.0 (perl v5.21.1) or higher, only v%vd is supported (perl v%vd)", $UCD_VERSION, $^V), 1 if $UCD_VERSION lt v7.0; is(eval{uts46_to_unicode("𑖿。嬶Ss葽", %p)},	undef,	"to_unicode\(\'𑖿\。嬶Ss葽\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:4626\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𑇀⒈。񔾭𐹲", %p)},	undef,	"to_unicode\(\'𑇀⒈\。񔾭𐹲\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4627\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑇀1.。񔾭𐹲", %p)},	undef,	"to_unicode\(\'𑇀1\.\。񔾭𐹲\'\)\ throws\ error\ P1\ V5\ V6\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:4628\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑍀︒≮．𺅧𐧅\x{06B7}", %p)},	undef,	"to_unicode\(\'𑍀︒\≮．𺅧𐧅\\u06B7\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4629\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑍀︒<\x{0338}．𺅧𐧅\x{06B7}", %p)},	undef,	"to_unicode\(\'𑍀︒\<\\u0338．𺅧𐧅\\u06B7\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4630\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑍀。≮.𺅧𐧅\x{06B7}", %p)},	undef,	"to_unicode\(\'𑍀\。\≮\.𺅧𐧅\\u06B7\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4631\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𑍀。<\x{0338}.𺅧𐧅\x{06B7}", %p)},	undef,	"to_unicode\(\'𑍀\。\<\\u0338\.𺅧𐧅\\u06B7\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:4632\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠀳𐹫򇬇.󠐊ς𸰟񧋭", %p)},	undef,	"to_unicode\(\'\󠀳𐹫򇬇\.\󠐊ς𸰟񧋭\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4633\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠀳𐹫򇬇.󠐊Σ𸰟񧋭", %p)},	undef,	"to_unicode\(\'\󠀳𐹫򇬇\.\󠐊Σ𸰟񧋭\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4634\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("󠀳𐹫򇬇.󠐊σ𸰟񧋭", %p)},	undef,	"to_unicode\(\'\󠀳𐹫򇬇\.\󠐊σ𸰟񧋭\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:4635\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς\x{1CD1}񝝛\x{0F84}｡𐯻\x{200C}\x{06C6}", %p)},	undef,	"to_unicode\(\'ς\\u1CD1񝝛\\u0F84｡𐯻\\u200C\\u06C6\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4636\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς\x{1CD1}񝝛\x{0F84}｡𐯻\x{200C}\x{06C6}", %p)},	undef,	"to_unicode\(\'ς\\u1CD1񝝛\\u0F84｡𐯻\\u200C\\u06C6\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4637\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς\x{1CD1}񝝛\x{0F84}。𐯻\x{200C}\x{06C6}", %p)},	undef,	"to_unicode\(\'ς\\u1CD1񝝛\\u0F84\。𐯻\\u200C\\u06C6\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4638\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς\x{1CD1}񝝛\x{0F84}。𐯻\x{200C}\x{06C6}", %p)},	undef,	"to_unicode\(\'ς\\u1CD1񝝛\\u0F84\。𐯻\\u200C\\u06C6\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4639\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ\x{1CD1}񝝛\x{0F84}。𐯻\x{200C}\x{06C6}", %p)},	undef,	"to_unicode\(\'Σ\\u1CD1񝝛\\u0F84\。𐯻\\u200C\\u06C6\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4640\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ\x{1CD1}񝝛\x{0F84}。𐯻\x{200C}\x{06C6}", %p)},	undef,	"to_unicode\(\'Σ\\u1CD1񝝛\\u0F84\。𐯻\\u200C\\u06C6\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4641\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ\x{1CD1}񝝛\x{0F84}。𐯻\x{200C}\x{06C6}", %p)},	undef,	"to_unicode\(\'σ\\u1CD1񝝛\\u0F84\。𐯻\\u200C\\u06C6\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4642\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ\x{1CD1}񝝛\x{0F84}。𐯻\x{200C}\x{06C6}", %p)},	undef,	"to_unicode\(\'σ\\u1CD1񝝛\\u0F84\。𐯻\\u200C\\u06C6\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4643\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ\x{1CD1}񝝛\x{0F84}｡𐯻\x{200C}\x{06C6}", %p)},	undef,	"to_unicode\(\'Σ\\u1CD1񝝛\\u0F84｡𐯻\\u200C\\u06C6\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4644\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ\x{1CD1}񝝛\x{0F84}｡𐯻\x{200C}\x{06C6}", %p)},	undef,	"to_unicode\(\'Σ\\u1CD1񝝛\\u0F84｡𐯻\\u200C\\u06C6\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4645\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ\x{1CD1}񝝛\x{0F84}｡𐯻\x{200C}\x{06C6}", %p)},	undef,	"to_unicode\(\'σ\\u1CD1񝝛\\u0F84｡𐯻\\u200C\\u06C6\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4646\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ\x{1CD1}񝝛\x{0F84}｡𐯻\x{200C}\x{06C6}", %p)},	undef,	"to_unicode\(\'σ\\u1CD1񝝛\\u0F84｡𐯻\\u200C\\u06C6\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:4647\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-𱤫｡-\x{05F3}𐫯", %p)},	undef,	"to_unicode\(\'\-𱤫｡\-\\u05F3𐫯\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4648\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-𱤫。-\x{05F3}𐫯", %p)},	undef,	"to_unicode\(\'\-𱤫\。\-\\u05F3𐫯\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:4649\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("◗󥆅𝟤｡\x{200D}󠍭", %p)},	undef,	"to_unicode\(\'\◗󥆅𝟤｡\\u200D\󠍭\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4650\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("◗󥆅𝟤｡\x{200D}󠍭", %p)},	undef,	"to_unicode\(\'\◗󥆅𝟤｡\\u200D\󠍭\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4651\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("◗󥆅2。\x{200D}󠍭", %p)},	undef,	"to_unicode\(\'\◗󥆅2\。\\u200D\󠍭\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4652\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("◗󥆅2。\x{200D}󠍭", %p)},	undef,	"to_unicode\(\'\◗󥆅2\。\\u200D\󠍭\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:4653\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0CF8}\x{200D}𑚴\x{0605}｡񦯈", %p)},	undef,	"to_unicode\(\'\\u0CF8\\u200D𑚴\\u0605｡񦯈\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:4654\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0CF8}\x{200D}𑚴\x{0605}｡񦯈", %p)},	undef,	"to_unicode\(\'\\u0CF8\\u200D𑚴\\u0605｡񦯈\'\)\ throws\ error