# *** DO NOT EDIT *** generated file *** DO NOT EDIT ***
#
# generated by lib/Unicode/UTS46/GenTests.PL from data/IdnaTest.txt
# see repository at http://github.com/cfaerber/Net-IDN-Encode for source files
#
use strict;
use utf8;
use warnings;

use Test::More tests => 615 + 1;
use Test::NoWarnings;

use Net::IDN::Encode qw(:all);

my $builder = Test::More->builder;
binmode $builder->output,         ":utf8";
binmode $builder->failure_output, ":utf8";
binmode $builder->todo_output,    ":utf8";

no warnings 'utf8';

my %p = ("TransitionalProcessing" => "1");

is(eval{to_unicode("fass.de",	%p)}, "fass.de",	"to_unicode\(\'fass\.de\'\)\ \[data\/IdnaTest\.txt\:45\]");
is(eval{to_unicode("FASS.DE",	%p)}, "fass.de",	"to_unicode\(\'FASS\.DE\'\)\ \[data\/IdnaTest\.txt\:46\]");
is(eval{to_unicode("Fass.de",	%p)}, "fass.de",	"to_unicode\(\'Fass\.de\'\)\ \[data\/IdnaTest\.txt\:47\]");
is(eval{to_unicode("faß.de",	%p)}, "faß.de",	"to_unicode\(\'faß\.de\'\)\ \[data\/IdnaTest\.txt\:48\]");
is(eval{to_unicode("Faß.de",	%p)}, "faß.de",	"to_unicode\(\'Faß\.de\'\)\ \[data\/IdnaTest\.txt\:50\]");
is(eval{to_unicode("xn--fa-hia.de",	%p)}, "faß.de",	"to_unicode\(\'xn\-\-fa\-hia\.de\'\)\ \[data\/IdnaTest\.txt\:52\]");
is(eval{to_unicode("XN--FA-HIA.DE",	%p)}, "faß.de",	"to_unicode\(\'XN\-\-FA\-HIA\.DE\'\)\ \[data\/IdnaTest\.txt\:53\]");
is(eval{to_unicode("Xn--Fa-Hia.de",	%p)}, "faß.de",	"to_unicode\(\'Xn\-\-Fa\-Hia\.de\'\)\ \[data\/IdnaTest\.txt\:54\]");
is(eval{to_unicode("à\x{05D0}",	%p)}, undef,	"to_unicode\(\'à\\u05D0\'\)\ is\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:55\]");
is(eval{to_unicode("À\x{05D0}",	%p)}, undef,	"to_unicode\(\'À\\u05D0\'\)\ is\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:56\]");
is(eval{to_unicode("0à.\x{05D0}",	%p)}, undef,	"to_unicode\(\'0à\.\\u05D0\'\)\ is\ error\ B1\ \[data\/IdnaTest\.txt\:57\]");
is(eval{to_unicode("0À.\x{05D0}",	%p)}, undef,	"to_unicode\(\'0À\.\\u05D0\'\)\ is\ error\ B1\ \[data\/IdnaTest\.txt\:58\]");
is(eval{to_unicode("à.\x{05D0}\x{0308}",	%p)}, "à.\x{05D0}\x{0308}",	"to_unicode\(\'à\.\\u05D0\\u0308\'\)\ \[data\/IdnaTest\.txt\:59\]");
is(eval{to_unicode("À.\x{05D0}\x{0308}",	%p)}, "à.\x{05D0}\x{0308}",	"to_unicode\(\'À\.\\u05D0\\u0308\'\)\ \[data\/IdnaTest\.txt\:60\]");
is(eval{to_unicode("xn--0ca.xn--ssa73l",	%p)}, "à.\x{05D0}\x{0308}",	"to_unicode\(\'xn\-\-0ca\.xn\-\-ssa73l\'\)\ \[data\/IdnaTest\.txt\:61\]");
is(eval{to_unicode("XN--0CA.XN--SSA73L",	%p)}, "à.\x{05D0}\x{0308}",	"to_unicode\(\'XN\-\-0CA\.XN\-\-SSA73L\'\)\ \[data\/IdnaTest\.txt\:62\]");
is(eval{to_unicode("Xn--0Ca.xn--Ssa73l",	%p)}, "à.\x{05D0}\x{0308}",	"to_unicode\(\'Xn\-\-0Ca\.xn\-\-Ssa73l\'\)\ \[data\/IdnaTest\.txt\:63\]");
is(eval{to_unicode("à.\x{05D0}0\x{0660}\x{05D0}",	%p)}, undef,	"to_unicode\(\'à\.\\u05D00\\u0660\\u05D0\'\)\ is\ error\ B4\ \[data\/IdnaTest\.txt\:64\]");
is(eval{to_unicode("À.\x{05D0}0\x{0660}\x{05D0}",	%p)}, undef,	"to_unicode\(\'À\.\\u05D00\\u0660\\u05D0\'\)\ is\ error\ B4\ \[data\/IdnaTest\.txt\:65\]");
is(eval{to_unicode("\x{0308}.\x{05D0}",	%p)}, undef,	"to_unicode\(\'\\u0308\.\\u05D0\'\)\ is\ error\ V5\ B1\ B3\ B6\ \[data\/IdnaTest\.txt\:66\]");
is(eval{to_unicode("à.\x{05D0}0\x{0660}",	%p)}, undef,	"to_unicode\(\'à\.\\u05D00\\u0660\'\)\ is\ error\ B4\ \[data\/IdnaTest\.txt\:67\]");
is(eval{to_unicode("À.\x{05D0}0\x{0660}",	%p)}, undef,	"to_unicode\(\'À\.\\u05D00\\u0660\'\)\ is\ error\ B4\ \[data\/IdnaTest\.txt\:68\]");
is(eval{to_unicode("àˇ.\x{05D0}",	%p)}, undef,	"to_unicode\(\'àˇ\.\\u05D0\'\)\ is\ error\ B6\ \[data\/IdnaTest\.txt\:69\]");
is(eval{to_unicode("Àˇ.\x{05D0}",	%p)}, undef,	"to_unicode\(\'Àˇ\.\\u05D0\'\)\ is\ error\ B6\ \[data\/IdnaTest\.txt\:70\]");
is(eval{to_unicode("à\x{0308}.\x{05D0}",	%p)}, "à\x{0308}.\x{05D0}",	"to_unicode\(\'à\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:71\]");
is(eval{to_unicode("À\x{0308}.\x{05D0}",	%p)}, "à\x{0308}.\x{05D0}",	"to_unicode\(\'À\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:72\]");
is(eval{to_unicode("xn--0ca81i.xn--4db",	%p)}, "à\x{0308}.\x{05D0}",	"to_unicode\(\'xn\-\-0ca81i\.xn\-\-4db\'\)\ \[data\/IdnaTest\.txt\:73\]");
is(eval{to_unicode("XN--0CA81I.XN--4DB",	%p)}, "à\x{0308}.\x{05D0}",	"to_unicode\(\'XN\-\-0CA81I\.XN\-\-4DB\'\)\ \[data\/IdnaTest\.txt\:74\]");
is(eval{to_unicode("Xn--0Ca81i.xn--4Db",	%p)}, "à\x{0308}.\x{05D0}",	"to_unicode\(\'Xn\-\-0Ca81i\.xn\-\-4Db\'\)\ \[data\/IdnaTest\.txt\:75\]");
is(eval{to_unicode("a\x{200C}b",	%p)}, undef,	"to_unicode\(\'a\\u200Cb\'\)\ is\ error\ C1\ \[data\/IdnaTest\.txt\:76\]");
is(eval{to_unicode("A\x{200C}B",	%p)}, undef,	"to_unicode\(\'A\\u200CB\'\)\ is\ error\ C1\ \[data\/IdnaTest\.txt\:78\]");
is(eval{to_unicode("A\x{200C}b",	%p)}, undef,	"to_unicode\(\'A\\u200Cb\'\)\ is\ error\ C1\ \[data\/IdnaTest\.txt\:80\]");
is(eval{to_unicode("ab",	%p)}, "ab",	"to_unicode\(\'ab\'\)\ \[data\/IdnaTest\.txt\:82\]");
is(eval{to_unicode("AB",	%p)}, "ab",	"to_unicode\(\'AB\'\)\ \[data\/IdnaTest\.txt\:83\]");
is(eval{to_unicode("Ab",	%p)}, "ab",	"to_unicode\(\'Ab\'\)\ \[data\/IdnaTest\.txt\:84\]");
is(eval{to_unicode("a\x{094D}\x{200C}b",	%p)}, "a\x{094D}\x{200C}b",	"to_unicode\(\'a\\u094D\\u200Cb\'\)\ \[data\/IdnaTest\.txt\:85\]");
is(eval{to_unicode("A\x{094D}\x{200C}B",	%p)}, "a\x{094D}\x{200C}b",	"to_unicode\(\'A\\u094D\\u200CB\'\)\ \[data\/IdnaTest\.txt\:87\]");
is(eval{to_unicode("A\x{094D}\x{200C}b",	%p)}, "a\x{094D}\x{200C}b",	"to_unicode\(\'A\\u094D\\u200Cb\'\)\ \[data\/IdnaTest\.txt\:89\]");
is(eval{to_unicode("xn--ab-fsf",	%p)}, "a\x{094D}b",	"to_unicode\(\'xn\-\-ab\-fsf\'\)\ \[data\/IdnaTest\.txt\:91\]");
is(eval{to_unicode("XN--AB-FSF",	%p)}, "a\x{094D}b",	"to_unicode\(\'XN\-\-AB\-FSF\'\)\ \[data\/IdnaTest\.txt\:92\]");
is(eval{to_unicode("Xn--Ab-Fsf",	%p)}, "a\x{094D}b",	"to_unicode\(\'Xn\-\-Ab\-Fsf\'\)\ \[data\/IdnaTest\.txt\:93\]");
is(eval{to_unicode("a\x{094D}b",	%p)}, "a\x{094D}b",	"to_unicode\(\'a\\u094Db\'\)\ \[data\/IdnaTest\.txt\:94\]");
is(eval{to_unicode("A\x{094D}B",	%p)}, "a\x{094D}b",	"to_unicode\(\'A\\u094DB\'\)\ \[data\/IdnaTest\.txt\:95\]");
is(eval{to_unicode("A\x{094D}b",	%p)}, "a\x{094D}b",	"to_unicode\(\'A\\u094Db\'\)\ \[data\/IdnaTest\.txt\:96\]");
is(eval{to_unicode("xn--ab-fsf604u",	%p)}, "a\x{094D}\x{200C}b",	"to_unicode\(\'xn\-\-ab\-fsf604u\'\)\ \[data\/IdnaTest\.txt\:97\]");
is(eval{to_unicode("XN--AB-FSF604U",	%p)}, "a\x{094D}\x{200C}b",	"to_unicode\(\'XN\-\-AB\-FSF604U\'\)\ \[data\/IdnaTest\.txt\:98\]");
is(eval{to_unicode("Xn--Ab-Fsf604u",	%p)}, "a\x{094D}\x{200C}b",	"to_unicode\(\'Xn\-\-Ab\-Fsf604u\'\)\ \[data\/IdnaTest\.txt\:99\]");
is(eval{to_unicode("\x{0308}\x{200C}\x{0308}\x{0628}b",	%p)}, undef,	"to_unicode\(\'\\u0308\\u200C\\u0308\\u0628b\'\)\ is\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:100\]");
is(eval{to_unicode("\x{0308}\x{200C}\x{0308}\x{0628}B",	%p)}, undef,	"to_unicode\(\'\\u0308\\u200C\\u0308\\u0628B\'\)\ is\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:102\]");
is(eval{to_unicode("a\x{0628}\x{0308}\x{200C}\x{0308}",	%p)}, undef,	"to_unicode\(\'a\\u0628\\u0308\\u200C\\u0308\'\)\ is\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:104\]");
is(eval{to_unicode("A\x{0628}\x{0308}\x{200C}\x{0308}",	%p)}, undef,	"to_unicode\(\'A\\u0628\\u0308\\u200C\\u0308\'\)\ is\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:106\]");
is(eval{to_unicode("a\x{0628}\x{0308}\x{200C}\x{0308}\x{0628}b",	%p)}, undef,	"to_unicode\(\'a\\u0628\\u0308\\u200C\\u0308\\u0628b\'\)\ is\ error\ B5\ \[data\/IdnaTest\.txt\:108\]");
is(eval{to_unicode("A\x{0628}\x{0308}\x{200C}\x{0308}\x{0628}B",	%p)}, undef,	"to_unicode\(\'A\\u0628\\u0308\\u200C\\u0308\\u0628B\'\)\ is\ error\ B5\ \[data\/IdnaTest\.txt\:110\]");
is(eval{to_unicode("A\x{0628}\x{0308}\x{200C}\x{0308}\x{0628}b",	%p)}, undef,	"to_unicode\(\'A\\u0628\\u0308\\u200C\\u0308\\u0628b\'\)\ is\ error\ B5\ \[data\/IdnaTest\.txt\:112\]");
is(eval{to_unicode("a\x{200D}b",	%p)}, undef,	"to_unicode\(\'a\\u200Db\'\)\ is\ error\ C2\ \[data\/IdnaTest\.txt\:114\]");
is(eval{to_unicode("A\x{200D}B",	%p)}, undef,	"to_unicode\(\'A\\u200DB\'\)\ is\ error\ C2\ \[data\/IdnaTest\.txt\:116\]");
is(eval{to_unicode("A\x{200D}b",	%p)}, undef,	"to_unicode\(\'A\\u200Db\'\)\ is\ error\ C2\ \[data\/IdnaTest\.txt\:118\]");
is(eval{to_unicode("a\x{094D}\x{200D}b",	%p)}, "a\x{094D}\x{200D}b",	"to_unicode\(\'a\\u094D\\u200Db\'\)\ \[data\/IdnaTest\.txt\:120\]");
is(eval{to_unicode("A\x{094D}\x{200D}B",	%p)}, "a\x{094D}\x{200D}b",	"to_unicode\(\'A\\u094D\\u200DB\'\)\ \[data\/IdnaTest\.txt\:122\]");
is(eval{to_unicode("A\x{094D}\x{200D}b",	%p)}, "a\x{094D}\x{200D}b",	"to_unicode\(\'A\\u094D\\u200Db\'\)\ \[data\/IdnaTest\.txt\:124\]");
is(eval{to_unicode("xn--ab-fsf014u",	%p)}, "a\x{094D}\x{200D}b",	"to_unicode\(\'xn\-\-ab\-fsf014u\'\)\ \[data\/IdnaTest\.txt\:126\]");
is(eval{to_unicode("XN--AB-FSF014U",	%p)}, "a\x{094D}\x{200D}b",	"to_unicode\(\'XN\-\-AB\-FSF014U\'\)\ \[data\/IdnaTest\.txt\:127\]");
is(eval{to_unicode("Xn--Ab-Fsf014u",	%p)}, "a\x{094D}\x{200D}b",	"to_unicode\(\'Xn\-\-Ab\-Fsf014u\'\)\ \[data\/IdnaTest\.txt\:128\]");
is(eval{to_unicode("\x{0308}\x{200D}\x{0308}\x{0628}b",	%p)}, undef,	"to_unicode\(\'\\u0308\\u200D\\u0308\\u0628b\'\)\ is\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:129\]");
is(eval{to_unicode("\x{0308}\x{200D}\x{0308}\x{0628}B",	%p)}, undef,	"to_unicode\(\'\\u0308\\u200D\\u0308\\u0628B\'\)\ is\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:131\]");
is(eval{to_unicode("a\x{0628}\x{0308}\x{200D}\x{0308}",	%p)}, undef,	"to_unicode\(\'a\\u0628\\u0308\\u200D\\u0308\'\)\ is\ error\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:133\]");
is(eval{to_unicode("A\x{0628}\x{0308}\x{200D}\x{0308}",	%p)}, undef,	"to_unicode\(\'A\\u0628\\u0308\\u200D\\u0308\'\)\ is\ error\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:135\]");
is(eval{to_unicode("a\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}b",	%p)}, undef,	"to_unicode\(\'a\\u0628\\u0308\\u200D\\u0308\\u0628b\'\)\ is\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:137\]");
is(eval{to_unicode("A\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}B",	%p)}, undef,	"to_unicode\(\'A\\u0628\\u0308\\u200D\\u0308\\u0628B\'\)\ is\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:139\]");
is(eval{to_unicode("A\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}b",	%p)}, undef,	"to_unicode\(\'A\\u0628\\u0308\\u200D\\u0308\\u0628b\'\)\ is\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:141\]");
is(eval{to_unicode("1234567890ä1234567890123456789012345678901234567890123456",	%p)}, "1234567890ä1234567890123456789012345678901234567890123456",	"to_unicode\(\'1234567890ä1234567890123456789012345678901234567890123456\'\)\ \[data\/IdnaTest\.txt\:143\]");
is(eval{to_unicode("1234567890Ä1234567890123456789012345678901234567890123456",	%p)}, "1234567890ä1234567890123456789012345678901234567890123456",	"to_unicode\(\'1234567890Ä1234567890123456789012345678901234567890123456\'\)\ \[data\/IdnaTest\.txt\:144\]");
is(eval{to_unicode("www.eXample.cOm",	%p)}, "www.example.com",	"to_unicode\(\'www\.eXample\.cOm\'\)\ \[data\/IdnaTest\.txt\:145\]");
is(eval{to_unicode("www.example.com",	%p)}, "www.example.com",	"to_unicode\(\'www\.example\.com\'\)\ \[data\/IdnaTest\.txt\:146\]");
is(eval{to_unicode("WWW.EXAMPLE.COM",	%p)}, "www.example.com",	"to_unicode\(\'WWW\.EXAMPLE\.COM\'\)\ \[data\/IdnaTest\.txt\:147\]");
is(eval{to_unicode("Www.example.com",	%p)}, "www.example.com",	"to_unicode\(\'Www\.example\.com\'\)\ \[data\/IdnaTest\.txt\:148\]");
is(eval{to_unicode("Bücher.de",	%p)}, "bücher.de",	"to_unicode\(\'Bücher\.de\'\)\ \[data\/IdnaTest\.txt\:149\]");
is(eval{to_unicode("bücher.de",	%p)}, "bücher.de",	"to_unicode\(\'bücher\.de\'\)\ \[data\/IdnaTest\.txt\:150\]");
is(eval{to_unicode("BÜCHER.DE",	%p)}, "bücher.de",	"to_unicode\(\'BÜCHER\.DE\'\)\ \[data\/IdnaTest\.txt\:151\]");
is(eval{to_unicode("xn--bcher-kva.de",	%p)}, "bücher.de",	"to_unicode\(\'xn\-\-bcher\-kva\.de\'\)\ \[data\/IdnaTest\.txt\:152\]");
is(eval{to_unicode("XN--BCHER-KVA.DE",	%p)}, "bücher.de",	"to_unicode\(\'XN\-\-BCHER\-KVA\.DE\'\)\ \[data\/IdnaTest\.txt\:153\]");
is(eval{to_unicode("Xn--Bcher-Kva.de",	%p)}, "bücher.de",	"to_unicode\(\'Xn\-\-Bcher\-Kva\.de\'\)\ \[data\/IdnaTest\.txt\:154\]");
is(eval{to_unicode("ÖBB",	%p)}, "öbb",	"to_unicode\(\'ÖBB\'\)\ \[data\/IdnaTest\.txt\:155\]");
is(eval{to_unicode("öbb",	%p)}, "öbb",	"to_unicode\(\'öbb\'\)\ \[data\/IdnaTest\.txt\:156\]");
is(eval{to_unicode("Öbb",	%p)}, "öbb",	"to_unicode\(\'Öbb\'\)\ \[data\/IdnaTest\.txt\:157\]");
is(eval{to_unicode("xn--bb-eka",	%p)}, "öbb",	"to_unicode\(\'xn\-\-bb\-eka\'\)\ \[data\/IdnaTest\.txt\:158\]");
is(eval{to_unicode("XN--BB-EKA",	%p)}, "öbb",	"to_unicode\(\'XN\-\-BB\-EKA\'\)\ \[data\/IdnaTest\.txt\:159\]");
is(eval{to_unicode("Xn--Bb-Eka",	%p)}, "öbb",	"to_unicode\(\'Xn\-\-Bb\-Eka\'\)\ \[data\/IdnaTest\.txt\:160\]");
is(eval{to_unicode("XN--fA-hia.dE",	%p)}, "faß.de",	"to_unicode\(\'XN\-\-fA\-hia\.dE\'\)\ \[data\/IdnaTest\.txt\:161\]");
is(eval{to_unicode("βόλος.com",	%p)}, "βόλος.com",	"to_unicode\(\'βόλος\.com\'\)\ \[data\/IdnaTest\.txt\:162\]");
is(eval{to_unicode("ΒΌΛΟΣ.COM",	%p)}, "βόλοσ.com",	"to_unicode\(\'ΒΌΛΟΣ\.COM\'\)\ \[data\/IdnaTest\.txt\:164\]");
is(eval{to_unicode("βόλοσ.com",	%p)}, "βόλοσ.com",	"to_unicode\(\'βόλοσ\.com\'\)\ \[data\/IdnaTest\.txt\:165\]");
is(eval{to_unicode("Βόλοσ.com",	%p)}, "βόλοσ.com",	"to_unicode\(\'Βόλοσ\.com\'\)\ \[data\/IdnaTest\.txt\:166\]");
is(eval{to_unicode("xn--nxasmq6b.com",	%p)}, "βόλοσ.com",	"to_unicode\(\'xn\-\-nxasmq6b\.com\'\)\ \[data\/IdnaTest\.txt\:167\]");
is(eval{to_unicode("XN--NXASMQ6B.COM",	%p)}, "βόλοσ.com",	"to_unicode\(\'XN\-\-NXASMQ6B\.COM\'\)\ \[data\/IdnaTest\.txt\:168\]");
is(eval{to_unicode("Xn--Nxasmq6b.com",	%p)}, "βόλοσ.com",	"to_unicode\(\'Xn\-\-Nxasmq6b\.com\'\)\ \[data\/IdnaTest\.txt\:169\]");
is(eval{to_unicode("Βόλος.com",	%p)}, "βόλος.com",	"to_unicode\(\'Βόλος\.com\'\)\ \[data\/IdnaTest\.txt\:170\]");
is(eval{to_unicode("xn--nxasmm1c.com",	%p)}, "βόλος.com",	"to_unicode\(\'xn\-\-nxasmm1c\.com\'\)\ \[data\/IdnaTest\.txt\:172\]");
is(eval{to_unicode("XN--NXASMM1C.COM",	%p)}, "βόλος.com",	"to_unicode\(\'XN\-\-NXASMM1C\.COM\'\)\ \[data\/IdnaTest\.txt\:173\]");
is(eval{to_unicode("Xn--Nxasmm1c.com",	%p)}, "βόλος.com",	"to_unicode\(\'Xn\-\-Nxasmm1c\.com\'\)\ \[data\/IdnaTest\.txt\:174\]");
is(eval{to_unicode("xn--nxasmm1c",	%p)}, "βόλος",	"to_unicode\(\'xn\-\-nxasmm1c\'\)\ \[data\/IdnaTest\.txt\:175\]");
is(eval{to_unicode("XN--NXASMM1C",	%p)}, "βόλος",	"to_unicode\(\'XN\-\-NXASMM1C\'\)\ \[data\/IdnaTest\.txt\:176\]");
is(eval{to_unicode("Xn--Nxasmm1c",	%p)}, "βόλος",	"to_unicode\(\'Xn\-\-Nxasmm1c\'\)\ \[data\/IdnaTest\.txt\:177\]");
is(eval{to_unicode("βόλος",	%p)}, "βόλος",	"to_unicode\(\'βόλος\'\)\ \[data\/IdnaTest\.txt\:178\]");
is(eval{to_unicode("ΒΌΛΟΣ",	%p)}, "βόλοσ",	"to_unicode\(\'ΒΌΛΟΣ\'\)\ \[data\/IdnaTest\.txt\:180\]");
is(eval{to_unicode("βόλοσ",	%p)}, "βόλοσ",	"to_unicode\(\'βόλοσ\'\)\ \[data\/IdnaTest\.txt\:181\]");
is(eval{to_unicode("Βόλοσ",	%p)}, "βόλοσ",	"to_unicode\(\'Βόλοσ\'\)\ \[data\/IdnaTest\.txt\:182\]");
is(eval{to_unicode("xn--nxasmq6b",	%p)}, "βόλοσ",	"to_unicode\(\'xn\-\-nxasmq6b\'\)\ \[data\/IdnaTest\.txt\:183\]");
is(eval{to_unicode("XN--NXASMQ6B",	%p)}, "βόλοσ",	"to_unicode\(\'XN\-\-NXASMQ6B\'\)\ \[data\/IdnaTest\.txt\:184\]");
is(eval{to_unicode("Xn--Nxasmq6b",	%p)}, "βόλοσ",	"to_unicode\(\'Xn\-\-Nxasmq6b\'\)\ \[data\/IdnaTest\.txt\:185\]");
is(eval{to_unicode("Βόλος",	%p)}, "βόλος",	"to_unicode\(\'Βόλος\'\)\ \[data\/IdnaTest\.txt\:186\]");
is(eval{to_unicode("www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com",	%p)}, "www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com",	"to_unicode\(\'www\.ශ\\u0DCA\\u200Dර\\u0DD3\.com\'\)\ \[data\/IdnaTest\.txt\:188\]");
is(eval{to_unicode("WWW.ශ\x{0DCA}\x{200D}ර\x{0DD3}.COM",	%p)}, "www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com",	"to_unicode\(\'WWW\.ශ\\u0DCA\\u200Dර\\u0DD3\.COM\'\)\ \[data\/IdnaTest\.txt\:190\]");
is(eval{to_unicode("Www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com",	%p)}, "www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com",	"to_unicode\(\'Www\.ශ\\u0DCA\\u200Dර\\u0DD3\.com\'\)\ \[data\/IdnaTest\.txt\:192\]");
is(eval{to_unicode("www.xn--10cl1a0b.com",	%p)}, "www.ශ\x{0DCA}ර\x{0DD3}.com",	"to_unicode\(\'www\.xn\-\-10cl1a0b\.com\'\)\ \[data\/IdnaTest\.txt\:194\]");
is(eval{to_unicode("WWW.XN--10CL1A0B.COM",	%p)}, "www.ශ\x{0DCA}ර\x{0DD3}.com",	"to_unicode\(\'WWW\.XN\-\-10CL1A0B\.COM\'\)\ \[data\/IdnaTest\.txt\:195\]");
is(eval{to_unicode("Www.xn--10Cl1a0b.com",	%p)}, "www.ශ\x{0DCA}ර\x{0DD3}.com",	"to_unicode\(\'Www\.xn\-\-10Cl1a0b\.com\'\)\ \[data\/IdnaTest\.txt\:196\]");
is(eval{to_unicode("www.ශ\x{0DCA}ර\x{0DD3}.com",	%p)}, "www.ශ\x{0DCA}ර\x{0DD3}.com",	"to_unicode\(\'www\.ශ\\u0DCAර\\u0DD3\.com\'\)\ \[data\/IdnaTest\.txt\:197\]");
is(eval{to_unicode("WWW.ශ\x{0DCA}ර\x{0DD3}.COM",	%p)}, "www.ශ\x{0DCA}ර\x{0DD3}.com",	"to_unicode\(\'WWW\.ශ\\u0DCAර\\u0DD3\.COM\'\)\ \[data\/IdnaTest\.txt\:198\]");
is(eval{to_unicode("Www.ශ\x{0DCA}ර\x{0DD3}.com",	%p)}, "www.ශ\x{0DCA}ර\x{0DD3}.com",	"to_unicode\(\'Www\.ශ\\u0DCAර\\u0DD3\.com\'\)\ \[data\/IdnaTest\.txt\:199\]");
is(eval{to_unicode("www.xn--10cl1a0b660p.com",	%p)}, "www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com",	"to_unicode\(\'www\.xn\-\-10cl1a0b660p\.com\'\)\ \[data\/IdnaTest\.txt\:200\]");
is(eval{to_unicode("WWW.XN--10CL1A0B660P.COM",	%p)}, "www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com",	"to_unicode\(\'WWW\.XN\-\-10CL1A0B660P\.COM\'\)\ \[data\/IdnaTest\.txt\:201\]");
is(eval{to_unicode("Www.xn--10Cl1a0b660p.com",	%p)}, "www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com",	"to_unicode\(\'Www\.xn\-\-10Cl1a0b660p\.com\'\)\ \[data\/IdnaTest\.txt\:202\]");
is(eval{to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}",	%p)}, "\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u200C\\u0627\\u06CC\'\)\ \[data\/IdnaTest\.txt\:203\]");
is(eval{to_unicode("xn--mgba3gch31f",	%p)}, "\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}",	"to_unicode\(\'xn\-\-mgba3gch31f\'\)\ \[data\/IdnaTest\.txt\:205\]");
is(eval{to_unicode("XN--MGBA3GCH31F",	%p)}, "\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}",	"to_unicode\(\'XN\-\-MGBA3GCH31F\'\)\ \[data\/IdnaTest\.txt\:206\]");
is(eval{to_unicode("Xn--Mgba3gch31f",	%p)}, "\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}",	"to_unicode\(\'Xn\-\-Mgba3gch31f\'\)\ \[data\/IdnaTest\.txt\:207\]");
is(eval{to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}",	%p)}, "\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u0627\\u06CC\'\)\ \[data\/IdnaTest\.txt\:208\]");
is(eval{to_unicode("xn--mgba3gch31f060k",	%p)}, "\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}",	"to_unicode\(\'xn\-\-mgba3gch31f060k\'\)\ \[data\/IdnaTest\.txt\:209\]");
is(eval{to_unicode("XN--MGBA3GCH31F060K",	%p)}, "\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}",	"to_unicode\(\'XN\-\-MGBA3GCH31F060K\'\)\ \[data\/IdnaTest\.txt\:210\]");
is(eval{to_unicode("Xn--Mgba3gch31f060k",	%p)}, "\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}",	"to_unicode\(\'Xn\-\-Mgba3gch31f060k\'\)\ \[data\/IdnaTest\.txt\:211\]");
is(eval{to_unicode("xn--mgba3gch31f060k.com",	%p)}, "\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.com",	"to_unicode\(\'xn\-\-mgba3gch31f060k\.com\'\)\ \[data\/IdnaTest\.txt\:212\]");
is(eval{to_unicode("XN--MGBA3GCH31F060K.COM",	%p)}, "\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.com",	"to_unicode\(\'XN\-\-MGBA3GCH31F060K\.COM\'\)\ \[data\/IdnaTest\.txt\:213\]");
is(eval{to_unicode("Xn--Mgba3gch31f060k.com",	%p)}, "\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.com",	"to_unicode\(\'Xn\-\-Mgba3gch31f060k\.com\'\)\ \[data\/IdnaTest\.txt\:214\]");
is(eval{to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.com",	%p)}, "\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.com",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u200C\\u0627\\u06CC\.com\'\)\ \[data\/IdnaTest\.txt\:215\]");
is(eval{to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.COM",	%p)}, "\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.com",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u200C\\u0627\\u06CC\.COM\'\)\ \[data\/IdnaTest\.txt\:217\]");
is(eval{to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.Com",	%p)}, "\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.com",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u200C\\u0627\\u06CC\.Com\'\)\ \[data\/IdnaTest\.txt\:219\]");
is(eval{to_unicode("xn--mgba3gch31f.com",	%p)}, "\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}.com",	"to_unicode\(\'xn\-\-mgba3gch31f\.com\'\)\ \[data\/IdnaTest\.txt\:221\]");
is(eval{to_unicode("XN--MGBA3GCH31F.COM",	%p)}, "\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}.com",	"to_unicode\(\'XN\-\-MGBA3GCH31F\.COM\'\)\ \[data\/IdnaTest\.txt\:222\]");
is(eval{to_unicode("Xn--Mgba3gch31f.com",	%p)}, "\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}.com",	"to_unicode\(\'Xn\-\-Mgba3gch31f\.com\'\)\ \[data\/IdnaTest\.txt\:223\]");
is(eval{to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}.com",	%p)}, "\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}.com",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u0627\\u06CC\.com\'\)\ \[data\/IdnaTest\.txt\:224\]");
is(eval{to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}.COM",	%p)}, "\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}.com",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u0627\\u06CC\.COM\'\)\ \[data\/IdnaTest\.txt\:225\]");
is(eval{to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}.Com",	%p)}, "\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}.com",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u0627\\u06CC\.Com\'\)\ \[data\/IdnaTest\.txt\:226\]");
is(eval{to_unicode("a.b．c。d｡",	%p)}, "a.b.c.d.",	"to_unicode\(\'a\.b．c。d｡\'\)\ \[data\/IdnaTest\.txt\:227\]");
is(eval{to_unicode("A.B．C。D｡",	%p)}, "a.b.c.d.",	"to_unicode\(\'A\.B．C。D｡\'\)\ \[data\/IdnaTest\.txt\:228\]");
is(eval{to_unicode("A.b．c。D｡",	%p)}, "a.b.c.d.",	"to_unicode\(\'A\.b．c。D｡\'\)\ \[data\/IdnaTest\.txt\:229\]");
is(eval{to_unicode("a.b.c.d.",	%p)}, "a.b.c.d.",	"to_unicode\(\'a\.b\.c\.d\.\'\)\ \[data\/IdnaTest\.txt\:230\]");
is(eval{to_unicode("A.B.C.D.",	%p)}, "a.b.c.d.",	"to_unicode\(\'A\.B\.C\.D\.\'\)\ \[data\/IdnaTest\.txt\:231\]");
is(eval{to_unicode("A.b.c.d.",	%p)}, "a.b.c.d.",	"to_unicode\(\'A\.b\.c\.d\.\'\)\ \[data\/IdnaTest\.txt\:232\]");
is(eval{to_unicode("U\x{0308}.xn--tda",	%p)}, "ü.ü",	"to_unicode\(\'U\\u0308\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:233\]");
is(eval{to_unicode("Ü.xn--tda",	%p)}, "ü.ü",	"to_unicode\(\'Ü\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:234\]");
is(eval{to_unicode("ü.xn--tda",	%p)}, "ü.ü",	"to_unicode\(\'ü\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:235\]");
is(eval{to_unicode("Ü.XN--TDA",	%p)}, "ü.ü",	"to_unicode\(\'Ü\.XN\-\-TDA\'\)\ \[data\/IdnaTest\.txt\:236\]");
is(eval{to_unicode("Ü.xn--Tda",	%p)}, "ü.ü",	"to_unicode\(\'Ü\.xn\-\-Tda\'\)\ \[data\/IdnaTest\.txt\:237\]");
is(eval{to_unicode("xn--tda.xn--tda",	%p)}, "ü.ü",	"to_unicode\(\'xn\-\-tda\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:238\]");
is(eval{to_unicode("XN--TDA.XN--TDA",	%p)}, "ü.ü",	"to_unicode\(\'XN\-\-TDA\.XN\-\-TDA\'\)\ \[data\/IdnaTest\.txt\:239\]");
is(eval{to_unicode("Xn--Tda.xn--Tda",	%p)}, "ü.ü",	"to_unicode\(\'Xn\-\-Tda\.xn\-\-Tda\'\)\ \[data\/IdnaTest\.txt\:240\]");
is(eval{to_unicode("ü.ü",	%p)}, "ü.ü",	"to_unicode\(\'ü\.ü\'\)\ \[data\/IdnaTest\.txt\:241\]");
is(eval{to_unicode("Ü.Ü",	%p)}, "ü.ü",	"to_unicode\(\'Ü\.Ü\'\)\ \[data\/IdnaTest\.txt\:242\]");
is(eval{to_unicode("Ü.ü",	%p)}, "ü.ü",	"to_unicode\(\'Ü\.ü\'\)\ \[data\/IdnaTest\.txt\:243\]");
is(eval{to_unicode("u\x{0308}.xn--tda",	%p)}, "ü.ü",	"to_unicode\(\'u\\u0308\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:244\]");
is(eval{to_unicode("U\x{0308}.XN--TDA",	%p)}, "ü.ü",	"to_unicode\(\'U\\u0308\.XN\-\-TDA\'\)\ \[data\/IdnaTest\.txt\:245\]");
is(eval{to_unicode("U\x{0308}.xn--Tda",	%p)}, "ü.ü",	"to_unicode\(\'U\\u0308\.xn\-\-Tda\'\)\ \[data\/IdnaTest\.txt\:246\]");
is(eval{to_unicode("xn--u-ccb",	%p)}, undef,	"to_unicode\(\'xn\-\-u\-ccb\'\)\ is\ error\ V1\ \[data\/IdnaTest\.txt\:247\]");
is(eval{to_unicode("XN--U-CCB",	%p)}, undef,	"to_unicode\(\'XN\-\-U\-CCB\'\)\ is\ error\ V1\ \[data\/IdnaTest\.txt\:248\]");
is(eval{to_unicode("Xn--U-Ccb",	%p)}, undef,	"to_unicode\(\'Xn\-\-U\-Ccb\'\)\ is\ error\ V1\ \[data\/IdnaTest\.txt\:249\]");
is(eval{to_unicode("a⒈com",	%p)}, undef,	"to_unicode\(\'a⒈com\'\)\ is\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:250\]");
is(eval{to_unicode("A⒈COM",	%p)}, undef,	"to_unicode\(\'A⒈COM\'\)\ is\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:251\]");
is(eval{to_unicode("A⒈Com",	%p)}, undef,	"to_unicode\(\'A⒈Com\'\)\ is\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:252\]");
is(eval{to_unicode("xn--a-ecp.ru",	%p)}, undef,	"to_unicode\(\'xn\-\-a\-ecp\.ru\'\)\ is\ error\ V6\ \[data\/IdnaTest\.txt\:253\]");
is(eval{to_unicode("XN--A-ECP.RU",	%p)}, undef,	"to_unicode\(\'XN\-\-A\-ECP\.RU\'\)\ is\ error\ V6\ \[data\/IdnaTest\.txt\:254\]");
is(eval{to_unicode("Xn--A-Ecp.ru",	%p)}, undef,	"to_unicode\(\'Xn\-\-A\-Ecp\.ru\'\)\ is\ error\ V6\ \[data\/IdnaTest\.txt\:255\]");
is(eval{to_unicode("xn--0.pt",	%p)}, undef,	"to_unicode\(\'xn\-\-0\.pt\'\)\ is\ error\ A3\ \[data\/IdnaTest\.txt\:256\]");
is(eval{to_unicode("XN--0.PT",	%p)}, undef,	"to_unicode\(\'XN\-\-0\.PT\'\)\ is\ error\ A3\ \[data\/IdnaTest\.txt\:257\]");
is(eval{to_unicode("Xn--0.Pt",	%p)}, undef,	"to_unicode\(\'Xn\-\-0\.Pt\'\)\ is\ error\ A3\ \[data\/IdnaTest\.txt\:258\]");
is(eval{to_unicode("xn--a.pt",	%p)}, undef,	"to_unicode\(\'xn\-\-a\.pt\'\)\ is\ error\ V6\ \[data\/IdnaTest\.txt\:259\]");
is(eval{to_unicode("XN--A.PT",	%p)}, undef,	"to_unicode\(\'XN\-\-A\.PT\'\)\ is\ error\ V6\ \[data\/IdnaTest\.txt\:260\]");
is(eval{to_unicode("Xn--A.pt",	%p)}, undef,	"to_unicode\(\'Xn\-\-A\.pt\'\)\ is\ error\ V6\ \[data\/IdnaTest\.txt\:261\]");
is(eval{to_unicode("xn--a-Ä.pt",	%p)}, undef,	"to_unicode\(\'xn\-\-a\-Ä\.pt\'\)\ is\ error\ A3\ \[data\/IdnaTest\.txt\:262\]");
is(eval{to_unicode("xn--a-ä.pt",	%p)}, undef,	"to_unicode\(\'xn\-\-a\-ä\.pt\'\)\ is\ error\ A3\ \[data\/IdnaTest\.txt\:263\]");
is(eval{to_unicode("XN--A-Ä.PT",	%p)}, undef,	"to_unicode\(\'XN\-\-A\-Ä\.PT\'\)\ is\ error\ A3\ \[data\/IdnaTest\.txt\:264\]");
is(eval{to_unicode("Xn--A-Ä.pt",	%p)}, undef,	"to_unicode\(\'Xn\-\-A\-Ä\.pt\'\)\ is\ error\ A3\ \[data\/IdnaTest\.txt\:265\]");
is(eval{to_unicode("日本語。ＪＰ",	%p)}, "日本語.jp",	"to_unicode\(\'日本語。ＪＰ\'\)\ \[data\/IdnaTest\.txt\:266\]");
is(eval{to_unicode("日本語。ｊｐ",	%p)}, "日本語.jp",	"to_unicode\(\'日本語。ｊｐ\'\)\ \[data\/IdnaTest\.txt\:267\]");
is(eval{to_unicode("日本語。Ｊｐ",	%p)}, "日本語.jp",	"to_unicode\(\'日本語。Ｊｐ\'\)\ \[data\/IdnaTest\.txt\:268\]");
is(eval{to_unicode("xn--wgv71a119e.jp",	%p)}, "日本語.jp",	"to_unicode\(\'xn\-\-wgv71a119e\.jp\'\)\ \[data\/IdnaTest\.txt\:269\]");
is(eval{to_unicode("XN--WGV71A119E.JP",	%p)}, "日本語.jp",	"to_unicode\(\'XN\-\-WGV71A119E\.JP\'\)\ \[data\/IdnaTest\.txt\:270\]");
is(eval{to_unicode("Xn--Wgv71a119e.jp",	%p)}, "日本語.jp",	"to_unicode\(\'Xn\-\-Wgv71a119e\.jp\'\)\ \[data\/IdnaTest\.txt\:271\]");
is(eval{to_unicode("日本語.jp",	%p)}, "日本語.jp",	"to_unicode\(\'日本語\.jp\'\)\ \[data\/IdnaTest\.txt\:272\]");
is(eval{to_unicode("日本語.JP",	%p)}, "日本語.jp",	"to_unicode\(\'日本語\.JP\'\)\ \[data\/IdnaTest\.txt\:273\]");
is(eval{to_unicode("日本語.Jp",	%p)}, "日本語.jp",	"to_unicode\(\'日本語\.Jp\'\)\ \[data\/IdnaTest\.txt\:274\]");
is(eval{to_unicode("☕",	%p)}, "☕",	"to_unicode\(\'☕\'\)\ \[data\/IdnaTest\.txt\:275\]");
is(eval{to_unicode("xn--53h",	%p)}, "☕",	"to_unicode\(\'xn\-\-53h\'\)\ \[data\/IdnaTest\.txt\:276\]");
is(eval{to_unicode("XN--53H",	%p)}, "☕",	"to_unicode\(\'XN\-\-53H\'\)\ \[data\/IdnaTest\.txt\:277\]");
is(eval{to_unicode("Xn--53H",	%p)}, "☕",	"to_unicode\(\'Xn\-\-53H\'\)\ \[data\/IdnaTest\.txt\:278\]");
is(eval{to_unicode("1.aß\x{200C}\x{200D}b\x{200C}\x{200D}cßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\x{0302}ßz",	%p)}, undef,	"to_unicode\(\'1\.aß\\u200C\\u200Db\\u200C\\u200Dcßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\\u0302ßz\'\)\ is\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:279\]");
is(eval{to_unicode("1.ASS\x{200C}\x{200D}B\x{200C}\x{200D}CSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSS\x{0302}SSZ",	%p)}, undef,	"to_unicode\(\'1\.ASS\\u200C\\u200DB\\u200C\\u200DCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSS\\u0302SSZ\'\)\ is\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:281\]");
is(eval{to_unicode("1.ASS\x{200C}\x{200D}B\x{200C}\x{200D}CSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ",	%p)}, undef,	"to_unicode\(\'1\.ASS\\u200C\\u200DB\\u200C\\u200DCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ\'\)\ is\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:283\]");
is(eval{to_unicode("1.ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz",	%p)}, undef,	"to_unicode\(\'1\.ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz\'\)\ is\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:285\]");
is(eval{to_unicode("1.Ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz",	%p)}, undef,	"to_unicode\(\'1\.Ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz\'\)\ is\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:287\]");
is(eval{to_unicode("1.ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\x{0302}ssz",	%p)}, undef,	"to_unicode\(\'1\.ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\\u0302ssz\'\)\ is\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:289\]");
is(eval{to_unicode("1.Ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\x{0302}ssz",	%p)}, undef,	"to_unicode\(\'1\.Ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\\u0302ssz\'\)\ is\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:291\]");
is(eval{to_unicode("1.Aß\x{200C}\x{200D}b\x{200C}\x{200D}cßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\x{0302}ßz",	%p)}, undef,	"to_unicode\(\'1\.Aß\\u200C\\u200Db\\u200C\\u200Dcßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\\u0302ßz\'\)\ is\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:293\]");
is(eval{to_unicode("\x{200C}x\x{200D}n\x{200C}-\x{200D}-bß",	%p)}, undef,	"to_unicode\(\'\\u200Cx\\u200Dn\\u200C\-\\u200D\-bß\'\)\ is\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:295\]");
is(eval{to_unicode("\x{200C}X\x{200D}N\x{200C}-\x{200D}-BSS",	%p)}, undef,	"to_unicode\(\'\\u200CX\\u200DN\\u200C\-\\u200D\-BSS\'\)\ is\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:297\]");
is(eval{to_unicode("\x{200C}x\x{200D}n\x{200C}-\x{200D}-bss",	%p)}, undef,	"to_unicode\(\'\\u200Cx\\u200Dn\\u200C\-\\u200D\-bss\'\)\ is\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:299\]");
is(eval{to_unicode("\x{200C}X\x{200D}n\x{200C}-\x{200D}-Bss",	%p)}, undef,	"to_unicode\(\'\\u200CX\\u200Dn\\u200C\-\\u200D\-Bss\'\)\ is\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:301\]");
is(eval{to_unicode("xn--bss",	%p)}, "夙",	"to_unicode\(\'xn\-\-bss\'\)\ \[data\/IdnaTest\.txt\:303\]");
is(eval{to_unicode("XN--BSS",	%p)}, "夙",	"to_unicode\(\'XN\-\-BSS\'\)\ \[data\/IdnaTest\.txt\:304\]");
is(eval{to_unicode("Xn--Bss",	%p)}, "夙",	"to_unicode\(\'Xn\-\-Bss\'\)\ \[data\/IdnaTest\.txt\:305\]");
is(eval{to_unicode("夙",	%p)}, "夙",	"to_unicode\(\'夙\'\)\ \[data\/IdnaTest\.txt\:306\]");
is(eval{to_unicode("\x{200C}X\x{200D}n\x{200C}-\x{200D}-Bß",	%p)}, undef,	"to_unicode\(\'\\u200CX\\u200Dn\\u200C\-\\u200D\-Bß\'\)\ is\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:307\]");
is(eval{to_unicode("ˣ\x{034F}ℕ\x{200B}﹣\x{00AD}－\x{180C}ℬ\x{FE00}ſ\x{2064}𝔰\x{E01EF}ﬄ",	%p)}, "夡夞夜夙",	"to_unicode\(\'ˣ\\u034Fℕ\\u200B﹣\\u00AD－\\u180Cℬ\\uFE00ſ\\u2064𝔰\\uDB40\\uDDEFﬄ\'\)\ \[data\/IdnaTest\.txt\:309\]");
is(eval{to_unicode("ˣ\x{034F}ℕ\x{200B}﹣\x{00AD}－\x{180C}ℬ\x{FE00}S\x{2064}𝔰\x{E01EF}FFL",	%p)}, "夡夞夜夙",	"to_unicode\(\'ˣ\\u034Fℕ\\u200B﹣\\u00AD－\\u180Cℬ\\uFE00S\\u2064𝔰\\uDB40\\uDDEFFFL\'\)\ \[data\/IdnaTest\.txt\:310\]");
is(eval{to_unicode("ˣ\x{034F}ℕ\x{200B}﹣\x{00AD}－\x{180C}ℬ\x{FE00}s\x{2064}𝔰\x{E01EF}ffl",	%p)}, "夡夞夜夙",	"to_unicode\(\'ˣ\\u034Fℕ\\u200B﹣\\u00AD－\\u180Cℬ\\uFE00s\\u2064𝔰\\uDB40\\uDDEFffl\'\)\ \[data\/IdnaTest\.txt\:311\]");
is(eval{to_unicode("xn--bssffl",	%p)}, "夡夞夜夙",	"to_unicode\(\'xn\-\-bssffl\'\)\ \[data\/IdnaTest\.txt\:312\]");
is(eval{to_unicode("XN--BSSFFL",	%p)}, "夡夞夜夙",	"to_unicode\(\'XN\-\-BSSFFL\'\)\ \[data\/IdnaTest\.txt\:313\]");
is(eval{to_unicode("Xn--Bssffl",	%p)}, "夡夞夜夙",	"to_unicode\(\'Xn\-\-Bssffl\'\)\ \[data\/IdnaTest\.txt\:314\]");
is(eval{to_unicode("夡夞夜夙",	%p)}, "夡夞夜夙",	"to_unicode\(\'夡夞夜夙\'\)\ \[data\/IdnaTest\.txt\:315\]");
is(eval{to_unicode("123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	%p)}, "123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:316\]");
is(eval{to_unicode("123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	%p)}, "123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:317\]");
is(eval{to_unicode("123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012",	%p)}, "123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ \[data\/IdnaTest\.txt\:318\]");
is(eval{to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890",	%p)}, "123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901234\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ \[data\/IdnaTest\.txt\:319\]");
is(eval{to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.",	%p)}, "123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901234\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ \[data\/IdnaTest\.txt\:320\]");
is(eval{to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	%p)}, "123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901234\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:321\]");
is(eval{to_unicode("ä1234567890123456789012345678901234567890123456789012345",	%p)}, "ä1234567890123456789012345678901234567890123456789012345",	"to_unicode\(\'ä1234567890123456789012345678901234567890123456789012345\'\)\ \[data\/IdnaTest\.txt\:322\]");
is(eval{to_unicode("Ä1234567890123456789012345678901234567890123456789012345",	%p)}, "ä1234567890123456789012345678901234567890123456789012345",	"to_unicode\(\'Ä1234567890123456789012345678901234567890123456789012345\'\)\ \[data\/IdnaTest\.txt\:323\]");
is(eval{to_unicode("xn--1234567890123456789012345678901234567890123456789012345-9te",	%p)}, "ä1234567890123456789012345678901234567890123456789012345",	"to_unicode\(\'xn\-\-1234567890123456789012345678901234567890123456789012345\-9te\'\)\ \[data\/IdnaTest\.txt\:324\]");
is(eval{to_unicode("XN--1234567890123456789012345678901234567890123456789012345-9TE",	%p)}, "ä1234567890123456789012345678901234567890123456789012345",	"to_unicode\(\'XN\-\-1234567890123456789012345678901234567890123456789012345\-9TE\'\)\ \[data\/IdnaTest\.txt\:325\]");
is(eval{to_unicode("Xn--1234567890123456789012345678901234567890123456789012345-9Te",	%p)}, "ä1234567890123456789012345678901234567890123456789012345",	"to_unicode\(\'Xn\-\-1234567890123456789012345678901234567890123456789012345\-9Te\'\)\ \[data\/IdnaTest\.txt\:326\]");
is(eval{to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	%p)}, "123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:327\]");
is(eval{to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	%p)}, "123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:328\]");
is(eval{to_unicode("123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	%p)}, "123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.xn\-\-1234567890123456789012345678901234567890123456789012345\-kue\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:329\]");
is(eval{to_unicode("123456789012345678901234567890123456789012345678901234567890123.XN--1234567890123456789012345678901234567890123456789012345-KUE.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	%p)}, "123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.XN\-\-1234567890123456789012345678901234567890123456789012345\-KUE\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:330\]");
is(eval{to_unicode("123456789012345678901234567890123456789012345678901234567890123.Xn--1234567890123456789012345678901234567890123456789012345-Kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	%p)}, "123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.Xn\-\-1234567890123456789012345678901234567890123456789012345\-Kue\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:331\]");
is(eval{to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	%p)}, "123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:332\]");
is(eval{to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	%p)}, "123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:333\]");
is(eval{to_unicode("123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	%p)}, "123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.xn\-\-1234567890123456789012345678901234567890123456789012345\-kue\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:334\]");
is(eval{to_unicode("123456789012345678901234567890123456789012345678901234567890123.XN--1234567890123456789012345678901234567890123456789012345-KUE.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	%p)}, "123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.XN\-\-1234567890123456789012345678901234567890123456789012345\-KUE\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:335\]");
is(eval{to_unicode("123456789012345678901234567890123456789012345678901234567890123.Xn--1234567890123456789012345678901234567890123456789012345-Kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	%p)}, "123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.Xn\-\-1234567890123456789012345678901234567890123456789012345\-Kue\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:336\]");
is(eval{to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012",	%p)}, "123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ \[data\/IdnaTest\.txt\:337\]");
is(eval{to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012",	%p)}, "123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ \[data\/IdnaTest\.txt\:338\]");
is(eval{to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890",	%p)}, "123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ \[data\/IdnaTest\.txt\:339\]");
is(eval{to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890",	%p)}, "123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ \[data\/IdnaTest\.txt\:340\]");
is(eval{to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.",	%p)}, "123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ \[data\/IdnaTest\.txt\:341\]");
is(eval{to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.",	%p)}, "123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ \[data\/IdnaTest\.txt\:342\]");
is(eval{to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	%p)}, "123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:343\]");
is(eval{to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	%p)}, "123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:344\]");
is(eval{to_unicode("a.b..-q--a-.e",	%p)}, undef,	"to_unicode\(\'a\.b\.\.\-q\-\-a\-\.e\'\)\ is\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:345\]");
is(eval{to_unicode("A.B..-Q--A-.E",	%p)}, undef,	"to_unicode\(\'A\.B\.\.\-Q\-\-A\-\.E\'\)\ is\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:346\]");
is(eval{to_unicode("A.b..-Q--A-.E",	%p)}, undef,	"to_unicode\(\'A\.b\.\.\-Q\-\-A\-\.E\'\)\ is\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:347\]");
is(eval{to_unicode("a.b..-q--ä-.e",	%p)}, undef,	"to_unicode\(\'a\.b\.\.\-q\-\-ä\-\.e\'\)\ is\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:348\]");
is(eval{to_unicode("A.B..-Q--Ä-.E",	%p)}, undef,	"to_unicode\(\'A\.B\.\.\-Q\-\-Ä\-\.E\'\)\ is\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:349\]");
is(eval{to_unicode("A.b..-Q--Ä-.E",	%p)}, undef,	"to_unicode\(\'A\.b\.\.\-Q\-\-Ä\-\.E\'\)\ is\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:350\]");
is(eval{to_unicode("a.b..xn---q----jra.e",	%p)}, undef,	"to_unicode\(\'a\.b\.\.xn\-\-\-q\-\-\-\-jra\.e\'\)\ is\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:351\]");
is(eval{to_unicode("A.B..XN---Q----JRA.E",	%p)}, undef,	"to_unicode\(\'A\.B\.\.XN\-\-\-Q\-\-\-\-JRA\.E\'\)\ is\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:352\]");
is(eval{to_unicode("A.b..Xn---Q----Jra.e",	%p)}, undef,	"to_unicode\(\'A\.b\.\.Xn\-\-\-Q\-\-\-\-Jra\.e\'\)\ is\ error\ V2\ V3\ \[data\/IdnaTest\.txt\:353\]");
is(eval{to_unicode("a..c",	%p)}, "a..c",	"to_unicode\(\'a\.\.c\'\)\ \[data\/IdnaTest\.txt\:354\]");
is(eval{to_unicode("A..C",	%p)}, "a..c",	"to_unicode\(\'A\.\.C\'\)\ \[data\/IdnaTest\.txt\:355\]");
is(eval{to_unicode("a.-b.",	%p)}, undef,	"to_unicode\(\'a\.\-b\.\'\)\ is\ error\ V3\ \[data\/IdnaTest\.txt\:356\]");
is(eval{to_unicode("A.-B.",	%p)}, undef,	"to_unicode\(\'A\.\-B\.\'\)\ is\ error\ V3\ \[data\/IdnaTest\.txt\:357\]");
is(eval{to_unicode("a.b-.c",	%p)}, undef,	"to_unicode\(\'a\.b\-\.c\'\)\ is\ error\ V3\ \[data\/IdnaTest\.txt\:358\]");
is(eval{to_unicode("A.B-.C",	%p)}, undef,	"to_unicode\(\'A\.B\-\.C\'\)\ is\ error\ V3\ \[data\/IdnaTest\.txt\:359\]");
is(eval{to_unicode("A.b-.C",	%p)}, undef,	"to_unicode\(\'A\.b\-\.C\'\)\ is\ error\ V3\ \[data\/IdnaTest\.txt\:360\]");
is(eval{to_unicode("a.-.c",	%p)}, undef,	"to_unicode\(\'a\.\-\.c\'\)\ is\ error\ V3\ \[data\/IdnaTest\.txt\:361\]");
is(eval{to_unicode("A.-.C",	%p)}, undef,	"to_unicode\(\'A\.\-\.C\'\)\ is\ error\ V3\ \[data\/IdnaTest\.txt\:362\]");
is(eval{to_unicode("a.bc--de.f",	%p)}, undef,	"to_unicode\(\'a\.bc\-\-de\.f\'\)\ is\ error\ V2\ \[data\/IdnaTest\.txt\:363\]");
is(eval{to_unicode("A.BC--DE.F",	%p)}, undef,	"to_unicode\(\'A\.BC\-\-DE\.F\'\)\ is\ error\ V2\ \[data\/IdnaTest\.txt\:364\]");
is(eval{to_unicode("A.bc--De.f",	%p)}, undef,	"to_unicode\(\'A\.bc\-\-De\.f\'\)\ is\ error\ V2\ \[data\/IdnaTest\.txt\:365\]");
is(eval{to_unicode("ä.\x{00AD}.c",	%p)}, "ä..c",	"to_unicode\(\'ä\.\\u00AD\.c\'\)\ \[data\/IdnaTest\.txt\:366\]");
is(eval{to_unicode("Ä.\x{00AD}.C",	%p)}, "ä..c",	"to_unicode\(\'Ä\.\\u00AD\.C\'\)\ \[data\/IdnaTest\.txt\:367\]");
is(eval{to_unicode("ä..c",	%p)}, "ä..c",	"to_unicode\(\'ä\.\.c\'\)\ \[data\/IdnaTest\.txt\:368\]");
is(eval{to_unicode("Ä..C",	%p)}, "ä..c",	"to_unicode\(\'Ä\.\.C\'\)\ \[data\/IdnaTest\.txt\:369\]");
is(eval{to_unicode("ä.-b.",	%p)}, undef,	"to_unicode\(\'ä\.\-b\.\'\)\ is\ error\ V3\ \[data\/IdnaTest\.txt\:370\]");
is(eval{to_unicode("Ä.-B.",	%p)}, undef,	"to_unicode\(\'Ä\.\-B\.\'\)\ is\ error\ V3\ \[data\/IdnaTest\.txt\:371\]");
is(eval{to_unicode("ä.b-.c",	%p)}, undef,	"to_unicode\(\'ä\.b\-\.c\'\)\ is\ error\ V3\ \[data\/IdnaTest\.txt\:372\]");
is(eval{to_unicode("Ä.B-.C",	%p)}, undef,	"to_unicode\(\'Ä\.B\-\.C\'\)\ is\ error\ V3\ \[data\/IdnaTest\.txt\:373\]");
is(eval{to_unicode("Ä.b-.C",	%p)}, undef,	"to_unicode\(\'Ä\.b\-\.C\'\)\ is\ error\ V3\ \[data\/IdnaTest\.txt\:374\]");
is(eval{to_unicode("ä.-.c",	%p)}, undef,	"to_unicode\(\'ä\.\-\.c\'\)\ is\ error\ V3\ \[data\/IdnaTest\.txt\:375\]");
is(eval{to_unicode("Ä.-.C",	%p)}, undef,	"to_unicode\(\'Ä\.\-\.C\'\)\ is\ error\ V3\ \[data\/IdnaTest\.txt\:376\]");
is(eval{to_unicode("ä.bc--de.f",	%p)}, undef,	"to_unicode\(\'ä\.bc\-\-de\.f\'\)\ is\ error\ V2\ \[data\/IdnaTest\.txt\:377\]");
is(eval{to_unicode("Ä.BC--DE.F",	%p)}, undef,	"to_unicode\(\'Ä\.BC\-\-DE\.F\'\)\ is\ error\ V2\ \[data\/IdnaTest\.txt\:378\]");
is(eval{to_unicode("Ä.bc--De.f",	%p)}, undef,	"to_unicode\(\'Ä\.bc\-\-De\.f\'\)\ is\ error\ V2\ \[data\/IdnaTest\.txt\:379\]");
is(eval{to_unicode("a.b.\x{0308}c.d",	%p)}, undef,	"to_unicode\(\'a\.b\.\\u0308c\.d\'\)\ is\ error\ V5\ \[data\/IdnaTest\.txt\:380\]");
is(eval{to_unicode("A.B.\x{0308}C.D",	%p)}, undef,	"to_unicode\(\'A\.B\.\\u0308C\.D\'\)\ is\ error\ V5\ \[data\/IdnaTest\.txt\:381\]");
is(eval{to_unicode("A.b.\x{0308}c.d",	%p)}, undef,	"to_unicode\(\'A\.b\.\\u0308c\.d\'\)\ is\ error\ V5\ \[data\/IdnaTest\.txt\:382\]");
is(eval{to_unicode("a.b.xn--c-bcb.d",	%p)}, undef,	"to_unicode\(\'a\.b\.xn\-\-c\-bcb\.d\'\)\ is\ error\ V5\ \[data\/IdnaTest\.txt\:383\]");
is(eval{to_unicode("A.B.XN--C-BCB.D",	%p)}, undef,	"to_unicode\(\'A\.B\.XN\-\-C\-BCB\.D\'\)\ is\ error\ V5\ \[data\/IdnaTest\.txt\:384\]");
is(eval{to_unicode("A.b.xn--C-Bcb.d",	%p)}, undef,	"to_unicode\(\'A\.b\.xn\-\-C\-Bcb\.d\'\)\ is\ error\ V5\ \[data\/IdnaTest\.txt\:385\]");
is(eval{to_unicode("A0",	%p)}, "a0",	"to_unicode\(\'A0\'\)\ \[data\/IdnaTest\.txt\:386\]");
is(eval{to_unicode("a0",	%p)}, "a0",	"to_unicode\(\'a0\'\)\ \[data\/IdnaTest\.txt\:387\]");
is(eval{to_unicode("0A",	%p)}, "0a",	"to_unicode\(\'0A\'\)\ \[data\/IdnaTest\.txt\:388\]");
is(eval{to_unicode("0a",	%p)}, "0a",	"to_unicode\(\'0a\'\)\ \[data\/IdnaTest\.txt\:389\]");
is(eval{to_unicode("0A.\x{05D0}",	%p)}, undef,	"to_unicode\(\'0A\.\\u05D0\'\)\ is\ error\ B1\ \[data\/IdnaTest\.txt\:390\]");
is(eval{to_unicode("0a.\x{05D0}",	%p)}, undef,	"to_unicode\(\'0a\.\\u05D0\'\)\ is\ error\ B1\ \[data\/IdnaTest\.txt\:391\]");
is(eval{to_unicode("c.xn--0-eha.xn--4db",	%p)}, undef,	"to_unicode\(\'c\.xn\-\-0\-eha\.xn\-\-4db\'\)\ is\ error\ B1\ \[data\/IdnaTest\.txt\:392\]");
is(eval{to_unicode("C.XN--0-EHA.XN--4DB",	%p)}, undef,	"to_unicode\(\'C\.XN\-\-0\-EHA\.XN\-\-4DB\'\)\ is\ error\ B1\ \[data\/IdnaTest\.txt\:393\]");
is(eval{to_unicode("C.xn--0-Eha.xn--4Db",	%p)}, undef,	"to_unicode\(\'C\.xn\-\-0\-Eha\.xn\-\-4Db\'\)\ is\ error\ B1\ \[data\/IdnaTest\.txt\:394\]");
is(eval{to_unicode("b-.\x{05D0}",	%p)}, undef,	"to_unicode\(\'b\-\.\\u05D0\'\)\ is\ error\ V3\ B6\ \[data\/IdnaTest\.txt\:395\]");
is(eval{to_unicode("B-.\x{05D0}",	%p)}, undef,	"to_unicode\(\'B\-\.\\u05D0\'\)\ is\ error\ V3\ B6\ \[data\/IdnaTest\.txt\:396\]");
is(eval{to_unicode("d.xn----dha.xn--4db",	%p)}, undef,	"to_unicode\(\'d\.xn\-\-\-\-dha\.xn\-\-4db\'\)\ is\ error\ V3\ B6\ \[data\/IdnaTest\.txt\:397\]");
is(eval{to_unicode("D.XN----DHA.XN--4DB",	%p)}, undef,	"to_unicode\(\'D\.XN\-\-\-\-DHA\.XN\-\-4DB\'\)\ is\ error\ V3\ B6\ \[data\/IdnaTest\.txt\:398\]");
is(eval{to_unicode("D.xn----Dha.xn--4Db",	%p)}, undef,	"to_unicode\(\'D\.xn\-\-\-\-Dha\.xn\-\-4Db\'\)\ is\ error\ V3\ B6\ \[data\/IdnaTest\.txt\:399\]");
is(eval{to_unicode("a\x{05D0}",	%p)}, undef,	"to_unicode\(\'a\\u05D0\'\)\ is\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:400\]");
is(eval{to_unicode("A\x{05D0}",	%p)}, undef,	"to_unicode\(\'A\\u05D0\'\)\ is\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:401\]");
is(eval{to_unicode("\x{05D0}\x{05C7}",	%p)}, "\x{05D0}\x{05C7}",	"to_unicode\(\'\\u05D0\\u05C7\'\)\ \[data\/IdnaTest\.txt\:402\]");
is(eval{to_unicode("xn--vdbr",	%p)}, "\x{05D0}\x{05C7}",	"to_unicode\(\'xn\-\-vdbr\'\)\ \[data\/IdnaTest\.txt\:403\]");
is(eval{to_unicode("XN--VDBR",	%p)}, "\x{05D0}\x{05C7}",	"to_unicode\(\'XN\-\-VDBR\'\)\ \[data\/IdnaTest\.txt\:404\]");
is(eval{to_unicode("Xn--Vdbr",	%p)}, "\x{05D0}\x{05C7}",	"to_unicode\(\'Xn\-\-Vdbr\'\)\ \[data\/IdnaTest\.txt\:405\]");
is(eval{to_unicode("\x{05D0}9\x{05C7}",	%p)}, "\x{05D0}9\x{05C7}",	"to_unicode\(\'\\u05D09\\u05C7\'\)\ \[data\/IdnaTest\.txt\:406\]");
is(eval{to_unicode("xn--9-ihcz",	%p)}, "\x{05D0}9\x{05C7}",	"to_unicode\(\'xn\-\-9\-ihcz\'\)\ \[data\/IdnaTest\.txt\:407\]");
is(eval{to_unicode("XN--9-IHCZ",	%p)}, "\x{05D0}9\x{05C7}",	"to_unicode\(\'XN\-\-9\-IHCZ\'\)\ \[data\/IdnaTest\.txt\:408\]");
is(eval{to_unicode("Xn--9-Ihcz",	%p)}, "\x{05D0}9\x{05C7}",	"to_unicode\(\'Xn\-\-9\-Ihcz\'\)\ \[data\/IdnaTest\.txt\:409\]");
is(eval{to_unicode("\x{05D0}a\x{05C7}",	%p)}, undef,	"to_unicode\(\'\\u05D0a\\u05C7\'\)\ is\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:410\]");
is(eval{to_unicode("\x{05D0}A\x{05C7}",	%p)}, undef,	"to_unicode\(\'\\u05D0A\\u05C7\'\)\ is\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:411\]");
is(eval{to_unicode("\x{05D0}\x{05EA}",	%p)}, "\x{05D0}\x{05EA}",	"to_unicode\(\'\\u05D0\\u05EA\'\)\ \[data\/IdnaTest\.txt\:412\]");
is(eval{to_unicode("xn--4db6c",	%p)}, "\x{05D0}\x{05EA}",	"to_unicode\(\'xn\-\-4db6c\'\)\ \[data\/IdnaTest\.txt\:413\]");
is(eval{to_unicode("XN--4DB6C",	%p)}, "\x{05D0}\x{05EA}",	"to_unicode\(\'XN\-\-4DB6C\'\)\ \[data\/IdnaTest\.txt\:414\]");
is(eval{to_unicode("Xn--4Db6c",	%p)}, "\x{05D0}\x{05EA}",	"to_unicode\(\'Xn\-\-4Db6c\'\)\ \[data\/IdnaTest\.txt\:415\]");
is(eval{to_unicode("\x{05D0}\x{05F3}\x{05EA}",	%p)}, "\x{05D0}\x{05F3}\x{05EA}",	"to_unicode\(\'\\u05D0\\u05F3\\u05EA\'\)\ \[data\/IdnaTest\.txt\:416\]");
is(eval{to_unicode("xn--4db6c0a",	%p)}, "\x{05D0}\x{05F3}\x{05EA}",	"to_unicode\(\'xn\-\-4db6c0a\'\)\ \[data\/IdnaTest\.txt\:417\]");
is(eval{to_unicode("XN--4DB6C0A",	%p)}, "\x{05D0}\x{05F3}\x{05EA}",	"to_unicode\(\'XN\-\-4DB6C0A\'\)\ \[data\/IdnaTest\.txt\:418\]");
is(eval{to_unicode("Xn--4Db6c0a",	%p)}, "\x{05D0}\x{05F3}\x{05EA}",	"to_unicode\(\'Xn\-\-4Db6c0a\'\)\ \[data\/IdnaTest\.txt\:419\]");
is(eval{to_unicode("a\x{05D0}Tz",	%p)}, undef,	"to_unicode\(\'a\\u05D0Tz\'\)\ is\ error\ B5\ \[data\/IdnaTest\.txt\:420\]");
is(eval{to_unicode("a\x{05D0}tz",	%p)}, undef,	"to_unicode\(\'a\\u05D0tz\'\)\ is\ error\ B5\ \[data\/IdnaTest\.txt\:421\]");
is(eval{to_unicode("A\x{05D0}TZ",	%p)}, undef,	"to_unicode\(\'A\\u05D0TZ\'\)\ is\ error\ B5\ \[data\/IdnaTest\.txt\:422\]");
is(eval{to_unicode("A\x{05D0}tz",	%p)}, undef,	"to_unicode\(\'A\\u05D0tz\'\)\ is\ error\ B5\ \[data\/IdnaTest\.txt\:423\]");
is(eval{to_unicode("\x{05D0}T\x{05EA}",	%p)}, undef,	"to_unicode\(\'\\u05D0T\\u05EA\'\)\ is\ error\ B2\ \[data\/IdnaTest\.txt\:424\]");
is(eval{to_unicode("\x{05D0}t\x{05EA}",	%p)}, undef,	"to_unicode\(\'\\u05D0t\\u05EA\'\)\ is\ error\ B2\ \[data\/IdnaTest\.txt\:425\]");
is(eval{to_unicode("\x{05D0}7\x{05EA}",	%p)}, "\x{05D0}7\x{05EA}",	"to_unicode\(\'\\u05D07\\u05EA\'\)\ \[data\/IdnaTest\.txt\:426\]");
is(eval{to_unicode("xn--7-zhc3f",	%p)}, "\x{05D0}7\x{05EA}",	"to_unicode\(\'xn\-\-7\-zhc3f\'\)\ \[data\/IdnaTest\.txt\:427\]");
is(eval{to_unicode("XN--7-ZHC3F",	%p)}, "\x{05D0}7\x{05EA}",	"to_unicode\(\'XN\-\-7\-ZHC3F\'\)\ \[data\/IdnaTest\.txt\:428\]");
is(eval{to_unicode("Xn--7-Zhc3f",	%p)}, "\x{05D0}7\x{05EA}",	"to_unicode\(\'Xn\-\-7\-Zhc3f\'\)\ \[data\/IdnaTest\.txt\:429\]");
is(eval{to_unicode("\x{05D0}\x{0667}\x{05EA}",	%p)}, "\x{05D0}\x{0667}\x{05EA}",	"to_unicode\(\'\\u05D0\\u0667\\u05EA\'\)\ \[data\/IdnaTest\.txt\:430\]");
is(eval{to_unicode("xn--4db6c6t",	%p)}, "\x{05D0}\x{0667}\x{05EA}",	"to_unicode\(\'xn\-\-4db6c6t\'\)\ \[data\/IdnaTest\.txt\:431\]");
is(eval{to_unicode("XN--4DB6C6T",	%p)}, "\x{05D0}\x{0667}\x{05EA}",	"to_unicode\(\'XN\-\-4DB6C6T\'\)\ \[data\/IdnaTest\.txt\:432\]");
is(eval{to_unicode("Xn--4Db6c6t",	%p)}, "\x{05D0}\x{0667}\x{05EA}",	"to_unicode\(\'Xn\-\-4Db6c6t\'\)\ \[data\/IdnaTest\.txt\:433\]");
is(eval{to_unicode("a7\x{0667}z",	%p)}, undef,	"to_unicode\(\'a7\\u0667z\'\)\ is\ error\ B5\ \[data\/IdnaTest\.txt\:434\]");
is(eval{to_unicode("A7\x{0667}Z",	%p)}, undef,	"to_unicode\(\'A7\\u0667Z\'\)\ is\ error\ B5\ \[data\/IdnaTest\.txt\:435\]");
is(eval{to_unicode("A7\x{0667}z",	%p)}, undef,	"to_unicode\(\'A7\\u0667z\'\)\ is\ error\ B5\ \[data\/IdnaTest\.txt\:436\]");
is(eval{to_unicode("\x{05D0}7\x{0667}\x{05EA}",	%p)}, undef,	"to_unicode\(\'\\u05D07\\u0667\\u05EA\'\)\ is\ error\ B4\ \[data\/IdnaTest\.txt\:437\]");
is(eval{to_unicode("ஹ\x{0BCD}\x{200D}",	%p)}, "ஹ\x{0BCD}\x{200D}",	"to_unicode\(\'ஹ\\u0BCD\\u200D\'\)\ \[data\/IdnaTest\.txt\:438\]");
is(eval{to_unicode("xn--dmc4b",	%p)}, "ஹ\x{0BCD}",	"to_unicode\(\'xn\-\-dmc4b\'\)\ \[data\/IdnaTest\.txt\:440\]");
is(eval{to_unicode("XN--DMC4B",	%p)}, "ஹ\x{0BCD}",	"to_unicode\(\'XN\-\-DMC4B\'\)\ \[data\/IdnaTest\.txt\:441\]");
is(eval{to_unicode("Xn--Dmc4b",	%p)}, "ஹ\x{0BCD}",	"to_unicode\(\'Xn\-\-Dmc4b\'\)\ \[data\/IdnaTest\.txt\:442\]");
is(eval{to_unicode("ஹ\x{0BCD}",	%p)}, "ஹ\x{0BCD}",	"to_unicode\(\'ஹ\\u0BCD\'\)\ \[data\/IdnaTest\.txt\:443\]");
is(eval{to_unicode("xn--dmc4b194h",	%p)}, "ஹ\x{0BCD}\x{200D}",	"to_unicode\(\'xn\-\-dmc4b194h\'\)\ \[data\/IdnaTest\.txt\:444\]");
is(eval{to_unicode("XN--DMC4B194H",	%p)}, "ஹ\x{0BCD}\x{200D}",	"to_unicode\(\'XN\-\-DMC4B194H\'\)\ \[data\/IdnaTest\.txt\:445\]");
is(eval{to_unicode("Xn--Dmc4b194h",	%p)}, "ஹ\x{0BCD}\x{200D}",	"to_unicode\(\'Xn\-\-Dmc4b194h\'\)\ \[data\/IdnaTest\.txt\:446\]");
is(eval{to_unicode("ஹ\x{200D}",	%p)}, undef,	"to_unicode\(\'ஹ\\u200D\'\)\ is\ error\ C2\ \[data\/IdnaTest\.txt\:447\]");
is(eval{to_unicode("xn--dmc",	%p)}, "ஹ",	"to_unicode\(\'xn\-\-dmc\'\)\ \[data\/IdnaTest\.txt\:449\]");
is(eval{to_unicode("XN--DMC",	%p)}, "ஹ",	"to_unicode\(\'XN\-\-DMC\'\)\ \[data\/IdnaTest\.txt\:450\]");
is(eval{to_unicode("Xn--Dmc",	%p)}, "ஹ",	"to_unicode\(\'Xn\-\-Dmc\'\)\ \[data\/IdnaTest\.txt\:451\]");
is(eval{to_unicode("ஹ",	%p)}, "ஹ",	"to_unicode\(\'ஹ\'\)\ \[data\/IdnaTest\.txt\:452\]");
is(eval{to_unicode("\x{200D}",	%p)}, undef,	"to_unicode\(\'\\u200D\'\)\ is\ error\ C2\ \[data\/IdnaTest\.txt\:453\]");
is(eval{to_unicode("",	%p)}, "",	"to_unicode\(\'\'\)\ \[data\/IdnaTest\.txt\:455\]");
is(eval{to_unicode("ஹ\x{0BCD}\x{200C}",	%p)}, "ஹ\x{0BCD}\x{200C}",	"to_unicode\(\'ஹ\\u0BCD\\u200C\'\)\ \[data\/IdnaTest\.txt\:456\]");
is(eval{to_unicode("xn--dmc4by94h",	%p)}, "ஹ\x{0BCD}\x{200C}",	"to_unicode\(\'xn\-\-dmc4by94h\'\)\ \[data\/IdnaTest\.txt\:458\]");
is(eval{to_unicode("XN--DMC4BY94H",	%p)}, "ஹ\x{0BCD}\x{200C}",	"to_unicode\(\'XN\-\-DMC4BY94H\'\)\ \[data\/IdnaTest\.txt\:459\]");
is(eval{to_unicode("Xn--Dmc4by94h",	%p)}, "ஹ\x{0BCD}\x{200C}",	"to_unicode\(\'Xn\-\-Dmc4by94h\'\)\ \[data\/IdnaTest\.txt\:460\]");
is(eval{to_unicode("ஹ\x{200C}",	%p)}, undef,	"to_unicode\(\'ஹ\\u200C\'\)\ is\ error\ C1\ \[data\/IdnaTest\.txt\:461\]");
is(eval{to_unicode("\x{200C}",	%p)}, undef,	"to_unicode\(\'\\u200C\'\)\ is\ error\ C1\ \[data\/IdnaTest\.txt\:463\]");
is(eval{to_unicode("\x{0644}\x{0670}\x{200C}\x{06ED}\x{06EF}",	%p)}, "\x{0644}\x{0670}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'\\u0644\\u0670\\u200C\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:465\]");
is(eval{to_unicode("xn--ghb2gxqia",	%p)}, "\x{0644}\x{0670}\x{06ED}\x{06EF}",	"to_unicode\(\'xn\-\-ghb2gxqia\'\)\ \[data\/IdnaTest\.txt\:467\]");
is(eval{to_unicode("XN--GHB2GXQIA",	%p)}, "\x{0644}\x{0670}\x{06ED}\x{06EF}",	"to_unicode\(\'XN\-\-GHB2GXQIA\'\)\ \[data\/IdnaTest\.txt\:468\]");
is(eval{to_unicode("Xn--Ghb2gxqia",	%p)}, "\x{0644}\x{0670}\x{06ED}\x{06EF}",	"to_unicode\(\'Xn\-\-Ghb2gxqia\'\)\ \[data\/IdnaTest\.txt\:469\]");
is(eval{to_unicode("\x{0644}\x{0670}\x{06ED}\x{06EF}",	%p)}, "\x{0644}\x{0670}\x{06ED}\x{06EF}",	"to_unicode\(\'\\u0644\\u0670\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:470\]");
is(eval{to_unicode("xn--ghb2gxqia7523a",	%p)}, "\x{0644}\x{0670}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'xn\-\-ghb2gxqia7523a\'\)\ \[data\/IdnaTest\.txt\:471\]");
is(eval{to_unicode("XN--GHB2GXQIA7523A",	%p)}, "\x{0644}\x{0670}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'XN\-\-GHB2GXQIA7523A\'\)\ \[data\/IdnaTest\.txt\:472\]");
is(eval{to_unicode("Xn--Ghb2gxqia7523a",	%p)}, "\x{0644}\x{0670}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'Xn\-\-Ghb2gxqia7523a\'\)\ \[data\/IdnaTest\.txt\:473\]");
is(eval{to_unicode("\x{0644}\x{0670}\x{200C}\x{06EF}",	%p)}, "\x{0644}\x{0670}\x{200C}\x{06EF}",	"to_unicode\(\'\\u0644\\u0670\\u200C\\u06EF\'\)\ \[data\/IdnaTest\.txt\:474\]");
is(eval{to_unicode("xn--ghb2g3q",	%p)}, "\x{0644}\x{0670}\x{06EF}",	"to_unicode\(\'xn\-\-ghb2g3q\'\)\ \[data\/IdnaTest\.txt\:476\]");
is(eval{to_unicode("XN--GHB2G3Q",	%p)}, "\x{0644}\x{0670}\x{06EF}",	"to_unicode\(\'XN\-\-GHB2G3Q\'\)\ \[data\/IdnaTest\.txt\:477\]");
is(eval{to_unicode("Xn--Ghb2g3q",	%p)}, "\x{0644}\x{0670}\x{06EF}",	"to_unicode\(\'Xn\-\-Ghb2g3q\'\)\ \[data\/IdnaTest\.txt\:478\]");
is(eval{to_unicode("\x{0644}\x{0670}\x{06EF}",	%p)}, "\x{0644}\x{0670}\x{06EF}",	"to_unicode\(\'\\u0644\\u0670\\u06EF\'\)\ \[data\/IdnaTest\.txt\:479\]");
is(eval{to_unicode("xn--ghb2g3qq34f",	%p)}, "\x{0644}\x{0670}\x{200C}\x{06EF}",	"to_unicode\(\'xn\-\-ghb2g3qq34f\'\)\ \[data\/IdnaTest\.txt\:480\]");
is(eval{to_unicode("XN--GHB2G3QQ34F",	%p)}, "\x{0644}\x{0670}\x{200C}\x{06EF}",	"to_unicode\(\'XN\-\-GHB2G3QQ34F\'\)\ \[data\/IdnaTest\.txt\:481\]");
is(eval{to_unicode("Xn--Ghb2g3qq34f",	%p)}, "\x{0644}\x{0670}\x{200C}\x{06EF}",	"to_unicode\(\'Xn\-\-Ghb2g3qq34f\'\)\ \[data\/IdnaTest\.txt\:482\]");
is(eval{to_unicode("\x{0644}\x{200C}\x{06ED}\x{06EF}",	%p)}, "\x{0644}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'\\u0644\\u200C\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:483\]");
is(eval{to_unicode("xn--ghb25aga",	%p)}, "\x{0644}\x{06ED}\x{06EF}",	"to_unicode\(\'xn\-\-ghb25aga\'\)\ \[data\/IdnaTest\.txt\:485\]");
is(eval{to_unicode("XN--GHB25AGA",	%p)}, "\x{0644}\x{06ED}\x{06EF}",	"to_unicode\(\'XN\-\-GHB25AGA\'\)\ \[data\/IdnaTest\.txt\:486\]");
is(eval{to_unicode("Xn--Ghb25aga",	%p)}, "\x{0644}\x{06ED}\x{06EF}",	"to_unicode\(\'Xn\-\-Ghb25aga\'\)\ \[data\/IdnaTest\.txt\:487\]");
is(eval{to_unicode("\x{0644}\x{06ED}\x{06EF}",	%p)}, "\x{0644}\x{06ED}\x{06EF}",	"to_unicode\(\'\\u0644\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:488\]");
is(eval{to_unicode("xn--ghb25aga828w",	%p)}, "\x{0644}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'xn\-\-ghb25aga828w\'\)\ \[data\/IdnaTest\.txt\:489\]");
is(eval{to_unicode("XN--GHB25AGA828W",	%p)}, "\x{0644}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'XN\-\-GHB25AGA828W\'\)\ \[data\/IdnaTest\.txt\:490\]");
is(eval{to_unicode("Xn--Ghb25aga828w",	%p)}, "\x{0644}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'Xn\-\-Ghb25aga828w\'\)\ \[data\/IdnaTest\.txt\:491\]");
is(eval{to_unicode("\x{0644}\x{200C}\x{06EF}",	%p)}, "\x{0644}\x{200C}\x{06EF}",	"to_unicode\(\'\\u0644\\u200C\\u06EF\'\)\ \[data\/IdnaTest\.txt\:492\]");
is(eval{to_unicode("xn--ghb65a",	%p)}, "\x{0644}\x{06EF}",	"to_unicode\(\'xn\-\-ghb65a\'\)\ \[data\/IdnaTest\.txt\:494\]");
is(eval{to_unicode("XN--GHB65A",	%p)}, "\x{0644}\x{06EF}",	"to_unicode\(\'XN\-\-GHB65A\'\)\ \[data\/IdnaTest\.txt\:495\]");
is(eval{to_unicode("Xn--Ghb65a",	%p)}, "\x{0644}\x{06EF}",	"to_unicode\(\'Xn\-\-Ghb65a\'\)\ \[data\/IdnaTest\.txt\:496\]");
is(eval{to_unicode("\x{0644}\x{06EF}",	%p)}, "\x{0644}\x{06EF}",	"to_unicode\(\'\\u0644\\u06EF\'\)\ \[data\/IdnaTest\.txt\:497\]");
is(eval{to_unicode("xn--ghb65a953d",	%p)}, "\x{0644}\x{200C}\x{06EF}",	"to_unicode\(\'xn\-\-ghb65a953d\'\)\ \[data\/IdnaTest\.txt\:498\]");
is(eval{to_unicode("XN--GHB65A953D",	%p)}, "\x{0644}\x{200C}\x{06EF}",	"to_unicode\(\'XN\-\-GHB65A953D\'\)\ \[data\/IdnaTest\.txt\:499\]");
is(eval{to_unicode("Xn--Ghb65a953d",	%p)}, "\x{0644}\x{200C}\x{06EF}",	"to_unicode\(\'Xn\-\-Ghb65a953d\'\)\ \[data\/IdnaTest\.txt\:500\]");
is(eval{to_unicode("\x{0644}\x{0670}\x{200C}\x{06ED}",	%p)}, undef,	"to_unicode\(\'\\u0644\\u0670\\u200C\\u06ED\'\)\ is\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:501\]");
is(eval{to_unicode("xn--ghb2gxq",	%p)}, "\x{0644}\x{0670}\x{06ED}",	"to_unicode\(\'xn\-\-ghb2gxq\'\)\ \[data\/IdnaTest\.txt\:503\]");
is(eval{to_unicode("XN--GHB2GXQ",	%p)}, "\x{0644}\x{0670}\x{06ED}",	"to_unicode\(\'XN\-\-GHB2GXQ\'\)\ \[data\/IdnaTest\.txt\:504\]");
is(eval{to_unicode("Xn--Ghb2gxq",	%p)}, "\x{0644}\x{0670}\x{06ED}",	"to_unicode\(\'Xn\-\-Ghb2gxq\'\)\ \[data\/IdnaTest\.txt\:505\]");
is(eval{to_unicode("\x{0644}\x{0670}\x{06ED}",	%p)}, "\x{0644}\x{0670}\x{06ED}",	"to_unicode\(\'\\u0644\\u0670\\u06ED\'\)\ \[data\/IdnaTest\.txt\:506\]");
is(eval{to_unicode("\x{06EF}\x{200C}\x{06EF}",	%p)}, undef,	"to_unicode\(\'\\u06EF\\u200C\\u06EF\'\)\ is\ error\ C1\ \[data\/IdnaTest\.txt\:507\]");
is(eval{to_unicode("xn--cmba",	%p)}, "\x{06EF}\x{06EF}",	"to_unicode\(\'xn\-\-cmba\'\)\ \[data\/IdnaTest\.txt\:509\]");
is(eval{to_unicode("XN--CMBA",	%p)}, "\x{06EF}\x{06EF}",	"to_unicode\(\'XN\-\-CMBA\'\)\ \[data\/IdnaTest\.txt\:510\]");
is(eval{to_unicode("Xn--Cmba",	%p)}, "\x{06EF}\x{06EF}",	"to_unicode\(\'Xn\-\-Cmba\'\)\ \[data\/IdnaTest\.txt\:511\]");
is(eval{to_unicode("\x{06EF}\x{06EF}",	%p)}, "\x{06EF}\x{06EF}",	"to_unicode\(\'\\u06EF\\u06EF\'\)\ \[data\/IdnaTest\.txt\:512\]");
is(eval{to_unicode("\x{0644}\x{200C}",	%p)}, undef,	"to_unicode\(\'\\u0644\\u200C\'\)\ is\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:513\]");
is(eval{to_unicode("xn--ghb",	%p)}, "\x{0644}",	"to_unicode\(\'xn\-\-ghb\'\)\ \[data\/IdnaTest\.txt\:515\]");
is(eval{to_unicode("XN--GHB",	%p)}, "\x{0644}",	"to_unicode\(\'XN\-\-GHB\'\)\ \[data\/IdnaTest\.txt\:516\]");
is(eval{to_unicode("Xn--Ghb",	%p)}, "\x{0644}",	"to_unicode\(\'Xn\-\-Ghb\'\)\ \[data\/IdnaTest\.txt\:517\]");
is(eval{to_unicode("\x{0644}",	%p)}, "\x{0644}",	"to_unicode\(\'\\u0644\'\)\ \[data\/IdnaTest\.txt\:518\]");
is(eval{to_unicode("\x{063D}\x{10DD6}\x{1039}",	%p)}, undef,	"to_unicode\(\'\\u063D\\uD803\\uDDD6\\u1039\'\)\ is\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:519\]");
is(eval{to_unicode("𝟽\x{1A56}\x{10E7B}",	%p)}, undef,	"to_unicode\(\'𝟽\\u1A56\\uD803\\uDE7B\'\)\ is\ error\ B1\ \[data\/IdnaTest\.txt\:520\]");
is(eval{to_unicode("\x{E01C8}．\x{0684}\x{200C}\x{1ED62}\x{06EE}",	%p)}, undef,	"to_unicode\(\'\\uDB40\\uDDC8．\\u0684\\u200C\\uD83B\\uDD62\\u06EE\'\)\ is\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:521\]");
is(eval{to_unicode("ς\x{069C}\x{0772}\x{05BC}｡𝟎-\x{10A3F}\x{200C}\x{1BA3}\x{FD24}｡〓-\x{5E484}\x{0321}",	%p)}, undef,	"to_unicode\(\'ς\\u069C\\u0772\\u05BC｡𝟎\-\\uD802\\uDE3F\\u200C\\u1BA3\\uFD24｡〓\-\\uD939\\uDC84\\u0321\'\)\ is\ error\ P1\ V6\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:523\]");
is(eval{to_unicode("Σ\x{069C}\x{0772}\x{05BC}｡𝟎-\x{10A3F}\x{200C}\x{1BA3}\x{FD24}｡〓-\x{5E484}\x{0321}",	%p)}, undef,	"to_unicode\(\'Σ\\u069C\\u0772\\u05BC｡𝟎\-\\uD802\\uDE3F\\u200C\\u1BA3\\uFD24｡〓\-\\uD939\\uDC84\\u0321\'\)\ is\ error\ P1\ V6\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:525\]");
is(eval{to_unicode("σ\x{069C}\x{0772}\x{05BC}｡𝟎-\x{10A3F}\x{200C}\x{1BA3}\x{FD24}｡〓-\x{5E484}\x{0321}",	%p)}, undef,	"to_unicode\(\'σ\\u069C\\u0772\\u05BC｡𝟎\-\\uD802\\uDE3F\\u200C\\u1BA3\\uFD24｡〓\-\\uD939\\uDC84\\u0321\'\)\ is\ error\ P1\ V6\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:527\]");
is(eval{to_unicode("\x{FD55}\x{AA338}-\x{10E66}\x{10837}\x{E04D8}\x{E0194}",	%p)}, undef,	"to_unicode\(\'\\uFD55\\uDA68\\uDF38\-\\uD803\\uDE66\\uD802\\uDC37\\uDB41\\uDCD8\\uDB40\\uDD94\'\)\ is\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:529\]");
is(eval{to_unicode("\x{A953}\x{0636}\x{10A3F}\x{06C1}\x{17D2}\x{200C}ς｡\x{10D1F}\x{11C05}\x{067A}\x{062D}",	%p)}, undef,	"to_unicode\(\'\\uA953\\u0636\\uD802\\uDE3F\\u06C1\\u17D2\\u200Cς｡\\uD803\\uDD1F\\uD807\\uDC05\\u067A\\u062D\'\)\ is\ error\ P1\ V5\ V6\ B5\ B2\ \[data\/IdnaTest\.txt\:530\]");
is(eval{to_unicode("\x{A953}\x{0636}\x{10A3F}\x{06C1}\x{17D2}\x{200C}Σ｡\x{10D1F}\x{11C05}\x{067A}\x{062D}",	%p)}, undef,	"to_unicode\(\'\\uA953\\u0636\\uD802\\uDE3F\\u06C1\\u17D2\\u200CΣ｡\\uD803\\uDD1F\\uD807\\uDC05\\u067A\\u062D\'\)\ is\ error\ P1\ V5\ V6\ B5\ B2\ \[data\/IdnaTest\.txt\:532\]");
is(eval{to_unicode("\x{A953}\x{0636}\x{10A3F}\x{06C1}\x{17D2}\x{200C}σ｡\x{10D1F}\x{11C05}\x{067A}\x{062D}",	%p)}, undef,	"to_unicode\(\'\\uA953\\u0636\\uD802\\uDE3F\\u06C1\\u17D2\\u200Cσ｡\\uD803\\uDD1F\\uD807\\uDC05\\u067A\\u062D\'\)\ is\ error\ P1\ V5\ V6\ B5\ B2\ \[data\/IdnaTest\.txt\:534\]");
is(eval{to_unicode("\x{A3336}\x{0340}\x{0721}\x{07DC}\x{2C01B}",	%p)}, undef,	"to_unicode\(\'\\uDA4C\\uDF36\\u0340\\u0721\\u07DC\\uD870\\uDC1B\'\)\ is\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:536\]");
is(eval{to_unicode("\x{A3336}\x{0300}\x{0721}\x{07DC}\x{2C01B}",	%p)}, undef,	"to_unicode\(\'\\uDA4C\\uDF36\\u0300\\u0721\\u07DC\\uD870\\uDC1B\'\)\ is\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:537\]");
is(eval{to_unicode("\x{067B}",	%p)}, "\x{067B}",	"to_unicode\(\'\\u067B\'\)\ \[data\/IdnaTest\.txt\:538\]");
is(eval{to_unicode("xn--0ib",	%p)}, "\x{067B}",	"to_unicode\(\'xn\-\-0ib\'\)\ \[data\/IdnaTest\.txt\:539\]");
is(eval{to_unicode("XN--0IB",	%p)}, "\x{067B}",	"to_unicode\(\'XN\-\-0IB\'\)\ \[data\/IdnaTest\.txt\:540\]");
is(eval{to_unicode("Xn--0Ib",	%p)}, "\x{067B}",	"to_unicode\(\'Xn\-\-0Ib\'\)\ \[data\/IdnaTest\.txt\:541\]");
is(eval{to_unicode("\x{E1FA9}-６\x{E0F69}｡𝟪\x{200C}\x{200C}-.-",	%p)}, undef,	"to_unicode\(\'\\uDB47\\uDFA9\-６\\uDB43\\uDF69｡𝟪\\u200C\\u200C\-\.\-\'\)\ is\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:542\]");
is(eval{to_unicode("\x{0661}\x{200C}\x{1ECD1}",	%p)}, undef,	"to_unicode\(\'\\u0661\\u200C\\uD83B\\uDCD1\'\)\ is\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:544\]");
is(eval{to_unicode("\x{1A8F4}．\x{069F}\x{0639}.-\x{06E2}⒎",	%p)}, undef,	"to_unicode\(\'\\uD82A\\uDCF4．\\u069F\\u0639\.\-\\u06E2⒎\'\)\ is\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:546\]");
is(eval{to_unicode("\x{067F}\x{10E6E}。-\x{063D}\x{5970E}。⫍\x{06AA}\x{FD9F}-",	%p)}, undef,	"to_unicode\(\'\\u067F\\uD803\\uDE6E。\-\\u063D\\uD925\\uDF0E。⫍\\u06AA\\uFD9F\-\'\)\ is\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:547\]");
is(eval{to_unicode("\x{E0140}\x{A806}．🄅\x{0643}.\x{FEE6}\x{E0082}\x{069E}",	%p)}, undef,	"to_unicode\(\'\\uDB40\\uDD40\\uA806．🄅\\u0643\.\\uFEE6\\uDB40\\uDC82\\u069E\'\)\ is\ error\ P1\ V5\ V6\ B1\ B3\ B6\ \[data\/IdnaTest\.txt\:548\]");
is(eval{to_unicode("ß-⒏\x{A802}",	%p)}, undef,	"to_unicode\(\'ß\-⒏\\uA802\'\)\ is\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:549\]");
is(eval{to_unicode("SS-⒏\x{A802}",	%p)}, undef,	"to_unicode\(\'SS\-⒏\\uA802\'\)\ is\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:551\]");
is(eval{to_unicode("ss-⒏\x{A802}",	%p)}, undef,	"to_unicode\(\'ss\-⒏\\uA802\'\)\ is\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:552\]");
is(eval{to_unicode("Ss-⒏\x{A802}",	%p)}, undef,	"to_unicode\(\'Ss\-⒏\\uA802\'\)\ is\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:553\]");
is(eval{to_unicode("\x{066B}\x{E01DF}ς\x{10E78}\x{10E67}\x{0733}。\x{FFF4}\x{075E}\x{10E78}",	%p)}, undef,	"to_unicode\(\'\\u066B\\uDB40\\uDDDFς\\uD803\\uDE78\\uD803\\uDE67\\u0733。\\uFFF4\\u075E\\uD803\\uDE78\'\)\ is\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:554\]");
is(eval{to_unicode("\x{066B}\x{E01DF}Σ\x{10E78}\x{10E67}\x{0733}。\x{FFF4}\x{075E}\x{10E78}",	%p)}, undef,	"to_unicode\(\'\\u066B\\uDB40\\uDDDFΣ\\uD803\\uDE78\\uD803\\uDE67\\u0733。\\uFFF4\\u075E\\uD803\\uDE78\'\)\ is\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:556\]");
is(eval{to_unicode("\x{066B}\x{E01DF}σ\x{10E78}\x{10E67}\x{0733}。\x{FFF4}\x{075E}\x{10E78}",	%p)}, undef,	"to_unicode\(\'\\u066B\\uDB40\\uDDDFσ\\uD803\\uDE78\\uD803\\uDE67\\u0733。\\uFFF4\\u075E\\uD803\\uDE78\'\)\ is\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:557\]");
is(eval{to_unicode("𝟾\x{F4FAE}｡\x{E01A3}\x{0662}\x{074F}\x{10BDD}\x{6F18C}。ς\x{1714}\x{0F84}\x{07D6}-",	%p)}, undef,	"to_unicode\(\'𝟾\\uDB93\\uDFAE｡\\uDB40\\uDDA3\\u0662\\u074F\\uD802\\uDFDD\\uD97C\\uDD8C。ς\\u1714\\u0F84\\u07D6\-\'\)\ is\ error\ P1\ V6\ V3\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:558\]");
is(eval{to_unicode("𝟾\x{F4FAE}｡\x{E01A3}\x{0662}\x{074F}\x{10BDD}\x{6F18C}。Σ\x{1714}\x{0F84}\x{07D6}-",	%p)}, undef,	"to_unicode\(\'𝟾\\uDB93\\uDFAE｡\\uDB40\\uDDA3\\u0662\\u074F\\uD802\\uDFDD\\uD97C\\uDD8C。Σ\\u1714\\u0F84\\u07D6\-\'\)\ is\ error\ P1\ V6\ V3\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:560\]");
is(eval{to_unicode("𝟾\x{F4FAE}｡\x{E01A3}\x{0662}\x{074F}\x{10BDD}\x{6F18C}。σ\x{1714}\x{0F84}\x{07D6}-",	%p)}, undef,	"to_unicode\(\'𝟾\\uDB93\\uDFAE｡\\uDB40\\uDDA3\\u0662\\u074F\\uD802\\uDFDD\\uD97C\\uDD8C。σ\\u1714\\u0F84\\u07D6\-\'\)\ is\ error\ P1\ V6\ V3\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:561\]");
is(eval{to_unicode("\x{10E6D}",	%p)}, undef,	"to_unicode\(\'\\uD803\\uDE6D\'\)\ is\ error\ B1\ \[data\/IdnaTest\.txt\:562\]");
is(eval{to_unicode("\x{0660}\x{072B}⒊\x{8CD67}\x{0626}\x{0678}｡\x{10E71}\x{0662}\x{200D}\x{0770}\x{0E3A}\x{E019F}",	%p)}, undef,	"to_unicode\(\'\\u0660\\u072B⒊\\uD9F3\\uDD67\\u0626\\u0678｡\\uD803\\uDE71\\u0662\\u200D\\u0770\\u0E3A\\uDB40\\uDD9F\'\)\ is\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:563\]");
is(eval{to_unicode("\x{E0112}𝟭۵-\x{E0E3F}-\x{E010E}",	%p)}, undef,	"to_unicode\(\'\\uDB40\\uDD12𝟭۵\-\\uDB43\\uDE3F\-\\uDB40\\uDD0E\'\)\ is\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:565\]");
is(eval{to_unicode("\x{031C}",	%p)}, undef,	"to_unicode\(\'\\u031C\'\)\ is\ error\ V5\ \[data\/IdnaTest\.txt\:566\]");
is(eval{to_unicode("\x{0F79}⒏\x{0647}\x{A92C}\x{07D2}\x{10ED8}\x{059A}。\x{200C}\x{069E}",	%p)}, undef,	"to_unicode\(\'\\u0F79⒏\\u0647\\uA92C\\u07D2\\uD803\\uDED8\\u059A。\\u200C\\u069E\'\)\ is\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:567\]");
is(eval{to_unicode("\x{200D}\x{17D2}\x{7A548}\x{0683}℈\x{20D9}",	%p)}, undef,	"to_unicode\(\'\\u200D\\u17D2\\uD9A9\\uDD48\\u0683℈\\u20D9\'\)\ is\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:569\]");
is(eval{to_unicode("\x{E0321}\x{200C}-",	%p)}, undef,	"to_unicode\(\'\\uDB40\\uDF21\\u200C\-\'\)\ is\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:571\]");
is(eval{to_unicode("\x{17B5}\x{9DF60}-。\x{E0597}\x{200C}\x{200D}",	%p)}, undef,	"to_unicode\(\'\\u17B5\\uDA37\\uDF60\-。\\uDB41\\uDD97\\u200C\\u200D\'\)\ is\ error\ P1\ V3\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:573\]");
is(eval{to_unicode("𐅫",	%p)}, "𐅫",	"to_unicode\(\'𐅫\'\)\ \[data\/IdnaTest\.txt\:575\]");
is(eval{to_unicode("xn--gy7c",	%p)}, "𐅫",	"to_unicode\(\'xn\-\-gy7c\'\)\ \[data\/IdnaTest\.txt\:576\]");
is(eval{to_unicode("XN--GY7C",	%p)}, "𐅫",	"to_unicode\(\'XN\-\-GY7C\'\)\ \[data\/IdnaTest\.txt\:577\]");
is(eval{to_unicode("Xn--Gy7c",	%p)}, "𐅫",	"to_unicode\(\'Xn\-\-Gy7c\'\)\ \[data\/IdnaTest\.txt\:578\]");
is(eval{to_unicode("\x{064A}\x{0BCD}-⁹\x{1DEFD}\x{06C5}\x{E0163}.\x{10E77}\x{200D}\x{0AC3}\x{E013B}-.\x{E04AD}\x{07ED}\x{E0817}\x{0626}𝟕",	%p)}, undef,	"to_unicode\(\'\\u064A\\u0BCD\-⁹\\uD837\\uDEFD\\u06C5\\uDB40\\uDD63\.\\uD803\\uDE77\\u200D\\u0AC3\\uDB40\\uDD3B\-\.\\uDB41\\uDCAD\\u07ED\\uDB42\\uDC17\\u0626𝟕\'\)\ is\ error\ P1\ V6\ V3\ B2\ B1\ C2\ \[data\/IdnaTest\.txt\:579\]");
is(eval{to_unicode("\x{10E69}\x{06AD}\x{200C}\x{0309}。🄂\x{E007A}\x{A806}\x{47F43}--．\x{F4273}⩆⫝",	%p)}, undef,	"to_unicode\(\'\\uD803\\uDE69\\u06AD\\u200C\\u0309。🄂\\uDB40\\uDC7A\\uA806\\uD8DF\\uDF43\-\-．\\uDB90\\uDE73⩆⫝\'\)\ is\ error\ P1\ V3\ V6\ B1\ B6\ C1\ \[data\/IdnaTest\.txt\:581\]");
is(eval{to_unicode("\x{06B7}\x{200D}\x{06FA}\x{0646}\x{066F}．\x{0771}\x{E067C}\x{1E973}\x{066C}\x{0B4D}.\x{0649}\x{0714}\x{10A01}\x{E0BC1}\x{10E7E}",	%p)}, undef,	"to_unicode\(\'\\u06B7\\u200D\\u06FA\\u0646\\u066F．\\u0771\\uDB41\\uDE7C\\uD83A\\uDD73\\u066C\\u0B4D\.\\u0649\\u0714\\uD802\\uDE01\\uDB42\\uDFC1\\uD803\\uDE7E\'\)\ is\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:583\]");
is(eval{to_unicode("\x{E0C53}\x{06B7}⒕ς\x{1A7F}₆\x{E0A0E}｡\x{094D}\x{1714}\x{D7241}\x{0765}\x{989A0}｡\x{E006C}\x{200D}\x{06BC}",	%p)}, undef,	"to_unicode\(\'\\uDB43\\uDC53\\u06B7⒕ς\\u1A7F₆\\uDB42\\uDE0E｡\\u094D\\u1714\\uDB1C\\uDE41\\u0765\\uDA22\\uDDA0｡\\uDB40\\uDC6C\\u200D\\u06BC\'\)\ is\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:585\]");
is(eval{to_unicode("\x{E0C53}\x{06B7}⒕Σ\x{1A7F}₆\x{E0A0E}｡\x{094D}\x{1714}\x{D7241}\x{0765}\x{989A0}｡\x{E006C}\x{200D}\x{06BC}",	%p)}, undef,	"to_unicode\(\'\\uDB43\\uDC53\\u06B7⒕Σ\\u1A7F₆\\uDB42\\uDE0E｡\\u094D\\u1714\\uDB1C\\uDE41\\u0765\\uDA22\\uDDA0｡\\uDB40\\uDC6C\\u200D\\u06BC\'\)\ is\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:587\]");
is(eval{to_unicode("\x{E0C53}\x{06B7}⒕σ\x{1A7F}₆\x{E0A0E}｡\x{094D}\x{1714}\x{D7241}\x{0765}\x{989A0}｡\x{E006C}\x{200D}\x{06BC}",	%p)}, undef,	"to_unicode\(\'\\uDB43\\uDC53\\u06B7⒕σ\\u1A7F₆\\uDB42\\uDE0E｡\\u094D\\u1714\\uDB1C\\uDE41\\u0765\\uDA22\\uDDA0｡\\uDB40\\uDC6C\\u200D\\u06BC\'\)\ is\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:589\]");
is(eval{to_unicode("𦜲\x{ABE8}\x{200D}\x{0760}｡\x{0F84}．ß",	%p)}, undef,	"to_unicode\(\'𦜲\\uABE8\\u200D\\u0760｡\\u0F84．ß\'\)\ is\ error\ V5\ B5\ B6\ B1\ B3\ C2\ \[data\/IdnaTest\.txt\:591\]");
is(eval{to_unicode("𦜲\x{ABE8}\x{200D}\x{0760}｡\x{0F84}．SS",	%p)}, undef,	"to_unicode\(\'𦜲\\uABE8\\u200D\\u0760｡\\u0F84．SS\'\)\ is\ error\ V5\ B5\ B6\ B1\ B3\ C2\ \[data\/IdnaTest\.txt\:593\]");
is(eval{to_unicode("𦜲\x{ABE8}\x{200D}\x{0760}｡\x{0F84}．ss",	%p)}, undef,	"to_unicode\(\'𦜲\\uABE8\\u200D\\u0760｡\\u0F84．ss\'\)\ is\ error\ V5\ B5\ B6\ B1\ B3\ C2\ \[data\/IdnaTest\.txt\:595\]");
is(eval{to_unicode("𦜲\x{ABE8}\x{200D}\x{0760}｡\x{0F84}．Ss",	%p)}, undef,	"to_unicode\(\'𦜲\\uABE8\\u200D\\u0760｡\\u0F84．Ss\'\)\ is\ error\ V5\ B5\ B6\ B1\ B3\ C2\ \[data\/IdnaTest\.txt\:597\]");
is(eval{to_unicode("\x{0FBC}\x{2DF5}\x{E0B68}.\x{102D}\x{200C}",	%p)}, undef,	"to_unicode\(\'\\u0FBC\\u2DF5\\uDB42\\uDF68\.\\u102D\\u200C\'\)\ is\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:599\]");
is(eval{to_unicode("ß\x{0778}\x{E0531}\x{0F19}\x{0649}",	%p)}, undef,	"to_unicode\(\'ß\\u0778\\uDB41\\uDD31\\u0F19\\u0649\'\)\ is\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:601\]");
is(eval{to_unicode("SS\x{0778}\x{E0531}\x{0F19}\x{0649}",	%p)}, undef,	"to_unicode\(\'SS\\u0778\\uDB41\\uDD31\\u0F19\\u0649\'\)\ is\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:603\]");
is(eval{to_unicode("ss\x{0778}\x{E0531}\x{0F19}\x{0649}",	%p)}, undef,	"to_unicode\(\'ss\\u0778\\uDB41\\uDD31\\u0F19\\u0649\'\)\ is\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:604\]");
is(eval{to_unicode("Ss\x{0778}\x{E0531}\x{0F19}\x{0649}",	%p)}, undef,	"to_unicode\(\'Ss\\u0778\\uDB41\\uDD31\\u0F19\\u0649\'\)\ is\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:605\]");
is(eval{to_unicode("\x{E012E}.\x{0C4D}\x{077F}\x{FBE1}\x{200D}\x{200D}\x{05C4}\x{200C}｡\x{0F35}\x{200C}\x{0BCD}\x{06AB}\x{0666}",	%p)}, undef,	"to_unicode\(\'\\uDB40\\uDD2E\.\\u0C4D\\u077F\\uFBE1\\u200D\\u200D\\u05C4\\u200C｡\\u0F35\\u200C\\u0BCD\\u06AB\\u0666\'\)\ is\ error\ V5\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:606\]");
is(eval{to_unicode("𝟣.\x{E0761}\x{73F52}\x{F7435}\x{E016F}6-\x{0943}。\x{53C57}ς\x{072D}\x{1CD4}𝟟\x{E0126}",	%p)}, undef,	"to_unicode\(\'𝟣\.\\uDB41\\uDF61\\uD98F\\uDF52\\uDB9D\\uDC35\\uDB40\\uDD6F6\-\\u0943。\\uD90F\\uDC57ς\\u072D\\u1CD4𝟟\\uDB40\\uDD26\'\)\ is\ error\ P1\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:608\]");
is(eval{to_unicode("𝟣.\x{E0761}\x{73F52}\x{F7435}\x{E016F}6-\x{0943}。\x{53C57}Σ\x{072D}\x{1CD4}𝟟\x{E0126}",	%p)}, undef,	"to_unicode\(\'𝟣\.\\uDB41\\uDF61\\uD98F\\uDF52\\uDB9D\\uDC35\\uDB40\\uDD6F6\-\\u0943。\\uD90F\\uDC57Σ\\u072D\\u1CD4𝟟\\uDB40\\uDD26\'\)\ is\ error\ P1\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:610\]");
is(eval{to_unicode("𝟣.\x{E0761}\x{73F52}\x{F7435}\x{E016F}6-\x{0943}。\x{53C57}σ\x{072D}\x{1CD4}𝟟\x{E0126}",	%p)}, undef,	"to_unicode\(\'𝟣\.\\uDB41\\uDF61\\uD98F\\uDF52\\uDB9D\\uDC35\\uDB40\\uDD6F6\-\\u0943。\\uD90F\\uDC57σ\\u072D\\u1CD4𝟟\\uDB40\\uDD26\'\)\ is\ error\ P1\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:611\]");
is(eval{to_unicode("\x{1EE79}\x{200C}ς\x{E0934}\x{1DD6}.\x{1ECB2}ς\x{10E79}\x{EEBF8}\x{06A4}\x{200D}\x{10E7A}。\x{A806}\x{10AF3}\x{06C1}\x{1EAAA}",	%p)}, undef,	"to_unicode\(\'\\uD83B\\uDE79\\u200Cς\\uDB42\\uDD34\\u1DD6\.\\uD83B\\uDCB2ς\\uD803\\uDE79\\uDB7A\\uDFF8\\u06A4\\u200D\\uD803\\uDE7A。\\uA806\\uD802\\uDEF3\\u06C1\\uD83A\\uDEAA\'\)\ is\ error\ P1\ V6\ V5\ B2\ B3\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:612\]");
is(eval{to_unicode("\x{1EE79}\x{200C}Σ\x{E0934}\x{1DD6}.\x{1ECB2}Σ\x{10E79}\x{EEBF8}\x{06A4}\x{200D}\x{10E7A}。\x{A806}\x{10AF3}\x{06C1}\x{1EAAA}",	%p)}, undef,	"to_unicode\(\'\\uD83B\\uDE79\\u200CΣ\\uDB42\\uDD34\\u1DD6\.\\uD83B\\uDCB2Σ\\uD803\\uDE79\\uDB7A\\uDFF8\\u06A4\\u200D\\uD803\\uDE7A。\\uA806\\uD802\\uDEF3\\u06C1\\uD83A\\uDEAA\'\)\ is\ error\ P1\ V6\ V5\ B2\ B3\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:614\]");
is(eval{to_unicode("\x{1EE79}\x{200C}σ\x{E0934}\x{1DD6}.\x{1ECB2}σ\x{10E79}\x{EEBF8}\x{06A4}\x{200D}\x{10E7A}。\x{A806}\x{10AF3}\x{06C1}\x{1EAAA}",	%p)}, undef,	"to_unicode\(\'\\uD83B\\uDE79\\u200Cσ\\uDB42\\uDD34\\u1DD6\.\\uD83B\\uDCB2σ\\uD803\\uDE79\\uDB7A\\uDFF8\\u06A4\\u200D\\uD803\\uDE7A。\\uA806\\uD802\\uDEF3\\u06C1\\uD83A\\uDEAA\'\)\ is\ error\ P1\ V6\ V5\ B2\ B3\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:616\]");
is(eval{to_unicode("\x{06CA}\x{A8C4}\x{066B}。\x{E0177}\x{1C180}\x{200C}\x{200D}\x{06E7}\x{10E79}",	%p)}, undef,	"to_unicode\(\'\\u06CA\\uA8C4\\u066B。\\uDB40\\uDD77\\uD830\\uDD80\\u200C\\u200D\\u06E7\\uD803\\uDE79\'\)\ is\ error\ P1\ V6\ B5\ B6\ C1\ C2\ \[data\/IdnaTest\.txt\:618\]");
is(eval{to_unicode("-𝟴。\x{105718}\x{1D186}₆\x{99AEB}ς\x{640A2}-．\x{200C}\x{0750}ς",	%p)}, undef,	"to_unicode\(\'\-𝟴。\\uDBD5\\uDF18\\uD834\\uDD86₆\\uDA26\\uDEEBς\\uD950\\uDCA2\-．\\u200C\\u0750ς\'\)\ is\ error\ P1\ V3\ V6\ B1\ B6\ C1\ \[data\/IdnaTest\.txt\:620\]");
is(eval{to_unicode("-𝟴。\x{105718}\x{1D186}₆\x{99AEB}Σ\x{640A2}-．\x{200C}\x{0750}Σ",	%p)}, undef,	"to_unicode\(\'\-𝟴。\\uDBD5\\uDF18\\uD834\\uDD86₆\\uDA26\\uDEEBΣ\\uD950\\uDCA2\-．\\u200C\\u0750Σ\'\)\ is\ error\ P1\ V3\ V6\ B1\ B6\ C1\ \[data\/IdnaTest\.txt\:622\]");
is(eval{to_unicode("-𝟴。\x{105718}\x{1D186}₆\x{99AEB}σ\x{640A2}-．\x{200C}\x{0750}σ",	%p)}, undef,	"to_unicode\(\'\-𝟴。\\uDBD5\\uDF18\\uD834\\uDD86₆\\uDA26\\uDEEBσ\\uD950\\uDCA2\-．\\u200C\\u0750σ\'\)\ is\ error\ P1\ V3\ V6\ B1\ B6\ C1\ \[data\/IdnaTest\.txt\:624\]");
is(eval{to_unicode("\x{E01C5}\x{0DCA}ß\x{07DB}-\x{E0246}",	%p)}, undef,	"to_unicode\(\'\\uDB40\\uDDC5\\u0DCAß\\u07DB\-\\uDB40\\uDE46\'\)\ is\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:626\]");
is(eval{to_unicode("\x{E01C5}\x{0DCA}SS\x{07DB}-\x{E0246}",	%p)}, undef,	"to_unicode\(\'\\uDB40\\uDDC5\\u0DCASS\\u07DB\-\\uDB40\\uDE46\'\)\ is\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:628\]");
is(eval{to_unicode("\x{E01C5}\x{0DCA}ss\x{07DB}-\x{E0246}",	%p)}, undef,	"to_unicode\(\'\\uDB40\\uDDC5\\u0DCAss\\u07DB\-\\uDB40\\uDE46\'\)\ is\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:629\]");
is(eval{to_unicode("\x{E01C5}\x{0DCA}Ss\x{07DB}-\x{E0246}",	%p)}, undef,	"to_unicode\(\'\\uDB40\\uDDC5\\u0DCASs\\u07DB\-\\uDB40\\uDE46\'\)\ is\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:630\]");
is(eval{to_unicode("\x{0767}\x{A825}｡ß-\x{200C}\x{2DF2}",	%p)}, undef,	"to_unicode\(\'\\u0767\\uA825｡ß\-\\u200C\\u2DF2\'\)\ is\ error\ B6\ C1\ \[data\/IdnaTest\.txt\:631\]");
is(eval{to_unicode("\x{0767}\x{A825}｡SS-\x{200C}\x{2DF2}",	%p)}, undef,	"to_unicode\(\'\\u0767\\uA825｡SS\-\\u200C\\u2DF2\'\)\ is\ error\ B6\ C1\ \[data\/IdnaTest\.txt\:633\]");
is(eval{to_unicode("\x{0767}\x{A825}｡ss-\x{200C}\x{2DF2}",	%p)}, undef,	"to_unicode\(\'\\u0767\\uA825｡ss\-\\u200C\\u2DF2\'\)\ is\ error\ B6\ C1\ \[data\/IdnaTest\.txt\:635\]");
is(eval{to_unicode("\x{0767}\x{A825}｡Ss-\x{200C}\x{2DF2}",	%p)}, undef,	"to_unicode\(\'\\u0767\\uA825｡Ss\-\\u200C\\u2DF2\'\)\ is\ error\ B6\ C1\ \[data\/IdnaTest\.txt\:637\]");
is(eval{to_unicode("-\x{0758}-\x{200D}꒸。\x{07AB}．\x{1089D}\x{E0317}\x{ABED}\x{1036}",	%p)}, undef,	"to_unicode\(\'\-\\u0758\-\\u200D꒸。\\u07AB．\\uD802\\uDC9D\\uDB40\\uDF17\\uABED\\u1036\'\)\ is\ error\ P1\ V3\ V5\ V6\ B1\ B3\ B6\ C2\ \[data\/IdnaTest\.txt\:639\]");
is(eval{to_unicode("\x{200C}𝟒\x{0625}\x{200C}\x{0667}．\x{10E6C}\x{200C}\x{0F9E}",	%p)}, undef,	"to_unicode\(\'\\u200C𝟒\\u0625\\u200C\\u0667．\\uD803\\uDE6C\\u200C\\u0F9E\'\)\ is\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:641\]");
is(eval{to_unicode("\x{0671}𝟎。\x{A8C4}\x{200D}\x{1D181}\x{17C9}",	%p)}, undef,	"to_unicode\(\'\\u0671𝟎。\\uA8C4\\u200D\\uD834\\uDD81\\u17C9\'\)\ is\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:643\]");
is(eval{to_unicode("\x{062D}\x{343B8}",	%p)}, undef,	"to_unicode\(\'\\u062D\\uD890\\uDFB8\'\)\ is\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:645\]");
is(eval{to_unicode("\x{BB22C}",	%p)}, undef,	"to_unicode\(\'\\uDAAC\\uDE2C\'\)\ is\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:646\]");
is(eval{to_unicode("𝟥\x{1EA8D}\x{0F84}\x{45630}⁰。\x{06C8}ß\x{1D169}",	%p)}, undef,	"to_unicode\(\'𝟥\\uD83A\\uDE8D\\u0F84\\uD8D5\\uDE30⁰。\\u06C8ß\\uD834\\uDD69\'\)\ is\ error\ P1\ V6\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:647\]");
is(eval{to_unicode("𝟥\x{1EA8D}\x{0F84}\x{45630}⁰。\x{06C8}SS\x{1D169}",	%p)}, undef,	"to_unicode\(\'𝟥\\uD83A\\uDE8D\\u0F84\\uD8D5\\uDE30⁰。\\u06C8SS\\uD834\\uDD69\'\)\ is\ error\ P1\ V6\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:649\]");
is(eval{to_unicode("𝟥\x{1EA8D}\x{0F84}\x{45630}⁰。\x{06C8}ss\x{1D169}",	%p)}, undef,	"to_unicode\(\'𝟥\\uD83A\\uDE8D\\u0F84\\uD8D5\\uDE30⁰。\\u06C8ss\\uD834\\uDD69\'\)\ is\ error\ P1\ V6\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:650\]");
is(eval{to_unicode("𝟥\x{1EA8D}\x{0F84}\x{45630}⁰。\x{06C8}Ss\x{1D169}",	%p)}, undef,	"to_unicode\(\'𝟥\\uD83A\\uDE8D\\u0F84\\uD8D5\\uDE30⁰。\\u06C8Ss\\uD834\\uDD69\'\)\ is\ error\ P1\ V6\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:651\]");
is(eval{to_unicode("\x{0661}ß。\x{1A60}\x{DAA74}\x{10E7B}",	%p)}, undef,	"to_unicode\(\'\\u0661ß。\\u1A60\\uDB2A\\uDE74\\uD803\\uDE7B\'\)\ is\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:652\]");
is(eval{to_unicode("\x{0661}SS。\x{1A60}\x{DAA74}\x{10E7B}",	%p)}, undef,	"to_unicode\(\'\\u0661SS。\\u1A60\\uDB2A\\uDE74\\uD803\\uDE7B\'\)\ is\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:654\]");
is(eval{to_unicode("\x{0661}ss。\x{1A60}\x{DAA74}\x{10E7B}",	%p)}, undef,	"to_unicode\(\'\\u0661ss。\\u1A60\\uDB2A\\uDE74\\uD803\\uDE7B\'\)\ is\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:655\]");
is(eval{to_unicode("\x{0661}Ss。\x{1A60}\x{DAA74}\x{10E7B}",	%p)}, undef,	"to_unicode\(\'\\u0661Ss。\\u1A60\\uDB2A\\uDE74\\uD803\\uDE7B\'\)\ is\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:656\]");
is(eval{to_unicode("ς\x{10E73}\x{0635}⒓",	%p)}, undef,	"to_unicode\(\'ς\\uD803\\uDE73\\u0635⒓\'\)\ is\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:657\]");
is(eval{to_unicode("Σ\x{10E73}\x{0635}⒓",	%p)}, undef,	"to_unicode\(\'Σ\\uD803\\uDE73\\u0635⒓\'\)\ is\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:659\]");
is(eval{to_unicode("σ\x{10E73}\x{0635}⒓",	%p)}, undef,	"to_unicode\(\'σ\\uD803\\uDE73\\u0635⒓\'\)\ is\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:660\]");
is(eval{to_unicode("\x{19785}㊲\x{10BE82}\x{200D}。\x{E0136}\x{2062}¹",	%p)}, undef,	"to_unicode\(\'\\uD825\\uDF85㊲\\uDBEF\\uDE82\\u200D。\\uDB40\\uDD36\\u2062¹\'\)\ is\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:661\]");
is(eval{to_unicode("\x{200D}\x{A953}.\x{FB2A}.-𝟨\x{200C}-",	%p)}, undef,	"to_unicode\(\'\\u200D\\uA953\.\\uFB2A\.\-𝟨\\u200C\-\'\)\ is\ error\ V3\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:663\]");
is(eval{to_unicode("\x{200D}\x{A953}.\x{05E9}\x{05C1}.-𝟨\x{200C}-",	%p)}, undef,	"to_unicode\(\'\\u200D\\uA953\.\\u05E9\\u05C1\.\-𝟨\\u200C\-\'\)\ is\ error\ V3\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:665\]");
is(eval{to_unicode("\x{06B2}\x{200C}-．\x{0D4D}。🄇-\x{E0AD8}\x{1DC9}\x{FA629}\x{E0BC5}\x{20E7}",	%p)}, undef,	"to_unicode\(\'\\u06B2\\u200C\-．\\u0D4D。🄇\-\\uDB42\\uDED8\\u1DC9\\uDBA9\\uDE29\\uDB42\\uDFC5\\u20E7\'\)\ is\ error\ P1\ V3\ V5\ V6\ B3\ B1\ B6\ C1\ \[data\/IdnaTest\.txt\:667\]");
is(eval{to_unicode("-",	%p)}, undef,	"to_unicode\(\'\-\'\)\ is\ error\ V3\ \[data\/IdnaTest\.txt\:669\]");
is(eval{to_unicode("\x{0680}\x{0DCA}\x{1A60}\x{0616}\x{E0A69}｡\x{1039}",	%p)}, undef,	"to_unicode\(\'\\u0680\\u0DCA\\u1A60\\u0616\\uDB42\\uDE69｡\\u1039\'\)\ is\ error\ P1\ V6\ V5\ B3\ B1\ B6\ \[data\/IdnaTest\.txt\:670\]");
is(eval{to_unicode("-\x{0683}\x{1BAA}\x{062B}𝟦．\x{FE25}\x{200D}\x{10899}\x{0777}𝟣．\x{A2A06}\x{0760}",	%p)}, undef,	"to_unicode\(\'\-\\u0683\\u1BAA\\u062B𝟦．\\uFE25\\u200D\\uD802\\uDC99\\u0777𝟣．\\uDA4A\\uDE06\\u0760\'\)\ is\ error\ P1\ V3\ V5\ V6\ B1\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:671\]");
is(eval{to_unicode("\x{3A131}",	%p)}, undef,	"to_unicode\(\'\\uD8A8\\uDD31\'\)\ is\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:673\]");
is(eval{to_unicode("\x{0837}。\x{0680}\x{031E}\x{0601}ß⁸",	%p)}, undef,	"to_unicode\(\'\\u0837。\\u0680\\u031E\\u0601ß⁸\'\)\ is\ error\ P1\ V6\ B2\ B4\ \[data\/IdnaTest\.txt\:674\]");
is(eval{to_unicode("\x{0837}。\x{0680}\x{031E}\x{0601}SS⁸",	%p)}, undef,	"to_unicode\(\'\\u0837。\\u0680\\u031E\\u0601SS⁸\'\)\ is\ error\ P1\ V6\ B2\ B4\ \[data\/IdnaTest\.txt\:676\]");
is(eval{to_unicode("\x{0837}。\x{0680}\x{031E}\x{0601}ss⁸",	%p)}, undef,	"to_unicode\(\'\\u0837。\\u0680\\u031E\\u0601ss⁸\'\)\ is\ error\ P1\ V6\ B2\ B4\ \[data\/IdnaTest\.txt\:677\]");
is(eval{to_unicode("\x{0837}。\x{0680}\x{031E}\x{0601}Ss⁸",	%p)}, undef,	"to_unicode\(\'\\u0837。\\u0680\\u031E\\u0601Ss⁸\'\)\ is\ error\ P1\ V6\ B2\ B4\ \[data\/IdnaTest\.txt\:678\]");
is(eval{to_unicode("-｡\x{06A9}7",	%p)}, undef,	"to_unicode\(\'\-｡\\u06A97\'\)\ is\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:679\]");
is(eval{to_unicode("\x{200D}\x{C27F8}\x{07D7}𝟼\x{E01E8}",	%p)}, undef,	"to_unicode\(\'\\u200D\\uDAC9\\uDFF8\\u07D7𝟼\\uDB40\\uDDE8\'\)\ is\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:680\]");
is(eval{to_unicode("\x{1CED}\x{10E61}\x{0DCA}\x{10815}\x{0CC6}．𝟙\x{0DCA}。\x{A67D}\x{0AC3}\x{1EB53}",	%p)}, undef,	"to_unicode\(\'\\u1CED\\uD803\\uDE61\\u0DCA\\uD802\\uDC15\\u0CC6．𝟙\\u0DCA。\\uA67D\\u0AC3\\uD83A\\uDF53\'\)\ is\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:682\]");
is(eval{to_unicode("\x{077B}\x{0D43}-\x{200D}．\x{10825}\x{E0FAC}\x{06BC}\x{200C}\x{10E68}.𝟶\x{071B}𝟲",	%p)}, undef,	"to_unicode\(\'\\u077B\\u0D43\-\\u200D．\\uD802\\uDC25\\uDB43\\uDFAC\\u06BC\\u200C\\uD803\\uDE68\.𝟶\\u071B𝟲\'\)\ is\ error\ P1\ V6\ B3\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:683\]");
is(eval{to_unicode("\x{200D}\x{10E6B}囓\x{06A8}｡\x{0F39}\x{0723}\x{A8EF}\x{0C4D}\x{200D}ς\x{0BCD}．\x{E00A1}\x{200D}\x{108B2}䷠\x{0718}",	%p)}, undef,	"to_unicode\(\'\\u200D\\uD803\\uDE6B囓\\u06A8｡\\u0F39\\u0723\\uA8EF\\u0C4D\\u200Dς\\u0BCD．\\uDB40\\uDCA1\\u200D\\uD802\\uDCB2䷠\\u0718\'\)\ is\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:685\]");
is(eval{to_unicode("\x{200D}\x{10E6B}囓\x{06A8}｡\x{0F39}\x{0723}\x{0C4D}\x{A8EF}\x{200D}ς\x{0BCD}．\x{E00A1}\x{200D}\x{108B2}䷠\x{0718}",	%p)}, undef,	"to_unicode\(\'\\u200D\\uD803\\uDE6B囓\\u06A8｡\\u0F39\\u0723\\u0C4D\\uA8EF\\u200Dς\\u0BCD．\\uDB40\\uDCA1\\u200D\\uD802\\uDCB2䷠\\u0718\'\)\ is\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:687\]");
is(eval{to_unicode("\x{200D}\x{10E6B}囓\x{06A8}｡\x{0F39}\x{0723}\x{0C4D}\x{A8EF}\x{200D}Σ\x{0BCD}．\x{E00A1}\x{200D}\x{108B2}䷠\x{0718}",	%p)}, undef,	"to_unicode\(\'\\u200D\\uD803\\uDE6B囓\\u06A8｡\\u0F39\\u0723\\u0C4D\\uA8EF\\u200DΣ\\u0BCD．\\uDB40\\uDCA1\\u200D\\uD802\\uDCB2䷠\\u0718\'\)\ is\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:689\]");
is(eval{to_unicode("\x{200D}\x{10E6B}囓\x{06A8}｡\x{0F39}\x{0723}\x{0C4D}\x{A8EF}\x{200D}σ\x{0BCD}．\x{E00A1}\x{200D}\x{108B2}䷠\x{0718}",	%p)}, undef,	"to_unicode\(\'\\u200D\\uD803\\uDE6B囓\\u06A8｡\\u0F39\\u0723\\u0C4D\\uA8EF\\u200Dσ\\u0BCD．\\uDB40\\uDCA1\\u200D\\uD802\\uDCB2䷠\\u0718\'\)\ is\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:691\]");
is(eval{to_unicode("\x{200D}\x{10E6B}囓\x{06A8}｡\x{0F39}\x{0723}\x{A8EF}\x{0C4D}\x{200D}Σ\x{0BCD}．\x{E00A1}\x{200D}\x{108B2}䷠\x{0718}",	%p)}, undef,	"to_unicode\(\'\\u200D\\uD803\\uDE6B囓\\u06A8｡\\u0F39\\u0723\\uA8EF\\u0C4D\\u200DΣ\\u0BCD．\\uDB40\\uDCA1\\u200D\\uD802\\uDCB2䷠\\u0718\'\)\ is\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:693\]");
is(eval{to_unicode("\x{200D}\x{10E6B}囓\x{06A8}｡\x{0F39}\x{0723}\x{A8EF}\x{0C4D}\x{200D}σ\x{0BCD}．\x{E00A1}\x{200D}\x{108B2}䷠\x{0718}",	%p)}, undef,	"to_unicode\(\'\\u200D\\uD803\\uDE6B囓\\u06A8｡\\u0F39\\u0723\\uA8EF\\u0C4D\\u200Dσ\\u0BCD．\\uDB40\\uDCA1\\u200D\\uD802\\uDCB2䷠\\u0718\'\)\ is\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:695\]");
is(eval{to_unicode("𝟚ß\x{200D}\x{0332}",	%p)}, undef,	"to_unicode\(\'𝟚ß\\u200D\\u0332\'\)\ is\ error\ C2\ \[data\/IdnaTest\.txt\:697\]");
is(eval{to_unicode("𝟚SS\x{200D}\x{0332}",	%p)}, undef,	"to_unicode\(\'𝟚SS\\u200D\\u0332\'\)\ is\ error\ C2\ \[data\/IdnaTest\.txt\:699\]");
is(eval{to_unicode("𝟚ss\x{200D}\x{0332}",	%p)}, undef,	"to_unicode\(\'𝟚ss\\u200D\\u0332\'\)\ is\ error\ C2\ \[data\/IdnaTest\.txt\:701\]");
is(eval{to_unicode("𝟚Ss\x{200D}\x{0332}",	%p)}, undef,	"to_unicode\(\'𝟚Ss\\u200D\\u0332\'\)\ is\ error\ C2\ \[data\/IdnaTest\.txt\:703\]");
is(eval{to_unicode("xn--2ss-7ic",	%p)}, "2ss\x{0332}",	"to_unicode\(\'xn\-\-2ss\-7ic\'\)\ \[data\/IdnaTest\.txt\:705\]");
is(eval{to_unicode("XN--2SS-7IC",	%p)}, "2ss\x{0332}",	"to_unicode\(\'XN\-\-2SS\-7IC\'\)\ \[data\/IdnaTest\.txt\:706\]");
is(eval{to_unicode("Xn--2Ss-7Ic",	%p)}, "2ss\x{0332}",	"to_unicode\(\'Xn\-\-2Ss\-7Ic\'\)\ \[data\/IdnaTest\.txt\:707\]");
is(eval{to_unicode("2ss\x{0332}",	%p)}, "2ss\x{0332}",	"to_unicode\(\'2ss\\u0332\'\)\ \[data\/IdnaTest\.txt\:708\]");
is(eval{to_unicode("2SS\x{0332}",	%p)}, "2ss\x{0332}",	"to_unicode\(\'2SS\\u0332\'\)\ \[data\/IdnaTest\.txt\:709\]");
is(eval{to_unicode("2Ss\x{0332}",	%p)}, "2ss\x{0332}",	"to_unicode\(\'2Ss\\u0332\'\)\ \[data\/IdnaTest\.txt\:710\]");
is(eval{to_unicode("-\x{200D}．\x{200D}",	%p)}, undef,	"to_unicode\(\'\-\\u200D．\\u200D\'\)\ is\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:711\]");
is(eval{to_unicode("\x{2DEC}\x{1EBCD}\x{10E66}．\x{200C}ß⒕-",	%p)}, undef,	"to_unicode\(\'\\u2DEC\\uD83A\\uDFCD\\uD803\\uDE66．\\u200Cß⒕\-\'\)\ is\ error\ P1\ V5\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:713\]");
is(eval{to_unicode("\x{2DEC}\x{1EBCD}\x{10E66}．\x{200C}SS⒕-",	%p)}, undef,	"to_unicode\(\'\\u2DEC\\uD83A\\uDFCD\\uD803\\uDE66．\\u200CSS⒕\-\'\)\ is\ error\ P1\ V5\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:715\]");
is(eval{to_unicode("\x{2DEC}\x{1EBCD}\x{10E66}．\x{200C}ss⒕-",	%p)}, undef,	"to_unicode\(\'\\u2DEC\\uD83A\\uDFCD\\uD803\\uDE66．\\u200Css⒕\-\'\)\ is\ error\ P1\ V5\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:717\]");
is(eval{to_unicode("\x{2DEC}\x{1EBCD}\x{10E66}．\x{200C}Ss⒕-",	%p)}, undef,	"to_unicode\(\'\\u2DEC\\uD83A\\uDFCD\\uD803\\uDE66．\\u200CSs⒕\-\'\)\ is\ error\ P1\ V5\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:719\]");
is(eval{to_unicode("⒌\x{033A}--．8\x{09CD}\x{200D}𝟴\x{1BA5}.\x{10E7B}\x{077A}\x{0626}\x{0644}𝟪\x{0729}",	%p)}, undef,	"to_unicode\(\'⒌\\u033A\-\-．8\\u09CD\\u200D𝟴\\u1BA5\.\\uD803\\uDE7B\\u077A\\u0626\\u0644𝟪\\u0729\'\)\ is\ error\ P1\ V2\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:721\]");
is(eval{to_unicode("\x{BFD9A}𝟝\x{1EEBA}。𝟑\x{10D2D}\x{200C}\x{077F}．₧\x{4B431}\x{200C}\x{0663}￨\x{06A6}\x{1EC45}",	%p)}, undef,	"to_unicode\(\'\\uDABF\\uDD9A𝟝\\uD83B\\uDEBA。𝟑\\uD803\\uDD2D\\u200C\\u077F．₧\\uD8ED\\uDC31\\u200C\\u0663￨\\u06A6\\uD83B\\uDC45\'\)\ is\ error\ P1\ V6\ B5\ B6\ B1\ C1\ \[data\/IdnaTest\.txt\:723\]");
is(eval{to_unicode("\x{0726}\x{0757}\x{E0887}\x{E0F9A}\x{AECF4}\x{0639}",	%p)}, undef,	"to_unicode\(\'\\u0726\\u0757\\uDB42\\uDC87\\uDB43\\uDF9A\\uDA7B\\uDCF4\\u0639\'\)\ is\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:725\]");
is(eval{to_unicode("\x{E010D}\x{200C}。-",	%p)}, undef,	"to_unicode\(\'\\uDB40\\uDD0D\\u200C。\-\'\)\ is\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:726\]");
is(eval{to_unicode("\x{200D}\x{06C7}.\x{10E72}\x{2CEF}",	%p)}, undef,	"to_unicode\(\'\\u200D\\u06C7\.\\uD803\\uDE72\\u2CEF\'\)\ is\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:728\]");
is(eval{to_unicode("\x{8D5EC}\x{1A6A}\x{077F}\x{200C}ß\x{07D6}𝟔",	%p)}, undef,	"to_unicode\(\'\\uD9F5\\uDDEC\\u1A6A\\u077F\\u200Cß\\u07D6𝟔\'\)\ is\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:730\]");
is(eval{to_unicode("\x{8D5EC}\x{1A6A}\x{077F}\x{200C}SS\x{07D6}𝟔",	%p)}, undef,	"to_unicode\(\'\\uD9F5\\uDDEC\\u1A6A\\u077F\\u200CSS\\u07D6𝟔\'\)\ is\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:732\]");
is(eval{to_unicode("\x{8D5EC}\x{1A6A}\x{077F}\x{200C}ss\x{07D6}𝟔",	%p)}, undef,	"to_unicode\(\'\\uD9F5\\uDDEC\\u1A6A\\u077F\\u200Css\\u07D6𝟔\'\)\ is\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:734\]");
is(eval{to_unicode("\x{8D5EC}\x{1A6A}\x{077F}\x{200C}Ss\x{07D6}𝟔",	%p)}, undef,	"to_unicode\(\'\\uD9F5\\uDDEC\\u1A6A\\u077F\\u200CSs\\u07D6𝟔\'\)\ is\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:736\]");
is(eval{to_unicode("ß\x{10A0D}-\x{200D}\x{1EC71}\x{05AA}\x{200C}｡\x{10A3F}\x{E0117}\x{0768}",	%p)}, undef,	"to_unicode\(\'ß\\uD802\\uDE0D\-\\u200D\\uD83B\\uDC71\\u05AA\\u200C｡\\uD802\\uDE3F\\uDB40\\uDD17\\u0768\'\)\ is\ error\ P1\ V6\ V5\ B5\ B6\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:738\]");
is(eval{to_unicode("SS\x{10A0D}-\x{200D}\x{1EC71}\x{05AA}\x{200C}｡\x{10A3F}\x{E0117}\x{0768}",	%p)}, undef,	"to_unicode\(\'SS\\uD802\\uDE0D\-\\u200D\\uD83B\\uDC71\\u05AA\\u200C｡\\uD802\\uDE3F\\uDB40\\uDD17\\u0768\'\)\ is\ error\ P1\ V6\ V5\ B5\ B6\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:740\]");
is(eval{to_unicode("ss\x{10A0D}-\x{200D}\x{1EC71}\x{05AA}\x{200C}｡\x{10A3F}\x{E0117}\x{0768}",	%p)}, undef,	"to_unicode\(\'ss\\uD802\\uDE0D\-\\u200D\\uD83B\\uDC71\\u05AA\\u200C｡\\uD802\\uDE3F\\uDB40\\uDD17\\u0768\'\)\ is\ error\ P1\ V6\ V5\ B5\ B6\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:742\]");
is(eval{to_unicode("Ss\x{10A0D}-\x{200D}\x{1EC71}\x{05AA}\x{200C}｡\x{10A3F}\x{E0117}\x{0768}",	%p)}, undef,	"to_unicode\(\'Ss\\uD802\\uDE0D\-\\u200D\\uD83B\\uDC71\\u05AA\\u200C｡\\uD802\\uDE3F\\uDB40\\uDD17\\u0768\'\)\ is\ error\ P1\ V6\ V5\ B5\ B6\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:744\]");
is(eval{to_unicode("\x{E013F}\x{067D}\x{0615}\x{A80B}\x{200C}\x{0886}。\x{37B43}𝟿\x{10E61}\x{36146}-｡\x{062D}\x{200C}\x{A8ED}\x{E04D4}\x{200C}\x{1732}",	%p)}, undef,	"to_unicode\(\'\\uDB40\\uDD3F\\u067D\\u0615\\uA80B\\u200C\\u0886。\\uD89E\\uDF43𝟿\\uD803\\uDE61\\uD898\\uDD46\-｡\\u062D\\u200C\\uA8ED\\uDB41\\uDCD4\\u200C\\u1732\'\)\ is\ error\ P1\ V6\ V3\ B5\ B6\ B3\ C1\ \[data\/IdnaTest\.txt\:746\]");
is(eval{to_unicode("\x{068E}ß\x{06DC}.\x{200D}\x{E07D9}\x{068E}\x{07E7}\x{FB43}.\x{06AB}\x{FE05}-\x{200D}\x{200D}",	%p)}, undef,	"to_unicode\(\'\\u068Eß\\u06DC\.\\u200D\\uDB41\\uDFD9\\u068E\\u07E7\\uFB43\.\\u06AB\\uFE05\-\\u200D\\u200D\'\)\ is\ error\ P1\ V6\ B2\ B3\ B1\ C2\ \[data\/IdnaTest\.txt\:748\]");
is(eval{to_unicode("\x{068E}ß\x{06DC}.\x{200D}\x{E07D9}\x{068E}\x{07E7}\x{05E3}\x{05BC}.\x{06AB}\x{FE05}-\x{200D}\x{200D}",	%p)}, undef,	"to_unicode\(\'\\u068Eß\\u06DC\.\\u200D\\uDB41\\uDFD9\\u068E\\u07E7\\u05E3\\u05BC\.\\u06AB\\uFE05\-\\u200D\\u200D\'\)\ is\ error\ P1\ V6\ B2\ B3\ B1\ C2\ \[data\/IdnaTest\.txt\:750\]");
is(eval{to_unicode("\x{068E}SS\x{06DC}.\x{200D}\x{E07D9}\x{068E}\x{07E7}\x{05E3}\x{05BC}.\x{06AB}\x{FE05}-\x{200D}\x{200D}",	%p)}, undef,	"to_unicode\(\'\\u068ESS\\u06DC\.\\u200D\\uDB41\\uDFD9\\u068E\\u07E7\\u05E3\\u05BC\.\\u06AB\\uFE05\-\\u200D\\u200D\'\)\ is\ error\ P1\ V6\ B2\ B3\ B1\ C2\ \[data\/IdnaTest\.txt\:752\]");
is(eval{to_unicode("\x{068E}ss\x{06DC}.\x{200D}\x{E07D9}\x{068E}\x{07E7}\x{05E3}\x{05BC}.\x{06AB}\x{FE05}-\x{200D}\x{200D}",	%p)}, undef,	"to_unicode\(\'\\u068Ess\\u06DC\.\\u200D\\uDB41\\uDFD9\\u068E\\u07E7\\u05E3\\u05BC\.\\u06AB\\uFE05\-\\u200D\\u200D\'\)\ is\ error\ P1\ V6\ B2\ B3\ B1\ C2\ \[data\/IdnaTest\.txt\:754\]");
is(eval{to_unicode("\x{068E}Ss\x{06DC}.\x{200D}\x{E07D9}\x{068E}\x{07E7}\x{05E3}\x{05BC}.\x{06AB}\x{FE05}-\x{200D}\x{200D}",	%p)}, undef,	"to_unicode\(\'\\u068ESs\\u06DC\.\\u200D\\uDB41\\uDFD9\\u068E\\u07E7\\u05E3\\u05BC\.\\u06AB\\uFE05\-\\u200D\\u200D\'\)\ is\ error\ P1\ V6\ B2\ B3\ B1\ C2\ \[data\/IdnaTest\.txt\:756\]");
is(eval{to_unicode("\x{068E}SS\x{06DC}.\x{200D}\x{E07D9}\x{068E}\x{07E7}\x{FB43}.\x{06AB}\x{FE05}-\x{200D}\x{200D}",	%p)}, undef,	"to_unicode\(\'\\u068ESS\\u06DC\.\\u200D\\uDB41\\uDFD9\\u068E\\u07E7\\uFB43\.\\u06AB\\uFE05\-\\u200D\\u200D\'\)\ is\ error\ P1\ V6\ B2\ B3\ B1\ C2\ \[data\/IdnaTest\.txt\:758\]");
is(eval{to_unicode("\x{068E}ss\x{06DC}.\x{200D}\x{E07D9}\x{068E}\x{07E7}\x{FB43}.\x{06AB}\x{FE05}-\x{200D}\x{200D}",	%p)}, undef,	"to_unicode\(\'\\u068Ess\\u06DC\.\\u200D\\uDB41\\uDFD9\\u068E\\u07E7\\uFB43\.\\u06AB\\uFE05\-\\u200D\\u200D\'\)\ is\ error\ P1\ V6\ B2\ B3\ B1\ C2\ \[data\/IdnaTest\.txt\:760\]");
is(eval{to_unicode("\x{068E}Ss\x{06DC}.\x{200D}\x{E07D9}\x{068E}\x{07E7}\x{FB43}.\x{06AB}\x{FE05}-\x{200D}\x{200D}",	%p)}, undef,	"to_unicode\(\'\\u068ESs\\u06DC\.\\u200D\\uDB41\\uDFD9\\u068E\\u07E7\\uFB43\.\\u06AB\\uFE05\-\\u200D\\u200D\'\)\ is\ error\ P1\ V6\ B2\ B3\ B1\ C2\ \[data\/IdnaTest\.txt\:762\]");
is(eval{to_unicode("\x{12788}\x{10A0E}\x{1EE51}\x{1097A}\x{200D}",	%p)}, undef,	"to_unicode\(\'\\uD809\\uDF88\\uD802\\uDE0E\\uD83B\\uDE51\\uD802\\uDD7A\\u200D\'\)\ is\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:764\]");
is(eval{to_unicode("\x{D97CD}１\x{0FA9}\x{200D}\x{10E7E}₁｡\x{200C}\x{200D}",	%p)}, undef,	"to_unicode\(\'\\uDB25\\uDFCD１\\u0FA9\\u200D\\uD803\\uDE7E₁｡\\u200C\\u200D\'\)\ is\ error\ P1\ V6\ B5\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:766\]");
is(eval{to_unicode("\x{07E9}\x{108C4}\x{06D1}\x{E0616}\x{068E}",	%p)}, undef,	"to_unicode\(\'\\u07E9\\uD802\\uDCC4\\u06D1\\uDB41\\uDE16\\u068E\'\)\ is\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:768\]");
is(eval{to_unicode("\x{109F2}.---\x{06A5}\x{07D2}",	%p)}, undef,	"to_unicode\(\'\\uD802\\uDDF2\.\-\-\-\\u06A5\\u07D2\'\)\ is\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:769\]");
is(eval{to_unicode("\x{0682}\x{0B4D}-\x{10E73}\x{10E64}⛛．\x{10E62}\x{AA2D}\x{0723}\x{200C}\x{0758}\x{18F9A}",	%p)}, undef,	"to_unicode\(\'\\u0682\\u0B4D\-\\uD803\\uDE73\\uD803\\uDE64⛛．\\uD803\\uDE62\\uAA2D\\u0723\\u200C\\u0758\\uD823\\uDF9A\'\)\ is\ error\ P1\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:770\]");
is(eval{to_unicode("-❵\x{200C}\x{0649}",	%p)}, undef,	"to_unicode\(\'\-❵\\u200C\\u0649\'\)\ is\ error\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:772\]");
is(eval{to_unicode("🄈\x{200C}\x{0665}-｡\x{1DD9}⬚\x{06A9}",	%p)}, undef,	"to_unicode\(\'🄈\\u200C\\u0665\-｡\\u1DD9⬚\\u06A9\'\)\ is\ error\ P1\ V3\ V6\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:774\]");
is(eval{to_unicode("ß\x{0CBF}\x{200D}\x{0603}\x{0727}",	%p)}, undef,	"to_unicode\(\'ß\\u0CBF\\u200D\\u0603\\u0727\'\)\ is\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:776\]");
is(eval{to_unicode("SS\x{0CBF}\x{200D}\x{0603}\x{0727}",	%p)}, undef,	"to_unicode\(\'SS\\u0CBF\\u200D\\u0603\\u0727\'\)\ is\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:778\]");
is(eval{to_unicode("ss\x{0CBF}\x{200D}\x{0603}\x{0727}",	%p)}, undef,	"to_unicode\(\'ss\\u0CBF\\u200D\\u0603\\u0727\'\)\ is\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:780\]");
is(eval{to_unicode("Ss\x{0CBF}\x{200D}\x{0603}\x{0727}",	%p)}, undef,	"to_unicode\(\'Ss\\u0CBF\\u200D\\u0603\\u0727\'\)\ is\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:782\]");
is(eval{to_unicode("-\x{AAB7}\x{E0DE2}\x{10DEC}\x{A806}",	%p)}, undef,	"to_unicode\(\'\-\\uAAB7\\uDB43\\uDDE2\\uD803\\uDDEC\\uA806\'\)\ is\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:784\]");
is(eval{to_unicode("\x{0C4D}ς\x{0DCA}\x{06B0}",	%p)}, undef,	"to_unicode\(\'\\u0C4Dς\\u0DCA\\u06B0\'\)\ is\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:785\]");
is(eval{to_unicode("\x{0C4D}Σ\x{0DCA}\x{06B0}",	%p)}, undef,	"to_unicode\(\'\\u0C4DΣ\\u0DCA\\u06B0\'\)\ is\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:787\]");
is(eval{to_unicode("\x{0C4D}σ\x{0DCA}\x{06B0}",	%p)}, undef,	"to_unicode\(\'\\u0C4Dσ\\u0DCA\\u06B0\'\)\ is\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:788\]");
is(eval{to_unicode("3\x{1EA3B}\x{0623}\x{0DD6}\x{10E7B}-。\x{10E78}\x{10E7C}\x{094D}۶-\x{10990}",	%p)}, undef,	"to_unicode\(\'3\\uD83A\\uDE3B\\u0623\\u0DD6\\uD803\\uDE7B\-。\\uD803\\uDE78\\uD803\\uDE7C\\u094D۶\-\\uD802\\uDD90\'\)\ is\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:789\]");
is(eval{to_unicode("\x{0770}\x{10E78}\x{200C}\x{200C}\x{200C}",	%p)}, undef,	"to_unicode\(\'\\u0770\\uD803\\uDE78\\u200C\\u200C\\u200C\'\)\ is\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:790\]");
is(eval{to_unicode("xn--0pb6875k",	%p)}, "\x{0770}\x{10E78}",	"to_unicode\(\'xn\-\-0pb6875k\'\)\ \[data\/IdnaTest\.txt\:792\]");
is(eval{to_unicode("XN--0PB6875K",	%p)}, "\x{0770}\x{10E78}",	"to_unicode\(\'XN\-\-0PB6875K\'\)\ \[data\/IdnaTest\.txt\:793\]");
is(eval{to_unicode("Xn--0Pb6875k",	%p)}, "\x{0770}\x{10E78}",	"to_unicode\(\'Xn\-\-0Pb6875k\'\)\ \[data\/IdnaTest\.txt\:794\]");
is(eval{to_unicode("\x{0770}\x{10E78}",	%p)}, "\x{0770}\x{10E78}",	"to_unicode\(\'\\u0770\\uD803\\uDE78\'\)\ \[data\/IdnaTest\.txt\:795\]");
is(eval{to_unicode("\x{0717}\x{10A0C}.\x{10E7D}\x{067C}\x{0311}\x{A9B8}．\x{E0ADD}\x{06C5}\x{10ED7}",	%p)}, undef,	"to_unicode\(\'\\u0717\\uD802\\uDE0C\.\\uD803\\uDE7D\\u067C\\u0311\\uA9B8．\\uDB42\\uDEDD\\u06C5\\uD803\\uDED7\'\)\ is\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:796\]");
is(eval{to_unicode("\x{10E78}。\x{10EA9}\x{094D}",	%p)}, undef,	"to_unicode\(\'\\uD803\\uDE78。\\uD803\\uDEA9\\u094D\'\)\ is\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:797\]");
is(eval{to_unicode("\x{10D6F5}\x{A806}\x{53887}ς\x{200D}\x{E01A7}",	%p)}, undef,	"to_unicode\(\'\\uDBF5\\uDEF5\\uA806\\uD90E\\uDC87ς\\u200D\\uDB40\\uDDA7\'\)\ is\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:798\]");
is(eval{to_unicode("\x{10D6F5}\x{A806}\x{53887}Σ\x{200D}\x{E01A7}",	%p)}, undef,	"to_unicode\(\'\\uDBF5\\uDEF5\\uA806\\uD90E\\uDC87Σ\\u200D\\uDB40\\uDDA7\'\)\ is\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:800\]");
is(eval{to_unicode("\x{10D6F5}\x{A806}\x{53887}σ\x{200D}\x{E01A7}",	%p)}, undef,	"to_unicode\(\'\\uDBF5\\uDEF5\\uA806\\uD90E\\uDC87σ\\u200D\\uDB40\\uDDA7\'\)\ is\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:802\]");
is(eval{to_unicode("ß\x{0687}\x{07DE}\x{06A2}.\x{109F1}\x{06AC}-\x{200C}ß\x{CEBAE}𝟺",	%p)}, undef,	"to_unicode\(\'ß\\u0687\\u07DE\\u06A2\.\\uD802\\uDDF1\\u06AC\-\\u200Cß\\uDAFA\\uDFAE𝟺\'\)\ is\ error\ P1\ V6\ B5\ B6\ B2\ C1\ \[data\/IdnaTest\.txt\:804\]");
is(eval{to_unicode("SS\x{0687}\x{07DE}\x{06A2}.\x{109F1}\x{06AC}-\x{200C}SS\x{CEBAE}𝟺",	%p)}, undef,	"to_unicode\(\'SS\\u0687\\u07DE\\u06A2\.\\uD802\\uDDF1\\u06AC\-\\u200CSS\\uDAFA\\uDFAE𝟺\'\)\ is\ error\ P1\ V6\ B5\ B6\ B2\ C1\ \[data\/IdnaTest\.txt\:806\]");
is(eval{to_unicode("ss\x{0687}\x{07DE}\x{06A2}.\x{109F1}\x{06AC}-\x{200C}ss\x{CEBAE}𝟺",	%p)}, undef,	"to_unicode\(\'ss\\u0687\\u07DE\\u06A2\.\\uD802\\uDDF1\\u06AC\-\\u200Css\\uDAFA\\uDFAE𝟺\'\)\ is\ error\ P1\ V6\ B5\ B6\ B2\ C1\ \[data\/IdnaTest\.txt\:808\]");
is(eval{to_unicode("Ss\x{0687}\x{07DE}\x{06A2}.\x{109F1}\x{06AC}-\x{200C}Ss\x{CEBAE}𝟺",	%p)}, undef,	"to_unicode\(\'Ss\\u0687\\u07DE\\u06A2\.\\uD802\\uDDF1\\u06AC\-\\u200CSs\\uDAFA\\uDFAE𝟺\'\)\ is\ error\ P1\ V6\ B5\ B6\ B2\ C1\ \[data\/IdnaTest\.txt\:810\]");
is(eval{to_unicode("\x{10E7A}\x{0F84}\x{3B8CA}\x{200D}∤\x{200C}-",	%p)}, undef,	"to_unicode\(\'\\uD803\\uDE7A\\u0F84\\uD8AE\\uDCCA\\u200D∤\\u200C\-\'\)\ is\ error\ P1\ V3\ V6\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:812\]");
is(eval{to_unicode("ß\x{E005B}\x{1EAC7}\x{063A}",	%p)}, undef,	"to_unicode\(\'ß\\uDB40\\uDC5B\\uD83A\\uDEC7\\u063A\'\)\ is\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:814\]");
is(eval{to_unicode("SS\x{E005B}\x{1EAC7}\x{063A}",	%p)}, undef,	"to_unicode\(\'SS\\uDB40\\uDC5B\\uD83A\\uDEC7\\u063A\'\)\ is\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:816\]");
is(eval{to_unicode("ss\x{E005B}\x{1EAC7}\x{063A}",	%p)}, undef,	"to_unicode\(\'ss\\uDB40\\uDC5B\\uD83A\\uDEC7\\u063A\'\)\ is\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:817\]");
is(eval{to_unicode("Ss\x{E005B}\x{1EAC7}\x{063A}",	%p)}, undef,	"to_unicode\(\'Ss\\uDB40\\uDC5B\\uD83A\\uDEC7\\u063A\'\)\ is\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:818\]");
is(eval{to_unicode("\x{E0064}\x{1039}\x{0B4D}-",	%p)}, undef,	"to_unicode\(\'\\uDB40\\uDC64\\u1039\\u0B4D\-\'\)\ is\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:819\]");
is(eval{to_unicode("\x{0954}\x{10E68}☞",	%p)}, undef,	"to_unicode\(\'\\u0954\\uD803\\uDE68☞\'\)\ is\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:820\]");
is(eval{to_unicode("\x{17B5}ς",	%p)}, undef,	"to_unicode\(\'\\u17B5ς\'\)\ is\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:821\]");
is(eval{to_unicode("\x{17B5}Σ",	%p)}, undef,	"to_unicode\(\'\\u17B5Σ\'\)\ is\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:823\]");
is(eval{to_unicode("\x{17B5}σ",	%p)}, undef,	"to_unicode\(\'\\u17B5σ\'\)\ is\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:824\]");
is(eval{to_unicode("\x{10CC8}\x{07BE}.ς\x{200D}\x{032F}.\x{0E48}\x{7D7CB}ς-",	%p)}, undef,	"to_unicode\(\'\\uD803\\uDCC8\\u07BE\.ς\\u200D\\u032F\.\\u0E48\\uD9B5\\uDFCBς\-\'\)\ is\ error\ P1\ V6\ V3\ V5\ B6\ B1\ C2\ \[data\/IdnaTest\.txt\:825\]");
is(eval{to_unicode("\x{10CC8}\x{07BE}.Σ\x{200D}\x{032F}.\x{0E48}\x{7D7CB}Σ-",	%p)}, undef,	"to_unicode\(\'\\uD803\\uDCC8\\u07BE\.Σ\\u200D\\u032F\.\\u0E48\\uD9B5\\uDFCBΣ\-\'\)\ is\ error\ P1\ V6\ V3\ V5\ B6\ B1\ C2\ \[data\/IdnaTest\.txt\:827\]");
is(eval{to_unicode("\x{10CC8}\x{07BE}.σ\x{200D}\x{032F}.\x{0E48}\x{7D7CB}σ-",	%p)}, undef,	"to_unicode\(\'\\uD803\\uDCC8\\u07BE\.σ\\u200D\\u032F\.\\u0E48\\uD9B5\\uDFCBσ\-\'\)\ is\ error\ P1\ V6\ V3\ V5\ B6\ B1\ C2\ \[data\/IdnaTest\.txt\:829\]");
is(eval{to_unicode("\x{1E946}\x{0315}ß\x{200C}⓽-\x{1EF9E}",	%p)}, undef,	"to_unicode\(\'\\uD83A\\uDD46\\u0315ß\\u200C⓽\-\\uD83B\\uDF9E\'\)\ is\ error\ P1\ V6\ B2\ C1\ \[data\/IdnaTest\.txt\:831\]");
is(eval{to_unicode("\x{1E946}\x{0315}SS\x{200C}⓽-\x{1EF9E}",	%p)}, undef,	"to_unicode\(\'\\uD83A\\uDD46\\u0315SS\\u200C⓽\-\\uD83B\\uDF9E\'\)\ is\ error\ P1\ V6\ B2\ C1\ \[data\/IdnaTest\.txt\:833\]");
is(eval{to_unicode("\x{1E946}\x{0315}ss\x{200C}⓽-\x{1EF9E}",	%p)}, undef,	"to_unicode\(\'\\uD83A\\uDD46\\u0315ss\\u200C⓽\-\\uD83B\\uDF9E\'\)\ is\ error\ P1\ V6\ B2\ C1\ \[data\/IdnaTest\.txt\:835\]");
is(eval{to_unicode("\x{1E946}\x{0315}Ss\x{200C}⓽-\x{1EF9E}",	%p)}, undef,	"to_unicode\(\'\\uD83A\\uDD46\\u0315Ss\\u200C⓽\-\\uD83B\\uDF9E\'\)\ is\ error\ P1\ V6\ B2\ C1\ \[data\/IdnaTest\.txt\:837\]");
is(eval{to_unicode("\x{0666}",	%p)}, undef,	"to_unicode\(\'\\u0666\'\)\ is\ error\ B1\ \[data\/IdnaTest\.txt\:839\]");
is(eval{to_unicode("\x{06A3}ς\x{07E4}。۹\x{10E73}\x{110B9}１\x{200D}",	%p)}, undef,	"to_unicode\(\'\\u06A3ς\\u07E4。۹\\uD803\\uDE73\\uD804\\uDCB9１\\u200D\'\)\ is\ error\ B2\ B1\ C2\ \[data\/IdnaTest\.txt\:840\]");
is(eval{to_unicode("\x{06A3}Σ\x{07E4}。۹\x{10E73}\x{110B9}１\x{200D}",	%p)}, undef,	"to_unicode\(\'\\u06A3Σ\\u07E4。۹\\uD803\\uDE73\\uD804\\uDCB9１\\u200D\'\)\ is\ error\ B2\ B1\ C2\ \[data\/IdnaTest\.txt\:842\]");
is(eval{to_unicode("\x{06A3}σ\x{07E4}。۹\x{10E73}\x{110B9}１\x{200D}",	%p)}, undef,	"to_unicode\(\'\\u06A3σ\\u07E4。۹\\uD803\\uDE73\\uD804\\uDCB9１\\u200D\'\)\ is\ error\ B2\ B1\ C2\ \[data\/IdnaTest\.txt\:844\]");
is(eval{to_unicode("\x{0342}.\x{0663}",	%p)}, undef,	"to_unicode\(\'\\u0342\.\\u0663\'\)\ is\ error\ V5\ B1\ B3\ B6\ \[data\/IdnaTest\.txt\:846\]");
is(eval{to_unicode("\x{0D4D}\x{200C}\x{200D}\x{3A373}.\x{E0144}\x{0764}\x{10E66}\x{3B44A}\x{1EBAE}𥐿.-🄇\x{10E62}\x{200D}",	%p)}, undef,	"to_unicode\(\'\\u0D4D\\u200C\\u200D\\uD8A8\\uDF73\.\\uDB40\\uDD44\\u0764\\uD803\\uDE66\\uD8AD\\uDC4A\\uD83A\\uDFAE𥐿\.\-🄇\\uD803\\uDE62\\u200D\'\)\ is\ error\ P1\ V5\ V6\ V3\ B1\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:847\]");
is(eval{to_unicode("\x{200C}\x{10E7A}｡\x{0660}²\x{1D174}\x{C425E}\x{10E79}。\x{200D}\x{0661}９",	%p)}, undef,	"to_unicode\(\'\\u200C\\uD803\\uDE7A｡\\u0660²\\uD834\\uDD74\\uDAD0\\uDE5E\\uD803\\uDE79。\\u200D\\u0661９\'\)\ is\ error\ P1\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:849\]");


exit(0);
